// Compiled by ClojureScript 1.9.946 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.14";
figwheel.client.js_stringify = (((typeof JSON !== 'undefined') && (!((JSON.stringify == null))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e34958){if((e34958 instanceof Error)){
var e = e34958;
return "Error: Unable to stringify";
} else {
throw e34958;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__34961 = arguments.length;
switch (G__34961) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__34959_SHARP_){
if(typeof p1__34959_SHARP_ === 'string'){
return p1__34959_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__34959_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__29526__auto__ = [];
var len__29519__auto___34964 = arguments.length;
var i__29520__auto___34965 = (0);
while(true){
if((i__29520__auto___34965 < len__29519__auto___34964)){
args__29526__auto__.push((arguments[i__29520__auto___34965]));

var G__34966 = (i__29520__auto___34965 + (1));
i__29520__auto___34965 = G__34966;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((0) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29527__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq34963){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34963));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__29526__auto__ = [];
var len__29519__auto___34968 = arguments.length;
var i__29520__auto___34969 = (0);
while(true){
if((i__29520__auto___34969 < len__29519__auto___34968)){
args__29526__auto__.push((arguments[i__29520__auto___34969]));

var G__34970 = (i__29520__auto___34969 + (1));
i__29520__auto___34969 = G__34970;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((0) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__29527__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq34967){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq34967));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__34971){
var map__34972 = p__34971;
var map__34972__$1 = ((((!((map__34972 == null)))?((((map__34972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34972.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34972):map__34972);
var message = cljs.core.get.call(null,map__34972__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__34972__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__28348__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__28348__auto__)){
return or__28348__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__28336__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__28336__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__28336__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__30950__auto___35051 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___35051,ch){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___35051,ch){
return (function (state_35023){
var state_val_35024 = (state_35023[(1)]);
if((state_val_35024 === (7))){
var inst_35019 = (state_35023[(2)]);
var state_35023__$1 = state_35023;
var statearr_35025_35052 = state_35023__$1;
(statearr_35025_35052[(2)] = inst_35019);

(statearr_35025_35052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (1))){
var state_35023__$1 = state_35023;
var statearr_35026_35053 = state_35023__$1;
(statearr_35026_35053[(2)] = null);

(statearr_35026_35053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (4))){
var inst_34976 = (state_35023[(7)]);
var inst_34976__$1 = (state_35023[(2)]);
var state_35023__$1 = (function (){var statearr_35027 = state_35023;
(statearr_35027[(7)] = inst_34976__$1);

return statearr_35027;
})();
if(cljs.core.truth_(inst_34976__$1)){
var statearr_35028_35054 = state_35023__$1;
(statearr_35028_35054[(1)] = (5));

} else {
var statearr_35029_35055 = state_35023__$1;
(statearr_35029_35055[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (15))){
var inst_34983 = (state_35023[(8)]);
var inst_34998 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_34983);
var inst_34999 = cljs.core.first.call(null,inst_34998);
var inst_35000 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_34999);
var inst_35001 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35000)].join('');
var inst_35002 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_35001);
var state_35023__$1 = state_35023;
var statearr_35030_35056 = state_35023__$1;
(statearr_35030_35056[(2)] = inst_35002);

(statearr_35030_35056[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (13))){
var inst_35007 = (state_35023[(2)]);
var state_35023__$1 = state_35023;
var statearr_35031_35057 = state_35023__$1;
(statearr_35031_35057[(2)] = inst_35007);

(statearr_35031_35057[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (6))){
var state_35023__$1 = state_35023;
var statearr_35032_35058 = state_35023__$1;
(statearr_35032_35058[(2)] = null);

(statearr_35032_35058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (17))){
var inst_35005 = (state_35023[(2)]);
var state_35023__$1 = state_35023;
var statearr_35033_35059 = state_35023__$1;
(statearr_35033_35059[(2)] = inst_35005);

(statearr_35033_35059[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (3))){
var inst_35021 = (state_35023[(2)]);
var state_35023__$1 = state_35023;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35023__$1,inst_35021);
} else {
if((state_val_35024 === (12))){
var inst_34982 = (state_35023[(9)]);
var inst_34996 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_34982,opts);
var state_35023__$1 = state_35023;
if(cljs.core.truth_(inst_34996)){
var statearr_35034_35060 = state_35023__$1;
(statearr_35034_35060[(1)] = (15));

} else {
var statearr_35035_35061 = state_35023__$1;
(statearr_35035_35061[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (2))){
var state_35023__$1 = state_35023;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35023__$1,(4),ch);
} else {
if((state_val_35024 === (11))){
var inst_34983 = (state_35023[(8)]);
var inst_34988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34989 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_34983);
var inst_34990 = cljs.core.async.timeout.call(null,(1000));
var inst_34991 = [inst_34989,inst_34990];
var inst_34992 = (new cljs.core.PersistentVector(null,2,(5),inst_34988,inst_34991,null));
var state_35023__$1 = state_35023;
return cljs.core.async.ioc_alts_BANG_.call(null,state_35023__$1,(14),inst_34992);
} else {
if((state_val_35024 === (9))){
var inst_34983 = (state_35023[(8)]);
var inst_35009 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_35010 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_34983);
var inst_35011 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_35010);
var inst_35012 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35011)].join('');
var inst_35013 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_35012);
var state_35023__$1 = (function (){var statearr_35036 = state_35023;
(statearr_35036[(10)] = inst_35009);

return statearr_35036;
})();
var statearr_35037_35062 = state_35023__$1;
(statearr_35037_35062[(2)] = inst_35013);

(statearr_35037_35062[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (5))){
var inst_34976 = (state_35023[(7)]);
var inst_34978 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_34979 = (new cljs.core.PersistentArrayMap(null,2,inst_34978,null));
var inst_34980 = (new cljs.core.PersistentHashSet(null,inst_34979,null));
var inst_34981 = figwheel.client.focus_msgs.call(null,inst_34980,inst_34976);
var inst_34982 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_34981);
var inst_34983 = cljs.core.first.call(null,inst_34981);
var inst_34984 = figwheel.client.autoload_QMARK_.call(null);
var state_35023__$1 = (function (){var statearr_35038 = state_35023;
(statearr_35038[(8)] = inst_34983);

(statearr_35038[(9)] = inst_34982);

return statearr_35038;
})();
if(cljs.core.truth_(inst_34984)){
var statearr_35039_35063 = state_35023__$1;
(statearr_35039_35063[(1)] = (8));

} else {
var statearr_35040_35064 = state_35023__$1;
(statearr_35040_35064[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (14))){
var inst_34994 = (state_35023[(2)]);
var state_35023__$1 = state_35023;
var statearr_35041_35065 = state_35023__$1;
(statearr_35041_35065[(2)] = inst_34994);

(statearr_35041_35065[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (16))){
var state_35023__$1 = state_35023;
var statearr_35042_35066 = state_35023__$1;
(statearr_35042_35066[(2)] = null);

(statearr_35042_35066[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (10))){
var inst_35015 = (state_35023[(2)]);
var state_35023__$1 = (function (){var statearr_35043 = state_35023;
(statearr_35043[(11)] = inst_35015);

return statearr_35043;
})();
var statearr_35044_35067 = state_35023__$1;
(statearr_35044_35067[(2)] = null);

(statearr_35044_35067[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35024 === (8))){
var inst_34982 = (state_35023[(9)]);
var inst_34986 = figwheel.client.reload_file_state_QMARK_.call(null,inst_34982,opts);
var state_35023__$1 = state_35023;
if(cljs.core.truth_(inst_34986)){
var statearr_35045_35068 = state_35023__$1;
(statearr_35045_35068[(1)] = (11));

} else {
var statearr_35046_35069 = state_35023__$1;
(statearr_35046_35069[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto___35051,ch))
;
return ((function (switch__30862__auto__,c__30950__auto___35051,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__30863__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__30863__auto____0 = (function (){
var statearr_35047 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35047[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__30863__auto__);

(statearr_35047[(1)] = (1));

return statearr_35047;
});
var figwheel$client$file_reloader_plugin_$_state_machine__30863__auto____1 = (function (state_35023){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_35023);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e35048){if((e35048 instanceof Object)){
var ex__30866__auto__ = e35048;
var statearr_35049_35070 = state_35023;
(statearr_35049_35070[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35023);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35048;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35071 = state_35023;
state_35023 = G__35071;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__30863__auto__ = function(state_35023){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__30863__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__30863__auto____1.call(this,state_35023);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$file_reloader_plugin_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__30863__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__30863__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___35051,ch))
})();
var state__30952__auto__ = (function (){var statearr_35050 = f__30951__auto__.call(null);
(statearr_35050[(6)] = c__30950__auto___35051);

return statearr_35050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___35051,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__35072_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__35072_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_35074 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_35074){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e35073){if((e35073 instanceof Error)){
var e = e35073;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_35074], null));
} else {
var e = e35073;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_35074))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__35075){
var map__35076 = p__35075;
var map__35076__$1 = ((((!((map__35076 == null)))?((((map__35076.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35076.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35076):map__35076);
var opts = map__35076__$1;
var build_id = cljs.core.get.call(null,map__35076__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__35076,map__35076__$1,opts,build_id){
return (function (p__35078){
var vec__35079 = p__35078;
var seq__35080 = cljs.core.seq.call(null,vec__35079);
var first__35081 = cljs.core.first.call(null,seq__35080);
var seq__35080__$1 = cljs.core.next.call(null,seq__35080);
var map__35082 = first__35081;
var map__35082__$1 = ((((!((map__35082 == null)))?((((map__35082.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35082.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35082):map__35082);
var msg = map__35082__$1;
var msg_name = cljs.core.get.call(null,map__35082__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35080__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__35079,seq__35080,first__35081,seq__35080__$1,map__35082,map__35082__$1,msg,msg_name,_,map__35076,map__35076__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__35079,seq__35080,first__35081,seq__35080__$1,map__35082,map__35082__$1,msg,msg_name,_,map__35076,map__35076__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__35076,map__35076__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__35084){
var vec__35085 = p__35084;
var seq__35086 = cljs.core.seq.call(null,vec__35085);
var first__35087 = cljs.core.first.call(null,seq__35086);
var seq__35086__$1 = cljs.core.next.call(null,seq__35086);
var map__35088 = first__35087;
var map__35088__$1 = ((((!((map__35088 == null)))?((((map__35088.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35088.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35088):map__35088);
var msg = map__35088__$1;
var msg_name = cljs.core.get.call(null,map__35088__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35086__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__35090){
var map__35091 = p__35090;
var map__35091__$1 = ((((!((map__35091 == null)))?((((map__35091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35091.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35091):map__35091);
var on_compile_warning = cljs.core.get.call(null,map__35091__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__35091__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__35091,map__35091__$1,on_compile_warning,on_compile_fail){
return (function (p__35093){
var vec__35094 = p__35093;
var seq__35095 = cljs.core.seq.call(null,vec__35094);
var first__35096 = cljs.core.first.call(null,seq__35095);
var seq__35095__$1 = cljs.core.next.call(null,seq__35095);
var map__35097 = first__35096;
var map__35097__$1 = ((((!((map__35097 == null)))?((((map__35097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35097.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35097):map__35097);
var msg = map__35097__$1;
var msg_name = cljs.core.get.call(null,map__35097__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__35095__$1;
var pred__35099 = cljs.core._EQ_;
var expr__35100 = msg_name;
if(cljs.core.truth_(pred__35099.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__35100))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__35099.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__35100))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__35091,map__35091__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__,msg_hist,msg_names,msg){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__,msg_hist,msg_names,msg){
return (function (state_35189){
var state_val_35190 = (state_35189[(1)]);
if((state_val_35190 === (7))){
var inst_35109 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
if(cljs.core.truth_(inst_35109)){
var statearr_35191_35238 = state_35189__$1;
(statearr_35191_35238[(1)] = (8));

} else {
var statearr_35192_35239 = state_35189__$1;
(statearr_35192_35239[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (20))){
var inst_35183 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35193_35240 = state_35189__$1;
(statearr_35193_35240[(2)] = inst_35183);

(statearr_35193_35240[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (27))){
var inst_35179 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35194_35241 = state_35189__$1;
(statearr_35194_35241[(2)] = inst_35179);

(statearr_35194_35241[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (1))){
var inst_35102 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_35189__$1 = state_35189;
if(cljs.core.truth_(inst_35102)){
var statearr_35195_35242 = state_35189__$1;
(statearr_35195_35242[(1)] = (2));

} else {
var statearr_35196_35243 = state_35189__$1;
(statearr_35196_35243[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (24))){
var inst_35181 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35197_35244 = state_35189__$1;
(statearr_35197_35244[(2)] = inst_35181);

(statearr_35197_35244[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (4))){
var inst_35187 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35189__$1,inst_35187);
} else {
if((state_val_35190 === (15))){
var inst_35185 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35198_35245 = state_35189__$1;
(statearr_35198_35245[(2)] = inst_35185);

(statearr_35198_35245[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (21))){
var inst_35138 = (state_35189[(2)]);
var inst_35139 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35140 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35139);
var state_35189__$1 = (function (){var statearr_35199 = state_35189;
(statearr_35199[(7)] = inst_35138);

return statearr_35199;
})();
var statearr_35200_35246 = state_35189__$1;
(statearr_35200_35246[(2)] = inst_35140);

(statearr_35200_35246[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (31))){
var inst_35168 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_35189__$1 = state_35189;
if(cljs.core.truth_(inst_35168)){
var statearr_35201_35247 = state_35189__$1;
(statearr_35201_35247[(1)] = (34));

} else {
var statearr_35202_35248 = state_35189__$1;
(statearr_35202_35248[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (32))){
var inst_35177 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35203_35249 = state_35189__$1;
(statearr_35203_35249[(2)] = inst_35177);

(statearr_35203_35249[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (33))){
var inst_35164 = (state_35189[(2)]);
var inst_35165 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35166 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35165);
var state_35189__$1 = (function (){var statearr_35204 = state_35189;
(statearr_35204[(8)] = inst_35164);

return statearr_35204;
})();
var statearr_35205_35250 = state_35189__$1;
(statearr_35205_35250[(2)] = inst_35166);

(statearr_35205_35250[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (13))){
var inst_35123 = figwheel.client.heads_up.clear.call(null);
var state_35189__$1 = state_35189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(16),inst_35123);
} else {
if((state_val_35190 === (22))){
var inst_35144 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35145 = figwheel.client.heads_up.append_warning_message.call(null,inst_35144);
var state_35189__$1 = state_35189;
var statearr_35206_35251 = state_35189__$1;
(statearr_35206_35251[(2)] = inst_35145);

(statearr_35206_35251[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (36))){
var inst_35175 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35207_35252 = state_35189__$1;
(statearr_35207_35252[(2)] = inst_35175);

(statearr_35207_35252[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (29))){
var inst_35155 = (state_35189[(2)]);
var inst_35156 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35157 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35156);
var state_35189__$1 = (function (){var statearr_35208 = state_35189;
(statearr_35208[(9)] = inst_35155);

return statearr_35208;
})();
var statearr_35209_35253 = state_35189__$1;
(statearr_35209_35253[(2)] = inst_35157);

(statearr_35209_35253[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (6))){
var inst_35104 = (state_35189[(10)]);
var state_35189__$1 = state_35189;
var statearr_35210_35254 = state_35189__$1;
(statearr_35210_35254[(2)] = inst_35104);

(statearr_35210_35254[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (28))){
var inst_35151 = (state_35189[(2)]);
var inst_35152 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35153 = figwheel.client.heads_up.display_warning.call(null,inst_35152);
var state_35189__$1 = (function (){var statearr_35211 = state_35189;
(statearr_35211[(11)] = inst_35151);

return statearr_35211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(29),inst_35153);
} else {
if((state_val_35190 === (25))){
var inst_35149 = figwheel.client.heads_up.clear.call(null);
var state_35189__$1 = state_35189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(28),inst_35149);
} else {
if((state_val_35190 === (34))){
var inst_35170 = figwheel.client.heads_up.flash_loaded.call(null);
var state_35189__$1 = state_35189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(37),inst_35170);
} else {
if((state_val_35190 === (17))){
var inst_35129 = (state_35189[(2)]);
var inst_35130 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35131 = figwheel.client.auto_jump_to_error.call(null,opts,inst_35130);
var state_35189__$1 = (function (){var statearr_35212 = state_35189;
(statearr_35212[(12)] = inst_35129);

return statearr_35212;
})();
var statearr_35213_35255 = state_35189__$1;
(statearr_35213_35255[(2)] = inst_35131);

(statearr_35213_35255[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (3))){
var inst_35121 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_35189__$1 = state_35189;
if(cljs.core.truth_(inst_35121)){
var statearr_35214_35256 = state_35189__$1;
(statearr_35214_35256[(1)] = (13));

} else {
var statearr_35215_35257 = state_35189__$1;
(statearr_35215_35257[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (12))){
var inst_35117 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35216_35258 = state_35189__$1;
(statearr_35216_35258[(2)] = inst_35117);

(statearr_35216_35258[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (2))){
var inst_35104 = (state_35189[(10)]);
var inst_35104__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_35189__$1 = (function (){var statearr_35217 = state_35189;
(statearr_35217[(10)] = inst_35104__$1);

return statearr_35217;
})();
if(cljs.core.truth_(inst_35104__$1)){
var statearr_35218_35259 = state_35189__$1;
(statearr_35218_35259[(1)] = (5));

} else {
var statearr_35219_35260 = state_35189__$1;
(statearr_35219_35260[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (23))){
var inst_35147 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_35189__$1 = state_35189;
if(cljs.core.truth_(inst_35147)){
var statearr_35220_35261 = state_35189__$1;
(statearr_35220_35261[(1)] = (25));

} else {
var statearr_35221_35262 = state_35189__$1;
(statearr_35221_35262[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (35))){
var state_35189__$1 = state_35189;
var statearr_35222_35263 = state_35189__$1;
(statearr_35222_35263[(2)] = null);

(statearr_35222_35263[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (19))){
var inst_35142 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_35189__$1 = state_35189;
if(cljs.core.truth_(inst_35142)){
var statearr_35223_35264 = state_35189__$1;
(statearr_35223_35264[(1)] = (22));

} else {
var statearr_35224_35265 = state_35189__$1;
(statearr_35224_35265[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (11))){
var inst_35113 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35225_35266 = state_35189__$1;
(statearr_35225_35266[(2)] = inst_35113);

(statearr_35225_35266[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (9))){
var inst_35115 = figwheel.client.heads_up.clear.call(null);
var state_35189__$1 = state_35189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(12),inst_35115);
} else {
if((state_val_35190 === (5))){
var inst_35106 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_35189__$1 = state_35189;
var statearr_35226_35267 = state_35189__$1;
(statearr_35226_35267[(2)] = inst_35106);

(statearr_35226_35267[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (14))){
var inst_35133 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_35189__$1 = state_35189;
if(cljs.core.truth_(inst_35133)){
var statearr_35227_35268 = state_35189__$1;
(statearr_35227_35268[(1)] = (18));

} else {
var statearr_35228_35269 = state_35189__$1;
(statearr_35228_35269[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (26))){
var inst_35159 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_35189__$1 = state_35189;
if(cljs.core.truth_(inst_35159)){
var statearr_35229_35270 = state_35189__$1;
(statearr_35229_35270[(1)] = (30));

} else {
var statearr_35230_35271 = state_35189__$1;
(statearr_35230_35271[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (16))){
var inst_35125 = (state_35189[(2)]);
var inst_35126 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35127 = figwheel.client.heads_up.display_exception.call(null,inst_35126);
var state_35189__$1 = (function (){var statearr_35231 = state_35189;
(statearr_35231[(13)] = inst_35125);

return statearr_35231;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(17),inst_35127);
} else {
if((state_val_35190 === (30))){
var inst_35161 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35162 = figwheel.client.heads_up.display_warning.call(null,inst_35161);
var state_35189__$1 = state_35189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(33),inst_35162);
} else {
if((state_val_35190 === (10))){
var inst_35119 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35232_35272 = state_35189__$1;
(statearr_35232_35272[(2)] = inst_35119);

(statearr_35232_35272[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (18))){
var inst_35135 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_35136 = figwheel.client.heads_up.display_exception.call(null,inst_35135);
var state_35189__$1 = state_35189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(21),inst_35136);
} else {
if((state_val_35190 === (37))){
var inst_35172 = (state_35189[(2)]);
var state_35189__$1 = state_35189;
var statearr_35233_35273 = state_35189__$1;
(statearr_35233_35273[(2)] = inst_35172);

(statearr_35233_35273[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35190 === (8))){
var inst_35111 = figwheel.client.heads_up.flash_loaded.call(null);
var state_35189__$1 = state_35189;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35189__$1,(11),inst_35111);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__30950__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__30862__auto__,c__30950__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto____0 = (function (){
var statearr_35234 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35234[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto__);

(statearr_35234[(1)] = (1));

return statearr_35234;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto____1 = (function (state_35189){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_35189);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e35235){if((e35235 instanceof Object)){
var ex__30866__auto__ = e35235;
var statearr_35236_35274 = state_35189;
(statearr_35236_35274[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35189);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35235;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35275 = state_35189;
state_35189 = G__35275;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto__ = function(state_35189){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto____1.call(this,state_35189);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__,msg_hist,msg_names,msg))
})();
var state__30952__auto__ = (function (){var statearr_35237 = f__30951__auto__.call(null);
(statearr_35237[(6)] = c__30950__auto__);

return statearr_35237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__,msg_hist,msg_names,msg))
);

return c__30950__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__30950__auto___35304 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto___35304,ch){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto___35304,ch){
return (function (state_35290){
var state_val_35291 = (state_35290[(1)]);
if((state_val_35291 === (1))){
var state_35290__$1 = state_35290;
var statearr_35292_35305 = state_35290__$1;
(statearr_35292_35305[(2)] = null);

(statearr_35292_35305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (2))){
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(4),ch);
} else {
if((state_val_35291 === (3))){
var inst_35288 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35290__$1,inst_35288);
} else {
if((state_val_35291 === (4))){
var inst_35278 = (state_35290[(7)]);
var inst_35278__$1 = (state_35290[(2)]);
var state_35290__$1 = (function (){var statearr_35293 = state_35290;
(statearr_35293[(7)] = inst_35278__$1);

return statearr_35293;
})();
if(cljs.core.truth_(inst_35278__$1)){
var statearr_35294_35306 = state_35290__$1;
(statearr_35294_35306[(1)] = (5));

} else {
var statearr_35295_35307 = state_35290__$1;
(statearr_35295_35307[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (5))){
var inst_35278 = (state_35290[(7)]);
var inst_35280 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_35278);
var state_35290__$1 = state_35290;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35290__$1,(8),inst_35280);
} else {
if((state_val_35291 === (6))){
var state_35290__$1 = state_35290;
var statearr_35296_35308 = state_35290__$1;
(statearr_35296_35308[(2)] = null);

(statearr_35296_35308[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (7))){
var inst_35286 = (state_35290[(2)]);
var state_35290__$1 = state_35290;
var statearr_35297_35309 = state_35290__$1;
(statearr_35297_35309[(2)] = inst_35286);

(statearr_35297_35309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_35291 === (8))){
var inst_35282 = (state_35290[(2)]);
var state_35290__$1 = (function (){var statearr_35298 = state_35290;
(statearr_35298[(8)] = inst_35282);

return statearr_35298;
})();
var statearr_35299_35310 = state_35290__$1;
(statearr_35299_35310[(2)] = null);

(statearr_35299_35310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__30950__auto___35304,ch))
;
return ((function (switch__30862__auto__,c__30950__auto___35304,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__30863__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__30863__auto____0 = (function (){
var statearr_35300 = [null,null,null,null,null,null,null,null,null];
(statearr_35300[(0)] = figwheel$client$heads_up_plugin_$_state_machine__30863__auto__);

(statearr_35300[(1)] = (1));

return statearr_35300;
});
var figwheel$client$heads_up_plugin_$_state_machine__30863__auto____1 = (function (state_35290){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_35290);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e35301){if((e35301 instanceof Object)){
var ex__30866__auto__ = e35301;
var statearr_35302_35311 = state_35290;
(statearr_35302_35311[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35290);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35301;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35312 = state_35290;
state_35290 = G__35312;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__30863__auto__ = function(state_35290){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__30863__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__30863__auto____1.call(this,state_35290);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$heads_up_plugin_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__30863__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__30863__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto___35304,ch))
})();
var state__30952__auto__ = (function (){var statearr_35303 = f__30951__auto__.call(null);
(statearr_35303[(6)] = c__30950__auto___35304);

return statearr_35303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto___35304,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__){
return (function (state_35318){
var state_val_35319 = (state_35318[(1)]);
if((state_val_35319 === (1))){
var inst_35313 = cljs.core.async.timeout.call(null,(3000));
var state_35318__$1 = state_35318;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35318__$1,(2),inst_35313);
} else {
if((state_val_35319 === (2))){
var inst_35315 = (state_35318[(2)]);
var inst_35316 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_35318__$1 = (function (){var statearr_35320 = state_35318;
(statearr_35320[(7)] = inst_35315);

return statearr_35320;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35318__$1,inst_35316);
} else {
return null;
}
}
});})(c__30950__auto__))
;
return ((function (switch__30862__auto__,c__30950__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__30863__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__30863__auto____0 = (function (){
var statearr_35321 = [null,null,null,null,null,null,null,null];
(statearr_35321[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__30863__auto__);

(statearr_35321[(1)] = (1));

return statearr_35321;
});
var figwheel$client$enforce_project_plugin_$_state_machine__30863__auto____1 = (function (state_35318){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_35318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e35322){if((e35322 instanceof Object)){
var ex__30866__auto__ = e35322;
var statearr_35323_35325 = state_35318;
(statearr_35323_35325[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35318);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35322;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35326 = state_35318;
state_35318 = G__35326;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__30863__auto__ = function(state_35318){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__30863__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__30863__auto____1.call(this,state_35318);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_project_plugin_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__30863__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__30863__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__))
})();
var state__30952__auto__ = (function (){var statearr_35324 = f__30951__auto__.call(null);
(statearr_35324[(6)] = c__30950__auto__);

return statearr_35324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__))
);

return c__30950__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__4657__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__4657__auto__)){
var figwheel_version = temp__4657__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__30950__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__30950__auto__,figwheel_version,temp__4657__auto__){
return (function (){
var f__30951__auto__ = (function (){var switch__30862__auto__ = ((function (c__30950__auto__,figwheel_version,temp__4657__auto__){
return (function (state_35333){
var state_val_35334 = (state_35333[(1)]);
if((state_val_35334 === (1))){
var inst_35327 = cljs.core.async.timeout.call(null,(2000));
var state_35333__$1 = state_35333;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_35333__$1,(2),inst_35327);
} else {
if((state_val_35334 === (2))){
var inst_35329 = (state_35333[(2)]);
var inst_35330 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_35331 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_35330);
var state_35333__$1 = (function (){var statearr_35335 = state_35333;
(statearr_35335[(7)] = inst_35329);

return statearr_35335;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_35333__$1,inst_35331);
} else {
return null;
}
}
});})(c__30950__auto__,figwheel_version,temp__4657__auto__))
;
return ((function (switch__30862__auto__,c__30950__auto__,figwheel_version,temp__4657__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto____0 = (function (){
var statearr_35336 = [null,null,null,null,null,null,null,null];
(statearr_35336[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto__);

(statearr_35336[(1)] = (1));

return statearr_35336;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto____1 = (function (state_35333){
while(true){
var ret_value__30864__auto__ = (function (){try{while(true){
var result__30865__auto__ = switch__30862__auto__.call(null,state_35333);
if(cljs.core.keyword_identical_QMARK_.call(null,result__30865__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__30865__auto__;
}
break;
}
}catch (e35337){if((e35337 instanceof Object)){
var ex__30866__auto__ = e35337;
var statearr_35338_35340 = state_35333;
(statearr_35338_35340[(5)] = ex__30866__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_35333);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e35337;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__30864__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35341 = state_35333;
state_35333 = G__35341;
continue;
} else {
return ret_value__30864__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto__ = function(state_35333){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto____1.call(this,state_35333);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__30863__auto__;
})()
;})(switch__30862__auto__,c__30950__auto__,figwheel_version,temp__4657__auto__))
})();
var state__30952__auto__ = (function (){var statearr_35339 = f__30951__auto__.call(null);
(statearr_35339[(6)] = c__30950__auto__);

return statearr_35339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__30952__auto__);
});})(c__30950__auto__,figwheel_version,temp__4657__auto__))
);

return c__30950__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__35342){
var map__35343 = p__35342;
var map__35343__$1 = ((((!((map__35343 == null)))?((((map__35343.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35343.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35343):map__35343);
var file = cljs.core.get.call(null,map__35343__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__35343__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__35343__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__35345 = "";
var G__35345__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35345),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__35345);
var G__35345__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35345__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__35345__$1);
if(cljs.core.truth_((function (){var and__28336__auto__ = line;
if(cljs.core.truth_(and__28336__auto__)){
return column;
} else {
return and__28336__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35345__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__35345__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__35346){
var map__35347 = p__35346;
var map__35347__$1 = ((((!((map__35347 == null)))?((((map__35347.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35347.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35347):map__35347);
var ed = map__35347__$1;
var formatted_exception = cljs.core.get.call(null,map__35347__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__35347__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__35347__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__35349_35353 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__35350_35354 = null;
var count__35351_35355 = (0);
var i__35352_35356 = (0);
while(true){
if((i__35352_35356 < count__35351_35355)){
var msg_35357 = cljs.core._nth.call(null,chunk__35350_35354,i__35352_35356);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_35357);

var G__35358 = seq__35349_35353;
var G__35359 = chunk__35350_35354;
var G__35360 = count__35351_35355;
var G__35361 = (i__35352_35356 + (1));
seq__35349_35353 = G__35358;
chunk__35350_35354 = G__35359;
count__35351_35355 = G__35360;
i__35352_35356 = G__35361;
continue;
} else {
var temp__4657__auto___35362 = cljs.core.seq.call(null,seq__35349_35353);
if(temp__4657__auto___35362){
var seq__35349_35363__$1 = temp__4657__auto___35362;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35349_35363__$1)){
var c__29187__auto___35364 = cljs.core.chunk_first.call(null,seq__35349_35363__$1);
var G__35365 = cljs.core.chunk_rest.call(null,seq__35349_35363__$1);
var G__35366 = c__29187__auto___35364;
var G__35367 = cljs.core.count.call(null,c__29187__auto___35364);
var G__35368 = (0);
seq__35349_35353 = G__35365;
chunk__35350_35354 = G__35366;
count__35351_35355 = G__35367;
i__35352_35356 = G__35368;
continue;
} else {
var msg_35369 = cljs.core.first.call(null,seq__35349_35363__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_35369);

var G__35370 = cljs.core.next.call(null,seq__35349_35363__$1);
var G__35371 = null;
var G__35372 = (0);
var G__35373 = (0);
seq__35349_35353 = G__35370;
chunk__35350_35354 = G__35371;
count__35351_35355 = G__35372;
i__35352_35356 = G__35373;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__35374){
var map__35375 = p__35374;
var map__35375__$1 = ((((!((map__35375 == null)))?((((map__35375.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35375.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35375):map__35375);
var w = map__35375__$1;
var message = cljs.core.get.call(null,map__35375__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/rui-demo/public/js/compiled/demo/out/figwheel/client.cljs",33,1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/rui-demo/public/js/compiled/demo/out/figwheel/client.cljs",30,1,355,355,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__28336__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__28336__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__28336__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__35377 = cljs.core.seq.call(null,plugins);
var chunk__35378 = null;
var count__35379 = (0);
var i__35380 = (0);
while(true){
if((i__35380 < count__35379)){
var vec__35381 = cljs.core._nth.call(null,chunk__35378,i__35380);
var k = cljs.core.nth.call(null,vec__35381,(0),null);
var plugin = cljs.core.nth.call(null,vec__35381,(1),null);
if(cljs.core.truth_(plugin)){
var pl_35387 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__35377,chunk__35378,count__35379,i__35380,pl_35387,vec__35381,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_35387.call(null,msg_hist);
});})(seq__35377,chunk__35378,count__35379,i__35380,pl_35387,vec__35381,k,plugin))
);
} else {
}

var G__35388 = seq__35377;
var G__35389 = chunk__35378;
var G__35390 = count__35379;
var G__35391 = (i__35380 + (1));
seq__35377 = G__35388;
chunk__35378 = G__35389;
count__35379 = G__35390;
i__35380 = G__35391;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35377);
if(temp__4657__auto__){
var seq__35377__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35377__$1)){
var c__29187__auto__ = cljs.core.chunk_first.call(null,seq__35377__$1);
var G__35392 = cljs.core.chunk_rest.call(null,seq__35377__$1);
var G__35393 = c__29187__auto__;
var G__35394 = cljs.core.count.call(null,c__29187__auto__);
var G__35395 = (0);
seq__35377 = G__35392;
chunk__35378 = G__35393;
count__35379 = G__35394;
i__35380 = G__35395;
continue;
} else {
var vec__35384 = cljs.core.first.call(null,seq__35377__$1);
var k = cljs.core.nth.call(null,vec__35384,(0),null);
var plugin = cljs.core.nth.call(null,vec__35384,(1),null);
if(cljs.core.truth_(plugin)){
var pl_35396 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__35377,chunk__35378,count__35379,i__35380,pl_35396,vec__35384,k,plugin,seq__35377__$1,temp__4657__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_35396.call(null,msg_hist);
});})(seq__35377,chunk__35378,count__35379,i__35380,pl_35396,vec__35384,k,plugin,seq__35377__$1,temp__4657__auto__))
);
} else {
}

var G__35397 = cljs.core.next.call(null,seq__35377__$1);
var G__35398 = null;
var G__35399 = (0);
var G__35400 = (0);
seq__35377 = G__35397;
chunk__35378 = G__35398;
count__35379 = G__35399;
i__35380 = G__35400;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__35402 = arguments.length;
switch (G__35402) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__35403_35408 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__35404_35409 = null;
var count__35405_35410 = (0);
var i__35406_35411 = (0);
while(true){
if((i__35406_35411 < count__35405_35410)){
var msg_35412 = cljs.core._nth.call(null,chunk__35404_35409,i__35406_35411);
figwheel.client.socket.handle_incoming_message.call(null,msg_35412);

var G__35413 = seq__35403_35408;
var G__35414 = chunk__35404_35409;
var G__35415 = count__35405_35410;
var G__35416 = (i__35406_35411 + (1));
seq__35403_35408 = G__35413;
chunk__35404_35409 = G__35414;
count__35405_35410 = G__35415;
i__35406_35411 = G__35416;
continue;
} else {
var temp__4657__auto___35417 = cljs.core.seq.call(null,seq__35403_35408);
if(temp__4657__auto___35417){
var seq__35403_35418__$1 = temp__4657__auto___35417;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35403_35418__$1)){
var c__29187__auto___35419 = cljs.core.chunk_first.call(null,seq__35403_35418__$1);
var G__35420 = cljs.core.chunk_rest.call(null,seq__35403_35418__$1);
var G__35421 = c__29187__auto___35419;
var G__35422 = cljs.core.count.call(null,c__29187__auto___35419);
var G__35423 = (0);
seq__35403_35408 = G__35420;
chunk__35404_35409 = G__35421;
count__35405_35410 = G__35422;
i__35406_35411 = G__35423;
continue;
} else {
var msg_35424 = cljs.core.first.call(null,seq__35403_35418__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_35424);

var G__35425 = cljs.core.next.call(null,seq__35403_35418__$1);
var G__35426 = null;
var G__35427 = (0);
var G__35428 = (0);
seq__35403_35408 = G__35425;
chunk__35404_35409 = G__35426;
count__35405_35410 = G__35427;
i__35406_35411 = G__35428;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__29526__auto__ = [];
var len__29519__auto___35433 = arguments.length;
var i__29520__auto___35434 = (0);
while(true){
if((i__29520__auto___35434 < len__29519__auto___35433)){
args__29526__auto__.push((arguments[i__29520__auto___35434]));

var G__35435 = (i__29520__auto___35434 + (1));
i__29520__auto___35434 = G__35435;
continue;
} else {
}
break;
}

var argseq__29527__auto__ = ((((0) < args__29526__auto__.length))?(new cljs.core.IndexedSeq(args__29526__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__29527__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__35430){
var map__35431 = p__35430;
var map__35431__$1 = ((((!((map__35431 == null)))?((((map__35431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35431.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35431):map__35431);
var opts = map__35431__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq35429){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq35429));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e35436){if((e35436 instanceof Error)){
var e = e35436;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e35436;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__35437){
var map__35438 = p__35437;
var map__35438__$1 = ((((!((map__35438 == null)))?((((map__35438.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35438.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35438):map__35438);
var msg_name = cljs.core.get.call(null,map__35438__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1516617677176
