// Compiled by ClojureScript 1.10.339 {}
goog.provide('rui.buttons.components');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('ccn.core');
goog.require('rui.icons');
/**
 * Returns a vector from a given `hashmap`
 * {:a 0 :b [1 2]} -> [:a 0 :b [1 2]]
 */
rui.buttons.components.map__GT_vec = (function rui$buttons$components$map__GT_vec(hashmap){
return cljs.core.apply.call(null,cljs.core.concat,cljs.core.vec.call(null,hashmap));
});
rui.buttons.components.compose_button_class = (function rui$buttons$components$compose_button_class(modifiers,twbs_modifiers,classes,enabled_internal_QMARK_,waiting_QMARK_){
return cljs.core.apply.call(null,ccn.core.css_class,cljs.core.concat.call(null,classes,cljs.core.conj.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ccn.core.twbs.call(null,"btn",twbs_modifiers)], null),ccn.core.bem.call(null,"btn",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(enabled_internal_QMARK_)?"enabled":"disabled"),(cljs.core.truth_(waiting_QMARK_)?"waiting":null)], null))))));
});
/**
 * Returns Bootstrap's button with a given `title` as content and `on-click` handler.
 * Kwargs:
 * :enabled? - a boolean that indicates enabled/disabled state of it
 * :attrs - a map of attributes to override element's attributes
 * :modifiers - BEM modifiers
 * :twbs-modifiers - Bootstrap modifiers
 * :children - a sequence of its children components
 * :waiting? - a boolean that shows a spinner when `true`
 * :classes - a sequence of CSS classes
 */
rui.buttons.components.button = (function rui$buttons$components$button(var_args){
var args__4534__auto__ = [];
var len__4531__auto___23385 = arguments.length;
var i__4532__auto___23386 = (0);
while(true){
if((i__4532__auto___23386 < len__4531__auto___23385)){
args__4534__auto__.push((arguments[i__4532__auto___23386]));

var G__23387 = (i__4532__auto___23386 + (1));
i__4532__auto___23386 = G__23387;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rui.buttons.components.button.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rui.buttons.components.button.cljs$core$IFn$_invoke$arity$variadic = (function (title,on_click,p__23382){
var map__23383 = p__23382;
var map__23383__$1 = ((((!((map__23383 == null)))?(((((map__23383.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23383.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23383):map__23383);
var enabled_QMARK_ = cljs.core.get.call(null,map__23383__$1,new cljs.core.Keyword(null,"enabled?","enabled?",-1376075057),true);
var attrs = cljs.core.get.call(null,map__23383__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var modifiers = cljs.core.get.call(null,map__23383__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var waiting_QMARK_ = cljs.core.get.call(null,map__23383__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false);
var children = cljs.core.get.call(null,map__23383__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var twbs_modifiers = cljs.core.get.call(null,map__23383__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var classes = cljs.core.get.call(null,map__23383__$1,new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.PersistentVector.EMPTY);
var enabled_internal_QMARK_ = (function (){var and__3938__auto__ = enabled_QMARK_;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,waiting_QMARK_);
} else {
return and__3938__auto__;
}
})();
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button","button",1456579943),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),rui.buttons.components.compose_button_class.call(null,modifiers,twbs_modifiers,classes,enabled_internal_QMARK_,waiting_QMARK_),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (enabled_internal_QMARK_,map__23383,map__23383__$1,enabled_QMARK_,attrs,modifiers,waiting_QMARK_,children,twbs_modifiers,classes){
return (function (p1__23378_SHARP_){
if(cljs.core.truth_(enabled_internal_QMARK_)){
return on_click.call(null,p1__23378_SHARP_);
} else {
return null;
}
});})(enabled_internal_QMARK_,map__23383,map__23383__$1,enabled_QMARK_,attrs,modifiers,waiting_QMARK_,children,twbs_modifiers,classes))
], null),(cljs.core.truth_(enabled_internal_QMARK_)?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),true], null)),attrs),(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.icons.fa,"gear",true], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"btn","title",cljs.core.PersistentVector.EMPTY)], null),title], null)], null),children);
});

rui.buttons.components.button.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rui.buttons.components.button.cljs$lang$applyTo = (function (seq23379){
var G__23380 = cljs.core.first.call(null,seq23379);
var seq23379__$1 = cljs.core.next.call(null,seq23379);
var G__23381 = cljs.core.first.call(null,seq23379__$1);
var seq23379__$2 = cljs.core.next.call(null,seq23379__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23380,G__23381,seq23379__$2);
});

/**
 * Helper function for creating buttons
 */
rui.buttons.components.button_factory = (function rui$buttons$components$button_factory(button_type){
return (function() { 
var G__23391__delegate = function (title,on_click,p__23388){
var map__23389 = p__23388;
var map__23389__$1 = ((((!((map__23389 == null)))?(((((map__23389.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23389.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23389):map__23389);
var kwargs = map__23389__$1;
var enabled_QMARK_ = cljs.core.get.call(null,map__23389__$1,new cljs.core.Keyword(null,"enabled?","enabled?",-1376075057));
var attrs = cljs.core.get.call(null,map__23389__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var modifiers = cljs.core.get.call(null,map__23389__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var waiting_QMARK_ = cljs.core.get.call(null,map__23389__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215));
var children = cljs.core.get.call(null,map__23389__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var twbs_modifiers = cljs.core.get.call(null,map__23389__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.buttons.components.button,title,on_click], null),rui.buttons.components.map__GT_vec.call(null,cljs.core.update.call(null,kwargs,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.conj,button_type)));
};
var G__23391 = function (title,on_click,var_args){
var p__23388 = null;
if (arguments.length > 2) {
var G__23392__i = 0, G__23392__a = new Array(arguments.length -  2);
while (G__23392__i < G__23392__a.length) {G__23392__a[G__23392__i] = arguments[G__23392__i + 2]; ++G__23392__i;}
  p__23388 = new cljs.core.IndexedSeq(G__23392__a,0,null);
} 
return G__23391__delegate.call(this,title,on_click,p__23388);};
G__23391.cljs$lang$maxFixedArity = 2;
G__23391.cljs$lang$applyTo = (function (arglist__23393){
var title = cljs.core.first(arglist__23393);
arglist__23393 = cljs.core.next(arglist__23393);
var on_click = cljs.core.first(arglist__23393);
var p__23388 = cljs.core.rest(arglist__23393);
return G__23391__delegate(title,on_click,p__23388);
});
G__23391.cljs$core$IFn$_invoke$arity$variadic = G__23391__delegate;
return G__23391;
})()
;
});

//# sourceMappingURL=components.js.map?rel=1533629716520
