// Compiled by ClojureScript 1.10.339 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.16";
figwheel.client.js_stringify = (((((typeof JSON !== 'undefined')) && (!((JSON.stringify == null)))))?(function (x){
return ["#js ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(JSON.stringify(x,null," "))].join('');
}):(function (x){
try{return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
}catch (e32145){if((e32145 instanceof Error)){
var e = e32145;
return "Error: Unable to stringify";
} else {
throw e32145;

}
}}));
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var G__32148 = arguments.length;
switch (G__32148) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),cljs.core.mapv.call(null,(function (p1__32146_SHARP_){
if(typeof p1__32146_SHARP_ === 'string'){
return p1__32146_SHARP_;
} else {
return figwheel.client.js_stringify.call(null,p1__32146_SHARP_);
}
}),args)], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32151 = arguments.length;
var i__4532__auto___32152 = (0);
while(true){
if((i__4532__auto___32152 < len__4531__auto___32151)){
args__4534__auto__.push((arguments[i__4532__auto___32152]));

var G__32153 = (i__4532__auto___32152 + (1));
i__4532__auto___32152 = G__32153;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq32150){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32150));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32155 = arguments.length;
var i__4532__auto___32156 = (0);
while(true){
if((i__4532__auto___32156 < len__4531__auto___32155)){
args__4534__auto__.push((arguments[i__4532__auto___32156]));

var G__32157 = (i__4532__auto___32156 + (1));
i__4532__auto___32156 = G__32157;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq32154){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32154));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)"].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Figwheel autoloading ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method.
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 * 
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if(((b === true) || (b === false))){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__32158){
var map__32159 = p__32158;
var map__32159__$1 = ((((!((map__32159 == null)))?(((((map__32159.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32159.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32159):map__32159);
var message = cljs.core.get.call(null,map__32159__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__32159__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$)," : ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__3949__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__3938__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__3938__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__3938__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return ((cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts))));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__25422__auto___32238 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___32238,ch){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___32238,ch){
return (function (state_32210){
var state_val_32211 = (state_32210[(1)]);
if((state_val_32211 === (7))){
var inst_32206 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32212_32239 = state_32210__$1;
(statearr_32212_32239[(2)] = inst_32206);

(statearr_32212_32239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (1))){
var state_32210__$1 = state_32210;
var statearr_32213_32240 = state_32210__$1;
(statearr_32213_32240[(2)] = null);

(statearr_32213_32240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (4))){
var inst_32163 = (state_32210[(7)]);
var inst_32163__$1 = (state_32210[(2)]);
var state_32210__$1 = (function (){var statearr_32214 = state_32210;
(statearr_32214[(7)] = inst_32163__$1);

return statearr_32214;
})();
if(cljs.core.truth_(inst_32163__$1)){
var statearr_32215_32241 = state_32210__$1;
(statearr_32215_32241[(1)] = (5));

} else {
var statearr_32216_32242 = state_32210__$1;
(statearr_32216_32242[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (15))){
var inst_32170 = (state_32210[(8)]);
var inst_32185 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_32170);
var inst_32186 = cljs.core.first.call(null,inst_32185);
var inst_32187 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_32186);
var inst_32188 = ["Figwheel: Not loading code with warnings - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32187)].join('');
var inst_32189 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_32188);
var state_32210__$1 = state_32210;
var statearr_32217_32243 = state_32210__$1;
(statearr_32217_32243[(2)] = inst_32189);

(statearr_32217_32243[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (13))){
var inst_32194 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32218_32244 = state_32210__$1;
(statearr_32218_32244[(2)] = inst_32194);

(statearr_32218_32244[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (6))){
var state_32210__$1 = state_32210;
var statearr_32219_32245 = state_32210__$1;
(statearr_32219_32245[(2)] = null);

(statearr_32219_32245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (17))){
var inst_32192 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32220_32246 = state_32210__$1;
(statearr_32220_32246[(2)] = inst_32192);

(statearr_32220_32246[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (3))){
var inst_32208 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32210__$1,inst_32208);
} else {
if((state_val_32211 === (12))){
var inst_32169 = (state_32210[(9)]);
var inst_32183 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_32169,opts);
var state_32210__$1 = state_32210;
if(cljs.core.truth_(inst_32183)){
var statearr_32221_32247 = state_32210__$1;
(statearr_32221_32247[(1)] = (15));

} else {
var statearr_32222_32248 = state_32210__$1;
(statearr_32222_32248[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (2))){
var state_32210__$1 = state_32210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32210__$1,(4),ch);
} else {
if((state_val_32211 === (11))){
var inst_32170 = (state_32210[(8)]);
var inst_32175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32176 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_32170);
var inst_32177 = cljs.core.async.timeout.call(null,(1000));
var inst_32178 = [inst_32176,inst_32177];
var inst_32179 = (new cljs.core.PersistentVector(null,2,(5),inst_32175,inst_32178,null));
var state_32210__$1 = state_32210;
return cljs.core.async.ioc_alts_BANG_.call(null,state_32210__$1,(14),inst_32179);
} else {
if((state_val_32211 === (9))){
var inst_32170 = (state_32210[(8)]);
var inst_32196 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_32197 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_32170);
var inst_32198 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_32197);
var inst_32199 = ["Not loading: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32198)].join('');
var inst_32200 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_32199);
var state_32210__$1 = (function (){var statearr_32223 = state_32210;
(statearr_32223[(10)] = inst_32196);

return statearr_32223;
})();
var statearr_32224_32249 = state_32210__$1;
(statearr_32224_32249[(2)] = inst_32200);

(statearr_32224_32249[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (5))){
var inst_32163 = (state_32210[(7)]);
var inst_32165 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_32166 = (new cljs.core.PersistentArrayMap(null,2,inst_32165,null));
var inst_32167 = (new cljs.core.PersistentHashSet(null,inst_32166,null));
var inst_32168 = figwheel.client.focus_msgs.call(null,inst_32167,inst_32163);
var inst_32169 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_32168);
var inst_32170 = cljs.core.first.call(null,inst_32168);
var inst_32171 = figwheel.client.autoload_QMARK_.call(null);
var state_32210__$1 = (function (){var statearr_32225 = state_32210;
(statearr_32225[(8)] = inst_32170);

(statearr_32225[(9)] = inst_32169);

return statearr_32225;
})();
if(cljs.core.truth_(inst_32171)){
var statearr_32226_32250 = state_32210__$1;
(statearr_32226_32250[(1)] = (8));

} else {
var statearr_32227_32251 = state_32210__$1;
(statearr_32227_32251[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (14))){
var inst_32181 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32228_32252 = state_32210__$1;
(statearr_32228_32252[(2)] = inst_32181);

(statearr_32228_32252[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (16))){
var state_32210__$1 = state_32210;
var statearr_32229_32253 = state_32210__$1;
(statearr_32229_32253[(2)] = null);

(statearr_32229_32253[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (10))){
var inst_32202 = (state_32210[(2)]);
var state_32210__$1 = (function (){var statearr_32230 = state_32210;
(statearr_32230[(11)] = inst_32202);

return statearr_32230;
})();
var statearr_32231_32254 = state_32210__$1;
(statearr_32231_32254[(2)] = null);

(statearr_32231_32254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32211 === (8))){
var inst_32169 = (state_32210[(9)]);
var inst_32173 = figwheel.client.reload_file_state_QMARK_.call(null,inst_32169,opts);
var state_32210__$1 = state_32210;
if(cljs.core.truth_(inst_32173)){
var statearr_32232_32255 = state_32210__$1;
(statearr_32232_32255[(1)] = (11));

} else {
var statearr_32233_32256 = state_32210__$1;
(statearr_32233_32256[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___32238,ch))
;
return ((function (switch__25331__auto__,c__25422__auto___32238,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__25332__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__25332__auto____0 = (function (){
var statearr_32234 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32234[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__25332__auto__);

(statearr_32234[(1)] = (1));

return statearr_32234;
});
var figwheel$client$file_reloader_plugin_$_state_machine__25332__auto____1 = (function (state_32210){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_32210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e32235){if((e32235 instanceof Object)){
var ex__25335__auto__ = e32235;
var statearr_32236_32257 = state_32210;
(statearr_32236_32257[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32235;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32258 = state_32210;
state_32210 = G__32258;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__25332__auto__ = function(state_32210){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__25332__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__25332__auto____1.call(this,state_32210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__25332__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__25332__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___32238,ch))
})();
var state__25424__auto__ = (function (){var statearr_32237 = f__25423__auto__.call(null);
(statearr_32237[(6)] = c__25422__auto___32238);

return statearr_32237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___32238,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__32259_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__32259_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_32263 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_32263){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{var sb = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR_32261 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR_32262 = cljs.core._STAR_print_fn_STAR_;
cljs.core._STAR_print_newline_STAR_ = true;

cljs.core._STAR_print_fn_STAR_ = ((function (_STAR_print_newline_STAR_32261,_STAR_print_fn_STAR_32262,sb,base_path_32263){
return (function (x){
return sb.append(x);
});})(_STAR_print_newline_STAR_32261,_STAR_print_fn_STAR_32262,sb,base_path_32263))
;

try{var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"out","out",-910545517),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join(''),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}finally {cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR_32262;

cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR_32261;
}}catch (e32260){if((e32260 instanceof Error)){
var e = e32260;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_32263], null));
} else {
var e = e32260;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}});})(base_path_32263))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__32264){
var map__32265 = p__32264;
var map__32265__$1 = ((((!((map__32265 == null)))?(((((map__32265.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32265.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32265):map__32265);
var opts = map__32265__$1;
var build_id = cljs.core.get.call(null,map__32265__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__32265,map__32265__$1,opts,build_id){
return (function (p__32267){
var vec__32268 = p__32267;
var seq__32269 = cljs.core.seq.call(null,vec__32268);
var first__32270 = cljs.core.first.call(null,seq__32269);
var seq__32269__$1 = cljs.core.next.call(null,seq__32269);
var map__32271 = first__32270;
var map__32271__$1 = ((((!((map__32271 == null)))?(((((map__32271.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32271.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32271):map__32271);
var msg = map__32271__$1;
var msg_name = cljs.core.get.call(null,map__32271__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32269__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__32268,seq__32269,first__32270,seq__32269__$1,map__32271,map__32271__$1,msg,msg_name,_,map__32265,map__32265__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__32268,seq__32269,first__32270,seq__32269__$1,map__32271,map__32271__$1,msg,msg_name,_,map__32265,map__32265__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__32265,map__32265__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__32273){
var vec__32274 = p__32273;
var seq__32275 = cljs.core.seq.call(null,vec__32274);
var first__32276 = cljs.core.first.call(null,seq__32275);
var seq__32275__$1 = cljs.core.next.call(null,seq__32275);
var map__32277 = first__32276;
var map__32277__$1 = ((((!((map__32277 == null)))?(((((map__32277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32277):map__32277);
var msg = map__32277__$1;
var msg_name = cljs.core.get.call(null,map__32277__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32275__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__32279){
var map__32280 = p__32279;
var map__32280__$1 = ((((!((map__32280 == null)))?(((((map__32280.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32280.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32280):map__32280);
var on_compile_warning = cljs.core.get.call(null,map__32280__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__32280__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__32280,map__32280__$1,on_compile_warning,on_compile_fail){
return (function (p__32282){
var vec__32283 = p__32282;
var seq__32284 = cljs.core.seq.call(null,vec__32283);
var first__32285 = cljs.core.first.call(null,seq__32284);
var seq__32284__$1 = cljs.core.next.call(null,seq__32284);
var map__32286 = first__32285;
var map__32286__$1 = ((((!((map__32286 == null)))?(((((map__32286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32286.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32286):map__32286);
var msg = map__32286__$1;
var msg_name = cljs.core.get.call(null,map__32286__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__32284__$1;
var pred__32288 = cljs.core._EQ_;
var expr__32289 = msg_name;
if(cljs.core.truth_(pred__32288.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__32289))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__32288.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__32289))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__32280,map__32280__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__,msg_hist,msg_names,msg){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__,msg_hist,msg_names,msg){
return (function (state_32378){
var state_val_32379 = (state_32378[(1)]);
if((state_val_32379 === (7))){
var inst_32298 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32298)){
var statearr_32380_32427 = state_32378__$1;
(statearr_32380_32427[(1)] = (8));

} else {
var statearr_32381_32428 = state_32378__$1;
(statearr_32381_32428[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (20))){
var inst_32372 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32382_32429 = state_32378__$1;
(statearr_32382_32429[(2)] = inst_32372);

(statearr_32382_32429[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (27))){
var inst_32368 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32383_32430 = state_32378__$1;
(statearr_32383_32430[(2)] = inst_32368);

(statearr_32383_32430[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (1))){
var inst_32291 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32291)){
var statearr_32384_32431 = state_32378__$1;
(statearr_32384_32431[(1)] = (2));

} else {
var statearr_32385_32432 = state_32378__$1;
(statearr_32385_32432[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (24))){
var inst_32370 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32386_32433 = state_32378__$1;
(statearr_32386_32433[(2)] = inst_32370);

(statearr_32386_32433[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (4))){
var inst_32376 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32378__$1,inst_32376);
} else {
if((state_val_32379 === (15))){
var inst_32374 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32387_32434 = state_32378__$1;
(statearr_32387_32434[(2)] = inst_32374);

(statearr_32387_32434[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (21))){
var inst_32327 = (state_32378[(2)]);
var inst_32328 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32329 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32328);
var state_32378__$1 = (function (){var statearr_32388 = state_32378;
(statearr_32388[(7)] = inst_32327);

return statearr_32388;
})();
var statearr_32389_32435 = state_32378__$1;
(statearr_32389_32435[(2)] = inst_32329);

(statearr_32389_32435[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (31))){
var inst_32357 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32357)){
var statearr_32390_32436 = state_32378__$1;
(statearr_32390_32436[(1)] = (34));

} else {
var statearr_32391_32437 = state_32378__$1;
(statearr_32391_32437[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (32))){
var inst_32366 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32392_32438 = state_32378__$1;
(statearr_32392_32438[(2)] = inst_32366);

(statearr_32392_32438[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (33))){
var inst_32353 = (state_32378[(2)]);
var inst_32354 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32355 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32354);
var state_32378__$1 = (function (){var statearr_32393 = state_32378;
(statearr_32393[(8)] = inst_32353);

return statearr_32393;
})();
var statearr_32394_32439 = state_32378__$1;
(statearr_32394_32439[(2)] = inst_32355);

(statearr_32394_32439[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (13))){
var inst_32312 = figwheel.client.heads_up.clear.call(null);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(16),inst_32312);
} else {
if((state_val_32379 === (22))){
var inst_32333 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32334 = figwheel.client.heads_up.append_warning_message.call(null,inst_32333);
var state_32378__$1 = state_32378;
var statearr_32395_32440 = state_32378__$1;
(statearr_32395_32440[(2)] = inst_32334);

(statearr_32395_32440[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (36))){
var inst_32364 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32396_32441 = state_32378__$1;
(statearr_32396_32441[(2)] = inst_32364);

(statearr_32396_32441[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (29))){
var inst_32344 = (state_32378[(2)]);
var inst_32345 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32346 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32345);
var state_32378__$1 = (function (){var statearr_32397 = state_32378;
(statearr_32397[(9)] = inst_32344);

return statearr_32397;
})();
var statearr_32398_32442 = state_32378__$1;
(statearr_32398_32442[(2)] = inst_32346);

(statearr_32398_32442[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (6))){
var inst_32293 = (state_32378[(10)]);
var state_32378__$1 = state_32378;
var statearr_32399_32443 = state_32378__$1;
(statearr_32399_32443[(2)] = inst_32293);

(statearr_32399_32443[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (28))){
var inst_32340 = (state_32378[(2)]);
var inst_32341 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32342 = figwheel.client.heads_up.display_warning.call(null,inst_32341);
var state_32378__$1 = (function (){var statearr_32400 = state_32378;
(statearr_32400[(11)] = inst_32340);

return statearr_32400;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(29),inst_32342);
} else {
if((state_val_32379 === (25))){
var inst_32338 = figwheel.client.heads_up.clear.call(null);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(28),inst_32338);
} else {
if((state_val_32379 === (34))){
var inst_32359 = figwheel.client.heads_up.flash_loaded.call(null);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(37),inst_32359);
} else {
if((state_val_32379 === (17))){
var inst_32318 = (state_32378[(2)]);
var inst_32319 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32320 = figwheel.client.auto_jump_to_error.call(null,opts,inst_32319);
var state_32378__$1 = (function (){var statearr_32401 = state_32378;
(statearr_32401[(12)] = inst_32318);

return statearr_32401;
})();
var statearr_32402_32444 = state_32378__$1;
(statearr_32402_32444[(2)] = inst_32320);

(statearr_32402_32444[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (3))){
var inst_32310 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32310)){
var statearr_32403_32445 = state_32378__$1;
(statearr_32403_32445[(1)] = (13));

} else {
var statearr_32404_32446 = state_32378__$1;
(statearr_32404_32446[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (12))){
var inst_32306 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32405_32447 = state_32378__$1;
(statearr_32405_32447[(2)] = inst_32306);

(statearr_32405_32447[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (2))){
var inst_32293 = (state_32378[(10)]);
var inst_32293__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_32378__$1 = (function (){var statearr_32406 = state_32378;
(statearr_32406[(10)] = inst_32293__$1);

return statearr_32406;
})();
if(cljs.core.truth_(inst_32293__$1)){
var statearr_32407_32448 = state_32378__$1;
(statearr_32407_32448[(1)] = (5));

} else {
var statearr_32408_32449 = state_32378__$1;
(statearr_32408_32449[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (23))){
var inst_32336 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32336)){
var statearr_32409_32450 = state_32378__$1;
(statearr_32409_32450[(1)] = (25));

} else {
var statearr_32410_32451 = state_32378__$1;
(statearr_32410_32451[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (35))){
var state_32378__$1 = state_32378;
var statearr_32411_32452 = state_32378__$1;
(statearr_32411_32452[(2)] = null);

(statearr_32411_32452[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (19))){
var inst_32331 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32331)){
var statearr_32412_32453 = state_32378__$1;
(statearr_32412_32453[(1)] = (22));

} else {
var statearr_32413_32454 = state_32378__$1;
(statearr_32413_32454[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (11))){
var inst_32302 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32414_32455 = state_32378__$1;
(statearr_32414_32455[(2)] = inst_32302);

(statearr_32414_32455[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (9))){
var inst_32304 = figwheel.client.heads_up.clear.call(null);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(12),inst_32304);
} else {
if((state_val_32379 === (5))){
var inst_32295 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_32378__$1 = state_32378;
var statearr_32415_32456 = state_32378__$1;
(statearr_32415_32456[(2)] = inst_32295);

(statearr_32415_32456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (14))){
var inst_32322 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32322)){
var statearr_32416_32457 = state_32378__$1;
(statearr_32416_32457[(1)] = (18));

} else {
var statearr_32417_32458 = state_32378__$1;
(statearr_32417_32458[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (26))){
var inst_32348 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_32378__$1 = state_32378;
if(cljs.core.truth_(inst_32348)){
var statearr_32418_32459 = state_32378__$1;
(statearr_32418_32459[(1)] = (30));

} else {
var statearr_32419_32460 = state_32378__$1;
(statearr_32419_32460[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (16))){
var inst_32314 = (state_32378[(2)]);
var inst_32315 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32316 = figwheel.client.heads_up.display_exception.call(null,inst_32315);
var state_32378__$1 = (function (){var statearr_32420 = state_32378;
(statearr_32420[(13)] = inst_32314);

return statearr_32420;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(17),inst_32316);
} else {
if((state_val_32379 === (30))){
var inst_32350 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32351 = figwheel.client.heads_up.display_warning.call(null,inst_32350);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(33),inst_32351);
} else {
if((state_val_32379 === (10))){
var inst_32308 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32421_32461 = state_32378__$1;
(statearr_32421_32461[(2)] = inst_32308);

(statearr_32421_32461[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (18))){
var inst_32324 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_32325 = figwheel.client.heads_up.display_exception.call(null,inst_32324);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(21),inst_32325);
} else {
if((state_val_32379 === (37))){
var inst_32361 = (state_32378[(2)]);
var state_32378__$1 = state_32378;
var statearr_32422_32462 = state_32378__$1;
(statearr_32422_32462[(2)] = inst_32361);

(statearr_32422_32462[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32379 === (8))){
var inst_32300 = figwheel.client.heads_up.flash_loaded.call(null);
var state_32378__$1 = state_32378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32378__$1,(11),inst_32300);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__25331__auto__,c__25422__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto____0 = (function (){
var statearr_32423 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32423[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto__);

(statearr_32423[(1)] = (1));

return statearr_32423;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto____1 = (function (state_32378){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_32378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e32424){if((e32424 instanceof Object)){
var ex__25335__auto__ = e32424;
var statearr_32425_32463 = state_32378;
(statearr_32425_32463[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32378);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32424;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32464 = state_32378;
state_32378 = G__32464;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto__ = function(state_32378){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto____1.call(this,state_32378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__,msg_hist,msg_names,msg))
})();
var state__25424__auto__ = (function (){var statearr_32426 = f__25423__auto__.call(null);
(statearr_32426[(6)] = c__25422__auto__);

return statearr_32426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__,msg_hist,msg_names,msg))
);

return c__25422__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__25422__auto___32493 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___32493,ch){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___32493,ch){
return (function (state_32479){
var state_val_32480 = (state_32479[(1)]);
if((state_val_32480 === (1))){
var state_32479__$1 = state_32479;
var statearr_32481_32494 = state_32479__$1;
(statearr_32481_32494[(2)] = null);

(statearr_32481_32494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32480 === (2))){
var state_32479__$1 = state_32479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32479__$1,(4),ch);
} else {
if((state_val_32480 === (3))){
var inst_32477 = (state_32479[(2)]);
var state_32479__$1 = state_32479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32479__$1,inst_32477);
} else {
if((state_val_32480 === (4))){
var inst_32467 = (state_32479[(7)]);
var inst_32467__$1 = (state_32479[(2)]);
var state_32479__$1 = (function (){var statearr_32482 = state_32479;
(statearr_32482[(7)] = inst_32467__$1);

return statearr_32482;
})();
if(cljs.core.truth_(inst_32467__$1)){
var statearr_32483_32495 = state_32479__$1;
(statearr_32483_32495[(1)] = (5));

} else {
var statearr_32484_32496 = state_32479__$1;
(statearr_32484_32496[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32480 === (5))){
var inst_32467 = (state_32479[(7)]);
var inst_32469 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_32467);
var state_32479__$1 = state_32479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32479__$1,(8),inst_32469);
} else {
if((state_val_32480 === (6))){
var state_32479__$1 = state_32479;
var statearr_32485_32497 = state_32479__$1;
(statearr_32485_32497[(2)] = null);

(statearr_32485_32497[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32480 === (7))){
var inst_32475 = (state_32479[(2)]);
var state_32479__$1 = state_32479;
var statearr_32486_32498 = state_32479__$1;
(statearr_32486_32498[(2)] = inst_32475);

(statearr_32486_32498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32480 === (8))){
var inst_32471 = (state_32479[(2)]);
var state_32479__$1 = (function (){var statearr_32487 = state_32479;
(statearr_32487[(8)] = inst_32471);

return statearr_32487;
})();
var statearr_32488_32499 = state_32479__$1;
(statearr_32488_32499[(2)] = null);

(statearr_32488_32499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__25422__auto___32493,ch))
;
return ((function (switch__25331__auto__,c__25422__auto___32493,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__25332__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__25332__auto____0 = (function (){
var statearr_32489 = [null,null,null,null,null,null,null,null,null];
(statearr_32489[(0)] = figwheel$client$heads_up_plugin_$_state_machine__25332__auto__);

(statearr_32489[(1)] = (1));

return statearr_32489;
});
var figwheel$client$heads_up_plugin_$_state_machine__25332__auto____1 = (function (state_32479){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_32479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e32490){if((e32490 instanceof Object)){
var ex__25335__auto__ = e32490;
var statearr_32491_32500 = state_32479;
(statearr_32491_32500[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32479);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32490;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32501 = state_32479;
state_32479 = G__32501;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__25332__auto__ = function(state_32479){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__25332__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__25332__auto____1.call(this,state_32479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__25332__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__25332__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___32493,ch))
})();
var state__25424__auto__ = (function (){var statearr_32492 = f__25423__auto__.call(null);
(statearr_32492[(6)] = c__25422__auto___32493);

return statearr_32492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___32493,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__){
return (function (state_32507){
var state_val_32508 = (state_32507[(1)]);
if((state_val_32508 === (1))){
var inst_32502 = cljs.core.async.timeout.call(null,(3000));
var state_32507__$1 = state_32507;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32507__$1,(2),inst_32502);
} else {
if((state_val_32508 === (2))){
var inst_32504 = (state_32507[(2)]);
var inst_32505 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_32507__$1 = (function (){var statearr_32509 = state_32507;
(statearr_32509[(7)] = inst_32504);

return statearr_32509;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32507__$1,inst_32505);
} else {
return null;
}
}
});})(c__25422__auto__))
;
return ((function (switch__25331__auto__,c__25422__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__25332__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__25332__auto____0 = (function (){
var statearr_32510 = [null,null,null,null,null,null,null,null];
(statearr_32510[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__25332__auto__);

(statearr_32510[(1)] = (1));

return statearr_32510;
});
var figwheel$client$enforce_project_plugin_$_state_machine__25332__auto____1 = (function (state_32507){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_32507);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e32511){if((e32511 instanceof Object)){
var ex__25335__auto__ = e32511;
var statearr_32512_32514 = state_32507;
(statearr_32512_32514[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32507);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32511;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32515 = state_32507;
state_32507 = G__32515;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__25332__auto__ = function(state_32507){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__25332__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__25332__auto____1.call(this,state_32507);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__25332__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__25332__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__))
})();
var state__25424__auto__ = (function (){var statearr_32513 = f__25423__auto__.call(null);
(statearr_32513[(6)] = c__25422__auto__);

return statearr_32513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__))
);

return c__25422__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__5457__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__5457__auto__)){
var figwheel_version = temp__5457__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__,figwheel_version,temp__5457__auto__){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__,figwheel_version,temp__5457__auto__){
return (function (state_32522){
var state_val_32523 = (state_32522[(1)]);
if((state_val_32523 === (1))){
var inst_32516 = cljs.core.async.timeout.call(null,(2000));
var state_32522__$1 = state_32522;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32522__$1,(2),inst_32516);
} else {
if((state_val_32523 === (2))){
var inst_32518 = (state_32522[(2)]);
var inst_32519 = ["Figwheel Client Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),"</strong> is not equal to ","Figwheel Sidecar Version <strong>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),"</strong>",".  Shutting down Websocket Connection!","<h4>To fix try:</h4>","<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>","<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>","<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>"].join('');
var inst_32520 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_32519);
var state_32522__$1 = (function (){var statearr_32524 = state_32522;
(statearr_32524[(7)] = inst_32518);

return statearr_32524;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32522__$1,inst_32520);
} else {
return null;
}
}
});})(c__25422__auto__,figwheel_version,temp__5457__auto__))
;
return ((function (switch__25331__auto__,c__25422__auto__,figwheel_version,temp__5457__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto____0 = (function (){
var statearr_32525 = [null,null,null,null,null,null,null,null];
(statearr_32525[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto__);

(statearr_32525[(1)] = (1));

return statearr_32525;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto____1 = (function (state_32522){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_32522);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e32526){if((e32526 instanceof Object)){
var ex__25335__auto__ = e32526;
var statearr_32527_32529 = state_32522;
(statearr_32527_32529[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32522);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32526;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32530 = state_32522;
state_32522 = G__32530;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto__ = function(state_32522){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto____1.call(this,state_32522);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__,figwheel_version,temp__5457__auto__))
})();
var state__25424__auto__ = (function (){var statearr_32528 = f__25423__auto__.call(null);
(statearr_32528[(6)] = c__25422__auto__);

return statearr_32528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__,figwheel_version,temp__5457__auto__))
);

return c__25422__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__32531){
var map__32532 = p__32531;
var map__32532__$1 = ((((!((map__32532 == null)))?(((((map__32532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32532.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32532):map__32532);
var file = cljs.core.get.call(null,map__32532__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__32532__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__32532__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__32534 = "";
var G__32534__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32534),"file ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__32534);
var G__32534__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32534__$1)," at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__32534__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = line;
if(cljs.core.truth_(and__3938__auto__)){
return column;
} else {
return and__3938__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32534__$2),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__32534__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__32535){
var map__32536 = p__32535;
var map__32536__$1 = ((((!((map__32536 == null)))?(((((map__32536.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32536.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32536):map__32536);
var ed = map__32536__$1;
var formatted_exception = cljs.core.get.call(null,map__32536__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__32536__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__32536__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__32538_32542 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__32539_32543 = null;
var count__32540_32544 = (0);
var i__32541_32545 = (0);
while(true){
if((i__32541_32545 < count__32540_32544)){
var msg_32546 = cljs.core._nth.call(null,chunk__32539_32543,i__32541_32545);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_32546);


var G__32547 = seq__32538_32542;
var G__32548 = chunk__32539_32543;
var G__32549 = count__32540_32544;
var G__32550 = (i__32541_32545 + (1));
seq__32538_32542 = G__32547;
chunk__32539_32543 = G__32548;
count__32540_32544 = G__32549;
i__32541_32545 = G__32550;
continue;
} else {
var temp__5457__auto___32551 = cljs.core.seq.call(null,seq__32538_32542);
if(temp__5457__auto___32551){
var seq__32538_32552__$1 = temp__5457__auto___32551;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32538_32552__$1)){
var c__4351__auto___32553 = cljs.core.chunk_first.call(null,seq__32538_32552__$1);
var G__32554 = cljs.core.chunk_rest.call(null,seq__32538_32552__$1);
var G__32555 = c__4351__auto___32553;
var G__32556 = cljs.core.count.call(null,c__4351__auto___32553);
var G__32557 = (0);
seq__32538_32542 = G__32554;
chunk__32539_32543 = G__32555;
count__32540_32544 = G__32556;
i__32541_32545 = G__32557;
continue;
} else {
var msg_32558 = cljs.core.first.call(null,seq__32538_32552__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_32558);


var G__32559 = cljs.core.next.call(null,seq__32538_32552__$1);
var G__32560 = null;
var G__32561 = (0);
var G__32562 = (0);
seq__32538_32542 = G__32559;
chunk__32539_32543 = G__32560;
count__32540_32544 = G__32561;
i__32541_32545 = G__32562;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),["Error on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__32563){
var map__32564 = p__32563;
var map__32564__$1 = ((((!((map__32564 == null)))?(((((map__32564.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32564.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32564):map__32564);
var w = map__32564__$1;
var message = cljs.core.get.call(null,map__32564__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),["Figwheel: Compile Warning - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message))," in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.config_defaults !== 'undefined')){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/rui-demo/public/js/compiled/demo/out/figwheel/client.cljs",33,1,361,361,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/rui-demo/public/js/compiled/demo/out/figwheel/client.cljs",30,1,353,353,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,["ws://",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),"/figwheel-ws"].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__3938__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__3938__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__3938__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_json_message_watch = (function figwheel$client$add_json_message_watch(key,callback){
return figwheel.client.add_message_watch.call(null,key,cljs.core.comp.call(null,callback,cljs.core.clj__GT_js));
});
goog.exportSymbol('figwheel.client.add_json_message_watch', figwheel.client.add_json_message_watch);
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__32566 = cljs.core.seq.call(null,plugins);
var chunk__32567 = null;
var count__32568 = (0);
var i__32569 = (0);
while(true){
if((i__32569 < count__32568)){
var vec__32570 = cljs.core._nth.call(null,chunk__32567,i__32569);
var k = cljs.core.nth.call(null,vec__32570,(0),null);
var plugin = cljs.core.nth.call(null,vec__32570,(1),null);
if(cljs.core.truth_(plugin)){
var pl_32576 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__32566,chunk__32567,count__32568,i__32569,pl_32576,vec__32570,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_32576.call(null,msg_hist);
});})(seq__32566,chunk__32567,count__32568,i__32569,pl_32576,vec__32570,k,plugin))
);
} else {
}


var G__32577 = seq__32566;
var G__32578 = chunk__32567;
var G__32579 = count__32568;
var G__32580 = (i__32569 + (1));
seq__32566 = G__32577;
chunk__32567 = G__32578;
count__32568 = G__32579;
i__32569 = G__32580;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__32566);
if(temp__5457__auto__){
var seq__32566__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32566__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__32566__$1);
var G__32581 = cljs.core.chunk_rest.call(null,seq__32566__$1);
var G__32582 = c__4351__auto__;
var G__32583 = cljs.core.count.call(null,c__4351__auto__);
var G__32584 = (0);
seq__32566 = G__32581;
chunk__32567 = G__32582;
count__32568 = G__32583;
i__32569 = G__32584;
continue;
} else {
var vec__32573 = cljs.core.first.call(null,seq__32566__$1);
var k = cljs.core.nth.call(null,vec__32573,(0),null);
var plugin = cljs.core.nth.call(null,vec__32573,(1),null);
if(cljs.core.truth_(plugin)){
var pl_32585 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__32566,chunk__32567,count__32568,i__32569,pl_32585,vec__32573,k,plugin,seq__32566__$1,temp__5457__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_32585.call(null,msg_hist);
});})(seq__32566,chunk__32567,count__32568,i__32569,pl_32585,vec__32573,k,plugin,seq__32566__$1,temp__5457__auto__))
);
} else {
}


var G__32586 = cljs.core.next.call(null,seq__32566__$1);
var G__32587 = null;
var G__32588 = (0);
var G__32589 = (0);
seq__32566 = G__32586;
chunk__32567 = G__32587;
count__32568 = G__32588;
i__32569 = G__32589;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var G__32591 = arguments.length;
switch (G__32591) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if((typeof figwheel !== 'undefined') && (typeof figwheel.client !== 'undefined') && (typeof figwheel.client.__figwheel_start_once__ !== 'undefined')){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__32592_32597 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__32593_32598 = null;
var count__32594_32599 = (0);
var i__32595_32600 = (0);
while(true){
if((i__32595_32600 < count__32594_32599)){
var msg_32601 = cljs.core._nth.call(null,chunk__32593_32598,i__32595_32600);
figwheel.client.socket.handle_incoming_message.call(null,msg_32601);


var G__32602 = seq__32592_32597;
var G__32603 = chunk__32593_32598;
var G__32604 = count__32594_32599;
var G__32605 = (i__32595_32600 + (1));
seq__32592_32597 = G__32602;
chunk__32593_32598 = G__32603;
count__32594_32599 = G__32604;
i__32595_32600 = G__32605;
continue;
} else {
var temp__5457__auto___32606 = cljs.core.seq.call(null,seq__32592_32597);
if(temp__5457__auto___32606){
var seq__32592_32607__$1 = temp__5457__auto___32606;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__32592_32607__$1)){
var c__4351__auto___32608 = cljs.core.chunk_first.call(null,seq__32592_32607__$1);
var G__32609 = cljs.core.chunk_rest.call(null,seq__32592_32607__$1);
var G__32610 = c__4351__auto___32608;
var G__32611 = cljs.core.count.call(null,c__4351__auto___32608);
var G__32612 = (0);
seq__32592_32597 = G__32609;
chunk__32593_32598 = G__32610;
count__32594_32599 = G__32611;
i__32595_32600 = G__32612;
continue;
} else {
var msg_32613 = cljs.core.first.call(null,seq__32592_32607__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_32613);


var G__32614 = cljs.core.next.call(null,seq__32592_32607__$1);
var G__32615 = null;
var G__32616 = (0);
var G__32617 = (0);
seq__32592_32597 = G__32614;
chunk__32593_32598 = G__32615;
count__32594_32599 = G__32616;
i__32595_32600 = G__32617;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__4534__auto__ = [];
var len__4531__auto___32622 = arguments.length;
var i__4532__auto___32623 = (0);
while(true){
if((i__4532__auto___32623 < len__4531__auto___32622)){
args__4534__auto__.push((arguments[i__4532__auto___32623]));

var G__32624 = (i__4532__auto___32623 + (1));
i__4532__auto___32623 = G__32624;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__32619){
var map__32620 = p__32619;
var map__32620__$1 = ((((!((map__32620 == null)))?(((((map__32620.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32620.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32620):map__32620);
var opts = map__32620__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq32618){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq32618));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e32625){if((e32625 instanceof Error)){
var e = e32625;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e32625;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__32626){
var map__32627 = p__32626;
var map__32627__$1 = ((((!((map__32627 == null)))?(((((map__32627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32627.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32627):map__32627);
var msg_name = cljs.core.get.call(null,map__32627__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1533629729548
