// Compiled by ClojureScript 1.10.339 {}
goog.provide('rui.forms.components');
goog.require('cljs.core');
goog.require('goog.string.format');
goog.require('goog.string');
goog.require('ccn.core');
goog.require('re_frame.core');
goog.require('rui.buttons');
goog.require('rui.forms.core');
goog.require('rui.forms.events');
rui.forms.components.default_required_mark = " *";
rui.forms.components.field__GT_twbs_class = (function rui$forms$components$field__GT_twbs_class(field){
var G__30135 = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(field);
var G__30135__$1 = (((G__30135 instanceof cljs.core.Keyword))?G__30135.fqn:null);
switch (G__30135__$1) {
case "initial":
return null;

break;
case "invalid":
return "is-invalid";

break;
case "valid":
return "is-valid";

break;
default:
return null;

}
});
rui.forms.components.form_errors = (function rui$forms$components$form_errors(messages){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-errors.invalid-feedback","div.form-errors.invalid-feedback",-104610415),(function (){var iter__4324__auto__ = (function rui$forms$components$form_errors_$_iter__30137(s__30138){
return (new cljs.core.LazySeq(null,(function (){
var s__30138__$1 = s__30138;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__30138__$1);
if(temp__5457__auto__){
var s__30138__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__30138__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__30138__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__30140 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__30139 = (0);
while(true){
if((i__30139 < size__4323__auto__)){
var vec__30141 = cljs.core._nth.call(null,c__4322__auto__,i__30139);
var message = cljs.core.nth.call(null,vec__30141,(0),null);
var i = cljs.core.nth.call(null,vec__30141,(1),null);
cljs.core.chunk_append.call(null,b__30140,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),goog.string.format("%s-%s",message,i)], null)));

var G__30147 = (i__30139 + (1));
i__30139 = G__30147;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30140),rui$forms$components$form_errors_$_iter__30137.call(null,cljs.core.chunk_rest.call(null,s__30138__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30140),null);
}
} else {
var vec__30144 = cljs.core.first.call(null,s__30138__$2);
var message = cljs.core.nth.call(null,vec__30144,(0),null);
var i = cljs.core.nth.call(null,vec__30144,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.bem.call(null,"form-errors","error",cljs.core.PersistentVector.EMPTY)], null),message], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),goog.string.format("%s-%s",message,i)], null)),rui$forms$components$form_errors_$_iter__30137.call(null,cljs.core.rest.call(null,s__30138__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4324__auto__.call(null,cljs.core.zipmap.call(null,messages,cljs.core.range.call(null)));
})()], null);
});
rui.forms.components.can_show_errors_QMARK_ = (function rui$forms$components$can_show_errors_QMARK_(field,errors){
return ((cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"initial","initial",1854648214),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(field))) && (cljs.core.seq.call(null,errors)));
});
/**
 * Bare radio input that renders just a div with an input type radio and label. Don't use it directly.
 */
rui.forms.components.radio_input_element = (function rui$forms$components$radio_input_element(p__30148){
var map__30149 = p__30148;
var map__30149__$1 = ((((!((map__30149 == null)))?(((((map__30149.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30149.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30149):map__30149);
var form = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var field_id = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"field-id","field-id",-353751335));
var choice = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"choice","choice",-1375170727));
var disabled_QMARK_ = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var on_change = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var checked_QMARK_ = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"checked?","checked?",2024809091));
var field = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var modifiers = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var label = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var id = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var radio_name = cljs.core.get.call(null,map__30149__$1,new cljs.core.Keyword(null,"radio-name","radio-name",771897205));
var chosen_value_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check",(cljs.core.truth_(disabled_QMARK_)?"disabled":null),ccn.core.bem.call(null,"radio",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [((chosen_value_QMARK_)?rui.forms.core.field_state.call(null,form,field_id):null)], null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check-input",((chosen_value_QMARK_)?rui.forms.components.field__GT_twbs_class.call(null,field):null)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),radio_name,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice),new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK_], null)], null),label], null);
});
/**
 * Radio input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `choices` a all possible values of the radio, a sequence of maps with `:label` and `:value` keys
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `component-class-name` a string that is added to 'form-group' Bootstrap element
 * - `renderer` a custom radio renderer, Reagent component that accepts a hashmap with following keys:
 *    id, field, radio-name, choice, on-change, checked?, disabled?, label, modifiers, form, field-id, input-el
 * - `on-change` a custom handler that is called after the original on-change handler
 *   - `required-mark` a valid Hiccup what will be shown when a field is required
 */
rui.forms.components.radio = (function rui$forms$components$radio(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30162 = arguments.length;
var i__4532__auto___30163 = (0);
while(true){
if((i__4532__auto___30163 < len__4531__auto___30162)){
args__4534__auto__.push((arguments[i__4532__auto___30163]));

var G__30164 = (i__4532__auto___30163 + (1));
i__4532__auto___30163 = G__30164;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.radio.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,choices,p__30155){
var map__30156 = p__30155;
var map__30156__$1 = ((((!((map__30156 == null)))?(((((map__30156.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30156.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30156):map__30156);
var modifiers = cljs.core.get.call(null,map__30156__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var component_class_name = cljs.core.get.call(null,map__30156__$1,new cljs.core.Keyword(null,"component-class-name","component-class-name",1044506625));
var renderer = cljs.core.get.call(null,map__30156__$1,new cljs.core.Keyword(null,"renderer","renderer",336841071));
var on_change = cljs.core.get.call(null,map__30156__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__30156__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,errors,map__30156,map__30156__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

event.preventDefault();

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,errors,map__30156,map__30156__$1,modifiers,component_class_name,renderer,on_change,required_mark))
;
var radio_name = rui.forms.core.gen_field_id.call(null,form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group","radio",component_class_name)], null),(function (){var iter__4324__auto__ = ((function (field,errors,on_change_internal,radio_name,map__30156,map__30156__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function rui$forms$components$iter__30158(s__30159){
return (new cljs.core.LazySeq(null,((function (field,errors,on_change_internal,radio_name,map__30156,map__30156__$1,modifiers,component_class_name,renderer,on_change,required_mark){
return (function (){
var s__30159__$1 = s__30159;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__30159__$1);
if(temp__5457__auto__){
var s__30159__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__30159__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__30159__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__30161 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__30160 = (0);
while(true){
if((i__30160 < size__4323__auto__)){
var choice = cljs.core._nth.call(null,c__4322__auto__,i__30160);
cljs.core.chunk_append.call(null,b__30161,(function (){var id = rui.forms.core.gen_field_id.call(null,form,cljs.core.name.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181).cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))) || ((((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)) && (new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label",new cljs.core.Keyword(null,"for","for",-1323786319),id], null),new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(choice),(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"checked?","checked?",2024809091),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"radio-name","radio-name",771897205),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"field-id","field-id",-353751335),new cljs.core.Keyword(null,"choice","choice",-1375170727),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181)],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.call(null,on_change_internal,(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),(cljs.core.truth_(renderer)?null:label)], null))], null);
if(!((renderer == null))){
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-el","input-el",1688931956),input_el], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta.call(null,input_el,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})());

var G__30165 = (i__30160 + (1));
i__30160 = G__30165;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30161),rui$forms$components$iter__30158.call(null,cljs.core.chunk_rest.call(null,s__30159__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30161),null);
}
} else {
var choice = cljs.core.first.call(null,s__30159__$2);
return cljs.core.cons.call(null,(function (){var id = rui.forms.core.gen_field_id.call(null,form,cljs.core.name.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,field_id)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))].join(''))].join('')));
var disabled_QMARK_ = new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181).cljs$core$IFn$_invoke$arity$1(choice) === true;
var checked_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice))) || ((((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)) && (new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(choice) === true))));
var label = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label",new cljs.core.Keyword(null,"for","for",-1323786319),id], null),new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(choice),(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null);
var input_opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"checked?","checked?",2024809091),new cljs.core.Keyword(null,"field","field",-1302436500),new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"radio-name","radio-name",771897205),new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.Keyword(null,"field-id","field-id",-353751335),new cljs.core.Keyword(null,"choice","choice",-1375170727),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181)],[checked_QMARK_,field,modifiers,id,radio_name,form,field_id,choice,cljs.core.partial.call(null,on_change_internal,(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice) instanceof cljs.core.Keyword)),disabled_QMARK_]);
var input_el = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.radio_input_element,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"label","label",1718410804),(cljs.core.truth_(renderer)?null:label)], null))], null);
if(!((renderer == null))){
return cljs.core.with_meta.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [renderer,cljs.core.merge.call(null,input_opts,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input-el","input-el",1688931956),input_el], null))], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
} else {
return cljs.core.with_meta.call(null,input_el,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(choice)], null));
}
})(),rui$forms$components$iter__30158.call(null,cljs.core.rest.call(null,s__30159__$2)));
}
} else {
return null;
}
break;
}
});})(field,errors,on_change_internal,radio_name,map__30156,map__30156__$1,modifiers,component_class_name,renderer,on_change,required_mark))
,null,null));
});})(field,errors,on_change_internal,radio_name,map__30156,map__30156__$1,modifiers,component_class_name,renderer,on_change,required_mark))
;
return iter__4324__auto__.call(null,choices);
})(),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)], null);
});

rui.forms.components.radio.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.radio.cljs$lang$applyTo = (function (seq30151){
var G__30152 = cljs.core.first.call(null,seq30151);
var seq30151__$1 = cljs.core.next.call(null,seq30151);
var G__30153 = cljs.core.first.call(null,seq30151__$1);
var seq30151__$2 = cljs.core.next.call(null,seq30151__$1);
var G__30154 = cljs.core.first.call(null,seq30151__$2);
var seq30151__$3 = cljs.core.next.call(null,seq30151__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30152,G__30153,G__30154,seq30151__$3);
});

rui.forms.components.checkbox = (function rui$forms$components$checkbox(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30173 = arguments.length;
var i__4532__auto___30174 = (0);
while(true){
if((i__4532__auto___30174 < len__4531__auto___30173)){
args__4534__auto__.push((arguments[i__4532__auto___30174]));

var G__30175 = (i__4532__auto___30174 + (1));
i__4532__auto___30174 = G__30175;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.checkbox.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__30170){
var map__30171 = p__30170;
var map__30171__$1 = ((((!((map__30171 == null)))?(((((map__30171.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30171.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30171):map__30171);
var children = cljs.core.get.call(null,map__30171__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.call(null,map__30171__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30171__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var on_change = cljs.core.get.call(null,map__30171__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__30171__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var active_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,active_QMARK_,errors,map__30171,map__30171__$1,children,modifiers,attrs,on_change,required_mark){
return (function (event){
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("rui::forms","forms-input-changed","rui::forms/forms-input-changed",-943107654),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(form),field_id,event.target.checked], null));

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,active_QMARK_,errors,map__30171,map__30171__$1,children,modifiers,attrs,on_change,required_mark))
;
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check","form-group",ccn.core.bem.call(null,"checkbox",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state.call(null,form,field_id)], null))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-check-input",rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"checked","checked",-50955819),active_QMARK_], null),attrs)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-check-label"], null),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null)], null),cljs.core.conj.call(null,children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.checkbox.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.checkbox.cljs$lang$applyTo = (function (seq30166){
var G__30167 = cljs.core.first.call(null,seq30166);
var seq30166__$1 = cljs.core.next.call(null,seq30166);
var G__30168 = cljs.core.first.call(null,seq30166__$1);
var seq30166__$2 = cljs.core.next.call(null,seq30166__$1);
var G__30169 = cljs.core.first.call(null,seq30166__$2);
var seq30166__$3 = cljs.core.next.call(null,seq30166__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30167,G__30168,G__30169,seq30166__$3);
});

rui.forms.components.select = (function rui$forms$components$select(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30194 = arguments.length;
var i__4532__auto___30195 = (0);
while(true){
if((i__4532__auto___30195 < len__4531__auto___30194)){
args__4534__auto__.push((arguments[i__4532__auto___30195]));

var G__30196 = (i__4532__auto___30195 + (1));
i__4532__auto___30195 = G__30196;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.select.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,value_label_pairs,p__30181){
var map__30182 = p__30181;
var map__30182__$1 = ((((!((map__30182 == null)))?(((((map__30182.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30182.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30182):map__30182);
var children = cljs.core.get.call(null,map__30182__$1,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.PersistentVector.EMPTY);
var modifiers = cljs.core.get.call(null,map__30182__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30182__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__30182__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__30182__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var on_change = cljs.core.get.call(null,map__30182__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__30182__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var field = field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form));
var active_QMARK_ = !((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null));
var errors = field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form));
var on_change_internal = ((function (field,active_QMARK_,errors,map__30182,map__30182__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function (was_keyword_QMARK_,event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,(cljs.core.truth_(was_keyword_QMARK_)?cljs.core.keyword:cljs.core.identity),event);

rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(field,active_QMARK_,errors,map__30182,map__30182__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
;
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"select",cljs.core.concat.call(null,modifiers,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((active_QMARK_)?"active":null),rui.forms.core.field_state.call(null,form,field_id)], null))))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,on_change_internal,cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,cljs.core.map.call(null,cljs.core.first,value_label_pairs))),new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field))], null),attrs,((!((new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field) == null)))?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default-value","default-value",232220170),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field)], null):null)),(function (){var iter__4324__auto__ = ((function (field,active_QMARK_,errors,on_change_internal,id,map__30182,map__30182__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function rui$forms$components$iter__30184(s__30185){
return (new cljs.core.LazySeq(null,((function (field,active_QMARK_,errors,on_change_internal,id,map__30182,map__30182__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark){
return (function (){
var s__30185__$1 = s__30185;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__30185__$1);
if(temp__5457__auto__){
var s__30185__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__30185__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__30185__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__30187 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__30186 = (0);
while(true){
if((i__30186 < size__4323__auto__)){
var vec__30188 = cljs.core._nth.call(null,c__4322__auto__,i__30186);
var value = cljs.core.nth.call(null,vec__30188,(0),null);
var label__$1 = cljs.core.nth.call(null,vec__30188,(1),null);
cljs.core.chunk_append.call(null,b__30187,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)));

var G__30197 = (i__30186 + (1));
i__30186 = G__30197;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30187),rui$forms$components$iter__30184.call(null,cljs.core.chunk_rest.call(null,s__30185__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__30187),null);
}
} else {
var vec__30191 = cljs.core.first.call(null,s__30185__$2);
var value = cljs.core.nth.call(null,vec__30191,(0),null);
var label__$1 = cljs.core.nth.call(null,vec__30191,(1),null);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null),label__$1], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),value], null)),rui$forms$components$iter__30184.call(null,cljs.core.rest.call(null,s__30185__$2)));
}
} else {
return null;
}
break;
}
});})(field,active_QMARK_,errors,on_change_internal,id,map__30182,map__30182__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
,null,null));
});})(field,active_QMARK_,errors,on_change_internal,id,map__30182,map__30182__$1,children,modifiers,attrs,label_attrs,twbs_modifiers,on_change,required_mark))
;
return iter__4324__auto__.call(null,value_label_pairs);
})()], null)], null),cljs.core.conj.call(null,children,(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field,errors))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,errors], null):null)));
});

rui.forms.components.select.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.select.cljs$lang$applyTo = (function (seq30176){
var G__30177 = cljs.core.first.call(null,seq30176);
var seq30176__$1 = cljs.core.next.call(null,seq30176);
var G__30178 = cljs.core.first.call(null,seq30176__$1);
var seq30176__$2 = cljs.core.next.call(null,seq30176__$1);
var G__30179 = cljs.core.first.call(null,seq30176__$2);
var seq30176__$3 = cljs.core.next.call(null,seq30176__$2);
var G__30180 = cljs.core.first.call(null,seq30176__$3);
var seq30176__$4 = cljs.core.next.call(null,seq30176__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30177,G__30178,G__30179,G__30180,seq30176__$4);
});

/**
 * Input field with all functionalities like: updating value, showing an error, ...
 * Required parameters:
 * - `input-type` a string like: 'text', 'number', ...
 * - `form` a form from the state
 * - `field-id` field is as a keyword
 * - `label` a Reagent valid component or string
 * Optional parameters:
 * - `modifiers` a CSS modifiers, a sequence of strings
 * - `attrs` a hashmap of HTML attributes of the input
 * - `label-attrs` a hashmap of HTML attributes for the label
 * - `twbs-modifiers` Twitter Bootstrap modifiers, a sequence of strings
 * - `input-group-append` a Twitter Bootstrap's 'input-group-append', a Reagent component of string
 * - `input-group-prepend` a Twitter Bootstrap's 'input-group-prepend', a Reagent component of string
 * - `on-change` a custom handler that is called after the original on-change handler
 * - `on-blur` a custom handler that is called after the original on-blur handler
 *   - `required-mark` a valid Hiccup what will be shown when a field is required
 */
rui.forms.components.input_field = (function rui$forms$components$input_field(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30206 = arguments.length;
var i__4532__auto___30207 = (0);
while(true){
if((i__4532__auto___30207 < len__4531__auto___30206)){
args__4534__auto__.push((arguments[i__4532__auto___30207]));

var G__30208 = (i__4532__auto___30207 + (1));
i__4532__auto___30207 = G__30208;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((4) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((4)),(0),null)):null);
return rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4535__auto__);
});

rui.forms.components.input_field.cljs$core$IFn$_invoke$arity$variadic = (function (input_type,form,field_id,label,p__30203){
var map__30204 = p__30203;
var map__30204__$1 = ((((!((map__30204 == null)))?(((((map__30204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30204.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30204):map__30204);
var modifiers = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var input_group_append = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"input-group-append","input-group-append",304795856),null);
var input_group_prepend = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"input-group-prepend","input-group-prepend",-1646594811),null);
var on_change = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var on_blur = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var required_mark = cljs.core.get.call(null,map__30204__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__30204,map__30204__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__30204,map__30204__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__30204,map__30204__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__30204,map__30204__$1,modifiers,attrs,label_attrs,twbs_modifiers,input_group_append,input_group_prepend,on_change,on_blur,required_mark))
;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"input-field",cljs.core.name.call(null,field_id),cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_((function (){var or__3949__auto__ = input_group_prepend;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return input_group_append;
}
})())?"input-group":null)], null),((!((input_group_prepend == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-prepend","div.input-group-prepend",-1522435373),((typeof input_group_prepend === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-text","div.input-group-text",-1838140799),input_group_prepend], null):input_group_prepend)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),input_type,new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),((!((input_group_append == null)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-append","div.input-group-append",-1462957134),((typeof input_group_append === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-group-text","div.input-group-text",-1838140799),input_group_append], null):input_group_append)], null):null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null)], null);
});

rui.forms.components.input_field.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
rui.forms.components.input_field.cljs$lang$applyTo = (function (seq30198){
var G__30199 = cljs.core.first.call(null,seq30198);
var seq30198__$1 = cljs.core.next.call(null,seq30198);
var G__30200 = cljs.core.first.call(null,seq30198__$1);
var seq30198__$2 = cljs.core.next.call(null,seq30198__$1);
var G__30201 = cljs.core.first.call(null,seq30198__$2);
var seq30198__$3 = cljs.core.next.call(null,seq30198__$2);
var G__30202 = cljs.core.first.call(null,seq30198__$3);
var seq30198__$4 = cljs.core.next.call(null,seq30198__$3);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30199,G__30200,G__30201,G__30202,seq30198__$4);
});

rui.forms.components.input_text = cljs.core.partial.call(null,rui.forms.components.input_field,"text");
rui.forms.components.input_password = cljs.core.partial.call(null,rui.forms.components.input_field,"password");
rui.forms.components.input_number = cljs.core.partial.call(null,rui.forms.components.input_field,"number");
rui.forms.components.input_email = cljs.core.partial.call(null,rui.forms.components.input_field,"email");
rui.forms.components.input_file = (function rui$forms$components$input_file(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30216 = arguments.length;
var i__4532__auto___30217 = (0);
while(true){
if((i__4532__auto___30217 < len__4531__auto___30216)){
args__4534__auto__.push((arguments[i__4532__auto___30217]));

var G__30218 = (i__4532__auto___30217 + (1));
i__4532__auto___30217 = G__30218;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.input_file.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__30213){
var map__30214 = p__30213;
var map__30214__$1 = ((((!((map__30214 == null)))?(((((map__30214.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30214.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30214):map__30214);
var kwargs = map__30214__$1;
var modifiers = cljs.core.get.call(null,map__30214__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834));
var attrs = cljs.core.get.call(null,map__30214__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var label_attrs = cljs.core.get.call(null,map__30214__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153));
var twbs_modifiers = cljs.core.get.call(null,map__30214__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072));
var on_blur = cljs.core.get.call(null,map__30214__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var on_change = cljs.core.get.call(null,map__30214__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__30214__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__30214,map__30214__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__30214,map__30214__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__30214,map__30214__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__30214,map__30214__$1,kwargs,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"input-field",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.custom-file","div.custom-file",1258230266),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),"file",new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control-file",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null)], null);
});

rui.forms.components.input_file.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.input_file.cljs$lang$applyTo = (function (seq30209){
var G__30210 = cljs.core.first.call(null,seq30209);
var seq30209__$1 = cljs.core.next.call(null,seq30209);
var G__30211 = cljs.core.first.call(null,seq30209__$1);
var seq30209__$2 = cljs.core.next.call(null,seq30209__$1);
var G__30212 = cljs.core.first.call(null,seq30209__$2);
var seq30209__$3 = cljs.core.next.call(null,seq30209__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30210,G__30211,G__30212,seq30209__$3);
});

rui.forms.components.text_area = (function rui$forms$components$text_area(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30226 = arguments.length;
var i__4532__auto___30227 = (0);
while(true){
if((i__4532__auto___30227 < len__4531__auto___30226)){
args__4534__auto__.push((arguments[i__4532__auto___30227]));

var G__30228 = (i__4532__auto___30227 + (1));
i__4532__auto___30227 = G__30228;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.text_area.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__30223){
var map__30224 = p__30223;
var map__30224__$1 = ((((!((map__30224 == null)))?(((((map__30224.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30224.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30224):map__30224);
var modifiers = cljs.core.get.call(null,map__30224__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30224__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__30224__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__30224__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var on_blur = cljs.core.get.call(null,map__30224__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var on_change = cljs.core.get.call(null,map__30224__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var required_mark = cljs.core.get.call(null,map__30224__$1,new cljs.core.Keyword(null,"required-mark","required-mark",978430492),rui.forms.components.default_required_mark);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
var field = cljs.core.get_in.call(null,form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"fields","fields",-1932066230),field_id], null));
var on_change_internal = ((function (id,field,map__30224,map__30224__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_change_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_change)){
return on_change.call(null,event);
} else {
return null;
}
});})(id,field,map__30224,map__30224__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
var on_blur_internal = ((function (id,field,on_change_internal,map__30224,map__30224__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark){
return (function (event){
rui.forms.core.input_on_blur_BANG_.call(null,form,field_id,event);

if(cljs.core.truth_(on_blur)){
return on_blur.call(null,event);
} else {
return null;
}
});})(id,field,on_change_internal,map__30224,map__30224__$1,modifiers,attrs,label_attrs,twbs_modifiers,on_blur,on_change,required_mark))
;
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"text-area",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label,(cljs.core.truth_(new cljs.core.Keyword(null,"required?","required?",-872514462).cljs$core$IFn$_invoke$arity$1(field))?required_mark:null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,ccn.core.twbs.call(null,"form-control",twbs_modifiers),rui.forms.components.field__GT_twbs_class.call(null,field)),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"name","name",1843675177),id,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),label,new cljs.core.Keyword(null,"on-change","on-change",-732046149),on_change_internal,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),on_blur_internal], null),attrs)], null),(cljs.core.truth_(rui.forms.components.can_show_errors_QMARK_.call(null,field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form)),field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.forms.components.form_errors,field_id.call(null,new cljs.core.Keyword(null,"errors","errors",-908790718).cljs$core$IFn$_invoke$arity$1(form))], null):null)], null);
});

rui.forms.components.text_area.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.text_area.cljs$lang$applyTo = (function (seq30219){
var G__30220 = cljs.core.first.call(null,seq30219);
var seq30219__$1 = cljs.core.next.call(null,seq30219);
var G__30221 = cljs.core.first.call(null,seq30219__$1);
var seq30219__$2 = cljs.core.next.call(null,seq30219__$1);
var G__30222 = cljs.core.first.call(null,seq30219__$2);
var seq30219__$3 = cljs.core.next.call(null,seq30219__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30220,G__30221,G__30222,seq30219__$3);
});

rui.forms.components.form_wrapper = (function rui$forms$components$form_wrapper(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30235 = arguments.length;
var i__4532__auto___30236 = (0);
while(true){
if((i__4532__auto___30236 < len__4531__auto___30235)){
args__4534__auto__.push((arguments[i__4532__auto___30236]));

var G__30237 = (i__4532__auto___30236 + (1));
i__4532__auto___30236 = G__30237;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

rui.forms.components.form_wrapper.cljs$core$IFn$_invoke$arity$variadic = (function (p__30232,children){
var map__30233 = p__30232;
var map__30233__$1 = ((((!((map__30233 == null)))?(((((map__30233.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30233.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30233):map__30233);
var kwargs = map__30233__$1;
var on_submit = cljs.core.get.call(null,map__30233__$1,new cljs.core.Keyword(null,"on-submit","on-submit",1227871159));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),"form-wrapper",new cljs.core.Keyword(null,"on-submit","on-submit",1227871159),((function (map__30233,map__30233__$1,kwargs,on_submit){
return (function (p1__30229_SHARP_){
p1__30229_SHARP_.preventDefault();

return on_submit.call(null,p1__30229_SHARP_);
});})(map__30233,map__30233__$1,kwargs,on_submit))
], null)], null),children);
});

rui.forms.components.form_wrapper.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
rui.forms.components.form_wrapper.cljs$lang$applyTo = (function (seq30230){
var G__30231 = cljs.core.first.call(null,seq30230);
var seq30230__$1 = cljs.core.next.call(null,seq30230);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30231,seq30230__$1);
});

rui.forms.components.button_submit = (function rui$forms$components$button_submit(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30244 = arguments.length;
var i__4532__auto___30245 = (0);
while(true){
if((i__4532__auto___30245 < len__4531__auto___30244)){
args__4534__auto__.push((arguments[i__4532__auto___30245]));

var G__30246 = (i__4532__auto___30245 + (1));
i__4532__auto___30245 = G__30246;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((2) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((2)),(0),null)):null);
return rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4535__auto__);
});

rui.forms.components.button_submit.cljs$core$IFn$_invoke$arity$variadic = (function (title,on_click,p__30241){
var map__30242 = p__30241;
var map__30242__$1 = ((((!((map__30242 == null)))?(((((map__30242.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30242.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30242):map__30242);
var kwargs = map__30242__$1;
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rui.buttons.button_primary,title,on_click], null),cljs.core.apply.call(null,cljs.core.concat,cljs.core.merge.call(null,kwargs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"modifiers","modifiers",50378834),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["submit"], null)], null))));
});

rui.forms.components.button_submit.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
rui.forms.components.button_submit.cljs$lang$applyTo = (function (seq30238){
var G__30239 = cljs.core.first.call(null,seq30238);
var seq30238__$1 = cljs.core.next.call(null,seq30238);
var G__30240 = cljs.core.first.call(null,seq30238__$1);
var seq30238__$2 = cljs.core.next.call(null,seq30238__$1);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30239,G__30240,seq30238__$2);
});

rui.forms.components.plaintext = (function rui$forms$components$plaintext(var_args){
var args__4534__auto__ = [];
var len__4531__auto___30254 = arguments.length;
var i__4532__auto___30255 = (0);
while(true){
if((i__4532__auto___30255 < len__4531__auto___30254)){
args__4534__auto__.push((arguments[i__4532__auto___30255]));

var G__30256 = (i__4532__auto___30255 + (1));
i__4532__auto___30255 = G__30256;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

rui.forms.components.plaintext.cljs$core$IFn$_invoke$arity$variadic = (function (form,field_id,label,p__30251){
var map__30252 = p__30251;
var map__30252__$1 = ((((!((map__30252 == null)))?(((((map__30252.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30252.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30252):map__30252);
var modifiers = cljs.core.get.call(null,map__30252__$1,new cljs.core.Keyword(null,"modifiers","modifiers",50378834),cljs.core.PersistentVector.EMPTY);
var attrs = cljs.core.get.call(null,map__30252__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),cljs.core.PersistentArrayMap.EMPTY);
var label_attrs = cljs.core.get.call(null,map__30252__$1,new cljs.core.Keyword(null,"label-attrs","label-attrs",-2077678153),cljs.core.PersistentArrayMap.EMPTY);
var twbs_modifiers = cljs.core.get.call(null,map__30252__$1,new cljs.core.Keyword(null,"twbs-modifiers","twbs-modifiers",374505072),cljs.core.PersistentVector.EMPTY);
var id = rui.forms.core.gen_field_id.call(null,form,field_id);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),ccn.core.css_class.call(null,"form-group",ccn.core.bem.call(null,"plaintext",cljs.core.conj.call(null,modifiers,rui.forms.core.field_state.call(null,form,field_id))))], null),((!((label == null)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"for","for",-1323786319),id,new cljs.core.Keyword(null,"class","class",-2030961996),"form-control-label"], null),label_attrs),label], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),cljs.core.merge.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"read-only","read-only",-191706886),new cljs.core.Keyword(null,"on-change","on-change",-732046149)],[label,id,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(field_id.call(null,new cljs.core.Keyword(null,"fields","fields",-1932066230).cljs$core$IFn$_invoke$arity$1(form))),cljs.core.partial.call(null,rui.forms.core.input_on_blur_BANG_,form,field_id),"text",id,ccn.core.twbs.call(null,"form-control-plaintext",twbs_modifiers),true,cljs.core.partial.call(null,rui.forms.core.input_on_change_BANG_,form,field_id)]),attrs)], null)], null);
});

rui.forms.components.plaintext.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
rui.forms.components.plaintext.cljs$lang$applyTo = (function (seq30247){
var G__30248 = cljs.core.first.call(null,seq30247);
var seq30247__$1 = cljs.core.next.call(null,seq30247);
var G__30249 = cljs.core.first.call(null,seq30247__$1);
var seq30247__$2 = cljs.core.next.call(null,seq30247__$1);
var G__30250 = cljs.core.first.call(null,seq30247__$2);
var seq30247__$3 = cljs.core.next.call(null,seq30247__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30248,G__30249,G__30250,seq30247__$3);
});


//# sourceMappingURL=components.js.map?rel=1559663711164
