// Compiled by ClojureScript 1.10.339 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__25482 = arguments.length;
switch (G__25482) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25483 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25483 = (function (f,blockable,meta25484){
this.f = f;
this.blockable = blockable;
this.meta25484 = meta25484;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25483.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25485,meta25484__$1){
var self__ = this;
var _25485__$1 = this;
return (new cljs.core.async.t_cljs$core$async25483(self__.f,self__.blockable,meta25484__$1));
});

cljs.core.async.t_cljs$core$async25483.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25485){
var self__ = this;
var _25485__$1 = this;
return self__.meta25484;
});

cljs.core.async.t_cljs$core$async25483.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25483.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async25483.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async25483.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async25483.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta25484","meta25484",-140874546,null)], null);
});

cljs.core.async.t_cljs$core$async25483.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25483.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25483";

cljs.core.async.t_cljs$core$async25483.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25483");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25483.
 */
cljs.core.async.__GT_t_cljs$core$async25483 = (function cljs$core$async$__GT_t_cljs$core$async25483(f__$1,blockable__$1,meta25484){
return (new cljs.core.async.t_cljs$core$async25483(f__$1,blockable__$1,meta25484));
});

}

return (new cljs.core.async.t_cljs$core$async25483(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__25489 = arguments.length;
switch (G__25489) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__25492 = arguments.length;
switch (G__25492) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__25495 = arguments.length;
switch (G__25495) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_25497 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_25497);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_25497,ret){
return (function (){
return fn1.call(null,val_25497);
});})(val_25497,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__25499 = arguments.length;
switch (G__25499) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4408__auto___25501 = n;
var x_25502 = (0);
while(true){
if((x_25502 < n__4408__auto___25501)){
(a[x_25502] = (0));

var G__25503 = (x_25502 + (1));
x_25502 = G__25503;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__25504 = (i + (1));
i = G__25504;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25505 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25505 = (function (flag,meta25506){
this.flag = flag;
this.meta25506 = meta25506;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25505.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_25507,meta25506__$1){
var self__ = this;
var _25507__$1 = this;
return (new cljs.core.async.t_cljs$core$async25505(self__.flag,meta25506__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async25505.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_25507){
var self__ = this;
var _25507__$1 = this;
return self__.meta25506;
});})(flag))
;

cljs.core.async.t_cljs$core$async25505.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25505.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async25505.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async25505.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async25505.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta25506","meta25506",1055485884,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async25505.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25505.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25505";

cljs.core.async.t_cljs$core$async25505.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25505");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25505.
 */
cljs.core.async.__GT_t_cljs$core$async25505 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async25505(flag__$1,meta25506){
return (new cljs.core.async.t_cljs$core$async25505(flag__$1,meta25506));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async25505(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async25508 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25508 = (function (flag,cb,meta25509){
this.flag = flag;
this.cb = cb;
this.meta25509 = meta25509;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25508.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25510,meta25509__$1){
var self__ = this;
var _25510__$1 = this;
return (new cljs.core.async.t_cljs$core$async25508(self__.flag,self__.cb,meta25509__$1));
});

cljs.core.async.t_cljs$core$async25508.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25510){
var self__ = this;
var _25510__$1 = this;
return self__.meta25509;
});

cljs.core.async.t_cljs$core$async25508.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25508.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async25508.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async25508.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async25508.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta25509","meta25509",-2089799041,null)], null);
});

cljs.core.async.t_cljs$core$async25508.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25508.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25508";

cljs.core.async.t_cljs$core$async25508.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async25508");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async25508.
 */
cljs.core.async.__GT_t_cljs$core$async25508 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async25508(flag__$1,cb__$1,meta25509){
return (new cljs.core.async.t_cljs$core$async25508(flag__$1,cb__$1,meta25509));
});

}

return (new cljs.core.async.t_cljs$core$async25508(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25511_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25511_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25512_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25512_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3949__auto__ = wport;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return port;
}
})()], null));
} else {
var G__25513 = (i + (1));
i = G__25513;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3949__auto__ = ret;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3938__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3938__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___25519 = arguments.length;
var i__4532__auto___25520 = (0);
while(true){
if((i__4532__auto___25520 < len__4531__auto___25519)){
args__4534__auto__.push((arguments[i__4532__auto___25520]));

var G__25521 = (i__4532__auto___25520 + (1));
i__4532__auto___25520 = G__25521;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((1) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4535__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__25516){
var map__25517 = p__25516;
var map__25517__$1 = ((((!((map__25517 == null)))?(((((map__25517.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25517.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25517):map__25517);
var opts = map__25517__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq25514){
var G__25515 = cljs.core.first.call(null,seq25514);
var seq25514__$1 = cljs.core.next.call(null,seq25514);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__25515,seq25514__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__25523 = arguments.length;
switch (G__25523) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__25422__auto___25569 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___25569){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___25569){
return (function (state_25547){
var state_val_25548 = (state_25547[(1)]);
if((state_val_25548 === (7))){
var inst_25543 = (state_25547[(2)]);
var state_25547__$1 = state_25547;
var statearr_25549_25570 = state_25547__$1;
(statearr_25549_25570[(2)] = inst_25543);

(statearr_25549_25570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (1))){
var state_25547__$1 = state_25547;
var statearr_25550_25571 = state_25547__$1;
(statearr_25550_25571[(2)] = null);

(statearr_25550_25571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (4))){
var inst_25526 = (state_25547[(7)]);
var inst_25526__$1 = (state_25547[(2)]);
var inst_25527 = (inst_25526__$1 == null);
var state_25547__$1 = (function (){var statearr_25551 = state_25547;
(statearr_25551[(7)] = inst_25526__$1);

return statearr_25551;
})();
if(cljs.core.truth_(inst_25527)){
var statearr_25552_25572 = state_25547__$1;
(statearr_25552_25572[(1)] = (5));

} else {
var statearr_25553_25573 = state_25547__$1;
(statearr_25553_25573[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (13))){
var state_25547__$1 = state_25547;
var statearr_25554_25574 = state_25547__$1;
(statearr_25554_25574[(2)] = null);

(statearr_25554_25574[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (6))){
var inst_25526 = (state_25547[(7)]);
var state_25547__$1 = state_25547;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25547__$1,(11),to,inst_25526);
} else {
if((state_val_25548 === (3))){
var inst_25545 = (state_25547[(2)]);
var state_25547__$1 = state_25547;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25547__$1,inst_25545);
} else {
if((state_val_25548 === (12))){
var state_25547__$1 = state_25547;
var statearr_25555_25575 = state_25547__$1;
(statearr_25555_25575[(2)] = null);

(statearr_25555_25575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (2))){
var state_25547__$1 = state_25547;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25547__$1,(4),from);
} else {
if((state_val_25548 === (11))){
var inst_25536 = (state_25547[(2)]);
var state_25547__$1 = state_25547;
if(cljs.core.truth_(inst_25536)){
var statearr_25556_25576 = state_25547__$1;
(statearr_25556_25576[(1)] = (12));

} else {
var statearr_25557_25577 = state_25547__$1;
(statearr_25557_25577[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (9))){
var state_25547__$1 = state_25547;
var statearr_25558_25578 = state_25547__$1;
(statearr_25558_25578[(2)] = null);

(statearr_25558_25578[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (5))){
var state_25547__$1 = state_25547;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25559_25579 = state_25547__$1;
(statearr_25559_25579[(1)] = (8));

} else {
var statearr_25560_25580 = state_25547__$1;
(statearr_25560_25580[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (14))){
var inst_25541 = (state_25547[(2)]);
var state_25547__$1 = state_25547;
var statearr_25561_25581 = state_25547__$1;
(statearr_25561_25581[(2)] = inst_25541);

(statearr_25561_25581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (10))){
var inst_25533 = (state_25547[(2)]);
var state_25547__$1 = state_25547;
var statearr_25562_25582 = state_25547__$1;
(statearr_25562_25582[(2)] = inst_25533);

(statearr_25562_25582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25548 === (8))){
var inst_25530 = cljs.core.async.close_BANG_.call(null,to);
var state_25547__$1 = state_25547;
var statearr_25563_25583 = state_25547__$1;
(statearr_25563_25583[(2)] = inst_25530);

(statearr_25563_25583[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___25569))
;
return ((function (switch__25331__auto__,c__25422__auto___25569){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_25564 = [null,null,null,null,null,null,null,null];
(statearr_25564[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_25564[(1)] = (1));

return statearr_25564;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_25547){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25547);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25565){if((e25565 instanceof Object)){
var ex__25335__auto__ = e25565;
var statearr_25566_25584 = state_25547;
(statearr_25566_25584[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25547);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25565;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25585 = state_25547;
state_25547 = G__25585;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_25547){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_25547);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___25569))
})();
var state__25424__auto__ = (function (){var statearr_25567 = f__25423__auto__.call(null);
(statearr_25567[(6)] = c__25422__auto___25569);

return statearr_25567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___25569))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__25586){
var vec__25587 = p__25586;
var v = cljs.core.nth.call(null,vec__25587,(0),null);
var p = cljs.core.nth.call(null,vec__25587,(1),null);
var job = vec__25587;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__25422__auto___25758 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___25758,res,vec__25587,v,p,job,jobs,results){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___25758,res,vec__25587,v,p,job,jobs,results){
return (function (state_25594){
var state_val_25595 = (state_25594[(1)]);
if((state_val_25595 === (1))){
var state_25594__$1 = state_25594;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25594__$1,(2),res,v);
} else {
if((state_val_25595 === (2))){
var inst_25591 = (state_25594[(2)]);
var inst_25592 = cljs.core.async.close_BANG_.call(null,res);
var state_25594__$1 = (function (){var statearr_25596 = state_25594;
(statearr_25596[(7)] = inst_25591);

return statearr_25596;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25594__$1,inst_25592);
} else {
return null;
}
}
});})(c__25422__auto___25758,res,vec__25587,v,p,job,jobs,results))
;
return ((function (switch__25331__auto__,c__25422__auto___25758,res,vec__25587,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0 = (function (){
var statearr_25597 = [null,null,null,null,null,null,null,null];
(statearr_25597[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__);

(statearr_25597[(1)] = (1));

return statearr_25597;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1 = (function (state_25594){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25594);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25598){if((e25598 instanceof Object)){
var ex__25335__auto__ = e25598;
var statearr_25599_25759 = state_25594;
(statearr_25599_25759[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25594);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25598;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25760 = state_25594;
state_25594 = G__25760;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = function(state_25594){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1.call(this,state_25594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___25758,res,vec__25587,v,p,job,jobs,results))
})();
var state__25424__auto__ = (function (){var statearr_25600 = f__25423__auto__.call(null);
(statearr_25600[(6)] = c__25422__auto___25758);

return statearr_25600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___25758,res,vec__25587,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__25601){
var vec__25602 = p__25601;
var v = cljs.core.nth.call(null,vec__25602,(0),null);
var p = cljs.core.nth.call(null,vec__25602,(1),null);
var job = vec__25602;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4408__auto___25761 = n;
var __25762 = (0);
while(true){
if((__25762 < n__4408__auto___25761)){
var G__25605_25763 = type;
var G__25605_25764__$1 = (((G__25605_25763 instanceof cljs.core.Keyword))?G__25605_25763.fqn:null);
switch (G__25605_25764__$1) {
case "compute":
var c__25422__auto___25766 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__25762,c__25422__auto___25766,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (__25762,c__25422__auto___25766,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async){
return (function (state_25618){
var state_val_25619 = (state_25618[(1)]);
if((state_val_25619 === (1))){
var state_25618__$1 = state_25618;
var statearr_25620_25767 = state_25618__$1;
(statearr_25620_25767[(2)] = null);

(statearr_25620_25767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25619 === (2))){
var state_25618__$1 = state_25618;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25618__$1,(4),jobs);
} else {
if((state_val_25619 === (3))){
var inst_25616 = (state_25618[(2)]);
var state_25618__$1 = state_25618;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25618__$1,inst_25616);
} else {
if((state_val_25619 === (4))){
var inst_25608 = (state_25618[(2)]);
var inst_25609 = process.call(null,inst_25608);
var state_25618__$1 = state_25618;
if(cljs.core.truth_(inst_25609)){
var statearr_25621_25768 = state_25618__$1;
(statearr_25621_25768[(1)] = (5));

} else {
var statearr_25622_25769 = state_25618__$1;
(statearr_25622_25769[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25619 === (5))){
var state_25618__$1 = state_25618;
var statearr_25623_25770 = state_25618__$1;
(statearr_25623_25770[(2)] = null);

(statearr_25623_25770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25619 === (6))){
var state_25618__$1 = state_25618;
var statearr_25624_25771 = state_25618__$1;
(statearr_25624_25771[(2)] = null);

(statearr_25624_25771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25619 === (7))){
var inst_25614 = (state_25618[(2)]);
var state_25618__$1 = state_25618;
var statearr_25625_25772 = state_25618__$1;
(statearr_25625_25772[(2)] = inst_25614);

(statearr_25625_25772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__25762,c__25422__auto___25766,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async))
;
return ((function (__25762,switch__25331__auto__,c__25422__auto___25766,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0 = (function (){
var statearr_25626 = [null,null,null,null,null,null,null];
(statearr_25626[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__);

(statearr_25626[(1)] = (1));

return statearr_25626;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1 = (function (state_25618){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25618);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25627){if((e25627 instanceof Object)){
var ex__25335__auto__ = e25627;
var statearr_25628_25773 = state_25618;
(statearr_25628_25773[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25618);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25774 = state_25618;
state_25618 = G__25774;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = function(state_25618){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1.call(this,state_25618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__;
})()
;})(__25762,switch__25331__auto__,c__25422__auto___25766,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async))
})();
var state__25424__auto__ = (function (){var statearr_25629 = f__25423__auto__.call(null);
(statearr_25629[(6)] = c__25422__auto___25766);

return statearr_25629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(__25762,c__25422__auto___25766,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async))
);


break;
case "async":
var c__25422__auto___25775 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__25762,c__25422__auto___25775,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (__25762,c__25422__auto___25775,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async){
return (function (state_25642){
var state_val_25643 = (state_25642[(1)]);
if((state_val_25643 === (1))){
var state_25642__$1 = state_25642;
var statearr_25644_25776 = state_25642__$1;
(statearr_25644_25776[(2)] = null);

(statearr_25644_25776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25643 === (2))){
var state_25642__$1 = state_25642;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25642__$1,(4),jobs);
} else {
if((state_val_25643 === (3))){
var inst_25640 = (state_25642[(2)]);
var state_25642__$1 = state_25642;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25642__$1,inst_25640);
} else {
if((state_val_25643 === (4))){
var inst_25632 = (state_25642[(2)]);
var inst_25633 = async.call(null,inst_25632);
var state_25642__$1 = state_25642;
if(cljs.core.truth_(inst_25633)){
var statearr_25645_25777 = state_25642__$1;
(statearr_25645_25777[(1)] = (5));

} else {
var statearr_25646_25778 = state_25642__$1;
(statearr_25646_25778[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25643 === (5))){
var state_25642__$1 = state_25642;
var statearr_25647_25779 = state_25642__$1;
(statearr_25647_25779[(2)] = null);

(statearr_25647_25779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25643 === (6))){
var state_25642__$1 = state_25642;
var statearr_25648_25780 = state_25642__$1;
(statearr_25648_25780[(2)] = null);

(statearr_25648_25780[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25643 === (7))){
var inst_25638 = (state_25642[(2)]);
var state_25642__$1 = state_25642;
var statearr_25649_25781 = state_25642__$1;
(statearr_25649_25781[(2)] = inst_25638);

(statearr_25649_25781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__25762,c__25422__auto___25775,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async))
;
return ((function (__25762,switch__25331__auto__,c__25422__auto___25775,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0 = (function (){
var statearr_25650 = [null,null,null,null,null,null,null];
(statearr_25650[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__);

(statearr_25650[(1)] = (1));

return statearr_25650;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1 = (function (state_25642){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25642);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25651){if((e25651 instanceof Object)){
var ex__25335__auto__ = e25651;
var statearr_25652_25782 = state_25642;
(statearr_25652_25782[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25642);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25651;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25783 = state_25642;
state_25642 = G__25783;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = function(state_25642){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1.call(this,state_25642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__;
})()
;})(__25762,switch__25331__auto__,c__25422__auto___25775,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async))
})();
var state__25424__auto__ = (function (){var statearr_25653 = f__25423__auto__.call(null);
(statearr_25653[(6)] = c__25422__auto___25775);

return statearr_25653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(__25762,c__25422__auto___25775,G__25605_25763,G__25605_25764__$1,n__4408__auto___25761,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25605_25764__$1)].join('')));

}

var G__25784 = (__25762 + (1));
__25762 = G__25784;
continue;
} else {
}
break;
}

var c__25422__auto___25785 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___25785,jobs,results,process,async){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___25785,jobs,results,process,async){
return (function (state_25675){
var state_val_25676 = (state_25675[(1)]);
if((state_val_25676 === (1))){
var state_25675__$1 = state_25675;
var statearr_25677_25786 = state_25675__$1;
(statearr_25677_25786[(2)] = null);

(statearr_25677_25786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25676 === (2))){
var state_25675__$1 = state_25675;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25675__$1,(4),from);
} else {
if((state_val_25676 === (3))){
var inst_25673 = (state_25675[(2)]);
var state_25675__$1 = state_25675;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25675__$1,inst_25673);
} else {
if((state_val_25676 === (4))){
var inst_25656 = (state_25675[(7)]);
var inst_25656__$1 = (state_25675[(2)]);
var inst_25657 = (inst_25656__$1 == null);
var state_25675__$1 = (function (){var statearr_25678 = state_25675;
(statearr_25678[(7)] = inst_25656__$1);

return statearr_25678;
})();
if(cljs.core.truth_(inst_25657)){
var statearr_25679_25787 = state_25675__$1;
(statearr_25679_25787[(1)] = (5));

} else {
var statearr_25680_25788 = state_25675__$1;
(statearr_25680_25788[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25676 === (5))){
var inst_25659 = cljs.core.async.close_BANG_.call(null,jobs);
var state_25675__$1 = state_25675;
var statearr_25681_25789 = state_25675__$1;
(statearr_25681_25789[(2)] = inst_25659);

(statearr_25681_25789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25676 === (6))){
var inst_25661 = (state_25675[(8)]);
var inst_25656 = (state_25675[(7)]);
var inst_25661__$1 = cljs.core.async.chan.call(null,(1));
var inst_25662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25663 = [inst_25656,inst_25661__$1];
var inst_25664 = (new cljs.core.PersistentVector(null,2,(5),inst_25662,inst_25663,null));
var state_25675__$1 = (function (){var statearr_25682 = state_25675;
(statearr_25682[(8)] = inst_25661__$1);

return statearr_25682;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25675__$1,(8),jobs,inst_25664);
} else {
if((state_val_25676 === (7))){
var inst_25671 = (state_25675[(2)]);
var state_25675__$1 = state_25675;
var statearr_25683_25790 = state_25675__$1;
(statearr_25683_25790[(2)] = inst_25671);

(statearr_25683_25790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25676 === (8))){
var inst_25661 = (state_25675[(8)]);
var inst_25666 = (state_25675[(2)]);
var state_25675__$1 = (function (){var statearr_25684 = state_25675;
(statearr_25684[(9)] = inst_25666);

return statearr_25684;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25675__$1,(9),results,inst_25661);
} else {
if((state_val_25676 === (9))){
var inst_25668 = (state_25675[(2)]);
var state_25675__$1 = (function (){var statearr_25685 = state_25675;
(statearr_25685[(10)] = inst_25668);

return statearr_25685;
})();
var statearr_25686_25791 = state_25675__$1;
(statearr_25686_25791[(2)] = null);

(statearr_25686_25791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___25785,jobs,results,process,async))
;
return ((function (switch__25331__auto__,c__25422__auto___25785,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0 = (function (){
var statearr_25687 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25687[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__);

(statearr_25687[(1)] = (1));

return statearr_25687;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1 = (function (state_25675){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25675);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25688){if((e25688 instanceof Object)){
var ex__25335__auto__ = e25688;
var statearr_25689_25792 = state_25675;
(statearr_25689_25792[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25675);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25688;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25793 = state_25675;
state_25675 = G__25793;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = function(state_25675){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1.call(this,state_25675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___25785,jobs,results,process,async))
})();
var state__25424__auto__ = (function (){var statearr_25690 = f__25423__auto__.call(null);
(statearr_25690[(6)] = c__25422__auto___25785);

return statearr_25690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___25785,jobs,results,process,async))
);


var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__,jobs,results,process,async){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__,jobs,results,process,async){
return (function (state_25728){
var state_val_25729 = (state_25728[(1)]);
if((state_val_25729 === (7))){
var inst_25724 = (state_25728[(2)]);
var state_25728__$1 = state_25728;
var statearr_25730_25794 = state_25728__$1;
(statearr_25730_25794[(2)] = inst_25724);

(statearr_25730_25794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (20))){
var state_25728__$1 = state_25728;
var statearr_25731_25795 = state_25728__$1;
(statearr_25731_25795[(2)] = null);

(statearr_25731_25795[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (1))){
var state_25728__$1 = state_25728;
var statearr_25732_25796 = state_25728__$1;
(statearr_25732_25796[(2)] = null);

(statearr_25732_25796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (4))){
var inst_25693 = (state_25728[(7)]);
var inst_25693__$1 = (state_25728[(2)]);
var inst_25694 = (inst_25693__$1 == null);
var state_25728__$1 = (function (){var statearr_25733 = state_25728;
(statearr_25733[(7)] = inst_25693__$1);

return statearr_25733;
})();
if(cljs.core.truth_(inst_25694)){
var statearr_25734_25797 = state_25728__$1;
(statearr_25734_25797[(1)] = (5));

} else {
var statearr_25735_25798 = state_25728__$1;
(statearr_25735_25798[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (15))){
var inst_25706 = (state_25728[(8)]);
var state_25728__$1 = state_25728;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25728__$1,(18),to,inst_25706);
} else {
if((state_val_25729 === (21))){
var inst_25719 = (state_25728[(2)]);
var state_25728__$1 = state_25728;
var statearr_25736_25799 = state_25728__$1;
(statearr_25736_25799[(2)] = inst_25719);

(statearr_25736_25799[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (13))){
var inst_25721 = (state_25728[(2)]);
var state_25728__$1 = (function (){var statearr_25737 = state_25728;
(statearr_25737[(9)] = inst_25721);

return statearr_25737;
})();
var statearr_25738_25800 = state_25728__$1;
(statearr_25738_25800[(2)] = null);

(statearr_25738_25800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (6))){
var inst_25693 = (state_25728[(7)]);
var state_25728__$1 = state_25728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25728__$1,(11),inst_25693);
} else {
if((state_val_25729 === (17))){
var inst_25714 = (state_25728[(2)]);
var state_25728__$1 = state_25728;
if(cljs.core.truth_(inst_25714)){
var statearr_25739_25801 = state_25728__$1;
(statearr_25739_25801[(1)] = (19));

} else {
var statearr_25740_25802 = state_25728__$1;
(statearr_25740_25802[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (3))){
var inst_25726 = (state_25728[(2)]);
var state_25728__$1 = state_25728;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25728__$1,inst_25726);
} else {
if((state_val_25729 === (12))){
var inst_25703 = (state_25728[(10)]);
var state_25728__$1 = state_25728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25728__$1,(14),inst_25703);
} else {
if((state_val_25729 === (2))){
var state_25728__$1 = state_25728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25728__$1,(4),results);
} else {
if((state_val_25729 === (19))){
var state_25728__$1 = state_25728;
var statearr_25741_25803 = state_25728__$1;
(statearr_25741_25803[(2)] = null);

(statearr_25741_25803[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (11))){
var inst_25703 = (state_25728[(2)]);
var state_25728__$1 = (function (){var statearr_25742 = state_25728;
(statearr_25742[(10)] = inst_25703);

return statearr_25742;
})();
var statearr_25743_25804 = state_25728__$1;
(statearr_25743_25804[(2)] = null);

(statearr_25743_25804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (9))){
var state_25728__$1 = state_25728;
var statearr_25744_25805 = state_25728__$1;
(statearr_25744_25805[(2)] = null);

(statearr_25744_25805[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (5))){
var state_25728__$1 = state_25728;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25745_25806 = state_25728__$1;
(statearr_25745_25806[(1)] = (8));

} else {
var statearr_25746_25807 = state_25728__$1;
(statearr_25746_25807[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (14))){
var inst_25708 = (state_25728[(11)]);
var inst_25706 = (state_25728[(8)]);
var inst_25706__$1 = (state_25728[(2)]);
var inst_25707 = (inst_25706__$1 == null);
var inst_25708__$1 = cljs.core.not.call(null,inst_25707);
var state_25728__$1 = (function (){var statearr_25747 = state_25728;
(statearr_25747[(11)] = inst_25708__$1);

(statearr_25747[(8)] = inst_25706__$1);

return statearr_25747;
})();
if(inst_25708__$1){
var statearr_25748_25808 = state_25728__$1;
(statearr_25748_25808[(1)] = (15));

} else {
var statearr_25749_25809 = state_25728__$1;
(statearr_25749_25809[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (16))){
var inst_25708 = (state_25728[(11)]);
var state_25728__$1 = state_25728;
var statearr_25750_25810 = state_25728__$1;
(statearr_25750_25810[(2)] = inst_25708);

(statearr_25750_25810[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (10))){
var inst_25700 = (state_25728[(2)]);
var state_25728__$1 = state_25728;
var statearr_25751_25811 = state_25728__$1;
(statearr_25751_25811[(2)] = inst_25700);

(statearr_25751_25811[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (18))){
var inst_25711 = (state_25728[(2)]);
var state_25728__$1 = state_25728;
var statearr_25752_25812 = state_25728__$1;
(statearr_25752_25812[(2)] = inst_25711);

(statearr_25752_25812[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25729 === (8))){
var inst_25697 = cljs.core.async.close_BANG_.call(null,to);
var state_25728__$1 = state_25728;
var statearr_25753_25813 = state_25728__$1;
(statearr_25753_25813[(2)] = inst_25697);

(statearr_25753_25813[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto__,jobs,results,process,async))
;
return ((function (switch__25331__auto__,c__25422__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0 = (function (){
var statearr_25754 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25754[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__);

(statearr_25754[(1)] = (1));

return statearr_25754;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1 = (function (state_25728){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25755){if((e25755 instanceof Object)){
var ex__25335__auto__ = e25755;
var statearr_25756_25814 = state_25728;
(statearr_25756_25814[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25728);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25755;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25815 = state_25728;
state_25728 = G__25815;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__ = function(state_25728){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1.call(this,state_25728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25332__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__,jobs,results,process,async))
})();
var state__25424__auto__ = (function (){var statearr_25757 = f__25423__auto__.call(null);
(statearr_25757[(6)] = c__25422__auto__);

return statearr_25757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__,jobs,results,process,async))
);

return c__25422__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__25817 = arguments.length;
switch (G__25817) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__25820 = arguments.length;
switch (G__25820) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__25823 = arguments.length;
switch (G__25823) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__25422__auto___25872 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___25872,tc,fc){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___25872,tc,fc){
return (function (state_25849){
var state_val_25850 = (state_25849[(1)]);
if((state_val_25850 === (7))){
var inst_25845 = (state_25849[(2)]);
var state_25849__$1 = state_25849;
var statearr_25851_25873 = state_25849__$1;
(statearr_25851_25873[(2)] = inst_25845);

(statearr_25851_25873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (1))){
var state_25849__$1 = state_25849;
var statearr_25852_25874 = state_25849__$1;
(statearr_25852_25874[(2)] = null);

(statearr_25852_25874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (4))){
var inst_25826 = (state_25849[(7)]);
var inst_25826__$1 = (state_25849[(2)]);
var inst_25827 = (inst_25826__$1 == null);
var state_25849__$1 = (function (){var statearr_25853 = state_25849;
(statearr_25853[(7)] = inst_25826__$1);

return statearr_25853;
})();
if(cljs.core.truth_(inst_25827)){
var statearr_25854_25875 = state_25849__$1;
(statearr_25854_25875[(1)] = (5));

} else {
var statearr_25855_25876 = state_25849__$1;
(statearr_25855_25876[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (13))){
var state_25849__$1 = state_25849;
var statearr_25856_25877 = state_25849__$1;
(statearr_25856_25877[(2)] = null);

(statearr_25856_25877[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (6))){
var inst_25826 = (state_25849[(7)]);
var inst_25832 = p.call(null,inst_25826);
var state_25849__$1 = state_25849;
if(cljs.core.truth_(inst_25832)){
var statearr_25857_25878 = state_25849__$1;
(statearr_25857_25878[(1)] = (9));

} else {
var statearr_25858_25879 = state_25849__$1;
(statearr_25858_25879[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (3))){
var inst_25847 = (state_25849[(2)]);
var state_25849__$1 = state_25849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25849__$1,inst_25847);
} else {
if((state_val_25850 === (12))){
var state_25849__$1 = state_25849;
var statearr_25859_25880 = state_25849__$1;
(statearr_25859_25880[(2)] = null);

(statearr_25859_25880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (2))){
var state_25849__$1 = state_25849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25849__$1,(4),ch);
} else {
if((state_val_25850 === (11))){
var inst_25826 = (state_25849[(7)]);
var inst_25836 = (state_25849[(2)]);
var state_25849__$1 = state_25849;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25849__$1,(8),inst_25836,inst_25826);
} else {
if((state_val_25850 === (9))){
var state_25849__$1 = state_25849;
var statearr_25860_25881 = state_25849__$1;
(statearr_25860_25881[(2)] = tc);

(statearr_25860_25881[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (5))){
var inst_25829 = cljs.core.async.close_BANG_.call(null,tc);
var inst_25830 = cljs.core.async.close_BANG_.call(null,fc);
var state_25849__$1 = (function (){var statearr_25861 = state_25849;
(statearr_25861[(8)] = inst_25829);

return statearr_25861;
})();
var statearr_25862_25882 = state_25849__$1;
(statearr_25862_25882[(2)] = inst_25830);

(statearr_25862_25882[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (14))){
var inst_25843 = (state_25849[(2)]);
var state_25849__$1 = state_25849;
var statearr_25863_25883 = state_25849__$1;
(statearr_25863_25883[(2)] = inst_25843);

(statearr_25863_25883[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (10))){
var state_25849__$1 = state_25849;
var statearr_25864_25884 = state_25849__$1;
(statearr_25864_25884[(2)] = fc);

(statearr_25864_25884[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25850 === (8))){
var inst_25838 = (state_25849[(2)]);
var state_25849__$1 = state_25849;
if(cljs.core.truth_(inst_25838)){
var statearr_25865_25885 = state_25849__$1;
(statearr_25865_25885[(1)] = (12));

} else {
var statearr_25866_25886 = state_25849__$1;
(statearr_25866_25886[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___25872,tc,fc))
;
return ((function (switch__25331__auto__,c__25422__auto___25872,tc,fc){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_25867 = [null,null,null,null,null,null,null,null,null];
(statearr_25867[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_25867[(1)] = (1));

return statearr_25867;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_25849){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25868){if((e25868 instanceof Object)){
var ex__25335__auto__ = e25868;
var statearr_25869_25887 = state_25849;
(statearr_25869_25887[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25849);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25868;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25888 = state_25849;
state_25849 = G__25888;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_25849){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_25849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___25872,tc,fc))
})();
var state__25424__auto__ = (function (){var statearr_25870 = f__25423__auto__.call(null);
(statearr_25870[(6)] = c__25422__auto___25872);

return statearr_25870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___25872,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__){
return (function (state_25909){
var state_val_25910 = (state_25909[(1)]);
if((state_val_25910 === (7))){
var inst_25905 = (state_25909[(2)]);
var state_25909__$1 = state_25909;
var statearr_25911_25929 = state_25909__$1;
(statearr_25911_25929[(2)] = inst_25905);

(statearr_25911_25929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (1))){
var inst_25889 = init;
var state_25909__$1 = (function (){var statearr_25912 = state_25909;
(statearr_25912[(7)] = inst_25889);

return statearr_25912;
})();
var statearr_25913_25930 = state_25909__$1;
(statearr_25913_25930[(2)] = null);

(statearr_25913_25930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (4))){
var inst_25892 = (state_25909[(8)]);
var inst_25892__$1 = (state_25909[(2)]);
var inst_25893 = (inst_25892__$1 == null);
var state_25909__$1 = (function (){var statearr_25914 = state_25909;
(statearr_25914[(8)] = inst_25892__$1);

return statearr_25914;
})();
if(cljs.core.truth_(inst_25893)){
var statearr_25915_25931 = state_25909__$1;
(statearr_25915_25931[(1)] = (5));

} else {
var statearr_25916_25932 = state_25909__$1;
(statearr_25916_25932[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (6))){
var inst_25889 = (state_25909[(7)]);
var inst_25892 = (state_25909[(8)]);
var inst_25896 = (state_25909[(9)]);
var inst_25896__$1 = f.call(null,inst_25889,inst_25892);
var inst_25897 = cljs.core.reduced_QMARK_.call(null,inst_25896__$1);
var state_25909__$1 = (function (){var statearr_25917 = state_25909;
(statearr_25917[(9)] = inst_25896__$1);

return statearr_25917;
})();
if(inst_25897){
var statearr_25918_25933 = state_25909__$1;
(statearr_25918_25933[(1)] = (8));

} else {
var statearr_25919_25934 = state_25909__$1;
(statearr_25919_25934[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (3))){
var inst_25907 = (state_25909[(2)]);
var state_25909__$1 = state_25909;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25909__$1,inst_25907);
} else {
if((state_val_25910 === (2))){
var state_25909__$1 = state_25909;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25909__$1,(4),ch);
} else {
if((state_val_25910 === (9))){
var inst_25896 = (state_25909[(9)]);
var inst_25889 = inst_25896;
var state_25909__$1 = (function (){var statearr_25920 = state_25909;
(statearr_25920[(7)] = inst_25889);

return statearr_25920;
})();
var statearr_25921_25935 = state_25909__$1;
(statearr_25921_25935[(2)] = null);

(statearr_25921_25935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (5))){
var inst_25889 = (state_25909[(7)]);
var state_25909__$1 = state_25909;
var statearr_25922_25936 = state_25909__$1;
(statearr_25922_25936[(2)] = inst_25889);

(statearr_25922_25936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (10))){
var inst_25903 = (state_25909[(2)]);
var state_25909__$1 = state_25909;
var statearr_25923_25937 = state_25909__$1;
(statearr_25923_25937[(2)] = inst_25903);

(statearr_25923_25937[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25910 === (8))){
var inst_25896 = (state_25909[(9)]);
var inst_25899 = cljs.core.deref.call(null,inst_25896);
var state_25909__$1 = state_25909;
var statearr_25924_25938 = state_25909__$1;
(statearr_25924_25938[(2)] = inst_25899);

(statearr_25924_25938[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto__))
;
return ((function (switch__25331__auto__,c__25422__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__25332__auto__ = null;
var cljs$core$async$reduce_$_state_machine__25332__auto____0 = (function (){
var statearr_25925 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25925[(0)] = cljs$core$async$reduce_$_state_machine__25332__auto__);

(statearr_25925[(1)] = (1));

return statearr_25925;
});
var cljs$core$async$reduce_$_state_machine__25332__auto____1 = (function (state_25909){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25909);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25926){if((e25926 instanceof Object)){
var ex__25335__auto__ = e25926;
var statearr_25927_25939 = state_25909;
(statearr_25927_25939[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25909);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25926;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25940 = state_25909;
state_25909 = G__25940;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__25332__auto__ = function(state_25909){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__25332__auto____1.call(this,state_25909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__25332__auto____0;
cljs$core$async$reduce_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__25332__auto____1;
return cljs$core$async$reduce_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__))
})();
var state__25424__auto__ = (function (){var statearr_25928 = f__25423__auto__.call(null);
(statearr_25928[(6)] = c__25422__auto__);

return statearr_25928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__))
);

return c__25422__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__,f__$1){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__,f__$1){
return (function (state_25946){
var state_val_25947 = (state_25946[(1)]);
if((state_val_25947 === (1))){
var inst_25941 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_25946__$1 = state_25946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25946__$1,(2),inst_25941);
} else {
if((state_val_25947 === (2))){
var inst_25943 = (state_25946[(2)]);
var inst_25944 = f__$1.call(null,inst_25943);
var state_25946__$1 = state_25946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25946__$1,inst_25944);
} else {
return null;
}
}
});})(c__25422__auto__,f__$1))
;
return ((function (switch__25331__auto__,c__25422__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__25332__auto__ = null;
var cljs$core$async$transduce_$_state_machine__25332__auto____0 = (function (){
var statearr_25948 = [null,null,null,null,null,null,null];
(statearr_25948[(0)] = cljs$core$async$transduce_$_state_machine__25332__auto__);

(statearr_25948[(1)] = (1));

return statearr_25948;
});
var cljs$core$async$transduce_$_state_machine__25332__auto____1 = (function (state_25946){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25949){if((e25949 instanceof Object)){
var ex__25335__auto__ = e25949;
var statearr_25950_25952 = state_25946;
(statearr_25950_25952[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25946);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25949;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25953 = state_25946;
state_25946 = G__25953;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__25332__auto__ = function(state_25946){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__25332__auto____1.call(this,state_25946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__25332__auto____0;
cljs$core$async$transduce_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__25332__auto____1;
return cljs$core$async$transduce_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__,f__$1))
})();
var state__25424__auto__ = (function (){var statearr_25951 = f__25423__auto__.call(null);
(statearr_25951[(6)] = c__25422__auto__);

return statearr_25951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__,f__$1))
);

return c__25422__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__25955 = arguments.length;
switch (G__25955) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__){
return (function (state_25980){
var state_val_25981 = (state_25980[(1)]);
if((state_val_25981 === (7))){
var inst_25962 = (state_25980[(2)]);
var state_25980__$1 = state_25980;
var statearr_25982_26003 = state_25980__$1;
(statearr_25982_26003[(2)] = inst_25962);

(statearr_25982_26003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (1))){
var inst_25956 = cljs.core.seq.call(null,coll);
var inst_25957 = inst_25956;
var state_25980__$1 = (function (){var statearr_25983 = state_25980;
(statearr_25983[(7)] = inst_25957);

return statearr_25983;
})();
var statearr_25984_26004 = state_25980__$1;
(statearr_25984_26004[(2)] = null);

(statearr_25984_26004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (4))){
var inst_25957 = (state_25980[(7)]);
var inst_25960 = cljs.core.first.call(null,inst_25957);
var state_25980__$1 = state_25980;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25980__$1,(7),ch,inst_25960);
} else {
if((state_val_25981 === (13))){
var inst_25974 = (state_25980[(2)]);
var state_25980__$1 = state_25980;
var statearr_25985_26005 = state_25980__$1;
(statearr_25985_26005[(2)] = inst_25974);

(statearr_25985_26005[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (6))){
var inst_25965 = (state_25980[(2)]);
var state_25980__$1 = state_25980;
if(cljs.core.truth_(inst_25965)){
var statearr_25986_26006 = state_25980__$1;
(statearr_25986_26006[(1)] = (8));

} else {
var statearr_25987_26007 = state_25980__$1;
(statearr_25987_26007[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (3))){
var inst_25978 = (state_25980[(2)]);
var state_25980__$1 = state_25980;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25980__$1,inst_25978);
} else {
if((state_val_25981 === (12))){
var state_25980__$1 = state_25980;
var statearr_25988_26008 = state_25980__$1;
(statearr_25988_26008[(2)] = null);

(statearr_25988_26008[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (2))){
var inst_25957 = (state_25980[(7)]);
var state_25980__$1 = state_25980;
if(cljs.core.truth_(inst_25957)){
var statearr_25989_26009 = state_25980__$1;
(statearr_25989_26009[(1)] = (4));

} else {
var statearr_25990_26010 = state_25980__$1;
(statearr_25990_26010[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (11))){
var inst_25971 = cljs.core.async.close_BANG_.call(null,ch);
var state_25980__$1 = state_25980;
var statearr_25991_26011 = state_25980__$1;
(statearr_25991_26011[(2)] = inst_25971);

(statearr_25991_26011[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (9))){
var state_25980__$1 = state_25980;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25992_26012 = state_25980__$1;
(statearr_25992_26012[(1)] = (11));

} else {
var statearr_25993_26013 = state_25980__$1;
(statearr_25993_26013[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (5))){
var inst_25957 = (state_25980[(7)]);
var state_25980__$1 = state_25980;
var statearr_25994_26014 = state_25980__$1;
(statearr_25994_26014[(2)] = inst_25957);

(statearr_25994_26014[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (10))){
var inst_25976 = (state_25980[(2)]);
var state_25980__$1 = state_25980;
var statearr_25995_26015 = state_25980__$1;
(statearr_25995_26015[(2)] = inst_25976);

(statearr_25995_26015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25981 === (8))){
var inst_25957 = (state_25980[(7)]);
var inst_25967 = cljs.core.next.call(null,inst_25957);
var inst_25957__$1 = inst_25967;
var state_25980__$1 = (function (){var statearr_25996 = state_25980;
(statearr_25996[(7)] = inst_25957__$1);

return statearr_25996;
})();
var statearr_25997_26016 = state_25980__$1;
(statearr_25997_26016[(2)] = null);

(statearr_25997_26016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto__))
;
return ((function (switch__25331__auto__,c__25422__auto__){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_25998 = [null,null,null,null,null,null,null,null];
(statearr_25998[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_25998[(1)] = (1));

return statearr_25998;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_25980){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_25980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e25999){if((e25999 instanceof Object)){
var ex__25335__auto__ = e25999;
var statearr_26000_26017 = state_25980;
(statearr_26000_26017[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25980);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25999;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26018 = state_25980;
state_25980 = G__26018;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_25980){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_25980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__))
})();
var state__25424__auto__ = (function (){var statearr_26001 = f__25423__auto__.call(null);
(statearr_26001[(6)] = c__25422__auto__);

return statearr_26001;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__))
);

return c__25422__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4243__auto__ = (((_ == null))?null:_);
var m__4244__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,_);
} else {
var m__4244__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4244__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m);
} else {
var m__4244__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26019 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26019 = (function (ch,cs,meta26020){
this.ch = ch;
this.cs = cs;
this.meta26020 = meta26020;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26019.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_26021,meta26020__$1){
var self__ = this;
var _26021__$1 = this;
return (new cljs.core.async.t_cljs$core$async26019(self__.ch,self__.cs,meta26020__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async26019.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_26021){
var self__ = this;
var _26021__$1 = this;
return self__.meta26020;
});})(cs))
;

cljs.core.async.t_cljs$core$async26019.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26019.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async26019.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26019.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26019.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26019.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async26019.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta26020","meta26020",-778330353,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async26019.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26019.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26019";

cljs.core.async.t_cljs$core$async26019.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26019");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26019.
 */
cljs.core.async.__GT_t_cljs$core$async26019 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async26019(ch__$1,cs__$1,meta26020){
return (new cljs.core.async.t_cljs$core$async26019(ch__$1,cs__$1,meta26020));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async26019(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__25422__auto___26241 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___26241,cs,m,dchan,dctr,done){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___26241,cs,m,dchan,dctr,done){
return (function (state_26156){
var state_val_26157 = (state_26156[(1)]);
if((state_val_26157 === (7))){
var inst_26152 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26158_26242 = state_26156__$1;
(statearr_26158_26242[(2)] = inst_26152);

(statearr_26158_26242[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (20))){
var inst_26055 = (state_26156[(7)]);
var inst_26067 = cljs.core.first.call(null,inst_26055);
var inst_26068 = cljs.core.nth.call(null,inst_26067,(0),null);
var inst_26069 = cljs.core.nth.call(null,inst_26067,(1),null);
var state_26156__$1 = (function (){var statearr_26159 = state_26156;
(statearr_26159[(8)] = inst_26068);

return statearr_26159;
})();
if(cljs.core.truth_(inst_26069)){
var statearr_26160_26243 = state_26156__$1;
(statearr_26160_26243[(1)] = (22));

} else {
var statearr_26161_26244 = state_26156__$1;
(statearr_26161_26244[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (27))){
var inst_26097 = (state_26156[(9)]);
var inst_26024 = (state_26156[(10)]);
var inst_26099 = (state_26156[(11)]);
var inst_26104 = (state_26156[(12)]);
var inst_26104__$1 = cljs.core._nth.call(null,inst_26097,inst_26099);
var inst_26105 = cljs.core.async.put_BANG_.call(null,inst_26104__$1,inst_26024,done);
var state_26156__$1 = (function (){var statearr_26162 = state_26156;
(statearr_26162[(12)] = inst_26104__$1);

return statearr_26162;
})();
if(cljs.core.truth_(inst_26105)){
var statearr_26163_26245 = state_26156__$1;
(statearr_26163_26245[(1)] = (30));

} else {
var statearr_26164_26246 = state_26156__$1;
(statearr_26164_26246[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (1))){
var state_26156__$1 = state_26156;
var statearr_26165_26247 = state_26156__$1;
(statearr_26165_26247[(2)] = null);

(statearr_26165_26247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (24))){
var inst_26055 = (state_26156[(7)]);
var inst_26074 = (state_26156[(2)]);
var inst_26075 = cljs.core.next.call(null,inst_26055);
var inst_26033 = inst_26075;
var inst_26034 = null;
var inst_26035 = (0);
var inst_26036 = (0);
var state_26156__$1 = (function (){var statearr_26166 = state_26156;
(statearr_26166[(13)] = inst_26036);

(statearr_26166[(14)] = inst_26035);

(statearr_26166[(15)] = inst_26074);

(statearr_26166[(16)] = inst_26034);

(statearr_26166[(17)] = inst_26033);

return statearr_26166;
})();
var statearr_26167_26248 = state_26156__$1;
(statearr_26167_26248[(2)] = null);

(statearr_26167_26248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (39))){
var state_26156__$1 = state_26156;
var statearr_26171_26249 = state_26156__$1;
(statearr_26171_26249[(2)] = null);

(statearr_26171_26249[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (4))){
var inst_26024 = (state_26156[(10)]);
var inst_26024__$1 = (state_26156[(2)]);
var inst_26025 = (inst_26024__$1 == null);
var state_26156__$1 = (function (){var statearr_26172 = state_26156;
(statearr_26172[(10)] = inst_26024__$1);

return statearr_26172;
})();
if(cljs.core.truth_(inst_26025)){
var statearr_26173_26250 = state_26156__$1;
(statearr_26173_26250[(1)] = (5));

} else {
var statearr_26174_26251 = state_26156__$1;
(statearr_26174_26251[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (15))){
var inst_26036 = (state_26156[(13)]);
var inst_26035 = (state_26156[(14)]);
var inst_26034 = (state_26156[(16)]);
var inst_26033 = (state_26156[(17)]);
var inst_26051 = (state_26156[(2)]);
var inst_26052 = (inst_26036 + (1));
var tmp26168 = inst_26035;
var tmp26169 = inst_26034;
var tmp26170 = inst_26033;
var inst_26033__$1 = tmp26170;
var inst_26034__$1 = tmp26169;
var inst_26035__$1 = tmp26168;
var inst_26036__$1 = inst_26052;
var state_26156__$1 = (function (){var statearr_26175 = state_26156;
(statearr_26175[(18)] = inst_26051);

(statearr_26175[(13)] = inst_26036__$1);

(statearr_26175[(14)] = inst_26035__$1);

(statearr_26175[(16)] = inst_26034__$1);

(statearr_26175[(17)] = inst_26033__$1);

return statearr_26175;
})();
var statearr_26176_26252 = state_26156__$1;
(statearr_26176_26252[(2)] = null);

(statearr_26176_26252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (21))){
var inst_26078 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26180_26253 = state_26156__$1;
(statearr_26180_26253[(2)] = inst_26078);

(statearr_26180_26253[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (31))){
var inst_26104 = (state_26156[(12)]);
var inst_26108 = done.call(null,null);
var inst_26109 = cljs.core.async.untap_STAR_.call(null,m,inst_26104);
var state_26156__$1 = (function (){var statearr_26181 = state_26156;
(statearr_26181[(19)] = inst_26108);

return statearr_26181;
})();
var statearr_26182_26254 = state_26156__$1;
(statearr_26182_26254[(2)] = inst_26109);

(statearr_26182_26254[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (32))){
var inst_26098 = (state_26156[(20)]);
var inst_26096 = (state_26156[(21)]);
var inst_26097 = (state_26156[(9)]);
var inst_26099 = (state_26156[(11)]);
var inst_26111 = (state_26156[(2)]);
var inst_26112 = (inst_26099 + (1));
var tmp26177 = inst_26098;
var tmp26178 = inst_26096;
var tmp26179 = inst_26097;
var inst_26096__$1 = tmp26178;
var inst_26097__$1 = tmp26179;
var inst_26098__$1 = tmp26177;
var inst_26099__$1 = inst_26112;
var state_26156__$1 = (function (){var statearr_26183 = state_26156;
(statearr_26183[(20)] = inst_26098__$1);

(statearr_26183[(21)] = inst_26096__$1);

(statearr_26183[(9)] = inst_26097__$1);

(statearr_26183[(22)] = inst_26111);

(statearr_26183[(11)] = inst_26099__$1);

return statearr_26183;
})();
var statearr_26184_26255 = state_26156__$1;
(statearr_26184_26255[(2)] = null);

(statearr_26184_26255[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (40))){
var inst_26124 = (state_26156[(23)]);
var inst_26128 = done.call(null,null);
var inst_26129 = cljs.core.async.untap_STAR_.call(null,m,inst_26124);
var state_26156__$1 = (function (){var statearr_26185 = state_26156;
(statearr_26185[(24)] = inst_26128);

return statearr_26185;
})();
var statearr_26186_26256 = state_26156__$1;
(statearr_26186_26256[(2)] = inst_26129);

(statearr_26186_26256[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (33))){
var inst_26115 = (state_26156[(25)]);
var inst_26117 = cljs.core.chunked_seq_QMARK_.call(null,inst_26115);
var state_26156__$1 = state_26156;
if(inst_26117){
var statearr_26187_26257 = state_26156__$1;
(statearr_26187_26257[(1)] = (36));

} else {
var statearr_26188_26258 = state_26156__$1;
(statearr_26188_26258[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (13))){
var inst_26045 = (state_26156[(26)]);
var inst_26048 = cljs.core.async.close_BANG_.call(null,inst_26045);
var state_26156__$1 = state_26156;
var statearr_26189_26259 = state_26156__$1;
(statearr_26189_26259[(2)] = inst_26048);

(statearr_26189_26259[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (22))){
var inst_26068 = (state_26156[(8)]);
var inst_26071 = cljs.core.async.close_BANG_.call(null,inst_26068);
var state_26156__$1 = state_26156;
var statearr_26190_26260 = state_26156__$1;
(statearr_26190_26260[(2)] = inst_26071);

(statearr_26190_26260[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (36))){
var inst_26115 = (state_26156[(25)]);
var inst_26119 = cljs.core.chunk_first.call(null,inst_26115);
var inst_26120 = cljs.core.chunk_rest.call(null,inst_26115);
var inst_26121 = cljs.core.count.call(null,inst_26119);
var inst_26096 = inst_26120;
var inst_26097 = inst_26119;
var inst_26098 = inst_26121;
var inst_26099 = (0);
var state_26156__$1 = (function (){var statearr_26191 = state_26156;
(statearr_26191[(20)] = inst_26098);

(statearr_26191[(21)] = inst_26096);

(statearr_26191[(9)] = inst_26097);

(statearr_26191[(11)] = inst_26099);

return statearr_26191;
})();
var statearr_26192_26261 = state_26156__$1;
(statearr_26192_26261[(2)] = null);

(statearr_26192_26261[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (41))){
var inst_26115 = (state_26156[(25)]);
var inst_26131 = (state_26156[(2)]);
var inst_26132 = cljs.core.next.call(null,inst_26115);
var inst_26096 = inst_26132;
var inst_26097 = null;
var inst_26098 = (0);
var inst_26099 = (0);
var state_26156__$1 = (function (){var statearr_26193 = state_26156;
(statearr_26193[(20)] = inst_26098);

(statearr_26193[(27)] = inst_26131);

(statearr_26193[(21)] = inst_26096);

(statearr_26193[(9)] = inst_26097);

(statearr_26193[(11)] = inst_26099);

return statearr_26193;
})();
var statearr_26194_26262 = state_26156__$1;
(statearr_26194_26262[(2)] = null);

(statearr_26194_26262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (43))){
var state_26156__$1 = state_26156;
var statearr_26195_26263 = state_26156__$1;
(statearr_26195_26263[(2)] = null);

(statearr_26195_26263[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (29))){
var inst_26140 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26196_26264 = state_26156__$1;
(statearr_26196_26264[(2)] = inst_26140);

(statearr_26196_26264[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (44))){
var inst_26149 = (state_26156[(2)]);
var state_26156__$1 = (function (){var statearr_26197 = state_26156;
(statearr_26197[(28)] = inst_26149);

return statearr_26197;
})();
var statearr_26198_26265 = state_26156__$1;
(statearr_26198_26265[(2)] = null);

(statearr_26198_26265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (6))){
var inst_26088 = (state_26156[(29)]);
var inst_26087 = cljs.core.deref.call(null,cs);
var inst_26088__$1 = cljs.core.keys.call(null,inst_26087);
var inst_26089 = cljs.core.count.call(null,inst_26088__$1);
var inst_26090 = cljs.core.reset_BANG_.call(null,dctr,inst_26089);
var inst_26095 = cljs.core.seq.call(null,inst_26088__$1);
var inst_26096 = inst_26095;
var inst_26097 = null;
var inst_26098 = (0);
var inst_26099 = (0);
var state_26156__$1 = (function (){var statearr_26199 = state_26156;
(statearr_26199[(20)] = inst_26098);

(statearr_26199[(30)] = inst_26090);

(statearr_26199[(21)] = inst_26096);

(statearr_26199[(9)] = inst_26097);

(statearr_26199[(11)] = inst_26099);

(statearr_26199[(29)] = inst_26088__$1);

return statearr_26199;
})();
var statearr_26200_26266 = state_26156__$1;
(statearr_26200_26266[(2)] = null);

(statearr_26200_26266[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (28))){
var inst_26115 = (state_26156[(25)]);
var inst_26096 = (state_26156[(21)]);
var inst_26115__$1 = cljs.core.seq.call(null,inst_26096);
var state_26156__$1 = (function (){var statearr_26201 = state_26156;
(statearr_26201[(25)] = inst_26115__$1);

return statearr_26201;
})();
if(inst_26115__$1){
var statearr_26202_26267 = state_26156__$1;
(statearr_26202_26267[(1)] = (33));

} else {
var statearr_26203_26268 = state_26156__$1;
(statearr_26203_26268[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (25))){
var inst_26098 = (state_26156[(20)]);
var inst_26099 = (state_26156[(11)]);
var inst_26101 = (inst_26099 < inst_26098);
var inst_26102 = inst_26101;
var state_26156__$1 = state_26156;
if(cljs.core.truth_(inst_26102)){
var statearr_26204_26269 = state_26156__$1;
(statearr_26204_26269[(1)] = (27));

} else {
var statearr_26205_26270 = state_26156__$1;
(statearr_26205_26270[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (34))){
var state_26156__$1 = state_26156;
var statearr_26206_26271 = state_26156__$1;
(statearr_26206_26271[(2)] = null);

(statearr_26206_26271[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (17))){
var state_26156__$1 = state_26156;
var statearr_26207_26272 = state_26156__$1;
(statearr_26207_26272[(2)] = null);

(statearr_26207_26272[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (3))){
var inst_26154 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26156__$1,inst_26154);
} else {
if((state_val_26157 === (12))){
var inst_26083 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26208_26273 = state_26156__$1;
(statearr_26208_26273[(2)] = inst_26083);

(statearr_26208_26273[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (2))){
var state_26156__$1 = state_26156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26156__$1,(4),ch);
} else {
if((state_val_26157 === (23))){
var state_26156__$1 = state_26156;
var statearr_26209_26274 = state_26156__$1;
(statearr_26209_26274[(2)] = null);

(statearr_26209_26274[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (35))){
var inst_26138 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26210_26275 = state_26156__$1;
(statearr_26210_26275[(2)] = inst_26138);

(statearr_26210_26275[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (19))){
var inst_26055 = (state_26156[(7)]);
var inst_26059 = cljs.core.chunk_first.call(null,inst_26055);
var inst_26060 = cljs.core.chunk_rest.call(null,inst_26055);
var inst_26061 = cljs.core.count.call(null,inst_26059);
var inst_26033 = inst_26060;
var inst_26034 = inst_26059;
var inst_26035 = inst_26061;
var inst_26036 = (0);
var state_26156__$1 = (function (){var statearr_26211 = state_26156;
(statearr_26211[(13)] = inst_26036);

(statearr_26211[(14)] = inst_26035);

(statearr_26211[(16)] = inst_26034);

(statearr_26211[(17)] = inst_26033);

return statearr_26211;
})();
var statearr_26212_26276 = state_26156__$1;
(statearr_26212_26276[(2)] = null);

(statearr_26212_26276[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (11))){
var inst_26055 = (state_26156[(7)]);
var inst_26033 = (state_26156[(17)]);
var inst_26055__$1 = cljs.core.seq.call(null,inst_26033);
var state_26156__$1 = (function (){var statearr_26213 = state_26156;
(statearr_26213[(7)] = inst_26055__$1);

return statearr_26213;
})();
if(inst_26055__$1){
var statearr_26214_26277 = state_26156__$1;
(statearr_26214_26277[(1)] = (16));

} else {
var statearr_26215_26278 = state_26156__$1;
(statearr_26215_26278[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (9))){
var inst_26085 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26216_26279 = state_26156__$1;
(statearr_26216_26279[(2)] = inst_26085);

(statearr_26216_26279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (5))){
var inst_26031 = cljs.core.deref.call(null,cs);
var inst_26032 = cljs.core.seq.call(null,inst_26031);
var inst_26033 = inst_26032;
var inst_26034 = null;
var inst_26035 = (0);
var inst_26036 = (0);
var state_26156__$1 = (function (){var statearr_26217 = state_26156;
(statearr_26217[(13)] = inst_26036);

(statearr_26217[(14)] = inst_26035);

(statearr_26217[(16)] = inst_26034);

(statearr_26217[(17)] = inst_26033);

return statearr_26217;
})();
var statearr_26218_26280 = state_26156__$1;
(statearr_26218_26280[(2)] = null);

(statearr_26218_26280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (14))){
var state_26156__$1 = state_26156;
var statearr_26219_26281 = state_26156__$1;
(statearr_26219_26281[(2)] = null);

(statearr_26219_26281[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (45))){
var inst_26146 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26220_26282 = state_26156__$1;
(statearr_26220_26282[(2)] = inst_26146);

(statearr_26220_26282[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (26))){
var inst_26088 = (state_26156[(29)]);
var inst_26142 = (state_26156[(2)]);
var inst_26143 = cljs.core.seq.call(null,inst_26088);
var state_26156__$1 = (function (){var statearr_26221 = state_26156;
(statearr_26221[(31)] = inst_26142);

return statearr_26221;
})();
if(inst_26143){
var statearr_26222_26283 = state_26156__$1;
(statearr_26222_26283[(1)] = (42));

} else {
var statearr_26223_26284 = state_26156__$1;
(statearr_26223_26284[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (16))){
var inst_26055 = (state_26156[(7)]);
var inst_26057 = cljs.core.chunked_seq_QMARK_.call(null,inst_26055);
var state_26156__$1 = state_26156;
if(inst_26057){
var statearr_26224_26285 = state_26156__$1;
(statearr_26224_26285[(1)] = (19));

} else {
var statearr_26225_26286 = state_26156__$1;
(statearr_26225_26286[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (38))){
var inst_26135 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26226_26287 = state_26156__$1;
(statearr_26226_26287[(2)] = inst_26135);

(statearr_26226_26287[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (30))){
var state_26156__$1 = state_26156;
var statearr_26227_26288 = state_26156__$1;
(statearr_26227_26288[(2)] = null);

(statearr_26227_26288[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (10))){
var inst_26036 = (state_26156[(13)]);
var inst_26034 = (state_26156[(16)]);
var inst_26044 = cljs.core._nth.call(null,inst_26034,inst_26036);
var inst_26045 = cljs.core.nth.call(null,inst_26044,(0),null);
var inst_26046 = cljs.core.nth.call(null,inst_26044,(1),null);
var state_26156__$1 = (function (){var statearr_26228 = state_26156;
(statearr_26228[(26)] = inst_26045);

return statearr_26228;
})();
if(cljs.core.truth_(inst_26046)){
var statearr_26229_26289 = state_26156__$1;
(statearr_26229_26289[(1)] = (13));

} else {
var statearr_26230_26290 = state_26156__$1;
(statearr_26230_26290[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (18))){
var inst_26081 = (state_26156[(2)]);
var state_26156__$1 = state_26156;
var statearr_26231_26291 = state_26156__$1;
(statearr_26231_26291[(2)] = inst_26081);

(statearr_26231_26291[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (42))){
var state_26156__$1 = state_26156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26156__$1,(45),dchan);
} else {
if((state_val_26157 === (37))){
var inst_26115 = (state_26156[(25)]);
var inst_26024 = (state_26156[(10)]);
var inst_26124 = (state_26156[(23)]);
var inst_26124__$1 = cljs.core.first.call(null,inst_26115);
var inst_26125 = cljs.core.async.put_BANG_.call(null,inst_26124__$1,inst_26024,done);
var state_26156__$1 = (function (){var statearr_26232 = state_26156;
(statearr_26232[(23)] = inst_26124__$1);

return statearr_26232;
})();
if(cljs.core.truth_(inst_26125)){
var statearr_26233_26292 = state_26156__$1;
(statearr_26233_26292[(1)] = (39));

} else {
var statearr_26234_26293 = state_26156__$1;
(statearr_26234_26293[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26157 === (8))){
var inst_26036 = (state_26156[(13)]);
var inst_26035 = (state_26156[(14)]);
var inst_26038 = (inst_26036 < inst_26035);
var inst_26039 = inst_26038;
var state_26156__$1 = state_26156;
if(cljs.core.truth_(inst_26039)){
var statearr_26235_26294 = state_26156__$1;
(statearr_26235_26294[(1)] = (10));

} else {
var statearr_26236_26295 = state_26156__$1;
(statearr_26236_26295[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___26241,cs,m,dchan,dctr,done))
;
return ((function (switch__25331__auto__,c__25422__auto___26241,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__25332__auto__ = null;
var cljs$core$async$mult_$_state_machine__25332__auto____0 = (function (){
var statearr_26237 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26237[(0)] = cljs$core$async$mult_$_state_machine__25332__auto__);

(statearr_26237[(1)] = (1));

return statearr_26237;
});
var cljs$core$async$mult_$_state_machine__25332__auto____1 = (function (state_26156){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_26156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e26238){if((e26238 instanceof Object)){
var ex__25335__auto__ = e26238;
var statearr_26239_26296 = state_26156;
(statearr_26239_26296[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26156);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26238;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26297 = state_26156;
state_26156 = G__26297;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__25332__auto__ = function(state_26156){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__25332__auto____1.call(this,state_26156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__25332__auto____0;
cljs$core$async$mult_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__25332__auto____1;
return cljs$core$async$mult_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___26241,cs,m,dchan,dctr,done))
})();
var state__25424__auto__ = (function (){var statearr_26240 = f__25423__auto__.call(null);
(statearr_26240[(6)] = c__25422__auto___26241);

return statearr_26240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___26241,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__26299 = arguments.length;
switch (G__26299) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m);
} else {
var m__4244__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,state_map);
} else {
var m__4244__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4243__auto__ = (((m == null))?null:m);
var m__4244__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,m,mode);
} else {
var m__4244__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4534__auto__ = [];
var len__4531__auto___26311 = arguments.length;
var i__4532__auto___26312 = (0);
while(true){
if((i__4532__auto___26312 < len__4531__auto___26311)){
args__4534__auto__.push((arguments[i__4532__auto___26312]));

var G__26313 = (i__4532__auto___26312 + (1));
i__4532__auto___26312 = G__26313;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((3) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4535__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__26305){
var map__26306 = p__26305;
var map__26306__$1 = ((((!((map__26306 == null)))?(((((map__26306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26306.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26306):map__26306);
var opts = map__26306__$1;
var statearr_26308_26314 = state;
(statearr_26308_26314[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__26306,map__26306__$1,opts){
return (function (val){
var statearr_26309_26315 = state;
(statearr_26309_26315[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__26306,map__26306__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_26310_26316 = state;
(statearr_26310_26316[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq26301){
var G__26302 = cljs.core.first.call(null,seq26301);
var seq26301__$1 = cljs.core.next.call(null,seq26301);
var G__26303 = cljs.core.first.call(null,seq26301__$1);
var seq26301__$2 = cljs.core.next.call(null,seq26301__$1);
var G__26304 = cljs.core.first.call(null,seq26301__$2);
var seq26301__$3 = cljs.core.next.call(null,seq26301__$2);
var self__4518__auto__ = this;
return self__4518__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26302,G__26303,G__26304,seq26301__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos)))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26317 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26317 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta26318){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta26318 = meta26318;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26319,meta26318__$1){
var self__ = this;
var _26319__$1 = this;
return (new cljs.core.async.t_cljs$core$async26317(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta26318__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26319){
var self__ = this;
var _26319__$1 = this;
return self__.meta26318;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta26318","meta26318",1927051482,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26317.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26317.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26317";

cljs.core.async.t_cljs$core$async26317.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26317");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26317.
 */
cljs.core.async.__GT_t_cljs$core$async26317 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async26317(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta26318){
return (new cljs.core.async.t_cljs$core$async26317(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta26318));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async26317(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25422__auto___26481 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___26481,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___26481,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_26421){
var state_val_26422 = (state_26421[(1)]);
if((state_val_26422 === (7))){
var inst_26336 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
var statearr_26423_26482 = state_26421__$1;
(statearr_26423_26482[(2)] = inst_26336);

(statearr_26423_26482[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (20))){
var inst_26348 = (state_26421[(7)]);
var state_26421__$1 = state_26421;
var statearr_26424_26483 = state_26421__$1;
(statearr_26424_26483[(2)] = inst_26348);

(statearr_26424_26483[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (27))){
var state_26421__$1 = state_26421;
var statearr_26425_26484 = state_26421__$1;
(statearr_26425_26484[(2)] = null);

(statearr_26425_26484[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (1))){
var inst_26323 = (state_26421[(8)]);
var inst_26323__$1 = calc_state.call(null);
var inst_26325 = (inst_26323__$1 == null);
var inst_26326 = cljs.core.not.call(null,inst_26325);
var state_26421__$1 = (function (){var statearr_26426 = state_26421;
(statearr_26426[(8)] = inst_26323__$1);

return statearr_26426;
})();
if(inst_26326){
var statearr_26427_26485 = state_26421__$1;
(statearr_26427_26485[(1)] = (2));

} else {
var statearr_26428_26486 = state_26421__$1;
(statearr_26428_26486[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (24))){
var inst_26372 = (state_26421[(9)]);
var inst_26381 = (state_26421[(10)]);
var inst_26395 = (state_26421[(11)]);
var inst_26395__$1 = inst_26372.call(null,inst_26381);
var state_26421__$1 = (function (){var statearr_26429 = state_26421;
(statearr_26429[(11)] = inst_26395__$1);

return statearr_26429;
})();
if(cljs.core.truth_(inst_26395__$1)){
var statearr_26430_26487 = state_26421__$1;
(statearr_26430_26487[(1)] = (29));

} else {
var statearr_26431_26488 = state_26421__$1;
(statearr_26431_26488[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (4))){
var inst_26339 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
if(cljs.core.truth_(inst_26339)){
var statearr_26432_26489 = state_26421__$1;
(statearr_26432_26489[(1)] = (8));

} else {
var statearr_26433_26490 = state_26421__$1;
(statearr_26433_26490[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (15))){
var inst_26366 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
if(cljs.core.truth_(inst_26366)){
var statearr_26434_26491 = state_26421__$1;
(statearr_26434_26491[(1)] = (19));

} else {
var statearr_26435_26492 = state_26421__$1;
(statearr_26435_26492[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (21))){
var inst_26371 = (state_26421[(12)]);
var inst_26371__$1 = (state_26421[(2)]);
var inst_26372 = cljs.core.get.call(null,inst_26371__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26373 = cljs.core.get.call(null,inst_26371__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26374 = cljs.core.get.call(null,inst_26371__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_26421__$1 = (function (){var statearr_26436 = state_26421;
(statearr_26436[(13)] = inst_26373);

(statearr_26436[(12)] = inst_26371__$1);

(statearr_26436[(9)] = inst_26372);

return statearr_26436;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_26421__$1,(22),inst_26374);
} else {
if((state_val_26422 === (31))){
var inst_26403 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
if(cljs.core.truth_(inst_26403)){
var statearr_26437_26493 = state_26421__$1;
(statearr_26437_26493[(1)] = (32));

} else {
var statearr_26438_26494 = state_26421__$1;
(statearr_26438_26494[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (32))){
var inst_26380 = (state_26421[(14)]);
var state_26421__$1 = state_26421;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26421__$1,(35),out,inst_26380);
} else {
if((state_val_26422 === (33))){
var inst_26371 = (state_26421[(12)]);
var inst_26348 = inst_26371;
var state_26421__$1 = (function (){var statearr_26439 = state_26421;
(statearr_26439[(7)] = inst_26348);

return statearr_26439;
})();
var statearr_26440_26495 = state_26421__$1;
(statearr_26440_26495[(2)] = null);

(statearr_26440_26495[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (13))){
var inst_26348 = (state_26421[(7)]);
var inst_26355 = inst_26348.cljs$lang$protocol_mask$partition0$;
var inst_26356 = (inst_26355 & (64));
var inst_26357 = inst_26348.cljs$core$ISeq$;
var inst_26358 = (cljs.core.PROTOCOL_SENTINEL === inst_26357);
var inst_26359 = ((inst_26356) || (inst_26358));
var state_26421__$1 = state_26421;
if(cljs.core.truth_(inst_26359)){
var statearr_26441_26496 = state_26421__$1;
(statearr_26441_26496[(1)] = (16));

} else {
var statearr_26442_26497 = state_26421__$1;
(statearr_26442_26497[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (22))){
var inst_26381 = (state_26421[(10)]);
var inst_26380 = (state_26421[(14)]);
var inst_26379 = (state_26421[(2)]);
var inst_26380__$1 = cljs.core.nth.call(null,inst_26379,(0),null);
var inst_26381__$1 = cljs.core.nth.call(null,inst_26379,(1),null);
var inst_26382 = (inst_26380__$1 == null);
var inst_26383 = cljs.core._EQ_.call(null,inst_26381__$1,change);
var inst_26384 = ((inst_26382) || (inst_26383));
var state_26421__$1 = (function (){var statearr_26443 = state_26421;
(statearr_26443[(10)] = inst_26381__$1);

(statearr_26443[(14)] = inst_26380__$1);

return statearr_26443;
})();
if(cljs.core.truth_(inst_26384)){
var statearr_26444_26498 = state_26421__$1;
(statearr_26444_26498[(1)] = (23));

} else {
var statearr_26445_26499 = state_26421__$1;
(statearr_26445_26499[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (36))){
var inst_26371 = (state_26421[(12)]);
var inst_26348 = inst_26371;
var state_26421__$1 = (function (){var statearr_26446 = state_26421;
(statearr_26446[(7)] = inst_26348);

return statearr_26446;
})();
var statearr_26447_26500 = state_26421__$1;
(statearr_26447_26500[(2)] = null);

(statearr_26447_26500[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (29))){
var inst_26395 = (state_26421[(11)]);
var state_26421__$1 = state_26421;
var statearr_26448_26501 = state_26421__$1;
(statearr_26448_26501[(2)] = inst_26395);

(statearr_26448_26501[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (6))){
var state_26421__$1 = state_26421;
var statearr_26449_26502 = state_26421__$1;
(statearr_26449_26502[(2)] = false);

(statearr_26449_26502[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (28))){
var inst_26391 = (state_26421[(2)]);
var inst_26392 = calc_state.call(null);
var inst_26348 = inst_26392;
var state_26421__$1 = (function (){var statearr_26450 = state_26421;
(statearr_26450[(7)] = inst_26348);

(statearr_26450[(15)] = inst_26391);

return statearr_26450;
})();
var statearr_26451_26503 = state_26421__$1;
(statearr_26451_26503[(2)] = null);

(statearr_26451_26503[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (25))){
var inst_26417 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
var statearr_26452_26504 = state_26421__$1;
(statearr_26452_26504[(2)] = inst_26417);

(statearr_26452_26504[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (34))){
var inst_26415 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
var statearr_26453_26505 = state_26421__$1;
(statearr_26453_26505[(2)] = inst_26415);

(statearr_26453_26505[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (17))){
var state_26421__$1 = state_26421;
var statearr_26454_26506 = state_26421__$1;
(statearr_26454_26506[(2)] = false);

(statearr_26454_26506[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (3))){
var state_26421__$1 = state_26421;
var statearr_26455_26507 = state_26421__$1;
(statearr_26455_26507[(2)] = false);

(statearr_26455_26507[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (12))){
var inst_26419 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26421__$1,inst_26419);
} else {
if((state_val_26422 === (2))){
var inst_26323 = (state_26421[(8)]);
var inst_26328 = inst_26323.cljs$lang$protocol_mask$partition0$;
var inst_26329 = (inst_26328 & (64));
var inst_26330 = inst_26323.cljs$core$ISeq$;
var inst_26331 = (cljs.core.PROTOCOL_SENTINEL === inst_26330);
var inst_26332 = ((inst_26329) || (inst_26331));
var state_26421__$1 = state_26421;
if(cljs.core.truth_(inst_26332)){
var statearr_26456_26508 = state_26421__$1;
(statearr_26456_26508[(1)] = (5));

} else {
var statearr_26457_26509 = state_26421__$1;
(statearr_26457_26509[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (23))){
var inst_26380 = (state_26421[(14)]);
var inst_26386 = (inst_26380 == null);
var state_26421__$1 = state_26421;
if(cljs.core.truth_(inst_26386)){
var statearr_26458_26510 = state_26421__$1;
(statearr_26458_26510[(1)] = (26));

} else {
var statearr_26459_26511 = state_26421__$1;
(statearr_26459_26511[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (35))){
var inst_26406 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
if(cljs.core.truth_(inst_26406)){
var statearr_26460_26512 = state_26421__$1;
(statearr_26460_26512[(1)] = (36));

} else {
var statearr_26461_26513 = state_26421__$1;
(statearr_26461_26513[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (19))){
var inst_26348 = (state_26421[(7)]);
var inst_26368 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26348);
var state_26421__$1 = state_26421;
var statearr_26462_26514 = state_26421__$1;
(statearr_26462_26514[(2)] = inst_26368);

(statearr_26462_26514[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (11))){
var inst_26348 = (state_26421[(7)]);
var inst_26352 = (inst_26348 == null);
var inst_26353 = cljs.core.not.call(null,inst_26352);
var state_26421__$1 = state_26421;
if(inst_26353){
var statearr_26463_26515 = state_26421__$1;
(statearr_26463_26515[(1)] = (13));

} else {
var statearr_26464_26516 = state_26421__$1;
(statearr_26464_26516[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (9))){
var inst_26323 = (state_26421[(8)]);
var state_26421__$1 = state_26421;
var statearr_26465_26517 = state_26421__$1;
(statearr_26465_26517[(2)] = inst_26323);

(statearr_26465_26517[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (5))){
var state_26421__$1 = state_26421;
var statearr_26466_26518 = state_26421__$1;
(statearr_26466_26518[(2)] = true);

(statearr_26466_26518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (14))){
var state_26421__$1 = state_26421;
var statearr_26467_26519 = state_26421__$1;
(statearr_26467_26519[(2)] = false);

(statearr_26467_26519[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (26))){
var inst_26381 = (state_26421[(10)]);
var inst_26388 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_26381);
var state_26421__$1 = state_26421;
var statearr_26468_26520 = state_26421__$1;
(statearr_26468_26520[(2)] = inst_26388);

(statearr_26468_26520[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (16))){
var state_26421__$1 = state_26421;
var statearr_26469_26521 = state_26421__$1;
(statearr_26469_26521[(2)] = true);

(statearr_26469_26521[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (38))){
var inst_26411 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
var statearr_26470_26522 = state_26421__$1;
(statearr_26470_26522[(2)] = inst_26411);

(statearr_26470_26522[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (30))){
var inst_26373 = (state_26421[(13)]);
var inst_26372 = (state_26421[(9)]);
var inst_26381 = (state_26421[(10)]);
var inst_26398 = cljs.core.empty_QMARK_.call(null,inst_26372);
var inst_26399 = inst_26373.call(null,inst_26381);
var inst_26400 = cljs.core.not.call(null,inst_26399);
var inst_26401 = ((inst_26398) && (inst_26400));
var state_26421__$1 = state_26421;
var statearr_26471_26523 = state_26421__$1;
(statearr_26471_26523[(2)] = inst_26401);

(statearr_26471_26523[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (10))){
var inst_26323 = (state_26421[(8)]);
var inst_26344 = (state_26421[(2)]);
var inst_26345 = cljs.core.get.call(null,inst_26344,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26346 = cljs.core.get.call(null,inst_26344,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26347 = cljs.core.get.call(null,inst_26344,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_26348 = inst_26323;
var state_26421__$1 = (function (){var statearr_26472 = state_26421;
(statearr_26472[(16)] = inst_26346);

(statearr_26472[(7)] = inst_26348);

(statearr_26472[(17)] = inst_26345);

(statearr_26472[(18)] = inst_26347);

return statearr_26472;
})();
var statearr_26473_26524 = state_26421__$1;
(statearr_26473_26524[(2)] = null);

(statearr_26473_26524[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (18))){
var inst_26363 = (state_26421[(2)]);
var state_26421__$1 = state_26421;
var statearr_26474_26525 = state_26421__$1;
(statearr_26474_26525[(2)] = inst_26363);

(statearr_26474_26525[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (37))){
var state_26421__$1 = state_26421;
var statearr_26475_26526 = state_26421__$1;
(statearr_26475_26526[(2)] = null);

(statearr_26475_26526[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26422 === (8))){
var inst_26323 = (state_26421[(8)]);
var inst_26341 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26323);
var state_26421__$1 = state_26421;
var statearr_26476_26527 = state_26421__$1;
(statearr_26476_26527[(2)] = inst_26341);

(statearr_26476_26527[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___26481,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__25331__auto__,c__25422__auto___26481,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__25332__auto__ = null;
var cljs$core$async$mix_$_state_machine__25332__auto____0 = (function (){
var statearr_26477 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26477[(0)] = cljs$core$async$mix_$_state_machine__25332__auto__);

(statearr_26477[(1)] = (1));

return statearr_26477;
});
var cljs$core$async$mix_$_state_machine__25332__auto____1 = (function (state_26421){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_26421);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e26478){if((e26478 instanceof Object)){
var ex__25335__auto__ = e26478;
var statearr_26479_26528 = state_26421;
(statearr_26479_26528[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26421);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26478;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26529 = state_26421;
state_26421 = G__26529;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__25332__auto__ = function(state_26421){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__25332__auto____1.call(this,state_26421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__25332__auto____0;
cljs$core$async$mix_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__25332__auto____1;
return cljs$core$async$mix_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___26481,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__25424__auto__ = (function (){var statearr_26480 = f__25423__auto__.call(null);
(statearr_26480[(6)] = c__25422__auto___26481);

return statearr_26480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___26481,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4244__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v,ch);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__26531 = arguments.length;
switch (G__26531) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4243__auto__ = (((p == null))?null:p);
var m__4244__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4243__auto__)]);
if(!((m__4244__auto__ == null))){
return m__4244__auto__.call(null,p,v);
} else {
var m__4244__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4244__auto____$1 == null))){
return m__4244__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__26535 = arguments.length;
switch (G__26535) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3949__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3949__auto__,mults){
return (function (p1__26533_SHARP_){
if(cljs.core.truth_(p1__26533_SHARP_.call(null,topic))){
return p1__26533_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__26533_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3949__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26536 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26536 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta26537){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta26537 = meta26537;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_26538,meta26537__$1){
var self__ = this;
var _26538__$1 = this;
return (new cljs.core.async.t_cljs$core$async26536(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta26537__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_26538){
var self__ = this;
var _26538__$1 = this;
return self__.meta26537;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26536.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26536.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta26537","meta26537",-951118399,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26536.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26536.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26536";

cljs.core.async.t_cljs$core$async26536.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26536");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26536.
 */
cljs.core.async.__GT_t_cljs$core$async26536 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async26536(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26537){
return (new cljs.core.async.t_cljs$core$async26536(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26537));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async26536(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25422__auto___26656 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___26656,mults,ensure_mult,p){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___26656,mults,ensure_mult,p){
return (function (state_26610){
var state_val_26611 = (state_26610[(1)]);
if((state_val_26611 === (7))){
var inst_26606 = (state_26610[(2)]);
var state_26610__$1 = state_26610;
var statearr_26612_26657 = state_26610__$1;
(statearr_26612_26657[(2)] = inst_26606);

(statearr_26612_26657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (20))){
var state_26610__$1 = state_26610;
var statearr_26613_26658 = state_26610__$1;
(statearr_26613_26658[(2)] = null);

(statearr_26613_26658[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (1))){
var state_26610__$1 = state_26610;
var statearr_26614_26659 = state_26610__$1;
(statearr_26614_26659[(2)] = null);

(statearr_26614_26659[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (24))){
var inst_26589 = (state_26610[(7)]);
var inst_26598 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_26589);
var state_26610__$1 = state_26610;
var statearr_26615_26660 = state_26610__$1;
(statearr_26615_26660[(2)] = inst_26598);

(statearr_26615_26660[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (4))){
var inst_26541 = (state_26610[(8)]);
var inst_26541__$1 = (state_26610[(2)]);
var inst_26542 = (inst_26541__$1 == null);
var state_26610__$1 = (function (){var statearr_26616 = state_26610;
(statearr_26616[(8)] = inst_26541__$1);

return statearr_26616;
})();
if(cljs.core.truth_(inst_26542)){
var statearr_26617_26661 = state_26610__$1;
(statearr_26617_26661[(1)] = (5));

} else {
var statearr_26618_26662 = state_26610__$1;
(statearr_26618_26662[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (15))){
var inst_26583 = (state_26610[(2)]);
var state_26610__$1 = state_26610;
var statearr_26619_26663 = state_26610__$1;
(statearr_26619_26663[(2)] = inst_26583);

(statearr_26619_26663[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (21))){
var inst_26603 = (state_26610[(2)]);
var state_26610__$1 = (function (){var statearr_26620 = state_26610;
(statearr_26620[(9)] = inst_26603);

return statearr_26620;
})();
var statearr_26621_26664 = state_26610__$1;
(statearr_26621_26664[(2)] = null);

(statearr_26621_26664[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (13))){
var inst_26565 = (state_26610[(10)]);
var inst_26567 = cljs.core.chunked_seq_QMARK_.call(null,inst_26565);
var state_26610__$1 = state_26610;
if(inst_26567){
var statearr_26622_26665 = state_26610__$1;
(statearr_26622_26665[(1)] = (16));

} else {
var statearr_26623_26666 = state_26610__$1;
(statearr_26623_26666[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (22))){
var inst_26595 = (state_26610[(2)]);
var state_26610__$1 = state_26610;
if(cljs.core.truth_(inst_26595)){
var statearr_26624_26667 = state_26610__$1;
(statearr_26624_26667[(1)] = (23));

} else {
var statearr_26625_26668 = state_26610__$1;
(statearr_26625_26668[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (6))){
var inst_26589 = (state_26610[(7)]);
var inst_26591 = (state_26610[(11)]);
var inst_26541 = (state_26610[(8)]);
var inst_26589__$1 = topic_fn.call(null,inst_26541);
var inst_26590 = cljs.core.deref.call(null,mults);
var inst_26591__$1 = cljs.core.get.call(null,inst_26590,inst_26589__$1);
var state_26610__$1 = (function (){var statearr_26626 = state_26610;
(statearr_26626[(7)] = inst_26589__$1);

(statearr_26626[(11)] = inst_26591__$1);

return statearr_26626;
})();
if(cljs.core.truth_(inst_26591__$1)){
var statearr_26627_26669 = state_26610__$1;
(statearr_26627_26669[(1)] = (19));

} else {
var statearr_26628_26670 = state_26610__$1;
(statearr_26628_26670[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (25))){
var inst_26600 = (state_26610[(2)]);
var state_26610__$1 = state_26610;
var statearr_26629_26671 = state_26610__$1;
(statearr_26629_26671[(2)] = inst_26600);

(statearr_26629_26671[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (17))){
var inst_26565 = (state_26610[(10)]);
var inst_26574 = cljs.core.first.call(null,inst_26565);
var inst_26575 = cljs.core.async.muxch_STAR_.call(null,inst_26574);
var inst_26576 = cljs.core.async.close_BANG_.call(null,inst_26575);
var inst_26577 = cljs.core.next.call(null,inst_26565);
var inst_26551 = inst_26577;
var inst_26552 = null;
var inst_26553 = (0);
var inst_26554 = (0);
var state_26610__$1 = (function (){var statearr_26630 = state_26610;
(statearr_26630[(12)] = inst_26551);

(statearr_26630[(13)] = inst_26576);

(statearr_26630[(14)] = inst_26553);

(statearr_26630[(15)] = inst_26554);

(statearr_26630[(16)] = inst_26552);

return statearr_26630;
})();
var statearr_26631_26672 = state_26610__$1;
(statearr_26631_26672[(2)] = null);

(statearr_26631_26672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (3))){
var inst_26608 = (state_26610[(2)]);
var state_26610__$1 = state_26610;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26610__$1,inst_26608);
} else {
if((state_val_26611 === (12))){
var inst_26585 = (state_26610[(2)]);
var state_26610__$1 = state_26610;
var statearr_26632_26673 = state_26610__$1;
(statearr_26632_26673[(2)] = inst_26585);

(statearr_26632_26673[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (2))){
var state_26610__$1 = state_26610;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26610__$1,(4),ch);
} else {
if((state_val_26611 === (23))){
var state_26610__$1 = state_26610;
var statearr_26633_26674 = state_26610__$1;
(statearr_26633_26674[(2)] = null);

(statearr_26633_26674[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (19))){
var inst_26591 = (state_26610[(11)]);
var inst_26541 = (state_26610[(8)]);
var inst_26593 = cljs.core.async.muxch_STAR_.call(null,inst_26591);
var state_26610__$1 = state_26610;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26610__$1,(22),inst_26593,inst_26541);
} else {
if((state_val_26611 === (11))){
var inst_26551 = (state_26610[(12)]);
var inst_26565 = (state_26610[(10)]);
var inst_26565__$1 = cljs.core.seq.call(null,inst_26551);
var state_26610__$1 = (function (){var statearr_26634 = state_26610;
(statearr_26634[(10)] = inst_26565__$1);

return statearr_26634;
})();
if(inst_26565__$1){
var statearr_26635_26675 = state_26610__$1;
(statearr_26635_26675[(1)] = (13));

} else {
var statearr_26636_26676 = state_26610__$1;
(statearr_26636_26676[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (9))){
var inst_26587 = (state_26610[(2)]);
var state_26610__$1 = state_26610;
var statearr_26637_26677 = state_26610__$1;
(statearr_26637_26677[(2)] = inst_26587);

(statearr_26637_26677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (5))){
var inst_26548 = cljs.core.deref.call(null,mults);
var inst_26549 = cljs.core.vals.call(null,inst_26548);
var inst_26550 = cljs.core.seq.call(null,inst_26549);
var inst_26551 = inst_26550;
var inst_26552 = null;
var inst_26553 = (0);
var inst_26554 = (0);
var state_26610__$1 = (function (){var statearr_26638 = state_26610;
(statearr_26638[(12)] = inst_26551);

(statearr_26638[(14)] = inst_26553);

(statearr_26638[(15)] = inst_26554);

(statearr_26638[(16)] = inst_26552);

return statearr_26638;
})();
var statearr_26639_26678 = state_26610__$1;
(statearr_26639_26678[(2)] = null);

(statearr_26639_26678[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (14))){
var state_26610__$1 = state_26610;
var statearr_26643_26679 = state_26610__$1;
(statearr_26643_26679[(2)] = null);

(statearr_26643_26679[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (16))){
var inst_26565 = (state_26610[(10)]);
var inst_26569 = cljs.core.chunk_first.call(null,inst_26565);
var inst_26570 = cljs.core.chunk_rest.call(null,inst_26565);
var inst_26571 = cljs.core.count.call(null,inst_26569);
var inst_26551 = inst_26570;
var inst_26552 = inst_26569;
var inst_26553 = inst_26571;
var inst_26554 = (0);
var state_26610__$1 = (function (){var statearr_26644 = state_26610;
(statearr_26644[(12)] = inst_26551);

(statearr_26644[(14)] = inst_26553);

(statearr_26644[(15)] = inst_26554);

(statearr_26644[(16)] = inst_26552);

return statearr_26644;
})();
var statearr_26645_26680 = state_26610__$1;
(statearr_26645_26680[(2)] = null);

(statearr_26645_26680[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (10))){
var inst_26551 = (state_26610[(12)]);
var inst_26553 = (state_26610[(14)]);
var inst_26554 = (state_26610[(15)]);
var inst_26552 = (state_26610[(16)]);
var inst_26559 = cljs.core._nth.call(null,inst_26552,inst_26554);
var inst_26560 = cljs.core.async.muxch_STAR_.call(null,inst_26559);
var inst_26561 = cljs.core.async.close_BANG_.call(null,inst_26560);
var inst_26562 = (inst_26554 + (1));
var tmp26640 = inst_26551;
var tmp26641 = inst_26553;
var tmp26642 = inst_26552;
var inst_26551__$1 = tmp26640;
var inst_26552__$1 = tmp26642;
var inst_26553__$1 = tmp26641;
var inst_26554__$1 = inst_26562;
var state_26610__$1 = (function (){var statearr_26646 = state_26610;
(statearr_26646[(17)] = inst_26561);

(statearr_26646[(12)] = inst_26551__$1);

(statearr_26646[(14)] = inst_26553__$1);

(statearr_26646[(15)] = inst_26554__$1);

(statearr_26646[(16)] = inst_26552__$1);

return statearr_26646;
})();
var statearr_26647_26681 = state_26610__$1;
(statearr_26647_26681[(2)] = null);

(statearr_26647_26681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (18))){
var inst_26580 = (state_26610[(2)]);
var state_26610__$1 = state_26610;
var statearr_26648_26682 = state_26610__$1;
(statearr_26648_26682[(2)] = inst_26580);

(statearr_26648_26682[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26611 === (8))){
var inst_26553 = (state_26610[(14)]);
var inst_26554 = (state_26610[(15)]);
var inst_26556 = (inst_26554 < inst_26553);
var inst_26557 = inst_26556;
var state_26610__$1 = state_26610;
if(cljs.core.truth_(inst_26557)){
var statearr_26649_26683 = state_26610__$1;
(statearr_26649_26683[(1)] = (10));

} else {
var statearr_26650_26684 = state_26610__$1;
(statearr_26650_26684[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___26656,mults,ensure_mult,p))
;
return ((function (switch__25331__auto__,c__25422__auto___26656,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_26651 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26651[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_26651[(1)] = (1));

return statearr_26651;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_26610){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_26610);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e26652){if((e26652 instanceof Object)){
var ex__25335__auto__ = e26652;
var statearr_26653_26685 = state_26610;
(statearr_26653_26685[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26610);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26652;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26686 = state_26610;
state_26610 = G__26686;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_26610){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_26610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___26656,mults,ensure_mult,p))
})();
var state__25424__auto__ = (function (){var statearr_26654 = f__25423__auto__.call(null);
(statearr_26654[(6)] = c__25422__auto___26656);

return statearr_26654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___26656,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__26688 = arguments.length;
switch (G__26688) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__26691 = arguments.length;
switch (G__26691) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__26694 = arguments.length;
switch (G__26694) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__25422__auto___26761 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___26761,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___26761,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_26733){
var state_val_26734 = (state_26733[(1)]);
if((state_val_26734 === (7))){
var state_26733__$1 = state_26733;
var statearr_26735_26762 = state_26733__$1;
(statearr_26735_26762[(2)] = null);

(statearr_26735_26762[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (1))){
var state_26733__$1 = state_26733;
var statearr_26736_26763 = state_26733__$1;
(statearr_26736_26763[(2)] = null);

(statearr_26736_26763[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (4))){
var inst_26697 = (state_26733[(7)]);
var inst_26699 = (inst_26697 < cnt);
var state_26733__$1 = state_26733;
if(cljs.core.truth_(inst_26699)){
var statearr_26737_26764 = state_26733__$1;
(statearr_26737_26764[(1)] = (6));

} else {
var statearr_26738_26765 = state_26733__$1;
(statearr_26738_26765[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (15))){
var inst_26729 = (state_26733[(2)]);
var state_26733__$1 = state_26733;
var statearr_26739_26766 = state_26733__$1;
(statearr_26739_26766[(2)] = inst_26729);

(statearr_26739_26766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (13))){
var inst_26722 = cljs.core.async.close_BANG_.call(null,out);
var state_26733__$1 = state_26733;
var statearr_26740_26767 = state_26733__$1;
(statearr_26740_26767[(2)] = inst_26722);

(statearr_26740_26767[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (6))){
var state_26733__$1 = state_26733;
var statearr_26741_26768 = state_26733__$1;
(statearr_26741_26768[(2)] = null);

(statearr_26741_26768[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (3))){
var inst_26731 = (state_26733[(2)]);
var state_26733__$1 = state_26733;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26733__$1,inst_26731);
} else {
if((state_val_26734 === (12))){
var inst_26719 = (state_26733[(8)]);
var inst_26719__$1 = (state_26733[(2)]);
var inst_26720 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_26719__$1);
var state_26733__$1 = (function (){var statearr_26742 = state_26733;
(statearr_26742[(8)] = inst_26719__$1);

return statearr_26742;
})();
if(cljs.core.truth_(inst_26720)){
var statearr_26743_26769 = state_26733__$1;
(statearr_26743_26769[(1)] = (13));

} else {
var statearr_26744_26770 = state_26733__$1;
(statearr_26744_26770[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (2))){
var inst_26696 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_26697 = (0);
var state_26733__$1 = (function (){var statearr_26745 = state_26733;
(statearr_26745[(9)] = inst_26696);

(statearr_26745[(7)] = inst_26697);

return statearr_26745;
})();
var statearr_26746_26771 = state_26733__$1;
(statearr_26746_26771[(2)] = null);

(statearr_26746_26771[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (11))){
var inst_26697 = (state_26733[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_26733,(10),Object,null,(9));
var inst_26706 = chs__$1.call(null,inst_26697);
var inst_26707 = done.call(null,inst_26697);
var inst_26708 = cljs.core.async.take_BANG_.call(null,inst_26706,inst_26707);
var state_26733__$1 = state_26733;
var statearr_26747_26772 = state_26733__$1;
(statearr_26747_26772[(2)] = inst_26708);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26733__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (9))){
var inst_26697 = (state_26733[(7)]);
var inst_26710 = (state_26733[(2)]);
var inst_26711 = (inst_26697 + (1));
var inst_26697__$1 = inst_26711;
var state_26733__$1 = (function (){var statearr_26748 = state_26733;
(statearr_26748[(10)] = inst_26710);

(statearr_26748[(7)] = inst_26697__$1);

return statearr_26748;
})();
var statearr_26749_26773 = state_26733__$1;
(statearr_26749_26773[(2)] = null);

(statearr_26749_26773[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (5))){
var inst_26717 = (state_26733[(2)]);
var state_26733__$1 = (function (){var statearr_26750 = state_26733;
(statearr_26750[(11)] = inst_26717);

return statearr_26750;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26733__$1,(12),dchan);
} else {
if((state_val_26734 === (14))){
var inst_26719 = (state_26733[(8)]);
var inst_26724 = cljs.core.apply.call(null,f,inst_26719);
var state_26733__$1 = state_26733;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26733__$1,(16),out,inst_26724);
} else {
if((state_val_26734 === (16))){
var inst_26726 = (state_26733[(2)]);
var state_26733__$1 = (function (){var statearr_26751 = state_26733;
(statearr_26751[(12)] = inst_26726);

return statearr_26751;
})();
var statearr_26752_26774 = state_26733__$1;
(statearr_26752_26774[(2)] = null);

(statearr_26752_26774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (10))){
var inst_26701 = (state_26733[(2)]);
var inst_26702 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_26733__$1 = (function (){var statearr_26753 = state_26733;
(statearr_26753[(13)] = inst_26701);

return statearr_26753;
})();
var statearr_26754_26775 = state_26733__$1;
(statearr_26754_26775[(2)] = inst_26702);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26733__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26734 === (8))){
var inst_26715 = (state_26733[(2)]);
var state_26733__$1 = state_26733;
var statearr_26755_26776 = state_26733__$1;
(statearr_26755_26776[(2)] = inst_26715);

(statearr_26755_26776[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___26761,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__25331__auto__,c__25422__auto___26761,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_26756 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26756[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_26756[(1)] = (1));

return statearr_26756;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_26733){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_26733);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e26757){if((e26757 instanceof Object)){
var ex__25335__auto__ = e26757;
var statearr_26758_26777 = state_26733;
(statearr_26758_26777[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26733);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26757;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26778 = state_26733;
state_26733 = G__26778;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_26733){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_26733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___26761,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__25424__auto__ = (function (){var statearr_26759 = f__25423__auto__.call(null);
(statearr_26759[(6)] = c__25422__auto___26761);

return statearr_26759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___26761,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__26781 = arguments.length;
switch (G__26781) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25422__auto___26835 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___26835,out){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___26835,out){
return (function (state_26813){
var state_val_26814 = (state_26813[(1)]);
if((state_val_26814 === (7))){
var inst_26792 = (state_26813[(7)]);
var inst_26793 = (state_26813[(8)]);
var inst_26792__$1 = (state_26813[(2)]);
var inst_26793__$1 = cljs.core.nth.call(null,inst_26792__$1,(0),null);
var inst_26794 = cljs.core.nth.call(null,inst_26792__$1,(1),null);
var inst_26795 = (inst_26793__$1 == null);
var state_26813__$1 = (function (){var statearr_26815 = state_26813;
(statearr_26815[(7)] = inst_26792__$1);

(statearr_26815[(8)] = inst_26793__$1);

(statearr_26815[(9)] = inst_26794);

return statearr_26815;
})();
if(cljs.core.truth_(inst_26795)){
var statearr_26816_26836 = state_26813__$1;
(statearr_26816_26836[(1)] = (8));

} else {
var statearr_26817_26837 = state_26813__$1;
(statearr_26817_26837[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26814 === (1))){
var inst_26782 = cljs.core.vec.call(null,chs);
var inst_26783 = inst_26782;
var state_26813__$1 = (function (){var statearr_26818 = state_26813;
(statearr_26818[(10)] = inst_26783);

return statearr_26818;
})();
var statearr_26819_26838 = state_26813__$1;
(statearr_26819_26838[(2)] = null);

(statearr_26819_26838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26814 === (4))){
var inst_26783 = (state_26813[(10)]);
var state_26813__$1 = state_26813;
return cljs.core.async.ioc_alts_BANG_.call(null,state_26813__$1,(7),inst_26783);
} else {
if((state_val_26814 === (6))){
var inst_26809 = (state_26813[(2)]);
var state_26813__$1 = state_26813;
var statearr_26820_26839 = state_26813__$1;
(statearr_26820_26839[(2)] = inst_26809);

(statearr_26820_26839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26814 === (3))){
var inst_26811 = (state_26813[(2)]);
var state_26813__$1 = state_26813;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26813__$1,inst_26811);
} else {
if((state_val_26814 === (2))){
var inst_26783 = (state_26813[(10)]);
var inst_26785 = cljs.core.count.call(null,inst_26783);
var inst_26786 = (inst_26785 > (0));
var state_26813__$1 = state_26813;
if(cljs.core.truth_(inst_26786)){
var statearr_26822_26840 = state_26813__$1;
(statearr_26822_26840[(1)] = (4));

} else {
var statearr_26823_26841 = state_26813__$1;
(statearr_26823_26841[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26814 === (11))){
var inst_26783 = (state_26813[(10)]);
var inst_26802 = (state_26813[(2)]);
var tmp26821 = inst_26783;
var inst_26783__$1 = tmp26821;
var state_26813__$1 = (function (){var statearr_26824 = state_26813;
(statearr_26824[(10)] = inst_26783__$1);

(statearr_26824[(11)] = inst_26802);

return statearr_26824;
})();
var statearr_26825_26842 = state_26813__$1;
(statearr_26825_26842[(2)] = null);

(statearr_26825_26842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26814 === (9))){
var inst_26793 = (state_26813[(8)]);
var state_26813__$1 = state_26813;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26813__$1,(11),out,inst_26793);
} else {
if((state_val_26814 === (5))){
var inst_26807 = cljs.core.async.close_BANG_.call(null,out);
var state_26813__$1 = state_26813;
var statearr_26826_26843 = state_26813__$1;
(statearr_26826_26843[(2)] = inst_26807);

(statearr_26826_26843[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26814 === (10))){
var inst_26805 = (state_26813[(2)]);
var state_26813__$1 = state_26813;
var statearr_26827_26844 = state_26813__$1;
(statearr_26827_26844[(2)] = inst_26805);

(statearr_26827_26844[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26814 === (8))){
var inst_26783 = (state_26813[(10)]);
var inst_26792 = (state_26813[(7)]);
var inst_26793 = (state_26813[(8)]);
var inst_26794 = (state_26813[(9)]);
var inst_26797 = (function (){var cs = inst_26783;
var vec__26788 = inst_26792;
var v = inst_26793;
var c = inst_26794;
return ((function (cs,vec__26788,v,c,inst_26783,inst_26792,inst_26793,inst_26794,state_val_26814,c__25422__auto___26835,out){
return (function (p1__26779_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__26779_SHARP_);
});
;})(cs,vec__26788,v,c,inst_26783,inst_26792,inst_26793,inst_26794,state_val_26814,c__25422__auto___26835,out))
})();
var inst_26798 = cljs.core.filterv.call(null,inst_26797,inst_26783);
var inst_26783__$1 = inst_26798;
var state_26813__$1 = (function (){var statearr_26828 = state_26813;
(statearr_26828[(10)] = inst_26783__$1);

return statearr_26828;
})();
var statearr_26829_26845 = state_26813__$1;
(statearr_26829_26845[(2)] = null);

(statearr_26829_26845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___26835,out))
;
return ((function (switch__25331__auto__,c__25422__auto___26835,out){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_26830 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26830[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_26830[(1)] = (1));

return statearr_26830;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_26813){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_26813);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e26831){if((e26831 instanceof Object)){
var ex__25335__auto__ = e26831;
var statearr_26832_26846 = state_26813;
(statearr_26832_26846[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26813);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26831;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26847 = state_26813;
state_26813 = G__26847;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_26813){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_26813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___26835,out))
})();
var state__25424__auto__ = (function (){var statearr_26833 = f__25423__auto__.call(null);
(statearr_26833[(6)] = c__25422__auto___26835);

return statearr_26833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___26835,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__26849 = arguments.length;
switch (G__26849) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25422__auto___26894 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___26894,out){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___26894,out){
return (function (state_26873){
var state_val_26874 = (state_26873[(1)]);
if((state_val_26874 === (7))){
var inst_26855 = (state_26873[(7)]);
var inst_26855__$1 = (state_26873[(2)]);
var inst_26856 = (inst_26855__$1 == null);
var inst_26857 = cljs.core.not.call(null,inst_26856);
var state_26873__$1 = (function (){var statearr_26875 = state_26873;
(statearr_26875[(7)] = inst_26855__$1);

return statearr_26875;
})();
if(inst_26857){
var statearr_26876_26895 = state_26873__$1;
(statearr_26876_26895[(1)] = (8));

} else {
var statearr_26877_26896 = state_26873__$1;
(statearr_26877_26896[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26874 === (1))){
var inst_26850 = (0);
var state_26873__$1 = (function (){var statearr_26878 = state_26873;
(statearr_26878[(8)] = inst_26850);

return statearr_26878;
})();
var statearr_26879_26897 = state_26873__$1;
(statearr_26879_26897[(2)] = null);

(statearr_26879_26897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26874 === (4))){
var state_26873__$1 = state_26873;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26873__$1,(7),ch);
} else {
if((state_val_26874 === (6))){
var inst_26868 = (state_26873[(2)]);
var state_26873__$1 = state_26873;
var statearr_26880_26898 = state_26873__$1;
(statearr_26880_26898[(2)] = inst_26868);

(statearr_26880_26898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26874 === (3))){
var inst_26870 = (state_26873[(2)]);
var inst_26871 = cljs.core.async.close_BANG_.call(null,out);
var state_26873__$1 = (function (){var statearr_26881 = state_26873;
(statearr_26881[(9)] = inst_26870);

return statearr_26881;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26873__$1,inst_26871);
} else {
if((state_val_26874 === (2))){
var inst_26850 = (state_26873[(8)]);
var inst_26852 = (inst_26850 < n);
var state_26873__$1 = state_26873;
if(cljs.core.truth_(inst_26852)){
var statearr_26882_26899 = state_26873__$1;
(statearr_26882_26899[(1)] = (4));

} else {
var statearr_26883_26900 = state_26873__$1;
(statearr_26883_26900[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26874 === (11))){
var inst_26850 = (state_26873[(8)]);
var inst_26860 = (state_26873[(2)]);
var inst_26861 = (inst_26850 + (1));
var inst_26850__$1 = inst_26861;
var state_26873__$1 = (function (){var statearr_26884 = state_26873;
(statearr_26884[(8)] = inst_26850__$1);

(statearr_26884[(10)] = inst_26860);

return statearr_26884;
})();
var statearr_26885_26901 = state_26873__$1;
(statearr_26885_26901[(2)] = null);

(statearr_26885_26901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26874 === (9))){
var state_26873__$1 = state_26873;
var statearr_26886_26902 = state_26873__$1;
(statearr_26886_26902[(2)] = null);

(statearr_26886_26902[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26874 === (5))){
var state_26873__$1 = state_26873;
var statearr_26887_26903 = state_26873__$1;
(statearr_26887_26903[(2)] = null);

(statearr_26887_26903[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26874 === (10))){
var inst_26865 = (state_26873[(2)]);
var state_26873__$1 = state_26873;
var statearr_26888_26904 = state_26873__$1;
(statearr_26888_26904[(2)] = inst_26865);

(statearr_26888_26904[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26874 === (8))){
var inst_26855 = (state_26873[(7)]);
var state_26873__$1 = state_26873;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26873__$1,(11),out,inst_26855);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___26894,out))
;
return ((function (switch__25331__auto__,c__25422__auto___26894,out){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_26889 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26889[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_26889[(1)] = (1));

return statearr_26889;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_26873){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_26873);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e26890){if((e26890 instanceof Object)){
var ex__25335__auto__ = e26890;
var statearr_26891_26905 = state_26873;
(statearr_26891_26905[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26873);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26890;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26906 = state_26873;
state_26873 = G__26906;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_26873){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_26873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___26894,out))
})();
var state__25424__auto__ = (function (){var statearr_26892 = f__25423__auto__.call(null);
(statearr_26892[(6)] = c__25422__auto___26894);

return statearr_26892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___26894,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26908 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26908 = (function (f,ch,meta26909){
this.f = f;
this.ch = ch;
this.meta26909 = meta26909;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26910,meta26909__$1){
var self__ = this;
var _26910__$1 = this;
return (new cljs.core.async.t_cljs$core$async26908(self__.f,self__.ch,meta26909__$1));
});

cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26910){
var self__ = this;
var _26910__$1 = this;
return self__.meta26909;
});

cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26911 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26911 = (function (f,ch,meta26909,_,fn1,meta26912){
this.f = f;
this.ch = ch;
this.meta26909 = meta26909;
this._ = _;
this.fn1 = fn1;
this.meta26912 = meta26912;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26911.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_26913,meta26912__$1){
var self__ = this;
var _26913__$1 = this;
return (new cljs.core.async.t_cljs$core$async26911(self__.f,self__.ch,self__.meta26909,self__._,self__.fn1,meta26912__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async26911.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_26913){
var self__ = this;
var _26913__$1 = this;
return self__.meta26912;
});})(___$1))
;

cljs.core.async.t_cljs$core$async26911.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26911.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async26911.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async26911.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__26907_SHARP_){
return f1.call(null,(((p1__26907_SHARP_ == null))?null:self__.f.call(null,p1__26907_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async26911.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26909","meta26909",1563610895,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async26908","cljs.core.async/t_cljs$core$async26908",-767171577,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta26912","meta26912",562457948,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async26911.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26911.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26911";

cljs.core.async.t_cljs$core$async26911.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26911");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26911.
 */
cljs.core.async.__GT_t_cljs$core$async26911 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async26911(f__$1,ch__$1,meta26909__$1,___$2,fn1__$1,meta26912){
return (new cljs.core.async.t_cljs$core$async26911(f__$1,ch__$1,meta26909__$1,___$2,fn1__$1,meta26912));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async26911(self__.f,self__.ch,self__.meta26909,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3938__auto__ = ret;
if(cljs.core.truth_(and__3938__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3938__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26908.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async26908.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26909","meta26909",1563610895,null)], null);
});

cljs.core.async.t_cljs$core$async26908.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26908.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26908";

cljs.core.async.t_cljs$core$async26908.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26908");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26908.
 */
cljs.core.async.__GT_t_cljs$core$async26908 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async26908(f__$1,ch__$1,meta26909){
return (new cljs.core.async.t_cljs$core$async26908(f__$1,ch__$1,meta26909));
});

}

return (new cljs.core.async.t_cljs$core$async26908(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26914 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26914 = (function (f,ch,meta26915){
this.f = f;
this.ch = ch;
this.meta26915 = meta26915;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26916,meta26915__$1){
var self__ = this;
var _26916__$1 = this;
return (new cljs.core.async.t_cljs$core$async26914(self__.f,self__.ch,meta26915__$1));
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26916){
var self__ = this;
var _26916__$1 = this;
return self__.meta26915;
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26914.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async26914.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26915","meta26915",1217540167,null)], null);
});

cljs.core.async.t_cljs$core$async26914.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26914.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26914";

cljs.core.async.t_cljs$core$async26914.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26914");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26914.
 */
cljs.core.async.__GT_t_cljs$core$async26914 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async26914(f__$1,ch__$1,meta26915){
return (new cljs.core.async.t_cljs$core$async26914(f__$1,ch__$1,meta26915));
});

}

return (new cljs.core.async.t_cljs$core$async26914(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26917 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26917 = (function (p,ch,meta26918){
this.p = p;
this.ch = ch;
this.meta26918 = meta26918;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26919,meta26918__$1){
var self__ = this;
var _26919__$1 = this;
return (new cljs.core.async.t_cljs$core$async26917(self__.p,self__.ch,meta26918__$1));
});

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26919){
var self__ = this;
var _26919__$1 = this;
return self__.meta26918;
});

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26917.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async26917.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26918","meta26918",1085690943,null)], null);
});

cljs.core.async.t_cljs$core$async26917.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26917.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26917";

cljs.core.async.t_cljs$core$async26917.cljs$lang$ctorPrWriter = (function (this__4192__auto__,writer__4193__auto__,opt__4194__auto__){
return cljs.core._write.call(null,writer__4193__auto__,"cljs.core.async/t_cljs$core$async26917");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26917.
 */
cljs.core.async.__GT_t_cljs$core$async26917 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async26917(p__$1,ch__$1,meta26918){
return (new cljs.core.async.t_cljs$core$async26917(p__$1,ch__$1,meta26918));
});

}

return (new cljs.core.async.t_cljs$core$async26917(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__26921 = arguments.length;
switch (G__26921) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25422__auto___26961 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___26961,out){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___26961,out){
return (function (state_26942){
var state_val_26943 = (state_26942[(1)]);
if((state_val_26943 === (7))){
var inst_26938 = (state_26942[(2)]);
var state_26942__$1 = state_26942;
var statearr_26944_26962 = state_26942__$1;
(statearr_26944_26962[(2)] = inst_26938);

(statearr_26944_26962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26943 === (1))){
var state_26942__$1 = state_26942;
var statearr_26945_26963 = state_26942__$1;
(statearr_26945_26963[(2)] = null);

(statearr_26945_26963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26943 === (4))){
var inst_26924 = (state_26942[(7)]);
var inst_26924__$1 = (state_26942[(2)]);
var inst_26925 = (inst_26924__$1 == null);
var state_26942__$1 = (function (){var statearr_26946 = state_26942;
(statearr_26946[(7)] = inst_26924__$1);

return statearr_26946;
})();
if(cljs.core.truth_(inst_26925)){
var statearr_26947_26964 = state_26942__$1;
(statearr_26947_26964[(1)] = (5));

} else {
var statearr_26948_26965 = state_26942__$1;
(statearr_26948_26965[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26943 === (6))){
var inst_26924 = (state_26942[(7)]);
var inst_26929 = p.call(null,inst_26924);
var state_26942__$1 = state_26942;
if(cljs.core.truth_(inst_26929)){
var statearr_26949_26966 = state_26942__$1;
(statearr_26949_26966[(1)] = (8));

} else {
var statearr_26950_26967 = state_26942__$1;
(statearr_26950_26967[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26943 === (3))){
var inst_26940 = (state_26942[(2)]);
var state_26942__$1 = state_26942;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26942__$1,inst_26940);
} else {
if((state_val_26943 === (2))){
var state_26942__$1 = state_26942;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26942__$1,(4),ch);
} else {
if((state_val_26943 === (11))){
var inst_26932 = (state_26942[(2)]);
var state_26942__$1 = state_26942;
var statearr_26951_26968 = state_26942__$1;
(statearr_26951_26968[(2)] = inst_26932);

(statearr_26951_26968[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26943 === (9))){
var state_26942__$1 = state_26942;
var statearr_26952_26969 = state_26942__$1;
(statearr_26952_26969[(2)] = null);

(statearr_26952_26969[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26943 === (5))){
var inst_26927 = cljs.core.async.close_BANG_.call(null,out);
var state_26942__$1 = state_26942;
var statearr_26953_26970 = state_26942__$1;
(statearr_26953_26970[(2)] = inst_26927);

(statearr_26953_26970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26943 === (10))){
var inst_26935 = (state_26942[(2)]);
var state_26942__$1 = (function (){var statearr_26954 = state_26942;
(statearr_26954[(8)] = inst_26935);

return statearr_26954;
})();
var statearr_26955_26971 = state_26942__$1;
(statearr_26955_26971[(2)] = null);

(statearr_26955_26971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26943 === (8))){
var inst_26924 = (state_26942[(7)]);
var state_26942__$1 = state_26942;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26942__$1,(11),out,inst_26924);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___26961,out))
;
return ((function (switch__25331__auto__,c__25422__auto___26961,out){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_26956 = [null,null,null,null,null,null,null,null,null];
(statearr_26956[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_26956[(1)] = (1));

return statearr_26956;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_26942){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_26942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e26957){if((e26957 instanceof Object)){
var ex__25335__auto__ = e26957;
var statearr_26958_26972 = state_26942;
(statearr_26958_26972[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26942);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26957;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26973 = state_26942;
state_26942 = G__26973;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_26942){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_26942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___26961,out))
})();
var state__25424__auto__ = (function (){var statearr_26959 = f__25423__auto__.call(null);
(statearr_26959[(6)] = c__25422__auto___26961);

return statearr_26959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___26961,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__26975 = arguments.length;
switch (G__26975) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__){
return (function (state_27038){
var state_val_27039 = (state_27038[(1)]);
if((state_val_27039 === (7))){
var inst_27034 = (state_27038[(2)]);
var state_27038__$1 = state_27038;
var statearr_27040_27078 = state_27038__$1;
(statearr_27040_27078[(2)] = inst_27034);

(statearr_27040_27078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (20))){
var inst_27004 = (state_27038[(7)]);
var inst_27015 = (state_27038[(2)]);
var inst_27016 = cljs.core.next.call(null,inst_27004);
var inst_26990 = inst_27016;
var inst_26991 = null;
var inst_26992 = (0);
var inst_26993 = (0);
var state_27038__$1 = (function (){var statearr_27041 = state_27038;
(statearr_27041[(8)] = inst_27015);

(statearr_27041[(9)] = inst_26991);

(statearr_27041[(10)] = inst_26992);

(statearr_27041[(11)] = inst_26990);

(statearr_27041[(12)] = inst_26993);

return statearr_27041;
})();
var statearr_27042_27079 = state_27038__$1;
(statearr_27042_27079[(2)] = null);

(statearr_27042_27079[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (1))){
var state_27038__$1 = state_27038;
var statearr_27043_27080 = state_27038__$1;
(statearr_27043_27080[(2)] = null);

(statearr_27043_27080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (4))){
var inst_26979 = (state_27038[(13)]);
var inst_26979__$1 = (state_27038[(2)]);
var inst_26980 = (inst_26979__$1 == null);
var state_27038__$1 = (function (){var statearr_27044 = state_27038;
(statearr_27044[(13)] = inst_26979__$1);

return statearr_27044;
})();
if(cljs.core.truth_(inst_26980)){
var statearr_27045_27081 = state_27038__$1;
(statearr_27045_27081[(1)] = (5));

} else {
var statearr_27046_27082 = state_27038__$1;
(statearr_27046_27082[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (15))){
var state_27038__$1 = state_27038;
var statearr_27050_27083 = state_27038__$1;
(statearr_27050_27083[(2)] = null);

(statearr_27050_27083[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (21))){
var state_27038__$1 = state_27038;
var statearr_27051_27084 = state_27038__$1;
(statearr_27051_27084[(2)] = null);

(statearr_27051_27084[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (13))){
var inst_26991 = (state_27038[(9)]);
var inst_26992 = (state_27038[(10)]);
var inst_26990 = (state_27038[(11)]);
var inst_26993 = (state_27038[(12)]);
var inst_27000 = (state_27038[(2)]);
var inst_27001 = (inst_26993 + (1));
var tmp27047 = inst_26991;
var tmp27048 = inst_26992;
var tmp27049 = inst_26990;
var inst_26990__$1 = tmp27049;
var inst_26991__$1 = tmp27047;
var inst_26992__$1 = tmp27048;
var inst_26993__$1 = inst_27001;
var state_27038__$1 = (function (){var statearr_27052 = state_27038;
(statearr_27052[(9)] = inst_26991__$1);

(statearr_27052[(10)] = inst_26992__$1);

(statearr_27052[(11)] = inst_26990__$1);

(statearr_27052[(12)] = inst_26993__$1);

(statearr_27052[(14)] = inst_27000);

return statearr_27052;
})();
var statearr_27053_27085 = state_27038__$1;
(statearr_27053_27085[(2)] = null);

(statearr_27053_27085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (22))){
var state_27038__$1 = state_27038;
var statearr_27054_27086 = state_27038__$1;
(statearr_27054_27086[(2)] = null);

(statearr_27054_27086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (6))){
var inst_26979 = (state_27038[(13)]);
var inst_26988 = f.call(null,inst_26979);
var inst_26989 = cljs.core.seq.call(null,inst_26988);
var inst_26990 = inst_26989;
var inst_26991 = null;
var inst_26992 = (0);
var inst_26993 = (0);
var state_27038__$1 = (function (){var statearr_27055 = state_27038;
(statearr_27055[(9)] = inst_26991);

(statearr_27055[(10)] = inst_26992);

(statearr_27055[(11)] = inst_26990);

(statearr_27055[(12)] = inst_26993);

return statearr_27055;
})();
var statearr_27056_27087 = state_27038__$1;
(statearr_27056_27087[(2)] = null);

(statearr_27056_27087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (17))){
var inst_27004 = (state_27038[(7)]);
var inst_27008 = cljs.core.chunk_first.call(null,inst_27004);
var inst_27009 = cljs.core.chunk_rest.call(null,inst_27004);
var inst_27010 = cljs.core.count.call(null,inst_27008);
var inst_26990 = inst_27009;
var inst_26991 = inst_27008;
var inst_26992 = inst_27010;
var inst_26993 = (0);
var state_27038__$1 = (function (){var statearr_27057 = state_27038;
(statearr_27057[(9)] = inst_26991);

(statearr_27057[(10)] = inst_26992);

(statearr_27057[(11)] = inst_26990);

(statearr_27057[(12)] = inst_26993);

return statearr_27057;
})();
var statearr_27058_27088 = state_27038__$1;
(statearr_27058_27088[(2)] = null);

(statearr_27058_27088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (3))){
var inst_27036 = (state_27038[(2)]);
var state_27038__$1 = state_27038;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27038__$1,inst_27036);
} else {
if((state_val_27039 === (12))){
var inst_27024 = (state_27038[(2)]);
var state_27038__$1 = state_27038;
var statearr_27059_27089 = state_27038__$1;
(statearr_27059_27089[(2)] = inst_27024);

(statearr_27059_27089[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (2))){
var state_27038__$1 = state_27038;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27038__$1,(4),in$);
} else {
if((state_val_27039 === (23))){
var inst_27032 = (state_27038[(2)]);
var state_27038__$1 = state_27038;
var statearr_27060_27090 = state_27038__$1;
(statearr_27060_27090[(2)] = inst_27032);

(statearr_27060_27090[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (19))){
var inst_27019 = (state_27038[(2)]);
var state_27038__$1 = state_27038;
var statearr_27061_27091 = state_27038__$1;
(statearr_27061_27091[(2)] = inst_27019);

(statearr_27061_27091[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (11))){
var inst_27004 = (state_27038[(7)]);
var inst_26990 = (state_27038[(11)]);
var inst_27004__$1 = cljs.core.seq.call(null,inst_26990);
var state_27038__$1 = (function (){var statearr_27062 = state_27038;
(statearr_27062[(7)] = inst_27004__$1);

return statearr_27062;
})();
if(inst_27004__$1){
var statearr_27063_27092 = state_27038__$1;
(statearr_27063_27092[(1)] = (14));

} else {
var statearr_27064_27093 = state_27038__$1;
(statearr_27064_27093[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (9))){
var inst_27026 = (state_27038[(2)]);
var inst_27027 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_27038__$1 = (function (){var statearr_27065 = state_27038;
(statearr_27065[(15)] = inst_27026);

return statearr_27065;
})();
if(cljs.core.truth_(inst_27027)){
var statearr_27066_27094 = state_27038__$1;
(statearr_27066_27094[(1)] = (21));

} else {
var statearr_27067_27095 = state_27038__$1;
(statearr_27067_27095[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (5))){
var inst_26982 = cljs.core.async.close_BANG_.call(null,out);
var state_27038__$1 = state_27038;
var statearr_27068_27096 = state_27038__$1;
(statearr_27068_27096[(2)] = inst_26982);

(statearr_27068_27096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (14))){
var inst_27004 = (state_27038[(7)]);
var inst_27006 = cljs.core.chunked_seq_QMARK_.call(null,inst_27004);
var state_27038__$1 = state_27038;
if(inst_27006){
var statearr_27069_27097 = state_27038__$1;
(statearr_27069_27097[(1)] = (17));

} else {
var statearr_27070_27098 = state_27038__$1;
(statearr_27070_27098[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (16))){
var inst_27022 = (state_27038[(2)]);
var state_27038__$1 = state_27038;
var statearr_27071_27099 = state_27038__$1;
(statearr_27071_27099[(2)] = inst_27022);

(statearr_27071_27099[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27039 === (10))){
var inst_26991 = (state_27038[(9)]);
var inst_26993 = (state_27038[(12)]);
var inst_26998 = cljs.core._nth.call(null,inst_26991,inst_26993);
var state_27038__$1 = state_27038;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27038__$1,(13),out,inst_26998);
} else {
if((state_val_27039 === (18))){
var inst_27004 = (state_27038[(7)]);
var inst_27013 = cljs.core.first.call(null,inst_27004);
var state_27038__$1 = state_27038;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27038__$1,(20),out,inst_27013);
} else {
if((state_val_27039 === (8))){
var inst_26992 = (state_27038[(10)]);
var inst_26993 = (state_27038[(12)]);
var inst_26995 = (inst_26993 < inst_26992);
var inst_26996 = inst_26995;
var state_27038__$1 = state_27038;
if(cljs.core.truth_(inst_26996)){
var statearr_27072_27100 = state_27038__$1;
(statearr_27072_27100[(1)] = (10));

} else {
var statearr_27073_27101 = state_27038__$1;
(statearr_27073_27101[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto__))
;
return ((function (switch__25331__auto__,c__25422__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__25332__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__25332__auto____0 = (function (){
var statearr_27074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27074[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__25332__auto__);

(statearr_27074[(1)] = (1));

return statearr_27074;
});
var cljs$core$async$mapcat_STAR__$_state_machine__25332__auto____1 = (function (state_27038){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_27038);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e27075){if((e27075 instanceof Object)){
var ex__25335__auto__ = e27075;
var statearr_27076_27102 = state_27038;
(statearr_27076_27102[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27038);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27075;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27103 = state_27038;
state_27038 = G__27103;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__25332__auto__ = function(state_27038){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__25332__auto____1.call(this,state_27038);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__25332__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__25332__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__))
})();
var state__25424__auto__ = (function (){var statearr_27077 = f__25423__auto__.call(null);
(statearr_27077[(6)] = c__25422__auto__);

return statearr_27077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__))
);

return c__25422__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__27105 = arguments.length;
switch (G__27105) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__27108 = arguments.length;
switch (G__27108) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__27111 = arguments.length;
switch (G__27111) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25422__auto___27158 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___27158,out){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___27158,out){
return (function (state_27135){
var state_val_27136 = (state_27135[(1)]);
if((state_val_27136 === (7))){
var inst_27130 = (state_27135[(2)]);
var state_27135__$1 = state_27135;
var statearr_27137_27159 = state_27135__$1;
(statearr_27137_27159[(2)] = inst_27130);

(statearr_27137_27159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (1))){
var inst_27112 = null;
var state_27135__$1 = (function (){var statearr_27138 = state_27135;
(statearr_27138[(7)] = inst_27112);

return statearr_27138;
})();
var statearr_27139_27160 = state_27135__$1;
(statearr_27139_27160[(2)] = null);

(statearr_27139_27160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (4))){
var inst_27115 = (state_27135[(8)]);
var inst_27115__$1 = (state_27135[(2)]);
var inst_27116 = (inst_27115__$1 == null);
var inst_27117 = cljs.core.not.call(null,inst_27116);
var state_27135__$1 = (function (){var statearr_27140 = state_27135;
(statearr_27140[(8)] = inst_27115__$1);

return statearr_27140;
})();
if(inst_27117){
var statearr_27141_27161 = state_27135__$1;
(statearr_27141_27161[(1)] = (5));

} else {
var statearr_27142_27162 = state_27135__$1;
(statearr_27142_27162[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (6))){
var state_27135__$1 = state_27135;
var statearr_27143_27163 = state_27135__$1;
(statearr_27143_27163[(2)] = null);

(statearr_27143_27163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (3))){
var inst_27132 = (state_27135[(2)]);
var inst_27133 = cljs.core.async.close_BANG_.call(null,out);
var state_27135__$1 = (function (){var statearr_27144 = state_27135;
(statearr_27144[(9)] = inst_27132);

return statearr_27144;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27135__$1,inst_27133);
} else {
if((state_val_27136 === (2))){
var state_27135__$1 = state_27135;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27135__$1,(4),ch);
} else {
if((state_val_27136 === (11))){
var inst_27115 = (state_27135[(8)]);
var inst_27124 = (state_27135[(2)]);
var inst_27112 = inst_27115;
var state_27135__$1 = (function (){var statearr_27145 = state_27135;
(statearr_27145[(10)] = inst_27124);

(statearr_27145[(7)] = inst_27112);

return statearr_27145;
})();
var statearr_27146_27164 = state_27135__$1;
(statearr_27146_27164[(2)] = null);

(statearr_27146_27164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (9))){
var inst_27115 = (state_27135[(8)]);
var state_27135__$1 = state_27135;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27135__$1,(11),out,inst_27115);
} else {
if((state_val_27136 === (5))){
var inst_27112 = (state_27135[(7)]);
var inst_27115 = (state_27135[(8)]);
var inst_27119 = cljs.core._EQ_.call(null,inst_27115,inst_27112);
var state_27135__$1 = state_27135;
if(inst_27119){
var statearr_27148_27165 = state_27135__$1;
(statearr_27148_27165[(1)] = (8));

} else {
var statearr_27149_27166 = state_27135__$1;
(statearr_27149_27166[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (10))){
var inst_27127 = (state_27135[(2)]);
var state_27135__$1 = state_27135;
var statearr_27150_27167 = state_27135__$1;
(statearr_27150_27167[(2)] = inst_27127);

(statearr_27150_27167[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27136 === (8))){
var inst_27112 = (state_27135[(7)]);
var tmp27147 = inst_27112;
var inst_27112__$1 = tmp27147;
var state_27135__$1 = (function (){var statearr_27151 = state_27135;
(statearr_27151[(7)] = inst_27112__$1);

return statearr_27151;
})();
var statearr_27152_27168 = state_27135__$1;
(statearr_27152_27168[(2)] = null);

(statearr_27152_27168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___27158,out))
;
return ((function (switch__25331__auto__,c__25422__auto___27158,out){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_27153 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27153[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_27153[(1)] = (1));

return statearr_27153;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_27135){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_27135);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e27154){if((e27154 instanceof Object)){
var ex__25335__auto__ = e27154;
var statearr_27155_27169 = state_27135;
(statearr_27155_27169[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27135);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27154;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27170 = state_27135;
state_27135 = G__27170;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_27135){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_27135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___27158,out))
})();
var state__25424__auto__ = (function (){var statearr_27156 = f__25423__auto__.call(null);
(statearr_27156[(6)] = c__25422__auto___27158);

return statearr_27156;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___27158,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__27172 = arguments.length;
switch (G__27172) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25422__auto___27238 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___27238,out){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___27238,out){
return (function (state_27210){
var state_val_27211 = (state_27210[(1)]);
if((state_val_27211 === (7))){
var inst_27206 = (state_27210[(2)]);
var state_27210__$1 = state_27210;
var statearr_27212_27239 = state_27210__$1;
(statearr_27212_27239[(2)] = inst_27206);

(statearr_27212_27239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (1))){
var inst_27173 = (new Array(n));
var inst_27174 = inst_27173;
var inst_27175 = (0);
var state_27210__$1 = (function (){var statearr_27213 = state_27210;
(statearr_27213[(7)] = inst_27175);

(statearr_27213[(8)] = inst_27174);

return statearr_27213;
})();
var statearr_27214_27240 = state_27210__$1;
(statearr_27214_27240[(2)] = null);

(statearr_27214_27240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (4))){
var inst_27178 = (state_27210[(9)]);
var inst_27178__$1 = (state_27210[(2)]);
var inst_27179 = (inst_27178__$1 == null);
var inst_27180 = cljs.core.not.call(null,inst_27179);
var state_27210__$1 = (function (){var statearr_27215 = state_27210;
(statearr_27215[(9)] = inst_27178__$1);

return statearr_27215;
})();
if(inst_27180){
var statearr_27216_27241 = state_27210__$1;
(statearr_27216_27241[(1)] = (5));

} else {
var statearr_27217_27242 = state_27210__$1;
(statearr_27217_27242[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (15))){
var inst_27200 = (state_27210[(2)]);
var state_27210__$1 = state_27210;
var statearr_27218_27243 = state_27210__$1;
(statearr_27218_27243[(2)] = inst_27200);

(statearr_27218_27243[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (13))){
var state_27210__$1 = state_27210;
var statearr_27219_27244 = state_27210__$1;
(statearr_27219_27244[(2)] = null);

(statearr_27219_27244[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (6))){
var inst_27175 = (state_27210[(7)]);
var inst_27196 = (inst_27175 > (0));
var state_27210__$1 = state_27210;
if(cljs.core.truth_(inst_27196)){
var statearr_27220_27245 = state_27210__$1;
(statearr_27220_27245[(1)] = (12));

} else {
var statearr_27221_27246 = state_27210__$1;
(statearr_27221_27246[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (3))){
var inst_27208 = (state_27210[(2)]);
var state_27210__$1 = state_27210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27210__$1,inst_27208);
} else {
if((state_val_27211 === (12))){
var inst_27174 = (state_27210[(8)]);
var inst_27198 = cljs.core.vec.call(null,inst_27174);
var state_27210__$1 = state_27210;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27210__$1,(15),out,inst_27198);
} else {
if((state_val_27211 === (2))){
var state_27210__$1 = state_27210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27210__$1,(4),ch);
} else {
if((state_val_27211 === (11))){
var inst_27190 = (state_27210[(2)]);
var inst_27191 = (new Array(n));
var inst_27174 = inst_27191;
var inst_27175 = (0);
var state_27210__$1 = (function (){var statearr_27222 = state_27210;
(statearr_27222[(7)] = inst_27175);

(statearr_27222[(10)] = inst_27190);

(statearr_27222[(8)] = inst_27174);

return statearr_27222;
})();
var statearr_27223_27247 = state_27210__$1;
(statearr_27223_27247[(2)] = null);

(statearr_27223_27247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (9))){
var inst_27174 = (state_27210[(8)]);
var inst_27188 = cljs.core.vec.call(null,inst_27174);
var state_27210__$1 = state_27210;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27210__$1,(11),out,inst_27188);
} else {
if((state_val_27211 === (5))){
var inst_27178 = (state_27210[(9)]);
var inst_27175 = (state_27210[(7)]);
var inst_27174 = (state_27210[(8)]);
var inst_27183 = (state_27210[(11)]);
var inst_27182 = (inst_27174[inst_27175] = inst_27178);
var inst_27183__$1 = (inst_27175 + (1));
var inst_27184 = (inst_27183__$1 < n);
var state_27210__$1 = (function (){var statearr_27224 = state_27210;
(statearr_27224[(12)] = inst_27182);

(statearr_27224[(11)] = inst_27183__$1);

return statearr_27224;
})();
if(cljs.core.truth_(inst_27184)){
var statearr_27225_27248 = state_27210__$1;
(statearr_27225_27248[(1)] = (8));

} else {
var statearr_27226_27249 = state_27210__$1;
(statearr_27226_27249[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (14))){
var inst_27203 = (state_27210[(2)]);
var inst_27204 = cljs.core.async.close_BANG_.call(null,out);
var state_27210__$1 = (function (){var statearr_27228 = state_27210;
(statearr_27228[(13)] = inst_27203);

return statearr_27228;
})();
var statearr_27229_27250 = state_27210__$1;
(statearr_27229_27250[(2)] = inst_27204);

(statearr_27229_27250[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (10))){
var inst_27194 = (state_27210[(2)]);
var state_27210__$1 = state_27210;
var statearr_27230_27251 = state_27210__$1;
(statearr_27230_27251[(2)] = inst_27194);

(statearr_27230_27251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27211 === (8))){
var inst_27174 = (state_27210[(8)]);
var inst_27183 = (state_27210[(11)]);
var tmp27227 = inst_27174;
var inst_27174__$1 = tmp27227;
var inst_27175 = inst_27183;
var state_27210__$1 = (function (){var statearr_27231 = state_27210;
(statearr_27231[(7)] = inst_27175);

(statearr_27231[(8)] = inst_27174__$1);

return statearr_27231;
})();
var statearr_27232_27252 = state_27210__$1;
(statearr_27232_27252[(2)] = null);

(statearr_27232_27252[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___27238,out))
;
return ((function (switch__25331__auto__,c__25422__auto___27238,out){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_27233 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27233[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_27233[(1)] = (1));

return statearr_27233;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_27210){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_27210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e27234){if((e27234 instanceof Object)){
var ex__25335__auto__ = e27234;
var statearr_27235_27253 = state_27210;
(statearr_27235_27253[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27210);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27234;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27254 = state_27210;
state_27210 = G__27254;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_27210){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_27210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___27238,out))
})();
var state__25424__auto__ = (function (){var statearr_27236 = f__25423__auto__.call(null);
(statearr_27236[(6)] = c__25422__auto___27238);

return statearr_27236;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___27238,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__27256 = arguments.length;
switch (G__27256) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25422__auto___27326 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___27326,out){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___27326,out){
return (function (state_27298){
var state_val_27299 = (state_27298[(1)]);
if((state_val_27299 === (7))){
var inst_27294 = (state_27298[(2)]);
var state_27298__$1 = state_27298;
var statearr_27300_27327 = state_27298__$1;
(statearr_27300_27327[(2)] = inst_27294);

(statearr_27300_27327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (1))){
var inst_27257 = [];
var inst_27258 = inst_27257;
var inst_27259 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_27298__$1 = (function (){var statearr_27301 = state_27298;
(statearr_27301[(7)] = inst_27259);

(statearr_27301[(8)] = inst_27258);

return statearr_27301;
})();
var statearr_27302_27328 = state_27298__$1;
(statearr_27302_27328[(2)] = null);

(statearr_27302_27328[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (4))){
var inst_27262 = (state_27298[(9)]);
var inst_27262__$1 = (state_27298[(2)]);
var inst_27263 = (inst_27262__$1 == null);
var inst_27264 = cljs.core.not.call(null,inst_27263);
var state_27298__$1 = (function (){var statearr_27303 = state_27298;
(statearr_27303[(9)] = inst_27262__$1);

return statearr_27303;
})();
if(inst_27264){
var statearr_27304_27329 = state_27298__$1;
(statearr_27304_27329[(1)] = (5));

} else {
var statearr_27305_27330 = state_27298__$1;
(statearr_27305_27330[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (15))){
var inst_27288 = (state_27298[(2)]);
var state_27298__$1 = state_27298;
var statearr_27306_27331 = state_27298__$1;
(statearr_27306_27331[(2)] = inst_27288);

(statearr_27306_27331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (13))){
var state_27298__$1 = state_27298;
var statearr_27307_27332 = state_27298__$1;
(statearr_27307_27332[(2)] = null);

(statearr_27307_27332[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (6))){
var inst_27258 = (state_27298[(8)]);
var inst_27283 = inst_27258.length;
var inst_27284 = (inst_27283 > (0));
var state_27298__$1 = state_27298;
if(cljs.core.truth_(inst_27284)){
var statearr_27308_27333 = state_27298__$1;
(statearr_27308_27333[(1)] = (12));

} else {
var statearr_27309_27334 = state_27298__$1;
(statearr_27309_27334[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (3))){
var inst_27296 = (state_27298[(2)]);
var state_27298__$1 = state_27298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27298__$1,inst_27296);
} else {
if((state_val_27299 === (12))){
var inst_27258 = (state_27298[(8)]);
var inst_27286 = cljs.core.vec.call(null,inst_27258);
var state_27298__$1 = state_27298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27298__$1,(15),out,inst_27286);
} else {
if((state_val_27299 === (2))){
var state_27298__$1 = state_27298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27298__$1,(4),ch);
} else {
if((state_val_27299 === (11))){
var inst_27266 = (state_27298[(10)]);
var inst_27262 = (state_27298[(9)]);
var inst_27276 = (state_27298[(2)]);
var inst_27277 = [];
var inst_27278 = inst_27277.push(inst_27262);
var inst_27258 = inst_27277;
var inst_27259 = inst_27266;
var state_27298__$1 = (function (){var statearr_27310 = state_27298;
(statearr_27310[(7)] = inst_27259);

(statearr_27310[(8)] = inst_27258);

(statearr_27310[(11)] = inst_27278);

(statearr_27310[(12)] = inst_27276);

return statearr_27310;
})();
var statearr_27311_27335 = state_27298__$1;
(statearr_27311_27335[(2)] = null);

(statearr_27311_27335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (9))){
var inst_27258 = (state_27298[(8)]);
var inst_27274 = cljs.core.vec.call(null,inst_27258);
var state_27298__$1 = state_27298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27298__$1,(11),out,inst_27274);
} else {
if((state_val_27299 === (5))){
var inst_27259 = (state_27298[(7)]);
var inst_27266 = (state_27298[(10)]);
var inst_27262 = (state_27298[(9)]);
var inst_27266__$1 = f.call(null,inst_27262);
var inst_27267 = cljs.core._EQ_.call(null,inst_27266__$1,inst_27259);
var inst_27268 = cljs.core.keyword_identical_QMARK_.call(null,inst_27259,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_27269 = ((inst_27267) || (inst_27268));
var state_27298__$1 = (function (){var statearr_27312 = state_27298;
(statearr_27312[(10)] = inst_27266__$1);

return statearr_27312;
})();
if(cljs.core.truth_(inst_27269)){
var statearr_27313_27336 = state_27298__$1;
(statearr_27313_27336[(1)] = (8));

} else {
var statearr_27314_27337 = state_27298__$1;
(statearr_27314_27337[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (14))){
var inst_27291 = (state_27298[(2)]);
var inst_27292 = cljs.core.async.close_BANG_.call(null,out);
var state_27298__$1 = (function (){var statearr_27316 = state_27298;
(statearr_27316[(13)] = inst_27291);

return statearr_27316;
})();
var statearr_27317_27338 = state_27298__$1;
(statearr_27317_27338[(2)] = inst_27292);

(statearr_27317_27338[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (10))){
var inst_27281 = (state_27298[(2)]);
var state_27298__$1 = state_27298;
var statearr_27318_27339 = state_27298__$1;
(statearr_27318_27339[(2)] = inst_27281);

(statearr_27318_27339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27299 === (8))){
var inst_27258 = (state_27298[(8)]);
var inst_27266 = (state_27298[(10)]);
var inst_27262 = (state_27298[(9)]);
var inst_27271 = inst_27258.push(inst_27262);
var tmp27315 = inst_27258;
var inst_27258__$1 = tmp27315;
var inst_27259 = inst_27266;
var state_27298__$1 = (function (){var statearr_27319 = state_27298;
(statearr_27319[(7)] = inst_27259);

(statearr_27319[(8)] = inst_27258__$1);

(statearr_27319[(14)] = inst_27271);

return statearr_27319;
})();
var statearr_27320_27340 = state_27298__$1;
(statearr_27320_27340[(2)] = null);

(statearr_27320_27340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___27326,out))
;
return ((function (switch__25331__auto__,c__25422__auto___27326,out){
return (function() {
var cljs$core$async$state_machine__25332__auto__ = null;
var cljs$core$async$state_machine__25332__auto____0 = (function (){
var statearr_27321 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27321[(0)] = cljs$core$async$state_machine__25332__auto__);

(statearr_27321[(1)] = (1));

return statearr_27321;
});
var cljs$core$async$state_machine__25332__auto____1 = (function (state_27298){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_27298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e27322){if((e27322 instanceof Object)){
var ex__25335__auto__ = e27322;
var statearr_27323_27341 = state_27298;
(statearr_27323_27341[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27322;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27342 = state_27298;
state_27298 = G__27342;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
cljs$core$async$state_machine__25332__auto__ = function(state_27298){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25332__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25332__auto____1.call(this,state_27298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25332__auto____0;
cljs$core$async$state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25332__auto____1;
return cljs$core$async$state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___27326,out))
})();
var state__25424__auto__ = (function (){var statearr_27324 = f__25423__auto__.call(null);
(statearr_27324[(6)] = c__25422__auto___27326);

return statearr_27324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___27326,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1533629719887
