// Compiled by ClojureScript 1.10.339 {}
goog.provide('re_com.typeahead');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('re_com.misc');
goog.require('re_com.util');
goog.require('re_com.popover');
goog.require('re_com.box');
goog.require('re_com.validate');
goog.require('reagent.core');
goog.require('goog.events.KeyCodes');

/**
 * Return an initial value for the typeahead state, given `args`.
 */
re_com.typeahead.make_typeahead_state = (function re_com$typeahead$make_typeahead_state(p__27438){
var map__27439 = p__27438;
var map__27439__$1 = ((((!((map__27439 == null)))?(((((map__27439.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27439.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27439):map__27439);
var args = map__27439__$1;
var on_change = cljs.core.get.call(null,map__27439__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var rigid_QMARK_ = cljs.core.get.call(null,map__27439__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__27439__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var data_source = cljs.core.get.call(null,map__27439__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var suggestion_to_string = cljs.core.get.call(null,map__27439__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var debounce_delay = cljs.core.get.call(null,map__27439__$1,new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982));
var model = cljs.core.get.call(null,map__27439__$1,new cljs.core.Keyword(null,"model","model",331153215));
var external_model_value = re_com.util.deref_or_value.call(null,model);
var G__27441 = (function (){var c_input = cljs.core.async.chan.call(null);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"c-search","c-search",1832536180),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"c-input","c-input",-1821004232),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"external-model","external-model",506095421),new cljs.core.Keyword(null,"model","model",331153215)],[false,(function (){var or__3949__auto__ = suggestion_to_string;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return cljs.core.str;
}
})(),false,"",rigid_QMARK_,data_source,re_com.typeahead.debounce.call(null,c_input,debounce_delay),change_on_blur_QMARK_,cljs.core.PersistentVector.EMPTY,c_input,on_change,re_com.util.deref_or_value.call(null,model),re_com.util.deref_or_value.call(null,model)]);
})();
if(cljs.core.truth_(external_model_value)){
return re_com.typeahead.display_suggestion.call(null,G__27441,external_model_value);
} else {
return G__27441;
}
});
/**
 * Should `event` update the `typeahead` `model`?
 */
re_com.typeahead.event_updates_model_QMARK_ = (function re_com$typeahead$event_updates_model_QMARK_(p__27442,event){
var map__27443 = p__27442;
var map__27443__$1 = ((((!((map__27443 == null)))?(((((map__27443.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27443.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27443):map__27443);
var state = map__27443__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__27443__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var rigid_QMARK_ = cljs.core.get.call(null,map__27443__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var rigid_QMARK___$1 = re_com.util.deref_or_value.call(null,rigid_QMARK_);
var G__27445 = event;
var G__27445__$1 = (((G__27445 instanceof cljs.core.Keyword))?G__27445.fqn:null);
switch (G__27445__$1) {
case "input-text-blurred":
var and__3938__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(and__3938__auto__)){
return cljs.core.not.call(null,rigid_QMARK___$1);
} else {
return and__3938__auto__;
}

break;
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
case "input-text-changed":
return cljs.core.not.call(null,(function (){var or__3949__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return rigid_QMARK___$1;
}
})());

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27445__$1)].join('')));

}
});
/**
 * Should `event` cause the `input-text` value to be used to show the active suggestion?
 */
re_com.typeahead.event_displays_suggestion_QMARK_ = (function re_com$typeahead$event_displays_suggestion_QMARK_(p__27447,event){
var map__27448 = p__27447;
var map__27448__$1 = ((((!((map__27448 == null)))?(((((map__27448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27448):map__27448);
var state = map__27448__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__27448__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var G__27450 = event;
var G__27450__$1 = (((G__27450 instanceof cljs.core.Keyword))?G__27450.fqn:null);
switch (G__27450__$1) {
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
default:
return false;

}
});
/**
 * Change the `typeahead` `model` value to `new-value`
 */
re_com.typeahead.update_model = (function re_com$typeahead$update_model(p__27452,new_value){
var map__27453 = p__27452;
var map__27453__$1 = ((((!((map__27453 == null)))?(((((map__27453.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27453.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27453):map__27453);
var state = map__27453__$1;
var on_change = cljs.core.get.call(null,map__27453__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
if(cljs.core.truth_(on_change)){
on_change.call(null,new_value);
} else {
}

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"model","model",331153215),new_value);
});
/**
 * Change the `input-text` `model` to the string representation of `suggestion`
 */
re_com.typeahead.display_suggestion = (function re_com$typeahead$display_suggestion(p__27455,suggestion){
var map__27456 = p__27455;
var map__27456__$1 = ((((!((map__27456 == null)))?(((((map__27456.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27456.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27456):map__27456);
var state = map__27456__$1;
var suggestion_to_string = cljs.core.get.call(null,map__27456__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var suggestion_string = suggestion_to_string.call(null,suggestion);
var G__27458 = state;
if(cljs.core.truth_(suggestion_string)){
return cljs.core.assoc.call(null,G__27458,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),suggestion_string,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),true);
} else {
return G__27458;
}
});
re_com.typeahead.clear_suggestions = (function re_com$typeahead$clear_suggestions(state){
return cljs.core.dissoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
});
/**
 * Make the suggestion at `index` the active suggestion
 */
re_com.typeahead.activate_suggestion_by_index = (function re_com$typeahead$activate_suggestion_by_index(p__27459,index){
var map__27460 = p__27459;
var map__27460__$1 = ((((!((map__27460 == null)))?(((((map__27460.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27460.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27460):map__27460);
var state = map__27460__$1;
var suggestions = cljs.core.get.call(null,map__27460__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
var G__27462 = state;
var G__27462__$1 = cljs.core.assoc.call(null,G__27462,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),index)
;
var G__27462__$2 = (cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))?re_com.typeahead.update_model.call(null,G__27462__$1,suggestion):G__27462__$1);
if(cljs.core.truth_(re_com.typeahead.event_displays_suggestion_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))){
return re_com.typeahead.display_suggestion.call(null,G__27462__$2,suggestion);
} else {
return G__27462__$2;
}
});
/**
 * Choose the suggestion at `index`
 */
re_com.typeahead.choose_suggestion_by_index = (function re_com$typeahead$choose_suggestion_by_index(p__27463,index){
var map__27464 = p__27463;
var map__27464__$1 = ((((!((map__27464 == null)))?(((((map__27464.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27464.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27464):map__27464);
var state = map__27464__$1;
var suggestions = cljs.core.get.call(null,map__27464__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,re_com.typeahead.activate_suggestion_by_index.call(null,state,index),suggestion),suggestion));
});
re_com.typeahead.choose_suggestion_active = (function re_com$typeahead$choose_suggestion_active(p__27466){
var map__27467 = p__27466;
var map__27467__$1 = ((((!((map__27467 == null)))?(((((map__27467.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27467.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27467):map__27467);
var state = map__27467__$1;
var suggestion_active_index = cljs.core.get.call(null,map__27467__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__27469 = state;
if(cljs.core.truth_(suggestion_active_index)){
return re_com.typeahead.choose_suggestion_by_index.call(null,G__27469,suggestion_active_index);
} else {
return G__27469;
}
});
re_com.typeahead.wrap = (function re_com$typeahead$wrap(index,count){
return cljs.core.mod.call(null,(count + index),count);
});
re_com.typeahead.activate_suggestion_next = (function re_com$typeahead$activate_suggestion_next(p__27470){
var map__27471 = p__27470;
var map__27471__$1 = ((((!((map__27471 == null)))?(((((map__27471.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27471.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27471):map__27471);
var state = map__27471__$1;
var suggestions = cljs.core.get.call(null,map__27471__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__27471__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__27473 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__27473,re_com.typeahead.wrap.call(null,((function (){var or__3949__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return (-1);
}
})() + (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__27473;
}
});
re_com.typeahead.activate_suggestion_prev = (function re_com$typeahead$activate_suggestion_prev(p__27474){
var map__27475 = p__27474;
var map__27475__$1 = ((((!((map__27475 == null)))?(((((map__27475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27475.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27475):map__27475);
var state = map__27475__$1;
var suggestions = cljs.core.get.call(null,map__27475__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__27475__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__27477 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__27477,re_com.typeahead.wrap.call(null,((function (){var or__3949__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return (0);
}
})() - (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__27477;
}
});
re_com.typeahead.reset_typeahead = (function re_com$typeahead$reset_typeahead(state){
var G__27478 = state;
var G__27478__$1 = re_com.typeahead.clear_suggestions.call(null,G__27478)
;
var G__27478__$2 = cljs.core.assoc.call(null,G__27478__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),"",new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__27478__$2,null);
} else {
return G__27478__$2;
}
});
/**
 * Update state when new suggestions are available
 */
re_com.typeahead.got_suggestions = (function re_com$typeahead$got_suggestions(state,suggestions){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),suggestions,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),null);
});
/**
 * Update state when the `input-text` is about to lose focus.
 */
re_com.typeahead.input_text_will_blur = (function re_com$typeahead$input_text_will_blur(p__27479){
var map__27480 = p__27479;
var map__27480__$1 = ((((!((map__27480 == null)))?(((((map__27480.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27480.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27480):map__27480);
var state = map__27480__$1;
var input_text = cljs.core.get.call(null,map__27480__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var displaying_suggestion_QMARK_ = cljs.core.get.call(null,map__27480__$1,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862));
var G__27482 = state;
if(cljs.core.truth_((function (){var and__3938__auto__ = cljs.core.not.call(null,displaying_suggestion_QMARK_);
if(and__3938__auto__){
return re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-blurred","input-text-blurred",-501892307));
} else {
return and__3938__auto__;
}
})())){
return re_com.typeahead.update_model.call(null,G__27482,input_text);
} else {
return G__27482;
}
});
/**
 * Update `state` given a new `data-source`. Resets the typeahead since any existing suggestions
 *   came from the old `data-source`.
 */
re_com.typeahead.change_data_source = (function re_com$typeahead$change_data_source(state,data_source){
return cljs.core.assoc.call(null,re_com.typeahead.reset_typeahead.call(null,state),new cljs.core.Keyword(null,"data-source","data-source",-658934676),data_source);
});
/**
 * Update state when the external model value has changed.
 */
re_com.typeahead.external_model_changed = (function re_com$typeahead$external_model_changed(state,new_value){
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,state,new_value),new_value));
});
/**
 * Call the `data-source` fn with `text`, and then call `got-suggestions` with the result
 *   (asynchronously, if `data-source` does not return a truthy value).
 */
re_com.typeahead.search_data_source_BANG_ = (function re_com$typeahead$search_data_source_BANG_(data_source,state_atom,text){
var temp__5455__auto__ = data_source.call(null,text,(function (p1__27483_SHARP_){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,p1__27483_SHARP_);
}));
if(cljs.core.truth_(temp__5455__auto__)){
var return_value = temp__5455__auto__;
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,return_value);
} else {
return cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),true);
}
});
/**
 * For every value arriving on the `c-search` channel, call `search-data-source!`.
 */
re_com.typeahead.search_data_source_loop_BANG_ = (function re_com$typeahead$search_data_source_loop_BANG_(state_atom,c_search){
var c__25422__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto__){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto__){
return (function (state_27500){
var state_val_27501 = (state_27500[(1)]);
if((state_val_27501 === (1))){
var state_27500__$1 = state_27500;
var statearr_27502_27514 = state_27500__$1;
(statearr_27502_27514[(2)] = null);

(statearr_27502_27514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27501 === (2))){
var state_27500__$1 = state_27500;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27500__$1,(4),c_search);
} else {
if((state_val_27501 === (3))){
var inst_27498 = (state_27500[(2)]);
var state_27500__$1 = state_27500;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27500__$1,inst_27498);
} else {
if((state_val_27501 === (4))){
var inst_27486 = (state_27500[(7)]);
var inst_27486__$1 = (state_27500[(2)]);
var inst_27487 = cljs.core.deref.call(null,state_atom);
var inst_27488 = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(inst_27487);
var inst_27489 = cljs.core._EQ_.call(null,"",inst_27486__$1);
var state_27500__$1 = (function (){var statearr_27503 = state_27500;
(statearr_27503[(8)] = inst_27488);

(statearr_27503[(7)] = inst_27486__$1);

return statearr_27503;
})();
if(inst_27489){
var statearr_27504_27515 = state_27500__$1;
(statearr_27504_27515[(1)] = (5));

} else {
var statearr_27505_27516 = state_27500__$1;
(statearr_27505_27516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27501 === (5))){
var inst_27491 = cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
var state_27500__$1 = state_27500;
var statearr_27506_27517 = state_27500__$1;
(statearr_27506_27517[(2)] = inst_27491);

(statearr_27506_27517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27501 === (6))){
var inst_27488 = (state_27500[(8)]);
var inst_27486 = (state_27500[(7)]);
var inst_27493 = re_com.typeahead.search_data_source_BANG_.call(null,inst_27488,state_atom,inst_27486);
var state_27500__$1 = state_27500;
var statearr_27507_27518 = state_27500__$1;
(statearr_27507_27518[(2)] = inst_27493);

(statearr_27507_27518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27501 === (7))){
var inst_27495 = (state_27500[(2)]);
var state_27500__$1 = (function (){var statearr_27508 = state_27500;
(statearr_27508[(9)] = inst_27495);

return statearr_27508;
})();
var statearr_27509_27519 = state_27500__$1;
(statearr_27509_27519[(2)] = null);

(statearr_27509_27519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__25422__auto__))
;
return ((function (switch__25331__auto__,c__25422__auto__){
return (function() {
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto__ = null;
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto____0 = (function (){
var statearr_27510 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27510[(0)] = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto__);

(statearr_27510[(1)] = (1));

return statearr_27510;
});
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto____1 = (function (state_27500){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_27500);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e27511){if((e27511 instanceof Object)){
var ex__25335__auto__ = e27511;
var statearr_27512_27520 = state_27500;
(statearr_27512_27520[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27500);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27511;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27521 = state_27500;
state_27500 = G__27521;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto__ = function(state_27500){
switch(arguments.length){
case 0:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto____0.call(this);
case 1:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto____1.call(this,state_27500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto____0;
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto____1;
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto__))
})();
var state__25424__auto__ = (function (){var statearr_27513 = f__25423__auto__.call(null);
(statearr_27513[(6)] = c__25422__auto__);

return statearr_27513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto__))
);

return c__25422__auto__;
});
/**
 * Update state in response to `input-text` `on-change`, and put text on the `c-input` channel
 */
re_com.typeahead.input_text_on_change_BANG_ = (function re_com$typeahead$input_text_on_change_BANG_(state_atom,new_text){
var map__27523 = cljs.core.deref.call(null,state_atom);
var map__27523__$1 = ((((!((map__27523 == null)))?(((((map__27523.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27523.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27523):map__27523);
var state = map__27523__$1;
var input_text = cljs.core.get.call(null,map__27523__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var c_input = cljs.core.get.call(null,map__27523__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
if(cljs.core._EQ_.call(null,new_text,input_text)){
return state;
} else {
if(clojure.string.blank_QMARK_.call(null,new_text)){
} else {
cljs.core.async.put_BANG_.call(null,c_input,new_text);
}

return cljs.core.swap_BANG_.call(null,state_atom,((function (map__27523,map__27523__$1,state,input_text,c_input){
return (function (p1__27522_SHARP_){
var G__27525 = p1__27522_SHARP_;
var G__27525__$1 = cljs.core.assoc.call(null,G__27525,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new_text,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__27525__$1,new_text);
} else {
return G__27525__$1;
}
});})(map__27523,map__27523__$1,state,input_text,c_input))
);
}
});
re_com.typeahead.input_text_on_key_down_BANG_ = (function re_com$typeahead$input_text_on_key_down_BANG_(state_atom,event){
var pred__27526 = cljs.core._EQ_;
var expr__27527 = event.which;
if(cljs.core.truth_(pred__27526.call(null,goog.events.KeyCodes.UP,expr__27527))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_prev);
} else {
if(cljs.core.truth_(pred__27526.call(null,goog.events.KeyCodes.DOWN,expr__27527))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);
} else {
if(cljs.core.truth_(pred__27526.call(null,goog.events.KeyCodes.ENTER,expr__27527))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_active);
} else {
if(cljs.core.truth_(pred__27526.call(null,goog.events.KeyCodes.ESC,expr__27527))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
} else {
if(cljs.core.truth_(pred__27526.call(null,goog.events.KeyCodes.TAB,expr__27527))){
if(cljs.core.truth_(cljs.core.not_empty.call(null,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state_atom))))){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);

return event.preventDefault();
} else {
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.input_text_will_blur);
}
} else {
return true;
}
}
}
}
}
});
re_com.typeahead.typeahead_args_desc = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null)," supplies suggestion objects. This can either accept a single string argument (the search term), or a string and a callback. For the first case, the fn should return a collection of suggestion objects (which can be anything). For the second case, the fn should return ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil"], null),", and eventually result in a call to the callback with a collection of suggestion objects."], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"string -> nil",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":change-on-blur?"], null)," controls when it is called. It is passed a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, invoke ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-change"], null)," when the user chooses a suggestion, otherwise invoke it on every change (navigating through suggestions with the mouse or keyboard, or if ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"rigid?"], null)," is also ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null),", invoke it on every character typed.)"], null)], null),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"object | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"The initial value of the typeahead (should match the suggestion objects returned by ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),")."]),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),(250),new cljs.core.Keyword(null,"type","type",1174270348),"integer",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.integer_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"After receiving input, the typeahead will wait this many milliseconds without receiving new input before calling ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),"."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"render fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"override the rendering of the suggestion items by passing a fn that returns hiccup forms. The fn will receive two arguments: the search term, and the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"suggestion -> string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"When a suggestion is chosen, the input-text value will be set to the result of calling this fn with the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"If ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null)," the user will be allowed to choose arbitrary text input rather than a suggestion from ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),". In this case, a string will be supplied in lieu of a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"keyword",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.input_status_type_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"validation status. ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil/omitted"], null)," for normal status or one of: ",re_com.validate.input_status_types_list], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, display an icon to match ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":status"], null)," (no icon for nil)"], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"displayed in status icon's tooltip"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"background text shown when empty"], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),"250px",new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS width setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS height setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, the user can't interact (input anything)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS class names, space separated"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"CSS style map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.css_style_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS styles to add or override"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"HTML attr map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.html_attr_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"HTML attributes, like ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-mouse-move"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),"No ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":class"], null)," or ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":style"], null),"allowed"], null)], null)], null);
/**
 * typeahead reagent component
 */
re_com.typeahead.typeahead = (function re_com$typeahead$typeahead(var_args){
var args__4534__auto__ = [];
var len__4531__auto___27551 = arguments.length;
var i__4532__auto___27552 = (0);
while(true){
if((i__4532__auto___27552 < len__4531__auto___27551)){
args__4534__auto__.push((arguments[i__4532__auto___27552]));

var G__27553 = (i__4532__auto___27552 + (1));
i__4532__auto___27552 = G__27553;
continue;
} else {
}
break;
}

var argseq__4535__auto__ = ((((0) < args__4534__auto__.length))?(new cljs.core.IndexedSeq(args__4534__auto__.slice((0)),(0),null)):null);
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(argseq__4535__auto__);
});

re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic = (function (p__27531){
var map__27532 = p__27531;
var map__27532__$1 = ((((!((map__27532 == null)))?(((((map__27532.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27532.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27532):map__27532);
var args = map__27532__$1;
if(cljs.core.truth_(((!(goog.DEBUG))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args,"typeahead")))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__27534 = re_com.typeahead.make_typeahead_state.call(null,args);
var map__27534__$1 = ((((!((map__27534 == null)))?(((((map__27534.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27534.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27534):map__27534);
var state = map__27534__$1;
var c_search = cljs.core.get.call(null,map__27534__$1,new cljs.core.Keyword(null,"c-search","c-search",1832536180));
var c_input = cljs.core.get.call(null,map__27534__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
var state_atom = reagent.core.atom.call(null,state);
var input_text_model = reagent.core.cursor.call(null,state_atom,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input-text","input-text",-1336297114)], null));
re_com.typeahead.search_data_source_loop_BANG_.call(null,state_atom,c_search);

return ((function (map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args){
return (function() { 
var G__27554__delegate = function (p__27536){
var map__27537 = p__27536;
var map__27537__$1 = ((((!((map__27537 == null)))?(((((map__27537.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27537.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27537):map__27537);
var args__$1 = map__27537__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var status_icon_QMARK_ = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612));
var height = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var status_tooltip = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007));
var model = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"model","model",331153215));
var _debounce_delay = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"_debounce-delay","_debounce-delay",-1476744225));
var _on_change = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"_on-change","_on-change",156649312));
var placeholder = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var render_suggestion = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503));
var _suggestion_to_string = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"_suggestion-to-string","_suggestion-to-string",795407399));
var width = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var data_source = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var _rigid_QMARK_ = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"_rigid?","_rigid?",1424449294));
var style = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var _change_on_blur_QMARK_ = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"_change-on-blur?","_change-on-blur?",1219941073));
var status = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var class$ = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var _attr = cljs.core.get.call(null,map__27537__$1,new cljs.core.Keyword(null,"_attr","_attr",299438964));
if(cljs.core.truth_(((!(goog.DEBUG))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args__$1,"typeahead")))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__27539 = cljs.core.deref.call(null,state_atom);
var map__27539__$1 = ((((!((map__27539 == null)))?(((((map__27539.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27539.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27539):map__27539);
var state__$1 = map__27539__$1;
var suggestions = cljs.core.get.call(null,map__27539__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var waiting_QMARK_ = cljs.core.get.call(null,map__27539__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215));
var suggestion_active_index = cljs.core.get.call(null,map__27539__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var external_model = cljs.core.get.call(null,map__27539__$1,new cljs.core.Keyword(null,"external-model","external-model",506095421));
var last_data_source = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(state__$1);
var latest_external_model = re_com.util.deref_or_value.call(null,model);
var width__$1 = (function (){var or__3949__auto__ = width;
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return "250px";
}
})();
if(cljs.core.not_EQ_.call(null,last_data_source,data_source)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.change_data_source,data_source);
} else {
}

if(cljs.core.not_EQ_.call(null,latest_external_model,external_model)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.external_model_changed,latest_external_model);
} else {
}

return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.input_text,new cljs.core.Keyword(null,"model","model",331153215),input_text_model,new cljs.core.Keyword(null,"class","class",-2030961996),class$,new cljs.core.Keyword(null,"style","style",-496642736),style,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK_,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),status_icon_QMARK_,new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),status_tooltip,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,re_com.typeahead.input_text_on_change_BANG_,state_atom),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),false,new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-key-down","on-key-down",-1374733765),cljs.core.partial.call(null,re_com.typeahead.input_text_on_key_down_BANG_,state_atom)], null)], null),(cljs.core.truth_((function (){var or__3949__auto__ = cljs.core.not_empty.call(null,suggestions);
if(cljs.core.truth_(or__3949__auto__)){
return or__3949__auto__;
} else {
return waiting_QMARK_;
}
})())?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-suggestions-container",new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"align","align",1964212802),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.throbber,new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"small","small",2133478704),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-throbber"], null)], null):null),(function (){var iter__4324__auto__ = ((function (map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args){
return (function re_com$typeahead$iter__27541(s__27542){
return (new cljs.core.LazySeq(null,((function (map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args){
return (function (){
var s__27542__$1 = s__27542;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__27542__$1);
if(temp__5457__auto__){
var s__27542__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__27542__$2)){
var c__4322__auto__ = cljs.core.chunk_first.call(null,s__27542__$2);
var size__4323__auto__ = cljs.core.count.call(null,c__4322__auto__);
var b__27544 = cljs.core.chunk_buffer.call(null,size__4323__auto__);
if((function (){var i__27543 = (0);
while(true){
if((i__27543 < size__4323__auto__)){
var vec__27545 = cljs.core._nth.call(null,c__4322__auto__,i__27543);
var i = cljs.core.nth.call(null,vec__27545,(0),null);
var s = cljs.core.nth.call(null,vec__27545,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
cljs.core.chunk_append.call(null,b__27544,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((selected_QMARK_)?" active":null))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (i__27543,selected_QMARK_,vec__27545,i,s,c__4322__auto__,size__4323__auto__,b__27544,s__27542__$2,temp__5457__auto__,map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(i__27543,selected_QMARK_,vec__27545,i,s,c__4322__auto__,size__4323__auto__,b__27544,s__27542__$2,temp__5457__auto__,map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (i__27543,selected_QMARK_,vec__27545,i,s,c__4322__auto__,size__4323__auto__,b__27544,s__27542__$2,temp__5457__auto__,map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args){
return (function (p1__27529_SHARP_){
p1__27529_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(i__27543,selected_QMARK_,vec__27545,i,s,c__4322__auto__,size__4323__auto__,b__27544,s__27542__$2,temp__5457__auto__,map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)));

var G__27555 = (i__27543 + (1));
i__27543 = G__27555;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27544),re_com$typeahead$iter__27541.call(null,cljs.core.chunk_rest.call(null,s__27542__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__27544),null);
}
} else {
var vec__27548 = cljs.core.first.call(null,s__27542__$2);
var i = cljs.core.nth.call(null,vec__27548,(0),null);
var s = cljs.core.nth.call(null,vec__27548,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((selected_QMARK_)?" active":null))].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (selected_QMARK_,vec__27548,i,s,s__27542__$2,temp__5457__auto__,map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(selected_QMARK_,vec__27548,i,s,s__27542__$2,temp__5457__auto__,map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (selected_QMARK_,vec__27548,i,s,s__27542__$2,temp__5457__auto__,map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args){
return (function (p1__27529_SHARP_){
p1__27529_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(selected_QMARK_,vec__27548,i,s,s__27542__$2,temp__5457__auto__,map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)),re_com$typeahead$iter__27541.call(null,cljs.core.rest.call(null,s__27542__$2)));
}
} else {
return null;
}
break;
}
});})(map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args))
,null,null));
});})(map__27539,map__27539__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__27537,map__27537__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args))
;
return iter__4324__auto__.call(null,cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null),suggestions));
})()], null)], null)], null):null)], null)], null);
};
var G__27554 = function (var_args){
var p__27536 = null;
if (arguments.length > 0) {
var G__27556__i = 0, G__27556__a = new Array(arguments.length -  0);
while (G__27556__i < G__27556__a.length) {G__27556__a[G__27556__i] = arguments[G__27556__i + 0]; ++G__27556__i;}
  p__27536 = new cljs.core.IndexedSeq(G__27556__a,0,null);
} 
return G__27554__delegate.call(this,p__27536);};
G__27554.cljs$lang$maxFixedArity = 0;
G__27554.cljs$lang$applyTo = (function (arglist__27557){
var p__27536 = cljs.core.seq(arglist__27557);
return G__27554__delegate(p__27536);
});
G__27554.cljs$core$IFn$_invoke$arity$variadic = G__27554__delegate;
return G__27554;
})()
;
;})(map__27534,map__27534__$1,state,c_search,c_input,state_atom,input_text_model,map__27532,map__27532__$1,args))
});

re_com.typeahead.typeahead.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
re_com.typeahead.typeahead.cljs$lang$applyTo = (function (seq27530){
var self__4519__auto__ = this;
return self__4519__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27530));
});

/**
 * Return a channel which will receive a value from the `in` channel only
 *   if no further value is received on the `in` channel in the next `ms` milliseconds.
 */
re_com.typeahead.debounce = (function re_com$typeahead$debounce(in$,ms){
var out = cljs.core.async.chan.call(null);
var c__25422__auto___27638 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25422__auto___27638,out){
return (function (){
var f__25423__auto__ = (function (){var switch__25331__auto__ = ((function (c__25422__auto___27638,out){
return (function (state_27608){
var state_val_27609 = (state_27608[(1)]);
if((state_val_27609 === (7))){
var inst_27563 = (state_27608[(2)]);
var state_27608__$1 = state_27608;
var statearr_27610_27639 = state_27608__$1;
(statearr_27610_27639[(2)] = inst_27563);

(statearr_27610_27639[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (1))){
var inst_27558 = null;
var state_27608__$1 = (function (){var statearr_27611 = state_27608;
(statearr_27611[(7)] = inst_27558);

return statearr_27611;
})();
var statearr_27612_27640 = state_27608__$1;
(statearr_27612_27640[(2)] = null);

(statearr_27612_27640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (4))){
var state_27608__$1 = state_27608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27608__$1,(7),in$);
} else {
if((state_val_27609 === (15))){
var inst_27593 = (state_27608[(2)]);
var state_27608__$1 = (function (){var statearr_27613 = state_27608;
(statearr_27613[(8)] = inst_27593);

return statearr_27613;
})();
var statearr_27614_27641 = state_27608__$1;
(statearr_27614_27641[(2)] = null);

(statearr_27614_27641[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (13))){
var inst_27581 = (state_27608[(9)]);
var inst_27595 = cljs.core._EQ_.call(null,inst_27581,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_27608__$1 = state_27608;
if(inst_27595){
var statearr_27615_27642 = state_27608__$1;
(statearr_27615_27642[(1)] = (16));

} else {
var statearr_27616_27643 = state_27608__$1;
(statearr_27616_27643[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (6))){
var inst_27567 = (state_27608[(10)]);
var inst_27566 = (state_27608[(2)]);
var inst_27567__$1 = cljs.core.async.timeout.call(null,ms);
var inst_27575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27576 = [in$,inst_27567__$1];
var inst_27577 = (new cljs.core.PersistentVector(null,2,(5),inst_27575,inst_27576,null));
var state_27608__$1 = (function (){var statearr_27617 = state_27608;
(statearr_27617[(10)] = inst_27567__$1);

(statearr_27617[(11)] = inst_27566);

return statearr_27617;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_27608__$1,(8),inst_27577);
} else {
if((state_val_27609 === (17))){
var state_27608__$1 = state_27608;
var statearr_27618_27644 = state_27608__$1;
(statearr_27618_27644[(2)] = null);

(statearr_27618_27644[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (3))){
var inst_27606 = (state_27608[(2)]);
var state_27608__$1 = state_27608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27608__$1,inst_27606);
} else {
if((state_val_27609 === (12))){
var inst_27566 = (state_27608[(11)]);
var state_27608__$1 = state_27608;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27608__$1,(15),out,inst_27566);
} else {
if((state_val_27609 === (2))){
var inst_27558 = (state_27608[(7)]);
var inst_27560 = (inst_27558 == null);
var state_27608__$1 = state_27608;
if(cljs.core.truth_(inst_27560)){
var statearr_27619_27645 = state_27608__$1;
(statearr_27619_27645[(1)] = (4));

} else {
var statearr_27620_27646 = state_27608__$1;
(statearr_27620_27646[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (11))){
var inst_27603 = (state_27608[(2)]);
var inst_27558 = inst_27603;
var state_27608__$1 = (function (){var statearr_27621 = state_27608;
(statearr_27621[(7)] = inst_27558);

return statearr_27621;
})();
var statearr_27622_27647 = state_27608__$1;
(statearr_27622_27647[(2)] = null);

(statearr_27622_27647[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (9))){
var inst_27579 = (state_27608[(12)]);
var inst_27587 = cljs.core.nth.call(null,inst_27579,(0),null);
var inst_27588 = cljs.core.nth.call(null,inst_27579,(1),null);
var state_27608__$1 = (function (){var statearr_27623 = state_27608;
(statearr_27623[(13)] = inst_27588);

return statearr_27623;
})();
var statearr_27624_27648 = state_27608__$1;
(statearr_27624_27648[(2)] = inst_27587);

(statearr_27624_27648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (5))){
var inst_27558 = (state_27608[(7)]);
var state_27608__$1 = state_27608;
var statearr_27625_27649 = state_27608__$1;
(statearr_27625_27649[(2)] = inst_27558);

(statearr_27625_27649[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (14))){
var inst_27601 = (state_27608[(2)]);
var state_27608__$1 = state_27608;
var statearr_27626_27650 = state_27608__$1;
(statearr_27626_27650[(2)] = inst_27601);

(statearr_27626_27650[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (16))){
var inst_27580 = (state_27608[(14)]);
var state_27608__$1 = state_27608;
var statearr_27627_27651 = state_27608__$1;
(statearr_27627_27651[(2)] = inst_27580);

(statearr_27627_27651[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (10))){
var inst_27581 = (state_27608[(9)]);
var inst_27567 = (state_27608[(10)]);
var inst_27590 = cljs.core._EQ_.call(null,inst_27581,inst_27567);
var state_27608__$1 = state_27608;
if(inst_27590){
var statearr_27628_27652 = state_27608__$1;
(statearr_27628_27652[(1)] = (12));

} else {
var statearr_27629_27653 = state_27608__$1;
(statearr_27629_27653[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (18))){
var inst_27599 = (state_27608[(2)]);
var state_27608__$1 = state_27608;
var statearr_27630_27654 = state_27608__$1;
(statearr_27630_27654[(2)] = inst_27599);

(statearr_27630_27654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27609 === (8))){
var inst_27581 = (state_27608[(9)]);
var inst_27579 = (state_27608[(12)]);
var inst_27579__$1 = (state_27608[(2)]);
var inst_27580 = cljs.core.nth.call(null,inst_27579__$1,(0),null);
var inst_27581__$1 = cljs.core.nth.call(null,inst_27579__$1,(1),null);
var inst_27582 = cljs.core._EQ_.call(null,inst_27581__$1,in$);
var state_27608__$1 = (function (){var statearr_27631 = state_27608;
(statearr_27631[(9)] = inst_27581__$1);

(statearr_27631[(12)] = inst_27579__$1);

(statearr_27631[(14)] = inst_27580);

return statearr_27631;
})();
if(inst_27582){
var statearr_27632_27655 = state_27608__$1;
(statearr_27632_27655[(1)] = (9));

} else {
var statearr_27633_27656 = state_27608__$1;
(statearr_27633_27656[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25422__auto___27638,out))
;
return ((function (switch__25331__auto__,c__25422__auto___27638,out){
return (function() {
var re_com$typeahead$debounce_$_state_machine__25332__auto__ = null;
var re_com$typeahead$debounce_$_state_machine__25332__auto____0 = (function (){
var statearr_27634 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27634[(0)] = re_com$typeahead$debounce_$_state_machine__25332__auto__);

(statearr_27634[(1)] = (1));

return statearr_27634;
});
var re_com$typeahead$debounce_$_state_machine__25332__auto____1 = (function (state_27608){
while(true){
var ret_value__25333__auto__ = (function (){try{while(true){
var result__25334__auto__ = switch__25331__auto__.call(null,state_27608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25334__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25334__auto__;
}
break;
}
}catch (e27635){if((e27635 instanceof Object)){
var ex__25335__auto__ = e27635;
var statearr_27636_27657 = state_27608;
(statearr_27636_27657[(5)] = ex__25335__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27608);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27635;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25333__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27658 = state_27608;
state_27608 = G__27658;
continue;
} else {
return ret_value__25333__auto__;
}
break;
}
});
re_com$typeahead$debounce_$_state_machine__25332__auto__ = function(state_27608){
switch(arguments.length){
case 0:
return re_com$typeahead$debounce_$_state_machine__25332__auto____0.call(this);
case 1:
return re_com$typeahead$debounce_$_state_machine__25332__auto____1.call(this,state_27608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
re_com$typeahead$debounce_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$debounce_$_state_machine__25332__auto____0;
re_com$typeahead$debounce_$_state_machine__25332__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$debounce_$_state_machine__25332__auto____1;
return re_com$typeahead$debounce_$_state_machine__25332__auto__;
})()
;})(switch__25331__auto__,c__25422__auto___27638,out))
})();
var state__25424__auto__ = (function (){var statearr_27637 = f__25423__auto__.call(null);
(statearr_27637[(6)] = c__25422__auto___27638);

return statearr_27637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25424__auto__);
});})(c__25422__auto___27638,out))
);


return out;
});

//# sourceMappingURL=typeahead.js.map?rel=1533629720488
