// Compiled by ClojureScript 1.10.339 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.trace');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_22973 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"op-type","op-type",-1636141668),new cljs.core.Keyword("event","do-fx","event/do-fx",1357330452)], null));

try{try{var seq__22974 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__22975 = null;
var count__22976 = (0);
var i__22977 = (0);
while(true){
if((i__22977 < count__22976)){
var vec__22978 = cljs.core._nth.call(null,chunk__22975,i__22977);
var effect_key = cljs.core.nth.call(null,vec__22978,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22978,(1),null);
var temp__5455__auto___22994 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___22994)){
var effect_fn_22995 = temp__5455__auto___22994;
effect_fn_22995.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__22996 = seq__22974;
var G__22997 = chunk__22975;
var G__22998 = count__22976;
var G__22999 = (i__22977 + (1));
seq__22974 = G__22996;
chunk__22975 = G__22997;
count__22976 = G__22998;
i__22977 = G__22999;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22974);
if(temp__5457__auto__){
var seq__22974__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22974__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__22974__$1);
var G__23000 = cljs.core.chunk_rest.call(null,seq__22974__$1);
var G__23001 = c__4351__auto__;
var G__23002 = cljs.core.count.call(null,c__4351__auto__);
var G__23003 = (0);
seq__22974 = G__23000;
chunk__22975 = G__23001;
count__22976 = G__23002;
i__22977 = G__23003;
continue;
} else {
var vec__22981 = cljs.core.first.call(null,seq__22974__$1);
var effect_key = cljs.core.nth.call(null,vec__22981,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22981,(1),null);
var temp__5455__auto___23004 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___23004)){
var effect_fn_23005 = temp__5455__auto___23004;
effect_fn_23005.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__23006 = cljs.core.next.call(null,seq__22974__$1);
var G__23007 = null;
var G__23008 = (0);
var G__23009 = (0);
seq__22974 = G__23006;
chunk__22975 = G__23007;
count__22976 = G__23008;
i__22977 = G__23009;
continue;
}
} else {
return null;
}
}
break;
}
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__22812__auto___23010 = re_frame.interop.now.call(null);
var duration__22813__auto___23011 = (end__22812__auto___23010 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
cljs.core.swap_BANG_.call(null,re_frame.trace.traces,cljs.core.conj,cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__22813__auto___23011,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null)));

re_frame.trace.run_tracing_callbacks_BANG_.call(null,end__22812__auto___23010);
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_22973;
}} else {
var seq__22984 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__22985 = null;
var count__22986 = (0);
var i__22987 = (0);
while(true){
if((i__22987 < count__22986)){
var vec__22988 = cljs.core._nth.call(null,chunk__22985,i__22987);
var effect_key = cljs.core.nth.call(null,vec__22988,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22988,(1),null);
var temp__5455__auto___23012 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___23012)){
var effect_fn_23013 = temp__5455__auto___23012;
effect_fn_23013.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__23014 = seq__22984;
var G__23015 = chunk__22985;
var G__23016 = count__22986;
var G__23017 = (i__22987 + (1));
seq__22984 = G__23014;
chunk__22985 = G__23015;
count__22986 = G__23016;
i__22987 = G__23017;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22984);
if(temp__5457__auto__){
var seq__22984__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22984__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__22984__$1);
var G__23018 = cljs.core.chunk_rest.call(null,seq__22984__$1);
var G__23019 = c__4351__auto__;
var G__23020 = cljs.core.count.call(null,c__4351__auto__);
var G__23021 = (0);
seq__22984 = G__23018;
chunk__22985 = G__23019;
count__22986 = G__23020;
i__22987 = G__23021;
continue;
} else {
var vec__22991 = cljs.core.first.call(null,seq__22984__$1);
var effect_key = cljs.core.nth.call(null,vec__22991,(0),null);
var effect_value = cljs.core.nth.call(null,vec__22991,(1),null);
var temp__5455__auto___23022 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__5455__auto___23022)){
var effect_fn_23023 = temp__5455__auto___23022;
effect_fn_23023.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect:",effect_key,". Ignoring.");
}


var G__23024 = cljs.core.next.call(null,seq__22984__$1);
var G__23025 = null;
var G__23026 = (0);
var G__23027 = (0);
seq__22984 = G__23024;
chunk__22985 = G__23025;
count__22986 = G__23026;
i__22987 = G__23027;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__23028 = cljs.core.seq.call(null,value);
var chunk__23029 = null;
var count__23030 = (0);
var i__23031 = (0);
while(true){
if((i__23031 < count__23030)){
var map__23032 = cljs.core._nth.call(null,chunk__23029,i__23031);
var map__23032__$1 = ((((!((map__23032 == null)))?(((((map__23032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23032.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23032):map__23032);
var effect = map__23032__$1;
var ms = cljs.core.get.call(null,map__23032__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__23032__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__23028,chunk__23029,count__23030,i__23031,map__23032,map__23032__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__23028,chunk__23029,count__23030,i__23031,map__23032,map__23032__$1,effect,ms,dispatch))
,ms);
}


var G__23036 = seq__23028;
var G__23037 = chunk__23029;
var G__23038 = count__23030;
var G__23039 = (i__23031 + (1));
seq__23028 = G__23036;
chunk__23029 = G__23037;
count__23030 = G__23038;
i__23031 = G__23039;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__23028);
if(temp__5457__auto__){
var seq__23028__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23028__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__23028__$1);
var G__23040 = cljs.core.chunk_rest.call(null,seq__23028__$1);
var G__23041 = c__4351__auto__;
var G__23042 = cljs.core.count.call(null,c__4351__auto__);
var G__23043 = (0);
seq__23028 = G__23040;
chunk__23029 = G__23041;
count__23030 = G__23042;
i__23031 = G__23043;
continue;
} else {
var map__23034 = cljs.core.first.call(null,seq__23028__$1);
var map__23034__$1 = ((((!((map__23034 == null)))?(((((map__23034.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23034.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23034):map__23034);
var effect = map__23034__$1;
var ms = cljs.core.get.call(null,map__23034__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__23034__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if(((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number')))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__23028,chunk__23029,count__23030,i__23031,map__23034,map__23034__$1,effect,ms,dispatch,seq__23028__$1,temp__5457__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__23028,chunk__23029,count__23030,i__23031,map__23034,map__23034__$1,effect,ms,dispatch,seq__23028__$1,temp__5457__auto__))
,ms);
}


var G__23044 = cljs.core.next.call(null,seq__23028__$1);
var G__23045 = null;
var G__23046 = (0);
var G__23047 = (0);
seq__23028 = G__23044;
chunk__23029 = G__23045;
count__23030 = G__23046;
i__23031 = G__23047;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__23048 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__23049 = null;
var count__23050 = (0);
var i__23051 = (0);
while(true){
if((i__23051 < count__23050)){
var event = cljs.core._nth.call(null,chunk__23049,i__23051);
re_frame.router.dispatch.call(null,event);


var G__23052 = seq__23048;
var G__23053 = chunk__23049;
var G__23054 = count__23050;
var G__23055 = (i__23051 + (1));
seq__23048 = G__23052;
chunk__23049 = G__23053;
count__23050 = G__23054;
i__23051 = G__23055;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__23048);
if(temp__5457__auto__){
var seq__23048__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23048__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__23048__$1);
var G__23056 = cljs.core.chunk_rest.call(null,seq__23048__$1);
var G__23057 = c__4351__auto__;
var G__23058 = cljs.core.count.call(null,c__4351__auto__);
var G__23059 = (0);
seq__23048 = G__23056;
chunk__23049 = G__23057;
count__23050 = G__23058;
i__23051 = G__23059;
continue;
} else {
var event = cljs.core.first.call(null,seq__23048__$1);
re_frame.router.dispatch.call(null,event);


var G__23060 = cljs.core.next.call(null,seq__23048__$1);
var G__23061 = null;
var G__23062 = (0);
var G__23063 = (0);
seq__23048 = G__23060;
chunk__23049 = G__23061;
count__23050 = G__23062;
i__23051 = G__23063;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__23064 = cljs.core.seq.call(null,value);
var chunk__23065 = null;
var count__23066 = (0);
var i__23067 = (0);
while(true){
if((i__23067 < count__23066)){
var event = cljs.core._nth.call(null,chunk__23065,i__23067);
clear_event.call(null,event);


var G__23068 = seq__23064;
var G__23069 = chunk__23065;
var G__23070 = count__23066;
var G__23071 = (i__23067 + (1));
seq__23064 = G__23068;
chunk__23065 = G__23069;
count__23066 = G__23070;
i__23067 = G__23071;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__23064);
if(temp__5457__auto__){
var seq__23064__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__23064__$1)){
var c__4351__auto__ = cljs.core.chunk_first.call(null,seq__23064__$1);
var G__23072 = cljs.core.chunk_rest.call(null,seq__23064__$1);
var G__23073 = c__4351__auto__;
var G__23074 = cljs.core.count.call(null,c__4351__auto__);
var G__23075 = (0);
seq__23064 = G__23072;
chunk__23065 = G__23073;
count__23066 = G__23074;
i__23067 = G__23075;
continue;
} else {
var event = cljs.core.first.call(null,seq__23064__$1);
clear_event.call(null,event);


var G__23076 = cljs.core.next.call(null,seq__23064__$1);
var G__23077 = null;
var G__23078 = (0);
var G__23079 = (0);
seq__23064 = G__23076;
chunk__23065 = G__23077;
count__23066 = G__23078;
i__23067 = G__23079;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));

//# sourceMappingURL=fx.js.map?rel=1533629715848
