(ns duct.logger.timbre.logfmt
  (:require [clojure.string :as str]))

(defn- quote-str [s]
  (if (re-find #"[\s=]" s) (pr-str s) s))

(defn- ->str [x]
  (if (keyword? x)
    (subs (str x) 1)
    (quote-str (str x))))

(defn logfmt [kvs]
  (str/join " " (for [[k v] kvs] (str (name k) "=" (->str v)))))

(defn- output-prelude [{:keys [level ?ns-str ?line id_] [event _] :vargs}]
  (logfmt [[:at level] [:ns ?ns-str] [:line ?line] [:id (force id_)] [:event event]]))

(defn- output-data [data]
  (logfmt (sort data)))

(defn- output-error [error]
  (logfmt [[:error (.getName (class error))] [:msg (.getMessage error)]]))

(defn output-fn [{[_ data] :vargs :as log}]
  (str (output-prelude log)
       (cond
         (instance? Throwable data) (str " " (output-error data))
         (map? data)                (str " " (output-data data))
         (nil? data)                "")))

(output-fn {:level :info
            :?ns-str "duct.server.http.jetty"
            :?line 15
            :id_ (delay (java.util.UUID/randomUUID))
            :vargs [:duct.server.http.jetty/starting-server {:port 3000}]})

(output-fn {:level :error
            :?ns-str "duct.server.http.jetty"
            :?line 15
            :id_ (delay (java.util.UUID/randomUUID))
            :vargs [:duct.server.http.jetty/error (Exception. "testing")]})
