Duct module.deployment-name
===========================

A [Duct](https://github.com/duct-framework/duct) module that coerces a deployment-name from env. var. into a keyword.

[![Build Status](https://travis-ci.com/Zimpler/duct.module.deployment-name.svg?branch=master)](https://travis-ci.com/Zimpler/duct.module.deployment-name)
[![Dependencies Status](https://jarkeeper.com/zimpler/duct.module.deployment-name/status.png)](https://jarkeeper.com/zimpler/duct.module.deployment-name)
[![License](https://img.shields.io/badge/MIT-Clause-blue.svg)](https://opensource.org/licenses/MIT)


Leiningen/Boot
--------------

To install, add the following to you project `:dependencies`:

```clojure
[duct.module.deployment-name "0.1.0"]
```


Usage
-----

To add this module to your configuration, add the :duct.module/deployment-name key. For example:

```clojure
{:duct.core/project-ns foo
 :duct.module/deployment-name #duct/env ["TARGET_ENV" Str]}
```

Set an env. variable:

```sh
export TARGET_ENV="staging"
```

And when your system is up, under the key `:duct.module/deployment-name` you will find your env.:

```clojure
:staging
```
