/*
 * Decompiled with CFR 0.152.
 */
package dumonts.hunspell;

import dumonts.hunspell.bindings.HunspellLibrary;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bridj.NativeList;
import org.bridj.Pointer;

public class Hunspell
implements Closeable {
    private final Pointer<HunspellLibrary.Hunhandle> handle;
    private final Charset charset;

    public Hunspell(Path dictionary, Path affix) {
        Pointer aff = Pointer.pointerToCString((String)affix.toString());
        Pointer dic = Pointer.pointerToCString((String)dictionary.toString());
        this.handle = HunspellLibrary.Hunspell_create((Pointer<Byte>)aff, (Pointer<Byte>)dic);
        this.charset = Charset.forName(HunspellLibrary.Hunspell_get_dic_encoding(this.handle).getCString());
        if (this.handle == null) {
            throw new RuntimeException("Unable to create Hunspell instance");
        }
    }

    public static Hunspell forDictionaryInResources(String language, String resourcePath) {
        try {
            ClassLoader loader = Hunspell.class.getClassLoader();
            InputStream dictionaryStream = loader.getResourceAsStream(resourcePath + language + ".dic");
            InputStream affixStream = loader.getResourceAsStream(resourcePath + language + ".aff");
            if (dictionaryStream == null || affixStream == null) {
                throw new RuntimeException("Could not find dictionary for language \"" + language + "\" in classpath");
            }
            Path dictionary = Files.createTempFile(language, ".dic", new FileAttribute[0]);
            Path affix = Files.createTempFile(language, ".aff", new FileAttribute[0]);
            Files.copy(dictionaryStream, dictionary, StandardCopyOption.REPLACE_EXISTING);
            Files.copy(affixStream, affix, StandardCopyOption.REPLACE_EXISTING);
            return new Hunspell(dictionary, affix);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary dictionaries for language \"" + language + "\"", e);
        }
    }

    public static Hunspell forDictionaryInResources(String language) {
        return Hunspell.forDictionaryInResources(language, "");
    }

    public boolean spell(String word) {
        if (this.handle == null) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        int result = HunspellLibrary.Hunspell_spell(this.handle, (Pointer<Byte>)str);
        return result != 0;
    }

    public void add(String word) {
        if (this.handle == null) {
            throw new RuntimeException("Attempt to use hunspell instance after closing");
        }
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        HunspellLibrary.Hunspell_add(this.handle, (Pointer<Byte>)str);
    }

    public List<String> suggest(String word) {
        Pointer str = Pointer.pointerToString((String)word, (Pointer.StringType)Pointer.StringType.C, (Charset)this.charset);
        Pointer nativeSuggestionArray = Pointer.allocatePointerPointer(Byte.class);
        int suggestionCount = HunspellLibrary.Hunspell_suggest(this.handle, (Pointer<Pointer<Pointer<Byte>>>)nativeSuggestionArray, (Pointer<Byte>)str);
        if (suggestionCount == 0) {
            return new ArrayList<String>();
        }
        NativeList nativeSuggestionList = ((Pointer)nativeSuggestionArray.get()).validElements((long)suggestionCount).asList();
        List<String> suggestions = nativeSuggestionList.stream().map(Pointer::getCString).collect(Collectors.toList());
        HunspellLibrary.Hunspell_free_list(this.handle, (Pointer<Pointer<Pointer<Byte>>>)nativeSuggestionArray, suggestionCount);
        return suggestions;
    }

    @Override
    public void close() {
        if (this.handle != null) {
            HunspellLibrary.Hunspell_destroy(this.handle);
        }
    }
}

