goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__47004 = arguments.length;
switch (G__47004) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47008 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47008 = (function (f,blockable,meta47009){
this.f = f;
this.blockable = blockable;
this.meta47009 = meta47009;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47008.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47010,meta47009__$1){
var self__ = this;
var _47010__$1 = this;
return (new cljs.core.async.t_cljs$core$async47008(self__.f,self__.blockable,meta47009__$1));
}));

(cljs.core.async.t_cljs$core$async47008.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47010){
var self__ = this;
var _47010__$1 = this;
return self__.meta47009;
}));

(cljs.core.async.t_cljs$core$async47008.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47008.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47008.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async47008.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async47008.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta47009","meta47009",895875147,null)], null);
}));

(cljs.core.async.t_cljs$core$async47008.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47008.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47008");

(cljs.core.async.t_cljs$core$async47008.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47008");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47008.
 */
cljs.core.async.__GT_t_cljs$core$async47008 = (function cljs$core$async$__GT_t_cljs$core$async47008(f__$1,blockable__$1,meta47009){
return (new cljs.core.async.t_cljs$core$async47008(f__$1,blockable__$1,meta47009));
});

}

return (new cljs.core.async.t_cljs$core$async47008(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__47036 = arguments.length;
switch (G__47036) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__47039 = arguments.length;
switch (G__47039) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__47047 = arguments.length;
switch (G__47047) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_49016 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49016) : fn1.call(null,val_49016));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49016) : fn1.call(null,val_49016));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__47063 = arguments.length;
switch (G__47063) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___49022 = n;
var x_49023 = (0);
while(true){
if((x_49023 < n__4613__auto___49022)){
(a[x_49023] = x_49023);

var G__49024 = (x_49023 + (1));
x_49023 = G__49024;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47086 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47086 = (function (flag,meta47087){
this.flag = flag;
this.meta47087 = meta47087;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47086.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47088,meta47087__$1){
var self__ = this;
var _47088__$1 = this;
return (new cljs.core.async.t_cljs$core$async47086(self__.flag,meta47087__$1));
}));

(cljs.core.async.t_cljs$core$async47086.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47088){
var self__ = this;
var _47088__$1 = this;
return self__.meta47087;
}));

(cljs.core.async.t_cljs$core$async47086.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47086.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async47086.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47086.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async47086.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta47087","meta47087",-1538194959,null)], null);
}));

(cljs.core.async.t_cljs$core$async47086.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47086.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47086");

(cljs.core.async.t_cljs$core$async47086.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47086");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47086.
 */
cljs.core.async.__GT_t_cljs$core$async47086 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async47086(flag__$1,meta47087){
return (new cljs.core.async.t_cljs$core$async47086(flag__$1,meta47087));
});

}

return (new cljs.core.async.t_cljs$core$async47086(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47101 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47101 = (function (flag,cb,meta47102){
this.flag = flag;
this.cb = cb;
this.meta47102 = meta47102;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47101.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47103,meta47102__$1){
var self__ = this;
var _47103__$1 = this;
return (new cljs.core.async.t_cljs$core$async47101(self__.flag,self__.cb,meta47102__$1));
}));

(cljs.core.async.t_cljs$core$async47101.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47103){
var self__ = this;
var _47103__$1 = this;
return self__.meta47102;
}));

(cljs.core.async.t_cljs$core$async47101.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47101.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async47101.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47101.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async47101.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta47102","meta47102",35279329,null)], null);
}));

(cljs.core.async.t_cljs$core$async47101.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47101.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47101");

(cljs.core.async.t_cljs$core$async47101.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47101");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47101.
 */
cljs.core.async.__GT_t_cljs$core$async47101 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async47101(flag__$1,cb__$1,meta47102){
return (new cljs.core.async.t_cljs$core$async47101(flag__$1,cb__$1,meta47102));
});

}

return (new cljs.core.async.t_cljs$core$async47101(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47121_SHARP_){
var G__47124 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47121_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__47124) : fret.call(null,G__47124));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47122_SHARP_){
var G__47125 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47122_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__47125) : fret.call(null,G__47125));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__49051 = (i + (1));
i = G__49051;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___49054 = arguments.length;
var i__4737__auto___49055 = (0);
while(true){
if((i__4737__auto___49055 < len__4736__auto___49054)){
args__4742__auto__.push((arguments[i__4737__auto___49055]));

var G__49056 = (i__4737__auto___49055 + (1));
i__4737__auto___49055 = G__49056;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__47131){
var map__47132 = p__47131;
var map__47132__$1 = (((((!((map__47132 == null))))?(((((map__47132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47132.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47132):map__47132);
var opts = map__47132__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq47127){
var G__47128 = cljs.core.first(seq47127);
var seq47127__$1 = cljs.core.next(seq47127);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47128,seq47127__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__47146 = arguments.length;
switch (G__47146) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__46897__auto___49059 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47212){
var state_val_47215 = (state_47212[(1)]);
if((state_val_47215 === (7))){
var inst_47203 = (state_47212[(2)]);
var state_47212__$1 = state_47212;
var statearr_47220_49060 = state_47212__$1;
(statearr_47220_49060[(2)] = inst_47203);

(statearr_47220_49060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (1))){
var state_47212__$1 = state_47212;
var statearr_47221_49061 = state_47212__$1;
(statearr_47221_49061[(2)] = null);

(statearr_47221_49061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (4))){
var inst_47168 = (state_47212[(7)]);
var inst_47168__$1 = (state_47212[(2)]);
var inst_47175 = (inst_47168__$1 == null);
var state_47212__$1 = (function (){var statearr_47222 = state_47212;
(statearr_47222[(7)] = inst_47168__$1);

return statearr_47222;
})();
if(cljs.core.truth_(inst_47175)){
var statearr_47223_49062 = state_47212__$1;
(statearr_47223_49062[(1)] = (5));

} else {
var statearr_47224_49063 = state_47212__$1;
(statearr_47224_49063[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (13))){
var state_47212__$1 = state_47212;
var statearr_47225_49064 = state_47212__$1;
(statearr_47225_49064[(2)] = null);

(statearr_47225_49064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (6))){
var inst_47168 = (state_47212[(7)]);
var state_47212__$1 = state_47212;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47212__$1,(11),to,inst_47168);
} else {
if((state_val_47215 === (3))){
var inst_47207 = (state_47212[(2)]);
var state_47212__$1 = state_47212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47212__$1,inst_47207);
} else {
if((state_val_47215 === (12))){
var state_47212__$1 = state_47212;
var statearr_47228_49069 = state_47212__$1;
(statearr_47228_49069[(2)] = null);

(statearr_47228_49069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (2))){
var state_47212__$1 = state_47212;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47212__$1,(4),from);
} else {
if((state_val_47215 === (11))){
var inst_47185 = (state_47212[(2)]);
var state_47212__$1 = state_47212;
if(cljs.core.truth_(inst_47185)){
var statearr_47229_49070 = state_47212__$1;
(statearr_47229_49070[(1)] = (12));

} else {
var statearr_47230_49071 = state_47212__$1;
(statearr_47230_49071[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (9))){
var state_47212__$1 = state_47212;
var statearr_47231_49072 = state_47212__$1;
(statearr_47231_49072[(2)] = null);

(statearr_47231_49072[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (5))){
var state_47212__$1 = state_47212;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47235_49073 = state_47212__$1;
(statearr_47235_49073[(1)] = (8));

} else {
var statearr_47236_49074 = state_47212__$1;
(statearr_47236_49074[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (14))){
var inst_47201 = (state_47212[(2)]);
var state_47212__$1 = state_47212;
var statearr_47237_49075 = state_47212__$1;
(statearr_47237_49075[(2)] = inst_47201);

(statearr_47237_49075[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (10))){
var inst_47182 = (state_47212[(2)]);
var state_47212__$1 = state_47212;
var statearr_47238_49076 = state_47212__$1;
(statearr_47238_49076[(2)] = inst_47182);

(statearr_47238_49076[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47215 === (8))){
var inst_47179 = cljs.core.async.close_BANG_(to);
var state_47212__$1 = state_47212;
var statearr_47241_49077 = state_47212__$1;
(statearr_47241_49077[(2)] = inst_47179);

(statearr_47241_49077[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_47243 = [null,null,null,null,null,null,null,null];
(statearr_47243[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_47243[(1)] = (1));

return statearr_47243;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_47212){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47212);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47244){var ex__46801__auto__ = e47244;
var statearr_47245_49078 = state_47212;
(statearr_47245_49078[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47212[(4)]))){
var statearr_47246_49079 = state_47212;
(statearr_47246_49079[(1)] = cljs.core.first((state_47212[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49081 = state_47212;
state_47212 = G__49081;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_47212){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_47212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47247 = f__46898__auto__();
(statearr_47247[(6)] = c__46897__auto___49059);

return statearr_47247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__47256){
var vec__47257 = p__47256;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47257,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47257,(1),null);
var job = vec__47257;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__46897__auto___49083 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47264){
var state_val_47265 = (state_47264[(1)]);
if((state_val_47265 === (1))){
var state_47264__$1 = state_47264;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47264__$1,(2),res,v);
} else {
if((state_val_47265 === (2))){
var inst_47261 = (state_47264[(2)]);
var inst_47262 = cljs.core.async.close_BANG_(res);
var state_47264__$1 = (function (){var statearr_47270 = state_47264;
(statearr_47270[(7)] = inst_47261);

return statearr_47270;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47264__$1,inst_47262);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0 = (function (){
var statearr_47271 = [null,null,null,null,null,null,null,null];
(statearr_47271[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__);

(statearr_47271[(1)] = (1));

return statearr_47271;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1 = (function (state_47264){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47264);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47272){var ex__46801__auto__ = e47272;
var statearr_47273_49084 = state_47264;
(statearr_47273_49084[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47264[(4)]))){
var statearr_47274_49085 = state_47264;
(statearr_47274_49085[(1)] = cljs.core.first((state_47264[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49086 = state_47264;
state_47264 = G__49086;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = function(state_47264){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1.call(this,state_47264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47275 = f__46898__auto__();
(statearr_47275[(6)] = c__46897__auto___49083);

return statearr_47275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__47276){
var vec__47283 = p__47276;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47283,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47283,(1),null);
var job = vec__47283;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___49091 = n;
var __49092 = (0);
while(true){
if((__49092 < n__4613__auto___49091)){
var G__47292_49093 = type;
var G__47292_49094__$1 = (((G__47292_49093 instanceof cljs.core.Keyword))?G__47292_49093.fqn:null);
switch (G__47292_49094__$1) {
case "compute":
var c__46897__auto___49096 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49092,c__46897__auto___49096,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async){
return (function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = ((function (__49092,c__46897__auto___49096,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async){
return (function (state_47308){
var state_val_47309 = (state_47308[(1)]);
if((state_val_47309 === (1))){
var state_47308__$1 = state_47308;
var statearr_47313_49100 = state_47308__$1;
(statearr_47313_49100[(2)] = null);

(statearr_47313_49100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47309 === (2))){
var state_47308__$1 = state_47308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47308__$1,(4),jobs);
} else {
if((state_val_47309 === (3))){
var inst_47306 = (state_47308[(2)]);
var state_47308__$1 = state_47308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47308__$1,inst_47306);
} else {
if((state_val_47309 === (4))){
var inst_47298 = (state_47308[(2)]);
var inst_47299 = process(inst_47298);
var state_47308__$1 = state_47308;
if(cljs.core.truth_(inst_47299)){
var statearr_47314_49104 = state_47308__$1;
(statearr_47314_49104[(1)] = (5));

} else {
var statearr_47315_49105 = state_47308__$1;
(statearr_47315_49105[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47309 === (5))){
var state_47308__$1 = state_47308;
var statearr_47316_49106 = state_47308__$1;
(statearr_47316_49106[(2)] = null);

(statearr_47316_49106[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47309 === (6))){
var state_47308__$1 = state_47308;
var statearr_47317_49110 = state_47308__$1;
(statearr_47317_49110[(2)] = null);

(statearr_47317_49110[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47309 === (7))){
var inst_47304 = (state_47308[(2)]);
var state_47308__$1 = state_47308;
var statearr_47321_49111 = state_47308__$1;
(statearr_47321_49111[(2)] = inst_47304);

(statearr_47321_49111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49092,c__46897__auto___49096,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async))
;
return ((function (__49092,switch__46797__auto__,c__46897__auto___49096,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0 = (function (){
var statearr_47326 = [null,null,null,null,null,null,null];
(statearr_47326[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__);

(statearr_47326[(1)] = (1));

return statearr_47326;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1 = (function (state_47308){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47308);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47327){var ex__46801__auto__ = e47327;
var statearr_47328_49115 = state_47308;
(statearr_47328_49115[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47308[(4)]))){
var statearr_47329_49116 = state_47308;
(statearr_47329_49116[(1)] = cljs.core.first((state_47308[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49121 = state_47308;
state_47308 = G__49121;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = function(state_47308){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1.call(this,state_47308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__;
})()
;})(__49092,switch__46797__auto__,c__46897__auto___49096,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async))
})();
var state__46899__auto__ = (function (){var statearr_47330 = f__46898__auto__();
(statearr_47330[(6)] = c__46897__auto___49096);

return statearr_47330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
});})(__49092,c__46897__auto___49096,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async))
);


break;
case "async":
var c__46897__auto___49125 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49092,c__46897__auto___49125,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async){
return (function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = ((function (__49092,c__46897__auto___49125,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async){
return (function (state_47346){
var state_val_47347 = (state_47346[(1)]);
if((state_val_47347 === (1))){
var state_47346__$1 = state_47346;
var statearr_47348_49129 = state_47346__$1;
(statearr_47348_49129[(2)] = null);

(statearr_47348_49129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47347 === (2))){
var state_47346__$1 = state_47346;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47346__$1,(4),jobs);
} else {
if((state_val_47347 === (3))){
var inst_47343 = (state_47346[(2)]);
var state_47346__$1 = state_47346;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47346__$1,inst_47343);
} else {
if((state_val_47347 === (4))){
var inst_47334 = (state_47346[(2)]);
var inst_47335 = async(inst_47334);
var state_47346__$1 = state_47346;
if(cljs.core.truth_(inst_47335)){
var statearr_47349_49133 = state_47346__$1;
(statearr_47349_49133[(1)] = (5));

} else {
var statearr_47350_49134 = state_47346__$1;
(statearr_47350_49134[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47347 === (5))){
var state_47346__$1 = state_47346;
var statearr_47351_49135 = state_47346__$1;
(statearr_47351_49135[(2)] = null);

(statearr_47351_49135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47347 === (6))){
var state_47346__$1 = state_47346;
var statearr_47352_49136 = state_47346__$1;
(statearr_47352_49136[(2)] = null);

(statearr_47352_49136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47347 === (7))){
var inst_47341 = (state_47346[(2)]);
var state_47346__$1 = state_47346;
var statearr_47353_49137 = state_47346__$1;
(statearr_47353_49137[(2)] = inst_47341);

(statearr_47353_49137[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49092,c__46897__auto___49125,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async))
;
return ((function (__49092,switch__46797__auto__,c__46897__auto___49125,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0 = (function (){
var statearr_47355 = [null,null,null,null,null,null,null];
(statearr_47355[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__);

(statearr_47355[(1)] = (1));

return statearr_47355;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1 = (function (state_47346){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47346);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47356){var ex__46801__auto__ = e47356;
var statearr_47357_49141 = state_47346;
(statearr_47357_49141[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47346[(4)]))){
var statearr_47359_49142 = state_47346;
(statearr_47359_49142[(1)] = cljs.core.first((state_47346[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49143 = state_47346;
state_47346 = G__49143;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = function(state_47346){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1.call(this,state_47346);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__;
})()
;})(__49092,switch__46797__auto__,c__46897__auto___49125,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async))
})();
var state__46899__auto__ = (function (){var statearr_47360 = f__46898__auto__();
(statearr_47360[(6)] = c__46897__auto___49125);

return statearr_47360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
});})(__49092,c__46897__auto___49125,G__47292_49093,G__47292_49094__$1,n__4613__auto___49091,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__47292_49094__$1)].join('')));

}

var G__49145 = (__49092 + (1));
__49092 = G__49145;
continue;
} else {
}
break;
}

var c__46897__auto___49146 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47382){
var state_val_47383 = (state_47382[(1)]);
if((state_val_47383 === (7))){
var inst_47378 = (state_47382[(2)]);
var state_47382__$1 = state_47382;
var statearr_47384_49147 = state_47382__$1;
(statearr_47384_49147[(2)] = inst_47378);

(statearr_47384_49147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (1))){
var state_47382__$1 = state_47382;
var statearr_47385_49148 = state_47382__$1;
(statearr_47385_49148[(2)] = null);

(statearr_47385_49148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (4))){
var inst_47363 = (state_47382[(7)]);
var inst_47363__$1 = (state_47382[(2)]);
var inst_47364 = (inst_47363__$1 == null);
var state_47382__$1 = (function (){var statearr_47386 = state_47382;
(statearr_47386[(7)] = inst_47363__$1);

return statearr_47386;
})();
if(cljs.core.truth_(inst_47364)){
var statearr_47387_49149 = state_47382__$1;
(statearr_47387_49149[(1)] = (5));

} else {
var statearr_47388_49150 = state_47382__$1;
(statearr_47388_49150[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (6))){
var inst_47368 = (state_47382[(8)]);
var inst_47363 = (state_47382[(7)]);
var inst_47368__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_47369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47370 = [inst_47363,inst_47368__$1];
var inst_47371 = (new cljs.core.PersistentVector(null,2,(5),inst_47369,inst_47370,null));
var state_47382__$1 = (function (){var statearr_47389 = state_47382;
(statearr_47389[(8)] = inst_47368__$1);

return statearr_47389;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47382__$1,(8),jobs,inst_47371);
} else {
if((state_val_47383 === (3))){
var inst_47380 = (state_47382[(2)]);
var state_47382__$1 = state_47382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47382__$1,inst_47380);
} else {
if((state_val_47383 === (2))){
var state_47382__$1 = state_47382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47382__$1,(4),from);
} else {
if((state_val_47383 === (9))){
var inst_47375 = (state_47382[(2)]);
var state_47382__$1 = (function (){var statearr_47390 = state_47382;
(statearr_47390[(9)] = inst_47375);

return statearr_47390;
})();
var statearr_47395_49152 = state_47382__$1;
(statearr_47395_49152[(2)] = null);

(statearr_47395_49152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (5))){
var inst_47366 = cljs.core.async.close_BANG_(jobs);
var state_47382__$1 = state_47382;
var statearr_47397_49153 = state_47382__$1;
(statearr_47397_49153[(2)] = inst_47366);

(statearr_47397_49153[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47383 === (8))){
var inst_47368 = (state_47382[(8)]);
var inst_47373 = (state_47382[(2)]);
var state_47382__$1 = (function (){var statearr_47403 = state_47382;
(statearr_47403[(10)] = inst_47373);

return statearr_47403;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47382__$1,(9),results,inst_47368);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0 = (function (){
var statearr_47411 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47411[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__);

(statearr_47411[(1)] = (1));

return statearr_47411;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1 = (function (state_47382){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47382);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47416){var ex__46801__auto__ = e47416;
var statearr_47421_49154 = state_47382;
(statearr_47421_49154[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47382[(4)]))){
var statearr_47425_49155 = state_47382;
(statearr_47425_49155[(1)] = cljs.core.first((state_47382[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49156 = state_47382;
state_47382 = G__49156;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = function(state_47382){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1.call(this,state_47382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47437 = f__46898__auto__();
(statearr_47437[(6)] = c__46897__auto___49146);

return statearr_47437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


var c__46897__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47483){
var state_val_47484 = (state_47483[(1)]);
if((state_val_47484 === (7))){
var inst_47479 = (state_47483[(2)]);
var state_47483__$1 = state_47483;
var statearr_47485_49157 = state_47483__$1;
(statearr_47485_49157[(2)] = inst_47479);

(statearr_47485_49157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (20))){
var state_47483__$1 = state_47483;
var statearr_47486_49158 = state_47483__$1;
(statearr_47486_49158[(2)] = null);

(statearr_47486_49158[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (1))){
var state_47483__$1 = state_47483;
var statearr_47487_49159 = state_47483__$1;
(statearr_47487_49159[(2)] = null);

(statearr_47487_49159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (4))){
var inst_47447 = (state_47483[(7)]);
var inst_47447__$1 = (state_47483[(2)]);
var inst_47448 = (inst_47447__$1 == null);
var state_47483__$1 = (function (){var statearr_47489 = state_47483;
(statearr_47489[(7)] = inst_47447__$1);

return statearr_47489;
})();
if(cljs.core.truth_(inst_47448)){
var statearr_47490_49163 = state_47483__$1;
(statearr_47490_49163[(1)] = (5));

} else {
var statearr_47491_49164 = state_47483__$1;
(statearr_47491_49164[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (15))){
var inst_47460 = (state_47483[(8)]);
var state_47483__$1 = state_47483;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47483__$1,(18),to,inst_47460);
} else {
if((state_val_47484 === (21))){
var inst_47474 = (state_47483[(2)]);
var state_47483__$1 = state_47483;
var statearr_47492_49168 = state_47483__$1;
(statearr_47492_49168[(2)] = inst_47474);

(statearr_47492_49168[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (13))){
var inst_47476 = (state_47483[(2)]);
var state_47483__$1 = (function (){var statearr_47493 = state_47483;
(statearr_47493[(9)] = inst_47476);

return statearr_47493;
})();
var statearr_47494_49169 = state_47483__$1;
(statearr_47494_49169[(2)] = null);

(statearr_47494_49169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (6))){
var inst_47447 = (state_47483[(7)]);
var state_47483__$1 = state_47483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47483__$1,(11),inst_47447);
} else {
if((state_val_47484 === (17))){
var inst_47469 = (state_47483[(2)]);
var state_47483__$1 = state_47483;
if(cljs.core.truth_(inst_47469)){
var statearr_47495_49171 = state_47483__$1;
(statearr_47495_49171[(1)] = (19));

} else {
var statearr_47496_49172 = state_47483__$1;
(statearr_47496_49172[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (3))){
var inst_47481 = (state_47483[(2)]);
var state_47483__$1 = state_47483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47483__$1,inst_47481);
} else {
if((state_val_47484 === (12))){
var inst_47457 = (state_47483[(10)]);
var state_47483__$1 = state_47483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47483__$1,(14),inst_47457);
} else {
if((state_val_47484 === (2))){
var state_47483__$1 = state_47483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47483__$1,(4),results);
} else {
if((state_val_47484 === (19))){
var state_47483__$1 = state_47483;
var statearr_47497_49175 = state_47483__$1;
(statearr_47497_49175[(2)] = null);

(statearr_47497_49175[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (11))){
var inst_47457 = (state_47483[(2)]);
var state_47483__$1 = (function (){var statearr_47498 = state_47483;
(statearr_47498[(10)] = inst_47457);

return statearr_47498;
})();
var statearr_47499_49176 = state_47483__$1;
(statearr_47499_49176[(2)] = null);

(statearr_47499_49176[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (9))){
var state_47483__$1 = state_47483;
var statearr_47500_49177 = state_47483__$1;
(statearr_47500_49177[(2)] = null);

(statearr_47500_49177[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (5))){
var state_47483__$1 = state_47483;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47501_49178 = state_47483__$1;
(statearr_47501_49178[(1)] = (8));

} else {
var statearr_47502_49179 = state_47483__$1;
(statearr_47502_49179[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (14))){
var inst_47460 = (state_47483[(8)]);
var inst_47460__$1 = (state_47483[(2)]);
var inst_47461 = (inst_47460__$1 == null);
var inst_47462 = cljs.core.not(inst_47461);
var state_47483__$1 = (function (){var statearr_47503 = state_47483;
(statearr_47503[(8)] = inst_47460__$1);

return statearr_47503;
})();
if(inst_47462){
var statearr_47504_49180 = state_47483__$1;
(statearr_47504_49180[(1)] = (15));

} else {
var statearr_47505_49181 = state_47483__$1;
(statearr_47505_49181[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (16))){
var state_47483__$1 = state_47483;
var statearr_47506_49182 = state_47483__$1;
(statearr_47506_49182[(2)] = false);

(statearr_47506_49182[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (10))){
var inst_47454 = (state_47483[(2)]);
var state_47483__$1 = state_47483;
var statearr_47507_49184 = state_47483__$1;
(statearr_47507_49184[(2)] = inst_47454);

(statearr_47507_49184[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (18))){
var inst_47466 = (state_47483[(2)]);
var state_47483__$1 = state_47483;
var statearr_47508_49188 = state_47483__$1;
(statearr_47508_49188[(2)] = inst_47466);

(statearr_47508_49188[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47484 === (8))){
var inst_47451 = cljs.core.async.close_BANG_(to);
var state_47483__$1 = state_47483;
var statearr_47509_49189 = state_47483__$1;
(statearr_47509_49189[(2)] = inst_47451);

(statearr_47509_49189[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0 = (function (){
var statearr_47510 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47510[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__);

(statearr_47510[(1)] = (1));

return statearr_47510;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1 = (function (state_47483){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47483);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47511){var ex__46801__auto__ = e47511;
var statearr_47512_49194 = state_47483;
(statearr_47512_49194[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47483[(4)]))){
var statearr_47513_49195 = state_47483;
(statearr_47513_49195[(1)] = cljs.core.first((state_47483[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49199 = state_47483;
state_47483 = G__49199;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__ = function(state_47483){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1.call(this,state_47483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46798__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47514 = f__46898__auto__();
(statearr_47514[(6)] = c__46897__auto__);

return statearr_47514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));

return c__46897__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__47516 = arguments.length;
switch (G__47516) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__47518 = arguments.length;
switch (G__47518) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__47520 = arguments.length;
switch (G__47520) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__46897__auto___49224 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47546){
var state_val_47547 = (state_47546[(1)]);
if((state_val_47547 === (7))){
var inst_47542 = (state_47546[(2)]);
var state_47546__$1 = state_47546;
var statearr_47548_49226 = state_47546__$1;
(statearr_47548_49226[(2)] = inst_47542);

(statearr_47548_49226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (1))){
var state_47546__$1 = state_47546;
var statearr_47549_49227 = state_47546__$1;
(statearr_47549_49227[(2)] = null);

(statearr_47549_49227[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (4))){
var inst_47523 = (state_47546[(7)]);
var inst_47523__$1 = (state_47546[(2)]);
var inst_47524 = (inst_47523__$1 == null);
var state_47546__$1 = (function (){var statearr_47550 = state_47546;
(statearr_47550[(7)] = inst_47523__$1);

return statearr_47550;
})();
if(cljs.core.truth_(inst_47524)){
var statearr_47551_49228 = state_47546__$1;
(statearr_47551_49228[(1)] = (5));

} else {
var statearr_47552_49229 = state_47546__$1;
(statearr_47552_49229[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (13))){
var state_47546__$1 = state_47546;
var statearr_47553_49231 = state_47546__$1;
(statearr_47553_49231[(2)] = null);

(statearr_47553_49231[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (6))){
var inst_47523 = (state_47546[(7)]);
var inst_47529 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47523) : p.call(null,inst_47523));
var state_47546__$1 = state_47546;
if(cljs.core.truth_(inst_47529)){
var statearr_47554_49235 = state_47546__$1;
(statearr_47554_49235[(1)] = (9));

} else {
var statearr_47555_49236 = state_47546__$1;
(statearr_47555_49236[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (3))){
var inst_47544 = (state_47546[(2)]);
var state_47546__$1 = state_47546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47546__$1,inst_47544);
} else {
if((state_val_47547 === (12))){
var state_47546__$1 = state_47546;
var statearr_47556_49243 = state_47546__$1;
(statearr_47556_49243[(2)] = null);

(statearr_47556_49243[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (2))){
var state_47546__$1 = state_47546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47546__$1,(4),ch);
} else {
if((state_val_47547 === (11))){
var inst_47523 = (state_47546[(7)]);
var inst_47533 = (state_47546[(2)]);
var state_47546__$1 = state_47546;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47546__$1,(8),inst_47533,inst_47523);
} else {
if((state_val_47547 === (9))){
var state_47546__$1 = state_47546;
var statearr_47557_49244 = state_47546__$1;
(statearr_47557_49244[(2)] = tc);

(statearr_47557_49244[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (5))){
var inst_47526 = cljs.core.async.close_BANG_(tc);
var inst_47527 = cljs.core.async.close_BANG_(fc);
var state_47546__$1 = (function (){var statearr_47558 = state_47546;
(statearr_47558[(8)] = inst_47526);

return statearr_47558;
})();
var statearr_47559_49245 = state_47546__$1;
(statearr_47559_49245[(2)] = inst_47527);

(statearr_47559_49245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (14))){
var inst_47540 = (state_47546[(2)]);
var state_47546__$1 = state_47546;
var statearr_47560_49246 = state_47546__$1;
(statearr_47560_49246[(2)] = inst_47540);

(statearr_47560_49246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (10))){
var state_47546__$1 = state_47546;
var statearr_47561_49247 = state_47546__$1;
(statearr_47561_49247[(2)] = fc);

(statearr_47561_49247[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47547 === (8))){
var inst_47535 = (state_47546[(2)]);
var state_47546__$1 = state_47546;
if(cljs.core.truth_(inst_47535)){
var statearr_47562_49248 = state_47546__$1;
(statearr_47562_49248[(1)] = (12));

} else {
var statearr_47563_49249 = state_47546__$1;
(statearr_47563_49249[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_47564 = [null,null,null,null,null,null,null,null,null];
(statearr_47564[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_47564[(1)] = (1));

return statearr_47564;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_47546){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47546);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47565){var ex__46801__auto__ = e47565;
var statearr_47566_49250 = state_47546;
(statearr_47566_49250[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47546[(4)]))){
var statearr_47567_49251 = state_47546;
(statearr_47567_49251[(1)] = cljs.core.first((state_47546[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49252 = state_47546;
state_47546 = G__49252;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_47546){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_47546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47568 = f__46898__auto__();
(statearr_47568[(6)] = c__46897__auto___49224);

return statearr_47568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__46897__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47590){
var state_val_47591 = (state_47590[(1)]);
if((state_val_47591 === (7))){
var inst_47586 = (state_47590[(2)]);
var state_47590__$1 = state_47590;
var statearr_47592_49259 = state_47590__$1;
(statearr_47592_49259[(2)] = inst_47586);

(statearr_47592_49259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47591 === (1))){
var inst_47569 = init;
var inst_47570 = inst_47569;
var state_47590__$1 = (function (){var statearr_47593 = state_47590;
(statearr_47593[(7)] = inst_47570);

return statearr_47593;
})();
var statearr_47594_49260 = state_47590__$1;
(statearr_47594_49260[(2)] = null);

(statearr_47594_49260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47591 === (4))){
var inst_47573 = (state_47590[(8)]);
var inst_47573__$1 = (state_47590[(2)]);
var inst_47574 = (inst_47573__$1 == null);
var state_47590__$1 = (function (){var statearr_47595 = state_47590;
(statearr_47595[(8)] = inst_47573__$1);

return statearr_47595;
})();
if(cljs.core.truth_(inst_47574)){
var statearr_47596_49264 = state_47590__$1;
(statearr_47596_49264[(1)] = (5));

} else {
var statearr_47597_49265 = state_47590__$1;
(statearr_47597_49265[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47591 === (6))){
var inst_47573 = (state_47590[(8)]);
var inst_47570 = (state_47590[(7)]);
var inst_47577 = (state_47590[(9)]);
var inst_47577__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_47570,inst_47573) : f.call(null,inst_47570,inst_47573));
var inst_47578 = cljs.core.reduced_QMARK_(inst_47577__$1);
var state_47590__$1 = (function (){var statearr_47598 = state_47590;
(statearr_47598[(9)] = inst_47577__$1);

return statearr_47598;
})();
if(inst_47578){
var statearr_47599_49266 = state_47590__$1;
(statearr_47599_49266[(1)] = (8));

} else {
var statearr_47600_49267 = state_47590__$1;
(statearr_47600_49267[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47591 === (3))){
var inst_47588 = (state_47590[(2)]);
var state_47590__$1 = state_47590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47590__$1,inst_47588);
} else {
if((state_val_47591 === (2))){
var state_47590__$1 = state_47590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47590__$1,(4),ch);
} else {
if((state_val_47591 === (9))){
var inst_47577 = (state_47590[(9)]);
var inst_47570 = inst_47577;
var state_47590__$1 = (function (){var statearr_47601 = state_47590;
(statearr_47601[(7)] = inst_47570);

return statearr_47601;
})();
var statearr_47602_49268 = state_47590__$1;
(statearr_47602_49268[(2)] = null);

(statearr_47602_49268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47591 === (5))){
var inst_47570 = (state_47590[(7)]);
var state_47590__$1 = state_47590;
var statearr_47603_49269 = state_47590__$1;
(statearr_47603_49269[(2)] = inst_47570);

(statearr_47603_49269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47591 === (10))){
var inst_47584 = (state_47590[(2)]);
var state_47590__$1 = state_47590;
var statearr_47608_49270 = state_47590__$1;
(statearr_47608_49270[(2)] = inst_47584);

(statearr_47608_49270[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47591 === (8))){
var inst_47577 = (state_47590[(9)]);
var inst_47580 = cljs.core.deref(inst_47577);
var state_47590__$1 = state_47590;
var statearr_47609_49272 = state_47590__$1;
(statearr_47609_49272[(2)] = inst_47580);

(statearr_47609_49272[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__46798__auto__ = null;
var cljs$core$async$reduce_$_state_machine__46798__auto____0 = (function (){
var statearr_47610 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47610[(0)] = cljs$core$async$reduce_$_state_machine__46798__auto__);

(statearr_47610[(1)] = (1));

return statearr_47610;
});
var cljs$core$async$reduce_$_state_machine__46798__auto____1 = (function (state_47590){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47590);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47611){var ex__46801__auto__ = e47611;
var statearr_47612_49273 = state_47590;
(statearr_47612_49273[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47590[(4)]))){
var statearr_47613_49274 = state_47590;
(statearr_47613_49274[(1)] = cljs.core.first((state_47590[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49275 = state_47590;
state_47590 = G__49275;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__46798__auto__ = function(state_47590){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__46798__auto____1.call(this,state_47590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__46798__auto____0;
cljs$core$async$reduce_$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__46798__auto____1;
return cljs$core$async$reduce_$_state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47614 = f__46898__auto__();
(statearr_47614[(6)] = c__46897__auto__);

return statearr_47614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));

return c__46897__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__46897__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47620){
var state_val_47621 = (state_47620[(1)]);
if((state_val_47621 === (1))){
var inst_47615 = cljs.core.async.reduce(f__$1,init,ch);
var state_47620__$1 = state_47620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47620__$1,(2),inst_47615);
} else {
if((state_val_47621 === (2))){
var inst_47617 = (state_47620[(2)]);
var inst_47618 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_47617) : f__$1.call(null,inst_47617));
var state_47620__$1 = state_47620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47620__$1,inst_47618);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__46798__auto__ = null;
var cljs$core$async$transduce_$_state_machine__46798__auto____0 = (function (){
var statearr_47622 = [null,null,null,null,null,null,null];
(statearr_47622[(0)] = cljs$core$async$transduce_$_state_machine__46798__auto__);

(statearr_47622[(1)] = (1));

return statearr_47622;
});
var cljs$core$async$transduce_$_state_machine__46798__auto____1 = (function (state_47620){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47620);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47623){var ex__46801__auto__ = e47623;
var statearr_47624_49281 = state_47620;
(statearr_47624_49281[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47620[(4)]))){
var statearr_47625_49282 = state_47620;
(statearr_47625_49282[(1)] = cljs.core.first((state_47620[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49283 = state_47620;
state_47620 = G__49283;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__46798__auto__ = function(state_47620){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__46798__auto____1.call(this,state_47620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__46798__auto____0;
cljs$core$async$transduce_$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__46798__auto____1;
return cljs$core$async$transduce_$_state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47626 = f__46898__auto__();
(statearr_47626[(6)] = c__46897__auto__);

return statearr_47626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));

return c__46897__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__47630 = arguments.length;
switch (G__47630) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__46897__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47655){
var state_val_47656 = (state_47655[(1)]);
if((state_val_47656 === (7))){
var inst_47637 = (state_47655[(2)]);
var state_47655__$1 = state_47655;
var statearr_47657_49290 = state_47655__$1;
(statearr_47657_49290[(2)] = inst_47637);

(statearr_47657_49290[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (1))){
var inst_47631 = cljs.core.seq(coll);
var inst_47632 = inst_47631;
var state_47655__$1 = (function (){var statearr_47658 = state_47655;
(statearr_47658[(7)] = inst_47632);

return statearr_47658;
})();
var statearr_47659_49292 = state_47655__$1;
(statearr_47659_49292[(2)] = null);

(statearr_47659_49292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (4))){
var inst_47632 = (state_47655[(7)]);
var inst_47635 = cljs.core.first(inst_47632);
var state_47655__$1 = state_47655;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47655__$1,(7),ch,inst_47635);
} else {
if((state_val_47656 === (13))){
var inst_47649 = (state_47655[(2)]);
var state_47655__$1 = state_47655;
var statearr_47660_49294 = state_47655__$1;
(statearr_47660_49294[(2)] = inst_47649);

(statearr_47660_49294[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (6))){
var inst_47640 = (state_47655[(2)]);
var state_47655__$1 = state_47655;
if(cljs.core.truth_(inst_47640)){
var statearr_47661_49299 = state_47655__$1;
(statearr_47661_49299[(1)] = (8));

} else {
var statearr_47662_49300 = state_47655__$1;
(statearr_47662_49300[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (3))){
var inst_47653 = (state_47655[(2)]);
var state_47655__$1 = state_47655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47655__$1,inst_47653);
} else {
if((state_val_47656 === (12))){
var state_47655__$1 = state_47655;
var statearr_47663_49301 = state_47655__$1;
(statearr_47663_49301[(2)] = null);

(statearr_47663_49301[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (2))){
var inst_47632 = (state_47655[(7)]);
var state_47655__$1 = state_47655;
if(cljs.core.truth_(inst_47632)){
var statearr_47664_49302 = state_47655__$1;
(statearr_47664_49302[(1)] = (4));

} else {
var statearr_47665_49303 = state_47655__$1;
(statearr_47665_49303[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (11))){
var inst_47646 = cljs.core.async.close_BANG_(ch);
var state_47655__$1 = state_47655;
var statearr_47666_49307 = state_47655__$1;
(statearr_47666_49307[(2)] = inst_47646);

(statearr_47666_49307[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (9))){
var state_47655__$1 = state_47655;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47667_49308 = state_47655__$1;
(statearr_47667_49308[(1)] = (11));

} else {
var statearr_47668_49309 = state_47655__$1;
(statearr_47668_49309[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (5))){
var inst_47632 = (state_47655[(7)]);
var state_47655__$1 = state_47655;
var statearr_47669_49310 = state_47655__$1;
(statearr_47669_49310[(2)] = inst_47632);

(statearr_47669_49310[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (10))){
var inst_47651 = (state_47655[(2)]);
var state_47655__$1 = state_47655;
var statearr_47670_49312 = state_47655__$1;
(statearr_47670_49312[(2)] = inst_47651);

(statearr_47670_49312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47656 === (8))){
var inst_47632 = (state_47655[(7)]);
var inst_47642 = cljs.core.next(inst_47632);
var inst_47632__$1 = inst_47642;
var state_47655__$1 = (function (){var statearr_47671 = state_47655;
(statearr_47671[(7)] = inst_47632__$1);

return statearr_47671;
})();
var statearr_47672_49316 = state_47655__$1;
(statearr_47672_49316[(2)] = null);

(statearr_47672_49316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_47677 = [null,null,null,null,null,null,null,null];
(statearr_47677[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_47677[(1)] = (1));

return statearr_47677;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_47655){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47655);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47678){var ex__46801__auto__ = e47678;
var statearr_47679_49318 = state_47655;
(statearr_47679_49318[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47655[(4)]))){
var statearr_47680_49320 = state_47655;
(statearr_47680_49320[(1)] = cljs.core.first((state_47655[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49321 = state_47655;
state_47655 = G__49321;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_47655){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_47655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47681 = f__46898__auto__();
(statearr_47681[(6)] = c__46897__auto__);

return statearr_47681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));

return c__46897__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__47683 = arguments.length;
switch (G__47683) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_49326 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_49326(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_49330 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_49330(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_49334 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_49334(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_49336 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_49336(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47692 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47692 = (function (ch,cs,meta47693){
this.ch = ch;
this.cs = cs;
this.meta47693 = meta47693;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47692.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47694,meta47693__$1){
var self__ = this;
var _47694__$1 = this;
return (new cljs.core.async.t_cljs$core$async47692(self__.ch,self__.cs,meta47693__$1));
}));

(cljs.core.async.t_cljs$core$async47692.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47694){
var self__ = this;
var _47694__$1 = this;
return self__.meta47693;
}));

(cljs.core.async.t_cljs$core$async47692.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47692.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async47692.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47692.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async47692.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async47692.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async47692.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47693","meta47693",253014309,null)], null);
}));

(cljs.core.async.t_cljs$core$async47692.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47692.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47692");

(cljs.core.async.t_cljs$core$async47692.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47692");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47692.
 */
cljs.core.async.__GT_t_cljs$core$async47692 = (function cljs$core$async$mult_$___GT_t_cljs$core$async47692(ch__$1,cs__$1,meta47693){
return (new cljs.core.async.t_cljs$core$async47692(ch__$1,cs__$1,meta47693));
});

}

return (new cljs.core.async.t_cljs$core$async47692(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__46897__auto___49356 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_47829){
var state_val_47830 = (state_47829[(1)]);
if((state_val_47830 === (7))){
var inst_47825 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47832_49360 = state_47829__$1;
(statearr_47832_49360[(2)] = inst_47825);

(statearr_47832_49360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (20))){
var inst_47728 = (state_47829[(7)]);
var inst_47740 = cljs.core.first(inst_47728);
var inst_47741 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47740,(0),null);
var inst_47742 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47740,(1),null);
var state_47829__$1 = (function (){var statearr_47834 = state_47829;
(statearr_47834[(8)] = inst_47741);

return statearr_47834;
})();
if(cljs.core.truth_(inst_47742)){
var statearr_47835_49367 = state_47829__$1;
(statearr_47835_49367[(1)] = (22));

} else {
var statearr_47836_49368 = state_47829__$1;
(statearr_47836_49368[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (27))){
var inst_47772 = (state_47829[(9)]);
var inst_47697 = (state_47829[(10)]);
var inst_47770 = (state_47829[(11)]);
var inst_47777 = (state_47829[(12)]);
var inst_47777__$1 = cljs.core._nth(inst_47770,inst_47772);
var inst_47778 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47777__$1,inst_47697,done);
var state_47829__$1 = (function (){var statearr_47844 = state_47829;
(statearr_47844[(12)] = inst_47777__$1);

return statearr_47844;
})();
if(cljs.core.truth_(inst_47778)){
var statearr_47845_49376 = state_47829__$1;
(statearr_47845_49376[(1)] = (30));

} else {
var statearr_47846_49377 = state_47829__$1;
(statearr_47846_49377[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (1))){
var state_47829__$1 = state_47829;
var statearr_47847_49378 = state_47829__$1;
(statearr_47847_49378[(2)] = null);

(statearr_47847_49378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (24))){
var inst_47728 = (state_47829[(7)]);
var inst_47747 = (state_47829[(2)]);
var inst_47748 = cljs.core.next(inst_47728);
var inst_47706 = inst_47748;
var inst_47707 = null;
var inst_47708 = (0);
var inst_47709 = (0);
var state_47829__$1 = (function (){var statearr_47848 = state_47829;
(statearr_47848[(13)] = inst_47747);

(statearr_47848[(14)] = inst_47706);

(statearr_47848[(15)] = inst_47709);

(statearr_47848[(16)] = inst_47707);

(statearr_47848[(17)] = inst_47708);

return statearr_47848;
})();
var statearr_47852_49381 = state_47829__$1;
(statearr_47852_49381[(2)] = null);

(statearr_47852_49381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (39))){
var state_47829__$1 = state_47829;
var statearr_47856_49383 = state_47829__$1;
(statearr_47856_49383[(2)] = null);

(statearr_47856_49383[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (4))){
var inst_47697 = (state_47829[(10)]);
var inst_47697__$1 = (state_47829[(2)]);
var inst_47698 = (inst_47697__$1 == null);
var state_47829__$1 = (function (){var statearr_47860 = state_47829;
(statearr_47860[(10)] = inst_47697__$1);

return statearr_47860;
})();
if(cljs.core.truth_(inst_47698)){
var statearr_47861_49384 = state_47829__$1;
(statearr_47861_49384[(1)] = (5));

} else {
var statearr_47862_49385 = state_47829__$1;
(statearr_47862_49385[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (15))){
var inst_47706 = (state_47829[(14)]);
var inst_47709 = (state_47829[(15)]);
var inst_47707 = (state_47829[(16)]);
var inst_47708 = (state_47829[(17)]);
var inst_47724 = (state_47829[(2)]);
var inst_47725 = (inst_47709 + (1));
var tmp47853 = inst_47706;
var tmp47854 = inst_47707;
var tmp47855 = inst_47708;
var inst_47706__$1 = tmp47853;
var inst_47707__$1 = tmp47854;
var inst_47708__$1 = tmp47855;
var inst_47709__$1 = inst_47725;
var state_47829__$1 = (function (){var statearr_47866 = state_47829;
(statearr_47866[(18)] = inst_47724);

(statearr_47866[(14)] = inst_47706__$1);

(statearr_47866[(15)] = inst_47709__$1);

(statearr_47866[(16)] = inst_47707__$1);

(statearr_47866[(17)] = inst_47708__$1);

return statearr_47866;
})();
var statearr_47867_49391 = state_47829__$1;
(statearr_47867_49391[(2)] = null);

(statearr_47867_49391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (21))){
var inst_47751 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47871_49393 = state_47829__$1;
(statearr_47871_49393[(2)] = inst_47751);

(statearr_47871_49393[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (31))){
var inst_47777 = (state_47829[(12)]);
var inst_47781 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47777);
var state_47829__$1 = state_47829;
var statearr_47872_49396 = state_47829__$1;
(statearr_47872_49396[(2)] = inst_47781);

(statearr_47872_49396[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (32))){
var inst_47772 = (state_47829[(9)]);
var inst_47769 = (state_47829[(19)]);
var inst_47771 = (state_47829[(20)]);
var inst_47770 = (state_47829[(11)]);
var inst_47783 = (state_47829[(2)]);
var inst_47784 = (inst_47772 + (1));
var tmp47868 = inst_47769;
var tmp47869 = inst_47771;
var tmp47870 = inst_47770;
var inst_47769__$1 = tmp47868;
var inst_47770__$1 = tmp47870;
var inst_47771__$1 = tmp47869;
var inst_47772__$1 = inst_47784;
var state_47829__$1 = (function (){var statearr_47873 = state_47829;
(statearr_47873[(21)] = inst_47783);

(statearr_47873[(9)] = inst_47772__$1);

(statearr_47873[(19)] = inst_47769__$1);

(statearr_47873[(20)] = inst_47771__$1);

(statearr_47873[(11)] = inst_47770__$1);

return statearr_47873;
})();
var statearr_47874_49397 = state_47829__$1;
(statearr_47874_49397[(2)] = null);

(statearr_47874_49397[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (40))){
var inst_47798 = (state_47829[(22)]);
var inst_47802 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47798);
var state_47829__$1 = state_47829;
var statearr_47875_49398 = state_47829__$1;
(statearr_47875_49398[(2)] = inst_47802);

(statearr_47875_49398[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (33))){
var inst_47787 = (state_47829[(23)]);
var inst_47790 = cljs.core.chunked_seq_QMARK_(inst_47787);
var state_47829__$1 = state_47829;
if(inst_47790){
var statearr_47878_49399 = state_47829__$1;
(statearr_47878_49399[(1)] = (36));

} else {
var statearr_47879_49400 = state_47829__$1;
(statearr_47879_49400[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (13))){
var inst_47718 = (state_47829[(24)]);
var inst_47721 = cljs.core.async.close_BANG_(inst_47718);
var state_47829__$1 = state_47829;
var statearr_47880_49404 = state_47829__$1;
(statearr_47880_49404[(2)] = inst_47721);

(statearr_47880_49404[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (22))){
var inst_47741 = (state_47829[(8)]);
var inst_47744 = cljs.core.async.close_BANG_(inst_47741);
var state_47829__$1 = state_47829;
var statearr_47881_49405 = state_47829__$1;
(statearr_47881_49405[(2)] = inst_47744);

(statearr_47881_49405[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (36))){
var inst_47787 = (state_47829[(23)]);
var inst_47792 = cljs.core.chunk_first(inst_47787);
var inst_47793 = cljs.core.chunk_rest(inst_47787);
var inst_47795 = cljs.core.count(inst_47792);
var inst_47769 = inst_47793;
var inst_47770 = inst_47792;
var inst_47771 = inst_47795;
var inst_47772 = (0);
var state_47829__$1 = (function (){var statearr_47885 = state_47829;
(statearr_47885[(9)] = inst_47772);

(statearr_47885[(19)] = inst_47769);

(statearr_47885[(20)] = inst_47771);

(statearr_47885[(11)] = inst_47770);

return statearr_47885;
})();
var statearr_47886_49413 = state_47829__$1;
(statearr_47886_49413[(2)] = null);

(statearr_47886_49413[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (41))){
var inst_47787 = (state_47829[(23)]);
var inst_47804 = (state_47829[(2)]);
var inst_47805 = cljs.core.next(inst_47787);
var inst_47769 = inst_47805;
var inst_47770 = null;
var inst_47771 = (0);
var inst_47772 = (0);
var state_47829__$1 = (function (){var statearr_47887 = state_47829;
(statearr_47887[(25)] = inst_47804);

(statearr_47887[(9)] = inst_47772);

(statearr_47887[(19)] = inst_47769);

(statearr_47887[(20)] = inst_47771);

(statearr_47887[(11)] = inst_47770);

return statearr_47887;
})();
var statearr_47888_49417 = state_47829__$1;
(statearr_47888_49417[(2)] = null);

(statearr_47888_49417[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (43))){
var state_47829__$1 = state_47829;
var statearr_47889_49422 = state_47829__$1;
(statearr_47889_49422[(2)] = null);

(statearr_47889_49422[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (29))){
var inst_47813 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47890_49428 = state_47829__$1;
(statearr_47890_49428[(2)] = inst_47813);

(statearr_47890_49428[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (44))){
var inst_47822 = (state_47829[(2)]);
var state_47829__$1 = (function (){var statearr_47891 = state_47829;
(statearr_47891[(26)] = inst_47822);

return statearr_47891;
})();
var statearr_47892_49429 = state_47829__$1;
(statearr_47892_49429[(2)] = null);

(statearr_47892_49429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (6))){
var inst_47761 = (state_47829[(27)]);
var inst_47760 = cljs.core.deref(cs);
var inst_47761__$1 = cljs.core.keys(inst_47760);
var inst_47762 = cljs.core.count(inst_47761__$1);
var inst_47763 = cljs.core.reset_BANG_(dctr,inst_47762);
var inst_47768 = cljs.core.seq(inst_47761__$1);
var inst_47769 = inst_47768;
var inst_47770 = null;
var inst_47771 = (0);
var inst_47772 = (0);
var state_47829__$1 = (function (){var statearr_47893 = state_47829;
(statearr_47893[(28)] = inst_47763);

(statearr_47893[(27)] = inst_47761__$1);

(statearr_47893[(9)] = inst_47772);

(statearr_47893[(19)] = inst_47769);

(statearr_47893[(20)] = inst_47771);

(statearr_47893[(11)] = inst_47770);

return statearr_47893;
})();
var statearr_47894_49431 = state_47829__$1;
(statearr_47894_49431[(2)] = null);

(statearr_47894_49431[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (28))){
var inst_47787 = (state_47829[(23)]);
var inst_47769 = (state_47829[(19)]);
var inst_47787__$1 = cljs.core.seq(inst_47769);
var state_47829__$1 = (function (){var statearr_47895 = state_47829;
(statearr_47895[(23)] = inst_47787__$1);

return statearr_47895;
})();
if(inst_47787__$1){
var statearr_47896_49432 = state_47829__$1;
(statearr_47896_49432[(1)] = (33));

} else {
var statearr_47897_49433 = state_47829__$1;
(statearr_47897_49433[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (25))){
var inst_47772 = (state_47829[(9)]);
var inst_47771 = (state_47829[(20)]);
var inst_47774 = (inst_47772 < inst_47771);
var inst_47775 = inst_47774;
var state_47829__$1 = state_47829;
if(cljs.core.truth_(inst_47775)){
var statearr_47898_49435 = state_47829__$1;
(statearr_47898_49435[(1)] = (27));

} else {
var statearr_47899_49436 = state_47829__$1;
(statearr_47899_49436[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (34))){
var state_47829__$1 = state_47829;
var statearr_47900_49437 = state_47829__$1;
(statearr_47900_49437[(2)] = null);

(statearr_47900_49437[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (17))){
var state_47829__$1 = state_47829;
var statearr_47901_49438 = state_47829__$1;
(statearr_47901_49438[(2)] = null);

(statearr_47901_49438[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (3))){
var inst_47827 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47829__$1,inst_47827);
} else {
if((state_val_47830 === (12))){
var inst_47756 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47902_49445 = state_47829__$1;
(statearr_47902_49445[(2)] = inst_47756);

(statearr_47902_49445[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (2))){
var state_47829__$1 = state_47829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47829__$1,(4),ch);
} else {
if((state_val_47830 === (23))){
var state_47829__$1 = state_47829;
var statearr_47903_49447 = state_47829__$1;
(statearr_47903_49447[(2)] = null);

(statearr_47903_49447[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (35))){
var inst_47811 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47904_49448 = state_47829__$1;
(statearr_47904_49448[(2)] = inst_47811);

(statearr_47904_49448[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (19))){
var inst_47728 = (state_47829[(7)]);
var inst_47732 = cljs.core.chunk_first(inst_47728);
var inst_47733 = cljs.core.chunk_rest(inst_47728);
var inst_47734 = cljs.core.count(inst_47732);
var inst_47706 = inst_47733;
var inst_47707 = inst_47732;
var inst_47708 = inst_47734;
var inst_47709 = (0);
var state_47829__$1 = (function (){var statearr_47905 = state_47829;
(statearr_47905[(14)] = inst_47706);

(statearr_47905[(15)] = inst_47709);

(statearr_47905[(16)] = inst_47707);

(statearr_47905[(17)] = inst_47708);

return statearr_47905;
})();
var statearr_47906_49449 = state_47829__$1;
(statearr_47906_49449[(2)] = null);

(statearr_47906_49449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (11))){
var inst_47706 = (state_47829[(14)]);
var inst_47728 = (state_47829[(7)]);
var inst_47728__$1 = cljs.core.seq(inst_47706);
var state_47829__$1 = (function (){var statearr_47907 = state_47829;
(statearr_47907[(7)] = inst_47728__$1);

return statearr_47907;
})();
if(inst_47728__$1){
var statearr_47908_49450 = state_47829__$1;
(statearr_47908_49450[(1)] = (16));

} else {
var statearr_47909_49451 = state_47829__$1;
(statearr_47909_49451[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (9))){
var inst_47758 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47910_49452 = state_47829__$1;
(statearr_47910_49452[(2)] = inst_47758);

(statearr_47910_49452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (5))){
var inst_47704 = cljs.core.deref(cs);
var inst_47705 = cljs.core.seq(inst_47704);
var inst_47706 = inst_47705;
var inst_47707 = null;
var inst_47708 = (0);
var inst_47709 = (0);
var state_47829__$1 = (function (){var statearr_47911 = state_47829;
(statearr_47911[(14)] = inst_47706);

(statearr_47911[(15)] = inst_47709);

(statearr_47911[(16)] = inst_47707);

(statearr_47911[(17)] = inst_47708);

return statearr_47911;
})();
var statearr_47912_49453 = state_47829__$1;
(statearr_47912_49453[(2)] = null);

(statearr_47912_49453[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (14))){
var state_47829__$1 = state_47829;
var statearr_47913_49454 = state_47829__$1;
(statearr_47913_49454[(2)] = null);

(statearr_47913_49454[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (45))){
var inst_47819 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47914_49455 = state_47829__$1;
(statearr_47914_49455[(2)] = inst_47819);

(statearr_47914_49455[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (26))){
var inst_47761 = (state_47829[(27)]);
var inst_47815 = (state_47829[(2)]);
var inst_47816 = cljs.core.seq(inst_47761);
var state_47829__$1 = (function (){var statearr_47915 = state_47829;
(statearr_47915[(29)] = inst_47815);

return statearr_47915;
})();
if(inst_47816){
var statearr_47916_49456 = state_47829__$1;
(statearr_47916_49456[(1)] = (42));

} else {
var statearr_47917_49457 = state_47829__$1;
(statearr_47917_49457[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (16))){
var inst_47728 = (state_47829[(7)]);
var inst_47730 = cljs.core.chunked_seq_QMARK_(inst_47728);
var state_47829__$1 = state_47829;
if(inst_47730){
var statearr_47918_49461 = state_47829__$1;
(statearr_47918_49461[(1)] = (19));

} else {
var statearr_47919_49462 = state_47829__$1;
(statearr_47919_49462[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (38))){
var inst_47808 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47920_49463 = state_47829__$1;
(statearr_47920_49463[(2)] = inst_47808);

(statearr_47920_49463[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (30))){
var state_47829__$1 = state_47829;
var statearr_47922_49464 = state_47829__$1;
(statearr_47922_49464[(2)] = null);

(statearr_47922_49464[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (10))){
var inst_47709 = (state_47829[(15)]);
var inst_47707 = (state_47829[(16)]);
var inst_47717 = cljs.core._nth(inst_47707,inst_47709);
var inst_47718 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47717,(0),null);
var inst_47719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47717,(1),null);
var state_47829__$1 = (function (){var statearr_47923 = state_47829;
(statearr_47923[(24)] = inst_47718);

return statearr_47923;
})();
if(cljs.core.truth_(inst_47719)){
var statearr_47924_49468 = state_47829__$1;
(statearr_47924_49468[(1)] = (13));

} else {
var statearr_47925_49469 = state_47829__$1;
(statearr_47925_49469[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (18))){
var inst_47754 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47926_49470 = state_47829__$1;
(statearr_47926_49470[(2)] = inst_47754);

(statearr_47926_49470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (42))){
var state_47829__$1 = state_47829;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47829__$1,(45),dchan);
} else {
if((state_val_47830 === (37))){
var inst_47787 = (state_47829[(23)]);
var inst_47697 = (state_47829[(10)]);
var inst_47798 = (state_47829[(22)]);
var inst_47798__$1 = cljs.core.first(inst_47787);
var inst_47799 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47798__$1,inst_47697,done);
var state_47829__$1 = (function (){var statearr_47927 = state_47829;
(statearr_47927[(22)] = inst_47798__$1);

return statearr_47927;
})();
if(cljs.core.truth_(inst_47799)){
var statearr_47928_49475 = state_47829__$1;
(statearr_47928_49475[(1)] = (39));

} else {
var statearr_47929_49476 = state_47829__$1;
(statearr_47929_49476[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47830 === (8))){
var inst_47709 = (state_47829[(15)]);
var inst_47708 = (state_47829[(17)]);
var inst_47711 = (inst_47709 < inst_47708);
var inst_47712 = inst_47711;
var state_47829__$1 = state_47829;
if(cljs.core.truth_(inst_47712)){
var statearr_47930_49477 = state_47829__$1;
(statearr_47930_49477[(1)] = (10));

} else {
var statearr_47931_49478 = state_47829__$1;
(statearr_47931_49478[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__46798__auto__ = null;
var cljs$core$async$mult_$_state_machine__46798__auto____0 = (function (){
var statearr_47942 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47942[(0)] = cljs$core$async$mult_$_state_machine__46798__auto__);

(statearr_47942[(1)] = (1));

return statearr_47942;
});
var cljs$core$async$mult_$_state_machine__46798__auto____1 = (function (state_47829){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_47829);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e47950){var ex__46801__auto__ = e47950;
var statearr_47953_49480 = state_47829;
(statearr_47953_49480[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_47829[(4)]))){
var statearr_47958_49481 = state_47829;
(statearr_47958_49481[(1)] = cljs.core.first((state_47829[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49482 = state_47829;
state_47829 = G__49482;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__46798__auto__ = function(state_47829){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__46798__auto____1.call(this,state_47829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__46798__auto____0;
cljs$core$async$mult_$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__46798__auto____1;
return cljs$core$async$mult_$_state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_47959 = f__46898__auto__();
(statearr_47959[(6)] = c__46897__auto___49356);

return statearr_47959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__47961 = arguments.length;
switch (G__47961) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_49491 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_49491(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_49496 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_49496(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_49503 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_49503(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_49508 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_49508(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_49512 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_49512(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___49518 = arguments.length;
var i__4737__auto___49519 = (0);
while(true){
if((i__4737__auto___49519 < len__4736__auto___49518)){
args__4742__auto__.push((arguments[i__4737__auto___49519]));

var G__49520 = (i__4737__auto___49519 + (1));
i__4737__auto___49519 = G__49520;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__48032){
var map__48033 = p__48032;
var map__48033__$1 = (((((!((map__48033 == null))))?(((((map__48033.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48033.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__48033):map__48033);
var opts = map__48033__$1;
var statearr_48035_49522 = state;
(statearr_48035_49522[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_48036_49523 = state;
(statearr_48036_49523[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_48037_49524 = state;
(statearr_48037_49524[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq48024){
var G__48025 = cljs.core.first(seq48024);
var seq48024__$1 = cljs.core.next(seq48024);
var G__48026 = cljs.core.first(seq48024__$1);
var seq48024__$2 = cljs.core.next(seq48024__$1);
var G__48027 = cljs.core.first(seq48024__$2);
var seq48024__$3 = cljs.core.next(seq48024__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48025,G__48026,G__48027,seq48024__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48039 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48039 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta48040){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta48040 = meta48040;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48041,meta48040__$1){
var self__ = this;
var _48041__$1 = this;
return (new cljs.core.async.t_cljs$core$async48039(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta48040__$1));
}));

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48041){
var self__ = this;
var _48041__$1 = this;
return self__.meta48040;
}));

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48039.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48039.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta48040","meta48040",-1053535648,null)], null);
}));

(cljs.core.async.t_cljs$core$async48039.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48039.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48039");

(cljs.core.async.t_cljs$core$async48039.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48039");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48039.
 */
cljs.core.async.__GT_t_cljs$core$async48039 = (function cljs$core$async$mix_$___GT_t_cljs$core$async48039(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta48040){
return (new cljs.core.async.t_cljs$core$async48039(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta48040));
});

}

return (new cljs.core.async.t_cljs$core$async48039(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46897__auto___49548 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48156){
var state_val_48157 = (state_48156[(1)]);
if((state_val_48157 === (7))){
var inst_48071 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
var statearr_48158_49549 = state_48156__$1;
(statearr_48158_49549[(2)] = inst_48071);

(statearr_48158_49549[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (20))){
var inst_48083 = (state_48156[(7)]);
var state_48156__$1 = state_48156;
var statearr_48159_49550 = state_48156__$1;
(statearr_48159_49550[(2)] = inst_48083);

(statearr_48159_49550[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (27))){
var state_48156__$1 = state_48156;
var statearr_48160_49555 = state_48156__$1;
(statearr_48160_49555[(2)] = null);

(statearr_48160_49555[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (1))){
var inst_48058 = (state_48156[(8)]);
var inst_48058__$1 = calc_state();
var inst_48060 = (inst_48058__$1 == null);
var inst_48061 = cljs.core.not(inst_48060);
var state_48156__$1 = (function (){var statearr_48161 = state_48156;
(statearr_48161[(8)] = inst_48058__$1);

return statearr_48161;
})();
if(inst_48061){
var statearr_48162_49556 = state_48156__$1;
(statearr_48162_49556[(1)] = (2));

} else {
var statearr_48163_49557 = state_48156__$1;
(statearr_48163_49557[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (24))){
var inst_48107 = (state_48156[(9)]);
var inst_48116 = (state_48156[(10)]);
var inst_48130 = (state_48156[(11)]);
var inst_48130__$1 = (inst_48107.cljs$core$IFn$_invoke$arity$1 ? inst_48107.cljs$core$IFn$_invoke$arity$1(inst_48116) : inst_48107.call(null,inst_48116));
var state_48156__$1 = (function (){var statearr_48164 = state_48156;
(statearr_48164[(11)] = inst_48130__$1);

return statearr_48164;
})();
if(cljs.core.truth_(inst_48130__$1)){
var statearr_48165_49564 = state_48156__$1;
(statearr_48165_49564[(1)] = (29));

} else {
var statearr_48166_49566 = state_48156__$1;
(statearr_48166_49566[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (4))){
var inst_48074 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
if(cljs.core.truth_(inst_48074)){
var statearr_48167_49567 = state_48156__$1;
(statearr_48167_49567[(1)] = (8));

} else {
var statearr_48168_49568 = state_48156__$1;
(statearr_48168_49568[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (15))){
var inst_48101 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
if(cljs.core.truth_(inst_48101)){
var statearr_48169_49573 = state_48156__$1;
(statearr_48169_49573[(1)] = (19));

} else {
var statearr_48170_49574 = state_48156__$1;
(statearr_48170_49574[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (21))){
var inst_48106 = (state_48156[(12)]);
var inst_48106__$1 = (state_48156[(2)]);
var inst_48107 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48106__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48108 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48106__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48109 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48106__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_48156__$1 = (function (){var statearr_48171 = state_48156;
(statearr_48171[(12)] = inst_48106__$1);

(statearr_48171[(9)] = inst_48107);

(statearr_48171[(13)] = inst_48108);

return statearr_48171;
})();
return cljs.core.async.ioc_alts_BANG_(state_48156__$1,(22),inst_48109);
} else {
if((state_val_48157 === (31))){
var inst_48138 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
if(cljs.core.truth_(inst_48138)){
var statearr_48172_49580 = state_48156__$1;
(statearr_48172_49580[(1)] = (32));

} else {
var statearr_48173_49581 = state_48156__$1;
(statearr_48173_49581[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (32))){
var inst_48115 = (state_48156[(14)]);
var state_48156__$1 = state_48156;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48156__$1,(35),out,inst_48115);
} else {
if((state_val_48157 === (33))){
var inst_48106 = (state_48156[(12)]);
var inst_48083 = inst_48106;
var state_48156__$1 = (function (){var statearr_48174 = state_48156;
(statearr_48174[(7)] = inst_48083);

return statearr_48174;
})();
var statearr_48175_49582 = state_48156__$1;
(statearr_48175_49582[(2)] = null);

(statearr_48175_49582[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (13))){
var inst_48083 = (state_48156[(7)]);
var inst_48090 = inst_48083.cljs$lang$protocol_mask$partition0$;
var inst_48091 = (inst_48090 & (64));
var inst_48092 = inst_48083.cljs$core$ISeq$;
var inst_48093 = (cljs.core.PROTOCOL_SENTINEL === inst_48092);
var inst_48094 = ((inst_48091) || (inst_48093));
var state_48156__$1 = state_48156;
if(cljs.core.truth_(inst_48094)){
var statearr_48176_49586 = state_48156__$1;
(statearr_48176_49586[(1)] = (16));

} else {
var statearr_48177_49587 = state_48156__$1;
(statearr_48177_49587[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (22))){
var inst_48115 = (state_48156[(14)]);
var inst_48116 = (state_48156[(10)]);
var inst_48114 = (state_48156[(2)]);
var inst_48115__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48114,(0),null);
var inst_48116__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48114,(1),null);
var inst_48117 = (inst_48115__$1 == null);
var inst_48118 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48116__$1,change);
var inst_48119 = ((inst_48117) || (inst_48118));
var state_48156__$1 = (function (){var statearr_48178 = state_48156;
(statearr_48178[(14)] = inst_48115__$1);

(statearr_48178[(10)] = inst_48116__$1);

return statearr_48178;
})();
if(cljs.core.truth_(inst_48119)){
var statearr_48179_49588 = state_48156__$1;
(statearr_48179_49588[(1)] = (23));

} else {
var statearr_48180_49589 = state_48156__$1;
(statearr_48180_49589[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (36))){
var inst_48106 = (state_48156[(12)]);
var inst_48083 = inst_48106;
var state_48156__$1 = (function (){var statearr_48181 = state_48156;
(statearr_48181[(7)] = inst_48083);

return statearr_48181;
})();
var statearr_48182_49590 = state_48156__$1;
(statearr_48182_49590[(2)] = null);

(statearr_48182_49590[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (29))){
var inst_48130 = (state_48156[(11)]);
var state_48156__$1 = state_48156;
var statearr_48183_49591 = state_48156__$1;
(statearr_48183_49591[(2)] = inst_48130);

(statearr_48183_49591[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (6))){
var state_48156__$1 = state_48156;
var statearr_48184_49592 = state_48156__$1;
(statearr_48184_49592[(2)] = false);

(statearr_48184_49592[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (28))){
var inst_48126 = (state_48156[(2)]);
var inst_48127 = calc_state();
var inst_48083 = inst_48127;
var state_48156__$1 = (function (){var statearr_48185 = state_48156;
(statearr_48185[(7)] = inst_48083);

(statearr_48185[(15)] = inst_48126);

return statearr_48185;
})();
var statearr_48186_49594 = state_48156__$1;
(statearr_48186_49594[(2)] = null);

(statearr_48186_49594[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (25))){
var inst_48152 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
var statearr_48187_49595 = state_48156__$1;
(statearr_48187_49595[(2)] = inst_48152);

(statearr_48187_49595[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (34))){
var inst_48150 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
var statearr_48188_49596 = state_48156__$1;
(statearr_48188_49596[(2)] = inst_48150);

(statearr_48188_49596[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (17))){
var state_48156__$1 = state_48156;
var statearr_48189_49597 = state_48156__$1;
(statearr_48189_49597[(2)] = false);

(statearr_48189_49597[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (3))){
var state_48156__$1 = state_48156;
var statearr_48190_49598 = state_48156__$1;
(statearr_48190_49598[(2)] = false);

(statearr_48190_49598[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (12))){
var inst_48154 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48156__$1,inst_48154);
} else {
if((state_val_48157 === (2))){
var inst_48058 = (state_48156[(8)]);
var inst_48063 = inst_48058.cljs$lang$protocol_mask$partition0$;
var inst_48064 = (inst_48063 & (64));
var inst_48065 = inst_48058.cljs$core$ISeq$;
var inst_48066 = (cljs.core.PROTOCOL_SENTINEL === inst_48065);
var inst_48067 = ((inst_48064) || (inst_48066));
var state_48156__$1 = state_48156;
if(cljs.core.truth_(inst_48067)){
var statearr_48191_49599 = state_48156__$1;
(statearr_48191_49599[(1)] = (5));

} else {
var statearr_48192_49600 = state_48156__$1;
(statearr_48192_49600[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (23))){
var inst_48115 = (state_48156[(14)]);
var inst_48121 = (inst_48115 == null);
var state_48156__$1 = state_48156;
if(cljs.core.truth_(inst_48121)){
var statearr_48193_49601 = state_48156__$1;
(statearr_48193_49601[(1)] = (26));

} else {
var statearr_48194_49602 = state_48156__$1;
(statearr_48194_49602[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (35))){
var inst_48141 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
if(cljs.core.truth_(inst_48141)){
var statearr_48195_49603 = state_48156__$1;
(statearr_48195_49603[(1)] = (36));

} else {
var statearr_48196_49604 = state_48156__$1;
(statearr_48196_49604[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (19))){
var inst_48083 = (state_48156[(7)]);
var inst_48103 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_48083);
var state_48156__$1 = state_48156;
var statearr_48197_49605 = state_48156__$1;
(statearr_48197_49605[(2)] = inst_48103);

(statearr_48197_49605[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (11))){
var inst_48083 = (state_48156[(7)]);
var inst_48087 = (inst_48083 == null);
var inst_48088 = cljs.core.not(inst_48087);
var state_48156__$1 = state_48156;
if(inst_48088){
var statearr_48198_49606 = state_48156__$1;
(statearr_48198_49606[(1)] = (13));

} else {
var statearr_48199_49610 = state_48156__$1;
(statearr_48199_49610[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (9))){
var inst_48058 = (state_48156[(8)]);
var state_48156__$1 = state_48156;
var statearr_48200_49611 = state_48156__$1;
(statearr_48200_49611[(2)] = inst_48058);

(statearr_48200_49611[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (5))){
var state_48156__$1 = state_48156;
var statearr_48201_49616 = state_48156__$1;
(statearr_48201_49616[(2)] = true);

(statearr_48201_49616[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (14))){
var state_48156__$1 = state_48156;
var statearr_48202_49620 = state_48156__$1;
(statearr_48202_49620[(2)] = false);

(statearr_48202_49620[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (26))){
var inst_48116 = (state_48156[(10)]);
var inst_48123 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_48116);
var state_48156__$1 = state_48156;
var statearr_48203_49621 = state_48156__$1;
(statearr_48203_49621[(2)] = inst_48123);

(statearr_48203_49621[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (16))){
var state_48156__$1 = state_48156;
var statearr_48204_49622 = state_48156__$1;
(statearr_48204_49622[(2)] = true);

(statearr_48204_49622[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (38))){
var inst_48146 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
var statearr_48205_49626 = state_48156__$1;
(statearr_48205_49626[(2)] = inst_48146);

(statearr_48205_49626[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (30))){
var inst_48107 = (state_48156[(9)]);
var inst_48108 = (state_48156[(13)]);
var inst_48116 = (state_48156[(10)]);
var inst_48133 = cljs.core.empty_QMARK_(inst_48107);
var inst_48134 = (inst_48108.cljs$core$IFn$_invoke$arity$1 ? inst_48108.cljs$core$IFn$_invoke$arity$1(inst_48116) : inst_48108.call(null,inst_48116));
var inst_48135 = cljs.core.not(inst_48134);
var inst_48136 = ((inst_48133) && (inst_48135));
var state_48156__$1 = state_48156;
var statearr_48206_49630 = state_48156__$1;
(statearr_48206_49630[(2)] = inst_48136);

(statearr_48206_49630[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (10))){
var inst_48058 = (state_48156[(8)]);
var inst_48079 = (state_48156[(2)]);
var inst_48080 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48079,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48081 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48079,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48082 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48079,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_48083 = inst_48058;
var state_48156__$1 = (function (){var statearr_48207 = state_48156;
(statearr_48207[(16)] = inst_48081);

(statearr_48207[(17)] = inst_48080);

(statearr_48207[(7)] = inst_48083);

(statearr_48207[(18)] = inst_48082);

return statearr_48207;
})();
var statearr_48208_49634 = state_48156__$1;
(statearr_48208_49634[(2)] = null);

(statearr_48208_49634[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (18))){
var inst_48098 = (state_48156[(2)]);
var state_48156__$1 = state_48156;
var statearr_48209_49635 = state_48156__$1;
(statearr_48209_49635[(2)] = inst_48098);

(statearr_48209_49635[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (37))){
var state_48156__$1 = state_48156;
var statearr_48210_49637 = state_48156__$1;
(statearr_48210_49637[(2)] = null);

(statearr_48210_49637[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48157 === (8))){
var inst_48058 = (state_48156[(8)]);
var inst_48076 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_48058);
var state_48156__$1 = state_48156;
var statearr_48211_49638 = state_48156__$1;
(statearr_48211_49638[(2)] = inst_48076);

(statearr_48211_49638[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__46798__auto__ = null;
var cljs$core$async$mix_$_state_machine__46798__auto____0 = (function (){
var statearr_48212 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48212[(0)] = cljs$core$async$mix_$_state_machine__46798__auto__);

(statearr_48212[(1)] = (1));

return statearr_48212;
});
var cljs$core$async$mix_$_state_machine__46798__auto____1 = (function (state_48156){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48156);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48213){var ex__46801__auto__ = e48213;
var statearr_48214_49648 = state_48156;
(statearr_48214_49648[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48156[(4)]))){
var statearr_48215_49649 = state_48156;
(statearr_48215_49649[(1)] = cljs.core.first((state_48156[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49656 = state_48156;
state_48156 = G__49656;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__46798__auto__ = function(state_48156){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__46798__auto____1.call(this,state_48156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__46798__auto____0;
cljs$core$async$mix_$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__46798__auto____1;
return cljs$core$async$mix_$_state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48216 = f__46898__auto__();
(statearr_48216[(6)] = c__46897__auto___49548);

return statearr_48216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_49657 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_49657(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_49658 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_49658(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_49665 = (function() {
var G__49666 = null;
var G__49666__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__49666__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__49666 = function(p,v){
switch(arguments.length){
case 1:
return G__49666__1.call(this,p);
case 2:
return G__49666__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__49666.cljs$core$IFn$_invoke$arity$1 = G__49666__1;
G__49666.cljs$core$IFn$_invoke$arity$2 = G__49666__2;
return G__49666;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__48218 = arguments.length;
switch (G__48218) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49665(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49665(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__48221 = arguments.length;
switch (G__48221) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__48219_SHARP_){
if(cljs.core.truth_((p1__48219_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__48219_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__48219_SHARP_.call(null,topic)))){
return p1__48219_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__48219_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48222 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48222 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta48223){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta48223 = meta48223;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48224,meta48223__$1){
var self__ = this;
var _48224__$1 = this;
return (new cljs.core.async.t_cljs$core$async48222(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta48223__$1));
}));

(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48224){
var self__ = this;
var _48224__$1 = this;
return self__.meta48223;
}));

(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async48222.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async48222.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta48223","meta48223",1374782427,null)], null);
}));

(cljs.core.async.t_cljs$core$async48222.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48222.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48222");

(cljs.core.async.t_cljs$core$async48222.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48222");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48222.
 */
cljs.core.async.__GT_t_cljs$core$async48222 = (function cljs$core$async$__GT_t_cljs$core$async48222(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48223){
return (new cljs.core.async.t_cljs$core$async48222(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48223));
});

}

return (new cljs.core.async.t_cljs$core$async48222(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__46897__auto___49681 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48296){
var state_val_48297 = (state_48296[(1)]);
if((state_val_48297 === (7))){
var inst_48292 = (state_48296[(2)]);
var state_48296__$1 = state_48296;
var statearr_48298_49682 = state_48296__$1;
(statearr_48298_49682[(2)] = inst_48292);

(statearr_48298_49682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (20))){
var state_48296__$1 = state_48296;
var statearr_48299_49683 = state_48296__$1;
(statearr_48299_49683[(2)] = null);

(statearr_48299_49683[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (1))){
var state_48296__$1 = state_48296;
var statearr_48300_49684 = state_48296__$1;
(statearr_48300_49684[(2)] = null);

(statearr_48300_49684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (24))){
var inst_48275 = (state_48296[(7)]);
var inst_48284 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_48275);
var state_48296__$1 = state_48296;
var statearr_48301_49685 = state_48296__$1;
(statearr_48301_49685[(2)] = inst_48284);

(statearr_48301_49685[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (4))){
var inst_48227 = (state_48296[(8)]);
var inst_48227__$1 = (state_48296[(2)]);
var inst_48228 = (inst_48227__$1 == null);
var state_48296__$1 = (function (){var statearr_48302 = state_48296;
(statearr_48302[(8)] = inst_48227__$1);

return statearr_48302;
})();
if(cljs.core.truth_(inst_48228)){
var statearr_48303_49689 = state_48296__$1;
(statearr_48303_49689[(1)] = (5));

} else {
var statearr_48304_49690 = state_48296__$1;
(statearr_48304_49690[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (15))){
var inst_48269 = (state_48296[(2)]);
var state_48296__$1 = state_48296;
var statearr_48305_49691 = state_48296__$1;
(statearr_48305_49691[(2)] = inst_48269);

(statearr_48305_49691[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (21))){
var inst_48289 = (state_48296[(2)]);
var state_48296__$1 = (function (){var statearr_48306 = state_48296;
(statearr_48306[(9)] = inst_48289);

return statearr_48306;
})();
var statearr_48307_49692 = state_48296__$1;
(statearr_48307_49692[(2)] = null);

(statearr_48307_49692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (13))){
var inst_48251 = (state_48296[(10)]);
var inst_48253 = cljs.core.chunked_seq_QMARK_(inst_48251);
var state_48296__$1 = state_48296;
if(inst_48253){
var statearr_48308_49695 = state_48296__$1;
(statearr_48308_49695[(1)] = (16));

} else {
var statearr_48309_49696 = state_48296__$1;
(statearr_48309_49696[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (22))){
var inst_48281 = (state_48296[(2)]);
var state_48296__$1 = state_48296;
if(cljs.core.truth_(inst_48281)){
var statearr_48310_49697 = state_48296__$1;
(statearr_48310_49697[(1)] = (23));

} else {
var statearr_48311_49698 = state_48296__$1;
(statearr_48311_49698[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (6))){
var inst_48227 = (state_48296[(8)]);
var inst_48275 = (state_48296[(7)]);
var inst_48277 = (state_48296[(11)]);
var inst_48275__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_48227) : topic_fn.call(null,inst_48227));
var inst_48276 = cljs.core.deref(mults);
var inst_48277__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48276,inst_48275__$1);
var state_48296__$1 = (function (){var statearr_48312 = state_48296;
(statearr_48312[(7)] = inst_48275__$1);

(statearr_48312[(11)] = inst_48277__$1);

return statearr_48312;
})();
if(cljs.core.truth_(inst_48277__$1)){
var statearr_48313_49699 = state_48296__$1;
(statearr_48313_49699[(1)] = (19));

} else {
var statearr_48314_49700 = state_48296__$1;
(statearr_48314_49700[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (25))){
var inst_48286 = (state_48296[(2)]);
var state_48296__$1 = state_48296;
var statearr_48315_49703 = state_48296__$1;
(statearr_48315_49703[(2)] = inst_48286);

(statearr_48315_49703[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (17))){
var inst_48251 = (state_48296[(10)]);
var inst_48260 = cljs.core.first(inst_48251);
var inst_48261 = cljs.core.async.muxch_STAR_(inst_48260);
var inst_48262 = cljs.core.async.close_BANG_(inst_48261);
var inst_48263 = cljs.core.next(inst_48251);
var inst_48237 = inst_48263;
var inst_48238 = null;
var inst_48239 = (0);
var inst_48240 = (0);
var state_48296__$1 = (function (){var statearr_48316 = state_48296;
(statearr_48316[(12)] = inst_48240);

(statearr_48316[(13)] = inst_48239);

(statearr_48316[(14)] = inst_48238);

(statearr_48316[(15)] = inst_48262);

(statearr_48316[(16)] = inst_48237);

return statearr_48316;
})();
var statearr_48317_49704 = state_48296__$1;
(statearr_48317_49704[(2)] = null);

(statearr_48317_49704[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (3))){
var inst_48294 = (state_48296[(2)]);
var state_48296__$1 = state_48296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48296__$1,inst_48294);
} else {
if((state_val_48297 === (12))){
var inst_48271 = (state_48296[(2)]);
var state_48296__$1 = state_48296;
var statearr_48321_49705 = state_48296__$1;
(statearr_48321_49705[(2)] = inst_48271);

(statearr_48321_49705[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (2))){
var state_48296__$1 = state_48296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48296__$1,(4),ch);
} else {
if((state_val_48297 === (23))){
var state_48296__$1 = state_48296;
var statearr_48322_49706 = state_48296__$1;
(statearr_48322_49706[(2)] = null);

(statearr_48322_49706[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (19))){
var inst_48227 = (state_48296[(8)]);
var inst_48277 = (state_48296[(11)]);
var inst_48279 = cljs.core.async.muxch_STAR_(inst_48277);
var state_48296__$1 = state_48296;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48296__$1,(22),inst_48279,inst_48227);
} else {
if((state_val_48297 === (11))){
var inst_48251 = (state_48296[(10)]);
var inst_48237 = (state_48296[(16)]);
var inst_48251__$1 = cljs.core.seq(inst_48237);
var state_48296__$1 = (function (){var statearr_48323 = state_48296;
(statearr_48323[(10)] = inst_48251__$1);

return statearr_48323;
})();
if(inst_48251__$1){
var statearr_48324_49713 = state_48296__$1;
(statearr_48324_49713[(1)] = (13));

} else {
var statearr_48325_49714 = state_48296__$1;
(statearr_48325_49714[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (9))){
var inst_48273 = (state_48296[(2)]);
var state_48296__$1 = state_48296;
var statearr_48326_49715 = state_48296__$1;
(statearr_48326_49715[(2)] = inst_48273);

(statearr_48326_49715[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (5))){
var inst_48234 = cljs.core.deref(mults);
var inst_48235 = cljs.core.vals(inst_48234);
var inst_48236 = cljs.core.seq(inst_48235);
var inst_48237 = inst_48236;
var inst_48238 = null;
var inst_48239 = (0);
var inst_48240 = (0);
var state_48296__$1 = (function (){var statearr_48328 = state_48296;
(statearr_48328[(12)] = inst_48240);

(statearr_48328[(13)] = inst_48239);

(statearr_48328[(14)] = inst_48238);

(statearr_48328[(16)] = inst_48237);

return statearr_48328;
})();
var statearr_48329_49718 = state_48296__$1;
(statearr_48329_49718[(2)] = null);

(statearr_48329_49718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (14))){
var state_48296__$1 = state_48296;
var statearr_48333_49720 = state_48296__$1;
(statearr_48333_49720[(2)] = null);

(statearr_48333_49720[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (16))){
var inst_48251 = (state_48296[(10)]);
var inst_48255 = cljs.core.chunk_first(inst_48251);
var inst_48256 = cljs.core.chunk_rest(inst_48251);
var inst_48257 = cljs.core.count(inst_48255);
var inst_48237 = inst_48256;
var inst_48238 = inst_48255;
var inst_48239 = inst_48257;
var inst_48240 = (0);
var state_48296__$1 = (function (){var statearr_48335 = state_48296;
(statearr_48335[(12)] = inst_48240);

(statearr_48335[(13)] = inst_48239);

(statearr_48335[(14)] = inst_48238);

(statearr_48335[(16)] = inst_48237);

return statearr_48335;
})();
var statearr_48336_49724 = state_48296__$1;
(statearr_48336_49724[(2)] = null);

(statearr_48336_49724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (10))){
var inst_48240 = (state_48296[(12)]);
var inst_48239 = (state_48296[(13)]);
var inst_48238 = (state_48296[(14)]);
var inst_48237 = (state_48296[(16)]);
var inst_48245 = cljs.core._nth(inst_48238,inst_48240);
var inst_48246 = cljs.core.async.muxch_STAR_(inst_48245);
var inst_48247 = cljs.core.async.close_BANG_(inst_48246);
var inst_48248 = (inst_48240 + (1));
var tmp48330 = inst_48239;
var tmp48331 = inst_48238;
var tmp48332 = inst_48237;
var inst_48237__$1 = tmp48332;
var inst_48238__$1 = tmp48331;
var inst_48239__$1 = tmp48330;
var inst_48240__$1 = inst_48248;
var state_48296__$1 = (function (){var statearr_48338 = state_48296;
(statearr_48338[(17)] = inst_48247);

(statearr_48338[(12)] = inst_48240__$1);

(statearr_48338[(13)] = inst_48239__$1);

(statearr_48338[(14)] = inst_48238__$1);

(statearr_48338[(16)] = inst_48237__$1);

return statearr_48338;
})();
var statearr_48339_49725 = state_48296__$1;
(statearr_48339_49725[(2)] = null);

(statearr_48339_49725[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (18))){
var inst_48266 = (state_48296[(2)]);
var state_48296__$1 = state_48296;
var statearr_48340_49726 = state_48296__$1;
(statearr_48340_49726[(2)] = inst_48266);

(statearr_48340_49726[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48297 === (8))){
var inst_48240 = (state_48296[(12)]);
var inst_48239 = (state_48296[(13)]);
var inst_48242 = (inst_48240 < inst_48239);
var inst_48243 = inst_48242;
var state_48296__$1 = state_48296;
if(cljs.core.truth_(inst_48243)){
var statearr_48342_49727 = state_48296__$1;
(statearr_48342_49727[(1)] = (10));

} else {
var statearr_48343_49728 = state_48296__$1;
(statearr_48343_49728[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_48344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48344[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_48344[(1)] = (1));

return statearr_48344;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_48296){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48296);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48345){var ex__46801__auto__ = e48345;
var statearr_48347_49730 = state_48296;
(statearr_48347_49730[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48296[(4)]))){
var statearr_48348_49731 = state_48296;
(statearr_48348_49731[(1)] = cljs.core.first((state_48296[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49732 = state_48296;
state_48296 = G__49732;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_48296){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_48296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48349 = f__46898__auto__();
(statearr_48349[(6)] = c__46897__auto___49681);

return statearr_48349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__48352 = arguments.length;
switch (G__48352) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__48354 = arguments.length;
switch (G__48354) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__48356 = arguments.length;
switch (G__48356) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__46897__auto___49737 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48399){
var state_val_48400 = (state_48399[(1)]);
if((state_val_48400 === (7))){
var state_48399__$1 = state_48399;
var statearr_48401_49738 = state_48399__$1;
(statearr_48401_49738[(2)] = null);

(statearr_48401_49738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (1))){
var state_48399__$1 = state_48399;
var statearr_48402_49739 = state_48399__$1;
(statearr_48402_49739[(2)] = null);

(statearr_48402_49739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (4))){
var inst_48359 = (state_48399[(7)]);
var inst_48360 = (state_48399[(8)]);
var inst_48362 = (inst_48360 < inst_48359);
var state_48399__$1 = state_48399;
if(cljs.core.truth_(inst_48362)){
var statearr_48403_49741 = state_48399__$1;
(statearr_48403_49741[(1)] = (6));

} else {
var statearr_48404_49742 = state_48399__$1;
(statearr_48404_49742[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (15))){
var inst_48385 = (state_48399[(9)]);
var inst_48390 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_48385);
var state_48399__$1 = state_48399;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48399__$1,(17),out,inst_48390);
} else {
if((state_val_48400 === (13))){
var inst_48385 = (state_48399[(9)]);
var inst_48385__$1 = (state_48399[(2)]);
var inst_48386 = cljs.core.some(cljs.core.nil_QMARK_,inst_48385__$1);
var state_48399__$1 = (function (){var statearr_48405 = state_48399;
(statearr_48405[(9)] = inst_48385__$1);

return statearr_48405;
})();
if(cljs.core.truth_(inst_48386)){
var statearr_48406_49743 = state_48399__$1;
(statearr_48406_49743[(1)] = (14));

} else {
var statearr_48407_49745 = state_48399__$1;
(statearr_48407_49745[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (6))){
var state_48399__$1 = state_48399;
var statearr_48408_49746 = state_48399__$1;
(statearr_48408_49746[(2)] = null);

(statearr_48408_49746[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (17))){
var inst_48392 = (state_48399[(2)]);
var state_48399__$1 = (function (){var statearr_48410 = state_48399;
(statearr_48410[(10)] = inst_48392);

return statearr_48410;
})();
var statearr_48411_49747 = state_48399__$1;
(statearr_48411_49747[(2)] = null);

(statearr_48411_49747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (3))){
var inst_48397 = (state_48399[(2)]);
var state_48399__$1 = state_48399;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48399__$1,inst_48397);
} else {
if((state_val_48400 === (12))){
var _ = (function (){var statearr_48412 = state_48399;
(statearr_48412[(4)] = cljs.core.rest((state_48399[(4)])));

return statearr_48412;
})();
var state_48399__$1 = state_48399;
var ex48409 = (state_48399__$1[(2)]);
var statearr_48413_49749 = state_48399__$1;
(statearr_48413_49749[(5)] = ex48409);


if((ex48409 instanceof Object)){
var statearr_48414_49751 = state_48399__$1;
(statearr_48414_49751[(1)] = (11));

(statearr_48414_49751[(5)] = null);

} else {
throw ex48409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (2))){
var inst_48358 = cljs.core.reset_BANG_(dctr,cnt);
var inst_48359 = cnt;
var inst_48360 = (0);
var state_48399__$1 = (function (){var statearr_48415 = state_48399;
(statearr_48415[(7)] = inst_48359);

(statearr_48415[(8)] = inst_48360);

(statearr_48415[(11)] = inst_48358);

return statearr_48415;
})();
var statearr_48416_49752 = state_48399__$1;
(statearr_48416_49752[(2)] = null);

(statearr_48416_49752[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (11))){
var inst_48364 = (state_48399[(2)]);
var inst_48365 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_48399__$1 = (function (){var statearr_48417 = state_48399;
(statearr_48417[(12)] = inst_48364);

return statearr_48417;
})();
var statearr_48418_49754 = state_48399__$1;
(statearr_48418_49754[(2)] = inst_48365);

(statearr_48418_49754[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (9))){
var inst_48360 = (state_48399[(8)]);
var _ = (function (){var statearr_48419 = state_48399;
(statearr_48419[(4)] = cljs.core.cons((12),(state_48399[(4)])));

return statearr_48419;
})();
var inst_48371 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_48360) : chs__$1.call(null,inst_48360));
var inst_48372 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_48360) : done.call(null,inst_48360));
var inst_48373 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_48371,inst_48372);
var ___$1 = (function (){var statearr_48420 = state_48399;
(statearr_48420[(4)] = cljs.core.rest((state_48399[(4)])));

return statearr_48420;
})();
var state_48399__$1 = state_48399;
var statearr_48421_49756 = state_48399__$1;
(statearr_48421_49756[(2)] = inst_48373);

(statearr_48421_49756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (5))){
var inst_48383 = (state_48399[(2)]);
var state_48399__$1 = (function (){var statearr_48422 = state_48399;
(statearr_48422[(13)] = inst_48383);

return statearr_48422;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48399__$1,(13),dchan);
} else {
if((state_val_48400 === (14))){
var inst_48388 = cljs.core.async.close_BANG_(out);
var state_48399__$1 = state_48399;
var statearr_48423_49759 = state_48399__$1;
(statearr_48423_49759[(2)] = inst_48388);

(statearr_48423_49759[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (16))){
var inst_48395 = (state_48399[(2)]);
var state_48399__$1 = state_48399;
var statearr_48424_49760 = state_48399__$1;
(statearr_48424_49760[(2)] = inst_48395);

(statearr_48424_49760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (10))){
var inst_48360 = (state_48399[(8)]);
var inst_48376 = (state_48399[(2)]);
var inst_48377 = (inst_48360 + (1));
var inst_48360__$1 = inst_48377;
var state_48399__$1 = (function (){var statearr_48425 = state_48399;
(statearr_48425[(8)] = inst_48360__$1);

(statearr_48425[(14)] = inst_48376);

return statearr_48425;
})();
var statearr_48426_49761 = state_48399__$1;
(statearr_48426_49761[(2)] = null);

(statearr_48426_49761[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48400 === (8))){
var inst_48381 = (state_48399[(2)]);
var state_48399__$1 = state_48399;
var statearr_48427_49763 = state_48399__$1;
(statearr_48427_49763[(2)] = inst_48381);

(statearr_48427_49763[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_48428 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48428[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_48428[(1)] = (1));

return statearr_48428;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_48399){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48399);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48429){var ex__46801__auto__ = e48429;
var statearr_48430_49773 = state_48399;
(statearr_48430_49773[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48399[(4)]))){
var statearr_48431_49778 = state_48399;
(statearr_48431_49778[(1)] = cljs.core.first((state_48399[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49780 = state_48399;
state_48399 = G__49780;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_48399){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_48399);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48432 = f__46898__auto__();
(statearr_48432[(6)] = c__46897__auto___49737);

return statearr_48432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__48435 = arguments.length;
switch (G__48435) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46897__auto___49785 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48467){
var state_val_48468 = (state_48467[(1)]);
if((state_val_48468 === (7))){
var inst_48446 = (state_48467[(7)]);
var inst_48447 = (state_48467[(8)]);
var inst_48446__$1 = (state_48467[(2)]);
var inst_48447__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48446__$1,(0),null);
var inst_48448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48446__$1,(1),null);
var inst_48449 = (inst_48447__$1 == null);
var state_48467__$1 = (function (){var statearr_48470 = state_48467;
(statearr_48470[(7)] = inst_48446__$1);

(statearr_48470[(9)] = inst_48448);

(statearr_48470[(8)] = inst_48447__$1);

return statearr_48470;
})();
if(cljs.core.truth_(inst_48449)){
var statearr_48471_49795 = state_48467__$1;
(statearr_48471_49795[(1)] = (8));

} else {
var statearr_48472_49796 = state_48467__$1;
(statearr_48472_49796[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (1))){
var inst_48436 = cljs.core.vec(chs);
var inst_48437 = inst_48436;
var state_48467__$1 = (function (){var statearr_48474 = state_48467;
(statearr_48474[(10)] = inst_48437);

return statearr_48474;
})();
var statearr_48475_49801 = state_48467__$1;
(statearr_48475_49801[(2)] = null);

(statearr_48475_49801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (4))){
var inst_48437 = (state_48467[(10)]);
var state_48467__$1 = state_48467;
return cljs.core.async.ioc_alts_BANG_(state_48467__$1,(7),inst_48437);
} else {
if((state_val_48468 === (6))){
var inst_48463 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
var statearr_48476_49802 = state_48467__$1;
(statearr_48476_49802[(2)] = inst_48463);

(statearr_48476_49802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (3))){
var inst_48465 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48467__$1,inst_48465);
} else {
if((state_val_48468 === (2))){
var inst_48437 = (state_48467[(10)]);
var inst_48439 = cljs.core.count(inst_48437);
var inst_48440 = (inst_48439 > (0));
var state_48467__$1 = state_48467;
if(cljs.core.truth_(inst_48440)){
var statearr_48478_49812 = state_48467__$1;
(statearr_48478_49812[(1)] = (4));

} else {
var statearr_48479_49813 = state_48467__$1;
(statearr_48479_49813[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (11))){
var inst_48437 = (state_48467[(10)]);
var inst_48456 = (state_48467[(2)]);
var tmp48477 = inst_48437;
var inst_48437__$1 = tmp48477;
var state_48467__$1 = (function (){var statearr_48480 = state_48467;
(statearr_48480[(10)] = inst_48437__$1);

(statearr_48480[(11)] = inst_48456);

return statearr_48480;
})();
var statearr_48481_49820 = state_48467__$1;
(statearr_48481_49820[(2)] = null);

(statearr_48481_49820[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (9))){
var inst_48447 = (state_48467[(8)]);
var state_48467__$1 = state_48467;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48467__$1,(11),out,inst_48447);
} else {
if((state_val_48468 === (5))){
var inst_48461 = cljs.core.async.close_BANG_(out);
var state_48467__$1 = state_48467;
var statearr_48482_49824 = state_48467__$1;
(statearr_48482_49824[(2)] = inst_48461);

(statearr_48482_49824[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (10))){
var inst_48459 = (state_48467[(2)]);
var state_48467__$1 = state_48467;
var statearr_48483_49825 = state_48467__$1;
(statearr_48483_49825[(2)] = inst_48459);

(statearr_48483_49825[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48468 === (8))){
var inst_48437 = (state_48467[(10)]);
var inst_48446 = (state_48467[(7)]);
var inst_48448 = (state_48467[(9)]);
var inst_48447 = (state_48467[(8)]);
var inst_48451 = (function (){var cs = inst_48437;
var vec__48442 = inst_48446;
var v = inst_48447;
var c = inst_48448;
return (function (p1__48433_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__48433_SHARP_);
});
})();
var inst_48452 = cljs.core.filterv(inst_48451,inst_48437);
var inst_48437__$1 = inst_48452;
var state_48467__$1 = (function (){var statearr_48484 = state_48467;
(statearr_48484[(10)] = inst_48437__$1);

return statearr_48484;
})();
var statearr_48485_49828 = state_48467__$1;
(statearr_48485_49828[(2)] = null);

(statearr_48485_49828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_48486 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48486[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_48486[(1)] = (1));

return statearr_48486;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_48467){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48467);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48487){var ex__46801__auto__ = e48487;
var statearr_48488_49832 = state_48467;
(statearr_48488_49832[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48467[(4)]))){
var statearr_48489_49833 = state_48467;
(statearr_48489_49833[(1)] = cljs.core.first((state_48467[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49834 = state_48467;
state_48467 = G__49834;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_48467){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_48467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48490 = f__46898__auto__();
(statearr_48490[(6)] = c__46897__auto___49785);

return statearr_48490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__48492 = arguments.length;
switch (G__48492) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46897__auto___49839 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48516){
var state_val_48517 = (state_48516[(1)]);
if((state_val_48517 === (7))){
var inst_48498 = (state_48516[(7)]);
var inst_48498__$1 = (state_48516[(2)]);
var inst_48499 = (inst_48498__$1 == null);
var inst_48500 = cljs.core.not(inst_48499);
var state_48516__$1 = (function (){var statearr_48518 = state_48516;
(statearr_48518[(7)] = inst_48498__$1);

return statearr_48518;
})();
if(inst_48500){
var statearr_48519_49840 = state_48516__$1;
(statearr_48519_49840[(1)] = (8));

} else {
var statearr_48520_49842 = state_48516__$1;
(statearr_48520_49842[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48517 === (1))){
var inst_48493 = (0);
var state_48516__$1 = (function (){var statearr_48521 = state_48516;
(statearr_48521[(8)] = inst_48493);

return statearr_48521;
})();
var statearr_48522_49843 = state_48516__$1;
(statearr_48522_49843[(2)] = null);

(statearr_48522_49843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48517 === (4))){
var state_48516__$1 = state_48516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48516__$1,(7),ch);
} else {
if((state_val_48517 === (6))){
var inst_48511 = (state_48516[(2)]);
var state_48516__$1 = state_48516;
var statearr_48524_49844 = state_48516__$1;
(statearr_48524_49844[(2)] = inst_48511);

(statearr_48524_49844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48517 === (3))){
var inst_48513 = (state_48516[(2)]);
var inst_48514 = cljs.core.async.close_BANG_(out);
var state_48516__$1 = (function (){var statearr_48525 = state_48516;
(statearr_48525[(9)] = inst_48513);

return statearr_48525;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48516__$1,inst_48514);
} else {
if((state_val_48517 === (2))){
var inst_48493 = (state_48516[(8)]);
var inst_48495 = (inst_48493 < n);
var state_48516__$1 = state_48516;
if(cljs.core.truth_(inst_48495)){
var statearr_48526_49848 = state_48516__$1;
(statearr_48526_49848[(1)] = (4));

} else {
var statearr_48527_49849 = state_48516__$1;
(statearr_48527_49849[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48517 === (11))){
var inst_48493 = (state_48516[(8)]);
var inst_48503 = (state_48516[(2)]);
var inst_48504 = (inst_48493 + (1));
var inst_48493__$1 = inst_48504;
var state_48516__$1 = (function (){var statearr_48528 = state_48516;
(statearr_48528[(8)] = inst_48493__$1);

(statearr_48528[(10)] = inst_48503);

return statearr_48528;
})();
var statearr_48529_49850 = state_48516__$1;
(statearr_48529_49850[(2)] = null);

(statearr_48529_49850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48517 === (9))){
var state_48516__$1 = state_48516;
var statearr_48530_49855 = state_48516__$1;
(statearr_48530_49855[(2)] = null);

(statearr_48530_49855[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48517 === (5))){
var state_48516__$1 = state_48516;
var statearr_48531_49862 = state_48516__$1;
(statearr_48531_49862[(2)] = null);

(statearr_48531_49862[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48517 === (10))){
var inst_48508 = (state_48516[(2)]);
var state_48516__$1 = state_48516;
var statearr_48532_49868 = state_48516__$1;
(statearr_48532_49868[(2)] = inst_48508);

(statearr_48532_49868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48517 === (8))){
var inst_48498 = (state_48516[(7)]);
var state_48516__$1 = state_48516;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48516__$1,(11),out,inst_48498);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_48533 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48533[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_48533[(1)] = (1));

return statearr_48533;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_48516){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48516);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48534){var ex__46801__auto__ = e48534;
var statearr_48535_49898 = state_48516;
(statearr_48535_49898[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48516[(4)]))){
var statearr_48536_49904 = state_48516;
(statearr_48536_49904[(1)] = cljs.core.first((state_48516[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49908 = state_48516;
state_48516 = G__49908;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_48516){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_48516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48537 = f__46898__auto__();
(statearr_48537[(6)] = c__46897__auto___49839);

return statearr_48537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48539 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48539 = (function (f,ch,meta48540){
this.f = f;
this.ch = ch;
this.meta48540 = meta48540;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48541,meta48540__$1){
var self__ = this;
var _48541__$1 = this;
return (new cljs.core.async.t_cljs$core$async48539(self__.f,self__.ch,meta48540__$1));
}));

(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48541){
var self__ = this;
var _48541__$1 = this;
return self__.meta48540;
}));

(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48542 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48542 = (function (f,ch,meta48540,_,fn1,meta48543){
this.f = f;
this.ch = ch;
this.meta48540 = meta48540;
this._ = _;
this.fn1 = fn1;
this.meta48543 = meta48543;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48542.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48544,meta48543__$1){
var self__ = this;
var _48544__$1 = this;
return (new cljs.core.async.t_cljs$core$async48542(self__.f,self__.ch,self__.meta48540,self__._,self__.fn1,meta48543__$1));
}));

(cljs.core.async.t_cljs$core$async48542.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48544){
var self__ = this;
var _48544__$1 = this;
return self__.meta48543;
}));

(cljs.core.async.t_cljs$core$async48542.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48542.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async48542.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async48542.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__48538_SHARP_){
var G__48545 = (((p1__48538_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__48538_SHARP_) : self__.f.call(null,p1__48538_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__48545) : f1.call(null,G__48545));
});
}));

(cljs.core.async.t_cljs$core$async48542.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48540","meta48540",2091704562,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48539","cljs.core.async/t_cljs$core$async48539",1767015039,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48543","meta48543",303005006,null)], null);
}));

(cljs.core.async.t_cljs$core$async48542.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48542.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48542");

(cljs.core.async.t_cljs$core$async48542.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48542");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48542.
 */
cljs.core.async.__GT_t_cljs$core$async48542 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48542(f__$1,ch__$1,meta48540__$1,___$2,fn1__$1,meta48543){
return (new cljs.core.async.t_cljs$core$async48542(f__$1,ch__$1,meta48540__$1,___$2,fn1__$1,meta48543));
});

}

return (new cljs.core.async.t_cljs$core$async48542(self__.f,self__.ch,self__.meta48540,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__48546 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__48546) : self__.f.call(null,G__48546));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48539.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async48539.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48540","meta48540",2091704562,null)], null);
}));

(cljs.core.async.t_cljs$core$async48539.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48539.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48539");

(cljs.core.async.t_cljs$core$async48539.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48539");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48539.
 */
cljs.core.async.__GT_t_cljs$core$async48539 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48539(f__$1,ch__$1,meta48540){
return (new cljs.core.async.t_cljs$core$async48539(f__$1,ch__$1,meta48540));
});

}

return (new cljs.core.async.t_cljs$core$async48539(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48547 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48547 = (function (f,ch,meta48548){
this.f = f;
this.ch = ch;
this.meta48548 = meta48548;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48547.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48549,meta48548__$1){
var self__ = this;
var _48549__$1 = this;
return (new cljs.core.async.t_cljs$core$async48547(self__.f,self__.ch,meta48548__$1));
}));

(cljs.core.async.t_cljs$core$async48547.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48549){
var self__ = this;
var _48549__$1 = this;
return self__.meta48548;
}));

(cljs.core.async.t_cljs$core$async48547.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48547.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48547.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48547.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48547.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48547.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async48547.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48548","meta48548",-190868844,null)], null);
}));

(cljs.core.async.t_cljs$core$async48547.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48547.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48547");

(cljs.core.async.t_cljs$core$async48547.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48547");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48547.
 */
cljs.core.async.__GT_t_cljs$core$async48547 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48547(f__$1,ch__$1,meta48548){
return (new cljs.core.async.t_cljs$core$async48547(f__$1,ch__$1,meta48548));
});

}

return (new cljs.core.async.t_cljs$core$async48547(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48550 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48550 = (function (p,ch,meta48551){
this.p = p;
this.ch = ch;
this.meta48551 = meta48551;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48552,meta48551__$1){
var self__ = this;
var _48552__$1 = this;
return (new cljs.core.async.t_cljs$core$async48550(self__.p,self__.ch,meta48551__$1));
}));

(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48552){
var self__ = this;
var _48552__$1 = this;
return self__.meta48551;
}));

(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48550.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async48550.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48551","meta48551",-2093008902,null)], null);
}));

(cljs.core.async.t_cljs$core$async48550.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48550.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48550");

(cljs.core.async.t_cljs$core$async48550.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48550");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48550.
 */
cljs.core.async.__GT_t_cljs$core$async48550 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48550(p__$1,ch__$1,meta48551){
return (new cljs.core.async.t_cljs$core$async48550(p__$1,ch__$1,meta48551));
});

}

return (new cljs.core.async.t_cljs$core$async48550(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__48555 = arguments.length;
switch (G__48555) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46897__auto___49995 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48576){
var state_val_48577 = (state_48576[(1)]);
if((state_val_48577 === (7))){
var inst_48572 = (state_48576[(2)]);
var state_48576__$1 = state_48576;
var statearr_48578_49996 = state_48576__$1;
(statearr_48578_49996[(2)] = inst_48572);

(statearr_48578_49996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48577 === (1))){
var state_48576__$1 = state_48576;
var statearr_48579_50001 = state_48576__$1;
(statearr_48579_50001[(2)] = null);

(statearr_48579_50001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48577 === (4))){
var inst_48558 = (state_48576[(7)]);
var inst_48558__$1 = (state_48576[(2)]);
var inst_48559 = (inst_48558__$1 == null);
var state_48576__$1 = (function (){var statearr_48580 = state_48576;
(statearr_48580[(7)] = inst_48558__$1);

return statearr_48580;
})();
if(cljs.core.truth_(inst_48559)){
var statearr_48581_50012 = state_48576__$1;
(statearr_48581_50012[(1)] = (5));

} else {
var statearr_48582_50014 = state_48576__$1;
(statearr_48582_50014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48577 === (6))){
var inst_48558 = (state_48576[(7)]);
var inst_48563 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_48558) : p.call(null,inst_48558));
var state_48576__$1 = state_48576;
if(cljs.core.truth_(inst_48563)){
var statearr_48583_50024 = state_48576__$1;
(statearr_48583_50024[(1)] = (8));

} else {
var statearr_48584_50026 = state_48576__$1;
(statearr_48584_50026[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48577 === (3))){
var inst_48574 = (state_48576[(2)]);
var state_48576__$1 = state_48576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48576__$1,inst_48574);
} else {
if((state_val_48577 === (2))){
var state_48576__$1 = state_48576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48576__$1,(4),ch);
} else {
if((state_val_48577 === (11))){
var inst_48566 = (state_48576[(2)]);
var state_48576__$1 = state_48576;
var statearr_48585_50031 = state_48576__$1;
(statearr_48585_50031[(2)] = inst_48566);

(statearr_48585_50031[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48577 === (9))){
var state_48576__$1 = state_48576;
var statearr_48586_50032 = state_48576__$1;
(statearr_48586_50032[(2)] = null);

(statearr_48586_50032[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48577 === (5))){
var inst_48561 = cljs.core.async.close_BANG_(out);
var state_48576__$1 = state_48576;
var statearr_48587_50033 = state_48576__$1;
(statearr_48587_50033[(2)] = inst_48561);

(statearr_48587_50033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48577 === (10))){
var inst_48569 = (state_48576[(2)]);
var state_48576__$1 = (function (){var statearr_48588 = state_48576;
(statearr_48588[(8)] = inst_48569);

return statearr_48588;
})();
var statearr_48589_50039 = state_48576__$1;
(statearr_48589_50039[(2)] = null);

(statearr_48589_50039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48577 === (8))){
var inst_48558 = (state_48576[(7)]);
var state_48576__$1 = state_48576;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48576__$1,(11),out,inst_48558);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_48590 = [null,null,null,null,null,null,null,null,null];
(statearr_48590[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_48590[(1)] = (1));

return statearr_48590;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_48576){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48576);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48591){var ex__46801__auto__ = e48591;
var statearr_48592_50043 = state_48576;
(statearr_48592_50043[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48576[(4)]))){
var statearr_48593_50044 = state_48576;
(statearr_48593_50044[(1)] = cljs.core.first((state_48576[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50052 = state_48576;
state_48576 = G__50052;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_48576){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_48576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48594 = f__46898__auto__();
(statearr_48594[(6)] = c__46897__auto___49995);

return statearr_48594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__48596 = arguments.length;
switch (G__48596) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__46897__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48658){
var state_val_48659 = (state_48658[(1)]);
if((state_val_48659 === (7))){
var inst_48654 = (state_48658[(2)]);
var state_48658__$1 = state_48658;
var statearr_48660_50066 = state_48658__$1;
(statearr_48660_50066[(2)] = inst_48654);

(statearr_48660_50066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (20))){
var inst_48624 = (state_48658[(7)]);
var inst_48635 = (state_48658[(2)]);
var inst_48636 = cljs.core.next(inst_48624);
var inst_48610 = inst_48636;
var inst_48611 = null;
var inst_48612 = (0);
var inst_48613 = (0);
var state_48658__$1 = (function (){var statearr_48661 = state_48658;
(statearr_48661[(8)] = inst_48611);

(statearr_48661[(9)] = inst_48610);

(statearr_48661[(10)] = inst_48613);

(statearr_48661[(11)] = inst_48612);

(statearr_48661[(12)] = inst_48635);

return statearr_48661;
})();
var statearr_48662_50067 = state_48658__$1;
(statearr_48662_50067[(2)] = null);

(statearr_48662_50067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (1))){
var state_48658__$1 = state_48658;
var statearr_48663_50071 = state_48658__$1;
(statearr_48663_50071[(2)] = null);

(statearr_48663_50071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (4))){
var inst_48599 = (state_48658[(13)]);
var inst_48599__$1 = (state_48658[(2)]);
var inst_48600 = (inst_48599__$1 == null);
var state_48658__$1 = (function (){var statearr_48664 = state_48658;
(statearr_48664[(13)] = inst_48599__$1);

return statearr_48664;
})();
if(cljs.core.truth_(inst_48600)){
var statearr_48665_50072 = state_48658__$1;
(statearr_48665_50072[(1)] = (5));

} else {
var statearr_48666_50073 = state_48658__$1;
(statearr_48666_50073[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (15))){
var state_48658__$1 = state_48658;
var statearr_48670_50074 = state_48658__$1;
(statearr_48670_50074[(2)] = null);

(statearr_48670_50074[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (21))){
var state_48658__$1 = state_48658;
var statearr_48671_50075 = state_48658__$1;
(statearr_48671_50075[(2)] = null);

(statearr_48671_50075[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (13))){
var inst_48611 = (state_48658[(8)]);
var inst_48610 = (state_48658[(9)]);
var inst_48613 = (state_48658[(10)]);
var inst_48612 = (state_48658[(11)]);
var inst_48620 = (state_48658[(2)]);
var inst_48621 = (inst_48613 + (1));
var tmp48667 = inst_48611;
var tmp48668 = inst_48610;
var tmp48669 = inst_48612;
var inst_48610__$1 = tmp48668;
var inst_48611__$1 = tmp48667;
var inst_48612__$1 = tmp48669;
var inst_48613__$1 = inst_48621;
var state_48658__$1 = (function (){var statearr_48674 = state_48658;
(statearr_48674[(14)] = inst_48620);

(statearr_48674[(8)] = inst_48611__$1);

(statearr_48674[(9)] = inst_48610__$1);

(statearr_48674[(10)] = inst_48613__$1);

(statearr_48674[(11)] = inst_48612__$1);

return statearr_48674;
})();
var statearr_48676_50080 = state_48658__$1;
(statearr_48676_50080[(2)] = null);

(statearr_48676_50080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (22))){
var state_48658__$1 = state_48658;
var statearr_48677_50081 = state_48658__$1;
(statearr_48677_50081[(2)] = null);

(statearr_48677_50081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (6))){
var inst_48599 = (state_48658[(13)]);
var inst_48608 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48599) : f.call(null,inst_48599));
var inst_48609 = cljs.core.seq(inst_48608);
var inst_48610 = inst_48609;
var inst_48611 = null;
var inst_48612 = (0);
var inst_48613 = (0);
var state_48658__$1 = (function (){var statearr_48678 = state_48658;
(statearr_48678[(8)] = inst_48611);

(statearr_48678[(9)] = inst_48610);

(statearr_48678[(10)] = inst_48613);

(statearr_48678[(11)] = inst_48612);

return statearr_48678;
})();
var statearr_48680_50082 = state_48658__$1;
(statearr_48680_50082[(2)] = null);

(statearr_48680_50082[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (17))){
var inst_48624 = (state_48658[(7)]);
var inst_48628 = cljs.core.chunk_first(inst_48624);
var inst_48629 = cljs.core.chunk_rest(inst_48624);
var inst_48630 = cljs.core.count(inst_48628);
var inst_48610 = inst_48629;
var inst_48611 = inst_48628;
var inst_48612 = inst_48630;
var inst_48613 = (0);
var state_48658__$1 = (function (){var statearr_48681 = state_48658;
(statearr_48681[(8)] = inst_48611);

(statearr_48681[(9)] = inst_48610);

(statearr_48681[(10)] = inst_48613);

(statearr_48681[(11)] = inst_48612);

return statearr_48681;
})();
var statearr_48682_50083 = state_48658__$1;
(statearr_48682_50083[(2)] = null);

(statearr_48682_50083[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (3))){
var inst_48656 = (state_48658[(2)]);
var state_48658__$1 = state_48658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48658__$1,inst_48656);
} else {
if((state_val_48659 === (12))){
var inst_48644 = (state_48658[(2)]);
var state_48658__$1 = state_48658;
var statearr_48685_50084 = state_48658__$1;
(statearr_48685_50084[(2)] = inst_48644);

(statearr_48685_50084[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (2))){
var state_48658__$1 = state_48658;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48658__$1,(4),in$);
} else {
if((state_val_48659 === (23))){
var inst_48652 = (state_48658[(2)]);
var state_48658__$1 = state_48658;
var statearr_48686_50090 = state_48658__$1;
(statearr_48686_50090[(2)] = inst_48652);

(statearr_48686_50090[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (19))){
var inst_48639 = (state_48658[(2)]);
var state_48658__$1 = state_48658;
var statearr_48687_50094 = state_48658__$1;
(statearr_48687_50094[(2)] = inst_48639);

(statearr_48687_50094[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (11))){
var inst_48610 = (state_48658[(9)]);
var inst_48624 = (state_48658[(7)]);
var inst_48624__$1 = cljs.core.seq(inst_48610);
var state_48658__$1 = (function (){var statearr_48689 = state_48658;
(statearr_48689[(7)] = inst_48624__$1);

return statearr_48689;
})();
if(inst_48624__$1){
var statearr_48691_50095 = state_48658__$1;
(statearr_48691_50095[(1)] = (14));

} else {
var statearr_48693_50096 = state_48658__$1;
(statearr_48693_50096[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (9))){
var inst_48646 = (state_48658[(2)]);
var inst_48647 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_48658__$1 = (function (){var statearr_48694 = state_48658;
(statearr_48694[(15)] = inst_48646);

return statearr_48694;
})();
if(cljs.core.truth_(inst_48647)){
var statearr_48695_50098 = state_48658__$1;
(statearr_48695_50098[(1)] = (21));

} else {
var statearr_48696_50099 = state_48658__$1;
(statearr_48696_50099[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (5))){
var inst_48602 = cljs.core.async.close_BANG_(out);
var state_48658__$1 = state_48658;
var statearr_48697_50105 = state_48658__$1;
(statearr_48697_50105[(2)] = inst_48602);

(statearr_48697_50105[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (14))){
var inst_48624 = (state_48658[(7)]);
var inst_48626 = cljs.core.chunked_seq_QMARK_(inst_48624);
var state_48658__$1 = state_48658;
if(inst_48626){
var statearr_48701_50108 = state_48658__$1;
(statearr_48701_50108[(1)] = (17));

} else {
var statearr_48702_50109 = state_48658__$1;
(statearr_48702_50109[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (16))){
var inst_48642 = (state_48658[(2)]);
var state_48658__$1 = state_48658;
var statearr_48703_50110 = state_48658__$1;
(statearr_48703_50110[(2)] = inst_48642);

(statearr_48703_50110[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48659 === (10))){
var inst_48611 = (state_48658[(8)]);
var inst_48613 = (state_48658[(10)]);
var inst_48618 = cljs.core._nth(inst_48611,inst_48613);
var state_48658__$1 = state_48658;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48658__$1,(13),out,inst_48618);
} else {
if((state_val_48659 === (18))){
var inst_48624 = (state_48658[(7)]);
var inst_48633 = cljs.core.first(inst_48624);
var state_48658__$1 = state_48658;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48658__$1,(20),out,inst_48633);
} else {
if((state_val_48659 === (8))){
var inst_48613 = (state_48658[(10)]);
var inst_48612 = (state_48658[(11)]);
var inst_48615 = (inst_48613 < inst_48612);
var inst_48616 = inst_48615;
var state_48658__$1 = state_48658;
if(cljs.core.truth_(inst_48616)){
var statearr_48707_50116 = state_48658__$1;
(statearr_48707_50116[(1)] = (10));

} else {
var statearr_48708_50117 = state_48658__$1;
(statearr_48708_50117[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__46798__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__46798__auto____0 = (function (){
var statearr_48717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48717[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__46798__auto__);

(statearr_48717[(1)] = (1));

return statearr_48717;
});
var cljs$core$async$mapcat_STAR__$_state_machine__46798__auto____1 = (function (state_48658){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48658);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48718){var ex__46801__auto__ = e48718;
var statearr_48719_50121 = state_48658;
(statearr_48719_50121[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48658[(4)]))){
var statearr_48720_50124 = state_48658;
(statearr_48720_50124[(1)] = cljs.core.first((state_48658[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50126 = state_48658;
state_48658 = G__50126;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__46798__auto__ = function(state_48658){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__46798__auto____1.call(this,state_48658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__46798__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__46798__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48721 = f__46898__auto__();
(statearr_48721[(6)] = c__46897__auto__);

return statearr_48721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));

return c__46897__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__48723 = arguments.length;
switch (G__48723) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__48728 = arguments.length;
switch (G__48728) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__48735 = arguments.length;
switch (G__48735) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46897__auto___50154 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48759){
var state_val_48760 = (state_48759[(1)]);
if((state_val_48760 === (7))){
var inst_48754 = (state_48759[(2)]);
var state_48759__$1 = state_48759;
var statearr_48761_50162 = state_48759__$1;
(statearr_48761_50162[(2)] = inst_48754);

(statearr_48761_50162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (1))){
var inst_48736 = null;
var state_48759__$1 = (function (){var statearr_48762 = state_48759;
(statearr_48762[(7)] = inst_48736);

return statearr_48762;
})();
var statearr_48763_50163 = state_48759__$1;
(statearr_48763_50163[(2)] = null);

(statearr_48763_50163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (4))){
var inst_48739 = (state_48759[(8)]);
var inst_48739__$1 = (state_48759[(2)]);
var inst_48740 = (inst_48739__$1 == null);
var inst_48741 = cljs.core.not(inst_48740);
var state_48759__$1 = (function (){var statearr_48767 = state_48759;
(statearr_48767[(8)] = inst_48739__$1);

return statearr_48767;
})();
if(inst_48741){
var statearr_48768_50164 = state_48759__$1;
(statearr_48768_50164[(1)] = (5));

} else {
var statearr_48769_50165 = state_48759__$1;
(statearr_48769_50165[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (6))){
var state_48759__$1 = state_48759;
var statearr_48770_50170 = state_48759__$1;
(statearr_48770_50170[(2)] = null);

(statearr_48770_50170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (3))){
var inst_48756 = (state_48759[(2)]);
var inst_48757 = cljs.core.async.close_BANG_(out);
var state_48759__$1 = (function (){var statearr_48771 = state_48759;
(statearr_48771[(9)] = inst_48756);

return statearr_48771;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48759__$1,inst_48757);
} else {
if((state_val_48760 === (2))){
var state_48759__$1 = state_48759;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48759__$1,(4),ch);
} else {
if((state_val_48760 === (11))){
var inst_48739 = (state_48759[(8)]);
var inst_48748 = (state_48759[(2)]);
var inst_48736 = inst_48739;
var state_48759__$1 = (function (){var statearr_48775 = state_48759;
(statearr_48775[(10)] = inst_48748);

(statearr_48775[(7)] = inst_48736);

return statearr_48775;
})();
var statearr_48776_50173 = state_48759__$1;
(statearr_48776_50173[(2)] = null);

(statearr_48776_50173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (9))){
var inst_48739 = (state_48759[(8)]);
var state_48759__$1 = state_48759;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48759__$1,(11),out,inst_48739);
} else {
if((state_val_48760 === (5))){
var inst_48739 = (state_48759[(8)]);
var inst_48736 = (state_48759[(7)]);
var inst_48743 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48739,inst_48736);
var state_48759__$1 = state_48759;
if(inst_48743){
var statearr_48778_50174 = state_48759__$1;
(statearr_48778_50174[(1)] = (8));

} else {
var statearr_48779_50175 = state_48759__$1;
(statearr_48779_50175[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (10))){
var inst_48751 = (state_48759[(2)]);
var state_48759__$1 = state_48759;
var statearr_48780_50176 = state_48759__$1;
(statearr_48780_50176[(2)] = inst_48751);

(statearr_48780_50176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48760 === (8))){
var inst_48736 = (state_48759[(7)]);
var tmp48777 = inst_48736;
var inst_48736__$1 = tmp48777;
var state_48759__$1 = (function (){var statearr_48786 = state_48759;
(statearr_48786[(7)] = inst_48736__$1);

return statearr_48786;
})();
var statearr_48787_50177 = state_48759__$1;
(statearr_48787_50177[(2)] = null);

(statearr_48787_50177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_48789 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48789[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_48789[(1)] = (1));

return statearr_48789;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_48759){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48759);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48790){var ex__46801__auto__ = e48790;
var statearr_48791_50183 = state_48759;
(statearr_48791_50183[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48759[(4)]))){
var statearr_48792_50184 = state_48759;
(statearr_48792_50184[(1)] = cljs.core.first((state_48759[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50185 = state_48759;
state_48759 = G__50185;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_48759){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_48759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48795 = f__46898__auto__();
(statearr_48795[(6)] = c__46897__auto___50154);

return statearr_48795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__48803 = arguments.length;
switch (G__48803) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46897__auto___50187 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48844){
var state_val_48845 = (state_48844[(1)]);
if((state_val_48845 === (7))){
var inst_48838 = (state_48844[(2)]);
var state_48844__$1 = state_48844;
var statearr_48846_50189 = state_48844__$1;
(statearr_48846_50189[(2)] = inst_48838);

(statearr_48846_50189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (1))){
var inst_48804 = (new Array(n));
var inst_48805 = inst_48804;
var inst_48806 = (0);
var state_48844__$1 = (function (){var statearr_48847 = state_48844;
(statearr_48847[(7)] = inst_48806);

(statearr_48847[(8)] = inst_48805);

return statearr_48847;
})();
var statearr_48850_50197 = state_48844__$1;
(statearr_48850_50197[(2)] = null);

(statearr_48850_50197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (4))){
var inst_48809 = (state_48844[(9)]);
var inst_48809__$1 = (state_48844[(2)]);
var inst_48810 = (inst_48809__$1 == null);
var inst_48811 = cljs.core.not(inst_48810);
var state_48844__$1 = (function (){var statearr_48852 = state_48844;
(statearr_48852[(9)] = inst_48809__$1);

return statearr_48852;
})();
if(inst_48811){
var statearr_48853_50210 = state_48844__$1;
(statearr_48853_50210[(1)] = (5));

} else {
var statearr_48854_50211 = state_48844__$1;
(statearr_48854_50211[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (15))){
var inst_48832 = (state_48844[(2)]);
var state_48844__$1 = state_48844;
var statearr_48855_50215 = state_48844__$1;
(statearr_48855_50215[(2)] = inst_48832);

(statearr_48855_50215[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (13))){
var state_48844__$1 = state_48844;
var statearr_48856_50216 = state_48844__$1;
(statearr_48856_50216[(2)] = null);

(statearr_48856_50216[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (6))){
var inst_48806 = (state_48844[(7)]);
var inst_48827 = (inst_48806 > (0));
var state_48844__$1 = state_48844;
if(cljs.core.truth_(inst_48827)){
var statearr_48861_50221 = state_48844__$1;
(statearr_48861_50221[(1)] = (12));

} else {
var statearr_48863_50222 = state_48844__$1;
(statearr_48863_50222[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (3))){
var inst_48840 = (state_48844[(2)]);
var state_48844__$1 = state_48844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48844__$1,inst_48840);
} else {
if((state_val_48845 === (12))){
var inst_48805 = (state_48844[(8)]);
var inst_48830 = cljs.core.vec(inst_48805);
var state_48844__$1 = state_48844;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48844__$1,(15),out,inst_48830);
} else {
if((state_val_48845 === (2))){
var state_48844__$1 = state_48844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48844__$1,(4),ch);
} else {
if((state_val_48845 === (11))){
var inst_48821 = (state_48844[(2)]);
var inst_48822 = (new Array(n));
var inst_48805 = inst_48822;
var inst_48806 = (0);
var state_48844__$1 = (function (){var statearr_48865 = state_48844;
(statearr_48865[(10)] = inst_48821);

(statearr_48865[(7)] = inst_48806);

(statearr_48865[(8)] = inst_48805);

return statearr_48865;
})();
var statearr_48866_50239 = state_48844__$1;
(statearr_48866_50239[(2)] = null);

(statearr_48866_50239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (9))){
var inst_48805 = (state_48844[(8)]);
var inst_48819 = cljs.core.vec(inst_48805);
var state_48844__$1 = state_48844;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48844__$1,(11),out,inst_48819);
} else {
if((state_val_48845 === (5))){
var inst_48814 = (state_48844[(11)]);
var inst_48806 = (state_48844[(7)]);
var inst_48809 = (state_48844[(9)]);
var inst_48805 = (state_48844[(8)]);
var inst_48813 = (inst_48805[inst_48806] = inst_48809);
var inst_48814__$1 = (inst_48806 + (1));
var inst_48815 = (inst_48814__$1 < n);
var state_48844__$1 = (function (){var statearr_48867 = state_48844;
(statearr_48867[(11)] = inst_48814__$1);

(statearr_48867[(12)] = inst_48813);

return statearr_48867;
})();
if(cljs.core.truth_(inst_48815)){
var statearr_48868_50272 = state_48844__$1;
(statearr_48868_50272[(1)] = (8));

} else {
var statearr_48869_50277 = state_48844__$1;
(statearr_48869_50277[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (14))){
var inst_48835 = (state_48844[(2)]);
var inst_48836 = cljs.core.async.close_BANG_(out);
var state_48844__$1 = (function (){var statearr_48877 = state_48844;
(statearr_48877[(13)] = inst_48835);

return statearr_48877;
})();
var statearr_48880_50289 = state_48844__$1;
(statearr_48880_50289[(2)] = inst_48836);

(statearr_48880_50289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (10))){
var inst_48825 = (state_48844[(2)]);
var state_48844__$1 = state_48844;
var statearr_48881_50292 = state_48844__$1;
(statearr_48881_50292[(2)] = inst_48825);

(statearr_48881_50292[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48845 === (8))){
var inst_48814 = (state_48844[(11)]);
var inst_48805 = (state_48844[(8)]);
var tmp48876 = inst_48805;
var inst_48805__$1 = tmp48876;
var inst_48806 = inst_48814;
var state_48844__$1 = (function (){var statearr_48882 = state_48844;
(statearr_48882[(7)] = inst_48806);

(statearr_48882[(8)] = inst_48805__$1);

return statearr_48882;
})();
var statearr_48883_50299 = state_48844__$1;
(statearr_48883_50299[(2)] = null);

(statearr_48883_50299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_48886 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48886[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_48886[(1)] = (1));

return statearr_48886;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_48844){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48844);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48887){var ex__46801__auto__ = e48887;
var statearr_48888_50321 = state_48844;
(statearr_48888_50321[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48844[(4)]))){
var statearr_48889_50323 = state_48844;
(statearr_48889_50323[(1)] = cljs.core.first((state_48844[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50332 = state_48844;
state_48844 = G__50332;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_48844){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_48844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48892 = f__46898__auto__();
(statearr_48892[(6)] = c__46897__auto___50187);

return statearr_48892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__48896 = arguments.length;
switch (G__48896) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__46897__auto___50344 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_48938){
var state_val_48939 = (state_48938[(1)]);
if((state_val_48939 === (7))){
var inst_48934 = (state_48938[(2)]);
var state_48938__$1 = state_48938;
var statearr_48941_50345 = state_48938__$1;
(statearr_48941_50345[(2)] = inst_48934);

(statearr_48941_50345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (1))){
var inst_48897 = [];
var inst_48898 = inst_48897;
var inst_48899 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_48938__$1 = (function (){var statearr_48942 = state_48938;
(statearr_48942[(7)] = inst_48899);

(statearr_48942[(8)] = inst_48898);

return statearr_48942;
})();
var statearr_48943_50349 = state_48938__$1;
(statearr_48943_50349[(2)] = null);

(statearr_48943_50349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (4))){
var inst_48902 = (state_48938[(9)]);
var inst_48902__$1 = (state_48938[(2)]);
var inst_48903 = (inst_48902__$1 == null);
var inst_48904 = cljs.core.not(inst_48903);
var state_48938__$1 = (function (){var statearr_48944 = state_48938;
(statearr_48944[(9)] = inst_48902__$1);

return statearr_48944;
})();
if(inst_48904){
var statearr_48947_50352 = state_48938__$1;
(statearr_48947_50352[(1)] = (5));

} else {
var statearr_48949_50353 = state_48938__$1;
(statearr_48949_50353[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (15))){
var inst_48928 = (state_48938[(2)]);
var state_48938__$1 = state_48938;
var statearr_48950_50355 = state_48938__$1;
(statearr_48950_50355[(2)] = inst_48928);

(statearr_48950_50355[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (13))){
var state_48938__$1 = state_48938;
var statearr_48951_50356 = state_48938__$1;
(statearr_48951_50356[(2)] = null);

(statearr_48951_50356[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (6))){
var inst_48898 = (state_48938[(8)]);
var inst_48923 = inst_48898.length;
var inst_48924 = (inst_48923 > (0));
var state_48938__$1 = state_48938;
if(cljs.core.truth_(inst_48924)){
var statearr_48952_50357 = state_48938__$1;
(statearr_48952_50357[(1)] = (12));

} else {
var statearr_48953_50358 = state_48938__$1;
(statearr_48953_50358[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (3))){
var inst_48936 = (state_48938[(2)]);
var state_48938__$1 = state_48938;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48938__$1,inst_48936);
} else {
if((state_val_48939 === (12))){
var inst_48898 = (state_48938[(8)]);
var inst_48926 = cljs.core.vec(inst_48898);
var state_48938__$1 = state_48938;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48938__$1,(15),out,inst_48926);
} else {
if((state_val_48939 === (2))){
var state_48938__$1 = state_48938;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48938__$1,(4),ch);
} else {
if((state_val_48939 === (11))){
var inst_48902 = (state_48938[(9)]);
var inst_48906 = (state_48938[(10)]);
var inst_48916 = (state_48938[(2)]);
var inst_48917 = [];
var inst_48918 = inst_48917.push(inst_48902);
var inst_48898 = inst_48917;
var inst_48899 = inst_48906;
var state_48938__$1 = (function (){var statearr_48966 = state_48938;
(statearr_48966[(7)] = inst_48899);

(statearr_48966[(11)] = inst_48916);

(statearr_48966[(12)] = inst_48918);

(statearr_48966[(8)] = inst_48898);

return statearr_48966;
})();
var statearr_48975_50366 = state_48938__$1;
(statearr_48975_50366[(2)] = null);

(statearr_48975_50366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (9))){
var inst_48898 = (state_48938[(8)]);
var inst_48914 = cljs.core.vec(inst_48898);
var state_48938__$1 = state_48938;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48938__$1,(11),out,inst_48914);
} else {
if((state_val_48939 === (5))){
var inst_48902 = (state_48938[(9)]);
var inst_48906 = (state_48938[(10)]);
var inst_48899 = (state_48938[(7)]);
var inst_48906__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48902) : f.call(null,inst_48902));
var inst_48907 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48906__$1,inst_48899);
var inst_48908 = cljs.core.keyword_identical_QMARK_(inst_48899,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_48909 = ((inst_48907) || (inst_48908));
var state_48938__$1 = (function (){var statearr_48976 = state_48938;
(statearr_48976[(10)] = inst_48906__$1);

return statearr_48976;
})();
if(cljs.core.truth_(inst_48909)){
var statearr_48977_50370 = state_48938__$1;
(statearr_48977_50370[(1)] = (8));

} else {
var statearr_48978_50371 = state_48938__$1;
(statearr_48978_50371[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (14))){
var inst_48931 = (state_48938[(2)]);
var inst_48932 = cljs.core.async.close_BANG_(out);
var state_48938__$1 = (function (){var statearr_48980 = state_48938;
(statearr_48980[(13)] = inst_48931);

return statearr_48980;
})();
var statearr_48981_50372 = state_48938__$1;
(statearr_48981_50372[(2)] = inst_48932);

(statearr_48981_50372[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (10))){
var inst_48921 = (state_48938[(2)]);
var state_48938__$1 = state_48938;
var statearr_48982_50373 = state_48938__$1;
(statearr_48982_50373[(2)] = inst_48921);

(statearr_48982_50373[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48939 === (8))){
var inst_48902 = (state_48938[(9)]);
var inst_48906 = (state_48938[(10)]);
var inst_48898 = (state_48938[(8)]);
var inst_48911 = inst_48898.push(inst_48902);
var tmp48979 = inst_48898;
var inst_48898__$1 = tmp48979;
var inst_48899 = inst_48906;
var state_48938__$1 = (function (){var statearr_48983 = state_48938;
(statearr_48983[(14)] = inst_48911);

(statearr_48983[(7)] = inst_48899);

(statearr_48983[(8)] = inst_48898__$1);

return statearr_48983;
})();
var statearr_48984_50374 = state_48938__$1;
(statearr_48984_50374[(2)] = null);

(statearr_48984_50374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46798__auto__ = null;
var cljs$core$async$state_machine__46798__auto____0 = (function (){
var statearr_48985 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48985[(0)] = cljs$core$async$state_machine__46798__auto__);

(statearr_48985[(1)] = (1));

return statearr_48985;
});
var cljs$core$async$state_machine__46798__auto____1 = (function (state_48938){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_48938);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e48986){var ex__46801__auto__ = e48986;
var statearr_48987_50376 = state_48938;
(statearr_48987_50376[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_48938[(4)]))){
var statearr_48988_50377 = state_48938;
(statearr_48988_50377[(1)] = cljs.core.first((state_48938[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50379 = state_48938;
state_48938 = G__50379;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
cljs$core$async$state_machine__46798__auto__ = function(state_48938){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46798__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46798__auto____1.call(this,state_48938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46798__auto____0;
cljs$core$async$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46798__auto____1;
return cljs$core$async$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_48989 = f__46898__auto__();
(statearr_48989[(6)] = c__46897__auto___50344);

return statearr_48989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
