goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_49729 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_49729(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_49733 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_49733(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__49010 = coll;
var G__49011 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__49010,G__49011) : shadow.dom.lazy_native_coll_seq.call(null,G__49010,G__49011));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__49018 = arguments.length;
switch (G__49018) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__49021 = arguments.length;
switch (G__49021) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__49030 = arguments.length;
switch (G__49030) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__49048 = arguments.length;
switch (G__49048) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__49050 = arguments.length;
switch (G__49050) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__49053 = arguments.length;
switch (G__49053) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e49057){if((e49057 instanceof Object)){
var e = e49057;
return console.log("didnt support attachEvent",el,e);
} else {
throw e49057;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__49065 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__49066 = null;
var count__49067 = (0);
var i__49068 = (0);
while(true){
if((i__49068 < count__49067)){
var el = chunk__49066.cljs$core$IIndexed$_nth$arity$2(null,i__49068);
var handler_49762__$1 = ((function (seq__49065,chunk__49066,count__49067,i__49068,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__49065,chunk__49066,count__49067,i__49068,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49762__$1);


var G__49764 = seq__49065;
var G__49765 = chunk__49066;
var G__49766 = count__49067;
var G__49767 = (i__49068 + (1));
seq__49065 = G__49764;
chunk__49066 = G__49765;
count__49067 = G__49766;
i__49068 = G__49767;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__49065);
if(temp__5735__auto__){
var seq__49065__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49065__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__49065__$1);
var G__49768 = cljs.core.chunk_rest(seq__49065__$1);
var G__49769 = c__4556__auto__;
var G__49770 = cljs.core.count(c__4556__auto__);
var G__49771 = (0);
seq__49065 = G__49768;
chunk__49066 = G__49769;
count__49067 = G__49770;
i__49068 = G__49771;
continue;
} else {
var el = cljs.core.first(seq__49065__$1);
var handler_49772__$1 = ((function (seq__49065,chunk__49066,count__49067,i__49068,el,seq__49065__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__49065,chunk__49066,count__49067,i__49068,el,seq__49065__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49772__$1);


var G__49774 = cljs.core.next(seq__49065__$1);
var G__49775 = null;
var G__49776 = (0);
var G__49777 = (0);
seq__49065 = G__49774;
chunk__49066 = G__49775;
count__49067 = G__49776;
i__49068 = G__49777;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__49082 = arguments.length;
switch (G__49082) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__49087 = cljs.core.seq(events);
var chunk__49088 = null;
var count__49089 = (0);
var i__49090 = (0);
while(true){
if((i__49090 < count__49089)){
var vec__49107 = chunk__49088.cljs$core$IIndexed$_nth$arity$2(null,i__49090);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49107,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49107,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49787 = seq__49087;
var G__49788 = chunk__49088;
var G__49789 = count__49089;
var G__49790 = (i__49090 + (1));
seq__49087 = G__49787;
chunk__49088 = G__49788;
count__49089 = G__49789;
i__49090 = G__49790;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__49087);
if(temp__5735__auto__){
var seq__49087__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49087__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__49087__$1);
var G__49791 = cljs.core.chunk_rest(seq__49087__$1);
var G__49792 = c__4556__auto__;
var G__49793 = cljs.core.count(c__4556__auto__);
var G__49794 = (0);
seq__49087 = G__49791;
chunk__49088 = G__49792;
count__49089 = G__49793;
i__49090 = G__49794;
continue;
} else {
var vec__49112 = cljs.core.first(seq__49087__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49112,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49112,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49797 = cljs.core.next(seq__49087__$1);
var G__49798 = null;
var G__49799 = (0);
var G__49800 = (0);
seq__49087 = G__49797;
chunk__49088 = G__49798;
count__49089 = G__49799;
i__49090 = G__49800;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__49117 = cljs.core.seq(styles);
var chunk__49118 = null;
var count__49119 = (0);
var i__49120 = (0);
while(true){
if((i__49120 < count__49119)){
var vec__49130 = chunk__49118.cljs$core$IIndexed$_nth$arity$2(null,i__49120);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49130,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49130,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49804 = seq__49117;
var G__49805 = chunk__49118;
var G__49806 = count__49119;
var G__49807 = (i__49120 + (1));
seq__49117 = G__49804;
chunk__49118 = G__49805;
count__49119 = G__49806;
i__49120 = G__49807;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__49117);
if(temp__5735__auto__){
var seq__49117__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49117__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__49117__$1);
var G__49808 = cljs.core.chunk_rest(seq__49117__$1);
var G__49809 = c__4556__auto__;
var G__49810 = cljs.core.count(c__4556__auto__);
var G__49811 = (0);
seq__49117 = G__49808;
chunk__49118 = G__49809;
count__49119 = G__49810;
i__49120 = G__49811;
continue;
} else {
var vec__49138 = cljs.core.first(seq__49117__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49138,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49138,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49815 = cljs.core.next(seq__49117__$1);
var G__49816 = null;
var G__49817 = (0);
var G__49818 = (0);
seq__49117 = G__49815;
chunk__49118 = G__49816;
count__49119 = G__49817;
i__49120 = G__49818;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__49144_49821 = key;
var G__49144_49822__$1 = (((G__49144_49821 instanceof cljs.core.Keyword))?G__49144_49821.fqn:null);
switch (G__49144_49822__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49827 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_49827,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_49827,"aria-");
}
})())){
el.setAttribute(ks_49827,value);
} else {
(el[ks_49827] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__49160){
var map__49161 = p__49160;
var map__49161__$1 = (((((!((map__49161 == null))))?(((((map__49161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49161.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49161):map__49161);
var props = map__49161__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49161__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__49165 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49165,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49165,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49165,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__49170 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__49170,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__49170;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__49174 = arguments.length;
switch (G__49174) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__49183){
var vec__49185 = p__49183;
var seq__49186 = cljs.core.seq(vec__49185);
var first__49187 = cljs.core.first(seq__49186);
var seq__49186__$1 = cljs.core.next(seq__49186);
var nn = first__49187;
var first__49187__$1 = cljs.core.first(seq__49186__$1);
var seq__49186__$2 = cljs.core.next(seq__49186__$1);
var np = first__49187__$1;
var nc = seq__49186__$2;
var node = vec__49185;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49190 = nn;
var G__49191 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49190,G__49191) : create_fn.call(null,G__49190,G__49191));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49192 = nn;
var G__49193 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49192,G__49193) : create_fn.call(null,G__49192,G__49193));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__49196 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49196,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49196,(1),null);
var seq__49200_49851 = cljs.core.seq(node_children);
var chunk__49201_49852 = null;
var count__49202_49853 = (0);
var i__49203_49854 = (0);
while(true){
if((i__49203_49854 < count__49202_49853)){
var child_struct_49860 = chunk__49201_49852.cljs$core$IIndexed$_nth$arity$2(null,i__49203_49854);
var children_49861 = shadow.dom.dom_node(child_struct_49860);
if(cljs.core.seq_QMARK_(children_49861)){
var seq__49237_49863 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49861));
var chunk__49239_49864 = null;
var count__49240_49865 = (0);
var i__49241_49866 = (0);
while(true){
if((i__49241_49866 < count__49240_49865)){
var child_49867 = chunk__49239_49864.cljs$core$IIndexed$_nth$arity$2(null,i__49241_49866);
if(cljs.core.truth_(child_49867)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49867);


var G__49869 = seq__49237_49863;
var G__49870 = chunk__49239_49864;
var G__49871 = count__49240_49865;
var G__49872 = (i__49241_49866 + (1));
seq__49237_49863 = G__49869;
chunk__49239_49864 = G__49870;
count__49240_49865 = G__49871;
i__49241_49866 = G__49872;
continue;
} else {
var G__49873 = seq__49237_49863;
var G__49874 = chunk__49239_49864;
var G__49875 = count__49240_49865;
var G__49876 = (i__49241_49866 + (1));
seq__49237_49863 = G__49873;
chunk__49239_49864 = G__49874;
count__49240_49865 = G__49875;
i__49241_49866 = G__49876;
continue;
}
} else {
var temp__5735__auto___49877 = cljs.core.seq(seq__49237_49863);
if(temp__5735__auto___49877){
var seq__49237_49878__$1 = temp__5735__auto___49877;
if(cljs.core.chunked_seq_QMARK_(seq__49237_49878__$1)){
var c__4556__auto___49879 = cljs.core.chunk_first(seq__49237_49878__$1);
var G__49880 = cljs.core.chunk_rest(seq__49237_49878__$1);
var G__49881 = c__4556__auto___49879;
var G__49882 = cljs.core.count(c__4556__auto___49879);
var G__49883 = (0);
seq__49237_49863 = G__49880;
chunk__49239_49864 = G__49881;
count__49240_49865 = G__49882;
i__49241_49866 = G__49883;
continue;
} else {
var child_49884 = cljs.core.first(seq__49237_49878__$1);
if(cljs.core.truth_(child_49884)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49884);


var G__49885 = cljs.core.next(seq__49237_49878__$1);
var G__49886 = null;
var G__49887 = (0);
var G__49888 = (0);
seq__49237_49863 = G__49885;
chunk__49239_49864 = G__49886;
count__49240_49865 = G__49887;
i__49241_49866 = G__49888;
continue;
} else {
var G__49889 = cljs.core.next(seq__49237_49878__$1);
var G__49890 = null;
var G__49891 = (0);
var G__49892 = (0);
seq__49237_49863 = G__49889;
chunk__49239_49864 = G__49890;
count__49240_49865 = G__49891;
i__49241_49866 = G__49892;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49861);
}


var G__49893 = seq__49200_49851;
var G__49894 = chunk__49201_49852;
var G__49895 = count__49202_49853;
var G__49896 = (i__49203_49854 + (1));
seq__49200_49851 = G__49893;
chunk__49201_49852 = G__49894;
count__49202_49853 = G__49895;
i__49203_49854 = G__49896;
continue;
} else {
var temp__5735__auto___49897 = cljs.core.seq(seq__49200_49851);
if(temp__5735__auto___49897){
var seq__49200_49899__$1 = temp__5735__auto___49897;
if(cljs.core.chunked_seq_QMARK_(seq__49200_49899__$1)){
var c__4556__auto___49900 = cljs.core.chunk_first(seq__49200_49899__$1);
var G__49901 = cljs.core.chunk_rest(seq__49200_49899__$1);
var G__49902 = c__4556__auto___49900;
var G__49903 = cljs.core.count(c__4556__auto___49900);
var G__49905 = (0);
seq__49200_49851 = G__49901;
chunk__49201_49852 = G__49902;
count__49202_49853 = G__49903;
i__49203_49854 = G__49905;
continue;
} else {
var child_struct_49906 = cljs.core.first(seq__49200_49899__$1);
var children_49907 = shadow.dom.dom_node(child_struct_49906);
if(cljs.core.seq_QMARK_(children_49907)){
var seq__49253_49909 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49907));
var chunk__49255_49910 = null;
var count__49256_49911 = (0);
var i__49257_49912 = (0);
while(true){
if((i__49257_49912 < count__49256_49911)){
var child_49913 = chunk__49255_49910.cljs$core$IIndexed$_nth$arity$2(null,i__49257_49912);
if(cljs.core.truth_(child_49913)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49913);


var G__49914 = seq__49253_49909;
var G__49915 = chunk__49255_49910;
var G__49916 = count__49256_49911;
var G__49917 = (i__49257_49912 + (1));
seq__49253_49909 = G__49914;
chunk__49255_49910 = G__49915;
count__49256_49911 = G__49916;
i__49257_49912 = G__49917;
continue;
} else {
var G__49918 = seq__49253_49909;
var G__49919 = chunk__49255_49910;
var G__49920 = count__49256_49911;
var G__49921 = (i__49257_49912 + (1));
seq__49253_49909 = G__49918;
chunk__49255_49910 = G__49919;
count__49256_49911 = G__49920;
i__49257_49912 = G__49921;
continue;
}
} else {
var temp__5735__auto___49922__$1 = cljs.core.seq(seq__49253_49909);
if(temp__5735__auto___49922__$1){
var seq__49253_49923__$1 = temp__5735__auto___49922__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49253_49923__$1)){
var c__4556__auto___49924 = cljs.core.chunk_first(seq__49253_49923__$1);
var G__49925 = cljs.core.chunk_rest(seq__49253_49923__$1);
var G__49926 = c__4556__auto___49924;
var G__49927 = cljs.core.count(c__4556__auto___49924);
var G__49928 = (0);
seq__49253_49909 = G__49925;
chunk__49255_49910 = G__49926;
count__49256_49911 = G__49927;
i__49257_49912 = G__49928;
continue;
} else {
var child_49933 = cljs.core.first(seq__49253_49923__$1);
if(cljs.core.truth_(child_49933)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49933);


var G__49934 = cljs.core.next(seq__49253_49923__$1);
var G__49935 = null;
var G__49936 = (0);
var G__49937 = (0);
seq__49253_49909 = G__49934;
chunk__49255_49910 = G__49935;
count__49256_49911 = G__49936;
i__49257_49912 = G__49937;
continue;
} else {
var G__49938 = cljs.core.next(seq__49253_49923__$1);
var G__49939 = null;
var G__49940 = (0);
var G__49941 = (0);
seq__49253_49909 = G__49938;
chunk__49255_49910 = G__49939;
count__49256_49911 = G__49940;
i__49257_49912 = G__49941;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49907);
}


var G__49942 = cljs.core.next(seq__49200_49899__$1);
var G__49943 = null;
var G__49944 = (0);
var G__49945 = (0);
seq__49200_49851 = G__49942;
chunk__49201_49852 = G__49943;
count__49202_49853 = G__49944;
i__49203_49854 = G__49945;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__49277 = cljs.core.seq(node);
var chunk__49278 = null;
var count__49279 = (0);
var i__49280 = (0);
while(true){
if((i__49280 < count__49279)){
var n = chunk__49278.cljs$core$IIndexed$_nth$arity$2(null,i__49280);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49949 = seq__49277;
var G__49950 = chunk__49278;
var G__49951 = count__49279;
var G__49952 = (i__49280 + (1));
seq__49277 = G__49949;
chunk__49278 = G__49950;
count__49279 = G__49951;
i__49280 = G__49952;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__49277);
if(temp__5735__auto__){
var seq__49277__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49277__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__49277__$1);
var G__49953 = cljs.core.chunk_rest(seq__49277__$1);
var G__49954 = c__4556__auto__;
var G__49955 = cljs.core.count(c__4556__auto__);
var G__49956 = (0);
seq__49277 = G__49953;
chunk__49278 = G__49954;
count__49279 = G__49955;
i__49280 = G__49956;
continue;
} else {
var n = cljs.core.first(seq__49277__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__49957 = cljs.core.next(seq__49277__$1);
var G__49958 = null;
var G__49959 = (0);
var G__49960 = (0);
seq__49277 = G__49957;
chunk__49278 = G__49958;
count__49279 = G__49959;
i__49280 = G__49960;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__49291 = arguments.length;
switch (G__49291) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__49298 = arguments.length;
switch (G__49298) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__49317 = arguments.length;
switch (G__49317) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___49970 = arguments.length;
var i__4737__auto___49971 = (0);
while(true){
if((i__4737__auto___49971 < len__4736__auto___49970)){
args__4742__auto__.push((arguments[i__4737__auto___49971]));

var G__49972 = (i__4737__auto___49971 + (1));
i__4737__auto___49971 = G__49972;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__49337_49973 = cljs.core.seq(nodes);
var chunk__49338_49974 = null;
var count__49339_49975 = (0);
var i__49340_49976 = (0);
while(true){
if((i__49340_49976 < count__49339_49975)){
var node_49977 = chunk__49338_49974.cljs$core$IIndexed$_nth$arity$2(null,i__49340_49976);
fragment.appendChild(shadow.dom._to_dom(node_49977));


var G__49978 = seq__49337_49973;
var G__49979 = chunk__49338_49974;
var G__49980 = count__49339_49975;
var G__49981 = (i__49340_49976 + (1));
seq__49337_49973 = G__49978;
chunk__49338_49974 = G__49979;
count__49339_49975 = G__49980;
i__49340_49976 = G__49981;
continue;
} else {
var temp__5735__auto___49983 = cljs.core.seq(seq__49337_49973);
if(temp__5735__auto___49983){
var seq__49337_49984__$1 = temp__5735__auto___49983;
if(cljs.core.chunked_seq_QMARK_(seq__49337_49984__$1)){
var c__4556__auto___49985 = cljs.core.chunk_first(seq__49337_49984__$1);
var G__49986 = cljs.core.chunk_rest(seq__49337_49984__$1);
var G__49987 = c__4556__auto___49985;
var G__49988 = cljs.core.count(c__4556__auto___49985);
var G__49989 = (0);
seq__49337_49973 = G__49986;
chunk__49338_49974 = G__49987;
count__49339_49975 = G__49988;
i__49340_49976 = G__49989;
continue;
} else {
var node_49990 = cljs.core.first(seq__49337_49984__$1);
fragment.appendChild(shadow.dom._to_dom(node_49990));


var G__49991 = cljs.core.next(seq__49337_49984__$1);
var G__49992 = null;
var G__49993 = (0);
var G__49994 = (0);
seq__49337_49973 = G__49991;
chunk__49338_49974 = G__49992;
count__49339_49975 = G__49993;
i__49340_49976 = G__49994;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq49332){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49332));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__49349_49997 = cljs.core.seq(scripts);
var chunk__49350_49998 = null;
var count__49351_49999 = (0);
var i__49352_50000 = (0);
while(true){
if((i__49352_50000 < count__49351_49999)){
var vec__49364_50002 = chunk__49350_49998.cljs$core$IIndexed$_nth$arity$2(null,i__49352_50000);
var script_tag_50003 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49364_50002,(0),null);
var script_body_50004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49364_50002,(1),null);
eval(script_body_50004);


var G__50007 = seq__49349_49997;
var G__50008 = chunk__49350_49998;
var G__50009 = count__49351_49999;
var G__50010 = (i__49352_50000 + (1));
seq__49349_49997 = G__50007;
chunk__49350_49998 = G__50008;
count__49351_49999 = G__50009;
i__49352_50000 = G__50010;
continue;
} else {
var temp__5735__auto___50011 = cljs.core.seq(seq__49349_49997);
if(temp__5735__auto___50011){
var seq__49349_50015__$1 = temp__5735__auto___50011;
if(cljs.core.chunked_seq_QMARK_(seq__49349_50015__$1)){
var c__4556__auto___50016 = cljs.core.chunk_first(seq__49349_50015__$1);
var G__50018 = cljs.core.chunk_rest(seq__49349_50015__$1);
var G__50019 = c__4556__auto___50016;
var G__50020 = cljs.core.count(c__4556__auto___50016);
var G__50021 = (0);
seq__49349_49997 = G__50018;
chunk__49350_49998 = G__50019;
count__49351_49999 = G__50020;
i__49352_50000 = G__50021;
continue;
} else {
var vec__49369_50022 = cljs.core.first(seq__49349_50015__$1);
var script_tag_50023 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49369_50022,(0),null);
var script_body_50025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49369_50022,(1),null);
eval(script_body_50025);


var G__50027 = cljs.core.next(seq__49349_50015__$1);
var G__50028 = null;
var G__50029 = (0);
var G__50030 = (0);
seq__49349_49997 = G__50027;
chunk__49350_49998 = G__50028;
count__49351_49999 = G__50029;
i__49352_50000 = G__50030;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__49372){
var vec__49373 = p__49372;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49373,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49373,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__49390 = arguments.length;
switch (G__49390) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__49408 = cljs.core.seq(style_keys);
var chunk__49409 = null;
var count__49410 = (0);
var i__49411 = (0);
while(true){
if((i__49411 < count__49410)){
var it = chunk__49409.cljs$core$IIndexed$_nth$arity$2(null,i__49411);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50048 = seq__49408;
var G__50049 = chunk__49409;
var G__50050 = count__49410;
var G__50051 = (i__49411 + (1));
seq__49408 = G__50048;
chunk__49409 = G__50049;
count__49410 = G__50050;
i__49411 = G__50051;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__49408);
if(temp__5735__auto__){
var seq__49408__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49408__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__49408__$1);
var G__50053 = cljs.core.chunk_rest(seq__49408__$1);
var G__50054 = c__4556__auto__;
var G__50055 = cljs.core.count(c__4556__auto__);
var G__50056 = (0);
seq__49408 = G__50053;
chunk__49409 = G__50054;
count__49410 = G__50055;
i__49411 = G__50056;
continue;
} else {
var it = cljs.core.first(seq__49408__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50058 = cljs.core.next(seq__49408__$1);
var G__50059 = null;
var G__50060 = (0);
var G__50061 = (0);
seq__49408 = G__50058;
chunk__49409 = G__50059;
count__49410 = G__50060;
i__49411 = G__50061;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k49425,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__49434 = k49425;
var G__49434__$1 = (((G__49434 instanceof cljs.core.Keyword))?G__49434.fqn:null);
switch (G__49434__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49425,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__49439){
var vec__49440 = p__49439;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49440,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49440,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49424){
var self__ = this;
var G__49424__$1 = this;
return (new cljs.core.RecordIter((0),G__49424__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49426,other49427){
var self__ = this;
var this49426__$1 = this;
return (((!((other49427 == null)))) && ((this49426__$1.constructor === other49427.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49426__$1.x,other49427.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49426__$1.y,other49427.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49426__$1.__extmap,other49427.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__49424){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__49458 = cljs.core.keyword_identical_QMARK_;
var expr__49459 = k__4388__auto__;
if(cljs.core.truth_((pred__49458.cljs$core$IFn$_invoke$arity$2 ? pred__49458.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__49459) : pred__49458.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__49459)))){
return (new shadow.dom.Coordinate(G__49424,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49458.cljs$core$IFn$_invoke$arity$2 ? pred__49458.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__49459) : pred__49458.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__49459)))){
return (new shadow.dom.Coordinate(self__.x,G__49424,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__49424),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__49424){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__49424,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__49430){
var extmap__4419__auto__ = (function (){var G__49479 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49430,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__49430)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49479);
} else {
return G__49479;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__49430),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__49430),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k49488,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__49500 = k49488;
var G__49500__$1 = (((G__49500 instanceof cljs.core.Keyword))?G__49500.fqn:null);
switch (G__49500__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49488,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__49504){
var vec__49505 = p__49504;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49505,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49505,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49487){
var self__ = this;
var G__49487__$1 = this;
return (new cljs.core.RecordIter((0),G__49487__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49489,other49490){
var self__ = this;
var this49489__$1 = this;
return (((!((other49490 == null)))) && ((this49489__$1.constructor === other49490.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49489__$1.w,other49490.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49489__$1.h,other49490.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49489__$1.__extmap,other49490.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__49487){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__49530 = cljs.core.keyword_identical_QMARK_;
var expr__49531 = k__4388__auto__;
if(cljs.core.truth_((pred__49530.cljs$core$IFn$_invoke$arity$2 ? pred__49530.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__49531) : pred__49530.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__49531)))){
return (new shadow.dom.Size(G__49487,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49530.cljs$core$IFn$_invoke$arity$2 ? pred__49530.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__49531) : pred__49530.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__49531)))){
return (new shadow.dom.Size(self__.w,G__49487,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__49487),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__49487){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__49487,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__49493){
var extmap__4419__auto__ = (function (){var G__49540 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49493,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__49493)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49540);
} else {
return G__49540;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__49493),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__49493),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__50167 = (i + (1));
var G__50168 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__50167;
ret = G__50168;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__49569){
var vec__49570 = p__49569;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49570,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49570,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__49577 = arguments.length;
switch (G__49577) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__50178 = ps;
var G__50179 = (i + (1));
el__$1 = G__50178;
i = G__50179;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__49607 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49607,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49607,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49607,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__49612_50190 = cljs.core.seq(props);
var chunk__49613_50191 = null;
var count__49614_50192 = (0);
var i__49615_50193 = (0);
while(true){
if((i__49615_50193 < count__49614_50192)){
var vec__49627_50194 = chunk__49613_50191.cljs$core$IIndexed$_nth$arity$2(null,i__49615_50193);
var k_50195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49627_50194,(0),null);
var v_50196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49627_50194,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_50195);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50195),v_50196);


var G__50199 = seq__49612_50190;
var G__50200 = chunk__49613_50191;
var G__50201 = count__49614_50192;
var G__50202 = (i__49615_50193 + (1));
seq__49612_50190 = G__50199;
chunk__49613_50191 = G__50200;
count__49614_50192 = G__50201;
i__49615_50193 = G__50202;
continue;
} else {
var temp__5735__auto___50203 = cljs.core.seq(seq__49612_50190);
if(temp__5735__auto___50203){
var seq__49612_50204__$1 = temp__5735__auto___50203;
if(cljs.core.chunked_seq_QMARK_(seq__49612_50204__$1)){
var c__4556__auto___50205 = cljs.core.chunk_first(seq__49612_50204__$1);
var G__50206 = cljs.core.chunk_rest(seq__49612_50204__$1);
var G__50207 = c__4556__auto___50205;
var G__50208 = cljs.core.count(c__4556__auto___50205);
var G__50209 = (0);
seq__49612_50190 = G__50206;
chunk__49613_50191 = G__50207;
count__49614_50192 = G__50208;
i__49615_50193 = G__50209;
continue;
} else {
var vec__49631_50212 = cljs.core.first(seq__49612_50204__$1);
var k_50213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49631_50212,(0),null);
var v_50214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49631_50212,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_50213);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50213),v_50214);


var G__50217 = cljs.core.next(seq__49612_50204__$1);
var G__50218 = null;
var G__50219 = (0);
var G__50220 = (0);
seq__49612_50190 = G__50217;
chunk__49613_50191 = G__50218;
count__49614_50192 = G__50219;
i__49615_50193 = G__50220;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__49639 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49639,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49639,(1),null);
var seq__49642_50223 = cljs.core.seq(node_children);
var chunk__49644_50224 = null;
var count__49645_50225 = (0);
var i__49646_50226 = (0);
while(true){
if((i__49646_50226 < count__49645_50225)){
var child_struct_50227 = chunk__49644_50224.cljs$core$IIndexed$_nth$arity$2(null,i__49646_50226);
if((!((child_struct_50227 == null)))){
if(typeof child_struct_50227 === 'string'){
var text_50228 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50228),child_struct_50227].join(''));
} else {
var children_50229 = shadow.dom.svg_node(child_struct_50227);
if(cljs.core.seq_QMARK_(children_50229)){
var seq__49668_50234 = cljs.core.seq(children_50229);
var chunk__49670_50235 = null;
var count__49671_50236 = (0);
var i__49672_50237 = (0);
while(true){
if((i__49672_50237 < count__49671_50236)){
var child_50238 = chunk__49670_50235.cljs$core$IIndexed$_nth$arity$2(null,i__49672_50237);
if(cljs.core.truth_(child_50238)){
node.appendChild(child_50238);


var G__50240 = seq__49668_50234;
var G__50241 = chunk__49670_50235;
var G__50242 = count__49671_50236;
var G__50243 = (i__49672_50237 + (1));
seq__49668_50234 = G__50240;
chunk__49670_50235 = G__50241;
count__49671_50236 = G__50242;
i__49672_50237 = G__50243;
continue;
} else {
var G__50248 = seq__49668_50234;
var G__50249 = chunk__49670_50235;
var G__50250 = count__49671_50236;
var G__50251 = (i__49672_50237 + (1));
seq__49668_50234 = G__50248;
chunk__49670_50235 = G__50249;
count__49671_50236 = G__50250;
i__49672_50237 = G__50251;
continue;
}
} else {
var temp__5735__auto___50252 = cljs.core.seq(seq__49668_50234);
if(temp__5735__auto___50252){
var seq__49668_50253__$1 = temp__5735__auto___50252;
if(cljs.core.chunked_seq_QMARK_(seq__49668_50253__$1)){
var c__4556__auto___50254 = cljs.core.chunk_first(seq__49668_50253__$1);
var G__50255 = cljs.core.chunk_rest(seq__49668_50253__$1);
var G__50256 = c__4556__auto___50254;
var G__50257 = cljs.core.count(c__4556__auto___50254);
var G__50258 = (0);
seq__49668_50234 = G__50255;
chunk__49670_50235 = G__50256;
count__49671_50236 = G__50257;
i__49672_50237 = G__50258;
continue;
} else {
var child_50259 = cljs.core.first(seq__49668_50253__$1);
if(cljs.core.truth_(child_50259)){
node.appendChild(child_50259);


var G__50264 = cljs.core.next(seq__49668_50253__$1);
var G__50265 = null;
var G__50266 = (0);
var G__50267 = (0);
seq__49668_50234 = G__50264;
chunk__49670_50235 = G__50265;
count__49671_50236 = G__50266;
i__49672_50237 = G__50267;
continue;
} else {
var G__50268 = cljs.core.next(seq__49668_50253__$1);
var G__50269 = null;
var G__50270 = (0);
var G__50271 = (0);
seq__49668_50234 = G__50268;
chunk__49670_50235 = G__50269;
count__49671_50236 = G__50270;
i__49672_50237 = G__50271;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50229);
}
}


var G__50273 = seq__49642_50223;
var G__50274 = chunk__49644_50224;
var G__50275 = count__49645_50225;
var G__50276 = (i__49646_50226 + (1));
seq__49642_50223 = G__50273;
chunk__49644_50224 = G__50274;
count__49645_50225 = G__50275;
i__49646_50226 = G__50276;
continue;
} else {
var G__50278 = seq__49642_50223;
var G__50279 = chunk__49644_50224;
var G__50280 = count__49645_50225;
var G__50281 = (i__49646_50226 + (1));
seq__49642_50223 = G__50278;
chunk__49644_50224 = G__50279;
count__49645_50225 = G__50280;
i__49646_50226 = G__50281;
continue;
}
} else {
var temp__5735__auto___50282 = cljs.core.seq(seq__49642_50223);
if(temp__5735__auto___50282){
var seq__49642_50283__$1 = temp__5735__auto___50282;
if(cljs.core.chunked_seq_QMARK_(seq__49642_50283__$1)){
var c__4556__auto___50284 = cljs.core.chunk_first(seq__49642_50283__$1);
var G__50285 = cljs.core.chunk_rest(seq__49642_50283__$1);
var G__50286 = c__4556__auto___50284;
var G__50287 = cljs.core.count(c__4556__auto___50284);
var G__50288 = (0);
seq__49642_50223 = G__50285;
chunk__49644_50224 = G__50286;
count__49645_50225 = G__50287;
i__49646_50226 = G__50288;
continue;
} else {
var child_struct_50290 = cljs.core.first(seq__49642_50283__$1);
if((!((child_struct_50290 == null)))){
if(typeof child_struct_50290 === 'string'){
var text_50291 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50291),child_struct_50290].join(''));
} else {
var children_50293 = shadow.dom.svg_node(child_struct_50290);
if(cljs.core.seq_QMARK_(children_50293)){
var seq__49675_50294 = cljs.core.seq(children_50293);
var chunk__49677_50295 = null;
var count__49678_50296 = (0);
var i__49679_50297 = (0);
while(true){
if((i__49679_50297 < count__49678_50296)){
var child_50298 = chunk__49677_50295.cljs$core$IIndexed$_nth$arity$2(null,i__49679_50297);
if(cljs.core.truth_(child_50298)){
node.appendChild(child_50298);


var G__50300 = seq__49675_50294;
var G__50301 = chunk__49677_50295;
var G__50302 = count__49678_50296;
var G__50303 = (i__49679_50297 + (1));
seq__49675_50294 = G__50300;
chunk__49677_50295 = G__50301;
count__49678_50296 = G__50302;
i__49679_50297 = G__50303;
continue;
} else {
var G__50304 = seq__49675_50294;
var G__50305 = chunk__49677_50295;
var G__50306 = count__49678_50296;
var G__50307 = (i__49679_50297 + (1));
seq__49675_50294 = G__50304;
chunk__49677_50295 = G__50305;
count__49678_50296 = G__50306;
i__49679_50297 = G__50307;
continue;
}
} else {
var temp__5735__auto___50312__$1 = cljs.core.seq(seq__49675_50294);
if(temp__5735__auto___50312__$1){
var seq__49675_50313__$1 = temp__5735__auto___50312__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49675_50313__$1)){
var c__4556__auto___50314 = cljs.core.chunk_first(seq__49675_50313__$1);
var G__50316 = cljs.core.chunk_rest(seq__49675_50313__$1);
var G__50317 = c__4556__auto___50314;
var G__50318 = cljs.core.count(c__4556__auto___50314);
var G__50319 = (0);
seq__49675_50294 = G__50316;
chunk__49677_50295 = G__50317;
count__49678_50296 = G__50318;
i__49679_50297 = G__50319;
continue;
} else {
var child_50322 = cljs.core.first(seq__49675_50313__$1);
if(cljs.core.truth_(child_50322)){
node.appendChild(child_50322);


var G__50324 = cljs.core.next(seq__49675_50313__$1);
var G__50325 = null;
var G__50326 = (0);
var G__50327 = (0);
seq__49675_50294 = G__50324;
chunk__49677_50295 = G__50325;
count__49678_50296 = G__50326;
i__49679_50297 = G__50327;
continue;
} else {
var G__50328 = cljs.core.next(seq__49675_50313__$1);
var G__50329 = null;
var G__50330 = (0);
var G__50331 = (0);
seq__49675_50294 = G__50328;
chunk__49677_50295 = G__50329;
count__49678_50296 = G__50330;
i__49679_50297 = G__50331;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50293);
}
}


var G__50333 = cljs.core.next(seq__49642_50283__$1);
var G__50334 = null;
var G__50335 = (0);
var G__50336 = (0);
seq__49642_50223 = G__50333;
chunk__49644_50224 = G__50334;
count__49645_50225 = G__50335;
i__49646_50226 = G__50336;
continue;
} else {
var G__50337 = cljs.core.next(seq__49642_50283__$1);
var G__50338 = null;
var G__50339 = (0);
var G__50340 = (0);
seq__49642_50223 = G__50337;
chunk__49644_50224 = G__50338;
count__49645_50225 = G__50339;
i__49646_50226 = G__50340;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50346 = arguments.length;
var i__4737__auto___50347 = (0);
while(true){
if((i__4737__auto___50347 < len__4736__auto___50346)){
args__4742__auto__.push((arguments[i__4737__auto___50347]));

var G__50348 = (i__4737__auto___50347 + (1));
i__4737__auto___50347 = G__50348;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq49693){
var G__49694 = cljs.core.first(seq49693);
var seq49693__$1 = cljs.core.next(seq49693);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49694,seq49693__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__49702 = arguments.length;
switch (G__49702) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__46897__auto___50361 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__46898__auto__ = (function (){var switch__46797__auto__ = (function (state_49711){
var state_val_49712 = (state_49711[(1)]);
if((state_val_49712 === (1))){
var state_49711__$1 = state_49711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49711__$1,(2),once_or_cleanup);
} else {
if((state_val_49712 === (2))){
var inst_49708 = (state_49711[(2)]);
var inst_49709 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_49711__$1 = (function (){var statearr_49716 = state_49711;
(statearr_49716[(7)] = inst_49708);

return statearr_49716;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49711__$1,inst_49709);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__46798__auto__ = null;
var shadow$dom$state_machine__46798__auto____0 = (function (){
var statearr_49717 = [null,null,null,null,null,null,null,null];
(statearr_49717[(0)] = shadow$dom$state_machine__46798__auto__);

(statearr_49717[(1)] = (1));

return statearr_49717;
});
var shadow$dom$state_machine__46798__auto____1 = (function (state_49711){
while(true){
var ret_value__46799__auto__ = (function (){try{while(true){
var result__46800__auto__ = switch__46797__auto__(state_49711);
if(cljs.core.keyword_identical_QMARK_(result__46800__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46800__auto__;
}
break;
}
}catch (e49719){var ex__46801__auto__ = e49719;
var statearr_49721_50367 = state_49711;
(statearr_49721_50367[(2)] = ex__46801__auto__);


if(cljs.core.seq((state_49711[(4)]))){
var statearr_49722_50368 = state_49711;
(statearr_49722_50368[(1)] = cljs.core.first((state_49711[(4)])));

} else {
throw ex__46801__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46799__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50369 = state_49711;
state_49711 = G__50369;
continue;
} else {
return ret_value__46799__auto__;
}
break;
}
});
shadow$dom$state_machine__46798__auto__ = function(state_49711){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__46798__auto____0.call(this);
case 1:
return shadow$dom$state_machine__46798__auto____1.call(this,state_49711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__46798__auto____0;
shadow$dom$state_machine__46798__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__46798__auto____1;
return shadow$dom$state_machine__46798__auto__;
})()
})();
var state__46899__auto__ = (function (){var statearr_49723 = f__46898__auto__();
(statearr_49723[(6)] = c__46897__auto___50361);

return statearr_49723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__46899__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
