goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__47100 = arguments.length;
switch (G__47100) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47102 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47102 = (function (f,blockable,meta47103){
this.f = f;
this.blockable = blockable;
this.meta47103 = meta47103;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47102.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47104,meta47103__$1){
var self__ = this;
var _47104__$1 = this;
return (new cljs.core.async.t_cljs$core$async47102(self__.f,self__.blockable,meta47103__$1));
}));

(cljs.core.async.t_cljs$core$async47102.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47104){
var self__ = this;
var _47104__$1 = this;
return self__.meta47103;
}));

(cljs.core.async.t_cljs$core$async47102.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47102.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47102.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async47102.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async47102.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta47103","meta47103",2134750916,null)], null);
}));

(cljs.core.async.t_cljs$core$async47102.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47102.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47102");

(cljs.core.async.t_cljs$core$async47102.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47102");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47102.
 */
cljs.core.async.__GT_t_cljs$core$async47102 = (function cljs$core$async$__GT_t_cljs$core$async47102(f__$1,blockable__$1,meta47103){
return (new cljs.core.async.t_cljs$core$async47102(f__$1,blockable__$1,meta47103));
});

}

return (new cljs.core.async.t_cljs$core$async47102(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__47140 = arguments.length;
switch (G__47140) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__47157 = arguments.length;
switch (G__47157) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__47184 = arguments.length;
switch (G__47184) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_50176 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_50176) : fn1.call(null,val_50176));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_50176) : fn1.call(null,val_50176));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__47202 = arguments.length;
switch (G__47202) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___50190 = n;
var x_50191 = (0);
while(true){
if((x_50191 < n__4613__auto___50190)){
(a[x_50191] = x_50191);

var G__50193 = (x_50191 + (1));
x_50191 = G__50193;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47245 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47245 = (function (flag,meta47246){
this.flag = flag;
this.meta47246 = meta47246;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47247,meta47246__$1){
var self__ = this;
var _47247__$1 = this;
return (new cljs.core.async.t_cljs$core$async47245(self__.flag,meta47246__$1));
}));

(cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47247){
var self__ = this;
var _47247__$1 = this;
return self__.meta47246;
}));

(cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47245.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async47245.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta47246","meta47246",-936653561,null)], null);
}));

(cljs.core.async.t_cljs$core$async47245.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47245.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47245");

(cljs.core.async.t_cljs$core$async47245.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47245");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47245.
 */
cljs.core.async.__GT_t_cljs$core$async47245 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async47245(flag__$1,meta47246){
return (new cljs.core.async.t_cljs$core$async47245(flag__$1,meta47246));
});

}

return (new cljs.core.async.t_cljs$core$async47245(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47257 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47257 = (function (flag,cb,meta47258){
this.flag = flag;
this.cb = cb;
this.meta47258 = meta47258;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47257.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47259,meta47258__$1){
var self__ = this;
var _47259__$1 = this;
return (new cljs.core.async.t_cljs$core$async47257(self__.flag,self__.cb,meta47258__$1));
}));

(cljs.core.async.t_cljs$core$async47257.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47259){
var self__ = this;
var _47259__$1 = this;
return self__.meta47258;
}));

(cljs.core.async.t_cljs$core$async47257.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47257.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async47257.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47257.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async47257.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta47258","meta47258",-1283985393,null)], null);
}));

(cljs.core.async.t_cljs$core$async47257.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47257.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47257");

(cljs.core.async.t_cljs$core$async47257.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47257");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47257.
 */
cljs.core.async.__GT_t_cljs$core$async47257 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async47257(flag__$1,cb__$1,meta47258){
return (new cljs.core.async.t_cljs$core$async47257(flag__$1,cb__$1,meta47258));
});

}

return (new cljs.core.async.t_cljs$core$async47257(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47268_SHARP_){
var G__47272 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47268_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__47272) : fret.call(null,G__47272));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__47269_SHARP_){
var G__47273 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__47269_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__47273) : fret.call(null,G__47273));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__50207 = (i + (1));
i = G__50207;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50211 = arguments.length;
var i__4737__auto___50212 = (0);
while(true){
if((i__4737__auto___50212 < len__4736__auto___50211)){
args__4742__auto__.push((arguments[i__4737__auto___50212]));

var G__50213 = (i__4737__auto___50212 + (1));
i__4737__auto___50212 = G__50213;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__47287){
var map__47288 = p__47287;
var map__47288__$1 = (((((!((map__47288 == null))))?(((((map__47288.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47288.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47288):map__47288);
var opts = map__47288__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq47278){
var G__47279 = cljs.core.first(seq47278);
var seq47278__$1 = cljs.core.next(seq47278);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47279,seq47278__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__47298 = arguments.length;
switch (G__47298) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__47011__auto___50223 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_47340){
var state_val_47341 = (state_47340[(1)]);
if((state_val_47341 === (7))){
var inst_47334 = (state_47340[(2)]);
var state_47340__$1 = state_47340;
var statearr_47349_50224 = state_47340__$1;
(statearr_47349_50224[(2)] = inst_47334);

(statearr_47349_50224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (1))){
var state_47340__$1 = state_47340;
var statearr_47352_50225 = state_47340__$1;
(statearr_47352_50225[(2)] = null);

(statearr_47352_50225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (4))){
var inst_47311 = (state_47340[(7)]);
var inst_47311__$1 = (state_47340[(2)]);
var inst_47317 = (inst_47311__$1 == null);
var state_47340__$1 = (function (){var statearr_47359 = state_47340;
(statearr_47359[(7)] = inst_47311__$1);

return statearr_47359;
})();
if(cljs.core.truth_(inst_47317)){
var statearr_47360_50232 = state_47340__$1;
(statearr_47360_50232[(1)] = (5));

} else {
var statearr_47362_50233 = state_47340__$1;
(statearr_47362_50233[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (13))){
var state_47340__$1 = state_47340;
var statearr_47365_50234 = state_47340__$1;
(statearr_47365_50234[(2)] = null);

(statearr_47365_50234[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (6))){
var inst_47311 = (state_47340[(7)]);
var state_47340__$1 = state_47340;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47340__$1,(11),to,inst_47311);
} else {
if((state_val_47341 === (3))){
var inst_47336 = (state_47340[(2)]);
var state_47340__$1 = state_47340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47340__$1,inst_47336);
} else {
if((state_val_47341 === (12))){
var state_47340__$1 = state_47340;
var statearr_47381_50235 = state_47340__$1;
(statearr_47381_50235[(2)] = null);

(statearr_47381_50235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (2))){
var state_47340__$1 = state_47340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47340__$1,(4),from);
} else {
if((state_val_47341 === (11))){
var inst_47327 = (state_47340[(2)]);
var state_47340__$1 = state_47340;
if(cljs.core.truth_(inst_47327)){
var statearr_47393_50236 = state_47340__$1;
(statearr_47393_50236[(1)] = (12));

} else {
var statearr_47397_50238 = state_47340__$1;
(statearr_47397_50238[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (9))){
var state_47340__$1 = state_47340;
var statearr_47402_50242 = state_47340__$1;
(statearr_47402_50242[(2)] = null);

(statearr_47402_50242[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (5))){
var state_47340__$1 = state_47340;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47407_50243 = state_47340__$1;
(statearr_47407_50243[(1)] = (8));

} else {
var statearr_47409_50244 = state_47340__$1;
(statearr_47409_50244[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (14))){
var inst_47332 = (state_47340[(2)]);
var state_47340__$1 = state_47340;
var statearr_47422_50245 = state_47340__$1;
(statearr_47422_50245[(2)] = inst_47332);

(statearr_47422_50245[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (10))){
var inst_47324 = (state_47340[(2)]);
var state_47340__$1 = state_47340;
var statearr_47428_50246 = state_47340__$1;
(statearr_47428_50246[(2)] = inst_47324);

(statearr_47428_50246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47341 === (8))){
var inst_47321 = cljs.core.async.close_BANG_(to);
var state_47340__$1 = state_47340;
var statearr_47429_50251 = state_47340__$1;
(statearr_47429_50251[(2)] = inst_47321);

(statearr_47429_50251[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_47431 = [null,null,null,null,null,null,null,null];
(statearr_47431[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_47431[(1)] = (1));

return statearr_47431;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_47340){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47340);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47436){var ex__46575__auto__ = e47436;
var statearr_47437_50258 = state_47340;
(statearr_47437_50258[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47340[(4)]))){
var statearr_47438_50259 = state_47340;
(statearr_47438_50259[(1)] = cljs.core.first((state_47340[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50260 = state_47340;
state_47340 = G__50260;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_47340){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_47340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_47439 = f__47012__auto__();
(statearr_47439[(6)] = c__47011__auto___50223);

return statearr_47439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__47445){
var vec__47447 = p__47445;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47447,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47447,(1),null);
var job = vec__47447;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__47011__auto___50265 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_47458){
var state_val_47459 = (state_47458[(1)]);
if((state_val_47459 === (1))){
var state_47458__$1 = state_47458;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47458__$1,(2),res,v);
} else {
if((state_val_47459 === (2))){
var inst_47455 = (state_47458[(2)]);
var inst_47456 = cljs.core.async.close_BANG_(res);
var state_47458__$1 = (function (){var statearr_47463 = state_47458;
(statearr_47463[(7)] = inst_47455);

return statearr_47463;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47458__$1,inst_47456);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0 = (function (){
var statearr_47465 = [null,null,null,null,null,null,null,null];
(statearr_47465[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__);

(statearr_47465[(1)] = (1));

return statearr_47465;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1 = (function (state_47458){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47458);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47466){var ex__46575__auto__ = e47466;
var statearr_47467_50271 = state_47458;
(statearr_47467_50271[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47458[(4)]))){
var statearr_47468_50273 = state_47458;
(statearr_47468_50273[(1)] = cljs.core.first((state_47458[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50275 = state_47458;
state_47458 = G__50275;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = function(state_47458){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1.call(this,state_47458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_47472 = f__47012__auto__();
(statearr_47472[(6)] = c__47011__auto___50265);

return statearr_47472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__47474){
var vec__47475 = p__47474;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47475,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47475,(1),null);
var job = vec__47475;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___50278 = n;
var __50280 = (0);
while(true){
if((__50280 < n__4613__auto___50278)){
var G__47480_50281 = type;
var G__47480_50282__$1 = (((G__47480_50281 instanceof cljs.core.Keyword))?G__47480_50281.fqn:null);
switch (G__47480_50282__$1) {
case "compute":
var c__47011__auto___50284 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__50280,c__47011__auto___50284,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async){
return (function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = ((function (__50280,c__47011__auto___50284,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async){
return (function (state_47501){
var state_val_47502 = (state_47501[(1)]);
if((state_val_47502 === (1))){
var state_47501__$1 = state_47501;
var statearr_47509_50290 = state_47501__$1;
(statearr_47509_50290[(2)] = null);

(statearr_47509_50290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47502 === (2))){
var state_47501__$1 = state_47501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47501__$1,(4),jobs);
} else {
if((state_val_47502 === (3))){
var inst_47498 = (state_47501[(2)]);
var state_47501__$1 = state_47501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47501__$1,inst_47498);
} else {
if((state_val_47502 === (4))){
var inst_47487 = (state_47501[(2)]);
var inst_47491 = process(inst_47487);
var state_47501__$1 = state_47501;
if(cljs.core.truth_(inst_47491)){
var statearr_47511_50298 = state_47501__$1;
(statearr_47511_50298[(1)] = (5));

} else {
var statearr_47513_50299 = state_47501__$1;
(statearr_47513_50299[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47502 === (5))){
var state_47501__$1 = state_47501;
var statearr_47515_50300 = state_47501__$1;
(statearr_47515_50300[(2)] = null);

(statearr_47515_50300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47502 === (6))){
var state_47501__$1 = state_47501;
var statearr_47516_50301 = state_47501__$1;
(statearr_47516_50301[(2)] = null);

(statearr_47516_50301[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47502 === (7))){
var inst_47496 = (state_47501[(2)]);
var state_47501__$1 = state_47501;
var statearr_47517_50302 = state_47501__$1;
(statearr_47517_50302[(2)] = inst_47496);

(statearr_47517_50302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__50280,c__47011__auto___50284,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async))
;
return ((function (__50280,switch__46571__auto__,c__47011__auto___50284,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0 = (function (){
var statearr_47519 = [null,null,null,null,null,null,null];
(statearr_47519[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__);

(statearr_47519[(1)] = (1));

return statearr_47519;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1 = (function (state_47501){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47501);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47520){var ex__46575__auto__ = e47520;
var statearr_47521_50307 = state_47501;
(statearr_47521_50307[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47501[(4)]))){
var statearr_47522_50308 = state_47501;
(statearr_47522_50308[(1)] = cljs.core.first((state_47501[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50309 = state_47501;
state_47501 = G__50309;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = function(state_47501){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1.call(this,state_47501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__;
})()
;})(__50280,switch__46571__auto__,c__47011__auto___50284,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async))
})();
var state__47013__auto__ = (function (){var statearr_47524 = f__47012__auto__();
(statearr_47524[(6)] = c__47011__auto___50284);

return statearr_47524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
});})(__50280,c__47011__auto___50284,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async))
);


break;
case "async":
var c__47011__auto___50311 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__50280,c__47011__auto___50311,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async){
return (function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = ((function (__50280,c__47011__auto___50311,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async){
return (function (state_47540){
var state_val_47541 = (state_47540[(1)]);
if((state_val_47541 === (1))){
var state_47540__$1 = state_47540;
var statearr_47543_50312 = state_47540__$1;
(statearr_47543_50312[(2)] = null);

(statearr_47543_50312[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (2))){
var state_47540__$1 = state_47540;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47540__$1,(4),jobs);
} else {
if((state_val_47541 === (3))){
var inst_47537 = (state_47540[(2)]);
var state_47540__$1 = state_47540;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47540__$1,inst_47537);
} else {
if((state_val_47541 === (4))){
var inst_47528 = (state_47540[(2)]);
var inst_47530 = async(inst_47528);
var state_47540__$1 = state_47540;
if(cljs.core.truth_(inst_47530)){
var statearr_47544_50314 = state_47540__$1;
(statearr_47544_50314[(1)] = (5));

} else {
var statearr_47545_50315 = state_47540__$1;
(statearr_47545_50315[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (5))){
var state_47540__$1 = state_47540;
var statearr_47548_50317 = state_47540__$1;
(statearr_47548_50317[(2)] = null);

(statearr_47548_50317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (6))){
var state_47540__$1 = state_47540;
var statearr_47550_50318 = state_47540__$1;
(statearr_47550_50318[(2)] = null);

(statearr_47550_50318[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47541 === (7))){
var inst_47535 = (state_47540[(2)]);
var state_47540__$1 = state_47540;
var statearr_47552_50322 = state_47540__$1;
(statearr_47552_50322[(2)] = inst_47535);

(statearr_47552_50322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__50280,c__47011__auto___50311,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async))
;
return ((function (__50280,switch__46571__auto__,c__47011__auto___50311,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0 = (function (){
var statearr_47554 = [null,null,null,null,null,null,null];
(statearr_47554[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__);

(statearr_47554[(1)] = (1));

return statearr_47554;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1 = (function (state_47540){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47540);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47555){var ex__46575__auto__ = e47555;
var statearr_47556_50324 = state_47540;
(statearr_47556_50324[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47540[(4)]))){
var statearr_47557_50326 = state_47540;
(statearr_47557_50326[(1)] = cljs.core.first((state_47540[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50327 = state_47540;
state_47540 = G__50327;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = function(state_47540){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1.call(this,state_47540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__;
})()
;})(__50280,switch__46571__auto__,c__47011__auto___50311,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async))
})();
var state__47013__auto__ = (function (){var statearr_47560 = f__47012__auto__();
(statearr_47560[(6)] = c__47011__auto___50311);

return statearr_47560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
});})(__50280,c__47011__auto___50311,G__47480_50281,G__47480_50282__$1,n__4613__auto___50278,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__47480_50282__$1)].join('')));

}

var G__50328 = (__50280 + (1));
__50280 = G__50328;
continue;
} else {
}
break;
}

var c__47011__auto___50332 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_47591){
var state_val_47592 = (state_47591[(1)]);
if((state_val_47592 === (7))){
var inst_47586 = (state_47591[(2)]);
var state_47591__$1 = state_47591;
var statearr_47593_50334 = state_47591__$1;
(statearr_47593_50334[(2)] = inst_47586);

(statearr_47593_50334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47592 === (1))){
var state_47591__$1 = state_47591;
var statearr_47594_50335 = state_47591__$1;
(statearr_47594_50335[(2)] = null);

(statearr_47594_50335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47592 === (4))){
var inst_47568 = (state_47591[(7)]);
var inst_47568__$1 = (state_47591[(2)]);
var inst_47569 = (inst_47568__$1 == null);
var state_47591__$1 = (function (){var statearr_47595 = state_47591;
(statearr_47595[(7)] = inst_47568__$1);

return statearr_47595;
})();
if(cljs.core.truth_(inst_47569)){
var statearr_47596_50337 = state_47591__$1;
(statearr_47596_50337[(1)] = (5));

} else {
var statearr_47597_50338 = state_47591__$1;
(statearr_47597_50338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47592 === (6))){
var inst_47575 = (state_47591[(8)]);
var inst_47568 = (state_47591[(7)]);
var inst_47575__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_47577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47578 = [inst_47568,inst_47575__$1];
var inst_47579 = (new cljs.core.PersistentVector(null,2,(5),inst_47577,inst_47578,null));
var state_47591__$1 = (function (){var statearr_47600 = state_47591;
(statearr_47600[(8)] = inst_47575__$1);

return statearr_47600;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47591__$1,(8),jobs,inst_47579);
} else {
if((state_val_47592 === (3))){
var inst_47588 = (state_47591[(2)]);
var state_47591__$1 = state_47591;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47591__$1,inst_47588);
} else {
if((state_val_47592 === (2))){
var state_47591__$1 = state_47591;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47591__$1,(4),from);
} else {
if((state_val_47592 === (9))){
var inst_47583 = (state_47591[(2)]);
var state_47591__$1 = (function (){var statearr_47602 = state_47591;
(statearr_47602[(9)] = inst_47583);

return statearr_47602;
})();
var statearr_47603_50343 = state_47591__$1;
(statearr_47603_50343[(2)] = null);

(statearr_47603_50343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47592 === (5))){
var inst_47571 = cljs.core.async.close_BANG_(jobs);
var state_47591__$1 = state_47591;
var statearr_47604_50347 = state_47591__$1;
(statearr_47604_50347[(2)] = inst_47571);

(statearr_47604_50347[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47592 === (8))){
var inst_47575 = (state_47591[(8)]);
var inst_47581 = (state_47591[(2)]);
var state_47591__$1 = (function (){var statearr_47605 = state_47591;
(statearr_47605[(10)] = inst_47581);

return statearr_47605;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47591__$1,(9),results,inst_47575);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0 = (function (){
var statearr_47611 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47611[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__);

(statearr_47611[(1)] = (1));

return statearr_47611;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1 = (function (state_47591){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47591);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47613){var ex__46575__auto__ = e47613;
var statearr_47614_50353 = state_47591;
(statearr_47614_50353[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47591[(4)]))){
var statearr_47615_50354 = state_47591;
(statearr_47615_50354[(1)] = cljs.core.first((state_47591[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50356 = state_47591;
state_47591 = G__50356;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = function(state_47591){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1.call(this,state_47591);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_47620 = f__47012__auto__();
(statearr_47620[(6)] = c__47011__auto___50332);

return statearr_47620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


var c__47011__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_47661){
var state_val_47662 = (state_47661[(1)]);
if((state_val_47662 === (7))){
var inst_47657 = (state_47661[(2)]);
var state_47661__$1 = state_47661;
var statearr_47664_50361 = state_47661__$1;
(statearr_47664_50361[(2)] = inst_47657);

(statearr_47664_50361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (20))){
var state_47661__$1 = state_47661;
var statearr_47665_50364 = state_47661__$1;
(statearr_47665_50364[(2)] = null);

(statearr_47665_50364[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (1))){
var state_47661__$1 = state_47661;
var statearr_47668_50366 = state_47661__$1;
(statearr_47668_50366[(2)] = null);

(statearr_47668_50366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (4))){
var inst_47623 = (state_47661[(7)]);
var inst_47623__$1 = (state_47661[(2)]);
var inst_47624 = (inst_47623__$1 == null);
var state_47661__$1 = (function (){var statearr_47672 = state_47661;
(statearr_47672[(7)] = inst_47623__$1);

return statearr_47672;
})();
if(cljs.core.truth_(inst_47624)){
var statearr_47673_50368 = state_47661__$1;
(statearr_47673_50368[(1)] = (5));

} else {
var statearr_47674_50371 = state_47661__$1;
(statearr_47674_50371[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (15))){
var inst_47638 = (state_47661[(8)]);
var state_47661__$1 = state_47661;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47661__$1,(18),to,inst_47638);
} else {
if((state_val_47662 === (21))){
var inst_47652 = (state_47661[(2)]);
var state_47661__$1 = state_47661;
var statearr_47676_50373 = state_47661__$1;
(statearr_47676_50373[(2)] = inst_47652);

(statearr_47676_50373[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (13))){
var inst_47654 = (state_47661[(2)]);
var state_47661__$1 = (function (){var statearr_47677 = state_47661;
(statearr_47677[(9)] = inst_47654);

return statearr_47677;
})();
var statearr_47678_50376 = state_47661__$1;
(statearr_47678_50376[(2)] = null);

(statearr_47678_50376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (6))){
var inst_47623 = (state_47661[(7)]);
var state_47661__$1 = state_47661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47661__$1,(11),inst_47623);
} else {
if((state_val_47662 === (17))){
var inst_47646 = (state_47661[(2)]);
var state_47661__$1 = state_47661;
if(cljs.core.truth_(inst_47646)){
var statearr_47680_50379 = state_47661__$1;
(statearr_47680_50379[(1)] = (19));

} else {
var statearr_47681_50380 = state_47661__$1;
(statearr_47681_50380[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (3))){
var inst_47659 = (state_47661[(2)]);
var state_47661__$1 = state_47661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47661__$1,inst_47659);
} else {
if((state_val_47662 === (12))){
var inst_47635 = (state_47661[(10)]);
var state_47661__$1 = state_47661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47661__$1,(14),inst_47635);
} else {
if((state_val_47662 === (2))){
var state_47661__$1 = state_47661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47661__$1,(4),results);
} else {
if((state_val_47662 === (19))){
var state_47661__$1 = state_47661;
var statearr_47682_50385 = state_47661__$1;
(statearr_47682_50385[(2)] = null);

(statearr_47682_50385[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (11))){
var inst_47635 = (state_47661[(2)]);
var state_47661__$1 = (function (){var statearr_47683 = state_47661;
(statearr_47683[(10)] = inst_47635);

return statearr_47683;
})();
var statearr_47684_50388 = state_47661__$1;
(statearr_47684_50388[(2)] = null);

(statearr_47684_50388[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (9))){
var state_47661__$1 = state_47661;
var statearr_47685_50391 = state_47661__$1;
(statearr_47685_50391[(2)] = null);

(statearr_47685_50391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (5))){
var state_47661__$1 = state_47661;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47688_50392 = state_47661__$1;
(statearr_47688_50392[(1)] = (8));

} else {
var statearr_47689_50393 = state_47661__$1;
(statearr_47689_50393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (14))){
var inst_47638 = (state_47661[(8)]);
var inst_47638__$1 = (state_47661[(2)]);
var inst_47639 = (inst_47638__$1 == null);
var inst_47640 = cljs.core.not(inst_47639);
var state_47661__$1 = (function (){var statearr_47693 = state_47661;
(statearr_47693[(8)] = inst_47638__$1);

return statearr_47693;
})();
if(inst_47640){
var statearr_47694_50398 = state_47661__$1;
(statearr_47694_50398[(1)] = (15));

} else {
var statearr_47696_50399 = state_47661__$1;
(statearr_47696_50399[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (16))){
var state_47661__$1 = state_47661;
var statearr_47698_50400 = state_47661__$1;
(statearr_47698_50400[(2)] = false);

(statearr_47698_50400[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (10))){
var inst_47631 = (state_47661[(2)]);
var state_47661__$1 = state_47661;
var statearr_47700_50401 = state_47661__$1;
(statearr_47700_50401[(2)] = inst_47631);

(statearr_47700_50401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (18))){
var inst_47643 = (state_47661[(2)]);
var state_47661__$1 = state_47661;
var statearr_47701_50402 = state_47661__$1;
(statearr_47701_50402[(2)] = inst_47643);

(statearr_47701_50402[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47662 === (8))){
var inst_47628 = cljs.core.async.close_BANG_(to);
var state_47661__$1 = state_47661;
var statearr_47702_50403 = state_47661__$1;
(statearr_47702_50403[(2)] = inst_47628);

(statearr_47702_50403[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0 = (function (){
var statearr_47708 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47708[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__);

(statearr_47708[(1)] = (1));

return statearr_47708;
});
var cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1 = (function (state_47661){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47661);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47710){var ex__46575__auto__ = e47710;
var statearr_47711_50404 = state_47661;
(statearr_47711_50404[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47661[(4)]))){
var statearr_47712_50406 = state_47661;
(statearr_47712_50406[(1)] = cljs.core.first((state_47661[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50408 = state_47661;
state_47661 = G__50408;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__ = function(state_47661){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1.call(this,state_47661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__46572__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_47715 = f__47012__auto__();
(statearr_47715[(6)] = c__47011__auto__);

return statearr_47715;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));

return c__47011__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__47732 = arguments.length;
switch (G__47732) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__47749 = arguments.length;
switch (G__47749) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__47762 = arguments.length;
switch (G__47762) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__47011__auto___50420 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_47794){
var state_val_47795 = (state_47794[(1)]);
if((state_val_47795 === (7))){
var inst_47790 = (state_47794[(2)]);
var state_47794__$1 = state_47794;
var statearr_47798_50424 = state_47794__$1;
(statearr_47798_50424[(2)] = inst_47790);

(statearr_47798_50424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (1))){
var state_47794__$1 = state_47794;
var statearr_47799_50427 = state_47794__$1;
(statearr_47799_50427[(2)] = null);

(statearr_47799_50427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (4))){
var inst_47767 = (state_47794[(7)]);
var inst_47767__$1 = (state_47794[(2)]);
var inst_47768 = (inst_47767__$1 == null);
var state_47794__$1 = (function (){var statearr_47800 = state_47794;
(statearr_47800[(7)] = inst_47767__$1);

return statearr_47800;
})();
if(cljs.core.truth_(inst_47768)){
var statearr_47801_50429 = state_47794__$1;
(statearr_47801_50429[(1)] = (5));

} else {
var statearr_47802_50431 = state_47794__$1;
(statearr_47802_50431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (13))){
var state_47794__$1 = state_47794;
var statearr_47804_50432 = state_47794__$1;
(statearr_47804_50432[(2)] = null);

(statearr_47804_50432[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (6))){
var inst_47767 = (state_47794[(7)]);
var inst_47777 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47767) : p.call(null,inst_47767));
var state_47794__$1 = state_47794;
if(cljs.core.truth_(inst_47777)){
var statearr_47805_50435 = state_47794__$1;
(statearr_47805_50435[(1)] = (9));

} else {
var statearr_47806_50436 = state_47794__$1;
(statearr_47806_50436[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (3))){
var inst_47792 = (state_47794[(2)]);
var state_47794__$1 = state_47794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47794__$1,inst_47792);
} else {
if((state_val_47795 === (12))){
var state_47794__$1 = state_47794;
var statearr_47811_50438 = state_47794__$1;
(statearr_47811_50438[(2)] = null);

(statearr_47811_50438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (2))){
var state_47794__$1 = state_47794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47794__$1,(4),ch);
} else {
if((state_val_47795 === (11))){
var inst_47767 = (state_47794[(7)]);
var inst_47781 = (state_47794[(2)]);
var state_47794__$1 = state_47794;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47794__$1,(8),inst_47781,inst_47767);
} else {
if((state_val_47795 === (9))){
var state_47794__$1 = state_47794;
var statearr_47812_50444 = state_47794__$1;
(statearr_47812_50444[(2)] = tc);

(statearr_47812_50444[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (5))){
var inst_47770 = cljs.core.async.close_BANG_(tc);
var inst_47771 = cljs.core.async.close_BANG_(fc);
var state_47794__$1 = (function (){var statearr_47813 = state_47794;
(statearr_47813[(8)] = inst_47770);

return statearr_47813;
})();
var statearr_47814_50449 = state_47794__$1;
(statearr_47814_50449[(2)] = inst_47771);

(statearr_47814_50449[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (14))){
var inst_47788 = (state_47794[(2)]);
var state_47794__$1 = state_47794;
var statearr_47815_50453 = state_47794__$1;
(statearr_47815_50453[(2)] = inst_47788);

(statearr_47815_50453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (10))){
var state_47794__$1 = state_47794;
var statearr_47816_50454 = state_47794__$1;
(statearr_47816_50454[(2)] = fc);

(statearr_47816_50454[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47795 === (8))){
var inst_47783 = (state_47794[(2)]);
var state_47794__$1 = state_47794;
if(cljs.core.truth_(inst_47783)){
var statearr_47817_50455 = state_47794__$1;
(statearr_47817_50455[(1)] = (12));

} else {
var statearr_47818_50456 = state_47794__$1;
(statearr_47818_50456[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_47819 = [null,null,null,null,null,null,null,null,null];
(statearr_47819[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_47819[(1)] = (1));

return statearr_47819;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_47794){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47794);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47821){var ex__46575__auto__ = e47821;
var statearr_47822_50460 = state_47794;
(statearr_47822_50460[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47794[(4)]))){
var statearr_47823_50462 = state_47794;
(statearr_47823_50462[(1)] = cljs.core.first((state_47794[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50465 = state_47794;
state_47794 = G__50465;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_47794){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_47794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_47825 = f__47012__auto__();
(statearr_47825[(6)] = c__47011__auto___50420);

return statearr_47825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__47011__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_47849){
var state_val_47850 = (state_47849[(1)]);
if((state_val_47850 === (7))){
var inst_47845 = (state_47849[(2)]);
var state_47849__$1 = state_47849;
var statearr_47854_50471 = state_47849__$1;
(statearr_47854_50471[(2)] = inst_47845);

(statearr_47854_50471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47850 === (1))){
var inst_47826 = init;
var inst_47827 = inst_47826;
var state_47849__$1 = (function (){var statearr_47855 = state_47849;
(statearr_47855[(7)] = inst_47827);

return statearr_47855;
})();
var statearr_47856_50473 = state_47849__$1;
(statearr_47856_50473[(2)] = null);

(statearr_47856_50473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47850 === (4))){
var inst_47831 = (state_47849[(8)]);
var inst_47831__$1 = (state_47849[(2)]);
var inst_47832 = (inst_47831__$1 == null);
var state_47849__$1 = (function (){var statearr_47857 = state_47849;
(statearr_47857[(8)] = inst_47831__$1);

return statearr_47857;
})();
if(cljs.core.truth_(inst_47832)){
var statearr_47858_50475 = state_47849__$1;
(statearr_47858_50475[(1)] = (5));

} else {
var statearr_47859_50476 = state_47849__$1;
(statearr_47859_50476[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47850 === (6))){
var inst_47836 = (state_47849[(9)]);
var inst_47831 = (state_47849[(8)]);
var inst_47827 = (state_47849[(7)]);
var inst_47836__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_47827,inst_47831) : f.call(null,inst_47827,inst_47831));
var inst_47837 = cljs.core.reduced_QMARK_(inst_47836__$1);
var state_47849__$1 = (function (){var statearr_47860 = state_47849;
(statearr_47860[(9)] = inst_47836__$1);

return statearr_47860;
})();
if(inst_47837){
var statearr_47862_50482 = state_47849__$1;
(statearr_47862_50482[(1)] = (8));

} else {
var statearr_47863_50484 = state_47849__$1;
(statearr_47863_50484[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47850 === (3))){
var inst_47847 = (state_47849[(2)]);
var state_47849__$1 = state_47849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47849__$1,inst_47847);
} else {
if((state_val_47850 === (2))){
var state_47849__$1 = state_47849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47849__$1,(4),ch);
} else {
if((state_val_47850 === (9))){
var inst_47836 = (state_47849[(9)]);
var inst_47827 = inst_47836;
var state_47849__$1 = (function (){var statearr_47864 = state_47849;
(statearr_47864[(7)] = inst_47827);

return statearr_47864;
})();
var statearr_47865_50491 = state_47849__$1;
(statearr_47865_50491[(2)] = null);

(statearr_47865_50491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47850 === (5))){
var inst_47827 = (state_47849[(7)]);
var state_47849__$1 = state_47849;
var statearr_47866_50493 = state_47849__$1;
(statearr_47866_50493[(2)] = inst_47827);

(statearr_47866_50493[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47850 === (10))){
var inst_47843 = (state_47849[(2)]);
var state_47849__$1 = state_47849;
var statearr_47867_50494 = state_47849__$1;
(statearr_47867_50494[(2)] = inst_47843);

(statearr_47867_50494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47850 === (8))){
var inst_47836 = (state_47849[(9)]);
var inst_47839 = cljs.core.deref(inst_47836);
var state_47849__$1 = state_47849;
var statearr_47868_50496 = state_47849__$1;
(statearr_47868_50496[(2)] = inst_47839);

(statearr_47868_50496[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__46572__auto__ = null;
var cljs$core$async$reduce_$_state_machine__46572__auto____0 = (function (){
var statearr_47869 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47869[(0)] = cljs$core$async$reduce_$_state_machine__46572__auto__);

(statearr_47869[(1)] = (1));

return statearr_47869;
});
var cljs$core$async$reduce_$_state_machine__46572__auto____1 = (function (state_47849){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47849);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47873){var ex__46575__auto__ = e47873;
var statearr_47874_50500 = state_47849;
(statearr_47874_50500[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47849[(4)]))){
var statearr_47875_50501 = state_47849;
(statearr_47875_50501[(1)] = cljs.core.first((state_47849[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50503 = state_47849;
state_47849 = G__50503;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__46572__auto__ = function(state_47849){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__46572__auto____1.call(this,state_47849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__46572__auto____0;
cljs$core$async$reduce_$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__46572__auto____1;
return cljs$core$async$reduce_$_state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_47876 = f__47012__auto__();
(statearr_47876[(6)] = c__47011__auto__);

return statearr_47876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));

return c__47011__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__47011__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_47882){
var state_val_47883 = (state_47882[(1)]);
if((state_val_47883 === (1))){
var inst_47877 = cljs.core.async.reduce(f__$1,init,ch);
var state_47882__$1 = state_47882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47882__$1,(2),inst_47877);
} else {
if((state_val_47883 === (2))){
var inst_47879 = (state_47882[(2)]);
var inst_47880 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_47879) : f__$1.call(null,inst_47879));
var state_47882__$1 = state_47882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47882__$1,inst_47880);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__46572__auto__ = null;
var cljs$core$async$transduce_$_state_machine__46572__auto____0 = (function (){
var statearr_47884 = [null,null,null,null,null,null,null];
(statearr_47884[(0)] = cljs$core$async$transduce_$_state_machine__46572__auto__);

(statearr_47884[(1)] = (1));

return statearr_47884;
});
var cljs$core$async$transduce_$_state_machine__46572__auto____1 = (function (state_47882){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47882);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47885){var ex__46575__auto__ = e47885;
var statearr_47886_50510 = state_47882;
(statearr_47886_50510[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47882[(4)]))){
var statearr_47887_50511 = state_47882;
(statearr_47887_50511[(1)] = cljs.core.first((state_47882[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50513 = state_47882;
state_47882 = G__50513;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__46572__auto__ = function(state_47882){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__46572__auto____1.call(this,state_47882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__46572__auto____0;
cljs$core$async$transduce_$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__46572__auto____1;
return cljs$core$async$transduce_$_state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_47888 = f__47012__auto__();
(statearr_47888[(6)] = c__47011__auto__);

return statearr_47888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));

return c__47011__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__47890 = arguments.length;
switch (G__47890) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__47011__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_47917){
var state_val_47918 = (state_47917[(1)]);
if((state_val_47918 === (7))){
var inst_47899 = (state_47917[(2)]);
var state_47917__$1 = state_47917;
var statearr_47920_50522 = state_47917__$1;
(statearr_47920_50522[(2)] = inst_47899);

(statearr_47920_50522[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (1))){
var inst_47891 = cljs.core.seq(coll);
var inst_47892 = inst_47891;
var state_47917__$1 = (function (){var statearr_47921 = state_47917;
(statearr_47921[(7)] = inst_47892);

return statearr_47921;
})();
var statearr_47922_50523 = state_47917__$1;
(statearr_47922_50523[(2)] = null);

(statearr_47922_50523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (4))){
var inst_47892 = (state_47917[(7)]);
var inst_47897 = cljs.core.first(inst_47892);
var state_47917__$1 = state_47917;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47917__$1,(7),ch,inst_47897);
} else {
if((state_val_47918 === (13))){
var inst_47911 = (state_47917[(2)]);
var state_47917__$1 = state_47917;
var statearr_47926_50526 = state_47917__$1;
(statearr_47926_50526[(2)] = inst_47911);

(statearr_47926_50526[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (6))){
var inst_47902 = (state_47917[(2)]);
var state_47917__$1 = state_47917;
if(cljs.core.truth_(inst_47902)){
var statearr_47929_50528 = state_47917__$1;
(statearr_47929_50528[(1)] = (8));

} else {
var statearr_47930_50530 = state_47917__$1;
(statearr_47930_50530[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (3))){
var inst_47915 = (state_47917[(2)]);
var state_47917__$1 = state_47917;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47917__$1,inst_47915);
} else {
if((state_val_47918 === (12))){
var state_47917__$1 = state_47917;
var statearr_47931_50531 = state_47917__$1;
(statearr_47931_50531[(2)] = null);

(statearr_47931_50531[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (2))){
var inst_47892 = (state_47917[(7)]);
var state_47917__$1 = state_47917;
if(cljs.core.truth_(inst_47892)){
var statearr_47932_50533 = state_47917__$1;
(statearr_47932_50533[(1)] = (4));

} else {
var statearr_47934_50536 = state_47917__$1;
(statearr_47934_50536[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (11))){
var inst_47908 = cljs.core.async.close_BANG_(ch);
var state_47917__$1 = state_47917;
var statearr_47936_50538 = state_47917__$1;
(statearr_47936_50538[(2)] = inst_47908);

(statearr_47936_50538[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (9))){
var state_47917__$1 = state_47917;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47939_50539 = state_47917__$1;
(statearr_47939_50539[(1)] = (11));

} else {
var statearr_47941_50540 = state_47917__$1;
(statearr_47941_50540[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (5))){
var inst_47892 = (state_47917[(7)]);
var state_47917__$1 = state_47917;
var statearr_47943_50541 = state_47917__$1;
(statearr_47943_50541[(2)] = inst_47892);

(statearr_47943_50541[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (10))){
var inst_47913 = (state_47917[(2)]);
var state_47917__$1 = state_47917;
var statearr_47944_50548 = state_47917__$1;
(statearr_47944_50548[(2)] = inst_47913);

(statearr_47944_50548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47918 === (8))){
var inst_47892 = (state_47917[(7)]);
var inst_47904 = cljs.core.next(inst_47892);
var inst_47892__$1 = inst_47904;
var state_47917__$1 = (function (){var statearr_47945 = state_47917;
(statearr_47945[(7)] = inst_47892__$1);

return statearr_47945;
})();
var statearr_47946_50550 = state_47917__$1;
(statearr_47946_50550[(2)] = null);

(statearr_47946_50550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_47947 = [null,null,null,null,null,null,null,null];
(statearr_47947[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_47947[(1)] = (1));

return statearr_47947;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_47917){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_47917);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e47948){var ex__46575__auto__ = e47948;
var statearr_47949_50553 = state_47917;
(statearr_47949_50553[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_47917[(4)]))){
var statearr_47950_50554 = state_47917;
(statearr_47950_50554[(1)] = cljs.core.first((state_47917[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50556 = state_47917;
state_47917 = G__50556;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_47917){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_47917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_47952 = f__47012__auto__();
(statearr_47952[(6)] = c__47011__auto__);

return statearr_47952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));

return c__47011__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__47964 = arguments.length;
switch (G__47964) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_50565 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_50565(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_50570 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_50570(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_50574 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_50574(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_50579 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_50579(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48010 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48010 = (function (ch,cs,meta48011){
this.ch = ch;
this.cs = cs;
this.meta48011 = meta48011;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48010.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48012,meta48011__$1){
var self__ = this;
var _48012__$1 = this;
return (new cljs.core.async.t_cljs$core$async48010(self__.ch,self__.cs,meta48011__$1));
}));

(cljs.core.async.t_cljs$core$async48010.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48012){
var self__ = this;
var _48012__$1 = this;
return self__.meta48011;
}));

(cljs.core.async.t_cljs$core$async48010.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48010.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async48010.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48010.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async48010.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async48010.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async48010.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta48011","meta48011",-1696494956,null)], null);
}));

(cljs.core.async.t_cljs$core$async48010.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48010.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48010");

(cljs.core.async.t_cljs$core$async48010.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48010");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48010.
 */
cljs.core.async.__GT_t_cljs$core$async48010 = (function cljs$core$async$mult_$___GT_t_cljs$core$async48010(ch__$1,cs__$1,meta48011){
return (new cljs.core.async.t_cljs$core$async48010(ch__$1,cs__$1,meta48011));
});

}

return (new cljs.core.async.t_cljs$core$async48010(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__47011__auto___50608 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_48283){
var state_val_48286 = (state_48283[(1)]);
if((state_val_48286 === (7))){
var inst_48256 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48291_50611 = state_48283__$1;
(statearr_48291_50611[(2)] = inst_48256);

(statearr_48291_50611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (20))){
var inst_48118 = (state_48283[(7)]);
var inst_48139 = cljs.core.first(inst_48118);
var inst_48142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48139,(0),null);
var inst_48143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48139,(1),null);
var state_48283__$1 = (function (){var statearr_48297 = state_48283;
(statearr_48297[(8)] = inst_48142);

return statearr_48297;
})();
if(cljs.core.truth_(inst_48143)){
var statearr_48301_50613 = state_48283__$1;
(statearr_48301_50613[(1)] = (22));

} else {
var statearr_48303_50614 = state_48283__$1;
(statearr_48303_50614[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (27))){
var inst_48184 = (state_48283[(9)]);
var inst_48194 = (state_48283[(10)]);
var inst_48070 = (state_48283[(11)]);
var inst_48182 = (state_48283[(12)]);
var inst_48194__$1 = cljs.core._nth(inst_48182,inst_48184);
var inst_48195 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_48194__$1,inst_48070,done);
var state_48283__$1 = (function (){var statearr_48315 = state_48283;
(statearr_48315[(10)] = inst_48194__$1);

return statearr_48315;
})();
if(cljs.core.truth_(inst_48195)){
var statearr_48317_50625 = state_48283__$1;
(statearr_48317_50625[(1)] = (30));

} else {
var statearr_48319_50627 = state_48283__$1;
(statearr_48319_50627[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (1))){
var state_48283__$1 = state_48283;
var statearr_48325_50629 = state_48283__$1;
(statearr_48325_50629[(2)] = null);

(statearr_48325_50629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (24))){
var inst_48118 = (state_48283[(7)]);
var inst_48151 = (state_48283[(2)]);
var inst_48152 = cljs.core.next(inst_48118);
var inst_48085 = inst_48152;
var inst_48086 = null;
var inst_48087 = (0);
var inst_48088 = (0);
var state_48283__$1 = (function (){var statearr_48330 = state_48283;
(statearr_48330[(13)] = inst_48086);

(statearr_48330[(14)] = inst_48087);

(statearr_48330[(15)] = inst_48151);

(statearr_48330[(16)] = inst_48088);

(statearr_48330[(17)] = inst_48085);

return statearr_48330;
})();
var statearr_48335_50632 = state_48283__$1;
(statearr_48335_50632[(2)] = null);

(statearr_48335_50632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (39))){
var state_48283__$1 = state_48283;
var statearr_48345_50638 = state_48283__$1;
(statearr_48345_50638[(2)] = null);

(statearr_48345_50638[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (4))){
var inst_48070 = (state_48283[(11)]);
var inst_48070__$1 = (state_48283[(2)]);
var inst_48074 = (inst_48070__$1 == null);
var state_48283__$1 = (function (){var statearr_48351 = state_48283;
(statearr_48351[(11)] = inst_48070__$1);

return statearr_48351;
})();
if(cljs.core.truth_(inst_48074)){
var statearr_48353_50641 = state_48283__$1;
(statearr_48353_50641[(1)] = (5));

} else {
var statearr_48355_50642 = state_48283__$1;
(statearr_48355_50642[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (15))){
var inst_48086 = (state_48283[(13)]);
var inst_48087 = (state_48283[(14)]);
var inst_48088 = (state_48283[(16)]);
var inst_48085 = (state_48283[(17)]);
var inst_48112 = (state_48283[(2)]);
var inst_48113 = (inst_48088 + (1));
var tmp48338 = inst_48086;
var tmp48339 = inst_48087;
var tmp48340 = inst_48085;
var inst_48085__$1 = tmp48340;
var inst_48086__$1 = tmp48338;
var inst_48087__$1 = tmp48339;
var inst_48088__$1 = inst_48113;
var state_48283__$1 = (function (){var statearr_48363 = state_48283;
(statearr_48363[(13)] = inst_48086__$1);

(statearr_48363[(14)] = inst_48087__$1);

(statearr_48363[(18)] = inst_48112);

(statearr_48363[(16)] = inst_48088__$1);

(statearr_48363[(17)] = inst_48085__$1);

return statearr_48363;
})();
var statearr_48366_50650 = state_48283__$1;
(statearr_48366_50650[(2)] = null);

(statearr_48366_50650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (21))){
var inst_48158 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48377_50652 = state_48283__$1;
(statearr_48377_50652[(2)] = inst_48158);

(statearr_48377_50652[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (31))){
var inst_48194 = (state_48283[(10)]);
var inst_48205 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_48194);
var state_48283__$1 = state_48283;
var statearr_48382_50654 = state_48283__$1;
(statearr_48382_50654[(2)] = inst_48205);

(statearr_48382_50654[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (32))){
var inst_48184 = (state_48283[(9)]);
var inst_48182 = (state_48283[(12)]);
var inst_48181 = (state_48283[(19)]);
var inst_48183 = (state_48283[(20)]);
var inst_48207 = (state_48283[(2)]);
var inst_48209 = (inst_48184 + (1));
var tmp48370 = inst_48182;
var tmp48371 = inst_48181;
var tmp48372 = inst_48183;
var inst_48181__$1 = tmp48371;
var inst_48182__$1 = tmp48370;
var inst_48183__$1 = tmp48372;
var inst_48184__$1 = inst_48209;
var state_48283__$1 = (function (){var statearr_48390 = state_48283;
(statearr_48390[(9)] = inst_48184__$1);

(statearr_48390[(12)] = inst_48182__$1);

(statearr_48390[(21)] = inst_48207);

(statearr_48390[(19)] = inst_48181__$1);

(statearr_48390[(20)] = inst_48183__$1);

return statearr_48390;
})();
var statearr_48395_50663 = state_48283__$1;
(statearr_48395_50663[(2)] = null);

(statearr_48395_50663[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (40))){
var inst_48227 = (state_48283[(22)]);
var inst_48231 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_48227);
var state_48283__$1 = state_48283;
var statearr_48400_50666 = state_48283__$1;
(statearr_48400_50666[(2)] = inst_48231);

(statearr_48400_50666[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (33))){
var inst_48215 = (state_48283[(23)]);
var inst_48220 = cljs.core.chunked_seq_QMARK_(inst_48215);
var state_48283__$1 = state_48283;
if(inst_48220){
var statearr_48406_50671 = state_48283__$1;
(statearr_48406_50671[(1)] = (36));

} else {
var statearr_48411_50673 = state_48283__$1;
(statearr_48411_50673[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (13))){
var inst_48103 = (state_48283[(24)]);
var inst_48109 = cljs.core.async.close_BANG_(inst_48103);
var state_48283__$1 = state_48283;
var statearr_48416_50675 = state_48283__$1;
(statearr_48416_50675[(2)] = inst_48109);

(statearr_48416_50675[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (22))){
var inst_48142 = (state_48283[(8)]);
var inst_48147 = cljs.core.async.close_BANG_(inst_48142);
var state_48283__$1 = state_48283;
var statearr_48422_50676 = state_48283__$1;
(statearr_48422_50676[(2)] = inst_48147);

(statearr_48422_50676[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (36))){
var inst_48215 = (state_48283[(23)]);
var inst_48222 = cljs.core.chunk_first(inst_48215);
var inst_48223 = cljs.core.chunk_rest(inst_48215);
var inst_48224 = cljs.core.count(inst_48222);
var inst_48181 = inst_48223;
var inst_48182 = inst_48222;
var inst_48183 = inst_48224;
var inst_48184 = (0);
var state_48283__$1 = (function (){var statearr_48429 = state_48283;
(statearr_48429[(9)] = inst_48184);

(statearr_48429[(12)] = inst_48182);

(statearr_48429[(19)] = inst_48181);

(statearr_48429[(20)] = inst_48183);

return statearr_48429;
})();
var statearr_48433_50684 = state_48283__$1;
(statearr_48433_50684[(2)] = null);

(statearr_48433_50684[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (41))){
var inst_48215 = (state_48283[(23)]);
var inst_48233 = (state_48283[(2)]);
var inst_48234 = cljs.core.next(inst_48215);
var inst_48181 = inst_48234;
var inst_48182 = null;
var inst_48183 = (0);
var inst_48184 = (0);
var state_48283__$1 = (function (){var statearr_48437 = state_48283;
(statearr_48437[(9)] = inst_48184);

(statearr_48437[(25)] = inst_48233);

(statearr_48437[(12)] = inst_48182);

(statearr_48437[(19)] = inst_48181);

(statearr_48437[(20)] = inst_48183);

return statearr_48437;
})();
var statearr_48443_50695 = state_48283__$1;
(statearr_48443_50695[(2)] = null);

(statearr_48443_50695[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (43))){
var state_48283__$1 = state_48283;
var statearr_48446_50697 = state_48283__$1;
(statearr_48446_50697[(2)] = null);

(statearr_48446_50697[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (29))){
var inst_48242 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48454_50699 = state_48283__$1;
(statearr_48454_50699[(2)] = inst_48242);

(statearr_48454_50699[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (44))){
var inst_48253 = (state_48283[(2)]);
var state_48283__$1 = (function (){var statearr_48460 = state_48283;
(statearr_48460[(26)] = inst_48253);

return statearr_48460;
})();
var statearr_48462_50701 = state_48283__$1;
(statearr_48462_50701[(2)] = null);

(statearr_48462_50701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (6))){
var inst_48172 = (state_48283[(27)]);
var inst_48169 = cljs.core.deref(cs);
var inst_48172__$1 = cljs.core.keys(inst_48169);
var inst_48173 = cljs.core.count(inst_48172__$1);
var inst_48174 = cljs.core.reset_BANG_(dctr,inst_48173);
var inst_48180 = cljs.core.seq(inst_48172__$1);
var inst_48181 = inst_48180;
var inst_48182 = null;
var inst_48183 = (0);
var inst_48184 = (0);
var state_48283__$1 = (function (){var statearr_48468 = state_48283;
(statearr_48468[(9)] = inst_48184);

(statearr_48468[(27)] = inst_48172__$1);

(statearr_48468[(12)] = inst_48182);

(statearr_48468[(28)] = inst_48174);

(statearr_48468[(19)] = inst_48181);

(statearr_48468[(20)] = inst_48183);

return statearr_48468;
})();
var statearr_48469_50710 = state_48283__$1;
(statearr_48469_50710[(2)] = null);

(statearr_48469_50710[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (28))){
var inst_48215 = (state_48283[(23)]);
var inst_48181 = (state_48283[(19)]);
var inst_48215__$1 = cljs.core.seq(inst_48181);
var state_48283__$1 = (function (){var statearr_48470 = state_48283;
(statearr_48470[(23)] = inst_48215__$1);

return statearr_48470;
})();
if(inst_48215__$1){
var statearr_48471_50713 = state_48283__$1;
(statearr_48471_50713[(1)] = (33));

} else {
var statearr_48472_50714 = state_48283__$1;
(statearr_48472_50714[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (25))){
var inst_48184 = (state_48283[(9)]);
var inst_48183 = (state_48283[(20)]);
var inst_48189 = (inst_48184 < inst_48183);
var inst_48190 = inst_48189;
var state_48283__$1 = state_48283;
if(cljs.core.truth_(inst_48190)){
var statearr_48473_50717 = state_48283__$1;
(statearr_48473_50717[(1)] = (27));

} else {
var statearr_48474_50721 = state_48283__$1;
(statearr_48474_50721[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (34))){
var state_48283__$1 = state_48283;
var statearr_48475_50726 = state_48283__$1;
(statearr_48475_50726[(2)] = null);

(statearr_48475_50726[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (17))){
var state_48283__$1 = state_48283;
var statearr_48476_50729 = state_48283__$1;
(statearr_48476_50729[(2)] = null);

(statearr_48476_50729[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (3))){
var inst_48258 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48283__$1,inst_48258);
} else {
if((state_val_48286 === (12))){
var inst_48163 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48477_50732 = state_48283__$1;
(statearr_48477_50732[(2)] = inst_48163);

(statearr_48477_50732[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (2))){
var state_48283__$1 = state_48283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48283__$1,(4),ch);
} else {
if((state_val_48286 === (23))){
var state_48283__$1 = state_48283;
var statearr_48480_50736 = state_48283__$1;
(statearr_48480_50736[(2)] = null);

(statearr_48480_50736[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (35))){
var inst_48240 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48481_50740 = state_48283__$1;
(statearr_48481_50740[(2)] = inst_48240);

(statearr_48481_50740[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (19))){
var inst_48118 = (state_48283[(7)]);
var inst_48127 = cljs.core.chunk_first(inst_48118);
var inst_48130 = cljs.core.chunk_rest(inst_48118);
var inst_48131 = cljs.core.count(inst_48127);
var inst_48085 = inst_48130;
var inst_48086 = inst_48127;
var inst_48087 = inst_48131;
var inst_48088 = (0);
var state_48283__$1 = (function (){var statearr_48484 = state_48283;
(statearr_48484[(13)] = inst_48086);

(statearr_48484[(14)] = inst_48087);

(statearr_48484[(16)] = inst_48088);

(statearr_48484[(17)] = inst_48085);

return statearr_48484;
})();
var statearr_48485_50744 = state_48283__$1;
(statearr_48485_50744[(2)] = null);

(statearr_48485_50744[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (11))){
var inst_48118 = (state_48283[(7)]);
var inst_48085 = (state_48283[(17)]);
var inst_48118__$1 = cljs.core.seq(inst_48085);
var state_48283__$1 = (function (){var statearr_48491 = state_48283;
(statearr_48491[(7)] = inst_48118__$1);

return statearr_48491;
})();
if(inst_48118__$1){
var statearr_48492_50754 = state_48283__$1;
(statearr_48492_50754[(1)] = (16));

} else {
var statearr_48493_50755 = state_48283__$1;
(statearr_48493_50755[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (9))){
var inst_48166 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48494_50758 = state_48283__$1;
(statearr_48494_50758[(2)] = inst_48166);

(statearr_48494_50758[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (5))){
var inst_48083 = cljs.core.deref(cs);
var inst_48084 = cljs.core.seq(inst_48083);
var inst_48085 = inst_48084;
var inst_48086 = null;
var inst_48087 = (0);
var inst_48088 = (0);
var state_48283__$1 = (function (){var statearr_48498 = state_48283;
(statearr_48498[(13)] = inst_48086);

(statearr_48498[(14)] = inst_48087);

(statearr_48498[(16)] = inst_48088);

(statearr_48498[(17)] = inst_48085);

return statearr_48498;
})();
var statearr_48500_50761 = state_48283__$1;
(statearr_48500_50761[(2)] = null);

(statearr_48500_50761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (14))){
var state_48283__$1 = state_48283;
var statearr_48501_50766 = state_48283__$1;
(statearr_48501_50766[(2)] = null);

(statearr_48501_50766[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (45))){
var inst_48250 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48503_50771 = state_48283__$1;
(statearr_48503_50771[(2)] = inst_48250);

(statearr_48503_50771[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (26))){
var inst_48172 = (state_48283[(27)]);
var inst_48244 = (state_48283[(2)]);
var inst_48247 = cljs.core.seq(inst_48172);
var state_48283__$1 = (function (){var statearr_48510 = state_48283;
(statearr_48510[(29)] = inst_48244);

return statearr_48510;
})();
if(inst_48247){
var statearr_48514_50773 = state_48283__$1;
(statearr_48514_50773[(1)] = (42));

} else {
var statearr_48515_50774 = state_48283__$1;
(statearr_48515_50774[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (16))){
var inst_48118 = (state_48283[(7)]);
var inst_48124 = cljs.core.chunked_seq_QMARK_(inst_48118);
var state_48283__$1 = state_48283;
if(inst_48124){
var statearr_48518_50780 = state_48283__$1;
(statearr_48518_50780[(1)] = (19));

} else {
var statearr_48521_50781 = state_48283__$1;
(statearr_48521_50781[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (38))){
var inst_48237 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48525_50788 = state_48283__$1;
(statearr_48525_50788[(2)] = inst_48237);

(statearr_48525_50788[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (30))){
var state_48283__$1 = state_48283;
var statearr_48526_50789 = state_48283__$1;
(statearr_48526_50789[(2)] = null);

(statearr_48526_50789[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (10))){
var inst_48086 = (state_48283[(13)]);
var inst_48088 = (state_48283[(16)]);
var inst_48101 = cljs.core._nth(inst_48086,inst_48088);
var inst_48103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48101,(0),null);
var inst_48104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48101,(1),null);
var state_48283__$1 = (function (){var statearr_48527 = state_48283;
(statearr_48527[(24)] = inst_48103);

return statearr_48527;
})();
if(cljs.core.truth_(inst_48104)){
var statearr_48530_50793 = state_48283__$1;
(statearr_48530_50793[(1)] = (13));

} else {
var statearr_48531_50797 = state_48283__$1;
(statearr_48531_50797[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (18))){
var inst_48161 = (state_48283[(2)]);
var state_48283__$1 = state_48283;
var statearr_48534_50801 = state_48283__$1;
(statearr_48534_50801[(2)] = inst_48161);

(statearr_48534_50801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (42))){
var state_48283__$1 = state_48283;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48283__$1,(45),dchan);
} else {
if((state_val_48286 === (37))){
var inst_48227 = (state_48283[(22)]);
var inst_48070 = (state_48283[(11)]);
var inst_48215 = (state_48283[(23)]);
var inst_48227__$1 = cljs.core.first(inst_48215);
var inst_48228 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_48227__$1,inst_48070,done);
var state_48283__$1 = (function (){var statearr_48540 = state_48283;
(statearr_48540[(22)] = inst_48227__$1);

return statearr_48540;
})();
if(cljs.core.truth_(inst_48228)){
var statearr_48541_50804 = state_48283__$1;
(statearr_48541_50804[(1)] = (39));

} else {
var statearr_48542_50805 = state_48283__$1;
(statearr_48542_50805[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48286 === (8))){
var inst_48087 = (state_48283[(14)]);
var inst_48088 = (state_48283[(16)]);
var inst_48091 = (inst_48088 < inst_48087);
var inst_48093 = inst_48091;
var state_48283__$1 = state_48283;
if(cljs.core.truth_(inst_48093)){
var statearr_48543_50815 = state_48283__$1;
(statearr_48543_50815[(1)] = (10));

} else {
var statearr_48545_50818 = state_48283__$1;
(statearr_48545_50818[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__46572__auto__ = null;
var cljs$core$async$mult_$_state_machine__46572__auto____0 = (function (){
var statearr_48551 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48551[(0)] = cljs$core$async$mult_$_state_machine__46572__auto__);

(statearr_48551[(1)] = (1));

return statearr_48551;
});
var cljs$core$async$mult_$_state_machine__46572__auto____1 = (function (state_48283){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_48283);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e48555){var ex__46575__auto__ = e48555;
var statearr_48557_50825 = state_48283;
(statearr_48557_50825[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_48283[(4)]))){
var statearr_48559_50827 = state_48283;
(statearr_48559_50827[(1)] = cljs.core.first((state_48283[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50831 = state_48283;
state_48283 = G__50831;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__46572__auto__ = function(state_48283){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__46572__auto____1.call(this,state_48283);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__46572__auto____0;
cljs$core$async$mult_$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__46572__auto____1;
return cljs$core$async$mult_$_state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_48566 = f__47012__auto__();
(statearr_48566[(6)] = c__47011__auto___50608);

return statearr_48566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__48572 = arguments.length;
switch (G__48572) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_50842 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_50842(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_50846 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_50846(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_50849 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_50849(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_50852 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_50852(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_50857 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_50857(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50861 = arguments.length;
var i__4737__auto___50862 = (0);
while(true){
if((i__4737__auto___50862 < len__4736__auto___50861)){
args__4742__auto__.push((arguments[i__4737__auto___50862]));

var G__50863 = (i__4737__auto___50862 + (1));
i__4737__auto___50862 = G__50863;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__48710){
var map__48712 = p__48710;
var map__48712__$1 = (((((!((map__48712 == null))))?(((((map__48712.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48712.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__48712):map__48712);
var opts = map__48712__$1;
var statearr_48720_50866 = state;
(statearr_48720_50866[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_48721_50867 = state;
(statearr_48721_50867[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_48722_50868 = state;
(statearr_48722_50868[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq48690){
var G__48691 = cljs.core.first(seq48690);
var seq48690__$1 = cljs.core.next(seq48690);
var G__48693 = cljs.core.first(seq48690__$1);
var seq48690__$2 = cljs.core.next(seq48690__$1);
var G__48694 = cljs.core.first(seq48690__$2);
var seq48690__$3 = cljs.core.next(seq48690__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__48691,G__48693,G__48694,seq48690__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48727 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48727 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta48728){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta48728 = meta48728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48729,meta48728__$1){
var self__ = this;
var _48729__$1 = this;
return (new cljs.core.async.t_cljs$core$async48727(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta48728__$1));
}));

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48729){
var self__ = this;
var _48729__$1 = this;
return self__.meta48728;
}));

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48727.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async48727.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta48728","meta48728",2038255565,null)], null);
}));

(cljs.core.async.t_cljs$core$async48727.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48727.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48727");

(cljs.core.async.t_cljs$core$async48727.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48727");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48727.
 */
cljs.core.async.__GT_t_cljs$core$async48727 = (function cljs$core$async$mix_$___GT_t_cljs$core$async48727(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta48728){
return (new cljs.core.async.t_cljs$core$async48727(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta48728));
});

}

return (new cljs.core.async.t_cljs$core$async48727(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47011__auto___50912 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_48859){
var state_val_48860 = (state_48859[(1)]);
if((state_val_48860 === (7))){
var inst_48765 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
var statearr_48865_50913 = state_48859__$1;
(statearr_48865_50913[(2)] = inst_48765);

(statearr_48865_50913[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (20))){
var inst_48777 = (state_48859[(7)]);
var state_48859__$1 = state_48859;
var statearr_48866_50914 = state_48859__$1;
(statearr_48866_50914[(2)] = inst_48777);

(statearr_48866_50914[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (27))){
var state_48859__$1 = state_48859;
var statearr_48868_50915 = state_48859__$1;
(statearr_48868_50915[(2)] = null);

(statearr_48868_50915[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (1))){
var inst_48751 = (state_48859[(8)]);
var inst_48751__$1 = calc_state();
var inst_48753 = (inst_48751__$1 == null);
var inst_48754 = cljs.core.not(inst_48753);
var state_48859__$1 = (function (){var statearr_48876 = state_48859;
(statearr_48876[(8)] = inst_48751__$1);

return statearr_48876;
})();
if(inst_48754){
var statearr_48881_50918 = state_48859__$1;
(statearr_48881_50918[(1)] = (2));

} else {
var statearr_48883_50919 = state_48859__$1;
(statearr_48883_50919[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (24))){
var inst_48802 = (state_48859[(9)]);
var inst_48812 = (state_48859[(10)]);
var inst_48827 = (state_48859[(11)]);
var inst_48827__$1 = (inst_48802.cljs$core$IFn$_invoke$arity$1 ? inst_48802.cljs$core$IFn$_invoke$arity$1(inst_48812) : inst_48802.call(null,inst_48812));
var state_48859__$1 = (function (){var statearr_48887 = state_48859;
(statearr_48887[(11)] = inst_48827__$1);

return statearr_48887;
})();
if(cljs.core.truth_(inst_48827__$1)){
var statearr_48890_50925 = state_48859__$1;
(statearr_48890_50925[(1)] = (29));

} else {
var statearr_48892_50929 = state_48859__$1;
(statearr_48892_50929[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (4))){
var inst_48768 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
if(cljs.core.truth_(inst_48768)){
var statearr_48893_50931 = state_48859__$1;
(statearr_48893_50931[(1)] = (8));

} else {
var statearr_48894_50932 = state_48859__$1;
(statearr_48894_50932[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (15))){
var inst_48796 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
if(cljs.core.truth_(inst_48796)){
var statearr_48895_50934 = state_48859__$1;
(statearr_48895_50934[(1)] = (19));

} else {
var statearr_48896_50935 = state_48859__$1;
(statearr_48896_50935[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (21))){
var inst_48801 = (state_48859[(12)]);
var inst_48801__$1 = (state_48859[(2)]);
var inst_48802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48801__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48801__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48801__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_48859__$1 = (function (){var statearr_48899 = state_48859;
(statearr_48899[(13)] = inst_48803);

(statearr_48899[(9)] = inst_48802);

(statearr_48899[(12)] = inst_48801__$1);

return statearr_48899;
})();
return cljs.core.async.ioc_alts_BANG_(state_48859__$1,(22),inst_48804);
} else {
if((state_val_48860 === (31))){
var inst_48836 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
if(cljs.core.truth_(inst_48836)){
var statearr_48902_50942 = state_48859__$1;
(statearr_48902_50942[(1)] = (32));

} else {
var statearr_48903_50943 = state_48859__$1;
(statearr_48903_50943[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (32))){
var inst_48811 = (state_48859[(14)]);
var state_48859__$1 = state_48859;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48859__$1,(35),out,inst_48811);
} else {
if((state_val_48860 === (33))){
var inst_48801 = (state_48859[(12)]);
var inst_48777 = inst_48801;
var state_48859__$1 = (function (){var statearr_48905 = state_48859;
(statearr_48905[(7)] = inst_48777);

return statearr_48905;
})();
var statearr_48906_50948 = state_48859__$1;
(statearr_48906_50948[(2)] = null);

(statearr_48906_50948[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (13))){
var inst_48777 = (state_48859[(7)]);
var inst_48785 = inst_48777.cljs$lang$protocol_mask$partition0$;
var inst_48786 = (inst_48785 & (64));
var inst_48787 = inst_48777.cljs$core$ISeq$;
var inst_48788 = (cljs.core.PROTOCOL_SENTINEL === inst_48787);
var inst_48789 = ((inst_48786) || (inst_48788));
var state_48859__$1 = state_48859;
if(cljs.core.truth_(inst_48789)){
var statearr_48907_50950 = state_48859__$1;
(statearr_48907_50950[(1)] = (16));

} else {
var statearr_48908_50951 = state_48859__$1;
(statearr_48908_50951[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (22))){
var inst_48812 = (state_48859[(10)]);
var inst_48811 = (state_48859[(14)]);
var inst_48810 = (state_48859[(2)]);
var inst_48811__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48810,(0),null);
var inst_48812__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48810,(1),null);
var inst_48813 = (inst_48811__$1 == null);
var inst_48815 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48812__$1,change);
var inst_48816 = ((inst_48813) || (inst_48815));
var state_48859__$1 = (function (){var statearr_48912 = state_48859;
(statearr_48912[(10)] = inst_48812__$1);

(statearr_48912[(14)] = inst_48811__$1);

return statearr_48912;
})();
if(cljs.core.truth_(inst_48816)){
var statearr_48913_50960 = state_48859__$1;
(statearr_48913_50960[(1)] = (23));

} else {
var statearr_48914_50961 = state_48859__$1;
(statearr_48914_50961[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (36))){
var inst_48801 = (state_48859[(12)]);
var inst_48777 = inst_48801;
var state_48859__$1 = (function (){var statearr_48917 = state_48859;
(statearr_48917[(7)] = inst_48777);

return statearr_48917;
})();
var statearr_48919_50963 = state_48859__$1;
(statearr_48919_50963[(2)] = null);

(statearr_48919_50963[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (29))){
var inst_48827 = (state_48859[(11)]);
var state_48859__$1 = state_48859;
var statearr_48921_50965 = state_48859__$1;
(statearr_48921_50965[(2)] = inst_48827);

(statearr_48921_50965[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (6))){
var state_48859__$1 = state_48859;
var statearr_48922_50970 = state_48859__$1;
(statearr_48922_50970[(2)] = false);

(statearr_48922_50970[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (28))){
var inst_48823 = (state_48859[(2)]);
var inst_48824 = calc_state();
var inst_48777 = inst_48824;
var state_48859__$1 = (function (){var statearr_48924 = state_48859;
(statearr_48924[(15)] = inst_48823);

(statearr_48924[(7)] = inst_48777);

return statearr_48924;
})();
var statearr_48925_50975 = state_48859__$1;
(statearr_48925_50975[(2)] = null);

(statearr_48925_50975[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (25))){
var inst_48850 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
var statearr_48926_50976 = state_48859__$1;
(statearr_48926_50976[(2)] = inst_48850);

(statearr_48926_50976[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (34))){
var inst_48848 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
var statearr_48927_50977 = state_48859__$1;
(statearr_48927_50977[(2)] = inst_48848);

(statearr_48927_50977[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (17))){
var state_48859__$1 = state_48859;
var statearr_48929_50979 = state_48859__$1;
(statearr_48929_50979[(2)] = false);

(statearr_48929_50979[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (3))){
var state_48859__$1 = state_48859;
var statearr_48934_50980 = state_48859__$1;
(statearr_48934_50980[(2)] = false);

(statearr_48934_50980[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (12))){
var inst_48852 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48859__$1,inst_48852);
} else {
if((state_val_48860 === (2))){
var inst_48751 = (state_48859[(8)]);
var inst_48757 = inst_48751.cljs$lang$protocol_mask$partition0$;
var inst_48758 = (inst_48757 & (64));
var inst_48759 = inst_48751.cljs$core$ISeq$;
var inst_48760 = (cljs.core.PROTOCOL_SENTINEL === inst_48759);
var inst_48761 = ((inst_48758) || (inst_48760));
var state_48859__$1 = state_48859;
if(cljs.core.truth_(inst_48761)){
var statearr_48938_50985 = state_48859__$1;
(statearr_48938_50985[(1)] = (5));

} else {
var statearr_48940_50986 = state_48859__$1;
(statearr_48940_50986[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (23))){
var inst_48811 = (state_48859[(14)]);
var inst_48818 = (inst_48811 == null);
var state_48859__$1 = state_48859;
if(cljs.core.truth_(inst_48818)){
var statearr_48941_50990 = state_48859__$1;
(statearr_48941_50990[(1)] = (26));

} else {
var statearr_48942_50991 = state_48859__$1;
(statearr_48942_50991[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (35))){
var inst_48839 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
if(cljs.core.truth_(inst_48839)){
var statearr_48944_50993 = state_48859__$1;
(statearr_48944_50993[(1)] = (36));

} else {
var statearr_48948_50994 = state_48859__$1;
(statearr_48948_50994[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (19))){
var inst_48777 = (state_48859[(7)]);
var inst_48798 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_48777);
var state_48859__$1 = state_48859;
var statearr_48952_50998 = state_48859__$1;
(statearr_48952_50998[(2)] = inst_48798);

(statearr_48952_50998[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (11))){
var inst_48777 = (state_48859[(7)]);
var inst_48782 = (inst_48777 == null);
var inst_48783 = cljs.core.not(inst_48782);
var state_48859__$1 = state_48859;
if(inst_48783){
var statearr_48955_51000 = state_48859__$1;
(statearr_48955_51000[(1)] = (13));

} else {
var statearr_48956_51002 = state_48859__$1;
(statearr_48956_51002[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (9))){
var inst_48751 = (state_48859[(8)]);
var state_48859__$1 = state_48859;
var statearr_48957_51006 = state_48859__$1;
(statearr_48957_51006[(2)] = inst_48751);

(statearr_48957_51006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (5))){
var state_48859__$1 = state_48859;
var statearr_48960_51007 = state_48859__$1;
(statearr_48960_51007[(2)] = true);

(statearr_48960_51007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (14))){
var state_48859__$1 = state_48859;
var statearr_48962_51008 = state_48859__$1;
(statearr_48962_51008[(2)] = false);

(statearr_48962_51008[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (26))){
var inst_48812 = (state_48859[(10)]);
var inst_48820 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_48812);
var state_48859__$1 = state_48859;
var statearr_48965_51011 = state_48859__$1;
(statearr_48965_51011[(2)] = inst_48820);

(statearr_48965_51011[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (16))){
var state_48859__$1 = state_48859;
var statearr_48968_51016 = state_48859__$1;
(statearr_48968_51016[(2)] = true);

(statearr_48968_51016[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (38))){
var inst_48844 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
var statearr_48969_51018 = state_48859__$1;
(statearr_48969_51018[(2)] = inst_48844);

(statearr_48969_51018[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (30))){
var inst_48803 = (state_48859[(13)]);
var inst_48802 = (state_48859[(9)]);
var inst_48812 = (state_48859[(10)]);
var inst_48831 = cljs.core.empty_QMARK_(inst_48802);
var inst_48832 = (inst_48803.cljs$core$IFn$_invoke$arity$1 ? inst_48803.cljs$core$IFn$_invoke$arity$1(inst_48812) : inst_48803.call(null,inst_48812));
var inst_48833 = cljs.core.not(inst_48832);
var inst_48834 = ((inst_48831) && (inst_48833));
var state_48859__$1 = state_48859;
var statearr_48974_51023 = state_48859__$1;
(statearr_48974_51023[(2)] = inst_48834);

(statearr_48974_51023[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (10))){
var inst_48751 = (state_48859[(8)]);
var inst_48773 = (state_48859[(2)]);
var inst_48774 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48773,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_48775 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48773,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_48776 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48773,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_48777 = inst_48751;
var state_48859__$1 = (function (){var statearr_48975 = state_48859;
(statearr_48975[(16)] = inst_48774);

(statearr_48975[(17)] = inst_48775);

(statearr_48975[(18)] = inst_48776);

(statearr_48975[(7)] = inst_48777);

return statearr_48975;
})();
var statearr_48977_51028 = state_48859__$1;
(statearr_48977_51028[(2)] = null);

(statearr_48977_51028[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (18))){
var inst_48793 = (state_48859[(2)]);
var state_48859__$1 = state_48859;
var statearr_48981_51032 = state_48859__$1;
(statearr_48981_51032[(2)] = inst_48793);

(statearr_48981_51032[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (37))){
var state_48859__$1 = state_48859;
var statearr_48983_51034 = state_48859__$1;
(statearr_48983_51034[(2)] = null);

(statearr_48983_51034[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48860 === (8))){
var inst_48751 = (state_48859[(8)]);
var inst_48770 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_48751);
var state_48859__$1 = state_48859;
var statearr_48984_51037 = state_48859__$1;
(statearr_48984_51037[(2)] = inst_48770);

(statearr_48984_51037[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__46572__auto__ = null;
var cljs$core$async$mix_$_state_machine__46572__auto____0 = (function (){
var statearr_48989 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48989[(0)] = cljs$core$async$mix_$_state_machine__46572__auto__);

(statearr_48989[(1)] = (1));

return statearr_48989;
});
var cljs$core$async$mix_$_state_machine__46572__auto____1 = (function (state_48859){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_48859);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e48993){var ex__46575__auto__ = e48993;
var statearr_48994_51044 = state_48859;
(statearr_48994_51044[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_48859[(4)]))){
var statearr_48995_51047 = state_48859;
(statearr_48995_51047[(1)] = cljs.core.first((state_48859[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51050 = state_48859;
state_48859 = G__51050;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__46572__auto__ = function(state_48859){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__46572__auto____1.call(this,state_48859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__46572__auto____0;
cljs$core$async$mix_$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__46572__auto____1;
return cljs$core$async$mix_$_state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_48999 = f__47012__auto__();
(statearr_48999[(6)] = c__47011__auto___50912);

return statearr_48999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_51055 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_51055(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_51060 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_51060(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_51066 = (function() {
var G__51067 = null;
var G__51067__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__51067__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__51067 = function(p,v){
switch(arguments.length){
case 1:
return G__51067__1.call(this,p);
case 2:
return G__51067__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__51067.cljs$core$IFn$_invoke$arity$1 = G__51067__1;
G__51067.cljs$core$IFn$_invoke$arity$2 = G__51067__2;
return G__51067;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__49038 = arguments.length;
switch (G__49038) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_51066(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_51066(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__49049 = arguments.length;
switch (G__49049) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__49042_SHARP_){
if(cljs.core.truth_((p1__49042_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__49042_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__49042_SHARP_.call(null,topic)))){
return p1__49042_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__49042_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49062 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49062 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta49063){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta49063 = meta49063;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49064,meta49063__$1){
var self__ = this;
var _49064__$1 = this;
return (new cljs.core.async.t_cljs$core$async49062(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta49063__$1));
}));

(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49064){
var self__ = this;
var _49064__$1 = this;
return self__.meta49063;
}));

(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async49062.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async49062.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta49063","meta49063",-516481606,null)], null);
}));

(cljs.core.async.t_cljs$core$async49062.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49062.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49062");

(cljs.core.async.t_cljs$core$async49062.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49062");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49062.
 */
cljs.core.async.__GT_t_cljs$core$async49062 = (function cljs$core$async$__GT_t_cljs$core$async49062(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta49063){
return (new cljs.core.async.t_cljs$core$async49062(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta49063));
});

}

return (new cljs.core.async.t_cljs$core$async49062(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__47011__auto___51105 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_49159){
var state_val_49160 = (state_49159[(1)]);
if((state_val_49160 === (7))){
var inst_49154 = (state_49159[(2)]);
var state_49159__$1 = state_49159;
var statearr_49162_51107 = state_49159__$1;
(statearr_49162_51107[(2)] = inst_49154);

(statearr_49162_51107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (20))){
var state_49159__$1 = state_49159;
var statearr_49163_51108 = state_49159__$1;
(statearr_49163_51108[(2)] = null);

(statearr_49163_51108[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (1))){
var state_49159__$1 = state_49159;
var statearr_49166_51111 = state_49159__$1;
(statearr_49166_51111[(2)] = null);

(statearr_49166_51111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (24))){
var inst_49137 = (state_49159[(7)]);
var inst_49146 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_49137);
var state_49159__$1 = state_49159;
var statearr_49169_51114 = state_49159__$1;
(statearr_49169_51114[(2)] = inst_49146);

(statearr_49169_51114[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (4))){
var inst_49089 = (state_49159[(8)]);
var inst_49089__$1 = (state_49159[(2)]);
var inst_49090 = (inst_49089__$1 == null);
var state_49159__$1 = (function (){var statearr_49173 = state_49159;
(statearr_49173[(8)] = inst_49089__$1);

return statearr_49173;
})();
if(cljs.core.truth_(inst_49090)){
var statearr_49174_51116 = state_49159__$1;
(statearr_49174_51116[(1)] = (5));

} else {
var statearr_49175_51117 = state_49159__$1;
(statearr_49175_51117[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (15))){
var inst_49131 = (state_49159[(2)]);
var state_49159__$1 = state_49159;
var statearr_49177_51120 = state_49159__$1;
(statearr_49177_51120[(2)] = inst_49131);

(statearr_49177_51120[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (21))){
var inst_49151 = (state_49159[(2)]);
var state_49159__$1 = (function (){var statearr_49178 = state_49159;
(statearr_49178[(9)] = inst_49151);

return statearr_49178;
})();
var statearr_49179_51124 = state_49159__$1;
(statearr_49179_51124[(2)] = null);

(statearr_49179_51124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (13))){
var inst_49113 = (state_49159[(10)]);
var inst_49115 = cljs.core.chunked_seq_QMARK_(inst_49113);
var state_49159__$1 = state_49159;
if(inst_49115){
var statearr_49180_51126 = state_49159__$1;
(statearr_49180_51126[(1)] = (16));

} else {
var statearr_49181_51127 = state_49159__$1;
(statearr_49181_51127[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (22))){
var inst_49143 = (state_49159[(2)]);
var state_49159__$1 = state_49159;
if(cljs.core.truth_(inst_49143)){
var statearr_49183_51129 = state_49159__$1;
(statearr_49183_51129[(1)] = (23));

} else {
var statearr_49184_51130 = state_49159__$1;
(statearr_49184_51130[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (6))){
var inst_49139 = (state_49159[(11)]);
var inst_49137 = (state_49159[(7)]);
var inst_49089 = (state_49159[(8)]);
var inst_49137__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_49089) : topic_fn.call(null,inst_49089));
var inst_49138 = cljs.core.deref(mults);
var inst_49139__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49138,inst_49137__$1);
var state_49159__$1 = (function (){var statearr_49191 = state_49159;
(statearr_49191[(11)] = inst_49139__$1);

(statearr_49191[(7)] = inst_49137__$1);

return statearr_49191;
})();
if(cljs.core.truth_(inst_49139__$1)){
var statearr_49192_51131 = state_49159__$1;
(statearr_49192_51131[(1)] = (19));

} else {
var statearr_49193_51132 = state_49159__$1;
(statearr_49193_51132[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (25))){
var inst_49148 = (state_49159[(2)]);
var state_49159__$1 = state_49159;
var statearr_49195_51133 = state_49159__$1;
(statearr_49195_51133[(2)] = inst_49148);

(statearr_49195_51133[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (17))){
var inst_49113 = (state_49159[(10)]);
var inst_49122 = cljs.core.first(inst_49113);
var inst_49123 = cljs.core.async.muxch_STAR_(inst_49122);
var inst_49124 = cljs.core.async.close_BANG_(inst_49123);
var inst_49125 = cljs.core.next(inst_49113);
var inst_49099 = inst_49125;
var inst_49100 = null;
var inst_49101 = (0);
var inst_49102 = (0);
var state_49159__$1 = (function (){var statearr_49198 = state_49159;
(statearr_49198[(12)] = inst_49099);

(statearr_49198[(13)] = inst_49100);

(statearr_49198[(14)] = inst_49124);

(statearr_49198[(15)] = inst_49101);

(statearr_49198[(16)] = inst_49102);

return statearr_49198;
})();
var statearr_49202_51139 = state_49159__$1;
(statearr_49202_51139[(2)] = null);

(statearr_49202_51139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (3))){
var inst_49156 = (state_49159[(2)]);
var state_49159__$1 = state_49159;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49159__$1,inst_49156);
} else {
if((state_val_49160 === (12))){
var inst_49133 = (state_49159[(2)]);
var state_49159__$1 = state_49159;
var statearr_49203_51140 = state_49159__$1;
(statearr_49203_51140[(2)] = inst_49133);

(statearr_49203_51140[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (2))){
var state_49159__$1 = state_49159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49159__$1,(4),ch);
} else {
if((state_val_49160 === (23))){
var state_49159__$1 = state_49159;
var statearr_49204_51141 = state_49159__$1;
(statearr_49204_51141[(2)] = null);

(statearr_49204_51141[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (19))){
var inst_49139 = (state_49159[(11)]);
var inst_49089 = (state_49159[(8)]);
var inst_49141 = cljs.core.async.muxch_STAR_(inst_49139);
var state_49159__$1 = state_49159;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49159__$1,(22),inst_49141,inst_49089);
} else {
if((state_val_49160 === (11))){
var inst_49099 = (state_49159[(12)]);
var inst_49113 = (state_49159[(10)]);
var inst_49113__$1 = cljs.core.seq(inst_49099);
var state_49159__$1 = (function (){var statearr_49205 = state_49159;
(statearr_49205[(10)] = inst_49113__$1);

return statearr_49205;
})();
if(inst_49113__$1){
var statearr_49206_51142 = state_49159__$1;
(statearr_49206_51142[(1)] = (13));

} else {
var statearr_49207_51143 = state_49159__$1;
(statearr_49207_51143[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (9))){
var inst_49135 = (state_49159[(2)]);
var state_49159__$1 = state_49159;
var statearr_49208_51146 = state_49159__$1;
(statearr_49208_51146[(2)] = inst_49135);

(statearr_49208_51146[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (5))){
var inst_49096 = cljs.core.deref(mults);
var inst_49097 = cljs.core.vals(inst_49096);
var inst_49098 = cljs.core.seq(inst_49097);
var inst_49099 = inst_49098;
var inst_49100 = null;
var inst_49101 = (0);
var inst_49102 = (0);
var state_49159__$1 = (function (){var statearr_49209 = state_49159;
(statearr_49209[(12)] = inst_49099);

(statearr_49209[(13)] = inst_49100);

(statearr_49209[(15)] = inst_49101);

(statearr_49209[(16)] = inst_49102);

return statearr_49209;
})();
var statearr_49210_51153 = state_49159__$1;
(statearr_49210_51153[(2)] = null);

(statearr_49210_51153[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (14))){
var state_49159__$1 = state_49159;
var statearr_49218_51155 = state_49159__$1;
(statearr_49218_51155[(2)] = null);

(statearr_49218_51155[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (16))){
var inst_49113 = (state_49159[(10)]);
var inst_49117 = cljs.core.chunk_first(inst_49113);
var inst_49118 = cljs.core.chunk_rest(inst_49113);
var inst_49119 = cljs.core.count(inst_49117);
var inst_49099 = inst_49118;
var inst_49100 = inst_49117;
var inst_49101 = inst_49119;
var inst_49102 = (0);
var state_49159__$1 = (function (){var statearr_49219 = state_49159;
(statearr_49219[(12)] = inst_49099);

(statearr_49219[(13)] = inst_49100);

(statearr_49219[(15)] = inst_49101);

(statearr_49219[(16)] = inst_49102);

return statearr_49219;
})();
var statearr_49221_51160 = state_49159__$1;
(statearr_49221_51160[(2)] = null);

(statearr_49221_51160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (10))){
var inst_49099 = (state_49159[(12)]);
var inst_49100 = (state_49159[(13)]);
var inst_49101 = (state_49159[(15)]);
var inst_49102 = (state_49159[(16)]);
var inst_49107 = cljs.core._nth(inst_49100,inst_49102);
var inst_49108 = cljs.core.async.muxch_STAR_(inst_49107);
var inst_49109 = cljs.core.async.close_BANG_(inst_49108);
var inst_49110 = (inst_49102 + (1));
var tmp49211 = inst_49099;
var tmp49212 = inst_49100;
var tmp49213 = inst_49101;
var inst_49099__$1 = tmp49211;
var inst_49100__$1 = tmp49212;
var inst_49101__$1 = tmp49213;
var inst_49102__$1 = inst_49110;
var state_49159__$1 = (function (){var statearr_49224 = state_49159;
(statearr_49224[(17)] = inst_49109);

(statearr_49224[(12)] = inst_49099__$1);

(statearr_49224[(13)] = inst_49100__$1);

(statearr_49224[(15)] = inst_49101__$1);

(statearr_49224[(16)] = inst_49102__$1);

return statearr_49224;
})();
var statearr_49225_51161 = state_49159__$1;
(statearr_49225_51161[(2)] = null);

(statearr_49225_51161[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (18))){
var inst_49128 = (state_49159[(2)]);
var state_49159__$1 = state_49159;
var statearr_49227_51165 = state_49159__$1;
(statearr_49227_51165[(2)] = inst_49128);

(statearr_49227_51165[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49160 === (8))){
var inst_49101 = (state_49159[(15)]);
var inst_49102 = (state_49159[(16)]);
var inst_49104 = (inst_49102 < inst_49101);
var inst_49105 = inst_49104;
var state_49159__$1 = state_49159;
if(cljs.core.truth_(inst_49105)){
var statearr_49230_51168 = state_49159__$1;
(statearr_49230_51168[(1)] = (10));

} else {
var statearr_49232_51169 = state_49159__$1;
(statearr_49232_51169[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_49235 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49235[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_49235[(1)] = (1));

return statearr_49235;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_49159){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_49159);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e49237){var ex__46575__auto__ = e49237;
var statearr_49238_51174 = state_49159;
(statearr_49238_51174[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_49159[(4)]))){
var statearr_49239_51176 = state_49159;
(statearr_49239_51176[(1)] = cljs.core.first((state_49159[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51178 = state_49159;
state_49159 = G__51178;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_49159){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_49159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_49242 = f__47012__auto__();
(statearr_49242[(6)] = c__47011__auto___51105);

return statearr_49242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__49245 = arguments.length;
switch (G__49245) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__49267 = arguments.length;
switch (G__49267) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__49275 = arguments.length;
switch (G__49275) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__47011__auto___51196 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_49338){
var state_val_49339 = (state_49338[(1)]);
if((state_val_49339 === (7))){
var state_49338__$1 = state_49338;
var statearr_49342_51198 = state_49338__$1;
(statearr_49342_51198[(2)] = null);

(statearr_49342_51198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (1))){
var state_49338__$1 = state_49338;
var statearr_49343_51200 = state_49338__$1;
(statearr_49343_51200[(2)] = null);

(statearr_49343_51200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (4))){
var inst_49285 = (state_49338[(7)]);
var inst_49286 = (state_49338[(8)]);
var inst_49288 = (inst_49286 < inst_49285);
var state_49338__$1 = state_49338;
if(cljs.core.truth_(inst_49288)){
var statearr_49346_51201 = state_49338__$1;
(statearr_49346_51201[(1)] = (6));

} else {
var statearr_49347_51202 = state_49338__$1;
(statearr_49347_51202[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (15))){
var inst_49322 = (state_49338[(9)]);
var inst_49328 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_49322);
var state_49338__$1 = state_49338;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49338__$1,(17),out,inst_49328);
} else {
if((state_val_49339 === (13))){
var inst_49322 = (state_49338[(9)]);
var inst_49322__$1 = (state_49338[(2)]);
var inst_49323 = cljs.core.some(cljs.core.nil_QMARK_,inst_49322__$1);
var state_49338__$1 = (function (){var statearr_49348 = state_49338;
(statearr_49348[(9)] = inst_49322__$1);

return statearr_49348;
})();
if(cljs.core.truth_(inst_49323)){
var statearr_49350_51203 = state_49338__$1;
(statearr_49350_51203[(1)] = (14));

} else {
var statearr_49351_51204 = state_49338__$1;
(statearr_49351_51204[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (6))){
var state_49338__$1 = state_49338;
var statearr_49353_51206 = state_49338__$1;
(statearr_49353_51206[(2)] = null);

(statearr_49353_51206[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (17))){
var inst_49330 = (state_49338[(2)]);
var state_49338__$1 = (function (){var statearr_49365 = state_49338;
(statearr_49365[(10)] = inst_49330);

return statearr_49365;
})();
var statearr_49366_51211 = state_49338__$1;
(statearr_49366_51211[(2)] = null);

(statearr_49366_51211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (3))){
var inst_49335 = (state_49338[(2)]);
var state_49338__$1 = state_49338;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49338__$1,inst_49335);
} else {
if((state_val_49339 === (12))){
var _ = (function (){var statearr_49367 = state_49338;
(statearr_49367[(4)] = cljs.core.rest((state_49338[(4)])));

return statearr_49367;
})();
var state_49338__$1 = state_49338;
var ex49361 = (state_49338__$1[(2)]);
var statearr_49369_51214 = state_49338__$1;
(statearr_49369_51214[(5)] = ex49361);


if((ex49361 instanceof Object)){
var statearr_49373_51216 = state_49338__$1;
(statearr_49373_51216[(1)] = (11));

(statearr_49373_51216[(5)] = null);

} else {
throw ex49361;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (2))){
var inst_49284 = cljs.core.reset_BANG_(dctr,cnt);
var inst_49285 = cnt;
var inst_49286 = (0);
var state_49338__$1 = (function (){var statearr_49377 = state_49338;
(statearr_49377[(7)] = inst_49285);

(statearr_49377[(11)] = inst_49284);

(statearr_49377[(8)] = inst_49286);

return statearr_49377;
})();
var statearr_49378_51221 = state_49338__$1;
(statearr_49378_51221[(2)] = null);

(statearr_49378_51221[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (11))){
var inst_49298 = (state_49338[(2)]);
var inst_49299 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_49338__$1 = (function (){var statearr_49379 = state_49338;
(statearr_49379[(12)] = inst_49298);

return statearr_49379;
})();
var statearr_49380_51228 = state_49338__$1;
(statearr_49380_51228[(2)] = inst_49299);

(statearr_49380_51228[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (9))){
var inst_49286 = (state_49338[(8)]);
var _ = (function (){var statearr_49383 = state_49338;
(statearr_49383[(4)] = cljs.core.cons((12),(state_49338[(4)])));

return statearr_49383;
})();
var inst_49306 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_49286) : chs__$1.call(null,inst_49286));
var inst_49307 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_49286) : done.call(null,inst_49286));
var inst_49308 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_49306,inst_49307);
var ___$1 = (function (){var statearr_49384 = state_49338;
(statearr_49384[(4)] = cljs.core.rest((state_49338[(4)])));

return statearr_49384;
})();
var state_49338__$1 = state_49338;
var statearr_49385_51233 = state_49338__$1;
(statearr_49385_51233[(2)] = inst_49308);

(statearr_49385_51233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (5))){
var inst_49319 = (state_49338[(2)]);
var state_49338__$1 = (function (){var statearr_49386 = state_49338;
(statearr_49386[(13)] = inst_49319);

return statearr_49386;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49338__$1,(13),dchan);
} else {
if((state_val_49339 === (14))){
var inst_49326 = cljs.core.async.close_BANG_(out);
var state_49338__$1 = state_49338;
var statearr_49389_51243 = state_49338__$1;
(statearr_49389_51243[(2)] = inst_49326);

(statearr_49389_51243[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (16))){
var inst_49333 = (state_49338[(2)]);
var state_49338__$1 = state_49338;
var statearr_49390_51247 = state_49338__$1;
(statearr_49390_51247[(2)] = inst_49333);

(statearr_49390_51247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (10))){
var inst_49286 = (state_49338[(8)]);
var inst_49311 = (state_49338[(2)]);
var inst_49313 = (inst_49286 + (1));
var inst_49286__$1 = inst_49313;
var state_49338__$1 = (function (){var statearr_49392 = state_49338;
(statearr_49392[(14)] = inst_49311);

(statearr_49392[(8)] = inst_49286__$1);

return statearr_49392;
})();
var statearr_49397_51250 = state_49338__$1;
(statearr_49397_51250[(2)] = null);

(statearr_49397_51250[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49339 === (8))){
var inst_49317 = (state_49338[(2)]);
var state_49338__$1 = state_49338;
var statearr_49400_51253 = state_49338__$1;
(statearr_49400_51253[(2)] = inst_49317);

(statearr_49400_51253[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_49401 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49401[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_49401[(1)] = (1));

return statearr_49401;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_49338){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_49338);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e49402){var ex__46575__auto__ = e49402;
var statearr_49404_51256 = state_49338;
(statearr_49404_51256[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_49338[(4)]))){
var statearr_49405_51258 = state_49338;
(statearr_49405_51258[(1)] = cljs.core.first((state_49338[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51260 = state_49338;
state_49338 = G__51260;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_49338){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_49338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_49408 = f__47012__auto__();
(statearr_49408[(6)] = c__47011__auto___51196);

return statearr_49408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__49414 = arguments.length;
switch (G__49414) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47011__auto___51271 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_49454){
var state_val_49456 = (state_49454[(1)]);
if((state_val_49456 === (7))){
var inst_49430 = (state_49454[(7)]);
var inst_49433 = (state_49454[(8)]);
var inst_49430__$1 = (state_49454[(2)]);
var inst_49433__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49430__$1,(0),null);
var inst_49434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_49430__$1,(1),null);
var inst_49435 = (inst_49433__$1 == null);
var state_49454__$1 = (function (){var statearr_49466 = state_49454;
(statearr_49466[(9)] = inst_49434);

(statearr_49466[(7)] = inst_49430__$1);

(statearr_49466[(8)] = inst_49433__$1);

return statearr_49466;
})();
if(cljs.core.truth_(inst_49435)){
var statearr_49467_51276 = state_49454__$1;
(statearr_49467_51276[(1)] = (8));

} else {
var statearr_49468_51278 = state_49454__$1;
(statearr_49468_51278[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49456 === (1))){
var inst_49420 = cljs.core.vec(chs);
var inst_49421 = inst_49420;
var state_49454__$1 = (function (){var statearr_49472 = state_49454;
(statearr_49472[(10)] = inst_49421);

return statearr_49472;
})();
var statearr_49473_51280 = state_49454__$1;
(statearr_49473_51280[(2)] = null);

(statearr_49473_51280[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49456 === (4))){
var inst_49421 = (state_49454[(10)]);
var state_49454__$1 = state_49454;
return cljs.core.async.ioc_alts_BANG_(state_49454__$1,(7),inst_49421);
} else {
if((state_val_49456 === (6))){
var inst_49450 = (state_49454[(2)]);
var state_49454__$1 = state_49454;
var statearr_49475_51281 = state_49454__$1;
(statearr_49475_51281[(2)] = inst_49450);

(statearr_49475_51281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49456 === (3))){
var inst_49452 = (state_49454[(2)]);
var state_49454__$1 = state_49454;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49454__$1,inst_49452);
} else {
if((state_val_49456 === (2))){
var inst_49421 = (state_49454[(10)]);
var inst_49423 = cljs.core.count(inst_49421);
var inst_49424 = (inst_49423 > (0));
var state_49454__$1 = state_49454;
if(cljs.core.truth_(inst_49424)){
var statearr_49479_51289 = state_49454__$1;
(statearr_49479_51289[(1)] = (4));

} else {
var statearr_49480_51290 = state_49454__$1;
(statearr_49480_51290[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49456 === (11))){
var inst_49421 = (state_49454[(10)]);
var inst_49442 = (state_49454[(2)]);
var tmp49476 = inst_49421;
var inst_49421__$1 = tmp49476;
var state_49454__$1 = (function (){var statearr_49483 = state_49454;
(statearr_49483[(10)] = inst_49421__$1);

(statearr_49483[(11)] = inst_49442);

return statearr_49483;
})();
var statearr_49487_51296 = state_49454__$1;
(statearr_49487_51296[(2)] = null);

(statearr_49487_51296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49456 === (9))){
var inst_49433 = (state_49454[(8)]);
var state_49454__$1 = state_49454;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49454__$1,(11),out,inst_49433);
} else {
if((state_val_49456 === (5))){
var inst_49448 = cljs.core.async.close_BANG_(out);
var state_49454__$1 = state_49454;
var statearr_49496_51298 = state_49454__$1;
(statearr_49496_51298[(2)] = inst_49448);

(statearr_49496_51298[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49456 === (10))){
var inst_49445 = (state_49454[(2)]);
var state_49454__$1 = state_49454;
var statearr_49501_51299 = state_49454__$1;
(statearr_49501_51299[(2)] = inst_49445);

(statearr_49501_51299[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49456 === (8))){
var inst_49434 = (state_49454[(9)]);
var inst_49430 = (state_49454[(7)]);
var inst_49421 = (state_49454[(10)]);
var inst_49433 = (state_49454[(8)]);
var inst_49437 = (function (){var cs = inst_49421;
var vec__49426 = inst_49430;
var v = inst_49433;
var c = inst_49434;
return (function (p1__49411_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__49411_SHARP_);
});
})();
var inst_49438 = cljs.core.filterv(inst_49437,inst_49421);
var inst_49421__$1 = inst_49438;
var state_49454__$1 = (function (){var statearr_49508 = state_49454;
(statearr_49508[(10)] = inst_49421__$1);

return statearr_49508;
})();
var statearr_49509_51308 = state_49454__$1;
(statearr_49509_51308[(2)] = null);

(statearr_49509_51308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_49511 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49511[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_49511[(1)] = (1));

return statearr_49511;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_49454){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_49454);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e49517){var ex__46575__auto__ = e49517;
var statearr_49519_51311 = state_49454;
(statearr_49519_51311[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_49454[(4)]))){
var statearr_49522_51312 = state_49454;
(statearr_49522_51312[(1)] = cljs.core.first((state_49454[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51313 = state_49454;
state_49454 = G__51313;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_49454){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_49454);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_49524 = f__47012__auto__();
(statearr_49524[(6)] = c__47011__auto___51271);

return statearr_49524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__49533 = arguments.length;
switch (G__49533) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47011__auto___51323 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_49562){
var state_val_49563 = (state_49562[(1)]);
if((state_val_49563 === (7))){
var inst_49543 = (state_49562[(7)]);
var inst_49543__$1 = (state_49562[(2)]);
var inst_49545 = (inst_49543__$1 == null);
var inst_49546 = cljs.core.not(inst_49545);
var state_49562__$1 = (function (){var statearr_49564 = state_49562;
(statearr_49564[(7)] = inst_49543__$1);

return statearr_49564;
})();
if(inst_49546){
var statearr_49565_51327 = state_49562__$1;
(statearr_49565_51327[(1)] = (8));

} else {
var statearr_49566_51328 = state_49562__$1;
(statearr_49566_51328[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (1))){
var inst_49538 = (0);
var state_49562__$1 = (function (){var statearr_49567 = state_49562;
(statearr_49567[(8)] = inst_49538);

return statearr_49567;
})();
var statearr_49568_51332 = state_49562__$1;
(statearr_49568_51332[(2)] = null);

(statearr_49568_51332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (4))){
var state_49562__$1 = state_49562;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49562__$1,(7),ch);
} else {
if((state_val_49563 === (6))){
var inst_49557 = (state_49562[(2)]);
var state_49562__$1 = state_49562;
var statearr_49569_51335 = state_49562__$1;
(statearr_49569_51335[(2)] = inst_49557);

(statearr_49569_51335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (3))){
var inst_49559 = (state_49562[(2)]);
var inst_49560 = cljs.core.async.close_BANG_(out);
var state_49562__$1 = (function (){var statearr_49570 = state_49562;
(statearr_49570[(9)] = inst_49559);

return statearr_49570;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49562__$1,inst_49560);
} else {
if((state_val_49563 === (2))){
var inst_49538 = (state_49562[(8)]);
var inst_49540 = (inst_49538 < n);
var state_49562__$1 = state_49562;
if(cljs.core.truth_(inst_49540)){
var statearr_49572_51337 = state_49562__$1;
(statearr_49572_51337[(1)] = (4));

} else {
var statearr_49573_51338 = state_49562__$1;
(statearr_49573_51338[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (11))){
var inst_49538 = (state_49562[(8)]);
var inst_49549 = (state_49562[(2)]);
var inst_49550 = (inst_49538 + (1));
var inst_49538__$1 = inst_49550;
var state_49562__$1 = (function (){var statearr_49574 = state_49562;
(statearr_49574[(10)] = inst_49549);

(statearr_49574[(8)] = inst_49538__$1);

return statearr_49574;
})();
var statearr_49575_51341 = state_49562__$1;
(statearr_49575_51341[(2)] = null);

(statearr_49575_51341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (9))){
var state_49562__$1 = state_49562;
var statearr_49578_51344 = state_49562__$1;
(statearr_49578_51344[(2)] = null);

(statearr_49578_51344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (5))){
var state_49562__$1 = state_49562;
var statearr_49581_51351 = state_49562__$1;
(statearr_49581_51351[(2)] = null);

(statearr_49581_51351[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (10))){
var inst_49554 = (state_49562[(2)]);
var state_49562__$1 = state_49562;
var statearr_49582_51356 = state_49562__$1;
(statearr_49582_51356[(2)] = inst_49554);

(statearr_49582_51356[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49563 === (8))){
var inst_49543 = (state_49562[(7)]);
var state_49562__$1 = state_49562;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49562__$1,(11),out,inst_49543);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_49584 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49584[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_49584[(1)] = (1));

return statearr_49584;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_49562){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_49562);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e49585){var ex__46575__auto__ = e49585;
var statearr_49586_51362 = state_49562;
(statearr_49586_51362[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_49562[(4)]))){
var statearr_49587_51365 = state_49562;
(statearr_49587_51365[(1)] = cljs.core.first((state_49562[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51369 = state_49562;
state_49562 = G__51369;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_49562){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_49562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_49589 = f__47012__auto__();
(statearr_49589[(6)] = c__47011__auto___51323);

return statearr_49589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49592 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49592 = (function (f,ch,meta49593){
this.f = f;
this.ch = ch;
this.meta49593 = meta49593;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49594,meta49593__$1){
var self__ = this;
var _49594__$1 = this;
return (new cljs.core.async.t_cljs$core$async49592(self__.f,self__.ch,meta49593__$1));
}));

(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49594){
var self__ = this;
var _49594__$1 = this;
return self__.meta49593;
}));

(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49599 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49599 = (function (f,ch,meta49593,_,fn1,meta49600){
this.f = f;
this.ch = ch;
this.meta49593 = meta49593;
this._ = _;
this.fn1 = fn1;
this.meta49600 = meta49600;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49599.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49601,meta49600__$1){
var self__ = this;
var _49601__$1 = this;
return (new cljs.core.async.t_cljs$core$async49599(self__.f,self__.ch,self__.meta49593,self__._,self__.fn1,meta49600__$1));
}));

(cljs.core.async.t_cljs$core$async49599.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49601){
var self__ = this;
var _49601__$1 = this;
return self__.meta49600;
}));

(cljs.core.async.t_cljs$core$async49599.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49599.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async49599.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async49599.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__49590_SHARP_){
var G__49606 = (((p1__49590_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__49590_SHARP_) : self__.f.call(null,p1__49590_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__49606) : f1.call(null,G__49606));
});
}));

(cljs.core.async.t_cljs$core$async49599.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49593","meta49593",2029554464,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async49592","cljs.core.async/t_cljs$core$async49592",1485991669,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta49600","meta49600",1700869707,null)], null);
}));

(cljs.core.async.t_cljs$core$async49599.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49599.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49599");

(cljs.core.async.t_cljs$core$async49599.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49599");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49599.
 */
cljs.core.async.__GT_t_cljs$core$async49599 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async49599(f__$1,ch__$1,meta49593__$1,___$2,fn1__$1,meta49600){
return (new cljs.core.async.t_cljs$core$async49599(f__$1,ch__$1,meta49593__$1,___$2,fn1__$1,meta49600));
});

}

return (new cljs.core.async.t_cljs$core$async49599(self__.f,self__.ch,self__.meta49593,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__49611 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__49611) : self__.f.call(null,G__49611));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49592.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async49592.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49593","meta49593",2029554464,null)], null);
}));

(cljs.core.async.t_cljs$core$async49592.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49592.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49592");

(cljs.core.async.t_cljs$core$async49592.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49592");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49592.
 */
cljs.core.async.__GT_t_cljs$core$async49592 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async49592(f__$1,ch__$1,meta49593){
return (new cljs.core.async.t_cljs$core$async49592(f__$1,ch__$1,meta49593));
});

}

return (new cljs.core.async.t_cljs$core$async49592(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49616 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49616 = (function (f,ch,meta49617){
this.f = f;
this.ch = ch;
this.meta49617 = meta49617;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49616.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49618,meta49617__$1){
var self__ = this;
var _49618__$1 = this;
return (new cljs.core.async.t_cljs$core$async49616(self__.f,self__.ch,meta49617__$1));
}));

(cljs.core.async.t_cljs$core$async49616.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49618){
var self__ = this;
var _49618__$1 = this;
return self__.meta49617;
}));

(cljs.core.async.t_cljs$core$async49616.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49616.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49616.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49616.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async49616.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49616.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async49616.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49617","meta49617",-423567180,null)], null);
}));

(cljs.core.async.t_cljs$core$async49616.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49616.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49616");

(cljs.core.async.t_cljs$core$async49616.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49616");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49616.
 */
cljs.core.async.__GT_t_cljs$core$async49616 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async49616(f__$1,ch__$1,meta49617){
return (new cljs.core.async.t_cljs$core$async49616(f__$1,ch__$1,meta49617));
});

}

return (new cljs.core.async.t_cljs$core$async49616(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async49626 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async49626 = (function (p,ch,meta49627){
this.p = p;
this.ch = ch;
this.meta49627 = meta49627;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_49628,meta49627__$1){
var self__ = this;
var _49628__$1 = this;
return (new cljs.core.async.t_cljs$core$async49626(self__.p,self__.ch,meta49627__$1));
}));

(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_49628){
var self__ = this;
var _49628__$1 = this;
return self__.meta49627;
}));

(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async49626.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async49626.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta49627","meta49627",-742856833,null)], null);
}));

(cljs.core.async.t_cljs$core$async49626.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async49626.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async49626");

(cljs.core.async.t_cljs$core$async49626.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async49626");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async49626.
 */
cljs.core.async.__GT_t_cljs$core$async49626 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async49626(p__$1,ch__$1,meta49627){
return (new cljs.core.async.t_cljs$core$async49626(p__$1,ch__$1,meta49627));
});

}

return (new cljs.core.async.t_cljs$core$async49626(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__49637 = arguments.length;
switch (G__49637) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47011__auto___51443 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_49661){
var state_val_49662 = (state_49661[(1)]);
if((state_val_49662 === (7))){
var inst_49657 = (state_49661[(2)]);
var state_49661__$1 = state_49661;
var statearr_49664_51445 = state_49661__$1;
(statearr_49664_51445[(2)] = inst_49657);

(statearr_49664_51445[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49662 === (1))){
var state_49661__$1 = state_49661;
var statearr_49665_51453 = state_49661__$1;
(statearr_49665_51453[(2)] = null);

(statearr_49665_51453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49662 === (4))){
var inst_49642 = (state_49661[(7)]);
var inst_49642__$1 = (state_49661[(2)]);
var inst_49643 = (inst_49642__$1 == null);
var state_49661__$1 = (function (){var statearr_49667 = state_49661;
(statearr_49667[(7)] = inst_49642__$1);

return statearr_49667;
})();
if(cljs.core.truth_(inst_49643)){
var statearr_49668_51455 = state_49661__$1;
(statearr_49668_51455[(1)] = (5));

} else {
var statearr_49669_51456 = state_49661__$1;
(statearr_49669_51456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49662 === (6))){
var inst_49642 = (state_49661[(7)]);
var inst_49647 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_49642) : p.call(null,inst_49642));
var state_49661__$1 = state_49661;
if(cljs.core.truth_(inst_49647)){
var statearr_49671_51458 = state_49661__$1;
(statearr_49671_51458[(1)] = (8));

} else {
var statearr_49672_51460 = state_49661__$1;
(statearr_49672_51460[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49662 === (3))){
var inst_49659 = (state_49661[(2)]);
var state_49661__$1 = state_49661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49661__$1,inst_49659);
} else {
if((state_val_49662 === (2))){
var state_49661__$1 = state_49661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49661__$1,(4),ch);
} else {
if((state_val_49662 === (11))){
var inst_49650 = (state_49661[(2)]);
var state_49661__$1 = state_49661;
var statearr_49674_51469 = state_49661__$1;
(statearr_49674_51469[(2)] = inst_49650);

(statearr_49674_51469[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49662 === (9))){
var state_49661__$1 = state_49661;
var statearr_49676_51470 = state_49661__$1;
(statearr_49676_51470[(2)] = null);

(statearr_49676_51470[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49662 === (5))){
var inst_49645 = cljs.core.async.close_BANG_(out);
var state_49661__$1 = state_49661;
var statearr_49678_51471 = state_49661__$1;
(statearr_49678_51471[(2)] = inst_49645);

(statearr_49678_51471[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49662 === (10))){
var inst_49654 = (state_49661[(2)]);
var state_49661__$1 = (function (){var statearr_49679 = state_49661;
(statearr_49679[(8)] = inst_49654);

return statearr_49679;
})();
var statearr_49680_51472 = state_49661__$1;
(statearr_49680_51472[(2)] = null);

(statearr_49680_51472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49662 === (8))){
var inst_49642 = (state_49661[(7)]);
var state_49661__$1 = state_49661;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49661__$1,(11),out,inst_49642);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_49683 = [null,null,null,null,null,null,null,null,null];
(statearr_49683[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_49683[(1)] = (1));

return statearr_49683;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_49661){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_49661);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e49685){var ex__46575__auto__ = e49685;
var statearr_49686_51494 = state_49661;
(statearr_49686_51494[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_49661[(4)]))){
var statearr_49688_51498 = state_49661;
(statearr_49688_51498[(1)] = cljs.core.first((state_49661[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51500 = state_49661;
state_49661 = G__51500;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_49661){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_49661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_49690 = f__47012__auto__();
(statearr_49690[(6)] = c__47011__auto___51443);

return statearr_49690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__49695 = arguments.length;
switch (G__49695) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__47011__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_49766){
var state_val_49767 = (state_49766[(1)]);
if((state_val_49767 === (7))){
var inst_49761 = (state_49766[(2)]);
var state_49766__$1 = state_49766;
var statearr_49771_51515 = state_49766__$1;
(statearr_49771_51515[(2)] = inst_49761);

(statearr_49771_51515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (20))){
var inst_49730 = (state_49766[(7)]);
var inst_49742 = (state_49766[(2)]);
var inst_49743 = cljs.core.next(inst_49730);
var inst_49714 = inst_49743;
var inst_49715 = null;
var inst_49716 = (0);
var inst_49717 = (0);
var state_49766__$1 = (function (){var statearr_49773 = state_49766;
(statearr_49773[(8)] = inst_49716);

(statearr_49773[(9)] = inst_49742);

(statearr_49773[(10)] = inst_49714);

(statearr_49773[(11)] = inst_49717);

(statearr_49773[(12)] = inst_49715);

return statearr_49773;
})();
var statearr_49774_51519 = state_49766__$1;
(statearr_49774_51519[(2)] = null);

(statearr_49774_51519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (1))){
var state_49766__$1 = state_49766;
var statearr_49776_51521 = state_49766__$1;
(statearr_49776_51521[(2)] = null);

(statearr_49776_51521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (4))){
var inst_49702 = (state_49766[(13)]);
var inst_49702__$1 = (state_49766[(2)]);
var inst_49704 = (inst_49702__$1 == null);
var state_49766__$1 = (function (){var statearr_49777 = state_49766;
(statearr_49777[(13)] = inst_49702__$1);

return statearr_49777;
})();
if(cljs.core.truth_(inst_49704)){
var statearr_49778_51527 = state_49766__$1;
(statearr_49778_51527[(1)] = (5));

} else {
var statearr_49780_51529 = state_49766__$1;
(statearr_49780_51529[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (15))){
var state_49766__$1 = state_49766;
var statearr_49785_51533 = state_49766__$1;
(statearr_49785_51533[(2)] = null);

(statearr_49785_51533[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (21))){
var state_49766__$1 = state_49766;
var statearr_49786_51535 = state_49766__$1;
(statearr_49786_51535[(2)] = null);

(statearr_49786_51535[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (13))){
var inst_49716 = (state_49766[(8)]);
var inst_49714 = (state_49766[(10)]);
var inst_49717 = (state_49766[(11)]);
var inst_49715 = (state_49766[(12)]);
var inst_49725 = (state_49766[(2)]);
var inst_49726 = (inst_49717 + (1));
var tmp49781 = inst_49716;
var tmp49782 = inst_49714;
var tmp49783 = inst_49715;
var inst_49714__$1 = tmp49782;
var inst_49715__$1 = tmp49783;
var inst_49716__$1 = tmp49781;
var inst_49717__$1 = inst_49726;
var state_49766__$1 = (function (){var statearr_49788 = state_49766;
(statearr_49788[(8)] = inst_49716__$1);

(statearr_49788[(10)] = inst_49714__$1);

(statearr_49788[(14)] = inst_49725);

(statearr_49788[(11)] = inst_49717__$1);

(statearr_49788[(12)] = inst_49715__$1);

return statearr_49788;
})();
var statearr_49790_51541 = state_49766__$1;
(statearr_49790_51541[(2)] = null);

(statearr_49790_51541[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (22))){
var state_49766__$1 = state_49766;
var statearr_49792_51544 = state_49766__$1;
(statearr_49792_51544[(2)] = null);

(statearr_49792_51544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (6))){
var inst_49702 = (state_49766[(13)]);
var inst_49712 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_49702) : f.call(null,inst_49702));
var inst_49713 = cljs.core.seq(inst_49712);
var inst_49714 = inst_49713;
var inst_49715 = null;
var inst_49716 = (0);
var inst_49717 = (0);
var state_49766__$1 = (function (){var statearr_49794 = state_49766;
(statearr_49794[(8)] = inst_49716);

(statearr_49794[(10)] = inst_49714);

(statearr_49794[(11)] = inst_49717);

(statearr_49794[(12)] = inst_49715);

return statearr_49794;
})();
var statearr_49795_51553 = state_49766__$1;
(statearr_49795_51553[(2)] = null);

(statearr_49795_51553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (17))){
var inst_49730 = (state_49766[(7)]);
var inst_49734 = cljs.core.chunk_first(inst_49730);
var inst_49735 = cljs.core.chunk_rest(inst_49730);
var inst_49736 = cljs.core.count(inst_49734);
var inst_49714 = inst_49735;
var inst_49715 = inst_49734;
var inst_49716 = inst_49736;
var inst_49717 = (0);
var state_49766__$1 = (function (){var statearr_49797 = state_49766;
(statearr_49797[(8)] = inst_49716);

(statearr_49797[(10)] = inst_49714);

(statearr_49797[(11)] = inst_49717);

(statearr_49797[(12)] = inst_49715);

return statearr_49797;
})();
var statearr_49799_51555 = state_49766__$1;
(statearr_49799_51555[(2)] = null);

(statearr_49799_51555[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (3))){
var inst_49763 = (state_49766[(2)]);
var state_49766__$1 = state_49766;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49766__$1,inst_49763);
} else {
if((state_val_49767 === (12))){
var inst_49751 = (state_49766[(2)]);
var state_49766__$1 = state_49766;
var statearr_49801_51561 = state_49766__$1;
(statearr_49801_51561[(2)] = inst_49751);

(statearr_49801_51561[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (2))){
var state_49766__$1 = state_49766;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49766__$1,(4),in$);
} else {
if((state_val_49767 === (23))){
var inst_49759 = (state_49766[(2)]);
var state_49766__$1 = state_49766;
var statearr_49802_51565 = state_49766__$1;
(statearr_49802_51565[(2)] = inst_49759);

(statearr_49802_51565[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (19))){
var inst_49746 = (state_49766[(2)]);
var state_49766__$1 = state_49766;
var statearr_49804_51568 = state_49766__$1;
(statearr_49804_51568[(2)] = inst_49746);

(statearr_49804_51568[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (11))){
var inst_49730 = (state_49766[(7)]);
var inst_49714 = (state_49766[(10)]);
var inst_49730__$1 = cljs.core.seq(inst_49714);
var state_49766__$1 = (function (){var statearr_49806 = state_49766;
(statearr_49806[(7)] = inst_49730__$1);

return statearr_49806;
})();
if(inst_49730__$1){
var statearr_49807_51572 = state_49766__$1;
(statearr_49807_51572[(1)] = (14));

} else {
var statearr_49808_51575 = state_49766__$1;
(statearr_49808_51575[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (9))){
var inst_49753 = (state_49766[(2)]);
var inst_49754 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_49766__$1 = (function (){var statearr_49810 = state_49766;
(statearr_49810[(15)] = inst_49753);

return statearr_49810;
})();
if(cljs.core.truth_(inst_49754)){
var statearr_49811_51579 = state_49766__$1;
(statearr_49811_51579[(1)] = (21));

} else {
var statearr_49813_51581 = state_49766__$1;
(statearr_49813_51581[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (5))){
var inst_49706 = cljs.core.async.close_BANG_(out);
var state_49766__$1 = state_49766;
var statearr_49814_51582 = state_49766__$1;
(statearr_49814_51582[(2)] = inst_49706);

(statearr_49814_51582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (14))){
var inst_49730 = (state_49766[(7)]);
var inst_49732 = cljs.core.chunked_seq_QMARK_(inst_49730);
var state_49766__$1 = state_49766;
if(inst_49732){
var statearr_49816_51585 = state_49766__$1;
(statearr_49816_51585[(1)] = (17));

} else {
var statearr_49817_51586 = state_49766__$1;
(statearr_49817_51586[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (16))){
var inst_49749 = (state_49766[(2)]);
var state_49766__$1 = state_49766;
var statearr_49819_51590 = state_49766__$1;
(statearr_49819_51590[(2)] = inst_49749);

(statearr_49819_51590[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49767 === (10))){
var inst_49717 = (state_49766[(11)]);
var inst_49715 = (state_49766[(12)]);
var inst_49723 = cljs.core._nth(inst_49715,inst_49717);
var state_49766__$1 = state_49766;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49766__$1,(13),out,inst_49723);
} else {
if((state_val_49767 === (18))){
var inst_49730 = (state_49766[(7)]);
var inst_49740 = cljs.core.first(inst_49730);
var state_49766__$1 = state_49766;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49766__$1,(20),out,inst_49740);
} else {
if((state_val_49767 === (8))){
var inst_49716 = (state_49766[(8)]);
var inst_49717 = (state_49766[(11)]);
var inst_49720 = (inst_49717 < inst_49716);
var inst_49721 = inst_49720;
var state_49766__$1 = state_49766;
if(cljs.core.truth_(inst_49721)){
var statearr_49821_51592 = state_49766__$1;
(statearr_49821_51592[(1)] = (10));

} else {
var statearr_49823_51594 = state_49766__$1;
(statearr_49823_51594[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__46572__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__46572__auto____0 = (function (){
var statearr_49825 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49825[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__46572__auto__);

(statearr_49825[(1)] = (1));

return statearr_49825;
});
var cljs$core$async$mapcat_STAR__$_state_machine__46572__auto____1 = (function (state_49766){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_49766);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e49826){var ex__46575__auto__ = e49826;
var statearr_49828_51597 = state_49766;
(statearr_49828_51597[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_49766[(4)]))){
var statearr_49829_51598 = state_49766;
(statearr_49829_51598[(1)] = cljs.core.first((state_49766[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51599 = state_49766;
state_49766 = G__51599;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__46572__auto__ = function(state_49766){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__46572__auto____1.call(this,state_49766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__46572__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__46572__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_49831 = f__47012__auto__();
(statearr_49831[(6)] = c__47011__auto__);

return statearr_49831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));

return c__47011__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__49834 = arguments.length;
switch (G__49834) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__49839 = arguments.length;
switch (G__49839) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__49844 = arguments.length;
switch (G__49844) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47011__auto___51618 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_49870){
var state_val_49871 = (state_49870[(1)]);
if((state_val_49871 === (7))){
var inst_49865 = (state_49870[(2)]);
var state_49870__$1 = state_49870;
var statearr_49873_51622 = state_49870__$1;
(statearr_49873_51622[(2)] = inst_49865);

(statearr_49873_51622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49871 === (1))){
var inst_49846 = null;
var state_49870__$1 = (function (){var statearr_49875 = state_49870;
(statearr_49875[(7)] = inst_49846);

return statearr_49875;
})();
var statearr_49876_51624 = state_49870__$1;
(statearr_49876_51624[(2)] = null);

(statearr_49876_51624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49871 === (4))){
var inst_49849 = (state_49870[(8)]);
var inst_49849__$1 = (state_49870[(2)]);
var inst_49850 = (inst_49849__$1 == null);
var inst_49852 = cljs.core.not(inst_49850);
var state_49870__$1 = (function (){var statearr_49877 = state_49870;
(statearr_49877[(8)] = inst_49849__$1);

return statearr_49877;
})();
if(inst_49852){
var statearr_49878_51628 = state_49870__$1;
(statearr_49878_51628[(1)] = (5));

} else {
var statearr_49879_51632 = state_49870__$1;
(statearr_49879_51632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49871 === (6))){
var state_49870__$1 = state_49870;
var statearr_49881_51635 = state_49870__$1;
(statearr_49881_51635[(2)] = null);

(statearr_49881_51635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49871 === (3))){
var inst_49867 = (state_49870[(2)]);
var inst_49868 = cljs.core.async.close_BANG_(out);
var state_49870__$1 = (function (){var statearr_49882 = state_49870;
(statearr_49882[(9)] = inst_49867);

return statearr_49882;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49870__$1,inst_49868);
} else {
if((state_val_49871 === (2))){
var state_49870__$1 = state_49870;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49870__$1,(4),ch);
} else {
if((state_val_49871 === (11))){
var inst_49849 = (state_49870[(8)]);
var inst_49859 = (state_49870[(2)]);
var inst_49846 = inst_49849;
var state_49870__$1 = (function (){var statearr_49884 = state_49870;
(statearr_49884[(7)] = inst_49846);

(statearr_49884[(10)] = inst_49859);

return statearr_49884;
})();
var statearr_49885_51641 = state_49870__$1;
(statearr_49885_51641[(2)] = null);

(statearr_49885_51641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49871 === (9))){
var inst_49849 = (state_49870[(8)]);
var state_49870__$1 = state_49870;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49870__$1,(11),out,inst_49849);
} else {
if((state_val_49871 === (5))){
var inst_49846 = (state_49870[(7)]);
var inst_49849 = (state_49870[(8)]);
var inst_49854 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49849,inst_49846);
var state_49870__$1 = state_49870;
if(inst_49854){
var statearr_49888_51647 = state_49870__$1;
(statearr_49888_51647[(1)] = (8));

} else {
var statearr_49889_51649 = state_49870__$1;
(statearr_49889_51649[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49871 === (10))){
var inst_49862 = (state_49870[(2)]);
var state_49870__$1 = state_49870;
var statearr_49891_51651 = state_49870__$1;
(statearr_49891_51651[(2)] = inst_49862);

(statearr_49891_51651[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49871 === (8))){
var inst_49846 = (state_49870[(7)]);
var tmp49887 = inst_49846;
var inst_49846__$1 = tmp49887;
var state_49870__$1 = (function (){var statearr_49892 = state_49870;
(statearr_49892[(7)] = inst_49846__$1);

return statearr_49892;
})();
var statearr_49894_51654 = state_49870__$1;
(statearr_49894_51654[(2)] = null);

(statearr_49894_51654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_49895 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49895[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_49895[(1)] = (1));

return statearr_49895;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_49870){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_49870);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e49897){var ex__46575__auto__ = e49897;
var statearr_49898_51657 = state_49870;
(statearr_49898_51657[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_49870[(4)]))){
var statearr_49899_51658 = state_49870;
(statearr_49899_51658[(1)] = cljs.core.first((state_49870[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51659 = state_49870;
state_49870 = G__51659;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_49870){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_49870);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_49901 = f__47012__auto__();
(statearr_49901[(6)] = c__47011__auto___51618);

return statearr_49901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__49905 = arguments.length;
switch (G__49905) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47011__auto___51666 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_49947){
var state_val_49948 = (state_49947[(1)]);
if((state_val_49948 === (7))){
var inst_49943 = (state_49947[(2)]);
var state_49947__$1 = state_49947;
var statearr_49951_51668 = state_49947__$1;
(statearr_49951_51668[(2)] = inst_49943);

(statearr_49951_51668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (1))){
var inst_49907 = (new Array(n));
var inst_49909 = inst_49907;
var inst_49910 = (0);
var state_49947__$1 = (function (){var statearr_49953 = state_49947;
(statearr_49953[(7)] = inst_49910);

(statearr_49953[(8)] = inst_49909);

return statearr_49953;
})();
var statearr_49954_51677 = state_49947__$1;
(statearr_49954_51677[(2)] = null);

(statearr_49954_51677[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (4))){
var inst_49913 = (state_49947[(9)]);
var inst_49913__$1 = (state_49947[(2)]);
var inst_49914 = (inst_49913__$1 == null);
var inst_49915 = cljs.core.not(inst_49914);
var state_49947__$1 = (function (){var statearr_49956 = state_49947;
(statearr_49956[(9)] = inst_49913__$1);

return statearr_49956;
})();
if(inst_49915){
var statearr_49957_51679 = state_49947__$1;
(statearr_49957_51679[(1)] = (5));

} else {
var statearr_49959_51683 = state_49947__$1;
(statearr_49959_51683[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (15))){
var inst_49936 = (state_49947[(2)]);
var state_49947__$1 = state_49947;
var statearr_49960_51687 = state_49947__$1;
(statearr_49960_51687[(2)] = inst_49936);

(statearr_49960_51687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (13))){
var state_49947__$1 = state_49947;
var statearr_49962_51688 = state_49947__$1;
(statearr_49962_51688[(2)] = null);

(statearr_49962_51688[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (6))){
var inst_49910 = (state_49947[(7)]);
var inst_49932 = (inst_49910 > (0));
var state_49947__$1 = state_49947;
if(cljs.core.truth_(inst_49932)){
var statearr_49964_51691 = state_49947__$1;
(statearr_49964_51691[(1)] = (12));

} else {
var statearr_49965_51692 = state_49947__$1;
(statearr_49965_51692[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (3))){
var inst_49945 = (state_49947[(2)]);
var state_49947__$1 = state_49947;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49947__$1,inst_49945);
} else {
if((state_val_49948 === (12))){
var inst_49909 = (state_49947[(8)]);
var inst_49934 = cljs.core.vec(inst_49909);
var state_49947__$1 = state_49947;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49947__$1,(15),out,inst_49934);
} else {
if((state_val_49948 === (2))){
var state_49947__$1 = state_49947;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49947__$1,(4),ch);
} else {
if((state_val_49948 === (11))){
var inst_49926 = (state_49947[(2)]);
var inst_49927 = (new Array(n));
var inst_49909 = inst_49927;
var inst_49910 = (0);
var state_49947__$1 = (function (){var statearr_49968 = state_49947;
(statearr_49968[(7)] = inst_49910);

(statearr_49968[(8)] = inst_49909);

(statearr_49968[(10)] = inst_49926);

return statearr_49968;
})();
var statearr_49969_51702 = state_49947__$1;
(statearr_49969_51702[(2)] = null);

(statearr_49969_51702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (9))){
var inst_49909 = (state_49947[(8)]);
var inst_49924 = cljs.core.vec(inst_49909);
var state_49947__$1 = state_49947;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49947__$1,(11),out,inst_49924);
} else {
if((state_val_49948 === (5))){
var inst_49910 = (state_49947[(7)]);
var inst_49918 = (state_49947[(11)]);
var inst_49913 = (state_49947[(9)]);
var inst_49909 = (state_49947[(8)]);
var inst_49917 = (inst_49909[inst_49910] = inst_49913);
var inst_49918__$1 = (inst_49910 + (1));
var inst_49919 = (inst_49918__$1 < n);
var state_49947__$1 = (function (){var statearr_49972 = state_49947;
(statearr_49972[(12)] = inst_49917);

(statearr_49972[(11)] = inst_49918__$1);

return statearr_49972;
})();
if(cljs.core.truth_(inst_49919)){
var statearr_49973_51717 = state_49947__$1;
(statearr_49973_51717[(1)] = (8));

} else {
var statearr_49975_51718 = state_49947__$1;
(statearr_49975_51718[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (14))){
var inst_49939 = (state_49947[(2)]);
var inst_49941 = cljs.core.async.close_BANG_(out);
var state_49947__$1 = (function (){var statearr_49977 = state_49947;
(statearr_49977[(13)] = inst_49939);

return statearr_49977;
})();
var statearr_49979_51721 = state_49947__$1;
(statearr_49979_51721[(2)] = inst_49941);

(statearr_49979_51721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (10))){
var inst_49930 = (state_49947[(2)]);
var state_49947__$1 = state_49947;
var statearr_49980_51725 = state_49947__$1;
(statearr_49980_51725[(2)] = inst_49930);

(statearr_49980_51725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49948 === (8))){
var inst_49918 = (state_49947[(11)]);
var inst_49909 = (state_49947[(8)]);
var tmp49976 = inst_49909;
var inst_49909__$1 = tmp49976;
var inst_49910 = inst_49918;
var state_49947__$1 = (function (){var statearr_49982 = state_49947;
(statearr_49982[(7)] = inst_49910);

(statearr_49982[(8)] = inst_49909__$1);

return statearr_49982;
})();
var statearr_49983_51726 = state_49947__$1;
(statearr_49983_51726[(2)] = null);

(statearr_49983_51726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_49985 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49985[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_49985[(1)] = (1));

return statearr_49985;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_49947){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_49947);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e49987){var ex__46575__auto__ = e49987;
var statearr_49988_51728 = state_49947;
(statearr_49988_51728[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_49947[(4)]))){
var statearr_49990_51729 = state_49947;
(statearr_49990_51729[(1)] = cljs.core.first((state_49947[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51737 = state_49947;
state_49947 = G__51737;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_49947){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_49947);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_49992 = f__47012__auto__();
(statearr_49992[(6)] = c__47011__auto___51666);

return statearr_49992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__49996 = arguments.length;
switch (G__49996) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__47011__auto___51743 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_50047){
var state_val_50048 = (state_50047[(1)]);
if((state_val_50048 === (7))){
var inst_50043 = (state_50047[(2)]);
var state_50047__$1 = state_50047;
var statearr_50050_51747 = state_50047__$1;
(statearr_50050_51747[(2)] = inst_50043);

(statearr_50050_51747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (1))){
var inst_49999 = [];
var inst_50000 = inst_49999;
var inst_50001 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_50047__$1 = (function (){var statearr_50054 = state_50047;
(statearr_50054[(7)] = inst_50001);

(statearr_50054[(8)] = inst_50000);

return statearr_50054;
})();
var statearr_50056_51760 = state_50047__$1;
(statearr_50056_51760[(2)] = null);

(statearr_50056_51760[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (4))){
var inst_50004 = (state_50047[(9)]);
var inst_50004__$1 = (state_50047[(2)]);
var inst_50005 = (inst_50004__$1 == null);
var inst_50006 = cljs.core.not(inst_50005);
var state_50047__$1 = (function (){var statearr_50057 = state_50047;
(statearr_50057[(9)] = inst_50004__$1);

return statearr_50057;
})();
if(inst_50006){
var statearr_50058_51761 = state_50047__$1;
(statearr_50058_51761[(1)] = (5));

} else {
var statearr_50059_51762 = state_50047__$1;
(statearr_50059_51762[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (15))){
var inst_50037 = (state_50047[(2)]);
var state_50047__$1 = state_50047;
var statearr_50061_51763 = state_50047__$1;
(statearr_50061_51763[(2)] = inst_50037);

(statearr_50061_51763[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (13))){
var state_50047__$1 = state_50047;
var statearr_50062_51764 = state_50047__$1;
(statearr_50062_51764[(2)] = null);

(statearr_50062_51764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (6))){
var inst_50000 = (state_50047[(8)]);
var inst_50032 = inst_50000.length;
var inst_50033 = (inst_50032 > (0));
var state_50047__$1 = state_50047;
if(cljs.core.truth_(inst_50033)){
var statearr_50063_51765 = state_50047__$1;
(statearr_50063_51765[(1)] = (12));

} else {
var statearr_50064_51766 = state_50047__$1;
(statearr_50064_51766[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (3))){
var inst_50045 = (state_50047[(2)]);
var state_50047__$1 = state_50047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50047__$1,inst_50045);
} else {
if((state_val_50048 === (12))){
var inst_50000 = (state_50047[(8)]);
var inst_50035 = cljs.core.vec(inst_50000);
var state_50047__$1 = state_50047;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50047__$1,(15),out,inst_50035);
} else {
if((state_val_50048 === (2))){
var state_50047__$1 = state_50047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50047__$1,(4),ch);
} else {
if((state_val_50048 === (11))){
var inst_50008 = (state_50047[(10)]);
var inst_50004 = (state_50047[(9)]);
var inst_50019 = (state_50047[(2)]);
var inst_50021 = [];
var inst_50027 = inst_50021.push(inst_50004);
var inst_50000 = inst_50021;
var inst_50001 = inst_50008;
var state_50047__$1 = (function (){var statearr_50069 = state_50047;
(statearr_50069[(7)] = inst_50001);

(statearr_50069[(11)] = inst_50019);

(statearr_50069[(12)] = inst_50027);

(statearr_50069[(8)] = inst_50000);

return statearr_50069;
})();
var statearr_50071_51775 = state_50047__$1;
(statearr_50071_51775[(2)] = null);

(statearr_50071_51775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (9))){
var inst_50000 = (state_50047[(8)]);
var inst_50017 = cljs.core.vec(inst_50000);
var state_50047__$1 = state_50047;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_50047__$1,(11),out,inst_50017);
} else {
if((state_val_50048 === (5))){
var inst_50001 = (state_50047[(7)]);
var inst_50008 = (state_50047[(10)]);
var inst_50004 = (state_50047[(9)]);
var inst_50008__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_50004) : f.call(null,inst_50004));
var inst_50010 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_50008__$1,inst_50001);
var inst_50011 = cljs.core.keyword_identical_QMARK_(inst_50001,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_50012 = ((inst_50010) || (inst_50011));
var state_50047__$1 = (function (){var statearr_50073 = state_50047;
(statearr_50073[(10)] = inst_50008__$1);

return statearr_50073;
})();
if(cljs.core.truth_(inst_50012)){
var statearr_50074_51779 = state_50047__$1;
(statearr_50074_51779[(1)] = (8));

} else {
var statearr_50075_51780 = state_50047__$1;
(statearr_50075_51780[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (14))){
var inst_50040 = (state_50047[(2)]);
var inst_50041 = cljs.core.async.close_BANG_(out);
var state_50047__$1 = (function (){var statearr_50077 = state_50047;
(statearr_50077[(13)] = inst_50040);

return statearr_50077;
})();
var statearr_50078_51782 = state_50047__$1;
(statearr_50078_51782[(2)] = inst_50041);

(statearr_50078_51782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (10))){
var inst_50030 = (state_50047[(2)]);
var state_50047__$1 = state_50047;
var statearr_50080_51785 = state_50047__$1;
(statearr_50080_51785[(2)] = inst_50030);

(statearr_50080_51785[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_50048 === (8))){
var inst_50008 = (state_50047[(10)]);
var inst_50004 = (state_50047[(9)]);
var inst_50000 = (state_50047[(8)]);
var inst_50014 = inst_50000.push(inst_50004);
var tmp50076 = inst_50000;
var inst_50000__$1 = tmp50076;
var inst_50001 = inst_50008;
var state_50047__$1 = (function (){var statearr_50084 = state_50047;
(statearr_50084[(7)] = inst_50001);

(statearr_50084[(14)] = inst_50014);

(statearr_50084[(8)] = inst_50000__$1);

return statearr_50084;
})();
var statearr_50086_51787 = state_50047__$1;
(statearr_50086_51787[(2)] = null);

(statearr_50086_51787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__46572__auto__ = null;
var cljs$core$async$state_machine__46572__auto____0 = (function (){
var statearr_50088 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50088[(0)] = cljs$core$async$state_machine__46572__auto__);

(statearr_50088[(1)] = (1));

return statearr_50088;
});
var cljs$core$async$state_machine__46572__auto____1 = (function (state_50047){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_50047);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e50089){var ex__46575__auto__ = e50089;
var statearr_50091_51801 = state_50047;
(statearr_50091_51801[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_50047[(4)]))){
var statearr_50094_51802 = state_50047;
(statearr_50094_51802[(1)] = cljs.core.first((state_50047[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51805 = state_50047;
state_50047 = G__51805;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
cljs$core$async$state_machine__46572__auto__ = function(state_50047){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__46572__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__46572__auto____1.call(this,state_50047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__46572__auto____0;
cljs$core$async$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__46572__auto____1;
return cljs$core$async$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_50099 = f__47012__auto__();
(statearr_50099[(6)] = c__47011__auto___51743);

return statearr_50099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
