goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('goog.dom');
var module$node_modules$react$index=shadow.js.require("module$node_modules$react$index", {});
/**
 * The React.js create element function.
 */
sablono.core.create_element = module$node_modules$react$index.createElement;
/**
 * The React.js Fragment.
 */
sablono.core.fragment = module$node_modules$react$index.Fragment;
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__51776__delegate = function (args){
if(cljs.core.map_QMARK_(cljs.core.first(args))){
var vec__51147 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,cljs.core.rest(args));
var seq__51148 = cljs.core.seq(vec__51147);
var first__51149 = cljs.core.first(seq__51148);
var seq__51148__$1 = cljs.core.next(seq__51148);
var tag = first__51149;
var body = seq__51148__$1;
if(cljs.core.map_QMARK_(cljs.core.first(body))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.first(body),cljs.core.first(args)], 0))], null),cljs.core.rest(body));
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tag,cljs.core.first(args)], null),body);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(func,args);
}
};
var G__51776 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__51777__i = 0, G__51777__a = new Array(arguments.length -  0);
while (G__51777__i < G__51777__a.length) {G__51777__a[G__51777__i] = arguments[G__51777__i + 0]; ++G__51777__i;}
  args = new cljs.core.IndexedSeq(G__51777__a,0,null);
} 
return G__51776__delegate.call(this,args);};
G__51776.cljs$lang$maxFixedArity = 0;
G__51776.cljs$lang$applyTo = (function (arglist__51778){
var args = cljs.core.seq(arglist__51778);
return G__51776__delegate(args);
});
G__51776.cljs$core$IFn$_invoke$arity$variadic = G__51776__delegate;
return G__51776;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__4529__auto__ = (function sablono$core$update_arglists_$_iter__51156(s__51157){
return (new cljs.core.LazySeq(null,(function (){
var s__51157__$1 = s__51157;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51157__$1);
if(temp__5735__auto__){
var s__51157__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51157__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51157__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51159 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51158 = (0);
while(true){
if((i__51158 < size__4528__auto__)){
var args = cljs.core._nth(c__4527__auto__,i__51158);
cljs.core.chunk_append(b__51159,cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__51781 = (i__51158 + (1));
i__51158 = G__51781;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51159),sablono$core$update_arglists_$_iter__51156(cljs.core.chunk_rest(s__51157__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51159),null);
}
} else {
var args = cljs.core.first(s__51157__$2);
return cljs.core.cons(cljs.core.vec(cljs.core.cons(new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__51156(cljs.core.rest(s__51157__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__4742__auto__ = [];
var len__4736__auto___51783 = arguments.length;
var i__4737__auto___51784 = (0);
while(true){
if((i__4737__auto___51784 < len__4736__auto___51783)){
args__4742__auto__.push((arguments[i__4737__auto___51784]));

var G__51786 = (i__4737__auto___51784 + (1));
i__4737__auto___51784 = G__51786;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__4529__auto__ = (function sablono$core$iter__51170(s__51171){
return (new cljs.core.LazySeq(null,(function (){
var s__51171__$1 = s__51171;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51171__$1);
if(temp__5735__auto__){
var s__51171__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51171__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51171__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51173 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51172 = (0);
while(true){
if((i__51172 < size__4528__auto__)){
var style = cljs.core._nth(c__4527__auto__,i__51172);
cljs.core.chunk_append(b__51173,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__51788 = (i__51172 + (1));
i__51172 = G__51788;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51173),sablono$core$iter__51170(cljs.core.chunk_rest(s__51171__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51173),null);
}
} else {
var style = cljs.core.first(s__51171__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([style], 0)),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__51170(cljs.core.rest(s__51171__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(styles);
}));

(sablono.core.include_css.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(sablono.core.include_css.cljs$lang$applyTo = (function (seq51167){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq51167));
}));

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js("http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to51189 = (function sablono$core$link_to51189(var_args){
var args__4742__auto__ = [];
var len__4736__auto___51803 = arguments.length;
var i__4737__auto___51804 = (0);
while(true){
if((i__4737__auto___51804 < len__4736__auto___51803)){
args__4742__auto__.push((arguments[i__4737__auto___51804]));

var G__51806 = (i__4737__auto___51804 + (1));
i__4737__auto___51804 = G__51806;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to51189.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.link_to51189.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([url], 0))], null),content], null);
}));

(sablono.core.link_to51189.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.link_to51189.cljs$lang$applyTo = (function (seq51192){
var G__51193 = cljs.core.first(seq51192);
var seq51192__$1 = cljs.core.next(seq51192);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51193,seq51192__$1);
}));


sablono.core.link_to = sablono.core.wrap_attrs(sablono.core.link_to51189);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to51208 = (function sablono$core$mail_to51208(var_args){
var args__4742__auto__ = [];
var len__4736__auto___51812 = arguments.length;
var i__4737__auto___51814 = (0);
while(true){
if((i__4737__auto___51814 < len__4736__auto___51812)){
args__4742__auto__.push((arguments[i__4737__auto___51814]));

var G__51815 = (i__4737__auto___51814 + (1));
i__4737__auto___51814 = G__51815;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to51208.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.mail_to51208.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__51222){
var vec__51224 = p__51222;
var content = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51224,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),["mailto:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_mail)].join('')], null),(function (){var or__4126__auto__ = content;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return e_mail;
}
})()], null);
}));

(sablono.core.mail_to51208.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.mail_to51208.cljs$lang$applyTo = (function (seq51212){
var G__51213 = cljs.core.first(seq51212);
var seq51212__$1 = cljs.core.next(seq51212);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51213,seq51212__$1);
}));


sablono.core.mail_to = sablono.core.wrap_attrs(sablono.core.mail_to51208);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list51234 = (function sablono$core$unordered_list51234(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__4529__auto__ = (function sablono$core$unordered_list51234_$_iter__51239(s__51240){
return (new cljs.core.LazySeq(null,(function (){
var s__51240__$1 = s__51240;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51240__$1);
if(temp__5735__auto__){
var s__51240__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51240__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51240__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51242 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51241 = (0);
while(true){
if((i__51241 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__51241);
cljs.core.chunk_append(b__51242,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__51817 = (i__51241 + (1));
i__51241 = G__51817;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51242),sablono$core$unordered_list51234_$_iter__51239(cljs.core.chunk_rest(s__51240__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51242),null);
}
} else {
var x = cljs.core.first(s__51240__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list51234_$_iter__51239(cljs.core.rest(s__51240__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs(sablono.core.unordered_list51234);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list51259 = (function sablono$core$ordered_list51259(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__4529__auto__ = (function sablono$core$ordered_list51259_$_iter__51263(s__51264){
return (new cljs.core.LazySeq(null,(function (){
var s__51264__$1 = s__51264;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51264__$1);
if(temp__5735__auto__){
var s__51264__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51264__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51264__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51266 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51265 = (0);
while(true){
if((i__51265 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__51265);
cljs.core.chunk_append(b__51266,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__51820 = (i__51265 + (1));
i__51265 = G__51820;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51266),sablono$core$ordered_list51259_$_iter__51263(cljs.core.chunk_rest(s__51264__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51266),null);
}
} else {
var x = cljs.core.first(s__51264__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list51259_$_iter__51263(cljs.core.rest(s__51264__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs(sablono.core.ordered_list51259);
/**
 * Create an image element.
 */
sablono.core.image51282 = (function sablono$core$image51282(var_args){
var G__51295 = arguments.length;
switch (G__51295) {
case 1:
return sablono.core.image51282.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image51282.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.image51282.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0))], null)], null);
}));

(sablono.core.image51282.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([src], 0)),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
}));

(sablono.core.image51282.cljs$lang$maxFixedArity = 2);


sablono.core.image = sablono.core.wrap_attrs(sablono.core.image51282);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__51305_SHARP_,p2__51306_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__51305_SHARP_),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__51306_SHARP_),"]"].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__51309_SHARP_,p2__51310_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__51309_SHARP_),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p2__51310_SHARP_)].join('');
}),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(sablono.core._STAR_group_STAR_,sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0))));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(var_args){
var G__51325 = arguments.length;
switch (G__51325) {
case 2:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (type,name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4126__auto__ = value;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.input_field_STAR_.cljs$lang$maxFixedArity = 3);

/**
 * Creates a color input field.
 */
sablono.core.color_field51336 = (function sablono$core$color_field51336(var_args){
var G__51340 = arguments.length;
switch (G__51340) {
case 1:
return sablono.core.color_field51336.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field51336.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.color_field51336.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__51123__auto__);
}));

(sablono.core.color_field51336.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"color","color",-1642760596,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.color_field51336.cljs$lang$maxFixedArity = 2);


sablono.core.color_field = sablono.core.wrap_attrs(sablono.core.color_field51336);

/**
 * Creates a date input field.
 */
sablono.core.date_field51359 = (function sablono$core$date_field51359(var_args){
var G__51367 = arguments.length;
switch (G__51367) {
case 1:
return sablono.core.date_field51359.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field51359.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.date_field51359.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__51123__auto__);
}));

(sablono.core.date_field51359.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"date","date",177097065,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.date_field51359.cljs$lang$maxFixedArity = 2);


sablono.core.date_field = sablono.core.wrap_attrs(sablono.core.date_field51359);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field51374 = (function sablono$core$datetime_field51374(var_args){
var G__51380 = arguments.length;
switch (G__51380) {
case 1:
return sablono.core.datetime_field51374.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field51374.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_field51374.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__51123__auto__);
}));

(sablono.core.datetime_field51374.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.datetime_field51374.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_field = sablono.core.wrap_attrs(sablono.core.datetime_field51374);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field51383 = (function sablono$core$datetime_local_field51383(var_args){
var G__51385 = arguments.length;
switch (G__51385) {
case 1:
return sablono.core.datetime_local_field51383.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field51383.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.datetime_local_field51383.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__51123__auto__);
}));

(sablono.core.datetime_local_field51383.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.datetime_local_field51383.cljs$lang$maxFixedArity = 2);


sablono.core.datetime_local_field = sablono.core.wrap_attrs(sablono.core.datetime_local_field51383);

/**
 * Creates a email input field.
 */
sablono.core.email_field51392 = (function sablono$core$email_field51392(var_args){
var G__51397 = arguments.length;
switch (G__51397) {
case 1:
return sablono.core.email_field51392.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field51392.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.email_field51392.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__51123__auto__);
}));

(sablono.core.email_field51392.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"email","email",-1238619063,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.email_field51392.cljs$lang$maxFixedArity = 2);


sablono.core.email_field = sablono.core.wrap_attrs(sablono.core.email_field51392);

/**
 * Creates a file input field.
 */
sablono.core.file_field51410 = (function sablono$core$file_field51410(var_args){
var G__51421 = arguments.length;
switch (G__51421) {
case 1:
return sablono.core.file_field51410.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field51410.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.file_field51410.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__51123__auto__);
}));

(sablono.core.file_field51410.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"file","file",370885649,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.file_field51410.cljs$lang$maxFixedArity = 2);


sablono.core.file_field = sablono.core.wrap_attrs(sablono.core.file_field51410);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field51426 = (function sablono$core$hidden_field51426(var_args){
var G__51429 = arguments.length;
switch (G__51429) {
case 1:
return sablono.core.hidden_field51426.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field51426.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.hidden_field51426.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__51123__auto__);
}));

(sablono.core.hidden_field51426.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.hidden_field51426.cljs$lang$maxFixedArity = 2);


sablono.core.hidden_field = sablono.core.wrap_attrs(sablono.core.hidden_field51426);

/**
 * Creates a month input field.
 */
sablono.core.month_field51440 = (function sablono$core$month_field51440(var_args){
var G__51444 = arguments.length;
switch (G__51444) {
case 1:
return sablono.core.month_field51440.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field51440.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.month_field51440.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__51123__auto__);
}));

(sablono.core.month_field51440.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"month","month",-319717006,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.month_field51440.cljs$lang$maxFixedArity = 2);


sablono.core.month_field = sablono.core.wrap_attrs(sablono.core.month_field51440);

/**
 * Creates a number input field.
 */
sablono.core.number_field51457 = (function sablono$core$number_field51457(var_args){
var G__51468 = arguments.length;
switch (G__51468) {
case 1:
return sablono.core.number_field51457.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field51457.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.number_field51457.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__51123__auto__);
}));

(sablono.core.number_field51457.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"number","number",-1084057331,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.number_field51457.cljs$lang$maxFixedArity = 2);


sablono.core.number_field = sablono.core.wrap_attrs(sablono.core.number_field51457);

/**
 * Creates a password input field.
 */
sablono.core.password_field51473 = (function sablono$core$password_field51473(var_args){
var G__51493 = arguments.length;
switch (G__51493) {
case 1:
return sablono.core.password_field51473.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field51473.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.password_field51473.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__51123__auto__);
}));

(sablono.core.password_field51473.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"password","password",2057553998,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.password_field51473.cljs$lang$maxFixedArity = 2);


sablono.core.password_field = sablono.core.wrap_attrs(sablono.core.password_field51473);

/**
 * Creates a range input field.
 */
sablono.core.range_field51505 = (function sablono$core$range_field51505(var_args){
var G__51511 = arguments.length;
switch (G__51511) {
case 1:
return sablono.core.range_field51505.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field51505.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.range_field51505.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__51123__auto__);
}));

(sablono.core.range_field51505.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"range","range",-1014743483,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.range_field51505.cljs$lang$maxFixedArity = 2);


sablono.core.range_field = sablono.core.wrap_attrs(sablono.core.range_field51505);

/**
 * Creates a search input field.
 */
sablono.core.search_field51520 = (function sablono$core$search_field51520(var_args){
var G__51528 = arguments.length;
switch (G__51528) {
case 1:
return sablono.core.search_field51520.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field51520.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.search_field51520.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__51123__auto__);
}));

(sablono.core.search_field51520.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"search","search",-1089495947,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.search_field51520.cljs$lang$maxFixedArity = 2);


sablono.core.search_field = sablono.core.wrap_attrs(sablono.core.search_field51520);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field51537 = (function sablono$core$tel_field51537(var_args){
var G__51546 = arguments.length;
switch (G__51546) {
case 1:
return sablono.core.tel_field51537.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field51537.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.tel_field51537.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__51123__auto__);
}));

(sablono.core.tel_field51537.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"tel","tel",1864669686,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.tel_field51537.cljs$lang$maxFixedArity = 2);


sablono.core.tel_field = sablono.core.wrap_attrs(sablono.core.tel_field51537);

/**
 * Creates a text input field.
 */
sablono.core.text_field51559 = (function sablono$core$text_field51559(var_args){
var G__51563 = arguments.length;
switch (G__51563) {
case 1:
return sablono.core.text_field51559.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field51559.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_field51559.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__51123__auto__);
}));

(sablono.core.text_field51559.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"text","text",-150030170,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.text_field51559.cljs$lang$maxFixedArity = 2);


sablono.core.text_field = sablono.core.wrap_attrs(sablono.core.text_field51559);

/**
 * Creates a time input field.
 */
sablono.core.time_field51580 = (function sablono$core$time_field51580(var_args){
var G__51584 = arguments.length;
switch (G__51584) {
case 1:
return sablono.core.time_field51580.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field51580.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.time_field51580.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__51123__auto__);
}));

(sablono.core.time_field51580.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"time","time",-1268547887,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.time_field51580.cljs$lang$maxFixedArity = 2);


sablono.core.time_field = sablono.core.wrap_attrs(sablono.core.time_field51580);

/**
 * Creates a url input field.
 */
sablono.core.url_field51591 = (function sablono$core$url_field51591(var_args){
var G__51596 = arguments.length;
switch (G__51596) {
case 1:
return sablono.core.url_field51591.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field51591.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.url_field51591.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__51123__auto__);
}));

(sablono.core.url_field51591.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"url","url",1916828573,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.url_field51591.cljs$lang$maxFixedArity = 2);


sablono.core.url_field = sablono.core.wrap_attrs(sablono.core.url_field51591);

/**
 * Creates a week input field.
 */
sablono.core.week_field51604 = (function sablono$core$week_field51604(var_args){
var G__51611 = arguments.length;
switch (G__51611) {
case 1:
return sablono.core.week_field51604.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field51604.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.week_field51604.cljs$core$IFn$_invoke$arity$1 = (function (name__51123__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__51123__auto__);
}));

(sablono.core.week_field51604.cljs$core$IFn$_invoke$arity$2 = (function (name__51123__auto__,value__51125__auto__){
return sablono.core.input_field_STAR_.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"week","week",314058249,null)),name__51123__auto__,value__51125__auto__);
}));

(sablono.core.week_field51604.cljs$lang$maxFixedArity = 2);


sablono.core.week_field = sablono.core.wrap_attrs(sablono.core.week_field51604);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box51617 = (function sablono$core$check_box51617(var_args){
var G__51623 = arguments.length;
switch (G__51623) {
case 1:
return sablono.core.check_box51617.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box51617.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box51617.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.check_box51617.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.check_box51617.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box51617.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.check_box51617.cljs$lang$maxFixedArity = 3);


sablono.core.check_box = sablono.core.wrap_attrs(sablono.core.check_box51617);
/**
 * Creates a radio button.
 */
sablono.core.radio_button51643 = (function sablono$core$radio_button51643(var_args){
var G__51650 = arguments.length;
switch (G__51650) {
case 1:
return sablono.core.radio_button51643.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button51643.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button51643.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.radio_button51643.cljs$core$IFn$_invoke$arity$1 = (function (group){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)))], null)], null);
}));

(sablono.core.radio_button51643.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0))),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button51643.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id([sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([group], 0)),"-",sablono.util.as_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0))].join('')),new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
}));

(sablono.core.radio_button51643.cljs$lang$maxFixedArity = 3);


sablono.core.radio_button = sablono.core.wrap_attrs(sablono.core.radio_button51643);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0)));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options51667 = (function sablono$core$select_options51667(coll){
var iter__4529__auto__ = (function sablono$core$select_options51667_$_iter__51669(s__51670){
return (new cljs.core.LazySeq(null,(function (){
var s__51670__$1 = s__51670;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__51670__$1);
if(temp__5735__auto__){
var s__51670__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__51670__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__51670__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__51672 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__51671 = (0);
while(true){
if((i__51671 < size__4528__auto__)){
var x = cljs.core._nth(c__4527__auto__,i__51671);
cljs.core.chunk_append(b__51672,((cljs.core.sequential_QMARK_(x))?(function (){var vec__51684 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51684,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51684,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51684,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options51667.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options51667.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options51667.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__51910 = (i__51671 + (1));
i__51671 = G__51910;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__51672),sablono$core$select_options51667_$_iter__51669(cljs.core.chunk_rest(s__51670__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__51672),null);
}
} else {
var x = cljs.core.first(s__51670__$2);
return cljs.core.cons(((cljs.core.sequential_QMARK_(x))?(function (){var vec__51695 = x;
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51695,(0),null);
var val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51695,(1),null);
var disabled_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51695,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$(disabled_QMARK_);
if(cljs.core.sequential_QMARK_(val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),(sablono.core.select_options51667.cljs$core$IFn$_invoke$arity$1 ? sablono.core.select_options51667.cljs$core$IFn$_invoke$arity$1(val) : sablono.core.select_options51667.call(null,val))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key(x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options51667_$_iter__51669(cljs.core.rest(s__51670__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
});

sablono.core.select_options = sablono.core.wrap_attrs(sablono.core.select_options51667);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down51698 = (function sablono$core$drop_down51698(var_args){
var G__51708 = arguments.length;
switch (G__51708) {
case 2:
return sablono.core.drop_down51698.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down51698.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.drop_down51698.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down51698.cljs$core$IFn$_invoke$arity$3(name,options,null);
}));

(sablono.core.drop_down51698.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null),sablono.core.select_options(options,selected)], null);
}));

(sablono.core.drop_down51698.cljs$lang$maxFixedArity = 3);


sablono.core.drop_down = sablono.core.wrap_attrs(sablono.core.drop_down51698);
/**
 * Creates a text area element.
 */
sablono.core.text_area51719 = (function sablono$core$text_area51719(var_args){
var G__51724 = arguments.length;
switch (G__51724) {
case 1:
return sablono.core.text_area51719.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area51719.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(sablono.core.text_area51719.cljs$core$IFn$_invoke$arity$1 = (function (name){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name)], null)], null);
}));

(sablono.core.text_area51719.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name(name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id(name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4126__auto__ = value;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return undefined;
}
})()], null)], null);
}));

(sablono.core.text_area51719.cljs$lang$maxFixedArity = 2);


sablono.core.text_area = sablono.core.wrap_attrs(sablono.core.text_area51719);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label51727 = (function sablono$core$label51727(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id(name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs(sablono.core.label51727);
/**
 * Creates a submit button.
 */
sablono.core.submit_button51730 = (function sablono$core$submit_button51730(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs(sablono.core.submit_button51730);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button51738 = (function sablono$core$reset_button51738(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs(sablono.core.reset_button51738);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to51740 = (function sablono$core$form_to51740(var_args){
var args__4742__auto__ = [];
var len__4736__auto___51931 = arguments.length;
var i__4737__auto___51932 = (0);
while(true){
if((i__4737__auto___51932 < len__4736__auto___51931)){
args__4742__auto__.push((arguments[i__4737__auto___51932]));

var G__51933 = (i__4737__auto___51932 + (1));
i__4737__auto___51932 = G__51933;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to51740.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(sablono.core.form_to51740.cljs$core$IFn$_invoke$arity$variadic = (function (p__51750,body){
var vec__51751 = p__51750;
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51751,(0),null);
var action = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51751,(1),null);
var method_str = clojure.string.upper_case(cljs.core.name(method));
var action_uri = sablono.util.to_uri(action);
return cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
}));

(sablono.core.form_to51740.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sablono.core.form_to51740.cljs$lang$applyTo = (function (seq51741){
var G__51742 = cljs.core.first(seq51741);
var seq51741__$1 = cljs.core.next(seq51741);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__51742,seq51741__$1);
}));


sablono.core.form_to = sablono.core.wrap_attrs(sablono.core.form_to51740);

//# sourceMappingURL=sablono.core.js.map
