goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.userAgent.product');
goog.require('goog.Uri');
goog.require('goog.net.XhrIo');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
goog.require('clojure.set');
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.repl_ns_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.repl_ns_ref = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
}
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.socket_ref !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.socket_ref = cljs.core.volatile_BANG_(null);
}
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___57123 = arguments.length;
var i__4737__auto___57124 = (0);
while(true){
if((i__4737__auto___57124 < len__4736__auto___57123)){
args__4742__auto__.push((arguments[i__4737__auto___57124]));

var G__57125 = (i__4737__auto___57124 + (1));
i__4737__auto___57124 = G__57125;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
if(cljs.core.seq(shadow.cljs.devtools.client.env.log_style)){
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%c\uD83E\uDC36 shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),shadow.cljs.devtools.client.env.log_style], null),args)));
} else {
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null),args)));
}
}));

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq56686){
var G__56687 = cljs.core.first(seq56686);
var seq56686__$1 = cljs.core.next(seq56686);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56687,seq56686__$1);
}));

shadow.cljs.devtools.client.browser.ws_msg = (function shadow$cljs$devtools$client$browser$ws_msg(msg){
var temp__5733__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5733__auto__)){
var s = temp__5733__auto__;
return s.send(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
} else {
return console.warn("WEBSOCKET NOT CONNECTED",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([msg], 0)));
}
});
shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__56703 = cljs.core.seq(sources);
var chunk__56704 = null;
var count__56705 = (0);
var i__56706 = (0);
while(true){
if((i__56706 < count__56705)){
var map__56748 = chunk__56704.cljs$core$IIndexed$_nth$arity$2(null,i__56706);
var map__56748__$1 = (((((!((map__56748 == null))))?(((((map__56748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56748):map__56748);
var src = map__56748__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56748__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56748__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56748__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56748__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e56752){var e_57147 = e56752;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_57147);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_57147.message)].join('')));
}

var G__57149 = seq__56703;
var G__57150 = chunk__56704;
var G__57151 = count__56705;
var G__57152 = (i__56706 + (1));
seq__56703 = G__57149;
chunk__56704 = G__57150;
count__56705 = G__57151;
i__56706 = G__57152;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__56703);
if(temp__5735__auto__){
var seq__56703__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56703__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__56703__$1);
var G__57153 = cljs.core.chunk_rest(seq__56703__$1);
var G__57154 = c__4556__auto__;
var G__57155 = cljs.core.count(c__4556__auto__);
var G__57156 = (0);
seq__56703 = G__57153;
chunk__56704 = G__57154;
count__56705 = G__57155;
i__56706 = G__57156;
continue;
} else {
var map__56754 = cljs.core.first(seq__56703__$1);
var map__56754__$1 = (((((!((map__56754 == null))))?(((((map__56754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56754.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56754):map__56754);
var src = map__56754__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56754__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56754__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56754__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56754__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e56760){var e_57173 = e56760;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_57173);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_57173.message)].join('')));
}

var G__57181 = cljs.core.next(seq__56703__$1);
var G__57182 = null;
var G__57183 = (0);
var G__57184 = (0);
seq__56703 = G__57181;
chunk__56704 = G__57182;
count__56705 = G__57183;
i__56706 = G__57184;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return null;
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__56765 = cljs.core.seq(js_requires);
var chunk__56766 = null;
var count__56767 = (0);
var i__56768 = (0);
while(true){
if((i__56768 < count__56767)){
var js_ns = chunk__56766.cljs$core$IIndexed$_nth$arity$2(null,i__56768);
var require_str_57189 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_57189);


var G__57190 = seq__56765;
var G__57191 = chunk__56766;
var G__57192 = count__56767;
var G__57193 = (i__56768 + (1));
seq__56765 = G__57190;
chunk__56766 = G__57191;
count__56767 = G__57192;
i__56768 = G__57193;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__56765);
if(temp__5735__auto__){
var seq__56765__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56765__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__56765__$1);
var G__57196 = cljs.core.chunk_rest(seq__56765__$1);
var G__57197 = c__4556__auto__;
var G__57198 = cljs.core.count(c__4556__auto__);
var G__57199 = (0);
seq__56765 = G__57196;
chunk__56766 = G__57197;
count__56767 = G__57198;
i__56768 = G__57199;
continue;
} else {
var js_ns = cljs.core.first(seq__56765__$1);
var require_str_57208 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_57208);


var G__57209 = cljs.core.next(seq__56765__$1);
var G__57210 = null;
var G__57211 = (0);
var G__57212 = (0);
seq__56765 = G__57209;
chunk__56766 = G__57210;
count__56767 = G__57211;
i__56768 = G__57212;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.load_sources = (function shadow$cljs$devtools$client$browser$load_sources(sources,callback){
if(cljs.core.empty_QMARK_(sources)){
var G__56773 = cljs.core.PersistentVector.EMPTY;
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__56773) : callback.call(null,G__56773));
} else {
return goog.net.XhrIo.send(shadow.cljs.devtools.client.env.files_url(),(function (res){
var req = this;
var content = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(content) : callback.call(null,content));
}),"POST",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"client","client",-1323448117),new cljs.core.Keyword(null,"browser","browser",828191719),new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources)], null)], 0)),({"content-type": "application/edn; charset=utf-8"}));
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(p__56775){
var map__56776 = p__56775;
var map__56776__$1 = (((((!((map__56776 == null))))?(((((map__56776.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56776.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56776):map__56776);
var msg = map__56776__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56776__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56776__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4529__auto__ = (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__56778(s__56779){
return (new cljs.core.LazySeq(null,(function (){
var s__56779__$1 = s__56779;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__56779__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var map__56784 = cljs.core.first(xs__6292__auto__);
var map__56784__$1 = (((((!((map__56784 == null))))?(((((map__56784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56784.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56784):map__56784);
var src = map__56784__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56784__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56784__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4525__auto__ = ((function (s__56779__$1,map__56784,map__56784__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__56776,map__56776__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__56778_$_iter__56780(s__56781){
return (new cljs.core.LazySeq(null,((function (s__56779__$1,map__56784,map__56784__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__56776,map__56776__$1,msg,info,reload_info){
return (function (){
var s__56781__$1 = s__56781;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__56781__$1);
if(temp__5735__auto____$1){
var s__56781__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__56781__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__56781__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__56783 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__56782 = (0);
while(true){
if((i__56782 < size__4528__auto__)){
var warning = cljs.core._nth(c__4527__auto__,i__56782);
cljs.core.chunk_append(b__56783,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__57228 = (i__56782 + (1));
i__56782 = G__57228;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__56783),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__56778_$_iter__56780(cljs.core.chunk_rest(s__56781__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__56783),null);
}
} else {
var warning = cljs.core.first(s__56781__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__56778_$_iter__56780(cljs.core.rest(s__56781__$2)));
}
} else {
return null;
}
break;
}
});})(s__56779__$1,map__56784,map__56784__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__56776,map__56776__$1,msg,info,reload_info))
,null,null));
});})(s__56779__$1,map__56784,map__56784__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__56776,map__56776__$1,msg,info,reload_info))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(warnings));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__56778(cljs.core.rest(s__56779__$1)));
} else {
var G__57230 = cljs.core.rest(s__56779__$1);
s__56779__$1 = G__57230;
continue;
}
} else {
var G__57231 = cljs.core.rest(s__56779__$1);
s__56779__$1 = G__57231;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(info));
})()));
var seq__56786_57232 = cljs.core.seq(warnings);
var chunk__56787_57233 = null;
var count__56788_57234 = (0);
var i__56789_57235 = (0);
while(true){
if((i__56789_57235 < count__56788_57234)){
var map__56802_57238 = chunk__56787_57233.cljs$core$IIndexed$_nth$arity$2(null,i__56789_57235);
var map__56802_57239__$1 = (((((!((map__56802_57238 == null))))?(((((map__56802_57238.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56802_57238.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56802_57238):map__56802_57238);
var w_57240 = map__56802_57239__$1;
var msg_57241__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56802_57239__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_57242 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56802_57239__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_57243 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56802_57239__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_57244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56802_57239__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_57244)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_57242),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_57243),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_57241__$1)].join(''));


var G__57247 = seq__56786_57232;
var G__57248 = chunk__56787_57233;
var G__57249 = count__56788_57234;
var G__57250 = (i__56789_57235 + (1));
seq__56786_57232 = G__57247;
chunk__56787_57233 = G__57248;
count__56788_57234 = G__57249;
i__56789_57235 = G__57250;
continue;
} else {
var temp__5735__auto___57251 = cljs.core.seq(seq__56786_57232);
if(temp__5735__auto___57251){
var seq__56786_57252__$1 = temp__5735__auto___57251;
if(cljs.core.chunked_seq_QMARK_(seq__56786_57252__$1)){
var c__4556__auto___57253 = cljs.core.chunk_first(seq__56786_57252__$1);
var G__57254 = cljs.core.chunk_rest(seq__56786_57252__$1);
var G__57255 = c__4556__auto___57253;
var G__57256 = cljs.core.count(c__4556__auto___57253);
var G__57257 = (0);
seq__56786_57232 = G__57254;
chunk__56787_57233 = G__57255;
count__56788_57234 = G__57256;
i__56789_57235 = G__57257;
continue;
} else {
var map__56817_57258 = cljs.core.first(seq__56786_57252__$1);
var map__56817_57259__$1 = (((((!((map__56817_57258 == null))))?(((((map__56817_57258.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56817_57258.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56817_57258):map__56817_57258);
var w_57260 = map__56817_57259__$1;
var msg_57261__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56817_57259__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_57262 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56817_57259__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_57263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56817_57259__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_57264 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56817_57259__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_57264)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_57262),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_57263),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_57261__$1)].join(''));


var G__57267 = cljs.core.next(seq__56786_57252__$1);
var G__57268 = null;
var G__57269 = (0);
var G__57270 = (0);
seq__56786_57232 = G__57267;
chunk__56787_57233 = G__57268;
count__56788_57234 = G__57269;
i__56789_57235 = G__57270;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = shadow.cljs.devtools.client.env.filter_reload_sources(info,reload_info);
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(cljs.core.seq(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("reloading code but no :after-load hooks are configured!",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks"], 0));
}

return shadow.cljs.devtools.client.browser.load_sources(sources_to_get,(function (p1__56774_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__56774_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
}));
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(new$,(1));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old,rel_new)) || (clojure.string.starts_with_QMARK_(old,[rel_new,"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not(node_uri.hasDomain())))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs,new$)){
return new$;
} else {
return false;
}
} else {
return false;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_watch = (function shadow$cljs$devtools$client$browser$handle_asset_watch(p__56821){
var map__56822 = p__56821;
var map__56822__$1 = (((((!((map__56822 == null))))?(((((map__56822.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56822.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56822):map__56822);
var msg = map__56822__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56822__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__56825 = cljs.core.seq(updates);
var chunk__56827 = null;
var count__56828 = (0);
var i__56829 = (0);
while(true){
if((i__56829 < count__56828)){
var path = chunk__56827.cljs$core$IIndexed$_nth$arity$2(null,i__56829);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__56879_57274 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__56882_57275 = null;
var count__56883_57276 = (0);
var i__56884_57277 = (0);
while(true){
if((i__56884_57277 < count__56883_57276)){
var node_57282 = chunk__56882_57275.cljs$core$IIndexed$_nth$arity$2(null,i__56884_57277);
var path_match_57284 = shadow.cljs.devtools.client.browser.match_paths(node_57282.getAttribute("href"),path);
if(cljs.core.truth_(path_match_57284)){
var new_link_57286 = (function (){var G__56896 = node_57282.cloneNode(true);
G__56896.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_57284),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__56896;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_57284], 0));

goog.dom.insertSiblingAfter(new_link_57286,node_57282);

goog.dom.removeNode(node_57282);


var G__57287 = seq__56879_57274;
var G__57288 = chunk__56882_57275;
var G__57289 = count__56883_57276;
var G__57290 = (i__56884_57277 + (1));
seq__56879_57274 = G__57287;
chunk__56882_57275 = G__57288;
count__56883_57276 = G__57289;
i__56884_57277 = G__57290;
continue;
} else {
var G__57291 = seq__56879_57274;
var G__57292 = chunk__56882_57275;
var G__57293 = count__56883_57276;
var G__57294 = (i__56884_57277 + (1));
seq__56879_57274 = G__57291;
chunk__56882_57275 = G__57292;
count__56883_57276 = G__57293;
i__56884_57277 = G__57294;
continue;
}
} else {
var temp__5735__auto___57295 = cljs.core.seq(seq__56879_57274);
if(temp__5735__auto___57295){
var seq__56879_57298__$1 = temp__5735__auto___57295;
if(cljs.core.chunked_seq_QMARK_(seq__56879_57298__$1)){
var c__4556__auto___57302 = cljs.core.chunk_first(seq__56879_57298__$1);
var G__57303 = cljs.core.chunk_rest(seq__56879_57298__$1);
var G__57304 = c__4556__auto___57302;
var G__57305 = cljs.core.count(c__4556__auto___57302);
var G__57306 = (0);
seq__56879_57274 = G__57303;
chunk__56882_57275 = G__57304;
count__56883_57276 = G__57305;
i__56884_57277 = G__57306;
continue;
} else {
var node_57309 = cljs.core.first(seq__56879_57298__$1);
var path_match_57311 = shadow.cljs.devtools.client.browser.match_paths(node_57309.getAttribute("href"),path);
if(cljs.core.truth_(path_match_57311)){
var new_link_57312 = (function (){var G__56900 = node_57309.cloneNode(true);
G__56900.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_57311),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__56900;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_57311], 0));

goog.dom.insertSiblingAfter(new_link_57312,node_57309);

goog.dom.removeNode(node_57309);


var G__57313 = cljs.core.next(seq__56879_57298__$1);
var G__57314 = null;
var G__57315 = (0);
var G__57316 = (0);
seq__56879_57274 = G__57313;
chunk__56882_57275 = G__57314;
count__56883_57276 = G__57315;
i__56884_57277 = G__57316;
continue;
} else {
var G__57317 = cljs.core.next(seq__56879_57298__$1);
var G__57318 = null;
var G__57319 = (0);
var G__57320 = (0);
seq__56879_57274 = G__57317;
chunk__56882_57275 = G__57318;
count__56883_57276 = G__57319;
i__56884_57277 = G__57320;
continue;
}
}
} else {
}
}
break;
}


var G__57327 = seq__56825;
var G__57328 = chunk__56827;
var G__57329 = count__56828;
var G__57330 = (i__56829 + (1));
seq__56825 = G__57327;
chunk__56827 = G__57328;
count__56828 = G__57329;
i__56829 = G__57330;
continue;
} else {
var G__57331 = seq__56825;
var G__57332 = chunk__56827;
var G__57333 = count__56828;
var G__57334 = (i__56829 + (1));
seq__56825 = G__57331;
chunk__56827 = G__57332;
count__56828 = G__57333;
i__56829 = G__57334;
continue;
}
} else {
var temp__5735__auto__ = cljs.core.seq(seq__56825);
if(temp__5735__auto__){
var seq__56825__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__56825__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__56825__$1);
var G__57338 = cljs.core.chunk_rest(seq__56825__$1);
var G__57339 = c__4556__auto__;
var G__57340 = cljs.core.count(c__4556__auto__);
var G__57341 = (0);
seq__56825 = G__57338;
chunk__56827 = G__57339;
count__56828 = G__57340;
i__56829 = G__57341;
continue;
} else {
var path = cljs.core.first(seq__56825__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__56913_57343 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__56916_57344 = null;
var count__56917_57345 = (0);
var i__56918_57346 = (0);
while(true){
if((i__56918_57346 < count__56917_57345)){
var node_57351 = chunk__56916_57344.cljs$core$IIndexed$_nth$arity$2(null,i__56918_57346);
var path_match_57352 = shadow.cljs.devtools.client.browser.match_paths(node_57351.getAttribute("href"),path);
if(cljs.core.truth_(path_match_57352)){
var new_link_57353 = (function (){var G__56952 = node_57351.cloneNode(true);
G__56952.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_57352),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__56952;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_57352], 0));

goog.dom.insertSiblingAfter(new_link_57353,node_57351);

goog.dom.removeNode(node_57351);


var G__57358 = seq__56913_57343;
var G__57359 = chunk__56916_57344;
var G__57360 = count__56917_57345;
var G__57361 = (i__56918_57346 + (1));
seq__56913_57343 = G__57358;
chunk__56916_57344 = G__57359;
count__56917_57345 = G__57360;
i__56918_57346 = G__57361;
continue;
} else {
var G__57363 = seq__56913_57343;
var G__57364 = chunk__56916_57344;
var G__57365 = count__56917_57345;
var G__57366 = (i__56918_57346 + (1));
seq__56913_57343 = G__57363;
chunk__56916_57344 = G__57364;
count__56917_57345 = G__57365;
i__56918_57346 = G__57366;
continue;
}
} else {
var temp__5735__auto___57367__$1 = cljs.core.seq(seq__56913_57343);
if(temp__5735__auto___57367__$1){
var seq__56913_57368__$1 = temp__5735__auto___57367__$1;
if(cljs.core.chunked_seq_QMARK_(seq__56913_57368__$1)){
var c__4556__auto___57375 = cljs.core.chunk_first(seq__56913_57368__$1);
var G__57377 = cljs.core.chunk_rest(seq__56913_57368__$1);
var G__57378 = c__4556__auto___57375;
var G__57379 = cljs.core.count(c__4556__auto___57375);
var G__57380 = (0);
seq__56913_57343 = G__57377;
chunk__56916_57344 = G__57378;
count__56917_57345 = G__57379;
i__56918_57346 = G__57380;
continue;
} else {
var node_57381 = cljs.core.first(seq__56913_57368__$1);
var path_match_57382 = shadow.cljs.devtools.client.browser.match_paths(node_57381.getAttribute("href"),path);
if(cljs.core.truth_(path_match_57382)){
var new_link_57383 = (function (){var G__56957 = node_57381.cloneNode(true);
G__56957.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_57382),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__56957;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_57382], 0));

goog.dom.insertSiblingAfter(new_link_57383,node_57381);

goog.dom.removeNode(node_57381);


var G__57384 = cljs.core.next(seq__56913_57368__$1);
var G__57385 = null;
var G__57386 = (0);
var G__57387 = (0);
seq__56913_57343 = G__57384;
chunk__56916_57344 = G__57385;
count__56917_57345 = G__57386;
i__56918_57346 = G__57387;
continue;
} else {
var G__57394 = cljs.core.next(seq__56913_57368__$1);
var G__57395 = null;
var G__57396 = (0);
var G__57397 = (0);
seq__56913_57343 = G__57394;
chunk__56916_57344 = G__57395;
count__56917_57345 = G__57396;
i__56918_57346 = G__57397;
continue;
}
}
} else {
}
}
break;
}


var G__57400 = cljs.core.next(seq__56825__$1);
var G__57401 = null;
var G__57402 = (0);
var G__57403 = (0);
seq__56825 = G__57400;
chunk__56827 = G__57401;
count__56828 = G__57402;
i__56829 = G__57403;
continue;
} else {
var G__57404 = cljs.core.next(seq__56825__$1);
var G__57405 = null;
var G__57406 = (0);
var G__57407 = (0);
seq__56825 = G__57404;
chunk__56827 = G__57405;
count__56828 = G__57406;
i__56829 = G__57407;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.get_ua_product = (function shadow$cljs$devtools$client$browser$get_ua_product(){
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
});
shadow.cljs.devtools.client.browser.get_asset_root = (function shadow$cljs$devtools$client$browser$get_asset_root(){
var loc = (new goog.Uri(document.location.href));
var cbp = (new goog.Uri(CLOSURE_BASE_PATH));
var s = loc.resolve(cbp).toString();
return clojure.string.replace(s,/^file:\//,"file:///");
});
shadow.cljs.devtools.client.browser.repl_error = (function shadow$cljs$devtools$client$browser$repl_error(e){
console.error("repl/invoke error",e);

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(shadow.cljs.devtools.client.env.repl_error(e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),shadow.cljs.devtools.client.browser.get_ua_product(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"asset-root","asset-root",1771735072),shadow.cljs.devtools.client.browser.get_asset_root()], 0));
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("undefined",typeof(module))){
return eval(js);
} else {
return (0,eval)(js);;
}
});
shadow.cljs.devtools.client.browser.repl_invoke = (function shadow$cljs$devtools$client$browser$repl_invoke(p__56965){
var map__56966 = p__56965;
var map__56966__$1 = (((((!((map__56966 == null))))?(((((map__56966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56966.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56966):map__56966);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56966__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56966__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var result = shadow.cljs.devtools.client.env.repl_call((function (){
return shadow.cljs.devtools.client.browser.global_eval(js);
}),shadow.cljs.devtools.client.browser.repl_error);
return shadow.cljs.devtools.client.browser.ws_msg(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"id","id",-1388402092),id));
});
shadow.cljs.devtools.client.browser.repl_require = (function shadow$cljs$devtools$client$browser$repl_require(p__56976,done){
var map__56977 = p__56976;
var map__56977__$1 = (((((!((map__56977 == null))))?(((((map__56977.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56977.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56977):map__56977);
var msg = map__56977__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56977__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56977__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56977__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56977__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__56986){
var map__56988 = p__56986;
var map__56988__$1 = (((((!((map__56988 == null))))?(((((map__56988.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__56988.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__56988):map__56988);
var src = map__56988__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__56988__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4115__auto__ = shadow.cljs.devtools.client.env.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__4115__auto__;
}
}),sources));
return shadow.cljs.devtools.client.browser.load_sources(sources_to_load,(function (sources__$1){
try{shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-complete","repl/require-complete",-2140254719),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));
}catch (e56994){var e = e56994;
return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","require-error","repl/require-error",1689310021),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"error","error",-978969032),e.message], null));
}finally {(done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}}));
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(p__57014,done){
var map__57016 = p__57014;
var map__57016__$1 = (((((!((map__57016 == null))))?(((((map__57016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57016.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57016):map__57016);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57016__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57016__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return shadow.cljs.devtools.client.browser.load_sources(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","init-complete","repl/init-complete",-162252879),new cljs.core.Keyword(null,"id","id",-1388402092),id], null));

shadow.cljs.devtools.client.browser.devtools_msg("REPL session start successful");

return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}));
});
shadow.cljs.devtools.client.browser.repl_set_ns = (function shadow$cljs$devtools$client$browser$repl_set_ns(p__57022){
var map__57024 = p__57022;
var map__57024__$1 = (((((!((map__57024 == null))))?(((((map__57024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57024.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57024):map__57024);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57024__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57024__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
return shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","set-ns-complete","repl/set-ns-complete",680944662),new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
});
shadow.cljs.devtools.client.browser.close_reason_ref = cljs.core.volatile_BANG_(null);
shadow.cljs.devtools.client.browser.stale_client_detected = cljs.core.volatile_BANG_(false);
shadow.cljs.devtools.client.browser.handle_message = (function shadow$cljs$devtools$client$browser$handle_message(p__57037,done){
var map__57038 = p__57037;
var map__57038__$1 = (((((!((map__57038 == null))))?(((((map__57038.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__57038.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__57038):map__57038);
var msg = map__57038__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__57038__$1,new cljs.core.Keyword(null,"type","type",1174270348));
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

var G__57043_57437 = type;
var G__57043_57438__$1 = (((G__57043_57437 instanceof cljs.core.Keyword))?G__57043_57437.fqn:null);
switch (G__57043_57438__$1) {
case "asset-watch":
shadow.cljs.devtools.client.browser.handle_asset_watch(msg);

break;
case "repl/invoke":
shadow.cljs.devtools.client.browser.repl_invoke(msg);

break;
case "repl/require":
shadow.cljs.devtools.client.browser.repl_require(msg,done);

break;
case "repl/set-ns":
shadow.cljs.devtools.client.browser.repl_set_ns(msg);

break;
case "repl/init":
shadow.cljs.devtools.client.browser.repl_init(msg,done);

break;
case "repl/session-start":
shadow.cljs.devtools.client.browser.repl_init(msg,done);

break;
case "repl/ping":
shadow.cljs.devtools.client.browser.ws_msg(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("repl","pong","repl/pong",-166610159),new cljs.core.Keyword(null,"time-server","time-server",786726561),new cljs.core.Keyword(null,"time-server","time-server",786726561).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"time-runtime","time-runtime",-40294923),Date.now()], null));

break;
case "build-complete":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

shadow.cljs.devtools.client.browser.handle_build_complete(msg);

break;
case "build-failure":
shadow.cljs.devtools.client.hud.load_end();

shadow.cljs.devtools.client.hud.hud_error(msg);

break;
case "build-init":
shadow.cljs.devtools.client.hud.hud_warnings(msg);

break;
case "build-start":
shadow.cljs.devtools.client.hud.hud_hide();

shadow.cljs.devtools.client.hud.load_start();

break;
case "pong":

break;
case "client/stale":
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,"Stale Client! You are not using the latest compilation output!");

break;
case "client/no-worker":
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.stale_client_detected,true);

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,["watch for build \"",shadow.cljs.devtools.client.env.build_id,"\" not running"].join(''));

break;
case "custom-msg":
shadow.cljs.devtools.client.env.publish_BANG_(new cljs.core.Keyword(null,"payload","payload",-383036092).cljs$core$IFn$_invoke$arity$1(msg));

break;
default:

}

if(cljs.core.contains_QMARK_(shadow.cljs.devtools.client.env.async_ops,type)){
return null;
} else {
return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}
});
shadow.cljs.devtools.client.browser.compile = (function shadow$cljs$devtools$client$browser$compile(text,callback){
return goog.net.XhrIo.send(["http",((shadow.cljs.devtools.client.env.ssl)?"s":null),"://",shadow.cljs.devtools.client.env.server_host,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.env.server_port),"/worker/compile/",shadow.cljs.devtools.client.env.build_id,"/",shadow.cljs.devtools.client.env.proc_id,"/browser"].join(''),(function (res){
var req = this;
var actions = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(req.getResponseText());
if(cljs.core.truth_(callback)){
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(actions) : callback.call(null,actions));
} else {
return null;
}
}),"POST",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"input","input",556931961),text], null)], 0)),({"content-type": "application/edn; charset=utf-8"}));
});
if((typeof shadow !== 'undefined') && (typeof shadow.cljs !== 'undefined') && (typeof shadow.cljs.devtools !== 'undefined') && (typeof shadow.cljs.devtools.client !== 'undefined') && (typeof shadow.cljs.devtools.client.browser !== 'undefined') && (typeof shadow.cljs.devtools.client.browser.ws_status !== 'undefined')){
} else {
shadow.cljs.devtools.client.browser.ws_status = cljs.core.volatile_BANG_(new cljs.core.Keyword(null,"init","init",-1875481434));
}
shadow.cljs.devtools.client.browser.ws_connect = (function shadow$cljs$devtools$client$browser$ws_connect(){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((function (){var fexpr__57066 = cljs.core.deref(shadow.cljs.devtools.client.browser.ws_status);
return (fexpr__57066.cljs$core$IFn$_invoke$arity$1 ? fexpr__57066.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"init","init",-1875481434)) : fexpr__57066.call(null,new cljs.core.Keyword(null,"init","init",-1875481434)));
})())){
return (shadow.cljs.devtools.client.browser.ws_connect_impl.cljs$core$IFn$_invoke$arity$0 ? shadow.cljs.devtools.client.browser.ws_connect_impl.cljs$core$IFn$_invoke$arity$0() : shadow.cljs.devtools.client.browser.ws_connect_impl.call(null));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.maybe_reconnect = (function shadow$cljs$devtools$client$browser$maybe_reconnect(){
if(((cljs.core.not(cljs.core.deref(shadow.cljs.devtools.client.browser.stale_client_detected))) && (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.cljs.devtools.client.browser.ws_status),new cljs.core.Keyword(null,"init","init",-1875481434))))){
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"init","init",-1875481434));

return setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(3000));
} else {
return null;
}
});
shadow.cljs.devtools.client.browser.ws_connect_impl = (function shadow$cljs$devtools$client$browser$ws_connect_impl(){
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connecting","connecting",-1347943866));

try{var print_fn = cljs.core._STAR_print_fn_STAR_;
var ws_url = shadow.cljs.devtools.client.env.ws_url(new cljs.core.Keyword(null,"browser","browser",828191719));
var socket = (new WebSocket(ws_url));
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,socket);

(socket.onmessage = (function (e){
return shadow.cljs.devtools.client.env.process_ws_msg(e.data,shadow.cljs.devtools.client.browser.handle_message);
}));

(socket.onopen = (function (e){
cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.ws_status,new cljs.core.Keyword(null,"connected","connected",-169833045));

shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.close_reason_ref,null);

shadow.cljs.devtools.client.env.patch_goog_BANG_();

shadow.cljs.devtools.client.env.set_print_fns_BANG_(shadow.cljs.devtools.client.browser.ws_msg);

return shadow.cljs.devtools.client.browser.devtools_msg("WebSocket connected!");
}));

(socket.onclose = (function (e){
shadow.cljs.devtools.client.browser.devtools_msg("WebSocket disconnected!");

shadow.cljs.devtools.client.hud.connection_error((function (){var or__4126__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.close_reason_ref);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Connection closed!";
}
})());

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);

shadow.cljs.devtools.client.env.reset_print_fns_BANG_();

return shadow.cljs.devtools.client.browser.maybe_reconnect();
}));

return (socket.onerror = (function (e){
shadow.cljs.devtools.client.hud.connection_error("Connection failed!");

shadow.cljs.devtools.client.browser.maybe_reconnect();

return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("websocket error",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}));
}catch (e57070){var e = e57070;
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("WebSocket setup failed",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
if(shadow.cljs.devtools.client.env.enabled){
var temp__5735__auto___57461 = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto___57461)){
var s_57463 = temp__5735__auto___57461;
shadow.cljs.devtools.client.browser.devtools_msg("connection reset!");

(s_57463.onclose = (function (e){
return null;
}));

s_57463.close();

cljs.core.vreset_BANG_(shadow.cljs.devtools.client.browser.socket_ref,null);
} else {
}

if(cljs.core.truth_(goog.global.window)){
window.addEventListener("beforeunload",(function (){
var temp__5735__auto__ = cljs.core.deref(shadow.cljs.devtools.client.browser.socket_ref);
if(cljs.core.truth_(temp__5735__auto__)){
var s = temp__5735__auto__;
return s.close();
} else {
return null;
}
}));
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = goog.global.document;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("loading",goog.global.document.readyState);
} else {
return and__4115__auto__;
}
})())){
window.addEventListener("DOMContentLoaded",shadow.cljs.devtools.client.browser.ws_connect);
} else {
setTimeout(shadow.cljs.devtools.client.browser.ws_connect,(10));
}
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
