goog.provide('shadow.dom');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.dom.forms');
goog.require('goog.dom.classlist');
goog.require('goog.style');
goog.require('goog.style.transition');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('cljs.core.async');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_52291 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_52291(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_52317 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_52317(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__51230 = coll;
var G__51231 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__51230,G__51231) : shadow.dom.lazy_native_coll_seq.call(null,G__51230,G__51231));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__51291 = arguments.length;
switch (G__51291) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__51307 = arguments.length;
switch (G__51307) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__51316 = arguments.length;
switch (G__51316) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__51331 = arguments.length;
switch (G__51331) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__51361 = arguments.length;
switch (G__51361) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__51382 = arguments.length;
switch (G__51382) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e51391){if((e51391 instanceof Object)){
var e = e51391;
return console.log("didnt support attachEvent",el,e);
} else {
throw e51391;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__51413 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__51414 = null;
var count__51415 = (0);
var i__51416 = (0);
while(true){
if((i__51416 < count__51415)){
var el = chunk__51414.cljs$core$IIndexed$_nth$arity$2(null,i__51416);
var handler_52414__$1 = ((function (seq__51413,chunk__51414,count__51415,i__51416,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__51413,chunk__51414,count__51415,i__51416,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52414__$1);


var G__52417 = seq__51413;
var G__52418 = chunk__51414;
var G__52419 = count__51415;
var G__52420 = (i__51416 + (1));
seq__51413 = G__52417;
chunk__51414 = G__52418;
count__51415 = G__52419;
i__51416 = G__52420;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51413);
if(temp__5735__auto__){
var seq__51413__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51413__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51413__$1);
var G__52426 = cljs.core.chunk_rest(seq__51413__$1);
var G__52427 = c__4556__auto__;
var G__52428 = cljs.core.count(c__4556__auto__);
var G__52429 = (0);
seq__51413 = G__52426;
chunk__51414 = G__52427;
count__51415 = G__52428;
i__51416 = G__52429;
continue;
} else {
var el = cljs.core.first(seq__51413__$1);
var handler_52432__$1 = ((function (seq__51413,chunk__51414,count__51415,i__51416,el,seq__51413__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__51413,chunk__51414,count__51415,i__51416,el,seq__51413__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52432__$1);


var G__52434 = cljs.core.next(seq__51413__$1);
var G__52435 = null;
var G__52436 = (0);
var G__52437 = (0);
seq__51413 = G__52434;
chunk__51414 = G__52435;
count__51415 = G__52436;
i__51416 = G__52437;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__51454 = arguments.length;
switch (G__51454) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__51488 = cljs.core.seq(events);
var chunk__51489 = null;
var count__51491 = (0);
var i__51492 = (0);
while(true){
if((i__51492 < count__51491)){
var vec__51508 = chunk__51489.cljs$core$IIndexed$_nth$arity$2(null,i__51492);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51508,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51508,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52461 = seq__51488;
var G__52462 = chunk__51489;
var G__52463 = count__51491;
var G__52464 = (i__51492 + (1));
seq__51488 = G__52461;
chunk__51489 = G__52462;
count__51491 = G__52463;
i__51492 = G__52464;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51488);
if(temp__5735__auto__){
var seq__51488__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51488__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51488__$1);
var G__52470 = cljs.core.chunk_rest(seq__51488__$1);
var G__52471 = c__4556__auto__;
var G__52472 = cljs.core.count(c__4556__auto__);
var G__52473 = (0);
seq__51488 = G__52470;
chunk__51489 = G__52471;
count__51491 = G__52472;
i__51492 = G__52473;
continue;
} else {
var vec__51516 = cljs.core.first(seq__51488__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51516,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51516,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52475 = cljs.core.next(seq__51488__$1);
var G__52476 = null;
var G__52477 = (0);
var G__52478 = (0);
seq__51488 = G__52475;
chunk__51489 = G__52476;
count__51491 = G__52477;
i__51492 = G__52478;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__51523 = cljs.core.seq(styles);
var chunk__51524 = null;
var count__51525 = (0);
var i__51526 = (0);
while(true){
if((i__51526 < count__51525)){
var vec__51549 = chunk__51524.cljs$core$IIndexed$_nth$arity$2(null,i__51526);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51549,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51549,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52483 = seq__51523;
var G__52484 = chunk__51524;
var G__52485 = count__51525;
var G__52486 = (i__51526 + (1));
seq__51523 = G__52483;
chunk__51524 = G__52484;
count__51525 = G__52485;
i__51526 = G__52486;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51523);
if(temp__5735__auto__){
var seq__51523__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51523__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51523__$1);
var G__52491 = cljs.core.chunk_rest(seq__51523__$1);
var G__52492 = c__4556__auto__;
var G__52493 = cljs.core.count(c__4556__auto__);
var G__52494 = (0);
seq__51523 = G__52491;
chunk__51524 = G__52492;
count__51525 = G__52493;
i__51526 = G__52494;
continue;
} else {
var vec__51556 = cljs.core.first(seq__51523__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51556,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51556,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52509 = cljs.core.next(seq__51523__$1);
var G__52510 = null;
var G__52512 = (0);
var G__52513 = (0);
seq__51523 = G__52509;
chunk__51524 = G__52510;
count__51525 = G__52512;
i__51526 = G__52513;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__51571_52518 = key;
var G__51571_52519__$1 = (((G__51571_52518 instanceof cljs.core.Keyword))?G__51571_52518.fqn:null);
switch (G__51571_52519__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_52534 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_52534,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_52534,"aria-");
}
})())){
el.setAttribute(ks_52534,value);
} else {
(el[ks_52534] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__51631){
var map__51634 = p__51631;
var map__51634__$1 = (((((!((map__51634 == null))))?(((((map__51634.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__51634.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51634):map__51634);
var props = map__51634__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51634__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__51637 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51637,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51637,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51637,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__51646 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__51646,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__51646;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__51653 = arguments.length;
switch (G__51653) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__51678){
var vec__51680 = p__51678;
var seq__51681 = cljs.core.seq(vec__51680);
var first__51682 = cljs.core.first(seq__51681);
var seq__51681__$1 = cljs.core.next(seq__51681);
var nn = first__51682;
var first__51682__$1 = cljs.core.first(seq__51681__$1);
var seq__51681__$2 = cljs.core.next(seq__51681__$1);
var np = first__51682__$1;
var nc = seq__51681__$2;
var node = vec__51680;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51689 = nn;
var G__51690 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51689,G__51690) : create_fn.call(null,G__51689,G__51690));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51693 = nn;
var G__51694 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51693,G__51694) : create_fn.call(null,G__51693,G__51694));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__51699 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51699,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51699,(1),null);
var seq__51703_52617 = cljs.core.seq(node_children);
var chunk__51705_52618 = null;
var count__51706_52619 = (0);
var i__51707_52620 = (0);
while(true){
if((i__51707_52620 < count__51706_52619)){
var child_struct_52622 = chunk__51705_52618.cljs$core$IIndexed$_nth$arity$2(null,i__51707_52620);
var children_52623 = shadow.dom.dom_node(child_struct_52622);
if(cljs.core.seq_QMARK_(children_52623)){
var seq__51754_52624 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52623));
var chunk__51756_52625 = null;
var count__51757_52626 = (0);
var i__51758_52627 = (0);
while(true){
if((i__51758_52627 < count__51757_52626)){
var child_52628 = chunk__51756_52625.cljs$core$IIndexed$_nth$arity$2(null,i__51758_52627);
if(cljs.core.truth_(child_52628)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52628);


var G__52629 = seq__51754_52624;
var G__52630 = chunk__51756_52625;
var G__52631 = count__51757_52626;
var G__52632 = (i__51758_52627 + (1));
seq__51754_52624 = G__52629;
chunk__51756_52625 = G__52630;
count__51757_52626 = G__52631;
i__51758_52627 = G__52632;
continue;
} else {
var G__52634 = seq__51754_52624;
var G__52635 = chunk__51756_52625;
var G__52636 = count__51757_52626;
var G__52637 = (i__51758_52627 + (1));
seq__51754_52624 = G__52634;
chunk__51756_52625 = G__52635;
count__51757_52626 = G__52636;
i__51758_52627 = G__52637;
continue;
}
} else {
var temp__5735__auto___52638 = cljs.core.seq(seq__51754_52624);
if(temp__5735__auto___52638){
var seq__51754_52639__$1 = temp__5735__auto___52638;
if(cljs.core.chunked_seq_QMARK_(seq__51754_52639__$1)){
var c__4556__auto___52640 = cljs.core.chunk_first(seq__51754_52639__$1);
var G__52641 = cljs.core.chunk_rest(seq__51754_52639__$1);
var G__52642 = c__4556__auto___52640;
var G__52643 = cljs.core.count(c__4556__auto___52640);
var G__52644 = (0);
seq__51754_52624 = G__52641;
chunk__51756_52625 = G__52642;
count__51757_52626 = G__52643;
i__51758_52627 = G__52644;
continue;
} else {
var child_52645 = cljs.core.first(seq__51754_52639__$1);
if(cljs.core.truth_(child_52645)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52645);


var G__52647 = cljs.core.next(seq__51754_52639__$1);
var G__52648 = null;
var G__52649 = (0);
var G__52650 = (0);
seq__51754_52624 = G__52647;
chunk__51756_52625 = G__52648;
count__51757_52626 = G__52649;
i__51758_52627 = G__52650;
continue;
} else {
var G__52654 = cljs.core.next(seq__51754_52639__$1);
var G__52655 = null;
var G__52656 = (0);
var G__52657 = (0);
seq__51754_52624 = G__52654;
chunk__51756_52625 = G__52655;
count__51757_52626 = G__52656;
i__51758_52627 = G__52657;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52623);
}


var G__52659 = seq__51703_52617;
var G__52660 = chunk__51705_52618;
var G__52661 = count__51706_52619;
var G__52662 = (i__51707_52620 + (1));
seq__51703_52617 = G__52659;
chunk__51705_52618 = G__52660;
count__51706_52619 = G__52661;
i__51707_52620 = G__52662;
continue;
} else {
var temp__5735__auto___52663 = cljs.core.seq(seq__51703_52617);
if(temp__5735__auto___52663){
var seq__51703_52664__$1 = temp__5735__auto___52663;
if(cljs.core.chunked_seq_QMARK_(seq__51703_52664__$1)){
var c__4556__auto___52665 = cljs.core.chunk_first(seq__51703_52664__$1);
var G__52667 = cljs.core.chunk_rest(seq__51703_52664__$1);
var G__52668 = c__4556__auto___52665;
var G__52669 = cljs.core.count(c__4556__auto___52665);
var G__52670 = (0);
seq__51703_52617 = G__52667;
chunk__51705_52618 = G__52668;
count__51706_52619 = G__52669;
i__51707_52620 = G__52670;
continue;
} else {
var child_struct_52672 = cljs.core.first(seq__51703_52664__$1);
var children_52673 = shadow.dom.dom_node(child_struct_52672);
if(cljs.core.seq_QMARK_(children_52673)){
var seq__51769_52674 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52673));
var chunk__51771_52675 = null;
var count__51772_52676 = (0);
var i__51773_52677 = (0);
while(true){
if((i__51773_52677 < count__51772_52676)){
var child_52680 = chunk__51771_52675.cljs$core$IIndexed$_nth$arity$2(null,i__51773_52677);
if(cljs.core.truth_(child_52680)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52680);


var G__52682 = seq__51769_52674;
var G__52683 = chunk__51771_52675;
var G__52684 = count__51772_52676;
var G__52685 = (i__51773_52677 + (1));
seq__51769_52674 = G__52682;
chunk__51771_52675 = G__52683;
count__51772_52676 = G__52684;
i__51773_52677 = G__52685;
continue;
} else {
var G__52687 = seq__51769_52674;
var G__52688 = chunk__51771_52675;
var G__52689 = count__51772_52676;
var G__52690 = (i__51773_52677 + (1));
seq__51769_52674 = G__52687;
chunk__51771_52675 = G__52688;
count__51772_52676 = G__52689;
i__51773_52677 = G__52690;
continue;
}
} else {
var temp__5735__auto___52691__$1 = cljs.core.seq(seq__51769_52674);
if(temp__5735__auto___52691__$1){
var seq__51769_52693__$1 = temp__5735__auto___52691__$1;
if(cljs.core.chunked_seq_QMARK_(seq__51769_52693__$1)){
var c__4556__auto___52694 = cljs.core.chunk_first(seq__51769_52693__$1);
var G__52696 = cljs.core.chunk_rest(seq__51769_52693__$1);
var G__52697 = c__4556__auto___52694;
var G__52698 = cljs.core.count(c__4556__auto___52694);
var G__52699 = (0);
seq__51769_52674 = G__52696;
chunk__51771_52675 = G__52697;
count__51772_52676 = G__52698;
i__51773_52677 = G__52699;
continue;
} else {
var child_52701 = cljs.core.first(seq__51769_52693__$1);
if(cljs.core.truth_(child_52701)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52701);


var G__52703 = cljs.core.next(seq__51769_52693__$1);
var G__52704 = null;
var G__52705 = (0);
var G__52706 = (0);
seq__51769_52674 = G__52703;
chunk__51771_52675 = G__52704;
count__51772_52676 = G__52705;
i__51773_52677 = G__52706;
continue;
} else {
var G__52709 = cljs.core.next(seq__51769_52693__$1);
var G__52710 = null;
var G__52711 = (0);
var G__52712 = (0);
seq__51769_52674 = G__52709;
chunk__51771_52675 = G__52710;
count__51772_52676 = G__52711;
i__51773_52677 = G__52712;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52673);
}


var G__52716 = cljs.core.next(seq__51703_52664__$1);
var G__52717 = null;
var G__52718 = (0);
var G__52719 = (0);
seq__51703_52617 = G__52716;
chunk__51705_52618 = G__52717;
count__51706_52619 = G__52718;
i__51707_52620 = G__52719;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__51808 = cljs.core.seq(node);
var chunk__51809 = null;
var count__51810 = (0);
var i__51811 = (0);
while(true){
if((i__51811 < count__51810)){
var n = chunk__51809.cljs$core$IIndexed$_nth$arity$2(null,i__51811);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52729 = seq__51808;
var G__52730 = chunk__51809;
var G__52731 = count__51810;
var G__52732 = (i__51811 + (1));
seq__51808 = G__52729;
chunk__51809 = G__52730;
count__51810 = G__52731;
i__51811 = G__52732;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51808);
if(temp__5735__auto__){
var seq__51808__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51808__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51808__$1);
var G__52734 = cljs.core.chunk_rest(seq__51808__$1);
var G__52735 = c__4556__auto__;
var G__52736 = cljs.core.count(c__4556__auto__);
var G__52737 = (0);
seq__51808 = G__52734;
chunk__51809 = G__52735;
count__51810 = G__52736;
i__51811 = G__52737;
continue;
} else {
var n = cljs.core.first(seq__51808__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52738 = cljs.core.next(seq__51808__$1);
var G__52739 = null;
var G__52740 = (0);
var G__52741 = (0);
seq__51808 = G__52738;
chunk__51809 = G__52739;
count__51810 = G__52740;
i__51811 = G__52741;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__51819 = arguments.length;
switch (G__51819) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__51823 = arguments.length;
switch (G__51823) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__51839 = arguments.length;
switch (G__51839) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___52759 = arguments.length;
var i__4737__auto___52760 = (0);
while(true){
if((i__4737__auto___52760 < len__4736__auto___52759)){
args__4742__auto__.push((arguments[i__4737__auto___52760]));

var G__52762 = (i__4737__auto___52760 + (1));
i__4737__auto___52760 = G__52762;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__51867_52764 = cljs.core.seq(nodes);
var chunk__51868_52765 = null;
var count__51869_52766 = (0);
var i__51870_52767 = (0);
while(true){
if((i__51870_52767 < count__51869_52766)){
var node_52768 = chunk__51868_52765.cljs$core$IIndexed$_nth$arity$2(null,i__51870_52767);
fragment.appendChild(shadow.dom._to_dom(node_52768));


var G__52770 = seq__51867_52764;
var G__52771 = chunk__51868_52765;
var G__52772 = count__51869_52766;
var G__52773 = (i__51870_52767 + (1));
seq__51867_52764 = G__52770;
chunk__51868_52765 = G__52771;
count__51869_52766 = G__52772;
i__51870_52767 = G__52773;
continue;
} else {
var temp__5735__auto___52774 = cljs.core.seq(seq__51867_52764);
if(temp__5735__auto___52774){
var seq__51867_52775__$1 = temp__5735__auto___52774;
if(cljs.core.chunked_seq_QMARK_(seq__51867_52775__$1)){
var c__4556__auto___52776 = cljs.core.chunk_first(seq__51867_52775__$1);
var G__52777 = cljs.core.chunk_rest(seq__51867_52775__$1);
var G__52778 = c__4556__auto___52776;
var G__52779 = cljs.core.count(c__4556__auto___52776);
var G__52780 = (0);
seq__51867_52764 = G__52777;
chunk__51868_52765 = G__52778;
count__51869_52766 = G__52779;
i__51870_52767 = G__52780;
continue;
} else {
var node_52783 = cljs.core.first(seq__51867_52775__$1);
fragment.appendChild(shadow.dom._to_dom(node_52783));


var G__52784 = cljs.core.next(seq__51867_52775__$1);
var G__52785 = null;
var G__52786 = (0);
var G__52787 = (0);
seq__51867_52764 = G__52784;
chunk__51868_52765 = G__52785;
count__51869_52766 = G__52786;
i__51870_52767 = G__52787;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq51860){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq51860));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__51882_52791 = cljs.core.seq(scripts);
var chunk__51883_52792 = null;
var count__51884_52793 = (0);
var i__51885_52794 = (0);
while(true){
if((i__51885_52794 < count__51884_52793)){
var vec__51894_52797 = chunk__51883_52792.cljs$core$IIndexed$_nth$arity$2(null,i__51885_52794);
var script_tag_52798 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51894_52797,(0),null);
var script_body_52799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51894_52797,(1),null);
eval(script_body_52799);


var G__52800 = seq__51882_52791;
var G__52801 = chunk__51883_52792;
var G__52802 = count__51884_52793;
var G__52803 = (i__51885_52794 + (1));
seq__51882_52791 = G__52800;
chunk__51883_52792 = G__52801;
count__51884_52793 = G__52802;
i__51885_52794 = G__52803;
continue;
} else {
var temp__5735__auto___52804 = cljs.core.seq(seq__51882_52791);
if(temp__5735__auto___52804){
var seq__51882_52805__$1 = temp__5735__auto___52804;
if(cljs.core.chunked_seq_QMARK_(seq__51882_52805__$1)){
var c__4556__auto___52809 = cljs.core.chunk_first(seq__51882_52805__$1);
var G__52810 = cljs.core.chunk_rest(seq__51882_52805__$1);
var G__52811 = c__4556__auto___52809;
var G__52812 = cljs.core.count(c__4556__auto___52809);
var G__52813 = (0);
seq__51882_52791 = G__52810;
chunk__51883_52792 = G__52811;
count__51884_52793 = G__52812;
i__51885_52794 = G__52813;
continue;
} else {
var vec__51897_52814 = cljs.core.first(seq__51882_52805__$1);
var script_tag_52815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51897_52814,(0),null);
var script_body_52816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51897_52814,(1),null);
eval(script_body_52816);


var G__52818 = cljs.core.next(seq__51882_52805__$1);
var G__52819 = null;
var G__52820 = (0);
var G__52821 = (0);
seq__51882_52791 = G__52818;
chunk__51883_52792 = G__52819;
count__51884_52793 = G__52820;
i__51885_52794 = G__52821;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__51900){
var vec__51901 = p__51900;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51901,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51901,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__51912 = arguments.length;
switch (G__51912) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__51927 = cljs.core.seq(style_keys);
var chunk__51928 = null;
var count__51929 = (0);
var i__51930 = (0);
while(true){
if((i__51930 < count__51929)){
var it = chunk__51928.cljs$core$IIndexed$_nth$arity$2(null,i__51930);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52836 = seq__51927;
var G__52837 = chunk__51928;
var G__52838 = count__51929;
var G__52839 = (i__51930 + (1));
seq__51927 = G__52836;
chunk__51928 = G__52837;
count__51929 = G__52838;
i__51930 = G__52839;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__51927);
if(temp__5735__auto__){
var seq__51927__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51927__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__51927__$1);
var G__52840 = cljs.core.chunk_rest(seq__51927__$1);
var G__52841 = c__4556__auto__;
var G__52842 = cljs.core.count(c__4556__auto__);
var G__52843 = (0);
seq__51927 = G__52840;
chunk__51928 = G__52841;
count__51929 = G__52842;
i__51930 = G__52843;
continue;
} else {
var it = cljs.core.first(seq__51927__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52845 = cljs.core.next(seq__51927__$1);
var G__52846 = null;
var G__52847 = (0);
var G__52848 = (0);
seq__51927 = G__52845;
chunk__51928 = G__52846;
count__51929 = G__52847;
i__51930 = G__52848;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k51937,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__51943 = k51937;
var G__51943__$1 = (((G__51943 instanceof cljs.core.Keyword))?G__51943.fqn:null);
switch (G__51943__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k51937,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__51944){
var vec__51945 = p__51944;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51945,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51945,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__51936){
var self__ = this;
var G__51936__$1 = this;
return (new cljs.core.RecordIter((0),G__51936__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this51938,other51939){
var self__ = this;
var this51938__$1 = this;
return (((!((other51939 == null)))) && ((this51938__$1.constructor === other51939.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51938__$1.x,other51939.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51938__$1.y,other51939.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51938__$1.__extmap,other51939.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__51936){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__51955 = cljs.core.keyword_identical_QMARK_;
var expr__51956 = k__4388__auto__;
if(cljs.core.truth_((pred__51955.cljs$core$IFn$_invoke$arity$2 ? pred__51955.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__51956) : pred__51955.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__51956)))){
return (new shadow.dom.Coordinate(G__51936,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__51955.cljs$core$IFn$_invoke$arity$2 ? pred__51955.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__51956) : pred__51955.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__51956)))){
return (new shadow.dom.Coordinate(self__.x,G__51936,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__51936),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__51936){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__51936,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__51941){
var extmap__4419__auto__ = (function (){var G__51969 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__51941,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__51941)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__51969);
} else {
return G__51969;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__51941),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__51941),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k51973,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__51979 = k51973;
var G__51979__$1 = (((G__51979 instanceof cljs.core.Keyword))?G__51979.fqn:null);
switch (G__51979__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k51973,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__51982){
var vec__51983 = p__51982;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51983,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51983,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__51972){
var self__ = this;
var G__51972__$1 = this;
return (new cljs.core.RecordIter((0),G__51972__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this51974,other51975){
var self__ = this;
var this51974__$1 = this;
return (((!((other51975 == null)))) && ((this51974__$1.constructor === other51975.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51974__$1.w,other51975.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51974__$1.h,other51975.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51974__$1.__extmap,other51975.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__51972){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__51986 = cljs.core.keyword_identical_QMARK_;
var expr__51987 = k__4388__auto__;
if(cljs.core.truth_((pred__51986.cljs$core$IFn$_invoke$arity$2 ? pred__51986.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__51987) : pred__51986.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__51987)))){
return (new shadow.dom.Size(G__51972,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__51986.cljs$core$IFn$_invoke$arity$2 ? pred__51986.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__51987) : pred__51986.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__51987)))){
return (new shadow.dom.Size(self__.w,G__51972,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__51972),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__51972){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__51972,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__51976){
var extmap__4419__auto__ = (function (){var G__51997 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__51976,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__51976)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__51997);
} else {
return G__51997;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__51976),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__51976),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__52920 = (i + (1));
var G__52921 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__52920;
ret = G__52921;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__52006){
var vec__52007 = p__52006;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52007,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52007,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__52011 = arguments.length;
switch (G__52011) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__52943 = ps;
var G__52944 = (i + (1));
el__$1 = G__52943;
i = G__52944;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__52066 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52066,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52066,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52066,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__52070_52950 = cljs.core.seq(props);
var chunk__52071_52951 = null;
var count__52072_52952 = (0);
var i__52073_52953 = (0);
while(true){
if((i__52073_52953 < count__52072_52952)){
var vec__52092_52956 = chunk__52071_52951.cljs$core$IIndexed$_nth$arity$2(null,i__52073_52953);
var k_52957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52092_52956,(0),null);
var v_52958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52092_52956,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_52957);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_52957),v_52958);


var G__52961 = seq__52070_52950;
var G__52962 = chunk__52071_52951;
var G__52963 = count__52072_52952;
var G__52964 = (i__52073_52953 + (1));
seq__52070_52950 = G__52961;
chunk__52071_52951 = G__52962;
count__52072_52952 = G__52963;
i__52073_52953 = G__52964;
continue;
} else {
var temp__5735__auto___52965 = cljs.core.seq(seq__52070_52950);
if(temp__5735__auto___52965){
var seq__52070_52966__$1 = temp__5735__auto___52965;
if(cljs.core.chunked_seq_QMARK_(seq__52070_52966__$1)){
var c__4556__auto___52967 = cljs.core.chunk_first(seq__52070_52966__$1);
var G__52968 = cljs.core.chunk_rest(seq__52070_52966__$1);
var G__52969 = c__4556__auto___52967;
var G__52970 = cljs.core.count(c__4556__auto___52967);
var G__52971 = (0);
seq__52070_52950 = G__52968;
chunk__52071_52951 = G__52969;
count__52072_52952 = G__52970;
i__52073_52953 = G__52971;
continue;
} else {
var vec__52098_52974 = cljs.core.first(seq__52070_52966__$1);
var k_52975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52098_52974,(0),null);
var v_52976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52098_52974,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_52975);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_52975),v_52976);


var G__52978 = cljs.core.next(seq__52070_52966__$1);
var G__52979 = null;
var G__52980 = (0);
var G__52981 = (0);
seq__52070_52950 = G__52978;
chunk__52071_52951 = G__52979;
count__52072_52952 = G__52980;
i__52073_52953 = G__52981;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__52112 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52112,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52112,(1),null);
var seq__52115_52983 = cljs.core.seq(node_children);
var chunk__52117_52984 = null;
var count__52118_52985 = (0);
var i__52119_52986 = (0);
while(true){
if((i__52119_52986 < count__52118_52985)){
var child_struct_52987 = chunk__52117_52984.cljs$core$IIndexed$_nth$arity$2(null,i__52119_52986);
if((!((child_struct_52987 == null)))){
if(typeof child_struct_52987 === 'string'){
var text_52988 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_52988),child_struct_52987].join(''));
} else {
var children_52989 = shadow.dom.svg_node(child_struct_52987);
if(cljs.core.seq_QMARK_(children_52989)){
var seq__52172_52992 = cljs.core.seq(children_52989);
var chunk__52174_52993 = null;
var count__52175_52994 = (0);
var i__52176_52995 = (0);
while(true){
if((i__52176_52995 < count__52175_52994)){
var child_52997 = chunk__52174_52993.cljs$core$IIndexed$_nth$arity$2(null,i__52176_52995);
if(cljs.core.truth_(child_52997)){
node.appendChild(child_52997);


var G__52998 = seq__52172_52992;
var G__52999 = chunk__52174_52993;
var G__53000 = count__52175_52994;
var G__53001 = (i__52176_52995 + (1));
seq__52172_52992 = G__52998;
chunk__52174_52993 = G__52999;
count__52175_52994 = G__53000;
i__52176_52995 = G__53001;
continue;
} else {
var G__53002 = seq__52172_52992;
var G__53003 = chunk__52174_52993;
var G__53004 = count__52175_52994;
var G__53005 = (i__52176_52995 + (1));
seq__52172_52992 = G__53002;
chunk__52174_52993 = G__53003;
count__52175_52994 = G__53004;
i__52176_52995 = G__53005;
continue;
}
} else {
var temp__5735__auto___53008 = cljs.core.seq(seq__52172_52992);
if(temp__5735__auto___53008){
var seq__52172_53009__$1 = temp__5735__auto___53008;
if(cljs.core.chunked_seq_QMARK_(seq__52172_53009__$1)){
var c__4556__auto___53010 = cljs.core.chunk_first(seq__52172_53009__$1);
var G__53012 = cljs.core.chunk_rest(seq__52172_53009__$1);
var G__53013 = c__4556__auto___53010;
var G__53014 = cljs.core.count(c__4556__auto___53010);
var G__53015 = (0);
seq__52172_52992 = G__53012;
chunk__52174_52993 = G__53013;
count__52175_52994 = G__53014;
i__52176_52995 = G__53015;
continue;
} else {
var child_53016 = cljs.core.first(seq__52172_53009__$1);
if(cljs.core.truth_(child_53016)){
node.appendChild(child_53016);


var G__53019 = cljs.core.next(seq__52172_53009__$1);
var G__53020 = null;
var G__53021 = (0);
var G__53022 = (0);
seq__52172_52992 = G__53019;
chunk__52174_52993 = G__53020;
count__52175_52994 = G__53021;
i__52176_52995 = G__53022;
continue;
} else {
var G__53024 = cljs.core.next(seq__52172_53009__$1);
var G__53025 = null;
var G__53026 = (0);
var G__53027 = (0);
seq__52172_52992 = G__53024;
chunk__52174_52993 = G__53025;
count__52175_52994 = G__53026;
i__52176_52995 = G__53027;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_52989);
}
}


var G__53029 = seq__52115_52983;
var G__53030 = chunk__52117_52984;
var G__53031 = count__52118_52985;
var G__53032 = (i__52119_52986 + (1));
seq__52115_52983 = G__53029;
chunk__52117_52984 = G__53030;
count__52118_52985 = G__53031;
i__52119_52986 = G__53032;
continue;
} else {
var G__53034 = seq__52115_52983;
var G__53035 = chunk__52117_52984;
var G__53036 = count__52118_52985;
var G__53037 = (i__52119_52986 + (1));
seq__52115_52983 = G__53034;
chunk__52117_52984 = G__53035;
count__52118_52985 = G__53036;
i__52119_52986 = G__53037;
continue;
}
} else {
var temp__5735__auto___53040 = cljs.core.seq(seq__52115_52983);
if(temp__5735__auto___53040){
var seq__52115_53041__$1 = temp__5735__auto___53040;
if(cljs.core.chunked_seq_QMARK_(seq__52115_53041__$1)){
var c__4556__auto___53042 = cljs.core.chunk_first(seq__52115_53041__$1);
var G__53043 = cljs.core.chunk_rest(seq__52115_53041__$1);
var G__53044 = c__4556__auto___53042;
var G__53045 = cljs.core.count(c__4556__auto___53042);
var G__53046 = (0);
seq__52115_52983 = G__53043;
chunk__52117_52984 = G__53044;
count__52118_52985 = G__53045;
i__52119_52986 = G__53046;
continue;
} else {
var child_struct_53047 = cljs.core.first(seq__52115_53041__$1);
if((!((child_struct_53047 == null)))){
if(typeof child_struct_53047 === 'string'){
var text_53050 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_53050),child_struct_53047].join(''));
} else {
var children_53052 = shadow.dom.svg_node(child_struct_53047);
if(cljs.core.seq_QMARK_(children_53052)){
var seq__52198_53054 = cljs.core.seq(children_53052);
var chunk__52200_53055 = null;
var count__52201_53056 = (0);
var i__52202_53057 = (0);
while(true){
if((i__52202_53057 < count__52201_53056)){
var child_53058 = chunk__52200_53055.cljs$core$IIndexed$_nth$arity$2(null,i__52202_53057);
if(cljs.core.truth_(child_53058)){
node.appendChild(child_53058);


var G__53062 = seq__52198_53054;
var G__53063 = chunk__52200_53055;
var G__53064 = count__52201_53056;
var G__53065 = (i__52202_53057 + (1));
seq__52198_53054 = G__53062;
chunk__52200_53055 = G__53063;
count__52201_53056 = G__53064;
i__52202_53057 = G__53065;
continue;
} else {
var G__53066 = seq__52198_53054;
var G__53067 = chunk__52200_53055;
var G__53068 = count__52201_53056;
var G__53069 = (i__52202_53057 + (1));
seq__52198_53054 = G__53066;
chunk__52200_53055 = G__53067;
count__52201_53056 = G__53068;
i__52202_53057 = G__53069;
continue;
}
} else {
var temp__5735__auto___53070__$1 = cljs.core.seq(seq__52198_53054);
if(temp__5735__auto___53070__$1){
var seq__52198_53071__$1 = temp__5735__auto___53070__$1;
if(cljs.core.chunked_seq_QMARK_(seq__52198_53071__$1)){
var c__4556__auto___53072 = cljs.core.chunk_first(seq__52198_53071__$1);
var G__53075 = cljs.core.chunk_rest(seq__52198_53071__$1);
var G__53076 = c__4556__auto___53072;
var G__53077 = cljs.core.count(c__4556__auto___53072);
var G__53078 = (0);
seq__52198_53054 = G__53075;
chunk__52200_53055 = G__53076;
count__52201_53056 = G__53077;
i__52202_53057 = G__53078;
continue;
} else {
var child_53080 = cljs.core.first(seq__52198_53071__$1);
if(cljs.core.truth_(child_53080)){
node.appendChild(child_53080);


var G__53081 = cljs.core.next(seq__52198_53071__$1);
var G__53082 = null;
var G__53083 = (0);
var G__53084 = (0);
seq__52198_53054 = G__53081;
chunk__52200_53055 = G__53082;
count__52201_53056 = G__53083;
i__52202_53057 = G__53084;
continue;
} else {
var G__53086 = cljs.core.next(seq__52198_53071__$1);
var G__53087 = null;
var G__53088 = (0);
var G__53089 = (0);
seq__52198_53054 = G__53086;
chunk__52200_53055 = G__53087;
count__52201_53056 = G__53088;
i__52202_53057 = G__53089;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_53052);
}
}


var G__53092 = cljs.core.next(seq__52115_53041__$1);
var G__53093 = null;
var G__53094 = (0);
var G__53095 = (0);
seq__52115_52983 = G__53092;
chunk__52117_52984 = G__53093;
count__52118_52985 = G__53094;
i__52119_52986 = G__53095;
continue;
} else {
var G__53096 = cljs.core.next(seq__52115_53041__$1);
var G__53097 = null;
var G__53098 = (0);
var G__53099 = (0);
seq__52115_52983 = G__53096;
chunk__52117_52984 = G__53097;
count__52118_52985 = G__53098;
i__52119_52986 = G__53099;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___53105 = arguments.length;
var i__4737__auto___53106 = (0);
while(true){
if((i__4737__auto___53106 < len__4736__auto___53105)){
args__4742__auto__.push((arguments[i__4737__auto___53106]));

var G__53107 = (i__4737__auto___53106 + (1));
i__4737__auto___53106 = G__53107;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq52229){
var G__52230 = cljs.core.first(seq52229);
var seq52229__$1 = cljs.core.next(seq52229);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52230,seq52229__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__52240 = arguments.length;
switch (G__52240) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__47011__auto___53124 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__47012__auto__ = (function (){var switch__46571__auto__ = (function (state_52255){
var state_val_52256 = (state_52255[(1)]);
if((state_val_52256 === (1))){
var state_52255__$1 = state_52255;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52255__$1,(2),once_or_cleanup);
} else {
if((state_val_52256 === (2))){
var inst_52252 = (state_52255[(2)]);
var inst_52253 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_52255__$1 = (function (){var statearr_52261 = state_52255;
(statearr_52261[(7)] = inst_52252);

return statearr_52261;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_52255__$1,inst_52253);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__46572__auto__ = null;
var shadow$dom$state_machine__46572__auto____0 = (function (){
var statearr_52264 = [null,null,null,null,null,null,null,null];
(statearr_52264[(0)] = shadow$dom$state_machine__46572__auto__);

(statearr_52264[(1)] = (1));

return statearr_52264;
});
var shadow$dom$state_machine__46572__auto____1 = (function (state_52255){
while(true){
var ret_value__46573__auto__ = (function (){try{while(true){
var result__46574__auto__ = switch__46571__auto__(state_52255);
if(cljs.core.keyword_identical_QMARK_(result__46574__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__46574__auto__;
}
break;
}
}catch (e52266){var ex__46575__auto__ = e52266;
var statearr_52267_53129 = state_52255;
(statearr_52267_53129[(2)] = ex__46575__auto__);


if(cljs.core.seq((state_52255[(4)]))){
var statearr_52269_53130 = state_52255;
(statearr_52269_53130[(1)] = cljs.core.first((state_52255[(4)])));

} else {
throw ex__46575__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__46573__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53133 = state_52255;
state_52255 = G__53133;
continue;
} else {
return ret_value__46573__auto__;
}
break;
}
});
shadow$dom$state_machine__46572__auto__ = function(state_52255){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__46572__auto____0.call(this);
case 1:
return shadow$dom$state_machine__46572__auto____1.call(this,state_52255);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__46572__auto____0;
shadow$dom$state_machine__46572__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__46572__auto____1;
return shadow$dom$state_machine__46572__auto__;
})()
})();
var state__47013__auto__ = (function (){var statearr_52273 = f__47012__auto__();
(statearr_52273[(6)] = c__47011__auto___53124);

return statearr_52273;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__47013__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
