goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__45751 = arguments.length;
switch (G__45751) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45758 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45758 = (function (f,blockable,meta45759){
this.f = f;
this.blockable = blockable;
this.meta45759 = meta45759;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45758.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45760,meta45759__$1){
var self__ = this;
var _45760__$1 = this;
return (new cljs.core.async.t_cljs$core$async45758(self__.f,self__.blockable,meta45759__$1));
}));

(cljs.core.async.t_cljs$core$async45758.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45760){
var self__ = this;
var _45760__$1 = this;
return self__.meta45759;
}));

(cljs.core.async.t_cljs$core$async45758.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45758.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45758.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async45758.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async45758.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta45759","meta45759",-548788208,null)], null);
}));

(cljs.core.async.t_cljs$core$async45758.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45758.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45758");

(cljs.core.async.t_cljs$core$async45758.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45758");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45758.
 */
cljs.core.async.__GT_t_cljs$core$async45758 = (function cljs$core$async$__GT_t_cljs$core$async45758(f__$1,blockable__$1,meta45759){
return (new cljs.core.async.t_cljs$core$async45758(f__$1,blockable__$1,meta45759));
});

}

return (new cljs.core.async.t_cljs$core$async45758(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__45833 = arguments.length;
switch (G__45833) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__45852 = arguments.length;
switch (G__45852) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__45875 = arguments.length;
switch (G__45875) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_49551 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49551) : fn1.call(null,val_49551));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_49551) : fn1.call(null,val_49551));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__45891 = arguments.length;
switch (G__45891) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___49580 = n;
var x_49582 = (0);
while(true){
if((x_49582 < n__4613__auto___49580)){
(a[x_49582] = x_49582);

var G__49583 = (x_49582 + (1));
x_49582 = G__49583;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45912 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45912 = (function (flag,meta45913){
this.flag = flag;
this.meta45913 = meta45913;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45912.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45914,meta45913__$1){
var self__ = this;
var _45914__$1 = this;
return (new cljs.core.async.t_cljs$core$async45912(self__.flag,meta45913__$1));
}));

(cljs.core.async.t_cljs$core$async45912.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45914){
var self__ = this;
var _45914__$1 = this;
return self__.meta45913;
}));

(cljs.core.async.t_cljs$core$async45912.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45912.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async45912.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45912.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async45912.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta45913","meta45913",-1934058470,null)], null);
}));

(cljs.core.async.t_cljs$core$async45912.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45912.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45912");

(cljs.core.async.t_cljs$core$async45912.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45912");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45912.
 */
cljs.core.async.__GT_t_cljs$core$async45912 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async45912(flag__$1,meta45913){
return (new cljs.core.async.t_cljs$core$async45912(flag__$1,meta45913));
});

}

return (new cljs.core.async.t_cljs$core$async45912(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45943 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45943 = (function (flag,cb,meta45944){
this.flag = flag;
this.cb = cb;
this.meta45944 = meta45944;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45943.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45945,meta45944__$1){
var self__ = this;
var _45945__$1 = this;
return (new cljs.core.async.t_cljs$core$async45943(self__.flag,self__.cb,meta45944__$1));
}));

(cljs.core.async.t_cljs$core$async45943.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45945){
var self__ = this;
var _45945__$1 = this;
return self__.meta45944;
}));

(cljs.core.async.t_cljs$core$async45943.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45943.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async45943.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45943.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async45943.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta45944","meta45944",1814096947,null)], null);
}));

(cljs.core.async.t_cljs$core$async45943.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45943.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45943");

(cljs.core.async.t_cljs$core$async45943.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45943");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45943.
 */
cljs.core.async.__GT_t_cljs$core$async45943 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async45943(flag__$1,cb__$1,meta45944){
return (new cljs.core.async.t_cljs$core$async45943(flag__$1,cb__$1,meta45944));
});

}

return (new cljs.core.async.t_cljs$core$async45943(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45966_SHARP_){
var G__45979 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45966_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__45979) : fret.call(null,G__45979));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45967_SHARP_){
var G__45980 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45967_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__45980) : fret.call(null,G__45980));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__49625 = (i + (1));
i = G__49625;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___49638 = arguments.length;
var i__4737__auto___49641 = (0);
while(true){
if((i__4737__auto___49641 < len__4736__auto___49638)){
args__4742__auto__.push((arguments[i__4737__auto___49641]));

var G__49644 = (i__4737__auto___49641 + (1));
i__4737__auto___49641 = G__49644;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__46002){
var map__46003 = p__46002;
var map__46003__$1 = (((((!((map__46003 == null))))?(((((map__46003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46003):map__46003);
var opts = map__46003__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq45986){
var G__45990 = cljs.core.first(seq45986);
var seq45986__$1 = cljs.core.next(seq45986);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45990,seq45986__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__46026 = arguments.length;
switch (G__46026) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__45600__auto___49677 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_46094){
var state_val_46095 = (state_46094[(1)]);
if((state_val_46095 === (7))){
var inst_46088 = (state_46094[(2)]);
var state_46094__$1 = state_46094;
var statearr_46110_49682 = state_46094__$1;
(statearr_46110_49682[(2)] = inst_46088);

(statearr_46110_49682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (1))){
var state_46094__$1 = state_46094;
var statearr_46112_49689 = state_46094__$1;
(statearr_46112_49689[(2)] = null);

(statearr_46112_49689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (4))){
var inst_46054 = (state_46094[(7)]);
var inst_46054__$1 = (state_46094[(2)]);
var inst_46067 = (inst_46054__$1 == null);
var state_46094__$1 = (function (){var statearr_46117 = state_46094;
(statearr_46117[(7)] = inst_46054__$1);

return statearr_46117;
})();
if(cljs.core.truth_(inst_46067)){
var statearr_46119_49697 = state_46094__$1;
(statearr_46119_49697[(1)] = (5));

} else {
var statearr_46121_49700 = state_46094__$1;
(statearr_46121_49700[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (13))){
var state_46094__$1 = state_46094;
var statearr_46127_49702 = state_46094__$1;
(statearr_46127_49702[(2)] = null);

(statearr_46127_49702[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (6))){
var inst_46054 = (state_46094[(7)]);
var state_46094__$1 = state_46094;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46094__$1,(11),to,inst_46054);
} else {
if((state_val_46095 === (3))){
var inst_46090 = (state_46094[(2)]);
var state_46094__$1 = state_46094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46094__$1,inst_46090);
} else {
if((state_val_46095 === (12))){
var state_46094__$1 = state_46094;
var statearr_46134_49711 = state_46094__$1;
(statearr_46134_49711[(2)] = null);

(statearr_46134_49711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (2))){
var state_46094__$1 = state_46094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46094__$1,(4),from);
} else {
if((state_val_46095 === (11))){
var inst_46078 = (state_46094[(2)]);
var state_46094__$1 = state_46094;
if(cljs.core.truth_(inst_46078)){
var statearr_46136_49715 = state_46094__$1;
(statearr_46136_49715[(1)] = (12));

} else {
var statearr_46137_49716 = state_46094__$1;
(statearr_46137_49716[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (9))){
var state_46094__$1 = state_46094;
var statearr_46139_49717 = state_46094__$1;
(statearr_46139_49717[(2)] = null);

(statearr_46139_49717[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (5))){
var state_46094__$1 = state_46094;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46142_49718 = state_46094__$1;
(statearr_46142_49718[(1)] = (8));

} else {
var statearr_46145_49719 = state_46094__$1;
(statearr_46145_49719[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (14))){
var inst_46086 = (state_46094[(2)]);
var state_46094__$1 = state_46094;
var statearr_46147_49720 = state_46094__$1;
(statearr_46147_49720[(2)] = inst_46086);

(statearr_46147_49720[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (10))){
var inst_46075 = (state_46094[(2)]);
var state_46094__$1 = state_46094;
var statearr_46149_49721 = state_46094__$1;
(statearr_46149_49721[(2)] = inst_46075);

(statearr_46149_49721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46095 === (8))){
var inst_46071 = cljs.core.async.close_BANG_(to);
var state_46094__$1 = state_46094;
var statearr_46154_49722 = state_46094__$1;
(statearr_46154_49722[(2)] = inst_46071);

(statearr_46154_49722[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_46164 = [null,null,null,null,null,null,null,null];
(statearr_46164[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_46164[(1)] = (1));

return statearr_46164;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_46094){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_46094);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e46171){var ex__45476__auto__ = e46171;
var statearr_46173_49725 = state_46094;
(statearr_46173_49725[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_46094[(4)]))){
var statearr_46174_49726 = state_46094;
(statearr_46174_49726[(1)] = cljs.core.first((state_46094[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49727 = state_46094;
state_46094 = G__49727;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_46094){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_46094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_46184 = f__45601__auto__();
(statearr_46184[(6)] = c__45600__auto___49677);

return statearr_46184;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__46214){
var vec__46218 = p__46214;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46218,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46218,(1),null);
var job = vec__46218;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__45600__auto___49730 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_46230){
var state_val_46231 = (state_46230[(1)]);
if((state_val_46231 === (1))){
var state_46230__$1 = state_46230;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46230__$1,(2),res,v);
} else {
if((state_val_46231 === (2))){
var inst_46226 = (state_46230[(2)]);
var inst_46227 = cljs.core.async.close_BANG_(res);
var state_46230__$1 = (function (){var statearr_46236 = state_46230;
(statearr_46236[(7)] = inst_46226);

return statearr_46236;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_46230__$1,inst_46227);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0 = (function (){
var statearr_46241 = [null,null,null,null,null,null,null,null];
(statearr_46241[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__);

(statearr_46241[(1)] = (1));

return statearr_46241;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1 = (function (state_46230){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_46230);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e46243){var ex__45476__auto__ = e46243;
var statearr_46247_49733 = state_46230;
(statearr_46247_49733[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_46230[(4)]))){
var statearr_46248_49735 = state_46230;
(statearr_46248_49735[(1)] = cljs.core.first((state_46230[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49737 = state_46230;
state_46230 = G__49737;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = function(state_46230){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1.call(this,state_46230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_46250 = f__45601__auto__();
(statearr_46250[(6)] = c__45600__auto___49730);

return statearr_46250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__46251){
var vec__46252 = p__46251;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46252,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46252,(1),null);
var job = vec__46252;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___49742 = n;
var __49743 = (0);
while(true){
if((__49743 < n__4613__auto___49742)){
var G__46255_49744 = type;
var G__46255_49745__$1 = (((G__46255_49744 instanceof cljs.core.Keyword))?G__46255_49744.fqn:null);
switch (G__46255_49745__$1) {
case "compute":
var c__45600__auto___49747 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49743,c__45600__auto___49747,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async){
return (function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = ((function (__49743,c__45600__auto___49747,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async){
return (function (state_46273){
var state_val_46274 = (state_46273[(1)]);
if((state_val_46274 === (1))){
var state_46273__$1 = state_46273;
var statearr_46277_49748 = state_46273__$1;
(statearr_46277_49748[(2)] = null);

(statearr_46277_49748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46274 === (2))){
var state_46273__$1 = state_46273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46273__$1,(4),jobs);
} else {
if((state_val_46274 === (3))){
var inst_46271 = (state_46273[(2)]);
var state_46273__$1 = state_46273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46273__$1,inst_46271);
} else {
if((state_val_46274 === (4))){
var inst_46263 = (state_46273[(2)]);
var inst_46264 = process(inst_46263);
var state_46273__$1 = state_46273;
if(cljs.core.truth_(inst_46264)){
var statearr_46280_49752 = state_46273__$1;
(statearr_46280_49752[(1)] = (5));

} else {
var statearr_46281_49753 = state_46273__$1;
(statearr_46281_49753[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46274 === (5))){
var state_46273__$1 = state_46273;
var statearr_46283_49755 = state_46273__$1;
(statearr_46283_49755[(2)] = null);

(statearr_46283_49755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46274 === (6))){
var state_46273__$1 = state_46273;
var statearr_46286_49756 = state_46273__$1;
(statearr_46286_49756[(2)] = null);

(statearr_46286_49756[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46274 === (7))){
var inst_46269 = (state_46273[(2)]);
var state_46273__$1 = state_46273;
var statearr_46288_49757 = state_46273__$1;
(statearr_46288_49757[(2)] = inst_46269);

(statearr_46288_49757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49743,c__45600__auto___49747,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async))
;
return ((function (__49743,switch__45472__auto__,c__45600__auto___49747,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0 = (function (){
var statearr_46290 = [null,null,null,null,null,null,null];
(statearr_46290[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__);

(statearr_46290[(1)] = (1));

return statearr_46290;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1 = (function (state_46273){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_46273);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e46293){var ex__45476__auto__ = e46293;
var statearr_46294_49764 = state_46273;
(statearr_46294_49764[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_46273[(4)]))){
var statearr_46297_49765 = state_46273;
(statearr_46297_49765[(1)] = cljs.core.first((state_46273[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49766 = state_46273;
state_46273 = G__49766;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = function(state_46273){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1.call(this,state_46273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__;
})()
;})(__49743,switch__45472__auto__,c__45600__auto___49747,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async))
})();
var state__45602__auto__ = (function (){var statearr_46304 = f__45601__auto__();
(statearr_46304[(6)] = c__45600__auto___49747);

return statearr_46304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
});})(__49743,c__45600__auto___49747,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async))
);


break;
case "async":
var c__45600__auto___49768 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__49743,c__45600__auto___49768,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async){
return (function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = ((function (__49743,c__45600__auto___49768,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async){
return (function (state_46317){
var state_val_46318 = (state_46317[(1)]);
if((state_val_46318 === (1))){
var state_46317__$1 = state_46317;
var statearr_46327_49770 = state_46317__$1;
(statearr_46327_49770[(2)] = null);

(statearr_46327_49770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46318 === (2))){
var state_46317__$1 = state_46317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46317__$1,(4),jobs);
} else {
if((state_val_46318 === (3))){
var inst_46315 = (state_46317[(2)]);
var state_46317__$1 = state_46317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46317__$1,inst_46315);
} else {
if((state_val_46318 === (4))){
var inst_46307 = (state_46317[(2)]);
var inst_46308 = async(inst_46307);
var state_46317__$1 = state_46317;
if(cljs.core.truth_(inst_46308)){
var statearr_46328_49772 = state_46317__$1;
(statearr_46328_49772[(1)] = (5));

} else {
var statearr_46329_49773 = state_46317__$1;
(statearr_46329_49773[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46318 === (5))){
var state_46317__$1 = state_46317;
var statearr_46331_49774 = state_46317__$1;
(statearr_46331_49774[(2)] = null);

(statearr_46331_49774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46318 === (6))){
var state_46317__$1 = state_46317;
var statearr_46332_49775 = state_46317__$1;
(statearr_46332_49775[(2)] = null);

(statearr_46332_49775[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46318 === (7))){
var inst_46313 = (state_46317[(2)]);
var state_46317__$1 = state_46317;
var statearr_46333_49777 = state_46317__$1;
(statearr_46333_49777[(2)] = inst_46313);

(statearr_46333_49777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__49743,c__45600__auto___49768,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async))
;
return ((function (__49743,switch__45472__auto__,c__45600__auto___49768,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0 = (function (){
var statearr_46334 = [null,null,null,null,null,null,null];
(statearr_46334[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__);

(statearr_46334[(1)] = (1));

return statearr_46334;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1 = (function (state_46317){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_46317);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e46335){var ex__45476__auto__ = e46335;
var statearr_46336_49779 = state_46317;
(statearr_46336_49779[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_46317[(4)]))){
var statearr_46337_49782 = state_46317;
(statearr_46337_49782[(1)] = cljs.core.first((state_46317[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49786 = state_46317;
state_46317 = G__49786;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = function(state_46317){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1.call(this,state_46317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__;
})()
;})(__49743,switch__45472__auto__,c__45600__auto___49768,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async))
})();
var state__45602__auto__ = (function (){var statearr_46347 = f__45601__auto__();
(statearr_46347[(6)] = c__45600__auto___49768);

return statearr_46347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
});})(__49743,c__45600__auto___49768,G__46255_49744,G__46255_49745__$1,n__4613__auto___49742,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__46255_49745__$1)].join('')));

}

var G__49788 = (__49743 + (1));
__49743 = G__49788;
continue;
} else {
}
break;
}

var c__45600__auto___49790 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_46373){
var state_val_46374 = (state_46373[(1)]);
if((state_val_46374 === (7))){
var inst_46369 = (state_46373[(2)]);
var state_46373__$1 = state_46373;
var statearr_46404_49793 = state_46373__$1;
(statearr_46404_49793[(2)] = inst_46369);

(statearr_46404_49793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46374 === (1))){
var state_46373__$1 = state_46373;
var statearr_46407_49794 = state_46373__$1;
(statearr_46407_49794[(2)] = null);

(statearr_46407_49794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46374 === (4))){
var inst_46352 = (state_46373[(7)]);
var inst_46352__$1 = (state_46373[(2)]);
var inst_46353 = (inst_46352__$1 == null);
var state_46373__$1 = (function (){var statearr_46414 = state_46373;
(statearr_46414[(7)] = inst_46352__$1);

return statearr_46414;
})();
if(cljs.core.truth_(inst_46353)){
var statearr_46416_49797 = state_46373__$1;
(statearr_46416_49797[(1)] = (5));

} else {
var statearr_46447_49802 = state_46373__$1;
(statearr_46447_49802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46374 === (6))){
var inst_46357 = (state_46373[(8)]);
var inst_46352 = (state_46373[(7)]);
var inst_46357__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_46360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46361 = [inst_46352,inst_46357__$1];
var inst_46362 = (new cljs.core.PersistentVector(null,2,(5),inst_46360,inst_46361,null));
var state_46373__$1 = (function (){var statearr_46454 = state_46373;
(statearr_46454[(8)] = inst_46357__$1);

return statearr_46454;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46373__$1,(8),jobs,inst_46362);
} else {
if((state_val_46374 === (3))){
var inst_46371 = (state_46373[(2)]);
var state_46373__$1 = state_46373;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46373__$1,inst_46371);
} else {
if((state_val_46374 === (2))){
var state_46373__$1 = state_46373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46373__$1,(4),from);
} else {
if((state_val_46374 === (9))){
var inst_46366 = (state_46373[(2)]);
var state_46373__$1 = (function (){var statearr_46472 = state_46373;
(statearr_46472[(9)] = inst_46366);

return statearr_46472;
})();
var statearr_46473_49816 = state_46373__$1;
(statearr_46473_49816[(2)] = null);

(statearr_46473_49816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46374 === (5))){
var inst_46355 = cljs.core.async.close_BANG_(jobs);
var state_46373__$1 = state_46373;
var statearr_46479_49817 = state_46373__$1;
(statearr_46479_49817[(2)] = inst_46355);

(statearr_46479_49817[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46374 === (8))){
var inst_46357 = (state_46373[(8)]);
var inst_46364 = (state_46373[(2)]);
var state_46373__$1 = (function (){var statearr_46480 = state_46373;
(statearr_46480[(10)] = inst_46364);

return statearr_46480;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46373__$1,(9),results,inst_46357);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0 = (function (){
var statearr_46481 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46481[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__);

(statearr_46481[(1)] = (1));

return statearr_46481;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1 = (function (state_46373){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_46373);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e46482){var ex__45476__auto__ = e46482;
var statearr_46483_49822 = state_46373;
(statearr_46483_49822[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_46373[(4)]))){
var statearr_46484_49823 = state_46373;
(statearr_46484_49823[(1)] = cljs.core.first((state_46373[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49824 = state_46373;
state_46373 = G__49824;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = function(state_46373){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1.call(this,state_46373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_46492 = f__45601__auto__();
(statearr_46492[(6)] = c__45600__auto___49790);

return statearr_46492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


var c__45600__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_46642){
var state_val_46643 = (state_46642[(1)]);
if((state_val_46643 === (7))){
var inst_46634 = (state_46642[(2)]);
var state_46642__$1 = state_46642;
var statearr_46648_49826 = state_46642__$1;
(statearr_46648_49826[(2)] = inst_46634);

(statearr_46648_49826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (20))){
var state_46642__$1 = state_46642;
var statearr_46649_49827 = state_46642__$1;
(statearr_46649_49827[(2)] = null);

(statearr_46649_49827[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (1))){
var state_46642__$1 = state_46642;
var statearr_46651_49828 = state_46642__$1;
(statearr_46651_49828[(2)] = null);

(statearr_46651_49828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (4))){
var inst_46595 = (state_46642[(7)]);
var inst_46595__$1 = (state_46642[(2)]);
var inst_46596 = (inst_46595__$1 == null);
var state_46642__$1 = (function (){var statearr_46655 = state_46642;
(statearr_46655[(7)] = inst_46595__$1);

return statearr_46655;
})();
if(cljs.core.truth_(inst_46596)){
var statearr_46656_49830 = state_46642__$1;
(statearr_46656_49830[(1)] = (5));

} else {
var statearr_46657_49831 = state_46642__$1;
(statearr_46657_49831[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (15))){
var inst_46616 = (state_46642[(8)]);
var state_46642__$1 = state_46642;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46642__$1,(18),to,inst_46616);
} else {
if((state_val_46643 === (21))){
var inst_46629 = (state_46642[(2)]);
var state_46642__$1 = state_46642;
var statearr_46675_49833 = state_46642__$1;
(statearr_46675_49833[(2)] = inst_46629);

(statearr_46675_49833[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (13))){
var inst_46631 = (state_46642[(2)]);
var state_46642__$1 = (function (){var statearr_46688 = state_46642;
(statearr_46688[(9)] = inst_46631);

return statearr_46688;
})();
var statearr_46692_49834 = state_46642__$1;
(statearr_46692_49834[(2)] = null);

(statearr_46692_49834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (6))){
var inst_46595 = (state_46642[(7)]);
var state_46642__$1 = state_46642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46642__$1,(11),inst_46595);
} else {
if((state_val_46643 === (17))){
var inst_46624 = (state_46642[(2)]);
var state_46642__$1 = state_46642;
if(cljs.core.truth_(inst_46624)){
var statearr_46704_49836 = state_46642__$1;
(statearr_46704_49836[(1)] = (19));

} else {
var statearr_46705_49837 = state_46642__$1;
(statearr_46705_49837[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (3))){
var inst_46636 = (state_46642[(2)]);
var state_46642__$1 = state_46642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46642__$1,inst_46636);
} else {
if((state_val_46643 === (12))){
var inst_46608 = (state_46642[(10)]);
var state_46642__$1 = state_46642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46642__$1,(14),inst_46608);
} else {
if((state_val_46643 === (2))){
var state_46642__$1 = state_46642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46642__$1,(4),results);
} else {
if((state_val_46643 === (19))){
var state_46642__$1 = state_46642;
var statearr_46722_49840 = state_46642__$1;
(statearr_46722_49840[(2)] = null);

(statearr_46722_49840[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (11))){
var inst_46608 = (state_46642[(2)]);
var state_46642__$1 = (function (){var statearr_46727 = state_46642;
(statearr_46727[(10)] = inst_46608);

return statearr_46727;
})();
var statearr_46730_49842 = state_46642__$1;
(statearr_46730_49842[(2)] = null);

(statearr_46730_49842[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (9))){
var state_46642__$1 = state_46642;
var statearr_46731_49843 = state_46642__$1;
(statearr_46731_49843[(2)] = null);

(statearr_46731_49843[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (5))){
var state_46642__$1 = state_46642;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46735_49845 = state_46642__$1;
(statearr_46735_49845[(1)] = (8));

} else {
var statearr_46737_49846 = state_46642__$1;
(statearr_46737_49846[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (14))){
var inst_46616 = (state_46642[(8)]);
var inst_46616__$1 = (state_46642[(2)]);
var inst_46617 = (inst_46616__$1 == null);
var inst_46618 = cljs.core.not(inst_46617);
var state_46642__$1 = (function (){var statearr_46743 = state_46642;
(statearr_46743[(8)] = inst_46616__$1);

return statearr_46743;
})();
if(inst_46618){
var statearr_46744_49847 = state_46642__$1;
(statearr_46744_49847[(1)] = (15));

} else {
var statearr_46745_49848 = state_46642__$1;
(statearr_46745_49848[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (16))){
var state_46642__$1 = state_46642;
var statearr_46750_49850 = state_46642__$1;
(statearr_46750_49850[(2)] = false);

(statearr_46750_49850[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (10))){
var inst_46604 = (state_46642[(2)]);
var state_46642__$1 = state_46642;
var statearr_46754_49851 = state_46642__$1;
(statearr_46754_49851[(2)] = inst_46604);

(statearr_46754_49851[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (18))){
var inst_46621 = (state_46642[(2)]);
var state_46642__$1 = state_46642;
var statearr_46755_49852 = state_46642__$1;
(statearr_46755_49852[(2)] = inst_46621);

(statearr_46755_49852[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46643 === (8))){
var inst_46599 = cljs.core.async.close_BANG_(to);
var state_46642__$1 = state_46642;
var statearr_46756_49853 = state_46642__$1;
(statearr_46756_49853[(2)] = inst_46599);

(statearr_46756_49853[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0 = (function (){
var statearr_46764 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46764[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__);

(statearr_46764[(1)] = (1));

return statearr_46764;
});
var cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1 = (function (state_46642){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_46642);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e46766){var ex__45476__auto__ = e46766;
var statearr_46768_49859 = state_46642;
(statearr_46768_49859[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_46642[(4)]))){
var statearr_46770_49861 = state_46642;
(statearr_46770_49861[(1)] = cljs.core.first((state_46642[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49862 = state_46642;
state_46642 = G__49862;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__ = function(state_46642){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1.call(this,state_46642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__45473__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_46786 = f__45601__auto__();
(statearr_46786[(6)] = c__45600__auto__);

return statearr_46786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));

return c__45600__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__46799 = arguments.length;
switch (G__46799) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__46816 = arguments.length;
switch (G__46816) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__46845 = arguments.length;
switch (G__46845) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__45600__auto___49878 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_46885){
var state_val_46886 = (state_46885[(1)]);
if((state_val_46886 === (7))){
var inst_46881 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46923_49881 = state_46885__$1;
(statearr_46923_49881[(2)] = inst_46881);

(statearr_46923_49881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (1))){
var state_46885__$1 = state_46885;
var statearr_46926_49883 = state_46885__$1;
(statearr_46926_49883[(2)] = null);

(statearr_46926_49883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (4))){
var inst_46859 = (state_46885[(7)]);
var inst_46859__$1 = (state_46885[(2)]);
var inst_46861 = (inst_46859__$1 == null);
var state_46885__$1 = (function (){var statearr_46929 = state_46885;
(statearr_46929[(7)] = inst_46859__$1);

return statearr_46929;
})();
if(cljs.core.truth_(inst_46861)){
var statearr_46930_49884 = state_46885__$1;
(statearr_46930_49884[(1)] = (5));

} else {
var statearr_46931_49886 = state_46885__$1;
(statearr_46931_49886[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (13))){
var state_46885__$1 = state_46885;
var statearr_46936_49887 = state_46885__$1;
(statearr_46936_49887[(2)] = null);

(statearr_46936_49887[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (6))){
var inst_46859 = (state_46885[(7)]);
var inst_46868 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_46859) : p.call(null,inst_46859));
var state_46885__$1 = state_46885;
if(cljs.core.truth_(inst_46868)){
var statearr_46942_49891 = state_46885__$1;
(statearr_46942_49891[(1)] = (9));

} else {
var statearr_46943_49892 = state_46885__$1;
(statearr_46943_49892[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (3))){
var inst_46883 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46885__$1,inst_46883);
} else {
if((state_val_46886 === (12))){
var state_46885__$1 = state_46885;
var statearr_46952_49893 = state_46885__$1;
(statearr_46952_49893[(2)] = null);

(statearr_46952_49893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (2))){
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46885__$1,(4),ch);
} else {
if((state_val_46886 === (11))){
var inst_46859 = (state_46885[(7)]);
var inst_46872 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46885__$1,(8),inst_46872,inst_46859);
} else {
if((state_val_46886 === (9))){
var state_46885__$1 = state_46885;
var statearr_46955_49898 = state_46885__$1;
(statearr_46955_49898[(2)] = tc);

(statearr_46955_49898[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (5))){
var inst_46864 = cljs.core.async.close_BANG_(tc);
var inst_46865 = cljs.core.async.close_BANG_(fc);
var state_46885__$1 = (function (){var statearr_46961 = state_46885;
(statearr_46961[(8)] = inst_46864);

return statearr_46961;
})();
var statearr_46962_49900 = state_46885__$1;
(statearr_46962_49900[(2)] = inst_46865);

(statearr_46962_49900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (14))){
var inst_46879 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
var statearr_46969_49903 = state_46885__$1;
(statearr_46969_49903[(2)] = inst_46879);

(statearr_46969_49903[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (10))){
var state_46885__$1 = state_46885;
var statearr_46975_49906 = state_46885__$1;
(statearr_46975_49906[(2)] = fc);

(statearr_46975_49906[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46886 === (8))){
var inst_46874 = (state_46885[(2)]);
var state_46885__$1 = state_46885;
if(cljs.core.truth_(inst_46874)){
var statearr_46983_49909 = state_46885__$1;
(statearr_46983_49909[(1)] = (12));

} else {
var statearr_46985_49910 = state_46885__$1;
(statearr_46985_49910[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_46999 = [null,null,null,null,null,null,null,null,null];
(statearr_46999[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_46999[(1)] = (1));

return statearr_46999;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_46885){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_46885);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e47007){var ex__45476__auto__ = e47007;
var statearr_47009_49916 = state_46885;
(statearr_47009_49916[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_46885[(4)]))){
var statearr_47015_49917 = state_46885;
(statearr_47015_49917[(1)] = cljs.core.first((state_46885[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49921 = state_46885;
state_46885 = G__49921;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_46885){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_46885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_47023 = f__45601__auto__();
(statearr_47023[(6)] = c__45600__auto___49878);

return statearr_47023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__45600__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_47047){
var state_val_47048 = (state_47047[(1)]);
if((state_val_47048 === (7))){
var inst_47043 = (state_47047[(2)]);
var state_47047__$1 = state_47047;
var statearr_47049_49929 = state_47047__$1;
(statearr_47049_49929[(2)] = inst_47043);

(statearr_47049_49929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47048 === (1))){
var inst_47026 = init;
var inst_47027 = inst_47026;
var state_47047__$1 = (function (){var statearr_47054 = state_47047;
(statearr_47054[(7)] = inst_47027);

return statearr_47054;
})();
var statearr_47055_49930 = state_47047__$1;
(statearr_47055_49930[(2)] = null);

(statearr_47055_49930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47048 === (4))){
var inst_47030 = (state_47047[(8)]);
var inst_47030__$1 = (state_47047[(2)]);
var inst_47031 = (inst_47030__$1 == null);
var state_47047__$1 = (function (){var statearr_47056 = state_47047;
(statearr_47056[(8)] = inst_47030__$1);

return statearr_47056;
})();
if(cljs.core.truth_(inst_47031)){
var statearr_47057_49934 = state_47047__$1;
(statearr_47057_49934[(1)] = (5));

} else {
var statearr_47058_49935 = state_47047__$1;
(statearr_47058_49935[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47048 === (6))){
var inst_47034 = (state_47047[(9)]);
var inst_47030 = (state_47047[(8)]);
var inst_47027 = (state_47047[(7)]);
var inst_47034__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_47027,inst_47030) : f.call(null,inst_47027,inst_47030));
var inst_47035 = cljs.core.reduced_QMARK_(inst_47034__$1);
var state_47047__$1 = (function (){var statearr_47063 = state_47047;
(statearr_47063[(9)] = inst_47034__$1);

return statearr_47063;
})();
if(inst_47035){
var statearr_47066_49940 = state_47047__$1;
(statearr_47066_49940[(1)] = (8));

} else {
var statearr_47069_49941 = state_47047__$1;
(statearr_47069_49941[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47048 === (3))){
var inst_47045 = (state_47047[(2)]);
var state_47047__$1 = state_47047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47047__$1,inst_47045);
} else {
if((state_val_47048 === (2))){
var state_47047__$1 = state_47047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47047__$1,(4),ch);
} else {
if((state_val_47048 === (9))){
var inst_47034 = (state_47047[(9)]);
var inst_47027 = inst_47034;
var state_47047__$1 = (function (){var statearr_47070 = state_47047;
(statearr_47070[(7)] = inst_47027);

return statearr_47070;
})();
var statearr_47071_49946 = state_47047__$1;
(statearr_47071_49946[(2)] = null);

(statearr_47071_49946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47048 === (5))){
var inst_47027 = (state_47047[(7)]);
var state_47047__$1 = state_47047;
var statearr_47072_49949 = state_47047__$1;
(statearr_47072_49949[(2)] = inst_47027);

(statearr_47072_49949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47048 === (10))){
var inst_47041 = (state_47047[(2)]);
var state_47047__$1 = state_47047;
var statearr_47073_49951 = state_47047__$1;
(statearr_47073_49951[(2)] = inst_47041);

(statearr_47073_49951[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47048 === (8))){
var inst_47034 = (state_47047[(9)]);
var inst_47037 = cljs.core.deref(inst_47034);
var state_47047__$1 = state_47047;
var statearr_47076_49952 = state_47047__$1;
(statearr_47076_49952[(2)] = inst_47037);

(statearr_47076_49952[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__45473__auto__ = null;
var cljs$core$async$reduce_$_state_machine__45473__auto____0 = (function (){
var statearr_47077 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47077[(0)] = cljs$core$async$reduce_$_state_machine__45473__auto__);

(statearr_47077[(1)] = (1));

return statearr_47077;
});
var cljs$core$async$reduce_$_state_machine__45473__auto____1 = (function (state_47047){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_47047);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e47082){var ex__45476__auto__ = e47082;
var statearr_47083_49957 = state_47047;
(statearr_47083_49957[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_47047[(4)]))){
var statearr_47088_49959 = state_47047;
(statearr_47088_49959[(1)] = cljs.core.first((state_47047[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49962 = state_47047;
state_47047 = G__49962;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__45473__auto__ = function(state_47047){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__45473__auto____1.call(this,state_47047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__45473__auto____0;
cljs$core$async$reduce_$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__45473__auto____1;
return cljs$core$async$reduce_$_state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_47093 = f__45601__auto__();
(statearr_47093[(6)] = c__45600__auto__);

return statearr_47093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));

return c__45600__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__45600__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_47101){
var state_val_47102 = (state_47101[(1)]);
if((state_val_47102 === (1))){
var inst_47096 = cljs.core.async.reduce(f__$1,init,ch);
var state_47101__$1 = state_47101;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47101__$1,(2),inst_47096);
} else {
if((state_val_47102 === (2))){
var inst_47098 = (state_47101[(2)]);
var inst_47099 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_47098) : f__$1.call(null,inst_47098));
var state_47101__$1 = state_47101;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47101__$1,inst_47099);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__45473__auto__ = null;
var cljs$core$async$transduce_$_state_machine__45473__auto____0 = (function (){
var statearr_47104 = [null,null,null,null,null,null,null];
(statearr_47104[(0)] = cljs$core$async$transduce_$_state_machine__45473__auto__);

(statearr_47104[(1)] = (1));

return statearr_47104;
});
var cljs$core$async$transduce_$_state_machine__45473__auto____1 = (function (state_47101){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_47101);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e47105){var ex__45476__auto__ = e47105;
var statearr_47106_49971 = state_47101;
(statearr_47106_49971[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_47101[(4)]))){
var statearr_47107_49973 = state_47101;
(statearr_47107_49973[(1)] = cljs.core.first((state_47101[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49974 = state_47101;
state_47101 = G__49974;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__45473__auto__ = function(state_47101){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__45473__auto____1.call(this,state_47101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__45473__auto____0;
cljs$core$async$transduce_$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__45473__auto____1;
return cljs$core$async$transduce_$_state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_47108 = f__45601__auto__();
(statearr_47108[(6)] = c__45600__auto__);

return statearr_47108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));

return c__45600__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__47112 = arguments.length;
switch (G__47112) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__45600__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_47142){
var state_val_47143 = (state_47142[(1)]);
if((state_val_47143 === (7))){
var inst_47123 = (state_47142[(2)]);
var state_47142__$1 = state_47142;
var statearr_47145_49978 = state_47142__$1;
(statearr_47145_49978[(2)] = inst_47123);

(statearr_47145_49978[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (1))){
var inst_47113 = cljs.core.seq(coll);
var inst_47114 = inst_47113;
var state_47142__$1 = (function (){var statearr_47146 = state_47142;
(statearr_47146[(7)] = inst_47114);

return statearr_47146;
})();
var statearr_47147_49980 = state_47142__$1;
(statearr_47147_49980[(2)] = null);

(statearr_47147_49980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (4))){
var inst_47114 = (state_47142[(7)]);
var inst_47121 = cljs.core.first(inst_47114);
var state_47142__$1 = state_47142;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47142__$1,(7),ch,inst_47121);
} else {
if((state_val_47143 === (13))){
var inst_47136 = (state_47142[(2)]);
var state_47142__$1 = state_47142;
var statearr_47152_49982 = state_47142__$1;
(statearr_47152_49982[(2)] = inst_47136);

(statearr_47152_49982[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (6))){
var inst_47126 = (state_47142[(2)]);
var state_47142__$1 = state_47142;
if(cljs.core.truth_(inst_47126)){
var statearr_47153_49984 = state_47142__$1;
(statearr_47153_49984[(1)] = (8));

} else {
var statearr_47154_49985 = state_47142__$1;
(statearr_47154_49985[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (3))){
var inst_47140 = (state_47142[(2)]);
var state_47142__$1 = state_47142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47142__$1,inst_47140);
} else {
if((state_val_47143 === (12))){
var state_47142__$1 = state_47142;
var statearr_47159_49987 = state_47142__$1;
(statearr_47159_49987[(2)] = null);

(statearr_47159_49987[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (2))){
var inst_47114 = (state_47142[(7)]);
var state_47142__$1 = state_47142;
if(cljs.core.truth_(inst_47114)){
var statearr_47163_49988 = state_47142__$1;
(statearr_47163_49988[(1)] = (4));

} else {
var statearr_47164_49989 = state_47142__$1;
(statearr_47164_49989[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (11))){
var inst_47133 = cljs.core.async.close_BANG_(ch);
var state_47142__$1 = state_47142;
var statearr_47165_49992 = state_47142__$1;
(statearr_47165_49992[(2)] = inst_47133);

(statearr_47165_49992[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (9))){
var state_47142__$1 = state_47142;
if(cljs.core.truth_(close_QMARK_)){
var statearr_47166_49994 = state_47142__$1;
(statearr_47166_49994[(1)] = (11));

} else {
var statearr_47167_49995 = state_47142__$1;
(statearr_47167_49995[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (5))){
var inst_47114 = (state_47142[(7)]);
var state_47142__$1 = state_47142;
var statearr_47168_49996 = state_47142__$1;
(statearr_47168_49996[(2)] = inst_47114);

(statearr_47168_49996[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (10))){
var inst_47138 = (state_47142[(2)]);
var state_47142__$1 = state_47142;
var statearr_47171_49997 = state_47142__$1;
(statearr_47171_49997[(2)] = inst_47138);

(statearr_47171_49997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47143 === (8))){
var inst_47114 = (state_47142[(7)]);
var inst_47129 = cljs.core.next(inst_47114);
var inst_47114__$1 = inst_47129;
var state_47142__$1 = (function (){var statearr_47173 = state_47142;
(statearr_47173[(7)] = inst_47114__$1);

return statearr_47173;
})();
var statearr_47174_50001 = state_47142__$1;
(statearr_47174_50001[(2)] = null);

(statearr_47174_50001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_47175 = [null,null,null,null,null,null,null,null];
(statearr_47175[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_47175[(1)] = (1));

return statearr_47175;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_47142){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_47142);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e47177){var ex__45476__auto__ = e47177;
var statearr_47178_50006 = state_47142;
(statearr_47178_50006[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_47142[(4)]))){
var statearr_47179_50007 = state_47142;
(statearr_47179_50007[(1)] = cljs.core.first((state_47142[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50008 = state_47142;
state_47142 = G__50008;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_47142){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_47142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_47181 = f__45601__auto__();
(statearr_47181[(6)] = c__45600__auto__);

return statearr_47181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));

return c__45600__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__47184 = arguments.length;
switch (G__47184) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_50019 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_50019(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_50024 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_50024(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_50028 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_50028(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_50029 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_50029(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47251 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47251 = (function (ch,cs,meta47252){
this.ch = ch;
this.cs = cs;
this.meta47252 = meta47252;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47251.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47253,meta47252__$1){
var self__ = this;
var _47253__$1 = this;
return (new cljs.core.async.t_cljs$core$async47251(self__.ch,self__.cs,meta47252__$1));
}));

(cljs.core.async.t_cljs$core$async47251.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47253){
var self__ = this;
var _47253__$1 = this;
return self__.meta47252;
}));

(cljs.core.async.t_cljs$core$async47251.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47251.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async47251.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47251.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async47251.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async47251.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async47251.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta47252","meta47252",1368436285,null)], null);
}));

(cljs.core.async.t_cljs$core$async47251.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47251.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47251");

(cljs.core.async.t_cljs$core$async47251.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47251");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47251.
 */
cljs.core.async.__GT_t_cljs$core$async47251 = (function cljs$core$async$mult_$___GT_t_cljs$core$async47251(ch__$1,cs__$1,meta47252){
return (new cljs.core.async.t_cljs$core$async47251(ch__$1,cs__$1,meta47252));
});

}

return (new cljs.core.async.t_cljs$core$async47251(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__45600__auto___50040 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_47433){
var state_val_47434 = (state_47433[(1)]);
if((state_val_47434 === (7))){
var inst_47426 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47437_50041 = state_47433__$1;
(statearr_47437_50041[(2)] = inst_47426);

(statearr_47437_50041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (20))){
var inst_47312 = (state_47433[(7)]);
var inst_47328 = cljs.core.first(inst_47312);
var inst_47329 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47328,(0),null);
var inst_47330 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47328,(1),null);
var state_47433__$1 = (function (){var statearr_47438 = state_47433;
(statearr_47438[(8)] = inst_47329);

return statearr_47438;
})();
if(cljs.core.truth_(inst_47330)){
var statearr_47439_50042 = state_47433__$1;
(statearr_47439_50042[(1)] = (22));

} else {
var statearr_47440_50043 = state_47433__$1;
(statearr_47440_50043[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (27))){
var inst_47368 = (state_47433[(9)]);
var inst_47278 = (state_47433[(10)]);
var inst_47363 = (state_47433[(11)]);
var inst_47361 = (state_47433[(12)]);
var inst_47368__$1 = cljs.core._nth(inst_47361,inst_47363);
var inst_47369 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47368__$1,inst_47278,done);
var state_47433__$1 = (function (){var statearr_47445 = state_47433;
(statearr_47445[(9)] = inst_47368__$1);

return statearr_47445;
})();
if(cljs.core.truth_(inst_47369)){
var statearr_47446_50044 = state_47433__$1;
(statearr_47446_50044[(1)] = (30));

} else {
var statearr_47447_50045 = state_47433__$1;
(statearr_47447_50045[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (1))){
var state_47433__$1 = state_47433;
var statearr_47449_50046 = state_47433__$1;
(statearr_47449_50046[(2)] = null);

(statearr_47449_50046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (24))){
var inst_47312 = (state_47433[(7)]);
var inst_47337 = (state_47433[(2)]);
var inst_47338 = cljs.core.next(inst_47312);
var inst_47287 = inst_47338;
var inst_47288 = null;
var inst_47289 = (0);
var inst_47290 = (0);
var state_47433__$1 = (function (){var statearr_47454 = state_47433;
(statearr_47454[(13)] = inst_47290);

(statearr_47454[(14)] = inst_47289);

(statearr_47454[(15)] = inst_47288);

(statearr_47454[(16)] = inst_47337);

(statearr_47454[(17)] = inst_47287);

return statearr_47454;
})();
var statearr_47455_50047 = state_47433__$1;
(statearr_47455_50047[(2)] = null);

(statearr_47455_50047[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (39))){
var state_47433__$1 = state_47433;
var statearr_47459_50048 = state_47433__$1;
(statearr_47459_50048[(2)] = null);

(statearr_47459_50048[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (4))){
var inst_47278 = (state_47433[(10)]);
var inst_47278__$1 = (state_47433[(2)]);
var inst_47279 = (inst_47278__$1 == null);
var state_47433__$1 = (function (){var statearr_47461 = state_47433;
(statearr_47461[(10)] = inst_47278__$1);

return statearr_47461;
})();
if(cljs.core.truth_(inst_47279)){
var statearr_47462_50049 = state_47433__$1;
(statearr_47462_50049[(1)] = (5));

} else {
var statearr_47463_50050 = state_47433__$1;
(statearr_47463_50050[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (15))){
var inst_47290 = (state_47433[(13)]);
var inst_47289 = (state_47433[(14)]);
var inst_47288 = (state_47433[(15)]);
var inst_47287 = (state_47433[(17)]);
var inst_47307 = (state_47433[(2)]);
var inst_47309 = (inst_47290 + (1));
var tmp47456 = inst_47289;
var tmp47457 = inst_47288;
var tmp47458 = inst_47287;
var inst_47287__$1 = tmp47458;
var inst_47288__$1 = tmp47457;
var inst_47289__$1 = tmp47456;
var inst_47290__$1 = inst_47309;
var state_47433__$1 = (function (){var statearr_47469 = state_47433;
(statearr_47469[(13)] = inst_47290__$1);

(statearr_47469[(14)] = inst_47289__$1);

(statearr_47469[(15)] = inst_47288__$1);

(statearr_47469[(17)] = inst_47287__$1);

(statearr_47469[(18)] = inst_47307);

return statearr_47469;
})();
var statearr_47470_50052 = state_47433__$1;
(statearr_47470_50052[(2)] = null);

(statearr_47470_50052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (21))){
var inst_47341 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47474_50053 = state_47433__$1;
(statearr_47474_50053[(2)] = inst_47341);

(statearr_47474_50053[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (31))){
var inst_47368 = (state_47433[(9)]);
var inst_47376 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47368);
var state_47433__$1 = state_47433;
var statearr_47478_50054 = state_47433__$1;
(statearr_47478_50054[(2)] = inst_47376);

(statearr_47478_50054[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (32))){
var inst_47362 = (state_47433[(19)]);
var inst_47360 = (state_47433[(20)]);
var inst_47363 = (state_47433[(11)]);
var inst_47361 = (state_47433[(12)]);
var inst_47378 = (state_47433[(2)]);
var inst_47380 = (inst_47363 + (1));
var tmp47471 = inst_47362;
var tmp47472 = inst_47360;
var tmp47473 = inst_47361;
var inst_47360__$1 = tmp47472;
var inst_47361__$1 = tmp47473;
var inst_47362__$1 = tmp47471;
var inst_47363__$1 = inst_47380;
var state_47433__$1 = (function (){var statearr_47480 = state_47433;
(statearr_47480[(19)] = inst_47362__$1);

(statearr_47480[(21)] = inst_47378);

(statearr_47480[(20)] = inst_47360__$1);

(statearr_47480[(11)] = inst_47363__$1);

(statearr_47480[(12)] = inst_47361__$1);

return statearr_47480;
})();
var statearr_47481_50056 = state_47433__$1;
(statearr_47481_50056[(2)] = null);

(statearr_47481_50056[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (40))){
var inst_47397 = (state_47433[(22)]);
var inst_47401 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_47397);
var state_47433__$1 = state_47433;
var statearr_47483_50058 = state_47433__$1;
(statearr_47483_50058[(2)] = inst_47401);

(statearr_47483_50058[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (33))){
var inst_47383 = (state_47433[(23)]);
var inst_47389 = cljs.core.chunked_seq_QMARK_(inst_47383);
var state_47433__$1 = state_47433;
if(inst_47389){
var statearr_47484_50062 = state_47433__$1;
(statearr_47484_50062[(1)] = (36));

} else {
var statearr_47485_50063 = state_47433__$1;
(statearr_47485_50063[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (13))){
var inst_47299 = (state_47433[(24)]);
var inst_47304 = cljs.core.async.close_BANG_(inst_47299);
var state_47433__$1 = state_47433;
var statearr_47487_50064 = state_47433__$1;
(statearr_47487_50064[(2)] = inst_47304);

(statearr_47487_50064[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (22))){
var inst_47329 = (state_47433[(8)]);
var inst_47334 = cljs.core.async.close_BANG_(inst_47329);
var state_47433__$1 = state_47433;
var statearr_47488_50068 = state_47433__$1;
(statearr_47488_50068[(2)] = inst_47334);

(statearr_47488_50068[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (36))){
var inst_47383 = (state_47433[(23)]);
var inst_47391 = cljs.core.chunk_first(inst_47383);
var inst_47392 = cljs.core.chunk_rest(inst_47383);
var inst_47393 = cljs.core.count(inst_47391);
var inst_47360 = inst_47392;
var inst_47361 = inst_47391;
var inst_47362 = inst_47393;
var inst_47363 = (0);
var state_47433__$1 = (function (){var statearr_47490 = state_47433;
(statearr_47490[(19)] = inst_47362);

(statearr_47490[(20)] = inst_47360);

(statearr_47490[(11)] = inst_47363);

(statearr_47490[(12)] = inst_47361);

return statearr_47490;
})();
var statearr_47491_50070 = state_47433__$1;
(statearr_47491_50070[(2)] = null);

(statearr_47491_50070[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (41))){
var inst_47383 = (state_47433[(23)]);
var inst_47403 = (state_47433[(2)]);
var inst_47404 = cljs.core.next(inst_47383);
var inst_47360 = inst_47404;
var inst_47361 = null;
var inst_47362 = (0);
var inst_47363 = (0);
var state_47433__$1 = (function (){var statearr_47493 = state_47433;
(statearr_47493[(19)] = inst_47362);

(statearr_47493[(25)] = inst_47403);

(statearr_47493[(20)] = inst_47360);

(statearr_47493[(11)] = inst_47363);

(statearr_47493[(12)] = inst_47361);

return statearr_47493;
})();
var statearr_47494_50071 = state_47433__$1;
(statearr_47494_50071[(2)] = null);

(statearr_47494_50071[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (43))){
var state_47433__$1 = state_47433;
var statearr_47496_50073 = state_47433__$1;
(statearr_47496_50073[(2)] = null);

(statearr_47496_50073[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (29))){
var inst_47412 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47497_50074 = state_47433__$1;
(statearr_47497_50074[(2)] = inst_47412);

(statearr_47497_50074[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (44))){
var inst_47422 = (state_47433[(2)]);
var state_47433__$1 = (function (){var statearr_47499 = state_47433;
(statearr_47499[(26)] = inst_47422);

return statearr_47499;
})();
var statearr_47500_50077 = state_47433__$1;
(statearr_47500_50077[(2)] = null);

(statearr_47500_50077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (6))){
var inst_47351 = (state_47433[(27)]);
var inst_47350 = cljs.core.deref(cs);
var inst_47351__$1 = cljs.core.keys(inst_47350);
var inst_47352 = cljs.core.count(inst_47351__$1);
var inst_47353 = cljs.core.reset_BANG_(dctr,inst_47352);
var inst_47359 = cljs.core.seq(inst_47351__$1);
var inst_47360 = inst_47359;
var inst_47361 = null;
var inst_47362 = (0);
var inst_47363 = (0);
var state_47433__$1 = (function (){var statearr_47502 = state_47433;
(statearr_47502[(27)] = inst_47351__$1);

(statearr_47502[(28)] = inst_47353);

(statearr_47502[(19)] = inst_47362);

(statearr_47502[(20)] = inst_47360);

(statearr_47502[(11)] = inst_47363);

(statearr_47502[(12)] = inst_47361);

return statearr_47502;
})();
var statearr_47503_50083 = state_47433__$1;
(statearr_47503_50083[(2)] = null);

(statearr_47503_50083[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (28))){
var inst_47383 = (state_47433[(23)]);
var inst_47360 = (state_47433[(20)]);
var inst_47383__$1 = cljs.core.seq(inst_47360);
var state_47433__$1 = (function (){var statearr_47507 = state_47433;
(statearr_47507[(23)] = inst_47383__$1);

return statearr_47507;
})();
if(inst_47383__$1){
var statearr_47508_50084 = state_47433__$1;
(statearr_47508_50084[(1)] = (33));

} else {
var statearr_47509_50085 = state_47433__$1;
(statearr_47509_50085[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (25))){
var inst_47362 = (state_47433[(19)]);
var inst_47363 = (state_47433[(11)]);
var inst_47365 = (inst_47363 < inst_47362);
var inst_47366 = inst_47365;
var state_47433__$1 = state_47433;
if(cljs.core.truth_(inst_47366)){
var statearr_47511_50087 = state_47433__$1;
(statearr_47511_50087[(1)] = (27));

} else {
var statearr_47512_50088 = state_47433__$1;
(statearr_47512_50088[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (34))){
var state_47433__$1 = state_47433;
var statearr_47513_50091 = state_47433__$1;
(statearr_47513_50091[(2)] = null);

(statearr_47513_50091[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (17))){
var state_47433__$1 = state_47433;
var statearr_47514_50094 = state_47433__$1;
(statearr_47514_50094[(2)] = null);

(statearr_47514_50094[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (3))){
var inst_47428 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47433__$1,inst_47428);
} else {
if((state_val_47434 === (12))){
var inst_47346 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47518_50095 = state_47433__$1;
(statearr_47518_50095[(2)] = inst_47346);

(statearr_47518_50095[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (2))){
var state_47433__$1 = state_47433;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47433__$1,(4),ch);
} else {
if((state_val_47434 === (23))){
var state_47433__$1 = state_47433;
var statearr_47523_50096 = state_47433__$1;
(statearr_47523_50096[(2)] = null);

(statearr_47523_50096[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (35))){
var inst_47410 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47526_50097 = state_47433__$1;
(statearr_47526_50097[(2)] = inst_47410);

(statearr_47526_50097[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (19))){
var inst_47312 = (state_47433[(7)]);
var inst_47317 = cljs.core.chunk_first(inst_47312);
var inst_47318 = cljs.core.chunk_rest(inst_47312);
var inst_47319 = cljs.core.count(inst_47317);
var inst_47287 = inst_47318;
var inst_47288 = inst_47317;
var inst_47289 = inst_47319;
var inst_47290 = (0);
var state_47433__$1 = (function (){var statearr_47528 = state_47433;
(statearr_47528[(13)] = inst_47290);

(statearr_47528[(14)] = inst_47289);

(statearr_47528[(15)] = inst_47288);

(statearr_47528[(17)] = inst_47287);

return statearr_47528;
})();
var statearr_47529_50098 = state_47433__$1;
(statearr_47529_50098[(2)] = null);

(statearr_47529_50098[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (11))){
var inst_47312 = (state_47433[(7)]);
var inst_47287 = (state_47433[(17)]);
var inst_47312__$1 = cljs.core.seq(inst_47287);
var state_47433__$1 = (function (){var statearr_47532 = state_47433;
(statearr_47532[(7)] = inst_47312__$1);

return statearr_47532;
})();
if(inst_47312__$1){
var statearr_47534_50099 = state_47433__$1;
(statearr_47534_50099[(1)] = (16));

} else {
var statearr_47535_50100 = state_47433__$1;
(statearr_47535_50100[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (9))){
var inst_47348 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47536_50101 = state_47433__$1;
(statearr_47536_50101[(2)] = inst_47348);

(statearr_47536_50101[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (5))){
var inst_47285 = cljs.core.deref(cs);
var inst_47286 = cljs.core.seq(inst_47285);
var inst_47287 = inst_47286;
var inst_47288 = null;
var inst_47289 = (0);
var inst_47290 = (0);
var state_47433__$1 = (function (){var statearr_47537 = state_47433;
(statearr_47537[(13)] = inst_47290);

(statearr_47537[(14)] = inst_47289);

(statearr_47537[(15)] = inst_47288);

(statearr_47537[(17)] = inst_47287);

return statearr_47537;
})();
var statearr_47541_50102 = state_47433__$1;
(statearr_47541_50102[(2)] = null);

(statearr_47541_50102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (14))){
var state_47433__$1 = state_47433;
var statearr_47542_50103 = state_47433__$1;
(statearr_47542_50103[(2)] = null);

(statearr_47542_50103[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (45))){
var inst_47419 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47544_50104 = state_47433__$1;
(statearr_47544_50104[(2)] = inst_47419);

(statearr_47544_50104[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (26))){
var inst_47351 = (state_47433[(27)]);
var inst_47414 = (state_47433[(2)]);
var inst_47415 = cljs.core.seq(inst_47351);
var state_47433__$1 = (function (){var statearr_47547 = state_47433;
(statearr_47547[(29)] = inst_47414);

return statearr_47547;
})();
if(inst_47415){
var statearr_47548_50105 = state_47433__$1;
(statearr_47548_50105[(1)] = (42));

} else {
var statearr_47549_50106 = state_47433__$1;
(statearr_47549_50106[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (16))){
var inst_47312 = (state_47433[(7)]);
var inst_47315 = cljs.core.chunked_seq_QMARK_(inst_47312);
var state_47433__$1 = state_47433;
if(inst_47315){
var statearr_47550_50111 = state_47433__$1;
(statearr_47550_50111[(1)] = (19));

} else {
var statearr_47551_50112 = state_47433__$1;
(statearr_47551_50112[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (38))){
var inst_47407 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47552_50113 = state_47433__$1;
(statearr_47552_50113[(2)] = inst_47407);

(statearr_47552_50113[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (30))){
var state_47433__$1 = state_47433;
var statearr_47553_50114 = state_47433__$1;
(statearr_47553_50114[(2)] = null);

(statearr_47553_50114[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (10))){
var inst_47290 = (state_47433[(13)]);
var inst_47288 = (state_47433[(15)]);
var inst_47298 = cljs.core._nth(inst_47288,inst_47290);
var inst_47299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47298,(0),null);
var inst_47300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47298,(1),null);
var state_47433__$1 = (function (){var statearr_47554 = state_47433;
(statearr_47554[(24)] = inst_47299);

return statearr_47554;
})();
if(cljs.core.truth_(inst_47300)){
var statearr_47557_50118 = state_47433__$1;
(statearr_47557_50118[(1)] = (13));

} else {
var statearr_47558_50119 = state_47433__$1;
(statearr_47558_50119[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (18))){
var inst_47344 = (state_47433[(2)]);
var state_47433__$1 = state_47433;
var statearr_47560_50120 = state_47433__$1;
(statearr_47560_50120[(2)] = inst_47344);

(statearr_47560_50120[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (42))){
var state_47433__$1 = state_47433;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47433__$1,(45),dchan);
} else {
if((state_val_47434 === (37))){
var inst_47397 = (state_47433[(22)]);
var inst_47383 = (state_47433[(23)]);
var inst_47278 = (state_47433[(10)]);
var inst_47397__$1 = cljs.core.first(inst_47383);
var inst_47398 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_47397__$1,inst_47278,done);
var state_47433__$1 = (function (){var statearr_47563 = state_47433;
(statearr_47563[(22)] = inst_47397__$1);

return statearr_47563;
})();
if(cljs.core.truth_(inst_47398)){
var statearr_47565_50121 = state_47433__$1;
(statearr_47565_50121[(1)] = (39));

} else {
var statearr_47566_50122 = state_47433__$1;
(statearr_47566_50122[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47434 === (8))){
var inst_47290 = (state_47433[(13)]);
var inst_47289 = (state_47433[(14)]);
var inst_47292 = (inst_47290 < inst_47289);
var inst_47293 = inst_47292;
var state_47433__$1 = state_47433;
if(cljs.core.truth_(inst_47293)){
var statearr_47567_50123 = state_47433__$1;
(statearr_47567_50123[(1)] = (10));

} else {
var statearr_47569_50125 = state_47433__$1;
(statearr_47569_50125[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__45473__auto__ = null;
var cljs$core$async$mult_$_state_machine__45473__auto____0 = (function (){
var statearr_47578 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47578[(0)] = cljs$core$async$mult_$_state_machine__45473__auto__);

(statearr_47578[(1)] = (1));

return statearr_47578;
});
var cljs$core$async$mult_$_state_machine__45473__auto____1 = (function (state_47433){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_47433);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e47579){var ex__45476__auto__ = e47579;
var statearr_47580_50129 = state_47433;
(statearr_47580_50129[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_47433[(4)]))){
var statearr_47582_50131 = state_47433;
(statearr_47582_50131[(1)] = cljs.core.first((state_47433[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50132 = state_47433;
state_47433 = G__50132;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__45473__auto__ = function(state_47433){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__45473__auto____1.call(this,state_47433);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__45473__auto____0;
cljs$core$async$mult_$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__45473__auto____1;
return cljs$core$async$mult_$_state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_47585 = f__45601__auto__();
(statearr_47585[(6)] = c__45600__auto___50040);

return statearr_47585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__47593 = arguments.length;
switch (G__47593) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_50136 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_50136(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_50137 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_50137(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_50140 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_50140(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_50141 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_50141(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_50144 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_50144(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___50151 = arguments.length;
var i__4737__auto___50152 = (0);
while(true){
if((i__4737__auto___50152 < len__4736__auto___50151)){
args__4742__auto__.push((arguments[i__4737__auto___50152]));

var G__50154 = (i__4737__auto___50152 + (1));
i__4737__auto___50152 = G__50154;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__47650){
var map__47651 = p__47650;
var map__47651__$1 = (((((!((map__47651 == null))))?(((((map__47651.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47651.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__47651):map__47651);
var opts = map__47651__$1;
var statearr_47663_50156 = state;
(statearr_47663_50156[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_47677_50158 = state;
(statearr_47677_50158[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_47680_50163 = state;
(statearr_47680_50163[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq47645){
var G__47646 = cljs.core.first(seq47645);
var seq47645__$1 = cljs.core.next(seq47645);
var G__47647 = cljs.core.first(seq47645__$1);
var seq47645__$2 = cljs.core.next(seq47645__$1);
var G__47648 = cljs.core.first(seq47645__$2);
var seq47645__$3 = cljs.core.next(seq47645__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47646,G__47647,G__47648,seq47645__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47701 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47701 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta47702){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta47702 = meta47702;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47703,meta47702__$1){
var self__ = this;
var _47703__$1 = this;
return (new cljs.core.async.t_cljs$core$async47701(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta47702__$1));
}));

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47703){
var self__ = this;
var _47703__$1 = this;
return self__.meta47702;
}));

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47701.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async47701.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta47702","meta47702",1620917405,null)], null);
}));

(cljs.core.async.t_cljs$core$async47701.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47701.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47701");

(cljs.core.async.t_cljs$core$async47701.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47701");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47701.
 */
cljs.core.async.__GT_t_cljs$core$async47701 = (function cljs$core$async$mix_$___GT_t_cljs$core$async47701(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47702){
return (new cljs.core.async.t_cljs$core$async47701(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta47702));
});

}

return (new cljs.core.async.t_cljs$core$async47701(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45600__auto___50179 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_47851){
var state_val_47853 = (state_47851[(1)]);
if((state_val_47853 === (7))){
var inst_47754 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
var statearr_47872_50182 = state_47851__$1;
(statearr_47872_50182[(2)] = inst_47754);

(statearr_47872_50182[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (20))){
var inst_47766 = (state_47851[(7)]);
var state_47851__$1 = state_47851;
var statearr_47879_50184 = state_47851__$1;
(statearr_47879_50184[(2)] = inst_47766);

(statearr_47879_50184[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (27))){
var state_47851__$1 = state_47851;
var statearr_47888_50186 = state_47851__$1;
(statearr_47888_50186[(2)] = null);

(statearr_47888_50186[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (1))){
var inst_47730 = (state_47851[(8)]);
var inst_47730__$1 = calc_state();
var inst_47732 = (inst_47730__$1 == null);
var inst_47733 = cljs.core.not(inst_47732);
var state_47851__$1 = (function (){var statearr_47896 = state_47851;
(statearr_47896[(8)] = inst_47730__$1);

return statearr_47896;
})();
if(inst_47733){
var statearr_47897_50187 = state_47851__$1;
(statearr_47897_50187[(1)] = (2));

} else {
var statearr_47898_50188 = state_47851__$1;
(statearr_47898_50188[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (24))){
var inst_47800 = (state_47851[(9)]);
var inst_47791 = (state_47851[(10)]);
var inst_47825 = (state_47851[(11)]);
var inst_47825__$1 = (inst_47791.cljs$core$IFn$_invoke$arity$1 ? inst_47791.cljs$core$IFn$_invoke$arity$1(inst_47800) : inst_47791.call(null,inst_47800));
var state_47851__$1 = (function (){var statearr_47899 = state_47851;
(statearr_47899[(11)] = inst_47825__$1);

return statearr_47899;
})();
if(cljs.core.truth_(inst_47825__$1)){
var statearr_47900_50197 = state_47851__$1;
(statearr_47900_50197[(1)] = (29));

} else {
var statearr_47902_50198 = state_47851__$1;
(statearr_47902_50198[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (4))){
var inst_47757 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
if(cljs.core.truth_(inst_47757)){
var statearr_47903_50199 = state_47851__$1;
(statearr_47903_50199[(1)] = (8));

} else {
var statearr_47904_50200 = state_47851__$1;
(statearr_47904_50200[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (15))){
var inst_47785 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
if(cljs.core.truth_(inst_47785)){
var statearr_47905_50201 = state_47851__$1;
(statearr_47905_50201[(1)] = (19));

} else {
var statearr_47906_50202 = state_47851__$1;
(statearr_47906_50202[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (21))){
var inst_47790 = (state_47851[(12)]);
var inst_47790__$1 = (state_47851[(2)]);
var inst_47791 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47790__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_47792 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47790__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_47793 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47790__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_47851__$1 = (function (){var statearr_47912 = state_47851;
(statearr_47912[(10)] = inst_47791);

(statearr_47912[(13)] = inst_47792);

(statearr_47912[(12)] = inst_47790__$1);

return statearr_47912;
})();
return cljs.core.async.ioc_alts_BANG_(state_47851__$1,(22),inst_47793);
} else {
if((state_val_47853 === (31))){
var inst_47833 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
if(cljs.core.truth_(inst_47833)){
var statearr_47917_50205 = state_47851__$1;
(statearr_47917_50205[(1)] = (32));

} else {
var statearr_47918_50206 = state_47851__$1;
(statearr_47918_50206[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (32))){
var inst_47799 = (state_47851[(14)]);
var state_47851__$1 = state_47851;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47851__$1,(35),out,inst_47799);
} else {
if((state_val_47853 === (33))){
var inst_47790 = (state_47851[(12)]);
var inst_47766 = inst_47790;
var state_47851__$1 = (function (){var statearr_47925 = state_47851;
(statearr_47925[(7)] = inst_47766);

return statearr_47925;
})();
var statearr_47927_50209 = state_47851__$1;
(statearr_47927_50209[(2)] = null);

(statearr_47927_50209[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (13))){
var inst_47766 = (state_47851[(7)]);
var inst_47773 = inst_47766.cljs$lang$protocol_mask$partition0$;
var inst_47774 = (inst_47773 & (64));
var inst_47776 = inst_47766.cljs$core$ISeq$;
var inst_47777 = (cljs.core.PROTOCOL_SENTINEL === inst_47776);
var inst_47778 = ((inst_47774) || (inst_47777));
var state_47851__$1 = state_47851;
if(cljs.core.truth_(inst_47778)){
var statearr_47931_50211 = state_47851__$1;
(statearr_47931_50211[(1)] = (16));

} else {
var statearr_47933_50212 = state_47851__$1;
(statearr_47933_50212[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (22))){
var inst_47800 = (state_47851[(9)]);
var inst_47799 = (state_47851[(14)]);
var inst_47798 = (state_47851[(2)]);
var inst_47799__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47798,(0),null);
var inst_47800__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47798,(1),null);
var inst_47801 = (inst_47799__$1 == null);
var inst_47802 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47800__$1,change);
var inst_47803 = ((inst_47801) || (inst_47802));
var state_47851__$1 = (function (){var statearr_48001 = state_47851;
(statearr_48001[(9)] = inst_47800__$1);

(statearr_48001[(14)] = inst_47799__$1);

return statearr_48001;
})();
if(cljs.core.truth_(inst_47803)){
var statearr_48002_50215 = state_47851__$1;
(statearr_48002_50215[(1)] = (23));

} else {
var statearr_48003_50216 = state_47851__$1;
(statearr_48003_50216[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (36))){
var inst_47790 = (state_47851[(12)]);
var inst_47766 = inst_47790;
var state_47851__$1 = (function (){var statearr_48004 = state_47851;
(statearr_48004[(7)] = inst_47766);

return statearr_48004;
})();
var statearr_48005_50217 = state_47851__$1;
(statearr_48005_50217[(2)] = null);

(statearr_48005_50217[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (29))){
var inst_47825 = (state_47851[(11)]);
var state_47851__$1 = state_47851;
var statearr_48006_50218 = state_47851__$1;
(statearr_48006_50218[(2)] = inst_47825);

(statearr_48006_50218[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (6))){
var state_47851__$1 = state_47851;
var statearr_48007_50221 = state_47851__$1;
(statearr_48007_50221[(2)] = false);

(statearr_48007_50221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (28))){
var inst_47810 = (state_47851[(2)]);
var inst_47820 = calc_state();
var inst_47766 = inst_47820;
var state_47851__$1 = (function (){var statearr_48008 = state_47851;
(statearr_48008[(7)] = inst_47766);

(statearr_48008[(15)] = inst_47810);

return statearr_48008;
})();
var statearr_48009_50222 = state_47851__$1;
(statearr_48009_50222[(2)] = null);

(statearr_48009_50222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (25))){
var inst_47847 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
var statearr_48011_50223 = state_47851__$1;
(statearr_48011_50223[(2)] = inst_47847);

(statearr_48011_50223[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (34))){
var inst_47845 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
var statearr_48012_50225 = state_47851__$1;
(statearr_48012_50225[(2)] = inst_47845);

(statearr_48012_50225[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (17))){
var state_47851__$1 = state_47851;
var statearr_48013_50227 = state_47851__$1;
(statearr_48013_50227[(2)] = false);

(statearr_48013_50227[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (3))){
var state_47851__$1 = state_47851;
var statearr_48014_50229 = state_47851__$1;
(statearr_48014_50229[(2)] = false);

(statearr_48014_50229[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (12))){
var inst_47849 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47851__$1,inst_47849);
} else {
if((state_val_47853 === (2))){
var inst_47730 = (state_47851[(8)]);
var inst_47744 = inst_47730.cljs$lang$protocol_mask$partition0$;
var inst_47745 = (inst_47744 & (64));
var inst_47748 = inst_47730.cljs$core$ISeq$;
var inst_47749 = (cljs.core.PROTOCOL_SENTINEL === inst_47748);
var inst_47750 = ((inst_47745) || (inst_47749));
var state_47851__$1 = state_47851;
if(cljs.core.truth_(inst_47750)){
var statearr_48016_50231 = state_47851__$1;
(statearr_48016_50231[(1)] = (5));

} else {
var statearr_48017_50232 = state_47851__$1;
(statearr_48017_50232[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (23))){
var inst_47799 = (state_47851[(14)]);
var inst_47805 = (inst_47799 == null);
var state_47851__$1 = state_47851;
if(cljs.core.truth_(inst_47805)){
var statearr_48018_50233 = state_47851__$1;
(statearr_48018_50233[(1)] = (26));

} else {
var statearr_48019_50234 = state_47851__$1;
(statearr_48019_50234[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (35))){
var inst_47836 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
if(cljs.core.truth_(inst_47836)){
var statearr_48020_50235 = state_47851__$1;
(statearr_48020_50235[(1)] = (36));

} else {
var statearr_48022_50236 = state_47851__$1;
(statearr_48022_50236[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (19))){
var inst_47766 = (state_47851[(7)]);
var inst_47787 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_47766);
var state_47851__$1 = state_47851;
var statearr_48027_50237 = state_47851__$1;
(statearr_48027_50237[(2)] = inst_47787);

(statearr_48027_50237[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (11))){
var inst_47766 = (state_47851[(7)]);
var inst_47770 = (inst_47766 == null);
var inst_47771 = cljs.core.not(inst_47770);
var state_47851__$1 = state_47851;
if(inst_47771){
var statearr_48033_50238 = state_47851__$1;
(statearr_48033_50238[(1)] = (13));

} else {
var statearr_48038_50240 = state_47851__$1;
(statearr_48038_50240[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (9))){
var inst_47730 = (state_47851[(8)]);
var state_47851__$1 = state_47851;
var statearr_48039_50243 = state_47851__$1;
(statearr_48039_50243[(2)] = inst_47730);

(statearr_48039_50243[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (5))){
var state_47851__$1 = state_47851;
var statearr_48040_50246 = state_47851__$1;
(statearr_48040_50246[(2)] = true);

(statearr_48040_50246[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (14))){
var state_47851__$1 = state_47851;
var statearr_48041_50250 = state_47851__$1;
(statearr_48041_50250[(2)] = false);

(statearr_48041_50250[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (26))){
var inst_47800 = (state_47851[(9)]);
var inst_47807 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_47800);
var state_47851__$1 = state_47851;
var statearr_48044_50251 = state_47851__$1;
(statearr_48044_50251[(2)] = inst_47807);

(statearr_48044_50251[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (16))){
var state_47851__$1 = state_47851;
var statearr_48045_50252 = state_47851__$1;
(statearr_48045_50252[(2)] = true);

(statearr_48045_50252[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (38))){
var inst_47841 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
var statearr_48047_50253 = state_47851__$1;
(statearr_48047_50253[(2)] = inst_47841);

(statearr_48047_50253[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (30))){
var inst_47800 = (state_47851[(9)]);
var inst_47791 = (state_47851[(10)]);
var inst_47792 = (state_47851[(13)]);
var inst_47828 = cljs.core.empty_QMARK_(inst_47791);
var inst_47829 = (inst_47792.cljs$core$IFn$_invoke$arity$1 ? inst_47792.cljs$core$IFn$_invoke$arity$1(inst_47800) : inst_47792.call(null,inst_47800));
var inst_47830 = cljs.core.not(inst_47829);
var inst_47831 = ((inst_47828) && (inst_47830));
var state_47851__$1 = state_47851;
var statearr_48049_50254 = state_47851__$1;
(statearr_48049_50254[(2)] = inst_47831);

(statearr_48049_50254[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (10))){
var inst_47730 = (state_47851[(8)]);
var inst_47762 = (state_47851[(2)]);
var inst_47763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47762,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_47764 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47762,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_47765 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47762,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_47766 = inst_47730;
var state_47851__$1 = (function (){var statearr_48051 = state_47851;
(statearr_48051[(7)] = inst_47766);

(statearr_48051[(16)] = inst_47765);

(statearr_48051[(17)] = inst_47763);

(statearr_48051[(18)] = inst_47764);

return statearr_48051;
})();
var statearr_48053_50257 = state_47851__$1;
(statearr_48053_50257[(2)] = null);

(statearr_48053_50257[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (18))){
var inst_47782 = (state_47851[(2)]);
var state_47851__$1 = state_47851;
var statearr_48055_50258 = state_47851__$1;
(statearr_48055_50258[(2)] = inst_47782);

(statearr_48055_50258[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (37))){
var state_47851__$1 = state_47851;
var statearr_48056_50260 = state_47851__$1;
(statearr_48056_50260[(2)] = null);

(statearr_48056_50260[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47853 === (8))){
var inst_47730 = (state_47851[(8)]);
var inst_47759 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_47730);
var state_47851__$1 = state_47851;
var statearr_48057_50262 = state_47851__$1;
(statearr_48057_50262[(2)] = inst_47759);

(statearr_48057_50262[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__45473__auto__ = null;
var cljs$core$async$mix_$_state_machine__45473__auto____0 = (function (){
var statearr_48058 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48058[(0)] = cljs$core$async$mix_$_state_machine__45473__auto__);

(statearr_48058[(1)] = (1));

return statearr_48058;
});
var cljs$core$async$mix_$_state_machine__45473__auto____1 = (function (state_47851){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_47851);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e48059){var ex__45476__auto__ = e48059;
var statearr_48060_50264 = state_47851;
(statearr_48060_50264[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_47851[(4)]))){
var statearr_48061_50265 = state_47851;
(statearr_48061_50265[(1)] = cljs.core.first((state_47851[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50266 = state_47851;
state_47851 = G__50266;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__45473__auto__ = function(state_47851){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__45473__auto____1.call(this,state_47851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__45473__auto____0;
cljs$core$async$mix_$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__45473__auto____1;
return cljs$core$async$mix_$_state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_48062 = f__45601__auto__();
(statearr_48062[(6)] = c__45600__auto___50179);

return statearr_48062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_50269 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_50269(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_50272 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_50272(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_50273 = (function() {
var G__50274 = null;
var G__50274__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__50274__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__50274 = function(p,v){
switch(arguments.length){
case 1:
return G__50274__1.call(this,p);
case 2:
return G__50274__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__50274.cljs$core$IFn$_invoke$arity$1 = G__50274__1;
G__50274.cljs$core$IFn$_invoke$arity$2 = G__50274__2;
return G__50274;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__48068 = arguments.length;
switch (G__48068) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_50273(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_50273(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__48078 = arguments.length;
switch (G__48078) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__48074_SHARP_){
if(cljs.core.truth_((p1__48074_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__48074_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__48074_SHARP_.call(null,topic)))){
return p1__48074_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__48074_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48085 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48085 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta48086){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta48086 = meta48086;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48087,meta48086__$1){
var self__ = this;
var _48087__$1 = this;
return (new cljs.core.async.t_cljs$core$async48085(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta48086__$1));
}));

(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48087){
var self__ = this;
var _48087__$1 = this;
return self__.meta48086;
}));

(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async48085.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async48085.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta48086","meta48086",1370381298,null)], null);
}));

(cljs.core.async.t_cljs$core$async48085.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48085.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48085");

(cljs.core.async.t_cljs$core$async48085.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48085");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48085.
 */
cljs.core.async.__GT_t_cljs$core$async48085 = (function cljs$core$async$__GT_t_cljs$core$async48085(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48086){
return (new cljs.core.async.t_cljs$core$async48085(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta48086));
});

}

return (new cljs.core.async.t_cljs$core$async48085(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45600__auto___50292 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_48191){
var state_val_48192 = (state_48191[(1)]);
if((state_val_48192 === (7))){
var inst_48186 = (state_48191[(2)]);
var state_48191__$1 = state_48191;
var statearr_48193_50293 = state_48191__$1;
(statearr_48193_50293[(2)] = inst_48186);

(statearr_48193_50293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (20))){
var state_48191__$1 = state_48191;
var statearr_48196_50295 = state_48191__$1;
(statearr_48196_50295[(2)] = null);

(statearr_48196_50295[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (1))){
var state_48191__$1 = state_48191;
var statearr_48198_50296 = state_48191__$1;
(statearr_48198_50296[(2)] = null);

(statearr_48198_50296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (24))){
var inst_48168 = (state_48191[(7)]);
var inst_48177 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_48168);
var state_48191__$1 = state_48191;
var statearr_48199_50297 = state_48191__$1;
(statearr_48199_50297[(2)] = inst_48177);

(statearr_48199_50297[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (4))){
var inst_48111 = (state_48191[(8)]);
var inst_48111__$1 = (state_48191[(2)]);
var inst_48112 = (inst_48111__$1 == null);
var state_48191__$1 = (function (){var statearr_48200 = state_48191;
(statearr_48200[(8)] = inst_48111__$1);

return statearr_48200;
})();
if(cljs.core.truth_(inst_48112)){
var statearr_48201_50299 = state_48191__$1;
(statearr_48201_50299[(1)] = (5));

} else {
var statearr_48203_50300 = state_48191__$1;
(statearr_48203_50300[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (15))){
var inst_48162 = (state_48191[(2)]);
var state_48191__$1 = state_48191;
var statearr_48206_50301 = state_48191__$1;
(statearr_48206_50301[(2)] = inst_48162);

(statearr_48206_50301[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (21))){
var inst_48182 = (state_48191[(2)]);
var state_48191__$1 = (function (){var statearr_48207 = state_48191;
(statearr_48207[(9)] = inst_48182);

return statearr_48207;
})();
var statearr_48208_50302 = state_48191__$1;
(statearr_48208_50302[(2)] = null);

(statearr_48208_50302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (13))){
var inst_48141 = (state_48191[(10)]);
var inst_48145 = cljs.core.chunked_seq_QMARK_(inst_48141);
var state_48191__$1 = state_48191;
if(inst_48145){
var statearr_48209_50306 = state_48191__$1;
(statearr_48209_50306[(1)] = (16));

} else {
var statearr_48210_50307 = state_48191__$1;
(statearr_48210_50307[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (22))){
var inst_48174 = (state_48191[(2)]);
var state_48191__$1 = state_48191;
if(cljs.core.truth_(inst_48174)){
var statearr_48211_50308 = state_48191__$1;
(statearr_48211_50308[(1)] = (23));

} else {
var statearr_48212_50309 = state_48191__$1;
(statearr_48212_50309[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (6))){
var inst_48168 = (state_48191[(7)]);
var inst_48111 = (state_48191[(8)]);
var inst_48170 = (state_48191[(11)]);
var inst_48168__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_48111) : topic_fn.call(null,inst_48111));
var inst_48169 = cljs.core.deref(mults);
var inst_48170__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48169,inst_48168__$1);
var state_48191__$1 = (function (){var statearr_48213 = state_48191;
(statearr_48213[(7)] = inst_48168__$1);

(statearr_48213[(11)] = inst_48170__$1);

return statearr_48213;
})();
if(cljs.core.truth_(inst_48170__$1)){
var statearr_48214_50312 = state_48191__$1;
(statearr_48214_50312[(1)] = (19));

} else {
var statearr_48215_50313 = state_48191__$1;
(statearr_48215_50313[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (25))){
var inst_48179 = (state_48191[(2)]);
var state_48191__$1 = state_48191;
var statearr_48221_50314 = state_48191__$1;
(statearr_48221_50314[(2)] = inst_48179);

(statearr_48221_50314[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (17))){
var inst_48141 = (state_48191[(10)]);
var inst_48152 = cljs.core.first(inst_48141);
var inst_48153 = cljs.core.async.muxch_STAR_(inst_48152);
var inst_48154 = cljs.core.async.close_BANG_(inst_48153);
var inst_48155 = cljs.core.next(inst_48141);
var inst_48121 = inst_48155;
var inst_48122 = null;
var inst_48123 = (0);
var inst_48124 = (0);
var state_48191__$1 = (function (){var statearr_48223 = state_48191;
(statearr_48223[(12)] = inst_48121);

(statearr_48223[(13)] = inst_48124);

(statearr_48223[(14)] = inst_48123);

(statearr_48223[(15)] = inst_48122);

(statearr_48223[(16)] = inst_48154);

return statearr_48223;
})();
var statearr_48224_50315 = state_48191__$1;
(statearr_48224_50315[(2)] = null);

(statearr_48224_50315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (3))){
var inst_48188 = (state_48191[(2)]);
var state_48191__$1 = state_48191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48191__$1,inst_48188);
} else {
if((state_val_48192 === (12))){
var inst_48164 = (state_48191[(2)]);
var state_48191__$1 = state_48191;
var statearr_48225_50317 = state_48191__$1;
(statearr_48225_50317[(2)] = inst_48164);

(statearr_48225_50317[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (2))){
var state_48191__$1 = state_48191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48191__$1,(4),ch);
} else {
if((state_val_48192 === (23))){
var state_48191__$1 = state_48191;
var statearr_48226_50319 = state_48191__$1;
(statearr_48226_50319[(2)] = null);

(statearr_48226_50319[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (19))){
var inst_48111 = (state_48191[(8)]);
var inst_48170 = (state_48191[(11)]);
var inst_48172 = cljs.core.async.muxch_STAR_(inst_48170);
var state_48191__$1 = state_48191;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48191__$1,(22),inst_48172,inst_48111);
} else {
if((state_val_48192 === (11))){
var inst_48121 = (state_48191[(12)]);
var inst_48141 = (state_48191[(10)]);
var inst_48141__$1 = cljs.core.seq(inst_48121);
var state_48191__$1 = (function (){var statearr_48231 = state_48191;
(statearr_48231[(10)] = inst_48141__$1);

return statearr_48231;
})();
if(inst_48141__$1){
var statearr_48236_50323 = state_48191__$1;
(statearr_48236_50323[(1)] = (13));

} else {
var statearr_48237_50327 = state_48191__$1;
(statearr_48237_50327[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (9))){
var inst_48166 = (state_48191[(2)]);
var state_48191__$1 = state_48191;
var statearr_48238_50329 = state_48191__$1;
(statearr_48238_50329[(2)] = inst_48166);

(statearr_48238_50329[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (5))){
var inst_48118 = cljs.core.deref(mults);
var inst_48119 = cljs.core.vals(inst_48118);
var inst_48120 = cljs.core.seq(inst_48119);
var inst_48121 = inst_48120;
var inst_48122 = null;
var inst_48123 = (0);
var inst_48124 = (0);
var state_48191__$1 = (function (){var statearr_48239 = state_48191;
(statearr_48239[(12)] = inst_48121);

(statearr_48239[(13)] = inst_48124);

(statearr_48239[(14)] = inst_48123);

(statearr_48239[(15)] = inst_48122);

return statearr_48239;
})();
var statearr_48240_50332 = state_48191__$1;
(statearr_48240_50332[(2)] = null);

(statearr_48240_50332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (14))){
var state_48191__$1 = state_48191;
var statearr_48244_50333 = state_48191__$1;
(statearr_48244_50333[(2)] = null);

(statearr_48244_50333[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (16))){
var inst_48141 = (state_48191[(10)]);
var inst_48147 = cljs.core.chunk_first(inst_48141);
var inst_48148 = cljs.core.chunk_rest(inst_48141);
var inst_48149 = cljs.core.count(inst_48147);
var inst_48121 = inst_48148;
var inst_48122 = inst_48147;
var inst_48123 = inst_48149;
var inst_48124 = (0);
var state_48191__$1 = (function (){var statearr_48247 = state_48191;
(statearr_48247[(12)] = inst_48121);

(statearr_48247[(13)] = inst_48124);

(statearr_48247[(14)] = inst_48123);

(statearr_48247[(15)] = inst_48122);

return statearr_48247;
})();
var statearr_48249_50334 = state_48191__$1;
(statearr_48249_50334[(2)] = null);

(statearr_48249_50334[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (10))){
var inst_48121 = (state_48191[(12)]);
var inst_48124 = (state_48191[(13)]);
var inst_48123 = (state_48191[(14)]);
var inst_48122 = (state_48191[(15)]);
var inst_48129 = cljs.core._nth(inst_48122,inst_48124);
var inst_48131 = cljs.core.async.muxch_STAR_(inst_48129);
var inst_48132 = cljs.core.async.close_BANG_(inst_48131);
var inst_48134 = (inst_48124 + (1));
var tmp48241 = inst_48121;
var tmp48242 = inst_48123;
var tmp48243 = inst_48122;
var inst_48121__$1 = tmp48241;
var inst_48122__$1 = tmp48243;
var inst_48123__$1 = tmp48242;
var inst_48124__$1 = inst_48134;
var state_48191__$1 = (function (){var statearr_48250 = state_48191;
(statearr_48250[(12)] = inst_48121__$1);

(statearr_48250[(17)] = inst_48132);

(statearr_48250[(13)] = inst_48124__$1);

(statearr_48250[(14)] = inst_48123__$1);

(statearr_48250[(15)] = inst_48122__$1);

return statearr_48250;
})();
var statearr_48251_50338 = state_48191__$1;
(statearr_48251_50338[(2)] = null);

(statearr_48251_50338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (18))){
var inst_48159 = (state_48191[(2)]);
var state_48191__$1 = state_48191;
var statearr_48253_50339 = state_48191__$1;
(statearr_48253_50339[(2)] = inst_48159);

(statearr_48253_50339[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48192 === (8))){
var inst_48124 = (state_48191[(13)]);
var inst_48123 = (state_48191[(14)]);
var inst_48126 = (inst_48124 < inst_48123);
var inst_48127 = inst_48126;
var state_48191__$1 = state_48191;
if(cljs.core.truth_(inst_48127)){
var statearr_48256_50340 = state_48191__$1;
(statearr_48256_50340[(1)] = (10));

} else {
var statearr_48257_50341 = state_48191__$1;
(statearr_48257_50341[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_48258 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48258[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_48258[(1)] = (1));

return statearr_48258;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_48191){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_48191);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e48259){var ex__45476__auto__ = e48259;
var statearr_48260_50343 = state_48191;
(statearr_48260_50343[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_48191[(4)]))){
var statearr_48261_50344 = state_48191;
(statearr_48261_50344[(1)] = cljs.core.first((state_48191[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50345 = state_48191;
state_48191 = G__50345;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_48191){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_48191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_48267 = f__45601__auto__();
(statearr_48267[(6)] = c__45600__auto___50292);

return statearr_48267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__48270 = arguments.length;
switch (G__48270) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__48280 = arguments.length;
switch (G__48280) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__48286 = arguments.length;
switch (G__48286) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__45600__auto___50363 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_48332){
var state_val_48333 = (state_48332[(1)]);
if((state_val_48333 === (7))){
var state_48332__$1 = state_48332;
var statearr_48336_50365 = state_48332__$1;
(statearr_48336_50365[(2)] = null);

(statearr_48336_50365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (1))){
var state_48332__$1 = state_48332;
var statearr_48338_50366 = state_48332__$1;
(statearr_48338_50366[(2)] = null);

(statearr_48338_50366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (4))){
var inst_48291 = (state_48332[(7)]);
var inst_48292 = (state_48332[(8)]);
var inst_48294 = (inst_48292 < inst_48291);
var state_48332__$1 = state_48332;
if(cljs.core.truth_(inst_48294)){
var statearr_48339_50367 = state_48332__$1;
(statearr_48339_50367[(1)] = (6));

} else {
var statearr_48340_50368 = state_48332__$1;
(statearr_48340_50368[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (15))){
var inst_48318 = (state_48332[(9)]);
var inst_48323 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_48318);
var state_48332__$1 = state_48332;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48332__$1,(17),out,inst_48323);
} else {
if((state_val_48333 === (13))){
var inst_48318 = (state_48332[(9)]);
var inst_48318__$1 = (state_48332[(2)]);
var inst_48319 = cljs.core.some(cljs.core.nil_QMARK_,inst_48318__$1);
var state_48332__$1 = (function (){var statearr_48353 = state_48332;
(statearr_48353[(9)] = inst_48318__$1);

return statearr_48353;
})();
if(cljs.core.truth_(inst_48319)){
var statearr_48354_50373 = state_48332__$1;
(statearr_48354_50373[(1)] = (14));

} else {
var statearr_48360_50374 = state_48332__$1;
(statearr_48360_50374[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (6))){
var state_48332__$1 = state_48332;
var statearr_48365_50376 = state_48332__$1;
(statearr_48365_50376[(2)] = null);

(statearr_48365_50376[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (17))){
var inst_48325 = (state_48332[(2)]);
var state_48332__$1 = (function (){var statearr_48373 = state_48332;
(statearr_48373[(10)] = inst_48325);

return statearr_48373;
})();
var statearr_48377_50382 = state_48332__$1;
(statearr_48377_50382[(2)] = null);

(statearr_48377_50382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (3))){
var inst_48330 = (state_48332[(2)]);
var state_48332__$1 = state_48332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48332__$1,inst_48330);
} else {
if((state_val_48333 === (12))){
var _ = (function (){var statearr_48378 = state_48332;
(statearr_48378[(4)] = cljs.core.rest((state_48332[(4)])));

return statearr_48378;
})();
var state_48332__$1 = state_48332;
var ex48371 = (state_48332__$1[(2)]);
var statearr_48380_50383 = state_48332__$1;
(statearr_48380_50383[(5)] = ex48371);


if((ex48371 instanceof Object)){
var statearr_48381_50384 = state_48332__$1;
(statearr_48381_50384[(1)] = (11));

(statearr_48381_50384[(5)] = null);

} else {
throw ex48371;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (2))){
var inst_48290 = cljs.core.reset_BANG_(dctr,cnt);
var inst_48291 = cnt;
var inst_48292 = (0);
var state_48332__$1 = (function (){var statearr_48382 = state_48332;
(statearr_48382[(11)] = inst_48290);

(statearr_48382[(7)] = inst_48291);

(statearr_48382[(8)] = inst_48292);

return statearr_48382;
})();
var statearr_48386_50386 = state_48332__$1;
(statearr_48386_50386[(2)] = null);

(statearr_48386_50386[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (11))){
var inst_48296 = (state_48332[(2)]);
var inst_48297 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_48332__$1 = (function (){var statearr_48387 = state_48332;
(statearr_48387[(12)] = inst_48296);

return statearr_48387;
})();
var statearr_48388_50393 = state_48332__$1;
(statearr_48388_50393[(2)] = inst_48297);

(statearr_48388_50393[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (9))){
var inst_48292 = (state_48332[(8)]);
var _ = (function (){var statearr_48389 = state_48332;
(statearr_48389[(4)] = cljs.core.cons((12),(state_48332[(4)])));

return statearr_48389;
})();
var inst_48303 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_48292) : chs__$1.call(null,inst_48292));
var inst_48304 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_48292) : done.call(null,inst_48292));
var inst_48305 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_48303,inst_48304);
var ___$1 = (function (){var statearr_48390 = state_48332;
(statearr_48390[(4)] = cljs.core.rest((state_48332[(4)])));

return statearr_48390;
})();
var state_48332__$1 = state_48332;
var statearr_48395_50397 = state_48332__$1;
(statearr_48395_50397[(2)] = inst_48305);

(statearr_48395_50397[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (5))){
var inst_48316 = (state_48332[(2)]);
var state_48332__$1 = (function (){var statearr_48400 = state_48332;
(statearr_48400[(13)] = inst_48316);

return statearr_48400;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48332__$1,(13),dchan);
} else {
if((state_val_48333 === (14))){
var inst_48321 = cljs.core.async.close_BANG_(out);
var state_48332__$1 = state_48332;
var statearr_48401_50398 = state_48332__$1;
(statearr_48401_50398[(2)] = inst_48321);

(statearr_48401_50398[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (16))){
var inst_48328 = (state_48332[(2)]);
var state_48332__$1 = state_48332;
var statearr_48402_50399 = state_48332__$1;
(statearr_48402_50399[(2)] = inst_48328);

(statearr_48402_50399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (10))){
var inst_48292 = (state_48332[(8)]);
var inst_48309 = (state_48332[(2)]);
var inst_48310 = (inst_48292 + (1));
var inst_48292__$1 = inst_48310;
var state_48332__$1 = (function (){var statearr_48403 = state_48332;
(statearr_48403[(14)] = inst_48309);

(statearr_48403[(8)] = inst_48292__$1);

return statearr_48403;
})();
var statearr_48404_50402 = state_48332__$1;
(statearr_48404_50402[(2)] = null);

(statearr_48404_50402[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48333 === (8))){
var inst_48314 = (state_48332[(2)]);
var state_48332__$1 = state_48332;
var statearr_48405_50403 = state_48332__$1;
(statearr_48405_50403[(2)] = inst_48314);

(statearr_48405_50403[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_48407 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48407[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_48407[(1)] = (1));

return statearr_48407;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_48332){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_48332);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e48408){var ex__45476__auto__ = e48408;
var statearr_48409_50407 = state_48332;
(statearr_48409_50407[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_48332[(4)]))){
var statearr_48410_50408 = state_48332;
(statearr_48410_50408[(1)] = cljs.core.first((state_48332[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50411 = state_48332;
state_48332 = G__50411;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_48332){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_48332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_48411 = f__45601__auto__();
(statearr_48411[(6)] = c__45600__auto___50363);

return statearr_48411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__48414 = arguments.length;
switch (G__48414) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45600__auto___50417 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_48451){
var state_val_48452 = (state_48451[(1)]);
if((state_val_48452 === (7))){
var inst_48427 = (state_48451[(7)]);
var inst_48426 = (state_48451[(8)]);
var inst_48426__$1 = (state_48451[(2)]);
var inst_48427__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48426__$1,(0),null);
var inst_48428 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_48426__$1,(1),null);
var inst_48429 = (inst_48427__$1 == null);
var state_48451__$1 = (function (){var statearr_48466 = state_48451;
(statearr_48466[(7)] = inst_48427__$1);

(statearr_48466[(9)] = inst_48428);

(statearr_48466[(8)] = inst_48426__$1);

return statearr_48466;
})();
if(cljs.core.truth_(inst_48429)){
var statearr_48473_50418 = state_48451__$1;
(statearr_48473_50418[(1)] = (8));

} else {
var statearr_48474_50419 = state_48451__$1;
(statearr_48474_50419[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48452 === (1))){
var inst_48415 = cljs.core.vec(chs);
var inst_48416 = inst_48415;
var state_48451__$1 = (function (){var statearr_48475 = state_48451;
(statearr_48475[(10)] = inst_48416);

return statearr_48475;
})();
var statearr_48480_50421 = state_48451__$1;
(statearr_48480_50421[(2)] = null);

(statearr_48480_50421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48452 === (4))){
var inst_48416 = (state_48451[(10)]);
var state_48451__$1 = state_48451;
return cljs.core.async.ioc_alts_BANG_(state_48451__$1,(7),inst_48416);
} else {
if((state_val_48452 === (6))){
var inst_48445 = (state_48451[(2)]);
var state_48451__$1 = state_48451;
var statearr_48488_50422 = state_48451__$1;
(statearr_48488_50422[(2)] = inst_48445);

(statearr_48488_50422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48452 === (3))){
var inst_48447 = (state_48451[(2)]);
var state_48451__$1 = state_48451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48451__$1,inst_48447);
} else {
if((state_val_48452 === (2))){
var inst_48416 = (state_48451[(10)]);
var inst_48418 = cljs.core.count(inst_48416);
var inst_48419 = (inst_48418 > (0));
var state_48451__$1 = state_48451;
if(cljs.core.truth_(inst_48419)){
var statearr_48493_50424 = state_48451__$1;
(statearr_48493_50424[(1)] = (4));

} else {
var statearr_48494_50426 = state_48451__$1;
(statearr_48494_50426[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48452 === (11))){
var inst_48416 = (state_48451[(10)]);
var inst_48437 = (state_48451[(2)]);
var tmp48489 = inst_48416;
var inst_48416__$1 = tmp48489;
var state_48451__$1 = (function (){var statearr_48495 = state_48451;
(statearr_48495[(11)] = inst_48437);

(statearr_48495[(10)] = inst_48416__$1);

return statearr_48495;
})();
var statearr_48496_50430 = state_48451__$1;
(statearr_48496_50430[(2)] = null);

(statearr_48496_50430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48452 === (9))){
var inst_48427 = (state_48451[(7)]);
var state_48451__$1 = state_48451;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48451__$1,(11),out,inst_48427);
} else {
if((state_val_48452 === (5))){
var inst_48443 = cljs.core.async.close_BANG_(out);
var state_48451__$1 = state_48451;
var statearr_48498_50431 = state_48451__$1;
(statearr_48498_50431[(2)] = inst_48443);

(statearr_48498_50431[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48452 === (10))){
var inst_48440 = (state_48451[(2)]);
var state_48451__$1 = state_48451;
var statearr_48501_50433 = state_48451__$1;
(statearr_48501_50433[(2)] = inst_48440);

(statearr_48501_50433[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48452 === (8))){
var inst_48427 = (state_48451[(7)]);
var inst_48428 = (state_48451[(9)]);
var inst_48426 = (state_48451[(8)]);
var inst_48416 = (state_48451[(10)]);
var inst_48432 = (function (){var cs = inst_48416;
var vec__48422 = inst_48426;
var v = inst_48427;
var c = inst_48428;
return (function (p1__48412_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__48412_SHARP_);
});
})();
var inst_48433 = cljs.core.filterv(inst_48432,inst_48416);
var inst_48416__$1 = inst_48433;
var state_48451__$1 = (function (){var statearr_48507 = state_48451;
(statearr_48507[(10)] = inst_48416__$1);

return statearr_48507;
})();
var statearr_48509_50435 = state_48451__$1;
(statearr_48509_50435[(2)] = null);

(statearr_48509_50435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_48512 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48512[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_48512[(1)] = (1));

return statearr_48512;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_48451){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_48451);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e48513){var ex__45476__auto__ = e48513;
var statearr_48514_50437 = state_48451;
(statearr_48514_50437[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_48451[(4)]))){
var statearr_48515_50438 = state_48451;
(statearr_48515_50438[(1)] = cljs.core.first((state_48451[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50439 = state_48451;
state_48451 = G__50439;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_48451){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_48451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_48520 = f__45601__auto__();
(statearr_48520[(6)] = c__45600__auto___50417);

return statearr_48520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__48524 = arguments.length;
switch (G__48524) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45600__auto___50443 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_48559){
var state_val_48560 = (state_48559[(1)]);
if((state_val_48560 === (7))){
var inst_48538 = (state_48559[(7)]);
var inst_48538__$1 = (state_48559[(2)]);
var inst_48541 = (inst_48538__$1 == null);
var inst_48542 = cljs.core.not(inst_48541);
var state_48559__$1 = (function (){var statearr_48562 = state_48559;
(statearr_48562[(7)] = inst_48538__$1);

return statearr_48562;
})();
if(inst_48542){
var statearr_48563_50445 = state_48559__$1;
(statearr_48563_50445[(1)] = (8));

} else {
var statearr_48565_50446 = state_48559__$1;
(statearr_48565_50446[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48560 === (1))){
var inst_48532 = (0);
var state_48559__$1 = (function (){var statearr_48568 = state_48559;
(statearr_48568[(8)] = inst_48532);

return statearr_48568;
})();
var statearr_48569_50447 = state_48559__$1;
(statearr_48569_50447[(2)] = null);

(statearr_48569_50447[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48560 === (4))){
var state_48559__$1 = state_48559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48559__$1,(7),ch);
} else {
if((state_val_48560 === (6))){
var inst_48554 = (state_48559[(2)]);
var state_48559__$1 = state_48559;
var statearr_48573_50449 = state_48559__$1;
(statearr_48573_50449[(2)] = inst_48554);

(statearr_48573_50449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48560 === (3))){
var inst_48556 = (state_48559[(2)]);
var inst_48557 = cljs.core.async.close_BANG_(out);
var state_48559__$1 = (function (){var statearr_48578 = state_48559;
(statearr_48578[(9)] = inst_48556);

return statearr_48578;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48559__$1,inst_48557);
} else {
if((state_val_48560 === (2))){
var inst_48532 = (state_48559[(8)]);
var inst_48535 = (inst_48532 < n);
var state_48559__$1 = state_48559;
if(cljs.core.truth_(inst_48535)){
var statearr_48583_50451 = state_48559__$1;
(statearr_48583_50451[(1)] = (4));

} else {
var statearr_48584_50452 = state_48559__$1;
(statearr_48584_50452[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48560 === (11))){
var inst_48532 = (state_48559[(8)]);
var inst_48546 = (state_48559[(2)]);
var inst_48547 = (inst_48532 + (1));
var inst_48532__$1 = inst_48547;
var state_48559__$1 = (function (){var statearr_48587 = state_48559;
(statearr_48587[(8)] = inst_48532__$1);

(statearr_48587[(10)] = inst_48546);

return statearr_48587;
})();
var statearr_48588_50453 = state_48559__$1;
(statearr_48588_50453[(2)] = null);

(statearr_48588_50453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48560 === (9))){
var state_48559__$1 = state_48559;
var statearr_48589_50455 = state_48559__$1;
(statearr_48589_50455[(2)] = null);

(statearr_48589_50455[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48560 === (5))){
var state_48559__$1 = state_48559;
var statearr_48590_50456 = state_48559__$1;
(statearr_48590_50456[(2)] = null);

(statearr_48590_50456[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48560 === (10))){
var inst_48551 = (state_48559[(2)]);
var state_48559__$1 = state_48559;
var statearr_48592_50457 = state_48559__$1;
(statearr_48592_50457[(2)] = inst_48551);

(statearr_48592_50457[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48560 === (8))){
var inst_48538 = (state_48559[(7)]);
var state_48559__$1 = state_48559;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48559__$1,(11),out,inst_48538);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_48595 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48595[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_48595[(1)] = (1));

return statearr_48595;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_48559){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_48559);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e48598){var ex__45476__auto__ = e48598;
var statearr_48600_50460 = state_48559;
(statearr_48600_50460[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_48559[(4)]))){
var statearr_48601_50461 = state_48559;
(statearr_48601_50461[(1)] = cljs.core.first((state_48559[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50462 = state_48559;
state_48559 = G__50462;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_48559){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_48559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_48602 = f__45601__auto__();
(statearr_48602[(6)] = c__45600__auto___50443);

return statearr_48602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48608 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48608 = (function (f,ch,meta48609){
this.f = f;
this.ch = ch;
this.meta48609 = meta48609;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48610,meta48609__$1){
var self__ = this;
var _48610__$1 = this;
return (new cljs.core.async.t_cljs$core$async48608(self__.f,self__.ch,meta48609__$1));
}));

(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48610){
var self__ = this;
var _48610__$1 = this;
return self__.meta48609;
}));

(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48623 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48623 = (function (f,ch,meta48609,_,fn1,meta48624){
this.f = f;
this.ch = ch;
this.meta48609 = meta48609;
this._ = _;
this.fn1 = fn1;
this.meta48624 = meta48624;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48623.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48625,meta48624__$1){
var self__ = this;
var _48625__$1 = this;
return (new cljs.core.async.t_cljs$core$async48623(self__.f,self__.ch,self__.meta48609,self__._,self__.fn1,meta48624__$1));
}));

(cljs.core.async.t_cljs$core$async48623.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48625){
var self__ = this;
var _48625__$1 = this;
return self__.meta48624;
}));

(cljs.core.async.t_cljs$core$async48623.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48623.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async48623.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async48623.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__48607_SHARP_){
var G__48629 = (((p1__48607_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__48607_SHARP_) : self__.f.call(null,p1__48607_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__48629) : f1.call(null,G__48629));
});
}));

(cljs.core.async.t_cljs$core$async48623.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48609","meta48609",392934701,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async48608","cljs.core.async/t_cljs$core$async48608",768805425,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta48624","meta48624",-963392379,null)], null);
}));

(cljs.core.async.t_cljs$core$async48623.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48623.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48623");

(cljs.core.async.t_cljs$core$async48623.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48623");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48623.
 */
cljs.core.async.__GT_t_cljs$core$async48623 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48623(f__$1,ch__$1,meta48609__$1,___$2,fn1__$1,meta48624){
return (new cljs.core.async.t_cljs$core$async48623(f__$1,ch__$1,meta48609__$1,___$2,fn1__$1,meta48624));
});

}

return (new cljs.core.async.t_cljs$core$async48623(self__.f,self__.ch,self__.meta48609,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__48633 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__48633) : self__.f.call(null,G__48633));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48608.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async48608.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48609","meta48609",392934701,null)], null);
}));

(cljs.core.async.t_cljs$core$async48608.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48608.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48608");

(cljs.core.async.t_cljs$core$async48608.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48608");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48608.
 */
cljs.core.async.__GT_t_cljs$core$async48608 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async48608(f__$1,ch__$1,meta48609){
return (new cljs.core.async.t_cljs$core$async48608(f__$1,ch__$1,meta48609));
});

}

return (new cljs.core.async.t_cljs$core$async48608(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48641 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48641 = (function (f,ch,meta48642){
this.f = f;
this.ch = ch;
this.meta48642 = meta48642;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48643,meta48642__$1){
var self__ = this;
var _48643__$1 = this;
return (new cljs.core.async.t_cljs$core$async48641(self__.f,self__.ch,meta48642__$1));
}));

(cljs.core.async.t_cljs$core$async48641.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48643){
var self__ = this;
var _48643__$1 = this;
return self__.meta48642;
}));

(cljs.core.async.t_cljs$core$async48641.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48641.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48641.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48641.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48641.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48641.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async48641.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48642","meta48642",239572545,null)], null);
}));

(cljs.core.async.t_cljs$core$async48641.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48641.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48641");

(cljs.core.async.t_cljs$core$async48641.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48641");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48641.
 */
cljs.core.async.__GT_t_cljs$core$async48641 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async48641(f__$1,ch__$1,meta48642){
return (new cljs.core.async.t_cljs$core$async48641(f__$1,ch__$1,meta48642));
});

}

return (new cljs.core.async.t_cljs$core$async48641(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async48655 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async48655 = (function (p,ch,meta48656){
this.p = p;
this.ch = ch;
this.meta48656 = meta48656;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_48657,meta48656__$1){
var self__ = this;
var _48657__$1 = this;
return (new cljs.core.async.t_cljs$core$async48655(self__.p,self__.ch,meta48656__$1));
}));

(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_48657){
var self__ = this;
var _48657__$1 = this;
return self__.meta48656;
}));

(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async48655.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async48655.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta48656","meta48656",1377677788,null)], null);
}));

(cljs.core.async.t_cljs$core$async48655.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async48655.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async48655");

(cljs.core.async.t_cljs$core$async48655.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async48655");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async48655.
 */
cljs.core.async.__GT_t_cljs$core$async48655 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async48655(p__$1,ch__$1,meta48656){
return (new cljs.core.async.t_cljs$core$async48655(p__$1,ch__$1,meta48656));
});

}

return (new cljs.core.async.t_cljs$core$async48655(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__48674 = arguments.length;
switch (G__48674) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45600__auto___50477 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_48702){
var state_val_48703 = (state_48702[(1)]);
if((state_val_48703 === (7))){
var inst_48698 = (state_48702[(2)]);
var state_48702__$1 = state_48702;
var statearr_48706_50478 = state_48702__$1;
(statearr_48706_50478[(2)] = inst_48698);

(statearr_48706_50478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48703 === (1))){
var state_48702__$1 = state_48702;
var statearr_48710_50480 = state_48702__$1;
(statearr_48710_50480[(2)] = null);

(statearr_48710_50480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48703 === (4))){
var inst_48680 = (state_48702[(7)]);
var inst_48680__$1 = (state_48702[(2)]);
var inst_48681 = (inst_48680__$1 == null);
var state_48702__$1 = (function (){var statearr_48716 = state_48702;
(statearr_48716[(7)] = inst_48680__$1);

return statearr_48716;
})();
if(cljs.core.truth_(inst_48681)){
var statearr_48717_50481 = state_48702__$1;
(statearr_48717_50481[(1)] = (5));

} else {
var statearr_48718_50482 = state_48702__$1;
(statearr_48718_50482[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48703 === (6))){
var inst_48680 = (state_48702[(7)]);
var inst_48686 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_48680) : p.call(null,inst_48680));
var state_48702__$1 = state_48702;
if(cljs.core.truth_(inst_48686)){
var statearr_48720_50484 = state_48702__$1;
(statearr_48720_50484[(1)] = (8));

} else {
var statearr_48721_50485 = state_48702__$1;
(statearr_48721_50485[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48703 === (3))){
var inst_48700 = (state_48702[(2)]);
var state_48702__$1 = state_48702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48702__$1,inst_48700);
} else {
if((state_val_48703 === (2))){
var state_48702__$1 = state_48702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48702__$1,(4),ch);
} else {
if((state_val_48703 === (11))){
var inst_48692 = (state_48702[(2)]);
var state_48702__$1 = state_48702;
var statearr_48723_50487 = state_48702__$1;
(statearr_48723_50487[(2)] = inst_48692);

(statearr_48723_50487[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48703 === (9))){
var state_48702__$1 = state_48702;
var statearr_48727_50488 = state_48702__$1;
(statearr_48727_50488[(2)] = null);

(statearr_48727_50488[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48703 === (5))){
var inst_48684 = cljs.core.async.close_BANG_(out);
var state_48702__$1 = state_48702;
var statearr_48728_50490 = state_48702__$1;
(statearr_48728_50490[(2)] = inst_48684);

(statearr_48728_50490[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48703 === (10))){
var inst_48695 = (state_48702[(2)]);
var state_48702__$1 = (function (){var statearr_48732 = state_48702;
(statearr_48732[(8)] = inst_48695);

return statearr_48732;
})();
var statearr_48733_50491 = state_48702__$1;
(statearr_48733_50491[(2)] = null);

(statearr_48733_50491[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48703 === (8))){
var inst_48680 = (state_48702[(7)]);
var state_48702__$1 = state_48702;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48702__$1,(11),out,inst_48680);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_48734 = [null,null,null,null,null,null,null,null,null];
(statearr_48734[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_48734[(1)] = (1));

return statearr_48734;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_48702){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_48702);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e48735){var ex__45476__auto__ = e48735;
var statearr_48737_50493 = state_48702;
(statearr_48737_50493[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_48702[(4)]))){
var statearr_48741_50495 = state_48702;
(statearr_48741_50495[(1)] = cljs.core.first((state_48702[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50496 = state_48702;
state_48702 = G__50496;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_48702){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_48702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_48742 = f__45601__auto__();
(statearr_48742[(6)] = c__45600__auto___50477);

return statearr_48742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__48745 = arguments.length;
switch (G__48745) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__45600__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_48841){
var state_val_48842 = (state_48841[(1)]);
if((state_val_48842 === (7))){
var inst_48835 = (state_48841[(2)]);
var state_48841__$1 = state_48841;
var statearr_48849_50500 = state_48841__$1;
(statearr_48849_50500[(2)] = inst_48835);

(statearr_48849_50500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (20))){
var inst_48792 = (state_48841[(7)]);
var inst_48809 = (state_48841[(2)]);
var inst_48810 = cljs.core.next(inst_48792);
var inst_48775 = inst_48810;
var inst_48776 = null;
var inst_48777 = (0);
var inst_48778 = (0);
var state_48841__$1 = (function (){var statearr_48854 = state_48841;
(statearr_48854[(8)] = inst_48775);

(statearr_48854[(9)] = inst_48778);

(statearr_48854[(10)] = inst_48776);

(statearr_48854[(11)] = inst_48809);

(statearr_48854[(12)] = inst_48777);

return statearr_48854;
})();
var statearr_48858_50502 = state_48841__$1;
(statearr_48858_50502[(2)] = null);

(statearr_48858_50502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (1))){
var state_48841__$1 = state_48841;
var statearr_48861_50503 = state_48841__$1;
(statearr_48861_50503[(2)] = null);

(statearr_48861_50503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (4))){
var inst_48763 = (state_48841[(13)]);
var inst_48763__$1 = (state_48841[(2)]);
var inst_48764 = (inst_48763__$1 == null);
var state_48841__$1 = (function (){var statearr_48863 = state_48841;
(statearr_48863[(13)] = inst_48763__$1);

return statearr_48863;
})();
if(cljs.core.truth_(inst_48764)){
var statearr_48864_50505 = state_48841__$1;
(statearr_48864_50505[(1)] = (5));

} else {
var statearr_48867_50506 = state_48841__$1;
(statearr_48867_50506[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (15))){
var state_48841__$1 = state_48841;
var statearr_48873_50507 = state_48841__$1;
(statearr_48873_50507[(2)] = null);

(statearr_48873_50507[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (21))){
var state_48841__$1 = state_48841;
var statearr_48875_50508 = state_48841__$1;
(statearr_48875_50508[(2)] = null);

(statearr_48875_50508[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (13))){
var inst_48775 = (state_48841[(8)]);
var inst_48778 = (state_48841[(9)]);
var inst_48776 = (state_48841[(10)]);
var inst_48777 = (state_48841[(12)]);
var inst_48787 = (state_48841[(2)]);
var inst_48789 = (inst_48778 + (1));
var tmp48870 = inst_48775;
var tmp48871 = inst_48776;
var tmp48872 = inst_48777;
var inst_48775__$1 = tmp48870;
var inst_48776__$1 = tmp48871;
var inst_48777__$1 = tmp48872;
var inst_48778__$1 = inst_48789;
var state_48841__$1 = (function (){var statearr_48877 = state_48841;
(statearr_48877[(8)] = inst_48775__$1);

(statearr_48877[(9)] = inst_48778__$1);

(statearr_48877[(10)] = inst_48776__$1);

(statearr_48877[(14)] = inst_48787);

(statearr_48877[(12)] = inst_48777__$1);

return statearr_48877;
})();
var statearr_48878_50511 = state_48841__$1;
(statearr_48878_50511[(2)] = null);

(statearr_48878_50511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (22))){
var state_48841__$1 = state_48841;
var statearr_48880_50512 = state_48841__$1;
(statearr_48880_50512[(2)] = null);

(statearr_48880_50512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (6))){
var inst_48763 = (state_48841[(13)]);
var inst_48772 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48763) : f.call(null,inst_48763));
var inst_48773 = cljs.core.seq(inst_48772);
var inst_48775 = inst_48773;
var inst_48776 = null;
var inst_48777 = (0);
var inst_48778 = (0);
var state_48841__$1 = (function (){var statearr_48885 = state_48841;
(statearr_48885[(8)] = inst_48775);

(statearr_48885[(9)] = inst_48778);

(statearr_48885[(10)] = inst_48776);

(statearr_48885[(12)] = inst_48777);

return statearr_48885;
})();
var statearr_48887_50514 = state_48841__$1;
(statearr_48887_50514[(2)] = null);

(statearr_48887_50514[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (17))){
var inst_48792 = (state_48841[(7)]);
var inst_48797 = cljs.core.chunk_first(inst_48792);
var inst_48801 = cljs.core.chunk_rest(inst_48792);
var inst_48804 = cljs.core.count(inst_48797);
var inst_48775 = inst_48801;
var inst_48776 = inst_48797;
var inst_48777 = inst_48804;
var inst_48778 = (0);
var state_48841__$1 = (function (){var statearr_48901 = state_48841;
(statearr_48901[(8)] = inst_48775);

(statearr_48901[(9)] = inst_48778);

(statearr_48901[(10)] = inst_48776);

(statearr_48901[(12)] = inst_48777);

return statearr_48901;
})();
var statearr_48903_50516 = state_48841__$1;
(statearr_48903_50516[(2)] = null);

(statearr_48903_50516[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (3))){
var inst_48837 = (state_48841[(2)]);
var state_48841__$1 = state_48841;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48841__$1,inst_48837);
} else {
if((state_val_48842 === (12))){
var inst_48819 = (state_48841[(2)]);
var state_48841__$1 = state_48841;
var statearr_48905_50517 = state_48841__$1;
(statearr_48905_50517[(2)] = inst_48819);

(statearr_48905_50517[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (2))){
var state_48841__$1 = state_48841;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48841__$1,(4),in$);
} else {
if((state_val_48842 === (23))){
var inst_48833 = (state_48841[(2)]);
var state_48841__$1 = state_48841;
var statearr_48912_50519 = state_48841__$1;
(statearr_48912_50519[(2)] = inst_48833);

(statearr_48912_50519[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (19))){
var inst_48813 = (state_48841[(2)]);
var state_48841__$1 = state_48841;
var statearr_48914_50520 = state_48841__$1;
(statearr_48914_50520[(2)] = inst_48813);

(statearr_48914_50520[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (11))){
var inst_48775 = (state_48841[(8)]);
var inst_48792 = (state_48841[(7)]);
var inst_48792__$1 = cljs.core.seq(inst_48775);
var state_48841__$1 = (function (){var statearr_48921 = state_48841;
(statearr_48921[(7)] = inst_48792__$1);

return statearr_48921;
})();
if(inst_48792__$1){
var statearr_48922_50522 = state_48841__$1;
(statearr_48922_50522[(1)] = (14));

} else {
var statearr_48923_50523 = state_48841__$1;
(statearr_48923_50523[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (9))){
var inst_48821 = (state_48841[(2)]);
var inst_48826 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_48841__$1 = (function (){var statearr_48928 = state_48841;
(statearr_48928[(15)] = inst_48821);

return statearr_48928;
})();
if(cljs.core.truth_(inst_48826)){
var statearr_48933_50525 = state_48841__$1;
(statearr_48933_50525[(1)] = (21));

} else {
var statearr_48935_50526 = state_48841__$1;
(statearr_48935_50526[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (5))){
var inst_48766 = cljs.core.async.close_BANG_(out);
var state_48841__$1 = state_48841;
var statearr_48941_50527 = state_48841__$1;
(statearr_48941_50527[(2)] = inst_48766);

(statearr_48941_50527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (14))){
var inst_48792 = (state_48841[(7)]);
var inst_48794 = cljs.core.chunked_seq_QMARK_(inst_48792);
var state_48841__$1 = state_48841;
if(inst_48794){
var statearr_48944_50529 = state_48841__$1;
(statearr_48944_50529[(1)] = (17));

} else {
var statearr_48947_50530 = state_48841__$1;
(statearr_48947_50530[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (16))){
var inst_48817 = (state_48841[(2)]);
var state_48841__$1 = state_48841;
var statearr_48948_50531 = state_48841__$1;
(statearr_48948_50531[(2)] = inst_48817);

(statearr_48948_50531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48842 === (10))){
var inst_48778 = (state_48841[(9)]);
var inst_48776 = (state_48841[(10)]);
var inst_48785 = cljs.core._nth(inst_48776,inst_48778);
var state_48841__$1 = state_48841;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48841__$1,(13),out,inst_48785);
} else {
if((state_val_48842 === (18))){
var inst_48792 = (state_48841[(7)]);
var inst_48807 = cljs.core.first(inst_48792);
var state_48841__$1 = state_48841;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48841__$1,(20),out,inst_48807);
} else {
if((state_val_48842 === (8))){
var inst_48778 = (state_48841[(9)]);
var inst_48777 = (state_48841[(12)]);
var inst_48782 = (inst_48778 < inst_48777);
var inst_48783 = inst_48782;
var state_48841__$1 = state_48841;
if(cljs.core.truth_(inst_48783)){
var statearr_48955_50533 = state_48841__$1;
(statearr_48955_50533[(1)] = (10));

} else {
var statearr_48956_50534 = state_48841__$1;
(statearr_48956_50534[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__45473__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__45473__auto____0 = (function (){
var statearr_48963 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48963[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__45473__auto__);

(statearr_48963[(1)] = (1));

return statearr_48963;
});
var cljs$core$async$mapcat_STAR__$_state_machine__45473__auto____1 = (function (state_48841){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_48841);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e48969){var ex__45476__auto__ = e48969;
var statearr_48970_50536 = state_48841;
(statearr_48970_50536[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_48841[(4)]))){
var statearr_48972_50538 = state_48841;
(statearr_48972_50538[(1)] = cljs.core.first((state_48841[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50539 = state_48841;
state_48841 = G__50539;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__45473__auto__ = function(state_48841){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__45473__auto____1.call(this,state_48841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__45473__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__45473__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_48977 = f__45601__auto__();
(statearr_48977[(6)] = c__45600__auto__);

return statearr_48977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));

return c__45600__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__48985 = arguments.length;
switch (G__48985) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__49002 = arguments.length;
switch (G__49002) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__49014 = arguments.length;
switch (G__49014) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45600__auto___50547 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_49041){
var state_val_49042 = (state_49041[(1)]);
if((state_val_49042 === (7))){
var inst_49036 = (state_49041[(2)]);
var state_49041__$1 = state_49041;
var statearr_49043_50548 = state_49041__$1;
(statearr_49043_50548[(2)] = inst_49036);

(statearr_49043_50548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49042 === (1))){
var inst_49018 = null;
var state_49041__$1 = (function (){var statearr_49044 = state_49041;
(statearr_49044[(7)] = inst_49018);

return statearr_49044;
})();
var statearr_49045_50550 = state_49041__$1;
(statearr_49045_50550[(2)] = null);

(statearr_49045_50550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49042 === (4))){
var inst_49021 = (state_49041[(8)]);
var inst_49021__$1 = (state_49041[(2)]);
var inst_49022 = (inst_49021__$1 == null);
var inst_49023 = cljs.core.not(inst_49022);
var state_49041__$1 = (function (){var statearr_49046 = state_49041;
(statearr_49046[(8)] = inst_49021__$1);

return statearr_49046;
})();
if(inst_49023){
var statearr_49047_50551 = state_49041__$1;
(statearr_49047_50551[(1)] = (5));

} else {
var statearr_49048_50552 = state_49041__$1;
(statearr_49048_50552[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49042 === (6))){
var state_49041__$1 = state_49041;
var statearr_49049_50554 = state_49041__$1;
(statearr_49049_50554[(2)] = null);

(statearr_49049_50554[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49042 === (3))){
var inst_49038 = (state_49041[(2)]);
var inst_49039 = cljs.core.async.close_BANG_(out);
var state_49041__$1 = (function (){var statearr_49050 = state_49041;
(statearr_49050[(9)] = inst_49038);

return statearr_49050;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49041__$1,inst_49039);
} else {
if((state_val_49042 === (2))){
var state_49041__$1 = state_49041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49041__$1,(4),ch);
} else {
if((state_val_49042 === (11))){
var inst_49021 = (state_49041[(8)]);
var inst_49030 = (state_49041[(2)]);
var inst_49018 = inst_49021;
var state_49041__$1 = (function (){var statearr_49053 = state_49041;
(statearr_49053[(7)] = inst_49018);

(statearr_49053[(10)] = inst_49030);

return statearr_49053;
})();
var statearr_49054_50556 = state_49041__$1;
(statearr_49054_50556[(2)] = null);

(statearr_49054_50556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49042 === (9))){
var inst_49021 = (state_49041[(8)]);
var state_49041__$1 = state_49041;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49041__$1,(11),out,inst_49021);
} else {
if((state_val_49042 === (5))){
var inst_49018 = (state_49041[(7)]);
var inst_49021 = (state_49041[(8)]);
var inst_49025 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49021,inst_49018);
var state_49041__$1 = state_49041;
if(inst_49025){
var statearr_49061_50558 = state_49041__$1;
(statearr_49061_50558[(1)] = (8));

} else {
var statearr_49062_50559 = state_49041__$1;
(statearr_49062_50559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49042 === (10))){
var inst_49033 = (state_49041[(2)]);
var state_49041__$1 = state_49041;
var statearr_49066_50560 = state_49041__$1;
(statearr_49066_50560[(2)] = inst_49033);

(statearr_49066_50560[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49042 === (8))){
var inst_49018 = (state_49041[(7)]);
var tmp49057 = inst_49018;
var inst_49018__$1 = tmp49057;
var state_49041__$1 = (function (){var statearr_49067 = state_49041;
(statearr_49067[(7)] = inst_49018__$1);

return statearr_49067;
})();
var statearr_49068_50562 = state_49041__$1;
(statearr_49068_50562[(2)] = null);

(statearr_49068_50562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_49070 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_49070[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_49070[(1)] = (1));

return statearr_49070;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_49041){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_49041);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e49074){var ex__45476__auto__ = e49074;
var statearr_49075_50564 = state_49041;
(statearr_49075_50564[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_49041[(4)]))){
var statearr_49076_50565 = state_49041;
(statearr_49076_50565[(1)] = cljs.core.first((state_49041[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50566 = state_49041;
state_49041 = G__50566;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_49041){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_49041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_49089 = f__45601__auto__();
(statearr_49089[(6)] = c__45600__auto___50547);

return statearr_49089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__49096 = arguments.length;
switch (G__49096) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45600__auto___50570 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_49178){
var state_val_49180 = (state_49178[(1)]);
if((state_val_49180 === (7))){
var inst_49171 = (state_49178[(2)]);
var state_49178__$1 = state_49178;
var statearr_49189_50571 = state_49178__$1;
(statearr_49189_50571[(2)] = inst_49171);

(statearr_49189_50571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (1))){
var inst_49128 = (new Array(n));
var inst_49130 = inst_49128;
var inst_49131 = (0);
var state_49178__$1 = (function (){var statearr_49196 = state_49178;
(statearr_49196[(7)] = inst_49131);

(statearr_49196[(8)] = inst_49130);

return statearr_49196;
})();
var statearr_49198_50573 = state_49178__$1;
(statearr_49198_50573[(2)] = null);

(statearr_49198_50573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (4))){
var inst_49137 = (state_49178[(9)]);
var inst_49137__$1 = (state_49178[(2)]);
var inst_49138 = (inst_49137__$1 == null);
var inst_49139 = cljs.core.not(inst_49138);
var state_49178__$1 = (function (){var statearr_49204 = state_49178;
(statearr_49204[(9)] = inst_49137__$1);

return statearr_49204;
})();
if(inst_49139){
var statearr_49205_50575 = state_49178__$1;
(statearr_49205_50575[(1)] = (5));

} else {
var statearr_49208_50576 = state_49178__$1;
(statearr_49208_50576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (15))){
var inst_49165 = (state_49178[(2)]);
var state_49178__$1 = state_49178;
var statearr_49213_50577 = state_49178__$1;
(statearr_49213_50577[(2)] = inst_49165);

(statearr_49213_50577[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (13))){
var state_49178__$1 = state_49178;
var statearr_49216_50578 = state_49178__$1;
(statearr_49216_50578[(2)] = null);

(statearr_49216_50578[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (6))){
var inst_49131 = (state_49178[(7)]);
var inst_49161 = (inst_49131 > (0));
var state_49178__$1 = state_49178;
if(cljs.core.truth_(inst_49161)){
var statearr_49222_50580 = state_49178__$1;
(statearr_49222_50580[(1)] = (12));

} else {
var statearr_49223_50581 = state_49178__$1;
(statearr_49223_50581[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (3))){
var inst_49174 = (state_49178[(2)]);
var state_49178__$1 = state_49178;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49178__$1,inst_49174);
} else {
if((state_val_49180 === (12))){
var inst_49130 = (state_49178[(8)]);
var inst_49163 = cljs.core.vec(inst_49130);
var state_49178__$1 = state_49178;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49178__$1,(15),out,inst_49163);
} else {
if((state_val_49180 === (2))){
var state_49178__$1 = state_49178;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49178__$1,(4),ch);
} else {
if((state_val_49180 === (11))){
var inst_49153 = (state_49178[(2)]);
var inst_49154 = (new Array(n));
var inst_49130 = inst_49154;
var inst_49131 = (0);
var state_49178__$1 = (function (){var statearr_49237 = state_49178;
(statearr_49237[(10)] = inst_49153);

(statearr_49237[(7)] = inst_49131);

(statearr_49237[(8)] = inst_49130);

return statearr_49237;
})();
var statearr_49238_50584 = state_49178__$1;
(statearr_49238_50584[(2)] = null);

(statearr_49238_50584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (9))){
var inst_49130 = (state_49178[(8)]);
var inst_49151 = cljs.core.vec(inst_49130);
var state_49178__$1 = state_49178;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49178__$1,(11),out,inst_49151);
} else {
if((state_val_49180 === (5))){
var inst_49143 = (state_49178[(11)]);
var inst_49137 = (state_49178[(9)]);
var inst_49131 = (state_49178[(7)]);
var inst_49130 = (state_49178[(8)]);
var inst_49142 = (inst_49130[inst_49131] = inst_49137);
var inst_49143__$1 = (inst_49131 + (1));
var inst_49145 = (inst_49143__$1 < n);
var state_49178__$1 = (function (){var statearr_49240 = state_49178;
(statearr_49240[(11)] = inst_49143__$1);

(statearr_49240[(12)] = inst_49142);

return statearr_49240;
})();
if(cljs.core.truth_(inst_49145)){
var statearr_49241_50586 = state_49178__$1;
(statearr_49241_50586[(1)] = (8));

} else {
var statearr_49242_50587 = state_49178__$1;
(statearr_49242_50587[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (14))){
var inst_49168 = (state_49178[(2)]);
var inst_49169 = cljs.core.async.close_BANG_(out);
var state_49178__$1 = (function (){var statearr_49246 = state_49178;
(statearr_49246[(13)] = inst_49168);

return statearr_49246;
})();
var statearr_49247_50588 = state_49178__$1;
(statearr_49247_50588[(2)] = inst_49169);

(statearr_49247_50588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (10))){
var inst_49158 = (state_49178[(2)]);
var state_49178__$1 = state_49178;
var statearr_49248_50590 = state_49178__$1;
(statearr_49248_50590[(2)] = inst_49158);

(statearr_49248_50590[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49180 === (8))){
var inst_49143 = (state_49178[(11)]);
var inst_49130 = (state_49178[(8)]);
var tmp49243 = inst_49130;
var inst_49130__$1 = tmp49243;
var inst_49131 = inst_49143;
var state_49178__$1 = (function (){var statearr_49251 = state_49178;
(statearr_49251[(7)] = inst_49131);

(statearr_49251[(8)] = inst_49130__$1);

return statearr_49251;
})();
var statearr_49252_50591 = state_49178__$1;
(statearr_49252_50591[(2)] = null);

(statearr_49252_50591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_49274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49274[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_49274[(1)] = (1));

return statearr_49274;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_49178){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_49178);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e49277){var ex__45476__auto__ = e49277;
var statearr_49278_50594 = state_49178;
(statearr_49278_50594[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_49178[(4)]))){
var statearr_49279_50595 = state_49178;
(statearr_49279_50595[(1)] = cljs.core.first((state_49178[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50596 = state_49178;
state_49178 = G__50596;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_49178){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_49178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_49284 = f__45601__auto__();
(statearr_49284[(6)] = c__45600__auto___50570);

return statearr_49284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__49295 = arguments.length;
switch (G__49295) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45600__auto___50600 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45601__auto__ = (function (){var switch__45472__auto__ = (function (state_49355){
var state_val_49356 = (state_49355[(1)]);
if((state_val_49356 === (7))){
var inst_49351 = (state_49355[(2)]);
var state_49355__$1 = state_49355;
var statearr_49363_50601 = state_49355__$1;
(statearr_49363_50601[(2)] = inst_49351);

(statearr_49363_50601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (1))){
var inst_49314 = [];
var inst_49315 = inst_49314;
var inst_49316 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_49355__$1 = (function (){var statearr_49366 = state_49355;
(statearr_49366[(7)] = inst_49315);

(statearr_49366[(8)] = inst_49316);

return statearr_49366;
})();
var statearr_49368_50603 = state_49355__$1;
(statearr_49368_50603[(2)] = null);

(statearr_49368_50603[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (4))){
var inst_49319 = (state_49355[(9)]);
var inst_49319__$1 = (state_49355[(2)]);
var inst_49320 = (inst_49319__$1 == null);
var inst_49321 = cljs.core.not(inst_49320);
var state_49355__$1 = (function (){var statearr_49374 = state_49355;
(statearr_49374[(9)] = inst_49319__$1);

return statearr_49374;
})();
if(inst_49321){
var statearr_49379_50605 = state_49355__$1;
(statearr_49379_50605[(1)] = (5));

} else {
var statearr_49381_50606 = state_49355__$1;
(statearr_49381_50606[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (15))){
var inst_49345 = (state_49355[(2)]);
var state_49355__$1 = state_49355;
var statearr_49387_50607 = state_49355__$1;
(statearr_49387_50607[(2)] = inst_49345);

(statearr_49387_50607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (13))){
var state_49355__$1 = state_49355;
var statearr_49393_50609 = state_49355__$1;
(statearr_49393_50609[(2)] = null);

(statearr_49393_50609[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (6))){
var inst_49315 = (state_49355[(7)]);
var inst_49340 = inst_49315.length;
var inst_49341 = (inst_49340 > (0));
var state_49355__$1 = state_49355;
if(cljs.core.truth_(inst_49341)){
var statearr_49400_50610 = state_49355__$1;
(statearr_49400_50610[(1)] = (12));

} else {
var statearr_49403_50611 = state_49355__$1;
(statearr_49403_50611[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (3))){
var inst_49353 = (state_49355[(2)]);
var state_49355__$1 = state_49355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49355__$1,inst_49353);
} else {
if((state_val_49356 === (12))){
var inst_49315 = (state_49355[(7)]);
var inst_49343 = cljs.core.vec(inst_49315);
var state_49355__$1 = state_49355;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49355__$1,(15),out,inst_49343);
} else {
if((state_val_49356 === (2))){
var state_49355__$1 = state_49355;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49355__$1,(4),ch);
} else {
if((state_val_49356 === (11))){
var inst_49319 = (state_49355[(9)]);
var inst_49323 = (state_49355[(10)]);
var inst_49333 = (state_49355[(2)]);
var inst_49334 = [];
var inst_49335 = inst_49334.push(inst_49319);
var inst_49315 = inst_49334;
var inst_49316 = inst_49323;
var state_49355__$1 = (function (){var statearr_49421 = state_49355;
(statearr_49421[(11)] = inst_49333);

(statearr_49421[(12)] = inst_49335);

(statearr_49421[(7)] = inst_49315);

(statearr_49421[(8)] = inst_49316);

return statearr_49421;
})();
var statearr_49426_50614 = state_49355__$1;
(statearr_49426_50614[(2)] = null);

(statearr_49426_50614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (9))){
var inst_49315 = (state_49355[(7)]);
var inst_49331 = cljs.core.vec(inst_49315);
var state_49355__$1 = state_49355;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_49355__$1,(11),out,inst_49331);
} else {
if((state_val_49356 === (5))){
var inst_49319 = (state_49355[(9)]);
var inst_49323 = (state_49355[(10)]);
var inst_49316 = (state_49355[(8)]);
var inst_49323__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_49319) : f.call(null,inst_49319));
var inst_49324 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_49323__$1,inst_49316);
var inst_49325 = cljs.core.keyword_identical_QMARK_(inst_49316,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_49326 = ((inst_49324) || (inst_49325));
var state_49355__$1 = (function (){var statearr_49437 = state_49355;
(statearr_49437[(10)] = inst_49323__$1);

return statearr_49437;
})();
if(cljs.core.truth_(inst_49326)){
var statearr_49440_50616 = state_49355__$1;
(statearr_49440_50616[(1)] = (8));

} else {
var statearr_49442_50617 = state_49355__$1;
(statearr_49442_50617[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (14))){
var inst_49348 = (state_49355[(2)]);
var inst_49349 = cljs.core.async.close_BANG_(out);
var state_49355__$1 = (function (){var statearr_49449 = state_49355;
(statearr_49449[(13)] = inst_49348);

return statearr_49449;
})();
var statearr_49454_50619 = state_49355__$1;
(statearr_49454_50619[(2)] = inst_49349);

(statearr_49454_50619[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (10))){
var inst_49338 = (state_49355[(2)]);
var state_49355__$1 = state_49355;
var statearr_49457_50620 = state_49355__$1;
(statearr_49457_50620[(2)] = inst_49338);

(statearr_49457_50620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_49356 === (8))){
var inst_49319 = (state_49355[(9)]);
var inst_49323 = (state_49355[(10)]);
var inst_49315 = (state_49355[(7)]);
var inst_49328 = inst_49315.push(inst_49319);
var tmp49446 = inst_49315;
var inst_49315__$1 = tmp49446;
var inst_49316 = inst_49323;
var state_49355__$1 = (function (){var statearr_49462 = state_49355;
(statearr_49462[(7)] = inst_49315__$1);

(statearr_49462[(8)] = inst_49316);

(statearr_49462[(14)] = inst_49328);

return statearr_49462;
})();
var statearr_49468_50622 = state_49355__$1;
(statearr_49468_50622[(2)] = null);

(statearr_49468_50622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__45473__auto__ = null;
var cljs$core$async$state_machine__45473__auto____0 = (function (){
var statearr_49478 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_49478[(0)] = cljs$core$async$state_machine__45473__auto__);

(statearr_49478[(1)] = (1));

return statearr_49478;
});
var cljs$core$async$state_machine__45473__auto____1 = (function (state_49355){
while(true){
var ret_value__45474__auto__ = (function (){try{while(true){
var result__45475__auto__ = switch__45472__auto__(state_49355);
if(cljs.core.keyword_identical_QMARK_(result__45475__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__45475__auto__;
}
break;
}
}catch (e49484){var ex__45476__auto__ = e49484;
var statearr_49486_50624 = state_49355;
(statearr_49486_50624[(2)] = ex__45476__auto__);


if(cljs.core.seq((state_49355[(4)]))){
var statearr_49490_50625 = state_49355;
(statearr_49490_50625[(1)] = cljs.core.first((state_49355[(4)])));

} else {
throw ex__45476__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__45474__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50626 = state_49355;
state_49355 = G__50626;
continue;
} else {
return ret_value__45474__auto__;
}
break;
}
});
cljs$core$async$state_machine__45473__auto__ = function(state_49355){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__45473__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__45473__auto____1.call(this,state_49355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__45473__auto____0;
cljs$core$async$state_machine__45473__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__45473__auto____1;
return cljs$core$async$state_machine__45473__auto__;
})()
})();
var state__45602__auto__ = (function (){var statearr_49493 = f__45601__auto__();
(statearr_49493[(6)] = c__45600__auto___50600);

return statearr_49493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45602__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
