goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__45148 = arguments.length;
switch (G__45148) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45152 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45152 = (function (f,blockable,meta45153){
this.f = f;
this.blockable = blockable;
this.meta45153 = meta45153;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45152.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45154,meta45153__$1){
var self__ = this;
var _45154__$1 = this;
return (new cljs.core.async.t_cljs$core$async45152(self__.f,self__.blockable,meta45153__$1));
}));

(cljs.core.async.t_cljs$core$async45152.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45154){
var self__ = this;
var _45154__$1 = this;
return self__.meta45153;
}));

(cljs.core.async.t_cljs$core$async45152.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45152.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45152.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async45152.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async45152.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta45153","meta45153",1709950025,null)], null);
}));

(cljs.core.async.t_cljs$core$async45152.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45152.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45152");

(cljs.core.async.t_cljs$core$async45152.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45152");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45152.
 */
cljs.core.async.__GT_t_cljs$core$async45152 = (function cljs$core$async$__GT_t_cljs$core$async45152(f__$1,blockable__$1,meta45153){
return (new cljs.core.async.t_cljs$core$async45152(f__$1,blockable__$1,meta45153));
});

}

return (new cljs.core.async.t_cljs$core$async45152(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__45201 = arguments.length;
switch (G__45201) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__45215 = arguments.length;
switch (G__45215) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__45238 = arguments.length;
switch (G__45238) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_48597 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48597) : fn1.call(null,val_48597));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48597) : fn1.call(null,val_48597));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__45262 = arguments.length;
switch (G__45262) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___48628 = n;
var x_48629 = (0);
while(true){
if((x_48629 < n__4613__auto___48628)){
(a[x_48629] = x_48629);

var G__48630 = (x_48629 + (1));
x_48629 = G__48630;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45308 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45308 = (function (flag,meta45309){
this.flag = flag;
this.meta45309 = meta45309;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45308.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45310,meta45309__$1){
var self__ = this;
var _45310__$1 = this;
return (new cljs.core.async.t_cljs$core$async45308(self__.flag,meta45309__$1));
}));

(cljs.core.async.t_cljs$core$async45308.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45310){
var self__ = this;
var _45310__$1 = this;
return self__.meta45309;
}));

(cljs.core.async.t_cljs$core$async45308.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45308.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async45308.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45308.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async45308.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta45309","meta45309",1149544013,null)], null);
}));

(cljs.core.async.t_cljs$core$async45308.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45308.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45308");

(cljs.core.async.t_cljs$core$async45308.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45308");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45308.
 */
cljs.core.async.__GT_t_cljs$core$async45308 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async45308(flag__$1,meta45309){
return (new cljs.core.async.t_cljs$core$async45308(flag__$1,meta45309));
});

}

return (new cljs.core.async.t_cljs$core$async45308(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45332 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45332 = (function (flag,cb,meta45333){
this.flag = flag;
this.cb = cb;
this.meta45333 = meta45333;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45332.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45334,meta45333__$1){
var self__ = this;
var _45334__$1 = this;
return (new cljs.core.async.t_cljs$core$async45332(self__.flag,self__.cb,meta45333__$1));
}));

(cljs.core.async.t_cljs$core$async45332.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45334){
var self__ = this;
var _45334__$1 = this;
return self__.meta45333;
}));

(cljs.core.async.t_cljs$core$async45332.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45332.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async45332.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45332.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async45332.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta45333","meta45333",-828562990,null)], null);
}));

(cljs.core.async.t_cljs$core$async45332.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45332.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45332");

(cljs.core.async.t_cljs$core$async45332.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async45332");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45332.
 */
cljs.core.async.__GT_t_cljs$core$async45332 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async45332(flag__$1,cb__$1,meta45333){
return (new cljs.core.async.t_cljs$core$async45332(flag__$1,cb__$1,meta45333));
});

}

return (new cljs.core.async.t_cljs$core$async45332(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45353_SHARP_){
var G__45361 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45353_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__45361) : fret.call(null,G__45361));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45354_SHARP_){
var G__45364 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45354_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__45364) : fret.call(null,G__45364));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__48707 = (i + (1));
i = G__48707;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48718 = arguments.length;
var i__4737__auto___48719 = (0);
while(true){
if((i__4737__auto___48719 < len__4736__auto___48718)){
args__4742__auto__.push((arguments[i__4737__auto___48719]));

var G__48721 = (i__4737__auto___48719 + (1));
i__4737__auto___48719 = G__48721;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__45390){
var map__45391 = p__45390;
var map__45391__$1 = (((((!((map__45391 == null))))?(((((map__45391.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45391.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__45391):map__45391);
var opts = map__45391__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq45386){
var G__45387 = cljs.core.first(seq45386);
var seq45386__$1 = cljs.core.next(seq45386);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45387,seq45386__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__45406 = arguments.length;
switch (G__45406) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__45032__auto___48763 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_45463){
var state_val_45464 = (state_45463[(1)]);
if((state_val_45464 === (7))){
var inst_45454 = (state_45463[(2)]);
var state_45463__$1 = state_45463;
var statearr_45472_48769 = state_45463__$1;
(statearr_45472_48769[(2)] = inst_45454);

(statearr_45472_48769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (1))){
var state_45463__$1 = state_45463;
var statearr_45473_48776 = state_45463__$1;
(statearr_45473_48776[(2)] = null);

(statearr_45473_48776[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (4))){
var inst_45426 = (state_45463[(7)]);
var inst_45426__$1 = (state_45463[(2)]);
var inst_45432 = (inst_45426__$1 == null);
var state_45463__$1 = (function (){var statearr_45477 = state_45463;
(statearr_45477[(7)] = inst_45426__$1);

return statearr_45477;
})();
if(cljs.core.truth_(inst_45432)){
var statearr_45478_48784 = state_45463__$1;
(statearr_45478_48784[(1)] = (5));

} else {
var statearr_45483_48787 = state_45463__$1;
(statearr_45483_48787[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (13))){
var state_45463__$1 = state_45463;
var statearr_45491_48797 = state_45463__$1;
(statearr_45491_48797[(2)] = null);

(statearr_45491_48797[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (6))){
var inst_45426 = (state_45463[(7)]);
var state_45463__$1 = state_45463;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45463__$1,(11),to,inst_45426);
} else {
if((state_val_45464 === (3))){
var inst_45456 = (state_45463[(2)]);
var state_45463__$1 = state_45463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45463__$1,inst_45456);
} else {
if((state_val_45464 === (12))){
var state_45463__$1 = state_45463;
var statearr_45499_48809 = state_45463__$1;
(statearr_45499_48809[(2)] = null);

(statearr_45499_48809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (2))){
var state_45463__$1 = state_45463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45463__$1,(4),from);
} else {
if((state_val_45464 === (11))){
var inst_45445 = (state_45463[(2)]);
var state_45463__$1 = state_45463;
if(cljs.core.truth_(inst_45445)){
var statearr_45500_48814 = state_45463__$1;
(statearr_45500_48814[(1)] = (12));

} else {
var statearr_45501_48815 = state_45463__$1;
(statearr_45501_48815[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (9))){
var state_45463__$1 = state_45463;
var statearr_45503_48821 = state_45463__$1;
(statearr_45503_48821[(2)] = null);

(statearr_45503_48821[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (5))){
var state_45463__$1 = state_45463;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45504_48823 = state_45463__$1;
(statearr_45504_48823[(1)] = (8));

} else {
var statearr_45505_48825 = state_45463__$1;
(statearr_45505_48825[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (14))){
var inst_45452 = (state_45463[(2)]);
var state_45463__$1 = state_45463;
var statearr_45506_48829 = state_45463__$1;
(statearr_45506_48829[(2)] = inst_45452);

(statearr_45506_48829[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (10))){
var inst_45442 = (state_45463[(2)]);
var state_45463__$1 = state_45463;
var statearr_45510_48830 = state_45463__$1;
(statearr_45510_48830[(2)] = inst_45442);

(statearr_45510_48830[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45464 === (8))){
var inst_45438 = cljs.core.async.close_BANG_(to);
var state_45463__$1 = state_45463;
var statearr_45511_48833 = state_45463__$1;
(statearr_45511_48833[(2)] = inst_45438);

(statearr_45511_48833[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_45515 = [null,null,null,null,null,null,null,null];
(statearr_45515[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_45515[(1)] = (1));

return statearr_45515;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_45463){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_45463);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e45518){var ex__44939__auto__ = e45518;
var statearr_45521_48835 = state_45463;
(statearr_45521_48835[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_45463[(4)]))){
var statearr_45524_48836 = state_45463;
(statearr_45524_48836[(1)] = cljs.core.first((state_45463[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48837 = state_45463;
state_45463 = G__48837;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_45463){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_45463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_45525 = f__45033__auto__();
(statearr_45525[(6)] = c__45032__auto___48763);

return statearr_45525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__45535){
var vec__45536 = p__45535;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45536,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45536,(1),null);
var job = vec__45536;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__45032__auto___48845 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_45544){
var state_val_45546 = (state_45544[(1)]);
if((state_val_45546 === (1))){
var state_45544__$1 = state_45544;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45544__$1,(2),res,v);
} else {
if((state_val_45546 === (2))){
var inst_45541 = (state_45544[(2)]);
var inst_45542 = cljs.core.async.close_BANG_(res);
var state_45544__$1 = (function (){var statearr_45547 = state_45544;
(statearr_45547[(7)] = inst_45541);

return statearr_45547;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45544__$1,inst_45542);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0 = (function (){
var statearr_45555 = [null,null,null,null,null,null,null,null];
(statearr_45555[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__);

(statearr_45555[(1)] = (1));

return statearr_45555;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1 = (function (state_45544){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_45544);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e45557){var ex__44939__auto__ = e45557;
var statearr_45558_48848 = state_45544;
(statearr_45558_48848[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_45544[(4)]))){
var statearr_45560_48850 = state_45544;
(statearr_45560_48850[(1)] = cljs.core.first((state_45544[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48854 = state_45544;
state_45544 = G__48854;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = function(state_45544){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1.call(this,state_45544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_45563 = f__45033__auto__();
(statearr_45563[(6)] = c__45032__auto___48845);

return statearr_45563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__45569){
var vec__45571 = p__45569;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45571,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45571,(1),null);
var job = vec__45571;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___48866 = n;
var __48867 = (0);
while(true){
if((__48867 < n__4613__auto___48866)){
var G__45577_48868 = type;
var G__45577_48869__$1 = (((G__45577_48868 instanceof cljs.core.Keyword))?G__45577_48868.fqn:null);
switch (G__45577_48869__$1) {
case "compute":
var c__45032__auto___48877 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48867,c__45032__auto___48877,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async){
return (function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = ((function (__48867,c__45032__auto___48877,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async){
return (function (state_45599){
var state_val_45600 = (state_45599[(1)]);
if((state_val_45600 === (1))){
var state_45599__$1 = state_45599;
var statearr_45614_48880 = state_45599__$1;
(statearr_45614_48880[(2)] = null);

(statearr_45614_48880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45600 === (2))){
var state_45599__$1 = state_45599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45599__$1,(4),jobs);
} else {
if((state_val_45600 === (3))){
var inst_45596 = (state_45599[(2)]);
var state_45599__$1 = state_45599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45599__$1,inst_45596);
} else {
if((state_val_45600 === (4))){
var inst_45586 = (state_45599[(2)]);
var inst_45587 = process(inst_45586);
var state_45599__$1 = state_45599;
if(cljs.core.truth_(inst_45587)){
var statearr_45633_48881 = state_45599__$1;
(statearr_45633_48881[(1)] = (5));

} else {
var statearr_45634_48882 = state_45599__$1;
(statearr_45634_48882[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45600 === (5))){
var state_45599__$1 = state_45599;
var statearr_45640_48883 = state_45599__$1;
(statearr_45640_48883[(2)] = null);

(statearr_45640_48883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45600 === (6))){
var state_45599__$1 = state_45599;
var statearr_45645_48884 = state_45599__$1;
(statearr_45645_48884[(2)] = null);

(statearr_45645_48884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45600 === (7))){
var inst_45594 = (state_45599[(2)]);
var state_45599__$1 = state_45599;
var statearr_45650_48885 = state_45599__$1;
(statearr_45650_48885[(2)] = inst_45594);

(statearr_45650_48885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48867,c__45032__auto___48877,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async))
;
return ((function (__48867,switch__44933__auto__,c__45032__auto___48877,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0 = (function (){
var statearr_45657 = [null,null,null,null,null,null,null];
(statearr_45657[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__);

(statearr_45657[(1)] = (1));

return statearr_45657;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1 = (function (state_45599){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_45599);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e45662){var ex__44939__auto__ = e45662;
var statearr_45666_48902 = state_45599;
(statearr_45666_48902[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_45599[(4)]))){
var statearr_45668_48903 = state_45599;
(statearr_45668_48903[(1)] = cljs.core.first((state_45599[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48908 = state_45599;
state_45599 = G__48908;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = function(state_45599){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1.call(this,state_45599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__;
})()
;})(__48867,switch__44933__auto__,c__45032__auto___48877,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async))
})();
var state__45034__auto__ = (function (){var statearr_45672 = f__45033__auto__();
(statearr_45672[(6)] = c__45032__auto___48877);

return statearr_45672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
});})(__48867,c__45032__auto___48877,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async))
);


break;
case "async":
var c__45032__auto___48909 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48867,c__45032__auto___48909,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async){
return (function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = ((function (__48867,c__45032__auto___48909,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async){
return (function (state_45697){
var state_val_45698 = (state_45697[(1)]);
if((state_val_45698 === (1))){
var state_45697__$1 = state_45697;
var statearr_45713_48918 = state_45697__$1;
(statearr_45713_48918[(2)] = null);

(statearr_45713_48918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45698 === (2))){
var state_45697__$1 = state_45697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45697__$1,(4),jobs);
} else {
if((state_val_45698 === (3))){
var inst_45695 = (state_45697[(2)]);
var state_45697__$1 = state_45697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45697__$1,inst_45695);
} else {
if((state_val_45698 === (4))){
var inst_45685 = (state_45697[(2)]);
var inst_45687 = async(inst_45685);
var state_45697__$1 = state_45697;
if(cljs.core.truth_(inst_45687)){
var statearr_45725_48921 = state_45697__$1;
(statearr_45725_48921[(1)] = (5));

} else {
var statearr_45726_48922 = state_45697__$1;
(statearr_45726_48922[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45698 === (5))){
var state_45697__$1 = state_45697;
var statearr_45729_48923 = state_45697__$1;
(statearr_45729_48923[(2)] = null);

(statearr_45729_48923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45698 === (6))){
var state_45697__$1 = state_45697;
var statearr_45737_48924 = state_45697__$1;
(statearr_45737_48924[(2)] = null);

(statearr_45737_48924[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45698 === (7))){
var inst_45692 = (state_45697[(2)]);
var state_45697__$1 = state_45697;
var statearr_45740_48925 = state_45697__$1;
(statearr_45740_48925[(2)] = inst_45692);

(statearr_45740_48925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48867,c__45032__auto___48909,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async))
;
return ((function (__48867,switch__44933__auto__,c__45032__auto___48909,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0 = (function (){
var statearr_45745 = [null,null,null,null,null,null,null];
(statearr_45745[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__);

(statearr_45745[(1)] = (1));

return statearr_45745;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1 = (function (state_45697){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_45697);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e45749){var ex__44939__auto__ = e45749;
var statearr_45750_48932 = state_45697;
(statearr_45750_48932[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_45697[(4)]))){
var statearr_45751_48933 = state_45697;
(statearr_45751_48933[(1)] = cljs.core.first((state_45697[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48934 = state_45697;
state_45697 = G__48934;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = function(state_45697){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1.call(this,state_45697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__;
})()
;})(__48867,switch__44933__auto__,c__45032__auto___48909,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async))
})();
var state__45034__auto__ = (function (){var statearr_45752 = f__45033__auto__();
(statearr_45752[(6)] = c__45032__auto___48909);

return statearr_45752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
});})(__48867,c__45032__auto___48909,G__45577_48868,G__45577_48869__$1,n__4613__auto___48866,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__45577_48869__$1)].join('')));

}

var G__48935 = (__48867 + (1));
__48867 = G__48935;
continue;
} else {
}
break;
}

var c__45032__auto___48936 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_45792){
var state_val_45795 = (state_45792[(1)]);
if((state_val_45795 === (7))){
var inst_45788 = (state_45792[(2)]);
var state_45792__$1 = state_45792;
var statearr_45807_48937 = state_45792__$1;
(statearr_45807_48937[(2)] = inst_45788);

(statearr_45807_48937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (1))){
var state_45792__$1 = state_45792;
var statearr_45809_48939 = state_45792__$1;
(statearr_45809_48939[(2)] = null);

(statearr_45809_48939[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (4))){
var inst_45770 = (state_45792[(7)]);
var inst_45770__$1 = (state_45792[(2)]);
var inst_45771 = (inst_45770__$1 == null);
var state_45792__$1 = (function (){var statearr_45813 = state_45792;
(statearr_45813[(7)] = inst_45770__$1);

return statearr_45813;
})();
if(cljs.core.truth_(inst_45771)){
var statearr_45815_48941 = state_45792__$1;
(statearr_45815_48941[(1)] = (5));

} else {
var statearr_45817_48942 = state_45792__$1;
(statearr_45817_48942[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (6))){
var inst_45776 = (state_45792[(8)]);
var inst_45770 = (state_45792[(7)]);
var inst_45776__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_45778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45779 = [inst_45770,inst_45776__$1];
var inst_45781 = (new cljs.core.PersistentVector(null,2,(5),inst_45778,inst_45779,null));
var state_45792__$1 = (function (){var statearr_45820 = state_45792;
(statearr_45820[(8)] = inst_45776__$1);

return statearr_45820;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45792__$1,(8),jobs,inst_45781);
} else {
if((state_val_45795 === (3))){
var inst_45790 = (state_45792[(2)]);
var state_45792__$1 = state_45792;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45792__$1,inst_45790);
} else {
if((state_val_45795 === (2))){
var state_45792__$1 = state_45792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45792__$1,(4),from);
} else {
if((state_val_45795 === (9))){
var inst_45785 = (state_45792[(2)]);
var state_45792__$1 = (function (){var statearr_45825 = state_45792;
(statearr_45825[(9)] = inst_45785);

return statearr_45825;
})();
var statearr_45826_48950 = state_45792__$1;
(statearr_45826_48950[(2)] = null);

(statearr_45826_48950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (5))){
var inst_45773 = cljs.core.async.close_BANG_(jobs);
var state_45792__$1 = state_45792;
var statearr_45829_48956 = state_45792__$1;
(statearr_45829_48956[(2)] = inst_45773);

(statearr_45829_48956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45795 === (8))){
var inst_45776 = (state_45792[(8)]);
var inst_45783 = (state_45792[(2)]);
var state_45792__$1 = (function (){var statearr_45830 = state_45792;
(statearr_45830[(10)] = inst_45783);

return statearr_45830;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45792__$1,(9),results,inst_45776);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0 = (function (){
var statearr_45835 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45835[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__);

(statearr_45835[(1)] = (1));

return statearr_45835;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1 = (function (state_45792){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_45792);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e45837){var ex__44939__auto__ = e45837;
var statearr_45838_48960 = state_45792;
(statearr_45838_48960[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_45792[(4)]))){
var statearr_45839_48961 = state_45792;
(statearr_45839_48961[(1)] = cljs.core.first((state_45792[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48969 = state_45792;
state_45792 = G__48969;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = function(state_45792){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1.call(this,state_45792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_45851 = f__45033__auto__();
(statearr_45851[(6)] = c__45032__auto___48936);

return statearr_45851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


var c__45032__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_45912){
var state_val_45913 = (state_45912[(1)]);
if((state_val_45913 === (7))){
var inst_45908 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
var statearr_45916_48976 = state_45912__$1;
(statearr_45916_48976[(2)] = inst_45908);

(statearr_45916_48976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (20))){
var state_45912__$1 = state_45912;
var statearr_45923_48977 = state_45912__$1;
(statearr_45923_48977[(2)] = null);

(statearr_45923_48977[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (1))){
var state_45912__$1 = state_45912;
var statearr_45928_48978 = state_45912__$1;
(statearr_45928_48978[(2)] = null);

(statearr_45928_48978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (4))){
var inst_45861 = (state_45912[(7)]);
var inst_45861__$1 = (state_45912[(2)]);
var inst_45863 = (inst_45861__$1 == null);
var state_45912__$1 = (function (){var statearr_45939 = state_45912;
(statearr_45939[(7)] = inst_45861__$1);

return statearr_45939;
})();
if(cljs.core.truth_(inst_45863)){
var statearr_45940_48984 = state_45912__$1;
(statearr_45940_48984[(1)] = (5));

} else {
var statearr_45941_48986 = state_45912__$1;
(statearr_45941_48986[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (15))){
var inst_45883 = (state_45912[(8)]);
var state_45912__$1 = state_45912;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45912__$1,(18),to,inst_45883);
} else {
if((state_val_45913 === (21))){
var inst_45899 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
var statearr_45944_48989 = state_45912__$1;
(statearr_45944_48989[(2)] = inst_45899);

(statearr_45944_48989[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (13))){
var inst_45901 = (state_45912[(2)]);
var state_45912__$1 = (function (){var statearr_45953 = state_45912;
(statearr_45953[(9)] = inst_45901);

return statearr_45953;
})();
var statearr_45954_48992 = state_45912__$1;
(statearr_45954_48992[(2)] = null);

(statearr_45954_48992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (6))){
var inst_45861 = (state_45912[(7)]);
var state_45912__$1 = state_45912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45912__$1,(11),inst_45861);
} else {
if((state_val_45913 === (17))){
var inst_45891 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
if(cljs.core.truth_(inst_45891)){
var statearr_45957_48995 = state_45912__$1;
(statearr_45957_48995[(1)] = (19));

} else {
var statearr_45959_49003 = state_45912__$1;
(statearr_45959_49003[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (3))){
var inst_45910 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45912__$1,inst_45910);
} else {
if((state_val_45913 === (12))){
var inst_45875 = (state_45912[(10)]);
var state_45912__$1 = state_45912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45912__$1,(14),inst_45875);
} else {
if((state_val_45913 === (2))){
var state_45912__$1 = state_45912;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45912__$1,(4),results);
} else {
if((state_val_45913 === (19))){
var state_45912__$1 = state_45912;
var statearr_45966_49019 = state_45912__$1;
(statearr_45966_49019[(2)] = null);

(statearr_45966_49019[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (11))){
var inst_45875 = (state_45912[(2)]);
var state_45912__$1 = (function (){var statearr_45971 = state_45912;
(statearr_45971[(10)] = inst_45875);

return statearr_45971;
})();
var statearr_45975_49022 = state_45912__$1;
(statearr_45975_49022[(2)] = null);

(statearr_45975_49022[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (9))){
var state_45912__$1 = state_45912;
var statearr_45976_49024 = state_45912__$1;
(statearr_45976_49024[(2)] = null);

(statearr_45976_49024[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (5))){
var state_45912__$1 = state_45912;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45979_49025 = state_45912__$1;
(statearr_45979_49025[(1)] = (8));

} else {
var statearr_45980_49026 = state_45912__$1;
(statearr_45980_49026[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (14))){
var inst_45883 = (state_45912[(8)]);
var inst_45883__$1 = (state_45912[(2)]);
var inst_45884 = (inst_45883__$1 == null);
var inst_45885 = cljs.core.not(inst_45884);
var state_45912__$1 = (function (){var statearr_45991 = state_45912;
(statearr_45991[(8)] = inst_45883__$1);

return statearr_45991;
})();
if(inst_45885){
var statearr_45992_49035 = state_45912__$1;
(statearr_45992_49035[(1)] = (15));

} else {
var statearr_45993_49036 = state_45912__$1;
(statearr_45993_49036[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (16))){
var state_45912__$1 = state_45912;
var statearr_46000_49042 = state_45912__$1;
(statearr_46000_49042[(2)] = false);

(statearr_46000_49042[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (10))){
var inst_45871 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
var statearr_46011_49044 = state_45912__$1;
(statearr_46011_49044[(2)] = inst_45871);

(statearr_46011_49044[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (18))){
var inst_45888 = (state_45912[(2)]);
var state_45912__$1 = state_45912;
var statearr_46012_49050 = state_45912__$1;
(statearr_46012_49050[(2)] = inst_45888);

(statearr_46012_49050[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45913 === (8))){
var inst_45867 = cljs.core.async.close_BANG_(to);
var state_45912__$1 = state_45912;
var statearr_46017_49052 = state_45912__$1;
(statearr_46017_49052[(2)] = inst_45867);

(statearr_46017_49052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0 = (function (){
var statearr_46024 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46024[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__);

(statearr_46024[(1)] = (1));

return statearr_46024;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1 = (function (state_45912){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_45912);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e46025){var ex__44939__auto__ = e46025;
var statearr_46027_49060 = state_45912;
(statearr_46027_49060[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_45912[(4)]))){
var statearr_46028_49061 = state_45912;
(statearr_46028_49061[(1)] = cljs.core.first((state_45912[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49064 = state_45912;
state_45912 = G__49064;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__ = function(state_45912){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1.call(this,state_45912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44935__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_46032 = f__45033__auto__();
(statearr_46032[(6)] = c__45032__auto__);

return statearr_46032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));

return c__45032__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__46041 = arguments.length;
switch (G__46041) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__46059 = arguments.length;
switch (G__46059) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__46077 = arguments.length;
switch (G__46077) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__45032__auto___49098 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_46109){
var state_val_46110 = (state_46109[(1)]);
if((state_val_46110 === (7))){
var inst_46104 = (state_46109[(2)]);
var state_46109__$1 = state_46109;
var statearr_46113_49101 = state_46109__$1;
(statearr_46113_49101[(2)] = inst_46104);

(statearr_46113_49101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (1))){
var state_46109__$1 = state_46109;
var statearr_46115_49102 = state_46109__$1;
(statearr_46115_49102[(2)] = null);

(statearr_46115_49102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (4))){
var inst_46085 = (state_46109[(7)]);
var inst_46085__$1 = (state_46109[(2)]);
var inst_46086 = (inst_46085__$1 == null);
var state_46109__$1 = (function (){var statearr_46116 = state_46109;
(statearr_46116[(7)] = inst_46085__$1);

return statearr_46116;
})();
if(cljs.core.truth_(inst_46086)){
var statearr_46117_49105 = state_46109__$1;
(statearr_46117_49105[(1)] = (5));

} else {
var statearr_46119_49106 = state_46109__$1;
(statearr_46119_49106[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (13))){
var state_46109__$1 = state_46109;
var statearr_46120_49108 = state_46109__$1;
(statearr_46120_49108[(2)] = null);

(statearr_46120_49108[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (6))){
var inst_46085 = (state_46109[(7)]);
var inst_46091 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_46085) : p.call(null,inst_46085));
var state_46109__$1 = state_46109;
if(cljs.core.truth_(inst_46091)){
var statearr_46121_49110 = state_46109__$1;
(statearr_46121_49110[(1)] = (9));

} else {
var statearr_46122_49111 = state_46109__$1;
(statearr_46122_49111[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (3))){
var inst_46106 = (state_46109[(2)]);
var state_46109__$1 = state_46109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46109__$1,inst_46106);
} else {
if((state_val_46110 === (12))){
var state_46109__$1 = state_46109;
var statearr_46125_49112 = state_46109__$1;
(statearr_46125_49112[(2)] = null);

(statearr_46125_49112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (2))){
var state_46109__$1 = state_46109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46109__$1,(4),ch);
} else {
if((state_val_46110 === (11))){
var inst_46085 = (state_46109[(7)]);
var inst_46095 = (state_46109[(2)]);
var state_46109__$1 = state_46109;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46109__$1,(8),inst_46095,inst_46085);
} else {
if((state_val_46110 === (9))){
var state_46109__$1 = state_46109;
var statearr_46126_49114 = state_46109__$1;
(statearr_46126_49114[(2)] = tc);

(statearr_46126_49114[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (5))){
var inst_46088 = cljs.core.async.close_BANG_(tc);
var inst_46089 = cljs.core.async.close_BANG_(fc);
var state_46109__$1 = (function (){var statearr_46127 = state_46109;
(statearr_46127[(8)] = inst_46088);

return statearr_46127;
})();
var statearr_46128_49116 = state_46109__$1;
(statearr_46128_49116[(2)] = inst_46089);

(statearr_46128_49116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (14))){
var inst_46102 = (state_46109[(2)]);
var state_46109__$1 = state_46109;
var statearr_46129_49117 = state_46109__$1;
(statearr_46129_49117[(2)] = inst_46102);

(statearr_46129_49117[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (10))){
var state_46109__$1 = state_46109;
var statearr_46130_49119 = state_46109__$1;
(statearr_46130_49119[(2)] = fc);

(statearr_46130_49119[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46110 === (8))){
var inst_46097 = (state_46109[(2)]);
var state_46109__$1 = state_46109;
if(cljs.core.truth_(inst_46097)){
var statearr_46131_49121 = state_46109__$1;
(statearr_46131_49121[(1)] = (12));

} else {
var statearr_46134_49122 = state_46109__$1;
(statearr_46134_49122[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_46135 = [null,null,null,null,null,null,null,null,null];
(statearr_46135[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_46135[(1)] = (1));

return statearr_46135;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_46109){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_46109);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e46136){var ex__44939__auto__ = e46136;
var statearr_46137_49128 = state_46109;
(statearr_46137_49128[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_46109[(4)]))){
var statearr_46138_49129 = state_46109;
(statearr_46138_49129[(1)] = cljs.core.first((state_46109[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49134 = state_46109;
state_46109 = G__49134;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_46109){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_46109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_46141 = f__45033__auto__();
(statearr_46141[(6)] = c__45032__auto___49098);

return statearr_46141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__45032__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_46165){
var state_val_46166 = (state_46165[(1)]);
if((state_val_46166 === (7))){
var inst_46161 = (state_46165[(2)]);
var state_46165__$1 = state_46165;
var statearr_46174_49140 = state_46165__$1;
(statearr_46174_49140[(2)] = inst_46161);

(statearr_46174_49140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46166 === (1))){
var inst_46142 = init;
var inst_46143 = inst_46142;
var state_46165__$1 = (function (){var statearr_46176 = state_46165;
(statearr_46176[(7)] = inst_46143);

return statearr_46176;
})();
var statearr_46177_49141 = state_46165__$1;
(statearr_46177_49141[(2)] = null);

(statearr_46177_49141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46166 === (4))){
var inst_46146 = (state_46165[(8)]);
var inst_46146__$1 = (state_46165[(2)]);
var inst_46147 = (inst_46146__$1 == null);
var state_46165__$1 = (function (){var statearr_46178 = state_46165;
(statearr_46178[(8)] = inst_46146__$1);

return statearr_46178;
})();
if(cljs.core.truth_(inst_46147)){
var statearr_46179_49143 = state_46165__$1;
(statearr_46179_49143[(1)] = (5));

} else {
var statearr_46180_49144 = state_46165__$1;
(statearr_46180_49144[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46166 === (6))){
var inst_46143 = (state_46165[(7)]);
var inst_46146 = (state_46165[(8)]);
var inst_46152 = (state_46165[(9)]);
var inst_46152__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_46143,inst_46146) : f.call(null,inst_46143,inst_46146));
var inst_46153 = cljs.core.reduced_QMARK_(inst_46152__$1);
var state_46165__$1 = (function (){var statearr_46186 = state_46165;
(statearr_46186[(9)] = inst_46152__$1);

return statearr_46186;
})();
if(inst_46153){
var statearr_46187_49152 = state_46165__$1;
(statearr_46187_49152[(1)] = (8));

} else {
var statearr_46188_49153 = state_46165__$1;
(statearr_46188_49153[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46166 === (3))){
var inst_46163 = (state_46165[(2)]);
var state_46165__$1 = state_46165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46165__$1,inst_46163);
} else {
if((state_val_46166 === (2))){
var state_46165__$1 = state_46165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46165__$1,(4),ch);
} else {
if((state_val_46166 === (9))){
var inst_46152 = (state_46165[(9)]);
var inst_46143 = inst_46152;
var state_46165__$1 = (function (){var statearr_46189 = state_46165;
(statearr_46189[(7)] = inst_46143);

return statearr_46189;
})();
var statearr_46195_49154 = state_46165__$1;
(statearr_46195_49154[(2)] = null);

(statearr_46195_49154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46166 === (5))){
var inst_46143 = (state_46165[(7)]);
var state_46165__$1 = state_46165;
var statearr_46196_49157 = state_46165__$1;
(statearr_46196_49157[(2)] = inst_46143);

(statearr_46196_49157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46166 === (10))){
var inst_46159 = (state_46165[(2)]);
var state_46165__$1 = state_46165;
var statearr_46207_49159 = state_46165__$1;
(statearr_46207_49159[(2)] = inst_46159);

(statearr_46207_49159[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46166 === (8))){
var inst_46152 = (state_46165[(9)]);
var inst_46155 = cljs.core.deref(inst_46152);
var state_46165__$1 = state_46165;
var statearr_46211_49161 = state_46165__$1;
(statearr_46211_49161[(2)] = inst_46155);

(statearr_46211_49161[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__44935__auto__ = null;
var cljs$core$async$reduce_$_state_machine__44935__auto____0 = (function (){
var statearr_46240 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46240[(0)] = cljs$core$async$reduce_$_state_machine__44935__auto__);

(statearr_46240[(1)] = (1));

return statearr_46240;
});
var cljs$core$async$reduce_$_state_machine__44935__auto____1 = (function (state_46165){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_46165);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e46246){var ex__44939__auto__ = e46246;
var statearr_46247_49167 = state_46165;
(statearr_46247_49167[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_46165[(4)]))){
var statearr_46248_49168 = state_46165;
(statearr_46248_49168[(1)] = cljs.core.first((state_46165[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49170 = state_46165;
state_46165 = G__49170;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__44935__auto__ = function(state_46165){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__44935__auto____1.call(this,state_46165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__44935__auto____0;
cljs$core$async$reduce_$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__44935__auto____1;
return cljs$core$async$reduce_$_state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_46256 = f__45033__auto__();
(statearr_46256[(6)] = c__45032__auto__);

return statearr_46256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));

return c__45032__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__45032__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_46277){
var state_val_46278 = (state_46277[(1)]);
if((state_val_46278 === (1))){
var inst_46272 = cljs.core.async.reduce(f__$1,init,ch);
var state_46277__$1 = state_46277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46277__$1,(2),inst_46272);
} else {
if((state_val_46278 === (2))){
var inst_46274 = (state_46277[(2)]);
var inst_46275 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_46274) : f__$1.call(null,inst_46274));
var state_46277__$1 = state_46277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46277__$1,inst_46275);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__44935__auto__ = null;
var cljs$core$async$transduce_$_state_machine__44935__auto____0 = (function (){
var statearr_46296 = [null,null,null,null,null,null,null];
(statearr_46296[(0)] = cljs$core$async$transduce_$_state_machine__44935__auto__);

(statearr_46296[(1)] = (1));

return statearr_46296;
});
var cljs$core$async$transduce_$_state_machine__44935__auto____1 = (function (state_46277){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_46277);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e46297){var ex__44939__auto__ = e46297;
var statearr_46298_49188 = state_46277;
(statearr_46298_49188[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_46277[(4)]))){
var statearr_46300_49190 = state_46277;
(statearr_46300_49190[(1)] = cljs.core.first((state_46277[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49191 = state_46277;
state_46277 = G__49191;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__44935__auto__ = function(state_46277){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__44935__auto____1.call(this,state_46277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__44935__auto____0;
cljs$core$async$transduce_$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__44935__auto____1;
return cljs$core$async$transduce_$_state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_46305 = f__45033__auto__();
(statearr_46305[(6)] = c__45032__auto__);

return statearr_46305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));

return c__45032__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__46311 = arguments.length;
switch (G__46311) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__45032__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_46337){
var state_val_46338 = (state_46337[(1)]);
if((state_val_46338 === (7))){
var inst_46319 = (state_46337[(2)]);
var state_46337__$1 = state_46337;
var statearr_46343_49201 = state_46337__$1;
(statearr_46343_49201[(2)] = inst_46319);

(statearr_46343_49201[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (1))){
var inst_46313 = cljs.core.seq(coll);
var inst_46314 = inst_46313;
var state_46337__$1 = (function (){var statearr_46344 = state_46337;
(statearr_46344[(7)] = inst_46314);

return statearr_46344;
})();
var statearr_46345_49206 = state_46337__$1;
(statearr_46345_49206[(2)] = null);

(statearr_46345_49206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (4))){
var inst_46314 = (state_46337[(7)]);
var inst_46317 = cljs.core.first(inst_46314);
var state_46337__$1 = state_46337;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46337__$1,(7),ch,inst_46317);
} else {
if((state_val_46338 === (13))){
var inst_46331 = (state_46337[(2)]);
var state_46337__$1 = state_46337;
var statearr_46346_49215 = state_46337__$1;
(statearr_46346_49215[(2)] = inst_46331);

(statearr_46346_49215[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (6))){
var inst_46322 = (state_46337[(2)]);
var state_46337__$1 = state_46337;
if(cljs.core.truth_(inst_46322)){
var statearr_46347_49217 = state_46337__$1;
(statearr_46347_49217[(1)] = (8));

} else {
var statearr_46348_49218 = state_46337__$1;
(statearr_46348_49218[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (3))){
var inst_46335 = (state_46337[(2)]);
var state_46337__$1 = state_46337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46337__$1,inst_46335);
} else {
if((state_val_46338 === (12))){
var state_46337__$1 = state_46337;
var statearr_46350_49219 = state_46337__$1;
(statearr_46350_49219[(2)] = null);

(statearr_46350_49219[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (2))){
var inst_46314 = (state_46337[(7)]);
var state_46337__$1 = state_46337;
if(cljs.core.truth_(inst_46314)){
var statearr_46351_49221 = state_46337__$1;
(statearr_46351_49221[(1)] = (4));

} else {
var statearr_46354_49222 = state_46337__$1;
(statearr_46354_49222[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (11))){
var inst_46328 = cljs.core.async.close_BANG_(ch);
var state_46337__$1 = state_46337;
var statearr_46356_49224 = state_46337__$1;
(statearr_46356_49224[(2)] = inst_46328);

(statearr_46356_49224[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (9))){
var state_46337__$1 = state_46337;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46357_49233 = state_46337__$1;
(statearr_46357_49233[(1)] = (11));

} else {
var statearr_46358_49234 = state_46337__$1;
(statearr_46358_49234[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (5))){
var inst_46314 = (state_46337[(7)]);
var state_46337__$1 = state_46337;
var statearr_46359_49235 = state_46337__$1;
(statearr_46359_49235[(2)] = inst_46314);

(statearr_46359_49235[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (10))){
var inst_46333 = (state_46337[(2)]);
var state_46337__$1 = state_46337;
var statearr_46360_49237 = state_46337__$1;
(statearr_46360_49237[(2)] = inst_46333);

(statearr_46360_49237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46338 === (8))){
var inst_46314 = (state_46337[(7)]);
var inst_46324 = cljs.core.next(inst_46314);
var inst_46314__$1 = inst_46324;
var state_46337__$1 = (function (){var statearr_46361 = state_46337;
(statearr_46361[(7)] = inst_46314__$1);

return statearr_46361;
})();
var statearr_46362_49242 = state_46337__$1;
(statearr_46362_49242[(2)] = null);

(statearr_46362_49242[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_46366 = [null,null,null,null,null,null,null,null];
(statearr_46366[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_46366[(1)] = (1));

return statearr_46366;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_46337){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_46337);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e46368){var ex__44939__auto__ = e46368;
var statearr_46369_49247 = state_46337;
(statearr_46369_49247[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_46337[(4)]))){
var statearr_46370_49248 = state_46337;
(statearr_46370_49248[(1)] = cljs.core.first((state_46337[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49249 = state_46337;
state_46337 = G__49249;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_46337){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_46337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_46374 = f__45033__auto__();
(statearr_46374[(6)] = c__45032__auto__);

return statearr_46374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));

return c__45032__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__46377 = arguments.length;
switch (G__46377) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_49254 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_49254(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_49261 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_49261(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_49269 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_49269(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_49273 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_49273(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46412 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46412 = (function (ch,cs,meta46413){
this.ch = ch;
this.cs = cs;
this.meta46413 = meta46413;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46412.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46414,meta46413__$1){
var self__ = this;
var _46414__$1 = this;
return (new cljs.core.async.t_cljs$core$async46412(self__.ch,self__.cs,meta46413__$1));
}));

(cljs.core.async.t_cljs$core$async46412.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46414){
var self__ = this;
var _46414__$1 = this;
return self__.meta46413;
}));

(cljs.core.async.t_cljs$core$async46412.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46412.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46412.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46412.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async46412.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async46412.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async46412.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta46413","meta46413",-1338699333,null)], null);
}));

(cljs.core.async.t_cljs$core$async46412.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46412.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46412");

(cljs.core.async.t_cljs$core$async46412.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46412");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46412.
 */
cljs.core.async.__GT_t_cljs$core$async46412 = (function cljs$core$async$mult_$___GT_t_cljs$core$async46412(ch__$1,cs__$1,meta46413){
return (new cljs.core.async.t_cljs$core$async46412(ch__$1,cs__$1,meta46413));
});

}

return (new cljs.core.async.t_cljs$core$async46412(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__45032__auto___49285 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_46578){
var state_val_46579 = (state_46578[(1)]);
if((state_val_46579 === (7))){
var inst_46574 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46582_49286 = state_46578__$1;
(statearr_46582_49286[(2)] = inst_46574);

(statearr_46582_49286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (20))){
var inst_46468 = (state_46578[(7)]);
var inst_46483 = cljs.core.first(inst_46468);
var inst_46484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46483,(0),null);
var inst_46485 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46483,(1),null);
var state_46578__$1 = (function (){var statearr_46585 = state_46578;
(statearr_46585[(8)] = inst_46484);

return statearr_46585;
})();
if(cljs.core.truth_(inst_46485)){
var statearr_46586_49287 = state_46578__$1;
(statearr_46586_49287[(1)] = (22));

} else {
var statearr_46587_49288 = state_46578__$1;
(statearr_46587_49288[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (27))){
var inst_46513 = (state_46578[(9)]);
var inst_46521 = (state_46578[(10)]);
var inst_46433 = (state_46578[(11)]);
var inst_46515 = (state_46578[(12)]);
var inst_46521__$1 = cljs.core._nth(inst_46513,inst_46515);
var inst_46522 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46521__$1,inst_46433,done);
var state_46578__$1 = (function (){var statearr_46591 = state_46578;
(statearr_46591[(10)] = inst_46521__$1);

return statearr_46591;
})();
if(cljs.core.truth_(inst_46522)){
var statearr_46592_49297 = state_46578__$1;
(statearr_46592_49297[(1)] = (30));

} else {
var statearr_46593_49298 = state_46578__$1;
(statearr_46593_49298[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (1))){
var state_46578__$1 = state_46578;
var statearr_46594_49303 = state_46578__$1;
(statearr_46594_49303[(2)] = null);

(statearr_46594_49303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (24))){
var inst_46468 = (state_46578[(7)]);
var inst_46490 = (state_46578[(2)]);
var inst_46491 = cljs.core.next(inst_46468);
var inst_46442 = inst_46491;
var inst_46443 = null;
var inst_46444 = (0);
var inst_46445 = (0);
var state_46578__$1 = (function (){var statearr_46596 = state_46578;
(statearr_46596[(13)] = inst_46445);

(statearr_46596[(14)] = inst_46490);

(statearr_46596[(15)] = inst_46444);

(statearr_46596[(16)] = inst_46443);

(statearr_46596[(17)] = inst_46442);

return statearr_46596;
})();
var statearr_46600_49308 = state_46578__$1;
(statearr_46600_49308[(2)] = null);

(statearr_46600_49308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (39))){
var state_46578__$1 = state_46578;
var statearr_46604_49309 = state_46578__$1;
(statearr_46604_49309[(2)] = null);

(statearr_46604_49309[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (4))){
var inst_46433 = (state_46578[(11)]);
var inst_46433__$1 = (state_46578[(2)]);
var inst_46434 = (inst_46433__$1 == null);
var state_46578__$1 = (function (){var statearr_46605 = state_46578;
(statearr_46605[(11)] = inst_46433__$1);

return statearr_46605;
})();
if(cljs.core.truth_(inst_46434)){
var statearr_46606_49311 = state_46578__$1;
(statearr_46606_49311[(1)] = (5));

} else {
var statearr_46607_49312 = state_46578__$1;
(statearr_46607_49312[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (15))){
var inst_46445 = (state_46578[(13)]);
var inst_46444 = (state_46578[(15)]);
var inst_46443 = (state_46578[(16)]);
var inst_46442 = (state_46578[(17)]);
var inst_46464 = (state_46578[(2)]);
var inst_46465 = (inst_46445 + (1));
var tmp46601 = inst_46444;
var tmp46602 = inst_46443;
var tmp46603 = inst_46442;
var inst_46442__$1 = tmp46603;
var inst_46443__$1 = tmp46602;
var inst_46444__$1 = tmp46601;
var inst_46445__$1 = inst_46465;
var state_46578__$1 = (function (){var statearr_46609 = state_46578;
(statearr_46609[(13)] = inst_46445__$1);

(statearr_46609[(18)] = inst_46464);

(statearr_46609[(15)] = inst_46444__$1);

(statearr_46609[(16)] = inst_46443__$1);

(statearr_46609[(17)] = inst_46442__$1);

return statearr_46609;
})();
var statearr_46610_49313 = state_46578__$1;
(statearr_46610_49313[(2)] = null);

(statearr_46610_49313[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (21))){
var inst_46494 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46618_49319 = state_46578__$1;
(statearr_46618_49319[(2)] = inst_46494);

(statearr_46618_49319[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (31))){
var inst_46521 = (state_46578[(10)]);
var inst_46528 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46521);
var state_46578__$1 = state_46578;
var statearr_46622_49328 = state_46578__$1;
(statearr_46622_49328[(2)] = inst_46528);

(statearr_46622_49328[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (32))){
var inst_46513 = (state_46578[(9)]);
var inst_46512 = (state_46578[(19)]);
var inst_46514 = (state_46578[(20)]);
var inst_46515 = (state_46578[(12)]);
var inst_46530 = (state_46578[(2)]);
var inst_46531 = (inst_46515 + (1));
var tmp46615 = inst_46513;
var tmp46616 = inst_46512;
var tmp46617 = inst_46514;
var inst_46512__$1 = tmp46616;
var inst_46513__$1 = tmp46615;
var inst_46514__$1 = tmp46617;
var inst_46515__$1 = inst_46531;
var state_46578__$1 = (function (){var statearr_46624 = state_46578;
(statearr_46624[(9)] = inst_46513__$1);

(statearr_46624[(19)] = inst_46512__$1);

(statearr_46624[(21)] = inst_46530);

(statearr_46624[(20)] = inst_46514__$1);

(statearr_46624[(12)] = inst_46515__$1);

return statearr_46624;
})();
var statearr_46627_49334 = state_46578__$1;
(statearr_46627_49334[(2)] = null);

(statearr_46627_49334[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (40))){
var inst_46545 = (state_46578[(22)]);
var inst_46549 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46545);
var state_46578__$1 = state_46578;
var statearr_46628_49338 = state_46578__$1;
(statearr_46628_49338[(2)] = inst_46549);

(statearr_46628_49338[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (33))){
var inst_46535 = (state_46578[(23)]);
var inst_46538 = cljs.core.chunked_seq_QMARK_(inst_46535);
var state_46578__$1 = state_46578;
if(inst_46538){
var statearr_46629_49347 = state_46578__$1;
(statearr_46629_49347[(1)] = (36));

} else {
var statearr_46630_49348 = state_46578__$1;
(statearr_46630_49348[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (13))){
var inst_46458 = (state_46578[(24)]);
var inst_46461 = cljs.core.async.close_BANG_(inst_46458);
var state_46578__$1 = state_46578;
var statearr_46635_49354 = state_46578__$1;
(statearr_46635_49354[(2)] = inst_46461);

(statearr_46635_49354[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (22))){
var inst_46484 = (state_46578[(8)]);
var inst_46487 = cljs.core.async.close_BANG_(inst_46484);
var state_46578__$1 = state_46578;
var statearr_46639_49355 = state_46578__$1;
(statearr_46639_49355[(2)] = inst_46487);

(statearr_46639_49355[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (36))){
var inst_46535 = (state_46578[(23)]);
var inst_46540 = cljs.core.chunk_first(inst_46535);
var inst_46541 = cljs.core.chunk_rest(inst_46535);
var inst_46542 = cljs.core.count(inst_46540);
var inst_46512 = inst_46541;
var inst_46513 = inst_46540;
var inst_46514 = inst_46542;
var inst_46515 = (0);
var state_46578__$1 = (function (){var statearr_46644 = state_46578;
(statearr_46644[(9)] = inst_46513);

(statearr_46644[(19)] = inst_46512);

(statearr_46644[(20)] = inst_46514);

(statearr_46644[(12)] = inst_46515);

return statearr_46644;
})();
var statearr_46649_49359 = state_46578__$1;
(statearr_46649_49359[(2)] = null);

(statearr_46649_49359[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (41))){
var inst_46535 = (state_46578[(23)]);
var inst_46551 = (state_46578[(2)]);
var inst_46552 = cljs.core.next(inst_46535);
var inst_46512 = inst_46552;
var inst_46513 = null;
var inst_46514 = (0);
var inst_46515 = (0);
var state_46578__$1 = (function (){var statearr_46650 = state_46578;
(statearr_46650[(9)] = inst_46513);

(statearr_46650[(19)] = inst_46512);

(statearr_46650[(20)] = inst_46514);

(statearr_46650[(25)] = inst_46551);

(statearr_46650[(12)] = inst_46515);

return statearr_46650;
})();
var statearr_46657_49379 = state_46578__$1;
(statearr_46657_49379[(2)] = null);

(statearr_46657_49379[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (43))){
var state_46578__$1 = state_46578;
var statearr_46658_49383 = state_46578__$1;
(statearr_46658_49383[(2)] = null);

(statearr_46658_49383[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (29))){
var inst_46562 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46660_49391 = state_46578__$1;
(statearr_46660_49391[(2)] = inst_46562);

(statearr_46660_49391[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (44))){
var inst_46571 = (state_46578[(2)]);
var state_46578__$1 = (function (){var statearr_46661 = state_46578;
(statearr_46661[(26)] = inst_46571);

return statearr_46661;
})();
var statearr_46662_49396 = state_46578__$1;
(statearr_46662_49396[(2)] = null);

(statearr_46662_49396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (6))){
var inst_46504 = (state_46578[(27)]);
var inst_46503 = cljs.core.deref(cs);
var inst_46504__$1 = cljs.core.keys(inst_46503);
var inst_46505 = cljs.core.count(inst_46504__$1);
var inst_46506 = cljs.core.reset_BANG_(dctr,inst_46505);
var inst_46511 = cljs.core.seq(inst_46504__$1);
var inst_46512 = inst_46511;
var inst_46513 = null;
var inst_46514 = (0);
var inst_46515 = (0);
var state_46578__$1 = (function (){var statearr_46663 = state_46578;
(statearr_46663[(9)] = inst_46513);

(statearr_46663[(19)] = inst_46512);

(statearr_46663[(27)] = inst_46504__$1);

(statearr_46663[(28)] = inst_46506);

(statearr_46663[(20)] = inst_46514);

(statearr_46663[(12)] = inst_46515);

return statearr_46663;
})();
var statearr_46664_49400 = state_46578__$1;
(statearr_46664_49400[(2)] = null);

(statearr_46664_49400[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (28))){
var inst_46512 = (state_46578[(19)]);
var inst_46535 = (state_46578[(23)]);
var inst_46535__$1 = cljs.core.seq(inst_46512);
var state_46578__$1 = (function (){var statearr_46669 = state_46578;
(statearr_46669[(23)] = inst_46535__$1);

return statearr_46669;
})();
if(inst_46535__$1){
var statearr_46672_49407 = state_46578__$1;
(statearr_46672_49407[(1)] = (33));

} else {
var statearr_46673_49409 = state_46578__$1;
(statearr_46673_49409[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (25))){
var inst_46514 = (state_46578[(20)]);
var inst_46515 = (state_46578[(12)]);
var inst_46517 = (inst_46515 < inst_46514);
var inst_46518 = inst_46517;
var state_46578__$1 = state_46578;
if(cljs.core.truth_(inst_46518)){
var statearr_46679_49412 = state_46578__$1;
(statearr_46679_49412[(1)] = (27));

} else {
var statearr_46680_49413 = state_46578__$1;
(statearr_46680_49413[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (34))){
var state_46578__$1 = state_46578;
var statearr_46682_49422 = state_46578__$1;
(statearr_46682_49422[(2)] = null);

(statearr_46682_49422[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (17))){
var state_46578__$1 = state_46578;
var statearr_46683_49429 = state_46578__$1;
(statearr_46683_49429[(2)] = null);

(statearr_46683_49429[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (3))){
var inst_46576 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46578__$1,inst_46576);
} else {
if((state_val_46579 === (12))){
var inst_46499 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46684_49439 = state_46578__$1;
(statearr_46684_49439[(2)] = inst_46499);

(statearr_46684_49439[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (2))){
var state_46578__$1 = state_46578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46578__$1,(4),ch);
} else {
if((state_val_46579 === (23))){
var state_46578__$1 = state_46578;
var statearr_46685_49447 = state_46578__$1;
(statearr_46685_49447[(2)] = null);

(statearr_46685_49447[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (35))){
var inst_46560 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46687_49462 = state_46578__$1;
(statearr_46687_49462[(2)] = inst_46560);

(statearr_46687_49462[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (19))){
var inst_46468 = (state_46578[(7)]);
var inst_46475 = cljs.core.chunk_first(inst_46468);
var inst_46476 = cljs.core.chunk_rest(inst_46468);
var inst_46477 = cljs.core.count(inst_46475);
var inst_46442 = inst_46476;
var inst_46443 = inst_46475;
var inst_46444 = inst_46477;
var inst_46445 = (0);
var state_46578__$1 = (function (){var statearr_46689 = state_46578;
(statearr_46689[(13)] = inst_46445);

(statearr_46689[(15)] = inst_46444);

(statearr_46689[(16)] = inst_46443);

(statearr_46689[(17)] = inst_46442);

return statearr_46689;
})();
var statearr_46690_49469 = state_46578__$1;
(statearr_46690_49469[(2)] = null);

(statearr_46690_49469[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (11))){
var inst_46442 = (state_46578[(17)]);
var inst_46468 = (state_46578[(7)]);
var inst_46468__$1 = cljs.core.seq(inst_46442);
var state_46578__$1 = (function (){var statearr_46691 = state_46578;
(statearr_46691[(7)] = inst_46468__$1);

return statearr_46691;
})();
if(inst_46468__$1){
var statearr_46692_49473 = state_46578__$1;
(statearr_46692_49473[(1)] = (16));

} else {
var statearr_46693_49474 = state_46578__$1;
(statearr_46693_49474[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (9))){
var inst_46501 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46694_49477 = state_46578__$1;
(statearr_46694_49477[(2)] = inst_46501);

(statearr_46694_49477[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (5))){
var inst_46440 = cljs.core.deref(cs);
var inst_46441 = cljs.core.seq(inst_46440);
var inst_46442 = inst_46441;
var inst_46443 = null;
var inst_46444 = (0);
var inst_46445 = (0);
var state_46578__$1 = (function (){var statearr_46695 = state_46578;
(statearr_46695[(13)] = inst_46445);

(statearr_46695[(15)] = inst_46444);

(statearr_46695[(16)] = inst_46443);

(statearr_46695[(17)] = inst_46442);

return statearr_46695;
})();
var statearr_46696_49484 = state_46578__$1;
(statearr_46696_49484[(2)] = null);

(statearr_46696_49484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (14))){
var state_46578__$1 = state_46578;
var statearr_46697_49488 = state_46578__$1;
(statearr_46697_49488[(2)] = null);

(statearr_46697_49488[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (45))){
var inst_46568 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46698_49489 = state_46578__$1;
(statearr_46698_49489[(2)] = inst_46568);

(statearr_46698_49489[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (26))){
var inst_46504 = (state_46578[(27)]);
var inst_46564 = (state_46578[(2)]);
var inst_46565 = cljs.core.seq(inst_46504);
var state_46578__$1 = (function (){var statearr_46699 = state_46578;
(statearr_46699[(29)] = inst_46564);

return statearr_46699;
})();
if(inst_46565){
var statearr_46700_49492 = state_46578__$1;
(statearr_46700_49492[(1)] = (42));

} else {
var statearr_46701_49493 = state_46578__$1;
(statearr_46701_49493[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (16))){
var inst_46468 = (state_46578[(7)]);
var inst_46471 = cljs.core.chunked_seq_QMARK_(inst_46468);
var state_46578__$1 = state_46578;
if(inst_46471){
var statearr_46702_49496 = state_46578__$1;
(statearr_46702_49496[(1)] = (19));

} else {
var statearr_46703_49497 = state_46578__$1;
(statearr_46703_49497[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (38))){
var inst_46557 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46704_49498 = state_46578__$1;
(statearr_46704_49498[(2)] = inst_46557);

(statearr_46704_49498[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (30))){
var state_46578__$1 = state_46578;
var statearr_46705_49499 = state_46578__$1;
(statearr_46705_49499[(2)] = null);

(statearr_46705_49499[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (10))){
var inst_46445 = (state_46578[(13)]);
var inst_46443 = (state_46578[(16)]);
var inst_46457 = cljs.core._nth(inst_46443,inst_46445);
var inst_46458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46457,(0),null);
var inst_46459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46457,(1),null);
var state_46578__$1 = (function (){var statearr_46708 = state_46578;
(statearr_46708[(24)] = inst_46458);

return statearr_46708;
})();
if(cljs.core.truth_(inst_46459)){
var statearr_46709_49505 = state_46578__$1;
(statearr_46709_49505[(1)] = (13));

} else {
var statearr_46712_49506 = state_46578__$1;
(statearr_46712_49506[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (18))){
var inst_46497 = (state_46578[(2)]);
var state_46578__$1 = state_46578;
var statearr_46713_49508 = state_46578__$1;
(statearr_46713_49508[(2)] = inst_46497);

(statearr_46713_49508[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (42))){
var state_46578__$1 = state_46578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46578__$1,(45),dchan);
} else {
if((state_val_46579 === (37))){
var inst_46545 = (state_46578[(22)]);
var inst_46433 = (state_46578[(11)]);
var inst_46535 = (state_46578[(23)]);
var inst_46545__$1 = cljs.core.first(inst_46535);
var inst_46546 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46545__$1,inst_46433,done);
var state_46578__$1 = (function (){var statearr_46714 = state_46578;
(statearr_46714[(22)] = inst_46545__$1);

return statearr_46714;
})();
if(cljs.core.truth_(inst_46546)){
var statearr_46715_49512 = state_46578__$1;
(statearr_46715_49512[(1)] = (39));

} else {
var statearr_46716_49513 = state_46578__$1;
(statearr_46716_49513[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46579 === (8))){
var inst_46445 = (state_46578[(13)]);
var inst_46444 = (state_46578[(15)]);
var inst_46448 = (inst_46445 < inst_46444);
var inst_46449 = inst_46448;
var state_46578__$1 = state_46578;
if(cljs.core.truth_(inst_46449)){
var statearr_46717_49516 = state_46578__$1;
(statearr_46717_49516[(1)] = (10));

} else {
var statearr_46718_49517 = state_46578__$1;
(statearr_46718_49517[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__44935__auto__ = null;
var cljs$core$async$mult_$_state_machine__44935__auto____0 = (function (){
var statearr_46722 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46722[(0)] = cljs$core$async$mult_$_state_machine__44935__auto__);

(statearr_46722[(1)] = (1));

return statearr_46722;
});
var cljs$core$async$mult_$_state_machine__44935__auto____1 = (function (state_46578){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_46578);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e46723){var ex__44939__auto__ = e46723;
var statearr_46724_49521 = state_46578;
(statearr_46724_49521[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_46578[(4)]))){
var statearr_46725_49523 = state_46578;
(statearr_46725_49523[(1)] = cljs.core.first((state_46578[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49530 = state_46578;
state_46578 = G__49530;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__44935__auto__ = function(state_46578){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__44935__auto____1.call(this,state_46578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__44935__auto____0;
cljs$core$async$mult_$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__44935__auto____1;
return cljs$core$async$mult_$_state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_46727 = f__45033__auto__();
(statearr_46727[(6)] = c__45032__auto___49285);

return statearr_46727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__46729 = arguments.length;
switch (G__46729) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_49549 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_49549(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_49550 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_49550(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_49553 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_49553(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_49554 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_49554(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_49558 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_49558(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___49567 = arguments.length;
var i__4737__auto___49568 = (0);
while(true){
if((i__4737__auto___49568 < len__4736__auto___49567)){
args__4742__auto__.push((arguments[i__4737__auto___49568]));

var G__49569 = (i__4737__auto___49568 + (1));
i__4737__auto___49568 = G__49569;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__46806){
var map__46810 = p__46806;
var map__46810__$1 = (((((!((map__46810 == null))))?(((((map__46810.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46810.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46810):map__46810);
var opts = map__46810__$1;
var statearr_46816_49575 = state;
(statearr_46816_49575[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_46817_49576 = state;
(statearr_46817_49576[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_46818_49578 = state;
(statearr_46818_49578[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq46799){
var G__46800 = cljs.core.first(seq46799);
var seq46799__$1 = cljs.core.next(seq46799);
var G__46801 = cljs.core.first(seq46799__$1);
var seq46799__$2 = cljs.core.next(seq46799__$1);
var G__46802 = cljs.core.first(seq46799__$2);
var seq46799__$3 = cljs.core.next(seq46799__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46800,G__46801,G__46802,seq46799__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46832 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46832 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta46833){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta46833 = meta46833;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46834,meta46833__$1){
var self__ = this;
var _46834__$1 = this;
return (new cljs.core.async.t_cljs$core$async46832(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta46833__$1));
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46834){
var self__ = this;
var _46834__$1 = this;
return self__.meta46833;
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46832.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta46833","meta46833",-1829149481,null)], null);
}));

(cljs.core.async.t_cljs$core$async46832.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46832.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46832");

(cljs.core.async.t_cljs$core$async46832.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async46832");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46832.
 */
cljs.core.async.__GT_t_cljs$core$async46832 = (function cljs$core$async$mix_$___GT_t_cljs$core$async46832(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46833){
return (new cljs.core.async.t_cljs$core$async46832(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46833));
});

}

return (new cljs.core.async.t_cljs$core$async46832(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45032__auto___49632 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_46962){
var state_val_46963 = (state_46962[(1)]);
if((state_val_46963 === (7))){
var inst_46864 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
var statearr_46973_49646 = state_46962__$1;
(statearr_46973_49646[(2)] = inst_46864);

(statearr_46973_49646[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (20))){
var inst_46876 = (state_46962[(7)]);
var state_46962__$1 = state_46962;
var statearr_46974_49655 = state_46962__$1;
(statearr_46974_49655[(2)] = inst_46876);

(statearr_46974_49655[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (27))){
var state_46962__$1 = state_46962;
var statearr_46975_49658 = state_46962__$1;
(statearr_46975_49658[(2)] = null);

(statearr_46975_49658[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (1))){
var inst_46851 = (state_46962[(8)]);
var inst_46851__$1 = calc_state();
var inst_46853 = (inst_46851__$1 == null);
var inst_46854 = cljs.core.not(inst_46853);
var state_46962__$1 = (function (){var statearr_46979 = state_46962;
(statearr_46979[(8)] = inst_46851__$1);

return statearr_46979;
})();
if(inst_46854){
var statearr_46980_49668 = state_46962__$1;
(statearr_46980_49668[(1)] = (2));

} else {
var statearr_46981_49669 = state_46962__$1;
(statearr_46981_49669[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (24))){
var inst_46925 = (state_46962[(9)]);
var inst_46909 = (state_46962[(10)]);
var inst_46900 = (state_46962[(11)]);
var inst_46925__$1 = (inst_46900.cljs$core$IFn$_invoke$arity$1 ? inst_46900.cljs$core$IFn$_invoke$arity$1(inst_46909) : inst_46900.call(null,inst_46909));
var state_46962__$1 = (function (){var statearr_46985 = state_46962;
(statearr_46985[(9)] = inst_46925__$1);

return statearr_46985;
})();
if(cljs.core.truth_(inst_46925__$1)){
var statearr_46986_49670 = state_46962__$1;
(statearr_46986_49670[(1)] = (29));

} else {
var statearr_46987_49671 = state_46962__$1;
(statearr_46987_49671[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (4))){
var inst_46867 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
if(cljs.core.truth_(inst_46867)){
var statearr_46994_49672 = state_46962__$1;
(statearr_46994_49672[(1)] = (8));

} else {
var statearr_46995_49674 = state_46962__$1;
(statearr_46995_49674[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (15))){
var inst_46894 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
if(cljs.core.truth_(inst_46894)){
var statearr_46998_49676 = state_46962__$1;
(statearr_46998_49676[(1)] = (19));

} else {
var statearr_46999_49677 = state_46962__$1;
(statearr_46999_49677[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (21))){
var inst_46899 = (state_46962[(12)]);
var inst_46899__$1 = (state_46962[(2)]);
var inst_46900 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46899__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46901 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46899__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46902 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46899__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_46962__$1 = (function (){var statearr_47009 = state_46962;
(statearr_47009[(13)] = inst_46901);

(statearr_47009[(12)] = inst_46899__$1);

(statearr_47009[(11)] = inst_46900);

return statearr_47009;
})();
return cljs.core.async.ioc_alts_BANG_(state_46962__$1,(22),inst_46902);
} else {
if((state_val_46963 === (31))){
var inst_46940 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
if(cljs.core.truth_(inst_46940)){
var statearr_47015_49688 = state_46962__$1;
(statearr_47015_49688[(1)] = (32));

} else {
var statearr_47016_49694 = state_46962__$1;
(statearr_47016_49694[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (32))){
var inst_46908 = (state_46962[(14)]);
var state_46962__$1 = state_46962;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46962__$1,(35),out,inst_46908);
} else {
if((state_val_46963 === (33))){
var inst_46899 = (state_46962[(12)]);
var inst_46876 = inst_46899;
var state_46962__$1 = (function (){var statearr_47024 = state_46962;
(statearr_47024[(7)] = inst_46876);

return statearr_47024;
})();
var statearr_47028_49699 = state_46962__$1;
(statearr_47028_49699[(2)] = null);

(statearr_47028_49699[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (13))){
var inst_46876 = (state_46962[(7)]);
var inst_46883 = inst_46876.cljs$lang$protocol_mask$partition0$;
var inst_46884 = (inst_46883 & (64));
var inst_46885 = inst_46876.cljs$core$ISeq$;
var inst_46886 = (cljs.core.PROTOCOL_SENTINEL === inst_46885);
var inst_46887 = ((inst_46884) || (inst_46886));
var state_46962__$1 = state_46962;
if(cljs.core.truth_(inst_46887)){
var statearr_47038_49709 = state_46962__$1;
(statearr_47038_49709[(1)] = (16));

} else {
var statearr_47039_49711 = state_46962__$1;
(statearr_47039_49711[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (22))){
var inst_46909 = (state_46962[(10)]);
var inst_46908 = (state_46962[(14)]);
var inst_46907 = (state_46962[(2)]);
var inst_46908__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46907,(0),null);
var inst_46909__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46907,(1),null);
var inst_46911 = (inst_46908__$1 == null);
var inst_46912 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46909__$1,change);
var inst_46913 = ((inst_46911) || (inst_46912));
var state_46962__$1 = (function (){var statearr_47043 = state_46962;
(statearr_47043[(10)] = inst_46909__$1);

(statearr_47043[(14)] = inst_46908__$1);

return statearr_47043;
})();
if(cljs.core.truth_(inst_46913)){
var statearr_47045_49727 = state_46962__$1;
(statearr_47045_49727[(1)] = (23));

} else {
var statearr_47047_49730 = state_46962__$1;
(statearr_47047_49730[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (36))){
var inst_46899 = (state_46962[(12)]);
var inst_46876 = inst_46899;
var state_46962__$1 = (function (){var statearr_47049 = state_46962;
(statearr_47049[(7)] = inst_46876);

return statearr_47049;
})();
var statearr_47050_49732 = state_46962__$1;
(statearr_47050_49732[(2)] = null);

(statearr_47050_49732[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (29))){
var inst_46925 = (state_46962[(9)]);
var state_46962__$1 = state_46962;
var statearr_47051_49734 = state_46962__$1;
(statearr_47051_49734[(2)] = inst_46925);

(statearr_47051_49734[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (6))){
var state_46962__$1 = state_46962;
var statearr_47052_49747 = state_46962__$1;
(statearr_47052_49747[(2)] = false);

(statearr_47052_49747[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (28))){
var inst_46921 = (state_46962[(2)]);
var inst_46922 = calc_state();
var inst_46876 = inst_46922;
var state_46962__$1 = (function (){var statearr_47054 = state_46962;
(statearr_47054[(7)] = inst_46876);

(statearr_47054[(15)] = inst_46921);

return statearr_47054;
})();
var statearr_47055_49752 = state_46962__$1;
(statearr_47055_49752[(2)] = null);

(statearr_47055_49752[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (25))){
var inst_46954 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
var statearr_47056_49758 = state_46962__$1;
(statearr_47056_49758[(2)] = inst_46954);

(statearr_47056_49758[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (34))){
var inst_46952 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
var statearr_47058_49760 = state_46962__$1;
(statearr_47058_49760[(2)] = inst_46952);

(statearr_47058_49760[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (17))){
var state_46962__$1 = state_46962;
var statearr_47059_49761 = state_46962__$1;
(statearr_47059_49761[(2)] = false);

(statearr_47059_49761[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (3))){
var state_46962__$1 = state_46962;
var statearr_47060_49762 = state_46962__$1;
(statearr_47060_49762[(2)] = false);

(statearr_47060_49762[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (12))){
var inst_46956 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46962__$1,inst_46956);
} else {
if((state_val_46963 === (2))){
var inst_46851 = (state_46962[(8)]);
var inst_46856 = inst_46851.cljs$lang$protocol_mask$partition0$;
var inst_46857 = (inst_46856 & (64));
var inst_46858 = inst_46851.cljs$core$ISeq$;
var inst_46859 = (cljs.core.PROTOCOL_SENTINEL === inst_46858);
var inst_46860 = ((inst_46857) || (inst_46859));
var state_46962__$1 = state_46962;
if(cljs.core.truth_(inst_46860)){
var statearr_47061_49764 = state_46962__$1;
(statearr_47061_49764[(1)] = (5));

} else {
var statearr_47062_49765 = state_46962__$1;
(statearr_47062_49765[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (23))){
var inst_46908 = (state_46962[(14)]);
var inst_46915 = (inst_46908 == null);
var state_46962__$1 = state_46962;
if(cljs.core.truth_(inst_46915)){
var statearr_47063_49767 = state_46962__$1;
(statearr_47063_49767[(1)] = (26));

} else {
var statearr_47064_49768 = state_46962__$1;
(statearr_47064_49768[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (35))){
var inst_46943 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
if(cljs.core.truth_(inst_46943)){
var statearr_47065_49773 = state_46962__$1;
(statearr_47065_49773[(1)] = (36));

} else {
var statearr_47066_49774 = state_46962__$1;
(statearr_47066_49774[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (19))){
var inst_46876 = (state_46962[(7)]);
var inst_46896 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_46876);
var state_46962__$1 = state_46962;
var statearr_47071_49775 = state_46962__$1;
(statearr_47071_49775[(2)] = inst_46896);

(statearr_47071_49775[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (11))){
var inst_46876 = (state_46962[(7)]);
var inst_46880 = (inst_46876 == null);
var inst_46881 = cljs.core.not(inst_46880);
var state_46962__$1 = state_46962;
if(inst_46881){
var statearr_47073_49778 = state_46962__$1;
(statearr_47073_49778[(1)] = (13));

} else {
var statearr_47074_49781 = state_46962__$1;
(statearr_47074_49781[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (9))){
var inst_46851 = (state_46962[(8)]);
var state_46962__$1 = state_46962;
var statearr_47075_49785 = state_46962__$1;
(statearr_47075_49785[(2)] = inst_46851);

(statearr_47075_49785[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (5))){
var state_46962__$1 = state_46962;
var statearr_47076_49787 = state_46962__$1;
(statearr_47076_49787[(2)] = true);

(statearr_47076_49787[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (14))){
var state_46962__$1 = state_46962;
var statearr_47077_49789 = state_46962__$1;
(statearr_47077_49789[(2)] = false);

(statearr_47077_49789[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (26))){
var inst_46909 = (state_46962[(10)]);
var inst_46918 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_46909);
var state_46962__$1 = state_46962;
var statearr_47078_49790 = state_46962__$1;
(statearr_47078_49790[(2)] = inst_46918);

(statearr_47078_49790[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (16))){
var state_46962__$1 = state_46962;
var statearr_47079_49791 = state_46962__$1;
(statearr_47079_49791[(2)] = true);

(statearr_47079_49791[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (38))){
var inst_46948 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
var statearr_47080_49795 = state_46962__$1;
(statearr_47080_49795[(2)] = inst_46948);

(statearr_47080_49795[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (30))){
var inst_46909 = (state_46962[(10)]);
var inst_46901 = (state_46962[(13)]);
var inst_46900 = (state_46962[(11)]);
var inst_46932 = cljs.core.empty_QMARK_(inst_46900);
var inst_46933 = (inst_46901.cljs$core$IFn$_invoke$arity$1 ? inst_46901.cljs$core$IFn$_invoke$arity$1(inst_46909) : inst_46901.call(null,inst_46909));
var inst_46934 = cljs.core.not(inst_46933);
var inst_46935 = ((inst_46932) && (inst_46934));
var state_46962__$1 = state_46962;
var statearr_47081_49809 = state_46962__$1;
(statearr_47081_49809[(2)] = inst_46935);

(statearr_47081_49809[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (10))){
var inst_46851 = (state_46962[(8)]);
var inst_46872 = (state_46962[(2)]);
var inst_46873 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46872,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46874 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46872,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46875 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46872,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_46876 = inst_46851;
var state_46962__$1 = (function (){var statearr_47082 = state_46962;
(statearr_47082[(16)] = inst_46875);

(statearr_47082[(7)] = inst_46876);

(statearr_47082[(17)] = inst_46873);

(statearr_47082[(18)] = inst_46874);

return statearr_47082;
})();
var statearr_47083_49832 = state_46962__$1;
(statearr_47083_49832[(2)] = null);

(statearr_47083_49832[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (18))){
var inst_46891 = (state_46962[(2)]);
var state_46962__$1 = state_46962;
var statearr_47084_49839 = state_46962__$1;
(statearr_47084_49839[(2)] = inst_46891);

(statearr_47084_49839[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (37))){
var state_46962__$1 = state_46962;
var statearr_47085_49848 = state_46962__$1;
(statearr_47085_49848[(2)] = null);

(statearr_47085_49848[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46963 === (8))){
var inst_46851 = (state_46962[(8)]);
var inst_46869 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_46851);
var state_46962__$1 = state_46962;
var statearr_47086_49855 = state_46962__$1;
(statearr_47086_49855[(2)] = inst_46869);

(statearr_47086_49855[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__44935__auto__ = null;
var cljs$core$async$mix_$_state_machine__44935__auto____0 = (function (){
var statearr_47087 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47087[(0)] = cljs$core$async$mix_$_state_machine__44935__auto__);

(statearr_47087[(1)] = (1));

return statearr_47087;
});
var cljs$core$async$mix_$_state_machine__44935__auto____1 = (function (state_46962){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_46962);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e47088){var ex__44939__auto__ = e47088;
var statearr_47089_49886 = state_46962;
(statearr_47089_49886[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_46962[(4)]))){
var statearr_47091_49890 = state_46962;
(statearr_47091_49890[(1)] = cljs.core.first((state_46962[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49905 = state_46962;
state_46962 = G__49905;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__44935__auto__ = function(state_46962){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__44935__auto____1.call(this,state_46962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__44935__auto____0;
cljs$core$async$mix_$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__44935__auto____1;
return cljs$core$async$mix_$_state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_47095 = f__45033__auto__();
(statearr_47095[(6)] = c__45032__auto___49632);

return statearr_47095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_49933 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_49933(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_49953 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_49953(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_49983 = (function() {
var G__49984 = null;
var G__49984__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__49984__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__49984 = function(p,v){
switch(arguments.length){
case 1:
return G__49984__1.call(this,p);
case 2:
return G__49984__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__49984.cljs$core$IFn$_invoke$arity$1 = G__49984__1;
G__49984.cljs$core$IFn$_invoke$arity$2 = G__49984__2;
return G__49984;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__47115 = arguments.length;
switch (G__47115) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49983(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49983(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__47125 = arguments.length;
switch (G__47125) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__47122_SHARP_){
if(cljs.core.truth_((p1__47122_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__47122_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__47122_SHARP_.call(null,topic)))){
return p1__47122_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__47122_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47141 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47141 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta47142){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta47142 = meta47142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47143,meta47142__$1){
var self__ = this;
var _47143__$1 = this;
return (new cljs.core.async.t_cljs$core$async47141(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta47142__$1));
}));

(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47143){
var self__ = this;
var _47143__$1 = this;
return self__.meta47142;
}));

(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async47141.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async47141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta47142","meta47142",1911752005,null)], null);
}));

(cljs.core.async.t_cljs$core$async47141.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47141");

(cljs.core.async.t_cljs$core$async47141.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47141");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47141.
 */
cljs.core.async.__GT_t_cljs$core$async47141 = (function cljs$core$async$__GT_t_cljs$core$async47141(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta47142){
return (new cljs.core.async.t_cljs$core$async47141(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta47142));
});

}

return (new cljs.core.async.t_cljs$core$async47141(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__45032__auto___50199 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_47266){
var state_val_47267 = (state_47266[(1)]);
if((state_val_47267 === (7))){
var inst_47257 = (state_47266[(2)]);
var state_47266__$1 = state_47266;
var statearr_47275_50213 = state_47266__$1;
(statearr_47275_50213[(2)] = inst_47257);

(statearr_47275_50213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (20))){
var state_47266__$1 = state_47266;
var statearr_47278_50222 = state_47266__$1;
(statearr_47278_50222[(2)] = null);

(statearr_47278_50222[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (1))){
var state_47266__$1 = state_47266;
var statearr_47284_50223 = state_47266__$1;
(statearr_47284_50223[(2)] = null);

(statearr_47284_50223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (24))){
var inst_47239 = (state_47266[(7)]);
var inst_47249 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_47239);
var state_47266__$1 = state_47266;
var statearr_47286_50235 = state_47266__$1;
(statearr_47286_50235[(2)] = inst_47249);

(statearr_47286_50235[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (4))){
var inst_47177 = (state_47266[(8)]);
var inst_47177__$1 = (state_47266[(2)]);
var inst_47179 = (inst_47177__$1 == null);
var state_47266__$1 = (function (){var statearr_47289 = state_47266;
(statearr_47289[(8)] = inst_47177__$1);

return statearr_47289;
})();
if(cljs.core.truth_(inst_47179)){
var statearr_47290_50258 = state_47266__$1;
(statearr_47290_50258[(1)] = (5));

} else {
var statearr_47292_50263 = state_47266__$1;
(statearr_47292_50263[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (15))){
var inst_47232 = (state_47266[(2)]);
var state_47266__$1 = state_47266;
var statearr_47293_50265 = state_47266__$1;
(statearr_47293_50265[(2)] = inst_47232);

(statearr_47293_50265[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (21))){
var inst_47254 = (state_47266[(2)]);
var state_47266__$1 = (function (){var statearr_47295 = state_47266;
(statearr_47295[(9)] = inst_47254);

return statearr_47295;
})();
var statearr_47297_50271 = state_47266__$1;
(statearr_47297_50271[(2)] = null);

(statearr_47297_50271[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (13))){
var inst_47208 = (state_47266[(10)]);
var inst_47210 = cljs.core.chunked_seq_QMARK_(inst_47208);
var state_47266__$1 = state_47266;
if(inst_47210){
var statearr_47301_50282 = state_47266__$1;
(statearr_47301_50282[(1)] = (16));

} else {
var statearr_47302_50288 = state_47266__$1;
(statearr_47302_50288[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (22))){
var inst_47246 = (state_47266[(2)]);
var state_47266__$1 = state_47266;
if(cljs.core.truth_(inst_47246)){
var statearr_47303_50295 = state_47266__$1;
(statearr_47303_50295[(1)] = (23));

} else {
var statearr_47304_50303 = state_47266__$1;
(statearr_47304_50303[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (6))){
var inst_47239 = (state_47266[(7)]);
var inst_47242 = (state_47266[(11)]);
var inst_47177 = (state_47266[(8)]);
var inst_47239__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_47177) : topic_fn.call(null,inst_47177));
var inst_47241 = cljs.core.deref(mults);
var inst_47242__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47241,inst_47239__$1);
var state_47266__$1 = (function (){var statearr_47312 = state_47266;
(statearr_47312[(7)] = inst_47239__$1);

(statearr_47312[(11)] = inst_47242__$1);

return statearr_47312;
})();
if(cljs.core.truth_(inst_47242__$1)){
var statearr_47313_50334 = state_47266__$1;
(statearr_47313_50334[(1)] = (19));

} else {
var statearr_47314_50339 = state_47266__$1;
(statearr_47314_50339[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (25))){
var inst_47251 = (state_47266[(2)]);
var state_47266__$1 = state_47266;
var statearr_47315_50348 = state_47266__$1;
(statearr_47315_50348[(2)] = inst_47251);

(statearr_47315_50348[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (17))){
var inst_47208 = (state_47266[(10)]);
var inst_47221 = cljs.core.first(inst_47208);
var inst_47222 = cljs.core.async.muxch_STAR_(inst_47221);
var inst_47223 = cljs.core.async.close_BANG_(inst_47222);
var inst_47224 = cljs.core.next(inst_47208);
var inst_47188 = inst_47224;
var inst_47189 = null;
var inst_47190 = (0);
var inst_47191 = (0);
var state_47266__$1 = (function (){var statearr_47322 = state_47266;
(statearr_47322[(12)] = inst_47188);

(statearr_47322[(13)] = inst_47190);

(statearr_47322[(14)] = inst_47189);

(statearr_47322[(15)] = inst_47191);

(statearr_47322[(16)] = inst_47223);

return statearr_47322;
})();
var statearr_47330_50386 = state_47266__$1;
(statearr_47330_50386[(2)] = null);

(statearr_47330_50386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (3))){
var inst_47259 = (state_47266[(2)]);
var state_47266__$1 = state_47266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47266__$1,inst_47259);
} else {
if((state_val_47267 === (12))){
var inst_47234 = (state_47266[(2)]);
var state_47266__$1 = state_47266;
var statearr_47339_50403 = state_47266__$1;
(statearr_47339_50403[(2)] = inst_47234);

(statearr_47339_50403[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (2))){
var state_47266__$1 = state_47266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47266__$1,(4),ch);
} else {
if((state_val_47267 === (23))){
var state_47266__$1 = state_47266;
var statearr_47345_50417 = state_47266__$1;
(statearr_47345_50417[(2)] = null);

(statearr_47345_50417[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (19))){
var inst_47242 = (state_47266[(11)]);
var inst_47177 = (state_47266[(8)]);
var inst_47244 = cljs.core.async.muxch_STAR_(inst_47242);
var state_47266__$1 = state_47266;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47266__$1,(22),inst_47244,inst_47177);
} else {
if((state_val_47267 === (11))){
var inst_47188 = (state_47266[(12)]);
var inst_47208 = (state_47266[(10)]);
var inst_47208__$1 = cljs.core.seq(inst_47188);
var state_47266__$1 = (function (){var statearr_47350 = state_47266;
(statearr_47350[(10)] = inst_47208__$1);

return statearr_47350;
})();
if(inst_47208__$1){
var statearr_47351_50452 = state_47266__$1;
(statearr_47351_50452[(1)] = (13));

} else {
var statearr_47352_50458 = state_47266__$1;
(statearr_47352_50458[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (9))){
var inst_47236 = (state_47266[(2)]);
var state_47266__$1 = state_47266;
var statearr_47353_50472 = state_47266__$1;
(statearr_47353_50472[(2)] = inst_47236);

(statearr_47353_50472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (5))){
var inst_47185 = cljs.core.deref(mults);
var inst_47186 = cljs.core.vals(inst_47185);
var inst_47187 = cljs.core.seq(inst_47186);
var inst_47188 = inst_47187;
var inst_47189 = null;
var inst_47190 = (0);
var inst_47191 = (0);
var state_47266__$1 = (function (){var statearr_47357 = state_47266;
(statearr_47357[(12)] = inst_47188);

(statearr_47357[(13)] = inst_47190);

(statearr_47357[(14)] = inst_47189);

(statearr_47357[(15)] = inst_47191);

return statearr_47357;
})();
var statearr_47358_50485 = state_47266__$1;
(statearr_47358_50485[(2)] = null);

(statearr_47358_50485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (14))){
var state_47266__$1 = state_47266;
var statearr_47363_50492 = state_47266__$1;
(statearr_47363_50492[(2)] = null);

(statearr_47363_50492[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (16))){
var inst_47208 = (state_47266[(10)]);
var inst_47213 = cljs.core.chunk_first(inst_47208);
var inst_47214 = cljs.core.chunk_rest(inst_47208);
var inst_47215 = cljs.core.count(inst_47213);
var inst_47188 = inst_47214;
var inst_47189 = inst_47213;
var inst_47190 = inst_47215;
var inst_47191 = (0);
var state_47266__$1 = (function (){var statearr_47369 = state_47266;
(statearr_47369[(12)] = inst_47188);

(statearr_47369[(13)] = inst_47190);

(statearr_47369[(14)] = inst_47189);

(statearr_47369[(15)] = inst_47191);

return statearr_47369;
})();
var statearr_47375_50515 = state_47266__$1;
(statearr_47375_50515[(2)] = null);

(statearr_47375_50515[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (10))){
var inst_47188 = (state_47266[(12)]);
var inst_47190 = (state_47266[(13)]);
var inst_47189 = (state_47266[(14)]);
var inst_47191 = (state_47266[(15)]);
var inst_47199 = cljs.core._nth(inst_47189,inst_47191);
var inst_47200 = cljs.core.async.muxch_STAR_(inst_47199);
var inst_47201 = cljs.core.async.close_BANG_(inst_47200);
var inst_47202 = (inst_47191 + (1));
var tmp47359 = inst_47188;
var tmp47360 = inst_47190;
var tmp47361 = inst_47189;
var inst_47188__$1 = tmp47359;
var inst_47189__$1 = tmp47361;
var inst_47190__$1 = tmp47360;
var inst_47191__$1 = inst_47202;
var state_47266__$1 = (function (){var statearr_47393 = state_47266;
(statearr_47393[(17)] = inst_47201);

(statearr_47393[(12)] = inst_47188__$1);

(statearr_47393[(13)] = inst_47190__$1);

(statearr_47393[(14)] = inst_47189__$1);

(statearr_47393[(15)] = inst_47191__$1);

return statearr_47393;
})();
var statearr_47401_50543 = state_47266__$1;
(statearr_47401_50543[(2)] = null);

(statearr_47401_50543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (18))){
var inst_47227 = (state_47266[(2)]);
var state_47266__$1 = state_47266;
var statearr_47404_50554 = state_47266__$1;
(statearr_47404_50554[(2)] = inst_47227);

(statearr_47404_50554[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47267 === (8))){
var inst_47190 = (state_47266[(13)]);
var inst_47191 = (state_47266[(15)]);
var inst_47195 = (inst_47191 < inst_47190);
var inst_47196 = inst_47195;
var state_47266__$1 = state_47266;
if(cljs.core.truth_(inst_47196)){
var statearr_47408_50567 = state_47266__$1;
(statearr_47408_50567[(1)] = (10));

} else {
var statearr_47412_50570 = state_47266__$1;
(statearr_47412_50570[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_47425 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47425[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_47425[(1)] = (1));

return statearr_47425;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_47266){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_47266);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e47431){var ex__44939__auto__ = e47431;
var statearr_47436_50588 = state_47266;
(statearr_47436_50588[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_47266[(4)]))){
var statearr_47438_50591 = state_47266;
(statearr_47438_50591[(1)] = cljs.core.first((state_47266[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50613 = state_47266;
state_47266 = G__50613;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_47266){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_47266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_47452 = f__45033__auto__();
(statearr_47452[(6)] = c__45032__auto___50199);

return statearr_47452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__47460 = arguments.length;
switch (G__47460) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__47472 = arguments.length;
switch (G__47472) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__47487 = arguments.length;
switch (G__47487) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__45032__auto___50765 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_47558){
var state_val_47559 = (state_47558[(1)]);
if((state_val_47559 === (7))){
var state_47558__$1 = state_47558;
var statearr_47567_50776 = state_47558__$1;
(statearr_47567_50776[(2)] = null);

(statearr_47567_50776[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (1))){
var state_47558__$1 = state_47558;
var statearr_47570_50791 = state_47558__$1;
(statearr_47570_50791[(2)] = null);

(statearr_47570_50791[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (4))){
var inst_47496 = (state_47558[(7)]);
var inst_47497 = (state_47558[(8)]);
var inst_47501 = (inst_47497 < inst_47496);
var state_47558__$1 = state_47558;
if(cljs.core.truth_(inst_47501)){
var statearr_47573_50794 = state_47558__$1;
(statearr_47573_50794[(1)] = (6));

} else {
var statearr_47576_50796 = state_47558__$1;
(statearr_47576_50796[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (15))){
var inst_47539 = (state_47558[(9)]);
var inst_47544 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_47539);
var state_47558__$1 = state_47558;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47558__$1,(17),out,inst_47544);
} else {
if((state_val_47559 === (13))){
var inst_47539 = (state_47558[(9)]);
var inst_47539__$1 = (state_47558[(2)]);
var inst_47540 = cljs.core.some(cljs.core.nil_QMARK_,inst_47539__$1);
var state_47558__$1 = (function (){var statearr_47582 = state_47558;
(statearr_47582[(9)] = inst_47539__$1);

return statearr_47582;
})();
if(cljs.core.truth_(inst_47540)){
var statearr_47585_50813 = state_47558__$1;
(statearr_47585_50813[(1)] = (14));

} else {
var statearr_47586_50814 = state_47558__$1;
(statearr_47586_50814[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (6))){
var state_47558__$1 = state_47558;
var statearr_47591_50815 = state_47558__$1;
(statearr_47591_50815[(2)] = null);

(statearr_47591_50815[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (17))){
var inst_47546 = (state_47558[(2)]);
var state_47558__$1 = (function (){var statearr_47607 = state_47558;
(statearr_47607[(10)] = inst_47546);

return statearr_47607;
})();
var statearr_47609_50830 = state_47558__$1;
(statearr_47609_50830[(2)] = null);

(statearr_47609_50830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (3))){
var inst_47551 = (state_47558[(2)]);
var state_47558__$1 = state_47558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47558__$1,inst_47551);
} else {
if((state_val_47559 === (12))){
var _ = (function (){var statearr_47613 = state_47558;
(statearr_47613[(4)] = cljs.core.rest((state_47558[(4)])));

return statearr_47613;
})();
var state_47558__$1 = state_47558;
var ex47601 = (state_47558__$1[(2)]);
var statearr_47615_50840 = state_47558__$1;
(statearr_47615_50840[(5)] = ex47601);


if((ex47601 instanceof Object)){
var statearr_47617_50841 = state_47558__$1;
(statearr_47617_50841[(1)] = (11));

(statearr_47617_50841[(5)] = null);

} else {
throw ex47601;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (2))){
var inst_47495 = cljs.core.reset_BANG_(dctr,cnt);
var inst_47496 = cnt;
var inst_47497 = (0);
var state_47558__$1 = (function (){var statearr_47628 = state_47558;
(statearr_47628[(7)] = inst_47496);

(statearr_47628[(8)] = inst_47497);

(statearr_47628[(11)] = inst_47495);

return statearr_47628;
})();
var statearr_47632_50848 = state_47558__$1;
(statearr_47632_50848[(2)] = null);

(statearr_47632_50848[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (11))){
var inst_47512 = (state_47558[(2)]);
var inst_47513 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_47558__$1 = (function (){var statearr_47641 = state_47558;
(statearr_47641[(12)] = inst_47512);

return statearr_47641;
})();
var statearr_47642_50861 = state_47558__$1;
(statearr_47642_50861[(2)] = inst_47513);

(statearr_47642_50861[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (9))){
var inst_47497 = (state_47558[(8)]);
var _ = (function (){var statearr_47644 = state_47558;
(statearr_47644[(4)] = cljs.core.cons((12),(state_47558[(4)])));

return statearr_47644;
})();
var inst_47520 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_47497) : chs__$1.call(null,inst_47497));
var inst_47521 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_47497) : done.call(null,inst_47497));
var inst_47522 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_47520,inst_47521);
var ___$1 = (function (){var statearr_47647 = state_47558;
(statearr_47647[(4)] = cljs.core.rest((state_47558[(4)])));

return statearr_47647;
})();
var state_47558__$1 = state_47558;
var statearr_47649_50880 = state_47558__$1;
(statearr_47649_50880[(2)] = inst_47522);

(statearr_47649_50880[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (5))){
var inst_47533 = (state_47558[(2)]);
var state_47558__$1 = (function (){var statearr_47652 = state_47558;
(statearr_47652[(13)] = inst_47533);

return statearr_47652;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47558__$1,(13),dchan);
} else {
if((state_val_47559 === (14))){
var inst_47542 = cljs.core.async.close_BANG_(out);
var state_47558__$1 = state_47558;
var statearr_47655_50890 = state_47558__$1;
(statearr_47655_50890[(2)] = inst_47542);

(statearr_47655_50890[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (16))){
var inst_47549 = (state_47558[(2)]);
var state_47558__$1 = state_47558;
var statearr_47656_50896 = state_47558__$1;
(statearr_47656_50896[(2)] = inst_47549);

(statearr_47656_50896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (10))){
var inst_47497 = (state_47558[(8)]);
var inst_47525 = (state_47558[(2)]);
var inst_47527 = (inst_47497 + (1));
var inst_47497__$1 = inst_47527;
var state_47558__$1 = (function (){var statearr_47659 = state_47558;
(statearr_47659[(14)] = inst_47525);

(statearr_47659[(8)] = inst_47497__$1);

return statearr_47659;
})();
var statearr_47661_50909 = state_47558__$1;
(statearr_47661_50909[(2)] = null);

(statearr_47661_50909[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47559 === (8))){
var inst_47531 = (state_47558[(2)]);
var state_47558__$1 = state_47558;
var statearr_47662_50919 = state_47558__$1;
(statearr_47662_50919[(2)] = inst_47531);

(statearr_47662_50919[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_47668 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47668[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_47668[(1)] = (1));

return statearr_47668;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_47558){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_47558);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e47675){var ex__44939__auto__ = e47675;
var statearr_47677_50961 = state_47558;
(statearr_47677_50961[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_47558[(4)]))){
var statearr_47680_50968 = state_47558;
(statearr_47680_50968[(1)] = cljs.core.first((state_47558[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50970 = state_47558;
state_47558 = G__50970;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_47558){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_47558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_47683 = f__45033__auto__();
(statearr_47683[(6)] = c__45032__auto___50765);

return statearr_47683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__47700 = arguments.length;
switch (G__47700) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45032__auto___51008 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_47750){
var state_val_47751 = (state_47750[(1)]);
if((state_val_47751 === (7))){
var inst_47723 = (state_47750[(7)]);
var inst_47721 = (state_47750[(8)]);
var inst_47721__$1 = (state_47750[(2)]);
var inst_47723__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47721__$1,(0),null);
var inst_47724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47721__$1,(1),null);
var inst_47726 = (inst_47723__$1 == null);
var state_47750__$1 = (function (){var statearr_47756 = state_47750;
(statearr_47756[(9)] = inst_47724);

(statearr_47756[(7)] = inst_47723__$1);

(statearr_47756[(8)] = inst_47721__$1);

return statearr_47756;
})();
if(cljs.core.truth_(inst_47726)){
var statearr_47757_51035 = state_47750__$1;
(statearr_47757_51035[(1)] = (8));

} else {
var statearr_47758_51037 = state_47750__$1;
(statearr_47758_51037[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47751 === (1))){
var inst_47708 = cljs.core.vec(chs);
var inst_47709 = inst_47708;
var state_47750__$1 = (function (){var statearr_47764 = state_47750;
(statearr_47764[(10)] = inst_47709);

return statearr_47764;
})();
var statearr_47765_51052 = state_47750__$1;
(statearr_47765_51052[(2)] = null);

(statearr_47765_51052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47751 === (4))){
var inst_47709 = (state_47750[(10)]);
var state_47750__$1 = state_47750;
return cljs.core.async.ioc_alts_BANG_(state_47750__$1,(7),inst_47709);
} else {
if((state_val_47751 === (6))){
var inst_47745 = (state_47750[(2)]);
var state_47750__$1 = state_47750;
var statearr_47766_51073 = state_47750__$1;
(statearr_47766_51073[(2)] = inst_47745);

(statearr_47766_51073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47751 === (3))){
var inst_47747 = (state_47750[(2)]);
var state_47750__$1 = state_47750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47750__$1,inst_47747);
} else {
if((state_val_47751 === (2))){
var inst_47709 = (state_47750[(10)]);
var inst_47711 = cljs.core.count(inst_47709);
var inst_47712 = (inst_47711 > (0));
var state_47750__$1 = state_47750;
if(cljs.core.truth_(inst_47712)){
var statearr_47772_51085 = state_47750__$1;
(statearr_47772_51085[(1)] = (4));

} else {
var statearr_47774_51087 = state_47750__$1;
(statearr_47774_51087[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47751 === (11))){
var inst_47709 = (state_47750[(10)]);
var inst_47738 = (state_47750[(2)]);
var tmp47767 = inst_47709;
var inst_47709__$1 = tmp47767;
var state_47750__$1 = (function (){var statearr_47775 = state_47750;
(statearr_47775[(11)] = inst_47738);

(statearr_47775[(10)] = inst_47709__$1);

return statearr_47775;
})();
var statearr_47777_51100 = state_47750__$1;
(statearr_47777_51100[(2)] = null);

(statearr_47777_51100[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47751 === (9))){
var inst_47723 = (state_47750[(7)]);
var state_47750__$1 = state_47750;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47750__$1,(11),out,inst_47723);
} else {
if((state_val_47751 === (5))){
var inst_47743 = cljs.core.async.close_BANG_(out);
var state_47750__$1 = state_47750;
var statearr_47782_51111 = state_47750__$1;
(statearr_47782_51111[(2)] = inst_47743);

(statearr_47782_51111[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47751 === (10))){
var inst_47741 = (state_47750[(2)]);
var state_47750__$1 = state_47750;
var statearr_47785_51113 = state_47750__$1;
(statearr_47785_51113[(2)] = inst_47741);

(statearr_47785_51113[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47751 === (8))){
var inst_47724 = (state_47750[(9)]);
var inst_47723 = (state_47750[(7)]);
var inst_47721 = (state_47750[(8)]);
var inst_47709 = (state_47750[(10)]);
var inst_47733 = (function (){var cs = inst_47709;
var vec__47717 = inst_47721;
var v = inst_47723;
var c = inst_47724;
return (function (p1__47688_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__47688_SHARP_);
});
})();
var inst_47734 = cljs.core.filterv(inst_47733,inst_47709);
var inst_47709__$1 = inst_47734;
var state_47750__$1 = (function (){var statearr_47793 = state_47750;
(statearr_47793[(10)] = inst_47709__$1);

return statearr_47793;
})();
var statearr_47794_51128 = state_47750__$1;
(statearr_47794_51128[(2)] = null);

(statearr_47794_51128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_47796 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47796[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_47796[(1)] = (1));

return statearr_47796;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_47750){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_47750);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e47799){var ex__44939__auto__ = e47799;
var statearr_47800_51143 = state_47750;
(statearr_47800_51143[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_47750[(4)]))){
var statearr_47805_51147 = state_47750;
(statearr_47805_51147[(1)] = cljs.core.first((state_47750[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51153 = state_47750;
state_47750 = G__51153;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_47750){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_47750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_47822 = f__45033__auto__();
(statearr_47822[(6)] = c__45032__auto___51008);

return statearr_47822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__47843 = arguments.length;
switch (G__47843) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45032__auto___51173 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_47877){
var state_val_47878 = (state_47877[(1)]);
if((state_val_47878 === (7))){
var inst_47856 = (state_47877[(7)]);
var inst_47856__$1 = (state_47877[(2)]);
var inst_47858 = (inst_47856__$1 == null);
var inst_47859 = cljs.core.not(inst_47858);
var state_47877__$1 = (function (){var statearr_47886 = state_47877;
(statearr_47886[(7)] = inst_47856__$1);

return statearr_47886;
})();
if(inst_47859){
var statearr_47888_51179 = state_47877__$1;
(statearr_47888_51179[(1)] = (8));

} else {
var statearr_47889_51181 = state_47877__$1;
(statearr_47889_51181[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47878 === (1))){
var inst_47851 = (0);
var state_47877__$1 = (function (){var statearr_47890 = state_47877;
(statearr_47890[(8)] = inst_47851);

return statearr_47890;
})();
var statearr_47891_51186 = state_47877__$1;
(statearr_47891_51186[(2)] = null);

(statearr_47891_51186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47878 === (4))){
var state_47877__$1 = state_47877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47877__$1,(7),ch);
} else {
if((state_val_47878 === (6))){
var inst_47870 = (state_47877[(2)]);
var state_47877__$1 = state_47877;
var statearr_47893_51191 = state_47877__$1;
(statearr_47893_51191[(2)] = inst_47870);

(statearr_47893_51191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47878 === (3))){
var inst_47872 = (state_47877[(2)]);
var inst_47874 = cljs.core.async.close_BANG_(out);
var state_47877__$1 = (function (){var statearr_47896 = state_47877;
(statearr_47896[(9)] = inst_47872);

return statearr_47896;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47877__$1,inst_47874);
} else {
if((state_val_47878 === (2))){
var inst_47851 = (state_47877[(8)]);
var inst_47853 = (inst_47851 < n);
var state_47877__$1 = state_47877;
if(cljs.core.truth_(inst_47853)){
var statearr_47899_51198 = state_47877__$1;
(statearr_47899_51198[(1)] = (4));

} else {
var statearr_47900_51199 = state_47877__$1;
(statearr_47900_51199[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47878 === (11))){
var inst_47851 = (state_47877[(8)]);
var inst_47862 = (state_47877[(2)]);
var inst_47863 = (inst_47851 + (1));
var inst_47851__$1 = inst_47863;
var state_47877__$1 = (function (){var statearr_47903 = state_47877;
(statearr_47903[(10)] = inst_47862);

(statearr_47903[(8)] = inst_47851__$1);

return statearr_47903;
})();
var statearr_47904_51205 = state_47877__$1;
(statearr_47904_51205[(2)] = null);

(statearr_47904_51205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47878 === (9))){
var state_47877__$1 = state_47877;
var statearr_47906_51211 = state_47877__$1;
(statearr_47906_51211[(2)] = null);

(statearr_47906_51211[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47878 === (5))){
var state_47877__$1 = state_47877;
var statearr_47907_51214 = state_47877__$1;
(statearr_47907_51214[(2)] = null);

(statearr_47907_51214[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47878 === (10))){
var inst_47867 = (state_47877[(2)]);
var state_47877__$1 = state_47877;
var statearr_47908_51215 = state_47877__$1;
(statearr_47908_51215[(2)] = inst_47867);

(statearr_47908_51215[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47878 === (8))){
var inst_47856 = (state_47877[(7)]);
var state_47877__$1 = state_47877;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47877__$1,(11),out,inst_47856);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_47912 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47912[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_47912[(1)] = (1));

return statearr_47912;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_47877){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_47877);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e47914){var ex__44939__auto__ = e47914;
var statearr_47915_51230 = state_47877;
(statearr_47915_51230[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_47877[(4)]))){
var statearr_47922_51236 = state_47877;
(statearr_47922_51236[(1)] = cljs.core.first((state_47877[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51237 = state_47877;
state_47877 = G__51237;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_47877){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_47877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_47926 = f__45033__auto__();
(statearr_47926[(6)] = c__45032__auto___51173);

return statearr_47926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47931 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47931 = (function (f,ch,meta47932){
this.f = f;
this.ch = ch;
this.meta47932 = meta47932;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47933,meta47932__$1){
var self__ = this;
var _47933__$1 = this;
return (new cljs.core.async.t_cljs$core$async47931(self__.f,self__.ch,meta47932__$1));
}));

(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47933){
var self__ = this;
var _47933__$1 = this;
return self__.meta47932;
}));

(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47945 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47945 = (function (f,ch,meta47932,_,fn1,meta47946){
this.f = f;
this.ch = ch;
this.meta47932 = meta47932;
this._ = _;
this.fn1 = fn1;
this.meta47946 = meta47946;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47947,meta47946__$1){
var self__ = this;
var _47947__$1 = this;
return (new cljs.core.async.t_cljs$core$async47945(self__.f,self__.ch,self__.meta47932,self__._,self__.fn1,meta47946__$1));
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47947){
var self__ = this;
var _47947__$1 = this;
return self__.meta47946;
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47945.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__47927_SHARP_){
var G__47957 = (((p1__47927_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__47927_SHARP_) : self__.f.call(null,p1__47927_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__47957) : f1.call(null,G__47957));
});
}));

(cljs.core.async.t_cljs$core$async47945.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47932","meta47932",1455051474,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async47931","cljs.core.async/t_cljs$core$async47931",1930150510,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta47946","meta47946",-389089895,null)], null);
}));

(cljs.core.async.t_cljs$core$async47945.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47945.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47945");

(cljs.core.async.t_cljs$core$async47945.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47945");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47945.
 */
cljs.core.async.__GT_t_cljs$core$async47945 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47945(f__$1,ch__$1,meta47932__$1,___$2,fn1__$1,meta47946){
return (new cljs.core.async.t_cljs$core$async47945(f__$1,ch__$1,meta47932__$1,___$2,fn1__$1,meta47946));
});

}

return (new cljs.core.async.t_cljs$core$async47945(self__.f,self__.ch,self__.meta47932,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__47967 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__47967) : self__.f.call(null,G__47967));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47931.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async47931.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47932","meta47932",1455051474,null)], null);
}));

(cljs.core.async.t_cljs$core$async47931.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47931.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47931");

(cljs.core.async.t_cljs$core$async47931.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47931");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47931.
 */
cljs.core.async.__GT_t_cljs$core$async47931 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47931(f__$1,ch__$1,meta47932){
return (new cljs.core.async.t_cljs$core$async47931(f__$1,ch__$1,meta47932));
});

}

return (new cljs.core.async.t_cljs$core$async47931(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47983 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47983 = (function (f,ch,meta47984){
this.f = f;
this.ch = ch;
this.meta47984 = meta47984;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47983.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47985,meta47984__$1){
var self__ = this;
var _47985__$1 = this;
return (new cljs.core.async.t_cljs$core$async47983(self__.f,self__.ch,meta47984__$1));
}));

(cljs.core.async.t_cljs$core$async47983.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47985){
var self__ = this;
var _47985__$1 = this;
return self__.meta47984;
}));

(cljs.core.async.t_cljs$core$async47983.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47983.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47983.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47983.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47983.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47983.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async47983.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47984","meta47984",-505229828,null)], null);
}));

(cljs.core.async.t_cljs$core$async47983.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47983.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47983");

(cljs.core.async.t_cljs$core$async47983.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47983");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47983.
 */
cljs.core.async.__GT_t_cljs$core$async47983 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async47983(f__$1,ch__$1,meta47984){
return (new cljs.core.async.t_cljs$core$async47983(f__$1,ch__$1,meta47984));
});

}

return (new cljs.core.async.t_cljs$core$async47983(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47995 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47995 = (function (p,ch,meta47996){
this.p = p;
this.ch = ch;
this.meta47996 = meta47996;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47997,meta47996__$1){
var self__ = this;
var _47997__$1 = this;
return (new cljs.core.async.t_cljs$core$async47995(self__.p,self__.ch,meta47996__$1));
}));

(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47997){
var self__ = this;
var _47997__$1 = this;
return self__.meta47996;
}));

(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47995.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async47995.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47996","meta47996",-921418894,null)], null);
}));

(cljs.core.async.t_cljs$core$async47995.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47995.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47995");

(cljs.core.async.t_cljs$core$async47995.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async47995");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47995.
 */
cljs.core.async.__GT_t_cljs$core$async47995 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async47995(p__$1,ch__$1,meta47996){
return (new cljs.core.async.t_cljs$core$async47995(p__$1,ch__$1,meta47996));
});

}

return (new cljs.core.async.t_cljs$core$async47995(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__48018 = arguments.length;
switch (G__48018) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45032__auto___51345 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_48040){
var state_val_48041 = (state_48040[(1)]);
if((state_val_48041 === (7))){
var inst_48036 = (state_48040[(2)]);
var state_48040__$1 = state_48040;
var statearr_48042_51348 = state_48040__$1;
(statearr_48042_51348[(2)] = inst_48036);

(statearr_48042_51348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48041 === (1))){
var state_48040__$1 = state_48040;
var statearr_48043_51354 = state_48040__$1;
(statearr_48043_51354[(2)] = null);

(statearr_48043_51354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48041 === (4))){
var inst_48021 = (state_48040[(7)]);
var inst_48021__$1 = (state_48040[(2)]);
var inst_48022 = (inst_48021__$1 == null);
var state_48040__$1 = (function (){var statearr_48044 = state_48040;
(statearr_48044[(7)] = inst_48021__$1);

return statearr_48044;
})();
if(cljs.core.truth_(inst_48022)){
var statearr_48046_51358 = state_48040__$1;
(statearr_48046_51358[(1)] = (5));

} else {
var statearr_48047_51360 = state_48040__$1;
(statearr_48047_51360[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48041 === (6))){
var inst_48021 = (state_48040[(7)]);
var inst_48026 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_48021) : p.call(null,inst_48021));
var state_48040__$1 = state_48040;
if(cljs.core.truth_(inst_48026)){
var statearr_48048_51364 = state_48040__$1;
(statearr_48048_51364[(1)] = (8));

} else {
var statearr_48049_51367 = state_48040__$1;
(statearr_48049_51367[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48041 === (3))){
var inst_48038 = (state_48040[(2)]);
var state_48040__$1 = state_48040;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48040__$1,inst_48038);
} else {
if((state_val_48041 === (2))){
var state_48040__$1 = state_48040;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48040__$1,(4),ch);
} else {
if((state_val_48041 === (11))){
var inst_48030 = (state_48040[(2)]);
var state_48040__$1 = state_48040;
var statearr_48054_51373 = state_48040__$1;
(statearr_48054_51373[(2)] = inst_48030);

(statearr_48054_51373[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48041 === (9))){
var state_48040__$1 = state_48040;
var statearr_48055_51377 = state_48040__$1;
(statearr_48055_51377[(2)] = null);

(statearr_48055_51377[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48041 === (5))){
var inst_48024 = cljs.core.async.close_BANG_(out);
var state_48040__$1 = state_48040;
var statearr_48058_51383 = state_48040__$1;
(statearr_48058_51383[(2)] = inst_48024);

(statearr_48058_51383[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48041 === (10))){
var inst_48033 = (state_48040[(2)]);
var state_48040__$1 = (function (){var statearr_48060 = state_48040;
(statearr_48060[(8)] = inst_48033);

return statearr_48060;
})();
var statearr_48061_51385 = state_48040__$1;
(statearr_48061_51385[(2)] = null);

(statearr_48061_51385[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48041 === (8))){
var inst_48021 = (state_48040[(7)]);
var state_48040__$1 = state_48040;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48040__$1,(11),out,inst_48021);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_48062 = [null,null,null,null,null,null,null,null,null];
(statearr_48062[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_48062[(1)] = (1));

return statearr_48062;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_48040){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_48040);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e48063){var ex__44939__auto__ = e48063;
var statearr_48064_51393 = state_48040;
(statearr_48064_51393[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_48040[(4)]))){
var statearr_48065_51394 = state_48040;
(statearr_48065_51394[(1)] = cljs.core.first((state_48040[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51396 = state_48040;
state_48040 = G__51396;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_48040){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_48040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_48067 = f__45033__auto__();
(statearr_48067[(6)] = c__45032__auto___51345);

return statearr_48067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__48073 = arguments.length;
switch (G__48073) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__45032__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_48139){
var state_val_48140 = (state_48139[(1)]);
if((state_val_48140 === (7))){
var inst_48135 = (state_48139[(2)]);
var state_48139__$1 = state_48139;
var statearr_48142_51409 = state_48139__$1;
(statearr_48142_51409[(2)] = inst_48135);

(statearr_48142_51409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (20))){
var inst_48105 = (state_48139[(7)]);
var inst_48116 = (state_48139[(2)]);
var inst_48117 = cljs.core.next(inst_48105);
var inst_48091 = inst_48117;
var inst_48092 = null;
var inst_48093 = (0);
var inst_48094 = (0);
var state_48139__$1 = (function (){var statearr_48149 = state_48139;
(statearr_48149[(8)] = inst_48092);

(statearr_48149[(9)] = inst_48094);

(statearr_48149[(10)] = inst_48116);

(statearr_48149[(11)] = inst_48091);

(statearr_48149[(12)] = inst_48093);

return statearr_48149;
})();
var statearr_48151_51413 = state_48139__$1;
(statearr_48151_51413[(2)] = null);

(statearr_48151_51413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (1))){
var state_48139__$1 = state_48139;
var statearr_48152_51414 = state_48139__$1;
(statearr_48152_51414[(2)] = null);

(statearr_48152_51414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (4))){
var inst_48079 = (state_48139[(13)]);
var inst_48079__$1 = (state_48139[(2)]);
var inst_48081 = (inst_48079__$1 == null);
var state_48139__$1 = (function (){var statearr_48153 = state_48139;
(statearr_48153[(13)] = inst_48079__$1);

return statearr_48153;
})();
if(cljs.core.truth_(inst_48081)){
var statearr_48154_51417 = state_48139__$1;
(statearr_48154_51417[(1)] = (5));

} else {
var statearr_48155_51418 = state_48139__$1;
(statearr_48155_51418[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (15))){
var state_48139__$1 = state_48139;
var statearr_48159_51426 = state_48139__$1;
(statearr_48159_51426[(2)] = null);

(statearr_48159_51426[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (21))){
var state_48139__$1 = state_48139;
var statearr_48160_51428 = state_48139__$1;
(statearr_48160_51428[(2)] = null);

(statearr_48160_51428[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (13))){
var inst_48092 = (state_48139[(8)]);
var inst_48094 = (state_48139[(9)]);
var inst_48091 = (state_48139[(11)]);
var inst_48093 = (state_48139[(12)]);
var inst_48101 = (state_48139[(2)]);
var inst_48102 = (inst_48094 + (1));
var tmp48156 = inst_48092;
var tmp48157 = inst_48091;
var tmp48158 = inst_48093;
var inst_48091__$1 = tmp48157;
var inst_48092__$1 = tmp48156;
var inst_48093__$1 = tmp48158;
var inst_48094__$1 = inst_48102;
var state_48139__$1 = (function (){var statearr_48162 = state_48139;
(statearr_48162[(8)] = inst_48092__$1);

(statearr_48162[(9)] = inst_48094__$1);

(statearr_48162[(11)] = inst_48091__$1);

(statearr_48162[(12)] = inst_48093__$1);

(statearr_48162[(14)] = inst_48101);

return statearr_48162;
})();
var statearr_48163_51458 = state_48139__$1;
(statearr_48163_51458[(2)] = null);

(statearr_48163_51458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (22))){
var state_48139__$1 = state_48139;
var statearr_48168_51463 = state_48139__$1;
(statearr_48168_51463[(2)] = null);

(statearr_48168_51463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (6))){
var inst_48079 = (state_48139[(13)]);
var inst_48089 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48079) : f.call(null,inst_48079));
var inst_48090 = cljs.core.seq(inst_48089);
var inst_48091 = inst_48090;
var inst_48092 = null;
var inst_48093 = (0);
var inst_48094 = (0);
var state_48139__$1 = (function (){var statearr_48169 = state_48139;
(statearr_48169[(8)] = inst_48092);

(statearr_48169[(9)] = inst_48094);

(statearr_48169[(11)] = inst_48091);

(statearr_48169[(12)] = inst_48093);

return statearr_48169;
})();
var statearr_48171_51488 = state_48139__$1;
(statearr_48171_51488[(2)] = null);

(statearr_48171_51488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (17))){
var inst_48105 = (state_48139[(7)]);
var inst_48109 = cljs.core.chunk_first(inst_48105);
var inst_48110 = cljs.core.chunk_rest(inst_48105);
var inst_48111 = cljs.core.count(inst_48109);
var inst_48091 = inst_48110;
var inst_48092 = inst_48109;
var inst_48093 = inst_48111;
var inst_48094 = (0);
var state_48139__$1 = (function (){var statearr_48172 = state_48139;
(statearr_48172[(8)] = inst_48092);

(statearr_48172[(9)] = inst_48094);

(statearr_48172[(11)] = inst_48091);

(statearr_48172[(12)] = inst_48093);

return statearr_48172;
})();
var statearr_48173_51497 = state_48139__$1;
(statearr_48173_51497[(2)] = null);

(statearr_48173_51497[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (3))){
var inst_48137 = (state_48139[(2)]);
var state_48139__$1 = state_48139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48139__$1,inst_48137);
} else {
if((state_val_48140 === (12))){
var inst_48125 = (state_48139[(2)]);
var state_48139__$1 = state_48139;
var statearr_48174_51502 = state_48139__$1;
(statearr_48174_51502[(2)] = inst_48125);

(statearr_48174_51502[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (2))){
var state_48139__$1 = state_48139;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48139__$1,(4),in$);
} else {
if((state_val_48140 === (23))){
var inst_48133 = (state_48139[(2)]);
var state_48139__$1 = state_48139;
var statearr_48176_51505 = state_48139__$1;
(statearr_48176_51505[(2)] = inst_48133);

(statearr_48176_51505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (19))){
var inst_48120 = (state_48139[(2)]);
var state_48139__$1 = state_48139;
var statearr_48177_51507 = state_48139__$1;
(statearr_48177_51507[(2)] = inst_48120);

(statearr_48177_51507[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (11))){
var inst_48105 = (state_48139[(7)]);
var inst_48091 = (state_48139[(11)]);
var inst_48105__$1 = cljs.core.seq(inst_48091);
var state_48139__$1 = (function (){var statearr_48178 = state_48139;
(statearr_48178[(7)] = inst_48105__$1);

return statearr_48178;
})();
if(inst_48105__$1){
var statearr_48179_51512 = state_48139__$1;
(statearr_48179_51512[(1)] = (14));

} else {
var statearr_48180_51513 = state_48139__$1;
(statearr_48180_51513[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (9))){
var inst_48127 = (state_48139[(2)]);
var inst_48128 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_48139__$1 = (function (){var statearr_48182 = state_48139;
(statearr_48182[(15)] = inst_48127);

return statearr_48182;
})();
if(cljs.core.truth_(inst_48128)){
var statearr_48183_51517 = state_48139__$1;
(statearr_48183_51517[(1)] = (21));

} else {
var statearr_48185_51519 = state_48139__$1;
(statearr_48185_51519[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (5))){
var inst_48083 = cljs.core.async.close_BANG_(out);
var state_48139__$1 = state_48139;
var statearr_48186_51523 = state_48139__$1;
(statearr_48186_51523[(2)] = inst_48083);

(statearr_48186_51523[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (14))){
var inst_48105 = (state_48139[(7)]);
var inst_48107 = cljs.core.chunked_seq_QMARK_(inst_48105);
var state_48139__$1 = state_48139;
if(inst_48107){
var statearr_48187_51528 = state_48139__$1;
(statearr_48187_51528[(1)] = (17));

} else {
var statearr_48188_51529 = state_48139__$1;
(statearr_48188_51529[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (16))){
var inst_48123 = (state_48139[(2)]);
var state_48139__$1 = state_48139;
var statearr_48190_51531 = state_48139__$1;
(statearr_48190_51531[(2)] = inst_48123);

(statearr_48190_51531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48140 === (10))){
var inst_48092 = (state_48139[(8)]);
var inst_48094 = (state_48139[(9)]);
var inst_48099 = cljs.core._nth(inst_48092,inst_48094);
var state_48139__$1 = state_48139;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48139__$1,(13),out,inst_48099);
} else {
if((state_val_48140 === (18))){
var inst_48105 = (state_48139[(7)]);
var inst_48114 = cljs.core.first(inst_48105);
var state_48139__$1 = state_48139;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48139__$1,(20),out,inst_48114);
} else {
if((state_val_48140 === (8))){
var inst_48094 = (state_48139[(9)]);
var inst_48093 = (state_48139[(12)]);
var inst_48096 = (inst_48094 < inst_48093);
var inst_48097 = inst_48096;
var state_48139__$1 = state_48139;
if(cljs.core.truth_(inst_48097)){
var statearr_48192_51554 = state_48139__$1;
(statearr_48192_51554[(1)] = (10));

} else {
var statearr_48193_51557 = state_48139__$1;
(statearr_48193_51557[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__44935__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__44935__auto____0 = (function (){
var statearr_48194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48194[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__44935__auto__);

(statearr_48194[(1)] = (1));

return statearr_48194;
});
var cljs$core$async$mapcat_STAR__$_state_machine__44935__auto____1 = (function (state_48139){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_48139);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e48195){var ex__44939__auto__ = e48195;
var statearr_48196_51575 = state_48139;
(statearr_48196_51575[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_48139[(4)]))){
var statearr_48199_51581 = state_48139;
(statearr_48199_51581[(1)] = cljs.core.first((state_48139[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51590 = state_48139;
state_48139 = G__51590;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__44935__auto__ = function(state_48139){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__44935__auto____1.call(this,state_48139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__44935__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__44935__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_48200 = f__45033__auto__();
(statearr_48200[(6)] = c__45032__auto__);

return statearr_48200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));

return c__45032__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__48202 = arguments.length;
switch (G__48202) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__48205 = arguments.length;
switch (G__48205) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__48210 = arguments.length;
switch (G__48210) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45032__auto___51623 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_48235){
var state_val_48236 = (state_48235[(1)]);
if((state_val_48236 === (7))){
var inst_48230 = (state_48235[(2)]);
var state_48235__$1 = state_48235;
var statearr_48237_51632 = state_48235__$1;
(statearr_48237_51632[(2)] = inst_48230);

(statearr_48237_51632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48236 === (1))){
var inst_48212 = null;
var state_48235__$1 = (function (){var statearr_48238 = state_48235;
(statearr_48238[(7)] = inst_48212);

return statearr_48238;
})();
var statearr_48239_51635 = state_48235__$1;
(statearr_48239_51635[(2)] = null);

(statearr_48239_51635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48236 === (4))){
var inst_48215 = (state_48235[(8)]);
var inst_48215__$1 = (state_48235[(2)]);
var inst_48216 = (inst_48215__$1 == null);
var inst_48217 = cljs.core.not(inst_48216);
var state_48235__$1 = (function (){var statearr_48240 = state_48235;
(statearr_48240[(8)] = inst_48215__$1);

return statearr_48240;
})();
if(inst_48217){
var statearr_48241_51638 = state_48235__$1;
(statearr_48241_51638[(1)] = (5));

} else {
var statearr_48242_51639 = state_48235__$1;
(statearr_48242_51639[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48236 === (6))){
var state_48235__$1 = state_48235;
var statearr_48243_51642 = state_48235__$1;
(statearr_48243_51642[(2)] = null);

(statearr_48243_51642[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48236 === (3))){
var inst_48232 = (state_48235[(2)]);
var inst_48233 = cljs.core.async.close_BANG_(out);
var state_48235__$1 = (function (){var statearr_48247 = state_48235;
(statearr_48247[(9)] = inst_48232);

return statearr_48247;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_48235__$1,inst_48233);
} else {
if((state_val_48236 === (2))){
var state_48235__$1 = state_48235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48235__$1,(4),ch);
} else {
if((state_val_48236 === (11))){
var inst_48215 = (state_48235[(8)]);
var inst_48224 = (state_48235[(2)]);
var inst_48212 = inst_48215;
var state_48235__$1 = (function (){var statearr_48248 = state_48235;
(statearr_48248[(10)] = inst_48224);

(statearr_48248[(7)] = inst_48212);

return statearr_48248;
})();
var statearr_48249_51656 = state_48235__$1;
(statearr_48249_51656[(2)] = null);

(statearr_48249_51656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48236 === (9))){
var inst_48215 = (state_48235[(8)]);
var state_48235__$1 = state_48235;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48235__$1,(11),out,inst_48215);
} else {
if((state_val_48236 === (5))){
var inst_48212 = (state_48235[(7)]);
var inst_48215 = (state_48235[(8)]);
var inst_48219 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48215,inst_48212);
var state_48235__$1 = state_48235;
if(inst_48219){
var statearr_48252_51662 = state_48235__$1;
(statearr_48252_51662[(1)] = (8));

} else {
var statearr_48255_51665 = state_48235__$1;
(statearr_48255_51665[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48236 === (10))){
var inst_48227 = (state_48235[(2)]);
var state_48235__$1 = state_48235;
var statearr_48257_51668 = state_48235__$1;
(statearr_48257_51668[(2)] = inst_48227);

(statearr_48257_51668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48236 === (8))){
var inst_48212 = (state_48235[(7)]);
var tmp48250 = inst_48212;
var inst_48212__$1 = tmp48250;
var state_48235__$1 = (function (){var statearr_48258 = state_48235;
(statearr_48258[(7)] = inst_48212__$1);

return statearr_48258;
})();
var statearr_48259_51671 = state_48235__$1;
(statearr_48259_51671[(2)] = null);

(statearr_48259_51671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_48263 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_48263[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_48263[(1)] = (1));

return statearr_48263;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_48235){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_48235);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e48266){var ex__44939__auto__ = e48266;
var statearr_48267_51676 = state_48235;
(statearr_48267_51676[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_48235[(4)]))){
var statearr_48268_51680 = state_48235;
(statearr_48268_51680[(1)] = cljs.core.first((state_48235[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51681 = state_48235;
state_48235 = G__51681;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_48235){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_48235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_48270 = f__45033__auto__();
(statearr_48270[(6)] = c__45032__auto___51623);

return statearr_48270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__48273 = arguments.length;
switch (G__48273) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45032__auto___51704 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_48316){
var state_val_48317 = (state_48316[(1)]);
if((state_val_48317 === (7))){
var inst_48311 = (state_48316[(2)]);
var state_48316__$1 = state_48316;
var statearr_48321_51708 = state_48316__$1;
(statearr_48321_51708[(2)] = inst_48311);

(statearr_48321_51708[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (1))){
var inst_48277 = (new Array(n));
var inst_48278 = inst_48277;
var inst_48280 = (0);
var state_48316__$1 = (function (){var statearr_48322 = state_48316;
(statearr_48322[(7)] = inst_48280);

(statearr_48322[(8)] = inst_48278);

return statearr_48322;
})();
var statearr_48323_51717 = state_48316__$1;
(statearr_48323_51717[(2)] = null);

(statearr_48323_51717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (4))){
var inst_48283 = (state_48316[(9)]);
var inst_48283__$1 = (state_48316[(2)]);
var inst_48284 = (inst_48283__$1 == null);
var inst_48285 = cljs.core.not(inst_48284);
var state_48316__$1 = (function (){var statearr_48325 = state_48316;
(statearr_48325[(9)] = inst_48283__$1);

return statearr_48325;
})();
if(inst_48285){
var statearr_48326_51719 = state_48316__$1;
(statearr_48326_51719[(1)] = (5));

} else {
var statearr_48327_51720 = state_48316__$1;
(statearr_48327_51720[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (15))){
var inst_48305 = (state_48316[(2)]);
var state_48316__$1 = state_48316;
var statearr_48330_51722 = state_48316__$1;
(statearr_48330_51722[(2)] = inst_48305);

(statearr_48330_51722[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (13))){
var state_48316__$1 = state_48316;
var statearr_48332_51724 = state_48316__$1;
(statearr_48332_51724[(2)] = null);

(statearr_48332_51724[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (6))){
var inst_48280 = (state_48316[(7)]);
var inst_48301 = (inst_48280 > (0));
var state_48316__$1 = state_48316;
if(cljs.core.truth_(inst_48301)){
var statearr_48334_51727 = state_48316__$1;
(statearr_48334_51727[(1)] = (12));

} else {
var statearr_48335_51728 = state_48316__$1;
(statearr_48335_51728[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (3))){
var inst_48313 = (state_48316[(2)]);
var state_48316__$1 = state_48316;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48316__$1,inst_48313);
} else {
if((state_val_48317 === (12))){
var inst_48278 = (state_48316[(8)]);
var inst_48303 = cljs.core.vec(inst_48278);
var state_48316__$1 = state_48316;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48316__$1,(15),out,inst_48303);
} else {
if((state_val_48317 === (2))){
var state_48316__$1 = state_48316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48316__$1,(4),ch);
} else {
if((state_val_48317 === (11))){
var inst_48295 = (state_48316[(2)]);
var inst_48296 = (new Array(n));
var inst_48278 = inst_48296;
var inst_48280 = (0);
var state_48316__$1 = (function (){var statearr_48342 = state_48316;
(statearr_48342[(7)] = inst_48280);

(statearr_48342[(10)] = inst_48295);

(statearr_48342[(8)] = inst_48278);

return statearr_48342;
})();
var statearr_48343_51743 = state_48316__$1;
(statearr_48343_51743[(2)] = null);

(statearr_48343_51743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (9))){
var inst_48278 = (state_48316[(8)]);
var inst_48293 = cljs.core.vec(inst_48278);
var state_48316__$1 = state_48316;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48316__$1,(11),out,inst_48293);
} else {
if((state_val_48317 === (5))){
var inst_48280 = (state_48316[(7)]);
var inst_48283 = (state_48316[(9)]);
var inst_48278 = (state_48316[(8)]);
var inst_48288 = (state_48316[(11)]);
var inst_48287 = (inst_48278[inst_48280] = inst_48283);
var inst_48288__$1 = (inst_48280 + (1));
var inst_48289 = (inst_48288__$1 < n);
var state_48316__$1 = (function (){var statearr_48346 = state_48316;
(statearr_48346[(12)] = inst_48287);

(statearr_48346[(11)] = inst_48288__$1);

return statearr_48346;
})();
if(cljs.core.truth_(inst_48289)){
var statearr_48347_51756 = state_48316__$1;
(statearr_48347_51756[(1)] = (8));

} else {
var statearr_48348_51758 = state_48316__$1;
(statearr_48348_51758[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (14))){
var inst_48308 = (state_48316[(2)]);
var inst_48309 = cljs.core.async.close_BANG_(out);
var state_48316__$1 = (function (){var statearr_48352 = state_48316;
(statearr_48352[(13)] = inst_48308);

return statearr_48352;
})();
var statearr_48354_51775 = state_48316__$1;
(statearr_48354_51775[(2)] = inst_48309);

(statearr_48354_51775[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (10))){
var inst_48299 = (state_48316[(2)]);
var state_48316__$1 = state_48316;
var statearr_48355_51786 = state_48316__$1;
(statearr_48355_51786[(2)] = inst_48299);

(statearr_48355_51786[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48317 === (8))){
var inst_48278 = (state_48316[(8)]);
var inst_48288 = (state_48316[(11)]);
var tmp48350 = inst_48278;
var inst_48278__$1 = tmp48350;
var inst_48280 = inst_48288;
var state_48316__$1 = (function (){var statearr_48356 = state_48316;
(statearr_48356[(7)] = inst_48280);

(statearr_48356[(8)] = inst_48278__$1);

return statearr_48356;
})();
var statearr_48359_51790 = state_48316__$1;
(statearr_48359_51790[(2)] = null);

(statearr_48359_51790[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_48361 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48361[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_48361[(1)] = (1));

return statearr_48361;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_48316){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_48316);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e48364){var ex__44939__auto__ = e48364;
var statearr_48365_51797 = state_48316;
(statearr_48365_51797[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_48316[(4)]))){
var statearr_48367_51802 = state_48316;
(statearr_48367_51802[(1)] = cljs.core.first((state_48316[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51809 = state_48316;
state_48316 = G__51809;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_48316){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_48316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_48368 = f__45033__auto__();
(statearr_48368[(6)] = c__45032__auto___51704);

return statearr_48368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__48382 = arguments.length;
switch (G__48382) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__45032__auto___51823 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__45033__auto__ = (function (){var switch__44933__auto__ = (function (state_48433){
var state_val_48435 = (state_48433[(1)]);
if((state_val_48435 === (7))){
var inst_48429 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48441_51835 = state_48433__$1;
(statearr_48441_51835[(2)] = inst_48429);

(statearr_48441_51835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (1))){
var inst_48388 = [];
var inst_48389 = inst_48388;
var inst_48390 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_48433__$1 = (function (){var statearr_48443 = state_48433;
(statearr_48443[(7)] = inst_48390);

(statearr_48443[(8)] = inst_48389);

return statearr_48443;
})();
var statearr_48444_51838 = state_48433__$1;
(statearr_48444_51838[(2)] = null);

(statearr_48444_51838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (4))){
var inst_48393 = (state_48433[(9)]);
var inst_48393__$1 = (state_48433[(2)]);
var inst_48396 = (inst_48393__$1 == null);
var inst_48397 = cljs.core.not(inst_48396);
var state_48433__$1 = (function (){var statearr_48445 = state_48433;
(statearr_48445[(9)] = inst_48393__$1);

return statearr_48445;
})();
if(inst_48397){
var statearr_48447_51845 = state_48433__$1;
(statearr_48447_51845[(1)] = (5));

} else {
var statearr_48448_51851 = state_48433__$1;
(statearr_48448_51851[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (15))){
var inst_48423 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48449_51854 = state_48433__$1;
(statearr_48449_51854[(2)] = inst_48423);

(statearr_48449_51854[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (13))){
var state_48433__$1 = state_48433;
var statearr_48452_51861 = state_48433__$1;
(statearr_48452_51861[(2)] = null);

(statearr_48452_51861[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (6))){
var inst_48389 = (state_48433[(8)]);
var inst_48418 = inst_48389.length;
var inst_48419 = (inst_48418 > (0));
var state_48433__$1 = state_48433;
if(cljs.core.truth_(inst_48419)){
var statearr_48456_51873 = state_48433__$1;
(statearr_48456_51873[(1)] = (12));

} else {
var statearr_48457_51874 = state_48433__$1;
(statearr_48457_51874[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (3))){
var inst_48431 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48433__$1,inst_48431);
} else {
if((state_val_48435 === (12))){
var inst_48389 = (state_48433[(8)]);
var inst_48421 = cljs.core.vec(inst_48389);
var state_48433__$1 = state_48433;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48433__$1,(15),out,inst_48421);
} else {
if((state_val_48435 === (2))){
var state_48433__$1 = state_48433;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48433__$1,(4),ch);
} else {
if((state_val_48435 === (11))){
var inst_48393 = (state_48433[(9)]);
var inst_48399 = (state_48433[(10)]);
var inst_48411 = (state_48433[(2)]);
var inst_48412 = [];
var inst_48413 = inst_48412.push(inst_48393);
var inst_48389 = inst_48412;
var inst_48390 = inst_48399;
var state_48433__$1 = (function (){var statearr_48461 = state_48433;
(statearr_48461[(11)] = inst_48413);

(statearr_48461[(12)] = inst_48411);

(statearr_48461[(7)] = inst_48390);

(statearr_48461[(8)] = inst_48389);

return statearr_48461;
})();
var statearr_48463_51886 = state_48433__$1;
(statearr_48463_51886[(2)] = null);

(statearr_48463_51886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (9))){
var inst_48389 = (state_48433[(8)]);
var inst_48409 = cljs.core.vec(inst_48389);
var state_48433__$1 = state_48433;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48433__$1,(11),out,inst_48409);
} else {
if((state_val_48435 === (5))){
var inst_48393 = (state_48433[(9)]);
var inst_48399 = (state_48433[(10)]);
var inst_48390 = (state_48433[(7)]);
var inst_48399__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48393) : f.call(null,inst_48393));
var inst_48402 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48399__$1,inst_48390);
var inst_48403 = cljs.core.keyword_identical_QMARK_(inst_48390,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_48404 = ((inst_48402) || (inst_48403));
var state_48433__$1 = (function (){var statearr_48468 = state_48433;
(statearr_48468[(10)] = inst_48399__$1);

return statearr_48468;
})();
if(cljs.core.truth_(inst_48404)){
var statearr_48469_51903 = state_48433__$1;
(statearr_48469_51903[(1)] = (8));

} else {
var statearr_48470_51907 = state_48433__$1;
(statearr_48470_51907[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (14))){
var inst_48426 = (state_48433[(2)]);
var inst_48427 = cljs.core.async.close_BANG_(out);
var state_48433__$1 = (function (){var statearr_48474 = state_48433;
(statearr_48474[(13)] = inst_48426);

return statearr_48474;
})();
var statearr_48476_51909 = state_48433__$1;
(statearr_48476_51909[(2)] = inst_48427);

(statearr_48476_51909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (10))){
var inst_48416 = (state_48433[(2)]);
var state_48433__$1 = state_48433;
var statearr_48477_51914 = state_48433__$1;
(statearr_48477_51914[(2)] = inst_48416);

(statearr_48477_51914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48435 === (8))){
var inst_48393 = (state_48433[(9)]);
var inst_48399 = (state_48433[(10)]);
var inst_48389 = (state_48433[(8)]);
var inst_48406 = inst_48389.push(inst_48393);
var tmp48471 = inst_48389;
var inst_48389__$1 = tmp48471;
var inst_48390 = inst_48399;
var state_48433__$1 = (function (){var statearr_48478 = state_48433;
(statearr_48478[(7)] = inst_48390);

(statearr_48478[(8)] = inst_48389__$1);

(statearr_48478[(14)] = inst_48406);

return statearr_48478;
})();
var statearr_48480_51922 = state_48433__$1;
(statearr_48480_51922[(2)] = null);

(statearr_48480_51922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44935__auto__ = null;
var cljs$core$async$state_machine__44935__auto____0 = (function (){
var statearr_48481 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48481[(0)] = cljs$core$async$state_machine__44935__auto__);

(statearr_48481[(1)] = (1));

return statearr_48481;
});
var cljs$core$async$state_machine__44935__auto____1 = (function (state_48433){
while(true){
var ret_value__44937__auto__ = (function (){try{while(true){
var result__44938__auto__ = switch__44933__auto__(state_48433);
if(cljs.core.keyword_identical_QMARK_(result__44938__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44938__auto__;
}
break;
}
}catch (e48487){var ex__44939__auto__ = e48487;
var statearr_48488_51929 = state_48433;
(statearr_48488_51929[(2)] = ex__44939__auto__);


if(cljs.core.seq((state_48433[(4)]))){
var statearr_48489_51930 = state_48433;
(statearr_48489_51930[(1)] = cljs.core.first((state_48433[(4)])));

} else {
throw ex__44939__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44937__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__51932 = state_48433;
state_48433 = G__51932;
continue;
} else {
return ret_value__44937__auto__;
}
break;
}
});
cljs$core$async$state_machine__44935__auto__ = function(state_48433){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44935__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44935__auto____1.call(this,state_48433);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44935__auto____0;
cljs$core$async$state_machine__44935__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44935__auto____1;
return cljs$core$async$state_machine__44935__auto__;
})()
})();
var state__45034__auto__ = (function (){var statearr_48493 = f__45033__auto__();
(statearr_48493[(6)] = c__45032__auto___51823);

return statearr_48493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__45034__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
