goog.provide('dv.cljs_emotion_reagent');
var module$node_modules$react$index=shadow.js.require("module$node_modules$react$index", {});
var module$node_modules$$emotion$hash$dist$hash_browser_cjs=shadow.js.require("module$node_modules$$emotion$hash$dist$hash_browser_cjs", {});
var module$node_modules$$emotion$styled$dist$emotion_styled_browser_cjs=shadow.js.require("module$node_modules$$emotion$styled$dist$emotion_styled_browser_cjs", {});
var module$node_modules$$emotion$react$dist$emotion_react_browser_cjs=shadow.js.require("module$node_modules$$emotion$react$dist$emotion_react_browser_cjs", {});
dv.cljs_emotion_reagent.emotion_hash = goog.object.get(module$node_modules$$emotion$hash$dist$hash_browser_cjs,"default");
dv.cljs_emotion_reagent.styled = goog.object.get(module$node_modules$$emotion$styled$dist$emotion_styled_browser_cjs,"default");
/**
 * Is it a reagent vector? (or a best effort guess at least.)
 */
dv.cljs_emotion_reagent.relement_QMARK_ = (function dv$cljs_emotion_reagent$relement_QMARK_(el){
if(cljs.core.vector_QMARK_(el)){
var item = cljs.core.first(el);
return (((item instanceof cljs.core.Keyword)) || ((item instanceof cljs.core.Symbol)) || (cljs.core.fn_QMARK_(item)));
} else {
return false;
}
});
/**
 * Utility function that will force a lazy sequence of children (recursively) into realized
 *   vectors (React cannot deal with lazy seqs in production mode)
 */
dv.cljs_emotion_reagent.force_children = (function dv$cljs_emotion_reagent$force_children(x){
if(cljs.core.seq_QMARK_(x)){
return cljs.core.to_array(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(dv.cljs_emotion_reagent.force_children,x));
} else {
if(dv.cljs_emotion_reagent.relement_QMARK_(x)){
return reagent.core.as_element.cljs$core$IFn$_invoke$arity$1(x);
} else {
return x;
}
}
});
dv.cljs_emotion_reagent.kebab__GT_camel = (function dv$cljs_emotion_reagent$kebab__GT_camel(prop){
if(clojure.string.starts_with_QMARK_(prop,".")){
return prop;
} else {
if(clojure.string.includes_QMARK_(prop,"-")){
var words = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.string.capitalize,cljs.core.re_seq(/[a-zA-Z]+/,prop));
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.update.cljs$core$IFn$_invoke$arity$3(words,(0),clojure.string.lower_case));
} else {
return prop;
}
}
});
/**
 * Also replaces styled components with their css classname is key position.
 */
dv.cljs_emotion_reagent.camelize_keys = (function dv$cljs_emotion_reagent$camelize_keys(style_map){
return clojure.walk.postwalk((function (v){
if((v instanceof cljs.core.Keyword)){
return dv.cljs_emotion_reagent.kebab__GT_camel(cljs.core.name(v));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.meta(v);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(v),new cljs.core.Keyword("dv.cljs-emotion-reagent","hashed-name","dv.cljs-emotion-reagent/hashed-name",-314507080));
} else {
return and__4115__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion-reagent","hashed-name","dv.cljs-emotion-reagent/hashed-name",-314507080).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v)))].join('');
} else {
return v;

}
}
}),style_map);
});
/**
 * Convert all keys in the map to kebab case keywords.
 */
dv.cljs_emotion_reagent.map__GT_kebab = (function dv$cljs_emotion_reagent$map__GT_kebab(m){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__45235){
var vec__45237 = p__45235;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45237,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45237,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [camel_snake_kebab.core.__GT_kebab_case(k),v], null);
}),m));
});
/**
 * Delegates to emotion's `jsx` function to apply anonymous styles to an element.
 *   `el` - a keyword (will use the name to get the element), a string, or any valid component you can pass to `jsx`.
 *   `styles` - a cljs map, styles must reside under the `:css` key.
 * 
 *   (css :div {:css {:background "red"} :my-other-prop} "content")
 */
dv.cljs_emotion_reagent.css = (function dv$cljs_emotion_reagent$css(var_args){
var G__45248 = arguments.length;
switch (G__45248) {
case 2:
return dv.cljs_emotion_reagent.css.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return dv.cljs_emotion_reagent.css.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___45296 = arguments.length;
var i__4737__auto___45297 = (0);
while(true){
if((i__4737__auto___45297 < len__4736__auto___45296)){
args_arr__4757__auto__.push((arguments[i__4737__auto___45297]));

var G__45298 = (i__4737__auto___45297 + (1));
i__4737__auto___45297 = G__45298;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((3)),(0),null));
return dv.cljs_emotion_reagent.css.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4758__auto__);

}
});

(dv.cljs_emotion_reagent.css.cljs$core$IFn$_invoke$arity$2 = (function (el,props){
var el__$1 = (((el instanceof cljs.core.Keyword))?cljs.core.name(el):null);
return module$node_modules$$emotion$react$dist$emotion_react_browser_cjs.jsx(el__$1,cljs.core.clj__GT_js(dv.cljs_emotion_reagent.camelize_keys(props)));
}));

(dv.cljs_emotion_reagent.css.cljs$core$IFn$_invoke$arity$3 = (function (el,props,children){
var el__$1 = (((el instanceof cljs.core.Keyword))?cljs.core.name(el):null);
return module$node_modules$$emotion$react$dist$emotion_react_browser_cjs.jsx(el__$1,cljs.core.clj__GT_js(dv.cljs_emotion_reagent.camelize_keys(props)),reagent.core.as_element.cljs$core$IFn$_invoke$arity$1(children));
}));

(dv.cljs_emotion_reagent.css.cljs$core$IFn$_invoke$arity$variadic = (function (el,props,first_child,children){
var el__$1 = (((el instanceof cljs.core.Keyword))?cljs.core.name(el):null);
var children__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"<>","<>",1280186386),first_child], null),children);
return module$node_modules$$emotion$react$dist$emotion_react_browser_cjs.jsx(el__$1,cljs.core.clj__GT_js(dv.cljs_emotion_reagent.camelize_keys(props)),reagent.core.as_element.cljs$core$IFn$_invoke$arity$1(children__$1));
}));

/** @this {Function} */
(dv.cljs_emotion_reagent.css.cljs$lang$applyTo = (function (seq45244){
var G__45245 = cljs.core.first(seq45244);
var seq45244__$1 = cljs.core.next(seq45244);
var G__45246 = cljs.core.first(seq45244__$1);
var seq45244__$2 = cljs.core.next(seq45244__$1);
var G__45247 = cljs.core.first(seq45244__$2);
var seq45244__$3 = cljs.core.next(seq45244__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45245,G__45246,G__45247,seq45244__$3);
}));

(dv.cljs_emotion_reagent.css.cljs$lang$maxFixedArity = (3));

dv.cljs_emotion_reagent.keyframes = (function dv$cljs_emotion_reagent$keyframes(anim_map){
return module$node_modules$$emotion$react$dist$emotion_react_browser_cjs.keyframes(cljs.core.clj__GT_js(dv.cljs_emotion_reagent.camelize_keys(anim_map)));
});
/**
 * @define {string}
 */
dv.cljs_emotion_reagent.ADD_CLASSNAMES = goog.define("dv.cljs_emotion_reagent.ADD_CLASSNAMES","INITIAL");
dv.cljs_emotion_reagent.add_class_names_QMARK_ = (function dv$cljs_emotion_reagent$add_class_names_QMARK_(){
if(cljs.core.boolean_QMARK_(dv.cljs_emotion_reagent.ADD_CLASSNAMES)){
return dv.cljs_emotion_reagent.ADD_CLASSNAMES;
} else {
return goog.DEBUG;
}
});
dv.cljs_emotion_reagent.add_class_name = (function dv$cljs_emotion_reagent$add_class_name(props,class_name){
if(cljs.core.object_QMARK_(props)){
var G__45271 = props;
goog.object.set(G__45271,"className",clojure.string.trim(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [class_name,goog.object.get(props,"className")], null))));

return G__45271;
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(props,new cljs.core.Keyword(null,"className","className",-1983287057),(function (p1__45270_SHARP_){
if((p1__45270_SHARP_ == null)){
return class_name;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__45270_SHARP_)].join('');
}
}));
}
});
dv.cljs_emotion_reagent.hashit = (function dv$cljs_emotion_reagent$hashit(string){
return ["dvcss-",cljs.core.str.cljs$core$IFn$_invoke$arity$1((dv.cljs_emotion_reagent.emotion_hash.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion_reagent.emotion_hash.cljs$core$IFn$_invoke$arity$1(string) : dv.cljs_emotion_reagent.emotion_hash.call(null,string)))].join('');
});
dv.cljs_emotion_reagent.set_class_name = (function dv$cljs_emotion_reagent$set_class_name(props,class_name){
if(cljs.core.truth_(class_name)){
var hashed_name = dv.cljs_emotion_reagent.hashit(class_name);
var props__$1 = dv.cljs_emotion_reagent.add_class_name(props,hashed_name);
if(cljs.core.truth_(dv.cljs_emotion_reagent.add_class_names_QMARK_())){
return dv.cljs_emotion_reagent.add_class_name(props__$1,class_name);
} else {
return props__$1;
}
} else {
return props;
}
});
/**
 * Allows using kebab-case prop names.
 */
dv.cljs_emotion_reagent.massage_props = (function dv$cljs_emotion_reagent$massage_props(props,class_name){
var clss = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props);
var props__$1 = (function (){var G__45278 = props;
if(cljs.core.truth_(clss)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45278,new cljs.core.Keyword(null,"class","class",-2030961996),reagent.impl.util.class_names.cljs$core$IFn$_invoke$arity$1(clss));
} else {
return G__45278;
}
})();
var props__$2 = reagent.impl.template.convert_prop_value(props__$1);
return cljs.core.clj__GT_js(dv.cljs_emotion_reagent.set_class_name(props__$2,class_name));
});
dv.cljs_emotion_reagent.react_factory = (function dv$cljs_emotion_reagent$react_factory(el,class_name){
return (function() {
var G__45308 = null;
var G__45308__0 = (function (){
return module$node_modules$react$index.createElement(el,cljs.core.clj__GT_js(dv.cljs_emotion_reagent.set_class_name(cljs.core.PersistentArrayMap.EMPTY,class_name)));
});
var G__45308__1 = (function (props){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = module$node_modules$react$index.isValidElement(props);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return typeof props === 'string';
}
})())){
return module$node_modules$react$index.createElement(el,dv.cljs_emotion_reagent.set_class_name(({}),class_name),props);
} else {
if(cljs.core.map_QMARK_(props)){
var props__$1 = dv.cljs_emotion_reagent.massage_props(props,class_name);
return module$node_modules$react$index.createElement(el,props__$1);
} else {
if(cljs.core.object_QMARK_(props)){
return module$node_modules$react$index.createElement(el,dv.cljs_emotion_reagent.set_class_name(props,class_name));
} else {
if(dv.cljs_emotion_reagent.relement_QMARK_(props)){
return module$node_modules$react$index.createElement(el,dv.cljs_emotion_reagent.set_class_name(({}),class_name),reagent.core.as_element.cljs$core$IFn$_invoke$arity$1(props));
} else {
if(cljs.core.seq_QMARK_(props)){
return module$node_modules$react$index.createElement(el,dv.cljs_emotion_reagent.set_class_name(({}),class_name),dv.cljs_emotion_reagent.force_children(props));
} else {
if(cljs.core.array_QMARK_(props)){
return module$node_modules$react$index.createElement(el,dv.cljs_emotion_reagent.set_class_name(({}),class_name),props);
} else {
return module$node_modules$react$index.createElement(el,dv.cljs_emotion_reagent.set_class_name(({}),class_name));

}
}
}
}
}
}
}catch (e45281){if((e45281 instanceof Object)){
var e = e45281;
return console.error("Error invoking an emotion styled component: ",e);
} else {
throw e45281;

}
}});
var G__45308__2 = (function() { 
var G__45310__delegate = function (props,children){
if(((((cljs.core.object_QMARK_(props)) && (cljs.core.not(module$node_modules$react$index.isValidElement(props))))) || (cljs.core.map_QMARK_(props)))){
var props__$1 = dv.cljs_emotion_reagent.massage_props(props,class_name);
if(cljs.core.seq(children)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(module$node_modules$react$index.createElement,el,props__$1,dv.cljs_emotion_reagent.force_children(children));
} else {
return module$node_modules$react$index.createElement(el,props__$1);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(module$node_modules$react$index.createElement,el,dv.cljs_emotion_reagent.set_class_name(({}),class_name),dv.cljs_emotion_reagent.force_children(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(props,children)));
}
};
var G__45310 = function (props,var_args){
var children = null;
if (arguments.length > 1) {
var G__45314__i = 0, G__45314__a = new Array(arguments.length -  1);
while (G__45314__i < G__45314__a.length) {G__45314__a[G__45314__i] = arguments[G__45314__i + 1]; ++G__45314__i;}
  children = new cljs.core.IndexedSeq(G__45314__a,0,null);
} 
return G__45310__delegate.call(this,props,children);};
G__45310.cljs$lang$maxFixedArity = 1;
G__45310.cljs$lang$applyTo = (function (arglist__45315){
var props = cljs.core.first(arglist__45315);
var children = cljs.core.rest(arglist__45315);
return G__45310__delegate(props,children);
});
G__45310.cljs$core$IFn$_invoke$arity$variadic = G__45310__delegate;
return G__45310;
})()
;
G__45308 = function(props,var_args){
var children = var_args;
switch(arguments.length){
case 0:
return G__45308__0.call(this);
case 1:
return G__45308__1.call(this,props);
default:
var G__45319 = null;
if (arguments.length > 1) {
var G__45320__i = 0, G__45320__a = new Array(arguments.length -  1);
while (G__45320__i < G__45320__a.length) {G__45320__a[G__45320__i] = arguments[G__45320__i + 1]; ++G__45320__i;}
G__45319 = new cljs.core.IndexedSeq(G__45320__a,0,null);
}
return G__45308__2.cljs$core$IFn$_invoke$arity$variadic(props, G__45319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45308.cljs$lang$maxFixedArity = 1;
G__45308.cljs$lang$applyTo = G__45308__2.cljs$lang$applyTo;
G__45308.cljs$core$IFn$_invoke$arity$0 = G__45308__0;
G__45308.cljs$core$IFn$_invoke$arity$1 = G__45308__1;
G__45308.cljs$core$IFn$_invoke$arity$variadic = G__45308__2.cljs$core$IFn$_invoke$arity$variadic;
return G__45308;
})()
});
dv.cljs_emotion_reagent.global_STAR_ = dv.cljs_emotion_reagent.react_factory(module$node_modules$$emotion$react$dist$emotion_react_browser_cjs.Global,null);
dv.cljs_emotion_reagent.global_style = (function dv$cljs_emotion_reagent$global_style(props){
return dv.cljs_emotion_reagent.global_STAR_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"styles","styles",1954480375),dv.cljs_emotion_reagent.camelize_keys(props)], null));
});
dv.cljs_emotion_reagent.theme_provider = (function dv$cljs_emotion_reagent$theme_provider(var_args){
var args__4742__auto__ = [];
var len__4736__auto___45329 = arguments.length;
var i__4737__auto___45330 = (0);
while(true){
if((i__4737__auto___45330 < len__4736__auto___45329)){
args__4742__auto__.push((arguments[i__4737__auto___45330]));

var G__45331 = (i__4737__auto___45330 + (1));
i__4737__auto___45330 = G__45331;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return dv.cljs_emotion_reagent.theme_provider.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(dv.cljs_emotion_reagent.theme_provider.cljs$core$IFn$_invoke$arity$variadic = (function (props,children){
if(cljs.core.contains_QMARK_(props,new cljs.core.Keyword(null,"theme","theme",-1247880880))){
} else {
throw (new Error("You must pass a :theme to the theme-provider."));
}

return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(module$node_modules$react$index.createElement,module$node_modules$$emotion$react$dist$emotion_react_browser_cjs.ThemeProvider,cljs.core.clj__GT_js(props),dv.cljs_emotion_reagent.force_children(children));
}));

(dv.cljs_emotion_reagent.theme_provider.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dv.cljs_emotion_reagent.theme_provider.cljs$lang$applyTo = (function (seq45293){
var G__45294 = cljs.core.first(seq45293);
var seq45293__$1 = cljs.core.next(seq45293);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45294,seq45293__$1);
}));


//# sourceMappingURL=dv.cljs_emotion_reagent.js.map
