goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__44515 = arguments.length;
switch (G__44515) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44534 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44534 = (function (f,blockable,meta44535){
this.f = f;
this.blockable = blockable;
this.meta44535 = meta44535;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44534.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44536,meta44535__$1){
var self__ = this;
var _44536__$1 = this;
return (new cljs.core.async.t_cljs$core$async44534(self__.f,self__.blockable,meta44535__$1));
}));

(cljs.core.async.t_cljs$core$async44534.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44536){
var self__ = this;
var _44536__$1 = this;
return self__.meta44535;
}));

(cljs.core.async.t_cljs$core$async44534.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44534.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44534.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async44534.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async44534.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta44535","meta44535",-734071608,null)], null);
}));

(cljs.core.async.t_cljs$core$async44534.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44534.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44534");

(cljs.core.async.t_cljs$core$async44534.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44534");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44534.
 */
cljs.core.async.__GT_t_cljs$core$async44534 = (function cljs$core$async$__GT_t_cljs$core$async44534(f__$1,blockable__$1,meta44535){
return (new cljs.core.async.t_cljs$core$async44534(f__$1,blockable__$1,meta44535));
});

}

return (new cljs.core.async.t_cljs$core$async44534(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__44624 = arguments.length;
switch (G__44624) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__44651 = arguments.length;
switch (G__44651) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__44690 = arguments.length;
switch (G__44690) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_48435 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48435) : fn1.call(null,val_48435));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48435) : fn1.call(null,val_48435));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__44728 = arguments.length;
switch (G__44728) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___48466 = n;
var x_48467 = (0);
while(true){
if((x_48467 < n__4741__auto___48466)){
(a[x_48467] = x_48467);

var G__48471 = (x_48467 + (1));
x_48467 = G__48471;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44760 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44760 = (function (flag,meta44761){
this.flag = flag;
this.meta44761 = meta44761;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44760.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44762,meta44761__$1){
var self__ = this;
var _44762__$1 = this;
return (new cljs.core.async.t_cljs$core$async44760(self__.flag,meta44761__$1));
}));

(cljs.core.async.t_cljs$core$async44760.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44762){
var self__ = this;
var _44762__$1 = this;
return self__.meta44761;
}));

(cljs.core.async.t_cljs$core$async44760.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44760.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44760.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44760.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44760.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44761","meta44761",-1802626629,null)], null);
}));

(cljs.core.async.t_cljs$core$async44760.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44760.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44760");

(cljs.core.async.t_cljs$core$async44760.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44760");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44760.
 */
cljs.core.async.__GT_t_cljs$core$async44760 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44760(flag__$1,meta44761){
return (new cljs.core.async.t_cljs$core$async44760(flag__$1,meta44761));
});

}

return (new cljs.core.async.t_cljs$core$async44760(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44796 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44796 = (function (flag,cb,meta44797){
this.flag = flag;
this.cb = cb;
this.meta44797 = meta44797;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44796.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44798,meta44797__$1){
var self__ = this;
var _44798__$1 = this;
return (new cljs.core.async.t_cljs$core$async44796(self__.flag,self__.cb,meta44797__$1));
}));

(cljs.core.async.t_cljs$core$async44796.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44798){
var self__ = this;
var _44798__$1 = this;
return self__.meta44797;
}));

(cljs.core.async.t_cljs$core$async44796.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44796.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44796.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44796.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44796.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44797","meta44797",1544756484,null)], null);
}));

(cljs.core.async.t_cljs$core$async44796.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44796.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44796");

(cljs.core.async.t_cljs$core$async44796.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44796");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44796.
 */
cljs.core.async.__GT_t_cljs$core$async44796 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44796(flag__$1,cb__$1,meta44797){
return (new cljs.core.async.t_cljs$core$async44796(flag__$1,cb__$1,meta44797));
});

}

return (new cljs.core.async.t_cljs$core$async44796(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44823_SHARP_){
var G__44837 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44823_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44837) : fret.call(null,G__44837));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44824_SHARP_){
var G__44839 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44824_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44839) : fret.call(null,G__44839));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__48522 = (i + (1));
i = G__48522;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___48533 = arguments.length;
var i__4865__auto___48534 = (0);
while(true){
if((i__4865__auto___48534 < len__4864__auto___48533)){
args__4870__auto__.push((arguments[i__4865__auto___48534]));

var G__48536 = (i__4865__auto___48534 + (1));
i__4865__auto___48534 = G__48536;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44863){
var map__44884 = p__44863;
var map__44884__$1 = cljs.core.__destructure_map(map__44884);
var opts = map__44884__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44844){
var G__44845 = cljs.core.first(seq44844);
var seq44844__$1 = cljs.core.next(seq44844);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44845,seq44844__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44905 = arguments.length;
switch (G__44905) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__44365__auto___48544 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_44952){
var state_val_44955 = (state_44952[(1)]);
if((state_val_44955 === (7))){
var inst_44946 = (state_44952[(2)]);
var state_44952__$1 = state_44952;
var statearr_44963_48545 = state_44952__$1;
(statearr_44963_48545[(2)] = inst_44946);

(statearr_44963_48545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (1))){
var state_44952__$1 = state_44952;
var statearr_44964_48549 = state_44952__$1;
(statearr_44964_48549[(2)] = null);

(statearr_44964_48549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (4))){
var inst_44925 = (state_44952[(7)]);
var inst_44925__$1 = (state_44952[(2)]);
var inst_44926 = (inst_44925__$1 == null);
var state_44952__$1 = (function (){var statearr_44971 = state_44952;
(statearr_44971[(7)] = inst_44925__$1);

return statearr_44971;
})();
if(cljs.core.truth_(inst_44926)){
var statearr_44972_48554 = state_44952__$1;
(statearr_44972_48554[(1)] = (5));

} else {
var statearr_44973_48558 = state_44952__$1;
(statearr_44973_48558[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (13))){
var state_44952__$1 = state_44952;
var statearr_44978_48559 = state_44952__$1;
(statearr_44978_48559[(2)] = null);

(statearr_44978_48559[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (6))){
var inst_44925 = (state_44952[(7)]);
var state_44952__$1 = state_44952;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44952__$1,(11),to,inst_44925);
} else {
if((state_val_44955 === (3))){
var inst_44948 = (state_44952[(2)]);
var state_44952__$1 = state_44952;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44952__$1,inst_44948);
} else {
if((state_val_44955 === (12))){
var state_44952__$1 = state_44952;
var statearr_44979_48565 = state_44952__$1;
(statearr_44979_48565[(2)] = null);

(statearr_44979_48565[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (2))){
var state_44952__$1 = state_44952;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44952__$1,(4),from);
} else {
if((state_val_44955 === (11))){
var inst_44938 = (state_44952[(2)]);
var state_44952__$1 = state_44952;
if(cljs.core.truth_(inst_44938)){
var statearr_44980_48566 = state_44952__$1;
(statearr_44980_48566[(1)] = (12));

} else {
var statearr_44981_48567 = state_44952__$1;
(statearr_44981_48567[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (9))){
var state_44952__$1 = state_44952;
var statearr_44984_48568 = state_44952__$1;
(statearr_44984_48568[(2)] = null);

(statearr_44984_48568[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (5))){
var state_44952__$1 = state_44952;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44985_48569 = state_44952__$1;
(statearr_44985_48569[(1)] = (8));

} else {
var statearr_44986_48570 = state_44952__$1;
(statearr_44986_48570[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (14))){
var inst_44944 = (state_44952[(2)]);
var state_44952__$1 = state_44952;
var statearr_44987_48574 = state_44952__$1;
(statearr_44987_48574[(2)] = inst_44944);

(statearr_44987_48574[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (10))){
var inst_44935 = (state_44952[(2)]);
var state_44952__$1 = state_44952;
var statearr_44988_48581 = state_44952__$1;
(statearr_44988_48581[(2)] = inst_44935);

(statearr_44988_48581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44955 === (8))){
var inst_44929 = cljs.core.async.close_BANG_(to);
var state_44952__$1 = state_44952;
var statearr_44990_48585 = state_44952__$1;
(statearr_44990_48585[(2)] = inst_44929);

(statearr_44990_48585[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_44991 = [null,null,null,null,null,null,null,null];
(statearr_44991[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_44991[(1)] = (1));

return statearr_44991;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_44952){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_44952);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e44993){var ex__44248__auto__ = e44993;
var statearr_44994_48586 = state_44952;
(statearr_44994_48586[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_44952[(4)]))){
var statearr_44996_48587 = state_44952;
(statearr_44996_48587[(1)] = cljs.core.first((state_44952[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48588 = state_44952;
state_44952 = G__48588;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_44952){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_44952);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_44999 = f__44367__auto__();
(statearr_44999[(6)] = c__44365__auto___48544);

return statearr_44999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__45009){
var vec__45010 = p__45009;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45010,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45010,(1),null);
var job = vec__45010;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__44365__auto___48604 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_45019){
var state_val_45020 = (state_45019[(1)]);
if((state_val_45020 === (1))){
var state_45019__$1 = state_45019;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45019__$1,(2),res,v);
} else {
if((state_val_45020 === (2))){
var inst_45014 = (state_45019[(2)]);
var inst_45015 = cljs.core.async.close_BANG_(res);
var state_45019__$1 = (function (){var statearr_45026 = state_45019;
(statearr_45026[(7)] = inst_45014);

return statearr_45026;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45019__$1,inst_45015);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0 = (function (){
var statearr_45028 = [null,null,null,null,null,null,null,null];
(statearr_45028[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__);

(statearr_45028[(1)] = (1));

return statearr_45028;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1 = (function (state_45019){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_45019);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e45034){var ex__44248__auto__ = e45034;
var statearr_45035_48612 = state_45019;
(statearr_45035_48612[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_45019[(4)]))){
var statearr_45038_48616 = state_45019;
(statearr_45038_48616[(1)] = cljs.core.first((state_45019[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48617 = state_45019;
state_45019 = G__48617;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = function(state_45019){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1.call(this,state_45019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_45044 = f__44367__auto__();
(statearr_45044[(6)] = c__44365__auto___48604);

return statearr_45044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__45050){
var vec__45052 = p__45050;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45052,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45052,(1),null);
var job = vec__45052;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___48620 = n;
var __48621 = (0);
while(true){
if((__48621 < n__4741__auto___48620)){
var G__45057_48622 = type;
var G__45057_48623__$1 = (((G__45057_48622 instanceof cljs.core.Keyword))?G__45057_48622.fqn:null);
switch (G__45057_48623__$1) {
case "compute":
var c__44365__auto___48625 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48621,c__44365__auto___48625,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async){
return (function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = ((function (__48621,c__44365__auto___48625,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async){
return (function (state_45071){
var state_val_45072 = (state_45071[(1)]);
if((state_val_45072 === (1))){
var state_45071__$1 = state_45071;
var statearr_45075_48626 = state_45071__$1;
(statearr_45075_48626[(2)] = null);

(statearr_45075_48626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45072 === (2))){
var state_45071__$1 = state_45071;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45071__$1,(4),jobs);
} else {
if((state_val_45072 === (3))){
var inst_45069 = (state_45071[(2)]);
var state_45071__$1 = state_45071;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45071__$1,inst_45069);
} else {
if((state_val_45072 === (4))){
var inst_45060 = (state_45071[(2)]);
var inst_45061 = process(inst_45060);
var state_45071__$1 = state_45071;
if(cljs.core.truth_(inst_45061)){
var statearr_45077_48627 = state_45071__$1;
(statearr_45077_48627[(1)] = (5));

} else {
var statearr_45080_48628 = state_45071__$1;
(statearr_45080_48628[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45072 === (5))){
var state_45071__$1 = state_45071;
var statearr_45087_48629 = state_45071__$1;
(statearr_45087_48629[(2)] = null);

(statearr_45087_48629[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45072 === (6))){
var state_45071__$1 = state_45071;
var statearr_45088_48630 = state_45071__$1;
(statearr_45088_48630[(2)] = null);

(statearr_45088_48630[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45072 === (7))){
var inst_45067 = (state_45071[(2)]);
var state_45071__$1 = state_45071;
var statearr_45090_48632 = state_45071__$1;
(statearr_45090_48632[(2)] = inst_45067);

(statearr_45090_48632[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48621,c__44365__auto___48625,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async))
;
return ((function (__48621,switch__44244__auto__,c__44365__auto___48625,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0 = (function (){
var statearr_45095 = [null,null,null,null,null,null,null];
(statearr_45095[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__);

(statearr_45095[(1)] = (1));

return statearr_45095;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1 = (function (state_45071){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_45071);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e45097){var ex__44248__auto__ = e45097;
var statearr_45098_48636 = state_45071;
(statearr_45098_48636[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_45071[(4)]))){
var statearr_45099_48637 = state_45071;
(statearr_45099_48637[(1)] = cljs.core.first((state_45071[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48638 = state_45071;
state_45071 = G__48638;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = function(state_45071){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1.call(this,state_45071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__;
})()
;})(__48621,switch__44244__auto__,c__44365__auto___48625,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async))
})();
var state__44368__auto__ = (function (){var statearr_45102 = f__44367__auto__();
(statearr_45102[(6)] = c__44365__auto___48625);

return statearr_45102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
});})(__48621,c__44365__auto___48625,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async))
);


break;
case "async":
var c__44365__auto___48641 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48621,c__44365__auto___48641,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async){
return (function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = ((function (__48621,c__44365__auto___48641,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async){
return (function (state_45121){
var state_val_45122 = (state_45121[(1)]);
if((state_val_45122 === (1))){
var state_45121__$1 = state_45121;
var statearr_45129_48644 = state_45121__$1;
(statearr_45129_48644[(2)] = null);

(statearr_45129_48644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45122 === (2))){
var state_45121__$1 = state_45121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45121__$1,(4),jobs);
} else {
if((state_val_45122 === (3))){
var inst_45119 = (state_45121[(2)]);
var state_45121__$1 = state_45121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45121__$1,inst_45119);
} else {
if((state_val_45122 === (4))){
var inst_45110 = (state_45121[(2)]);
var inst_45112 = async(inst_45110);
var state_45121__$1 = state_45121;
if(cljs.core.truth_(inst_45112)){
var statearr_45151_48647 = state_45121__$1;
(statearr_45151_48647[(1)] = (5));

} else {
var statearr_45157_48648 = state_45121__$1;
(statearr_45157_48648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45122 === (5))){
var state_45121__$1 = state_45121;
var statearr_45168_48649 = state_45121__$1;
(statearr_45168_48649[(2)] = null);

(statearr_45168_48649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45122 === (6))){
var state_45121__$1 = state_45121;
var statearr_45175_48650 = state_45121__$1;
(statearr_45175_48650[(2)] = null);

(statearr_45175_48650[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45122 === (7))){
var inst_45117 = (state_45121[(2)]);
var state_45121__$1 = state_45121;
var statearr_45187_48652 = state_45121__$1;
(statearr_45187_48652[(2)] = inst_45117);

(statearr_45187_48652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48621,c__44365__auto___48641,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async))
;
return ((function (__48621,switch__44244__auto__,c__44365__auto___48641,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0 = (function (){
var statearr_45196 = [null,null,null,null,null,null,null];
(statearr_45196[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__);

(statearr_45196[(1)] = (1));

return statearr_45196;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1 = (function (state_45121){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_45121);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e45199){var ex__44248__auto__ = e45199;
var statearr_45201_48653 = state_45121;
(statearr_45201_48653[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_45121[(4)]))){
var statearr_45208_48654 = state_45121;
(statearr_45208_48654[(1)] = cljs.core.first((state_45121[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48655 = state_45121;
state_45121 = G__48655;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = function(state_45121){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1.call(this,state_45121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__;
})()
;})(__48621,switch__44244__auto__,c__44365__auto___48641,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async))
})();
var state__44368__auto__ = (function (){var statearr_45221 = f__44367__auto__();
(statearr_45221[(6)] = c__44365__auto___48641);

return statearr_45221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
});})(__48621,c__44365__auto___48641,G__45057_48622,G__45057_48623__$1,n__4741__auto___48620,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__45057_48623__$1)].join('')));

}

var G__48657 = (__48621 + (1));
__48621 = G__48657;
continue;
} else {
}
break;
}

var c__44365__auto___48658 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_45278){
var state_val_45279 = (state_45278[(1)]);
if((state_val_45279 === (7))){
var inst_45270 = (state_45278[(2)]);
var state_45278__$1 = state_45278;
var statearr_45306_48659 = state_45278__$1;
(statearr_45306_48659[(2)] = inst_45270);

(statearr_45306_48659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45279 === (1))){
var state_45278__$1 = state_45278;
var statearr_45307_48660 = state_45278__$1;
(statearr_45307_48660[(2)] = null);

(statearr_45307_48660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45279 === (4))){
var inst_45233 = (state_45278[(7)]);
var inst_45233__$1 = (state_45278[(2)]);
var inst_45234 = (inst_45233__$1 == null);
var state_45278__$1 = (function (){var statearr_45308 = state_45278;
(statearr_45308[(7)] = inst_45233__$1);

return statearr_45308;
})();
if(cljs.core.truth_(inst_45234)){
var statearr_45309_48662 = state_45278__$1;
(statearr_45309_48662[(1)] = (5));

} else {
var statearr_45310_48663 = state_45278__$1;
(statearr_45310_48663[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45279 === (6))){
var inst_45238 = (state_45278[(8)]);
var inst_45233 = (state_45278[(7)]);
var inst_45238__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_45259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45262 = [inst_45233,inst_45238__$1];
var inst_45263 = (new cljs.core.PersistentVector(null,2,(5),inst_45259,inst_45262,null));
var state_45278__$1 = (function (){var statearr_45316 = state_45278;
(statearr_45316[(8)] = inst_45238__$1);

return statearr_45316;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45278__$1,(8),jobs,inst_45263);
} else {
if((state_val_45279 === (3))){
var inst_45272 = (state_45278[(2)]);
var state_45278__$1 = state_45278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45278__$1,inst_45272);
} else {
if((state_val_45279 === (2))){
var state_45278__$1 = state_45278;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45278__$1,(4),from);
} else {
if((state_val_45279 === (9))){
var inst_45267 = (state_45278[(2)]);
var state_45278__$1 = (function (){var statearr_45318 = state_45278;
(statearr_45318[(9)] = inst_45267);

return statearr_45318;
})();
var statearr_45323_48667 = state_45278__$1;
(statearr_45323_48667[(2)] = null);

(statearr_45323_48667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45279 === (5))){
var inst_45236 = cljs.core.async.close_BANG_(jobs);
var state_45278__$1 = state_45278;
var statearr_45327_48668 = state_45278__$1;
(statearr_45327_48668[(2)] = inst_45236);

(statearr_45327_48668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45279 === (8))){
var inst_45238 = (state_45278[(8)]);
var inst_45265 = (state_45278[(2)]);
var state_45278__$1 = (function (){var statearr_45336 = state_45278;
(statearr_45336[(10)] = inst_45265);

return statearr_45336;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45278__$1,(9),results,inst_45238);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0 = (function (){
var statearr_45344 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45344[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__);

(statearr_45344[(1)] = (1));

return statearr_45344;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1 = (function (state_45278){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_45278);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e45346){var ex__44248__auto__ = e45346;
var statearr_45347_48673 = state_45278;
(statearr_45347_48673[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_45278[(4)]))){
var statearr_45350_48675 = state_45278;
(statearr_45350_48675[(1)] = cljs.core.first((state_45278[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48688 = state_45278;
state_45278 = G__48688;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = function(state_45278){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1.call(this,state_45278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_45358 = f__44367__auto__();
(statearr_45358[(6)] = c__44365__auto___48658);

return statearr_45358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


var c__44365__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_45419){
var state_val_45420 = (state_45419[(1)]);
if((state_val_45420 === (7))){
var inst_45415 = (state_45419[(2)]);
var state_45419__$1 = state_45419;
var statearr_45430_48691 = state_45419__$1;
(statearr_45430_48691[(2)] = inst_45415);

(statearr_45430_48691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (20))){
var state_45419__$1 = state_45419;
var statearr_45432_48692 = state_45419__$1;
(statearr_45432_48692[(2)] = null);

(statearr_45432_48692[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (1))){
var state_45419__$1 = state_45419;
var statearr_45434_48696 = state_45419__$1;
(statearr_45434_48696[(2)] = null);

(statearr_45434_48696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (4))){
var inst_45370 = (state_45419[(7)]);
var inst_45370__$1 = (state_45419[(2)]);
var inst_45372 = (inst_45370__$1 == null);
var state_45419__$1 = (function (){var statearr_45446 = state_45419;
(statearr_45446[(7)] = inst_45370__$1);

return statearr_45446;
})();
if(cljs.core.truth_(inst_45372)){
var statearr_45450_48697 = state_45419__$1;
(statearr_45450_48697[(1)] = (5));

} else {
var statearr_45454_48699 = state_45419__$1;
(statearr_45454_48699[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (15))){
var inst_45394 = (state_45419[(8)]);
var state_45419__$1 = state_45419;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45419__$1,(18),to,inst_45394);
} else {
if((state_val_45420 === (21))){
var inst_45409 = (state_45419[(2)]);
var state_45419__$1 = state_45419;
var statearr_45462_48706 = state_45419__$1;
(statearr_45462_48706[(2)] = inst_45409);

(statearr_45462_48706[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (13))){
var inst_45411 = (state_45419[(2)]);
var state_45419__$1 = (function (){var statearr_45466 = state_45419;
(statearr_45466[(9)] = inst_45411);

return statearr_45466;
})();
var statearr_45468_48713 = state_45419__$1;
(statearr_45468_48713[(2)] = null);

(statearr_45468_48713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (6))){
var inst_45370 = (state_45419[(7)]);
var state_45419__$1 = state_45419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45419__$1,(11),inst_45370);
} else {
if((state_val_45420 === (17))){
var inst_45402 = (state_45419[(2)]);
var state_45419__$1 = state_45419;
if(cljs.core.truth_(inst_45402)){
var statearr_45472_48718 = state_45419__$1;
(statearr_45472_48718[(1)] = (19));

} else {
var statearr_45473_48719 = state_45419__$1;
(statearr_45473_48719[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (3))){
var inst_45417 = (state_45419[(2)]);
var state_45419__$1 = state_45419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45419__$1,inst_45417);
} else {
if((state_val_45420 === (12))){
var inst_45384 = (state_45419[(10)]);
var state_45419__$1 = state_45419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45419__$1,(14),inst_45384);
} else {
if((state_val_45420 === (2))){
var state_45419__$1 = state_45419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45419__$1,(4),results);
} else {
if((state_val_45420 === (19))){
var state_45419__$1 = state_45419;
var statearr_45478_48723 = state_45419__$1;
(statearr_45478_48723[(2)] = null);

(statearr_45478_48723[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (11))){
var inst_45384 = (state_45419[(2)]);
var state_45419__$1 = (function (){var statearr_45479 = state_45419;
(statearr_45479[(10)] = inst_45384);

return statearr_45479;
})();
var statearr_45480_48724 = state_45419__$1;
(statearr_45480_48724[(2)] = null);

(statearr_45480_48724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (9))){
var state_45419__$1 = state_45419;
var statearr_45481_48725 = state_45419__$1;
(statearr_45481_48725[(2)] = null);

(statearr_45481_48725[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (5))){
var state_45419__$1 = state_45419;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45484_48728 = state_45419__$1;
(statearr_45484_48728[(1)] = (8));

} else {
var statearr_45485_48729 = state_45419__$1;
(statearr_45485_48729[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (14))){
var inst_45396 = (state_45419[(11)]);
var inst_45394 = (state_45419[(8)]);
var inst_45394__$1 = (state_45419[(2)]);
var inst_45395 = (inst_45394__$1 == null);
var inst_45396__$1 = cljs.core.not(inst_45395);
var state_45419__$1 = (function (){var statearr_45487 = state_45419;
(statearr_45487[(11)] = inst_45396__$1);

(statearr_45487[(8)] = inst_45394__$1);

return statearr_45487;
})();
if(inst_45396__$1){
var statearr_45488_48732 = state_45419__$1;
(statearr_45488_48732[(1)] = (15));

} else {
var statearr_45489_48733 = state_45419__$1;
(statearr_45489_48733[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (16))){
var inst_45396 = (state_45419[(11)]);
var state_45419__$1 = state_45419;
var statearr_45494_48734 = state_45419__$1;
(statearr_45494_48734[(2)] = inst_45396);

(statearr_45494_48734[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (10))){
var inst_45379 = (state_45419[(2)]);
var state_45419__$1 = state_45419;
var statearr_45503_48735 = state_45419__$1;
(statearr_45503_48735[(2)] = inst_45379);

(statearr_45503_48735[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (18))){
var inst_45399 = (state_45419[(2)]);
var state_45419__$1 = state_45419;
var statearr_45511_48736 = state_45419__$1;
(statearr_45511_48736[(2)] = inst_45399);

(statearr_45511_48736[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45420 === (8))){
var inst_45376 = cljs.core.async.close_BANG_(to);
var state_45419__$1 = state_45419;
var statearr_45516_48738 = state_45419__$1;
(statearr_45516_48738[(2)] = inst_45376);

(statearr_45516_48738[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0 = (function (){
var statearr_45520 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45520[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__);

(statearr_45520[(1)] = (1));

return statearr_45520;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1 = (function (state_45419){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_45419);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e45522){var ex__44248__auto__ = e45522;
var statearr_45524_48739 = state_45419;
(statearr_45524_48739[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_45419[(4)]))){
var statearr_45530_48741 = state_45419;
(statearr_45530_48741[(1)] = cljs.core.first((state_45419[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48742 = state_45419;
state_45419 = G__48742;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__ = function(state_45419){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1.call(this,state_45419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44245__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_45535 = f__44367__auto__();
(statearr_45535[(6)] = c__44365__auto__);

return statearr_45535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));

return c__44365__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__45543 = arguments.length;
switch (G__45543) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__45553 = arguments.length;
switch (G__45553) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__45580 = arguments.length;
switch (G__45580) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__44365__auto___48756 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_45621){
var state_val_45622 = (state_45621[(1)]);
if((state_val_45622 === (7))){
var inst_45617 = (state_45621[(2)]);
var state_45621__$1 = state_45621;
var statearr_45631_48757 = state_45621__$1;
(statearr_45631_48757[(2)] = inst_45617);

(statearr_45631_48757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (1))){
var state_45621__$1 = state_45621;
var statearr_45633_48758 = state_45621__$1;
(statearr_45633_48758[(2)] = null);

(statearr_45633_48758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (4))){
var inst_45595 = (state_45621[(7)]);
var inst_45595__$1 = (state_45621[(2)]);
var inst_45596 = (inst_45595__$1 == null);
var state_45621__$1 = (function (){var statearr_45639 = state_45621;
(statearr_45639[(7)] = inst_45595__$1);

return statearr_45639;
})();
if(cljs.core.truth_(inst_45596)){
var statearr_45641_48768 = state_45621__$1;
(statearr_45641_48768[(1)] = (5));

} else {
var statearr_45644_48769 = state_45621__$1;
(statearr_45644_48769[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (13))){
var state_45621__$1 = state_45621;
var statearr_45647_48771 = state_45621__$1;
(statearr_45647_48771[(2)] = null);

(statearr_45647_48771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (6))){
var inst_45595 = (state_45621[(7)]);
var inst_45602 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45595) : p.call(null,inst_45595));
var state_45621__$1 = state_45621;
if(cljs.core.truth_(inst_45602)){
var statearr_45652_48774 = state_45621__$1;
(statearr_45652_48774[(1)] = (9));

} else {
var statearr_45656_48775 = state_45621__$1;
(statearr_45656_48775[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (3))){
var inst_45619 = (state_45621[(2)]);
var state_45621__$1 = state_45621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45621__$1,inst_45619);
} else {
if((state_val_45622 === (12))){
var state_45621__$1 = state_45621;
var statearr_45683_48778 = state_45621__$1;
(statearr_45683_48778[(2)] = null);

(statearr_45683_48778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (2))){
var state_45621__$1 = state_45621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45621__$1,(4),ch);
} else {
if((state_val_45622 === (11))){
var inst_45595 = (state_45621[(7)]);
var inst_45608 = (state_45621[(2)]);
var state_45621__$1 = state_45621;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45621__$1,(8),inst_45608,inst_45595);
} else {
if((state_val_45622 === (9))){
var state_45621__$1 = state_45621;
var statearr_45697_48781 = state_45621__$1;
(statearr_45697_48781[(2)] = tc);

(statearr_45697_48781[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (5))){
var inst_45598 = cljs.core.async.close_BANG_(tc);
var inst_45599 = cljs.core.async.close_BANG_(fc);
var state_45621__$1 = (function (){var statearr_45701 = state_45621;
(statearr_45701[(8)] = inst_45598);

return statearr_45701;
})();
var statearr_45704_48784 = state_45621__$1;
(statearr_45704_48784[(2)] = inst_45599);

(statearr_45704_48784[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (14))){
var inst_45615 = (state_45621[(2)]);
var state_45621__$1 = state_45621;
var statearr_45706_48786 = state_45621__$1;
(statearr_45706_48786[(2)] = inst_45615);

(statearr_45706_48786[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (10))){
var state_45621__$1 = state_45621;
var statearr_45710_48787 = state_45621__$1;
(statearr_45710_48787[(2)] = fc);

(statearr_45710_48787[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45622 === (8))){
var inst_45610 = (state_45621[(2)]);
var state_45621__$1 = state_45621;
if(cljs.core.truth_(inst_45610)){
var statearr_45720_48788 = state_45621__$1;
(statearr_45720_48788[(1)] = (12));

} else {
var statearr_45724_48789 = state_45621__$1;
(statearr_45724_48789[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_45732 = [null,null,null,null,null,null,null,null,null];
(statearr_45732[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_45732[(1)] = (1));

return statearr_45732;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_45621){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_45621);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e45733){var ex__44248__auto__ = e45733;
var statearr_45736_48795 = state_45621;
(statearr_45736_48795[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_45621[(4)]))){
var statearr_45744_48796 = state_45621;
(statearr_45744_48796[(1)] = cljs.core.first((state_45621[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48799 = state_45621;
state_45621 = G__48799;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_45621){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_45621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_45774 = f__44367__auto__();
(statearr_45774[(6)] = c__44365__auto___48756);

return statearr_45774;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__44365__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_45894){
var state_val_45896 = (state_45894[(1)]);
if((state_val_45896 === (7))){
var inst_45873 = (state_45894[(2)]);
var state_45894__$1 = state_45894;
var statearr_45925_48802 = state_45894__$1;
(statearr_45925_48802[(2)] = inst_45873);

(statearr_45925_48802[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (1))){
var inst_45811 = init;
var inst_45820 = inst_45811;
var state_45894__$1 = (function (){var statearr_45930 = state_45894;
(statearr_45930[(7)] = inst_45820);

return statearr_45930;
})();
var statearr_45935_48803 = state_45894__$1;
(statearr_45935_48803[(2)] = null);

(statearr_45935_48803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (4))){
var inst_45836 = (state_45894[(8)]);
var inst_45836__$1 = (state_45894[(2)]);
var inst_45842 = (inst_45836__$1 == null);
var state_45894__$1 = (function (){var statearr_45936 = state_45894;
(statearr_45936[(8)] = inst_45836__$1);

return statearr_45936;
})();
if(cljs.core.truth_(inst_45842)){
var statearr_45940_48807 = state_45894__$1;
(statearr_45940_48807[(1)] = (5));

} else {
var statearr_45941_48808 = state_45894__$1;
(statearr_45941_48808[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (6))){
var inst_45820 = (state_45894[(7)]);
var inst_45854 = (state_45894[(9)]);
var inst_45836 = (state_45894[(8)]);
var inst_45854__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_45820,inst_45836) : f.call(null,inst_45820,inst_45836));
var inst_45856 = cljs.core.reduced_QMARK_(inst_45854__$1);
var state_45894__$1 = (function (){var statearr_45944 = state_45894;
(statearr_45944[(9)] = inst_45854__$1);

return statearr_45944;
})();
if(inst_45856){
var statearr_45947_48811 = state_45894__$1;
(statearr_45947_48811[(1)] = (8));

} else {
var statearr_45951_48813 = state_45894__$1;
(statearr_45951_48813[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (3))){
var inst_45883 = (state_45894[(2)]);
var state_45894__$1 = state_45894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45894__$1,inst_45883);
} else {
if((state_val_45896 === (2))){
var state_45894__$1 = state_45894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45894__$1,(4),ch);
} else {
if((state_val_45896 === (9))){
var inst_45854 = (state_45894[(9)]);
var inst_45820 = inst_45854;
var state_45894__$1 = (function (){var statearr_45967 = state_45894;
(statearr_45967[(7)] = inst_45820);

return statearr_45967;
})();
var statearr_45974_48817 = state_45894__$1;
(statearr_45974_48817[(2)] = null);

(statearr_45974_48817[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (5))){
var inst_45820 = (state_45894[(7)]);
var state_45894__$1 = state_45894;
var statearr_45975_48818 = state_45894__$1;
(statearr_45975_48818[(2)] = inst_45820);

(statearr_45975_48818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (10))){
var inst_45870 = (state_45894[(2)]);
var state_45894__$1 = state_45894;
var statearr_45980_48820 = state_45894__$1;
(statearr_45980_48820[(2)] = inst_45870);

(statearr_45980_48820[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45896 === (8))){
var inst_45854 = (state_45894[(9)]);
var inst_45865 = cljs.core.deref(inst_45854);
var state_45894__$1 = state_45894;
var statearr_45982_48823 = state_45894__$1;
(statearr_45982_48823[(2)] = inst_45865);

(statearr_45982_48823[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__44245__auto__ = null;
var cljs$core$async$reduce_$_state_machine__44245__auto____0 = (function (){
var statearr_45987 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45987[(0)] = cljs$core$async$reduce_$_state_machine__44245__auto__);

(statearr_45987[(1)] = (1));

return statearr_45987;
});
var cljs$core$async$reduce_$_state_machine__44245__auto____1 = (function (state_45894){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_45894);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e45990){var ex__44248__auto__ = e45990;
var statearr_45992_48827 = state_45894;
(statearr_45992_48827[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_45894[(4)]))){
var statearr_45993_48829 = state_45894;
(statearr_45993_48829[(1)] = cljs.core.first((state_45894[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48830 = state_45894;
state_45894 = G__48830;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__44245__auto__ = function(state_45894){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__44245__auto____1.call(this,state_45894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__44245__auto____0;
cljs$core$async$reduce_$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__44245__auto____1;
return cljs$core$async$reduce_$_state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_45999 = f__44367__auto__();
(statearr_45999[(6)] = c__44365__auto__);

return statearr_45999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));

return c__44365__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__44365__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_46010){
var state_val_46011 = (state_46010[(1)]);
if((state_val_46011 === (1))){
var inst_46004 = cljs.core.async.reduce(f__$1,init,ch);
var state_46010__$1 = state_46010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46010__$1,(2),inst_46004);
} else {
if((state_val_46011 === (2))){
var inst_46006 = (state_46010[(2)]);
var inst_46008 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_46006) : f__$1.call(null,inst_46006));
var state_46010__$1 = state_46010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46010__$1,inst_46008);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__44245__auto__ = null;
var cljs$core$async$transduce_$_state_machine__44245__auto____0 = (function (){
var statearr_46016 = [null,null,null,null,null,null,null];
(statearr_46016[(0)] = cljs$core$async$transduce_$_state_machine__44245__auto__);

(statearr_46016[(1)] = (1));

return statearr_46016;
});
var cljs$core$async$transduce_$_state_machine__44245__auto____1 = (function (state_46010){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_46010);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e46022){var ex__44248__auto__ = e46022;
var statearr_46023_48844 = state_46010;
(statearr_46023_48844[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_46010[(4)]))){
var statearr_46024_48845 = state_46010;
(statearr_46024_48845[(1)] = cljs.core.first((state_46010[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48848 = state_46010;
state_46010 = G__48848;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__44245__auto__ = function(state_46010){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__44245__auto____1.call(this,state_46010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__44245__auto____0;
cljs$core$async$transduce_$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__44245__auto____1;
return cljs$core$async$transduce_$_state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_46025 = f__44367__auto__();
(statearr_46025[(6)] = c__44365__auto__);

return statearr_46025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));

return c__44365__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__46030 = arguments.length;
switch (G__46030) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__44365__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_46071){
var state_val_46072 = (state_46071[(1)]);
if((state_val_46072 === (7))){
var inst_46053 = (state_46071[(2)]);
var state_46071__$1 = state_46071;
var statearr_46087_48863 = state_46071__$1;
(statearr_46087_48863[(2)] = inst_46053);

(statearr_46087_48863[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (1))){
var inst_46043 = cljs.core.seq(coll);
var inst_46048 = inst_46043;
var state_46071__$1 = (function (){var statearr_46089 = state_46071;
(statearr_46089[(7)] = inst_46048);

return statearr_46089;
})();
var statearr_46090_48869 = state_46071__$1;
(statearr_46090_48869[(2)] = null);

(statearr_46090_48869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (4))){
var inst_46048 = (state_46071[(7)]);
var inst_46051 = cljs.core.first(inst_46048);
var state_46071__$1 = state_46071;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46071__$1,(7),ch,inst_46051);
} else {
if((state_val_46072 === (13))){
var inst_46065 = (state_46071[(2)]);
var state_46071__$1 = state_46071;
var statearr_46091_48872 = state_46071__$1;
(statearr_46091_48872[(2)] = inst_46065);

(statearr_46091_48872[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (6))){
var inst_46056 = (state_46071[(2)]);
var state_46071__$1 = state_46071;
if(cljs.core.truth_(inst_46056)){
var statearr_46092_48873 = state_46071__$1;
(statearr_46092_48873[(1)] = (8));

} else {
var statearr_46093_48877 = state_46071__$1;
(statearr_46093_48877[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (3))){
var inst_46069 = (state_46071[(2)]);
var state_46071__$1 = state_46071;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46071__$1,inst_46069);
} else {
if((state_val_46072 === (12))){
var state_46071__$1 = state_46071;
var statearr_46097_48885 = state_46071__$1;
(statearr_46097_48885[(2)] = null);

(statearr_46097_48885[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (2))){
var inst_46048 = (state_46071[(7)]);
var state_46071__$1 = state_46071;
if(cljs.core.truth_(inst_46048)){
var statearr_46100_48888 = state_46071__$1;
(statearr_46100_48888[(1)] = (4));

} else {
var statearr_46101_48890 = state_46071__$1;
(statearr_46101_48890[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (11))){
var inst_46062 = cljs.core.async.close_BANG_(ch);
var state_46071__$1 = state_46071;
var statearr_46102_48893 = state_46071__$1;
(statearr_46102_48893[(2)] = inst_46062);

(statearr_46102_48893[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (9))){
var state_46071__$1 = state_46071;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46111_48894 = state_46071__$1;
(statearr_46111_48894[(1)] = (11));

} else {
var statearr_46112_48895 = state_46071__$1;
(statearr_46112_48895[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (5))){
var inst_46048 = (state_46071[(7)]);
var state_46071__$1 = state_46071;
var statearr_46113_48896 = state_46071__$1;
(statearr_46113_48896[(2)] = inst_46048);

(statearr_46113_48896[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (10))){
var inst_46067 = (state_46071[(2)]);
var state_46071__$1 = state_46071;
var statearr_46115_48899 = state_46071__$1;
(statearr_46115_48899[(2)] = inst_46067);

(statearr_46115_48899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46072 === (8))){
var inst_46048 = (state_46071[(7)]);
var inst_46058 = cljs.core.next(inst_46048);
var inst_46048__$1 = inst_46058;
var state_46071__$1 = (function (){var statearr_46117 = state_46071;
(statearr_46117[(7)] = inst_46048__$1);

return statearr_46117;
})();
var statearr_46120_48903 = state_46071__$1;
(statearr_46120_48903[(2)] = null);

(statearr_46120_48903[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_46125 = [null,null,null,null,null,null,null,null];
(statearr_46125[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_46125[(1)] = (1));

return statearr_46125;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_46071){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_46071);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e46129){var ex__44248__auto__ = e46129;
var statearr_46133_48913 = state_46071;
(statearr_46133_48913[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_46071[(4)]))){
var statearr_46134_48914 = state_46071;
(statearr_46134_48914[(1)] = cljs.core.first((state_46071[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48915 = state_46071;
state_46071 = G__48915;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_46071){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_46071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_46136 = f__44367__auto__();
(statearr_46136[(6)] = c__44365__auto__);

return statearr_46136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));

return c__44365__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__46146 = arguments.length;
switch (G__46146) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_48928 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_48928(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_48930 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_48930(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_48936 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_48936(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_48947 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_48947(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46185 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46185 = (function (ch,cs,meta46186){
this.ch = ch;
this.cs = cs;
this.meta46186 = meta46186;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46185.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46187,meta46186__$1){
var self__ = this;
var _46187__$1 = this;
return (new cljs.core.async.t_cljs$core$async46185(self__.ch,self__.cs,meta46186__$1));
}));

(cljs.core.async.t_cljs$core$async46185.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46187){
var self__ = this;
var _46187__$1 = this;
return self__.meta46186;
}));

(cljs.core.async.t_cljs$core$async46185.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46185.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46185.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46185.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async46185.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async46185.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async46185.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta46186","meta46186",-578311065,null)], null);
}));

(cljs.core.async.t_cljs$core$async46185.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46185.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46185");

(cljs.core.async.t_cljs$core$async46185.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46185");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46185.
 */
cljs.core.async.__GT_t_cljs$core$async46185 = (function cljs$core$async$mult_$___GT_t_cljs$core$async46185(ch__$1,cs__$1,meta46186){
return (new cljs.core.async.t_cljs$core$async46185(ch__$1,cs__$1,meta46186));
});

}

return (new cljs.core.async.t_cljs$core$async46185(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__44365__auto___48962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_46359){
var state_val_46360 = (state_46359[(1)]);
if((state_val_46360 === (7))){
var inst_46353 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46365_48963 = state_46359__$1;
(statearr_46365_48963[(2)] = inst_46353);

(statearr_46365_48963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (20))){
var inst_46255 = (state_46359[(7)]);
var inst_46267 = cljs.core.first(inst_46255);
var inst_46269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46267,(0),null);
var inst_46270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46267,(1),null);
var state_46359__$1 = (function (){var statearr_46366 = state_46359;
(statearr_46366[(8)] = inst_46269);

return statearr_46366;
})();
if(cljs.core.truth_(inst_46270)){
var statearr_46371_48965 = state_46359__$1;
(statearr_46371_48965[(1)] = (22));

} else {
var statearr_46376_48966 = state_46359__$1;
(statearr_46376_48966[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (27))){
var inst_46298 = (state_46359[(9)]);
var inst_46300 = (state_46359[(10)]);
var inst_46305 = (state_46359[(11)]);
var inst_46218 = (state_46359[(12)]);
var inst_46305__$1 = cljs.core._nth(inst_46298,inst_46300);
var inst_46306 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46305__$1,inst_46218,done);
var state_46359__$1 = (function (){var statearr_46390 = state_46359;
(statearr_46390[(11)] = inst_46305__$1);

return statearr_46390;
})();
if(cljs.core.truth_(inst_46306)){
var statearr_46391_48970 = state_46359__$1;
(statearr_46391_48970[(1)] = (30));

} else {
var statearr_46392_48972 = state_46359__$1;
(statearr_46392_48972[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (1))){
var state_46359__$1 = state_46359;
var statearr_46393_48973 = state_46359__$1;
(statearr_46393_48973[(2)] = null);

(statearr_46393_48973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (24))){
var inst_46255 = (state_46359[(7)]);
var inst_46275 = (state_46359[(2)]);
var inst_46276 = cljs.core.next(inst_46255);
var inst_46228 = inst_46276;
var inst_46229 = null;
var inst_46230 = (0);
var inst_46231 = (0);
var state_46359__$1 = (function (){var statearr_46394 = state_46359;
(statearr_46394[(13)] = inst_46230);

(statearr_46394[(14)] = inst_46229);

(statearr_46394[(15)] = inst_46231);

(statearr_46394[(16)] = inst_46275);

(statearr_46394[(17)] = inst_46228);

return statearr_46394;
})();
var statearr_46395_48975 = state_46359__$1;
(statearr_46395_48975[(2)] = null);

(statearr_46395_48975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (39))){
var state_46359__$1 = state_46359;
var statearr_46399_48977 = state_46359__$1;
(statearr_46399_48977[(2)] = null);

(statearr_46399_48977[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (4))){
var inst_46218 = (state_46359[(12)]);
var inst_46218__$1 = (state_46359[(2)]);
var inst_46219 = (inst_46218__$1 == null);
var state_46359__$1 = (function (){var statearr_46401 = state_46359;
(statearr_46401[(12)] = inst_46218__$1);

return statearr_46401;
})();
if(cljs.core.truth_(inst_46219)){
var statearr_46404_48978 = state_46359__$1;
(statearr_46404_48978[(1)] = (5));

} else {
var statearr_46406_48980 = state_46359__$1;
(statearr_46406_48980[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (15))){
var inst_46230 = (state_46359[(13)]);
var inst_46229 = (state_46359[(14)]);
var inst_46231 = (state_46359[(15)]);
var inst_46228 = (state_46359[(17)]);
var inst_46251 = (state_46359[(2)]);
var inst_46252 = (inst_46231 + (1));
var tmp46396 = inst_46230;
var tmp46397 = inst_46229;
var tmp46398 = inst_46228;
var inst_46228__$1 = tmp46398;
var inst_46229__$1 = tmp46397;
var inst_46230__$1 = tmp46396;
var inst_46231__$1 = inst_46252;
var state_46359__$1 = (function (){var statearr_46408 = state_46359;
(statearr_46408[(13)] = inst_46230__$1);

(statearr_46408[(14)] = inst_46229__$1);

(statearr_46408[(15)] = inst_46231__$1);

(statearr_46408[(18)] = inst_46251);

(statearr_46408[(17)] = inst_46228__$1);

return statearr_46408;
})();
var statearr_46409_48983 = state_46359__$1;
(statearr_46409_48983[(2)] = null);

(statearr_46409_48983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (21))){
var inst_46279 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46416_48985 = state_46359__$1;
(statearr_46416_48985[(2)] = inst_46279);

(statearr_46416_48985[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (31))){
var inst_46305 = (state_46359[(11)]);
var inst_46309 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46305);
var state_46359__$1 = state_46359;
var statearr_46419_48990 = state_46359__$1;
(statearr_46419_48990[(2)] = inst_46309);

(statearr_46419_48990[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (32))){
var inst_46298 = (state_46359[(9)]);
var inst_46300 = (state_46359[(10)]);
var inst_46297 = (state_46359[(19)]);
var inst_46299 = (state_46359[(20)]);
var inst_46311 = (state_46359[(2)]);
var inst_46312 = (inst_46300 + (1));
var tmp46413 = inst_46298;
var tmp46414 = inst_46297;
var tmp46415 = inst_46299;
var inst_46297__$1 = tmp46414;
var inst_46298__$1 = tmp46413;
var inst_46299__$1 = tmp46415;
var inst_46300__$1 = inst_46312;
var state_46359__$1 = (function (){var statearr_46424 = state_46359;
(statearr_46424[(9)] = inst_46298__$1);

(statearr_46424[(10)] = inst_46300__$1);

(statearr_46424[(21)] = inst_46311);

(statearr_46424[(19)] = inst_46297__$1);

(statearr_46424[(20)] = inst_46299__$1);

return statearr_46424;
})();
var statearr_46430_48993 = state_46359__$1;
(statearr_46430_48993[(2)] = null);

(statearr_46430_48993[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (40))){
var inst_46325 = (state_46359[(22)]);
var inst_46329 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46325);
var state_46359__$1 = state_46359;
var statearr_46435_48998 = state_46359__$1;
(statearr_46435_48998[(2)] = inst_46329);

(statearr_46435_48998[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (33))){
var inst_46315 = (state_46359[(23)]);
var inst_46317 = cljs.core.chunked_seq_QMARK_(inst_46315);
var state_46359__$1 = state_46359;
if(inst_46317){
var statearr_46444_49001 = state_46359__$1;
(statearr_46444_49001[(1)] = (36));

} else {
var statearr_46447_49002 = state_46359__$1;
(statearr_46447_49002[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (13))){
var inst_46244 = (state_46359[(24)]);
var inst_46248 = cljs.core.async.close_BANG_(inst_46244);
var state_46359__$1 = state_46359;
var statearr_46452_49003 = state_46359__$1;
(statearr_46452_49003[(2)] = inst_46248);

(statearr_46452_49003[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (22))){
var inst_46269 = (state_46359[(8)]);
var inst_46272 = cljs.core.async.close_BANG_(inst_46269);
var state_46359__$1 = state_46359;
var statearr_46458_49011 = state_46359__$1;
(statearr_46458_49011[(2)] = inst_46272);

(statearr_46458_49011[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (36))){
var inst_46315 = (state_46359[(23)]);
var inst_46320 = cljs.core.chunk_first(inst_46315);
var inst_46321 = cljs.core.chunk_rest(inst_46315);
var inst_46322 = cljs.core.count(inst_46320);
var inst_46297 = inst_46321;
var inst_46298 = inst_46320;
var inst_46299 = inst_46322;
var inst_46300 = (0);
var state_46359__$1 = (function (){var statearr_46467 = state_46359;
(statearr_46467[(9)] = inst_46298);

(statearr_46467[(10)] = inst_46300);

(statearr_46467[(19)] = inst_46297);

(statearr_46467[(20)] = inst_46299);

return statearr_46467;
})();
var statearr_46477_49018 = state_46359__$1;
(statearr_46477_49018[(2)] = null);

(statearr_46477_49018[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (41))){
var inst_46315 = (state_46359[(23)]);
var inst_46331 = (state_46359[(2)]);
var inst_46332 = cljs.core.next(inst_46315);
var inst_46297 = inst_46332;
var inst_46298 = null;
var inst_46299 = (0);
var inst_46300 = (0);
var state_46359__$1 = (function (){var statearr_46487 = state_46359;
(statearr_46487[(9)] = inst_46298);

(statearr_46487[(10)] = inst_46300);

(statearr_46487[(19)] = inst_46297);

(statearr_46487[(25)] = inst_46331);

(statearr_46487[(20)] = inst_46299);

return statearr_46487;
})();
var statearr_46506_49023 = state_46359__$1;
(statearr_46506_49023[(2)] = null);

(statearr_46506_49023[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (43))){
var state_46359__$1 = state_46359;
var statearr_46513_49029 = state_46359__$1;
(statearr_46513_49029[(2)] = null);

(statearr_46513_49029[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (29))){
var inst_46340 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46514_49032 = state_46359__$1;
(statearr_46514_49032[(2)] = inst_46340);

(statearr_46514_49032[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (44))){
var inst_46349 = (state_46359[(2)]);
var state_46359__$1 = (function (){var statearr_46516 = state_46359;
(statearr_46516[(26)] = inst_46349);

return statearr_46516;
})();
var statearr_46518_49034 = state_46359__$1;
(statearr_46518_49034[(2)] = null);

(statearr_46518_49034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (6))){
var inst_46289 = (state_46359[(27)]);
var inst_46288 = cljs.core.deref(cs);
var inst_46289__$1 = cljs.core.keys(inst_46288);
var inst_46290 = cljs.core.count(inst_46289__$1);
var inst_46291 = cljs.core.reset_BANG_(dctr,inst_46290);
var inst_46296 = cljs.core.seq(inst_46289__$1);
var inst_46297 = inst_46296;
var inst_46298 = null;
var inst_46299 = (0);
var inst_46300 = (0);
var state_46359__$1 = (function (){var statearr_46525 = state_46359;
(statearr_46525[(9)] = inst_46298);

(statearr_46525[(10)] = inst_46300);

(statearr_46525[(19)] = inst_46297);

(statearr_46525[(20)] = inst_46299);

(statearr_46525[(28)] = inst_46291);

(statearr_46525[(27)] = inst_46289__$1);

return statearr_46525;
})();
var statearr_46529_49045 = state_46359__$1;
(statearr_46529_49045[(2)] = null);

(statearr_46529_49045[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (28))){
var inst_46297 = (state_46359[(19)]);
var inst_46315 = (state_46359[(23)]);
var inst_46315__$1 = cljs.core.seq(inst_46297);
var state_46359__$1 = (function (){var statearr_46533 = state_46359;
(statearr_46533[(23)] = inst_46315__$1);

return statearr_46533;
})();
if(inst_46315__$1){
var statearr_46535_49046 = state_46359__$1;
(statearr_46535_49046[(1)] = (33));

} else {
var statearr_46538_49047 = state_46359__$1;
(statearr_46538_49047[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (25))){
var inst_46300 = (state_46359[(10)]);
var inst_46299 = (state_46359[(20)]);
var inst_46302 = (inst_46300 < inst_46299);
var inst_46303 = inst_46302;
var state_46359__$1 = state_46359;
if(cljs.core.truth_(inst_46303)){
var statearr_46549_49054 = state_46359__$1;
(statearr_46549_49054[(1)] = (27));

} else {
var statearr_46550_49055 = state_46359__$1;
(statearr_46550_49055[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (34))){
var state_46359__$1 = state_46359;
var statearr_46551_49056 = state_46359__$1;
(statearr_46551_49056[(2)] = null);

(statearr_46551_49056[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (17))){
var state_46359__$1 = state_46359;
var statearr_46552_49057 = state_46359__$1;
(statearr_46552_49057[(2)] = null);

(statearr_46552_49057[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (3))){
var inst_46355 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46359__$1,inst_46355);
} else {
if((state_val_46360 === (12))){
var inst_46284 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46559_49060 = state_46359__$1;
(statearr_46559_49060[(2)] = inst_46284);

(statearr_46559_49060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (2))){
var state_46359__$1 = state_46359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46359__$1,(4),ch);
} else {
if((state_val_46360 === (23))){
var state_46359__$1 = state_46359;
var statearr_46560_49063 = state_46359__$1;
(statearr_46560_49063[(2)] = null);

(statearr_46560_49063[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (35))){
var inst_46338 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46562_49065 = state_46359__$1;
(statearr_46562_49065[(2)] = inst_46338);

(statearr_46562_49065[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (19))){
var inst_46255 = (state_46359[(7)]);
var inst_46259 = cljs.core.chunk_first(inst_46255);
var inst_46260 = cljs.core.chunk_rest(inst_46255);
var inst_46261 = cljs.core.count(inst_46259);
var inst_46228 = inst_46260;
var inst_46229 = inst_46259;
var inst_46230 = inst_46261;
var inst_46231 = (0);
var state_46359__$1 = (function (){var statearr_46569 = state_46359;
(statearr_46569[(13)] = inst_46230);

(statearr_46569[(14)] = inst_46229);

(statearr_46569[(15)] = inst_46231);

(statearr_46569[(17)] = inst_46228);

return statearr_46569;
})();
var statearr_46570_49069 = state_46359__$1;
(statearr_46570_49069[(2)] = null);

(statearr_46570_49069[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (11))){
var inst_46255 = (state_46359[(7)]);
var inst_46228 = (state_46359[(17)]);
var inst_46255__$1 = cljs.core.seq(inst_46228);
var state_46359__$1 = (function (){var statearr_46571 = state_46359;
(statearr_46571[(7)] = inst_46255__$1);

return statearr_46571;
})();
if(inst_46255__$1){
var statearr_46572_49070 = state_46359__$1;
(statearr_46572_49070[(1)] = (16));

} else {
var statearr_46573_49071 = state_46359__$1;
(statearr_46573_49071[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (9))){
var inst_46286 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46574_49072 = state_46359__$1;
(statearr_46574_49072[(2)] = inst_46286);

(statearr_46574_49072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (5))){
var inst_46226 = cljs.core.deref(cs);
var inst_46227 = cljs.core.seq(inst_46226);
var inst_46228 = inst_46227;
var inst_46229 = null;
var inst_46230 = (0);
var inst_46231 = (0);
var state_46359__$1 = (function (){var statearr_46576 = state_46359;
(statearr_46576[(13)] = inst_46230);

(statearr_46576[(14)] = inst_46229);

(statearr_46576[(15)] = inst_46231);

(statearr_46576[(17)] = inst_46228);

return statearr_46576;
})();
var statearr_46580_49080 = state_46359__$1;
(statearr_46580_49080[(2)] = null);

(statearr_46580_49080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (14))){
var state_46359__$1 = state_46359;
var statearr_46581_49082 = state_46359__$1;
(statearr_46581_49082[(2)] = null);

(statearr_46581_49082[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (45))){
var inst_46346 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46582_49089 = state_46359__$1;
(statearr_46582_49089[(2)] = inst_46346);

(statearr_46582_49089[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (26))){
var inst_46289 = (state_46359[(27)]);
var inst_46342 = (state_46359[(2)]);
var inst_46343 = cljs.core.seq(inst_46289);
var state_46359__$1 = (function (){var statearr_46586 = state_46359;
(statearr_46586[(29)] = inst_46342);

return statearr_46586;
})();
if(inst_46343){
var statearr_46587_49090 = state_46359__$1;
(statearr_46587_49090[(1)] = (42));

} else {
var statearr_46588_49091 = state_46359__$1;
(statearr_46588_49091[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (16))){
var inst_46255 = (state_46359[(7)]);
var inst_46257 = cljs.core.chunked_seq_QMARK_(inst_46255);
var state_46359__$1 = state_46359;
if(inst_46257){
var statearr_46592_49092 = state_46359__$1;
(statearr_46592_49092[(1)] = (19));

} else {
var statearr_46593_49093 = state_46359__$1;
(statearr_46593_49093[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (38))){
var inst_46335 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46595_49094 = state_46359__$1;
(statearr_46595_49094[(2)] = inst_46335);

(statearr_46595_49094[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (30))){
var state_46359__$1 = state_46359;
var statearr_46597_49095 = state_46359__$1;
(statearr_46597_49095[(2)] = null);

(statearr_46597_49095[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (10))){
var inst_46229 = (state_46359[(14)]);
var inst_46231 = (state_46359[(15)]);
var inst_46242 = cljs.core._nth(inst_46229,inst_46231);
var inst_46244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46242,(0),null);
var inst_46245 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46242,(1),null);
var state_46359__$1 = (function (){var statearr_46611 = state_46359;
(statearr_46611[(24)] = inst_46244);

return statearr_46611;
})();
if(cljs.core.truth_(inst_46245)){
var statearr_46615_49097 = state_46359__$1;
(statearr_46615_49097[(1)] = (13));

} else {
var statearr_46621_49098 = state_46359__$1;
(statearr_46621_49098[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (18))){
var inst_46282 = (state_46359[(2)]);
var state_46359__$1 = state_46359;
var statearr_46626_49100 = state_46359__$1;
(statearr_46626_49100[(2)] = inst_46282);

(statearr_46626_49100[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (42))){
var state_46359__$1 = state_46359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46359__$1,(45),dchan);
} else {
if((state_val_46360 === (37))){
var inst_46325 = (state_46359[(22)]);
var inst_46218 = (state_46359[(12)]);
var inst_46315 = (state_46359[(23)]);
var inst_46325__$1 = cljs.core.first(inst_46315);
var inst_46326 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46325__$1,inst_46218,done);
var state_46359__$1 = (function (){var statearr_46627 = state_46359;
(statearr_46627[(22)] = inst_46325__$1);

return statearr_46627;
})();
if(cljs.core.truth_(inst_46326)){
var statearr_46631_49106 = state_46359__$1;
(statearr_46631_49106[(1)] = (39));

} else {
var statearr_46633_49107 = state_46359__$1;
(statearr_46633_49107[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46360 === (8))){
var inst_46230 = (state_46359[(13)]);
var inst_46231 = (state_46359[(15)]);
var inst_46233 = (inst_46231 < inst_46230);
var inst_46234 = inst_46233;
var state_46359__$1 = state_46359;
if(cljs.core.truth_(inst_46234)){
var statearr_46636_49108 = state_46359__$1;
(statearr_46636_49108[(1)] = (10));

} else {
var statearr_46637_49109 = state_46359__$1;
(statearr_46637_49109[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__44245__auto__ = null;
var cljs$core$async$mult_$_state_machine__44245__auto____0 = (function (){
var statearr_46643 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46643[(0)] = cljs$core$async$mult_$_state_machine__44245__auto__);

(statearr_46643[(1)] = (1));

return statearr_46643;
});
var cljs$core$async$mult_$_state_machine__44245__auto____1 = (function (state_46359){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_46359);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e46644){var ex__44248__auto__ = e46644;
var statearr_46645_49110 = state_46359;
(statearr_46645_49110[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_46359[(4)]))){
var statearr_46647_49112 = state_46359;
(statearr_46647_49112[(1)] = cljs.core.first((state_46359[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49113 = state_46359;
state_46359 = G__49113;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__44245__auto__ = function(state_46359){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__44245__auto____1.call(this,state_46359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__44245__auto____0;
cljs$core$async$mult_$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__44245__auto____1;
return cljs$core$async$mult_$_state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_46650 = f__44367__auto__();
(statearr_46650[(6)] = c__44365__auto___48962);

return statearr_46650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__46654 = arguments.length;
switch (G__46654) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_49120 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_49120(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_49125 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_49125(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_49136 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_49136(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_49141 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_49141(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_49142 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_49142(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___49147 = arguments.length;
var i__4865__auto___49149 = (0);
while(true){
if((i__4865__auto___49149 < len__4864__auto___49147)){
args__4870__auto__.push((arguments[i__4865__auto___49149]));

var G__49153 = (i__4865__auto___49149 + (1));
i__4865__auto___49149 = G__49153;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__46677){
var map__46678 = p__46677;
var map__46678__$1 = cljs.core.__destructure_map(map__46678);
var opts = map__46678__$1;
var statearr_46679_49156 = state;
(statearr_46679_49156[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_46681_49158 = state;
(statearr_46681_49158[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_46682_49159 = state;
(statearr_46682_49159[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq46671){
var G__46672 = cljs.core.first(seq46671);
var seq46671__$1 = cljs.core.next(seq46671);
var G__46673 = cljs.core.first(seq46671__$1);
var seq46671__$2 = cljs.core.next(seq46671__$1);
var G__46674 = cljs.core.first(seq46671__$2);
var seq46671__$3 = cljs.core.next(seq46671__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46672,G__46673,G__46674,seq46671__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46687 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46687 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta46688){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta46688 = meta46688;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46689,meta46688__$1){
var self__ = this;
var _46689__$1 = this;
return (new cljs.core.async.t_cljs$core$async46687(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta46688__$1));
}));

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46689){
var self__ = this;
var _46689__$1 = this;
return self__.meta46688;
}));

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46687.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46687.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta46688","meta46688",1578731752,null)], null);
}));

(cljs.core.async.t_cljs$core$async46687.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46687.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46687");

(cljs.core.async.t_cljs$core$async46687.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46687");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46687.
 */
cljs.core.async.__GT_t_cljs$core$async46687 = (function cljs$core$async$mix_$___GT_t_cljs$core$async46687(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46688){
return (new cljs.core.async.t_cljs$core$async46687(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46688));
});

}

return (new cljs.core.async.t_cljs$core$async46687(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44365__auto___49165 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_46771){
var state_val_46772 = (state_46771[(1)]);
if((state_val_46772 === (7))){
var inst_46730 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
if(cljs.core.truth_(inst_46730)){
var statearr_46774_49166 = state_46771__$1;
(statearr_46774_49166[(1)] = (8));

} else {
var statearr_46777_49167 = state_46771__$1;
(statearr_46777_49167[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (20))){
var inst_46718 = (state_46771[(7)]);
var state_46771__$1 = state_46771;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46771__$1,(23),out,inst_46718);
} else {
if((state_val_46772 === (1))){
var inst_46696 = calc_state();
var inst_46697 = cljs.core.__destructure_map(inst_46696);
var inst_46698 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46697,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46701 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46697,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46697,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_46704 = inst_46696;
var state_46771__$1 = (function (){var statearr_46779 = state_46771;
(statearr_46779[(8)] = inst_46702);

(statearr_46779[(9)] = inst_46698);

(statearr_46779[(10)] = inst_46701);

(statearr_46779[(11)] = inst_46704);

return statearr_46779;
})();
var statearr_46780_49172 = state_46771__$1;
(statearr_46780_49172[(2)] = null);

(statearr_46780_49172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (24))){
var inst_46707 = (state_46771[(12)]);
var inst_46704 = inst_46707;
var state_46771__$1 = (function (){var statearr_46782 = state_46771;
(statearr_46782[(11)] = inst_46704);

return statearr_46782;
})();
var statearr_46784_49173 = state_46771__$1;
(statearr_46784_49173[(2)] = null);

(statearr_46784_49173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (4))){
var inst_46718 = (state_46771[(7)]);
var inst_46723 = (state_46771[(13)]);
var inst_46716 = (state_46771[(2)]);
var inst_46718__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46716,(0),null);
var inst_46721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46716,(1),null);
var inst_46723__$1 = (inst_46718__$1 == null);
var state_46771__$1 = (function (){var statearr_46787 = state_46771;
(statearr_46787[(14)] = inst_46721);

(statearr_46787[(7)] = inst_46718__$1);

(statearr_46787[(13)] = inst_46723__$1);

return statearr_46787;
})();
if(cljs.core.truth_(inst_46723__$1)){
var statearr_46788_49175 = state_46771__$1;
(statearr_46788_49175[(1)] = (5));

} else {
var statearr_46789_49176 = state_46771__$1;
(statearr_46789_49176[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (15))){
var inst_46708 = (state_46771[(15)]);
var inst_46744 = (state_46771[(16)]);
var inst_46744__$1 = cljs.core.empty_QMARK_(inst_46708);
var state_46771__$1 = (function (){var statearr_46792 = state_46771;
(statearr_46792[(16)] = inst_46744__$1);

return statearr_46792;
})();
if(inst_46744__$1){
var statearr_46794_49179 = state_46771__$1;
(statearr_46794_49179[(1)] = (17));

} else {
var statearr_46795_49180 = state_46771__$1;
(statearr_46795_49180[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (21))){
var inst_46707 = (state_46771[(12)]);
var inst_46704 = inst_46707;
var state_46771__$1 = (function (){var statearr_46796 = state_46771;
(statearr_46796[(11)] = inst_46704);

return statearr_46796;
})();
var statearr_46797_49181 = state_46771__$1;
(statearr_46797_49181[(2)] = null);

(statearr_46797_49181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (13))){
var inst_46737 = (state_46771[(2)]);
var inst_46738 = calc_state();
var inst_46704 = inst_46738;
var state_46771__$1 = (function (){var statearr_46798 = state_46771;
(statearr_46798[(17)] = inst_46737);

(statearr_46798[(11)] = inst_46704);

return statearr_46798;
})();
var statearr_46799_49183 = state_46771__$1;
(statearr_46799_49183[(2)] = null);

(statearr_46799_49183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (22))){
var inst_46764 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
var statearr_46801_49184 = state_46771__$1;
(statearr_46801_49184[(2)] = inst_46764);

(statearr_46801_49184[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (6))){
var inst_46721 = (state_46771[(14)]);
var inst_46728 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46721,change);
var state_46771__$1 = state_46771;
var statearr_46802_49185 = state_46771__$1;
(statearr_46802_49185[(2)] = inst_46728);

(statearr_46802_49185[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (25))){
var state_46771__$1 = state_46771;
var statearr_46803_49186 = state_46771__$1;
(statearr_46803_49186[(2)] = null);

(statearr_46803_49186[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (17))){
var inst_46721 = (state_46771[(14)]);
var inst_46709 = (state_46771[(18)]);
var inst_46746 = (inst_46709.cljs$core$IFn$_invoke$arity$1 ? inst_46709.cljs$core$IFn$_invoke$arity$1(inst_46721) : inst_46709.call(null,inst_46721));
var inst_46747 = cljs.core.not(inst_46746);
var state_46771__$1 = state_46771;
var statearr_46804_49188 = state_46771__$1;
(statearr_46804_49188[(2)] = inst_46747);

(statearr_46804_49188[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (3))){
var inst_46769 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46771__$1,inst_46769);
} else {
if((state_val_46772 === (12))){
var state_46771__$1 = state_46771;
var statearr_46808_49193 = state_46771__$1;
(statearr_46808_49193[(2)] = null);

(statearr_46808_49193[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (2))){
var inst_46704 = (state_46771[(11)]);
var inst_46707 = (state_46771[(12)]);
var inst_46707__$1 = cljs.core.__destructure_map(inst_46704);
var inst_46708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46707__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46707__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46707__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_46771__$1 = (function (){var statearr_46812 = state_46771;
(statearr_46812[(15)] = inst_46708);

(statearr_46812[(18)] = inst_46709);

(statearr_46812[(12)] = inst_46707__$1);

return statearr_46812;
})();
return cljs.core.async.ioc_alts_BANG_(state_46771__$1,(4),inst_46710);
} else {
if((state_val_46772 === (23))){
var inst_46755 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
if(cljs.core.truth_(inst_46755)){
var statearr_46813_49197 = state_46771__$1;
(statearr_46813_49197[(1)] = (24));

} else {
var statearr_46814_49198 = state_46771__$1;
(statearr_46814_49198[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (19))){
var inst_46750 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
var statearr_46815_49199 = state_46771__$1;
(statearr_46815_49199[(2)] = inst_46750);

(statearr_46815_49199[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (11))){
var inst_46721 = (state_46771[(14)]);
var inst_46734 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_46721);
var state_46771__$1 = state_46771;
var statearr_46817_49200 = state_46771__$1;
(statearr_46817_49200[(2)] = inst_46734);

(statearr_46817_49200[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (9))){
var inst_46721 = (state_46771[(14)]);
var inst_46708 = (state_46771[(15)]);
var inst_46741 = (state_46771[(19)]);
var inst_46741__$1 = (inst_46708.cljs$core$IFn$_invoke$arity$1 ? inst_46708.cljs$core$IFn$_invoke$arity$1(inst_46721) : inst_46708.call(null,inst_46721));
var state_46771__$1 = (function (){var statearr_46818 = state_46771;
(statearr_46818[(19)] = inst_46741__$1);

return statearr_46818;
})();
if(cljs.core.truth_(inst_46741__$1)){
var statearr_46819_49201 = state_46771__$1;
(statearr_46819_49201[(1)] = (14));

} else {
var statearr_46820_49203 = state_46771__$1;
(statearr_46820_49203[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (5))){
var inst_46723 = (state_46771[(13)]);
var state_46771__$1 = state_46771;
var statearr_46821_49207 = state_46771__$1;
(statearr_46821_49207[(2)] = inst_46723);

(statearr_46821_49207[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (14))){
var inst_46741 = (state_46771[(19)]);
var state_46771__$1 = state_46771;
var statearr_46822_49208 = state_46771__$1;
(statearr_46822_49208[(2)] = inst_46741);

(statearr_46822_49208[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (26))){
var inst_46760 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
var statearr_46824_49209 = state_46771__$1;
(statearr_46824_49209[(2)] = inst_46760);

(statearr_46824_49209[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (16))){
var inst_46752 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
if(cljs.core.truth_(inst_46752)){
var statearr_46825_49211 = state_46771__$1;
(statearr_46825_49211[(1)] = (20));

} else {
var statearr_46826_49212 = state_46771__$1;
(statearr_46826_49212[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (10))){
var inst_46766 = (state_46771[(2)]);
var state_46771__$1 = state_46771;
var statearr_46827_49213 = state_46771__$1;
(statearr_46827_49213[(2)] = inst_46766);

(statearr_46827_49213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (18))){
var inst_46744 = (state_46771[(16)]);
var state_46771__$1 = state_46771;
var statearr_46828_49214 = state_46771__$1;
(statearr_46828_49214[(2)] = inst_46744);

(statearr_46828_49214[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46772 === (8))){
var inst_46718 = (state_46771[(7)]);
var inst_46732 = (inst_46718 == null);
var state_46771__$1 = state_46771;
if(cljs.core.truth_(inst_46732)){
var statearr_46829_49215 = state_46771__$1;
(statearr_46829_49215[(1)] = (11));

} else {
var statearr_46830_49216 = state_46771__$1;
(statearr_46830_49216[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__44245__auto__ = null;
var cljs$core$async$mix_$_state_machine__44245__auto____0 = (function (){
var statearr_46831 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46831[(0)] = cljs$core$async$mix_$_state_machine__44245__auto__);

(statearr_46831[(1)] = (1));

return statearr_46831;
});
var cljs$core$async$mix_$_state_machine__44245__auto____1 = (function (state_46771){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_46771);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e46833){var ex__44248__auto__ = e46833;
var statearr_46834_49217 = state_46771;
(statearr_46834_49217[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_46771[(4)]))){
var statearr_46835_49220 = state_46771;
(statearr_46835_49220[(1)] = cljs.core.first((state_46771[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49221 = state_46771;
state_46771 = G__49221;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__44245__auto__ = function(state_46771){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__44245__auto____1.call(this,state_46771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__44245__auto____0;
cljs$core$async$mix_$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__44245__auto____1;
return cljs$core$async$mix_$_state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_46836 = f__44367__auto__();
(statearr_46836[(6)] = c__44365__auto___49165);

return statearr_46836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_49222 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_49222(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_49224 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_49224(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_49230 = (function() {
var G__49231 = null;
var G__49231__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__49231__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__49231 = function(p,v){
switch(arguments.length){
case 1:
return G__49231__1.call(this,p);
case 2:
return G__49231__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__49231.cljs$core$IFn$_invoke$arity$1 = G__49231__1;
G__49231.cljs$core$IFn$_invoke$arity$2 = G__49231__2;
return G__49231;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__46842 = arguments.length;
switch (G__46842) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49230(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49230(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__46846 = arguments.length;
switch (G__46846) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__46844_SHARP_){
if(cljs.core.truth_((p1__46844_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__46844_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__46844_SHARP_.call(null,topic)))){
return p1__46844_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__46844_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46848 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46848 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta46849){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta46849 = meta46849;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46850,meta46849__$1){
var self__ = this;
var _46850__$1 = this;
return (new cljs.core.async.t_cljs$core$async46848(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta46849__$1));
}));

(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46850){
var self__ = this;
var _46850__$1 = this;
return self__.meta46849;
}));

(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async46848.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async46848.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta46849","meta46849",1463711372,null)], null);
}));

(cljs.core.async.t_cljs$core$async46848.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46848.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46848");

(cljs.core.async.t_cljs$core$async46848.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46848");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46848.
 */
cljs.core.async.__GT_t_cljs$core$async46848 = (function cljs$core$async$__GT_t_cljs$core$async46848(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46849){
return (new cljs.core.async.t_cljs$core$async46848(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46849));
});

}

return (new cljs.core.async.t_cljs$core$async46848(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44365__auto___49262 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_46928){
var state_val_46929 = (state_46928[(1)]);
if((state_val_46929 === (7))){
var inst_46924 = (state_46928[(2)]);
var state_46928__$1 = state_46928;
var statearr_46930_49264 = state_46928__$1;
(statearr_46930_49264[(2)] = inst_46924);

(statearr_46930_49264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (20))){
var state_46928__$1 = state_46928;
var statearr_46931_49265 = state_46928__$1;
(statearr_46931_49265[(2)] = null);

(statearr_46931_49265[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (1))){
var state_46928__$1 = state_46928;
var statearr_46932_49266 = state_46928__$1;
(statearr_46932_49266[(2)] = null);

(statearr_46932_49266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (24))){
var inst_46907 = (state_46928[(7)]);
var inst_46916 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46907);
var state_46928__$1 = state_46928;
var statearr_46934_49268 = state_46928__$1;
(statearr_46934_49268[(2)] = inst_46916);

(statearr_46934_49268[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (4))){
var inst_46857 = (state_46928[(8)]);
var inst_46857__$1 = (state_46928[(2)]);
var inst_46858 = (inst_46857__$1 == null);
var state_46928__$1 = (function (){var statearr_46936 = state_46928;
(statearr_46936[(8)] = inst_46857__$1);

return statearr_46936;
})();
if(cljs.core.truth_(inst_46858)){
var statearr_46937_49270 = state_46928__$1;
(statearr_46937_49270[(1)] = (5));

} else {
var statearr_46938_49272 = state_46928__$1;
(statearr_46938_49272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (15))){
var inst_46901 = (state_46928[(2)]);
var state_46928__$1 = state_46928;
var statearr_46939_49274 = state_46928__$1;
(statearr_46939_49274[(2)] = inst_46901);

(statearr_46939_49274[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (21))){
var inst_46921 = (state_46928[(2)]);
var state_46928__$1 = (function (){var statearr_46940 = state_46928;
(statearr_46940[(9)] = inst_46921);

return statearr_46940;
})();
var statearr_46941_49275 = state_46928__$1;
(statearr_46941_49275[(2)] = null);

(statearr_46941_49275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (13))){
var inst_46881 = (state_46928[(10)]);
var inst_46883 = cljs.core.chunked_seq_QMARK_(inst_46881);
var state_46928__$1 = state_46928;
if(inst_46883){
var statearr_46942_49276 = state_46928__$1;
(statearr_46942_49276[(1)] = (16));

} else {
var statearr_46943_49277 = state_46928__$1;
(statearr_46943_49277[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (22))){
var inst_46913 = (state_46928[(2)]);
var state_46928__$1 = state_46928;
if(cljs.core.truth_(inst_46913)){
var statearr_46944_49278 = state_46928__$1;
(statearr_46944_49278[(1)] = (23));

} else {
var statearr_46945_49279 = state_46928__$1;
(statearr_46945_49279[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (6))){
var inst_46909 = (state_46928[(11)]);
var inst_46857 = (state_46928[(8)]);
var inst_46907 = (state_46928[(7)]);
var inst_46907__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_46857) : topic_fn.call(null,inst_46857));
var inst_46908 = cljs.core.deref(mults);
var inst_46909__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46908,inst_46907__$1);
var state_46928__$1 = (function (){var statearr_46946 = state_46928;
(statearr_46946[(11)] = inst_46909__$1);

(statearr_46946[(7)] = inst_46907__$1);

return statearr_46946;
})();
if(cljs.core.truth_(inst_46909__$1)){
var statearr_46947_49282 = state_46928__$1;
(statearr_46947_49282[(1)] = (19));

} else {
var statearr_46948_49283 = state_46928__$1;
(statearr_46948_49283[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (25))){
var inst_46918 = (state_46928[(2)]);
var state_46928__$1 = state_46928;
var statearr_46949_49284 = state_46928__$1;
(statearr_46949_49284[(2)] = inst_46918);

(statearr_46949_49284[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (17))){
var inst_46881 = (state_46928[(10)]);
var inst_46890 = cljs.core.first(inst_46881);
var inst_46891 = cljs.core.async.muxch_STAR_(inst_46890);
var inst_46892 = cljs.core.async.close_BANG_(inst_46891);
var inst_46895 = cljs.core.next(inst_46881);
var inst_46867 = inst_46895;
var inst_46868 = null;
var inst_46869 = (0);
var inst_46870 = (0);
var state_46928__$1 = (function (){var statearr_46950 = state_46928;
(statearr_46950[(12)] = inst_46892);

(statearr_46950[(13)] = inst_46869);

(statearr_46950[(14)] = inst_46867);

(statearr_46950[(15)] = inst_46870);

(statearr_46950[(16)] = inst_46868);

return statearr_46950;
})();
var statearr_46953_49285 = state_46928__$1;
(statearr_46953_49285[(2)] = null);

(statearr_46953_49285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (3))){
var inst_46926 = (state_46928[(2)]);
var state_46928__$1 = state_46928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46928__$1,inst_46926);
} else {
if((state_val_46929 === (12))){
var inst_46903 = (state_46928[(2)]);
var state_46928__$1 = state_46928;
var statearr_46955_49288 = state_46928__$1;
(statearr_46955_49288[(2)] = inst_46903);

(statearr_46955_49288[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (2))){
var state_46928__$1 = state_46928;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46928__$1,(4),ch);
} else {
if((state_val_46929 === (23))){
var state_46928__$1 = state_46928;
var statearr_46962_49290 = state_46928__$1;
(statearr_46962_49290[(2)] = null);

(statearr_46962_49290[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (19))){
var inst_46909 = (state_46928[(11)]);
var inst_46857 = (state_46928[(8)]);
var inst_46911 = cljs.core.async.muxch_STAR_(inst_46909);
var state_46928__$1 = state_46928;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46928__$1,(22),inst_46911,inst_46857);
} else {
if((state_val_46929 === (11))){
var inst_46881 = (state_46928[(10)]);
var inst_46867 = (state_46928[(14)]);
var inst_46881__$1 = cljs.core.seq(inst_46867);
var state_46928__$1 = (function (){var statearr_46963 = state_46928;
(statearr_46963[(10)] = inst_46881__$1);

return statearr_46963;
})();
if(inst_46881__$1){
var statearr_46964_49292 = state_46928__$1;
(statearr_46964_49292[(1)] = (13));

} else {
var statearr_46966_49293 = state_46928__$1;
(statearr_46966_49293[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (9))){
var inst_46905 = (state_46928[(2)]);
var state_46928__$1 = state_46928;
var statearr_46969_49294 = state_46928__$1;
(statearr_46969_49294[(2)] = inst_46905);

(statearr_46969_49294[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (5))){
var inst_46864 = cljs.core.deref(mults);
var inst_46865 = cljs.core.vals(inst_46864);
var inst_46866 = cljs.core.seq(inst_46865);
var inst_46867 = inst_46866;
var inst_46868 = null;
var inst_46869 = (0);
var inst_46870 = (0);
var state_46928__$1 = (function (){var statearr_46972 = state_46928;
(statearr_46972[(13)] = inst_46869);

(statearr_46972[(14)] = inst_46867);

(statearr_46972[(15)] = inst_46870);

(statearr_46972[(16)] = inst_46868);

return statearr_46972;
})();
var statearr_46976_49300 = state_46928__$1;
(statearr_46976_49300[(2)] = null);

(statearr_46976_49300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (14))){
var state_46928__$1 = state_46928;
var statearr_46981_49304 = state_46928__$1;
(statearr_46981_49304[(2)] = null);

(statearr_46981_49304[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (16))){
var inst_46881 = (state_46928[(10)]);
var inst_46885 = cljs.core.chunk_first(inst_46881);
var inst_46886 = cljs.core.chunk_rest(inst_46881);
var inst_46887 = cljs.core.count(inst_46885);
var inst_46867 = inst_46886;
var inst_46868 = inst_46885;
var inst_46869 = inst_46887;
var inst_46870 = (0);
var state_46928__$1 = (function (){var statearr_46986 = state_46928;
(statearr_46986[(13)] = inst_46869);

(statearr_46986[(14)] = inst_46867);

(statearr_46986[(15)] = inst_46870);

(statearr_46986[(16)] = inst_46868);

return statearr_46986;
})();
var statearr_46988_49305 = state_46928__$1;
(statearr_46988_49305[(2)] = null);

(statearr_46988_49305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (10))){
var inst_46869 = (state_46928[(13)]);
var inst_46867 = (state_46928[(14)]);
var inst_46870 = (state_46928[(15)]);
var inst_46868 = (state_46928[(16)]);
var inst_46875 = cljs.core._nth(inst_46868,inst_46870);
var inst_46876 = cljs.core.async.muxch_STAR_(inst_46875);
var inst_46877 = cljs.core.async.close_BANG_(inst_46876);
var inst_46878 = (inst_46870 + (1));
var tmp46978 = inst_46869;
var tmp46979 = inst_46867;
var tmp46980 = inst_46868;
var inst_46867__$1 = tmp46979;
var inst_46868__$1 = tmp46980;
var inst_46869__$1 = tmp46978;
var inst_46870__$1 = inst_46878;
var state_46928__$1 = (function (){var statearr_46994 = state_46928;
(statearr_46994[(13)] = inst_46869__$1);

(statearr_46994[(17)] = inst_46877);

(statearr_46994[(14)] = inst_46867__$1);

(statearr_46994[(15)] = inst_46870__$1);

(statearr_46994[(16)] = inst_46868__$1);

return statearr_46994;
})();
var statearr_46996_49306 = state_46928__$1;
(statearr_46996_49306[(2)] = null);

(statearr_46996_49306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (18))){
var inst_46898 = (state_46928[(2)]);
var state_46928__$1 = state_46928;
var statearr_46998_49308 = state_46928__$1;
(statearr_46998_49308[(2)] = inst_46898);

(statearr_46998_49308[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46929 === (8))){
var inst_46869 = (state_46928[(13)]);
var inst_46870 = (state_46928[(15)]);
var inst_46872 = (inst_46870 < inst_46869);
var inst_46873 = inst_46872;
var state_46928__$1 = state_46928;
if(cljs.core.truth_(inst_46873)){
var statearr_47002_49310 = state_46928__$1;
(statearr_47002_49310[(1)] = (10));

} else {
var statearr_47004_49311 = state_46928__$1;
(statearr_47004_49311[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_47009 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47009[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_47009[(1)] = (1));

return statearr_47009;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_46928){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_46928);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e47013){var ex__44248__auto__ = e47013;
var statearr_47014_49314 = state_46928;
(statearr_47014_49314[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_46928[(4)]))){
var statearr_47016_49315 = state_46928;
(statearr_47016_49315[(1)] = cljs.core.first((state_46928[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49317 = state_46928;
state_46928 = G__49317;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_46928){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_46928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_47020 = f__44367__auto__();
(statearr_47020[(6)] = c__44365__auto___49262);

return statearr_47020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__47027 = arguments.length;
switch (G__47027) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__47044 = arguments.length;
switch (G__47044) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__47055 = arguments.length;
switch (G__47055) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__44365__auto___49332 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_47125){
var state_val_47126 = (state_47125[(1)]);
if((state_val_47126 === (7))){
var state_47125__$1 = state_47125;
var statearr_47130_49333 = state_47125__$1;
(statearr_47130_49333[(2)] = null);

(statearr_47130_49333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (1))){
var state_47125__$1 = state_47125;
var statearr_47133_49334 = state_47125__$1;
(statearr_47133_49334[(2)] = null);

(statearr_47133_49334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (4))){
var inst_47070 = (state_47125[(7)]);
var inst_47071 = (state_47125[(8)]);
var inst_47074 = (inst_47071 < inst_47070);
var state_47125__$1 = state_47125;
if(cljs.core.truth_(inst_47074)){
var statearr_47137_49335 = state_47125__$1;
(statearr_47137_49335[(1)] = (6));

} else {
var statearr_47139_49337 = state_47125__$1;
(statearr_47139_49337[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (15))){
var inst_47107 = (state_47125[(9)]);
var inst_47112 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_47107);
var state_47125__$1 = state_47125;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47125__$1,(17),out,inst_47112);
} else {
if((state_val_47126 === (13))){
var inst_47107 = (state_47125[(9)]);
var inst_47107__$1 = (state_47125[(2)]);
var inst_47108 = cljs.core.some(cljs.core.nil_QMARK_,inst_47107__$1);
var state_47125__$1 = (function (){var statearr_47147 = state_47125;
(statearr_47147[(9)] = inst_47107__$1);

return statearr_47147;
})();
if(cljs.core.truth_(inst_47108)){
var statearr_47150_49340 = state_47125__$1;
(statearr_47150_49340[(1)] = (14));

} else {
var statearr_47152_49341 = state_47125__$1;
(statearr_47152_49341[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (6))){
var state_47125__$1 = state_47125;
var statearr_47154_49343 = state_47125__$1;
(statearr_47154_49343[(2)] = null);

(statearr_47154_49343[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (17))){
var inst_47114 = (state_47125[(2)]);
var state_47125__$1 = (function (){var statearr_47167 = state_47125;
(statearr_47167[(10)] = inst_47114);

return statearr_47167;
})();
var statearr_47168_49344 = state_47125__$1;
(statearr_47168_49344[(2)] = null);

(statearr_47168_49344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (3))){
var inst_47119 = (state_47125[(2)]);
var state_47125__$1 = state_47125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47125__$1,inst_47119);
} else {
if((state_val_47126 === (12))){
var _ = (function (){var statearr_47173 = state_47125;
(statearr_47173[(4)] = cljs.core.rest((state_47125[(4)])));

return statearr_47173;
})();
var state_47125__$1 = state_47125;
var ex47163 = (state_47125__$1[(2)]);
var statearr_47177_49345 = state_47125__$1;
(statearr_47177_49345[(5)] = ex47163);


if((ex47163 instanceof Object)){
var statearr_47179_49347 = state_47125__$1;
(statearr_47179_49347[(1)] = (11));

(statearr_47179_49347[(5)] = null);

} else {
throw ex47163;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (2))){
var inst_47067 = cljs.core.reset_BANG_(dctr,cnt);
var inst_47070 = cnt;
var inst_47071 = (0);
var state_47125__$1 = (function (){var statearr_47190 = state_47125;
(statearr_47190[(7)] = inst_47070);

(statearr_47190[(11)] = inst_47067);

(statearr_47190[(8)] = inst_47071);

return statearr_47190;
})();
var statearr_47192_49355 = state_47125__$1;
(statearr_47192_49355[(2)] = null);

(statearr_47192_49355[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (11))){
var inst_47082 = (state_47125[(2)]);
var inst_47083 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_47125__$1 = (function (){var statearr_47195 = state_47125;
(statearr_47195[(12)] = inst_47082);

return statearr_47195;
})();
var statearr_47197_49356 = state_47125__$1;
(statearr_47197_49356[(2)] = inst_47083);

(statearr_47197_49356[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (9))){
var inst_47071 = (state_47125[(8)]);
var _ = (function (){var statearr_47199 = state_47125;
(statearr_47199[(4)] = cljs.core.cons((12),(state_47125[(4)])));

return statearr_47199;
})();
var inst_47091 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_47071) : chs__$1.call(null,inst_47071));
var inst_47092 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_47071) : done.call(null,inst_47071));
var inst_47093 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_47091,inst_47092);
var ___$1 = (function (){var statearr_47203 = state_47125;
(statearr_47203[(4)] = cljs.core.rest((state_47125[(4)])));

return statearr_47203;
})();
var state_47125__$1 = state_47125;
var statearr_47204_49357 = state_47125__$1;
(statearr_47204_49357[(2)] = inst_47093);

(statearr_47204_49357[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (5))){
var inst_47104 = (state_47125[(2)]);
var state_47125__$1 = (function (){var statearr_47207 = state_47125;
(statearr_47207[(13)] = inst_47104);

return statearr_47207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47125__$1,(13),dchan);
} else {
if((state_val_47126 === (14))){
var inst_47110 = cljs.core.async.close_BANG_(out);
var state_47125__$1 = state_47125;
var statearr_47216_49360 = state_47125__$1;
(statearr_47216_49360[(2)] = inst_47110);

(statearr_47216_49360[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (16))){
var inst_47117 = (state_47125[(2)]);
var state_47125__$1 = state_47125;
var statearr_47219_49362 = state_47125__$1;
(statearr_47219_49362[(2)] = inst_47117);

(statearr_47219_49362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (10))){
var inst_47071 = (state_47125[(8)]);
var inst_47097 = (state_47125[(2)]);
var inst_47098 = (inst_47071 + (1));
var inst_47071__$1 = inst_47098;
var state_47125__$1 = (function (){var statearr_47223 = state_47125;
(statearr_47223[(14)] = inst_47097);

(statearr_47223[(8)] = inst_47071__$1);

return statearr_47223;
})();
var statearr_47225_49365 = state_47125__$1;
(statearr_47225_49365[(2)] = null);

(statearr_47225_49365[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (8))){
var inst_47102 = (state_47125[(2)]);
var state_47125__$1 = state_47125;
var statearr_47229_49367 = state_47125__$1;
(statearr_47229_49367[(2)] = inst_47102);

(statearr_47229_49367[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_47234 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47234[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_47234[(1)] = (1));

return statearr_47234;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_47125){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_47125);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e47236){var ex__44248__auto__ = e47236;
var statearr_47237_49369 = state_47125;
(statearr_47237_49369[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_47125[(4)]))){
var statearr_47240_49371 = state_47125;
(statearr_47240_49371[(1)] = cljs.core.first((state_47125[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49372 = state_47125;
state_47125 = G__49372;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_47125){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_47125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_47243 = f__44367__auto__();
(statearr_47243[(6)] = c__44365__auto___49332);

return statearr_47243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__47253 = arguments.length;
switch (G__47253) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44365__auto___49376 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_47288){
var state_val_47289 = (state_47288[(1)]);
if((state_val_47289 === (7))){
var inst_47267 = (state_47288[(7)]);
var inst_47268 = (state_47288[(8)]);
var inst_47267__$1 = (state_47288[(2)]);
var inst_47268__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47267__$1,(0),null);
var inst_47269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47267__$1,(1),null);
var inst_47270 = (inst_47268__$1 == null);
var state_47288__$1 = (function (){var statearr_47292 = state_47288;
(statearr_47292[(7)] = inst_47267__$1);

(statearr_47292[(8)] = inst_47268__$1);

(statearr_47292[(9)] = inst_47269);

return statearr_47292;
})();
if(cljs.core.truth_(inst_47270)){
var statearr_47293_49381 = state_47288__$1;
(statearr_47293_49381[(1)] = (8));

} else {
var statearr_47294_49383 = state_47288__$1;
(statearr_47294_49383[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47289 === (1))){
var inst_47257 = cljs.core.vec(chs);
var inst_47258 = inst_47257;
var state_47288__$1 = (function (){var statearr_47296 = state_47288;
(statearr_47296[(10)] = inst_47258);

return statearr_47296;
})();
var statearr_47297_49384 = state_47288__$1;
(statearr_47297_49384[(2)] = null);

(statearr_47297_49384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47289 === (4))){
var inst_47258 = (state_47288[(10)]);
var state_47288__$1 = state_47288;
return cljs.core.async.ioc_alts_BANG_(state_47288__$1,(7),inst_47258);
} else {
if((state_val_47289 === (6))){
var inst_47284 = (state_47288[(2)]);
var state_47288__$1 = state_47288;
var statearr_47307_49386 = state_47288__$1;
(statearr_47307_49386[(2)] = inst_47284);

(statearr_47307_49386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47289 === (3))){
var inst_47286 = (state_47288[(2)]);
var state_47288__$1 = state_47288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47288__$1,inst_47286);
} else {
if((state_val_47289 === (2))){
var inst_47258 = (state_47288[(10)]);
var inst_47260 = cljs.core.count(inst_47258);
var inst_47261 = (inst_47260 > (0));
var state_47288__$1 = state_47288;
if(cljs.core.truth_(inst_47261)){
var statearr_47313_49393 = state_47288__$1;
(statearr_47313_49393[(1)] = (4));

} else {
var statearr_47314_49394 = state_47288__$1;
(statearr_47314_49394[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47289 === (11))){
var inst_47258 = (state_47288[(10)]);
var inst_47277 = (state_47288[(2)]);
var tmp47309 = inst_47258;
var inst_47258__$1 = tmp47309;
var state_47288__$1 = (function (){var statearr_47315 = state_47288;
(statearr_47315[(11)] = inst_47277);

(statearr_47315[(10)] = inst_47258__$1);

return statearr_47315;
})();
var statearr_47320_49395 = state_47288__$1;
(statearr_47320_49395[(2)] = null);

(statearr_47320_49395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47289 === (9))){
var inst_47268 = (state_47288[(8)]);
var state_47288__$1 = state_47288;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47288__$1,(11),out,inst_47268);
} else {
if((state_val_47289 === (5))){
var inst_47282 = cljs.core.async.close_BANG_(out);
var state_47288__$1 = state_47288;
var statearr_47329_49398 = state_47288__$1;
(statearr_47329_49398[(2)] = inst_47282);

(statearr_47329_49398[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47289 === (10))){
var inst_47280 = (state_47288[(2)]);
var state_47288__$1 = state_47288;
var statearr_47330_49399 = state_47288__$1;
(statearr_47330_49399[(2)] = inst_47280);

(statearr_47330_49399[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47289 === (8))){
var inst_47267 = (state_47288[(7)]);
var inst_47258 = (state_47288[(10)]);
var inst_47268 = (state_47288[(8)]);
var inst_47269 = (state_47288[(9)]);
var inst_47272 = (function (){var cs = inst_47258;
var vec__47263 = inst_47267;
var v = inst_47268;
var c = inst_47269;
return (function (p1__47248_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__47248_SHARP_);
});
})();
var inst_47273 = cljs.core.filterv(inst_47272,inst_47258);
var inst_47258__$1 = inst_47273;
var state_47288__$1 = (function (){var statearr_47335 = state_47288;
(statearr_47335[(10)] = inst_47258__$1);

return statearr_47335;
})();
var statearr_47339_49403 = state_47288__$1;
(statearr_47339_49403[(2)] = null);

(statearr_47339_49403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_47341 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47341[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_47341[(1)] = (1));

return statearr_47341;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_47288){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_47288);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e47343){var ex__44248__auto__ = e47343;
var statearr_47344_49405 = state_47288;
(statearr_47344_49405[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_47288[(4)]))){
var statearr_47345_49406 = state_47288;
(statearr_47345_49406[(1)] = cljs.core.first((state_47288[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49407 = state_47288;
state_47288 = G__49407;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_47288){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_47288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_47350 = f__44367__auto__();
(statearr_47350[(6)] = c__44365__auto___49376);

return statearr_47350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__47363 = arguments.length;
switch (G__47363) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44365__auto___49411 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_47393){
var state_val_47394 = (state_47393[(1)]);
if((state_val_47394 === (7))){
var inst_47375 = (state_47393[(7)]);
var inst_47375__$1 = (state_47393[(2)]);
var inst_47376 = (inst_47375__$1 == null);
var inst_47377 = cljs.core.not(inst_47376);
var state_47393__$1 = (function (){var statearr_47402 = state_47393;
(statearr_47402[(7)] = inst_47375__$1);

return statearr_47402;
})();
if(inst_47377){
var statearr_47404_49415 = state_47393__$1;
(statearr_47404_49415[(1)] = (8));

} else {
var statearr_47405_49416 = state_47393__$1;
(statearr_47405_49416[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (1))){
var inst_47369 = (0);
var state_47393__$1 = (function (){var statearr_47406 = state_47393;
(statearr_47406[(8)] = inst_47369);

return statearr_47406;
})();
var statearr_47407_49419 = state_47393__$1;
(statearr_47407_49419[(2)] = null);

(statearr_47407_49419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (4))){
var state_47393__$1 = state_47393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47393__$1,(7),ch);
} else {
if((state_val_47394 === (6))){
var inst_47388 = (state_47393[(2)]);
var state_47393__$1 = state_47393;
var statearr_47412_49420 = state_47393__$1;
(statearr_47412_49420[(2)] = inst_47388);

(statearr_47412_49420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (3))){
var inst_47390 = (state_47393[(2)]);
var inst_47391 = cljs.core.async.close_BANG_(out);
var state_47393__$1 = (function (){var statearr_47416 = state_47393;
(statearr_47416[(9)] = inst_47390);

return statearr_47416;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47393__$1,inst_47391);
} else {
if((state_val_47394 === (2))){
var inst_47369 = (state_47393[(8)]);
var inst_47371 = (inst_47369 < n);
var state_47393__$1 = state_47393;
if(cljs.core.truth_(inst_47371)){
var statearr_47418_49422 = state_47393__$1;
(statearr_47418_49422[(1)] = (4));

} else {
var statearr_47419_49423 = state_47393__$1;
(statearr_47419_49423[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (11))){
var inst_47369 = (state_47393[(8)]);
var inst_47380 = (state_47393[(2)]);
var inst_47381 = (inst_47369 + (1));
var inst_47369__$1 = inst_47381;
var state_47393__$1 = (function (){var statearr_47424 = state_47393;
(statearr_47424[(8)] = inst_47369__$1);

(statearr_47424[(10)] = inst_47380);

return statearr_47424;
})();
var statearr_47425_49425 = state_47393__$1;
(statearr_47425_49425[(2)] = null);

(statearr_47425_49425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (9))){
var state_47393__$1 = state_47393;
var statearr_47426_49427 = state_47393__$1;
(statearr_47426_49427[(2)] = null);

(statearr_47426_49427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (5))){
var state_47393__$1 = state_47393;
var statearr_47428_49430 = state_47393__$1;
(statearr_47428_49430[(2)] = null);

(statearr_47428_49430[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (10))){
var inst_47385 = (state_47393[(2)]);
var state_47393__$1 = state_47393;
var statearr_47429_49435 = state_47393__$1;
(statearr_47429_49435[(2)] = inst_47385);

(statearr_47429_49435[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47394 === (8))){
var inst_47375 = (state_47393[(7)]);
var state_47393__$1 = state_47393;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47393__$1,(11),out,inst_47375);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_47434 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47434[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_47434[(1)] = (1));

return statearr_47434;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_47393){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_47393);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e47439){var ex__44248__auto__ = e47439;
var statearr_47440_49440 = state_47393;
(statearr_47440_49440[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_47393[(4)]))){
var statearr_47441_49441 = state_47393;
(statearr_47441_49441[(1)] = cljs.core.first((state_47393[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49443 = state_47393;
state_47393 = G__49443;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_47393){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_47393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_47446 = f__44367__auto__();
(statearr_47446[(6)] = c__44365__auto___49411);

return statearr_47446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47452 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47452 = (function (f,ch,meta47453){
this.f = f;
this.ch = ch;
this.meta47453 = meta47453;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47454,meta47453__$1){
var self__ = this;
var _47454__$1 = this;
return (new cljs.core.async.t_cljs$core$async47452(self__.f,self__.ch,meta47453__$1));
}));

(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47454){
var self__ = this;
var _47454__$1 = this;
return self__.meta47453;
}));

(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47467 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47467 = (function (f,ch,meta47453,_,fn1,meta47468){
this.f = f;
this.ch = ch;
this.meta47453 = meta47453;
this._ = _;
this.fn1 = fn1;
this.meta47468 = meta47468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47469,meta47468__$1){
var self__ = this;
var _47469__$1 = this;
return (new cljs.core.async.t_cljs$core$async47467(self__.f,self__.ch,self__.meta47453,self__._,self__.fn1,meta47468__$1));
}));

(cljs.core.async.t_cljs$core$async47467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47469){
var self__ = this;
var _47469__$1 = this;
return self__.meta47468;
}));

(cljs.core.async.t_cljs$core$async47467.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47467.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async47467.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47467.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__47450_SHARP_){
var G__47472 = (((p1__47450_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__47450_SHARP_) : self__.f.call(null,p1__47450_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__47472) : f1.call(null,G__47472));
});
}));

(cljs.core.async.t_cljs$core$async47467.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47453","meta47453",1347221045,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async47452","cljs.core.async/t_cljs$core$async47452",1423028207,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta47468","meta47468",-1375267020,null)], null);
}));

(cljs.core.async.t_cljs$core$async47467.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47467.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47467");

(cljs.core.async.t_cljs$core$async47467.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47467");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47467.
 */
cljs.core.async.__GT_t_cljs$core$async47467 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47467(f__$1,ch__$1,meta47453__$1,___$2,fn1__$1,meta47468){
return (new cljs.core.async.t_cljs$core$async47467(f__$1,ch__$1,meta47453__$1,___$2,fn1__$1,meta47468));
});

}

return (new cljs.core.async.t_cljs$core$async47467(self__.f,self__.ch,self__.meta47453,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__47475 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__47475) : self__.f.call(null,G__47475));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47452.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async47452.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47453","meta47453",1347221045,null)], null);
}));

(cljs.core.async.t_cljs$core$async47452.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47452.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47452");

(cljs.core.async.t_cljs$core$async47452.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47452");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47452.
 */
cljs.core.async.__GT_t_cljs$core$async47452 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47452(f__$1,ch__$1,meta47453){
return (new cljs.core.async.t_cljs$core$async47452(f__$1,ch__$1,meta47453));
});

}

return (new cljs.core.async.t_cljs$core$async47452(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47478 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47478 = (function (f,ch,meta47479){
this.f = f;
this.ch = ch;
this.meta47479 = meta47479;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47478.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47480,meta47479__$1){
var self__ = this;
var _47480__$1 = this;
return (new cljs.core.async.t_cljs$core$async47478(self__.f,self__.ch,meta47479__$1));
}));

(cljs.core.async.t_cljs$core$async47478.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47480){
var self__ = this;
var _47480__$1 = this;
return self__.meta47479;
}));

(cljs.core.async.t_cljs$core$async47478.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47478.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47478.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47478.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47478.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47478.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async47478.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47479","meta47479",-231433525,null)], null);
}));

(cljs.core.async.t_cljs$core$async47478.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47478.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47478");

(cljs.core.async.t_cljs$core$async47478.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47478");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47478.
 */
cljs.core.async.__GT_t_cljs$core$async47478 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async47478(f__$1,ch__$1,meta47479){
return (new cljs.core.async.t_cljs$core$async47478(f__$1,ch__$1,meta47479));
});

}

return (new cljs.core.async.t_cljs$core$async47478(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47491 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47491 = (function (p,ch,meta47492){
this.p = p;
this.ch = ch;
this.meta47492 = meta47492;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47493,meta47492__$1){
var self__ = this;
var _47493__$1 = this;
return (new cljs.core.async.t_cljs$core$async47491(self__.p,self__.ch,meta47492__$1));
}));

(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47493){
var self__ = this;
var _47493__$1 = this;
return self__.meta47492;
}));

(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47491.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async47491.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47492","meta47492",1848504272,null)], null);
}));

(cljs.core.async.t_cljs$core$async47491.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47491.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47491");

(cljs.core.async.t_cljs$core$async47491.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47491");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47491.
 */
cljs.core.async.__GT_t_cljs$core$async47491 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async47491(p__$1,ch__$1,meta47492){
return (new cljs.core.async.t_cljs$core$async47491(p__$1,ch__$1,meta47492));
});

}

return (new cljs.core.async.t_cljs$core$async47491(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__47500 = arguments.length;
switch (G__47500) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44365__auto___49490 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_47525){
var state_val_47526 = (state_47525[(1)]);
if((state_val_47526 === (7))){
var inst_47521 = (state_47525[(2)]);
var state_47525__$1 = state_47525;
var statearr_47532_49495 = state_47525__$1;
(statearr_47532_49495[(2)] = inst_47521);

(statearr_47532_49495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47526 === (1))){
var state_47525__$1 = state_47525;
var statearr_47533_49498 = state_47525__$1;
(statearr_47533_49498[(2)] = null);

(statearr_47533_49498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47526 === (4))){
var inst_47507 = (state_47525[(7)]);
var inst_47507__$1 = (state_47525[(2)]);
var inst_47508 = (inst_47507__$1 == null);
var state_47525__$1 = (function (){var statearr_47534 = state_47525;
(statearr_47534[(7)] = inst_47507__$1);

return statearr_47534;
})();
if(cljs.core.truth_(inst_47508)){
var statearr_47539_49500 = state_47525__$1;
(statearr_47539_49500[(1)] = (5));

} else {
var statearr_47540_49501 = state_47525__$1;
(statearr_47540_49501[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47526 === (6))){
var inst_47507 = (state_47525[(7)]);
var inst_47512 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47507) : p.call(null,inst_47507));
var state_47525__$1 = state_47525;
if(cljs.core.truth_(inst_47512)){
var statearr_47541_49504 = state_47525__$1;
(statearr_47541_49504[(1)] = (8));

} else {
var statearr_47542_49505 = state_47525__$1;
(statearr_47542_49505[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47526 === (3))){
var inst_47523 = (state_47525[(2)]);
var state_47525__$1 = state_47525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47525__$1,inst_47523);
} else {
if((state_val_47526 === (2))){
var state_47525__$1 = state_47525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47525__$1,(4),ch);
} else {
if((state_val_47526 === (11))){
var inst_47515 = (state_47525[(2)]);
var state_47525__$1 = state_47525;
var statearr_47544_49508 = state_47525__$1;
(statearr_47544_49508[(2)] = inst_47515);

(statearr_47544_49508[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47526 === (9))){
var state_47525__$1 = state_47525;
var statearr_47546_49510 = state_47525__$1;
(statearr_47546_49510[(2)] = null);

(statearr_47546_49510[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47526 === (5))){
var inst_47510 = cljs.core.async.close_BANG_(out);
var state_47525__$1 = state_47525;
var statearr_47548_49512 = state_47525__$1;
(statearr_47548_49512[(2)] = inst_47510);

(statearr_47548_49512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47526 === (10))){
var inst_47518 = (state_47525[(2)]);
var state_47525__$1 = (function (){var statearr_47553 = state_47525;
(statearr_47553[(8)] = inst_47518);

return statearr_47553;
})();
var statearr_47555_49513 = state_47525__$1;
(statearr_47555_49513[(2)] = null);

(statearr_47555_49513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47526 === (8))){
var inst_47507 = (state_47525[(7)]);
var state_47525__$1 = state_47525;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47525__$1,(11),out,inst_47507);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_47556 = [null,null,null,null,null,null,null,null,null];
(statearr_47556[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_47556[(1)] = (1));

return statearr_47556;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_47525){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_47525);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e47560){var ex__44248__auto__ = e47560;
var statearr_47561_49515 = state_47525;
(statearr_47561_49515[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_47525[(4)]))){
var statearr_47562_49516 = state_47525;
(statearr_47562_49516[(1)] = cljs.core.first((state_47525[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49517 = state_47525;
state_47525 = G__49517;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_47525){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_47525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_47563 = f__44367__auto__();
(statearr_47563[(6)] = c__44365__auto___49490);

return statearr_47563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__47565 = arguments.length;
switch (G__47565) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__44365__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_47660){
var state_val_47661 = (state_47660[(1)]);
if((state_val_47661 === (7))){
var inst_47656 = (state_47660[(2)]);
var state_47660__$1 = state_47660;
var statearr_47663_49522 = state_47660__$1;
(statearr_47663_49522[(2)] = inst_47656);

(statearr_47663_49522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (20))){
var inst_47623 = (state_47660[(7)]);
var inst_47637 = (state_47660[(2)]);
var inst_47638 = cljs.core.next(inst_47623);
var inst_47606 = inst_47638;
var inst_47607 = null;
var inst_47608 = (0);
var inst_47612 = (0);
var state_47660__$1 = (function (){var statearr_47668 = state_47660;
(statearr_47668[(8)] = inst_47612);

(statearr_47668[(9)] = inst_47606);

(statearr_47668[(10)] = inst_47607);

(statearr_47668[(11)] = inst_47637);

(statearr_47668[(12)] = inst_47608);

return statearr_47668;
})();
var statearr_47669_49525 = state_47660__$1;
(statearr_47669_49525[(2)] = null);

(statearr_47669_49525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (1))){
var state_47660__$1 = state_47660;
var statearr_47670_49526 = state_47660__$1;
(statearr_47670_49526[(2)] = null);

(statearr_47670_49526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (4))){
var inst_47592 = (state_47660[(13)]);
var inst_47592__$1 = (state_47660[(2)]);
var inst_47593 = (inst_47592__$1 == null);
var state_47660__$1 = (function (){var statearr_47673 = state_47660;
(statearr_47673[(13)] = inst_47592__$1);

return statearr_47673;
})();
if(cljs.core.truth_(inst_47593)){
var statearr_47674_49528 = state_47660__$1;
(statearr_47674_49528[(1)] = (5));

} else {
var statearr_47675_49529 = state_47660__$1;
(statearr_47675_49529[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (15))){
var state_47660__$1 = state_47660;
var statearr_47682_49530 = state_47660__$1;
(statearr_47682_49530[(2)] = null);

(statearr_47682_49530[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (21))){
var state_47660__$1 = state_47660;
var statearr_47683_49531 = state_47660__$1;
(statearr_47683_49531[(2)] = null);

(statearr_47683_49531[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (13))){
var inst_47612 = (state_47660[(8)]);
var inst_47606 = (state_47660[(9)]);
var inst_47607 = (state_47660[(10)]);
var inst_47608 = (state_47660[(12)]);
var inst_47619 = (state_47660[(2)]);
var inst_47620 = (inst_47612 + (1));
var tmp47676 = inst_47606;
var tmp47677 = inst_47607;
var tmp47678 = inst_47608;
var inst_47606__$1 = tmp47676;
var inst_47607__$1 = tmp47677;
var inst_47608__$1 = tmp47678;
var inst_47612__$1 = inst_47620;
var state_47660__$1 = (function (){var statearr_47688 = state_47660;
(statearr_47688[(8)] = inst_47612__$1);

(statearr_47688[(9)] = inst_47606__$1);

(statearr_47688[(10)] = inst_47607__$1);

(statearr_47688[(14)] = inst_47619);

(statearr_47688[(12)] = inst_47608__$1);

return statearr_47688;
})();
var statearr_47689_49533 = state_47660__$1;
(statearr_47689_49533[(2)] = null);

(statearr_47689_49533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (22))){
var state_47660__$1 = state_47660;
var statearr_47692_49534 = state_47660__$1;
(statearr_47692_49534[(2)] = null);

(statearr_47692_49534[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (6))){
var inst_47592 = (state_47660[(13)]);
var inst_47604 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47592) : f.call(null,inst_47592));
var inst_47605 = cljs.core.seq(inst_47604);
var inst_47606 = inst_47605;
var inst_47607 = null;
var inst_47608 = (0);
var inst_47612 = (0);
var state_47660__$1 = (function (){var statearr_47695 = state_47660;
(statearr_47695[(8)] = inst_47612);

(statearr_47695[(9)] = inst_47606);

(statearr_47695[(10)] = inst_47607);

(statearr_47695[(12)] = inst_47608);

return statearr_47695;
})();
var statearr_47696_49536 = state_47660__$1;
(statearr_47696_49536[(2)] = null);

(statearr_47696_49536[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (17))){
var inst_47623 = (state_47660[(7)]);
var inst_47630 = cljs.core.chunk_first(inst_47623);
var inst_47631 = cljs.core.chunk_rest(inst_47623);
var inst_47632 = cljs.core.count(inst_47630);
var inst_47606 = inst_47631;
var inst_47607 = inst_47630;
var inst_47608 = inst_47632;
var inst_47612 = (0);
var state_47660__$1 = (function (){var statearr_47698 = state_47660;
(statearr_47698[(8)] = inst_47612);

(statearr_47698[(9)] = inst_47606);

(statearr_47698[(10)] = inst_47607);

(statearr_47698[(12)] = inst_47608);

return statearr_47698;
})();
var statearr_47699_49538 = state_47660__$1;
(statearr_47699_49538[(2)] = null);

(statearr_47699_49538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (3))){
var inst_47658 = (state_47660[(2)]);
var state_47660__$1 = state_47660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47660__$1,inst_47658);
} else {
if((state_val_47661 === (12))){
var inst_47646 = (state_47660[(2)]);
var state_47660__$1 = state_47660;
var statearr_47700_49539 = state_47660__$1;
(statearr_47700_49539[(2)] = inst_47646);

(statearr_47700_49539[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (2))){
var state_47660__$1 = state_47660;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47660__$1,(4),in$);
} else {
if((state_val_47661 === (23))){
var inst_47654 = (state_47660[(2)]);
var state_47660__$1 = state_47660;
var statearr_47704_49540 = state_47660__$1;
(statearr_47704_49540[(2)] = inst_47654);

(statearr_47704_49540[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (19))){
var inst_47641 = (state_47660[(2)]);
var state_47660__$1 = state_47660;
var statearr_47705_49542 = state_47660__$1;
(statearr_47705_49542[(2)] = inst_47641);

(statearr_47705_49542[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (11))){
var inst_47606 = (state_47660[(9)]);
var inst_47623 = (state_47660[(7)]);
var inst_47623__$1 = cljs.core.seq(inst_47606);
var state_47660__$1 = (function (){var statearr_47706 = state_47660;
(statearr_47706[(7)] = inst_47623__$1);

return statearr_47706;
})();
if(inst_47623__$1){
var statearr_47708_49543 = state_47660__$1;
(statearr_47708_49543[(1)] = (14));

} else {
var statearr_47709_49544 = state_47660__$1;
(statearr_47709_49544[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (9))){
var inst_47648 = (state_47660[(2)]);
var inst_47649 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_47660__$1 = (function (){var statearr_47711 = state_47660;
(statearr_47711[(15)] = inst_47648);

return statearr_47711;
})();
if(cljs.core.truth_(inst_47649)){
var statearr_47712_49546 = state_47660__$1;
(statearr_47712_49546[(1)] = (21));

} else {
var statearr_47713_49547 = state_47660__$1;
(statearr_47713_49547[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (5))){
var inst_47598 = cljs.core.async.close_BANG_(out);
var state_47660__$1 = state_47660;
var statearr_47714_49548 = state_47660__$1;
(statearr_47714_49548[(2)] = inst_47598);

(statearr_47714_49548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (14))){
var inst_47623 = (state_47660[(7)]);
var inst_47628 = cljs.core.chunked_seq_QMARK_(inst_47623);
var state_47660__$1 = state_47660;
if(inst_47628){
var statearr_47716_49550 = state_47660__$1;
(statearr_47716_49550[(1)] = (17));

} else {
var statearr_47717_49551 = state_47660__$1;
(statearr_47717_49551[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (16))){
var inst_47644 = (state_47660[(2)]);
var state_47660__$1 = state_47660;
var statearr_47722_49552 = state_47660__$1;
(statearr_47722_49552[(2)] = inst_47644);

(statearr_47722_49552[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47661 === (10))){
var inst_47612 = (state_47660[(8)]);
var inst_47607 = (state_47660[(10)]);
var inst_47617 = cljs.core._nth(inst_47607,inst_47612);
var state_47660__$1 = state_47660;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47660__$1,(13),out,inst_47617);
} else {
if((state_val_47661 === (18))){
var inst_47623 = (state_47660[(7)]);
var inst_47635 = cljs.core.first(inst_47623);
var state_47660__$1 = state_47660;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47660__$1,(20),out,inst_47635);
} else {
if((state_val_47661 === (8))){
var inst_47612 = (state_47660[(8)]);
var inst_47608 = (state_47660[(12)]);
var inst_47614 = (inst_47612 < inst_47608);
var inst_47615 = inst_47614;
var state_47660__$1 = state_47660;
if(cljs.core.truth_(inst_47615)){
var statearr_47723_49556 = state_47660__$1;
(statearr_47723_49556[(1)] = (10));

} else {
var statearr_47724_49557 = state_47660__$1;
(statearr_47724_49557[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__44245__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__44245__auto____0 = (function (){
var statearr_47725 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47725[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__44245__auto__);

(statearr_47725[(1)] = (1));

return statearr_47725;
});
var cljs$core$async$mapcat_STAR__$_state_machine__44245__auto____1 = (function (state_47660){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_47660);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e47726){var ex__44248__auto__ = e47726;
var statearr_47727_49560 = state_47660;
(statearr_47727_49560[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_47660[(4)]))){
var statearr_47728_49561 = state_47660;
(statearr_47728_49561[(1)] = cljs.core.first((state_47660[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49563 = state_47660;
state_47660 = G__49563;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__44245__auto__ = function(state_47660){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__44245__auto____1.call(this,state_47660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__44245__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__44245__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_47729 = f__44367__auto__();
(statearr_47729[(6)] = c__44365__auto__);

return statearr_47729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));

return c__44365__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__47731 = arguments.length;
switch (G__47731) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__47740 = arguments.length;
switch (G__47740) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__47757 = arguments.length;
switch (G__47757) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44365__auto___49573 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_47785){
var state_val_47786 = (state_47785[(1)]);
if((state_val_47786 === (7))){
var inst_47780 = (state_47785[(2)]);
var state_47785__$1 = state_47785;
var statearr_47789_49575 = state_47785__$1;
(statearr_47789_49575[(2)] = inst_47780);

(statearr_47789_49575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47786 === (1))){
var inst_47762 = null;
var state_47785__$1 = (function (){var statearr_47792 = state_47785;
(statearr_47792[(7)] = inst_47762);

return statearr_47792;
})();
var statearr_47793_49577 = state_47785__$1;
(statearr_47793_49577[(2)] = null);

(statearr_47793_49577[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47786 === (4))){
var inst_47765 = (state_47785[(8)]);
var inst_47765__$1 = (state_47785[(2)]);
var inst_47766 = (inst_47765__$1 == null);
var inst_47767 = cljs.core.not(inst_47766);
var state_47785__$1 = (function (){var statearr_47800 = state_47785;
(statearr_47800[(8)] = inst_47765__$1);

return statearr_47800;
})();
if(inst_47767){
var statearr_47801_49580 = state_47785__$1;
(statearr_47801_49580[(1)] = (5));

} else {
var statearr_47802_49581 = state_47785__$1;
(statearr_47802_49581[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47786 === (6))){
var state_47785__$1 = state_47785;
var statearr_47803_49582 = state_47785__$1;
(statearr_47803_49582[(2)] = null);

(statearr_47803_49582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47786 === (3))){
var inst_47782 = (state_47785[(2)]);
var inst_47783 = cljs.core.async.close_BANG_(out);
var state_47785__$1 = (function (){var statearr_47804 = state_47785;
(statearr_47804[(9)] = inst_47782);

return statearr_47804;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47785__$1,inst_47783);
} else {
if((state_val_47786 === (2))){
var state_47785__$1 = state_47785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47785__$1,(4),ch);
} else {
if((state_val_47786 === (11))){
var inst_47765 = (state_47785[(8)]);
var inst_47774 = (state_47785[(2)]);
var inst_47762 = inst_47765;
var state_47785__$1 = (function (){var statearr_47809 = state_47785;
(statearr_47809[(7)] = inst_47762);

(statearr_47809[(10)] = inst_47774);

return statearr_47809;
})();
var statearr_47810_49584 = state_47785__$1;
(statearr_47810_49584[(2)] = null);

(statearr_47810_49584[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47786 === (9))){
var inst_47765 = (state_47785[(8)]);
var state_47785__$1 = state_47785;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47785__$1,(11),out,inst_47765);
} else {
if((state_val_47786 === (5))){
var inst_47765 = (state_47785[(8)]);
var inst_47762 = (state_47785[(7)]);
var inst_47769 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47765,inst_47762);
var state_47785__$1 = state_47785;
if(inst_47769){
var statearr_47812_49586 = state_47785__$1;
(statearr_47812_49586[(1)] = (8));

} else {
var statearr_47813_49587 = state_47785__$1;
(statearr_47813_49587[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47786 === (10))){
var inst_47777 = (state_47785[(2)]);
var state_47785__$1 = state_47785;
var statearr_47814_49588 = state_47785__$1;
(statearr_47814_49588[(2)] = inst_47777);

(statearr_47814_49588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47786 === (8))){
var inst_47762 = (state_47785[(7)]);
var tmp47811 = inst_47762;
var inst_47762__$1 = tmp47811;
var state_47785__$1 = (function (){var statearr_47817 = state_47785;
(statearr_47817[(7)] = inst_47762__$1);

return statearr_47817;
})();
var statearr_47818_49590 = state_47785__$1;
(statearr_47818_49590[(2)] = null);

(statearr_47818_49590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_47821 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47821[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_47821[(1)] = (1));

return statearr_47821;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_47785){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_47785);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e47823){var ex__44248__auto__ = e47823;
var statearr_47825_49592 = state_47785;
(statearr_47825_49592[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_47785[(4)]))){
var statearr_47826_49593 = state_47785;
(statearr_47826_49593[(1)] = cljs.core.first((state_47785[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49594 = state_47785;
state_47785 = G__49594;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_47785){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_47785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_47828 = f__44367__auto__();
(statearr_47828[(6)] = c__44365__auto___49573);

return statearr_47828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__47831 = arguments.length;
switch (G__47831) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44365__auto___49600 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_47882){
var state_val_47883 = (state_47882[(1)]);
if((state_val_47883 === (7))){
var inst_47877 = (state_47882[(2)]);
var state_47882__$1 = state_47882;
var statearr_47897_49601 = state_47882__$1;
(statearr_47897_49601[(2)] = inst_47877);

(statearr_47897_49601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (1))){
var inst_47841 = (new Array(n));
var inst_47842 = inst_47841;
var inst_47843 = (0);
var state_47882__$1 = (function (){var statearr_47900 = state_47882;
(statearr_47900[(7)] = inst_47843);

(statearr_47900[(8)] = inst_47842);

return statearr_47900;
})();
var statearr_47901_49604 = state_47882__$1;
(statearr_47901_49604[(2)] = null);

(statearr_47901_49604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (4))){
var inst_47846 = (state_47882[(9)]);
var inst_47846__$1 = (state_47882[(2)]);
var inst_47847 = (inst_47846__$1 == null);
var inst_47848 = cljs.core.not(inst_47847);
var state_47882__$1 = (function (){var statearr_47904 = state_47882;
(statearr_47904[(9)] = inst_47846__$1);

return statearr_47904;
})();
if(inst_47848){
var statearr_47905_49606 = state_47882__$1;
(statearr_47905_49606[(1)] = (5));

} else {
var statearr_47906_49607 = state_47882__$1;
(statearr_47906_49607[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (15))){
var inst_47871 = (state_47882[(2)]);
var state_47882__$1 = state_47882;
var statearr_47909_49608 = state_47882__$1;
(statearr_47909_49608[(2)] = inst_47871);

(statearr_47909_49608[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (13))){
var state_47882__$1 = state_47882;
var statearr_47910_49609 = state_47882__$1;
(statearr_47910_49609[(2)] = null);

(statearr_47910_49609[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (6))){
var inst_47843 = (state_47882[(7)]);
var inst_47865 = (inst_47843 > (0));
var state_47882__$1 = state_47882;
if(cljs.core.truth_(inst_47865)){
var statearr_47915_49611 = state_47882__$1;
(statearr_47915_49611[(1)] = (12));

} else {
var statearr_47917_49612 = state_47882__$1;
(statearr_47917_49612[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (3))){
var inst_47879 = (state_47882[(2)]);
var state_47882__$1 = state_47882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47882__$1,inst_47879);
} else {
if((state_val_47883 === (12))){
var inst_47842 = (state_47882[(8)]);
var inst_47869 = cljs.core.vec(inst_47842);
var state_47882__$1 = state_47882;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47882__$1,(15),out,inst_47869);
} else {
if((state_val_47883 === (2))){
var state_47882__$1 = state_47882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47882__$1,(4),ch);
} else {
if((state_val_47883 === (11))){
var inst_47859 = (state_47882[(2)]);
var inst_47860 = (new Array(n));
var inst_47842 = inst_47860;
var inst_47843 = (0);
var state_47882__$1 = (function (){var statearr_47930 = state_47882;
(statearr_47930[(7)] = inst_47843);

(statearr_47930[(10)] = inst_47859);

(statearr_47930[(8)] = inst_47842);

return statearr_47930;
})();
var statearr_47935_49615 = state_47882__$1;
(statearr_47935_49615[(2)] = null);

(statearr_47935_49615[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (9))){
var inst_47842 = (state_47882[(8)]);
var inst_47857 = cljs.core.vec(inst_47842);
var state_47882__$1 = state_47882;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47882__$1,(11),out,inst_47857);
} else {
if((state_val_47883 === (5))){
var inst_47843 = (state_47882[(7)]);
var inst_47846 = (state_47882[(9)]);
var inst_47851 = (state_47882[(11)]);
var inst_47842 = (state_47882[(8)]);
var inst_47850 = (inst_47842[inst_47843] = inst_47846);
var inst_47851__$1 = (inst_47843 + (1));
var inst_47852 = (inst_47851__$1 < n);
var state_47882__$1 = (function (){var statearr_47946 = state_47882;
(statearr_47946[(12)] = inst_47850);

(statearr_47946[(11)] = inst_47851__$1);

return statearr_47946;
})();
if(cljs.core.truth_(inst_47852)){
var statearr_47949_49619 = state_47882__$1;
(statearr_47949_49619[(1)] = (8));

} else {
var statearr_47951_49620 = state_47882__$1;
(statearr_47951_49620[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (14))){
var inst_47874 = (state_47882[(2)]);
var inst_47875 = cljs.core.async.close_BANG_(out);
var state_47882__$1 = (function (){var statearr_47957 = state_47882;
(statearr_47957[(13)] = inst_47874);

return statearr_47957;
})();
var statearr_47961_49621 = state_47882__$1;
(statearr_47961_49621[(2)] = inst_47875);

(statearr_47961_49621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (10))){
var inst_47863 = (state_47882[(2)]);
var state_47882__$1 = state_47882;
var statearr_47966_49623 = state_47882__$1;
(statearr_47966_49623[(2)] = inst_47863);

(statearr_47966_49623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47883 === (8))){
var inst_47851 = (state_47882[(11)]);
var inst_47842 = (state_47882[(8)]);
var tmp47954 = inst_47842;
var inst_47842__$1 = tmp47954;
var inst_47843 = inst_47851;
var state_47882__$1 = (function (){var statearr_47971 = state_47882;
(statearr_47971[(7)] = inst_47843);

(statearr_47971[(8)] = inst_47842__$1);

return statearr_47971;
})();
var statearr_47974_49624 = state_47882__$1;
(statearr_47974_49624[(2)] = null);

(statearr_47974_49624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_47982 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47982[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_47982[(1)] = (1));

return statearr_47982;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_47882){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_47882);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e47987){var ex__44248__auto__ = e47987;
var statearr_47990_49626 = state_47882;
(statearr_47990_49626[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_47882[(4)]))){
var statearr_47993_49628 = state_47882;
(statearr_47993_49628[(1)] = cljs.core.first((state_47882[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49629 = state_47882;
state_47882 = G__49629;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_47882){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_47882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_48004 = f__44367__auto__();
(statearr_48004[(6)] = c__44365__auto___49600);

return statearr_48004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__48012 = arguments.length;
switch (G__48012) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44365__auto___49632 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_48092){
var state_val_48093 = (state_48092[(1)]);
if((state_val_48093 === (7))){
var inst_48086 = (state_48092[(2)]);
var state_48092__$1 = state_48092;
var statearr_48098_49634 = state_48092__$1;
(statearr_48098_49634[(2)] = inst_48086);

(statearr_48098_49634[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (1))){
var inst_48017 = [];
var inst_48018 = inst_48017;
var inst_48019 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_48092__$1 = (function (){var statearr_48104 = state_48092;
(statearr_48104[(7)] = inst_48019);

(statearr_48104[(8)] = inst_48018);

return statearr_48104;
})();
var statearr_48105_49639 = state_48092__$1;
(statearr_48105_49639[(2)] = null);

(statearr_48105_49639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (4))){
var inst_48030 = (state_48092[(9)]);
var inst_48030__$1 = (state_48092[(2)]);
var inst_48039 = (inst_48030__$1 == null);
var inst_48042 = cljs.core.not(inst_48039);
var state_48092__$1 = (function (){var statearr_48111 = state_48092;
(statearr_48111[(9)] = inst_48030__$1);

return statearr_48111;
})();
if(inst_48042){
var statearr_48118_49654 = state_48092__$1;
(statearr_48118_49654[(1)] = (5));

} else {
var statearr_48119_49655 = state_48092__$1;
(statearr_48119_49655[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (15))){
var inst_48018 = (state_48092[(8)]);
var inst_48078 = cljs.core.vec(inst_48018);
var state_48092__$1 = state_48092;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48092__$1,(18),out,inst_48078);
} else {
if((state_val_48093 === (13))){
var inst_48071 = (state_48092[(2)]);
var state_48092__$1 = state_48092;
var statearr_48128_49657 = state_48092__$1;
(statearr_48128_49657[(2)] = inst_48071);

(statearr_48128_49657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (6))){
var inst_48018 = (state_48092[(8)]);
var inst_48073 = inst_48018.length;
var inst_48075 = (inst_48073 > (0));
var state_48092__$1 = state_48092;
if(cljs.core.truth_(inst_48075)){
var statearr_48136_49658 = state_48092__$1;
(statearr_48136_49658[(1)] = (15));

} else {
var statearr_48137_49659 = state_48092__$1;
(statearr_48137_49659[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (17))){
var inst_48083 = (state_48092[(2)]);
var inst_48084 = cljs.core.async.close_BANG_(out);
var state_48092__$1 = (function (){var statearr_48144 = state_48092;
(statearr_48144[(10)] = inst_48083);

return statearr_48144;
})();
var statearr_48154_49668 = state_48092__$1;
(statearr_48154_49668[(2)] = inst_48084);

(statearr_48154_49668[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (3))){
var inst_48088 = (state_48092[(2)]);
var state_48092__$1 = state_48092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48092__$1,inst_48088);
} else {
if((state_val_48093 === (12))){
var inst_48018 = (state_48092[(8)]);
var inst_48064 = cljs.core.vec(inst_48018);
var state_48092__$1 = state_48092;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_48092__$1,(14),out,inst_48064);
} else {
if((state_val_48093 === (2))){
var state_48092__$1 = state_48092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48092__$1,(4),ch);
} else {
if((state_val_48093 === (11))){
var inst_48018 = (state_48092[(8)]);
var inst_48030 = (state_48092[(9)]);
var inst_48046 = (state_48092[(11)]);
var inst_48061 = inst_48018.push(inst_48030);
var tmp48166 = inst_48018;
var inst_48018__$1 = tmp48166;
var inst_48019 = inst_48046;
var state_48092__$1 = (function (){var statearr_48183 = state_48092;
(statearr_48183[(7)] = inst_48019);

(statearr_48183[(8)] = inst_48018__$1);

(statearr_48183[(12)] = inst_48061);

return statearr_48183;
})();
var statearr_48187_49674 = state_48092__$1;
(statearr_48187_49674[(2)] = null);

(statearr_48187_49674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (9))){
var inst_48019 = (state_48092[(7)]);
var inst_48057 = cljs.core.keyword_identical_QMARK_(inst_48019,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_48092__$1 = state_48092;
var statearr_48201_49680 = state_48092__$1;
(statearr_48201_49680[(2)] = inst_48057);

(statearr_48201_49680[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (5))){
var inst_48019 = (state_48092[(7)]);
var inst_48054 = (state_48092[(13)]);
var inst_48030 = (state_48092[(9)]);
var inst_48046 = (state_48092[(11)]);
var inst_48046__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_48030) : f.call(null,inst_48030));
var inst_48054__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48046__$1,inst_48019);
var state_48092__$1 = (function (){var statearr_48223 = state_48092;
(statearr_48223[(13)] = inst_48054__$1);

(statearr_48223[(11)] = inst_48046__$1);

return statearr_48223;
})();
if(inst_48054__$1){
var statearr_48225_49688 = state_48092__$1;
(statearr_48225_49688[(1)] = (8));

} else {
var statearr_48227_49690 = state_48092__$1;
(statearr_48227_49690[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (14))){
var inst_48030 = (state_48092[(9)]);
var inst_48046 = (state_48092[(11)]);
var inst_48066 = (state_48092[(2)]);
var inst_48067 = [];
var inst_48068 = inst_48067.push(inst_48030);
var inst_48018 = inst_48067;
var inst_48019 = inst_48046;
var state_48092__$1 = (function (){var statearr_48233 = state_48092;
(statearr_48233[(7)] = inst_48019);

(statearr_48233[(8)] = inst_48018);

(statearr_48233[(14)] = inst_48068);

(statearr_48233[(15)] = inst_48066);

return statearr_48233;
})();
var statearr_48240_49707 = state_48092__$1;
(statearr_48240_49707[(2)] = null);

(statearr_48240_49707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (16))){
var state_48092__$1 = state_48092;
var statearr_48243_49716 = state_48092__$1;
(statearr_48243_49716[(2)] = null);

(statearr_48243_49716[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (10))){
var inst_48059 = (state_48092[(2)]);
var state_48092__$1 = state_48092;
if(cljs.core.truth_(inst_48059)){
var statearr_48249_49717 = state_48092__$1;
(statearr_48249_49717[(1)] = (11));

} else {
var statearr_48251_49718 = state_48092__$1;
(statearr_48251_49718[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (18))){
var inst_48080 = (state_48092[(2)]);
var state_48092__$1 = state_48092;
var statearr_48256_49720 = state_48092__$1;
(statearr_48256_49720[(2)] = inst_48080);

(statearr_48256_49720[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48093 === (8))){
var inst_48054 = (state_48092[(13)]);
var state_48092__$1 = state_48092;
var statearr_48262_49721 = state_48092__$1;
(statearr_48262_49721[(2)] = inst_48054);

(statearr_48262_49721[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44245__auto__ = null;
var cljs$core$async$state_machine__44245__auto____0 = (function (){
var statearr_48271 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48271[(0)] = cljs$core$async$state_machine__44245__auto__);

(statearr_48271[(1)] = (1));

return statearr_48271;
});
var cljs$core$async$state_machine__44245__auto____1 = (function (state_48092){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_48092);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e48276){var ex__44248__auto__ = e48276;
var statearr_48280_49730 = state_48092;
(statearr_48280_49730[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_48092[(4)]))){
var statearr_48286_49731 = state_48092;
(statearr_48286_49731[(1)] = cljs.core.first((state_48092[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49737 = state_48092;
state_48092 = G__49737;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
cljs$core$async$state_machine__44245__auto__ = function(state_48092){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44245__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44245__auto____1.call(this,state_48092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44245__auto____0;
cljs$core$async$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44245__auto____1;
return cljs$core$async$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_48294 = f__44367__auto__();
(statearr_48294[(6)] = c__44365__auto___49632);

return statearr_48294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
