goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_52155 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_52155(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_52156 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_52156(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__50770 = coll;
var G__50771 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__50770,G__50771) : shadow.dom.lazy_native_coll_seq.call(null,G__50770,G__50771));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4253__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__50817 = arguments.length;
switch (G__50817) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__50826 = arguments.length;
switch (G__50826) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__50843 = arguments.length;
switch (G__50843) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__50853 = arguments.length;
switch (G__50853) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__50867 = arguments.length;
switch (G__50867) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__50879 = arguments.length;
switch (G__50879) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e50902){if((e50902 instanceof Object)){
var e = e50902;
return console.log("didnt support attachEvent",el,e);
} else {
throw e50902;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__50929 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__50930 = null;
var count__50931 = (0);
var i__50932 = (0);
while(true){
if((i__50932 < count__50931)){
var el = chunk__50930.cljs$core$IIndexed$_nth$arity$2(null,i__50932);
var handler_52185__$1 = ((function (seq__50929,chunk__50930,count__50931,i__50932,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__50929,chunk__50930,count__50931,i__50932,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52185__$1);


var G__52186 = seq__50929;
var G__52187 = chunk__50930;
var G__52188 = count__50931;
var G__52189 = (i__50932 + (1));
seq__50929 = G__52186;
chunk__50930 = G__52187;
count__50931 = G__52188;
i__50932 = G__52189;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__50929);
if(temp__5753__auto__){
var seq__50929__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50929__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__50929__$1);
var G__52190 = cljs.core.chunk_rest(seq__50929__$1);
var G__52191 = c__4679__auto__;
var G__52192 = cljs.core.count(c__4679__auto__);
var G__52193 = (0);
seq__50929 = G__52190;
chunk__50930 = G__52191;
count__50931 = G__52192;
i__50932 = G__52193;
continue;
} else {
var el = cljs.core.first(seq__50929__$1);
var handler_52194__$1 = ((function (seq__50929,chunk__50930,count__50931,i__50932,el,seq__50929__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__50929,chunk__50930,count__50931,i__50932,el,seq__50929__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52194__$1);


var G__52195 = cljs.core.next(seq__50929__$1);
var G__52196 = null;
var G__52197 = (0);
var G__52198 = (0);
seq__50929 = G__52195;
chunk__50930 = G__52196;
count__50931 = G__52197;
i__50932 = G__52198;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__50989 = arguments.length;
switch (G__50989) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__51041 = cljs.core.seq(events);
var chunk__51042 = null;
var count__51043 = (0);
var i__51044 = (0);
while(true){
if((i__51044 < count__51043)){
var vec__51058 = chunk__51042.cljs$core$IIndexed$_nth$arity$2(null,i__51044);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51058,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51058,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52203 = seq__51041;
var G__52204 = chunk__51042;
var G__52205 = count__51043;
var G__52206 = (i__51044 + (1));
seq__51041 = G__52203;
chunk__51042 = G__52204;
count__51043 = G__52205;
i__51044 = G__52206;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__51041);
if(temp__5753__auto__){
var seq__51041__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51041__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__51041__$1);
var G__52207 = cljs.core.chunk_rest(seq__51041__$1);
var G__52208 = c__4679__auto__;
var G__52209 = cljs.core.count(c__4679__auto__);
var G__52210 = (0);
seq__51041 = G__52207;
chunk__51042 = G__52208;
count__51043 = G__52209;
i__51044 = G__52210;
continue;
} else {
var vec__51063 = cljs.core.first(seq__51041__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51063,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51063,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52213 = cljs.core.next(seq__51041__$1);
var G__52214 = null;
var G__52215 = (0);
var G__52216 = (0);
seq__51041 = G__52213;
chunk__51042 = G__52214;
count__51043 = G__52215;
i__51044 = G__52216;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__51067 = cljs.core.seq(styles);
var chunk__51068 = null;
var count__51069 = (0);
var i__51070 = (0);
while(true){
if((i__51070 < count__51069)){
var vec__51083 = chunk__51068.cljs$core$IIndexed$_nth$arity$2(null,i__51070);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51083,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51083,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52220 = seq__51067;
var G__52221 = chunk__51068;
var G__52222 = count__51069;
var G__52223 = (i__51070 + (1));
seq__51067 = G__52220;
chunk__51068 = G__52221;
count__51069 = G__52222;
i__51070 = G__52223;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__51067);
if(temp__5753__auto__){
var seq__51067__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51067__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__51067__$1);
var G__52225 = cljs.core.chunk_rest(seq__51067__$1);
var G__52226 = c__4679__auto__;
var G__52227 = cljs.core.count(c__4679__auto__);
var G__52228 = (0);
seq__51067 = G__52225;
chunk__51068 = G__52226;
count__51069 = G__52227;
i__51070 = G__52228;
continue;
} else {
var vec__51092 = cljs.core.first(seq__51067__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51092,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51092,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52230 = cljs.core.next(seq__51067__$1);
var G__52231 = null;
var G__52232 = (0);
var G__52233 = (0);
seq__51067 = G__52230;
chunk__51068 = G__52231;
count__51069 = G__52232;
i__51070 = G__52233;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__51098_52234 = key;
var G__51098_52235__$1 = (((G__51098_52234 instanceof cljs.core.Keyword))?G__51098_52234.fqn:null);
switch (G__51098_52235__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_52240 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4253__auto__ = goog.string.startsWith(ks_52240,"data-");
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return goog.string.startsWith(ks_52240,"aria-");
}
})())){
el.setAttribute(ks_52240,value);
} else {
(el[ks_52240] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__51119){
var map__51120 = p__51119;
var map__51120__$1 = cljs.core.__destructure_map(map__51120);
var props = map__51120__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51120__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__51122 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51122,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51122,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51122,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__51128 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__51128,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__51128;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__51132 = arguments.length;
switch (G__51132) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__51150){
var vec__51151 = p__51150;
var seq__51152 = cljs.core.seq(vec__51151);
var first__51153 = cljs.core.first(seq__51152);
var seq__51152__$1 = cljs.core.next(seq__51152);
var nn = first__51153;
var first__51153__$1 = cljs.core.first(seq__51152__$1);
var seq__51152__$2 = cljs.core.next(seq__51152__$1);
var np = first__51153__$1;
var nc = seq__51152__$2;
var node = vec__51151;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51154 = nn;
var G__51155 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51154,G__51155) : create_fn.call(null,G__51154,G__51155));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51157 = nn;
var G__51158 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51157,G__51158) : create_fn.call(null,G__51157,G__51158));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__51162 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51162,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51162,(1),null);
var seq__51165_52268 = cljs.core.seq(node_children);
var chunk__51166_52269 = null;
var count__51167_52270 = (0);
var i__51168_52271 = (0);
while(true){
if((i__51168_52271 < count__51167_52270)){
var child_struct_52273 = chunk__51166_52269.cljs$core$IIndexed$_nth$arity$2(null,i__51168_52271);
var children_52274 = shadow.dom.dom_node(child_struct_52273);
if(cljs.core.seq_QMARK_(children_52274)){
var seq__51215_52275 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52274));
var chunk__51217_52276 = null;
var count__51218_52277 = (0);
var i__51219_52278 = (0);
while(true){
if((i__51219_52278 < count__51218_52277)){
var child_52279 = chunk__51217_52276.cljs$core$IIndexed$_nth$arity$2(null,i__51219_52278);
if(cljs.core.truth_(child_52279)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52279);


var G__52280 = seq__51215_52275;
var G__52281 = chunk__51217_52276;
var G__52282 = count__51218_52277;
var G__52283 = (i__51219_52278 + (1));
seq__51215_52275 = G__52280;
chunk__51217_52276 = G__52281;
count__51218_52277 = G__52282;
i__51219_52278 = G__52283;
continue;
} else {
var G__52284 = seq__51215_52275;
var G__52285 = chunk__51217_52276;
var G__52286 = count__51218_52277;
var G__52287 = (i__51219_52278 + (1));
seq__51215_52275 = G__52284;
chunk__51217_52276 = G__52285;
count__51218_52277 = G__52286;
i__51219_52278 = G__52287;
continue;
}
} else {
var temp__5753__auto___52290 = cljs.core.seq(seq__51215_52275);
if(temp__5753__auto___52290){
var seq__51215_52291__$1 = temp__5753__auto___52290;
if(cljs.core.chunked_seq_QMARK_(seq__51215_52291__$1)){
var c__4679__auto___52292 = cljs.core.chunk_first(seq__51215_52291__$1);
var G__52295 = cljs.core.chunk_rest(seq__51215_52291__$1);
var G__52296 = c__4679__auto___52292;
var G__52297 = cljs.core.count(c__4679__auto___52292);
var G__52298 = (0);
seq__51215_52275 = G__52295;
chunk__51217_52276 = G__52296;
count__51218_52277 = G__52297;
i__51219_52278 = G__52298;
continue;
} else {
var child_52300 = cljs.core.first(seq__51215_52291__$1);
if(cljs.core.truth_(child_52300)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52300);


var G__52301 = cljs.core.next(seq__51215_52291__$1);
var G__52302 = null;
var G__52303 = (0);
var G__52304 = (0);
seq__51215_52275 = G__52301;
chunk__51217_52276 = G__52302;
count__51218_52277 = G__52303;
i__51219_52278 = G__52304;
continue;
} else {
var G__52305 = cljs.core.next(seq__51215_52291__$1);
var G__52306 = null;
var G__52307 = (0);
var G__52308 = (0);
seq__51215_52275 = G__52305;
chunk__51217_52276 = G__52306;
count__51218_52277 = G__52307;
i__51219_52278 = G__52308;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52274);
}


var G__52309 = seq__51165_52268;
var G__52310 = chunk__51166_52269;
var G__52311 = count__51167_52270;
var G__52312 = (i__51168_52271 + (1));
seq__51165_52268 = G__52309;
chunk__51166_52269 = G__52310;
count__51167_52270 = G__52311;
i__51168_52271 = G__52312;
continue;
} else {
var temp__5753__auto___52313 = cljs.core.seq(seq__51165_52268);
if(temp__5753__auto___52313){
var seq__51165_52315__$1 = temp__5753__auto___52313;
if(cljs.core.chunked_seq_QMARK_(seq__51165_52315__$1)){
var c__4679__auto___52316 = cljs.core.chunk_first(seq__51165_52315__$1);
var G__52317 = cljs.core.chunk_rest(seq__51165_52315__$1);
var G__52318 = c__4679__auto___52316;
var G__52319 = cljs.core.count(c__4679__auto___52316);
var G__52320 = (0);
seq__51165_52268 = G__52317;
chunk__51166_52269 = G__52318;
count__51167_52270 = G__52319;
i__51168_52271 = G__52320;
continue;
} else {
var child_struct_52321 = cljs.core.first(seq__51165_52315__$1);
var children_52322 = shadow.dom.dom_node(child_struct_52321);
if(cljs.core.seq_QMARK_(children_52322)){
var seq__51233_52323 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52322));
var chunk__51235_52324 = null;
var count__51236_52325 = (0);
var i__51237_52326 = (0);
while(true){
if((i__51237_52326 < count__51236_52325)){
var child_52329 = chunk__51235_52324.cljs$core$IIndexed$_nth$arity$2(null,i__51237_52326);
if(cljs.core.truth_(child_52329)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52329);


var G__52331 = seq__51233_52323;
var G__52332 = chunk__51235_52324;
var G__52333 = count__51236_52325;
var G__52334 = (i__51237_52326 + (1));
seq__51233_52323 = G__52331;
chunk__51235_52324 = G__52332;
count__51236_52325 = G__52333;
i__51237_52326 = G__52334;
continue;
} else {
var G__52337 = seq__51233_52323;
var G__52338 = chunk__51235_52324;
var G__52339 = count__51236_52325;
var G__52340 = (i__51237_52326 + (1));
seq__51233_52323 = G__52337;
chunk__51235_52324 = G__52338;
count__51236_52325 = G__52339;
i__51237_52326 = G__52340;
continue;
}
} else {
var temp__5753__auto___52341__$1 = cljs.core.seq(seq__51233_52323);
if(temp__5753__auto___52341__$1){
var seq__51233_52343__$1 = temp__5753__auto___52341__$1;
if(cljs.core.chunked_seq_QMARK_(seq__51233_52343__$1)){
var c__4679__auto___52344 = cljs.core.chunk_first(seq__51233_52343__$1);
var G__52345 = cljs.core.chunk_rest(seq__51233_52343__$1);
var G__52346 = c__4679__auto___52344;
var G__52347 = cljs.core.count(c__4679__auto___52344);
var G__52348 = (0);
seq__51233_52323 = G__52345;
chunk__51235_52324 = G__52346;
count__51236_52325 = G__52347;
i__51237_52326 = G__52348;
continue;
} else {
var child_52350 = cljs.core.first(seq__51233_52343__$1);
if(cljs.core.truth_(child_52350)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52350);


var G__52352 = cljs.core.next(seq__51233_52343__$1);
var G__52353 = null;
var G__52354 = (0);
var G__52355 = (0);
seq__51233_52323 = G__52352;
chunk__51235_52324 = G__52353;
count__51236_52325 = G__52354;
i__51237_52326 = G__52355;
continue;
} else {
var G__52356 = cljs.core.next(seq__51233_52343__$1);
var G__52357 = null;
var G__52358 = (0);
var G__52359 = (0);
seq__51233_52323 = G__52356;
chunk__51235_52324 = G__52357;
count__51236_52325 = G__52358;
i__51237_52326 = G__52359;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52322);
}


var G__52361 = cljs.core.next(seq__51165_52315__$1);
var G__52362 = null;
var G__52363 = (0);
var G__52364 = (0);
seq__51165_52268 = G__52361;
chunk__51166_52269 = G__52362;
count__51167_52270 = G__52363;
i__51168_52271 = G__52364;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__51276 = cljs.core.seq(node);
var chunk__51277 = null;
var count__51278 = (0);
var i__51279 = (0);
while(true){
if((i__51279 < count__51278)){
var n = chunk__51277.cljs$core$IIndexed$_nth$arity$2(null,i__51279);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52371 = seq__51276;
var G__52372 = chunk__51277;
var G__52373 = count__51278;
var G__52374 = (i__51279 + (1));
seq__51276 = G__52371;
chunk__51277 = G__52372;
count__51278 = G__52373;
i__51279 = G__52374;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__51276);
if(temp__5753__auto__){
var seq__51276__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51276__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__51276__$1);
var G__52375 = cljs.core.chunk_rest(seq__51276__$1);
var G__52376 = c__4679__auto__;
var G__52377 = cljs.core.count(c__4679__auto__);
var G__52378 = (0);
seq__51276 = G__52375;
chunk__51277 = G__52376;
count__51278 = G__52377;
i__51279 = G__52378;
continue;
} else {
var n = cljs.core.first(seq__51276__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52382 = cljs.core.next(seq__51276__$1);
var G__52384 = null;
var G__52385 = (0);
var G__52386 = (0);
seq__51276 = G__52382;
chunk__51277 = G__52384;
count__51278 = G__52385;
i__51279 = G__52386;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__51288 = arguments.length;
switch (G__51288) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__51297 = arguments.length;
switch (G__51297) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__51318 = arguments.length;
switch (G__51318) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4253__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4870__auto__ = [];
var len__4864__auto___52405 = arguments.length;
var i__4865__auto___52406 = (0);
while(true){
if((i__4865__auto___52406 < len__4864__auto___52405)){
args__4870__auto__.push((arguments[i__4865__auto___52406]));

var G__52408 = (i__4865__auto___52406 + (1));
i__4865__auto___52406 = G__52408;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__51360_52409 = cljs.core.seq(nodes);
var chunk__51362_52410 = null;
var count__51363_52411 = (0);
var i__51364_52412 = (0);
while(true){
if((i__51364_52412 < count__51363_52411)){
var node_52419 = chunk__51362_52410.cljs$core$IIndexed$_nth$arity$2(null,i__51364_52412);
fragment.appendChild(shadow.dom._to_dom(node_52419));


var G__52420 = seq__51360_52409;
var G__52421 = chunk__51362_52410;
var G__52422 = count__51363_52411;
var G__52423 = (i__51364_52412 + (1));
seq__51360_52409 = G__52420;
chunk__51362_52410 = G__52421;
count__51363_52411 = G__52422;
i__51364_52412 = G__52423;
continue;
} else {
var temp__5753__auto___52424 = cljs.core.seq(seq__51360_52409);
if(temp__5753__auto___52424){
var seq__51360_52426__$1 = temp__5753__auto___52424;
if(cljs.core.chunked_seq_QMARK_(seq__51360_52426__$1)){
var c__4679__auto___52428 = cljs.core.chunk_first(seq__51360_52426__$1);
var G__52430 = cljs.core.chunk_rest(seq__51360_52426__$1);
var G__52431 = c__4679__auto___52428;
var G__52432 = cljs.core.count(c__4679__auto___52428);
var G__52433 = (0);
seq__51360_52409 = G__52430;
chunk__51362_52410 = G__52431;
count__51363_52411 = G__52432;
i__51364_52412 = G__52433;
continue;
} else {
var node_52434 = cljs.core.first(seq__51360_52426__$1);
fragment.appendChild(shadow.dom._to_dom(node_52434));


var G__52435 = cljs.core.next(seq__51360_52426__$1);
var G__52436 = null;
var G__52437 = (0);
var G__52438 = (0);
seq__51360_52409 = G__52435;
chunk__51362_52410 = G__52436;
count__51363_52411 = G__52437;
i__51364_52412 = G__52438;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq51352){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq51352));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__51399_52444 = cljs.core.seq(scripts);
var chunk__51400_52445 = null;
var count__51401_52446 = (0);
var i__51402_52447 = (0);
while(true){
if((i__51402_52447 < count__51401_52446)){
var vec__51432_52453 = chunk__51400_52445.cljs$core$IIndexed$_nth$arity$2(null,i__51402_52447);
var script_tag_52455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51432_52453,(0),null);
var script_body_52456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51432_52453,(1),null);
eval(script_body_52456);


var G__52467 = seq__51399_52444;
var G__52468 = chunk__51400_52445;
var G__52469 = count__51401_52446;
var G__52470 = (i__51402_52447 + (1));
seq__51399_52444 = G__52467;
chunk__51400_52445 = G__52468;
count__51401_52446 = G__52469;
i__51402_52447 = G__52470;
continue;
} else {
var temp__5753__auto___52479 = cljs.core.seq(seq__51399_52444);
if(temp__5753__auto___52479){
var seq__51399_52483__$1 = temp__5753__auto___52479;
if(cljs.core.chunked_seq_QMARK_(seq__51399_52483__$1)){
var c__4679__auto___52484 = cljs.core.chunk_first(seq__51399_52483__$1);
var G__52485 = cljs.core.chunk_rest(seq__51399_52483__$1);
var G__52486 = c__4679__auto___52484;
var G__52487 = cljs.core.count(c__4679__auto___52484);
var G__52488 = (0);
seq__51399_52444 = G__52485;
chunk__51400_52445 = G__52486;
count__51401_52446 = G__52487;
i__51402_52447 = G__52488;
continue;
} else {
var vec__51468_52490 = cljs.core.first(seq__51399_52483__$1);
var script_tag_52491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51468_52490,(0),null);
var script_body_52492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51468_52490,(1),null);
eval(script_body_52492);


var G__52494 = cljs.core.next(seq__51399_52483__$1);
var G__52495 = null;
var G__52496 = (0);
var G__52497 = (0);
seq__51399_52444 = G__52494;
chunk__51400_52445 = G__52495;
count__51401_52446 = G__52496;
i__51402_52447 = G__52497;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__51482){
var vec__51484 = p__51482;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51484,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51484,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__51512 = arguments.length;
switch (G__51512) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__51534 = cljs.core.seq(style_keys);
var chunk__51535 = null;
var count__51536 = (0);
var i__51537 = (0);
while(true){
if((i__51537 < count__51536)){
var it = chunk__51535.cljs$core$IIndexed$_nth$arity$2(null,i__51537);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52519 = seq__51534;
var G__52520 = chunk__51535;
var G__52521 = count__51536;
var G__52522 = (i__51537 + (1));
seq__51534 = G__52519;
chunk__51535 = G__52520;
count__51536 = G__52521;
i__51537 = G__52522;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__51534);
if(temp__5753__auto__){
var seq__51534__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51534__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__51534__$1);
var G__52528 = cljs.core.chunk_rest(seq__51534__$1);
var G__52529 = c__4679__auto__;
var G__52530 = cljs.core.count(c__4679__auto__);
var G__52531 = (0);
seq__51534 = G__52528;
chunk__51535 = G__52529;
count__51536 = G__52530;
i__51537 = G__52531;
continue;
} else {
var it = cljs.core.first(seq__51534__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52533 = cljs.core.next(seq__51534__$1);
var G__52534 = null;
var G__52535 = (0);
var G__52536 = (0);
seq__51534 = G__52533;
chunk__51535 = G__52534;
count__51536 = G__52535;
i__51537 = G__52536;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k51551,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__51565 = k51551;
var G__51565__$1 = (((G__51565 instanceof cljs.core.Keyword))?G__51565.fqn:null);
switch (G__51565__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k51551,else__4505__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__51569){
var vec__51572 = p__51569;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51572,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51572,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__51550){
var self__ = this;
var G__51550__$1 = this;
return (new cljs.core.RecordIter((0),G__51550__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this51552,other51553){
var self__ = this;
var this51552__$1 = this;
return (((!((other51553 == null)))) && ((((this51552__$1.constructor === other51553.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51552__$1.x,other51553.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51552__$1.y,other51553.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51552__$1.__extmap,other51553.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k51551){
var self__ = this;
var this__4509__auto____$1 = this;
var G__51603 = k51551;
var G__51603__$1 = (((G__51603 instanceof cljs.core.Keyword))?G__51603.fqn:null);
switch (G__51603__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k51551);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__51550){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__51607 = cljs.core.keyword_identical_QMARK_;
var expr__51608 = k__4511__auto__;
if(cljs.core.truth_((pred__51607.cljs$core$IFn$_invoke$arity$2 ? pred__51607.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__51608) : pred__51607.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__51608)))){
return (new shadow.dom.Coordinate(G__51550,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__51607.cljs$core$IFn$_invoke$arity$2 ? pred__51607.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__51608) : pred__51607.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__51608)))){
return (new shadow.dom.Coordinate(self__.x,G__51550,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__51550),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__51550){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__51550,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__51556){
var extmap__4542__auto__ = (function (){var G__51629 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__51556,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__51556)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__51629);
} else {
return G__51629;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__51556),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__51556),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k51646,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__51658 = k51646;
var G__51658__$1 = (((G__51658 instanceof cljs.core.Keyword))?G__51658.fqn:null);
switch (G__51658__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k51646,else__4505__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__51659){
var vec__51660 = p__51659;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51660,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51660,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Size{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__51645){
var self__ = this;
var G__51645__$1 = this;
return (new cljs.core.RecordIter((0),G__51645__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this51647,other51648){
var self__ = this;
var this51647__$1 = this;
return (((!((other51648 == null)))) && ((((this51647__$1.constructor === other51648.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51647__$1.w,other51648.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51647__$1.h,other51648.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51647__$1.__extmap,other51648.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k51646){
var self__ = this;
var this__4509__auto____$1 = this;
var G__51686 = k51646;
var G__51686__$1 = (((G__51686 instanceof cljs.core.Keyword))?G__51686.fqn:null);
switch (G__51686__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k51646);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__51645){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__51689 = cljs.core.keyword_identical_QMARK_;
var expr__51690 = k__4511__auto__;
if(cljs.core.truth_((pred__51689.cljs$core$IFn$_invoke$arity$2 ? pred__51689.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__51690) : pred__51689.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__51690)))){
return (new shadow.dom.Size(G__51645,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__51689.cljs$core$IFn$_invoke$arity$2 ? pred__51689.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__51690) : pred__51689.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__51690)))){
return (new shadow.dom.Size(self__.w,G__51645,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__51645),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__51645){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__51645,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__51655){
var extmap__4542__auto__ = (function (){var G__51703 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__51655,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__51655)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__51703);
} else {
return G__51703;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__51655),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__51655),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4738__auto__ = opts;
var l__4739__auto__ = a__4738__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4739__auto__)){
var G__52651 = (i + (1));
var G__52652 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__52651;
ret = G__52652;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__51730){
var vec__51732 = p__51730;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51732,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51732,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__51736 = arguments.length;
switch (G__51736) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__52675 = ps;
var G__52676 = (i + (1));
el__$1 = G__52675;
i = G__52676;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__51793 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51793,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51793,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51793,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__51798_52689 = cljs.core.seq(props);
var chunk__51799_52690 = null;
var count__51800_52691 = (0);
var i__51801_52692 = (0);
while(true){
if((i__51801_52692 < count__51800_52691)){
var vec__51825_52693 = chunk__51799_52690.cljs$core$IIndexed$_nth$arity$2(null,i__51801_52692);
var k_52694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51825_52693,(0),null);
var v_52695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51825_52693,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_52694);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_52694),v_52695);


var G__52700 = seq__51798_52689;
var G__52701 = chunk__51799_52690;
var G__52702 = count__51800_52691;
var G__52703 = (i__51801_52692 + (1));
seq__51798_52689 = G__52700;
chunk__51799_52690 = G__52701;
count__51800_52691 = G__52702;
i__51801_52692 = G__52703;
continue;
} else {
var temp__5753__auto___52704 = cljs.core.seq(seq__51798_52689);
if(temp__5753__auto___52704){
var seq__51798_52705__$1 = temp__5753__auto___52704;
if(cljs.core.chunked_seq_QMARK_(seq__51798_52705__$1)){
var c__4679__auto___52706 = cljs.core.chunk_first(seq__51798_52705__$1);
var G__52707 = cljs.core.chunk_rest(seq__51798_52705__$1);
var G__52708 = c__4679__auto___52706;
var G__52709 = cljs.core.count(c__4679__auto___52706);
var G__52710 = (0);
seq__51798_52689 = G__52707;
chunk__51799_52690 = G__52708;
count__51800_52691 = G__52709;
i__51801_52692 = G__52710;
continue;
} else {
var vec__51830_52711 = cljs.core.first(seq__51798_52705__$1);
var k_52712 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51830_52711,(0),null);
var v_52713 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51830_52711,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_52712);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_52712),v_52713);


var G__52715 = cljs.core.next(seq__51798_52705__$1);
var G__52716 = null;
var G__52717 = (0);
var G__52718 = (0);
seq__51798_52689 = G__52715;
chunk__51799_52690 = G__52716;
count__51800_52691 = G__52717;
i__51801_52692 = G__52718;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__51845 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51845,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51845,(1),null);
var seq__51848_52723 = cljs.core.seq(node_children);
var chunk__51850_52724 = null;
var count__51851_52725 = (0);
var i__51852_52726 = (0);
while(true){
if((i__51852_52726 < count__51851_52725)){
var child_struct_52728 = chunk__51850_52724.cljs$core$IIndexed$_nth$arity$2(null,i__51852_52726);
if((!((child_struct_52728 == null)))){
if(typeof child_struct_52728 === 'string'){
var text_52731 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_52731),child_struct_52728].join(''));
} else {
var children_52732 = shadow.dom.svg_node(child_struct_52728);
if(cljs.core.seq_QMARK_(children_52732)){
var seq__51948_52733 = cljs.core.seq(children_52732);
var chunk__51950_52734 = null;
var count__51951_52735 = (0);
var i__51952_52737 = (0);
while(true){
if((i__51952_52737 < count__51951_52735)){
var child_52739 = chunk__51950_52734.cljs$core$IIndexed$_nth$arity$2(null,i__51952_52737);
if(cljs.core.truth_(child_52739)){
node.appendChild(child_52739);


var G__52743 = seq__51948_52733;
var G__52744 = chunk__51950_52734;
var G__52745 = count__51951_52735;
var G__52746 = (i__51952_52737 + (1));
seq__51948_52733 = G__52743;
chunk__51950_52734 = G__52744;
count__51951_52735 = G__52745;
i__51952_52737 = G__52746;
continue;
} else {
var G__52747 = seq__51948_52733;
var G__52748 = chunk__51950_52734;
var G__52749 = count__51951_52735;
var G__52750 = (i__51952_52737 + (1));
seq__51948_52733 = G__52747;
chunk__51950_52734 = G__52748;
count__51951_52735 = G__52749;
i__51952_52737 = G__52750;
continue;
}
} else {
var temp__5753__auto___52752 = cljs.core.seq(seq__51948_52733);
if(temp__5753__auto___52752){
var seq__51948_52753__$1 = temp__5753__auto___52752;
if(cljs.core.chunked_seq_QMARK_(seq__51948_52753__$1)){
var c__4679__auto___52754 = cljs.core.chunk_first(seq__51948_52753__$1);
var G__52758 = cljs.core.chunk_rest(seq__51948_52753__$1);
var G__52759 = c__4679__auto___52754;
var G__52760 = cljs.core.count(c__4679__auto___52754);
var G__52761 = (0);
seq__51948_52733 = G__52758;
chunk__51950_52734 = G__52759;
count__51951_52735 = G__52760;
i__51952_52737 = G__52761;
continue;
} else {
var child_52762 = cljs.core.first(seq__51948_52753__$1);
if(cljs.core.truth_(child_52762)){
node.appendChild(child_52762);


var G__52764 = cljs.core.next(seq__51948_52753__$1);
var G__52765 = null;
var G__52766 = (0);
var G__52767 = (0);
seq__51948_52733 = G__52764;
chunk__51950_52734 = G__52765;
count__51951_52735 = G__52766;
i__51952_52737 = G__52767;
continue;
} else {
var G__52768 = cljs.core.next(seq__51948_52753__$1);
var G__52769 = null;
var G__52770 = (0);
var G__52771 = (0);
seq__51948_52733 = G__52768;
chunk__51950_52734 = G__52769;
count__51951_52735 = G__52770;
i__51952_52737 = G__52771;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_52732);
}
}


var G__52775 = seq__51848_52723;
var G__52776 = chunk__51850_52724;
var G__52777 = count__51851_52725;
var G__52778 = (i__51852_52726 + (1));
seq__51848_52723 = G__52775;
chunk__51850_52724 = G__52776;
count__51851_52725 = G__52777;
i__51852_52726 = G__52778;
continue;
} else {
var G__52779 = seq__51848_52723;
var G__52780 = chunk__51850_52724;
var G__52781 = count__51851_52725;
var G__52782 = (i__51852_52726 + (1));
seq__51848_52723 = G__52779;
chunk__51850_52724 = G__52780;
count__51851_52725 = G__52781;
i__51852_52726 = G__52782;
continue;
}
} else {
var temp__5753__auto___52783 = cljs.core.seq(seq__51848_52723);
if(temp__5753__auto___52783){
var seq__51848_52785__$1 = temp__5753__auto___52783;
if(cljs.core.chunked_seq_QMARK_(seq__51848_52785__$1)){
var c__4679__auto___52786 = cljs.core.chunk_first(seq__51848_52785__$1);
var G__52787 = cljs.core.chunk_rest(seq__51848_52785__$1);
var G__52788 = c__4679__auto___52786;
var G__52789 = cljs.core.count(c__4679__auto___52786);
var G__52790 = (0);
seq__51848_52723 = G__52787;
chunk__51850_52724 = G__52788;
count__51851_52725 = G__52789;
i__51852_52726 = G__52790;
continue;
} else {
var child_struct_52791 = cljs.core.first(seq__51848_52785__$1);
if((!((child_struct_52791 == null)))){
if(typeof child_struct_52791 === 'string'){
var text_52792 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_52792),child_struct_52791].join(''));
} else {
var children_52795 = shadow.dom.svg_node(child_struct_52791);
if(cljs.core.seq_QMARK_(children_52795)){
var seq__51976_52796 = cljs.core.seq(children_52795);
var chunk__51978_52797 = null;
var count__51979_52798 = (0);
var i__51980_52799 = (0);
while(true){
if((i__51980_52799 < count__51979_52798)){
var child_52802 = chunk__51978_52797.cljs$core$IIndexed$_nth$arity$2(null,i__51980_52799);
if(cljs.core.truth_(child_52802)){
node.appendChild(child_52802);


var G__52807 = seq__51976_52796;
var G__52808 = chunk__51978_52797;
var G__52809 = count__51979_52798;
var G__52810 = (i__51980_52799 + (1));
seq__51976_52796 = G__52807;
chunk__51978_52797 = G__52808;
count__51979_52798 = G__52809;
i__51980_52799 = G__52810;
continue;
} else {
var G__52811 = seq__51976_52796;
var G__52812 = chunk__51978_52797;
var G__52813 = count__51979_52798;
var G__52814 = (i__51980_52799 + (1));
seq__51976_52796 = G__52811;
chunk__51978_52797 = G__52812;
count__51979_52798 = G__52813;
i__51980_52799 = G__52814;
continue;
}
} else {
var temp__5753__auto___52815__$1 = cljs.core.seq(seq__51976_52796);
if(temp__5753__auto___52815__$1){
var seq__51976_52819__$1 = temp__5753__auto___52815__$1;
if(cljs.core.chunked_seq_QMARK_(seq__51976_52819__$1)){
var c__4679__auto___52821 = cljs.core.chunk_first(seq__51976_52819__$1);
var G__52822 = cljs.core.chunk_rest(seq__51976_52819__$1);
var G__52823 = c__4679__auto___52821;
var G__52824 = cljs.core.count(c__4679__auto___52821);
var G__52825 = (0);
seq__51976_52796 = G__52822;
chunk__51978_52797 = G__52823;
count__51979_52798 = G__52824;
i__51980_52799 = G__52825;
continue;
} else {
var child_52826 = cljs.core.first(seq__51976_52819__$1);
if(cljs.core.truth_(child_52826)){
node.appendChild(child_52826);


var G__52829 = cljs.core.next(seq__51976_52819__$1);
var G__52830 = null;
var G__52831 = (0);
var G__52832 = (0);
seq__51976_52796 = G__52829;
chunk__51978_52797 = G__52830;
count__51979_52798 = G__52831;
i__51980_52799 = G__52832;
continue;
} else {
var G__52833 = cljs.core.next(seq__51976_52819__$1);
var G__52834 = null;
var G__52835 = (0);
var G__52836 = (0);
seq__51976_52796 = G__52833;
chunk__51978_52797 = G__52834;
count__51979_52798 = G__52835;
i__51980_52799 = G__52836;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_52795);
}
}


var G__52839 = cljs.core.next(seq__51848_52785__$1);
var G__52840 = null;
var G__52841 = (0);
var G__52842 = (0);
seq__51848_52723 = G__52839;
chunk__51850_52724 = G__52840;
count__51851_52725 = G__52841;
i__51852_52726 = G__52842;
continue;
} else {
var G__52843 = cljs.core.next(seq__51848_52785__$1);
var G__52844 = null;
var G__52845 = (0);
var G__52846 = (0);
seq__51848_52723 = G__52843;
chunk__51850_52724 = G__52844;
count__51851_52725 = G__52845;
i__51852_52726 = G__52846;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___52857 = arguments.length;
var i__4865__auto___52858 = (0);
while(true){
if((i__4865__auto___52858 < len__4864__auto___52857)){
args__4870__auto__.push((arguments[i__4865__auto___52858]));

var G__52859 = (i__4865__auto___52858 + (1));
i__4865__auto___52858 = G__52859;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq52016){
var G__52017 = cljs.core.first(seq52016);
var seq52016__$1 = cljs.core.next(seq52016);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52017,seq52016__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__52050 = arguments.length;
switch (G__52050) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4251__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4251__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4251__auto__;
}
})())){
var c__44365__auto___52874 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44367__auto__ = (function (){var switch__44244__auto__ = (function (state_52076){
var state_val_52077 = (state_52076[(1)]);
if((state_val_52077 === (1))){
var state_52076__$1 = state_52076;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52076__$1,(2),once_or_cleanup);
} else {
if((state_val_52077 === (2))){
var inst_52073 = (state_52076[(2)]);
var inst_52074 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_52076__$1 = (function (){var statearr_52085 = state_52076;
(statearr_52085[(7)] = inst_52073);

return statearr_52085;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_52076__$1,inst_52074);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__44245__auto__ = null;
var shadow$dom$state_machine__44245__auto____0 = (function (){
var statearr_52086 = [null,null,null,null,null,null,null,null];
(statearr_52086[(0)] = shadow$dom$state_machine__44245__auto__);

(statearr_52086[(1)] = (1));

return statearr_52086;
});
var shadow$dom$state_machine__44245__auto____1 = (function (state_52076){
while(true){
var ret_value__44246__auto__ = (function (){try{while(true){
var result__44247__auto__ = switch__44244__auto__(state_52076);
if(cljs.core.keyword_identical_QMARK_(result__44247__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44247__auto__;
}
break;
}
}catch (e52088){var ex__44248__auto__ = e52088;
var statearr_52090_52882 = state_52076;
(statearr_52090_52882[(2)] = ex__44248__auto__);


if(cljs.core.seq((state_52076[(4)]))){
var statearr_52091_52883 = state_52076;
(statearr_52091_52883[(1)] = cljs.core.first((state_52076[(4)])));

} else {
throw ex__44248__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44246__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52886 = state_52076;
state_52076 = G__52886;
continue;
} else {
return ret_value__44246__auto__;
}
break;
}
});
shadow$dom$state_machine__44245__auto__ = function(state_52076){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__44245__auto____0.call(this);
case 1:
return shadow$dom$state_machine__44245__auto____1.call(this,state_52076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__44245__auto____0;
shadow$dom$state_machine__44245__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__44245__auto____1;
return shadow$dom$state_machine__44245__auto__;
})()
})();
var state__44368__auto__ = (function (){var statearr_52096 = f__44367__auto__();
(statearr_52096[(6)] = c__44365__auto___52874);

return statearr_52096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44368__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
