goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__44952 = arguments.length;
switch (G__44952) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44956 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44956 = (function (f,blockable,meta44957){
this.f = f;
this.blockable = blockable;
this.meta44957 = meta44957;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44956.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44958,meta44957__$1){
var self__ = this;
var _44958__$1 = this;
return (new cljs.core.async.t_cljs$core$async44956(self__.f,self__.blockable,meta44957__$1));
}));

(cljs.core.async.t_cljs$core$async44956.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44958){
var self__ = this;
var _44958__$1 = this;
return self__.meta44957;
}));

(cljs.core.async.t_cljs$core$async44956.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44956.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44956.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async44956.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async44956.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta44957","meta44957",1527109819,null)], null);
}));

(cljs.core.async.t_cljs$core$async44956.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44956.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44956");

(cljs.core.async.t_cljs$core$async44956.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44956");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44956.
 */
cljs.core.async.__GT_t_cljs$core$async44956 = (function cljs$core$async$__GT_t_cljs$core$async44956(f__$1,blockable__$1,meta44957){
return (new cljs.core.async.t_cljs$core$async44956(f__$1,blockable__$1,meta44957));
});

}

return (new cljs.core.async.t_cljs$core$async44956(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__45020 = arguments.length;
switch (G__45020) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__45054 = arguments.length;
switch (G__45054) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__45093 = arguments.length;
switch (G__45093) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_48212 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48212) : fn1.call(null,val_48212));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_48212) : fn1.call(null,val_48212));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__45117 = arguments.length;
switch (G__45117) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___48243 = n;
var x_48244 = (0);
while(true){
if((x_48244 < n__4741__auto___48243)){
(a[x_48244] = x_48244);

var G__48245 = (x_48244 + (1));
x_48244 = G__48245;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45142 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45142 = (function (flag,meta45143){
this.flag = flag;
this.meta45143 = meta45143;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45142.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45144,meta45143__$1){
var self__ = this;
var _45144__$1 = this;
return (new cljs.core.async.t_cljs$core$async45142(self__.flag,meta45143__$1));
}));

(cljs.core.async.t_cljs$core$async45142.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45144){
var self__ = this;
var _45144__$1 = this;
return self__.meta45143;
}));

(cljs.core.async.t_cljs$core$async45142.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45142.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async45142.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45142.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async45142.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta45143","meta45143",152006408,null)], null);
}));

(cljs.core.async.t_cljs$core$async45142.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45142.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45142");

(cljs.core.async.t_cljs$core$async45142.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async45142");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45142.
 */
cljs.core.async.__GT_t_cljs$core$async45142 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async45142(flag__$1,meta45143){
return (new cljs.core.async.t_cljs$core$async45142(flag__$1,meta45143));
});

}

return (new cljs.core.async.t_cljs$core$async45142(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async45150 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async45150 = (function (flag,cb,meta45151){
this.flag = flag;
this.cb = cb;
this.meta45151 = meta45151;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async45150.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45152,meta45151__$1){
var self__ = this;
var _45152__$1 = this;
return (new cljs.core.async.t_cljs$core$async45150(self__.flag,self__.cb,meta45151__$1));
}));

(cljs.core.async.t_cljs$core$async45150.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45152){
var self__ = this;
var _45152__$1 = this;
return self__.meta45151;
}));

(cljs.core.async.t_cljs$core$async45150.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async45150.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async45150.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async45150.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async45150.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta45151","meta45151",1296753868,null)], null);
}));

(cljs.core.async.t_cljs$core$async45150.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async45150.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async45150");

(cljs.core.async.t_cljs$core$async45150.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async45150");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async45150.
 */
cljs.core.async.__GT_t_cljs$core$async45150 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async45150(flag__$1,cb__$1,meta45151){
return (new cljs.core.async.t_cljs$core$async45150(flag__$1,cb__$1,meta45151));
});

}

return (new cljs.core.async.t_cljs$core$async45150(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45162_SHARP_){
var G__45194 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45162_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__45194) : fret.call(null,G__45194));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__45163_SHARP_){
var G__45195 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__45163_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__45195) : fret.call(null,G__45195));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__48314 = (i + (1));
i = G__48314;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___48326 = arguments.length;
var i__4865__auto___48327 = (0);
while(true){
if((i__4865__auto___48327 < len__4864__auto___48326)){
args__4870__auto__.push((arguments[i__4865__auto___48327]));

var G__48329 = (i__4865__auto___48327 + (1));
i__4865__auto___48327 = G__48329;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__45206){
var map__45207 = p__45206;
var map__45207__$1 = cljs.core.__destructure_map(map__45207);
var opts = map__45207__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq45204){
var G__45205 = cljs.core.first(seq45204);
var seq45204__$1 = cljs.core.next(seq45204);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__45205,seq45204__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__45215 = arguments.length;
switch (G__45215) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__44855__auto___48352 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_45256){
var state_val_45257 = (state_45256[(1)]);
if((state_val_45257 === (7))){
var inst_45251 = (state_45256[(2)]);
var state_45256__$1 = state_45256;
var statearr_45269_48355 = state_45256__$1;
(statearr_45269_48355[(2)] = inst_45251);

(statearr_45269_48355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (1))){
var state_45256__$1 = state_45256;
var statearr_45270_48360 = state_45256__$1;
(statearr_45270_48360[(2)] = null);

(statearr_45270_48360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (4))){
var inst_45231 = (state_45256[(7)]);
var inst_45231__$1 = (state_45256[(2)]);
var inst_45232 = (inst_45231__$1 == null);
var state_45256__$1 = (function (){var statearr_45273 = state_45256;
(statearr_45273[(7)] = inst_45231__$1);

return statearr_45273;
})();
if(cljs.core.truth_(inst_45232)){
var statearr_45274_48366 = state_45256__$1;
(statearr_45274_48366[(1)] = (5));

} else {
var statearr_45275_48369 = state_45256__$1;
(statearr_45275_48369[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (13))){
var state_45256__$1 = state_45256;
var statearr_45284_48370 = state_45256__$1;
(statearr_45284_48370[(2)] = null);

(statearr_45284_48370[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (6))){
var inst_45231 = (state_45256[(7)]);
var state_45256__$1 = state_45256;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45256__$1,(11),to,inst_45231);
} else {
if((state_val_45257 === (3))){
var inst_45254 = (state_45256[(2)]);
var state_45256__$1 = state_45256;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45256__$1,inst_45254);
} else {
if((state_val_45257 === (12))){
var state_45256__$1 = state_45256;
var statearr_45285_48371 = state_45256__$1;
(statearr_45285_48371[(2)] = null);

(statearr_45285_48371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (2))){
var state_45256__$1 = state_45256;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45256__$1,(4),from);
} else {
if((state_val_45257 === (11))){
var inst_45244 = (state_45256[(2)]);
var state_45256__$1 = state_45256;
if(cljs.core.truth_(inst_45244)){
var statearr_45286_48372 = state_45256__$1;
(statearr_45286_48372[(1)] = (12));

} else {
var statearr_45287_48373 = state_45256__$1;
(statearr_45287_48373[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (9))){
var state_45256__$1 = state_45256;
var statearr_45288_48374 = state_45256__$1;
(statearr_45288_48374[(2)] = null);

(statearr_45288_48374[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (5))){
var state_45256__$1 = state_45256;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45289_48375 = state_45256__$1;
(statearr_45289_48375[(1)] = (8));

} else {
var statearr_45290_48376 = state_45256__$1;
(statearr_45290_48376[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (14))){
var inst_45249 = (state_45256[(2)]);
var state_45256__$1 = state_45256;
var statearr_45291_48377 = state_45256__$1;
(statearr_45291_48377[(2)] = inst_45249);

(statearr_45291_48377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (10))){
var inst_45241 = (state_45256[(2)]);
var state_45256__$1 = state_45256;
var statearr_45292_48380 = state_45256__$1;
(statearr_45292_48380[(2)] = inst_45241);

(statearr_45292_48380[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45257 === (8))){
var inst_45238 = cljs.core.async.close_BANG_(to);
var state_45256__$1 = state_45256;
var statearr_45293_48381 = state_45256__$1;
(statearr_45293_48381[(2)] = inst_45238);

(statearr_45293_48381[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_45296 = [null,null,null,null,null,null,null,null];
(statearr_45296[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_45296[(1)] = (1));

return statearr_45296;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_45256){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45256);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45297){var ex__44696__auto__ = e45297;
var statearr_45298_48384 = state_45256;
(statearr_45298_48384[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45256[(4)]))){
var statearr_45299_48387 = state_45256;
(statearr_45299_48387[(1)] = cljs.core.first((state_45256[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48391 = state_45256;
state_45256 = G__48391;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_45256){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_45256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_45302 = f__44856__auto__();
(statearr_45302[(6)] = c__44855__auto___48352);

return statearr_45302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__45345){
var vec__45346 = p__45345;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45346,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45346,(1),null);
var job = vec__45346;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__44855__auto___48404 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_45379){
var state_val_45380 = (state_45379[(1)]);
if((state_val_45380 === (1))){
var state_45379__$1 = state_45379;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45379__$1,(2),res,v);
} else {
if((state_val_45380 === (2))){
var inst_45372 = (state_45379[(2)]);
var inst_45377 = cljs.core.async.close_BANG_(res);
var state_45379__$1 = (function (){var statearr_45388 = state_45379;
(statearr_45388[(7)] = inst_45372);

return statearr_45388;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45379__$1,inst_45377);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0 = (function (){
var statearr_45393 = [null,null,null,null,null,null,null,null];
(statearr_45393[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__);

(statearr_45393[(1)] = (1));

return statearr_45393;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1 = (function (state_45379){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45379);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45396){var ex__44696__auto__ = e45396;
var statearr_45397_48425 = state_45379;
(statearr_45397_48425[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45379[(4)]))){
var statearr_45398_48426 = state_45379;
(statearr_45398_48426[(1)] = cljs.core.first((state_45379[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48427 = state_45379;
state_45379 = G__48427;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = function(state_45379){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1.call(this,state_45379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_45399 = f__44856__auto__();
(statearr_45399[(6)] = c__44855__auto___48404);

return statearr_45399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__45402){
var vec__45404 = p__45402;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45404,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45404,(1),null);
var job = vec__45404;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___48432 = n;
var __48435 = (0);
while(true){
if((__48435 < n__4741__auto___48432)){
var G__45407_48437 = type;
var G__45407_48438__$1 = (((G__45407_48437 instanceof cljs.core.Keyword))?G__45407_48437.fqn:null);
switch (G__45407_48438__$1) {
case "compute":
var c__44855__auto___48442 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48435,c__44855__auto___48442,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async){
return (function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = ((function (__48435,c__44855__auto___48442,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async){
return (function (state_45421){
var state_val_45422 = (state_45421[(1)]);
if((state_val_45422 === (1))){
var state_45421__$1 = state_45421;
var statearr_45425_48445 = state_45421__$1;
(statearr_45425_48445[(2)] = null);

(statearr_45425_48445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45422 === (2))){
var state_45421__$1 = state_45421;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45421__$1,(4),jobs);
} else {
if((state_val_45422 === (3))){
var inst_45418 = (state_45421[(2)]);
var state_45421__$1 = state_45421;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45421__$1,inst_45418);
} else {
if((state_val_45422 === (4))){
var inst_45410 = (state_45421[(2)]);
var inst_45411 = process(inst_45410);
var state_45421__$1 = state_45421;
if(cljs.core.truth_(inst_45411)){
var statearr_45430_48449 = state_45421__$1;
(statearr_45430_48449[(1)] = (5));

} else {
var statearr_45431_48451 = state_45421__$1;
(statearr_45431_48451[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45422 === (5))){
var state_45421__$1 = state_45421;
var statearr_45432_48455 = state_45421__$1;
(statearr_45432_48455[(2)] = null);

(statearr_45432_48455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45422 === (6))){
var state_45421__$1 = state_45421;
var statearr_45437_48458 = state_45421__$1;
(statearr_45437_48458[(2)] = null);

(statearr_45437_48458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45422 === (7))){
var inst_45416 = (state_45421[(2)]);
var state_45421__$1 = state_45421;
var statearr_45441_48462 = state_45421__$1;
(statearr_45441_48462[(2)] = inst_45416);

(statearr_45441_48462[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48435,c__44855__auto___48442,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async))
;
return ((function (__48435,switch__44692__auto__,c__44855__auto___48442,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0 = (function (){
var statearr_45449 = [null,null,null,null,null,null,null];
(statearr_45449[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__);

(statearr_45449[(1)] = (1));

return statearr_45449;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1 = (function (state_45421){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45421);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45450){var ex__44696__auto__ = e45450;
var statearr_45451_48468 = state_45421;
(statearr_45451_48468[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45421[(4)]))){
var statearr_45452_48469 = state_45421;
(statearr_45452_48469[(1)] = cljs.core.first((state_45421[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48472 = state_45421;
state_45421 = G__48472;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = function(state_45421){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1.call(this,state_45421);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__;
})()
;})(__48435,switch__44692__auto__,c__44855__auto___48442,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async))
})();
var state__44857__auto__ = (function (){var statearr_45454 = f__44856__auto__();
(statearr_45454[(6)] = c__44855__auto___48442);

return statearr_45454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
});})(__48435,c__44855__auto___48442,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async))
);


break;
case "async":
var c__44855__auto___48481 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48435,c__44855__auto___48481,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async){
return (function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = ((function (__48435,c__44855__auto___48481,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async){
return (function (state_45471){
var state_val_45472 = (state_45471[(1)]);
if((state_val_45472 === (1))){
var state_45471__$1 = state_45471;
var statearr_45484_48495 = state_45471__$1;
(statearr_45484_48495[(2)] = null);

(statearr_45484_48495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45472 === (2))){
var state_45471__$1 = state_45471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45471__$1,(4),jobs);
} else {
if((state_val_45472 === (3))){
var inst_45468 = (state_45471[(2)]);
var state_45471__$1 = state_45471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45471__$1,inst_45468);
} else {
if((state_val_45472 === (4))){
var inst_45458 = (state_45471[(2)]);
var inst_45459 = async(inst_45458);
var state_45471__$1 = state_45471;
if(cljs.core.truth_(inst_45459)){
var statearr_45491_48502 = state_45471__$1;
(statearr_45491_48502[(1)] = (5));

} else {
var statearr_45494_48503 = state_45471__$1;
(statearr_45494_48503[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45472 === (5))){
var state_45471__$1 = state_45471;
var statearr_45495_48504 = state_45471__$1;
(statearr_45495_48504[(2)] = null);

(statearr_45495_48504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45472 === (6))){
var state_45471__$1 = state_45471;
var statearr_45496_48505 = state_45471__$1;
(statearr_45496_48505[(2)] = null);

(statearr_45496_48505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45472 === (7))){
var inst_45466 = (state_45471[(2)]);
var state_45471__$1 = state_45471;
var statearr_45497_48509 = state_45471__$1;
(statearr_45497_48509[(2)] = inst_45466);

(statearr_45497_48509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48435,c__44855__auto___48481,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async))
;
return ((function (__48435,switch__44692__auto__,c__44855__auto___48481,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0 = (function (){
var statearr_45502 = [null,null,null,null,null,null,null];
(statearr_45502[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__);

(statearr_45502[(1)] = (1));

return statearr_45502;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1 = (function (state_45471){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45471);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45503){var ex__44696__auto__ = e45503;
var statearr_45504_48521 = state_45471;
(statearr_45504_48521[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45471[(4)]))){
var statearr_45505_48524 = state_45471;
(statearr_45505_48524[(1)] = cljs.core.first((state_45471[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48529 = state_45471;
state_45471 = G__48529;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = function(state_45471){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1.call(this,state_45471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__;
})()
;})(__48435,switch__44692__auto__,c__44855__auto___48481,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async))
})();
var state__44857__auto__ = (function (){var statearr_45506 = f__44856__auto__();
(statearr_45506[(6)] = c__44855__auto___48481);

return statearr_45506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
});})(__48435,c__44855__auto___48481,G__45407_48437,G__45407_48438__$1,n__4741__auto___48432,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__45407_48438__$1)].join('')));

}

var G__48536 = (__48435 + (1));
__48435 = G__48536;
continue;
} else {
}
break;
}

var c__44855__auto___48537 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_45541){
var state_val_45542 = (state_45541[(1)]);
if((state_val_45542 === (7))){
var inst_45537 = (state_45541[(2)]);
var state_45541__$1 = state_45541;
var statearr_45546_48543 = state_45541__$1;
(statearr_45546_48543[(2)] = inst_45537);

(statearr_45546_48543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45542 === (1))){
var state_45541__$1 = state_45541;
var statearr_45547_48549 = state_45541__$1;
(statearr_45547_48549[(2)] = null);

(statearr_45547_48549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45542 === (4))){
var inst_45520 = (state_45541[(7)]);
var inst_45520__$1 = (state_45541[(2)]);
var inst_45521 = (inst_45520__$1 == null);
var state_45541__$1 = (function (){var statearr_45552 = state_45541;
(statearr_45552[(7)] = inst_45520__$1);

return statearr_45552;
})();
if(cljs.core.truth_(inst_45521)){
var statearr_45553_48558 = state_45541__$1;
(statearr_45553_48558[(1)] = (5));

} else {
var statearr_45554_48561 = state_45541__$1;
(statearr_45554_48561[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45542 === (6))){
var inst_45527 = (state_45541[(8)]);
var inst_45520 = (state_45541[(7)]);
var inst_45527__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_45528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45529 = [inst_45520,inst_45527__$1];
var inst_45530 = (new cljs.core.PersistentVector(null,2,(5),inst_45528,inst_45529,null));
var state_45541__$1 = (function (){var statearr_45559 = state_45541;
(statearr_45559[(8)] = inst_45527__$1);

return statearr_45559;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45541__$1,(8),jobs,inst_45530);
} else {
if((state_val_45542 === (3))){
var inst_45539 = (state_45541[(2)]);
var state_45541__$1 = state_45541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45541__$1,inst_45539);
} else {
if((state_val_45542 === (2))){
var state_45541__$1 = state_45541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45541__$1,(4),from);
} else {
if((state_val_45542 === (9))){
var inst_45534 = (state_45541[(2)]);
var state_45541__$1 = (function (){var statearr_45563 = state_45541;
(statearr_45563[(9)] = inst_45534);

return statearr_45563;
})();
var statearr_45564_48576 = state_45541__$1;
(statearr_45564_48576[(2)] = null);

(statearr_45564_48576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45542 === (5))){
var inst_45523 = cljs.core.async.close_BANG_(jobs);
var state_45541__$1 = state_45541;
var statearr_45566_48581 = state_45541__$1;
(statearr_45566_48581[(2)] = inst_45523);

(statearr_45566_48581[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45542 === (8))){
var inst_45527 = (state_45541[(8)]);
var inst_45532 = (state_45541[(2)]);
var state_45541__$1 = (function (){var statearr_45570 = state_45541;
(statearr_45570[(10)] = inst_45532);

return statearr_45570;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45541__$1,(9),results,inst_45527);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0 = (function (){
var statearr_45571 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45571[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__);

(statearr_45571[(1)] = (1));

return statearr_45571;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1 = (function (state_45541){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45541);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45573){var ex__44696__auto__ = e45573;
var statearr_45574_48594 = state_45541;
(statearr_45574_48594[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45541[(4)]))){
var statearr_45575_48598 = state_45541;
(statearr_45575_48598[(1)] = cljs.core.first((state_45541[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48601 = state_45541;
state_45541 = G__48601;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = function(state_45541){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1.call(this,state_45541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_45576 = f__44856__auto__();
(statearr_45576[(6)] = c__44855__auto___48537);

return statearr_45576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


var c__44855__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_45617){
var state_val_45618 = (state_45617[(1)]);
if((state_val_45618 === (7))){
var inst_45612 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
var statearr_45620_48611 = state_45617__$1;
(statearr_45620_48611[(2)] = inst_45612);

(statearr_45620_48611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (20))){
var state_45617__$1 = state_45617;
var statearr_45621_48616 = state_45617__$1;
(statearr_45621_48616[(2)] = null);

(statearr_45621_48616[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (1))){
var state_45617__$1 = state_45617;
var statearr_45623_48621 = state_45617__$1;
(statearr_45623_48621[(2)] = null);

(statearr_45623_48621[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (4))){
var inst_45579 = (state_45617[(7)]);
var inst_45579__$1 = (state_45617[(2)]);
var inst_45580 = (inst_45579__$1 == null);
var state_45617__$1 = (function (){var statearr_45624 = state_45617;
(statearr_45624[(7)] = inst_45579__$1);

return statearr_45624;
})();
if(cljs.core.truth_(inst_45580)){
var statearr_45625_48628 = state_45617__$1;
(statearr_45625_48628[(1)] = (5));

} else {
var statearr_45626_48632 = state_45617__$1;
(statearr_45626_48632[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (15))){
var inst_45594 = (state_45617[(8)]);
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45617__$1,(18),to,inst_45594);
} else {
if((state_val_45618 === (21))){
var inst_45607 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
var statearr_45631_48636 = state_45617__$1;
(statearr_45631_48636[(2)] = inst_45607);

(statearr_45631_48636[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (13))){
var inst_45609 = (state_45617[(2)]);
var state_45617__$1 = (function (){var statearr_45632 = state_45617;
(statearr_45632[(9)] = inst_45609);

return statearr_45632;
})();
var statearr_45633_48638 = state_45617__$1;
(statearr_45633_48638[(2)] = null);

(statearr_45633_48638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (6))){
var inst_45579 = (state_45617[(7)]);
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45617__$1,(11),inst_45579);
} else {
if((state_val_45618 === (17))){
var inst_45602 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
if(cljs.core.truth_(inst_45602)){
var statearr_45635_48644 = state_45617__$1;
(statearr_45635_48644[(1)] = (19));

} else {
var statearr_45636_48646 = state_45617__$1;
(statearr_45636_48646[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (3))){
var inst_45614 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45617__$1,inst_45614);
} else {
if((state_val_45618 === (12))){
var inst_45591 = (state_45617[(10)]);
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45617__$1,(14),inst_45591);
} else {
if((state_val_45618 === (2))){
var state_45617__$1 = state_45617;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45617__$1,(4),results);
} else {
if((state_val_45618 === (19))){
var state_45617__$1 = state_45617;
var statearr_45639_48654 = state_45617__$1;
(statearr_45639_48654[(2)] = null);

(statearr_45639_48654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (11))){
var inst_45591 = (state_45617[(2)]);
var state_45617__$1 = (function (){var statearr_45641 = state_45617;
(statearr_45641[(10)] = inst_45591);

return statearr_45641;
})();
var statearr_45642_48655 = state_45617__$1;
(statearr_45642_48655[(2)] = null);

(statearr_45642_48655[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (9))){
var state_45617__$1 = state_45617;
var statearr_45644_48656 = state_45617__$1;
(statearr_45644_48656[(2)] = null);

(statearr_45644_48656[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (5))){
var state_45617__$1 = state_45617;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45645_48657 = state_45617__$1;
(statearr_45645_48657[(1)] = (8));

} else {
var statearr_45646_48658 = state_45617__$1;
(statearr_45646_48658[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (14))){
var inst_45596 = (state_45617[(11)]);
var inst_45594 = (state_45617[(8)]);
var inst_45594__$1 = (state_45617[(2)]);
var inst_45595 = (inst_45594__$1 == null);
var inst_45596__$1 = cljs.core.not(inst_45595);
var state_45617__$1 = (function (){var statearr_45647 = state_45617;
(statearr_45647[(11)] = inst_45596__$1);

(statearr_45647[(8)] = inst_45594__$1);

return statearr_45647;
})();
if(inst_45596__$1){
var statearr_45648_48662 = state_45617__$1;
(statearr_45648_48662[(1)] = (15));

} else {
var statearr_45649_48663 = state_45617__$1;
(statearr_45649_48663[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (16))){
var inst_45596 = (state_45617[(11)]);
var state_45617__$1 = state_45617;
var statearr_45650_48668 = state_45617__$1;
(statearr_45650_48668[(2)] = inst_45596);

(statearr_45650_48668[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (10))){
var inst_45587 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
var statearr_45653_48672 = state_45617__$1;
(statearr_45653_48672[(2)] = inst_45587);

(statearr_45653_48672[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (18))){
var inst_45599 = (state_45617[(2)]);
var state_45617__$1 = state_45617;
var statearr_45655_48676 = state_45617__$1;
(statearr_45655_48676[(2)] = inst_45599);

(statearr_45655_48676[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45618 === (8))){
var inst_45584 = cljs.core.async.close_BANG_(to);
var state_45617__$1 = state_45617;
var statearr_45660_48677 = state_45617__$1;
(statearr_45660_48677[(2)] = inst_45584);

(statearr_45660_48677[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0 = (function (){
var statearr_45665 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45665[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__);

(statearr_45665[(1)] = (1));

return statearr_45665;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1 = (function (state_45617){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45617);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45666){var ex__44696__auto__ = e45666;
var statearr_45667_48680 = state_45617;
(statearr_45667_48680[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45617[(4)]))){
var statearr_45671_48685 = state_45617;
(statearr_45671_48685[(1)] = cljs.core.first((state_45617[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48689 = state_45617;
state_45617 = G__48689;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__ = function(state_45617){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1.call(this,state_45617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44693__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_45675 = f__44856__auto__();
(statearr_45675[(6)] = c__44855__auto__);

return statearr_45675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));

return c__44855__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__45683 = arguments.length;
switch (G__45683) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__45686 = arguments.length;
switch (G__45686) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__45708 = arguments.length;
switch (G__45708) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__44855__auto___48721 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_45748){
var state_val_45749 = (state_45748[(1)]);
if((state_val_45749 === (7))){
var inst_45744 = (state_45748[(2)]);
var state_45748__$1 = state_45748;
var statearr_45757_48724 = state_45748__$1;
(statearr_45757_48724[(2)] = inst_45744);

(statearr_45757_48724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (1))){
var state_45748__$1 = state_45748;
var statearr_45758_48726 = state_45748__$1;
(statearr_45758_48726[(2)] = null);

(statearr_45758_48726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (4))){
var inst_45719 = (state_45748[(7)]);
var inst_45719__$1 = (state_45748[(2)]);
var inst_45720 = (inst_45719__$1 == null);
var state_45748__$1 = (function (){var statearr_45764 = state_45748;
(statearr_45764[(7)] = inst_45719__$1);

return statearr_45764;
})();
if(cljs.core.truth_(inst_45720)){
var statearr_45768_48728 = state_45748__$1;
(statearr_45768_48728[(1)] = (5));

} else {
var statearr_45769_48729 = state_45748__$1;
(statearr_45769_48729[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (13))){
var state_45748__$1 = state_45748;
var statearr_45770_48730 = state_45748__$1;
(statearr_45770_48730[(2)] = null);

(statearr_45770_48730[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (6))){
var inst_45719 = (state_45748[(7)]);
var inst_45727 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45719) : p.call(null,inst_45719));
var state_45748__$1 = state_45748;
if(cljs.core.truth_(inst_45727)){
var statearr_45774_48731 = state_45748__$1;
(statearr_45774_48731[(1)] = (9));

} else {
var statearr_45775_48732 = state_45748__$1;
(statearr_45775_48732[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (3))){
var inst_45746 = (state_45748[(2)]);
var state_45748__$1 = state_45748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45748__$1,inst_45746);
} else {
if((state_val_45749 === (12))){
var state_45748__$1 = state_45748;
var statearr_45776_48733 = state_45748__$1;
(statearr_45776_48733[(2)] = null);

(statearr_45776_48733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (2))){
var state_45748__$1 = state_45748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45748__$1,(4),ch);
} else {
if((state_val_45749 === (11))){
var inst_45719 = (state_45748[(7)]);
var inst_45735 = (state_45748[(2)]);
var state_45748__$1 = state_45748;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45748__$1,(8),inst_45735,inst_45719);
} else {
if((state_val_45749 === (9))){
var state_45748__$1 = state_45748;
var statearr_45777_48735 = state_45748__$1;
(statearr_45777_48735[(2)] = tc);

(statearr_45777_48735[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (5))){
var inst_45724 = cljs.core.async.close_BANG_(tc);
var inst_45725 = cljs.core.async.close_BANG_(fc);
var state_45748__$1 = (function (){var statearr_45782 = state_45748;
(statearr_45782[(8)] = inst_45724);

return statearr_45782;
})();
var statearr_45784_48738 = state_45748__$1;
(statearr_45784_48738[(2)] = inst_45725);

(statearr_45784_48738[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (14))){
var inst_45742 = (state_45748[(2)]);
var state_45748__$1 = state_45748;
var statearr_45788_48740 = state_45748__$1;
(statearr_45788_48740[(2)] = inst_45742);

(statearr_45788_48740[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (10))){
var state_45748__$1 = state_45748;
var statearr_45793_48741 = state_45748__$1;
(statearr_45793_48741[(2)] = fc);

(statearr_45793_48741[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45749 === (8))){
var inst_45737 = (state_45748[(2)]);
var state_45748__$1 = state_45748;
if(cljs.core.truth_(inst_45737)){
var statearr_45801_48742 = state_45748__$1;
(statearr_45801_48742[(1)] = (12));

} else {
var statearr_45802_48743 = state_45748__$1;
(statearr_45802_48743[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_45807 = [null,null,null,null,null,null,null,null,null];
(statearr_45807[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_45807[(1)] = (1));

return statearr_45807;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_45748){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45748);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45810){var ex__44696__auto__ = e45810;
var statearr_45812_48746 = state_45748;
(statearr_45812_48746[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45748[(4)]))){
var statearr_45813_48747 = state_45748;
(statearr_45813_48747[(1)] = cljs.core.first((state_45748[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48750 = state_45748;
state_45748 = G__48750;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_45748){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_45748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_45816 = f__44856__auto__();
(statearr_45816[(6)] = c__44855__auto___48721);

return statearr_45816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__44855__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_45851){
var state_val_45854 = (state_45851[(1)]);
if((state_val_45854 === (7))){
var inst_45842 = (state_45851[(2)]);
var state_45851__$1 = state_45851;
var statearr_45858_48753 = state_45851__$1;
(statearr_45858_48753[(2)] = inst_45842);

(statearr_45858_48753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45854 === (1))){
var inst_45821 = init;
var inst_45823 = inst_45821;
var state_45851__$1 = (function (){var statearr_45862 = state_45851;
(statearr_45862[(7)] = inst_45823);

return statearr_45862;
})();
var statearr_45870_48755 = state_45851__$1;
(statearr_45870_48755[(2)] = null);

(statearr_45870_48755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45854 === (4))){
var inst_45827 = (state_45851[(8)]);
var inst_45827__$1 = (state_45851[(2)]);
var inst_45829 = (inst_45827__$1 == null);
var state_45851__$1 = (function (){var statearr_45872 = state_45851;
(statearr_45872[(8)] = inst_45827__$1);

return statearr_45872;
})();
if(cljs.core.truth_(inst_45829)){
var statearr_45874_48756 = state_45851__$1;
(statearr_45874_48756[(1)] = (5));

} else {
var statearr_45876_48757 = state_45851__$1;
(statearr_45876_48757[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45854 === (6))){
var inst_45827 = (state_45851[(8)]);
var inst_45823 = (state_45851[(7)]);
var inst_45832 = (state_45851[(9)]);
var inst_45832__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_45823,inst_45827) : f.call(null,inst_45823,inst_45827));
var inst_45833 = cljs.core.reduced_QMARK_(inst_45832__$1);
var state_45851__$1 = (function (){var statearr_45882 = state_45851;
(statearr_45882[(9)] = inst_45832__$1);

return statearr_45882;
})();
if(inst_45833){
var statearr_45883_48759 = state_45851__$1;
(statearr_45883_48759[(1)] = (8));

} else {
var statearr_45884_48760 = state_45851__$1;
(statearr_45884_48760[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45854 === (3))){
var inst_45844 = (state_45851[(2)]);
var state_45851__$1 = state_45851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45851__$1,inst_45844);
} else {
if((state_val_45854 === (2))){
var state_45851__$1 = state_45851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45851__$1,(4),ch);
} else {
if((state_val_45854 === (9))){
var inst_45832 = (state_45851[(9)]);
var inst_45823 = inst_45832;
var state_45851__$1 = (function (){var statearr_45895 = state_45851;
(statearr_45895[(7)] = inst_45823);

return statearr_45895;
})();
var statearr_45896_48761 = state_45851__$1;
(statearr_45896_48761[(2)] = null);

(statearr_45896_48761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45854 === (5))){
var inst_45823 = (state_45851[(7)]);
var state_45851__$1 = state_45851;
var statearr_45899_48764 = state_45851__$1;
(statearr_45899_48764[(2)] = inst_45823);

(statearr_45899_48764[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45854 === (10))){
var inst_45840 = (state_45851[(2)]);
var state_45851__$1 = state_45851;
var statearr_45911_48766 = state_45851__$1;
(statearr_45911_48766[(2)] = inst_45840);

(statearr_45911_48766[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45854 === (8))){
var inst_45832 = (state_45851[(9)]);
var inst_45835 = cljs.core.deref(inst_45832);
var state_45851__$1 = state_45851;
var statearr_45915_48767 = state_45851__$1;
(statearr_45915_48767[(2)] = inst_45835);

(statearr_45915_48767[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__44693__auto__ = null;
var cljs$core$async$reduce_$_state_machine__44693__auto____0 = (function (){
var statearr_45922 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45922[(0)] = cljs$core$async$reduce_$_state_machine__44693__auto__);

(statearr_45922[(1)] = (1));

return statearr_45922;
});
var cljs$core$async$reduce_$_state_machine__44693__auto____1 = (function (state_45851){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45851);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45929){var ex__44696__auto__ = e45929;
var statearr_45931_48769 = state_45851;
(statearr_45931_48769[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45851[(4)]))){
var statearr_45938_48770 = state_45851;
(statearr_45938_48770[(1)] = cljs.core.first((state_45851[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48772 = state_45851;
state_45851 = G__48772;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__44693__auto__ = function(state_45851){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__44693__auto____1.call(this,state_45851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__44693__auto____0;
cljs$core$async$reduce_$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__44693__auto____1;
return cljs$core$async$reduce_$_state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_45954 = f__44856__auto__();
(statearr_45954[(6)] = c__44855__auto__);

return statearr_45954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));

return c__44855__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__44855__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_45969){
var state_val_45970 = (state_45969[(1)]);
if((state_val_45970 === (1))){
var inst_45960 = cljs.core.async.reduce(f__$1,init,ch);
var state_45969__$1 = state_45969;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45969__$1,(2),inst_45960);
} else {
if((state_val_45970 === (2))){
var inst_45962 = (state_45969[(2)]);
var inst_45964 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_45962) : f__$1.call(null,inst_45962));
var state_45969__$1 = state_45969;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45969__$1,inst_45964);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__44693__auto__ = null;
var cljs$core$async$transduce_$_state_machine__44693__auto____0 = (function (){
var statearr_45982 = [null,null,null,null,null,null,null];
(statearr_45982[(0)] = cljs$core$async$transduce_$_state_machine__44693__auto__);

(statearr_45982[(1)] = (1));

return statearr_45982;
});
var cljs$core$async$transduce_$_state_machine__44693__auto____1 = (function (state_45969){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_45969);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e45991){var ex__44696__auto__ = e45991;
var statearr_45992_48792 = state_45969;
(statearr_45992_48792[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_45969[(4)]))){
var statearr_45995_48793 = state_45969;
(statearr_45995_48793[(1)] = cljs.core.first((state_45969[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48796 = state_45969;
state_45969 = G__48796;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__44693__auto__ = function(state_45969){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__44693__auto____1.call(this,state_45969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__44693__auto____0;
cljs$core$async$transduce_$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__44693__auto____1;
return cljs$core$async$transduce_$_state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_46002 = f__44856__auto__();
(statearr_46002[(6)] = c__44855__auto__);

return statearr_46002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));

return c__44855__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__46013 = arguments.length;
switch (G__46013) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__44855__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_46098){
var state_val_46100 = (state_46098[(1)]);
if((state_val_46100 === (7))){
var inst_46065 = (state_46098[(2)]);
var state_46098__$1 = state_46098;
var statearr_46116_48811 = state_46098__$1;
(statearr_46116_48811[(2)] = inst_46065);

(statearr_46116_48811[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (1))){
var inst_46045 = cljs.core.seq(coll);
var inst_46047 = inst_46045;
var state_46098__$1 = (function (){var statearr_46127 = state_46098;
(statearr_46127[(7)] = inst_46047);

return statearr_46127;
})();
var statearr_46129_48814 = state_46098__$1;
(statearr_46129_48814[(2)] = null);

(statearr_46129_48814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (4))){
var inst_46047 = (state_46098[(7)]);
var inst_46063 = cljs.core.first(inst_46047);
var state_46098__$1 = state_46098;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46098__$1,(7),ch,inst_46063);
} else {
if((state_val_46100 === (13))){
var inst_46083 = (state_46098[(2)]);
var state_46098__$1 = state_46098;
var statearr_46155_48820 = state_46098__$1;
(statearr_46155_48820[(2)] = inst_46083);

(statearr_46155_48820[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (6))){
var inst_46068 = (state_46098[(2)]);
var state_46098__$1 = state_46098;
if(cljs.core.truth_(inst_46068)){
var statearr_46165_48821 = state_46098__$1;
(statearr_46165_48821[(1)] = (8));

} else {
var statearr_46166_48822 = state_46098__$1;
(statearr_46166_48822[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (3))){
var inst_46087 = (state_46098[(2)]);
var state_46098__$1 = state_46098;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46098__$1,inst_46087);
} else {
if((state_val_46100 === (12))){
var state_46098__$1 = state_46098;
var statearr_46169_48823 = state_46098__$1;
(statearr_46169_48823[(2)] = null);

(statearr_46169_48823[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (2))){
var inst_46047 = (state_46098[(7)]);
var state_46098__$1 = state_46098;
if(cljs.core.truth_(inst_46047)){
var statearr_46170_48826 = state_46098__$1;
(statearr_46170_48826[(1)] = (4));

} else {
var statearr_46175_48827 = state_46098__$1;
(statearr_46175_48827[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (11))){
var inst_46080 = cljs.core.async.close_BANG_(ch);
var state_46098__$1 = state_46098;
var statearr_46176_48829 = state_46098__$1;
(statearr_46176_48829[(2)] = inst_46080);

(statearr_46176_48829[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (9))){
var state_46098__$1 = state_46098;
if(cljs.core.truth_(close_QMARK_)){
var statearr_46179_48831 = state_46098__$1;
(statearr_46179_48831[(1)] = (11));

} else {
var statearr_46181_48832 = state_46098__$1;
(statearr_46181_48832[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (5))){
var inst_46047 = (state_46098[(7)]);
var state_46098__$1 = state_46098;
var statearr_46185_48833 = state_46098__$1;
(statearr_46185_48833[(2)] = inst_46047);

(statearr_46185_48833[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (10))){
var inst_46085 = (state_46098[(2)]);
var state_46098__$1 = state_46098;
var statearr_46196_48834 = state_46098__$1;
(statearr_46196_48834[(2)] = inst_46085);

(statearr_46196_48834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46100 === (8))){
var inst_46047 = (state_46098[(7)]);
var inst_46070 = cljs.core.next(inst_46047);
var inst_46047__$1 = inst_46070;
var state_46098__$1 = (function (){var statearr_46204 = state_46098;
(statearr_46204[(7)] = inst_46047__$1);

return statearr_46204;
})();
var statearr_46207_48835 = state_46098__$1;
(statearr_46207_48835[(2)] = null);

(statearr_46207_48835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_46209 = [null,null,null,null,null,null,null,null];
(statearr_46209[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_46209[(1)] = (1));

return statearr_46209;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_46098){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_46098);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e46210){var ex__44696__auto__ = e46210;
var statearr_46211_48837 = state_46098;
(statearr_46211_48837[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_46098[(4)]))){
var statearr_46214_48838 = state_46098;
(statearr_46214_48838[(1)] = cljs.core.first((state_46098[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48839 = state_46098;
state_46098 = G__48839;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_46098){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_46098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_46220 = f__44856__auto__();
(statearr_46220[(6)] = c__44855__auto__);

return statearr_46220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));

return c__44855__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__46233 = arguments.length;
switch (G__46233) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_48847 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_48847(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_48851 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_48851(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_48862 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_48862(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_48864 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_48864(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46313 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46313 = (function (ch,cs,meta46314){
this.ch = ch;
this.cs = cs;
this.meta46314 = meta46314;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46313.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46315,meta46314__$1){
var self__ = this;
var _46315__$1 = this;
return (new cljs.core.async.t_cljs$core$async46313(self__.ch,self__.cs,meta46314__$1));
}));

(cljs.core.async.t_cljs$core$async46313.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46315){
var self__ = this;
var _46315__$1 = this;
return self__.meta46314;
}));

(cljs.core.async.t_cljs$core$async46313.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46313.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46313.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46313.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async46313.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async46313.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async46313.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta46314","meta46314",1305468669,null)], null);
}));

(cljs.core.async.t_cljs$core$async46313.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46313.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46313");

(cljs.core.async.t_cljs$core$async46313.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46313");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46313.
 */
cljs.core.async.__GT_t_cljs$core$async46313 = (function cljs$core$async$mult_$___GT_t_cljs$core$async46313(ch__$1,cs__$1,meta46314){
return (new cljs.core.async.t_cljs$core$async46313(ch__$1,cs__$1,meta46314));
});

}

return (new cljs.core.async.t_cljs$core$async46313(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__44855__auto___48872 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_46477){
var state_val_46478 = (state_46477[(1)]);
if((state_val_46478 === (7))){
var inst_46473 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46479_48873 = state_46477__$1;
(statearr_46479_48873[(2)] = inst_46473);

(statearr_46479_48873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (20))){
var inst_46368 = (state_46477[(7)]);
var inst_46384 = cljs.core.first(inst_46368);
var inst_46385 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46384,(0),null);
var inst_46386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46384,(1),null);
var state_46477__$1 = (function (){var statearr_46481 = state_46477;
(statearr_46481[(8)] = inst_46385);

return statearr_46481;
})();
if(cljs.core.truth_(inst_46386)){
var statearr_46482_48876 = state_46477__$1;
(statearr_46482_48876[(1)] = (22));

} else {
var statearr_46483_48877 = state_46477__$1;
(statearr_46483_48877[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (27))){
var inst_46332 = (state_46477[(9)]);
var inst_46417 = (state_46477[(10)]);
var inst_46422 = (state_46477[(11)]);
var inst_46415 = (state_46477[(12)]);
var inst_46422__$1 = cljs.core._nth(inst_46415,inst_46417);
var inst_46423 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46422__$1,inst_46332,done);
var state_46477__$1 = (function (){var statearr_46484 = state_46477;
(statearr_46484[(11)] = inst_46422__$1);

return statearr_46484;
})();
if(cljs.core.truth_(inst_46423)){
var statearr_46485_48879 = state_46477__$1;
(statearr_46485_48879[(1)] = (30));

} else {
var statearr_46486_48880 = state_46477__$1;
(statearr_46486_48880[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (1))){
var state_46477__$1 = state_46477;
var statearr_46487_48881 = state_46477__$1;
(statearr_46487_48881[(2)] = null);

(statearr_46487_48881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (24))){
var inst_46368 = (state_46477[(7)]);
var inst_46391 = (state_46477[(2)]);
var inst_46392 = cljs.core.next(inst_46368);
var inst_46341 = inst_46392;
var inst_46342 = null;
var inst_46343 = (0);
var inst_46344 = (0);
var state_46477__$1 = (function (){var statearr_46489 = state_46477;
(statearr_46489[(13)] = inst_46341);

(statearr_46489[(14)] = inst_46391);

(statearr_46489[(15)] = inst_46342);

(statearr_46489[(16)] = inst_46343);

(statearr_46489[(17)] = inst_46344);

return statearr_46489;
})();
var statearr_46490_48882 = state_46477__$1;
(statearr_46490_48882[(2)] = null);

(statearr_46490_48882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (39))){
var state_46477__$1 = state_46477;
var statearr_46494_48883 = state_46477__$1;
(statearr_46494_48883[(2)] = null);

(statearr_46494_48883[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (4))){
var inst_46332 = (state_46477[(9)]);
var inst_46332__$1 = (state_46477[(2)]);
var inst_46333 = (inst_46332__$1 == null);
var state_46477__$1 = (function (){var statearr_46495 = state_46477;
(statearr_46495[(9)] = inst_46332__$1);

return statearr_46495;
})();
if(cljs.core.truth_(inst_46333)){
var statearr_46496_48888 = state_46477__$1;
(statearr_46496_48888[(1)] = (5));

} else {
var statearr_46497_48890 = state_46477__$1;
(statearr_46497_48890[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (15))){
var inst_46341 = (state_46477[(13)]);
var inst_46342 = (state_46477[(15)]);
var inst_46343 = (state_46477[(16)]);
var inst_46344 = (state_46477[(17)]);
var inst_46364 = (state_46477[(2)]);
var inst_46365 = (inst_46344 + (1));
var tmp46491 = inst_46341;
var tmp46492 = inst_46342;
var tmp46493 = inst_46343;
var inst_46341__$1 = tmp46491;
var inst_46342__$1 = tmp46492;
var inst_46343__$1 = tmp46493;
var inst_46344__$1 = inst_46365;
var state_46477__$1 = (function (){var statearr_46499 = state_46477;
(statearr_46499[(13)] = inst_46341__$1);

(statearr_46499[(18)] = inst_46364);

(statearr_46499[(15)] = inst_46342__$1);

(statearr_46499[(16)] = inst_46343__$1);

(statearr_46499[(17)] = inst_46344__$1);

return statearr_46499;
})();
var statearr_46500_48893 = state_46477__$1;
(statearr_46500_48893[(2)] = null);

(statearr_46500_48893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (21))){
var inst_46395 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46504_48898 = state_46477__$1;
(statearr_46504_48898[(2)] = inst_46395);

(statearr_46504_48898[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (31))){
var inst_46422 = (state_46477[(11)]);
var inst_46426 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46422);
var state_46477__$1 = state_46477;
var statearr_46505_48899 = state_46477__$1;
(statearr_46505_48899[(2)] = inst_46426);

(statearr_46505_48899[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (32))){
var inst_46414 = (state_46477[(19)]);
var inst_46417 = (state_46477[(10)]);
var inst_46416 = (state_46477[(20)]);
var inst_46415 = (state_46477[(12)]);
var inst_46428 = (state_46477[(2)]);
var inst_46429 = (inst_46417 + (1));
var tmp46501 = inst_46414;
var tmp46502 = inst_46416;
var tmp46503 = inst_46415;
var inst_46414__$1 = tmp46501;
var inst_46415__$1 = tmp46503;
var inst_46416__$1 = tmp46502;
var inst_46417__$1 = inst_46429;
var state_46477__$1 = (function (){var statearr_46506 = state_46477;
(statearr_46506[(21)] = inst_46428);

(statearr_46506[(19)] = inst_46414__$1);

(statearr_46506[(10)] = inst_46417__$1);

(statearr_46506[(20)] = inst_46416__$1);

(statearr_46506[(12)] = inst_46415__$1);

return statearr_46506;
})();
var statearr_46508_48900 = state_46477__$1;
(statearr_46508_48900[(2)] = null);

(statearr_46508_48900[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (40))){
var inst_46444 = (state_46477[(22)]);
var inst_46448 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46444);
var state_46477__$1 = state_46477;
var statearr_46509_48904 = state_46477__$1;
(statearr_46509_48904[(2)] = inst_46448);

(statearr_46509_48904[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (33))){
var inst_46432 = (state_46477[(23)]);
var inst_46434 = cljs.core.chunked_seq_QMARK_(inst_46432);
var state_46477__$1 = state_46477;
if(inst_46434){
var statearr_46510_48906 = state_46477__$1;
(statearr_46510_48906[(1)] = (36));

} else {
var statearr_46511_48908 = state_46477__$1;
(statearr_46511_48908[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (13))){
var inst_46353 = (state_46477[(24)]);
var inst_46361 = cljs.core.async.close_BANG_(inst_46353);
var state_46477__$1 = state_46477;
var statearr_46512_48909 = state_46477__$1;
(statearr_46512_48909[(2)] = inst_46361);

(statearr_46512_48909[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (22))){
var inst_46385 = (state_46477[(8)]);
var inst_46388 = cljs.core.async.close_BANG_(inst_46385);
var state_46477__$1 = state_46477;
var statearr_46513_48911 = state_46477__$1;
(statearr_46513_48911[(2)] = inst_46388);

(statearr_46513_48911[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (36))){
var inst_46432 = (state_46477[(23)]);
var inst_46436 = cljs.core.chunk_first(inst_46432);
var inst_46437 = cljs.core.chunk_rest(inst_46432);
var inst_46438 = cljs.core.count(inst_46436);
var inst_46414 = inst_46437;
var inst_46415 = inst_46436;
var inst_46416 = inst_46438;
var inst_46417 = (0);
var state_46477__$1 = (function (){var statearr_46518 = state_46477;
(statearr_46518[(19)] = inst_46414);

(statearr_46518[(10)] = inst_46417);

(statearr_46518[(20)] = inst_46416);

(statearr_46518[(12)] = inst_46415);

return statearr_46518;
})();
var statearr_46519_48915 = state_46477__$1;
(statearr_46519_48915[(2)] = null);

(statearr_46519_48915[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (41))){
var inst_46432 = (state_46477[(23)]);
var inst_46450 = (state_46477[(2)]);
var inst_46452 = cljs.core.next(inst_46432);
var inst_46414 = inst_46452;
var inst_46415 = null;
var inst_46416 = (0);
var inst_46417 = (0);
var state_46477__$1 = (function (){var statearr_46520 = state_46477;
(statearr_46520[(19)] = inst_46414);

(statearr_46520[(25)] = inst_46450);

(statearr_46520[(10)] = inst_46417);

(statearr_46520[(20)] = inst_46416);

(statearr_46520[(12)] = inst_46415);

return statearr_46520;
})();
var statearr_46523_48916 = state_46477__$1;
(statearr_46523_48916[(2)] = null);

(statearr_46523_48916[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (43))){
var state_46477__$1 = state_46477;
var statearr_46525_48919 = state_46477__$1;
(statearr_46525_48919[(2)] = null);

(statearr_46525_48919[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (29))){
var inst_46460 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46526_48928 = state_46477__$1;
(statearr_46526_48928[(2)] = inst_46460);

(statearr_46526_48928[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (44))){
var inst_46470 = (state_46477[(2)]);
var state_46477__$1 = (function (){var statearr_46531 = state_46477;
(statearr_46531[(26)] = inst_46470);

return statearr_46531;
})();
var statearr_46532_48930 = state_46477__$1;
(statearr_46532_48930[(2)] = null);

(statearr_46532_48930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (6))){
var inst_46405 = (state_46477[(27)]);
var inst_46404 = cljs.core.deref(cs);
var inst_46405__$1 = cljs.core.keys(inst_46404);
var inst_46407 = cljs.core.count(inst_46405__$1);
var inst_46408 = cljs.core.reset_BANG_(dctr,inst_46407);
var inst_46413 = cljs.core.seq(inst_46405__$1);
var inst_46414 = inst_46413;
var inst_46415 = null;
var inst_46416 = (0);
var inst_46417 = (0);
var state_46477__$1 = (function (){var statearr_46535 = state_46477;
(statearr_46535[(27)] = inst_46405__$1);

(statearr_46535[(19)] = inst_46414);

(statearr_46535[(28)] = inst_46408);

(statearr_46535[(10)] = inst_46417);

(statearr_46535[(20)] = inst_46416);

(statearr_46535[(12)] = inst_46415);

return statearr_46535;
})();
var statearr_46537_48935 = state_46477__$1;
(statearr_46537_48935[(2)] = null);

(statearr_46537_48935[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (28))){
var inst_46414 = (state_46477[(19)]);
var inst_46432 = (state_46477[(23)]);
var inst_46432__$1 = cljs.core.seq(inst_46414);
var state_46477__$1 = (function (){var statearr_46539 = state_46477;
(statearr_46539[(23)] = inst_46432__$1);

return statearr_46539;
})();
if(inst_46432__$1){
var statearr_46542_48947 = state_46477__$1;
(statearr_46542_48947[(1)] = (33));

} else {
var statearr_46543_48948 = state_46477__$1;
(statearr_46543_48948[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (25))){
var inst_46417 = (state_46477[(10)]);
var inst_46416 = (state_46477[(20)]);
var inst_46419 = (inst_46417 < inst_46416);
var inst_46420 = inst_46419;
var state_46477__$1 = state_46477;
if(cljs.core.truth_(inst_46420)){
var statearr_46547_48949 = state_46477__$1;
(statearr_46547_48949[(1)] = (27));

} else {
var statearr_46549_48950 = state_46477__$1;
(statearr_46549_48950[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (34))){
var state_46477__$1 = state_46477;
var statearr_46550_48955 = state_46477__$1;
(statearr_46550_48955[(2)] = null);

(statearr_46550_48955[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (17))){
var state_46477__$1 = state_46477;
var statearr_46551_48958 = state_46477__$1;
(statearr_46551_48958[(2)] = null);

(statearr_46551_48958[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (3))){
var inst_46475 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46477__$1,inst_46475);
} else {
if((state_val_46478 === (12))){
var inst_46400 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46557_48960 = state_46477__$1;
(statearr_46557_48960[(2)] = inst_46400);

(statearr_46557_48960[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (2))){
var state_46477__$1 = state_46477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46477__$1,(4),ch);
} else {
if((state_val_46478 === (23))){
var state_46477__$1 = state_46477;
var statearr_46563_48969 = state_46477__$1;
(statearr_46563_48969[(2)] = null);

(statearr_46563_48969[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (35))){
var inst_46458 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46569_48971 = state_46477__$1;
(statearr_46569_48971[(2)] = inst_46458);

(statearr_46569_48971[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (19))){
var inst_46368 = (state_46477[(7)]);
var inst_46373 = cljs.core.chunk_first(inst_46368);
var inst_46374 = cljs.core.chunk_rest(inst_46368);
var inst_46378 = cljs.core.count(inst_46373);
var inst_46341 = inst_46374;
var inst_46342 = inst_46373;
var inst_46343 = inst_46378;
var inst_46344 = (0);
var state_46477__$1 = (function (){var statearr_46573 = state_46477;
(statearr_46573[(13)] = inst_46341);

(statearr_46573[(15)] = inst_46342);

(statearr_46573[(16)] = inst_46343);

(statearr_46573[(17)] = inst_46344);

return statearr_46573;
})();
var statearr_46576_48975 = state_46477__$1;
(statearr_46576_48975[(2)] = null);

(statearr_46576_48975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (11))){
var inst_46341 = (state_46477[(13)]);
var inst_46368 = (state_46477[(7)]);
var inst_46368__$1 = cljs.core.seq(inst_46341);
var state_46477__$1 = (function (){var statearr_46579 = state_46477;
(statearr_46579[(7)] = inst_46368__$1);

return statearr_46579;
})();
if(inst_46368__$1){
var statearr_46582_48978 = state_46477__$1;
(statearr_46582_48978[(1)] = (16));

} else {
var statearr_46584_48979 = state_46477__$1;
(statearr_46584_48979[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (9))){
var inst_46402 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46585_48983 = state_46477__$1;
(statearr_46585_48983[(2)] = inst_46402);

(statearr_46585_48983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (5))){
var inst_46339 = cljs.core.deref(cs);
var inst_46340 = cljs.core.seq(inst_46339);
var inst_46341 = inst_46340;
var inst_46342 = null;
var inst_46343 = (0);
var inst_46344 = (0);
var state_46477__$1 = (function (){var statearr_46591 = state_46477;
(statearr_46591[(13)] = inst_46341);

(statearr_46591[(15)] = inst_46342);

(statearr_46591[(16)] = inst_46343);

(statearr_46591[(17)] = inst_46344);

return statearr_46591;
})();
var statearr_46592_48989 = state_46477__$1;
(statearr_46592_48989[(2)] = null);

(statearr_46592_48989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (14))){
var state_46477__$1 = state_46477;
var statearr_46597_48992 = state_46477__$1;
(statearr_46597_48992[(2)] = null);

(statearr_46597_48992[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (45))){
var inst_46467 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46600_48994 = state_46477__$1;
(statearr_46600_48994[(2)] = inst_46467);

(statearr_46600_48994[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (26))){
var inst_46405 = (state_46477[(27)]);
var inst_46462 = (state_46477[(2)]);
var inst_46464 = cljs.core.seq(inst_46405);
var state_46477__$1 = (function (){var statearr_46609 = state_46477;
(statearr_46609[(29)] = inst_46462);

return statearr_46609;
})();
if(inst_46464){
var statearr_46613_49000 = state_46477__$1;
(statearr_46613_49000[(1)] = (42));

} else {
var statearr_46615_49001 = state_46477__$1;
(statearr_46615_49001[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (16))){
var inst_46368 = (state_46477[(7)]);
var inst_46370 = cljs.core.chunked_seq_QMARK_(inst_46368);
var state_46477__$1 = state_46477;
if(inst_46370){
var statearr_46620_49005 = state_46477__$1;
(statearr_46620_49005[(1)] = (19));

} else {
var statearr_46621_49006 = state_46477__$1;
(statearr_46621_49006[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (38))){
var inst_46455 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46626_49008 = state_46477__$1;
(statearr_46626_49008[(2)] = inst_46455);

(statearr_46626_49008[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (30))){
var state_46477__$1 = state_46477;
var statearr_46627_49011 = state_46477__$1;
(statearr_46627_49011[(2)] = null);

(statearr_46627_49011[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (10))){
var inst_46342 = (state_46477[(15)]);
var inst_46344 = (state_46477[(17)]);
var inst_46352 = cljs.core._nth(inst_46342,inst_46344);
var inst_46353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46352,(0),null);
var inst_46355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46352,(1),null);
var state_46477__$1 = (function (){var statearr_46630 = state_46477;
(statearr_46630[(24)] = inst_46353);

return statearr_46630;
})();
if(cljs.core.truth_(inst_46355)){
var statearr_46631_49013 = state_46477__$1;
(statearr_46631_49013[(1)] = (13));

} else {
var statearr_46632_49015 = state_46477__$1;
(statearr_46632_49015[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (18))){
var inst_46398 = (state_46477[(2)]);
var state_46477__$1 = state_46477;
var statearr_46635_49018 = state_46477__$1;
(statearr_46635_49018[(2)] = inst_46398);

(statearr_46635_49018[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (42))){
var state_46477__$1 = state_46477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46477__$1,(45),dchan);
} else {
if((state_val_46478 === (37))){
var inst_46444 = (state_46477[(22)]);
var inst_46432 = (state_46477[(23)]);
var inst_46332 = (state_46477[(9)]);
var inst_46444__$1 = cljs.core.first(inst_46432);
var inst_46445 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46444__$1,inst_46332,done);
var state_46477__$1 = (function (){var statearr_46638 = state_46477;
(statearr_46638[(22)] = inst_46444__$1);

return statearr_46638;
})();
if(cljs.core.truth_(inst_46445)){
var statearr_46639_49021 = state_46477__$1;
(statearr_46639_49021[(1)] = (39));

} else {
var statearr_46643_49022 = state_46477__$1;
(statearr_46643_49022[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46478 === (8))){
var inst_46343 = (state_46477[(16)]);
var inst_46344 = (state_46477[(17)]);
var inst_46346 = (inst_46344 < inst_46343);
var inst_46347 = inst_46346;
var state_46477__$1 = state_46477;
if(cljs.core.truth_(inst_46347)){
var statearr_46644_49032 = state_46477__$1;
(statearr_46644_49032[(1)] = (10));

} else {
var statearr_46645_49033 = state_46477__$1;
(statearr_46645_49033[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__44693__auto__ = null;
var cljs$core$async$mult_$_state_machine__44693__auto____0 = (function (){
var statearr_46648 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46648[(0)] = cljs$core$async$mult_$_state_machine__44693__auto__);

(statearr_46648[(1)] = (1));

return statearr_46648;
});
var cljs$core$async$mult_$_state_machine__44693__auto____1 = (function (state_46477){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_46477);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e46650){var ex__44696__auto__ = e46650;
var statearr_46652_49038 = state_46477;
(statearr_46652_49038[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_46477[(4)]))){
var statearr_46653_49039 = state_46477;
(statearr_46653_49039[(1)] = cljs.core.first((state_46477[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49042 = state_46477;
state_46477 = G__49042;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__44693__auto__ = function(state_46477){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__44693__auto____1.call(this,state_46477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__44693__auto____0;
cljs$core$async$mult_$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__44693__auto____1;
return cljs$core$async$mult_$_state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_46669 = f__44856__auto__();
(statearr_46669[(6)] = c__44855__auto___48872);

return statearr_46669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__46684 = arguments.length;
switch (G__46684) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_49051 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_49051(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_49054 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_49054(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_49059 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_49059(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_49064 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_49064(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_49067 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_49067(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___49071 = arguments.length;
var i__4865__auto___49072 = (0);
while(true){
if((i__4865__auto___49072 < len__4864__auto___49071)){
args__4870__auto__.push((arguments[i__4865__auto___49072]));

var G__49073 = (i__4865__auto___49072 + (1));
i__4865__auto___49072 = G__49073;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__46716){
var map__46719 = p__46716;
var map__46719__$1 = cljs.core.__destructure_map(map__46719);
var opts = map__46719__$1;
var statearr_46721_49078 = state;
(statearr_46721_49078[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_46722_49079 = state;
(statearr_46722_49079[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_46723_49080 = state;
(statearr_46723_49080[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq46712){
var G__46713 = cljs.core.first(seq46712);
var seq46712__$1 = cljs.core.next(seq46712);
var G__46714 = cljs.core.first(seq46712__$1);
var seq46712__$2 = cljs.core.next(seq46712__$1);
var G__46715 = cljs.core.first(seq46712__$2);
var seq46712__$3 = cljs.core.next(seq46712__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46713,G__46714,G__46715,seq46712__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46727 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46727 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta46728){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta46728 = meta46728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46729,meta46728__$1){
var self__ = this;
var _46729__$1 = this;
return (new cljs.core.async.t_cljs$core$async46727(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta46728__$1));
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46729){
var self__ = this;
var _46729__$1 = this;
return self__.meta46728;
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46727.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46727.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta46728","meta46728",212090302,null)], null);
}));

(cljs.core.async.t_cljs$core$async46727.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46727.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46727");

(cljs.core.async.t_cljs$core$async46727.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46727");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46727.
 */
cljs.core.async.__GT_t_cljs$core$async46727 = (function cljs$core$async$mix_$___GT_t_cljs$core$async46727(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46728){
return (new cljs.core.async.t_cljs$core$async46727(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46728));
});

}

return (new cljs.core.async.t_cljs$core$async46727(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44855__auto___49123 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_46806){
var state_val_46807 = (state_46806[(1)]);
if((state_val_46807 === (7))){
var inst_46764 = (state_46806[(2)]);
var state_46806__$1 = state_46806;
if(cljs.core.truth_(inst_46764)){
var statearr_46808_49126 = state_46806__$1;
(statearr_46808_49126[(1)] = (8));

} else {
var statearr_46809_49127 = state_46806__$1;
(statearr_46809_49127[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (20))){
var inst_46757 = (state_46806[(7)]);
var state_46806__$1 = state_46806;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46806__$1,(23),out,inst_46757);
} else {
if((state_val_46807 === (1))){
var inst_46739 = calc_state();
var inst_46740 = cljs.core.__destructure_map(inst_46739);
var inst_46741 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46740,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46740,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46743 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46740,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_46744 = inst_46739;
var state_46806__$1 = (function (){var statearr_46811 = state_46806;
(statearr_46811[(8)] = inst_46744);

(statearr_46811[(9)] = inst_46742);

(statearr_46811[(10)] = inst_46741);

(statearr_46811[(11)] = inst_46743);

return statearr_46811;
})();
var statearr_46812_49131 = state_46806__$1;
(statearr_46812_49131[(2)] = null);

(statearr_46812_49131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (24))){
var inst_46748 = (state_46806[(12)]);
var inst_46744 = inst_46748;
var state_46806__$1 = (function (){var statearr_46814 = state_46806;
(statearr_46814[(8)] = inst_46744);

return statearr_46814;
})();
var statearr_46815_49138 = state_46806__$1;
(statearr_46815_49138[(2)] = null);

(statearr_46815_49138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (4))){
var inst_46759 = (state_46806[(13)]);
var inst_46757 = (state_46806[(7)]);
var inst_46756 = (state_46806[(2)]);
var inst_46757__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46756,(0),null);
var inst_46758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46756,(1),null);
var inst_46759__$1 = (inst_46757__$1 == null);
var state_46806__$1 = (function (){var statearr_46816 = state_46806;
(statearr_46816[(13)] = inst_46759__$1);

(statearr_46816[(7)] = inst_46757__$1);

(statearr_46816[(14)] = inst_46758);

return statearr_46816;
})();
if(cljs.core.truth_(inst_46759__$1)){
var statearr_46817_49147 = state_46806__$1;
(statearr_46817_49147[(1)] = (5));

} else {
var statearr_46818_49149 = state_46806__$1;
(statearr_46818_49149[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (15))){
var inst_46779 = (state_46806[(15)]);
var inst_46749 = (state_46806[(16)]);
var inst_46779__$1 = cljs.core.empty_QMARK_(inst_46749);
var state_46806__$1 = (function (){var statearr_46820 = state_46806;
(statearr_46820[(15)] = inst_46779__$1);

return statearr_46820;
})();
if(inst_46779__$1){
var statearr_46821_49151 = state_46806__$1;
(statearr_46821_49151[(1)] = (17));

} else {
var statearr_46822_49152 = state_46806__$1;
(statearr_46822_49152[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (21))){
var inst_46748 = (state_46806[(12)]);
var inst_46744 = inst_46748;
var state_46806__$1 = (function (){var statearr_46823 = state_46806;
(statearr_46823[(8)] = inst_46744);

return statearr_46823;
})();
var statearr_46824_49155 = state_46806__$1;
(statearr_46824_49155[(2)] = null);

(statearr_46824_49155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (13))){
var inst_46771 = (state_46806[(2)]);
var inst_46772 = calc_state();
var inst_46744 = inst_46772;
var state_46806__$1 = (function (){var statearr_46825 = state_46806;
(statearr_46825[(8)] = inst_46744);

(statearr_46825[(17)] = inst_46771);

return statearr_46825;
})();
var statearr_46826_49158 = state_46806__$1;
(statearr_46826_49158[(2)] = null);

(statearr_46826_49158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (22))){
var inst_46800 = (state_46806[(2)]);
var state_46806__$1 = state_46806;
var statearr_46827_49160 = state_46806__$1;
(statearr_46827_49160[(2)] = inst_46800);

(statearr_46827_49160[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (6))){
var inst_46758 = (state_46806[(14)]);
var inst_46762 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46758,change);
var state_46806__$1 = state_46806;
var statearr_46829_49164 = state_46806__$1;
(statearr_46829_49164[(2)] = inst_46762);

(statearr_46829_49164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (25))){
var state_46806__$1 = state_46806;
var statearr_46830_49166 = state_46806__$1;
(statearr_46830_49166[(2)] = null);

(statearr_46830_49166[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (17))){
var inst_46758 = (state_46806[(14)]);
var inst_46750 = (state_46806[(18)]);
var inst_46781 = (inst_46750.cljs$core$IFn$_invoke$arity$1 ? inst_46750.cljs$core$IFn$_invoke$arity$1(inst_46758) : inst_46750.call(null,inst_46758));
var inst_46782 = cljs.core.not(inst_46781);
var state_46806__$1 = state_46806;
var statearr_46831_49167 = state_46806__$1;
(statearr_46831_49167[(2)] = inst_46782);

(statearr_46831_49167[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (3))){
var inst_46804 = (state_46806[(2)]);
var state_46806__$1 = state_46806;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46806__$1,inst_46804);
} else {
if((state_val_46807 === (12))){
var state_46806__$1 = state_46806;
var statearr_46832_49173 = state_46806__$1;
(statearr_46832_49173[(2)] = null);

(statearr_46832_49173[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (2))){
var inst_46744 = (state_46806[(8)]);
var inst_46748 = (state_46806[(12)]);
var inst_46748__$1 = cljs.core.__destructure_map(inst_46744);
var inst_46749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46748__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46750 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46748__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46748__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_46806__$1 = (function (){var statearr_46833 = state_46806;
(statearr_46833[(12)] = inst_46748__$1);

(statearr_46833[(18)] = inst_46750);

(statearr_46833[(16)] = inst_46749);

return statearr_46833;
})();
return cljs.core.async.ioc_alts_BANG_(state_46806__$1,(4),inst_46751);
} else {
if((state_val_46807 === (23))){
var inst_46791 = (state_46806[(2)]);
var state_46806__$1 = state_46806;
if(cljs.core.truth_(inst_46791)){
var statearr_46835_49174 = state_46806__$1;
(statearr_46835_49174[(1)] = (24));

} else {
var statearr_46836_49175 = state_46806__$1;
(statearr_46836_49175[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (19))){
var inst_46785 = (state_46806[(2)]);
var state_46806__$1 = state_46806;
var statearr_46837_49178 = state_46806__$1;
(statearr_46837_49178[(2)] = inst_46785);

(statearr_46837_49178[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (11))){
var inst_46758 = (state_46806[(14)]);
var inst_46768 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_46758);
var state_46806__$1 = state_46806;
var statearr_46838_49179 = state_46806__$1;
(statearr_46838_49179[(2)] = inst_46768);

(statearr_46838_49179[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (9))){
var inst_46758 = (state_46806[(14)]);
var inst_46775 = (state_46806[(19)]);
var inst_46749 = (state_46806[(16)]);
var inst_46775__$1 = (inst_46749.cljs$core$IFn$_invoke$arity$1 ? inst_46749.cljs$core$IFn$_invoke$arity$1(inst_46758) : inst_46749.call(null,inst_46758));
var state_46806__$1 = (function (){var statearr_46839 = state_46806;
(statearr_46839[(19)] = inst_46775__$1);

return statearr_46839;
})();
if(cljs.core.truth_(inst_46775__$1)){
var statearr_46840_49183 = state_46806__$1;
(statearr_46840_49183[(1)] = (14));

} else {
var statearr_46841_49185 = state_46806__$1;
(statearr_46841_49185[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (5))){
var inst_46759 = (state_46806[(13)]);
var state_46806__$1 = state_46806;
var statearr_46843_49190 = state_46806__$1;
(statearr_46843_49190[(2)] = inst_46759);

(statearr_46843_49190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (14))){
var inst_46775 = (state_46806[(19)]);
var state_46806__$1 = state_46806;
var statearr_46844_49191 = state_46806__$1;
(statearr_46844_49191[(2)] = inst_46775);

(statearr_46844_49191[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (26))){
var inst_46796 = (state_46806[(2)]);
var state_46806__$1 = state_46806;
var statearr_46848_49192 = state_46806__$1;
(statearr_46848_49192[(2)] = inst_46796);

(statearr_46848_49192[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (16))){
var inst_46787 = (state_46806[(2)]);
var state_46806__$1 = state_46806;
if(cljs.core.truth_(inst_46787)){
var statearr_46849_49193 = state_46806__$1;
(statearr_46849_49193[(1)] = (20));

} else {
var statearr_46851_49194 = state_46806__$1;
(statearr_46851_49194[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (10))){
var inst_46802 = (state_46806[(2)]);
var state_46806__$1 = state_46806;
var statearr_46855_49195 = state_46806__$1;
(statearr_46855_49195[(2)] = inst_46802);

(statearr_46855_49195[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (18))){
var inst_46779 = (state_46806[(15)]);
var state_46806__$1 = state_46806;
var statearr_46858_49197 = state_46806__$1;
(statearr_46858_49197[(2)] = inst_46779);

(statearr_46858_49197[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46807 === (8))){
var inst_46757 = (state_46806[(7)]);
var inst_46766 = (inst_46757 == null);
var state_46806__$1 = state_46806;
if(cljs.core.truth_(inst_46766)){
var statearr_46860_49204 = state_46806__$1;
(statearr_46860_49204[(1)] = (11));

} else {
var statearr_46861_49208 = state_46806__$1;
(statearr_46861_49208[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__44693__auto__ = null;
var cljs$core$async$mix_$_state_machine__44693__auto____0 = (function (){
var statearr_46862 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46862[(0)] = cljs$core$async$mix_$_state_machine__44693__auto__);

(statearr_46862[(1)] = (1));

return statearr_46862;
});
var cljs$core$async$mix_$_state_machine__44693__auto____1 = (function (state_46806){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_46806);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e46863){var ex__44696__auto__ = e46863;
var statearr_46864_49213 = state_46806;
(statearr_46864_49213[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_46806[(4)]))){
var statearr_46865_49214 = state_46806;
(statearr_46865_49214[(1)] = cljs.core.first((state_46806[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49215 = state_46806;
state_46806 = G__49215;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__44693__auto__ = function(state_46806){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__44693__auto____1.call(this,state_46806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__44693__auto____0;
cljs$core$async$mix_$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__44693__auto____1;
return cljs$core$async$mix_$_state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_46866 = f__44856__auto__();
(statearr_46866[(6)] = c__44855__auto___49123);

return statearr_46866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_49216 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_49216(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_49220 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_49220(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_49221 = (function() {
var G__49222 = null;
var G__49222__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__49222__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__49222 = function(p,v){
switch(arguments.length){
case 1:
return G__49222__1.call(this,p);
case 2:
return G__49222__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__49222.cljs$core$IFn$_invoke$arity$1 = G__49222__1;
G__49222.cljs$core$IFn$_invoke$arity$2 = G__49222__2;
return G__49222;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__46880 = arguments.length;
switch (G__46880) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49221(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49221(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__46885 = arguments.length;
switch (G__46885) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__46882_SHARP_){
if(cljs.core.truth_((p1__46882_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__46882_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__46882_SHARP_.call(null,topic)))){
return p1__46882_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__46882_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46892 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46892 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta46893){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta46893 = meta46893;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46894,meta46893__$1){
var self__ = this;
var _46894__$1 = this;
return (new cljs.core.async.t_cljs$core$async46892(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta46893__$1));
}));

(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46894){
var self__ = this;
var _46894__$1 = this;
return self__.meta46893;
}));

(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async46892.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async46892.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta46893","meta46893",-570738785,null)], null);
}));

(cljs.core.async.t_cljs$core$async46892.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46892.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46892");

(cljs.core.async.t_cljs$core$async46892.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46892");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46892.
 */
cljs.core.async.__GT_t_cljs$core$async46892 = (function cljs$core$async$__GT_t_cljs$core$async46892(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46893){
return (new cljs.core.async.t_cljs$core$async46892(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46893));
});

}

return (new cljs.core.async.t_cljs$core$async46892(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44855__auto___49236 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_46973){
var state_val_46974 = (state_46973[(1)]);
if((state_val_46974 === (7))){
var inst_46967 = (state_46973[(2)]);
var state_46973__$1 = state_46973;
var statearr_46975_49237 = state_46973__$1;
(statearr_46975_49237[(2)] = inst_46967);

(statearr_46975_49237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (20))){
var state_46973__$1 = state_46973;
var statearr_46976_49238 = state_46973__$1;
(statearr_46976_49238[(2)] = null);

(statearr_46976_49238[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (1))){
var state_46973__$1 = state_46973;
var statearr_46977_49239 = state_46973__$1;
(statearr_46977_49239[(2)] = null);

(statearr_46977_49239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (24))){
var inst_46950 = (state_46973[(7)]);
var inst_46959 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46950);
var state_46973__$1 = state_46973;
var statearr_46978_49244 = state_46973__$1;
(statearr_46978_49244[(2)] = inst_46959);

(statearr_46978_49244[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (4))){
var inst_46902 = (state_46973[(8)]);
var inst_46902__$1 = (state_46973[(2)]);
var inst_46903 = (inst_46902__$1 == null);
var state_46973__$1 = (function (){var statearr_46979 = state_46973;
(statearr_46979[(8)] = inst_46902__$1);

return statearr_46979;
})();
if(cljs.core.truth_(inst_46903)){
var statearr_46980_49245 = state_46973__$1;
(statearr_46980_49245[(1)] = (5));

} else {
var statearr_46981_49246 = state_46973__$1;
(statearr_46981_49246[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (15))){
var inst_46944 = (state_46973[(2)]);
var state_46973__$1 = state_46973;
var statearr_46982_49247 = state_46973__$1;
(statearr_46982_49247[(2)] = inst_46944);

(statearr_46982_49247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (21))){
var inst_46964 = (state_46973[(2)]);
var state_46973__$1 = (function (){var statearr_46983 = state_46973;
(statearr_46983[(9)] = inst_46964);

return statearr_46983;
})();
var statearr_46984_49250 = state_46973__$1;
(statearr_46984_49250[(2)] = null);

(statearr_46984_49250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (13))){
var inst_46926 = (state_46973[(10)]);
var inst_46928 = cljs.core.chunked_seq_QMARK_(inst_46926);
var state_46973__$1 = state_46973;
if(inst_46928){
var statearr_46985_49256 = state_46973__$1;
(statearr_46985_49256[(1)] = (16));

} else {
var statearr_46986_49259 = state_46973__$1;
(statearr_46986_49259[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (22))){
var inst_46956 = (state_46973[(2)]);
var state_46973__$1 = state_46973;
if(cljs.core.truth_(inst_46956)){
var statearr_46987_49260 = state_46973__$1;
(statearr_46987_49260[(1)] = (23));

} else {
var statearr_46990_49261 = state_46973__$1;
(statearr_46990_49261[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (6))){
var inst_46902 = (state_46973[(8)]);
var inst_46952 = (state_46973[(11)]);
var inst_46950 = (state_46973[(7)]);
var inst_46950__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_46902) : topic_fn.call(null,inst_46902));
var inst_46951 = cljs.core.deref(mults);
var inst_46952__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46951,inst_46950__$1);
var state_46973__$1 = (function (){var statearr_46995 = state_46973;
(statearr_46995[(11)] = inst_46952__$1);

(statearr_46995[(7)] = inst_46950__$1);

return statearr_46995;
})();
if(cljs.core.truth_(inst_46952__$1)){
var statearr_46996_49263 = state_46973__$1;
(statearr_46996_49263[(1)] = (19));

} else {
var statearr_47000_49264 = state_46973__$1;
(statearr_47000_49264[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (25))){
var inst_46961 = (state_46973[(2)]);
var state_46973__$1 = state_46973;
var statearr_47001_49265 = state_46973__$1;
(statearr_47001_49265[(2)] = inst_46961);

(statearr_47001_49265[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (17))){
var inst_46926 = (state_46973[(10)]);
var inst_46935 = cljs.core.first(inst_46926);
var inst_46936 = cljs.core.async.muxch_STAR_(inst_46935);
var inst_46937 = cljs.core.async.close_BANG_(inst_46936);
var inst_46938 = cljs.core.next(inst_46926);
var inst_46912 = inst_46938;
var inst_46913 = null;
var inst_46914 = (0);
var inst_46915 = (0);
var state_46973__$1 = (function (){var statearr_47002 = state_46973;
(statearr_47002[(12)] = inst_46912);

(statearr_47002[(13)] = inst_46937);

(statearr_47002[(14)] = inst_46914);

(statearr_47002[(15)] = inst_46915);

(statearr_47002[(16)] = inst_46913);

return statearr_47002;
})();
var statearr_47004_49267 = state_46973__$1;
(statearr_47004_49267[(2)] = null);

(statearr_47004_49267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (3))){
var inst_46969 = (state_46973[(2)]);
var state_46973__$1 = state_46973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46973__$1,inst_46969);
} else {
if((state_val_46974 === (12))){
var inst_46946 = (state_46973[(2)]);
var state_46973__$1 = state_46973;
var statearr_47009_49270 = state_46973__$1;
(statearr_47009_49270[(2)] = inst_46946);

(statearr_47009_49270[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (2))){
var state_46973__$1 = state_46973;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46973__$1,(4),ch);
} else {
if((state_val_46974 === (23))){
var state_46973__$1 = state_46973;
var statearr_47013_49273 = state_46973__$1;
(statearr_47013_49273[(2)] = null);

(statearr_47013_49273[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (19))){
var inst_46902 = (state_46973[(8)]);
var inst_46952 = (state_46973[(11)]);
var inst_46954 = cljs.core.async.muxch_STAR_(inst_46952);
var state_46973__$1 = state_46973;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46973__$1,(22),inst_46954,inst_46902);
} else {
if((state_val_46974 === (11))){
var inst_46912 = (state_46973[(12)]);
var inst_46926 = (state_46973[(10)]);
var inst_46926__$1 = cljs.core.seq(inst_46912);
var state_46973__$1 = (function (){var statearr_47019 = state_46973;
(statearr_47019[(10)] = inst_46926__$1);

return statearr_47019;
})();
if(inst_46926__$1){
var statearr_47020_49274 = state_46973__$1;
(statearr_47020_49274[(1)] = (13));

} else {
var statearr_47023_49275 = state_46973__$1;
(statearr_47023_49275[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (9))){
var inst_46948 = (state_46973[(2)]);
var state_46973__$1 = state_46973;
var statearr_47025_49277 = state_46973__$1;
(statearr_47025_49277[(2)] = inst_46948);

(statearr_47025_49277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (5))){
var inst_46909 = cljs.core.deref(mults);
var inst_46910 = cljs.core.vals(inst_46909);
var inst_46911 = cljs.core.seq(inst_46910);
var inst_46912 = inst_46911;
var inst_46913 = null;
var inst_46914 = (0);
var inst_46915 = (0);
var state_46973__$1 = (function (){var statearr_47030 = state_46973;
(statearr_47030[(12)] = inst_46912);

(statearr_47030[(14)] = inst_46914);

(statearr_47030[(15)] = inst_46915);

(statearr_47030[(16)] = inst_46913);

return statearr_47030;
})();
var statearr_47032_49278 = state_46973__$1;
(statearr_47032_49278[(2)] = null);

(statearr_47032_49278[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (14))){
var state_46973__$1 = state_46973;
var statearr_47039_49279 = state_46973__$1;
(statearr_47039_49279[(2)] = null);

(statearr_47039_49279[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (16))){
var inst_46926 = (state_46973[(10)]);
var inst_46930 = cljs.core.chunk_first(inst_46926);
var inst_46931 = cljs.core.chunk_rest(inst_46926);
var inst_46932 = cljs.core.count(inst_46930);
var inst_46912 = inst_46931;
var inst_46913 = inst_46930;
var inst_46914 = inst_46932;
var inst_46915 = (0);
var state_46973__$1 = (function (){var statearr_47044 = state_46973;
(statearr_47044[(12)] = inst_46912);

(statearr_47044[(14)] = inst_46914);

(statearr_47044[(15)] = inst_46915);

(statearr_47044[(16)] = inst_46913);

return statearr_47044;
})();
var statearr_47046_49280 = state_46973__$1;
(statearr_47046_49280[(2)] = null);

(statearr_47046_49280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (10))){
var inst_46912 = (state_46973[(12)]);
var inst_46914 = (state_46973[(14)]);
var inst_46915 = (state_46973[(15)]);
var inst_46913 = (state_46973[(16)]);
var inst_46920 = cljs.core._nth(inst_46913,inst_46915);
var inst_46921 = cljs.core.async.muxch_STAR_(inst_46920);
var inst_46922 = cljs.core.async.close_BANG_(inst_46921);
var inst_46923 = (inst_46915 + (1));
var tmp47036 = inst_46912;
var tmp47037 = inst_46914;
var tmp47038 = inst_46913;
var inst_46912__$1 = tmp47036;
var inst_46913__$1 = tmp47038;
var inst_46914__$1 = tmp47037;
var inst_46915__$1 = inst_46923;
var state_46973__$1 = (function (){var statearr_47053 = state_46973;
(statearr_47053[(12)] = inst_46912__$1);

(statearr_47053[(14)] = inst_46914__$1);

(statearr_47053[(15)] = inst_46915__$1);

(statearr_47053[(16)] = inst_46913__$1);

(statearr_47053[(17)] = inst_46922);

return statearr_47053;
})();
var statearr_47055_49285 = state_46973__$1;
(statearr_47055_49285[(2)] = null);

(statearr_47055_49285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (18))){
var inst_46941 = (state_46973[(2)]);
var state_46973__$1 = state_46973;
var statearr_47059_49290 = state_46973__$1;
(statearr_47059_49290[(2)] = inst_46941);

(statearr_47059_49290[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46974 === (8))){
var inst_46914 = (state_46973[(14)]);
var inst_46915 = (state_46973[(15)]);
var inst_46917 = (inst_46915 < inst_46914);
var inst_46918 = inst_46917;
var state_46973__$1 = state_46973;
if(cljs.core.truth_(inst_46918)){
var statearr_47062_49291 = state_46973__$1;
(statearr_47062_49291[(1)] = (10));

} else {
var statearr_47063_49292 = state_46973__$1;
(statearr_47063_49292[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_47071 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47071[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_47071[(1)] = (1));

return statearr_47071;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_46973){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_46973);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e47073){var ex__44696__auto__ = e47073;
var statearr_47074_49293 = state_46973;
(statearr_47074_49293[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_46973[(4)]))){
var statearr_47078_49294 = state_46973;
(statearr_47078_49294[(1)] = cljs.core.first((state_46973[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49299 = state_46973;
state_46973 = G__49299;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_46973){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_46973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_47082 = f__44856__auto__();
(statearr_47082[(6)] = c__44855__auto___49236);

return statearr_47082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__47090 = arguments.length;
switch (G__47090) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__47107 = arguments.length;
switch (G__47107) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__47118 = arguments.length;
switch (G__47118) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__44855__auto___49308 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_47192){
var state_val_47195 = (state_47192[(1)]);
if((state_val_47195 === (7))){
var state_47192__$1 = state_47192;
var statearr_47201_49309 = state_47192__$1;
(statearr_47201_49309[(2)] = null);

(statearr_47201_49309[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (1))){
var state_47192__$1 = state_47192;
var statearr_47203_49311 = state_47192__$1;
(statearr_47203_49311[(2)] = null);

(statearr_47203_49311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (4))){
var inst_47139 = (state_47192[(7)]);
var inst_47138 = (state_47192[(8)]);
var inst_47141 = (inst_47139 < inst_47138);
var state_47192__$1 = state_47192;
if(cljs.core.truth_(inst_47141)){
var statearr_47208_49312 = state_47192__$1;
(statearr_47208_49312[(1)] = (6));

} else {
var statearr_47210_49313 = state_47192__$1;
(statearr_47210_49313[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (15))){
var inst_47176 = (state_47192[(9)]);
var inst_47182 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_47176);
var state_47192__$1 = state_47192;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47192__$1,(17),out,inst_47182);
} else {
if((state_val_47195 === (13))){
var inst_47176 = (state_47192[(9)]);
var inst_47176__$1 = (state_47192[(2)]);
var inst_47178 = cljs.core.some(cljs.core.nil_QMARK_,inst_47176__$1);
var state_47192__$1 = (function (){var statearr_47215 = state_47192;
(statearr_47215[(9)] = inst_47176__$1);

return statearr_47215;
})();
if(cljs.core.truth_(inst_47178)){
var statearr_47218_49317 = state_47192__$1;
(statearr_47218_49317[(1)] = (14));

} else {
var statearr_47223_49318 = state_47192__$1;
(statearr_47223_49318[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (6))){
var state_47192__$1 = state_47192;
var statearr_47225_49320 = state_47192__$1;
(statearr_47225_49320[(2)] = null);

(statearr_47225_49320[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (17))){
var inst_47184 = (state_47192[(2)]);
var state_47192__$1 = (function (){var statearr_47237 = state_47192;
(statearr_47237[(10)] = inst_47184);

return statearr_47237;
})();
var statearr_47240_49321 = state_47192__$1;
(statearr_47240_49321[(2)] = null);

(statearr_47240_49321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (3))){
var inst_47189 = (state_47192[(2)]);
var state_47192__$1 = state_47192;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47192__$1,inst_47189);
} else {
if((state_val_47195 === (12))){
var _ = (function (){var statearr_47246 = state_47192;
(statearr_47246[(4)] = cljs.core.rest((state_47192[(4)])));

return statearr_47246;
})();
var state_47192__$1 = state_47192;
var ex47233 = (state_47192__$1[(2)]);
var statearr_47248_49322 = state_47192__$1;
(statearr_47248_49322[(5)] = ex47233);


if((ex47233 instanceof Object)){
var statearr_47252_49323 = state_47192__$1;
(statearr_47252_49323[(1)] = (11));

(statearr_47252_49323[(5)] = null);

} else {
throw ex47233;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (2))){
var inst_47136 = cljs.core.reset_BANG_(dctr,cnt);
var inst_47138 = cnt;
var inst_47139 = (0);
var state_47192__$1 = (function (){var statearr_47260 = state_47192;
(statearr_47260[(7)] = inst_47139);

(statearr_47260[(8)] = inst_47138);

(statearr_47260[(11)] = inst_47136);

return statearr_47260;
})();
var statearr_47262_49325 = state_47192__$1;
(statearr_47262_49325[(2)] = null);

(statearr_47262_49325[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (11))){
var inst_47152 = (state_47192[(2)]);
var inst_47153 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_47192__$1 = (function (){var statearr_47266 = state_47192;
(statearr_47266[(12)] = inst_47152);

return statearr_47266;
})();
var statearr_47268_49326 = state_47192__$1;
(statearr_47268_49326[(2)] = inst_47153);

(statearr_47268_49326[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (9))){
var inst_47139 = (state_47192[(7)]);
var _ = (function (){var statearr_47271 = state_47192;
(statearr_47271[(4)] = cljs.core.cons((12),(state_47192[(4)])));

return statearr_47271;
})();
var inst_47160 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_47139) : chs__$1.call(null,inst_47139));
var inst_47161 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_47139) : done.call(null,inst_47139));
var inst_47162 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_47160,inst_47161);
var ___$1 = (function (){var statearr_47273 = state_47192;
(statearr_47273[(4)] = cljs.core.rest((state_47192[(4)])));

return statearr_47273;
})();
var state_47192__$1 = state_47192;
var statearr_47274_49328 = state_47192__$1;
(statearr_47274_49328[(2)] = inst_47162);

(statearr_47274_49328[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (5))){
var inst_47172 = (state_47192[(2)]);
var state_47192__$1 = (function (){var statearr_47275 = state_47192;
(statearr_47275[(13)] = inst_47172);

return statearr_47275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47192__$1,(13),dchan);
} else {
if((state_val_47195 === (14))){
var inst_47180 = cljs.core.async.close_BANG_(out);
var state_47192__$1 = state_47192;
var statearr_47276_49329 = state_47192__$1;
(statearr_47276_49329[(2)] = inst_47180);

(statearr_47276_49329[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (16))){
var inst_47187 = (state_47192[(2)]);
var state_47192__$1 = state_47192;
var statearr_47277_49330 = state_47192__$1;
(statearr_47277_49330[(2)] = inst_47187);

(statearr_47277_49330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (10))){
var inst_47139 = (state_47192[(7)]);
var inst_47165 = (state_47192[(2)]);
var inst_47166 = (inst_47139 + (1));
var inst_47139__$1 = inst_47166;
var state_47192__$1 = (function (){var statearr_47278 = state_47192;
(statearr_47278[(14)] = inst_47165);

(statearr_47278[(7)] = inst_47139__$1);

return statearr_47278;
})();
var statearr_47279_49333 = state_47192__$1;
(statearr_47279_49333[(2)] = null);

(statearr_47279_49333[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47195 === (8))){
var inst_47170 = (state_47192[(2)]);
var state_47192__$1 = state_47192;
var statearr_47281_49334 = state_47192__$1;
(statearr_47281_49334[(2)] = inst_47170);

(statearr_47281_49334[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_47283 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47283[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_47283[(1)] = (1));

return statearr_47283;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_47192){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_47192);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e47284){var ex__44696__auto__ = e47284;
var statearr_47285_49339 = state_47192;
(statearr_47285_49339[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_47192[(4)]))){
var statearr_47286_49340 = state_47192;
(statearr_47286_49340[(1)] = cljs.core.first((state_47192[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49341 = state_47192;
state_47192 = G__49341;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_47192){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_47192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_47287 = f__44856__auto__();
(statearr_47287[(6)] = c__44855__auto___49308);

return statearr_47287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__47290 = arguments.length;
switch (G__47290) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44855__auto___49348 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_47322){
var state_val_47323 = (state_47322[(1)]);
if((state_val_47323 === (7))){
var inst_47302 = (state_47322[(7)]);
var inst_47301 = (state_47322[(8)]);
var inst_47301__$1 = (state_47322[(2)]);
var inst_47302__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47301__$1,(0),null);
var inst_47303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47301__$1,(1),null);
var inst_47304 = (inst_47302__$1 == null);
var state_47322__$1 = (function (){var statearr_47324 = state_47322;
(statearr_47324[(7)] = inst_47302__$1);

(statearr_47324[(9)] = inst_47303);

(statearr_47324[(8)] = inst_47301__$1);

return statearr_47324;
})();
if(cljs.core.truth_(inst_47304)){
var statearr_47325_49352 = state_47322__$1;
(statearr_47325_49352[(1)] = (8));

} else {
var statearr_47326_49354 = state_47322__$1;
(statearr_47326_49354[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47323 === (1))){
var inst_47291 = cljs.core.vec(chs);
var inst_47292 = inst_47291;
var state_47322__$1 = (function (){var statearr_47327 = state_47322;
(statearr_47327[(10)] = inst_47292);

return statearr_47327;
})();
var statearr_47328_49357 = state_47322__$1;
(statearr_47328_49357[(2)] = null);

(statearr_47328_49357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47323 === (4))){
var inst_47292 = (state_47322[(10)]);
var state_47322__$1 = state_47322;
return cljs.core.async.ioc_alts_BANG_(state_47322__$1,(7),inst_47292);
} else {
if((state_val_47323 === (6))){
var inst_47318 = (state_47322[(2)]);
var state_47322__$1 = state_47322;
var statearr_47331_49360 = state_47322__$1;
(statearr_47331_49360[(2)] = inst_47318);

(statearr_47331_49360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47323 === (3))){
var inst_47320 = (state_47322[(2)]);
var state_47322__$1 = state_47322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47322__$1,inst_47320);
} else {
if((state_val_47323 === (2))){
var inst_47292 = (state_47322[(10)]);
var inst_47294 = cljs.core.count(inst_47292);
var inst_47295 = (inst_47294 > (0));
var state_47322__$1 = state_47322;
if(cljs.core.truth_(inst_47295)){
var statearr_47333_49361 = state_47322__$1;
(statearr_47333_49361[(1)] = (4));

} else {
var statearr_47334_49362 = state_47322__$1;
(statearr_47334_49362[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47323 === (11))){
var inst_47292 = (state_47322[(10)]);
var inst_47311 = (state_47322[(2)]);
var tmp47332 = inst_47292;
var inst_47292__$1 = tmp47332;
var state_47322__$1 = (function (){var statearr_47339 = state_47322;
(statearr_47339[(11)] = inst_47311);

(statearr_47339[(10)] = inst_47292__$1);

return statearr_47339;
})();
var statearr_47340_49364 = state_47322__$1;
(statearr_47340_49364[(2)] = null);

(statearr_47340_49364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47323 === (9))){
var inst_47302 = (state_47322[(7)]);
var state_47322__$1 = state_47322;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47322__$1,(11),out,inst_47302);
} else {
if((state_val_47323 === (5))){
var inst_47316 = cljs.core.async.close_BANG_(out);
var state_47322__$1 = state_47322;
var statearr_47346_49369 = state_47322__$1;
(statearr_47346_49369[(2)] = inst_47316);

(statearr_47346_49369[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47323 === (10))){
var inst_47314 = (state_47322[(2)]);
var state_47322__$1 = state_47322;
var statearr_47347_49376 = state_47322__$1;
(statearr_47347_49376[(2)] = inst_47314);

(statearr_47347_49376[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47323 === (8))){
var inst_47302 = (state_47322[(7)]);
var inst_47303 = (state_47322[(9)]);
var inst_47301 = (state_47322[(8)]);
var inst_47292 = (state_47322[(10)]);
var inst_47306 = (function (){var cs = inst_47292;
var vec__47297 = inst_47301;
var v = inst_47302;
var c = inst_47303;
return (function (p1__47288_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__47288_SHARP_);
});
})();
var inst_47307 = cljs.core.filterv(inst_47306,inst_47292);
var inst_47292__$1 = inst_47307;
var state_47322__$1 = (function (){var statearr_47356 = state_47322;
(statearr_47356[(10)] = inst_47292__$1);

return statearr_47356;
})();
var statearr_47357_49378 = state_47322__$1;
(statearr_47357_49378[(2)] = null);

(statearr_47357_49378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_47361 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47361[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_47361[(1)] = (1));

return statearr_47361;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_47322){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_47322);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e47363){var ex__44696__auto__ = e47363;
var statearr_47364_49379 = state_47322;
(statearr_47364_49379[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_47322[(4)]))){
var statearr_47365_49380 = state_47322;
(statearr_47365_49380[(1)] = cljs.core.first((state_47322[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49381 = state_47322;
state_47322 = G__49381;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_47322){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_47322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_47370 = f__44856__auto__();
(statearr_47370[(6)] = c__44855__auto___49348);

return statearr_47370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__47377 = arguments.length;
switch (G__47377) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44855__auto___49386 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_47413){
var state_val_47414 = (state_47413[(1)]);
if((state_val_47414 === (7))){
var inst_47391 = (state_47413[(7)]);
var inst_47391__$1 = (state_47413[(2)]);
var inst_47392 = (inst_47391__$1 == null);
var inst_47393 = cljs.core.not(inst_47392);
var state_47413__$1 = (function (){var statearr_47419 = state_47413;
(statearr_47419[(7)] = inst_47391__$1);

return statearr_47419;
})();
if(inst_47393){
var statearr_47420_49391 = state_47413__$1;
(statearr_47420_49391[(1)] = (8));

} else {
var statearr_47424_49392 = state_47413__$1;
(statearr_47424_49392[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47414 === (1))){
var inst_47386 = (0);
var state_47413__$1 = (function (){var statearr_47426 = state_47413;
(statearr_47426[(8)] = inst_47386);

return statearr_47426;
})();
var statearr_47427_49394 = state_47413__$1;
(statearr_47427_49394[(2)] = null);

(statearr_47427_49394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47414 === (4))){
var state_47413__$1 = state_47413;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47413__$1,(7),ch);
} else {
if((state_val_47414 === (6))){
var inst_47407 = (state_47413[(2)]);
var state_47413__$1 = state_47413;
var statearr_47429_49395 = state_47413__$1;
(statearr_47429_49395[(2)] = inst_47407);

(statearr_47429_49395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47414 === (3))){
var inst_47409 = (state_47413[(2)]);
var inst_47410 = cljs.core.async.close_BANG_(out);
var state_47413__$1 = (function (){var statearr_47430 = state_47413;
(statearr_47430[(9)] = inst_47409);

return statearr_47430;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47413__$1,inst_47410);
} else {
if((state_val_47414 === (2))){
var inst_47386 = (state_47413[(8)]);
var inst_47388 = (inst_47386 < n);
var state_47413__$1 = state_47413;
if(cljs.core.truth_(inst_47388)){
var statearr_47431_49396 = state_47413__$1;
(statearr_47431_49396[(1)] = (4));

} else {
var statearr_47432_49398 = state_47413__$1;
(statearr_47432_49398[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47414 === (11))){
var inst_47386 = (state_47413[(8)]);
var inst_47396 = (state_47413[(2)]);
var inst_47400 = (inst_47386 + (1));
var inst_47386__$1 = inst_47400;
var state_47413__$1 = (function (){var statearr_47437 = state_47413;
(statearr_47437[(8)] = inst_47386__$1);

(statearr_47437[(10)] = inst_47396);

return statearr_47437;
})();
var statearr_47438_49400 = state_47413__$1;
(statearr_47438_49400[(2)] = null);

(statearr_47438_49400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47414 === (9))){
var state_47413__$1 = state_47413;
var statearr_47443_49401 = state_47413__$1;
(statearr_47443_49401[(2)] = null);

(statearr_47443_49401[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47414 === (5))){
var state_47413__$1 = state_47413;
var statearr_47444_49402 = state_47413__$1;
(statearr_47444_49402[(2)] = null);

(statearr_47444_49402[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47414 === (10))){
var inst_47404 = (state_47413[(2)]);
var state_47413__$1 = state_47413;
var statearr_47445_49403 = state_47413__$1;
(statearr_47445_49403[(2)] = inst_47404);

(statearr_47445_49403[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47414 === (8))){
var inst_47391 = (state_47413[(7)]);
var state_47413__$1 = state_47413;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47413__$1,(11),out,inst_47391);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_47450 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47450[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_47450[(1)] = (1));

return statearr_47450;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_47413){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_47413);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e47455){var ex__44696__auto__ = e47455;
var statearr_47456_49404 = state_47413;
(statearr_47456_49404[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_47413[(4)]))){
var statearr_47457_49407 = state_47413;
(statearr_47457_49407[(1)] = cljs.core.first((state_47413[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49408 = state_47413;
state_47413 = G__49408;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_47413){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_47413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_47462 = f__44856__auto__();
(statearr_47462[(6)] = c__44855__auto___49386);

return statearr_47462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47465 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47465 = (function (f,ch,meta47466){
this.f = f;
this.ch = ch;
this.meta47466 = meta47466;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47467,meta47466__$1){
var self__ = this;
var _47467__$1 = this;
return (new cljs.core.async.t_cljs$core$async47465(self__.f,self__.ch,meta47466__$1));
}));

(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47467){
var self__ = this;
var _47467__$1 = this;
return self__.meta47466;
}));

(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47480 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47480 = (function (f,ch,meta47466,_,fn1,meta47481){
this.f = f;
this.ch = ch;
this.meta47466 = meta47466;
this._ = _;
this.fn1 = fn1;
this.meta47481 = meta47481;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47482,meta47481__$1){
var self__ = this;
var _47482__$1 = this;
return (new cljs.core.async.t_cljs$core$async47480(self__.f,self__.ch,self__.meta47466,self__._,self__.fn1,meta47481__$1));
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47482){
var self__ = this;
var _47482__$1 = this;
return self__.meta47481;
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47480.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__47463_SHARP_){
var G__47491 = (((p1__47463_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__47463_SHARP_) : self__.f.call(null,p1__47463_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__47491) : f1.call(null,G__47491));
});
}));

(cljs.core.async.t_cljs$core$async47480.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47466","meta47466",-1784198905,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async47465","cljs.core.async/t_cljs$core$async47465",1236293891,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta47481","meta47481",1124401078,null)], null);
}));

(cljs.core.async.t_cljs$core$async47480.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47480.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47480");

(cljs.core.async.t_cljs$core$async47480.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47480");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47480.
 */
cljs.core.async.__GT_t_cljs$core$async47480 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47480(f__$1,ch__$1,meta47466__$1,___$2,fn1__$1,meta47481){
return (new cljs.core.async.t_cljs$core$async47480(f__$1,ch__$1,meta47466__$1,___$2,fn1__$1,meta47481));
});

}

return (new cljs.core.async.t_cljs$core$async47480(self__.f,self__.ch,self__.meta47466,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__47497 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__47497) : self__.f.call(null,G__47497));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47465.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async47465.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47466","meta47466",-1784198905,null)], null);
}));

(cljs.core.async.t_cljs$core$async47465.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47465.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47465");

(cljs.core.async.t_cljs$core$async47465.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47465");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47465.
 */
cljs.core.async.__GT_t_cljs$core$async47465 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47465(f__$1,ch__$1,meta47466){
return (new cljs.core.async.t_cljs$core$async47465(f__$1,ch__$1,meta47466));
});

}

return (new cljs.core.async.t_cljs$core$async47465(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47500 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47500 = (function (f,ch,meta47501){
this.f = f;
this.ch = ch;
this.meta47501 = meta47501;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47500.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47502,meta47501__$1){
var self__ = this;
var _47502__$1 = this;
return (new cljs.core.async.t_cljs$core$async47500(self__.f,self__.ch,meta47501__$1));
}));

(cljs.core.async.t_cljs$core$async47500.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47502){
var self__ = this;
var _47502__$1 = this;
return self__.meta47501;
}));

(cljs.core.async.t_cljs$core$async47500.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47500.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47500.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47500.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47500.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47500.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async47500.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47501","meta47501",727436035,null)], null);
}));

(cljs.core.async.t_cljs$core$async47500.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47500.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47500");

(cljs.core.async.t_cljs$core$async47500.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47500");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47500.
 */
cljs.core.async.__GT_t_cljs$core$async47500 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async47500(f__$1,ch__$1,meta47501){
return (new cljs.core.async.t_cljs$core$async47500(f__$1,ch__$1,meta47501));
});

}

return (new cljs.core.async.t_cljs$core$async47500(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47504 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47504 = (function (p,ch,meta47505){
this.p = p;
this.ch = ch;
this.meta47505 = meta47505;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47506,meta47505__$1){
var self__ = this;
var _47506__$1 = this;
return (new cljs.core.async.t_cljs$core$async47504(self__.p,self__.ch,meta47505__$1));
}));

(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47506){
var self__ = this;
var _47506__$1 = this;
return self__.meta47505;
}));

(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47504.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async47504.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47505","meta47505",1784624793,null)], null);
}));

(cljs.core.async.t_cljs$core$async47504.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47504.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47504");

(cljs.core.async.t_cljs$core$async47504.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47504");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47504.
 */
cljs.core.async.__GT_t_cljs$core$async47504 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async47504(p__$1,ch__$1,meta47505){
return (new cljs.core.async.t_cljs$core$async47504(p__$1,ch__$1,meta47505));
});

}

return (new cljs.core.async.t_cljs$core$async47504(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__47518 = arguments.length;
switch (G__47518) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44855__auto___49432 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_47541){
var state_val_47542 = (state_47541[(1)]);
if((state_val_47542 === (7))){
var inst_47537 = (state_47541[(2)]);
var state_47541__$1 = state_47541;
var statearr_47545_49433 = state_47541__$1;
(statearr_47545_49433[(2)] = inst_47537);

(statearr_47545_49433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47542 === (1))){
var state_47541__$1 = state_47541;
var statearr_47546_49434 = state_47541__$1;
(statearr_47546_49434[(2)] = null);

(statearr_47546_49434[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47542 === (4))){
var inst_47523 = (state_47541[(7)]);
var inst_47523__$1 = (state_47541[(2)]);
var inst_47524 = (inst_47523__$1 == null);
var state_47541__$1 = (function (){var statearr_47547 = state_47541;
(statearr_47547[(7)] = inst_47523__$1);

return statearr_47547;
})();
if(cljs.core.truth_(inst_47524)){
var statearr_47548_49437 = state_47541__$1;
(statearr_47548_49437[(1)] = (5));

} else {
var statearr_47549_49438 = state_47541__$1;
(statearr_47549_49438[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47542 === (6))){
var inst_47523 = (state_47541[(7)]);
var inst_47528 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47523) : p.call(null,inst_47523));
var state_47541__$1 = state_47541;
if(cljs.core.truth_(inst_47528)){
var statearr_47551_49443 = state_47541__$1;
(statearr_47551_49443[(1)] = (8));

} else {
var statearr_47552_49444 = state_47541__$1;
(statearr_47552_49444[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47542 === (3))){
var inst_47539 = (state_47541[(2)]);
var state_47541__$1 = state_47541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47541__$1,inst_47539);
} else {
if((state_val_47542 === (2))){
var state_47541__$1 = state_47541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47541__$1,(4),ch);
} else {
if((state_val_47542 === (11))){
var inst_47531 = (state_47541[(2)]);
var state_47541__$1 = state_47541;
var statearr_47555_49447 = state_47541__$1;
(statearr_47555_49447[(2)] = inst_47531);

(statearr_47555_49447[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47542 === (9))){
var state_47541__$1 = state_47541;
var statearr_47558_49451 = state_47541__$1;
(statearr_47558_49451[(2)] = null);

(statearr_47558_49451[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47542 === (5))){
var inst_47526 = cljs.core.async.close_BANG_(out);
var state_47541__$1 = state_47541;
var statearr_47559_49453 = state_47541__$1;
(statearr_47559_49453[(2)] = inst_47526);

(statearr_47559_49453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47542 === (10))){
var inst_47534 = (state_47541[(2)]);
var state_47541__$1 = (function (){var statearr_47560 = state_47541;
(statearr_47560[(8)] = inst_47534);

return statearr_47560;
})();
var statearr_47561_49455 = state_47541__$1;
(statearr_47561_49455[(2)] = null);

(statearr_47561_49455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47542 === (8))){
var inst_47523 = (state_47541[(7)]);
var state_47541__$1 = state_47541;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47541__$1,(11),out,inst_47523);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_47562 = [null,null,null,null,null,null,null,null,null];
(statearr_47562[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_47562[(1)] = (1));

return statearr_47562;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_47541){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_47541);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e47565){var ex__44696__auto__ = e47565;
var statearr_47566_49457 = state_47541;
(statearr_47566_49457[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_47541[(4)]))){
var statearr_47571_49458 = state_47541;
(statearr_47571_49458[(1)] = cljs.core.first((state_47541[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49459 = state_47541;
state_47541 = G__49459;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_47541){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_47541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_47572 = f__44856__auto__();
(statearr_47572[(6)] = c__44855__auto___49432);

return statearr_47572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__47579 = arguments.length;
switch (G__47579) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__44855__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_47654){
var state_val_47658 = (state_47654[(1)]);
if((state_val_47658 === (7))){
var inst_47649 = (state_47654[(2)]);
var state_47654__$1 = state_47654;
var statearr_47661_49469 = state_47654__$1;
(statearr_47661_49469[(2)] = inst_47649);

(statearr_47661_49469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (20))){
var inst_47615 = (state_47654[(7)]);
var inst_47629 = (state_47654[(2)]);
var inst_47630 = cljs.core.next(inst_47615);
var inst_47600 = inst_47630;
var inst_47601 = null;
var inst_47602 = (0);
var inst_47603 = (0);
var state_47654__$1 = (function (){var statearr_47669 = state_47654;
(statearr_47669[(8)] = inst_47629);

(statearr_47669[(9)] = inst_47602);

(statearr_47669[(10)] = inst_47600);

(statearr_47669[(11)] = inst_47601);

(statearr_47669[(12)] = inst_47603);

return statearr_47669;
})();
var statearr_47676_49471 = state_47654__$1;
(statearr_47676_49471[(2)] = null);

(statearr_47676_49471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (1))){
var state_47654__$1 = state_47654;
var statearr_47677_49472 = state_47654__$1;
(statearr_47677_49472[(2)] = null);

(statearr_47677_49472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (4))){
var inst_47587 = (state_47654[(13)]);
var inst_47587__$1 = (state_47654[(2)]);
var inst_47589 = (inst_47587__$1 == null);
var state_47654__$1 = (function (){var statearr_47684 = state_47654;
(statearr_47684[(13)] = inst_47587__$1);

return statearr_47684;
})();
if(cljs.core.truth_(inst_47589)){
var statearr_47685_49474 = state_47654__$1;
(statearr_47685_49474[(1)] = (5));

} else {
var statearr_47686_49476 = state_47654__$1;
(statearr_47686_49476[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (15))){
var state_47654__$1 = state_47654;
var statearr_47690_49477 = state_47654__$1;
(statearr_47690_49477[(2)] = null);

(statearr_47690_49477[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (21))){
var state_47654__$1 = state_47654;
var statearr_47692_49479 = state_47654__$1;
(statearr_47692_49479[(2)] = null);

(statearr_47692_49479[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (13))){
var inst_47602 = (state_47654[(9)]);
var inst_47600 = (state_47654[(10)]);
var inst_47601 = (state_47654[(11)]);
var inst_47603 = (state_47654[(12)]);
var inst_47610 = (state_47654[(2)]);
var inst_47612 = (inst_47603 + (1));
var tmp47687 = inst_47602;
var tmp47688 = inst_47600;
var tmp47689 = inst_47601;
var inst_47600__$1 = tmp47688;
var inst_47601__$1 = tmp47689;
var inst_47602__$1 = tmp47687;
var inst_47603__$1 = inst_47612;
var state_47654__$1 = (function (){var statearr_47700 = state_47654;
(statearr_47700[(9)] = inst_47602__$1);

(statearr_47700[(10)] = inst_47600__$1);

(statearr_47700[(11)] = inst_47601__$1);

(statearr_47700[(14)] = inst_47610);

(statearr_47700[(12)] = inst_47603__$1);

return statearr_47700;
})();
var statearr_47704_49481 = state_47654__$1;
(statearr_47704_49481[(2)] = null);

(statearr_47704_49481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (22))){
var state_47654__$1 = state_47654;
var statearr_47709_49483 = state_47654__$1;
(statearr_47709_49483[(2)] = null);

(statearr_47709_49483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (6))){
var inst_47587 = (state_47654[(13)]);
var inst_47598 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47587) : f.call(null,inst_47587));
var inst_47599 = cljs.core.seq(inst_47598);
var inst_47600 = inst_47599;
var inst_47601 = null;
var inst_47602 = (0);
var inst_47603 = (0);
var state_47654__$1 = (function (){var statearr_47716 = state_47654;
(statearr_47716[(9)] = inst_47602);

(statearr_47716[(10)] = inst_47600);

(statearr_47716[(11)] = inst_47601);

(statearr_47716[(12)] = inst_47603);

return statearr_47716;
})();
var statearr_47717_49485 = state_47654__$1;
(statearr_47717_49485[(2)] = null);

(statearr_47717_49485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (17))){
var inst_47615 = (state_47654[(7)]);
var inst_47622 = cljs.core.chunk_first(inst_47615);
var inst_47623 = cljs.core.chunk_rest(inst_47615);
var inst_47624 = cljs.core.count(inst_47622);
var inst_47600 = inst_47623;
var inst_47601 = inst_47622;
var inst_47602 = inst_47624;
var inst_47603 = (0);
var state_47654__$1 = (function (){var statearr_47718 = state_47654;
(statearr_47718[(9)] = inst_47602);

(statearr_47718[(10)] = inst_47600);

(statearr_47718[(11)] = inst_47601);

(statearr_47718[(12)] = inst_47603);

return statearr_47718;
})();
var statearr_47719_49488 = state_47654__$1;
(statearr_47719_49488[(2)] = null);

(statearr_47719_49488[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (3))){
var inst_47651 = (state_47654[(2)]);
var state_47654__$1 = state_47654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47654__$1,inst_47651);
} else {
if((state_val_47658 === (12))){
var inst_47638 = (state_47654[(2)]);
var state_47654__$1 = state_47654;
var statearr_47720_49489 = state_47654__$1;
(statearr_47720_49489[(2)] = inst_47638);

(statearr_47720_49489[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (2))){
var state_47654__$1 = state_47654;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47654__$1,(4),in$);
} else {
if((state_val_47658 === (23))){
var inst_47646 = (state_47654[(2)]);
var state_47654__$1 = state_47654;
var statearr_47728_49492 = state_47654__$1;
(statearr_47728_49492[(2)] = inst_47646);

(statearr_47728_49492[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (19))){
var inst_47633 = (state_47654[(2)]);
var state_47654__$1 = state_47654;
var statearr_47729_49493 = state_47654__$1;
(statearr_47729_49493[(2)] = inst_47633);

(statearr_47729_49493[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (11))){
var inst_47600 = (state_47654[(10)]);
var inst_47615 = (state_47654[(7)]);
var inst_47615__$1 = cljs.core.seq(inst_47600);
var state_47654__$1 = (function (){var statearr_47730 = state_47654;
(statearr_47730[(7)] = inst_47615__$1);

return statearr_47730;
})();
if(inst_47615__$1){
var statearr_47731_49495 = state_47654__$1;
(statearr_47731_49495[(1)] = (14));

} else {
var statearr_47732_49496 = state_47654__$1;
(statearr_47732_49496[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (9))){
var inst_47640 = (state_47654[(2)]);
var inst_47641 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_47654__$1 = (function (){var statearr_47733 = state_47654;
(statearr_47733[(15)] = inst_47640);

return statearr_47733;
})();
if(cljs.core.truth_(inst_47641)){
var statearr_47734_49503 = state_47654__$1;
(statearr_47734_49503[(1)] = (21));

} else {
var statearr_47735_49504 = state_47654__$1;
(statearr_47735_49504[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (5))){
var inst_47591 = cljs.core.async.close_BANG_(out);
var state_47654__$1 = state_47654;
var statearr_47736_49505 = state_47654__$1;
(statearr_47736_49505[(2)] = inst_47591);

(statearr_47736_49505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (14))){
var inst_47615 = (state_47654[(7)]);
var inst_47617 = cljs.core.chunked_seq_QMARK_(inst_47615);
var state_47654__$1 = state_47654;
if(inst_47617){
var statearr_47737_49506 = state_47654__$1;
(statearr_47737_49506[(1)] = (17));

} else {
var statearr_47738_49507 = state_47654__$1;
(statearr_47738_49507[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (16))){
var inst_47636 = (state_47654[(2)]);
var state_47654__$1 = state_47654;
var statearr_47739_49510 = state_47654__$1;
(statearr_47739_49510[(2)] = inst_47636);

(statearr_47739_49510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47658 === (10))){
var inst_47601 = (state_47654[(11)]);
var inst_47603 = (state_47654[(12)]);
var inst_47608 = cljs.core._nth(inst_47601,inst_47603);
var state_47654__$1 = state_47654;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47654__$1,(13),out,inst_47608);
} else {
if((state_val_47658 === (18))){
var inst_47615 = (state_47654[(7)]);
var inst_47627 = cljs.core.first(inst_47615);
var state_47654__$1 = state_47654;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47654__$1,(20),out,inst_47627);
} else {
if((state_val_47658 === (8))){
var inst_47602 = (state_47654[(9)]);
var inst_47603 = (state_47654[(12)]);
var inst_47605 = (inst_47603 < inst_47602);
var inst_47606 = inst_47605;
var state_47654__$1 = state_47654;
if(cljs.core.truth_(inst_47606)){
var statearr_47741_49516 = state_47654__$1;
(statearr_47741_49516[(1)] = (10));

} else {
var statearr_47742_49517 = state_47654__$1;
(statearr_47742_49517[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__44693__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__44693__auto____0 = (function (){
var statearr_47746 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47746[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__44693__auto__);

(statearr_47746[(1)] = (1));

return statearr_47746;
});
var cljs$core$async$mapcat_STAR__$_state_machine__44693__auto____1 = (function (state_47654){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_47654);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e47747){var ex__44696__auto__ = e47747;
var statearr_47750_49520 = state_47654;
(statearr_47750_49520[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_47654[(4)]))){
var statearr_47751_49522 = state_47654;
(statearr_47751_49522[(1)] = cljs.core.first((state_47654[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49524 = state_47654;
state_47654 = G__49524;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__44693__auto__ = function(state_47654){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__44693__auto____1.call(this,state_47654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__44693__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__44693__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_47752 = f__44856__auto__();
(statearr_47752[(6)] = c__44855__auto__);

return statearr_47752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));

return c__44855__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__47756 = arguments.length;
switch (G__47756) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__47758 = arguments.length;
switch (G__47758) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__47760 = arguments.length;
switch (G__47760) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44855__auto___49537 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_47787){
var state_val_47788 = (state_47787[(1)]);
if((state_val_47788 === (7))){
var inst_47782 = (state_47787[(2)]);
var state_47787__$1 = state_47787;
var statearr_47793_49539 = state_47787__$1;
(statearr_47793_49539[(2)] = inst_47782);

(statearr_47793_49539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47788 === (1))){
var inst_47763 = null;
var state_47787__$1 = (function (){var statearr_47794 = state_47787;
(statearr_47794[(7)] = inst_47763);

return statearr_47794;
})();
var statearr_47795_49541 = state_47787__$1;
(statearr_47795_49541[(2)] = null);

(statearr_47795_49541[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47788 === (4))){
var inst_47766 = (state_47787[(8)]);
var inst_47766__$1 = (state_47787[(2)]);
var inst_47767 = (inst_47766__$1 == null);
var inst_47768 = cljs.core.not(inst_47767);
var state_47787__$1 = (function (){var statearr_47797 = state_47787;
(statearr_47797[(8)] = inst_47766__$1);

return statearr_47797;
})();
if(inst_47768){
var statearr_47798_49549 = state_47787__$1;
(statearr_47798_49549[(1)] = (5));

} else {
var statearr_47799_49550 = state_47787__$1;
(statearr_47799_49550[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47788 === (6))){
var state_47787__$1 = state_47787;
var statearr_47800_49551 = state_47787__$1;
(statearr_47800_49551[(2)] = null);

(statearr_47800_49551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47788 === (3))){
var inst_47784 = (state_47787[(2)]);
var inst_47785 = cljs.core.async.close_BANG_(out);
var state_47787__$1 = (function (){var statearr_47801 = state_47787;
(statearr_47801[(9)] = inst_47784);

return statearr_47801;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47787__$1,inst_47785);
} else {
if((state_val_47788 === (2))){
var state_47787__$1 = state_47787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47787__$1,(4),ch);
} else {
if((state_val_47788 === (11))){
var inst_47766 = (state_47787[(8)]);
var inst_47775 = (state_47787[(2)]);
var inst_47763 = inst_47766;
var state_47787__$1 = (function (){var statearr_47802 = state_47787;
(statearr_47802[(7)] = inst_47763);

(statearr_47802[(10)] = inst_47775);

return statearr_47802;
})();
var statearr_47803_49554 = state_47787__$1;
(statearr_47803_49554[(2)] = null);

(statearr_47803_49554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47788 === (9))){
var inst_47766 = (state_47787[(8)]);
var state_47787__$1 = state_47787;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47787__$1,(11),out,inst_47766);
} else {
if((state_val_47788 === (5))){
var inst_47766 = (state_47787[(8)]);
var inst_47763 = (state_47787[(7)]);
var inst_47770 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47766,inst_47763);
var state_47787__$1 = state_47787;
if(inst_47770){
var statearr_47805_49557 = state_47787__$1;
(statearr_47805_49557[(1)] = (8));

} else {
var statearr_47806_49559 = state_47787__$1;
(statearr_47806_49559[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47788 === (10))){
var inst_47779 = (state_47787[(2)]);
var state_47787__$1 = state_47787;
var statearr_47807_49562 = state_47787__$1;
(statearr_47807_49562[(2)] = inst_47779);

(statearr_47807_49562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47788 === (8))){
var inst_47763 = (state_47787[(7)]);
var tmp47804 = inst_47763;
var inst_47763__$1 = tmp47804;
var state_47787__$1 = (function (){var statearr_47808 = state_47787;
(statearr_47808[(7)] = inst_47763__$1);

return statearr_47808;
})();
var statearr_47809_49563 = state_47787__$1;
(statearr_47809_49563[(2)] = null);

(statearr_47809_49563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_47810 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47810[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_47810[(1)] = (1));

return statearr_47810;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_47787){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_47787);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e47812){var ex__44696__auto__ = e47812;
var statearr_47813_49566 = state_47787;
(statearr_47813_49566[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_47787[(4)]))){
var statearr_47814_49567 = state_47787;
(statearr_47814_49567[(1)] = cljs.core.first((state_47787[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49568 = state_47787;
state_47787 = G__49568;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_47787){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_47787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_47815 = f__44856__auto__();
(statearr_47815[(6)] = c__44855__auto___49537);

return statearr_47815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__47825 = arguments.length;
switch (G__47825) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44855__auto___49574 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_47873){
var state_val_47874 = (state_47873[(1)]);
if((state_val_47874 === (7))){
var inst_47865 = (state_47873[(2)]);
var state_47873__$1 = state_47873;
var statearr_47875_49579 = state_47873__$1;
(statearr_47875_49579[(2)] = inst_47865);

(statearr_47875_49579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (1))){
var inst_47830 = (new Array(n));
var inst_47831 = inst_47830;
var inst_47832 = (0);
var state_47873__$1 = (function (){var statearr_47876 = state_47873;
(statearr_47876[(7)] = inst_47831);

(statearr_47876[(8)] = inst_47832);

return statearr_47876;
})();
var statearr_47877_49586 = state_47873__$1;
(statearr_47877_49586[(2)] = null);

(statearr_47877_49586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (4))){
var inst_47835 = (state_47873[(9)]);
var inst_47835__$1 = (state_47873[(2)]);
var inst_47837 = (inst_47835__$1 == null);
var inst_47838 = cljs.core.not(inst_47837);
var state_47873__$1 = (function (){var statearr_47878 = state_47873;
(statearr_47878[(9)] = inst_47835__$1);

return statearr_47878;
})();
if(inst_47838){
var statearr_47879_49589 = state_47873__$1;
(statearr_47879_49589[(1)] = (5));

} else {
var statearr_47883_49590 = state_47873__$1;
(statearr_47883_49590[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (15))){
var inst_47859 = (state_47873[(2)]);
var state_47873__$1 = state_47873;
var statearr_47884_49591 = state_47873__$1;
(statearr_47884_49591[(2)] = inst_47859);

(statearr_47884_49591[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (13))){
var state_47873__$1 = state_47873;
var statearr_47885_49592 = state_47873__$1;
(statearr_47885_49592[(2)] = null);

(statearr_47885_49592[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (6))){
var inst_47832 = (state_47873[(8)]);
var inst_47855 = (inst_47832 > (0));
var state_47873__$1 = state_47873;
if(cljs.core.truth_(inst_47855)){
var statearr_47886_49593 = state_47873__$1;
(statearr_47886_49593[(1)] = (12));

} else {
var statearr_47887_49594 = state_47873__$1;
(statearr_47887_49594[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (3))){
var inst_47867 = (state_47873[(2)]);
var state_47873__$1 = state_47873;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47873__$1,inst_47867);
} else {
if((state_val_47874 === (12))){
var inst_47831 = (state_47873[(7)]);
var inst_47857 = cljs.core.vec(inst_47831);
var state_47873__$1 = state_47873;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47873__$1,(15),out,inst_47857);
} else {
if((state_val_47874 === (2))){
var state_47873__$1 = state_47873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47873__$1,(4),ch);
} else {
if((state_val_47874 === (11))){
var inst_47849 = (state_47873[(2)]);
var inst_47850 = (new Array(n));
var inst_47831 = inst_47850;
var inst_47832 = (0);
var state_47873__$1 = (function (){var statearr_47888 = state_47873;
(statearr_47888[(7)] = inst_47831);

(statearr_47888[(8)] = inst_47832);

(statearr_47888[(10)] = inst_47849);

return statearr_47888;
})();
var statearr_47889_49596 = state_47873__$1;
(statearr_47889_49596[(2)] = null);

(statearr_47889_49596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (9))){
var inst_47831 = (state_47873[(7)]);
var inst_47847 = cljs.core.vec(inst_47831);
var state_47873__$1 = state_47873;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47873__$1,(11),out,inst_47847);
} else {
if((state_val_47874 === (5))){
var inst_47835 = (state_47873[(9)]);
var inst_47841 = (state_47873[(11)]);
var inst_47831 = (state_47873[(7)]);
var inst_47832 = (state_47873[(8)]);
var inst_47840 = (inst_47831[inst_47832] = inst_47835);
var inst_47841__$1 = (inst_47832 + (1));
var inst_47842 = (inst_47841__$1 < n);
var state_47873__$1 = (function (){var statearr_47891 = state_47873;
(statearr_47891[(11)] = inst_47841__$1);

(statearr_47891[(12)] = inst_47840);

return statearr_47891;
})();
if(cljs.core.truth_(inst_47842)){
var statearr_47895_49601 = state_47873__$1;
(statearr_47895_49601[(1)] = (8));

} else {
var statearr_47896_49603 = state_47873__$1;
(statearr_47896_49603[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (14))){
var inst_47862 = (state_47873[(2)]);
var inst_47863 = cljs.core.async.close_BANG_(out);
var state_47873__$1 = (function (){var statearr_47898 = state_47873;
(statearr_47898[(13)] = inst_47862);

return statearr_47898;
})();
var statearr_47899_49614 = state_47873__$1;
(statearr_47899_49614[(2)] = inst_47863);

(statearr_47899_49614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (10))){
var inst_47853 = (state_47873[(2)]);
var state_47873__$1 = state_47873;
var statearr_47900_49623 = state_47873__$1;
(statearr_47900_49623[(2)] = inst_47853);

(statearr_47900_49623[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47874 === (8))){
var inst_47841 = (state_47873[(11)]);
var inst_47831 = (state_47873[(7)]);
var tmp47897 = inst_47831;
var inst_47831__$1 = tmp47897;
var inst_47832 = inst_47841;
var state_47873__$1 = (function (){var statearr_47901 = state_47873;
(statearr_47901[(7)] = inst_47831__$1);

(statearr_47901[(8)] = inst_47832);

return statearr_47901;
})();
var statearr_47903_49628 = state_47873__$1;
(statearr_47903_49628[(2)] = null);

(statearr_47903_49628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_47907 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47907[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_47907[(1)] = (1));

return statearr_47907;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_47873){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_47873);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e47908){var ex__44696__auto__ = e47908;
var statearr_47909_49637 = state_47873;
(statearr_47909_49637[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_47873[(4)]))){
var statearr_47910_49639 = state_47873;
(statearr_47910_49639[(1)] = cljs.core.first((state_47873[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49644 = state_47873;
state_47873 = G__49644;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_47873){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_47873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_47911 = f__44856__auto__();
(statearr_47911[(6)] = c__44855__auto___49574);

return statearr_47911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__47914 = arguments.length;
switch (G__47914) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44855__auto___49674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_47971){
var state_val_47972 = (state_47971[(1)]);
if((state_val_47972 === (7))){
var inst_47967 = (state_47971[(2)]);
var state_47971__$1 = state_47971;
var statearr_47973_49689 = state_47971__$1;
(statearr_47973_49689[(2)] = inst_47967);

(statearr_47973_49689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (1))){
var inst_47918 = [];
var inst_47919 = inst_47918;
var inst_47920 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_47971__$1 = (function (){var statearr_47974 = state_47971;
(statearr_47974[(7)] = inst_47919);

(statearr_47974[(8)] = inst_47920);

return statearr_47974;
})();
var statearr_47975_49691 = state_47971__$1;
(statearr_47975_49691[(2)] = null);

(statearr_47975_49691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (4))){
var inst_47923 = (state_47971[(9)]);
var inst_47923__$1 = (state_47971[(2)]);
var inst_47924 = (inst_47923__$1 == null);
var inst_47925 = cljs.core.not(inst_47924);
var state_47971__$1 = (function (){var statearr_47976 = state_47971;
(statearr_47976[(9)] = inst_47923__$1);

return statearr_47976;
})();
if(inst_47925){
var statearr_47977_49693 = state_47971__$1;
(statearr_47977_49693[(1)] = (5));

} else {
var statearr_47978_49694 = state_47971__$1;
(statearr_47978_49694[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (15))){
var inst_47919 = (state_47971[(7)]);
var inst_47959 = cljs.core.vec(inst_47919);
var state_47971__$1 = state_47971;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47971__$1,(18),out,inst_47959);
} else {
if((state_val_47972 === (13))){
var inst_47948 = (state_47971[(2)]);
var state_47971__$1 = state_47971;
var statearr_47979_49704 = state_47971__$1;
(statearr_47979_49704[(2)] = inst_47948);

(statearr_47979_49704[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (6))){
var inst_47919 = (state_47971[(7)]);
var inst_47954 = inst_47919.length;
var inst_47955 = (inst_47954 > (0));
var state_47971__$1 = state_47971;
if(cljs.core.truth_(inst_47955)){
var statearr_47980_49706 = state_47971__$1;
(statearr_47980_49706[(1)] = (15));

} else {
var statearr_47981_49707 = state_47971__$1;
(statearr_47981_49707[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (17))){
var inst_47964 = (state_47971[(2)]);
var inst_47965 = cljs.core.async.close_BANG_(out);
var state_47971__$1 = (function (){var statearr_47982 = state_47971;
(statearr_47982[(10)] = inst_47964);

return statearr_47982;
})();
var statearr_47983_49710 = state_47971__$1;
(statearr_47983_49710[(2)] = inst_47965);

(statearr_47983_49710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (3))){
var inst_47969 = (state_47971[(2)]);
var state_47971__$1 = state_47971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47971__$1,inst_47969);
} else {
if((state_val_47972 === (12))){
var inst_47919 = (state_47971[(7)]);
var inst_47939 = cljs.core.vec(inst_47919);
var state_47971__$1 = state_47971;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47971__$1,(14),out,inst_47939);
} else {
if((state_val_47972 === (2))){
var state_47971__$1 = state_47971;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47971__$1,(4),ch);
} else {
if((state_val_47972 === (11))){
var inst_47923 = (state_47971[(9)]);
var inst_47919 = (state_47971[(7)]);
var inst_47927 = (state_47971[(11)]);
var inst_47936 = inst_47919.push(inst_47923);
var tmp47984 = inst_47919;
var inst_47919__$1 = tmp47984;
var inst_47920 = inst_47927;
var state_47971__$1 = (function (){var statearr_47987 = state_47971;
(statearr_47987[(7)] = inst_47919__$1);

(statearr_47987[(12)] = inst_47936);

(statearr_47987[(8)] = inst_47920);

return statearr_47987;
})();
var statearr_47988_49729 = state_47971__$1;
(statearr_47988_49729[(2)] = null);

(statearr_47988_49729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (9))){
var inst_47920 = (state_47971[(8)]);
var inst_47932 = cljs.core.keyword_identical_QMARK_(inst_47920,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_47971__$1 = state_47971;
var statearr_47991_49734 = state_47971__$1;
(statearr_47991_49734[(2)] = inst_47932);

(statearr_47991_49734[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (5))){
var inst_47923 = (state_47971[(9)]);
var inst_47927 = (state_47971[(11)]);
var inst_47920 = (state_47971[(8)]);
var inst_47928 = (state_47971[(13)]);
var inst_47927__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47923) : f.call(null,inst_47923));
var inst_47928__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47927__$1,inst_47920);
var state_47971__$1 = (function (){var statearr_47994 = state_47971;
(statearr_47994[(11)] = inst_47927__$1);

(statearr_47994[(13)] = inst_47928__$1);

return statearr_47994;
})();
if(inst_47928__$1){
var statearr_47995_49739 = state_47971__$1;
(statearr_47995_49739[(1)] = (8));

} else {
var statearr_47996_49741 = state_47971__$1;
(statearr_47996_49741[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (14))){
var inst_47923 = (state_47971[(9)]);
var inst_47927 = (state_47971[(11)]);
var inst_47941 = (state_47971[(2)]);
var inst_47943 = [];
var inst_47945 = inst_47943.push(inst_47923);
var inst_47919 = inst_47943;
var inst_47920 = inst_47927;
var state_47971__$1 = (function (){var statearr_47997 = state_47971;
(statearr_47997[(14)] = inst_47945);

(statearr_47997[(7)] = inst_47919);

(statearr_47997[(15)] = inst_47941);

(statearr_47997[(8)] = inst_47920);

return statearr_47997;
})();
var statearr_47998_49746 = state_47971__$1;
(statearr_47998_49746[(2)] = null);

(statearr_47998_49746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (16))){
var state_47971__$1 = state_47971;
var statearr_47999_49747 = state_47971__$1;
(statearr_47999_49747[(2)] = null);

(statearr_47999_49747[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (10))){
var inst_47934 = (state_47971[(2)]);
var state_47971__$1 = state_47971;
if(cljs.core.truth_(inst_47934)){
var statearr_48000_49749 = state_47971__$1;
(statearr_48000_49749[(1)] = (11));

} else {
var statearr_48001_49750 = state_47971__$1;
(statearr_48001_49750[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (18))){
var inst_47961 = (state_47971[(2)]);
var state_47971__$1 = state_47971;
var statearr_48002_49751 = state_47971__$1;
(statearr_48002_49751[(2)] = inst_47961);

(statearr_48002_49751[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47972 === (8))){
var inst_47928 = (state_47971[(13)]);
var state_47971__$1 = state_47971;
var statearr_48005_49756 = state_47971__$1;
(statearr_48005_49756[(2)] = inst_47928);

(statearr_48005_49756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44693__auto__ = null;
var cljs$core$async$state_machine__44693__auto____0 = (function (){
var statearr_48009 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48009[(0)] = cljs$core$async$state_machine__44693__auto__);

(statearr_48009[(1)] = (1));

return statearr_48009;
});
var cljs$core$async$state_machine__44693__auto____1 = (function (state_47971){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_47971);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e48011){var ex__44696__auto__ = e48011;
var statearr_48012_49758 = state_47971;
(statearr_48012_49758[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_47971[(4)]))){
var statearr_48013_49759 = state_47971;
(statearr_48013_49759[(1)] = cljs.core.first((state_47971[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49761 = state_47971;
state_47971 = G__49761;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
cljs$core$async$state_machine__44693__auto__ = function(state_47971){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44693__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44693__auto____1.call(this,state_47971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44693__auto____0;
cljs$core$async$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44693__auto____1;
return cljs$core$async$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_48014 = f__44856__auto__();
(statearr_48014[(6)] = c__44855__auto___49674);

return statearr_48014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
