goog.provide('com.fulcrologic.fulcro.dom');
goog.scope(function(){
  com.fulcrologic.fulcro.dom.goog$module$goog$object = goog.module.get('goog.object');
});





































































































































































































/**
 * Returns true if the given arg is a react element.
 */
com.fulcrologic.fulcro.dom.element_QMARK_ = (function com$fulcrologic$fulcro$dom$element_QMARK_(x){
return React.isValidElement(x);
});
com.fulcrologic.fulcro.dom.child__GT_typed_child = (function com$fulcrologic$fulcro$dom$child__GT_typed_child(child){
if(typeof child === 'string'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"string","string",-1989541586),child], null);
} else {
if(typeof child === 'number'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"number","number",1570378438),child], null);
} else {
if(((cljs.core.vector_QMARK_(child)) || (((cljs.core.seq_QMARK_(child)) || (cljs.core.array_QMARK_(child)))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"collection","collection",-683361892),child], null);
} else {
if((child == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nil","nil",99600501),child], null);
} else {
if(cljs.core.truth_(com.fulcrologic.fulcro.dom.element_QMARK_(child))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"element","element",1974019749),child], null);
} else {
return null;
}
}
}
}
}
});
/**
 * Runtime parsing of DOM tag arguments. Returns a map with keys :css, :attrs, and :children.
 */
com.fulcrologic.fulcro.dom.parse_args = (function com$fulcrologic$fulcro$dom$parse_args(args){
var parse_css = (function com$fulcrologic$fulcro$dom$parse_args_$_parse_css(p__66848){
var vec__66850 = p__66848;
var args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66850,(0),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66850,(1),null);
var pair = vec__66850;
var arg = cljs.core.first(args__$1);
if((arg instanceof cljs.core.Keyword)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.next(args__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"css","css",1135045163),arg)], null);
} else {
return pair;
}
});
var parse_attrs = (function com$fulcrologic$fulcro$dom$parse_args_$_parse_attrs(p__66855){
var vec__66856 = p__66855;
var args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66856,(0),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66856,(1),null);
var pair = vec__66856;
var has_arg_QMARK_ = cljs.core.seq(args__$1);
var arg = cljs.core.first(args__$1);
if(((has_arg_QMARK_) && ((arg == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.next(args__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nil","nil",99600501),null], null))], null);
} else {
if(((cljs.core.object_QMARK_(arg)) && (cljs.core.not(com.fulcrologic.fulcro.dom.element_QMARK_(arg))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.next(args__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-object","js-object",1830199158),arg], null))], null);
} else {
if(((cljs.core.map_QMARK_(arg)) && (cljs.core.not(com.fulcrologic.fulcro.dom.element_QMARK_(arg))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.next(args__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map","map",1371690461),arg], null))], null);
} else {
return pair;

}
}
}
});
var parse_children = (function com$fulcrologic$fulcro$dom$parse_args_$_parse_children(p__66859){
var vec__66860 = p__66859;
var args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66860,(0),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66860,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,(function (){var G__66863 = result;
if(cljs.core.seq(args__$1)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__66863,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(com.fulcrologic.fulcro.dom.child__GT_typed_child,args__$1));
} else {
return G__66863;
}
})()], null);
});
return cljs.core.second(parse_children(parse_attrs(parse_css(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [args,cljs.core.PersistentArrayMap.EMPTY], null)))));
});
/**
 * Equivalent to React.render
 */
com.fulcrologic.fulcro.dom.render = (function com$fulcrologic$fulcro$dom$render(component,el){
return ReactDOM.render(component,el);
});
/**
 * Equivalent to React.renderToString. NOTE: You must make sure js/ReactDOMServer is defined (e.g. require cljsjs.react.dom.server) to use this function.
 */
com.fulcrologic.fulcro.dom.render_to_str = (function com$fulcrologic$fulcro$dom$render_to_str(c){
return ReactDOMServer.renderToString(c);
});
/**
 * Returns the dom node associated with a component's React ref.
 */
com.fulcrologic.fulcro.dom.node = (function com$fulcrologic$fulcro$dom$node(var_args){
var G__66866 = arguments.length;
switch (G__66866) {
case 1:
return com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$1 = (function (component){
return ReactDOM.findDOMNode(component);
}));

(com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$2 = (function (component,name){
var G__66867 = component.refs;
var G__66867__$1 = (((G__66867 == null))?null:com.fulcrologic.fulcro.dom.goog$module$goog$object.get(G__66867,name));
if((G__66867__$1 == null)){
return null;
} else {
return ReactDOM.findDOMNode(G__66867__$1);
}
}));

(com.fulcrologic.fulcro.dom.node.cljs$lang$maxFixedArity = 2);

/**
 * React component that wraps dom/input to prevent cursor madness.
 */
com.fulcrologic.fulcro.dom.Input = com.fulcrologic.fulcro.dom.inputs.StringBufferedInput(new cljs.core.Keyword("com.fulcrologic.fulcro.dom","Input","com.fulcrologic.fulcro.dom/Input",-2041077839),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"string->model","string->model",-134531957),cljs.core.identity,new cljs.core.Keyword(null,"model->string","model->string",-2085451701),cljs.core.identity], null));
/**
 * A wrapped input. Use this when you see the cursor jump around while you're trying to type in an input. Drop-in replacement
 * for `dom/input`.
 * 
 * NOTE: The onChange and onBlur handlers will receive a string value, not an event. If you want the raw event on changes use onInput.
 */
com.fulcrologic.fulcro.dom.ui_input = (function (){var factory = com.fulcrologic.fulcro.components.factory.cljs$core$IFn$_invoke$arity$2(com.fulcrologic.fulcro.dom.Input,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword(null,"key","key",-1516042587)], null));
return (function (props){
var temp__5751__auto__ = new cljs.core.Keyword(null,"ref","ref",1289896967).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(temp__5751__auto__)){
var ref = temp__5751__auto__;
var G__66875 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(props,new cljs.core.Keyword(null,"ref","ref",1289896967),(function (r){
var G__66876 = (function (){var G__66877 = r;
if((G__66877 == null)){
return null;
} else {
return com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$1(G__66877);
}
})();
return (ref.cljs$core$IFn$_invoke$arity$1 ? ref.cljs$core$IFn$_invoke$arity$1(G__66876) : ref.call(null,G__66876));
}));
return (factory.cljs$core$IFn$_invoke$arity$1 ? factory.cljs$core$IFn$_invoke$arity$1(G__66875) : factory.call(null,G__66875));
} else {
return (factory.cljs$core$IFn$_invoke$arity$1 ? factory.cljs$core$IFn$_invoke$arity$1(props) : factory.call(null,props));
}
});
})();
/**
 * Create a DOM element for which there exists no corresponding function.
 * Useful to create DOM elements not included in React.DOM. Equivalent
 * to calling `js/React.createElement`
 */
com.fulcrologic.fulcro.dom.create_element = (function com$fulcrologic$fulcro$dom$create_element(var_args){
var G__66882 = arguments.length;
switch (G__66882) {
case 1:
return com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___69964 = arguments.length;
var i__4865__auto___69965 = (0);
while(true){
if((i__4865__auto___69965 < len__4864__auto___69964)){
args_arr__4885__auto__.push((arguments[i__4865__auto___69965]));

var G__69966 = (i__4865__auto___69965 + (1));
i__4865__auto___69965 = G__69966;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((2)),(0),null));
return com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4886__auto__);

}
});

(com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$2(tag,null);
}));

(com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag,opts){
return React.createElement(tag,opts);
}));

(com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$variadic = (function (tag,opts,children){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(React.createElement,tag,opts,children);
}));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.create_element.cljs$lang$applyTo = (function (seq66879){
var G__66880 = cljs.core.first(seq66879);
var seq66879__$1 = cljs.core.next(seq66879);
var G__66881 = cljs.core.first(seq66879__$1);
var seq66879__$2 = cljs.core.next(seq66879__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66880,G__66881,seq66879__$2);
}));

(com.fulcrologic.fulcro.dom.create_element.cljs$lang$maxFixedArity = (2));

/**
 * Given props, which can be nil, a js-obj or a clj map: returns a js object.
 */
com.fulcrologic.fulcro.dom.convert_props = (function com$fulcrologic$fulcro$dom$convert_props(props){
if((props == null)){
return ({});
} else {
if(cljs.core.map_QMARK_(props)){
return cljs.core.clj__GT_js(props);
} else {
return props;

}
}
});
/**
 * Used internally by the DOM element generation.
 */
com.fulcrologic.fulcro.dom.macro_create_element_STAR_ = (function com$fulcrologic$fulcro$dom$macro_create_element_STAR_(arr){
if(cljs.core.array_QMARK_(arr)){
} else {
throw (new Error("Assert failed: (array? arr)"));
}

return React.createElement.apply(null,arr);
});
/**
 * Updates the state of the wrapped input element.
 */
com.fulcrologic.fulcro.dom.update_state = (function com$fulcrologic$fulcro$dom$update_state(component,next_props,value){
var on_change = com.fulcrologic.fulcro.dom.goog$module$goog$object.getValueByKeys(component,"state","cached-props","onChange");
var next_state = ({});
var inputRef = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(next_props,"inputRef");
com.fulcrologic.fulcro.dom.goog$module$goog$object.extend(next_state,next_props,({"onChange": on_change}));

com.fulcrologic.fulcro.dom.goog$module$goog$object.set(next_state,"value",value);

if(cljs.core.truth_(inputRef)){
com.fulcrologic.fulcro.dom.goog$module$goog$object.remove(next_state,"inputRef");

com.fulcrologic.fulcro.dom.goog$module$goog$object.set(next_state,"ref",inputRef);
} else {
}

return component.setState(({"cached-props": next_state}));
});
if((typeof com !== 'undefined') && (typeof com.fulcrologic !== 'undefined') && (typeof com.fulcrologic.fulcro !== 'undefined') && (typeof com.fulcrologic.fulcro.dom !== 'undefined') && (typeof com.fulcrologic.fulcro.dom.form_elements_QMARK_ !== 'undefined')){
} else {
com.fulcrologic.fulcro.dom.form_elements_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["option",null,"select",null,"input",null,"textarea",null], null), null);
}
com.fulcrologic.fulcro.dom.is_form_element_QMARK_ = (function com$fulcrologic$fulcro$dom$is_form_element_QMARK_(element){
var tag = element.tagName;
var and__4251__auto__ = tag;
if(cljs.core.truth_(and__4251__auto__)){
var G__66889 = clojure.string.lower_case(tag);
return (com.fulcrologic.fulcro.dom.form_elements_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.dom.form_elements_QMARK_.cljs$core$IFn$_invoke$arity$1(G__66889) : com.fulcrologic.fulcro.dom.form_elements_QMARK_.call(null,G__66889));
} else {
return and__4251__auto__;
}
});
com.fulcrologic.fulcro.dom.wrap_form_element = (function com$fulcrologic$fulcro$dom$wrap_form_element(element){
var ctor = (function (props){
var this$ = this;
(this$.state = (function (){var state = ({"ref": com.fulcrologic.fulcro.dom.goog$module$goog$object.get(props,"inputRef")});
com.fulcrologic.fulcro.dom.goog$module$goog$object.extend(state,props,({"onChange": goog.bind(com.fulcrologic.fulcro.dom.goog$module$goog$object.get(this$,"onChange"),this$)}));

com.fulcrologic.fulcro.dom.goog$module$goog$object.remove(state,"inputRef");

return ({"cached-props": state});
})());

return React.Component.apply(this$,arguments);
});
(ctor.displayName = ["wrapped-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(element)].join(''));

goog.inherits(ctor,React.Component);

var x66900_69985 = ctor.prototype;
(x66900_69985.onChange = (function (event){
var this$ = this;
var temp__5753__auto__ = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(this$.props,"onChange");
if(cljs.core.truth_(temp__5753__auto__)){
var handler = temp__5753__auto__;
(handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(event) : handler.call(null,event));

return com.fulcrologic.fulcro.dom.update_state(this$,this$.props,com.fulcrologic.fulcro.dom.goog$module$goog$object.getValueByKeys(event,"target","value"));
} else {
return null;
}
}));

(x66900_69985.UNSAFE_componentWillReceiveProps = (function (new_props){
var this$ = this;
var state_value = com.fulcrologic.fulcro.dom.goog$module$goog$object.getValueByKeys(this$,"state","cached-props","value");
var this_node = ReactDOM.findDOMNode(this$);
var value_node = (cljs.core.truth_(com.fulcrologic.fulcro.dom.is_form_element_QMARK_(this_node))?this_node:goog.dom.findNode(this_node,(function (p1__66894_SHARP_){
return com.fulcrologic.fulcro.dom.is_form_element_QMARK_(p1__66894_SHARP_);
})));
var element_value = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(value_node,"value");
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core.truth_((function (){var and__4251__auto__ = state_value;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = element_value;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.type(state_value),cljs.core.type(element_value));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"com.fulcrologic.fulcro.dom",null,181,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["There is a mismatch for the data type of the value on an input with value ",element_value,". This will cause the input to miss refreshes. In general you should force the :value of an input to\n                be a string since that is how values are stored on most real DOM elements. See https://book.fulcrologic.com/#warn-dom-type-mismatch"], null);
}),null)),null,2020392417,null);
} else {
}
} else {
}

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(state_value,element_value)){
return com.fulcrologic.fulcro.dom.update_state(this$,new_props,element_value);
} else {
return com.fulcrologic.fulcro.dom.update_state(this$,new_props,com.fulcrologic.fulcro.dom.goog$module$goog$object.get(new_props,"value"));
}
}));

(x66900_69985.render = (function (){
var this$ = this;
return React.createElement(element,com.fulcrologic.fulcro.dom.goog$module$goog$object.getValueByKeys(this$,"state","cached-props"));
}));


var real_factory = (function() { 
var G__70002__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(React.createElement,ctor,args);
};
var G__70002 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__70003__i = 0, G__70003__a = new Array(arguments.length -  0);
while (G__70003__i < G__70003__a.length) {G__70003__a[G__70003__i] = arguments[G__70003__i + 0]; ++G__70003__i;}
  args = new cljs.core.IndexedSeq(G__70003__a,0,null);
} 
return G__70002__delegate.call(this,args);};
G__70002.cljs$lang$maxFixedArity = 0;
G__70002.cljs$lang$applyTo = (function (arglist__70004){
var args = cljs.core.seq(arglist__70004);
return G__70002__delegate(args);
});
G__70002.cljs$core$IFn$_invoke$arity$variadic = G__70002__delegate;
return G__70002;
})()
;
return (function() { 
var G__70005__delegate = function (props,children){
var t = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(props,"type");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,"file")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(React.createElement,"input",props,children);
} else {
var temp__5751__auto__ = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(props,"ref");
if(cljs.core.truth_(temp__5751__auto__)){
var r = temp__5751__auto__;
if(typeof r === 'string'){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(real_factory,props,children);
} else {
var p = ({});
com.fulcrologic.fulcro.dom.goog$module$goog$object.extend(p,props);

com.fulcrologic.fulcro.dom.goog$module$goog$object.set(p,"inputRef",r);

com.fulcrologic.fulcro.dom.goog$module$goog$object.remove(p,"ref");

return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(real_factory,p,children);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(real_factory,props,children);
}
}
};
var G__70005 = function (props,var_args){
var children = null;
if (arguments.length > 1) {
var G__70010__i = 0, G__70010__a = new Array(arguments.length -  1);
while (G__70010__i < G__70010__a.length) {G__70010__a[G__70010__i] = arguments[G__70010__i + 1]; ++G__70010__i;}
  children = new cljs.core.IndexedSeq(G__70010__a,0,null);
} 
return G__70005__delegate.call(this,props,children);};
G__70005.cljs$lang$maxFixedArity = 1;
G__70005.cljs$lang$applyTo = (function (arglist__70011){
var props = cljs.core.first(arglist__70011);
var children = cljs.core.rest(arglist__70011);
return G__70005__delegate(props,children);
});
G__70005.cljs$core$IFn$_invoke$arity$variadic = G__70005__delegate;
return G__70005;
})()
;
});
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
com.fulcrologic.fulcro.dom.wrapped_input = com.fulcrologic.fulcro.dom.wrap_form_element("input");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
com.fulcrologic.fulcro.dom.wrapped_textarea = com.fulcrologic.fulcro.dom.wrap_form_element("textarea");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
com.fulcrologic.fulcro.dom.wrapped_option = com.fulcrologic.fulcro.dom.wrap_form_element("option");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
com.fulcrologic.fulcro.dom.wrapped_select = com.fulcrologic.fulcro.dom.wrap_form_element("select");
com.fulcrologic.fulcro.dom.arr_append_STAR_ = (function com$fulcrologic$fulcro$dom$arr_append_STAR_(arr,x){
arr.push(x);

return arr;
});
com.fulcrologic.fulcro.dom.arr_append = (function com$fulcrologic$fulcro$dom$arr_append(arr,tail){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.arr_append_STAR_,arr,tail);
});
/**
 * Used internally by element generation.
 */
com.fulcrologic.fulcro.dom.macro_create_wrapped_form_element = (function com$fulcrologic$fulcro$dom$macro_create_wrapped_form_element(opts){
var tag = (opts[(0)]);
var props = (opts[(1)]);
var children = opts.splice((2));
var G__66931 = tag;
switch (G__66931) {
case "input":
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.wrapped_input,props,children);

break;
case "textarea":
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.wrapped_textarea,props,children);

break;
case "select":
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.wrapped_select,props,children);

break;
case "option":
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.wrapped_option,props,children);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__66931)].join('')));

}
});
/**
 * Runtime interpretation of props. Used internally by element generation when the macro cannot expand the element at compile time.
 */
com.fulcrologic.fulcro.dom.macro_create_element = (function com$fulcrologic$fulcro$dom$macro_create_element(var_args){
var G__66940 = arguments.length;
switch (G__66940) {
case 2:
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$2 = (function (type,args){
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3(type,args,null);
}));

(com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3 = (function (type,args,csskw){
var vec__66947 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(com.fulcrologic.fulcro.components.force_children,args);
var seq__66948 = cljs.core.seq(vec__66947);
var first__66949 = cljs.core.first(seq__66948);
var seq__66948__$1 = cljs.core.next(seq__66948);
var head = first__66949;
var tail = seq__66948__$1;
var f = (cljs.core.truth_((com.fulcrologic.fulcro.dom.form_elements_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.dom.form_elements_QMARK_.cljs$core$IFn$_invoke$arity$1(type) : com.fulcrologic.fulcro.dom.form_elements_QMARK_.call(null,type)))?com.fulcrologic.fulcro.dom.macro_create_wrapped_form_element:com.fulcrologic.fulcro.dom.macro_create_element_STAR_);
if((head == null)){
var G__66950 = (function (){var G__66951 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66951,tail);

return G__66951;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66950) : f.call(null,G__66950));
} else {
if(cljs.core.truth_(com.fulcrologic.fulcro.dom.element_QMARK_(head))){
var G__66952 = (function (){var G__66953 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66953,args);

return G__66953;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66952) : f.call(null,G__66952));
} else {
if(cljs.core.object_QMARK_(head)){
var G__66954 = (function (){var G__66955 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(head,csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66955,tail);

return G__66955;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66954) : f.call(null,G__66954));
} else {
if(cljs.core.map_QMARK_(head)){
var G__66956 = (function (){var G__66957 = [type,cljs.core.clj__GT_js(com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(com.fulcrologic.fulcro.dom_common.interpret_classes(head),csskw))];
com.fulcrologic.fulcro.dom.arr_append(G__66957,tail);

return G__66957;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66956) : f.call(null,G__66956));
} else {
var G__66958 = (function (){var G__66959 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66959,args);

return G__66959;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66958) : f.call(null,G__66958));

}
}
}
}
}));

(com.fulcrologic.fulcro.dom.macro_create_element.cljs$lang$maxFixedArity = 3);

/**
 * Just like macro-create-element, but never wraps form input types.
 */
com.fulcrologic.fulcro.dom.macro_create_unwrapped_element = (function com$fulcrologic$fulcro$dom$macro_create_unwrapped_element(var_args){
var G__66961 = arguments.length;
switch (G__66961) {
case 2:
return com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$core$IFn$_invoke$arity$2 = (function (type,args){
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3(type,args,null);
}));

(com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$core$IFn$_invoke$arity$3 = (function (type,args,csskw){
var vec__66962 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(com.fulcrologic.fulcro.components.force_children,args);
var seq__66963 = cljs.core.seq(vec__66962);
var first__66964 = cljs.core.first(seq__66963);
var seq__66963__$1 = cljs.core.next(seq__66963);
var head = first__66964;
var tail = seq__66963__$1;
if((head == null)){
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66965 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66965,tail);

return G__66965;
})());
} else {
if(cljs.core.truth_(com.fulcrologic.fulcro.dom.element_QMARK_(head))){
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66966 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66966,args);

return G__66966;
})());
} else {
if(cljs.core.object_QMARK_(head)){
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66967 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(head,csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66967,tail);

return G__66967;
})());
} else {
if(cljs.core.map_QMARK_(head)){
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66969 = [type,cljs.core.clj__GT_js(com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(com.fulcrologic.fulcro.dom_common.interpret_classes(head),csskw))];
com.fulcrologic.fulcro.dom.arr_append(G__66969,tail);

return G__66969;
})());
} else {
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66970 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66970,args);

return G__66970;
})());

}
}
}
}
}));

(com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$lang$maxFixedArity = 3);

/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (form "hello")
 * (form nil "hello")
 * 
 * These two are made equivalent at compile time
 * (form {:onClick f} "hello")
 * (form #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (form :#the-id.klass.other-klass "hello")
 * (form :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.form = (function com$fulcrologic$fulcro$dom$form(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70043 = arguments.length;
var i__4865__auto___70044 = (0);
while(true){
if((i__4865__auto___70044 < len__4864__auto___70043)){
args__4870__auto__.push((arguments[i__4865__auto___70044]));

var G__70049 = (i__4865__auto___70044 + (1));
i__4865__auto___70044 = G__70049;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.form.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.form.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66996 = conformed_args__65516__auto__;
var map__66996__$1 = cljs.core.__destructure_map(map__66996);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66996__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66996__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66996__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("form",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.form.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.form.cljs$lang$applyTo = (function (seq66990){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66990));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (audio "hello")
 * (audio nil "hello")
 * 
 * These two are made equivalent at compile time
 * (audio {:onClick f} "hello")
 * (audio #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (audio :#the-id.klass.other-klass "hello")
 * (audio :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.audio = (function com$fulcrologic$fulcro$dom$audio(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70055 = arguments.length;
var i__4865__auto___70056 = (0);
while(true){
if((i__4865__auto___70056 < len__4864__auto___70055)){
args__4870__auto__.push((arguments[i__4865__auto___70056]));

var G__70057 = (i__4865__auto___70056 + (1));
i__4865__auto___70056 = G__70057;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.audio.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.audio.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67004 = conformed_args__65516__auto__;
var map__67004__$1 = cljs.core.__destructure_map(map__67004);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67004__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67004__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67004__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("audio",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.audio.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.audio.cljs$lang$applyTo = (function (seq67002){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67002));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (input "hello")
 * (input nil "hello")
 * 
 * These two are made equivalent at compile time
 * (input {:onClick f} "hello")
 * (input #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (input :#the-id.klass.other-klass "hello")
 * (input :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.input = (function com$fulcrologic$fulcro$dom$input(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70067 = arguments.length;
var i__4865__auto___70068 = (0);
while(true){
if((i__4865__auto___70068 < len__4864__auto___70067)){
args__4870__auto__.push((arguments[i__4865__auto___70068]));

var G__70069 = (i__4865__auto___70068 + (1));
i__4865__auto___70068 = G__70069;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.input.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.input.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67014 = conformed_args__65516__auto__;
var map__67014__$1 = cljs.core.__destructure_map(map__67014);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67014__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67014__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67014__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("input",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.input.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.input.cljs$lang$applyTo = (function (seq67008){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67008));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (menuitem "hello")
 * (menuitem nil "hello")
 * 
 * These two are made equivalent at compile time
 * (menuitem {:onClick f} "hello")
 * (menuitem #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (menuitem :#the-id.klass.other-klass "hello")
 * (menuitem :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.menuitem = (function com$fulcrologic$fulcro$dom$menuitem(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70077 = arguments.length;
var i__4865__auto___70078 = (0);
while(true){
if((i__4865__auto___70078 < len__4864__auto___70077)){
args__4870__auto__.push((arguments[i__4865__auto___70078]));

var G__70079 = (i__4865__auto___70078 + (1));
i__4865__auto___70078 = G__70079;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67028 = conformed_args__65516__auto__;
var map__67028__$1 = cljs.core.__destructure_map(map__67028);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67028__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67028__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67028__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("menuitem",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.menuitem.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.menuitem.cljs$lang$applyTo = (function (seq67022){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67022));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (radialGradient "hello")
 * (radialGradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (radialGradient {:onClick f} "hello")
 * (radialGradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (radialGradient :#the-id.klass.other-klass "hello")
 * (radialGradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.radialGradient = (function com$fulcrologic$fulcro$dom$radialGradient(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70086 = arguments.length;
var i__4865__auto___70087 = (0);
while(true){
if((i__4865__auto___70087 < len__4864__auto___70086)){
args__4870__auto__.push((arguments[i__4865__auto___70087]));

var G__70090 = (i__4865__auto___70087 + (1));
i__4865__auto___70087 = G__70090;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67035 = conformed_args__65516__auto__;
var map__67035__$1 = cljs.core.__destructure_map(map__67035);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67035__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67035__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67035__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("radialGradient",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.radialGradient.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.radialGradient.cljs$lang$applyTo = (function (seq67032){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67032));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMerge "hello")
 * (feMerge nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMerge {:onClick f} "hello")
 * (feMerge #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMerge :#the-id.klass.other-klass "hello")
 * (feMerge :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feMerge = (function com$fulcrologic$fulcro$dom$feMerge(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70096 = arguments.length;
var i__4865__auto___70097 = (0);
while(true){
if((i__4865__auto___70097 < len__4864__auto___70096)){
args__4870__auto__.push((arguments[i__4865__auto___70097]));

var G__70102 = (i__4865__auto___70097 + (1));
i__4865__auto___70097 = G__70102;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feMerge.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feMerge.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67041 = conformed_args__65516__auto__;
var map__67041__$1 = cljs.core.__destructure_map(map__67041);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67041__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67041__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67041__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feMerge",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feMerge.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feMerge.cljs$lang$applyTo = (function (seq67038){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67038));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (set "hello")
 * (set nil "hello")
 * 
 * These two are made equivalent at compile time
 * (set {:onClick f} "hello")
 * (set #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (set :#the-id.klass.other-klass "hello")
 * (set :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.set = (function com$fulcrologic$fulcro$dom$set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70114 = arguments.length;
var i__4865__auto___70115 = (0);
while(true){
if((i__4865__auto___70115 < len__4864__auto___70114)){
args__4870__auto__.push((arguments[i__4865__auto___70115]));

var G__70116 = (i__4865__auto___70115 + (1));
i__4865__auto___70115 = G__70116;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67046 = conformed_args__65516__auto__;
var map__67046__$1 = cljs.core.__destructure_map(map__67046);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67046__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67046__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67046__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("set",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.set.cljs$lang$applyTo = (function (seq67043){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67043));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feSpecularLighting "hello")
 * (feSpecularLighting nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feSpecularLighting {:onClick f} "hello")
 * (feSpecularLighting #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feSpecularLighting :#the-id.klass.other-klass "hello")
 * (feSpecularLighting :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feSpecularLighting = (function com$fulcrologic$fulcro$dom$feSpecularLighting(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70124 = arguments.length;
var i__4865__auto___70126 = (0);
while(true){
if((i__4865__auto___70126 < len__4864__auto___70124)){
args__4870__auto__.push((arguments[i__4865__auto___70126]));

var G__70128 = (i__4865__auto___70126 + (1));
i__4865__auto___70126 = G__70128;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feSpecularLighting.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feSpecularLighting.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67050 = conformed_args__65516__auto__;
var map__67050__$1 = cljs.core.__destructure_map(map__67050);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67050__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67050__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67050__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feSpecularLighting",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feSpecularLighting.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feSpecularLighting.cljs$lang$applyTo = (function (seq67048){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67048));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (base "hello")
 * (base nil "hello")
 * 
 * These two are made equivalent at compile time
 * (base {:onClick f} "hello")
 * (base #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (base :#the-id.klass.other-klass "hello")
 * (base :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.base = (function com$fulcrologic$fulcro$dom$base(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70134 = arguments.length;
var i__4865__auto___70135 = (0);
while(true){
if((i__4865__auto___70135 < len__4864__auto___70134)){
args__4870__auto__.push((arguments[i__4865__auto___70135]));

var G__70136 = (i__4865__auto___70135 + (1));
i__4865__auto___70135 = G__70136;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.base.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.base.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67060 = conformed_args__65516__auto__;
var map__67060__$1 = cljs.core.__destructure_map(map__67060);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67060__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67060__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67060__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("base",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.base.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.base.cljs$lang$applyTo = (function (seq67058){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67058));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h1 "hello")
 * (h1 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h1 {:onClick f} "hello")
 * (h1 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h1 :#the-id.klass.other-klass "hello")
 * (h1 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h1 = (function com$fulcrologic$fulcro$dom$h1(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70148 = arguments.length;
var i__4865__auto___70150 = (0);
while(true){
if((i__4865__auto___70150 < len__4864__auto___70148)){
args__4870__auto__.push((arguments[i__4865__auto___70150]));

var G__70153 = (i__4865__auto___70150 + (1));
i__4865__auto___70150 = G__70153;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h1.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h1.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67071 = conformed_args__65516__auto__;
var map__67071__$1 = cljs.core.__destructure_map(map__67071);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67071__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67071__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67071__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h1",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.h1.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h1.cljs$lang$applyTo = (function (seq67070){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67070));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feOffset "hello")
 * (feOffset nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feOffset {:onClick f} "hello")
 * (feOffset #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feOffset :#the-id.klass.other-klass "hello")
 * (feOffset :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feOffset = (function com$fulcrologic$fulcro$dom$feOffset(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70159 = arguments.length;
var i__4865__auto___70160 = (0);
while(true){
if((i__4865__auto___70160 < len__4864__auto___70159)){
args__4870__auto__.push((arguments[i__4865__auto___70160]));

var G__70161 = (i__4865__auto___70160 + (1));
i__4865__auto___70160 = G__70161;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feOffset.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feOffset.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67075 = conformed_args__65516__auto__;
var map__67075__$1 = cljs.core.__destructure_map(map__67075);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67075__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67075__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67075__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feOffset",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feOffset.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feOffset.cljs$lang$applyTo = (function (seq67074){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67074));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (embed "hello")
 * (embed nil "hello")
 * 
 * These two are made equivalent at compile time
 * (embed {:onClick f} "hello")
 * (embed #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (embed :#the-id.klass.other-klass "hello")
 * (embed :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.embed = (function com$fulcrologic$fulcro$dom$embed(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70164 = arguments.length;
var i__4865__auto___70165 = (0);
while(true){
if((i__4865__auto___70165 < len__4864__auto___70164)){
args__4870__auto__.push((arguments[i__4865__auto___70165]));

var G__70166 = (i__4865__auto___70165 + (1));
i__4865__auto___70165 = G__70166;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.embed.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.embed.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67085 = conformed_args__65516__auto__;
var map__67085__$1 = cljs.core.__destructure_map(map__67085);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67085__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67085__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67085__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("embed",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.embed.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.embed.cljs$lang$applyTo = (function (seq67078){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67078));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateMotion "hello")
 * (animateMotion nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateMotion {:onClick f} "hello")
 * (animateMotion #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateMotion :#the-id.klass.other-klass "hello")
 * (animateMotion :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.animateMotion = (function com$fulcrologic$fulcro$dom$animateMotion(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70170 = arguments.length;
var i__4865__auto___70171 = (0);
while(true){
if((i__4865__auto___70171 < len__4864__auto___70170)){
args__4870__auto__.push((arguments[i__4865__auto___70171]));

var G__70172 = (i__4865__auto___70171 + (1));
i__4865__auto___70171 = G__70172;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.animateMotion.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.animateMotion.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67097 = conformed_args__65516__auto__;
var map__67097__$1 = cljs.core.__destructure_map(map__67097);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67097__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67097__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67097__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("animateMotion",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.animateMotion.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.animateMotion.cljs$lang$applyTo = (function (seq67093){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67093));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h3 "hello")
 * (h3 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h3 {:onClick f} "hello")
 * (h3 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h3 :#the-id.klass.other-klass "hello")
 * (h3 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h3 = (function com$fulcrologic$fulcro$dom$h3(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70179 = arguments.length;
var i__4865__auto___70181 = (0);
while(true){
if((i__4865__auto___70181 < len__4864__auto___70179)){
args__4870__auto__.push((arguments[i__4865__auto___70181]));

var G__70182 = (i__4865__auto___70181 + (1));
i__4865__auto___70181 = G__70182;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h3.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h3.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67102 = conformed_args__65516__auto__;
var map__67102__$1 = cljs.core.__destructure_map(map__67102);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67102__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67102__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67102__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h3",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.h3.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h3.cljs$lang$applyTo = (function (seq67099){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67099));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (body "hello")
 * (body nil "hello")
 * 
 * These two are made equivalent at compile time
 * (body {:onClick f} "hello")
 * (body #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (body :#the-id.klass.other-klass "hello")
 * (body :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.body = (function com$fulcrologic$fulcro$dom$body(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70189 = arguments.length;
var i__4865__auto___70190 = (0);
while(true){
if((i__4865__auto___70190 < len__4864__auto___70189)){
args__4870__auto__.push((arguments[i__4865__auto___70190]));

var G__70193 = (i__4865__auto___70190 + (1));
i__4865__auto___70190 = G__70193;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.body.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.body.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67113 = conformed_args__65516__auto__;
var map__67113__$1 = cljs.core.__destructure_map(map__67113);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67113__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67113__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67113__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("body",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.body.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.body.cljs$lang$applyTo = (function (seq67105){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67105));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hkern "hello")
 * (hkern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hkern {:onClick f} "hello")
 * (hkern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hkern :#the-id.klass.other-klass "hello")
 * (hkern :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.hkern = (function com$fulcrologic$fulcro$dom$hkern(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70197 = arguments.length;
var i__4865__auto___70198 = (0);
while(true){
if((i__4865__auto___70198 < len__4864__auto___70197)){
args__4870__auto__.push((arguments[i__4865__auto___70198]));

var G__70199 = (i__4865__auto___70198 + (1));
i__4865__auto___70198 = G__70199;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.hkern.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.hkern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67132 = conformed_args__65516__auto__;
var map__67132__$1 = cljs.core.__destructure_map(map__67132);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67132__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67132__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67132__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("hkern",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.hkern.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.hkern.cljs$lang$applyTo = (function (seq67126){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67126));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (keygen "hello")
 * (keygen nil "hello")
 * 
 * These two are made equivalent at compile time
 * (keygen {:onClick f} "hello")
 * (keygen #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (keygen :#the-id.klass.other-klass "hello")
 * (keygen :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.keygen = (function com$fulcrologic$fulcro$dom$keygen(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70202 = arguments.length;
var i__4865__auto___70203 = (0);
while(true){
if((i__4865__auto___70203 < len__4864__auto___70202)){
args__4870__auto__.push((arguments[i__4865__auto___70203]));

var G__70204 = (i__4865__auto___70203 + (1));
i__4865__auto___70203 = G__70204;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.keygen.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.keygen.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67152 = conformed_args__65516__auto__;
var map__67152__$1 = cljs.core.__destructure_map(map__67152);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67152__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67152__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67152__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("keygen",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.keygen.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.keygen.cljs$lang$applyTo = (function (seq67140){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67140));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-format "hello")
 * (font-face-format nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-format {:onClick f} "hello")
 * (font-face-format #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-format :#the-id.klass.other-klass "hello")
 * (font-face-format :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face_format = (function com$fulcrologic$fulcro$dom$font_face_format(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70207 = arguments.length;
var i__4865__auto___70208 = (0);
while(true){
if((i__4865__auto___70208 < len__4864__auto___70207)){
args__4870__auto__.push((arguments[i__4865__auto___70208]));

var G__70209 = (i__4865__auto___70208 + (1));
i__4865__auto___70208 = G__70209;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face_format.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face_format.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67158 = conformed_args__65516__auto__;
var map__67158__$1 = cljs.core.__destructure_map(map__67158);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67158__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67158__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67158__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face-format",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face_format.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face_format.cljs$lang$applyTo = (function (seq67154){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67154));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncA "hello")
 * (feFuncA nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncA {:onClick f} "hello")
 * (feFuncA #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncA :#the-id.klass.other-klass "hello")
 * (feFuncA :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFuncA = (function com$fulcrologic$fulcro$dom$feFuncA(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70218 = arguments.length;
var i__4865__auto___70219 = (0);
while(true){
if((i__4865__auto___70219 < len__4864__auto___70218)){
args__4870__auto__.push((arguments[i__4865__auto___70219]));

var G__70220 = (i__4865__auto___70219 + (1));
i__4865__auto___70219 = G__70220;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFuncA.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFuncA.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67165 = conformed_args__65516__auto__;
var map__67165__$1 = cljs.core.__destructure_map(map__67165);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67165__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67165__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67165__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFuncA",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feFuncA.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFuncA.cljs$lang$applyTo = (function (seq67163){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67163));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (progress "hello")
 * (progress nil "hello")
 * 
 * These two are made equivalent at compile time
 * (progress {:onClick f} "hello")
 * (progress #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (progress :#the-id.klass.other-klass "hello")
 * (progress :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.progress = (function com$fulcrologic$fulcro$dom$progress(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70225 = arguments.length;
var i__4865__auto___70226 = (0);
while(true){
if((i__4865__auto___70226 < len__4864__auto___70225)){
args__4870__auto__.push((arguments[i__4865__auto___70226]));

var G__70227 = (i__4865__auto___70226 + (1));
i__4865__auto___70226 = G__70227;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.progress.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.progress.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67178 = conformed_args__65516__auto__;
var map__67178__$1 = cljs.core.__destructure_map(map__67178);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67178__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67178__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67178__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("progress",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.progress.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.progress.cljs$lang$applyTo = (function (seq67174){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67174));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (main "hello")
 * (main nil "hello")
 * 
 * These two are made equivalent at compile time
 * (main {:onClick f} "hello")
 * (main #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (main :#the-id.klass.other-klass "hello")
 * (main :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.main = (function com$fulcrologic$fulcro$dom$main(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70238 = arguments.length;
var i__4865__auto___70239 = (0);
while(true){
if((i__4865__auto___70239 < len__4864__auto___70238)){
args__4870__auto__.push((arguments[i__4865__auto___70239]));

var G__70241 = (i__4865__auto___70239 + (1));
i__4865__auto___70239 = G__70241;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.main.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.main.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67187 = conformed_args__65516__auto__;
var map__67187__$1 = cljs.core.__destructure_map(map__67187);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67187__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67187__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67187__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("main",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.main.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.main.cljs$lang$applyTo = (function (seq67180){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67180));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (cite "hello")
 * (cite nil "hello")
 * 
 * These two are made equivalent at compile time
 * (cite {:onClick f} "hello")
 * (cite #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (cite :#the-id.klass.other-klass "hello")
 * (cite :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.cite = (function com$fulcrologic$fulcro$dom$cite(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70249 = arguments.length;
var i__4865__auto___70251 = (0);
while(true){
if((i__4865__auto___70251 < len__4864__auto___70249)){
args__4870__auto__.push((arguments[i__4865__auto___70251]));

var G__70254 = (i__4865__auto___70251 + (1));
i__4865__auto___70251 = G__70254;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.cite.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.cite.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67197 = conformed_args__65516__auto__;
var map__67197__$1 = cljs.core.__destructure_map(map__67197);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67197__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67197__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67197__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("cite",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.cite.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.cite.cljs$lang$applyTo = (function (seq67190){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67190));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rect "hello")
 * (rect nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rect {:onClick f} "hello")
 * (rect #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rect :#the-id.klass.other-klass "hello")
 * (rect :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.rect = (function com$fulcrologic$fulcro$dom$rect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70257 = arguments.length;
var i__4865__auto___70258 = (0);
while(true){
if((i__4865__auto___70258 < len__4864__auto___70257)){
args__4870__auto__.push((arguments[i__4865__auto___70258]));

var G__70259 = (i__4865__auto___70258 + (1));
i__4865__auto___70258 = G__70259;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.rect.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.rect.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67205 = conformed_args__65516__auto__;
var map__67205__$1 = cljs.core.__destructure_map(map__67205);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67205__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67205__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67205__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("rect",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.rect.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.rect.cljs$lang$applyTo = (function (seq67203){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67203));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tref "hello")
 * (tref nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tref {:onClick f} "hello")
 * (tref #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tref :#the-id.klass.other-klass "hello")
 * (tref :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tref = (function com$fulcrologic$fulcro$dom$tref(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70269 = arguments.length;
var i__4865__auto___70270 = (0);
while(true){
if((i__4865__auto___70270 < len__4864__auto___70269)){
args__4870__auto__.push((arguments[i__4865__auto___70270]));

var G__70271 = (i__4865__auto___70270 + (1));
i__4865__auto___70270 = G__70271;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tref.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tref.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67211 = conformed_args__65516__auto__;
var map__67211__$1 = cljs.core.__destructure_map(map__67211);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67211__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67211__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67211__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tref",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.tref.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tref.cljs$lang$applyTo = (function (seq67209){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67209));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshpatch "hello")
 * (meshpatch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshpatch {:onClick f} "hello")
 * (meshpatch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshpatch :#the-id.klass.other-klass "hello")
 * (meshpatch :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meshpatch = (function com$fulcrologic$fulcro$dom$meshpatch(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70275 = arguments.length;
var i__4865__auto___70276 = (0);
while(true){
if((i__4865__auto___70276 < len__4864__auto___70275)){
args__4870__auto__.push((arguments[i__4865__auto___70276]));

var G__70277 = (i__4865__auto___70276 + (1));
i__4865__auto___70276 = G__70277;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meshpatch.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meshpatch.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67220 = conformed_args__65516__auto__;
var map__67220__$1 = cljs.core.__destructure_map(map__67220);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67220__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67220__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67220__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meshpatch",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.meshpatch.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meshpatch.cljs$lang$applyTo = (function (seq67218){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67218));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (polyline "hello")
 * (polyline nil "hello")
 * 
 * These two are made equivalent at compile time
 * (polyline {:onClick f} "hello")
 * (polyline #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (polyline :#the-id.klass.other-klass "hello")
 * (polyline :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.polyline = (function com$fulcrologic$fulcro$dom$polyline(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70281 = arguments.length;
var i__4865__auto___70282 = (0);
while(true){
if((i__4865__auto___70282 < len__4864__auto___70281)){
args__4870__auto__.push((arguments[i__4865__auto___70282]));

var G__70283 = (i__4865__auto___70282 + (1));
i__4865__auto___70282 = G__70283;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.polyline.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.polyline.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67224 = conformed_args__65516__auto__;
var map__67224__$1 = cljs.core.__destructure_map(map__67224);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67224__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67224__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67224__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("polyline",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.polyline.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.polyline.cljs$lang$applyTo = (function (seq67222){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67222));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (metadata "hello")
 * (metadata nil "hello")
 * 
 * These two are made equivalent at compile time
 * (metadata {:onClick f} "hello")
 * (metadata #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (metadata :#the-id.klass.other-klass "hello")
 * (metadata :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.metadata = (function com$fulcrologic$fulcro$dom$metadata(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70288 = arguments.length;
var i__4865__auto___70289 = (0);
while(true){
if((i__4865__auto___70289 < len__4864__auto___70288)){
args__4870__auto__.push((arguments[i__4865__auto___70289]));

var G__70291 = (i__4865__auto___70289 + (1));
i__4865__auto___70289 = G__70291;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.metadata.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67235 = conformed_args__65516__auto__;
var map__67235__$1 = cljs.core.__destructure_map(map__67235);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67235__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67235__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67235__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("metadata",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.metadata.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.metadata.cljs$lang$applyTo = (function (seq67229){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67229));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (map "hello")
 * (map nil "hello")
 * 
 * These two are made equivalent at compile time
 * (map {:onClick f} "hello")
 * (map #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (map :#the-id.klass.other-klass "hello")
 * (map :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.map = (function com$fulcrologic$fulcro$dom$map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70293 = arguments.length;
var i__4865__auto___70294 = (0);
while(true){
if((i__4865__auto___70294 < len__4864__auto___70293)){
args__4870__auto__.push((arguments[i__4865__auto___70294]));

var G__70295 = (i__4865__auto___70294 + (1));
i__4865__auto___70294 = G__70295;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.map.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.map.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67241 = conformed_args__65516__auto__;
var map__67241__$1 = cljs.core.__destructure_map(map__67241);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67241__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67241__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67241__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("map",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.map.cljs$lang$applyTo = (function (seq67237){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67237));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (object "hello")
 * (object nil "hello")
 * 
 * These two are made equivalent at compile time
 * (object {:onClick f} "hello")
 * (object #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (object :#the-id.klass.other-klass "hello")
 * (object :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.object = (function com$fulcrologic$fulcro$dom$object(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70305 = arguments.length;
var i__4865__auto___70306 = (0);
while(true){
if((i__4865__auto___70306 < len__4864__auto___70305)){
args__4870__auto__.push((arguments[i__4865__auto___70306]));

var G__70307 = (i__4865__auto___70306 + (1));
i__4865__auto___70306 = G__70307;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.object.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.object.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67247 = conformed_args__65516__auto__;
var map__67247__$1 = cljs.core.__destructure_map(map__67247);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67247__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67247__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67247__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("object",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.object.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.object.cljs$lang$applyTo = (function (seq67243){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67243));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (i "hello")
 * (i nil "hello")
 * 
 * These two are made equivalent at compile time
 * (i {:onClick f} "hello")
 * (i #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (i :#the-id.klass.other-klass "hello")
 * (i :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.i = (function com$fulcrologic$fulcro$dom$i(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70309 = arguments.length;
var i__4865__auto___70310 = (0);
while(true){
if((i__4865__auto___70310 < len__4864__auto___70309)){
args__4870__auto__.push((arguments[i__4865__auto___70310]));

var G__70311 = (i__4865__auto___70310 + (1));
i__4865__auto___70310 = G__70311;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.i.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.i.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67251 = conformed_args__65516__auto__;
var map__67251__$1 = cljs.core.__destructure_map(map__67251);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67251__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67251__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67251__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("i",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.i.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.i.cljs$lang$applyTo = (function (seq67248){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67248));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-name "hello")
 * (font-face-name nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-name {:onClick f} "hello")
 * (font-face-name #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-name :#the-id.klass.other-klass "hello")
 * (font-face-name :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face_name = (function com$fulcrologic$fulcro$dom$font_face_name(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70322 = arguments.length;
var i__4865__auto___70323 = (0);
while(true){
if((i__4865__auto___70323 < len__4864__auto___70322)){
args__4870__auto__.push((arguments[i__4865__auto___70323]));

var G__70325 = (i__4865__auto___70323 + (1));
i__4865__auto___70323 = G__70325;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face_name.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face_name.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67259 = conformed_args__65516__auto__;
var map__67259__$1 = cljs.core.__destructure_map(map__67259);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67259__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67259__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67259__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face-name",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face_name.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face_name.cljs$lang$applyTo = (function (seq67256){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67256));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (p "hello")
 * (p nil "hello")
 * 
 * These two are made equivalent at compile time
 * (p {:onClick f} "hello")
 * (p #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (p :#the-id.klass.other-klass "hello")
 * (p :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.p = (function com$fulcrologic$fulcro$dom$p(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70331 = arguments.length;
var i__4865__auto___70332 = (0);
while(true){
if((i__4865__auto___70332 < len__4864__auto___70331)){
args__4870__auto__.push((arguments[i__4865__auto___70332]));

var G__70333 = (i__4865__auto___70332 + (1));
i__4865__auto___70332 = G__70333;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.p.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.p.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67276 = conformed_args__65516__auto__;
var map__67276__$1 = cljs.core.__destructure_map(map__67276);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67276__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67276__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67276__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("p",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.p.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.p.cljs$lang$applyTo = (function (seq67269){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67269));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncR "hello")
 * (feFuncR nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncR {:onClick f} "hello")
 * (feFuncR #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncR :#the-id.klass.other-klass "hello")
 * (feFuncR :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFuncR = (function com$fulcrologic$fulcro$dom$feFuncR(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70338 = arguments.length;
var i__4865__auto___70340 = (0);
while(true){
if((i__4865__auto___70340 < len__4864__auto___70338)){
args__4870__auto__.push((arguments[i__4865__auto___70340]));

var G__70341 = (i__4865__auto___70340 + (1));
i__4865__auto___70340 = G__70341;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFuncR.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFuncR.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67286 = conformed_args__65516__auto__;
var map__67286__$1 = cljs.core.__destructure_map(map__67286);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67286__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67286__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67286__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFuncR",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feFuncR.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFuncR.cljs$lang$applyTo = (function (seq67280){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67280));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hatchpath "hello")
 * (hatchpath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hatchpath {:onClick f} "hello")
 * (hatchpath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hatchpath :#the-id.klass.other-klass "hello")
 * (hatchpath :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.hatchpath = (function com$fulcrologic$fulcro$dom$hatchpath(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70346 = arguments.length;
var i__4865__auto___70347 = (0);
while(true){
if((i__4865__auto___70347 < len__4864__auto___70346)){
args__4870__auto__.push((arguments[i__4865__auto___70347]));

var G__70349 = (i__4865__auto___70347 + (1));
i__4865__auto___70347 = G__70349;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.hatchpath.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.hatchpath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67301 = conformed_args__65516__auto__;
var map__67301__$1 = cljs.core.__destructure_map(map__67301);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67301__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67301__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67301__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("hatchpath",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.hatchpath.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.hatchpath.cljs$lang$applyTo = (function (seq67296){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67296));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyphItem "hello")
 * (altGlyphItem nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyphItem {:onClick f} "hello")
 * (altGlyphItem #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyphItem :#the-id.klass.other-klass "hello")
 * (altGlyphItem :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.altGlyphItem = (function com$fulcrologic$fulcro$dom$altGlyphItem(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70356 = arguments.length;
var i__4865__auto___70357 = (0);
while(true){
if((i__4865__auto___70357 < len__4864__auto___70356)){
args__4870__auto__.push((arguments[i__4865__auto___70357]));

var G__70358 = (i__4865__auto___70357 + (1));
i__4865__auto___70357 = G__70358;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.altGlyphItem.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.altGlyphItem.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67315 = conformed_args__65516__auto__;
var map__67315__$1 = cljs.core.__destructure_map(map__67315);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67315__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67315__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67315__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("altGlyphItem",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.altGlyphItem.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.altGlyphItem.cljs$lang$applyTo = (function (seq67308){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67308));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (nav "hello")
 * (nav nil "hello")
 * 
 * These two are made equivalent at compile time
 * (nav {:onClick f} "hello")
 * (nav #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (nav :#the-id.klass.other-klass "hello")
 * (nav :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.nav = (function com$fulcrologic$fulcro$dom$nav(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70376 = arguments.length;
var i__4865__auto___70377 = (0);
while(true){
if((i__4865__auto___70377 < len__4864__auto___70376)){
args__4870__auto__.push((arguments[i__4865__auto___70377]));

var G__70383 = (i__4865__auto___70377 + (1));
i__4865__auto___70377 = G__70383;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.nav.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.nav.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67323 = conformed_args__65516__auto__;
var map__67323__$1 = cljs.core.__destructure_map(map__67323);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67323__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67323__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67323__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("nav",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.nav.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.nav.cljs$lang$applyTo = (function (seq67319){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67319));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ruby "hello")
 * (ruby nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ruby {:onClick f} "hello")
 * (ruby #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ruby :#the-id.klass.other-klass "hello")
 * (ruby :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ruby = (function com$fulcrologic$fulcro$dom$ruby(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70396 = arguments.length;
var i__4865__auto___70398 = (0);
while(true){
if((i__4865__auto___70398 < len__4864__auto___70396)){
args__4870__auto__.push((arguments[i__4865__auto___70398]));

var G__70400 = (i__4865__auto___70398 + (1));
i__4865__auto___70398 = G__70400;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ruby.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ruby.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67339 = conformed_args__65516__auto__;
var map__67339__$1 = cljs.core.__destructure_map(map__67339);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67339__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67339__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67339__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ruby",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.ruby.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ruby.cljs$lang$applyTo = (function (seq67332){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67332));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (switch "hello")
 * (switch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (switch {:onClick f} "hello")
 * (switch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (switch :#the-id.klass.other-klass "hello")
 * (switch :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.switch$ = (function com$fulcrologic$fulcro$dom$switch(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70409 = arguments.length;
var i__4865__auto___70410 = (0);
while(true){
if((i__4865__auto___70410 < len__4864__auto___70409)){
args__4870__auto__.push((arguments[i__4865__auto___70410]));

var G__70411 = (i__4865__auto___70410 + (1));
i__4865__auto___70410 = G__70411;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.switch$.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.switch$.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67352 = conformed_args__65516__auto__;
var map__67352__$1 = cljs.core.__destructure_map(map__67352);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67352__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67352__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67352__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("switch",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.switch$.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.switch$.cljs$lang$applyTo = (function (seq67343){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67343));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (a "hello")
 * (a nil "hello")
 * 
 * These two are made equivalent at compile time
 * (a {:onClick f} "hello")
 * (a #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (a :#the-id.klass.other-klass "hello")
 * (a :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.a = (function com$fulcrologic$fulcro$dom$a(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70421 = arguments.length;
var i__4865__auto___70422 = (0);
while(true){
if((i__4865__auto___70422 < len__4864__auto___70421)){
args__4870__auto__.push((arguments[i__4865__auto___70422]));

var G__70424 = (i__4865__auto___70422 + (1));
i__4865__auto___70422 = G__70424;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.a.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.a.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67366 = conformed_args__65516__auto__;
var map__67366__$1 = cljs.core.__destructure_map(map__67366);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67366__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67366__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67366__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("a",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.a.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.a.cljs$lang$applyTo = (function (seq67360){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67360));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (view "hello")
 * (view nil "hello")
 * 
 * These two are made equivalent at compile time
 * (view {:onClick f} "hello")
 * (view #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (view :#the-id.klass.other-klass "hello")
 * (view :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.view = (function com$fulcrologic$fulcro$dom$view(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70431 = arguments.length;
var i__4865__auto___70432 = (0);
while(true){
if((i__4865__auto___70432 < len__4864__auto___70431)){
args__4870__auto__.push((arguments[i__4865__auto___70432]));

var G__70434 = (i__4865__auto___70432 + (1));
i__4865__auto___70432 = G__70434;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.view.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.view.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67376 = conformed_args__65516__auto__;
var map__67376__$1 = cljs.core.__destructure_map(map__67376);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67376__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67376__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67376__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("view",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.view.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.view.cljs$lang$applyTo = (function (seq67370){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67370));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (menu "hello")
 * (menu nil "hello")
 * 
 * These two are made equivalent at compile time
 * (menu {:onClick f} "hello")
 * (menu #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (menu :#the-id.klass.other-klass "hello")
 * (menu :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.menu = (function com$fulcrologic$fulcro$dom$menu(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70440 = arguments.length;
var i__4865__auto___70442 = (0);
while(true){
if((i__4865__auto___70442 < len__4864__auto___70440)){
args__4870__auto__.push((arguments[i__4865__auto___70442]));

var G__70443 = (i__4865__auto___70442 + (1));
i__4865__auto___70442 = G__70443;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.menu.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.menu.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67387 = conformed_args__65516__auto__;
var map__67387__$1 = cljs.core.__destructure_map(map__67387);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67387__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67387__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67387__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("menu",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.menu.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.menu.cljs$lang$applyTo = (function (seq67381){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67381));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (blockquote "hello")
 * (blockquote nil "hello")
 * 
 * These two are made equivalent at compile time
 * (blockquote {:onClick f} "hello")
 * (blockquote #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (blockquote :#the-id.klass.other-klass "hello")
 * (blockquote :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.blockquote = (function com$fulcrologic$fulcro$dom$blockquote(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70447 = arguments.length;
var i__4865__auto___70448 = (0);
while(true){
if((i__4865__auto___70448 < len__4864__auto___70447)){
args__4870__auto__.push((arguments[i__4865__auto___70448]));

var G__70450 = (i__4865__auto___70448 + (1));
i__4865__auto___70448 = G__70450;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67401 = conformed_args__65516__auto__;
var map__67401__$1 = cljs.core.__destructure_map(map__67401);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67401__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67401__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67401__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("blockquote",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.blockquote.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.blockquote.cljs$lang$applyTo = (function (seq67398){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67398));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (img "hello")
 * (img nil "hello")
 * 
 * These two are made equivalent at compile time
 * (img {:onClick f} "hello")
 * (img #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (img :#the-id.klass.other-klass "hello")
 * (img :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.img = (function com$fulcrologic$fulcro$dom$img(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70458 = arguments.length;
var i__4865__auto___70459 = (0);
while(true){
if((i__4865__auto___70459 < len__4864__auto___70458)){
args__4870__auto__.push((arguments[i__4865__auto___70459]));

var G__70460 = (i__4865__auto___70459 + (1));
i__4865__auto___70459 = G__70460;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.img.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.img.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67411 = conformed_args__65516__auto__;
var map__67411__$1 = cljs.core.__destructure_map(map__67411);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67411__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67411__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67411__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("img",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.img.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.img.cljs$lang$applyTo = (function (seq67407){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67407));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncG "hello")
 * (feFuncG nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncG {:onClick f} "hello")
 * (feFuncG #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncG :#the-id.klass.other-klass "hello")
 * (feFuncG :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFuncG = (function com$fulcrologic$fulcro$dom$feFuncG(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70468 = arguments.length;
var i__4865__auto___70470 = (0);
while(true){
if((i__4865__auto___70470 < len__4864__auto___70468)){
args__4870__auto__.push((arguments[i__4865__auto___70470]));

var G__70471 = (i__4865__auto___70470 + (1));
i__4865__auto___70470 = G__70471;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFuncG.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFuncG.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67423 = conformed_args__65516__auto__;
var map__67423__$1 = cljs.core.__destructure_map(map__67423);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67423__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67423__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67423__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFuncG",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feFuncG.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFuncG.cljs$lang$applyTo = (function (seq67419){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67419));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (text "hello")
 * (text nil "hello")
 * 
 * These two are made equivalent at compile time
 * (text {:onClick f} "hello")
 * (text #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (text :#the-id.klass.other-klass "hello")
 * (text :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.text = (function com$fulcrologic$fulcro$dom$text(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70479 = arguments.length;
var i__4865__auto___70480 = (0);
while(true){
if((i__4865__auto___70480 < len__4864__auto___70479)){
args__4870__auto__.push((arguments[i__4865__auto___70480]));

var G__70482 = (i__4865__auto___70480 + (1));
i__4865__auto___70480 = G__70482;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.text.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.text.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67439 = conformed_args__65516__auto__;
var map__67439__$1 = cljs.core.__destructure_map(map__67439);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67439__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67439__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67439__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("text",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.text.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.text.cljs$lang$applyTo = (function (seq67428){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67428));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (span "hello")
 * (span nil "hello")
 * 
 * These two are made equivalent at compile time
 * (span {:onClick f} "hello")
 * (span #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (span :#the-id.klass.other-klass "hello")
 * (span :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.span = (function com$fulcrologic$fulcro$dom$span(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70502 = arguments.length;
var i__4865__auto___70503 = (0);
while(true){
if((i__4865__auto___70503 < len__4864__auto___70502)){
args__4870__auto__.push((arguments[i__4865__auto___70503]));

var G__70504 = (i__4865__auto___70503 + (1));
i__4865__auto___70503 = G__70504;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.span.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.span.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67451 = conformed_args__65516__auto__;
var map__67451__$1 = cljs.core.__destructure_map(map__67451);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67451__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67451__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67451__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("span",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.span.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.span.cljs$lang$applyTo = (function (seq67444){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67444));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (track "hello")
 * (track nil "hello")
 * 
 * These two are made equivalent at compile time
 * (track {:onClick f} "hello")
 * (track #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (track :#the-id.klass.other-klass "hello")
 * (track :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.track = (function com$fulcrologic$fulcro$dom$track(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70526 = arguments.length;
var i__4865__auto___70527 = (0);
while(true){
if((i__4865__auto___70527 < len__4864__auto___70526)){
args__4870__auto__.push((arguments[i__4865__auto___70527]));

var G__70534 = (i__4865__auto___70527 + (1));
i__4865__auto___70527 = G__70534;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.track.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.track.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67460 = conformed_args__65516__auto__;
var map__67460__$1 = cljs.core.__destructure_map(map__67460);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67460__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67460__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67460__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("track",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.track.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.track.cljs$lang$applyTo = (function (seq67455){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67455));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (data "hello")
 * (data nil "hello")
 * 
 * These two are made equivalent at compile time
 * (data {:onClick f} "hello")
 * (data #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (data :#the-id.klass.other-klass "hello")
 * (data :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.data = (function com$fulcrologic$fulcro$dom$data(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70551 = arguments.length;
var i__4865__auto___70553 = (0);
while(true){
if((i__4865__auto___70553 < len__4864__auto___70551)){
args__4870__auto__.push((arguments[i__4865__auto___70553]));

var G__70560 = (i__4865__auto___70553 + (1));
i__4865__auto___70553 = G__70560;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.data.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.data.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67476 = conformed_args__65516__auto__;
var map__67476__$1 = cljs.core.__destructure_map(map__67476);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67476__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67476__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67476__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("data",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.data.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.data.cljs$lang$applyTo = (function (seq67468){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67468));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (u "hello")
 * (u nil "hello")
 * 
 * These two are made equivalent at compile time
 * (u {:onClick f} "hello")
 * (u #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (u :#the-id.klass.other-klass "hello")
 * (u :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.u = (function com$fulcrologic$fulcro$dom$u(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70580 = arguments.length;
var i__4865__auto___70582 = (0);
while(true){
if((i__4865__auto___70582 < len__4864__auto___70580)){
args__4870__auto__.push((arguments[i__4865__auto___70582]));

var G__70584 = (i__4865__auto___70582 + (1));
i__4865__auto___70582 = G__70584;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.u.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.u.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67495 = conformed_args__65516__auto__;
var map__67495__$1 = cljs.core.__destructure_map(map__67495);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67495__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67495__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67495__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("u",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.u.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.u.cljs$lang$applyTo = (function (seq67493){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67493));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dl "hello")
 * (dl nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dl {:onClick f} "hello")
 * (dl #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dl :#the-id.klass.other-klass "hello")
 * (dl :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dl = (function com$fulcrologic$fulcro$dom$dl(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70594 = arguments.length;
var i__4865__auto___70595 = (0);
while(true){
if((i__4865__auto___70595 < len__4864__auto___70594)){
args__4870__auto__.push((arguments[i__4865__auto___70595]));

var G__70600 = (i__4865__auto___70595 + (1));
i__4865__auto___70595 = G__70600;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dl.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dl.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67511 = conformed_args__65516__auto__;
var map__67511__$1 = cljs.core.__destructure_map(map__67511);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67511__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67511__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67511__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dl",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.dl.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dl.cljs$lang$applyTo = (function (seq67501){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67501));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (select "hello")
 * (select nil "hello")
 * 
 * These two are made equivalent at compile time
 * (select {:onClick f} "hello")
 * (select #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (select :#the-id.klass.other-klass "hello")
 * (select :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.select = (function com$fulcrologic$fulcro$dom$select(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70616 = arguments.length;
var i__4865__auto___70617 = (0);
while(true){
if((i__4865__auto___70617 < len__4864__auto___70616)){
args__4870__auto__.push((arguments[i__4865__auto___70617]));

var G__70618 = (i__4865__auto___70617 + (1));
i__4865__auto___70617 = G__70618;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.select.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.select.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67533 = conformed_args__65516__auto__;
var map__67533__$1 = cljs.core.__destructure_map(map__67533);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67533__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67533__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67533__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("select",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.select.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.select.cljs$lang$applyTo = (function (seq67523){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67523));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (polygon "hello")
 * (polygon nil "hello")
 * 
 * These two are made equivalent at compile time
 * (polygon {:onClick f} "hello")
 * (polygon #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (polygon :#the-id.klass.other-klass "hello")
 * (polygon :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.polygon = (function com$fulcrologic$fulcro$dom$polygon(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70621 = arguments.length;
var i__4865__auto___70623 = (0);
while(true){
if((i__4865__auto___70623 < len__4864__auto___70621)){
args__4870__auto__.push((arguments[i__4865__auto___70623]));

var G__70625 = (i__4865__auto___70623 + (1));
i__4865__auto___70623 = G__70625;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.polygon.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.polygon.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67561 = conformed_args__65516__auto__;
var map__67561__$1 = cljs.core.__destructure_map(map__67561);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67561__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67561__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67561__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("polygon",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.polygon.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.polygon.cljs$lang$applyTo = (function (seq67548){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67548));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (pattern "hello")
 * (pattern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (pattern {:onClick f} "hello")
 * (pattern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (pattern :#the-id.klass.other-klass "hello")
 * (pattern :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.pattern = (function com$fulcrologic$fulcro$dom$pattern(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70628 = arguments.length;
var i__4865__auto___70629 = (0);
while(true){
if((i__4865__auto___70629 < len__4864__auto___70628)){
args__4870__auto__.push((arguments[i__4865__auto___70629]));

var G__70631 = (i__4865__auto___70629 + (1));
i__4865__auto___70629 = G__70631;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.pattern.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.pattern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67590 = conformed_args__65516__auto__;
var map__67590__$1 = cljs.core.__destructure_map(map__67590);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67590__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67590__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67590__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("pattern",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.pattern.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.pattern.cljs$lang$applyTo = (function (seq67575){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67575));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (html "hello")
 * (html nil "hello")
 * 
 * These two are made equivalent at compile time
 * (html {:onClick f} "hello")
 * (html #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (html :#the-id.klass.other-klass "hello")
 * (html :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.html = (function com$fulcrologic$fulcro$dom$html(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70639 = arguments.length;
var i__4865__auto___70642 = (0);
while(true){
if((i__4865__auto___70642 < len__4864__auto___70639)){
args__4870__auto__.push((arguments[i__4865__auto___70642]));

var G__70645 = (i__4865__auto___70642 + (1));
i__4865__auto___70642 = G__70645;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.html.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.html.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67622 = conformed_args__65516__auto__;
var map__67622__$1 = cljs.core.__destructure_map(map__67622);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67622__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67622__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67622__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("html",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.html.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.html.cljs$lang$applyTo = (function (seq67606){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67606));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (foreignObject "hello")
 * (foreignObject nil "hello")
 * 
 * These two are made equivalent at compile time
 * (foreignObject {:onClick f} "hello")
 * (foreignObject #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (foreignObject :#the-id.klass.other-klass "hello")
 * (foreignObject :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.foreignObject = (function com$fulcrologic$fulcro$dom$foreignObject(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70648 = arguments.length;
var i__4865__auto___70649 = (0);
while(true){
if((i__4865__auto___70649 < len__4864__auto___70648)){
args__4870__auto__.push((arguments[i__4865__auto___70649]));

var G__70650 = (i__4865__auto___70649 + (1));
i__4865__auto___70649 = G__70650;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.foreignObject.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.foreignObject.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67634 = conformed_args__65516__auto__;
var map__67634__$1 = cljs.core.__destructure_map(map__67634);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67634__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67634__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67634__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("foreignObject",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.foreignObject.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.foreignObject.cljs$lang$applyTo = (function (seq67628){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67628));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (thead "hello")
 * (thead nil "hello")
 * 
 * These two are made equivalent at compile time
 * (thead {:onClick f} "hello")
 * (thead #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (thead :#the-id.klass.other-klass "hello")
 * (thead :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.thead = (function com$fulcrologic$fulcro$dom$thead(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70652 = arguments.length;
var i__4865__auto___70653 = (0);
while(true){
if((i__4865__auto___70653 < len__4864__auto___70652)){
args__4870__auto__.push((arguments[i__4865__auto___70653]));

var G__70656 = (i__4865__auto___70653 + (1));
i__4865__auto___70653 = G__70656;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.thead.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.thead.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67646 = conformed_args__65516__auto__;
var map__67646__$1 = cljs.core.__destructure_map(map__67646);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67646__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67646__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67646__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("thead",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.thead.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.thead.cljs$lang$applyTo = (function (seq67640){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67640));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (path "hello")
 * (path nil "hello")
 * 
 * These two are made equivalent at compile time
 * (path {:onClick f} "hello")
 * (path #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (path :#the-id.klass.other-klass "hello")
 * (path :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.path = (function com$fulcrologic$fulcro$dom$path(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70660 = arguments.length;
var i__4865__auto___70661 = (0);
while(true){
if((i__4865__auto___70661 < len__4864__auto___70660)){
args__4870__auto__.push((arguments[i__4865__auto___70661]));

var G__70663 = (i__4865__auto___70661 + (1));
i__4865__auto___70661 = G__70663;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.path.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.path.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67660 = conformed_args__65516__auto__;
var map__67660__$1 = cljs.core.__destructure_map(map__67660);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67660__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67660__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67660__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("path",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.path.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.path.cljs$lang$applyTo = (function (seq67653){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67653));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (del "hello")
 * (del nil "hello")
 * 
 * These two are made equivalent at compile time
 * (del {:onClick f} "hello")
 * (del #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (del :#the-id.klass.other-klass "hello")
 * (del :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.del = (function com$fulcrologic$fulcro$dom$del(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70665 = arguments.length;
var i__4865__auto___70666 = (0);
while(true){
if((i__4865__auto___70666 < len__4864__auto___70665)){
args__4870__auto__.push((arguments[i__4865__auto___70666]));

var G__70667 = (i__4865__auto___70666 + (1));
i__4865__auto___70666 = G__70667;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.del.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.del.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67680 = conformed_args__65516__auto__;
var map__67680__$1 = cljs.core.__destructure_map(map__67680);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67680__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67680__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67680__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("del",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.del.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.del.cljs$lang$applyTo = (function (seq67677){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67677));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyph "hello")
 * (altGlyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyph {:onClick f} "hello")
 * (altGlyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyph :#the-id.klass.other-klass "hello")
 * (altGlyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.altGlyph = (function com$fulcrologic$fulcro$dom$altGlyph(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70670 = arguments.length;
var i__4865__auto___70671 = (0);
while(true){
if((i__4865__auto___70671 < len__4864__auto___70670)){
args__4870__auto__.push((arguments[i__4865__auto___70671]));

var G__70672 = (i__4865__auto___70671 + (1));
i__4865__auto___70671 = G__70672;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.altGlyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.altGlyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67704 = conformed_args__65516__auto__;
var map__67704__$1 = cljs.core.__destructure_map(map__67704);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67704__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67704__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67704__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("altGlyph",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.altGlyph.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.altGlyph.cljs$lang$applyTo = (function (seq67695){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67695));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (fieldset "hello")
 * (fieldset nil "hello")
 * 
 * These two are made equivalent at compile time
 * (fieldset {:onClick f} "hello")
 * (fieldset #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (fieldset :#the-id.klass.other-klass "hello")
 * (fieldset :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.fieldset = (function com$fulcrologic$fulcro$dom$fieldset(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70681 = arguments.length;
var i__4865__auto___70682 = (0);
while(true){
if((i__4865__auto___70682 < len__4864__auto___70681)){
args__4870__auto__.push((arguments[i__4865__auto___70682]));

var G__70683 = (i__4865__auto___70682 + (1));
i__4865__auto___70682 = G__70683;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67714 = conformed_args__65516__auto__;
var map__67714__$1 = cljs.core.__destructure_map(map__67714);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67714__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67714__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67714__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("fieldset",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.fieldset.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.fieldset.cljs$lang$applyTo = (function (seq67711){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67711));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (aside "hello")
 * (aside nil "hello")
 * 
 * These two are made equivalent at compile time
 * (aside {:onClick f} "hello")
 * (aside #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (aside :#the-id.klass.other-klass "hello")
 * (aside :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.aside = (function com$fulcrologic$fulcro$dom$aside(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70691 = arguments.length;
var i__4865__auto___70692 = (0);
while(true){
if((i__4865__auto___70692 < len__4864__auto___70691)){
args__4870__auto__.push((arguments[i__4865__auto___70692]));

var G__70695 = (i__4865__auto___70692 + (1));
i__4865__auto___70692 = G__70695;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.aside.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.aside.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67729 = conformed_args__65516__auto__;
var map__67729__$1 = cljs.core.__destructure_map(map__67729);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67729__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67729__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67729__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("aside",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.aside.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.aside.cljs$lang$applyTo = (function (seq67719){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67719));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feBlend "hello")
 * (feBlend nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feBlend {:onClick f} "hello")
 * (feBlend #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feBlend :#the-id.klass.other-klass "hello")
 * (feBlend :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feBlend = (function com$fulcrologic$fulcro$dom$feBlend(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70702 = arguments.length;
var i__4865__auto___70703 = (0);
while(true){
if((i__4865__auto___70703 < len__4864__auto___70702)){
args__4870__auto__.push((arguments[i__4865__auto___70703]));

var G__70704 = (i__4865__auto___70703 + (1));
i__4865__auto___70703 = G__70704;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feBlend.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feBlend.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67757 = conformed_args__65516__auto__;
var map__67757__$1 = cljs.core.__destructure_map(map__67757);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67757__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67757__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67757__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feBlend",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feBlend.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feBlend.cljs$lang$applyTo = (function (seq67738){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67738));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (figure "hello")
 * (figure nil "hello")
 * 
 * These two are made equivalent at compile time
 * (figure {:onClick f} "hello")
 * (figure #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (figure :#the-id.klass.other-klass "hello")
 * (figure :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.figure = (function com$fulcrologic$fulcro$dom$figure(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70715 = arguments.length;
var i__4865__auto___70716 = (0);
while(true){
if((i__4865__auto___70716 < len__4864__auto___70715)){
args__4870__auto__.push((arguments[i__4865__auto___70716]));

var G__70720 = (i__4865__auto___70716 + (1));
i__4865__auto___70716 = G__70720;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.figure.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.figure.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67764 = conformed_args__65516__auto__;
var map__67764__$1 = cljs.core.__destructure_map(map__67764);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67764__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67764__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67764__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("figure",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.figure.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.figure.cljs$lang$applyTo = (function (seq67758){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67758));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (textPath "hello")
 * (textPath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (textPath {:onClick f} "hello")
 * (textPath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (textPath :#the-id.klass.other-klass "hello")
 * (textPath :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.textPath = (function com$fulcrologic$fulcro$dom$textPath(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70722 = arguments.length;
var i__4865__auto___70723 = (0);
while(true){
if((i__4865__auto___70723 < len__4864__auto___70722)){
args__4870__auto__.push((arguments[i__4865__auto___70723]));

var G__70724 = (i__4865__auto___70723 + (1));
i__4865__auto___70723 = G__70724;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.textPath.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.textPath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67781 = conformed_args__65516__auto__;
var map__67781__$1 = cljs.core.__destructure_map(map__67781);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67781__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67781__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67781__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("textPath",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.textPath.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.textPath.cljs$lang$applyTo = (function (seq67772){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67772));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (figcaption "hello")
 * (figcaption nil "hello")
 * 
 * These two are made equivalent at compile time
 * (figcaption {:onClick f} "hello")
 * (figcaption #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (figcaption :#the-id.klass.other-klass "hello")
 * (figcaption :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.figcaption = (function com$fulcrologic$fulcro$dom$figcaption(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70727 = arguments.length;
var i__4865__auto___70728 = (0);
while(true){
if((i__4865__auto___70728 < len__4864__auto___70727)){
args__4870__auto__.push((arguments[i__4865__auto___70728]));

var G__70729 = (i__4865__auto___70728 + (1));
i__4865__auto___70728 = G__70729;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67812 = conformed_args__65516__auto__;
var map__67812__$1 = cljs.core.__destructure_map(map__67812);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67812__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67812__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67812__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("figcaption",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.figcaption.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.figcaption.cljs$lang$applyTo = (function (seq67795){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67795));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mask "hello")
 * (mask nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mask {:onClick f} "hello")
 * (mask #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mask :#the-id.klass.other-klass "hello")
 * (mask :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.mask = (function com$fulcrologic$fulcro$dom$mask(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70731 = arguments.length;
var i__4865__auto___70732 = (0);
while(true){
if((i__4865__auto___70732 < len__4864__auto___70731)){
args__4870__auto__.push((arguments[i__4865__auto___70732]));

var G__70734 = (i__4865__auto___70732 + (1));
i__4865__auto___70732 = G__70734;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.mask.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.mask.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67825 = conformed_args__65516__auto__;
var map__67825__$1 = cljs.core.__destructure_map(map__67825);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67825__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67825__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67825__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("mask",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.mask.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.mask.cljs$lang$applyTo = (function (seq67817){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67817));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (q "hello")
 * (q nil "hello")
 * 
 * These two are made equivalent at compile time
 * (q {:onClick f} "hello")
 * (q #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (q :#the-id.klass.other-klass "hello")
 * (q :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.q = (function com$fulcrologic$fulcro$dom$q(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70735 = arguments.length;
var i__4865__auto___70736 = (0);
while(true){
if((i__4865__auto___70736 < len__4864__auto___70735)){
args__4870__auto__.push((arguments[i__4865__auto___70736]));

var G__70737 = (i__4865__auto___70736 + (1));
i__4865__auto___70736 = G__70737;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.q.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.q.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67838 = conformed_args__65516__auto__;
var map__67838__$1 = cljs.core.__destructure_map(map__67838);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67838__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67838__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67838__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("q",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.q.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.q.cljs$lang$applyTo = (function (seq67832){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67832));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (bdi "hello")
 * (bdi nil "hello")
 * 
 * These two are made equivalent at compile time
 * (bdi {:onClick f} "hello")
 * (bdi #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (bdi :#the-id.klass.other-klass "hello")
 * (bdi :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.bdi = (function com$fulcrologic$fulcro$dom$bdi(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70742 = arguments.length;
var i__4865__auto___70743 = (0);
while(true){
if((i__4865__auto___70743 < len__4864__auto___70742)){
args__4870__auto__.push((arguments[i__4865__auto___70743]));

var G__70744 = (i__4865__auto___70743 + (1));
i__4865__auto___70743 = G__70744;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.bdi.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.bdi.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67862 = conformed_args__65516__auto__;
var map__67862__$1 = cljs.core.__destructure_map(map__67862);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67862__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67862__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67862__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("bdi",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.bdi.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.bdi.cljs$lang$applyTo = (function (seq67851){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67851));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDistantLight "hello")
 * (feDistantLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDistantLight {:onClick f} "hello")
 * (feDistantLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDistantLight :#the-id.klass.other-klass "hello")
 * (feDistantLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feDistantLight = (function com$fulcrologic$fulcro$dom$feDistantLight(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70753 = arguments.length;
var i__4865__auto___70754 = (0);
while(true){
if((i__4865__auto___70754 < len__4864__auto___70753)){
args__4870__auto__.push((arguments[i__4865__auto___70754]));

var G__70757 = (i__4865__auto___70754 + (1));
i__4865__auto___70754 = G__70757;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feDistantLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feDistantLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67874 = conformed_args__65516__auto__;
var map__67874__$1 = cljs.core.__destructure_map(map__67874);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67874__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67874__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67874__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feDistantLight",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feDistantLight.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feDistantLight.cljs$lang$applyTo = (function (seq67869){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67869));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (video "hello")
 * (video nil "hello")
 * 
 * These two are made equivalent at compile time
 * (video {:onClick f} "hello")
 * (video #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (video :#the-id.klass.other-klass "hello")
 * (video :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.video = (function com$fulcrologic$fulcro$dom$video(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70758 = arguments.length;
var i__4865__auto___70759 = (0);
while(true){
if((i__4865__auto___70759 < len__4864__auto___70758)){
args__4870__auto__.push((arguments[i__4865__auto___70759]));

var G__70760 = (i__4865__auto___70759 + (1));
i__4865__auto___70759 = G__70760;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.video.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.video.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67888 = conformed_args__65516__auto__;
var map__67888__$1 = cljs.core.__destructure_map(map__67888);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67888__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67888__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67888__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("video",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.video.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.video.cljs$lang$applyTo = (function (seq67880){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67880));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (address "hello")
 * (address nil "hello")
 * 
 * These two are made equivalent at compile time
 * (address {:onClick f} "hello")
 * (address #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (address :#the-id.klass.other-klass "hello")
 * (address :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.address = (function com$fulcrologic$fulcro$dom$address(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70765 = arguments.length;
var i__4865__auto___70766 = (0);
while(true){
if((i__4865__auto___70766 < len__4864__auto___70765)){
args__4870__auto__.push((arguments[i__4865__auto___70766]));

var G__70767 = (i__4865__auto___70766 + (1));
i__4865__auto___70766 = G__70767;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.address.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.address.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67902 = conformed_args__65516__auto__;
var map__67902__$1 = cljs.core.__destructure_map(map__67902);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67902__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67902__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67902__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("address",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.address.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.address.cljs$lang$applyTo = (function (seq67893){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67893));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (caption "hello")
 * (caption nil "hello")
 * 
 * These two are made equivalent at compile time
 * (caption {:onClick f} "hello")
 * (caption #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (caption :#the-id.klass.other-klass "hello")
 * (caption :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.caption = (function com$fulcrologic$fulcro$dom$caption(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70768 = arguments.length;
var i__4865__auto___70770 = (0);
while(true){
if((i__4865__auto___70770 < len__4864__auto___70768)){
args__4870__auto__.push((arguments[i__4865__auto___70770]));

var G__70772 = (i__4865__auto___70770 + (1));
i__4865__auto___70770 = G__70772;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.caption.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.caption.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67910 = conformed_args__65516__auto__;
var map__67910__$1 = cljs.core.__destructure_map(map__67910);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67910__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67910__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67910__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("caption",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.caption.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.caption.cljs$lang$applyTo = (function (seq67906){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67906));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dd "hello")
 * (dd nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dd {:onClick f} "hello")
 * (dd #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dd :#the-id.klass.other-klass "hello")
 * (dd :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dd = (function com$fulcrologic$fulcro$dom$dd(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70774 = arguments.length;
var i__4865__auto___70775 = (0);
while(true){
if((i__4865__auto___70775 < len__4864__auto___70774)){
args__4870__auto__.push((arguments[i__4865__auto___70775]));

var G__70776 = (i__4865__auto___70775 + (1));
i__4865__auto___70775 = G__70776;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dd.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dd.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67917 = conformed_args__65516__auto__;
var map__67917__$1 = cljs.core.__destructure_map(map__67917);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67917__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67917__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67917__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dd",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.dd.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dd.cljs$lang$applyTo = (function (seq67912){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67912));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rp "hello")
 * (rp nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rp {:onClick f} "hello")
 * (rp #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rp :#the-id.klass.other-klass "hello")
 * (rp :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.rp = (function com$fulcrologic$fulcro$dom$rp(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70779 = arguments.length;
var i__4865__auto___70780 = (0);
while(true){
if((i__4865__auto___70780 < len__4864__auto___70779)){
args__4870__auto__.push((arguments[i__4865__auto___70780]));

var G__70781 = (i__4865__auto___70780 + (1));
i__4865__auto___70780 = G__70781;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.rp.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.rp.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67936 = conformed_args__65516__auto__;
var map__67936__$1 = cljs.core.__destructure_map(map__67936);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67936__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67936__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67936__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("rp",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.rp.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.rp.cljs$lang$applyTo = (function (seq67931){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67931));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hr "hello")
 * (hr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hr {:onClick f} "hello")
 * (hr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hr :#the-id.klass.other-klass "hello")
 * (hr :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.hr = (function com$fulcrologic$fulcro$dom$hr(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70794 = arguments.length;
var i__4865__auto___70795 = (0);
while(true){
if((i__4865__auto___70795 < len__4864__auto___70794)){
args__4870__auto__.push((arguments[i__4865__auto___70795]));

var G__70796 = (i__4865__auto___70795 + (1));
i__4865__auto___70795 = G__70796;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.hr.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.hr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67944 = conformed_args__65516__auto__;
var map__67944__$1 = cljs.core.__destructure_map(map__67944);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67944__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67944__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67944__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("hr",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.hr.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.hr.cljs$lang$applyTo = (function (seq67939){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67939));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meta "hello")
 * (meta nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meta {:onClick f} "hello")
 * (meta #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meta :#the-id.klass.other-klass "hello")
 * (meta :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meta = (function com$fulcrologic$fulcro$dom$meta(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70799 = arguments.length;
var i__4865__auto___70800 = (0);
while(true){
if((i__4865__auto___70800 < len__4864__auto___70799)){
args__4870__auto__.push((arguments[i__4865__auto___70800]));

var G__70801 = (i__4865__auto___70800 + (1));
i__4865__auto___70800 = G__70801;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meta.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meta.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67953 = conformed_args__65516__auto__;
var map__67953__$1 = cljs.core.__destructure_map(map__67953);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67953__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67953__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67953__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meta",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.meta.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meta.cljs$lang$applyTo = (function (seq67949){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67949));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tbody "hello")
 * (tbody nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tbody {:onClick f} "hello")
 * (tbody #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tbody :#the-id.klass.other-klass "hello")
 * (tbody :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tbody = (function com$fulcrologic$fulcro$dom$tbody(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70808 = arguments.length;
var i__4865__auto___70809 = (0);
while(true){
if((i__4865__auto___70809 < len__4864__auto___70808)){
args__4870__auto__.push((arguments[i__4865__auto___70809]));

var G__70810 = (i__4865__auto___70809 + (1));
i__4865__auto___70809 = G__70810;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tbody.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tbody.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67963 = conformed_args__65516__auto__;
var map__67963__$1 = cljs.core.__destructure_map(map__67963);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67963__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67963__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67963__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tbody",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.tbody.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tbody.cljs$lang$applyTo = (function (seq67959){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67959));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (desc "hello")
 * (desc nil "hello")
 * 
 * These two are made equivalent at compile time
 * (desc {:onClick f} "hello")
 * (desc #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (desc :#the-id.klass.other-klass "hello")
 * (desc :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.desc = (function com$fulcrologic$fulcro$dom$desc(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70812 = arguments.length;
var i__4865__auto___70813 = (0);
while(true){
if((i__4865__auto___70813 < len__4864__auto___70812)){
args__4870__auto__.push((arguments[i__4865__auto___70813]));

var G__70814 = (i__4865__auto___70813 + (1));
i__4865__auto___70813 = G__70814;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.desc.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.desc.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67971 = conformed_args__65516__auto__;
var map__67971__$1 = cljs.core.__destructure_map(map__67971);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67971__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67971__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67971__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("desc",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.desc.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.desc.cljs$lang$applyTo = (function (seq67967){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67967));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (table "hello")
 * (table nil "hello")
 * 
 * These two are made equivalent at compile time
 * (table {:onClick f} "hello")
 * (table #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (table :#the-id.klass.other-klass "hello")
 * (table :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.table = (function com$fulcrologic$fulcro$dom$table(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70818 = arguments.length;
var i__4865__auto___70819 = (0);
while(true){
if((i__4865__auto___70819 < len__4864__auto___70818)){
args__4870__auto__.push((arguments[i__4865__auto___70819]));

var G__70820 = (i__4865__auto___70819 + (1));
i__4865__auto___70819 = G__70820;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.table.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.table.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67979 = conformed_args__65516__auto__;
var map__67979__$1 = cljs.core.__destructure_map(map__67979);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67979__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67979__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67979__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("table",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.table.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.table.cljs$lang$applyTo = (function (seq67975){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67975));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (pre "hello")
 * (pre nil "hello")
 * 
 * These two are made equivalent at compile time
 * (pre {:onClick f} "hello")
 * (pre #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (pre :#the-id.klass.other-klass "hello")
 * (pre :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.pre = (function com$fulcrologic$fulcro$dom$pre(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70821 = arguments.length;
var i__4865__auto___70822 = (0);
while(true){
if((i__4865__auto___70822 < len__4864__auto___70821)){
args__4870__auto__.push((arguments[i__4865__auto___70822]));

var G__70823 = (i__4865__auto___70822 + (1));
i__4865__auto___70822 = G__70823;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.pre.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.pre.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67988 = conformed_args__65516__auto__;
var map__67988__$1 = cljs.core.__destructure_map(map__67988);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67988__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67988__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67988__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("pre",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.pre.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.pre.cljs$lang$applyTo = (function (seq67984){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67984));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ul "hello")
 * (ul nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ul {:onClick f} "hello")
 * (ul #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ul :#the-id.klass.other-klass "hello")
 * (ul :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ul = (function com$fulcrologic$fulcro$dom$ul(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70824 = arguments.length;
var i__4865__auto___70825 = (0);
while(true){
if((i__4865__auto___70825 < len__4864__auto___70824)){
args__4870__auto__.push((arguments[i__4865__auto___70825]));

var G__70826 = (i__4865__auto___70825 + (1));
i__4865__auto___70825 = G__70826;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ul.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68003 = conformed_args__65516__auto__;
var map__68003__$1 = cljs.core.__destructure_map(map__68003);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68003__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68003__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68003__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ul",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.ul.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ul.cljs$lang$applyTo = (function (seq67993){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67993));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feConvolveMatrix "hello")
 * (feConvolveMatrix nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feConvolveMatrix {:onClick f} "hello")
 * (feConvolveMatrix #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feConvolveMatrix :#the-id.klass.other-klass "hello")
 * (feConvolveMatrix :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feConvolveMatrix = (function com$fulcrologic$fulcro$dom$feConvolveMatrix(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70829 = arguments.length;
var i__4865__auto___70830 = (0);
while(true){
if((i__4865__auto___70830 < len__4864__auto___70829)){
args__4870__auto__.push((arguments[i__4865__auto___70830]));

var G__70831 = (i__4865__auto___70830 + (1));
i__4865__auto___70830 = G__70831;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feConvolveMatrix.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feConvolveMatrix.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68015 = conformed_args__65516__auto__;
var map__68015__$1 = cljs.core.__destructure_map(map__68015);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68015__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68015__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68015__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feConvolveMatrix",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feConvolveMatrix.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feConvolveMatrix.cljs$lang$applyTo = (function (seq68012){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68012));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (sup "hello")
 * (sup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (sup {:onClick f} "hello")
 * (sup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (sup :#the-id.klass.other-klass "hello")
 * (sup :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.sup = (function com$fulcrologic$fulcro$dom$sup(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70832 = arguments.length;
var i__4865__auto___70833 = (0);
while(true){
if((i__4865__auto___70833 < len__4864__auto___70832)){
args__4870__auto__.push((arguments[i__4865__auto___70833]));

var G__70834 = (i__4865__auto___70833 + (1));
i__4865__auto___70833 = G__70834;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.sup.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.sup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68024 = conformed_args__65516__auto__;
var map__68024__$1 = cljs.core.__destructure_map(map__68024);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68024__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68024__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68024__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("sup",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.sup.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.sup.cljs$lang$applyTo = (function (seq68020){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68020));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dfn "hello")
 * (dfn nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dfn {:onClick f} "hello")
 * (dfn #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dfn :#the-id.klass.other-klass "hello")
 * (dfn :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dfn = (function com$fulcrologic$fulcro$dom$dfn(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70835 = arguments.length;
var i__4865__auto___70836 = (0);
while(true){
if((i__4865__auto___70836 < len__4864__auto___70835)){
args__4870__auto__.push((arguments[i__4865__auto___70836]));

var G__70837 = (i__4865__auto___70836 + (1));
i__4865__auto___70836 = G__70837;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dfn.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dfn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68034 = conformed_args__65516__auto__;
var map__68034__$1 = cljs.core.__destructure_map(map__68034);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68034__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68034__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68034__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dfn",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.dfn.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dfn.cljs$lang$applyTo = (function (seq68027){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68027));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (sub "hello")
 * (sub nil "hello")
 * 
 * These two are made equivalent at compile time
 * (sub {:onClick f} "hello")
 * (sub #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (sub :#the-id.klass.other-klass "hello")
 * (sub :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.sub = (function com$fulcrologic$fulcro$dom$sub(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70840 = arguments.length;
var i__4865__auto___70841 = (0);
while(true){
if((i__4865__auto___70841 < len__4864__auto___70840)){
args__4870__auto__.push((arguments[i__4865__auto___70841]));

var G__70842 = (i__4865__auto___70841 + (1));
i__4865__auto___70841 = G__70842;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68043 = conformed_args__65516__auto__;
var map__68043__$1 = cljs.core.__destructure_map(map__68043);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68043__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68043__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68043__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("sub",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.sub.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.sub.cljs$lang$applyTo = (function (seq68039){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68039));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mark "hello")
 * (mark nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mark {:onClick f} "hello")
 * (mark #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mark :#the-id.klass.other-klass "hello")
 * (mark :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.mark = (function com$fulcrologic$fulcro$dom$mark(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70843 = arguments.length;
var i__4865__auto___70844 = (0);
while(true){
if((i__4865__auto___70844 < len__4864__auto___70843)){
args__4870__auto__.push((arguments[i__4865__auto___70844]));

var G__70846 = (i__4865__auto___70844 + (1));
i__4865__auto___70844 = G__70846;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.mark.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.mark.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68052 = conformed_args__65516__auto__;
var map__68052__$1 = cljs.core.__destructure_map(map__68052);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68052__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68052__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68052__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("mark",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.mark.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.mark.cljs$lang$applyTo = (function (seq68047){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68047));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDisplacementMap "hello")
 * (feDisplacementMap nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDisplacementMap {:onClick f} "hello")
 * (feDisplacementMap #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDisplacementMap :#the-id.klass.other-klass "hello")
 * (feDisplacementMap :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feDisplacementMap = (function com$fulcrologic$fulcro$dom$feDisplacementMap(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70849 = arguments.length;
var i__4865__auto___70850 = (0);
while(true){
if((i__4865__auto___70850 < len__4864__auto___70849)){
args__4870__auto__.push((arguments[i__4865__auto___70850]));

var G__70851 = (i__4865__auto___70850 + (1));
i__4865__auto___70850 = G__70851;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feDisplacementMap.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feDisplacementMap.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68066 = conformed_args__65516__auto__;
var map__68066__$1 = cljs.core.__destructure_map(map__68066);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68066__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68066__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68066__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feDisplacementMap",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feDisplacementMap.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feDisplacementMap.cljs$lang$applyTo = (function (seq68063){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68063));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (unknown "hello")
 * (unknown nil "hello")
 * 
 * These two are made equivalent at compile time
 * (unknown {:onClick f} "hello")
 * (unknown #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (unknown :#the-id.klass.other-klass "hello")
 * (unknown :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.unknown = (function com$fulcrologic$fulcro$dom$unknown(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70858 = arguments.length;
var i__4865__auto___70859 = (0);
while(true){
if((i__4865__auto___70859 < len__4864__auto___70858)){
args__4870__auto__.push((arguments[i__4865__auto___70859]));

var G__70860 = (i__4865__auto___70859 + (1));
i__4865__auto___70859 = G__70860;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.unknown.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.unknown.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68076 = conformed_args__65516__auto__;
var map__68076__$1 = cljs.core.__destructure_map(map__68076);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68076__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68076__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68076__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("unknown",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.unknown.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.unknown.cljs$lang$applyTo = (function (seq68072){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68072));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (script "hello")
 * (script nil "hello")
 * 
 * These two are made equivalent at compile time
 * (script {:onClick f} "hello")
 * (script #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (script :#the-id.klass.other-klass "hello")
 * (script :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.script = (function com$fulcrologic$fulcro$dom$script(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70866 = arguments.length;
var i__4865__auto___70867 = (0);
while(true){
if((i__4865__auto___70867 < len__4864__auto___70866)){
args__4870__auto__.push((arguments[i__4865__auto___70867]));

var G__70868 = (i__4865__auto___70867 + (1));
i__4865__auto___70867 = G__70868;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.script.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.script.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68088 = conformed_args__65516__auto__;
var map__68088__$1 = cljs.core.__destructure_map(map__68088);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68088__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68088__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68088__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("script",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.script.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.script.cljs$lang$applyTo = (function (seq68083){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68083));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feTurbulence "hello")
 * (feTurbulence nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feTurbulence {:onClick f} "hello")
 * (feTurbulence #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feTurbulence :#the-id.klass.other-klass "hello")
 * (feTurbulence :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feTurbulence = (function com$fulcrologic$fulcro$dom$feTurbulence(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70873 = arguments.length;
var i__4865__auto___70874 = (0);
while(true){
if((i__4865__auto___70874 < len__4864__auto___70873)){
args__4870__auto__.push((arguments[i__4865__auto___70874]));

var G__70875 = (i__4865__auto___70874 + (1));
i__4865__auto___70874 = G__70875;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feTurbulence.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feTurbulence.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68099 = conformed_args__65516__auto__;
var map__68099__$1 = cljs.core.__destructure_map(map__68099);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68099__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68099__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68099__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feTurbulence",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feTurbulence.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feTurbulence.cljs$lang$applyTo = (function (seq68094){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68094));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (big "hello")
 * (big nil "hello")
 * 
 * These two are made equivalent at compile time
 * (big {:onClick f} "hello")
 * (big #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (big :#the-id.klass.other-klass "hello")
 * (big :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.big = (function com$fulcrologic$fulcro$dom$big(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70879 = arguments.length;
var i__4865__auto___70880 = (0);
while(true){
if((i__4865__auto___70880 < len__4864__auto___70879)){
args__4870__auto__.push((arguments[i__4865__auto___70880]));

var G__70881 = (i__4865__auto___70880 + (1));
i__4865__auto___70880 = G__70881;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.big.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.big.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68106 = conformed_args__65516__auto__;
var map__68106__$1 = cljs.core.__destructure_map(map__68106);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68106__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68106__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68106__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("big",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.big.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.big.cljs$lang$applyTo = (function (seq68103){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68103));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (button "hello")
 * (button nil "hello")
 * 
 * These two are made equivalent at compile time
 * (button {:onClick f} "hello")
 * (button #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (button :#the-id.klass.other-klass "hello")
 * (button :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.button = (function com$fulcrologic$fulcro$dom$button(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70883 = arguments.length;
var i__4865__auto___70884 = (0);
while(true){
if((i__4865__auto___70884 < len__4864__auto___70883)){
args__4870__auto__.push((arguments[i__4865__auto___70884]));

var G__70885 = (i__4865__auto___70884 + (1));
i__4865__auto___70884 = G__70885;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.button.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.button.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68130 = conformed_args__65516__auto__;
var map__68130__$1 = cljs.core.__destructure_map(map__68130);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68130__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68130__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68130__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("button",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.button.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.button.cljs$lang$applyTo = (function (seq68111){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68111));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-uri "hello")
 * (font-face-uri nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-uri {:onClick f} "hello")
 * (font-face-uri #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-uri :#the-id.klass.other-klass "hello")
 * (font-face-uri :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face_uri = (function com$fulcrologic$fulcro$dom$font_face_uri(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70888 = arguments.length;
var i__4865__auto___70889 = (0);
while(true){
if((i__4865__auto___70889 < len__4864__auto___70888)){
args__4870__auto__.push((arguments[i__4865__auto___70889]));

var G__70890 = (i__4865__auto___70889 + (1));
i__4865__auto___70889 = G__70890;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face_uri.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face_uri.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68177 = conformed_args__65516__auto__;
var map__68177__$1 = cljs.core.__destructure_map(map__68177);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68177__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68177__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68177__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face-uri",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face_uri.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face_uri.cljs$lang$applyTo = (function (seq68163){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68163));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (wbr "hello")
 * (wbr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (wbr {:onClick f} "hello")
 * (wbr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (wbr :#the-id.klass.other-klass "hello")
 * (wbr :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.wbr = (function com$fulcrologic$fulcro$dom$wbr(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70891 = arguments.length;
var i__4865__auto___70892 = (0);
while(true){
if((i__4865__auto___70892 < len__4864__auto___70891)){
args__4870__auto__.push((arguments[i__4865__auto___70892]));

var G__70893 = (i__4865__auto___70892 + (1));
i__4865__auto___70892 = G__70893;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.wbr.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.wbr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68191 = conformed_args__65516__auto__;
var map__68191__$1 = cljs.core.__destructure_map(map__68191);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68191__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68191__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68191__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("wbr",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.wbr.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.wbr.cljs$lang$applyTo = (function (seq68184){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68184));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (symbol "hello")
 * (symbol nil "hello")
 * 
 * These two are made equivalent at compile time
 * (symbol {:onClick f} "hello")
 * (symbol #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (symbol :#the-id.klass.other-klass "hello")
 * (symbol :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.symbol = (function com$fulcrologic$fulcro$dom$symbol(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70896 = arguments.length;
var i__4865__auto___70897 = (0);
while(true){
if((i__4865__auto___70897 < len__4864__auto___70896)){
args__4870__auto__.push((arguments[i__4865__auto___70897]));

var G__70898 = (i__4865__auto___70897 + (1));
i__4865__auto___70897 = G__70898;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.symbol.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.symbol.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68222 = conformed_args__65516__auto__;
var map__68222__$1 = cljs.core.__destructure_map(map__68222);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68222__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68222__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68222__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("symbol",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.symbol.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.symbol.cljs$lang$applyTo = (function (seq68201){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68201));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (strong "hello")
 * (strong nil "hello")
 * 
 * These two are made equivalent at compile time
 * (strong {:onClick f} "hello")
 * (strong #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (strong :#the-id.klass.other-klass "hello")
 * (strong :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.strong = (function com$fulcrologic$fulcro$dom$strong(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70904 = arguments.length;
var i__4865__auto___70905 = (0);
while(true){
if((i__4865__auto___70905 < len__4864__auto___70904)){
args__4870__auto__.push((arguments[i__4865__auto___70905]));

var G__70906 = (i__4865__auto___70905 + (1));
i__4865__auto___70905 = G__70906;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.strong.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.strong.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68253 = conformed_args__65516__auto__;
var map__68253__$1 = cljs.core.__destructure_map(map__68253);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68253__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68253__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68253__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("strong",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.strong.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.strong.cljs$lang$applyTo = (function (seq68247){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68247));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (use "hello")
 * (use nil "hello")
 * 
 * These two are made equivalent at compile time
 * (use {:onClick f} "hello")
 * (use #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (use :#the-id.klass.other-klass "hello")
 * (use :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.use = (function com$fulcrologic$fulcro$dom$use(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70911 = arguments.length;
var i__4865__auto___70912 = (0);
while(true){
if((i__4865__auto___70912 < len__4864__auto___70911)){
args__4870__auto__.push((arguments[i__4865__auto___70912]));

var G__70913 = (i__4865__auto___70912 + (1));
i__4865__auto___70912 = G__70913;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.use.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.use.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68271 = conformed_args__65516__auto__;
var map__68271__$1 = cljs.core.__destructure_map(map__68271);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68271__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68271__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68271__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("use",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.use.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.use.cljs$lang$applyTo = (function (seq68263){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68263));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (solidcolor "hello")
 * (solidcolor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (solidcolor {:onClick f} "hello")
 * (solidcolor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (solidcolor :#the-id.klass.other-klass "hello")
 * (solidcolor :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.solidcolor = (function com$fulcrologic$fulcro$dom$solidcolor(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70918 = arguments.length;
var i__4865__auto___70919 = (0);
while(true){
if((i__4865__auto___70919 < len__4864__auto___70918)){
args__4870__auto__.push((arguments[i__4865__auto___70919]));

var G__70920 = (i__4865__auto___70919 + (1));
i__4865__auto___70919 = G__70920;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.solidcolor.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.solidcolor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68284 = conformed_args__65516__auto__;
var map__68284__$1 = cljs.core.__destructure_map(map__68284);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68284__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68284__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68284__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("solidcolor",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.solidcolor.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.solidcolor.cljs$lang$applyTo = (function (seq68277){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68277));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (fePointLight "hello")
 * (fePointLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (fePointLight {:onClick f} "hello")
 * (fePointLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (fePointLight :#the-id.klass.other-klass "hello")
 * (fePointLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.fePointLight = (function com$fulcrologic$fulcro$dom$fePointLight(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70934 = arguments.length;
var i__4865__auto___70935 = (0);
while(true){
if((i__4865__auto___70935 < len__4864__auto___70934)){
args__4870__auto__.push((arguments[i__4865__auto___70935]));

var G__70936 = (i__4865__auto___70935 + (1));
i__4865__auto___70935 = G__70936;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.fePointLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.fePointLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68301 = conformed_args__65516__auto__;
var map__68301__$1 = cljs.core.__destructure_map(map__68301);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68301__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68301__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68301__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("fePointLight",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.fePointLight.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.fePointLight.cljs$lang$applyTo = (function (seq68293){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68293));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (li "hello")
 * (li nil "hello")
 * 
 * These two are made equivalent at compile time
 * (li {:onClick f} "hello")
 * (li #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (li :#the-id.klass.other-klass "hello")
 * (li :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.li = (function com$fulcrologic$fulcro$dom$li(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70939 = arguments.length;
var i__4865__auto___70940 = (0);
while(true){
if((i__4865__auto___70940 < len__4864__auto___70939)){
args__4870__auto__.push((arguments[i__4865__auto___70940]));

var G__70941 = (i__4865__auto___70940 + (1));
i__4865__auto___70940 = G__70941;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.li.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.li.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68313 = conformed_args__65516__auto__;
var map__68313__$1 = cljs.core.__destructure_map(map__68313);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68313__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68313__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68313__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("li",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.li.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.li.cljs$lang$applyTo = (function (seq68311){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68311));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dt "hello")
 * (dt nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dt {:onClick f} "hello")
 * (dt #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dt :#the-id.klass.other-klass "hello")
 * (dt :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dt = (function com$fulcrologic$fulcro$dom$dt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70942 = arguments.length;
var i__4865__auto___70943 = (0);
while(true){
if((i__4865__auto___70943 < len__4864__auto___70942)){
args__4870__auto__.push((arguments[i__4865__auto___70943]));

var G__70944 = (i__4865__auto___70943 + (1));
i__4865__auto___70943 = G__70944;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dt.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dt.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68326 = conformed_args__65516__auto__;
var map__68326__$1 = cljs.core.__destructure_map(map__68326);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68326__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68326__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68326__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dt",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.dt.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dt.cljs$lang$applyTo = (function (seq68318){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68318));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncB "hello")
 * (feFuncB nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncB {:onClick f} "hello")
 * (feFuncB #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncB :#the-id.klass.other-klass "hello")
 * (feFuncB :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFuncB = (function com$fulcrologic$fulcro$dom$feFuncB(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70950 = arguments.length;
var i__4865__auto___70951 = (0);
while(true){
if((i__4865__auto___70951 < len__4864__auto___70950)){
args__4870__auto__.push((arguments[i__4865__auto___70951]));

var G__70953 = (i__4865__auto___70951 + (1));
i__4865__auto___70951 = G__70953;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFuncB.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFuncB.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68330 = conformed_args__65516__auto__;
var map__68330__$1 = cljs.core.__destructure_map(map__68330);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68330__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68330__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68330__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFuncB",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feFuncB.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFuncB.cljs$lang$applyTo = (function (seq68327){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68327));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (marker "hello")
 * (marker nil "hello")
 * 
 * These two are made equivalent at compile time
 * (marker {:onClick f} "hello")
 * (marker #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (marker :#the-id.klass.other-klass "hello")
 * (marker :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.marker = (function com$fulcrologic$fulcro$dom$marker(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70954 = arguments.length;
var i__4865__auto___70955 = (0);
while(true){
if((i__4865__auto___70955 < len__4864__auto___70954)){
args__4870__auto__.push((arguments[i__4865__auto___70955]));

var G__70956 = (i__4865__auto___70955 + (1));
i__4865__auto___70955 = G__70956;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.marker.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.marker.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68345 = conformed_args__65516__auto__;
var map__68345__$1 = cljs.core.__destructure_map(map__68345);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68345__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68345__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68345__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("marker",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.marker.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.marker.cljs$lang$applyTo = (function (seq68334){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68334));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feComponentTransfer "hello")
 * (feComponentTransfer nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feComponentTransfer {:onClick f} "hello")
 * (feComponentTransfer #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feComponentTransfer :#the-id.klass.other-klass "hello")
 * (feComponentTransfer :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feComponentTransfer = (function com$fulcrologic$fulcro$dom$feComponentTransfer(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70957 = arguments.length;
var i__4865__auto___70959 = (0);
while(true){
if((i__4865__auto___70959 < len__4864__auto___70957)){
args__4870__auto__.push((arguments[i__4865__auto___70959]));

var G__70960 = (i__4865__auto___70959 + (1));
i__4865__auto___70959 = G__70960;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feComponentTransfer.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feComponentTransfer.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68359 = conformed_args__65516__auto__;
var map__68359__$1 = cljs.core.__destructure_map(map__68359);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68359__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68359__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68359__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feComponentTransfer",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feComponentTransfer.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feComponentTransfer.cljs$lang$applyTo = (function (seq68352){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68352));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (td "hello")
 * (td nil "hello")
 * 
 * These two are made equivalent at compile time
 * (td {:onClick f} "hello")
 * (td #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (td :#the-id.klass.other-klass "hello")
 * (td :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.td = (function com$fulcrologic$fulcro$dom$td(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70968 = arguments.length;
var i__4865__auto___70969 = (0);
while(true){
if((i__4865__auto___70969 < len__4864__auto___70968)){
args__4870__auto__.push((arguments[i__4865__auto___70969]));

var G__70970 = (i__4865__auto___70969 + (1));
i__4865__auto___70969 = G__70970;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.td.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.td.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68377 = conformed_args__65516__auto__;
var map__68377__$1 = cljs.core.__destructure_map(map__68377);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68377__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68377__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68377__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("td",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.td.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.td.cljs$lang$applyTo = (function (seq68368){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68368));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tr "hello")
 * (tr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tr {:onClick f} "hello")
 * (tr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tr :#the-id.klass.other-klass "hello")
 * (tr :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tr = (function com$fulcrologic$fulcro$dom$tr(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70971 = arguments.length;
var i__4865__auto___70972 = (0);
while(true){
if((i__4865__auto___70972 < len__4864__auto___70971)){
args__4870__auto__.push((arguments[i__4865__auto___70972]));

var G__70973 = (i__4865__auto___70972 + (1));
i__4865__auto___70972 = G__70973;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tr.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68398 = conformed_args__65516__auto__;
var map__68398__$1 = cljs.core.__destructure_map(map__68398);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68398__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68398__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68398__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tr",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.tr.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tr.cljs$lang$applyTo = (function (seq68389){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68389));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (circle "hello")
 * (circle nil "hello")
 * 
 * These two are made equivalent at compile time
 * (circle {:onClick f} "hello")
 * (circle #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (circle :#the-id.klass.other-klass "hello")
 * (circle :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.circle = (function com$fulcrologic$fulcro$dom$circle(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70974 = arguments.length;
var i__4865__auto___70975 = (0);
while(true){
if((i__4865__auto___70975 < len__4864__auto___70974)){
args__4870__auto__.push((arguments[i__4865__auto___70975]));

var G__70976 = (i__4865__auto___70975 + (1));
i__4865__auto___70975 = G__70976;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.circle.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.circle.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68426 = conformed_args__65516__auto__;
var map__68426__$1 = cljs.core.__destructure_map(map__68426);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68426__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68426__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68426__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("circle",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.circle.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.circle.cljs$lang$applyTo = (function (seq68407){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68407));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (section "hello")
 * (section nil "hello")
 * 
 * These two are made equivalent at compile time
 * (section {:onClick f} "hello")
 * (section #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (section :#the-id.klass.other-klass "hello")
 * (section :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.section = (function com$fulcrologic$fulcro$dom$section(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70978 = arguments.length;
var i__4865__auto___70979 = (0);
while(true){
if((i__4865__auto___70979 < len__4864__auto___70978)){
args__4870__auto__.push((arguments[i__4865__auto___70979]));

var G__70980 = (i__4865__auto___70979 + (1));
i__4865__auto___70979 = G__70980;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.section.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.section.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68441 = conformed_args__65516__auto__;
var map__68441__$1 = cljs.core.__destructure_map(map__68441);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68441__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68441__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68441__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("section",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.section.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.section.cljs$lang$applyTo = (function (seq68438){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68438));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDropShadow "hello")
 * (feDropShadow nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDropShadow {:onClick f} "hello")
 * (feDropShadow #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDropShadow :#the-id.klass.other-klass "hello")
 * (feDropShadow :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feDropShadow = (function com$fulcrologic$fulcro$dom$feDropShadow(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70984 = arguments.length;
var i__4865__auto___70985 = (0);
while(true){
if((i__4865__auto___70985 < len__4864__auto___70984)){
args__4870__auto__.push((arguments[i__4865__auto___70985]));

var G__70986 = (i__4865__auto___70985 + (1));
i__4865__auto___70985 = G__70986;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feDropShadow.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feDropShadow.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68481 = conformed_args__65516__auto__;
var map__68481__$1 = cljs.core.__destructure_map(map__68481);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68481__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68481__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68481__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feDropShadow",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feDropShadow.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feDropShadow.cljs$lang$applyTo = (function (seq68458){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68458));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (th "hello")
 * (th nil "hello")
 * 
 * These two are made equivalent at compile time
 * (th {:onClick f} "hello")
 * (th #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (th :#the-id.klass.other-klass "hello")
 * (th :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.th = (function com$fulcrologic$fulcro$dom$th(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70988 = arguments.length;
var i__4865__auto___70989 = (0);
while(true){
if((i__4865__auto___70989 < len__4864__auto___70988)){
args__4870__auto__.push((arguments[i__4865__auto___70989]));

var G__70990 = (i__4865__auto___70989 + (1));
i__4865__auto___70989 = G__70990;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.th.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.th.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68496 = conformed_args__65516__auto__;
var map__68496__$1 = cljs.core.__destructure_map(map__68496);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68496__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68496__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68496__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("th",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.th.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.th.cljs$lang$applyTo = (function (seq68489){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68489));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (time "hello")
 * (time nil "hello")
 * 
 * These two are made equivalent at compile time
 * (time {:onClick f} "hello")
 * (time #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (time :#the-id.klass.other-klass "hello")
 * (time :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.time = (function com$fulcrologic$fulcro$dom$time(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70991 = arguments.length;
var i__4865__auto___70992 = (0);
while(true){
if((i__4865__auto___70992 < len__4864__auto___70991)){
args__4870__auto__.push((arguments[i__4865__auto___70992]));

var G__70993 = (i__4865__auto___70992 + (1));
i__4865__auto___70992 = G__70993;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.time.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.time.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68529 = conformed_args__65516__auto__;
var map__68529__$1 = cljs.core.__destructure_map(map__68529);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68529__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68529__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68529__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("time",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.time.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.time.cljs$lang$applyTo = (function (seq68512){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68512));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (optgroup "hello")
 * (optgroup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (optgroup {:onClick f} "hello")
 * (optgroup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (optgroup :#the-id.klass.other-klass "hello")
 * (optgroup :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.optgroup = (function com$fulcrologic$fulcro$dom$optgroup(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70995 = arguments.length;
var i__4865__auto___70996 = (0);
while(true){
if((i__4865__auto___70996 < len__4864__auto___70995)){
args__4870__auto__.push((arguments[i__4865__auto___70996]));

var G__70997 = (i__4865__auto___70996 + (1));
i__4865__auto___70996 = G__70997;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68553 = conformed_args__65516__auto__;
var map__68553__$1 = cljs.core.__destructure_map(map__68553);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68553__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68553__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68553__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("optgroup",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.optgroup.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.optgroup.cljs$lang$applyTo = (function (seq68536){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68536));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (iframe "hello")
 * (iframe nil "hello")
 * 
 * These two are made equivalent at compile time
 * (iframe {:onClick f} "hello")
 * (iframe #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (iframe :#the-id.klass.other-klass "hello")
 * (iframe :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.iframe = (function com$fulcrologic$fulcro$dom$iframe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70998 = arguments.length;
var i__4865__auto___70999 = (0);
while(true){
if((i__4865__auto___70999 < len__4864__auto___70998)){
args__4870__auto__.push((arguments[i__4865__auto___70999]));

var G__71000 = (i__4865__auto___70999 + (1));
i__4865__auto___70999 = G__71000;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.iframe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.iframe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68578 = conformed_args__65516__auto__;
var map__68578__$1 = cljs.core.__destructure_map(map__68578);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68578__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68578__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68578__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("iframe",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.iframe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.iframe.cljs$lang$applyTo = (function (seq68568){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68568));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (color-profile "hello")
 * (color-profile nil "hello")
 * 
 * These two are made equivalent at compile time
 * (color-profile {:onClick f} "hello")
 * (color-profile #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (color-profile :#the-id.klass.other-klass "hello")
 * (color-profile :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.color_profile = (function com$fulcrologic$fulcro$dom$color_profile(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71002 = arguments.length;
var i__4865__auto___71003 = (0);
while(true){
if((i__4865__auto___71003 < len__4864__auto___71002)){
args__4870__auto__.push((arguments[i__4865__auto___71003]));

var G__71007 = (i__4865__auto___71003 + (1));
i__4865__auto___71003 = G__71007;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.color_profile.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.color_profile.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68593 = conformed_args__65516__auto__;
var map__68593__$1 = cljs.core.__destructure_map(map__68593);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68593__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68593__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68593__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("color-profile",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.color_profile.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.color_profile.cljs$lang$applyTo = (function (seq68585){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68585));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (legend "hello")
 * (legend nil "hello")
 * 
 * These two are made equivalent at compile time
 * (legend {:onClick f} "hello")
 * (legend #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (legend :#the-id.klass.other-klass "hello")
 * (legend :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.legend = (function com$fulcrologic$fulcro$dom$legend(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71008 = arguments.length;
var i__4865__auto___71009 = (0);
while(true){
if((i__4865__auto___71009 < len__4864__auto___71008)){
args__4870__auto__.push((arguments[i__4865__auto___71009]));

var G__71010 = (i__4865__auto___71009 + (1));
i__4865__auto___71009 = G__71010;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.legend.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.legend.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68619 = conformed_args__65516__auto__;
var map__68619__$1 = cljs.core.__destructure_map(map__68619);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68619__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68619__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68619__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("legend",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.legend.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.legend.cljs$lang$applyTo = (function (seq68603){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68603));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (em "hello")
 * (em nil "hello")
 * 
 * These two are made equivalent at compile time
 * (em {:onClick f} "hello")
 * (em #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (em :#the-id.klass.other-klass "hello")
 * (em :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.em = (function com$fulcrologic$fulcro$dom$em(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71013 = arguments.length;
var i__4865__auto___71015 = (0);
while(true){
if((i__4865__auto___71015 < len__4864__auto___71013)){
args__4870__auto__.push((arguments[i__4865__auto___71015]));

var G__71017 = (i__4865__auto___71015 + (1));
i__4865__auto___71015 = G__71017;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.em.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.em.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68672 = conformed_args__65516__auto__;
var map__68672__$1 = cljs.core.__destructure_map(map__68672);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68672__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68672__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68672__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("em",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.em.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.em.cljs$lang$applyTo = (function (seq68646){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68646));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (kbd "hello")
 * (kbd nil "hello")
 * 
 * These two are made equivalent at compile time
 * (kbd {:onClick f} "hello")
 * (kbd #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (kbd :#the-id.klass.other-klass "hello")
 * (kbd :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.kbd = (function com$fulcrologic$fulcro$dom$kbd(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71028 = arguments.length;
var i__4865__auto___71029 = (0);
while(true){
if((i__4865__auto___71029 < len__4864__auto___71028)){
args__4870__auto__.push((arguments[i__4865__auto___71029]));

var G__71030 = (i__4865__auto___71029 + (1));
i__4865__auto___71029 = G__71030;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.kbd.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.kbd.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68727 = conformed_args__65516__auto__;
var map__68727__$1 = cljs.core.__destructure_map(map__68727);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68727__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68727__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68727__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("kbd",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.kbd.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.kbd.cljs$lang$applyTo = (function (seq68705){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68705));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (article "hello")
 * (article nil "hello")
 * 
 * These two are made equivalent at compile time
 * (article {:onClick f} "hello")
 * (article #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (article :#the-id.klass.other-klass "hello")
 * (article :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.article = (function com$fulcrologic$fulcro$dom$article(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71032 = arguments.length;
var i__4865__auto___71033 = (0);
while(true){
if((i__4865__auto___71033 < len__4864__auto___71032)){
args__4870__auto__.push((arguments[i__4865__auto___71033]));

var G__71034 = (i__4865__auto___71033 + (1));
i__4865__auto___71033 = G__71034;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.article.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.article.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68775 = conformed_args__65516__auto__;
var map__68775__$1 = cljs.core.__destructure_map(map__68775);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68775__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68775__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68775__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("article",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.article.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.article.cljs$lang$applyTo = (function (seq68748){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68748));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateColor "hello")
 * (animateColor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateColor {:onClick f} "hello")
 * (animateColor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateColor :#the-id.klass.other-klass "hello")
 * (animateColor :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.animateColor = (function com$fulcrologic$fulcro$dom$animateColor(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71035 = arguments.length;
var i__4865__auto___71036 = (0);
while(true){
if((i__4865__auto___71036 < len__4864__auto___71035)){
args__4870__auto__.push((arguments[i__4865__auto___71036]));

var G__71037 = (i__4865__auto___71036 + (1));
i__4865__auto___71036 = G__71037;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.animateColor.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.animateColor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68800 = conformed_args__65516__auto__;
var map__68800__$1 = cljs.core.__destructure_map(map__68800);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68800__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68800__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68800__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("animateColor",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.animateColor.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.animateColor.cljs$lang$applyTo = (function (seq68789){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68789));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (clipPath "hello")
 * (clipPath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (clipPath {:onClick f} "hello")
 * (clipPath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (clipPath :#the-id.klass.other-klass "hello")
 * (clipPath :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.clipPath = (function com$fulcrologic$fulcro$dom$clipPath(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71038 = arguments.length;
var i__4865__auto___71039 = (0);
while(true){
if((i__4865__auto___71039 < len__4864__auto___71038)){
args__4870__auto__.push((arguments[i__4865__auto___71039]));

var G__71040 = (i__4865__auto___71039 + (1));
i__4865__auto___71039 = G__71040;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68837 = conformed_args__65516__auto__;
var map__68837__$1 = cljs.core.__destructure_map(map__68837);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68837__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68837__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68837__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("clipPath",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.clipPath.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.clipPath.cljs$lang$applyTo = (function (seq68815){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68815));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (abbr "hello")
 * (abbr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (abbr {:onClick f} "hello")
 * (abbr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (abbr :#the-id.klass.other-klass "hello")
 * (abbr :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.abbr = (function com$fulcrologic$fulcro$dom$abbr(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71046 = arguments.length;
var i__4865__auto___71048 = (0);
while(true){
if((i__4865__auto___71048 < len__4864__auto___71046)){
args__4870__auto__.push((arguments[i__4865__auto___71048]));

var G__71049 = (i__4865__auto___71048 + (1));
i__4865__auto___71048 = G__71049;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.abbr.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.abbr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68885 = conformed_args__65516__auto__;
var map__68885__$1 = cljs.core.__destructure_map(map__68885);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68885__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68885__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68885__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("abbr",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.abbr.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.abbr.cljs$lang$applyTo = (function (seq68858){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68858));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyphDef "hello")
 * (altGlyphDef nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyphDef {:onClick f} "hello")
 * (altGlyphDef #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyphDef :#the-id.klass.other-klass "hello")
 * (altGlyphDef :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.altGlyphDef = (function com$fulcrologic$fulcro$dom$altGlyphDef(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71057 = arguments.length;
var i__4865__auto___71058 = (0);
while(true){
if((i__4865__auto___71058 < len__4864__auto___71057)){
args__4870__auto__.push((arguments[i__4865__auto___71058]));

var G__71059 = (i__4865__auto___71058 + (1));
i__4865__auto___71058 = G__71059;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.altGlyphDef.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.altGlyphDef.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68907 = conformed_args__65516__auto__;
var map__68907__$1 = cljs.core.__destructure_map(map__68907);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68907__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68907__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68907__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("altGlyphDef",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.altGlyphDef.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.altGlyphDef.cljs$lang$applyTo = (function (seq68906){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68906));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshrow "hello")
 * (meshrow nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshrow {:onClick f} "hello")
 * (meshrow #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshrow :#the-id.klass.other-klass "hello")
 * (meshrow :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meshrow = (function com$fulcrologic$fulcro$dom$meshrow(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71062 = arguments.length;
var i__4865__auto___71063 = (0);
while(true){
if((i__4865__auto___71063 < len__4864__auto___71062)){
args__4870__auto__.push((arguments[i__4865__auto___71063]));

var G__71064 = (i__4865__auto___71063 + (1));
i__4865__auto___71063 = G__71064;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meshrow.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meshrow.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68944 = conformed_args__65516__auto__;
var map__68944__$1 = cljs.core.__destructure_map(map__68944);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68944__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68944__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68944__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meshrow",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.meshrow.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meshrow.cljs$lang$applyTo = (function (seq68930){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68930));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (cursor "hello")
 * (cursor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (cursor {:onClick f} "hello")
 * (cursor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (cursor :#the-id.klass.other-klass "hello")
 * (cursor :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.cursor = (function com$fulcrologic$fulcro$dom$cursor(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71069 = arguments.length;
var i__4865__auto___71070 = (0);
while(true){
if((i__4865__auto___71070 < len__4864__auto___71069)){
args__4870__auto__.push((arguments[i__4865__auto___71070]));

var G__71072 = (i__4865__auto___71070 + (1));
i__4865__auto___71070 = G__71072;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.cursor.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.cursor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68966 = conformed_args__65516__auto__;
var map__68966__$1 = cljs.core.__destructure_map(map__68966);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68966__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68966__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68966__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("cursor",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.cursor.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.cursor.cljs$lang$applyTo = (function (seq68959){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68959));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animate "hello")
 * (animate nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animate {:onClick f} "hello")
 * (animate #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animate :#the-id.klass.other-klass "hello")
 * (animate :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.animate = (function com$fulcrologic$fulcro$dom$animate(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71073 = arguments.length;
var i__4865__auto___71074 = (0);
while(true){
if((i__4865__auto___71074 < len__4864__auto___71073)){
args__4870__auto__.push((arguments[i__4865__auto___71074]));

var G__71075 = (i__4865__auto___71074 + (1));
i__4865__auto___71074 = G__71075;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.animate.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.animate.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68979 = conformed_args__65516__auto__;
var map__68979__$1 = cljs.core.__destructure_map(map__68979);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68979__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68979__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68979__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("animate",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.animate.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.animate.cljs$lang$applyTo = (function (seq68969){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68969));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (source "hello")
 * (source nil "hello")
 * 
 * These two are made equivalent at compile time
 * (source {:onClick f} "hello")
 * (source #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (source :#the-id.klass.other-klass "hello")
 * (source :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.source = (function com$fulcrologic$fulcro$dom$source(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71079 = arguments.length;
var i__4865__auto___71080 = (0);
while(true){
if((i__4865__auto___71080 < len__4864__auto___71079)){
args__4870__auto__.push((arguments[i__4865__auto___71080]));

var G__71081 = (i__4865__auto___71080 + (1));
i__4865__auto___71080 = G__71081;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.source.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.source.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68991 = conformed_args__65516__auto__;
var map__68991__$1 = cljs.core.__destructure_map(map__68991);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68991__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68991__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68991__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("source",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.source.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.source.cljs$lang$applyTo = (function (seq68982){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68982));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (output "hello")
 * (output nil "hello")
 * 
 * These two are made equivalent at compile time
 * (output {:onClick f} "hello")
 * (output #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (output :#the-id.klass.other-klass "hello")
 * (output :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.output = (function com$fulcrologic$fulcro$dom$output(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71083 = arguments.length;
var i__4865__auto___71084 = (0);
while(true){
if((i__4865__auto___71084 < len__4864__auto___71083)){
args__4870__auto__.push((arguments[i__4865__auto___71084]));

var G__71085 = (i__4865__auto___71084 + (1));
i__4865__auto___71084 = G__71085;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.output.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.output.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69013 = conformed_args__65516__auto__;
var map__69013__$1 = cljs.core.__destructure_map(map__69013);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69013__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69013__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69013__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("output",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.output.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.output.cljs$lang$applyTo = (function (seq69005){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69005));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face "hello")
 * (font-face nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face {:onClick f} "hello")
 * (font-face #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face :#the-id.klass.other-klass "hello")
 * (font-face :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face = (function com$fulcrologic$fulcro$dom$font_face(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71091 = arguments.length;
var i__4865__auto___71092 = (0);
while(true){
if((i__4865__auto___71092 < len__4864__auto___71091)){
args__4870__auto__.push((arguments[i__4865__auto___71092]));

var G__71093 = (i__4865__auto___71092 + (1));
i__4865__auto___71092 = G__71093;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69030 = conformed_args__65516__auto__;
var map__69030__$1 = cljs.core.__destructure_map(map__69030);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69030__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69030__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69030__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face.cljs$lang$applyTo = (function (seq69021){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69021));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMergeNode "hello")
 * (feMergeNode nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMergeNode {:onClick f} "hello")
 * (feMergeNode #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMergeNode :#the-id.klass.other-klass "hello")
 * (feMergeNode :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feMergeNode = (function com$fulcrologic$fulcro$dom$feMergeNode(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71096 = arguments.length;
var i__4865__auto___71097 = (0);
while(true){
if((i__4865__auto___71097 < len__4864__auto___71096)){
args__4870__auto__.push((arguments[i__4865__auto___71097]));

var G__71098 = (i__4865__auto___71097 + (1));
i__4865__auto___71097 = G__71098;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feMergeNode.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feMergeNode.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69064 = conformed_args__65516__auto__;
var map__69064__$1 = cljs.core.__destructure_map(map__69064);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69064__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69064__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69064__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feMergeNode",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feMergeNode.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feMergeNode.cljs$lang$applyTo = (function (seq69051){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69051));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feSpotLight "hello")
 * (feSpotLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feSpotLight {:onClick f} "hello")
 * (feSpotLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feSpotLight :#the-id.klass.other-klass "hello")
 * (feSpotLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feSpotLight = (function com$fulcrologic$fulcro$dom$feSpotLight(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71099 = arguments.length;
var i__4865__auto___71100 = (0);
while(true){
if((i__4865__auto___71100 < len__4864__auto___71099)){
args__4870__auto__.push((arguments[i__4865__auto___71100]));

var G__71101 = (i__4865__auto___71100 + (1));
i__4865__auto___71100 = G__71101;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feSpotLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feSpotLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69073 = conformed_args__65516__auto__;
var map__69073__$1 = cljs.core.__destructure_map(map__69073);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69073__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69073__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69073__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feSpotLight",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feSpotLight.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feSpotLight.cljs$lang$applyTo = (function (seq69070){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69070));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (header "hello")
 * (header nil "hello")
 * 
 * These two are made equivalent at compile time
 * (header {:onClick f} "hello")
 * (header #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (header :#the-id.klass.other-klass "hello")
 * (header :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.header = (function com$fulcrologic$fulcro$dom$header(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71107 = arguments.length;
var i__4865__auto___71108 = (0);
while(true){
if((i__4865__auto___71108 < len__4864__auto___71107)){
args__4870__auto__.push((arguments[i__4865__auto___71108]));

var G__71109 = (i__4865__auto___71108 + (1));
i__4865__auto___71108 = G__71109;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.header.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.header.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69091 = conformed_args__65516__auto__;
var map__69091__$1 = cljs.core.__destructure_map(map__69091);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69091__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69091__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69091__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("header",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.header.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.header.cljs$lang$applyTo = (function (seq69082){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69082));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (datalist "hello")
 * (datalist nil "hello")
 * 
 * These two are made equivalent at compile time
 * (datalist {:onClick f} "hello")
 * (datalist #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (datalist :#the-id.klass.other-klass "hello")
 * (datalist :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.datalist = (function com$fulcrologic$fulcro$dom$datalist(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71115 = arguments.length;
var i__4865__auto___71116 = (0);
while(true){
if((i__4865__auto___71116 < len__4864__auto___71115)){
args__4870__auto__.push((arguments[i__4865__auto___71116]));

var G__71120 = (i__4865__auto___71116 + (1));
i__4865__auto___71116 = G__71120;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.datalist.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.datalist.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69118 = conformed_args__65516__auto__;
var map__69118__$1 = cljs.core.__destructure_map(map__69118);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69118__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69118__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69118__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("datalist",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.datalist.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.datalist.cljs$lang$applyTo = (function (seq69105){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69105));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tfoot "hello")
 * (tfoot nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tfoot {:onClick f} "hello")
 * (tfoot #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tfoot :#the-id.klass.other-klass "hello")
 * (tfoot :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tfoot = (function com$fulcrologic$fulcro$dom$tfoot(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71128 = arguments.length;
var i__4865__auto___71129 = (0);
while(true){
if((i__4865__auto___71129 < len__4864__auto___71128)){
args__4870__auto__.push((arguments[i__4865__auto___71129]));

var G__71130 = (i__4865__auto___71129 + (1));
i__4865__auto___71129 = G__71130;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69129 = conformed_args__65516__auto__;
var map__69129__$1 = cljs.core.__destructure_map(map__69129);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69129__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69129__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69129__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tfoot",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.tfoot.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tfoot.cljs$lang$applyTo = (function (seq69124){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69124));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (s "hello")
 * (s nil "hello")
 * 
 * These two are made equivalent at compile time
 * (s {:onClick f} "hello")
 * (s #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (s :#the-id.klass.other-klass "hello")
 * (s :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.s = (function com$fulcrologic$fulcro$dom$s(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71132 = arguments.length;
var i__4865__auto___71133 = (0);
while(true){
if((i__4865__auto___71133 < len__4864__auto___71132)){
args__4870__auto__.push((arguments[i__4865__auto___71133]));

var G__71136 = (i__4865__auto___71133 + (1));
i__4865__auto___71133 = G__71136;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.s.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.s.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69141 = conformed_args__65516__auto__;
var map__69141__$1 = cljs.core.__destructure_map(map__69141);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69141__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69141__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69141__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("s",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.s.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.s.cljs$lang$applyTo = (function (seq69137){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69137));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hatch "hello")
 * (hatch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hatch {:onClick f} "hello")
 * (hatch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hatch :#the-id.klass.other-klass "hello")
 * (hatch :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.hatch = (function com$fulcrologic$fulcro$dom$hatch(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71138 = arguments.length;
var i__4865__auto___71139 = (0);
while(true){
if((i__4865__auto___71139 < len__4864__auto___71138)){
args__4870__auto__.push((arguments[i__4865__auto___71139]));

var G__71140 = (i__4865__auto___71139 + (1));
i__4865__auto___71139 = G__71140;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.hatch.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.hatch.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69155 = conformed_args__65516__auto__;
var map__69155__$1 = cljs.core.__destructure_map(map__69155);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69155__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69155__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69155__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("hatch",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.hatch.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.hatch.cljs$lang$applyTo = (function (seq69150){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69150));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ins "hello")
 * (ins nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ins {:onClick f} "hello")
 * (ins #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ins :#the-id.klass.other-klass "hello")
 * (ins :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ins = (function com$fulcrologic$fulcro$dom$ins(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71146 = arguments.length;
var i__4865__auto___71147 = (0);
while(true){
if((i__4865__auto___71147 < len__4864__auto___71146)){
args__4870__auto__.push((arguments[i__4865__auto___71147]));

var G__71148 = (i__4865__auto___71147 + (1));
i__4865__auto___71147 = G__71148;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ins.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ins.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69170 = conformed_args__65516__auto__;
var map__69170__$1 = cljs.core.__destructure_map(map__69170);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69170__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69170__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69170__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ins",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.ins.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ins.cljs$lang$applyTo = (function (seq69164){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69164));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (footer "hello")
 * (footer nil "hello")
 * 
 * These two are made equivalent at compile time
 * (footer {:onClick f} "hello")
 * (footer #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (footer :#the-id.klass.other-klass "hello")
 * (footer :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.footer = (function com$fulcrologic$fulcro$dom$footer(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71150 = arguments.length;
var i__4865__auto___71151 = (0);
while(true){
if((i__4865__auto___71151 < len__4864__auto___71150)){
args__4870__auto__.push((arguments[i__4865__auto___71151]));

var G__71152 = (i__4865__auto___71151 + (1));
i__4865__auto___71151 = G__71152;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.footer.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.footer.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69181 = conformed_args__65516__auto__;
var map__69181__$1 = cljs.core.__destructure_map(map__69181);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69181__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69181__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69181__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("footer",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.footer.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.footer.cljs$lang$applyTo = (function (seq69179){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69179));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mpath "hello")
 * (mpath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mpath {:onClick f} "hello")
 * (mpath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mpath :#the-id.klass.other-klass "hello")
 * (mpath :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.mpath = (function com$fulcrologic$fulcro$dom$mpath(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71158 = arguments.length;
var i__4865__auto___71159 = (0);
while(true){
if((i__4865__auto___71159 < len__4864__auto___71158)){
args__4870__auto__.push((arguments[i__4865__auto___71159]));

var G__71165 = (i__4865__auto___71159 + (1));
i__4865__auto___71159 = G__71165;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.mpath.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.mpath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69190 = conformed_args__65516__auto__;
var map__69190__$1 = cljs.core.__destructure_map(map__69190);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69190__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69190__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69190__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("mpath",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.mpath.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.mpath.cljs$lang$applyTo = (function (seq69184){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69184));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (title "hello")
 * (title nil "hello")
 * 
 * These two are made equivalent at compile time
 * (title {:onClick f} "hello")
 * (title #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (title :#the-id.klass.other-klass "hello")
 * (title :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.title = (function com$fulcrologic$fulcro$dom$title(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71169 = arguments.length;
var i__4865__auto___71170 = (0);
while(true){
if((i__4865__auto___71170 < len__4864__auto___71169)){
args__4870__auto__.push((arguments[i__4865__auto___71170]));

var G__71171 = (i__4865__auto___71170 + (1));
i__4865__auto___71170 = G__71171;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.title.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.title.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69199 = conformed_args__65516__auto__;
var map__69199__$1 = cljs.core.__destructure_map(map__69199);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69199__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69199__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69199__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("title",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.title.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.title.cljs$lang$applyTo = (function (seq69193){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69193));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h5 "hello")
 * (h5 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h5 {:onClick f} "hello")
 * (h5 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h5 :#the-id.klass.other-klass "hello")
 * (h5 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h5 = (function com$fulcrologic$fulcro$dom$h5(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71176 = arguments.length;
var i__4865__auto___71177 = (0);
while(true){
if((i__4865__auto___71177 < len__4864__auto___71176)){
args__4870__auto__.push((arguments[i__4865__auto___71177]));

var G__71178 = (i__4865__auto___71177 + (1));
i__4865__auto___71177 = G__71178;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h5.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h5.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69218 = conformed_args__65516__auto__;
var map__69218__$1 = cljs.core.__destructure_map(map__69218);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69218__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69218__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69218__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h5",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.h5.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h5.cljs$lang$applyTo = (function (seq69213){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69213));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshgradient "hello")
 * (meshgradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshgradient {:onClick f} "hello")
 * (meshgradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshgradient :#the-id.klass.other-klass "hello")
 * (meshgradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meshgradient = (function com$fulcrologic$fulcro$dom$meshgradient(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71183 = arguments.length;
var i__4865__auto___71184 = (0);
while(true){
if((i__4865__auto___71184 < len__4864__auto___71183)){
args__4870__auto__.push((arguments[i__4865__auto___71184]));

var G__71185 = (i__4865__auto___71184 + (1));
i__4865__auto___71184 = G__71185;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meshgradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meshgradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69233 = conformed_args__65516__auto__;
var map__69233__$1 = cljs.core.__destructure_map(map__69233);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69233__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69233__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69233__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meshgradient",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.meshgradient.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meshgradient.cljs$lang$applyTo = (function (seq69225){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69225));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (canvas "hello")
 * (canvas nil "hello")
 * 
 * These two are made equivalent at compile time
 * (canvas {:onClick f} "hello")
 * (canvas #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (canvas :#the-id.klass.other-klass "hello")
 * (canvas :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.canvas = (function com$fulcrologic$fulcro$dom$canvas(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71192 = arguments.length;
var i__4865__auto___71193 = (0);
while(true){
if((i__4865__auto___71193 < len__4864__auto___71192)){
args__4870__auto__.push((arguments[i__4865__auto___71193]));

var G__71195 = (i__4865__auto___71193 + (1));
i__4865__auto___71193 = G__71195;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.canvas.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.canvas.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69246 = conformed_args__65516__auto__;
var map__69246__$1 = cljs.core.__destructure_map(map__69246);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69246__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69246__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69246__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("canvas",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.canvas.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.canvas.cljs$lang$applyTo = (function (seq69239){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69239));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (param "hello")
 * (param nil "hello")
 * 
 * These two are made equivalent at compile time
 * (param {:onClick f} "hello")
 * (param #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (param :#the-id.klass.other-klass "hello")
 * (param :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.param = (function com$fulcrologic$fulcro$dom$param(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71206 = arguments.length;
var i__4865__auto___71208 = (0);
while(true){
if((i__4865__auto___71208 < len__4864__auto___71206)){
args__4870__auto__.push((arguments[i__4865__auto___71208]));

var G__71209 = (i__4865__auto___71208 + (1));
i__4865__auto___71208 = G__71209;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.param.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.param.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69257 = conformed_args__65516__auto__;
var map__69257__$1 = cljs.core.__destructure_map(map__69257);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69257__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69257__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69257__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("param",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.param.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.param.cljs$lang$applyTo = (function (seq69250){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69250));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font "hello")
 * (font nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font {:onClick f} "hello")
 * (font #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font :#the-id.klass.other-klass "hello")
 * (font :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font = (function com$fulcrologic$fulcro$dom$font(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71212 = arguments.length;
var i__4865__auto___71214 = (0);
while(true){
if((i__4865__auto___71214 < len__4864__auto___71212)){
args__4870__auto__.push((arguments[i__4865__auto___71214]));

var G__71216 = (i__4865__auto___71214 + (1));
i__4865__auto___71214 = G__71216;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69267 = conformed_args__65516__auto__;
var map__69267__$1 = cljs.core.__destructure_map(map__69267);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69267__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69267__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69267__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.font.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font.cljs$lang$applyTo = (function (seq69259){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69259));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (div "hello")
 * (div nil "hello")
 * 
 * These two are made equivalent at compile time
 * (div {:onClick f} "hello")
 * (div #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (div :#the-id.klass.other-klass "hello")
 * (div :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.div = (function com$fulcrologic$fulcro$dom$div(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71223 = arguments.length;
var i__4865__auto___71224 = (0);
while(true){
if((i__4865__auto___71224 < len__4864__auto___71223)){
args__4870__auto__.push((arguments[i__4865__auto___71224]));

var G__71225 = (i__4865__auto___71224 + (1));
i__4865__auto___71224 = G__71225;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.div.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69273 = conformed_args__65516__auto__;
var map__69273__$1 = cljs.core.__destructure_map(map__69273);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69273__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69273__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69273__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("div",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.div.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.div.cljs$lang$applyTo = (function (seq69271){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69271));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (option "hello")
 * (option nil "hello")
 * 
 * These two are made equivalent at compile time
 * (option {:onClick f} "hello")
 * (option #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (option :#the-id.klass.other-klass "hello")
 * (option :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.option = (function com$fulcrologic$fulcro$dom$option(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71235 = arguments.length;
var i__4865__auto___71237 = (0);
while(true){
if((i__4865__auto___71237 < len__4864__auto___71235)){
args__4870__auto__.push((arguments[i__4865__auto___71237]));

var G__71238 = (i__4865__auto___71237 + (1));
i__4865__auto___71237 = G__71238;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.option.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.option.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69283 = conformed_args__65516__auto__;
var map__69283__$1 = cljs.core.__destructure_map(map__69283);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69283__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69283__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69283__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("option",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.option.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.option.cljs$lang$applyTo = (function (seq69282){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69282));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFlood "hello")
 * (feFlood nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFlood {:onClick f} "hello")
 * (feFlood #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFlood :#the-id.klass.other-klass "hello")
 * (feFlood :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFlood = (function com$fulcrologic$fulcro$dom$feFlood(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71249 = arguments.length;
var i__4865__auto___71252 = (0);
while(true){
if((i__4865__auto___71252 < len__4864__auto___71249)){
args__4870__auto__.push((arguments[i__4865__auto___71252]));

var G__71254 = (i__4865__auto___71252 + (1));
i__4865__auto___71252 = G__71254;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFlood.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFlood.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69294 = conformed_args__65516__auto__;
var map__69294__$1 = cljs.core.__destructure_map(map__69294);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69294__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69294__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69294__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFlood",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feFlood.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFlood.cljs$lang$applyTo = (function (seq69290){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69290));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (summary "hello")
 * (summary nil "hello")
 * 
 * These two are made equivalent at compile time
 * (summary {:onClick f} "hello")
 * (summary #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (summary :#the-id.klass.other-klass "hello")
 * (summary :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.summary = (function com$fulcrologic$fulcro$dom$summary(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71259 = arguments.length;
var i__4865__auto___71260 = (0);
while(true){
if((i__4865__auto___71260 < len__4864__auto___71259)){
args__4870__auto__.push((arguments[i__4865__auto___71260]));

var G__71261 = (i__4865__auto___71260 + (1));
i__4865__auto___71260 = G__71261;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.summary.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.summary.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69302 = conformed_args__65516__auto__;
var map__69302__$1 = cljs.core.__destructure_map(map__69302);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69302__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69302__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69302__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("summary",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.summary.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.summary.cljs$lang$applyTo = (function (seq69297){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69297));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMorphology "hello")
 * (feMorphology nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMorphology {:onClick f} "hello")
 * (feMorphology #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMorphology :#the-id.klass.other-klass "hello")
 * (feMorphology :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feMorphology = (function com$fulcrologic$fulcro$dom$feMorphology(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71269 = arguments.length;
var i__4865__auto___71272 = (0);
while(true){
if((i__4865__auto___71272 < len__4864__auto___71269)){
args__4870__auto__.push((arguments[i__4865__auto___71272]));

var G__71273 = (i__4865__auto___71272 + (1));
i__4865__auto___71272 = G__71273;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feMorphology.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feMorphology.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69312 = conformed_args__65516__auto__;
var map__69312__$1 = cljs.core.__destructure_map(map__69312);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69312__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69312__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69312__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feMorphology",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feMorphology.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feMorphology.cljs$lang$applyTo = (function (seq69305){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69305));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (samp "hello")
 * (samp nil "hello")
 * 
 * These two are made equivalent at compile time
 * (samp {:onClick f} "hello")
 * (samp #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (samp :#the-id.klass.other-klass "hello")
 * (samp :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.samp = (function com$fulcrologic$fulcro$dom$samp(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71280 = arguments.length;
var i__4865__auto___71281 = (0);
while(true){
if((i__4865__auto___71281 < len__4864__auto___71280)){
args__4870__auto__.push((arguments[i__4865__auto___71281]));

var G__71282 = (i__4865__auto___71281 + (1));
i__4865__auto___71281 = G__71282;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.samp.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.samp.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69319 = conformed_args__65516__auto__;
var map__69319__$1 = cljs.core.__destructure_map(map__69319);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69319__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69319__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69319__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("samp",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.samp.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.samp.cljs$lang$applyTo = (function (seq69316){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69316));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (glyphRef "hello")
 * (glyphRef nil "hello")
 * 
 * These two are made equivalent at compile time
 * (glyphRef {:onClick f} "hello")
 * (glyphRef #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (glyphRef :#the-id.klass.other-klass "hello")
 * (glyphRef :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.glyphRef = (function com$fulcrologic$fulcro$dom$glyphRef(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71287 = arguments.length;
var i__4865__auto___71288 = (0);
while(true){
if((i__4865__auto___71288 < len__4864__auto___71287)){
args__4870__auto__.push((arguments[i__4865__auto___71288]));

var G__71289 = (i__4865__auto___71288 + (1));
i__4865__auto___71288 = G__71289;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.glyphRef.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.glyphRef.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69327 = conformed_args__65516__auto__;
var map__69327__$1 = cljs.core.__destructure_map(map__69327);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69327__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69327__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69327__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("glyphRef",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.glyphRef.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.glyphRef.cljs$lang$applyTo = (function (seq69323){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69323));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (small "hello")
 * (small nil "hello")
 * 
 * These two are made equivalent at compile time
 * (small {:onClick f} "hello")
 * (small #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (small :#the-id.klass.other-klass "hello")
 * (small :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.small = (function com$fulcrologic$fulcro$dom$small(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71292 = arguments.length;
var i__4865__auto___71293 = (0);
while(true){
if((i__4865__auto___71293 < len__4864__auto___71292)){
args__4870__auto__.push((arguments[i__4865__auto___71293]));

var G__71295 = (i__4865__auto___71293 + (1));
i__4865__auto___71293 = G__71295;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.small.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.small.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69336 = conformed_args__65516__auto__;
var map__69336__$1 = cljs.core.__destructure_map(map__69336);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69336__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69336__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69336__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("small",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.small.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.small.cljs$lang$applyTo = (function (seq69330){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69330));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (style "hello")
 * (style nil "hello")
 * 
 * These two are made equivalent at compile time
 * (style {:onClick f} "hello")
 * (style #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (style :#the-id.klass.other-klass "hello")
 * (style :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.style = (function com$fulcrologic$fulcro$dom$style(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71296 = arguments.length;
var i__4865__auto___71297 = (0);
while(true){
if((i__4865__auto___71297 < len__4864__auto___71296)){
args__4870__auto__.push((arguments[i__4865__auto___71297]));

var G__71298 = (i__4865__auto___71297 + (1));
i__4865__auto___71297 = G__71298;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.style.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.style.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69345 = conformed_args__65516__auto__;
var map__69345__$1 = cljs.core.__destructure_map(map__69345);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69345__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69345__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69345__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("style",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.style.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.style.cljs$lang$applyTo = (function (seq69341){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69341));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (textarea "hello")
 * (textarea nil "hello")
 * 
 * These two are made equivalent at compile time
 * (textarea {:onClick f} "hello")
 * (textarea #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (textarea :#the-id.klass.other-klass "hello")
 * (textarea :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.textarea = (function com$fulcrologic$fulcro$dom$textarea(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71300 = arguments.length;
var i__4865__auto___71301 = (0);
while(true){
if((i__4865__auto___71301 < len__4864__auto___71300)){
args__4870__auto__.push((arguments[i__4865__auto___71301]));

var G__71302 = (i__4865__auto___71301 + (1));
i__4865__auto___71301 = G__71302;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.textarea.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.textarea.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69357 = conformed_args__65516__auto__;
var map__69357__$1 = cljs.core.__destructure_map(map__69357);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69357__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69357__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69357__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("textarea",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.textarea.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.textarea.cljs$lang$applyTo = (function (seq69349){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69349));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feGaussianBlur "hello")
 * (feGaussianBlur nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feGaussianBlur {:onClick f} "hello")
 * (feGaussianBlur #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feGaussianBlur :#the-id.klass.other-klass "hello")
 * (feGaussianBlur :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feGaussianBlur = (function com$fulcrologic$fulcro$dom$feGaussianBlur(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71307 = arguments.length;
var i__4865__auto___71308 = (0);
while(true){
if((i__4865__auto___71308 < len__4864__auto___71307)){
args__4870__auto__.push((arguments[i__4865__auto___71308]));

var G__71309 = (i__4865__auto___71308 + (1));
i__4865__auto___71308 = G__71309;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feGaussianBlur.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feGaussianBlur.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69377 = conformed_args__65516__auto__;
var map__69377__$1 = cljs.core.__destructure_map(map__69377);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69377__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69377__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69377__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feGaussianBlur",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feGaussianBlur.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feGaussianBlur.cljs$lang$applyTo = (function (seq69369){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69369));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h4 "hello")
 * (h4 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h4 {:onClick f} "hello")
 * (h4 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h4 :#the-id.klass.other-klass "hello")
 * (h4 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h4 = (function com$fulcrologic$fulcro$dom$h4(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71312 = arguments.length;
var i__4865__auto___71313 = (0);
while(true){
if((i__4865__auto___71313 < len__4864__auto___71312)){
args__4870__auto__.push((arguments[i__4865__auto___71313]));

var G__71314 = (i__4865__auto___71313 + (1));
i__4865__auto___71313 = G__71314;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h4.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h4.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69387 = conformed_args__65516__auto__;
var map__69387__$1 = cljs.core.__destructure_map(map__69387);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69387__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69387__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69387__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h4",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.h4.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h4.cljs$lang$applyTo = (function (seq69382){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69382));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (head "hello")
 * (head nil "hello")
 * 
 * These two are made equivalent at compile time
 * (head {:onClick f} "hello")
 * (head #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (head :#the-id.klass.other-klass "hello")
 * (head :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.head = (function com$fulcrologic$fulcro$dom$head(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71315 = arguments.length;
var i__4865__auto___71316 = (0);
while(true){
if((i__4865__auto___71316 < len__4864__auto___71315)){
args__4870__auto__.push((arguments[i__4865__auto___71316]));

var G__71317 = (i__4865__auto___71316 + (1));
i__4865__auto___71316 = G__71317;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.head.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.head.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69398 = conformed_args__65516__auto__;
var map__69398__$1 = cljs.core.__destructure_map(map__69398);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69398__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69398__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69398__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("head",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.head.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.head.cljs$lang$applyTo = (function (seq69391){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69391));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (g "hello")
 * (g nil "hello")
 * 
 * These two are made equivalent at compile time
 * (g {:onClick f} "hello")
 * (g #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (g :#the-id.klass.other-klass "hello")
 * (g :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.g = (function com$fulcrologic$fulcro$dom$g(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71318 = arguments.length;
var i__4865__auto___71319 = (0);
while(true){
if((i__4865__auto___71319 < len__4864__auto___71318)){
args__4870__auto__.push((arguments[i__4865__auto___71319]));

var G__71320 = (i__4865__auto___71319 + (1));
i__4865__auto___71319 = G__71320;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.g.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.g.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69409 = conformed_args__65516__auto__;
var map__69409__$1 = cljs.core.__destructure_map(map__69409);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69409__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69409__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69409__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("g",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.g.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.g.cljs$lang$applyTo = (function (seq69404){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69404));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (missing-glyph "hello")
 * (missing-glyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (missing-glyph {:onClick f} "hello")
 * (missing-glyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (missing-glyph :#the-id.klass.other-klass "hello")
 * (missing-glyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.missing_glyph = (function com$fulcrologic$fulcro$dom$missing_glyph(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71321 = arguments.length;
var i__4865__auto___71322 = (0);
while(true){
if((i__4865__auto___71322 < len__4864__auto___71321)){
args__4870__auto__.push((arguments[i__4865__auto___71322]));

var G__71325 = (i__4865__auto___71322 + (1));
i__4865__auto___71322 = G__71325;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.missing_glyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.missing_glyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69418 = conformed_args__65516__auto__;
var map__69418__$1 = cljs.core.__destructure_map(map__69418);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69418__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69418__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69418__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("missing-glyph",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.missing_glyph.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.missing_glyph.cljs$lang$applyTo = (function (seq69413){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69413));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (stop "hello")
 * (stop nil "hello")
 * 
 * These two are made equivalent at compile time
 * (stop {:onClick f} "hello")
 * (stop #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (stop :#the-id.klass.other-klass "hello")
 * (stop :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.stop = (function com$fulcrologic$fulcro$dom$stop(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71331 = arguments.length;
var i__4865__auto___71332 = (0);
while(true){
if((i__4865__auto___71332 < len__4864__auto___71331)){
args__4870__auto__.push((arguments[i__4865__auto___71332]));

var G__71333 = (i__4865__auto___71332 + (1));
i__4865__auto___71332 = G__71333;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.stop.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.stop.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69428 = conformed_args__65516__auto__;
var map__69428__$1 = cljs.core.__destructure_map(map__69428);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69428__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69428__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69428__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("stop",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.stop.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.stop.cljs$lang$applyTo = (function (seq69423){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69423));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDiffuseLighting "hello")
 * (feDiffuseLighting nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDiffuseLighting {:onClick f} "hello")
 * (feDiffuseLighting #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDiffuseLighting :#the-id.klass.other-klass "hello")
 * (feDiffuseLighting :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feDiffuseLighting = (function com$fulcrologic$fulcro$dom$feDiffuseLighting(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71335 = arguments.length;
var i__4865__auto___71336 = (0);
while(true){
if((i__4865__auto___71336 < len__4864__auto___71335)){
args__4870__auto__.push((arguments[i__4865__auto___71336]));

var G__71337 = (i__4865__auto___71336 + (1));
i__4865__auto___71336 = G__71337;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feDiffuseLighting.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feDiffuseLighting.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69439 = conformed_args__65516__auto__;
var map__69439__$1 = cljs.core.__destructure_map(map__69439);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69439__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69439__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69439__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feDiffuseLighting",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feDiffuseLighting.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feDiffuseLighting.cljs$lang$applyTo = (function (seq69433){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69433));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (filter "hello")
 * (filter nil "hello")
 * 
 * These two are made equivalent at compile time
 * (filter {:onClick f} "hello")
 * (filter #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (filter :#the-id.klass.other-klass "hello")
 * (filter :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.filter = (function com$fulcrologic$fulcro$dom$filter(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71342 = arguments.length;
var i__4865__auto___71343 = (0);
while(true){
if((i__4865__auto___71343 < len__4864__auto___71342)){
args__4870__auto__.push((arguments[i__4865__auto___71343]));

var G__71344 = (i__4865__auto___71343 + (1));
i__4865__auto___71343 = G__71344;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.filter.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.filter.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69450 = conformed_args__65516__auto__;
var map__69450__$1 = cljs.core.__destructure_map(map__69450);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69450__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69450__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69450__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("filter",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.filter.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.filter.cljs$lang$applyTo = (function (seq69441){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69441));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feComposite "hello")
 * (feComposite nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feComposite {:onClick f} "hello")
 * (feComposite #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feComposite :#the-id.klass.other-klass "hello")
 * (feComposite :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feComposite = (function com$fulcrologic$fulcro$dom$feComposite(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71354 = arguments.length;
var i__4865__auto___71356 = (0);
while(true){
if((i__4865__auto___71356 < len__4864__auto___71354)){
args__4870__auto__.push((arguments[i__4865__auto___71356]));

var G__71358 = (i__4865__auto___71356 + (1));
i__4865__auto___71356 = G__71358;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feComposite.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feComposite.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69461 = conformed_args__65516__auto__;
var map__69461__$1 = cljs.core.__destructure_map(map__69461);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69461__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69461__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69461__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feComposite",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feComposite.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feComposite.cljs$lang$applyTo = (function (seq69460){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69460));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mesh "hello")
 * (mesh nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mesh {:onClick f} "hello")
 * (mesh #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mesh :#the-id.klass.other-klass "hello")
 * (mesh :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.mesh = (function com$fulcrologic$fulcro$dom$mesh(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71365 = arguments.length;
var i__4865__auto___71366 = (0);
while(true){
if((i__4865__auto___71366 < len__4864__auto___71365)){
args__4870__auto__.push((arguments[i__4865__auto___71366]));

var G__71367 = (i__4865__auto___71366 + (1));
i__4865__auto___71366 = G__71367;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.mesh.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.mesh.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69473 = conformed_args__65516__auto__;
var map__69473__$1 = cljs.core.__destructure_map(map__69473);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69473__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69473__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69473__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("mesh",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.mesh.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.mesh.cljs$lang$applyTo = (function (seq69468){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69468));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (var "hello")
 * (var nil "hello")
 * 
 * These two are made equivalent at compile time
 * (var {:onClick f} "hello")
 * (var #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (var :#the-id.klass.other-klass "hello")
 * (var :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.var$ = (function com$fulcrologic$fulcro$dom$var(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71371 = arguments.length;
var i__4865__auto___71373 = (0);
while(true){
if((i__4865__auto___71373 < len__4864__auto___71371)){
args__4870__auto__.push((arguments[i__4865__auto___71373]));

var G__71374 = (i__4865__auto___71373 + (1));
i__4865__auto___71373 = G__71374;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.var$.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.var$.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69482 = conformed_args__65516__auto__;
var map__69482__$1 = cljs.core.__destructure_map(map__69482);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69482__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69482__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69482__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("var",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.var$.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.var$.cljs$lang$applyTo = (function (seq69479){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69479));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tspan "hello")
 * (tspan nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tspan {:onClick f} "hello")
 * (tspan #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tspan :#the-id.klass.other-klass "hello")
 * (tspan :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tspan = (function com$fulcrologic$fulcro$dom$tspan(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71379 = arguments.length;
var i__4865__auto___71380 = (0);
while(true){
if((i__4865__auto___71380 < len__4864__auto___71379)){
args__4870__auto__.push((arguments[i__4865__auto___71380]));

var G__71383 = (i__4865__auto___71380 + (1));
i__4865__auto___71380 = G__71383;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tspan.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tspan.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69506 = conformed_args__65516__auto__;
var map__69506__$1 = cljs.core.__destructure_map(map__69506);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69506__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69506__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69506__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tspan",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.tspan.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tspan.cljs$lang$applyTo = (function (seq69500){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69500));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ol "hello")
 * (ol nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ol {:onClick f} "hello")
 * (ol #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ol :#the-id.klass.other-klass "hello")
 * (ol :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ol = (function com$fulcrologic$fulcro$dom$ol(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71387 = arguments.length;
var i__4865__auto___71388 = (0);
while(true){
if((i__4865__auto___71388 < len__4864__auto___71387)){
args__4870__auto__.push((arguments[i__4865__auto___71388]));

var G__71389 = (i__4865__auto___71388 + (1));
i__4865__auto___71388 = G__71389;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ol.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ol.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69518 = conformed_args__65516__auto__;
var map__69518__$1 = cljs.core.__destructure_map(map__69518);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69518__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69518__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69518__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ol",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.ol.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ol.cljs$lang$applyTo = (function (seq69511){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69511));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (details "hello")
 * (details nil "hello")
 * 
 * These two are made equivalent at compile time
 * (details {:onClick f} "hello")
 * (details #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (details :#the-id.klass.other-klass "hello")
 * (details :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.details = (function com$fulcrologic$fulcro$dom$details(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71392 = arguments.length;
var i__4865__auto___71394 = (0);
while(true){
if((i__4865__auto___71394 < len__4864__auto___71392)){
args__4870__auto__.push((arguments[i__4865__auto___71394]));

var G__71395 = (i__4865__auto___71394 + (1));
i__4865__auto___71394 = G__71395;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.details.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.details.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69535 = conformed_args__65516__auto__;
var map__69535__$1 = cljs.core.__destructure_map(map__69535);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69535__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69535__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69535__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("details",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.details.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.details.cljs$lang$applyTo = (function (seq69527){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69527));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (line "hello")
 * (line nil "hello")
 * 
 * These two are made equivalent at compile time
 * (line {:onClick f} "hello")
 * (line #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (line :#the-id.klass.other-klass "hello")
 * (line :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.line = (function com$fulcrologic$fulcro$dom$line(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71403 = arguments.length;
var i__4865__auto___71404 = (0);
while(true){
if((i__4865__auto___71404 < len__4864__auto___71403)){
args__4870__auto__.push((arguments[i__4865__auto___71404]));

var G__71405 = (i__4865__auto___71404 + (1));
i__4865__auto___71404 = G__71405;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.line.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.line.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69544 = conformed_args__65516__auto__;
var map__69544__$1 = cljs.core.__destructure_map(map__69544);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69544__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69544__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69544__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("line",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.line.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.line.cljs$lang$applyTo = (function (seq69539){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69539));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (col "hello")
 * (col nil "hello")
 * 
 * These two are made equivalent at compile time
 * (col {:onClick f} "hello")
 * (col #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (col :#the-id.klass.other-klass "hello")
 * (col :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.col = (function com$fulcrologic$fulcro$dom$col(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71408 = arguments.length;
var i__4865__auto___71409 = (0);
while(true){
if((i__4865__auto___71409 < len__4864__auto___71408)){
args__4870__auto__.push((arguments[i__4865__auto___71409]));

var G__71410 = (i__4865__auto___71409 + (1));
i__4865__auto___71409 = G__71410;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.col.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.col.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69552 = conformed_args__65516__auto__;
var map__69552__$1 = cljs.core.__destructure_map(map__69552);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69552__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69552__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69552__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("col",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.col.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.col.cljs$lang$applyTo = (function (seq69547){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69547));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (label "hello")
 * (label nil "hello")
 * 
 * These two are made equivalent at compile time
 * (label {:onClick f} "hello")
 * (label #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (label :#the-id.klass.other-klass "hello")
 * (label :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.label = (function com$fulcrologic$fulcro$dom$label(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71417 = arguments.length;
var i__4865__auto___71418 = (0);
while(true){
if((i__4865__auto___71418 < len__4864__auto___71417)){
args__4870__auto__.push((arguments[i__4865__auto___71418]));

var G__71420 = (i__4865__auto___71418 + (1));
i__4865__auto___71418 = G__71420;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.label.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.label.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69559 = conformed_args__65516__auto__;
var map__69559__$1 = cljs.core.__destructure_map(map__69559);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69559__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69559__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69559__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("label",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.label.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.label.cljs$lang$applyTo = (function (seq69556){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69556));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (picture "hello")
 * (picture nil "hello")
 * 
 * These two are made equivalent at compile time
 * (picture {:onClick f} "hello")
 * (picture #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (picture :#the-id.klass.other-klass "hello")
 * (picture :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.picture = (function com$fulcrologic$fulcro$dom$picture(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71433 = arguments.length;
var i__4865__auto___71435 = (0);
while(true){
if((i__4865__auto___71435 < len__4864__auto___71433)){
args__4870__auto__.push((arguments[i__4865__auto___71435]));

var G__71436 = (i__4865__auto___71435 + (1));
i__4865__auto___71435 = G__71436;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.picture.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.picture.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69565 = conformed_args__65516__auto__;
var map__69565__$1 = cljs.core.__destructure_map(map__69565);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69565__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69565__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69565__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("picture",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.picture.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.picture.cljs$lang$applyTo = (function (seq69562){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69562));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rt "hello")
 * (rt nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rt {:onClick f} "hello")
 * (rt #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rt :#the-id.klass.other-klass "hello")
 * (rt :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.rt = (function com$fulcrologic$fulcro$dom$rt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71444 = arguments.length;
var i__4865__auto___71445 = (0);
while(true){
if((i__4865__auto___71445 < len__4864__auto___71444)){
args__4870__auto__.push((arguments[i__4865__auto___71445]));

var G__71447 = (i__4865__auto___71445 + (1));
i__4865__auto___71445 = G__71447;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.rt.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.rt.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69570 = conformed_args__65516__auto__;
var map__69570__$1 = cljs.core.__destructure_map(map__69570);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69570__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69570__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69570__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("rt",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.rt.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.rt.cljs$lang$applyTo = (function (seq69568){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69568));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h6 "hello")
 * (h6 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h6 {:onClick f} "hello")
 * (h6 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h6 :#the-id.klass.other-klass "hello")
 * (h6 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h6 = (function com$fulcrologic$fulcro$dom$h6(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71450 = arguments.length;
var i__4865__auto___71451 = (0);
while(true){
if((i__4865__auto___71451 < len__4864__auto___71450)){
args__4870__auto__.push((arguments[i__4865__auto___71451]));

var G__71452 = (i__4865__auto___71451 + (1));
i__4865__auto___71451 = G__71452;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h6.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h6.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69576 = conformed_args__65516__auto__;
var map__69576__$1 = cljs.core.__destructure_map(map__69576);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69576__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69576__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69576__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h6",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.h6.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h6.cljs$lang$applyTo = (function (seq69573){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69573));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (vkern "hello")
 * (vkern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (vkern {:onClick f} "hello")
 * (vkern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (vkern :#the-id.klass.other-klass "hello")
 * (vkern :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.vkern = (function com$fulcrologic$fulcro$dom$vkern(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71457 = arguments.length;
var i__4865__auto___71458 = (0);
while(true){
if((i__4865__auto___71458 < len__4864__auto___71457)){
args__4870__auto__.push((arguments[i__4865__auto___71458]));

var G__71460 = (i__4865__auto___71458 + (1));
i__4865__auto___71458 = G__71460;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.vkern.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.vkern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69587 = conformed_args__65516__auto__;
var map__69587__$1 = cljs.core.__destructure_map(map__69587);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69587__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69587__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69587__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("vkern",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.vkern.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.vkern.cljs$lang$applyTo = (function (seq69578){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69578));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (link "hello")
 * (link nil "hello")
 * 
 * These two are made equivalent at compile time
 * (link {:onClick f} "hello")
 * (link #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (link :#the-id.klass.other-klass "hello")
 * (link :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.link = (function com$fulcrologic$fulcro$dom$link(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71462 = arguments.length;
var i__4865__auto___71463 = (0);
while(true){
if((i__4865__auto___71463 < len__4864__auto___71462)){
args__4870__auto__.push((arguments[i__4865__auto___71463]));

var G__71464 = (i__4865__auto___71463 + (1));
i__4865__auto___71463 = G__71464;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.link.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.link.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69600 = conformed_args__65516__auto__;
var map__69600__$1 = cljs.core.__destructure_map(map__69600);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69600__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69600__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69600__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("link",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.link.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.link.cljs$lang$applyTo = (function (seq69596){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69596));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (defs "hello")
 * (defs nil "hello")
 * 
 * These two are made equivalent at compile time
 * (defs {:onClick f} "hello")
 * (defs #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (defs :#the-id.klass.other-klass "hello")
 * (defs :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.defs = (function com$fulcrologic$fulcro$dom$defs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71468 = arguments.length;
var i__4865__auto___71469 = (0);
while(true){
if((i__4865__auto___71469 < len__4864__auto___71468)){
args__4870__auto__.push((arguments[i__4865__auto___71469]));

var G__71470 = (i__4865__auto___71469 + (1));
i__4865__auto___71469 = G__71470;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.defs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.defs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69612 = conformed_args__65516__auto__;
var map__69612__$1 = cljs.core.__destructure_map(map__69612);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69612__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69612__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69612__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("defs",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.defs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.defs.cljs$lang$applyTo = (function (seq69606){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69606));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (glyph "hello")
 * (glyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (glyph {:onClick f} "hello")
 * (glyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (glyph :#the-id.klass.other-klass "hello")
 * (glyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.glyph = (function com$fulcrologic$fulcro$dom$glyph(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71475 = arguments.length;
var i__4865__auto___71476 = (0);
while(true){
if((i__4865__auto___71476 < len__4864__auto___71475)){
args__4870__auto__.push((arguments[i__4865__auto___71476]));

var G__71478 = (i__4865__auto___71476 + (1));
i__4865__auto___71476 = G__71478;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.glyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.glyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69621 = conformed_args__65516__auto__;
var map__69621__$1 = cljs.core.__destructure_map(map__69621);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69621__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69621__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69621__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("glyph",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.glyph.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.glyph.cljs$lang$applyTo = (function (seq69615){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69615));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (colgroup "hello")
 * (colgroup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (colgroup {:onClick f} "hello")
 * (colgroup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (colgroup :#the-id.klass.other-klass "hello")
 * (colgroup :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.colgroup = (function com$fulcrologic$fulcro$dom$colgroup(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71487 = arguments.length;
var i__4865__auto___71488 = (0);
while(true){
if((i__4865__auto___71488 < len__4864__auto___71487)){
args__4870__auto__.push((arguments[i__4865__auto___71488]));

var G__71490 = (i__4865__auto___71488 + (1));
i__4865__auto___71488 = G__71490;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69629 = conformed_args__65516__auto__;
var map__69629__$1 = cljs.core.__destructure_map(map__69629);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69629__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69629__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69629__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("colgroup",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.colgroup.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.colgroup.cljs$lang$applyTo = (function (seq69625){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69625));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meter "hello")
 * (meter nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meter {:onClick f} "hello")
 * (meter #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meter :#the-id.klass.other-klass "hello")
 * (meter :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meter = (function com$fulcrologic$fulcro$dom$meter(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71495 = arguments.length;
var i__4865__auto___71496 = (0);
while(true){
if((i__4865__auto___71496 < len__4864__auto___71495)){
args__4870__auto__.push((arguments[i__4865__auto___71496]));

var G__71497 = (i__4865__auto___71496 + (1));
i__4865__auto___71496 = G__71497;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meter.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meter.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69636 = conformed_args__65516__auto__;
var map__69636__$1 = cljs.core.__destructure_map(map__69636);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69636__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69636__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69636__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meter",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.meter.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meter.cljs$lang$applyTo = (function (seq69633){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69633));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (bdo "hello")
 * (bdo nil "hello")
 * 
 * These two are made equivalent at compile time
 * (bdo {:onClick f} "hello")
 * (bdo #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (bdo :#the-id.klass.other-klass "hello")
 * (bdo :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.bdo = (function com$fulcrologic$fulcro$dom$bdo(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71503 = arguments.length;
var i__4865__auto___71504 = (0);
while(true){
if((i__4865__auto___71504 < len__4864__auto___71503)){
args__4870__auto__.push((arguments[i__4865__auto___71504]));

var G__71505 = (i__4865__auto___71504 + (1));
i__4865__auto___71504 = G__71505;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.bdo.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.bdo.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69648 = conformed_args__65516__auto__;
var map__69648__$1 = cljs.core.__destructure_map(map__69648);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69648__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69648__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69648__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("bdo",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.bdo.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.bdo.cljs$lang$applyTo = (function (seq69639){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69639));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feImage "hello")
 * (feImage nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feImage {:onClick f} "hello")
 * (feImage #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feImage :#the-id.klass.other-klass "hello")
 * (feImage :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feImage = (function com$fulcrologic$fulcro$dom$feImage(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71511 = arguments.length;
var i__4865__auto___71512 = (0);
while(true){
if((i__4865__auto___71512 < len__4864__auto___71511)){
args__4870__auto__.push((arguments[i__4865__auto___71512]));

var G__71513 = (i__4865__auto___71512 + (1));
i__4865__auto___71512 = G__71513;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feImage.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feImage.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69658 = conformed_args__65516__auto__;
var map__69658__$1 = cljs.core.__destructure_map(map__69658);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69658__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69658__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69658__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feImage",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feImage.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feImage.cljs$lang$applyTo = (function (seq69651){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69651));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (b "hello")
 * (b nil "hello")
 * 
 * These two are made equivalent at compile time
 * (b {:onClick f} "hello")
 * (b #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (b :#the-id.klass.other-klass "hello")
 * (b :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.b = (function com$fulcrologic$fulcro$dom$b(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71517 = arguments.length;
var i__4865__auto___71518 = (0);
while(true){
if((i__4865__auto___71518 < len__4864__auto___71517)){
args__4870__auto__.push((arguments[i__4865__auto___71518]));

var G__71519 = (i__4865__auto___71518 + (1));
i__4865__auto___71518 = G__71519;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.b.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.b.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69669 = conformed_args__65516__auto__;
var map__69669__$1 = cljs.core.__destructure_map(map__69669);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69669__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69669__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69669__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("b",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.b.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.b.cljs$lang$applyTo = (function (seq69662){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69662));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (svg "hello")
 * (svg nil "hello")
 * 
 * These two are made equivalent at compile time
 * (svg {:onClick f} "hello")
 * (svg #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (svg :#the-id.klass.other-klass "hello")
 * (svg :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.svg = (function com$fulcrologic$fulcro$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71523 = arguments.length;
var i__4865__auto___71524 = (0);
while(true){
if((i__4865__auto___71524 < len__4864__auto___71523)){
args__4870__auto__.push((arguments[i__4865__auto___71524]));

var G__71525 = (i__4865__auto___71524 + (1));
i__4865__auto___71524 = G__71525;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.svg.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69678 = conformed_args__65516__auto__;
var map__69678__$1 = cljs.core.__destructure_map(map__69678);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69678__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69678__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69678__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("svg",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.svg.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.svg.cljs$lang$applyTo = (function (seq69673){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69673));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feTile "hello")
 * (feTile nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feTile {:onClick f} "hello")
 * (feTile #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feTile :#the-id.klass.other-klass "hello")
 * (feTile :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feTile = (function com$fulcrologic$fulcro$dom$feTile(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71529 = arguments.length;
var i__4865__auto___71530 = (0);
while(true){
if((i__4865__auto___71530 < len__4864__auto___71529)){
args__4870__auto__.push((arguments[i__4865__auto___71530]));

var G__71532 = (i__4865__auto___71530 + (1));
i__4865__auto___71530 = G__71532;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feTile.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feTile.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69695 = conformed_args__65516__auto__;
var map__69695__$1 = cljs.core.__destructure_map(map__69695);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69695__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69695__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69695__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feTile",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feTile.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feTile.cljs$lang$applyTo = (function (seq69682){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69682));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ellipse "hello")
 * (ellipse nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ellipse {:onClick f} "hello")
 * (ellipse #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ellipse :#the-id.klass.other-klass "hello")
 * (ellipse :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ellipse = (function com$fulcrologic$fulcro$dom$ellipse(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71541 = arguments.length;
var i__4865__auto___71542 = (0);
while(true){
if((i__4865__auto___71542 < len__4864__auto___71541)){
args__4870__auto__.push((arguments[i__4865__auto___71542]));

var G__71544 = (i__4865__auto___71542 + (1));
i__4865__auto___71542 = G__71544;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69711 = conformed_args__65516__auto__;
var map__69711__$1 = cljs.core.__destructure_map(map__69711);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69711__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69711__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69711__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ellipse",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.ellipse.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ellipse.cljs$lang$applyTo = (function (seq69701){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69701));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (code "hello")
 * (code nil "hello")
 * 
 * These two are made equivalent at compile time
 * (code {:onClick f} "hello")
 * (code #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (code :#the-id.klass.other-klass "hello")
 * (code :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.code = (function com$fulcrologic$fulcro$dom$code(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71546 = arguments.length;
var i__4865__auto___71547 = (0);
while(true){
if((i__4865__auto___71547 < len__4864__auto___71546)){
args__4870__auto__.push((arguments[i__4865__auto___71547]));

var G__71548 = (i__4865__auto___71547 + (1));
i__4865__auto___71547 = G__71548;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.code.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.code.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69731 = conformed_args__65516__auto__;
var map__69731__$1 = cljs.core.__destructure_map(map__69731);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69731__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69731__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69731__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("code",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.code.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.code.cljs$lang$applyTo = (function (seq69721){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69721));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dialog "hello")
 * (dialog nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dialog {:onClick f} "hello")
 * (dialog #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dialog :#the-id.klass.other-klass "hello")
 * (dialog :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dialog = (function com$fulcrologic$fulcro$dom$dialog(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71549 = arguments.length;
var i__4865__auto___71550 = (0);
while(true){
if((i__4865__auto___71550 < len__4864__auto___71549)){
args__4870__auto__.push((arguments[i__4865__auto___71550]));

var G__71551 = (i__4865__auto___71550 + (1));
i__4865__auto___71550 = G__71551;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dialog.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dialog.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69740 = conformed_args__65516__auto__;
var map__69740__$1 = cljs.core.__destructure_map(map__69740);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69740__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69740__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69740__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dialog",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.dialog.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dialog.cljs$lang$applyTo = (function (seq69734){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69734));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (linearGradient "hello")
 * (linearGradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (linearGradient {:onClick f} "hello")
 * (linearGradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (linearGradient :#the-id.klass.other-klass "hello")
 * (linearGradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.linearGradient = (function com$fulcrologic$fulcro$dom$linearGradient(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71554 = arguments.length;
var i__4865__auto___71555 = (0);
while(true){
if((i__4865__auto___71555 < len__4864__auto___71554)){
args__4870__auto__.push((arguments[i__4865__auto___71555]));

var G__71556 = (i__4865__auto___71555 + (1));
i__4865__auto___71555 = G__71556;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69748 = conformed_args__65516__auto__;
var map__69748__$1 = cljs.core.__destructure_map(map__69748);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69748__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69748__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69748__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("linearGradient",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.linearGradient.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.linearGradient.cljs$lang$applyTo = (function (seq69744){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69744));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (discard "hello")
 * (discard nil "hello")
 * 
 * These two are made equivalent at compile time
 * (discard {:onClick f} "hello")
 * (discard #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (discard :#the-id.klass.other-klass "hello")
 * (discard :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.discard = (function com$fulcrologic$fulcro$dom$discard(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71558 = arguments.length;
var i__4865__auto___71559 = (0);
while(true){
if((i__4865__auto___71559 < len__4864__auto___71558)){
args__4870__auto__.push((arguments[i__4865__auto___71559]));

var G__71560 = (i__4865__auto___71559 + (1));
i__4865__auto___71559 = G__71560;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.discard.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.discard.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69757 = conformed_args__65516__auto__;
var map__69757__$1 = cljs.core.__destructure_map(map__69757);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69757__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69757__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69757__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("discard",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.discard.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.discard.cljs$lang$applyTo = (function (seq69753){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69753));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-src "hello")
 * (font-face-src nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-src {:onClick f} "hello")
 * (font-face-src #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-src :#the-id.klass.other-klass "hello")
 * (font-face-src :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face_src = (function com$fulcrologic$fulcro$dom$font_face_src(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71577 = arguments.length;
var i__4865__auto___71578 = (0);
while(true){
if((i__4865__auto___71578 < len__4864__auto___71577)){
args__4870__auto__.push((arguments[i__4865__auto___71578]));

var G__71580 = (i__4865__auto___71578 + (1));
i__4865__auto___71578 = G__71580;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face_src.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face_src.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69766 = conformed_args__65516__auto__;
var map__69766__$1 = cljs.core.__destructure_map(map__69766);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69766__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69766__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69766__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face-src",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face_src.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face_src.cljs$lang$applyTo = (function (seq69763){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69763));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (noscript "hello")
 * (noscript nil "hello")
 * 
 * These two are made equivalent at compile time
 * (noscript {:onClick f} "hello")
 * (noscript #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (noscript :#the-id.klass.other-klass "hello")
 * (noscript :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.noscript = (function com$fulcrologic$fulcro$dom$noscript(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71581 = arguments.length;
var i__4865__auto___71582 = (0);
while(true){
if((i__4865__auto___71582 < len__4864__auto___71581)){
args__4870__auto__.push((arguments[i__4865__auto___71582]));

var G__71583 = (i__4865__auto___71582 + (1));
i__4865__auto___71582 = G__71583;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.noscript.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.noscript.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69780 = conformed_args__65516__auto__;
var map__69780__$1 = cljs.core.__destructure_map(map__69780);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69780__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69780__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69780__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("noscript",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.noscript.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.noscript.cljs$lang$applyTo = (function (seq69773){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69773));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateTransform "hello")
 * (animateTransform nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateTransform {:onClick f} "hello")
 * (animateTransform #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateTransform :#the-id.klass.other-klass "hello")
 * (animateTransform :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.animateTransform = (function com$fulcrologic$fulcro$dom$animateTransform(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71587 = arguments.length;
var i__4865__auto___71588 = (0);
while(true){
if((i__4865__auto___71588 < len__4864__auto___71587)){
args__4870__auto__.push((arguments[i__4865__auto___71588]));

var G__71589 = (i__4865__auto___71588 + (1));
i__4865__auto___71588 = G__71589;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.animateTransform.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.animateTransform.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69789 = conformed_args__65516__auto__;
var map__69789__$1 = cljs.core.__destructure_map(map__69789);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69789__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69789__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69789__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("animateTransform",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.animateTransform.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.animateTransform.cljs$lang$applyTo = (function (seq69785){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69785));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feColorMatrix "hello")
 * (feColorMatrix nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feColorMatrix {:onClick f} "hello")
 * (feColorMatrix #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feColorMatrix :#the-id.klass.other-klass "hello")
 * (feColorMatrix :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feColorMatrix = (function com$fulcrologic$fulcro$dom$feColorMatrix(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71592 = arguments.length;
var i__4865__auto___71593 = (0);
while(true){
if((i__4865__auto___71593 < len__4864__auto___71592)){
args__4870__auto__.push((arguments[i__4865__auto___71593]));

var G__71594 = (i__4865__auto___71593 + (1));
i__4865__auto___71593 = G__71594;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feColorMatrix.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feColorMatrix.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69791 = conformed_args__65516__auto__;
var map__69791__$1 = cljs.core.__destructure_map(map__69791);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69791__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69791__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69791__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feColorMatrix",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.feColorMatrix.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feColorMatrix.cljs$lang$applyTo = (function (seq69790){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69790));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h2 "hello")
 * (h2 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h2 {:onClick f} "hello")
 * (h2 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h2 :#the-id.klass.other-klass "hello")
 * (h2 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h2 = (function com$fulcrologic$fulcro$dom$h2(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71596 = arguments.length;
var i__4865__auto___71597 = (0);
while(true){
if((i__4865__auto___71597 < len__4864__auto___71596)){
args__4870__auto__.push((arguments[i__4865__auto___71597]));

var G__71599 = (i__4865__auto___71597 + (1));
i__4865__auto___71597 = G__71599;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h2.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h2.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69800 = conformed_args__65516__auto__;
var map__69800__$1 = cljs.core.__destructure_map(map__69800);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69800__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69800__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69800__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h2",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.h2.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h2.cljs$lang$applyTo = (function (seq69794){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69794));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (area "hello")
 * (area nil "hello")
 * 
 * These two are made equivalent at compile time
 * (area {:onClick f} "hello")
 * (area #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (area :#the-id.klass.other-klass "hello")
 * (area :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.area = (function com$fulcrologic$fulcro$dom$area(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71601 = arguments.length;
var i__4865__auto___71602 = (0);
while(true){
if((i__4865__auto___71602 < len__4864__auto___71601)){
args__4870__auto__.push((arguments[i__4865__auto___71602]));

var G__71603 = (i__4865__auto___71602 + (1));
i__4865__auto___71602 = G__71603;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.area.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.area.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69813 = conformed_args__65516__auto__;
var map__69813__$1 = cljs.core.__destructure_map(map__69813);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69813__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69813__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69813__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("area",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.area.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.area.cljs$lang$applyTo = (function (seq69808){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69808));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (br "hello")
 * (br nil "hello")
 * 
 * These two are made equivalent at compile time
 * (br {:onClick f} "hello")
 * (br #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (br :#the-id.klass.other-klass "hello")
 * (br :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.br = (function com$fulcrologic$fulcro$dom$br(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71605 = arguments.length;
var i__4865__auto___71606 = (0);
while(true){
if((i__4865__auto___71606 < len__4864__auto___71605)){
args__4870__auto__.push((arguments[i__4865__auto___71606]));

var G__71607 = (i__4865__auto___71606 + (1));
i__4865__auto___71606 = G__71607;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.br.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.br.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69821 = conformed_args__65516__auto__;
var map__69821__$1 = cljs.core.__destructure_map(map__69821);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69821__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69821__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69821__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("br",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.br.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.br.cljs$lang$applyTo = (function (seq69816){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69816));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (image "hello")
 * (image nil "hello")
 * 
 * These two are made equivalent at compile time
 * (image {:onClick f} "hello")
 * (image #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (image :#the-id.klass.other-klass "hello")
 * (image :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.image = (function com$fulcrologic$fulcro$dom$image(var_args){
var args__4870__auto__ = [];
var len__4864__auto___71609 = arguments.length;
var i__4865__auto___71610 = (0);
while(true){
if((i__4865__auto___71610 < len__4864__auto___71609)){
args__4870__auto__.push((arguments[i__4865__auto___71610]));

var G__71611 = (i__4865__auto___71610 + (1));
i__4865__auto___71610 = G__71611;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.image.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.image.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65516__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69829 = conformed_args__65516__auto__;
var map__69829__$1 = cljs.core.__destructure_map(map__69829);
var children__65518__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69829__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var attrs__65517__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69829__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var css__65519__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69829__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var children__65518__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65518__auto__);
var attrs_value__65520__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65517__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("image",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65520__auto__], null),children__65518__auto____$1),css__65519__auto__);
}));

(com.fulcrologic.fulcro.dom.image.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.image.cljs$lang$applyTo = (function (seq69826){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69826));
}));


//# sourceMappingURL=com.fulcrologic.fulcro.dom.js.map
