goog.provide('com.fulcrologic.fulcro.rendering.ident_optimized_render');
/**
 * Checks the given `idents` and returns a subset of them where the data they refer to has changed
 * between `old-state` and `new-state`.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.dirty_table_entries = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$dirty_table_entries(old_state,new_state,idents){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,ident){
if((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(old_state,ident) === cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,ident))){
return result;
} else {
return cljs.core.cons(ident,result);
}
}),cljs.core.List.EMPTY,idents);
});
/**
 * Uses the component's query and the current application state to query for the current value of that component's
 *   props (subtree). It then sends those props to the component via "props tunnelling" (setting them on a well-known key in
 *   component-local state).
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_component_BANG_(app,ident,c){
if(cljs.core.truth_((function (){var and__4251__auto__ = c;
if(cljs.core.truth_(and__4251__auto__)){
return ident;
} else {
return and__4251__auto__;
}
})())){
var map__63555 = app;
var map__63555__$1 = cljs.core.__destructure_map(map__63555);
var state_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63555__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","state-atom","com.fulcrologic.fulcro.application/state-atom",648128366));
var state_map = cljs.core.deref(state_atom);
var query = com.fulcrologic.fulcro.components.get_query.cljs$core$IFn$_invoke$arity$2(c,state_map);
var q = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([ident,query])], null);
var prior_computed = (function (){var or__4253__auto__ = (com.fulcrologic.fulcro.components.get_computed.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_computed.cljs$core$IFn$_invoke$arity$1(c) : com.fulcrologic.fulcro.components.get_computed.call(null,c));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var data_tree = (cljs.core.truth_(query)?com.fulcrologic.fulcro.algorithms.denormalize.db__GT_tree(q,state_map,state_map):null);
var new_props = (function (){var G__63557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data_tree,ident);
var G__63558 = prior_computed;
return (com.fulcrologic.fulcro.components.computed.cljs$core$IFn$_invoke$arity$2 ? com.fulcrologic.fulcro.components.computed.cljs$core$IFn$_invoke$arity$2(G__63557,G__63558) : com.fulcrologic.fulcro.components.computed.call(null,G__63557,G__63558));
})();
if(cljs.core.truth_(query)){
} else {
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"com.fulcrologic.fulcro.rendering.ident-optimized-render",null,42,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Query was empty. Refresh failed for ",cljs.core.type(c),"See https://book.fulcrologic.com/#err-id-opt-render-empty-query"], null);
}),null)),null,-521903284,null);
}

return com.fulcrologic.fulcro.components.tunnel_props_BANG_(c,new_props);
} else {
var root = new cljs.core.Keyword("com.fulcrologic.fulcro.application","app-root","com.fulcrologic.fulcro.application/app-root",835379005).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword("com.fulcrologic.fulcro.application","runtime-atom","com.fulcrologic.fulcro.application/runtime-atom",-1167397772).cljs$core$IFn$_invoke$arity$1(app)));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,root)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"com.fulcrologic.fulcro.rendering.ident-optimized-render",null,46,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Failed to do optimized update. Component",(function (){var G__63560 = com.fulcrologic.fulcro.components.react_type(c);
return (com.fulcrologic.fulcro.components.class__GT_registry_key.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.class__GT_registry_key.cljs$core$IFn$_invoke$arity$1(G__63560) : com.fulcrologic.fulcro.components.class__GT_registry_key.call(null,G__63560));
})(),"queries for data that changed, but does not have an ident."], null);
}),null)),null,-635788194,null);
} else {
}

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Targeted update failed",cljs.core.PersistentArrayMap.EMPTY);
}
});
/**
 * Renders *only* components that *have* the given ident.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_components_with_ident_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_components_with_ident_BANG_(app,ident){
var seq__63562 = cljs.core.seq(com.fulcrologic.fulcro.components.ident__GT_components(app,ident));
var chunk__63563 = null;
var count__63564 = (0);
var i__63565 = (0);
while(true){
if((i__63565 < count__63564)){
var c = chunk__63563.cljs$core$IIndexed$_nth$arity$2(null,i__63565);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,ident,c);


var G__63742 = seq__63562;
var G__63743 = chunk__63563;
var G__63744 = count__63564;
var G__63745 = (i__63565 + (1));
seq__63562 = G__63742;
chunk__63563 = G__63743;
count__63564 = G__63744;
i__63565 = G__63745;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63562);
if(temp__5753__auto__){
var seq__63562__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63562__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__63562__$1);
var G__63749 = cljs.core.chunk_rest(seq__63562__$1);
var G__63750 = c__4679__auto__;
var G__63751 = cljs.core.count(c__4679__auto__);
var G__63752 = (0);
seq__63562 = G__63749;
chunk__63563 = G__63750;
count__63564 = G__63751;
i__63565 = G__63752;
continue;
} else {
var c = cljs.core.first(seq__63562__$1);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,ident,c);


var G__63753 = cljs.core.next(seq__63562__$1);
var G__63754 = null;
var G__63755 = (0);
var G__63756 = (0);
seq__63562 = G__63753;
chunk__63563 = G__63754;
count__63564 = G__63755;
i__63565 = G__63756;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Renders components that have, or query for, the given ident.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_dependents_of_ident_BANG_(app,ident){
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_components_with_ident_BANG_(app,ident);

var map__63574 = app;
var map__63574__$1 = cljs.core.__destructure_map(map__63574);
var runtime_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63574__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","runtime-atom","com.fulcrologic.fulcro.application/runtime-atom",-1167397772));
var map__63575 = cljs.core.deref(runtime_atom);
var map__63575__$1 = cljs.core.__destructure_map(map__63575);
var indexes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63575__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","indexes","com.fulcrologic.fulcro.application/indexes",-165326938));
var map__63576 = indexes;
var map__63576__$1 = cljs.core.__destructure_map(map__63576);
var prop__GT_classes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63576__$1,new cljs.core.Keyword(null,"prop->classes","prop->classes",515892717));
var idents_in_joins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63576__$1,new cljs.core.Keyword(null,"idents-in-joins","idents-in-joins",-1556962035));
var class__GT_components = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63576__$1,new cljs.core.Keyword(null,"class->components","class->components",436435919));
var idents_in_joins__$1 = (function (){var or__4253__auto__ = idents_in_joins;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
if(cljs.core.contains_QMARK_(idents_in_joins__$1,ident)){
var classes = (prop__GT_classes.cljs$core$IFn$_invoke$arity$1 ? prop__GT_classes.cljs$core$IFn$_invoke$arity$1(ident) : prop__GT_classes.call(null,ident));
if(cljs.core.seq(classes)){
var seq__63577 = cljs.core.seq(classes);
var chunk__63578 = null;
var count__63579 = (0);
var i__63580 = (0);
while(true){
if((i__63580 < count__63579)){
var class$ = chunk__63578.cljs$core$IIndexed$_nth$arity$2(null,i__63580);
var seq__63606_63760 = cljs.core.seq((class__GT_components.cljs$core$IFn$_invoke$arity$1 ? class__GT_components.cljs$core$IFn$_invoke$arity$1(class$) : class__GT_components.call(null,class$)));
var chunk__63608_63761 = null;
var count__63609_63762 = (0);
var i__63610_63763 = (0);
while(true){
if((i__63610_63763 < count__63609_63762)){
var component_63765 = chunk__63608_63761.cljs$core$IIndexed$_nth$arity$2(null,i__63610_63763);
var component_ident_63767 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(component_63765) : com.fulcrologic.fulcro.components.get_ident.call(null,component_63765));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,component_ident_63767,component_63765);


var G__63776 = seq__63606_63760;
var G__63777 = chunk__63608_63761;
var G__63778 = count__63609_63762;
var G__63779 = (i__63610_63763 + (1));
seq__63606_63760 = G__63776;
chunk__63608_63761 = G__63777;
count__63609_63762 = G__63778;
i__63610_63763 = G__63779;
continue;
} else {
var temp__5753__auto___63780 = cljs.core.seq(seq__63606_63760);
if(temp__5753__auto___63780){
var seq__63606_63781__$1 = temp__5753__auto___63780;
if(cljs.core.chunked_seq_QMARK_(seq__63606_63781__$1)){
var c__4679__auto___63783 = cljs.core.chunk_first(seq__63606_63781__$1);
var G__63784 = cljs.core.chunk_rest(seq__63606_63781__$1);
var G__63785 = c__4679__auto___63783;
var G__63786 = cljs.core.count(c__4679__auto___63783);
var G__63787 = (0);
seq__63606_63760 = G__63784;
chunk__63608_63761 = G__63785;
count__63609_63762 = G__63786;
i__63610_63763 = G__63787;
continue;
} else {
var component_63788 = cljs.core.first(seq__63606_63781__$1);
var component_ident_63789 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(component_63788) : com.fulcrologic.fulcro.components.get_ident.call(null,component_63788));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,component_ident_63789,component_63788);


var G__63790 = cljs.core.next(seq__63606_63781__$1);
var G__63791 = null;
var G__63792 = (0);
var G__63793 = (0);
seq__63606_63760 = G__63790;
chunk__63608_63761 = G__63791;
count__63609_63762 = G__63792;
i__63610_63763 = G__63793;
continue;
}
} else {
}
}
break;
}


var G__63794 = seq__63577;
var G__63795 = chunk__63578;
var G__63796 = count__63579;
var G__63797 = (i__63580 + (1));
seq__63577 = G__63794;
chunk__63578 = G__63795;
count__63579 = G__63796;
i__63580 = G__63797;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63577);
if(temp__5753__auto__){
var seq__63577__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63577__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__63577__$1);
var G__63798 = cljs.core.chunk_rest(seq__63577__$1);
var G__63799 = c__4679__auto__;
var G__63800 = cljs.core.count(c__4679__auto__);
var G__63801 = (0);
seq__63577 = G__63798;
chunk__63578 = G__63799;
count__63579 = G__63800;
i__63580 = G__63801;
continue;
} else {
var class$ = cljs.core.first(seq__63577__$1);
var seq__63615_63802 = cljs.core.seq((class__GT_components.cljs$core$IFn$_invoke$arity$1 ? class__GT_components.cljs$core$IFn$_invoke$arity$1(class$) : class__GT_components.call(null,class$)));
var chunk__63617_63803 = null;
var count__63618_63804 = (0);
var i__63619_63805 = (0);
while(true){
if((i__63619_63805 < count__63618_63804)){
var component_63806 = chunk__63617_63803.cljs$core$IIndexed$_nth$arity$2(null,i__63619_63805);
var component_ident_63807 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(component_63806) : com.fulcrologic.fulcro.components.get_ident.call(null,component_63806));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,component_ident_63807,component_63806);


var G__63808 = seq__63615_63802;
var G__63809 = chunk__63617_63803;
var G__63810 = count__63618_63804;
var G__63811 = (i__63619_63805 + (1));
seq__63615_63802 = G__63808;
chunk__63617_63803 = G__63809;
count__63618_63804 = G__63810;
i__63619_63805 = G__63811;
continue;
} else {
var temp__5753__auto___63812__$1 = cljs.core.seq(seq__63615_63802);
if(temp__5753__auto___63812__$1){
var seq__63615_63813__$1 = temp__5753__auto___63812__$1;
if(cljs.core.chunked_seq_QMARK_(seq__63615_63813__$1)){
var c__4679__auto___63814 = cljs.core.chunk_first(seq__63615_63813__$1);
var G__63815 = cljs.core.chunk_rest(seq__63615_63813__$1);
var G__63816 = c__4679__auto___63814;
var G__63817 = cljs.core.count(c__4679__auto___63814);
var G__63818 = (0);
seq__63615_63802 = G__63815;
chunk__63617_63803 = G__63816;
count__63618_63804 = G__63817;
i__63619_63805 = G__63818;
continue;
} else {
var component_63819 = cljs.core.first(seq__63615_63813__$1);
var component_ident_63820 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(component_63819) : com.fulcrologic.fulcro.components.get_ident.call(null,component_63819));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,component_ident_63820,component_63819);


var G__63821 = cljs.core.next(seq__63615_63813__$1);
var G__63822 = null;
var G__63823 = (0);
var G__63824 = (0);
seq__63615_63802 = G__63821;
chunk__63617_63803 = G__63822;
count__63618_63804 = G__63823;
i__63619_63805 = G__63824;
continue;
}
} else {
}
}
break;
}


var G__63825 = cljs.core.next(seq__63577__$1);
var G__63826 = null;
var G__63827 = (0);
var G__63828 = (0);
seq__63577 = G__63825;
chunk__63578 = G__63826;
count__63579 = G__63827;
i__63580 = G__63828;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
/**
 * Given an app and a `property-set`: returns the components that query for the items in property-set.
 * 
 *   The `property-set` can be any sequence (ideally a set) of keywords and idents that can directly appear
 *   in a component query as a property or join key.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.props__GT_components = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$props__GT_components(app,property_set){
if(cljs.core.seq(property_set)){
var map__63635 = app;
var map__63635__$1 = cljs.core.__destructure_map(map__63635);
var runtime_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63635__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","runtime-atom","com.fulcrologic.fulcro.application/runtime-atom",-1167397772));
var map__63636 = cljs.core.deref(runtime_atom);
var map__63636__$1 = cljs.core.__destructure_map(map__63636);
var indexes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63636__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","indexes","com.fulcrologic.fulcro.application/indexes",-165326938));
var map__63637 = indexes;
var map__63637__$1 = cljs.core.__destructure_map(map__63637);
var prop__GT_classes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63637__$1,new cljs.core.Keyword(null,"prop->classes","prop->classes",515892717));
var class__GT_components = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63637__$1,new cljs.core.Keyword(null,"class->components","class->components",436435919));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,prop){
var classes = (prop__GT_classes.cljs$core$IFn$_invoke$arity$1 ? prop__GT_classes.cljs$core$IFn$_invoke$arity$1(prop) : prop__GT_classes.call(null,prop));
var components = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__63632_SHARP_,p2__63633_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(p1__63632_SHARP_,(class__GT_components.cljs$core$IFn$_invoke$arity$1 ? class__GT_components.cljs$core$IFn$_invoke$arity$1(p2__63633_SHARP_) : class__GT_components.call(null,p2__63633_SHARP_)));
}),cljs.core.PersistentHashSet.EMPTY,classes);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(result,components);
}),cljs.core.PersistentHashSet.EMPTY,property_set);
} else {
return null;
}
});
/**
 * This function tracks the state of the app at the time of prior render in the app's runtime-atom. It
 * uses that to do a comparison of old vs. current application state (bounded by the needs of on-screen components).
 * When it finds data that has changed it renders all of the components that depend on that data.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_stale_components_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_stale_components_BANG_(app){
var map__63641 = app;
var map__63641__$1 = cljs.core.__destructure_map(map__63641);
var runtime_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63641__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","runtime-atom","com.fulcrologic.fulcro.application/runtime-atom",-1167397772));
var state_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63641__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","state-atom","com.fulcrologic.fulcro.application/state-atom",648128366));
var map__63642 = cljs.core.deref(runtime_atom);
var map__63642__$1 = cljs.core.__destructure_map(map__63642);
var indexes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63642__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","indexes","com.fulcrologic.fulcro.application/indexes",-165326938));
var last_rendered_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63642__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","last-rendered-state","com.fulcrologic.fulcro.application/last-rendered-state",1438978441));
var to_refresh = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63642__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","to-refresh","com.fulcrologic.fulcro.application/to-refresh",-967758829));
var only_refresh = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63642__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","only-refresh","com.fulcrologic.fulcro.application/only-refresh",1300408206));
var map__63643 = indexes;
var map__63643__$1 = cljs.core.__destructure_map(map__63643);
var linked_props = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63643__$1,new cljs.core.Keyword(null,"linked-props","linked-props",1547374714));
var ident__GT_components = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63643__$1,new cljs.core.Keyword(null,"ident->components","ident->components",-1952169224));
var prop__GT_classes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63643__$1,new cljs.core.Keyword(null,"prop->classes","prop->classes",515892717));
var idents_in_joins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63643__$1,new cljs.core.Keyword(null,"idents-in-joins","idents-in-joins",-1556962035));
var limited_refresh_QMARK_ = cljs.core.seq(only_refresh);
if(limited_refresh_QMARK_){
var map__63644 = cljs.core.group_by(edn_query_language.core.ident_QMARK_,only_refresh);
var map__63644__$1 = cljs.core.__destructure_map(map__63644);
var limited_idents = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63644__$1,true);
var limited_props = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63644__$1,false);
var limited_to_render = com.fulcrologic.fulcro.rendering.ident_optimized_render.props__GT_components(app,limited_props);
var seq__63647_63837 = cljs.core.seq(limited_to_render);
var chunk__63649_63838 = null;
var count__63650_63839 = (0);
var i__63651_63840 = (0);
while(true){
if((i__63651_63840 < count__63650_63839)){
var c_63845 = chunk__63649_63838.cljs$core$IIndexed$_nth$arity$2(null,i__63651_63840);
var ident_63846 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(c_63845) : com.fulcrologic.fulcro.components.get_ident.call(null,c_63845));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,ident_63846,c_63845);


var G__63851 = seq__63647_63837;
var G__63852 = chunk__63649_63838;
var G__63853 = count__63650_63839;
var G__63854 = (i__63651_63840 + (1));
seq__63647_63837 = G__63851;
chunk__63649_63838 = G__63852;
count__63650_63839 = G__63853;
i__63651_63840 = G__63854;
continue;
} else {
var temp__5753__auto___63855 = cljs.core.seq(seq__63647_63837);
if(temp__5753__auto___63855){
var seq__63647_63859__$1 = temp__5753__auto___63855;
if(cljs.core.chunked_seq_QMARK_(seq__63647_63859__$1)){
var c__4679__auto___63860 = cljs.core.chunk_first(seq__63647_63859__$1);
var G__63861 = cljs.core.chunk_rest(seq__63647_63859__$1);
var G__63862 = c__4679__auto___63860;
var G__63863 = cljs.core.count(c__4679__auto___63860);
var G__63864 = (0);
seq__63647_63837 = G__63861;
chunk__63649_63838 = G__63862;
count__63650_63839 = G__63863;
i__63651_63840 = G__63864;
continue;
} else {
var c_63865 = cljs.core.first(seq__63647_63859__$1);
var ident_63866 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(c_63865) : com.fulcrologic.fulcro.components.get_ident.call(null,c_63865));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,ident_63866,c_63865);


var G__63867 = cljs.core.next(seq__63647_63859__$1);
var G__63868 = null;
var G__63869 = (0);
var G__63870 = (0);
seq__63647_63837 = G__63867;
chunk__63649_63838 = G__63868;
count__63650_63839 = G__63869;
i__63651_63840 = G__63870;
continue;
}
} else {
}
}
break;
}

var seq__63656 = cljs.core.seq(limited_idents);
var chunk__63657 = null;
var count__63658 = (0);
var i__63659 = (0);
while(true){
if((i__63659 < count__63658)){
var i = chunk__63657.cljs$core$IIndexed$_nth$arity$2(null,i__63659);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_(app,i);


var G__63877 = seq__63656;
var G__63878 = chunk__63657;
var G__63879 = count__63658;
var G__63880 = (i__63659 + (1));
seq__63656 = G__63877;
chunk__63657 = G__63878;
count__63658 = G__63879;
i__63659 = G__63880;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63656);
if(temp__5753__auto__){
var seq__63656__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63656__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__63656__$1);
var G__63884 = cljs.core.chunk_rest(seq__63656__$1);
var G__63885 = c__4679__auto__;
var G__63886 = cljs.core.count(c__4679__auto__);
var G__63887 = (0);
seq__63656 = G__63884;
chunk__63657 = G__63885;
count__63658 = G__63886;
i__63659 = G__63887;
continue;
} else {
var i = cljs.core.first(seq__63656__$1);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_(app,i);


var G__63894 = cljs.core.next(seq__63656__$1);
var G__63895 = null;
var G__63896 = (0);
var G__63897 = (0);
seq__63656 = G__63894;
chunk__63657 = G__63895;
count__63658 = G__63896;
i__63659 = G__63897;
continue;
}
} else {
return null;
}
}
break;
}
} else {
var state_map = cljs.core.deref(state_atom);
var idents_in_joins__$1 = (function (){var or__4253__auto__ = idents_in_joins;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
var dirty_linked_props = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(state_map,p) === cljs.core.get.cljs$core$IFn$_invoke$arity$2(last_rendered_state,p))))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,p);
} else {
return acc;
}
}),cljs.core.PersistentHashSet.EMPTY,linked_props);
var map__63671 = cljs.core.group_by(edn_query_language.core.ident_QMARK_,to_refresh);
var map__63671__$1 = cljs.core.__destructure_map(map__63671);
var idents_to_force = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63671__$1,true);
var props_to_force = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63671__$1,false);
var props_to_force__$1 = clojure.set.union.cljs$core$IFn$_invoke$arity$2(props_to_force,dirty_linked_props);
var mounted_idents = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(ident__GT_components),idents_in_joins__$1);
var stale_idents = com.fulcrologic.fulcro.rendering.ident_optimized_render.dirty_table_entries(last_rendered_state,state_map,mounted_idents);
var extra_to_force = com.fulcrologic.fulcro.rendering.ident_optimized_render.props__GT_components(app,props_to_force__$1);
var all_idents = clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.set(idents_to_force),cljs.core.set(stale_idents));
var seq__63677_63899 = cljs.core.seq(all_idents);
var chunk__63678_63900 = null;
var count__63679_63901 = (0);
var i__63680_63902 = (0);
while(true){
if((i__63680_63902 < count__63679_63901)){
var i_63903 = chunk__63678_63900.cljs$core$IIndexed$_nth$arity$2(null,i__63680_63902);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_(app,i_63903);


var G__63904 = seq__63677_63899;
var G__63905 = chunk__63678_63900;
var G__63906 = count__63679_63901;
var G__63907 = (i__63680_63902 + (1));
seq__63677_63899 = G__63904;
chunk__63678_63900 = G__63905;
count__63679_63901 = G__63906;
i__63680_63902 = G__63907;
continue;
} else {
var temp__5753__auto___63908 = cljs.core.seq(seq__63677_63899);
if(temp__5753__auto___63908){
var seq__63677_63909__$1 = temp__5753__auto___63908;
if(cljs.core.chunked_seq_QMARK_(seq__63677_63909__$1)){
var c__4679__auto___63910 = cljs.core.chunk_first(seq__63677_63909__$1);
var G__63911 = cljs.core.chunk_rest(seq__63677_63909__$1);
var G__63912 = c__4679__auto___63910;
var G__63913 = cljs.core.count(c__4679__auto___63910);
var G__63914 = (0);
seq__63677_63899 = G__63911;
chunk__63678_63900 = G__63912;
count__63679_63901 = G__63913;
i__63680_63902 = G__63914;
continue;
} else {
var i_63915 = cljs.core.first(seq__63677_63909__$1);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_(app,i_63915);


var G__63917 = cljs.core.next(seq__63677_63909__$1);
var G__63918 = null;
var G__63919 = (0);
var G__63920 = (0);
seq__63677_63899 = G__63917;
chunk__63678_63900 = G__63918;
count__63679_63901 = G__63919;
i__63680_63902 = G__63920;
continue;
}
} else {
}
}
break;
}

var seq__63687 = cljs.core.seq(extra_to_force);
var chunk__63688 = null;
var count__63689 = (0);
var i__63690 = (0);
while(true){
if((i__63690 < count__63689)){
var c = chunk__63688.cljs$core$IIndexed$_nth$arity$2(null,i__63690);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,(com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(c) : com.fulcrologic.fulcro.components.get_ident.call(null,c)),c);


var G__63924 = seq__63687;
var G__63925 = chunk__63688;
var G__63926 = count__63689;
var G__63927 = (i__63690 + (1));
seq__63687 = G__63924;
chunk__63688 = G__63925;
count__63689 = G__63926;
i__63690 = G__63927;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63687);
if(temp__5753__auto__){
var seq__63687__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63687__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__63687__$1);
var G__63928 = cljs.core.chunk_rest(seq__63687__$1);
var G__63929 = c__4679__auto__;
var G__63930 = cljs.core.count(c__4679__auto__);
var G__63931 = (0);
seq__63687 = G__63928;
chunk__63688 = G__63929;
count__63689 = G__63930;
i__63690 = G__63931;
continue;
} else {
var c = cljs.core.first(seq__63687__$1);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,(com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(c) : com.fulcrologic.fulcro.components.get_ident.call(null,c)),c);


var G__63932 = cljs.core.next(seq__63687__$1);
var G__63933 = null;
var G__63934 = (0);
var G__63935 = (0);
seq__63687 = G__63932;
chunk__63688 = G__63933;
count__63689 = G__63934;
i__63690 = G__63935;
continue;
}
} else {
return null;
}
}
break;
}
}
});
/**
 * The top-level call for using this optimized render in your application.
 * 
 *   If `:force-root? true` is passed in options, then it just forces a keyframe root render; otherwise
 *   it tries to minimize the work done for screen refresh to just the queries/refreshes needed by the
 *   data that has changed.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_BANG_(var_args){
var G__63705 = arguments.length;
switch (G__63705) {
case 1:
return com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (app){
return com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$2(app,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app,p__63713){
var map__63714 = p__63713;
var map__63714__$1 = cljs.core.__destructure_map(map__63714);
var options = map__63714__$1;
var force_root_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63714__$1,new cljs.core.Keyword(null,"force-root?","force-root?",-1598741683));
var root_props_changed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63714__$1,new cljs.core.Keyword(null,"root-props-changed?","root-props-changed?",1999614835));
if(cljs.core.truth_((function (){var or__4253__auto__ = force_root_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return root_props_changed_QMARK_;
}
})())){
return com.fulcrologic.fulcro.rendering.keyframe_render.render_BANG_(app,options);
} else {
try{return com.fulcrologic.fulcro.rendering.ident_optimized_render.render_stale_components_BANG_(app);
}catch (e63715){var e = e63715;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"com.fulcrologic.fulcro.rendering.ident-optimized-render",null,146,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Optimized render failed. Falling back to root render."], null);
}),null)),null,-1949434493,null);

return com.fulcrologic.fulcro.rendering.keyframe_render.render_BANG_(app,options);
}}
}));

(com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=com.fulcrologic.fulcro.rendering.ident_optimized_render.js.map
