goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_52153 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_52153(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_52158 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_52158(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__50858 = coll;
var G__50859 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__50858,G__50859) : shadow.dom.lazy_native_coll_seq.call(null,G__50858,G__50859));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4253__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__50910 = arguments.length;
switch (G__50910) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__50918 = arguments.length;
switch (G__50918) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__50927 = arguments.length;
switch (G__50927) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__50938 = arguments.length;
switch (G__50938) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__50948 = arguments.length;
switch (G__50948) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__50959 = arguments.length;
switch (G__50959) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e50968){if((e50968 instanceof Object)){
var e = e50968;
return console.log("didnt support attachEvent",el,e);
} else {
throw e50968;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__50985 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__50986 = null;
var count__50987 = (0);
var i__50988 = (0);
while(true){
if((i__50988 < count__50987)){
var el = chunk__50986.cljs$core$IIndexed$_nth$arity$2(null,i__50988);
var handler_52242__$1 = ((function (seq__50985,chunk__50986,count__50987,i__50988,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__50985,chunk__50986,count__50987,i__50988,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52242__$1);


var G__52244 = seq__50985;
var G__52245 = chunk__50986;
var G__52246 = count__50987;
var G__52247 = (i__50988 + (1));
seq__50985 = G__52244;
chunk__50986 = G__52245;
count__50987 = G__52246;
i__50988 = G__52247;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__50985);
if(temp__5753__auto__){
var seq__50985__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50985__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__50985__$1);
var G__52260 = cljs.core.chunk_rest(seq__50985__$1);
var G__52261 = c__4679__auto__;
var G__52262 = cljs.core.count(c__4679__auto__);
var G__52263 = (0);
seq__50985 = G__52260;
chunk__50986 = G__52261;
count__50987 = G__52262;
i__50988 = G__52263;
continue;
} else {
var el = cljs.core.first(seq__50985__$1);
var handler_52267__$1 = ((function (seq__50985,chunk__50986,count__50987,i__50988,el,seq__50985__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__50985,chunk__50986,count__50987,i__50988,el,seq__50985__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_52267__$1);


var G__52269 = cljs.core.next(seq__50985__$1);
var G__52270 = null;
var G__52271 = (0);
var G__52272 = (0);
seq__50985 = G__52269;
chunk__50986 = G__52270;
count__50987 = G__52271;
i__50988 = G__52272;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__51030 = arguments.length;
switch (G__51030) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__51059 = cljs.core.seq(events);
var chunk__51060 = null;
var count__51061 = (0);
var i__51062 = (0);
while(true){
if((i__51062 < count__51061)){
var vec__51090 = chunk__51060.cljs$core$IIndexed$_nth$arity$2(null,i__51062);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51090,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51090,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52286 = seq__51059;
var G__52287 = chunk__51060;
var G__52288 = count__51061;
var G__52289 = (i__51062 + (1));
seq__51059 = G__52286;
chunk__51060 = G__52287;
count__51061 = G__52288;
i__51062 = G__52289;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__51059);
if(temp__5753__auto__){
var seq__51059__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51059__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__51059__$1);
var G__52291 = cljs.core.chunk_rest(seq__51059__$1);
var G__52292 = c__4679__auto__;
var G__52293 = cljs.core.count(c__4679__auto__);
var G__52294 = (0);
seq__51059 = G__52291;
chunk__51060 = G__52292;
count__51061 = G__52293;
i__51062 = G__52294;
continue;
} else {
var vec__51107 = cljs.core.first(seq__51059__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51107,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51107,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__52297 = cljs.core.next(seq__51059__$1);
var G__52298 = null;
var G__52299 = (0);
var G__52300 = (0);
seq__51059 = G__52297;
chunk__51060 = G__52298;
count__51061 = G__52299;
i__51062 = G__52300;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__51121 = cljs.core.seq(styles);
var chunk__51122 = null;
var count__51123 = (0);
var i__51124 = (0);
while(true){
if((i__51124 < count__51123)){
var vec__51149 = chunk__51122.cljs$core$IIndexed$_nth$arity$2(null,i__51124);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51149,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51149,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52303 = seq__51121;
var G__52304 = chunk__51122;
var G__52305 = count__51123;
var G__52306 = (i__51124 + (1));
seq__51121 = G__52303;
chunk__51122 = G__52304;
count__51123 = G__52305;
i__51124 = G__52306;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__51121);
if(temp__5753__auto__){
var seq__51121__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51121__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__51121__$1);
var G__52308 = cljs.core.chunk_rest(seq__51121__$1);
var G__52309 = c__4679__auto__;
var G__52310 = cljs.core.count(c__4679__auto__);
var G__52311 = (0);
seq__51121 = G__52308;
chunk__51122 = G__52309;
count__51123 = G__52310;
i__51124 = G__52311;
continue;
} else {
var vec__51156 = cljs.core.first(seq__51121__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51156,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51156,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__52312 = cljs.core.next(seq__51121__$1);
var G__52313 = null;
var G__52314 = (0);
var G__52315 = (0);
seq__51121 = G__52312;
chunk__51122 = G__52313;
count__51123 = G__52314;
i__51124 = G__52315;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__51174_52317 = key;
var G__51174_52318__$1 = (((G__51174_52317 instanceof cljs.core.Keyword))?G__51174_52317.fqn:null);
switch (G__51174_52318__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_52325 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4253__auto__ = goog.string.startsWith(ks_52325,"data-");
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return goog.string.startsWith(ks_52325,"aria-");
}
})())){
el.setAttribute(ks_52325,value);
} else {
(el[ks_52325] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__51195){
var map__51197 = p__51195;
var map__51197__$1 = cljs.core.__destructure_map(map__51197);
var props = map__51197__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51197__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__51201 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51201,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51201,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51201,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__51206 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__51206,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__51206;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__51215 = arguments.length;
switch (G__51215) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__51221){
var vec__51222 = p__51221;
var seq__51223 = cljs.core.seq(vec__51222);
var first__51224 = cljs.core.first(seq__51223);
var seq__51223__$1 = cljs.core.next(seq__51223);
var nn = first__51224;
var first__51224__$1 = cljs.core.first(seq__51223__$1);
var seq__51223__$2 = cljs.core.next(seq__51223__$1);
var np = first__51224__$1;
var nc = seq__51223__$2;
var node = vec__51222;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51225 = nn;
var G__51227 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51225,G__51227) : create_fn.call(null,G__51225,G__51227));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__51228 = nn;
var G__51229 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__51228,G__51229) : create_fn.call(null,G__51228,G__51229));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__51230 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51230,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51230,(1),null);
var seq__51233_52342 = cljs.core.seq(node_children);
var chunk__51234_52343 = null;
var count__51235_52344 = (0);
var i__51236_52345 = (0);
while(true){
if((i__51236_52345 < count__51235_52344)){
var child_struct_52346 = chunk__51234_52343.cljs$core$IIndexed$_nth$arity$2(null,i__51236_52345);
var children_52347 = shadow.dom.dom_node(child_struct_52346);
if(cljs.core.seq_QMARK_(children_52347)){
var seq__51288_52348 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52347));
var chunk__51290_52349 = null;
var count__51291_52350 = (0);
var i__51292_52351 = (0);
while(true){
if((i__51292_52351 < count__51291_52350)){
var child_52353 = chunk__51290_52349.cljs$core$IIndexed$_nth$arity$2(null,i__51292_52351);
if(cljs.core.truth_(child_52353)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52353);


var G__52354 = seq__51288_52348;
var G__52355 = chunk__51290_52349;
var G__52356 = count__51291_52350;
var G__52357 = (i__51292_52351 + (1));
seq__51288_52348 = G__52354;
chunk__51290_52349 = G__52355;
count__51291_52350 = G__52356;
i__51292_52351 = G__52357;
continue;
} else {
var G__52358 = seq__51288_52348;
var G__52359 = chunk__51290_52349;
var G__52360 = count__51291_52350;
var G__52361 = (i__51292_52351 + (1));
seq__51288_52348 = G__52358;
chunk__51290_52349 = G__52359;
count__51291_52350 = G__52360;
i__51292_52351 = G__52361;
continue;
}
} else {
var temp__5753__auto___52364 = cljs.core.seq(seq__51288_52348);
if(temp__5753__auto___52364){
var seq__51288_52365__$1 = temp__5753__auto___52364;
if(cljs.core.chunked_seq_QMARK_(seq__51288_52365__$1)){
var c__4679__auto___52366 = cljs.core.chunk_first(seq__51288_52365__$1);
var G__52367 = cljs.core.chunk_rest(seq__51288_52365__$1);
var G__52368 = c__4679__auto___52366;
var G__52369 = cljs.core.count(c__4679__auto___52366);
var G__52370 = (0);
seq__51288_52348 = G__52367;
chunk__51290_52349 = G__52368;
count__51291_52350 = G__52369;
i__51292_52351 = G__52370;
continue;
} else {
var child_52372 = cljs.core.first(seq__51288_52365__$1);
if(cljs.core.truth_(child_52372)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52372);


var G__52373 = cljs.core.next(seq__51288_52365__$1);
var G__52374 = null;
var G__52375 = (0);
var G__52376 = (0);
seq__51288_52348 = G__52373;
chunk__51290_52349 = G__52374;
count__51291_52350 = G__52375;
i__51292_52351 = G__52376;
continue;
} else {
var G__52377 = cljs.core.next(seq__51288_52365__$1);
var G__52378 = null;
var G__52379 = (0);
var G__52380 = (0);
seq__51288_52348 = G__52377;
chunk__51290_52349 = G__52378;
count__51291_52350 = G__52379;
i__51292_52351 = G__52380;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52347);
}


var G__52382 = seq__51233_52342;
var G__52383 = chunk__51234_52343;
var G__52384 = count__51235_52344;
var G__52385 = (i__51236_52345 + (1));
seq__51233_52342 = G__52382;
chunk__51234_52343 = G__52383;
count__51235_52344 = G__52384;
i__51236_52345 = G__52385;
continue;
} else {
var temp__5753__auto___52386 = cljs.core.seq(seq__51233_52342);
if(temp__5753__auto___52386){
var seq__51233_52387__$1 = temp__5753__auto___52386;
if(cljs.core.chunked_seq_QMARK_(seq__51233_52387__$1)){
var c__4679__auto___52389 = cljs.core.chunk_first(seq__51233_52387__$1);
var G__52390 = cljs.core.chunk_rest(seq__51233_52387__$1);
var G__52391 = c__4679__auto___52389;
var G__52392 = cljs.core.count(c__4679__auto___52389);
var G__52393 = (0);
seq__51233_52342 = G__52390;
chunk__51234_52343 = G__52391;
count__51235_52344 = G__52392;
i__51236_52345 = G__52393;
continue;
} else {
var child_struct_52394 = cljs.core.first(seq__51233_52387__$1);
var children_52395 = shadow.dom.dom_node(child_struct_52394);
if(cljs.core.seq_QMARK_(children_52395)){
var seq__51310_52396 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_52395));
var chunk__51312_52397 = null;
var count__51313_52398 = (0);
var i__51314_52399 = (0);
while(true){
if((i__51314_52399 < count__51313_52398)){
var child_52400 = chunk__51312_52397.cljs$core$IIndexed$_nth$arity$2(null,i__51314_52399);
if(cljs.core.truth_(child_52400)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52400);


var G__52401 = seq__51310_52396;
var G__52402 = chunk__51312_52397;
var G__52403 = count__51313_52398;
var G__52404 = (i__51314_52399 + (1));
seq__51310_52396 = G__52401;
chunk__51312_52397 = G__52402;
count__51313_52398 = G__52403;
i__51314_52399 = G__52404;
continue;
} else {
var G__52405 = seq__51310_52396;
var G__52406 = chunk__51312_52397;
var G__52407 = count__51313_52398;
var G__52408 = (i__51314_52399 + (1));
seq__51310_52396 = G__52405;
chunk__51312_52397 = G__52406;
count__51313_52398 = G__52407;
i__51314_52399 = G__52408;
continue;
}
} else {
var temp__5753__auto___52409__$1 = cljs.core.seq(seq__51310_52396);
if(temp__5753__auto___52409__$1){
var seq__51310_52410__$1 = temp__5753__auto___52409__$1;
if(cljs.core.chunked_seq_QMARK_(seq__51310_52410__$1)){
var c__4679__auto___52411 = cljs.core.chunk_first(seq__51310_52410__$1);
var G__52412 = cljs.core.chunk_rest(seq__51310_52410__$1);
var G__52413 = c__4679__auto___52411;
var G__52414 = cljs.core.count(c__4679__auto___52411);
var G__52415 = (0);
seq__51310_52396 = G__52412;
chunk__51312_52397 = G__52413;
count__51313_52398 = G__52414;
i__51314_52399 = G__52415;
continue;
} else {
var child_52418 = cljs.core.first(seq__51310_52410__$1);
if(cljs.core.truth_(child_52418)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_52418);


var G__52419 = cljs.core.next(seq__51310_52410__$1);
var G__52420 = null;
var G__52421 = (0);
var G__52422 = (0);
seq__51310_52396 = G__52419;
chunk__51312_52397 = G__52420;
count__51313_52398 = G__52421;
i__51314_52399 = G__52422;
continue;
} else {
var G__52423 = cljs.core.next(seq__51310_52410__$1);
var G__52424 = null;
var G__52425 = (0);
var G__52426 = (0);
seq__51310_52396 = G__52423;
chunk__51312_52397 = G__52424;
count__51313_52398 = G__52425;
i__51314_52399 = G__52426;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_52395);
}


var G__52428 = cljs.core.next(seq__51233_52387__$1);
var G__52429 = null;
var G__52430 = (0);
var G__52431 = (0);
seq__51233_52342 = G__52428;
chunk__51234_52343 = G__52429;
count__51235_52344 = G__52430;
i__51236_52345 = G__52431;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__51367 = cljs.core.seq(node);
var chunk__51368 = null;
var count__51369 = (0);
var i__51370 = (0);
while(true){
if((i__51370 < count__51369)){
var n = chunk__51368.cljs$core$IIndexed$_nth$arity$2(null,i__51370);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52437 = seq__51367;
var G__52438 = chunk__51368;
var G__52439 = count__51369;
var G__52440 = (i__51370 + (1));
seq__51367 = G__52437;
chunk__51368 = G__52438;
count__51369 = G__52439;
i__51370 = G__52440;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__51367);
if(temp__5753__auto__){
var seq__51367__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51367__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__51367__$1);
var G__52441 = cljs.core.chunk_rest(seq__51367__$1);
var G__52442 = c__4679__auto__;
var G__52443 = cljs.core.count(c__4679__auto__);
var G__52444 = (0);
seq__51367 = G__52441;
chunk__51368 = G__52442;
count__51369 = G__52443;
i__51370 = G__52444;
continue;
} else {
var n = cljs.core.first(seq__51367__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__52447 = cljs.core.next(seq__51367__$1);
var G__52448 = null;
var G__52449 = (0);
var G__52450 = (0);
seq__51367 = G__52447;
chunk__51368 = G__52448;
count__51369 = G__52449;
i__51370 = G__52450;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__51396 = arguments.length;
switch (G__51396) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__51407 = arguments.length;
switch (G__51407) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__51444 = arguments.length;
switch (G__51444) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4253__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4870__auto__ = [];
var len__4864__auto___52492 = arguments.length;
var i__4865__auto___52493 = (0);
while(true){
if((i__4865__auto___52493 < len__4864__auto___52492)){
args__4870__auto__.push((arguments[i__4865__auto___52493]));

var G__52499 = (i__4865__auto___52493 + (1));
i__4865__auto___52493 = G__52499;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__51460_52511 = cljs.core.seq(nodes);
var chunk__51461_52512 = null;
var count__51462_52513 = (0);
var i__51463_52514 = (0);
while(true){
if((i__51463_52514 < count__51462_52513)){
var node_52519 = chunk__51461_52512.cljs$core$IIndexed$_nth$arity$2(null,i__51463_52514);
fragment.appendChild(shadow.dom._to_dom(node_52519));


var G__52520 = seq__51460_52511;
var G__52521 = chunk__51461_52512;
var G__52522 = count__51462_52513;
var G__52523 = (i__51463_52514 + (1));
seq__51460_52511 = G__52520;
chunk__51461_52512 = G__52521;
count__51462_52513 = G__52522;
i__51463_52514 = G__52523;
continue;
} else {
var temp__5753__auto___52525 = cljs.core.seq(seq__51460_52511);
if(temp__5753__auto___52525){
var seq__51460_52527__$1 = temp__5753__auto___52525;
if(cljs.core.chunked_seq_QMARK_(seq__51460_52527__$1)){
var c__4679__auto___52528 = cljs.core.chunk_first(seq__51460_52527__$1);
var G__52529 = cljs.core.chunk_rest(seq__51460_52527__$1);
var G__52530 = c__4679__auto___52528;
var G__52531 = cljs.core.count(c__4679__auto___52528);
var G__52532 = (0);
seq__51460_52511 = G__52529;
chunk__51461_52512 = G__52530;
count__51462_52513 = G__52531;
i__51463_52514 = G__52532;
continue;
} else {
var node_52533 = cljs.core.first(seq__51460_52527__$1);
fragment.appendChild(shadow.dom._to_dom(node_52533));


var G__52534 = cljs.core.next(seq__51460_52527__$1);
var G__52535 = null;
var G__52536 = (0);
var G__52537 = (0);
seq__51460_52511 = G__52534;
chunk__51461_52512 = G__52535;
count__51462_52513 = G__52536;
i__51463_52514 = G__52537;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq51458){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq51458));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__51467_52542 = cljs.core.seq(scripts);
var chunk__51468_52543 = null;
var count__51469_52544 = (0);
var i__51470_52545 = (0);
while(true){
if((i__51470_52545 < count__51469_52544)){
var vec__51477_52546 = chunk__51468_52543.cljs$core$IIndexed$_nth$arity$2(null,i__51470_52545);
var script_tag_52547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51477_52546,(0),null);
var script_body_52548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51477_52546,(1),null);
eval(script_body_52548);


var G__52549 = seq__51467_52542;
var G__52550 = chunk__51468_52543;
var G__52551 = count__51469_52544;
var G__52552 = (i__51470_52545 + (1));
seq__51467_52542 = G__52549;
chunk__51468_52543 = G__52550;
count__51469_52544 = G__52551;
i__51470_52545 = G__52552;
continue;
} else {
var temp__5753__auto___52553 = cljs.core.seq(seq__51467_52542);
if(temp__5753__auto___52553){
var seq__51467_52554__$1 = temp__5753__auto___52553;
if(cljs.core.chunked_seq_QMARK_(seq__51467_52554__$1)){
var c__4679__auto___52555 = cljs.core.chunk_first(seq__51467_52554__$1);
var G__52556 = cljs.core.chunk_rest(seq__51467_52554__$1);
var G__52557 = c__4679__auto___52555;
var G__52558 = cljs.core.count(c__4679__auto___52555);
var G__52559 = (0);
seq__51467_52542 = G__52556;
chunk__51468_52543 = G__52557;
count__51469_52544 = G__52558;
i__51470_52545 = G__52559;
continue;
} else {
var vec__51480_52560 = cljs.core.first(seq__51467_52554__$1);
var script_tag_52561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51480_52560,(0),null);
var script_body_52562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51480_52560,(1),null);
eval(script_body_52562);


var G__52563 = cljs.core.next(seq__51467_52554__$1);
var G__52564 = null;
var G__52565 = (0);
var G__52566 = (0);
seq__51467_52542 = G__52563;
chunk__51468_52543 = G__52564;
count__51469_52544 = G__52565;
i__51470_52545 = G__52566;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__51483){
var vec__51484 = p__51483;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51484,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51484,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__51490 = arguments.length;
switch (G__51490) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__51504 = cljs.core.seq(style_keys);
var chunk__51505 = null;
var count__51506 = (0);
var i__51507 = (0);
while(true){
if((i__51507 < count__51506)){
var it = chunk__51505.cljs$core$IIndexed$_nth$arity$2(null,i__51507);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52585 = seq__51504;
var G__52586 = chunk__51505;
var G__52587 = count__51506;
var G__52588 = (i__51507 + (1));
seq__51504 = G__52585;
chunk__51505 = G__52586;
count__51506 = G__52587;
i__51507 = G__52588;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__51504);
if(temp__5753__auto__){
var seq__51504__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__51504__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__51504__$1);
var G__52589 = cljs.core.chunk_rest(seq__51504__$1);
var G__52590 = c__4679__auto__;
var G__52591 = cljs.core.count(c__4679__auto__);
var G__52592 = (0);
seq__51504 = G__52589;
chunk__51505 = G__52590;
count__51506 = G__52591;
i__51507 = G__52592;
continue;
} else {
var it = cljs.core.first(seq__51504__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__52596 = cljs.core.next(seq__51504__$1);
var G__52597 = null;
var G__52598 = (0);
var G__52599 = (0);
seq__51504 = G__52596;
chunk__51505 = G__52597;
count__51506 = G__52598;
i__51507 = G__52599;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k51523,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__51537 = k51523;
var G__51537__$1 = (((G__51537 instanceof cljs.core.Keyword))?G__51537.fqn:null);
switch (G__51537__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k51523,else__4505__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__51541){
var vec__51542 = p__51541;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51542,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51542,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__51522){
var self__ = this;
var G__51522__$1 = this;
return (new cljs.core.RecordIter((0),G__51522__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this51524,other51525){
var self__ = this;
var this51524__$1 = this;
return (((!((other51525 == null)))) && ((((this51524__$1.constructor === other51525.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51524__$1.x,other51525.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51524__$1.y,other51525.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51524__$1.__extmap,other51525.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k51523){
var self__ = this;
var this__4509__auto____$1 = this;
var G__51562 = k51523;
var G__51562__$1 = (((G__51562 instanceof cljs.core.Keyword))?G__51562.fqn:null);
switch (G__51562__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k51523);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__51522){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__51568 = cljs.core.keyword_identical_QMARK_;
var expr__51569 = k__4511__auto__;
if(cljs.core.truth_((pred__51568.cljs$core$IFn$_invoke$arity$2 ? pred__51568.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__51569) : pred__51568.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__51569)))){
return (new shadow.dom.Coordinate(G__51522,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__51568.cljs$core$IFn$_invoke$arity$2 ? pred__51568.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__51569) : pred__51568.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__51569)))){
return (new shadow.dom.Coordinate(self__.x,G__51522,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__51522),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__51522){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__51522,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__51526){
var extmap__4542__auto__ = (function (){var G__51581 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__51526,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__51526)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__51581);
} else {
return G__51581;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__51526),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__51526),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k51587,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__51600 = k51587;
var G__51600__$1 = (((G__51600 instanceof cljs.core.Keyword))?G__51600.fqn:null);
switch (G__51600__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k51587,else__4505__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__51605){
var vec__51610 = p__51605;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51610,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51610,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Size{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__51586){
var self__ = this;
var G__51586__$1 = this;
return (new cljs.core.RecordIter((0),G__51586__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this51588,other51589){
var self__ = this;
var this51588__$1 = this;
return (((!((other51589 == null)))) && ((((this51588__$1.constructor === other51589.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51588__$1.w,other51589.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51588__$1.h,other51589.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this51588__$1.__extmap,other51589.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k51587){
var self__ = this;
var this__4509__auto____$1 = this;
var G__51645 = k51587;
var G__51645__$1 = (((G__51645 instanceof cljs.core.Keyword))?G__51645.fqn:null);
switch (G__51645__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k51587);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__51586){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__51649 = cljs.core.keyword_identical_QMARK_;
var expr__51650 = k__4511__auto__;
if(cljs.core.truth_((pred__51649.cljs$core$IFn$_invoke$arity$2 ? pred__51649.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__51650) : pred__51649.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__51650)))){
return (new shadow.dom.Size(G__51586,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__51649.cljs$core$IFn$_invoke$arity$2 ? pred__51649.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__51650) : pred__51649.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__51650)))){
return (new shadow.dom.Size(self__.w,G__51586,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__51586),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__51586){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__51586,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__51593){
var extmap__4542__auto__ = (function (){var G__51674 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__51593,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__51593)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__51674);
} else {
return G__51674;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__51593),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__51593),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4738__auto__ = opts;
var l__4739__auto__ = a__4738__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4739__auto__)){
var G__52721 = (i + (1));
var G__52722 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__52721;
ret = G__52722;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__51705){
var vec__51706 = p__51705;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51706,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51706,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__51716 = arguments.length;
switch (G__51716) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__52743 = ps;
var G__52744 = (i + (1));
el__$1 = G__52743;
i = G__52744;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__51766 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51766,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51766,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51766,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__51769_52760 = cljs.core.seq(props);
var chunk__51770_52761 = null;
var count__51771_52762 = (0);
var i__51772_52764 = (0);
while(true){
if((i__51772_52764 < count__51771_52762)){
var vec__51799_52767 = chunk__51770_52761.cljs$core$IIndexed$_nth$arity$2(null,i__51772_52764);
var k_52768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51799_52767,(0),null);
var v_52769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51799_52767,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_52768);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_52768),v_52769);


var G__52774 = seq__51769_52760;
var G__52775 = chunk__51770_52761;
var G__52776 = count__51771_52762;
var G__52777 = (i__51772_52764 + (1));
seq__51769_52760 = G__52774;
chunk__51770_52761 = G__52775;
count__51771_52762 = G__52776;
i__51772_52764 = G__52777;
continue;
} else {
var temp__5753__auto___52779 = cljs.core.seq(seq__51769_52760);
if(temp__5753__auto___52779){
var seq__51769_52780__$1 = temp__5753__auto___52779;
if(cljs.core.chunked_seq_QMARK_(seq__51769_52780__$1)){
var c__4679__auto___52781 = cljs.core.chunk_first(seq__51769_52780__$1);
var G__52782 = cljs.core.chunk_rest(seq__51769_52780__$1);
var G__52783 = c__4679__auto___52781;
var G__52784 = cljs.core.count(c__4679__auto___52781);
var G__52785 = (0);
seq__51769_52760 = G__52782;
chunk__51770_52761 = G__52783;
count__51771_52762 = G__52784;
i__51772_52764 = G__52785;
continue;
} else {
var vec__51812_52787 = cljs.core.first(seq__51769_52780__$1);
var k_52788 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51812_52787,(0),null);
var v_52789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51812_52787,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_52788);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_52788),v_52789);


var G__52793 = cljs.core.next(seq__51769_52780__$1);
var G__52794 = null;
var G__52795 = (0);
var G__52796 = (0);
seq__51769_52760 = G__52793;
chunk__51770_52761 = G__52794;
count__51771_52762 = G__52795;
i__51772_52764 = G__52796;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__51838 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51838,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51838,(1),null);
var seq__51841_52798 = cljs.core.seq(node_children);
var chunk__51843_52799 = null;
var count__51844_52800 = (0);
var i__51845_52801 = (0);
while(true){
if((i__51845_52801 < count__51844_52800)){
var child_struct_52802 = chunk__51843_52799.cljs$core$IIndexed$_nth$arity$2(null,i__51845_52801);
if((!((child_struct_52802 == null)))){
if(typeof child_struct_52802 === 'string'){
var text_52803 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_52803),child_struct_52802].join(''));
} else {
var children_52804 = shadow.dom.svg_node(child_struct_52802);
if(cljs.core.seq_QMARK_(children_52804)){
var seq__51885_52805 = cljs.core.seq(children_52804);
var chunk__51887_52806 = null;
var count__51888_52807 = (0);
var i__51889_52808 = (0);
while(true){
if((i__51889_52808 < count__51888_52807)){
var child_52811 = chunk__51887_52806.cljs$core$IIndexed$_nth$arity$2(null,i__51889_52808);
if(cljs.core.truth_(child_52811)){
node.appendChild(child_52811);


var G__52813 = seq__51885_52805;
var G__52814 = chunk__51887_52806;
var G__52815 = count__51888_52807;
var G__52816 = (i__51889_52808 + (1));
seq__51885_52805 = G__52813;
chunk__51887_52806 = G__52814;
count__51888_52807 = G__52815;
i__51889_52808 = G__52816;
continue;
} else {
var G__52818 = seq__51885_52805;
var G__52819 = chunk__51887_52806;
var G__52820 = count__51888_52807;
var G__52821 = (i__51889_52808 + (1));
seq__51885_52805 = G__52818;
chunk__51887_52806 = G__52819;
count__51888_52807 = G__52820;
i__51889_52808 = G__52821;
continue;
}
} else {
var temp__5753__auto___52822 = cljs.core.seq(seq__51885_52805);
if(temp__5753__auto___52822){
var seq__51885_52823__$1 = temp__5753__auto___52822;
if(cljs.core.chunked_seq_QMARK_(seq__51885_52823__$1)){
var c__4679__auto___52824 = cljs.core.chunk_first(seq__51885_52823__$1);
var G__52825 = cljs.core.chunk_rest(seq__51885_52823__$1);
var G__52826 = c__4679__auto___52824;
var G__52827 = cljs.core.count(c__4679__auto___52824);
var G__52828 = (0);
seq__51885_52805 = G__52825;
chunk__51887_52806 = G__52826;
count__51888_52807 = G__52827;
i__51889_52808 = G__52828;
continue;
} else {
var child_52832 = cljs.core.first(seq__51885_52823__$1);
if(cljs.core.truth_(child_52832)){
node.appendChild(child_52832);


var G__52833 = cljs.core.next(seq__51885_52823__$1);
var G__52834 = null;
var G__52835 = (0);
var G__52836 = (0);
seq__51885_52805 = G__52833;
chunk__51887_52806 = G__52834;
count__51888_52807 = G__52835;
i__51889_52808 = G__52836;
continue;
} else {
var G__52837 = cljs.core.next(seq__51885_52823__$1);
var G__52838 = null;
var G__52839 = (0);
var G__52840 = (0);
seq__51885_52805 = G__52837;
chunk__51887_52806 = G__52838;
count__51888_52807 = G__52839;
i__51889_52808 = G__52840;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_52804);
}
}


var G__52842 = seq__51841_52798;
var G__52843 = chunk__51843_52799;
var G__52844 = count__51844_52800;
var G__52845 = (i__51845_52801 + (1));
seq__51841_52798 = G__52842;
chunk__51843_52799 = G__52843;
count__51844_52800 = G__52844;
i__51845_52801 = G__52845;
continue;
} else {
var G__52846 = seq__51841_52798;
var G__52847 = chunk__51843_52799;
var G__52848 = count__51844_52800;
var G__52849 = (i__51845_52801 + (1));
seq__51841_52798 = G__52846;
chunk__51843_52799 = G__52847;
count__51844_52800 = G__52848;
i__51845_52801 = G__52849;
continue;
}
} else {
var temp__5753__auto___52850 = cljs.core.seq(seq__51841_52798);
if(temp__5753__auto___52850){
var seq__51841_52851__$1 = temp__5753__auto___52850;
if(cljs.core.chunked_seq_QMARK_(seq__51841_52851__$1)){
var c__4679__auto___52853 = cljs.core.chunk_first(seq__51841_52851__$1);
var G__52855 = cljs.core.chunk_rest(seq__51841_52851__$1);
var G__52856 = c__4679__auto___52853;
var G__52857 = cljs.core.count(c__4679__auto___52853);
var G__52858 = (0);
seq__51841_52798 = G__52855;
chunk__51843_52799 = G__52856;
count__51844_52800 = G__52857;
i__51845_52801 = G__52858;
continue;
} else {
var child_struct_52859 = cljs.core.first(seq__51841_52851__$1);
if((!((child_struct_52859 == null)))){
if(typeof child_struct_52859 === 'string'){
var text_52862 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_52862),child_struct_52859].join(''));
} else {
var children_52863 = shadow.dom.svg_node(child_struct_52859);
if(cljs.core.seq_QMARK_(children_52863)){
var seq__51957_52864 = cljs.core.seq(children_52863);
var chunk__51959_52865 = null;
var count__51960_52866 = (0);
var i__51961_52867 = (0);
while(true){
if((i__51961_52867 < count__51960_52866)){
var child_52868 = chunk__51959_52865.cljs$core$IIndexed$_nth$arity$2(null,i__51961_52867);
if(cljs.core.truth_(child_52868)){
node.appendChild(child_52868);


var G__52869 = seq__51957_52864;
var G__52870 = chunk__51959_52865;
var G__52871 = count__51960_52866;
var G__52872 = (i__51961_52867 + (1));
seq__51957_52864 = G__52869;
chunk__51959_52865 = G__52870;
count__51960_52866 = G__52871;
i__51961_52867 = G__52872;
continue;
} else {
var G__52873 = seq__51957_52864;
var G__52874 = chunk__51959_52865;
var G__52875 = count__51960_52866;
var G__52876 = (i__51961_52867 + (1));
seq__51957_52864 = G__52873;
chunk__51959_52865 = G__52874;
count__51960_52866 = G__52875;
i__51961_52867 = G__52876;
continue;
}
} else {
var temp__5753__auto___52877__$1 = cljs.core.seq(seq__51957_52864);
if(temp__5753__auto___52877__$1){
var seq__51957_52879__$1 = temp__5753__auto___52877__$1;
if(cljs.core.chunked_seq_QMARK_(seq__51957_52879__$1)){
var c__4679__auto___52880 = cljs.core.chunk_first(seq__51957_52879__$1);
var G__52881 = cljs.core.chunk_rest(seq__51957_52879__$1);
var G__52882 = c__4679__auto___52880;
var G__52883 = cljs.core.count(c__4679__auto___52880);
var G__52884 = (0);
seq__51957_52864 = G__52881;
chunk__51959_52865 = G__52882;
count__51960_52866 = G__52883;
i__51961_52867 = G__52884;
continue;
} else {
var child_52885 = cljs.core.first(seq__51957_52879__$1);
if(cljs.core.truth_(child_52885)){
node.appendChild(child_52885);


var G__52888 = cljs.core.next(seq__51957_52879__$1);
var G__52889 = null;
var G__52890 = (0);
var G__52891 = (0);
seq__51957_52864 = G__52888;
chunk__51959_52865 = G__52889;
count__51960_52866 = G__52890;
i__51961_52867 = G__52891;
continue;
} else {
var G__52892 = cljs.core.next(seq__51957_52879__$1);
var G__52893 = null;
var G__52894 = (0);
var G__52895 = (0);
seq__51957_52864 = G__52892;
chunk__51959_52865 = G__52893;
count__51960_52866 = G__52894;
i__51961_52867 = G__52895;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_52863);
}
}


var G__52898 = cljs.core.next(seq__51841_52851__$1);
var G__52899 = null;
var G__52900 = (0);
var G__52901 = (0);
seq__51841_52798 = G__52898;
chunk__51843_52799 = G__52899;
count__51844_52800 = G__52900;
i__51845_52801 = G__52901;
continue;
} else {
var G__52902 = cljs.core.next(seq__51841_52851__$1);
var G__52903 = null;
var G__52904 = (0);
var G__52905 = (0);
seq__51841_52798 = G__52902;
chunk__51843_52799 = G__52903;
count__51844_52800 = G__52904;
i__51845_52801 = G__52905;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___52915 = arguments.length;
var i__4865__auto___52917 = (0);
while(true){
if((i__4865__auto___52917 < len__4864__auto___52915)){
args__4870__auto__.push((arguments[i__4865__auto___52917]));

var G__52918 = (i__4865__auto___52917 + (1));
i__4865__auto___52917 = G__52918;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq52009){
var G__52011 = cljs.core.first(seq52009);
var seq52009__$1 = cljs.core.next(seq52009);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52011,seq52009__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__52032 = arguments.length;
switch (G__52032) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4251__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4251__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4251__auto__;
}
})())){
var c__44855__auto___52932 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44856__auto__ = (function (){var switch__44692__auto__ = (function (state_52071){
var state_val_52072 = (state_52071[(1)]);
if((state_val_52072 === (1))){
var state_52071__$1 = state_52071;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52071__$1,(2),once_or_cleanup);
} else {
if((state_val_52072 === (2))){
var inst_52068 = (state_52071[(2)]);
var inst_52069 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_52071__$1 = (function (){var statearr_52080 = state_52071;
(statearr_52080[(7)] = inst_52068);

return statearr_52080;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_52071__$1,inst_52069);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__44693__auto__ = null;
var shadow$dom$state_machine__44693__auto____0 = (function (){
var statearr_52084 = [null,null,null,null,null,null,null,null];
(statearr_52084[(0)] = shadow$dom$state_machine__44693__auto__);

(statearr_52084[(1)] = (1));

return statearr_52084;
});
var shadow$dom$state_machine__44693__auto____1 = (function (state_52071){
while(true){
var ret_value__44694__auto__ = (function (){try{while(true){
var result__44695__auto__ = switch__44692__auto__(state_52071);
if(cljs.core.keyword_identical_QMARK_(result__44695__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44695__auto__;
}
break;
}
}catch (e52090){var ex__44696__auto__ = e52090;
var statearr_52091_52934 = state_52071;
(statearr_52091_52934[(2)] = ex__44696__auto__);


if(cljs.core.seq((state_52071[(4)]))){
var statearr_52095_52938 = state_52071;
(statearr_52095_52938[(1)] = cljs.core.first((state_52071[(4)])));

} else {
throw ex__44696__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44694__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__52940 = state_52071;
state_52071 = G__52940;
continue;
} else {
return ret_value__44694__auto__;
}
break;
}
});
shadow$dom$state_machine__44693__auto__ = function(state_52071){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__44693__auto____0.call(this);
case 1:
return shadow$dom$state_machine__44693__auto____1.call(this,state_52071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__44693__auto____0;
shadow$dom$state_machine__44693__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__44693__auto____1;
return shadow$dom$state_machine__44693__auto__;
})()
})();
var state__44857__auto__ = (function (){var statearr_52101 = f__44856__auto__();
(statearr_52101[(6)] = c__44855__auto___52932);

return statearr_52101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44857__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
