goog.provide('com.fulcrologic.fulcro.dom');
goog.scope(function(){
  com.fulcrologic.fulcro.dom.goog$module$goog$object = goog.module.get('goog.object');
});
var module$node_modules$react$index=shadow.js.require("module$node_modules$react$index", {});
var module$node_modules$react_dom$index=shadow.js.require("module$node_modules$react_dom$index", {});





































































































































































































/**
 * Returns true if the given arg is a react element.
 */
com.fulcrologic.fulcro.dom.element_QMARK_ = (function com$fulcrologic$fulcro$dom$element_QMARK_(x){
return module$node_modules$react$index.isValidElement(x);
});
com.fulcrologic.fulcro.dom.child__GT_typed_child = (function com$fulcrologic$fulcro$dom$child__GT_typed_child(child){
if(typeof child === 'string'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"string","string",-1989541586),child], null);
} else {
if(typeof child === 'number'){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"number","number",1570378438),child], null);
} else {
if(((cljs.core.vector_QMARK_(child)) || (((cljs.core.seq_QMARK_(child)) || (cljs.core.array_QMARK_(child)))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"collection","collection",-683361892),child], null);
} else {
if((child == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nil","nil",99600501),child], null);
} else {
if(cljs.core.truth_(com.fulcrologic.fulcro.dom.element_QMARK_(child))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"element","element",1974019749),child], null);
} else {
return null;
}
}
}
}
}
});
/**
 * Runtime parsing of DOM tag arguments. Returns a map with keys :css, :attrs, and :children.
 */
com.fulcrologic.fulcro.dom.parse_args = (function com$fulcrologic$fulcro$dom$parse_args(args){
var parse_css = (function com$fulcrologic$fulcro$dom$parse_args_$_parse_css(p__66578){
var vec__66580 = p__66578;
var args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66580,(0),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66580,(1),null);
var pair = vec__66580;
var arg = cljs.core.first(args__$1);
if((arg instanceof cljs.core.Keyword)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.next(args__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"css","css",1135045163),arg)], null);
} else {
return pair;
}
});
var parse_attrs = (function com$fulcrologic$fulcro$dom$parse_args_$_parse_attrs(p__66584){
var vec__66585 = p__66584;
var args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66585,(0),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66585,(1),null);
var pair = vec__66585;
var has_arg_QMARK_ = cljs.core.seq(args__$1);
var arg = cljs.core.first(args__$1);
if(((has_arg_QMARK_) && ((arg == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.next(args__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"nil","nil",99600501),null], null))], null);
} else {
if(((cljs.core.object_QMARK_(arg)) && (cljs.core.not(com.fulcrologic.fulcro.dom.element_QMARK_(arg))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.next(args__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-object","js-object",1830199158),arg], null))], null);
} else {
if(((cljs.core.map_QMARK_(arg)) && (cljs.core.not(com.fulcrologic.fulcro.dom.element_QMARK_(arg))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.next(args__$1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.Keyword(null,"attrs","attrs",-2090668713),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"map","map",1371690461),arg], null))], null);
} else {
return pair;

}
}
}
});
var parse_children = (function com$fulcrologic$fulcro$dom$parse_args_$_parse_children(p__66588){
var vec__66589 = p__66588;
var args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66589,(0),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66589,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,(function (){var G__66592 = result;
if(cljs.core.seq(args__$1)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__66592,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(com.fulcrologic.fulcro.dom.child__GT_typed_child,args__$1));
} else {
return G__66592;
}
})()], null);
});
return cljs.core.second(parse_children(parse_attrs(parse_css(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [args,cljs.core.PersistentArrayMap.EMPTY], null)))));
});
/**
 * Equivalent to React.render
 */
com.fulcrologic.fulcro.dom.render = (function com$fulcrologic$fulcro$dom$render(component,el){
return module$node_modules$react_dom$index.render(component,el);
});
/**
 * Equivalent to React.renderToString. NOTE: You must make sure js/ReactDOMServer is defined (e.g. require cljsjs.react.dom.server) to use this function.
 */
com.fulcrologic.fulcro.dom.render_to_str = (function com$fulcrologic$fulcro$dom$render_to_str(c){
return ReactDOMServer.renderToString(c);
});
/**
 * Returns the dom node associated with a component's React ref.
 */
com.fulcrologic.fulcro.dom.node = (function com$fulcrologic$fulcro$dom$node(var_args){
var G__66595 = arguments.length;
switch (G__66595) {
case 1:
return com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$1 = (function (component){
return module$node_modules$react_dom$index.findDOMNode(component);
}));

(com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$2 = (function (component,name){
var G__66596 = component.refs;
var G__66596__$1 = (((G__66596 == null))?null:com.fulcrologic.fulcro.dom.goog$module$goog$object.get(G__66596,name));
if((G__66596__$1 == null)){
return null;
} else {
return module$node_modules$react_dom$index.findDOMNode(G__66596__$1);
}
}));

(com.fulcrologic.fulcro.dom.node.cljs$lang$maxFixedArity = 2);

/**
 * React component that wraps dom/input to prevent cursor madness.
 */
com.fulcrologic.fulcro.dom.Input = com.fulcrologic.fulcro.dom.inputs.StringBufferedInput(new cljs.core.Keyword("com.fulcrologic.fulcro.dom","Input","com.fulcrologic.fulcro.dom/Input",-2041077839),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"string->model","string->model",-134531957),cljs.core.identity,new cljs.core.Keyword(null,"model->string","model->string",-2085451701),cljs.core.identity], null));
/**
 * A wrapped input. Use this when you see the cursor jump around while you're trying to type in an input. Drop-in replacement
 * for `dom/input`.
 * 
 * NOTE: The onChange and onBlur handlers will receive a string value, not an event. If you want the raw event on changes use onInput.
 */
com.fulcrologic.fulcro.dom.ui_input = (function (){var factory = com.fulcrologic.fulcro.components.factory.cljs$core$IFn$_invoke$arity$2(com.fulcrologic.fulcro.dom.Input,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyfn","keyfn",780060332),new cljs.core.Keyword(null,"key","key",-1516042587)], null));
return (function (props){
var temp__5751__auto__ = new cljs.core.Keyword(null,"ref","ref",1289896967).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(temp__5751__auto__)){
var ref = temp__5751__auto__;
var G__66601 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(props,new cljs.core.Keyword(null,"ref","ref",1289896967),(function (r){
var G__66605 = (function (){var G__66606 = r;
if((G__66606 == null)){
return null;
} else {
return com.fulcrologic.fulcro.dom.node.cljs$core$IFn$_invoke$arity$1(G__66606);
}
})();
return (ref.cljs$core$IFn$_invoke$arity$1 ? ref.cljs$core$IFn$_invoke$arity$1(G__66605) : ref.call(null,G__66605));
}));
return (factory.cljs$core$IFn$_invoke$arity$1 ? factory.cljs$core$IFn$_invoke$arity$1(G__66601) : factory.call(null,G__66601));
} else {
return (factory.cljs$core$IFn$_invoke$arity$1 ? factory.cljs$core$IFn$_invoke$arity$1(props) : factory.call(null,props));
}
});
})();
/**
 * Create a DOM element for which there exists no corresponding function.
 * Useful to create DOM elements not included in React.DOM. Equivalent
 * to calling `js/React.createElement`
 */
com.fulcrologic.fulcro.dom.create_element = (function com$fulcrologic$fulcro$dom$create_element(var_args){
var G__66611 = arguments.length;
switch (G__66611) {
case 1:
return com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4885__auto__ = [];
var len__4864__auto___69692 = arguments.length;
var i__4865__auto___69693 = (0);
while(true){
if((i__4865__auto___69693 < len__4864__auto___69692)){
args_arr__4885__auto__.push((arguments[i__4865__auto___69693]));

var G__69694 = (i__4865__auto___69693 + (1));
i__4865__auto___69693 = G__69694;
continue;
} else {
}
break;
}

var argseq__4886__auto__ = (new cljs.core.IndexedSeq(args_arr__4885__auto__.slice((2)),(0),null));
return com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4886__auto__);

}
});

(com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$1 = (function (tag){
return com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$2(tag,null);
}));

(com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$2 = (function (tag,opts){
return module$node_modules$react$index.createElement(tag,opts);
}));

(com.fulcrologic.fulcro.dom.create_element.cljs$core$IFn$_invoke$arity$variadic = (function (tag,opts,children){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(module$node_modules$react$index.createElement,tag,opts,children);
}));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.create_element.cljs$lang$applyTo = (function (seq66608){
var G__66609 = cljs.core.first(seq66608);
var seq66608__$1 = cljs.core.next(seq66608);
var G__66610 = cljs.core.first(seq66608__$1);
var seq66608__$2 = cljs.core.next(seq66608__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66609,G__66610,seq66608__$2);
}));

(com.fulcrologic.fulcro.dom.create_element.cljs$lang$maxFixedArity = (2));

/**
 * Given props, which can be nil, a js-obj or a clj map: returns a js object.
 */
com.fulcrologic.fulcro.dom.convert_props = (function com$fulcrologic$fulcro$dom$convert_props(props){
if((props == null)){
return ({});
} else {
if(cljs.core.map_QMARK_(props)){
return cljs.core.clj__GT_js(props);
} else {
return props;

}
}
});
/**
 * Used internally by the DOM element generation.
 */
com.fulcrologic.fulcro.dom.macro_create_element_STAR_ = (function com$fulcrologic$fulcro$dom$macro_create_element_STAR_(arr){
if(cljs.core.array_QMARK_(arr)){
} else {
throw (new Error("Assert failed: (array? arr)"));
}

return module$node_modules$react$index.createElement.apply(null,arr);
});
/**
 * Updates the state of the wrapped input element.
 */
com.fulcrologic.fulcro.dom.update_state = (function com$fulcrologic$fulcro$dom$update_state(component,next_props,value){
var on_change = com.fulcrologic.fulcro.dom.goog$module$goog$object.getValueByKeys(component,"state","cached-props","onChange");
var next_state = ({});
var inputRef = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(next_props,"inputRef");
com.fulcrologic.fulcro.dom.goog$module$goog$object.extend(next_state,next_props,({"onChange": on_change}));

com.fulcrologic.fulcro.dom.goog$module$goog$object.set(next_state,"value",value);

if(cljs.core.truth_(inputRef)){
com.fulcrologic.fulcro.dom.goog$module$goog$object.remove(next_state,"inputRef");

com.fulcrologic.fulcro.dom.goog$module$goog$object.set(next_state,"ref",inputRef);
} else {
}

return component.setState(({"cached-props": next_state}));
});
if((typeof com !== 'undefined') && (typeof com.fulcrologic !== 'undefined') && (typeof com.fulcrologic.fulcro !== 'undefined') && (typeof com.fulcrologic.fulcro.dom !== 'undefined') && (typeof com.fulcrologic.fulcro.dom.form_elements_QMARK_ !== 'undefined')){
} else {
com.fulcrologic.fulcro.dom.form_elements_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["option",null,"select",null,"input",null,"textarea",null], null), null);
}
com.fulcrologic.fulcro.dom.is_form_element_QMARK_ = (function com$fulcrologic$fulcro$dom$is_form_element_QMARK_(element){
var tag = element.tagName;
var and__4251__auto__ = tag;
if(cljs.core.truth_(and__4251__auto__)){
var G__66618 = clojure.string.lower_case(tag);
return (com.fulcrologic.fulcro.dom.form_elements_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.dom.form_elements_QMARK_.cljs$core$IFn$_invoke$arity$1(G__66618) : com.fulcrologic.fulcro.dom.form_elements_QMARK_.call(null,G__66618));
} else {
return and__4251__auto__;
}
});
com.fulcrologic.fulcro.dom.wrap_form_element = (function com$fulcrologic$fulcro$dom$wrap_form_element(element){
var ctor = (function (props){
var this$ = this;
(this$.state = (function (){var state = ({"ref": com.fulcrologic.fulcro.dom.goog$module$goog$object.get(props,"inputRef")});
com.fulcrologic.fulcro.dom.goog$module$goog$object.extend(state,props,({"onChange": goog.bind(com.fulcrologic.fulcro.dom.goog$module$goog$object.get(this$,"onChange"),this$)}));

com.fulcrologic.fulcro.dom.goog$module$goog$object.remove(state,"inputRef");

return ({"cached-props": state});
})());

return module$node_modules$react$index.Component.apply(this$,arguments);
});
(ctor.displayName = ["wrapped-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(element)].join(''));

goog.inherits(ctor,module$node_modules$react$index.Component);

var x66631_69706 = ctor.prototype;
(x66631_69706.onChange = (function (event){
var this$ = this;
var temp__5753__auto__ = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(this$.props,"onChange");
if(cljs.core.truth_(temp__5753__auto__)){
var handler = temp__5753__auto__;
(handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(event) : handler.call(null,event));

return com.fulcrologic.fulcro.dom.update_state(this$,this$.props,com.fulcrologic.fulcro.dom.goog$module$goog$object.getValueByKeys(event,"target","value"));
} else {
return null;
}
}));

(x66631_69706.UNSAFE_componentWillReceiveProps = (function (new_props){
var this$ = this;
var state_value = com.fulcrologic.fulcro.dom.goog$module$goog$object.getValueByKeys(this$,"state","cached-props","value");
var this_node = module$node_modules$react_dom$index.findDOMNode(this$);
var value_node = (cljs.core.truth_(com.fulcrologic.fulcro.dom.is_form_element_QMARK_(this_node))?this_node:goog.dom.findNode(this_node,(function (p1__66623_SHARP_){
return com.fulcrologic.fulcro.dom.is_form_element_QMARK_(p1__66623_SHARP_);
})));
var element_value = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(value_node,"value");
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core.truth_((function (){var and__4251__auto__ = state_value;
if(cljs.core.truth_(and__4251__auto__)){
var and__4251__auto____$1 = element_value;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.type(state_value),cljs.core.type(element_value));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"com.fulcrologic.fulcro.dom",null,181,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["There is a mismatch for the data type of the value on an input with value ",element_value,". This will cause the input to miss refreshes. In general you should force the :value of an input to\n                be a string since that is how values are stored on most real DOM elements. See https://book.fulcrologic.com/#warn-dom-type-mismatch"], null);
}),null)),null,-1829411433,null);
} else {
}
} else {
}

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(state_value,element_value)){
return com.fulcrologic.fulcro.dom.update_state(this$,new_props,element_value);
} else {
return com.fulcrologic.fulcro.dom.update_state(this$,new_props,com.fulcrologic.fulcro.dom.goog$module$goog$object.get(new_props,"value"));
}
}));

(x66631_69706.render = (function (){
var this$ = this;
return module$node_modules$react$index.createElement(element,com.fulcrologic.fulcro.dom.goog$module$goog$object.getValueByKeys(this$,"state","cached-props"));
}));


var real_factory = (function() { 
var G__69715__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(module$node_modules$react$index.createElement,ctor,args);
};
var G__69715 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__69716__i = 0, G__69716__a = new Array(arguments.length -  0);
while (G__69716__i < G__69716__a.length) {G__69716__a[G__69716__i] = arguments[G__69716__i + 0]; ++G__69716__i;}
  args = new cljs.core.IndexedSeq(G__69716__a,0,null);
} 
return G__69715__delegate.call(this,args);};
G__69715.cljs$lang$maxFixedArity = 0;
G__69715.cljs$lang$applyTo = (function (arglist__69717){
var args = cljs.core.seq(arglist__69717);
return G__69715__delegate(args);
});
G__69715.cljs$core$IFn$_invoke$arity$variadic = G__69715__delegate;
return G__69715;
})()
;
return (function() { 
var G__69718__delegate = function (props,children){
var t = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(props,"type");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,"file")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(module$node_modules$react$index.createElement,"input",props,children);
} else {
var temp__5751__auto__ = com.fulcrologic.fulcro.dom.goog$module$goog$object.get(props,"ref");
if(cljs.core.truth_(temp__5751__auto__)){
var r = temp__5751__auto__;
if(typeof r === 'string'){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(real_factory,props,children);
} else {
var p = ({});
com.fulcrologic.fulcro.dom.goog$module$goog$object.extend(p,props);

com.fulcrologic.fulcro.dom.goog$module$goog$object.set(p,"inputRef",r);

com.fulcrologic.fulcro.dom.goog$module$goog$object.remove(p,"ref");

return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(real_factory,p,children);
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(real_factory,props,children);
}
}
};
var G__69718 = function (props,var_args){
var children = null;
if (arguments.length > 1) {
var G__69720__i = 0, G__69720__a = new Array(arguments.length -  1);
while (G__69720__i < G__69720__a.length) {G__69720__a[G__69720__i] = arguments[G__69720__i + 1]; ++G__69720__i;}
  children = new cljs.core.IndexedSeq(G__69720__a,0,null);
} 
return G__69718__delegate.call(this,props,children);};
G__69718.cljs$lang$maxFixedArity = 1;
G__69718.cljs$lang$applyTo = (function (arglist__69721){
var props = cljs.core.first(arglist__69721);
var children = cljs.core.rest(arglist__69721);
return G__69718__delegate(props,children);
});
G__69718.cljs$core$IFn$_invoke$arity$variadic = G__69718__delegate;
return G__69718;
})()
;
});
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
com.fulcrologic.fulcro.dom.wrapped_input = com.fulcrologic.fulcro.dom.wrap_form_element("input");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
com.fulcrologic.fulcro.dom.wrapped_textarea = com.fulcrologic.fulcro.dom.wrap_form_element("textarea");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
com.fulcrologic.fulcro.dom.wrapped_option = com.fulcrologic.fulcro.dom.wrap_form_element("option");
/**
 * Low-level form input, with no syntactic sugar. Used internally by DOM macros
 */
com.fulcrologic.fulcro.dom.wrapped_select = com.fulcrologic.fulcro.dom.wrap_form_element("select");
com.fulcrologic.fulcro.dom.arr_append_STAR_ = (function com$fulcrologic$fulcro$dom$arr_append_STAR_(arr,x){
arr.push(x);

return arr;
});
com.fulcrologic.fulcro.dom.arr_append = (function com$fulcrologic$fulcro$dom$arr_append(arr,tail){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.arr_append_STAR_,arr,tail);
});
/**
 * Used internally by element generation.
 */
com.fulcrologic.fulcro.dom.macro_create_wrapped_form_element = (function com$fulcrologic$fulcro$dom$macro_create_wrapped_form_element(opts){
var tag = (opts[(0)]);
var props = (opts[(1)]);
var children = opts.splice((2));
var G__66661 = tag;
switch (G__66661) {
case "input":
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.wrapped_input,props,children);

break;
case "textarea":
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.wrapped_textarea,props,children);

break;
case "select":
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.wrapped_select,props,children);

break;
case "option":
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(com.fulcrologic.fulcro.dom.wrapped_option,props,children);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__66661)].join('')));

}
});
/**
 * Runtime interpretation of props. Used internally by element generation when the macro cannot expand the element at compile time.
 */
com.fulcrologic.fulcro.dom.macro_create_element = (function com$fulcrologic$fulcro$dom$macro_create_element(var_args){
var G__66668 = arguments.length;
switch (G__66668) {
case 2:
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$2 = (function (type,args){
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3(type,args,null);
}));

(com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3 = (function (type,args,csskw){
var vec__66676 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(com.fulcrologic.fulcro.components.force_children,args);
var seq__66677 = cljs.core.seq(vec__66676);
var first__66678 = cljs.core.first(seq__66677);
var seq__66677__$1 = cljs.core.next(seq__66677);
var head = first__66678;
var tail = seq__66677__$1;
var f = (cljs.core.truth_((com.fulcrologic.fulcro.dom.form_elements_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.dom.form_elements_QMARK_.cljs$core$IFn$_invoke$arity$1(type) : com.fulcrologic.fulcro.dom.form_elements_QMARK_.call(null,type)))?com.fulcrologic.fulcro.dom.macro_create_wrapped_form_element:com.fulcrologic.fulcro.dom.macro_create_element_STAR_);
if((head == null)){
var G__66679 = (function (){var G__66680 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66680,tail);

return G__66680;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66679) : f.call(null,G__66679));
} else {
if(cljs.core.truth_(com.fulcrologic.fulcro.dom.element_QMARK_(head))){
var G__66681 = (function (){var G__66682 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66682,args);

return G__66682;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66681) : f.call(null,G__66681));
} else {
if(cljs.core.object_QMARK_(head)){
var G__66683 = (function (){var G__66684 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(head,csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66684,tail);

return G__66684;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66683) : f.call(null,G__66683));
} else {
if(cljs.core.map_QMARK_(head)){
var G__66685 = (function (){var G__66686 = [type,cljs.core.clj__GT_js(com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(com.fulcrologic.fulcro.dom_common.interpret_classes(head),csskw))];
com.fulcrologic.fulcro.dom.arr_append(G__66686,tail);

return G__66686;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66685) : f.call(null,G__66685));
} else {
var G__66687 = (function (){var G__66688 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66688,args);

return G__66688;
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__66687) : f.call(null,G__66687));

}
}
}
}
}));

(com.fulcrologic.fulcro.dom.macro_create_element.cljs$lang$maxFixedArity = 3);

/**
 * Just like macro-create-element, but never wraps form input types.
 */
com.fulcrologic.fulcro.dom.macro_create_unwrapped_element = (function com$fulcrologic$fulcro$dom$macro_create_unwrapped_element(var_args){
var G__66690 = arguments.length;
switch (G__66690) {
case 2:
return com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$core$IFn$_invoke$arity$2 = (function (type,args){
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3(type,args,null);
}));

(com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$core$IFn$_invoke$arity$3 = (function (type,args,csskw){
var vec__66691 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(com.fulcrologic.fulcro.components.force_children,args);
var seq__66692 = cljs.core.seq(vec__66691);
var first__66693 = cljs.core.first(seq__66692);
var seq__66692__$1 = cljs.core.next(seq__66692);
var head = first__66693;
var tail = seq__66692__$1;
if((head == null)){
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66694 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66694,tail);

return G__66694;
})());
} else {
if(cljs.core.truth_(com.fulcrologic.fulcro.dom.element_QMARK_(head))){
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66695 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66695,args);

return G__66695;
})());
} else {
if(cljs.core.object_QMARK_(head)){
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66696 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(head,csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66696,tail);

return G__66696;
})());
} else {
if(cljs.core.map_QMARK_(head)){
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66697 = [type,cljs.core.clj__GT_js(com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(com.fulcrologic.fulcro.dom_common.interpret_classes(head),csskw))];
com.fulcrologic.fulcro.dom.arr_append(G__66697,tail);

return G__66697;
})());
} else {
return com.fulcrologic.fulcro.dom.macro_create_element_STAR_((function (){var G__66698 = [type,com.fulcrologic.fulcro.dom_common.add_kwprops_to_props(({}),csskw)];
com.fulcrologic.fulcro.dom.arr_append(G__66698,args);

return G__66698;
})());

}
}
}
}
}));

(com.fulcrologic.fulcro.dom.macro_create_unwrapped_element.cljs$lang$maxFixedArity = 3);

/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (form "hello")
 * (form nil "hello")
 * 
 * These two are made equivalent at compile time
 * (form {:onClick f} "hello")
 * (form #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (form :#the-id.klass.other-klass "hello")
 * (form :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.form = (function com$fulcrologic$fulcro$dom$form(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69737 = arguments.length;
var i__4865__auto___69738 = (0);
while(true){
if((i__4865__auto___69738 < len__4864__auto___69737)){
args__4870__auto__.push((arguments[i__4865__auto___69738]));

var G__69739 = (i__4865__auto___69738 + (1));
i__4865__auto___69738 = G__69739;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.form.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.form.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66720 = conformed_args__65183__auto__;
var map__66720__$1 = cljs.core.__destructure_map(map__66720);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66720__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66720__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66720__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("form",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.form.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.form.cljs$lang$applyTo = (function (seq66719){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66719));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (audio "hello")
 * (audio nil "hello")
 * 
 * These two are made equivalent at compile time
 * (audio {:onClick f} "hello")
 * (audio #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (audio :#the-id.klass.other-klass "hello")
 * (audio :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.audio = (function com$fulcrologic$fulcro$dom$audio(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69741 = arguments.length;
var i__4865__auto___69743 = (0);
while(true){
if((i__4865__auto___69743 < len__4864__auto___69741)){
args__4870__auto__.push((arguments[i__4865__auto___69743]));

var G__69744 = (i__4865__auto___69743 + (1));
i__4865__auto___69743 = G__69744;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.audio.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.audio.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66732 = conformed_args__65183__auto__;
var map__66732__$1 = cljs.core.__destructure_map(map__66732);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66732__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66732__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66732__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("audio",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.audio.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.audio.cljs$lang$applyTo = (function (seq66724){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66724));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (input "hello")
 * (input nil "hello")
 * 
 * These two are made equivalent at compile time
 * (input {:onClick f} "hello")
 * (input #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (input :#the-id.klass.other-klass "hello")
 * (input :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.input = (function com$fulcrologic$fulcro$dom$input(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69745 = arguments.length;
var i__4865__auto___69746 = (0);
while(true){
if((i__4865__auto___69746 < len__4864__auto___69745)){
args__4870__auto__.push((arguments[i__4865__auto___69746]));

var G__69747 = (i__4865__auto___69746 + (1));
i__4865__auto___69746 = G__69747;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.input.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.input.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66738 = conformed_args__65183__auto__;
var map__66738__$1 = cljs.core.__destructure_map(map__66738);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66738__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66738__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66738__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("input",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.input.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.input.cljs$lang$applyTo = (function (seq66733){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66733));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (menuitem "hello")
 * (menuitem nil "hello")
 * 
 * These two are made equivalent at compile time
 * (menuitem {:onClick f} "hello")
 * (menuitem #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (menuitem :#the-id.klass.other-klass "hello")
 * (menuitem :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.menuitem = (function com$fulcrologic$fulcro$dom$menuitem(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69751 = arguments.length;
var i__4865__auto___69752 = (0);
while(true){
if((i__4865__auto___69752 < len__4864__auto___69751)){
args__4870__auto__.push((arguments[i__4865__auto___69752]));

var G__69754 = (i__4865__auto___69752 + (1));
i__4865__auto___69752 = G__69754;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.menuitem.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66750 = conformed_args__65183__auto__;
var map__66750__$1 = cljs.core.__destructure_map(map__66750);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66750__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66750__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66750__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("menuitem",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.menuitem.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.menuitem.cljs$lang$applyTo = (function (seq66744){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66744));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (radialGradient "hello")
 * (radialGradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (radialGradient {:onClick f} "hello")
 * (radialGradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (radialGradient :#the-id.klass.other-klass "hello")
 * (radialGradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.radialGradient = (function com$fulcrologic$fulcro$dom$radialGradient(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69758 = arguments.length;
var i__4865__auto___69759 = (0);
while(true){
if((i__4865__auto___69759 < len__4864__auto___69758)){
args__4870__auto__.push((arguments[i__4865__auto___69759]));

var G__69763 = (i__4865__auto___69759 + (1));
i__4865__auto___69759 = G__69763;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.radialGradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66762 = conformed_args__65183__auto__;
var map__66762__$1 = cljs.core.__destructure_map(map__66762);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66762__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66762__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66762__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("radialGradient",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.radialGradient.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.radialGradient.cljs$lang$applyTo = (function (seq66756){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66756));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMerge "hello")
 * (feMerge nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMerge {:onClick f} "hello")
 * (feMerge #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMerge :#the-id.klass.other-klass "hello")
 * (feMerge :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feMerge = (function com$fulcrologic$fulcro$dom$feMerge(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69770 = arguments.length;
var i__4865__auto___69771 = (0);
while(true){
if((i__4865__auto___69771 < len__4864__auto___69770)){
args__4870__auto__.push((arguments[i__4865__auto___69771]));

var G__69772 = (i__4865__auto___69771 + (1));
i__4865__auto___69771 = G__69772;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feMerge.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feMerge.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66769 = conformed_args__65183__auto__;
var map__66769__$1 = cljs.core.__destructure_map(map__66769);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66769__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66769__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66769__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feMerge",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feMerge.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feMerge.cljs$lang$applyTo = (function (seq66765){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66765));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (set "hello")
 * (set nil "hello")
 * 
 * These two are made equivalent at compile time
 * (set {:onClick f} "hello")
 * (set #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (set :#the-id.klass.other-klass "hello")
 * (set :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.set = (function com$fulcrologic$fulcro$dom$set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69774 = arguments.length;
var i__4865__auto___69775 = (0);
while(true){
if((i__4865__auto___69775 < len__4864__auto___69774)){
args__4870__auto__.push((arguments[i__4865__auto___69775]));

var G__69776 = (i__4865__auto___69775 + (1));
i__4865__auto___69775 = G__69776;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66775 = conformed_args__65183__auto__;
var map__66775__$1 = cljs.core.__destructure_map(map__66775);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66775__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66775__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66775__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("set",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.set.cljs$lang$applyTo = (function (seq66772){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66772));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feSpecularLighting "hello")
 * (feSpecularLighting nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feSpecularLighting {:onClick f} "hello")
 * (feSpecularLighting #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feSpecularLighting :#the-id.klass.other-klass "hello")
 * (feSpecularLighting :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feSpecularLighting = (function com$fulcrologic$fulcro$dom$feSpecularLighting(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69781 = arguments.length;
var i__4865__auto___69782 = (0);
while(true){
if((i__4865__auto___69782 < len__4864__auto___69781)){
args__4870__auto__.push((arguments[i__4865__auto___69782]));

var G__69784 = (i__4865__auto___69782 + (1));
i__4865__auto___69782 = G__69784;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feSpecularLighting.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feSpecularLighting.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66779 = conformed_args__65183__auto__;
var map__66779__$1 = cljs.core.__destructure_map(map__66779);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66779__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66779__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66779__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feSpecularLighting",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feSpecularLighting.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feSpecularLighting.cljs$lang$applyTo = (function (seq66777){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66777));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (base "hello")
 * (base nil "hello")
 * 
 * These two are made equivalent at compile time
 * (base {:onClick f} "hello")
 * (base #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (base :#the-id.klass.other-klass "hello")
 * (base :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.base = (function com$fulcrologic$fulcro$dom$base(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69788 = arguments.length;
var i__4865__auto___69789 = (0);
while(true){
if((i__4865__auto___69789 < len__4864__auto___69788)){
args__4870__auto__.push((arguments[i__4865__auto___69789]));

var G__69790 = (i__4865__auto___69789 + (1));
i__4865__auto___69789 = G__69790;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.base.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.base.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66795 = conformed_args__65183__auto__;
var map__66795__$1 = cljs.core.__destructure_map(map__66795);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66795__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66795__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66795__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("base",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.base.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.base.cljs$lang$applyTo = (function (seq66788){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66788));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h1 "hello")
 * (h1 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h1 {:onClick f} "hello")
 * (h1 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h1 :#the-id.klass.other-klass "hello")
 * (h1 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h1 = (function com$fulcrologic$fulcro$dom$h1(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69799 = arguments.length;
var i__4865__auto___69800 = (0);
while(true){
if((i__4865__auto___69800 < len__4864__auto___69799)){
args__4870__auto__.push((arguments[i__4865__auto___69800]));

var G__69801 = (i__4865__auto___69800 + (1));
i__4865__auto___69800 = G__69801;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h1.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h1.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66802 = conformed_args__65183__auto__;
var map__66802__$1 = cljs.core.__destructure_map(map__66802);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66802__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66802__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66802__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h1",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.h1.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h1.cljs$lang$applyTo = (function (seq66799){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66799));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feOffset "hello")
 * (feOffset nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feOffset {:onClick f} "hello")
 * (feOffset #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feOffset :#the-id.klass.other-klass "hello")
 * (feOffset :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feOffset = (function com$fulcrologic$fulcro$dom$feOffset(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69802 = arguments.length;
var i__4865__auto___69803 = (0);
while(true){
if((i__4865__auto___69803 < len__4864__auto___69802)){
args__4870__auto__.push((arguments[i__4865__auto___69803]));

var G__69805 = (i__4865__auto___69803 + (1));
i__4865__auto___69803 = G__69805;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feOffset.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feOffset.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66805 = conformed_args__65183__auto__;
var map__66805__$1 = cljs.core.__destructure_map(map__66805);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66805__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66805__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66805__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feOffset",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feOffset.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feOffset.cljs$lang$applyTo = (function (seq66803){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66803));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (embed "hello")
 * (embed nil "hello")
 * 
 * These two are made equivalent at compile time
 * (embed {:onClick f} "hello")
 * (embed #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (embed :#the-id.klass.other-klass "hello")
 * (embed :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.embed = (function com$fulcrologic$fulcro$dom$embed(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69807 = arguments.length;
var i__4865__auto___69808 = (0);
while(true){
if((i__4865__auto___69808 < len__4864__auto___69807)){
args__4870__auto__.push((arguments[i__4865__auto___69808]));

var G__69810 = (i__4865__auto___69808 + (1));
i__4865__auto___69808 = G__69810;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.embed.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.embed.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66824 = conformed_args__65183__auto__;
var map__66824__$1 = cljs.core.__destructure_map(map__66824);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66824__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66824__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66824__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("embed",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.embed.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.embed.cljs$lang$applyTo = (function (seq66812){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66812));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateMotion "hello")
 * (animateMotion nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateMotion {:onClick f} "hello")
 * (animateMotion #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateMotion :#the-id.klass.other-klass "hello")
 * (animateMotion :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.animateMotion = (function com$fulcrologic$fulcro$dom$animateMotion(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69817 = arguments.length;
var i__4865__auto___69818 = (0);
while(true){
if((i__4865__auto___69818 < len__4864__auto___69817)){
args__4870__auto__.push((arguments[i__4865__auto___69818]));

var G__69819 = (i__4865__auto___69818 + (1));
i__4865__auto___69818 = G__69819;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.animateMotion.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.animateMotion.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66833 = conformed_args__65183__auto__;
var map__66833__$1 = cljs.core.__destructure_map(map__66833);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66833__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66833__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66833__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("animateMotion",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.animateMotion.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.animateMotion.cljs$lang$applyTo = (function (seq66826){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66826));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h3 "hello")
 * (h3 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h3 {:onClick f} "hello")
 * (h3 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h3 :#the-id.klass.other-klass "hello")
 * (h3 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h3 = (function com$fulcrologic$fulcro$dom$h3(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69821 = arguments.length;
var i__4865__auto___69822 = (0);
while(true){
if((i__4865__auto___69822 < len__4864__auto___69821)){
args__4870__auto__.push((arguments[i__4865__auto___69822]));

var G__69823 = (i__4865__auto___69822 + (1));
i__4865__auto___69822 = G__69823;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h3.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h3.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66849 = conformed_args__65183__auto__;
var map__66849__$1 = cljs.core.__destructure_map(map__66849);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66849__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66849__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66849__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h3",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.h3.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h3.cljs$lang$applyTo = (function (seq66842){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66842));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (body "hello")
 * (body nil "hello")
 * 
 * These two are made equivalent at compile time
 * (body {:onClick f} "hello")
 * (body #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (body :#the-id.klass.other-klass "hello")
 * (body :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.body = (function com$fulcrologic$fulcro$dom$body(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69825 = arguments.length;
var i__4865__auto___69826 = (0);
while(true){
if((i__4865__auto___69826 < len__4864__auto___69825)){
args__4870__auto__.push((arguments[i__4865__auto___69826]));

var G__69827 = (i__4865__auto___69826 + (1));
i__4865__auto___69826 = G__69827;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.body.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.body.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66864 = conformed_args__65183__auto__;
var map__66864__$1 = cljs.core.__destructure_map(map__66864);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66864__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66864__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66864__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("body",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.body.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.body.cljs$lang$applyTo = (function (seq66854){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66854));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hkern "hello")
 * (hkern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hkern {:onClick f} "hello")
 * (hkern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hkern :#the-id.klass.other-klass "hello")
 * (hkern :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.hkern = (function com$fulcrologic$fulcro$dom$hkern(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69830 = arguments.length;
var i__4865__auto___69831 = (0);
while(true){
if((i__4865__auto___69831 < len__4864__auto___69830)){
args__4870__auto__.push((arguments[i__4865__auto___69831]));

var G__69832 = (i__4865__auto___69831 + (1));
i__4865__auto___69831 = G__69832;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.hkern.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.hkern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66877 = conformed_args__65183__auto__;
var map__66877__$1 = cljs.core.__destructure_map(map__66877);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66877__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66877__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66877__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("hkern",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.hkern.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.hkern.cljs$lang$applyTo = (function (seq66868){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66868));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (keygen "hello")
 * (keygen nil "hello")
 * 
 * These two are made equivalent at compile time
 * (keygen {:onClick f} "hello")
 * (keygen #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (keygen :#the-id.klass.other-klass "hello")
 * (keygen :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.keygen = (function com$fulcrologic$fulcro$dom$keygen(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69835 = arguments.length;
var i__4865__auto___69836 = (0);
while(true){
if((i__4865__auto___69836 < len__4864__auto___69835)){
args__4870__auto__.push((arguments[i__4865__auto___69836]));

var G__69838 = (i__4865__auto___69836 + (1));
i__4865__auto___69836 = G__69838;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.keygen.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.keygen.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66888 = conformed_args__65183__auto__;
var map__66888__$1 = cljs.core.__destructure_map(map__66888);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66888__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66888__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66888__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("keygen",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.keygen.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.keygen.cljs$lang$applyTo = (function (seq66884){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66884));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-format "hello")
 * (font-face-format nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-format {:onClick f} "hello")
 * (font-face-format #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-format :#the-id.klass.other-klass "hello")
 * (font-face-format :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face_format = (function com$fulcrologic$fulcro$dom$font_face_format(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69840 = arguments.length;
var i__4865__auto___69841 = (0);
while(true){
if((i__4865__auto___69841 < len__4864__auto___69840)){
args__4870__auto__.push((arguments[i__4865__auto___69841]));

var G__69842 = (i__4865__auto___69841 + (1));
i__4865__auto___69841 = G__69842;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face_format.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face_format.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66917 = conformed_args__65183__auto__;
var map__66917__$1 = cljs.core.__destructure_map(map__66917);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66917__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66917__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66917__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face-format",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face_format.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face_format.cljs$lang$applyTo = (function (seq66902){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66902));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncA "hello")
 * (feFuncA nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncA {:onClick f} "hello")
 * (feFuncA #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncA :#the-id.klass.other-klass "hello")
 * (feFuncA :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFuncA = (function com$fulcrologic$fulcro$dom$feFuncA(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69844 = arguments.length;
var i__4865__auto___69845 = (0);
while(true){
if((i__4865__auto___69845 < len__4864__auto___69844)){
args__4870__auto__.push((arguments[i__4865__auto___69845]));

var G__69846 = (i__4865__auto___69845 + (1));
i__4865__auto___69845 = G__69846;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFuncA.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFuncA.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66931 = conformed_args__65183__auto__;
var map__66931__$1 = cljs.core.__destructure_map(map__66931);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66931__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66931__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66931__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFuncA",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feFuncA.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFuncA.cljs$lang$applyTo = (function (seq66922){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66922));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (progress "hello")
 * (progress nil "hello")
 * 
 * These two are made equivalent at compile time
 * (progress {:onClick f} "hello")
 * (progress #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (progress :#the-id.klass.other-klass "hello")
 * (progress :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.progress = (function com$fulcrologic$fulcro$dom$progress(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69848 = arguments.length;
var i__4865__auto___69849 = (0);
while(true){
if((i__4865__auto___69849 < len__4864__auto___69848)){
args__4870__auto__.push((arguments[i__4865__auto___69849]));

var G__69850 = (i__4865__auto___69849 + (1));
i__4865__auto___69849 = G__69850;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.progress.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.progress.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66959 = conformed_args__65183__auto__;
var map__66959__$1 = cljs.core.__destructure_map(map__66959);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66959__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66959__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66959__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("progress",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.progress.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.progress.cljs$lang$applyTo = (function (seq66947){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66947));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (main "hello")
 * (main nil "hello")
 * 
 * These two are made equivalent at compile time
 * (main {:onClick f} "hello")
 * (main #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (main :#the-id.klass.other-klass "hello")
 * (main :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.main = (function com$fulcrologic$fulcro$dom$main(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69853 = arguments.length;
var i__4865__auto___69854 = (0);
while(true){
if((i__4865__auto___69854 < len__4864__auto___69853)){
args__4870__auto__.push((arguments[i__4865__auto___69854]));

var G__69855 = (i__4865__auto___69854 + (1));
i__4865__auto___69854 = G__69855;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.main.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.main.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__66994 = conformed_args__65183__auto__;
var map__66994__$1 = cljs.core.__destructure_map(map__66994);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66994__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66994__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66994__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("main",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.main.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.main.cljs$lang$applyTo = (function (seq66976){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66976));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (cite "hello")
 * (cite nil "hello")
 * 
 * These two are made equivalent at compile time
 * (cite {:onClick f} "hello")
 * (cite #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (cite :#the-id.klass.other-klass "hello")
 * (cite :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.cite = (function com$fulcrologic$fulcro$dom$cite(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69858 = arguments.length;
var i__4865__auto___69859 = (0);
while(true){
if((i__4865__auto___69859 < len__4864__auto___69858)){
args__4870__auto__.push((arguments[i__4865__auto___69859]));

var G__69860 = (i__4865__auto___69859 + (1));
i__4865__auto___69859 = G__69860;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.cite.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.cite.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67017 = conformed_args__65183__auto__;
var map__67017__$1 = cljs.core.__destructure_map(map__67017);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67017__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67017__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67017__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("cite",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.cite.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.cite.cljs$lang$applyTo = (function (seq67004){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67004));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rect "hello")
 * (rect nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rect {:onClick f} "hello")
 * (rect #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rect :#the-id.klass.other-klass "hello")
 * (rect :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.rect = (function com$fulcrologic$fulcro$dom$rect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69863 = arguments.length;
var i__4865__auto___69864 = (0);
while(true){
if((i__4865__auto___69864 < len__4864__auto___69863)){
args__4870__auto__.push((arguments[i__4865__auto___69864]));

var G__69865 = (i__4865__auto___69864 + (1));
i__4865__auto___69864 = G__69865;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.rect.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.rect.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67042 = conformed_args__65183__auto__;
var map__67042__$1 = cljs.core.__destructure_map(map__67042);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67042__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67042__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67042__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("rect",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.rect.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.rect.cljs$lang$applyTo = (function (seq67029){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67029));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tref "hello")
 * (tref nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tref {:onClick f} "hello")
 * (tref #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tref :#the-id.klass.other-klass "hello")
 * (tref :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tref = (function com$fulcrologic$fulcro$dom$tref(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69873 = arguments.length;
var i__4865__auto___69874 = (0);
while(true){
if((i__4865__auto___69874 < len__4864__auto___69873)){
args__4870__auto__.push((arguments[i__4865__auto___69874]));

var G__69876 = (i__4865__auto___69874 + (1));
i__4865__auto___69874 = G__69876;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tref.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tref.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67056 = conformed_args__65183__auto__;
var map__67056__$1 = cljs.core.__destructure_map(map__67056);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67056__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67056__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67056__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tref",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.tref.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tref.cljs$lang$applyTo = (function (seq67049){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67049));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshpatch "hello")
 * (meshpatch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshpatch {:onClick f} "hello")
 * (meshpatch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshpatch :#the-id.klass.other-klass "hello")
 * (meshpatch :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meshpatch = (function com$fulcrologic$fulcro$dom$meshpatch(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69879 = arguments.length;
var i__4865__auto___69880 = (0);
while(true){
if((i__4865__auto___69880 < len__4864__auto___69879)){
args__4870__auto__.push((arguments[i__4865__auto___69880]));

var G__69881 = (i__4865__auto___69880 + (1));
i__4865__auto___69880 = G__69881;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meshpatch.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meshpatch.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67076 = conformed_args__65183__auto__;
var map__67076__$1 = cljs.core.__destructure_map(map__67076);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67076__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67076__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67076__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meshpatch",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.meshpatch.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meshpatch.cljs$lang$applyTo = (function (seq67065){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67065));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (polyline "hello")
 * (polyline nil "hello")
 * 
 * These two are made equivalent at compile time
 * (polyline {:onClick f} "hello")
 * (polyline #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (polyline :#the-id.klass.other-klass "hello")
 * (polyline :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.polyline = (function com$fulcrologic$fulcro$dom$polyline(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69890 = arguments.length;
var i__4865__auto___69891 = (0);
while(true){
if((i__4865__auto___69891 < len__4864__auto___69890)){
args__4870__auto__.push((arguments[i__4865__auto___69891]));

var G__69892 = (i__4865__auto___69891 + (1));
i__4865__auto___69891 = G__69892;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.polyline.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.polyline.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67089 = conformed_args__65183__auto__;
var map__67089__$1 = cljs.core.__destructure_map(map__67089);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67089__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67089__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67089__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("polyline",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.polyline.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.polyline.cljs$lang$applyTo = (function (seq67086){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67086));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (metadata "hello")
 * (metadata nil "hello")
 * 
 * These two are made equivalent at compile time
 * (metadata {:onClick f} "hello")
 * (metadata #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (metadata :#the-id.klass.other-klass "hello")
 * (metadata :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.metadata = (function com$fulcrologic$fulcro$dom$metadata(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69893 = arguments.length;
var i__4865__auto___69894 = (0);
while(true){
if((i__4865__auto___69894 < len__4864__auto___69893)){
args__4870__auto__.push((arguments[i__4865__auto___69894]));

var G__69895 = (i__4865__auto___69894 + (1));
i__4865__auto___69894 = G__69895;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.metadata.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.metadata.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67107 = conformed_args__65183__auto__;
var map__67107__$1 = cljs.core.__destructure_map(map__67107);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67107__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67107__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67107__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("metadata",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.metadata.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.metadata.cljs$lang$applyTo = (function (seq67104){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67104));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (map "hello")
 * (map nil "hello")
 * 
 * These two are made equivalent at compile time
 * (map {:onClick f} "hello")
 * (map #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (map :#the-id.klass.other-klass "hello")
 * (map :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.map = (function com$fulcrologic$fulcro$dom$map(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69898 = arguments.length;
var i__4865__auto___69899 = (0);
while(true){
if((i__4865__auto___69899 < len__4864__auto___69898)){
args__4870__auto__.push((arguments[i__4865__auto___69899]));

var G__69900 = (i__4865__auto___69899 + (1));
i__4865__auto___69899 = G__69900;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.map.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.map.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67130 = conformed_args__65183__auto__;
var map__67130__$1 = cljs.core.__destructure_map(map__67130);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67130__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67130__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67130__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("map",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.map.cljs$lang$applyTo = (function (seq67116){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67116));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (object "hello")
 * (object nil "hello")
 * 
 * These two are made equivalent at compile time
 * (object {:onClick f} "hello")
 * (object #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (object :#the-id.klass.other-klass "hello")
 * (object :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.object = (function com$fulcrologic$fulcro$dom$object(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69905 = arguments.length;
var i__4865__auto___69906 = (0);
while(true){
if((i__4865__auto___69906 < len__4864__auto___69905)){
args__4870__auto__.push((arguments[i__4865__auto___69906]));

var G__69907 = (i__4865__auto___69906 + (1));
i__4865__auto___69906 = G__69907;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.object.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.object.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67144 = conformed_args__65183__auto__;
var map__67144__$1 = cljs.core.__destructure_map(map__67144);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67144__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67144__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67144__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("object",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.object.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.object.cljs$lang$applyTo = (function (seq67133){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67133));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (i "hello")
 * (i nil "hello")
 * 
 * These two are made equivalent at compile time
 * (i {:onClick f} "hello")
 * (i #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (i :#the-id.klass.other-klass "hello")
 * (i :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.i = (function com$fulcrologic$fulcro$dom$i(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69912 = arguments.length;
var i__4865__auto___69913 = (0);
while(true){
if((i__4865__auto___69913 < len__4864__auto___69912)){
args__4870__auto__.push((arguments[i__4865__auto___69913]));

var G__69914 = (i__4865__auto___69913 + (1));
i__4865__auto___69913 = G__69914;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.i.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.i.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67158 = conformed_args__65183__auto__;
var map__67158__$1 = cljs.core.__destructure_map(map__67158);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67158__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67158__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67158__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("i",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.i.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.i.cljs$lang$applyTo = (function (seq67151){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67151));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-name "hello")
 * (font-face-name nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-name {:onClick f} "hello")
 * (font-face-name #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-name :#the-id.klass.other-klass "hello")
 * (font-face-name :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face_name = (function com$fulcrologic$fulcro$dom$font_face_name(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69916 = arguments.length;
var i__4865__auto___69917 = (0);
while(true){
if((i__4865__auto___69917 < len__4864__auto___69916)){
args__4870__auto__.push((arguments[i__4865__auto___69917]));

var G__69918 = (i__4865__auto___69917 + (1));
i__4865__auto___69917 = G__69918;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face_name.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face_name.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67176 = conformed_args__65183__auto__;
var map__67176__$1 = cljs.core.__destructure_map(map__67176);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67176__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67176__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67176__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face-name",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face_name.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face_name.cljs$lang$applyTo = (function (seq67164){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67164));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (p "hello")
 * (p nil "hello")
 * 
 * These two are made equivalent at compile time
 * (p {:onClick f} "hello")
 * (p #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (p :#the-id.klass.other-klass "hello")
 * (p :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.p = (function com$fulcrologic$fulcro$dom$p(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69921 = arguments.length;
var i__4865__auto___69923 = (0);
while(true){
if((i__4865__auto___69923 < len__4864__auto___69921)){
args__4870__auto__.push((arguments[i__4865__auto___69923]));

var G__69924 = (i__4865__auto___69923 + (1));
i__4865__auto___69923 = G__69924;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.p.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.p.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67192 = conformed_args__65183__auto__;
var map__67192__$1 = cljs.core.__destructure_map(map__67192);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67192__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67192__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67192__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("p",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.p.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.p.cljs$lang$applyTo = (function (seq67184){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67184));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncR "hello")
 * (feFuncR nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncR {:onClick f} "hello")
 * (feFuncR #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncR :#the-id.klass.other-klass "hello")
 * (feFuncR :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFuncR = (function com$fulcrologic$fulcro$dom$feFuncR(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69926 = arguments.length;
var i__4865__auto___69927 = (0);
while(true){
if((i__4865__auto___69927 < len__4864__auto___69926)){
args__4870__auto__.push((arguments[i__4865__auto___69927]));

var G__69928 = (i__4865__auto___69927 + (1));
i__4865__auto___69927 = G__69928;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFuncR.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFuncR.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67209 = conformed_args__65183__auto__;
var map__67209__$1 = cljs.core.__destructure_map(map__67209);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67209__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67209__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67209__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFuncR",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feFuncR.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFuncR.cljs$lang$applyTo = (function (seq67200){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67200));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hatchpath "hello")
 * (hatchpath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hatchpath {:onClick f} "hello")
 * (hatchpath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hatchpath :#the-id.klass.other-klass "hello")
 * (hatchpath :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.hatchpath = (function com$fulcrologic$fulcro$dom$hatchpath(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69930 = arguments.length;
var i__4865__auto___69931 = (0);
while(true){
if((i__4865__auto___69931 < len__4864__auto___69930)){
args__4870__auto__.push((arguments[i__4865__auto___69931]));

var G__69932 = (i__4865__auto___69931 + (1));
i__4865__auto___69931 = G__69932;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.hatchpath.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.hatchpath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67222 = conformed_args__65183__auto__;
var map__67222__$1 = cljs.core.__destructure_map(map__67222);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67222__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67222__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67222__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("hatchpath",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.hatchpath.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.hatchpath.cljs$lang$applyTo = (function (seq67217){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67217));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyphItem "hello")
 * (altGlyphItem nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyphItem {:onClick f} "hello")
 * (altGlyphItem #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyphItem :#the-id.klass.other-klass "hello")
 * (altGlyphItem :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.altGlyphItem = (function com$fulcrologic$fulcro$dom$altGlyphItem(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69937 = arguments.length;
var i__4865__auto___69938 = (0);
while(true){
if((i__4865__auto___69938 < len__4864__auto___69937)){
args__4870__auto__.push((arguments[i__4865__auto___69938]));

var G__69939 = (i__4865__auto___69938 + (1));
i__4865__auto___69938 = G__69939;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.altGlyphItem.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.altGlyphItem.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67240 = conformed_args__65183__auto__;
var map__67240__$1 = cljs.core.__destructure_map(map__67240);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67240__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67240__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67240__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("altGlyphItem",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.altGlyphItem.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.altGlyphItem.cljs$lang$applyTo = (function (seq67231){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67231));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (nav "hello")
 * (nav nil "hello")
 * 
 * These two are made equivalent at compile time
 * (nav {:onClick f} "hello")
 * (nav #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (nav :#the-id.klass.other-klass "hello")
 * (nav :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.nav = (function com$fulcrologic$fulcro$dom$nav(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69941 = arguments.length;
var i__4865__auto___69942 = (0);
while(true){
if((i__4865__auto___69942 < len__4864__auto___69941)){
args__4870__auto__.push((arguments[i__4865__auto___69942]));

var G__69944 = (i__4865__auto___69942 + (1));
i__4865__auto___69942 = G__69944;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.nav.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.nav.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67263 = conformed_args__65183__auto__;
var map__67263__$1 = cljs.core.__destructure_map(map__67263);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67263__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67263__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67263__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("nav",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.nav.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.nav.cljs$lang$applyTo = (function (seq67257){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67257));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ruby "hello")
 * (ruby nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ruby {:onClick f} "hello")
 * (ruby #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ruby :#the-id.klass.other-klass "hello")
 * (ruby :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ruby = (function com$fulcrologic$fulcro$dom$ruby(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69946 = arguments.length;
var i__4865__auto___69947 = (0);
while(true){
if((i__4865__auto___69947 < len__4864__auto___69946)){
args__4870__auto__.push((arguments[i__4865__auto___69947]));

var G__69948 = (i__4865__auto___69947 + (1));
i__4865__auto___69947 = G__69948;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ruby.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ruby.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67273 = conformed_args__65183__auto__;
var map__67273__$1 = cljs.core.__destructure_map(map__67273);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67273__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67273__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67273__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ruby",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.ruby.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ruby.cljs$lang$applyTo = (function (seq67267){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67267));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (switch "hello")
 * (switch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (switch {:onClick f} "hello")
 * (switch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (switch :#the-id.klass.other-klass "hello")
 * (switch :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.switch$ = (function com$fulcrologic$fulcro$dom$switch(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69949 = arguments.length;
var i__4865__auto___69950 = (0);
while(true){
if((i__4865__auto___69950 < len__4864__auto___69949)){
args__4870__auto__.push((arguments[i__4865__auto___69950]));

var G__69951 = (i__4865__auto___69950 + (1));
i__4865__auto___69950 = G__69951;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.switch$.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.switch$.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67287 = conformed_args__65183__auto__;
var map__67287__$1 = cljs.core.__destructure_map(map__67287);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67287__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67287__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67287__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("switch",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.switch$.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.switch$.cljs$lang$applyTo = (function (seq67281){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67281));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (a "hello")
 * (a nil "hello")
 * 
 * These two are made equivalent at compile time
 * (a {:onClick f} "hello")
 * (a #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (a :#the-id.klass.other-klass "hello")
 * (a :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.a = (function com$fulcrologic$fulcro$dom$a(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69953 = arguments.length;
var i__4865__auto___69954 = (0);
while(true){
if((i__4865__auto___69954 < len__4864__auto___69953)){
args__4870__auto__.push((arguments[i__4865__auto___69954]));

var G__69955 = (i__4865__auto___69954 + (1));
i__4865__auto___69954 = G__69955;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.a.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.a.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67296 = conformed_args__65183__auto__;
var map__67296__$1 = cljs.core.__destructure_map(map__67296);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67296__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67296__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67296__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("a",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.a.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.a.cljs$lang$applyTo = (function (seq67293){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67293));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (view "hello")
 * (view nil "hello")
 * 
 * These two are made equivalent at compile time
 * (view {:onClick f} "hello")
 * (view #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (view :#the-id.klass.other-klass "hello")
 * (view :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.view = (function com$fulcrologic$fulcro$dom$view(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69960 = arguments.length;
var i__4865__auto___69961 = (0);
while(true){
if((i__4865__auto___69961 < len__4864__auto___69960)){
args__4870__auto__.push((arguments[i__4865__auto___69961]));

var G__69962 = (i__4865__auto___69961 + (1));
i__4865__auto___69961 = G__69962;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.view.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.view.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67307 = conformed_args__65183__auto__;
var map__67307__$1 = cljs.core.__destructure_map(map__67307);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67307__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67307__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67307__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("view",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.view.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.view.cljs$lang$applyTo = (function (seq67299){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67299));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (menu "hello")
 * (menu nil "hello")
 * 
 * These two are made equivalent at compile time
 * (menu {:onClick f} "hello")
 * (menu #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (menu :#the-id.klass.other-klass "hello")
 * (menu :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.menu = (function com$fulcrologic$fulcro$dom$menu(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69968 = arguments.length;
var i__4865__auto___69969 = (0);
while(true){
if((i__4865__auto___69969 < len__4864__auto___69968)){
args__4870__auto__.push((arguments[i__4865__auto___69969]));

var G__69976 = (i__4865__auto___69969 + (1));
i__4865__auto___69969 = G__69976;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.menu.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.menu.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67314 = conformed_args__65183__auto__;
var map__67314__$1 = cljs.core.__destructure_map(map__67314);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67314__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67314__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67314__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("menu",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.menu.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.menu.cljs$lang$applyTo = (function (seq67311){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67311));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (blockquote "hello")
 * (blockquote nil "hello")
 * 
 * These two are made equivalent at compile time
 * (blockquote {:onClick f} "hello")
 * (blockquote #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (blockquote :#the-id.klass.other-klass "hello")
 * (blockquote :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.blockquote = (function com$fulcrologic$fulcro$dom$blockquote(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69980 = arguments.length;
var i__4865__auto___69982 = (0);
while(true){
if((i__4865__auto___69982 < len__4864__auto___69980)){
args__4870__auto__.push((arguments[i__4865__auto___69982]));

var G__69984 = (i__4865__auto___69982 + (1));
i__4865__auto___69982 = G__69984;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.blockquote.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67329 = conformed_args__65183__auto__;
var map__67329__$1 = cljs.core.__destructure_map(map__67329);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67329__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67329__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67329__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("blockquote",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.blockquote.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.blockquote.cljs$lang$applyTo = (function (seq67326){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67326));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (img "hello")
 * (img nil "hello")
 * 
 * These two are made equivalent at compile time
 * (img {:onClick f} "hello")
 * (img #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (img :#the-id.klass.other-klass "hello")
 * (img :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.img = (function com$fulcrologic$fulcro$dom$img(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69986 = arguments.length;
var i__4865__auto___69987 = (0);
while(true){
if((i__4865__auto___69987 < len__4864__auto___69986)){
args__4870__auto__.push((arguments[i__4865__auto___69987]));

var G__69988 = (i__4865__auto___69987 + (1));
i__4865__auto___69987 = G__69988;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.img.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.img.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67341 = conformed_args__65183__auto__;
var map__67341__$1 = cljs.core.__destructure_map(map__67341);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67341__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67341__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67341__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("img",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.img.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.img.cljs$lang$applyTo = (function (seq67338){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67338));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncG "hello")
 * (feFuncG nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncG {:onClick f} "hello")
 * (feFuncG #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncG :#the-id.klass.other-klass "hello")
 * (feFuncG :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFuncG = (function com$fulcrologic$fulcro$dom$feFuncG(var_args){
var args__4870__auto__ = [];
var len__4864__auto___69996 = arguments.length;
var i__4865__auto___69997 = (0);
while(true){
if((i__4865__auto___69997 < len__4864__auto___69996)){
args__4870__auto__.push((arguments[i__4865__auto___69997]));

var G__70000 = (i__4865__auto___69997 + (1));
i__4865__auto___69997 = G__70000;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFuncG.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFuncG.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67355 = conformed_args__65183__auto__;
var map__67355__$1 = cljs.core.__destructure_map(map__67355);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67355__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67355__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67355__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFuncG",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feFuncG.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFuncG.cljs$lang$applyTo = (function (seq67347){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67347));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (text "hello")
 * (text nil "hello")
 * 
 * These two are made equivalent at compile time
 * (text {:onClick f} "hello")
 * (text #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (text :#the-id.klass.other-klass "hello")
 * (text :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.text = (function com$fulcrologic$fulcro$dom$text(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70008 = arguments.length;
var i__4865__auto___70009 = (0);
while(true){
if((i__4865__auto___70009 < len__4864__auto___70008)){
args__4870__auto__.push((arguments[i__4865__auto___70009]));

var G__70010 = (i__4865__auto___70009 + (1));
i__4865__auto___70009 = G__70010;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.text.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.text.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67371 = conformed_args__65183__auto__;
var map__67371__$1 = cljs.core.__destructure_map(map__67371);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67371__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67371__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67371__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("text",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.text.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.text.cljs$lang$applyTo = (function (seq67365){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67365));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (span "hello")
 * (span nil "hello")
 * 
 * These two are made equivalent at compile time
 * (span {:onClick f} "hello")
 * (span #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (span :#the-id.klass.other-klass "hello")
 * (span :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.span = (function com$fulcrologic$fulcro$dom$span(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70031 = arguments.length;
var i__4865__auto___70033 = (0);
while(true){
if((i__4865__auto___70033 < len__4864__auto___70031)){
args__4870__auto__.push((arguments[i__4865__auto___70033]));

var G__70035 = (i__4865__auto___70033 + (1));
i__4865__auto___70033 = G__70035;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.span.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.span.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67393 = conformed_args__65183__auto__;
var map__67393__$1 = cljs.core.__destructure_map(map__67393);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67393__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67393__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67393__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("span",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.span.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.span.cljs$lang$applyTo = (function (seq67384){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67384));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (track "hello")
 * (track nil "hello")
 * 
 * These two are made equivalent at compile time
 * (track {:onClick f} "hello")
 * (track #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (track :#the-id.klass.other-klass "hello")
 * (track :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.track = (function com$fulcrologic$fulcro$dom$track(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70040 = arguments.length;
var i__4865__auto___70041 = (0);
while(true){
if((i__4865__auto___70041 < len__4864__auto___70040)){
args__4870__auto__.push((arguments[i__4865__auto___70041]));

var G__70042 = (i__4865__auto___70041 + (1));
i__4865__auto___70041 = G__70042;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.track.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.track.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67410 = conformed_args__65183__auto__;
var map__67410__$1 = cljs.core.__destructure_map(map__67410);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67410__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67410__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67410__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("track",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.track.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.track.cljs$lang$applyTo = (function (seq67402){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67402));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (data "hello")
 * (data nil "hello")
 * 
 * These two are made equivalent at compile time
 * (data {:onClick f} "hello")
 * (data #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (data :#the-id.klass.other-klass "hello")
 * (data :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.data = (function com$fulcrologic$fulcro$dom$data(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70047 = arguments.length;
var i__4865__auto___70048 = (0);
while(true){
if((i__4865__auto___70048 < len__4864__auto___70047)){
args__4870__auto__.push((arguments[i__4865__auto___70048]));

var G__70049 = (i__4865__auto___70048 + (1));
i__4865__auto___70048 = G__70049;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.data.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.data.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67432 = conformed_args__65183__auto__;
var map__67432__$1 = cljs.core.__destructure_map(map__67432);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67432__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67432__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67432__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("data",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.data.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.data.cljs$lang$applyTo = (function (seq67418){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67418));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (u "hello")
 * (u nil "hello")
 * 
 * These two are made equivalent at compile time
 * (u {:onClick f} "hello")
 * (u #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (u :#the-id.klass.other-klass "hello")
 * (u :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.u = (function com$fulcrologic$fulcro$dom$u(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70051 = arguments.length;
var i__4865__auto___70052 = (0);
while(true){
if((i__4865__auto___70052 < len__4864__auto___70051)){
args__4870__auto__.push((arguments[i__4865__auto___70052]));

var G__70053 = (i__4865__auto___70052 + (1));
i__4865__auto___70052 = G__70053;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.u.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.u.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67513 = conformed_args__65183__auto__;
var map__67513__$1 = cljs.core.__destructure_map(map__67513);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67513__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67513__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67513__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("u",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.u.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.u.cljs$lang$applyTo = (function (seq67477){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67477));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dl "hello")
 * (dl nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dl {:onClick f} "hello")
 * (dl #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dl :#the-id.klass.other-klass "hello")
 * (dl :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dl = (function com$fulcrologic$fulcro$dom$dl(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70057 = arguments.length;
var i__4865__auto___70058 = (0);
while(true){
if((i__4865__auto___70058 < len__4864__auto___70057)){
args__4870__auto__.push((arguments[i__4865__auto___70058]));

var G__70059 = (i__4865__auto___70058 + (1));
i__4865__auto___70058 = G__70059;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dl.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dl.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67542 = conformed_args__65183__auto__;
var map__67542__$1 = cljs.core.__destructure_map(map__67542);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67542__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67542__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67542__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dl",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.dl.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dl.cljs$lang$applyTo = (function (seq67535){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67535));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (select "hello")
 * (select nil "hello")
 * 
 * These two are made equivalent at compile time
 * (select {:onClick f} "hello")
 * (select #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (select :#the-id.klass.other-klass "hello")
 * (select :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.select = (function com$fulcrologic$fulcro$dom$select(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70061 = arguments.length;
var i__4865__auto___70062 = (0);
while(true){
if((i__4865__auto___70062 < len__4864__auto___70061)){
args__4870__auto__.push((arguments[i__4865__auto___70062]));

var G__70063 = (i__4865__auto___70062 + (1));
i__4865__auto___70062 = G__70063;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.select.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.select.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67557 = conformed_args__65183__auto__;
var map__67557__$1 = cljs.core.__destructure_map(map__67557);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67557__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67557__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67557__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("select",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.select.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.select.cljs$lang$applyTo = (function (seq67551){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67551));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (polygon "hello")
 * (polygon nil "hello")
 * 
 * These two are made equivalent at compile time
 * (polygon {:onClick f} "hello")
 * (polygon #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (polygon :#the-id.klass.other-klass "hello")
 * (polygon :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.polygon = (function com$fulcrologic$fulcro$dom$polygon(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70066 = arguments.length;
var i__4865__auto___70068 = (0);
while(true){
if((i__4865__auto___70068 < len__4864__auto___70066)){
args__4870__auto__.push((arguments[i__4865__auto___70068]));

var G__70069 = (i__4865__auto___70068 + (1));
i__4865__auto___70068 = G__70069;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.polygon.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.polygon.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67575 = conformed_args__65183__auto__;
var map__67575__$1 = cljs.core.__destructure_map(map__67575);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67575__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67575__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67575__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("polygon",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.polygon.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.polygon.cljs$lang$applyTo = (function (seq67571){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67571));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (pattern "hello")
 * (pattern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (pattern {:onClick f} "hello")
 * (pattern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (pattern :#the-id.klass.other-klass "hello")
 * (pattern :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.pattern = (function com$fulcrologic$fulcro$dom$pattern(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70070 = arguments.length;
var i__4865__auto___70071 = (0);
while(true){
if((i__4865__auto___70071 < len__4864__auto___70070)){
args__4870__auto__.push((arguments[i__4865__auto___70071]));

var G__70072 = (i__4865__auto___70071 + (1));
i__4865__auto___70071 = G__70072;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.pattern.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.pattern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67587 = conformed_args__65183__auto__;
var map__67587__$1 = cljs.core.__destructure_map(map__67587);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67587__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67587__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67587__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("pattern",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.pattern.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.pattern.cljs$lang$applyTo = (function (seq67584){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67584));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (html "hello")
 * (html nil "hello")
 * 
 * These two are made equivalent at compile time
 * (html {:onClick f} "hello")
 * (html #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (html :#the-id.klass.other-klass "hello")
 * (html :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.html = (function com$fulcrologic$fulcro$dom$html(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70075 = arguments.length;
var i__4865__auto___70076 = (0);
while(true){
if((i__4865__auto___70076 < len__4864__auto___70075)){
args__4870__auto__.push((arguments[i__4865__auto___70076]));

var G__70077 = (i__4865__auto___70076 + (1));
i__4865__auto___70076 = G__70077;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.html.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.html.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67602 = conformed_args__65183__auto__;
var map__67602__$1 = cljs.core.__destructure_map(map__67602);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67602__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67602__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67602__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("html",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.html.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.html.cljs$lang$applyTo = (function (seq67594){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67594));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (foreignObject "hello")
 * (foreignObject nil "hello")
 * 
 * These two are made equivalent at compile time
 * (foreignObject {:onClick f} "hello")
 * (foreignObject #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (foreignObject :#the-id.klass.other-klass "hello")
 * (foreignObject :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.foreignObject = (function com$fulcrologic$fulcro$dom$foreignObject(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70084 = arguments.length;
var i__4865__auto___70085 = (0);
while(true){
if((i__4865__auto___70085 < len__4864__auto___70084)){
args__4870__auto__.push((arguments[i__4865__auto___70085]));

var G__70086 = (i__4865__auto___70085 + (1));
i__4865__auto___70085 = G__70086;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.foreignObject.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.foreignObject.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67618 = conformed_args__65183__auto__;
var map__67618__$1 = cljs.core.__destructure_map(map__67618);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67618__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67618__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67618__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("foreignObject",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.foreignObject.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.foreignObject.cljs$lang$applyTo = (function (seq67615){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67615));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (thead "hello")
 * (thead nil "hello")
 * 
 * These two are made equivalent at compile time
 * (thead {:onClick f} "hello")
 * (thead #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (thead :#the-id.klass.other-klass "hello")
 * (thead :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.thead = (function com$fulcrologic$fulcro$dom$thead(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70089 = arguments.length;
var i__4865__auto___70090 = (0);
while(true){
if((i__4865__auto___70090 < len__4864__auto___70089)){
args__4870__auto__.push((arguments[i__4865__auto___70090]));

var G__70092 = (i__4865__auto___70090 + (1));
i__4865__auto___70090 = G__70092;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.thead.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.thead.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67639 = conformed_args__65183__auto__;
var map__67639__$1 = cljs.core.__destructure_map(map__67639);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67639__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67639__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67639__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("thead",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.thead.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.thead.cljs$lang$applyTo = (function (seq67629){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67629));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (path "hello")
 * (path nil "hello")
 * 
 * These two are made equivalent at compile time
 * (path {:onClick f} "hello")
 * (path #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (path :#the-id.klass.other-klass "hello")
 * (path :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.path = (function com$fulcrologic$fulcro$dom$path(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70094 = arguments.length;
var i__4865__auto___70095 = (0);
while(true){
if((i__4865__auto___70095 < len__4864__auto___70094)){
args__4870__auto__.push((arguments[i__4865__auto___70095]));

var G__70096 = (i__4865__auto___70095 + (1));
i__4865__auto___70095 = G__70096;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.path.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.path.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67658 = conformed_args__65183__auto__;
var map__67658__$1 = cljs.core.__destructure_map(map__67658);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67658__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67658__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67658__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("path",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.path.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.path.cljs$lang$applyTo = (function (seq67646){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67646));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (del "hello")
 * (del nil "hello")
 * 
 * These two are made equivalent at compile time
 * (del {:onClick f} "hello")
 * (del #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (del :#the-id.klass.other-klass "hello")
 * (del :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.del = (function com$fulcrologic$fulcro$dom$del(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70102 = arguments.length;
var i__4865__auto___70103 = (0);
while(true){
if((i__4865__auto___70103 < len__4864__auto___70102)){
args__4870__auto__.push((arguments[i__4865__auto___70103]));

var G__70110 = (i__4865__auto___70103 + (1));
i__4865__auto___70103 = G__70110;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.del.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.del.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67678 = conformed_args__65183__auto__;
var map__67678__$1 = cljs.core.__destructure_map(map__67678);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67678__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67678__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67678__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("del",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.del.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.del.cljs$lang$applyTo = (function (seq67671){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67671));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyph "hello")
 * (altGlyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyph {:onClick f} "hello")
 * (altGlyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyph :#the-id.klass.other-klass "hello")
 * (altGlyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.altGlyph = (function com$fulcrologic$fulcro$dom$altGlyph(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70117 = arguments.length;
var i__4865__auto___70122 = (0);
while(true){
if((i__4865__auto___70122 < len__4864__auto___70117)){
args__4870__auto__.push((arguments[i__4865__auto___70122]));

var G__70125 = (i__4865__auto___70122 + (1));
i__4865__auto___70122 = G__70125;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.altGlyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.altGlyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67702 = conformed_args__65183__auto__;
var map__67702__$1 = cljs.core.__destructure_map(map__67702);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67702__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67702__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67702__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("altGlyph",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.altGlyph.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.altGlyph.cljs$lang$applyTo = (function (seq67681){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67681));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (fieldset "hello")
 * (fieldset nil "hello")
 * 
 * These two are made equivalent at compile time
 * (fieldset {:onClick f} "hello")
 * (fieldset #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (fieldset :#the-id.klass.other-klass "hello")
 * (fieldset :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.fieldset = (function com$fulcrologic$fulcro$dom$fieldset(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70144 = arguments.length;
var i__4865__auto___70145 = (0);
while(true){
if((i__4865__auto___70145 < len__4864__auto___70144)){
args__4870__auto__.push((arguments[i__4865__auto___70145]));

var G__70146 = (i__4865__auto___70145 + (1));
i__4865__auto___70145 = G__70146;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.fieldset.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67727 = conformed_args__65183__auto__;
var map__67727__$1 = cljs.core.__destructure_map(map__67727);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67727__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67727__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67727__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("fieldset",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.fieldset.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.fieldset.cljs$lang$applyTo = (function (seq67713){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67713));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (aside "hello")
 * (aside nil "hello")
 * 
 * These two are made equivalent at compile time
 * (aside {:onClick f} "hello")
 * (aside #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (aside :#the-id.klass.other-klass "hello")
 * (aside :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.aside = (function com$fulcrologic$fulcro$dom$aside(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70164 = arguments.length;
var i__4865__auto___70165 = (0);
while(true){
if((i__4865__auto___70165 < len__4864__auto___70164)){
args__4870__auto__.push((arguments[i__4865__auto___70165]));

var G__70167 = (i__4865__auto___70165 + (1));
i__4865__auto___70165 = G__70167;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.aside.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.aside.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67766 = conformed_args__65183__auto__;
var map__67766__$1 = cljs.core.__destructure_map(map__67766);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67766__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67766__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67766__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("aside",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.aside.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.aside.cljs$lang$applyTo = (function (seq67748){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67748));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feBlend "hello")
 * (feBlend nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feBlend {:onClick f} "hello")
 * (feBlend #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feBlend :#the-id.klass.other-klass "hello")
 * (feBlend :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feBlend = (function com$fulcrologic$fulcro$dom$feBlend(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70185 = arguments.length;
var i__4865__auto___70187 = (0);
while(true){
if((i__4865__auto___70187 < len__4864__auto___70185)){
args__4870__auto__.push((arguments[i__4865__auto___70187]));

var G__70189 = (i__4865__auto___70187 + (1));
i__4865__auto___70187 = G__70189;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feBlend.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feBlend.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67794 = conformed_args__65183__auto__;
var map__67794__$1 = cljs.core.__destructure_map(map__67794);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67794__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67794__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67794__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feBlend",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feBlend.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feBlend.cljs$lang$applyTo = (function (seq67778){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67778));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (figure "hello")
 * (figure nil "hello")
 * 
 * These two are made equivalent at compile time
 * (figure {:onClick f} "hello")
 * (figure #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (figure :#the-id.klass.other-klass "hello")
 * (figure :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.figure = (function com$fulcrologic$fulcro$dom$figure(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70198 = arguments.length;
var i__4865__auto___70200 = (0);
while(true){
if((i__4865__auto___70200 < len__4864__auto___70198)){
args__4870__auto__.push((arguments[i__4865__auto___70200]));

var G__70202 = (i__4865__auto___70200 + (1));
i__4865__auto___70200 = G__70202;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.figure.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.figure.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67817 = conformed_args__65183__auto__;
var map__67817__$1 = cljs.core.__destructure_map(map__67817);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67817__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67817__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67817__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("figure",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.figure.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.figure.cljs$lang$applyTo = (function (seq67806){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67806));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (textPath "hello")
 * (textPath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (textPath {:onClick f} "hello")
 * (textPath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (textPath :#the-id.klass.other-klass "hello")
 * (textPath :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.textPath = (function com$fulcrologic$fulcro$dom$textPath(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70215 = arguments.length;
var i__4865__auto___70217 = (0);
while(true){
if((i__4865__auto___70217 < len__4864__auto___70215)){
args__4870__auto__.push((arguments[i__4865__auto___70217]));

var G__70218 = (i__4865__auto___70217 + (1));
i__4865__auto___70217 = G__70218;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.textPath.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.textPath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67837 = conformed_args__65183__auto__;
var map__67837__$1 = cljs.core.__destructure_map(map__67837);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67837__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67837__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67837__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("textPath",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.textPath.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.textPath.cljs$lang$applyTo = (function (seq67828){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67828));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (figcaption "hello")
 * (figcaption nil "hello")
 * 
 * These two are made equivalent at compile time
 * (figcaption {:onClick f} "hello")
 * (figcaption #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (figcaption :#the-id.klass.other-klass "hello")
 * (figcaption :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.figcaption = (function com$fulcrologic$fulcro$dom$figcaption(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70229 = arguments.length;
var i__4865__auto___70230 = (0);
while(true){
if((i__4865__auto___70230 < len__4864__auto___70229)){
args__4870__auto__.push((arguments[i__4865__auto___70230]));

var G__70231 = (i__4865__auto___70230 + (1));
i__4865__auto___70230 = G__70231;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.figcaption.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67854 = conformed_args__65183__auto__;
var map__67854__$1 = cljs.core.__destructure_map(map__67854);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67854__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67854__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67854__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("figcaption",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.figcaption.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.figcaption.cljs$lang$applyTo = (function (seq67844){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67844));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mask "hello")
 * (mask nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mask {:onClick f} "hello")
 * (mask #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mask :#the-id.klass.other-klass "hello")
 * (mask :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.mask = (function com$fulcrologic$fulcro$dom$mask(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70237 = arguments.length;
var i__4865__auto___70238 = (0);
while(true){
if((i__4865__auto___70238 < len__4864__auto___70237)){
args__4870__auto__.push((arguments[i__4865__auto___70238]));

var G__70239 = (i__4865__auto___70238 + (1));
i__4865__auto___70238 = G__70239;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.mask.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.mask.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67874 = conformed_args__65183__auto__;
var map__67874__$1 = cljs.core.__destructure_map(map__67874);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67874__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67874__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67874__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("mask",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.mask.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.mask.cljs$lang$applyTo = (function (seq67861){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67861));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (q "hello")
 * (q nil "hello")
 * 
 * These two are made equivalent at compile time
 * (q {:onClick f} "hello")
 * (q #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (q :#the-id.klass.other-klass "hello")
 * (q :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.q = (function com$fulcrologic$fulcro$dom$q(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70251 = arguments.length;
var i__4865__auto___70252 = (0);
while(true){
if((i__4865__auto___70252 < len__4864__auto___70251)){
args__4870__auto__.push((arguments[i__4865__auto___70252]));

var G__70253 = (i__4865__auto___70252 + (1));
i__4865__auto___70252 = G__70253;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.q.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.q.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67887 = conformed_args__65183__auto__;
var map__67887__$1 = cljs.core.__destructure_map(map__67887);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67887__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67887__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67887__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("q",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.q.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.q.cljs$lang$applyTo = (function (seq67880){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67880));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (bdi "hello")
 * (bdi nil "hello")
 * 
 * These two are made equivalent at compile time
 * (bdi {:onClick f} "hello")
 * (bdi #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (bdi :#the-id.klass.other-klass "hello")
 * (bdi :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.bdi = (function com$fulcrologic$fulcro$dom$bdi(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70261 = arguments.length;
var i__4865__auto___70262 = (0);
while(true){
if((i__4865__auto___70262 < len__4864__auto___70261)){
args__4870__auto__.push((arguments[i__4865__auto___70262]));

var G__70263 = (i__4865__auto___70262 + (1));
i__4865__auto___70262 = G__70263;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.bdi.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.bdi.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67901 = conformed_args__65183__auto__;
var map__67901__$1 = cljs.core.__destructure_map(map__67901);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67901__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67901__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67901__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("bdi",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.bdi.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.bdi.cljs$lang$applyTo = (function (seq67896){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67896));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDistantLight "hello")
 * (feDistantLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDistantLight {:onClick f} "hello")
 * (feDistantLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDistantLight :#the-id.klass.other-klass "hello")
 * (feDistantLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feDistantLight = (function com$fulcrologic$fulcro$dom$feDistantLight(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70267 = arguments.length;
var i__4865__auto___70268 = (0);
while(true){
if((i__4865__auto___70268 < len__4864__auto___70267)){
args__4870__auto__.push((arguments[i__4865__auto___70268]));

var G__70270 = (i__4865__auto___70268 + (1));
i__4865__auto___70268 = G__70270;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feDistantLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feDistantLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67911 = conformed_args__65183__auto__;
var map__67911__$1 = cljs.core.__destructure_map(map__67911);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67911__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67911__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67911__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feDistantLight",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feDistantLight.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feDistantLight.cljs$lang$applyTo = (function (seq67906){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67906));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (video "hello")
 * (video nil "hello")
 * 
 * These two are made equivalent at compile time
 * (video {:onClick f} "hello")
 * (video #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (video :#the-id.klass.other-klass "hello")
 * (video :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.video = (function com$fulcrologic$fulcro$dom$video(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70283 = arguments.length;
var i__4865__auto___70284 = (0);
while(true){
if((i__4865__auto___70284 < len__4864__auto___70283)){
args__4870__auto__.push((arguments[i__4865__auto___70284]));

var G__70285 = (i__4865__auto___70284 + (1));
i__4865__auto___70284 = G__70285;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.video.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.video.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67919 = conformed_args__65183__auto__;
var map__67919__$1 = cljs.core.__destructure_map(map__67919);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67919__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67919__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67919__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("video",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.video.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.video.cljs$lang$applyTo = (function (seq67914){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67914));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (address "hello")
 * (address nil "hello")
 * 
 * These two are made equivalent at compile time
 * (address {:onClick f} "hello")
 * (address #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (address :#the-id.klass.other-klass "hello")
 * (address :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.address = (function com$fulcrologic$fulcro$dom$address(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70291 = arguments.length;
var i__4865__auto___70292 = (0);
while(true){
if((i__4865__auto___70292 < len__4864__auto___70291)){
args__4870__auto__.push((arguments[i__4865__auto___70292]));

var G__70294 = (i__4865__auto___70292 + (1));
i__4865__auto___70292 = G__70294;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.address.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.address.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67929 = conformed_args__65183__auto__;
var map__67929__$1 = cljs.core.__destructure_map(map__67929);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67929__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67929__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67929__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("address",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.address.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.address.cljs$lang$applyTo = (function (seq67923){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67923));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (caption "hello")
 * (caption nil "hello")
 * 
 * These two are made equivalent at compile time
 * (caption {:onClick f} "hello")
 * (caption #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (caption :#the-id.klass.other-klass "hello")
 * (caption :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.caption = (function com$fulcrologic$fulcro$dom$caption(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70296 = arguments.length;
var i__4865__auto___70297 = (0);
while(true){
if((i__4865__auto___70297 < len__4864__auto___70296)){
args__4870__auto__.push((arguments[i__4865__auto___70297]));

var G__70299 = (i__4865__auto___70297 + (1));
i__4865__auto___70297 = G__70299;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.caption.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.caption.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__67962 = conformed_args__65183__auto__;
var map__67962__$1 = cljs.core.__destructure_map(map__67962);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67962__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67962__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67962__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("caption",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.caption.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.caption.cljs$lang$applyTo = (function (seq67937){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67937));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dd "hello")
 * (dd nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dd {:onClick f} "hello")
 * (dd #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dd :#the-id.klass.other-klass "hello")
 * (dd :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dd = (function com$fulcrologic$fulcro$dom$dd(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70305 = arguments.length;
var i__4865__auto___70306 = (0);
while(true){
if((i__4865__auto___70306 < len__4864__auto___70305)){
args__4870__auto__.push((arguments[i__4865__auto___70306]));

var G__70309 = (i__4865__auto___70306 + (1));
i__4865__auto___70306 = G__70309;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dd.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dd.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68004 = conformed_args__65183__auto__;
var map__68004__$1 = cljs.core.__destructure_map(map__68004);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68004__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68004__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68004__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dd",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.dd.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dd.cljs$lang$applyTo = (function (seq67994){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq67994));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rp "hello")
 * (rp nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rp {:onClick f} "hello")
 * (rp #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rp :#the-id.klass.other-klass "hello")
 * (rp :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.rp = (function com$fulcrologic$fulcro$dom$rp(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70316 = arguments.length;
var i__4865__auto___70317 = (0);
while(true){
if((i__4865__auto___70317 < len__4864__auto___70316)){
args__4870__auto__.push((arguments[i__4865__auto___70317]));

var G__70318 = (i__4865__auto___70317 + (1));
i__4865__auto___70317 = G__70318;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.rp.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.rp.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68017 = conformed_args__65183__auto__;
var map__68017__$1 = cljs.core.__destructure_map(map__68017);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68017__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68017__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68017__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("rp",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.rp.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.rp.cljs$lang$applyTo = (function (seq68012){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68012));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hr "hello")
 * (hr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hr {:onClick f} "hello")
 * (hr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hr :#the-id.klass.other-klass "hello")
 * (hr :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.hr = (function com$fulcrologic$fulcro$dom$hr(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70319 = arguments.length;
var i__4865__auto___70320 = (0);
while(true){
if((i__4865__auto___70320 < len__4864__auto___70319)){
args__4870__auto__.push((arguments[i__4865__auto___70320]));

var G__70321 = (i__4865__auto___70320 + (1));
i__4865__auto___70320 = G__70321;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.hr.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.hr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68034 = conformed_args__65183__auto__;
var map__68034__$1 = cljs.core.__destructure_map(map__68034);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68034__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68034__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68034__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("hr",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.hr.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.hr.cljs$lang$applyTo = (function (seq68020){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68020));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meta "hello")
 * (meta nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meta {:onClick f} "hello")
 * (meta #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meta :#the-id.klass.other-klass "hello")
 * (meta :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meta = (function com$fulcrologic$fulcro$dom$meta(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70329 = arguments.length;
var i__4865__auto___70330 = (0);
while(true){
if((i__4865__auto___70330 < len__4864__auto___70329)){
args__4870__auto__.push((arguments[i__4865__auto___70330]));

var G__70331 = (i__4865__auto___70330 + (1));
i__4865__auto___70330 = G__70331;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meta.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meta.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68076 = conformed_args__65183__auto__;
var map__68076__$1 = cljs.core.__destructure_map(map__68076);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68076__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68076__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68076__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meta",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.meta.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meta.cljs$lang$applyTo = (function (seq68054){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68054));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tbody "hello")
 * (tbody nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tbody {:onClick f} "hello")
 * (tbody #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tbody :#the-id.klass.other-klass "hello")
 * (tbody :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tbody = (function com$fulcrologic$fulcro$dom$tbody(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70335 = arguments.length;
var i__4865__auto___70336 = (0);
while(true){
if((i__4865__auto___70336 < len__4864__auto___70335)){
args__4870__auto__.push((arguments[i__4865__auto___70336]));

var G__70337 = (i__4865__auto___70336 + (1));
i__4865__auto___70336 = G__70337;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tbody.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tbody.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68092 = conformed_args__65183__auto__;
var map__68092__$1 = cljs.core.__destructure_map(map__68092);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68092__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68092__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68092__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tbody",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.tbody.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tbody.cljs$lang$applyTo = (function (seq68086){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68086));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (desc "hello")
 * (desc nil "hello")
 * 
 * These two are made equivalent at compile time
 * (desc {:onClick f} "hello")
 * (desc #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (desc :#the-id.klass.other-klass "hello")
 * (desc :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.desc = (function com$fulcrologic$fulcro$dom$desc(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70344 = arguments.length;
var i__4865__auto___70345 = (0);
while(true){
if((i__4865__auto___70345 < len__4864__auto___70344)){
args__4870__auto__.push((arguments[i__4865__auto___70345]));

var G__70349 = (i__4865__auto___70345 + (1));
i__4865__auto___70345 = G__70349;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.desc.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.desc.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68108 = conformed_args__65183__auto__;
var map__68108__$1 = cljs.core.__destructure_map(map__68108);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68108__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68108__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68108__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("desc",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.desc.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.desc.cljs$lang$applyTo = (function (seq68097){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68097));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (table "hello")
 * (table nil "hello")
 * 
 * These two are made equivalent at compile time
 * (table {:onClick f} "hello")
 * (table #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (table :#the-id.klass.other-klass "hello")
 * (table :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.table = (function com$fulcrologic$fulcro$dom$table(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70354 = arguments.length;
var i__4865__auto___70355 = (0);
while(true){
if((i__4865__auto___70355 < len__4864__auto___70354)){
args__4870__auto__.push((arguments[i__4865__auto___70355]));

var G__70356 = (i__4865__auto___70355 + (1));
i__4865__auto___70355 = G__70356;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.table.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.table.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68121 = conformed_args__65183__auto__;
var map__68121__$1 = cljs.core.__destructure_map(map__68121);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68121__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68121__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68121__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("table",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.table.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.table.cljs$lang$applyTo = (function (seq68114){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68114));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (pre "hello")
 * (pre nil "hello")
 * 
 * These two are made equivalent at compile time
 * (pre {:onClick f} "hello")
 * (pre #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (pre :#the-id.klass.other-klass "hello")
 * (pre :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.pre = (function com$fulcrologic$fulcro$dom$pre(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70359 = arguments.length;
var i__4865__auto___70360 = (0);
while(true){
if((i__4865__auto___70360 < len__4864__auto___70359)){
args__4870__auto__.push((arguments[i__4865__auto___70360]));

var G__70361 = (i__4865__auto___70360 + (1));
i__4865__auto___70360 = G__70361;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.pre.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.pre.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68139 = conformed_args__65183__auto__;
var map__68139__$1 = cljs.core.__destructure_map(map__68139);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68139__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68139__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68139__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("pre",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.pre.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.pre.cljs$lang$applyTo = (function (seq68127){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68127));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ul "hello")
 * (ul nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ul {:onClick f} "hello")
 * (ul #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ul :#the-id.klass.other-klass "hello")
 * (ul :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ul = (function com$fulcrologic$fulcro$dom$ul(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70362 = arguments.length;
var i__4865__auto___70363 = (0);
while(true){
if((i__4865__auto___70363 < len__4864__auto___70362)){
args__4870__auto__.push((arguments[i__4865__auto___70363]));

var G__70364 = (i__4865__auto___70363 + (1));
i__4865__auto___70363 = G__70364;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ul.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ul.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68146 = conformed_args__65183__auto__;
var map__68146__$1 = cljs.core.__destructure_map(map__68146);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68146__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68146__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68146__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ul",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.ul.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ul.cljs$lang$applyTo = (function (seq68140){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68140));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feConvolveMatrix "hello")
 * (feConvolveMatrix nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feConvolveMatrix {:onClick f} "hello")
 * (feConvolveMatrix #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feConvolveMatrix :#the-id.klass.other-klass "hello")
 * (feConvolveMatrix :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feConvolveMatrix = (function com$fulcrologic$fulcro$dom$feConvolveMatrix(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70366 = arguments.length;
var i__4865__auto___70367 = (0);
while(true){
if((i__4865__auto___70367 < len__4864__auto___70366)){
args__4870__auto__.push((arguments[i__4865__auto___70367]));

var G__70368 = (i__4865__auto___70367 + (1));
i__4865__auto___70367 = G__70368;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feConvolveMatrix.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feConvolveMatrix.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68153 = conformed_args__65183__auto__;
var map__68153__$1 = cljs.core.__destructure_map(map__68153);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68153__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68153__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68153__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feConvolveMatrix",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feConvolveMatrix.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feConvolveMatrix.cljs$lang$applyTo = (function (seq68149){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68149));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (sup "hello")
 * (sup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (sup {:onClick f} "hello")
 * (sup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (sup :#the-id.klass.other-klass "hello")
 * (sup :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.sup = (function com$fulcrologic$fulcro$dom$sup(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70370 = arguments.length;
var i__4865__auto___70371 = (0);
while(true){
if((i__4865__auto___70371 < len__4864__auto___70370)){
args__4870__auto__.push((arguments[i__4865__auto___70371]));

var G__70372 = (i__4865__auto___70371 + (1));
i__4865__auto___70371 = G__70372;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.sup.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.sup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68185 = conformed_args__65183__auto__;
var map__68185__$1 = cljs.core.__destructure_map(map__68185);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68185__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68185__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68185__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("sup",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.sup.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.sup.cljs$lang$applyTo = (function (seq68169){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68169));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dfn "hello")
 * (dfn nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dfn {:onClick f} "hello")
 * (dfn #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dfn :#the-id.klass.other-klass "hello")
 * (dfn :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dfn = (function com$fulcrologic$fulcro$dom$dfn(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70376 = arguments.length;
var i__4865__auto___70377 = (0);
while(true){
if((i__4865__auto___70377 < len__4864__auto___70376)){
args__4870__auto__.push((arguments[i__4865__auto___70377]));

var G__70378 = (i__4865__auto___70377 + (1));
i__4865__auto___70377 = G__70378;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dfn.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dfn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68212 = conformed_args__65183__auto__;
var map__68212__$1 = cljs.core.__destructure_map(map__68212);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68212__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68212__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68212__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dfn",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.dfn.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dfn.cljs$lang$applyTo = (function (seq68194){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68194));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (sub "hello")
 * (sub nil "hello")
 * 
 * These two are made equivalent at compile time
 * (sub {:onClick f} "hello")
 * (sub #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (sub :#the-id.klass.other-klass "hello")
 * (sub :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.sub = (function com$fulcrologic$fulcro$dom$sub(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70384 = arguments.length;
var i__4865__auto___70385 = (0);
while(true){
if((i__4865__auto___70385 < len__4864__auto___70384)){
args__4870__auto__.push((arguments[i__4865__auto___70385]));

var G__70387 = (i__4865__auto___70385 + (1));
i__4865__auto___70385 = G__70387;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.sub.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.sub.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68227 = conformed_args__65183__auto__;
var map__68227__$1 = cljs.core.__destructure_map(map__68227);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68227__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68227__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68227__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("sub",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.sub.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.sub.cljs$lang$applyTo = (function (seq68218){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68218));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mark "hello")
 * (mark nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mark {:onClick f} "hello")
 * (mark #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mark :#the-id.klass.other-klass "hello")
 * (mark :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.mark = (function com$fulcrologic$fulcro$dom$mark(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70388 = arguments.length;
var i__4865__auto___70389 = (0);
while(true){
if((i__4865__auto___70389 < len__4864__auto___70388)){
args__4870__auto__.push((arguments[i__4865__auto___70389]));

var G__70390 = (i__4865__auto___70389 + (1));
i__4865__auto___70389 = G__70390;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.mark.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.mark.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68235 = conformed_args__65183__auto__;
var map__68235__$1 = cljs.core.__destructure_map(map__68235);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68235__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68235__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68235__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("mark",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.mark.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.mark.cljs$lang$applyTo = (function (seq68229){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68229));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDisplacementMap "hello")
 * (feDisplacementMap nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDisplacementMap {:onClick f} "hello")
 * (feDisplacementMap #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDisplacementMap :#the-id.klass.other-klass "hello")
 * (feDisplacementMap :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feDisplacementMap = (function com$fulcrologic$fulcro$dom$feDisplacementMap(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70391 = arguments.length;
var i__4865__auto___70392 = (0);
while(true){
if((i__4865__auto___70392 < len__4864__auto___70391)){
args__4870__auto__.push((arguments[i__4865__auto___70392]));

var G__70393 = (i__4865__auto___70392 + (1));
i__4865__auto___70392 = G__70393;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feDisplacementMap.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feDisplacementMap.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68255 = conformed_args__65183__auto__;
var map__68255__$1 = cljs.core.__destructure_map(map__68255);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68255__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68255__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68255__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feDisplacementMap",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feDisplacementMap.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feDisplacementMap.cljs$lang$applyTo = (function (seq68240){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68240));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (unknown "hello")
 * (unknown nil "hello")
 * 
 * These two are made equivalent at compile time
 * (unknown {:onClick f} "hello")
 * (unknown #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (unknown :#the-id.klass.other-klass "hello")
 * (unknown :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.unknown = (function com$fulcrologic$fulcro$dom$unknown(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70395 = arguments.length;
var i__4865__auto___70396 = (0);
while(true){
if((i__4865__auto___70396 < len__4864__auto___70395)){
args__4870__auto__.push((arguments[i__4865__auto___70396]));

var G__70397 = (i__4865__auto___70396 + (1));
i__4865__auto___70396 = G__70397;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.unknown.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.unknown.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68298 = conformed_args__65183__auto__;
var map__68298__$1 = cljs.core.__destructure_map(map__68298);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68298__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68298__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68298__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("unknown",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.unknown.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.unknown.cljs$lang$applyTo = (function (seq68269){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68269));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (script "hello")
 * (script nil "hello")
 * 
 * These two are made equivalent at compile time
 * (script {:onClick f} "hello")
 * (script #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (script :#the-id.klass.other-klass "hello")
 * (script :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.script = (function com$fulcrologic$fulcro$dom$script(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70398 = arguments.length;
var i__4865__auto___70399 = (0);
while(true){
if((i__4865__auto___70399 < len__4864__auto___70398)){
args__4870__auto__.push((arguments[i__4865__auto___70399]));

var G__70400 = (i__4865__auto___70399 + (1));
i__4865__auto___70399 = G__70400;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.script.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.script.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68351 = conformed_args__65183__auto__;
var map__68351__$1 = cljs.core.__destructure_map(map__68351);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68351__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68351__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68351__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("script",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.script.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.script.cljs$lang$applyTo = (function (seq68327){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68327));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feTurbulence "hello")
 * (feTurbulence nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feTurbulence {:onClick f} "hello")
 * (feTurbulence #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feTurbulence :#the-id.klass.other-klass "hello")
 * (feTurbulence :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feTurbulence = (function com$fulcrologic$fulcro$dom$feTurbulence(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70402 = arguments.length;
var i__4865__auto___70403 = (0);
while(true){
if((i__4865__auto___70403 < len__4864__auto___70402)){
args__4870__auto__.push((arguments[i__4865__auto___70403]));

var G__70404 = (i__4865__auto___70403 + (1));
i__4865__auto___70403 = G__70404;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feTurbulence.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feTurbulence.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68379 = conformed_args__65183__auto__;
var map__68379__$1 = cljs.core.__destructure_map(map__68379);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68379__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68379__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68379__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feTurbulence",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feTurbulence.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feTurbulence.cljs$lang$applyTo = (function (seq68368){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68368));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (big "hello")
 * (big nil "hello")
 * 
 * These two are made equivalent at compile time
 * (big {:onClick f} "hello")
 * (big #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (big :#the-id.klass.other-klass "hello")
 * (big :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.big = (function com$fulcrologic$fulcro$dom$big(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70407 = arguments.length;
var i__4865__auto___70409 = (0);
while(true){
if((i__4865__auto___70409 < len__4864__auto___70407)){
args__4870__auto__.push((arguments[i__4865__auto___70409]));

var G__70410 = (i__4865__auto___70409 + (1));
i__4865__auto___70409 = G__70410;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.big.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.big.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68407 = conformed_args__65183__auto__;
var map__68407__$1 = cljs.core.__destructure_map(map__68407);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68407__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68407__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68407__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("big",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.big.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.big.cljs$lang$applyTo = (function (seq68392){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68392));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (button "hello")
 * (button nil "hello")
 * 
 * These two are made equivalent at compile time
 * (button {:onClick f} "hello")
 * (button #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (button :#the-id.klass.other-klass "hello")
 * (button :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.button = (function com$fulcrologic$fulcro$dom$button(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70411 = arguments.length;
var i__4865__auto___70412 = (0);
while(true){
if((i__4865__auto___70412 < len__4864__auto___70411)){
args__4870__auto__.push((arguments[i__4865__auto___70412]));

var G__70413 = (i__4865__auto___70412 + (1));
i__4865__auto___70412 = G__70413;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.button.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.button.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68435 = conformed_args__65183__auto__;
var map__68435__$1 = cljs.core.__destructure_map(map__68435);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68435__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68435__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68435__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("button",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.button.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.button.cljs$lang$applyTo = (function (seq68425){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68425));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-uri "hello")
 * (font-face-uri nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-uri {:onClick f} "hello")
 * (font-face-uri #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-uri :#the-id.klass.other-klass "hello")
 * (font-face-uri :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face_uri = (function com$fulcrologic$fulcro$dom$font_face_uri(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70414 = arguments.length;
var i__4865__auto___70415 = (0);
while(true){
if((i__4865__auto___70415 < len__4864__auto___70414)){
args__4870__auto__.push((arguments[i__4865__auto___70415]));

var G__70417 = (i__4865__auto___70415 + (1));
i__4865__auto___70415 = G__70417;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face_uri.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face_uri.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68475 = conformed_args__65183__auto__;
var map__68475__$1 = cljs.core.__destructure_map(map__68475);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68475__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68475__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68475__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face-uri",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face_uri.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face_uri.cljs$lang$applyTo = (function (seq68461){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68461));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (wbr "hello")
 * (wbr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (wbr {:onClick f} "hello")
 * (wbr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (wbr :#the-id.klass.other-klass "hello")
 * (wbr :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.wbr = (function com$fulcrologic$fulcro$dom$wbr(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70419 = arguments.length;
var i__4865__auto___70420 = (0);
while(true){
if((i__4865__auto___70420 < len__4864__auto___70419)){
args__4870__auto__.push((arguments[i__4865__auto___70420]));

var G__70421 = (i__4865__auto___70420 + (1));
i__4865__auto___70420 = G__70421;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.wbr.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.wbr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68514 = conformed_args__65183__auto__;
var map__68514__$1 = cljs.core.__destructure_map(map__68514);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68514__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68514__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68514__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("wbr",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.wbr.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.wbr.cljs$lang$applyTo = (function (seq68493){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68493));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (symbol "hello")
 * (symbol nil "hello")
 * 
 * These two are made equivalent at compile time
 * (symbol {:onClick f} "hello")
 * (symbol #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (symbol :#the-id.klass.other-klass "hello")
 * (symbol :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.symbol = (function com$fulcrologic$fulcro$dom$symbol(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70425 = arguments.length;
var i__4865__auto___70426 = (0);
while(true){
if((i__4865__auto___70426 < len__4864__auto___70425)){
args__4870__auto__.push((arguments[i__4865__auto___70426]));

var G__70427 = (i__4865__auto___70426 + (1));
i__4865__auto___70426 = G__70427;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.symbol.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.symbol.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68556 = conformed_args__65183__auto__;
var map__68556__$1 = cljs.core.__destructure_map(map__68556);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68556__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68556__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68556__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("symbol",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.symbol.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.symbol.cljs$lang$applyTo = (function (seq68524){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68524));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (strong "hello")
 * (strong nil "hello")
 * 
 * These two are made equivalent at compile time
 * (strong {:onClick f} "hello")
 * (strong #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (strong :#the-id.klass.other-klass "hello")
 * (strong :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.strong = (function com$fulcrologic$fulcro$dom$strong(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70428 = arguments.length;
var i__4865__auto___70429 = (0);
while(true){
if((i__4865__auto___70429 < len__4864__auto___70428)){
args__4870__auto__.push((arguments[i__4865__auto___70429]));

var G__70430 = (i__4865__auto___70429 + (1));
i__4865__auto___70429 = G__70430;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.strong.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.strong.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68592 = conformed_args__65183__auto__;
var map__68592__$1 = cljs.core.__destructure_map(map__68592);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68592__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68592__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68592__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("strong",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.strong.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.strong.cljs$lang$applyTo = (function (seq68583){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68583));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (use "hello")
 * (use nil "hello")
 * 
 * These two are made equivalent at compile time
 * (use {:onClick f} "hello")
 * (use #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (use :#the-id.klass.other-klass "hello")
 * (use :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.use = (function com$fulcrologic$fulcro$dom$use(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70433 = arguments.length;
var i__4865__auto___70434 = (0);
while(true){
if((i__4865__auto___70434 < len__4864__auto___70433)){
args__4870__auto__.push((arguments[i__4865__auto___70434]));

var G__70435 = (i__4865__auto___70434 + (1));
i__4865__auto___70434 = G__70435;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.use.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.use.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68627 = conformed_args__65183__auto__;
var map__68627__$1 = cljs.core.__destructure_map(map__68627);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68627__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68627__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68627__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("use",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.use.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.use.cljs$lang$applyTo = (function (seq68610){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68610));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (solidcolor "hello")
 * (solidcolor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (solidcolor {:onClick f} "hello")
 * (solidcolor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (solidcolor :#the-id.klass.other-klass "hello")
 * (solidcolor :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.solidcolor = (function com$fulcrologic$fulcro$dom$solidcolor(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70437 = arguments.length;
var i__4865__auto___70438 = (0);
while(true){
if((i__4865__auto___70438 < len__4864__auto___70437)){
args__4870__auto__.push((arguments[i__4865__auto___70438]));

var G__70439 = (i__4865__auto___70438 + (1));
i__4865__auto___70438 = G__70439;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.solidcolor.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.solidcolor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68633 = conformed_args__65183__auto__;
var map__68633__$1 = cljs.core.__destructure_map(map__68633);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68633__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68633__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68633__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("solidcolor",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.solidcolor.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.solidcolor.cljs$lang$applyTo = (function (seq68629){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68629));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (fePointLight "hello")
 * (fePointLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (fePointLight {:onClick f} "hello")
 * (fePointLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (fePointLight :#the-id.klass.other-klass "hello")
 * (fePointLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.fePointLight = (function com$fulcrologic$fulcro$dom$fePointLight(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70441 = arguments.length;
var i__4865__auto___70442 = (0);
while(true){
if((i__4865__auto___70442 < len__4864__auto___70441)){
args__4870__auto__.push((arguments[i__4865__auto___70442]));

var G__70443 = (i__4865__auto___70442 + (1));
i__4865__auto___70442 = G__70443;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.fePointLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.fePointLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68646 = conformed_args__65183__auto__;
var map__68646__$1 = cljs.core.__destructure_map(map__68646);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68646__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68646__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68646__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("fePointLight",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.fePointLight.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.fePointLight.cljs$lang$applyTo = (function (seq68639){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68639));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (li "hello")
 * (li nil "hello")
 * 
 * These two are made equivalent at compile time
 * (li {:onClick f} "hello")
 * (li #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (li :#the-id.klass.other-klass "hello")
 * (li :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.li = (function com$fulcrologic$fulcro$dom$li(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70445 = arguments.length;
var i__4865__auto___70446 = (0);
while(true){
if((i__4865__auto___70446 < len__4864__auto___70445)){
args__4870__auto__.push((arguments[i__4865__auto___70446]));

var G__70447 = (i__4865__auto___70446 + (1));
i__4865__auto___70446 = G__70447;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.li.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.li.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68655 = conformed_args__65183__auto__;
var map__68655__$1 = cljs.core.__destructure_map(map__68655);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68655__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68655__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68655__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("li",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.li.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.li.cljs$lang$applyTo = (function (seq68653){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68653));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dt "hello")
 * (dt nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dt {:onClick f} "hello")
 * (dt #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dt :#the-id.klass.other-klass "hello")
 * (dt :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dt = (function com$fulcrologic$fulcro$dom$dt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70450 = arguments.length;
var i__4865__auto___70451 = (0);
while(true){
if((i__4865__auto___70451 < len__4864__auto___70450)){
args__4870__auto__.push((arguments[i__4865__auto___70451]));

var G__70452 = (i__4865__auto___70451 + (1));
i__4865__auto___70451 = G__70452;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dt.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dt.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68663 = conformed_args__65183__auto__;
var map__68663__$1 = cljs.core.__destructure_map(map__68663);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68663__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68663__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68663__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dt",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.dt.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dt.cljs$lang$applyTo = (function (seq68658){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68658));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFuncB "hello")
 * (feFuncB nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFuncB {:onClick f} "hello")
 * (feFuncB #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFuncB :#the-id.klass.other-klass "hello")
 * (feFuncB :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFuncB = (function com$fulcrologic$fulcro$dom$feFuncB(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70456 = arguments.length;
var i__4865__auto___70457 = (0);
while(true){
if((i__4865__auto___70457 < len__4864__auto___70456)){
args__4870__auto__.push((arguments[i__4865__auto___70457]));

var G__70458 = (i__4865__auto___70457 + (1));
i__4865__auto___70457 = G__70458;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFuncB.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFuncB.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68674 = conformed_args__65183__auto__;
var map__68674__$1 = cljs.core.__destructure_map(map__68674);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68674__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68674__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68674__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFuncB",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feFuncB.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFuncB.cljs$lang$applyTo = (function (seq68666){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68666));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (marker "hello")
 * (marker nil "hello")
 * 
 * These two are made equivalent at compile time
 * (marker {:onClick f} "hello")
 * (marker #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (marker :#the-id.klass.other-klass "hello")
 * (marker :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.marker = (function com$fulcrologic$fulcro$dom$marker(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70459 = arguments.length;
var i__4865__auto___70460 = (0);
while(true){
if((i__4865__auto___70460 < len__4864__auto___70459)){
args__4870__auto__.push((arguments[i__4865__auto___70460]));

var G__70464 = (i__4865__auto___70460 + (1));
i__4865__auto___70460 = G__70464;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.marker.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.marker.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68696 = conformed_args__65183__auto__;
var map__68696__$1 = cljs.core.__destructure_map(map__68696);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68696__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68696__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68696__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("marker",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.marker.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.marker.cljs$lang$applyTo = (function (seq68687){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68687));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feComponentTransfer "hello")
 * (feComponentTransfer nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feComponentTransfer {:onClick f} "hello")
 * (feComponentTransfer #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feComponentTransfer :#the-id.klass.other-klass "hello")
 * (feComponentTransfer :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feComponentTransfer = (function com$fulcrologic$fulcro$dom$feComponentTransfer(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70465 = arguments.length;
var i__4865__auto___70466 = (0);
while(true){
if((i__4865__auto___70466 < len__4864__auto___70465)){
args__4870__auto__.push((arguments[i__4865__auto___70466]));

var G__70467 = (i__4865__auto___70466 + (1));
i__4865__auto___70466 = G__70467;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feComponentTransfer.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feComponentTransfer.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68710 = conformed_args__65183__auto__;
var map__68710__$1 = cljs.core.__destructure_map(map__68710);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68710__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68710__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68710__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feComponentTransfer",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feComponentTransfer.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feComponentTransfer.cljs$lang$applyTo = (function (seq68701){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68701));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (td "hello")
 * (td nil "hello")
 * 
 * These two are made equivalent at compile time
 * (td {:onClick f} "hello")
 * (td #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (td :#the-id.klass.other-klass "hello")
 * (td :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.td = (function com$fulcrologic$fulcro$dom$td(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70470 = arguments.length;
var i__4865__auto___70471 = (0);
while(true){
if((i__4865__auto___70471 < len__4864__auto___70470)){
args__4870__auto__.push((arguments[i__4865__auto___70471]));

var G__70472 = (i__4865__auto___70471 + (1));
i__4865__auto___70471 = G__70472;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.td.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.td.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68717 = conformed_args__65183__auto__;
var map__68717__$1 = cljs.core.__destructure_map(map__68717);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68717__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68717__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68717__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("td",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.td.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.td.cljs$lang$applyTo = (function (seq68715){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68715));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tr "hello")
 * (tr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tr {:onClick f} "hello")
 * (tr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tr :#the-id.klass.other-klass "hello")
 * (tr :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tr = (function com$fulcrologic$fulcro$dom$tr(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70474 = arguments.length;
var i__4865__auto___70475 = (0);
while(true){
if((i__4865__auto___70475 < len__4864__auto___70474)){
args__4870__auto__.push((arguments[i__4865__auto___70475]));

var G__70476 = (i__4865__auto___70475 + (1));
i__4865__auto___70475 = G__70476;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tr.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68721 = conformed_args__65183__auto__;
var map__68721__$1 = cljs.core.__destructure_map(map__68721);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68721__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68721__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68721__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tr",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.tr.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tr.cljs$lang$applyTo = (function (seq68718){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68718));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (circle "hello")
 * (circle nil "hello")
 * 
 * These two are made equivalent at compile time
 * (circle {:onClick f} "hello")
 * (circle #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (circle :#the-id.klass.other-klass "hello")
 * (circle :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.circle = (function com$fulcrologic$fulcro$dom$circle(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70479 = arguments.length;
var i__4865__auto___70480 = (0);
while(true){
if((i__4865__auto___70480 < len__4864__auto___70479)){
args__4870__auto__.push((arguments[i__4865__auto___70480]));

var G__70481 = (i__4865__auto___70480 + (1));
i__4865__auto___70480 = G__70481;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.circle.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.circle.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68734 = conformed_args__65183__auto__;
var map__68734__$1 = cljs.core.__destructure_map(map__68734);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68734__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68734__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68734__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("circle",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.circle.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.circle.cljs$lang$applyTo = (function (seq68730){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68730));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (section "hello")
 * (section nil "hello")
 * 
 * These two are made equivalent at compile time
 * (section {:onClick f} "hello")
 * (section #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (section :#the-id.klass.other-klass "hello")
 * (section :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.section = (function com$fulcrologic$fulcro$dom$section(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70488 = arguments.length;
var i__4865__auto___70489 = (0);
while(true){
if((i__4865__auto___70489 < len__4864__auto___70488)){
args__4870__auto__.push((arguments[i__4865__auto___70489]));

var G__70491 = (i__4865__auto___70489 + (1));
i__4865__auto___70489 = G__70491;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.section.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.section.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68742 = conformed_args__65183__auto__;
var map__68742__$1 = cljs.core.__destructure_map(map__68742);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68742__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68742__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68742__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("section",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.section.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.section.cljs$lang$applyTo = (function (seq68737){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68737));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDropShadow "hello")
 * (feDropShadow nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDropShadow {:onClick f} "hello")
 * (feDropShadow #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDropShadow :#the-id.klass.other-klass "hello")
 * (feDropShadow :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feDropShadow = (function com$fulcrologic$fulcro$dom$feDropShadow(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70496 = arguments.length;
var i__4865__auto___70497 = (0);
while(true){
if((i__4865__auto___70497 < len__4864__auto___70496)){
args__4870__auto__.push((arguments[i__4865__auto___70497]));

var G__70498 = (i__4865__auto___70497 + (1));
i__4865__auto___70497 = G__70498;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feDropShadow.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feDropShadow.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68763 = conformed_args__65183__auto__;
var map__68763__$1 = cljs.core.__destructure_map(map__68763);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68763__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68763__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68763__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feDropShadow",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feDropShadow.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feDropShadow.cljs$lang$applyTo = (function (seq68757){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68757));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (th "hello")
 * (th nil "hello")
 * 
 * These two are made equivalent at compile time
 * (th {:onClick f} "hello")
 * (th #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (th :#the-id.klass.other-klass "hello")
 * (th :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.th = (function com$fulcrologic$fulcro$dom$th(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70500 = arguments.length;
var i__4865__auto___70501 = (0);
while(true){
if((i__4865__auto___70501 < len__4864__auto___70500)){
args__4870__auto__.push((arguments[i__4865__auto___70501]));

var G__70502 = (i__4865__auto___70501 + (1));
i__4865__auto___70501 = G__70502;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.th.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.th.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68769 = conformed_args__65183__auto__;
var map__68769__$1 = cljs.core.__destructure_map(map__68769);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68769__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68769__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68769__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("th",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.th.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.th.cljs$lang$applyTo = (function (seq68766){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68766));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (time "hello")
 * (time nil "hello")
 * 
 * These two are made equivalent at compile time
 * (time {:onClick f} "hello")
 * (time #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (time :#the-id.klass.other-klass "hello")
 * (time :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.time = (function com$fulcrologic$fulcro$dom$time(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70503 = arguments.length;
var i__4865__auto___70504 = (0);
while(true){
if((i__4865__auto___70504 < len__4864__auto___70503)){
args__4870__auto__.push((arguments[i__4865__auto___70504]));

var G__70505 = (i__4865__auto___70504 + (1));
i__4865__auto___70504 = G__70505;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.time.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.time.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68777 = conformed_args__65183__auto__;
var map__68777__$1 = cljs.core.__destructure_map(map__68777);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68777__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68777__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68777__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("time",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.time.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.time.cljs$lang$applyTo = (function (seq68773){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68773));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (optgroup "hello")
 * (optgroup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (optgroup {:onClick f} "hello")
 * (optgroup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (optgroup :#the-id.klass.other-klass "hello")
 * (optgroup :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.optgroup = (function com$fulcrologic$fulcro$dom$optgroup(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70506 = arguments.length;
var i__4865__auto___70507 = (0);
while(true){
if((i__4865__auto___70507 < len__4864__auto___70506)){
args__4870__auto__.push((arguments[i__4865__auto___70507]));

var G__70508 = (i__4865__auto___70507 + (1));
i__4865__auto___70507 = G__70508;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.optgroup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68783 = conformed_args__65183__auto__;
var map__68783__$1 = cljs.core.__destructure_map(map__68783);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68783__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68783__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68783__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("optgroup",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.optgroup.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.optgroup.cljs$lang$applyTo = (function (seq68782){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68782));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (iframe "hello")
 * (iframe nil "hello")
 * 
 * These two are made equivalent at compile time
 * (iframe {:onClick f} "hello")
 * (iframe #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (iframe :#the-id.klass.other-klass "hello")
 * (iframe :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.iframe = (function com$fulcrologic$fulcro$dom$iframe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70511 = arguments.length;
var i__4865__auto___70512 = (0);
while(true){
if((i__4865__auto___70512 < len__4864__auto___70511)){
args__4870__auto__.push((arguments[i__4865__auto___70512]));

var G__70513 = (i__4865__auto___70512 + (1));
i__4865__auto___70512 = G__70513;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.iframe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.iframe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68796 = conformed_args__65183__auto__;
var map__68796__$1 = cljs.core.__destructure_map(map__68796);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68796__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68796__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68796__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("iframe",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.iframe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.iframe.cljs$lang$applyTo = (function (seq68789){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68789));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (color-profile "hello")
 * (color-profile nil "hello")
 * 
 * These two are made equivalent at compile time
 * (color-profile {:onClick f} "hello")
 * (color-profile #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (color-profile :#the-id.klass.other-klass "hello")
 * (color-profile :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.color_profile = (function com$fulcrologic$fulcro$dom$color_profile(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70514 = arguments.length;
var i__4865__auto___70515 = (0);
while(true){
if((i__4865__auto___70515 < len__4864__auto___70514)){
args__4870__auto__.push((arguments[i__4865__auto___70515]));

var G__70516 = (i__4865__auto___70515 + (1));
i__4865__auto___70515 = G__70516;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.color_profile.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.color_profile.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68809 = conformed_args__65183__auto__;
var map__68809__$1 = cljs.core.__destructure_map(map__68809);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68809__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68809__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68809__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("color-profile",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.color_profile.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.color_profile.cljs$lang$applyTo = (function (seq68801){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68801));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (legend "hello")
 * (legend nil "hello")
 * 
 * These two are made equivalent at compile time
 * (legend {:onClick f} "hello")
 * (legend #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (legend :#the-id.klass.other-klass "hello")
 * (legend :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.legend = (function com$fulcrologic$fulcro$dom$legend(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70518 = arguments.length;
var i__4865__auto___70519 = (0);
while(true){
if((i__4865__auto___70519 < len__4864__auto___70518)){
args__4870__auto__.push((arguments[i__4865__auto___70519]));

var G__70521 = (i__4865__auto___70519 + (1));
i__4865__auto___70519 = G__70521;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.legend.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.legend.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68820 = conformed_args__65183__auto__;
var map__68820__$1 = cljs.core.__destructure_map(map__68820);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68820__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68820__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68820__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("legend",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.legend.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.legend.cljs$lang$applyTo = (function (seq68814){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68814));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (em "hello")
 * (em nil "hello")
 * 
 * These two are made equivalent at compile time
 * (em {:onClick f} "hello")
 * (em #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (em :#the-id.klass.other-klass "hello")
 * (em :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.em = (function com$fulcrologic$fulcro$dom$em(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70522 = arguments.length;
var i__4865__auto___70523 = (0);
while(true){
if((i__4865__auto___70523 < len__4864__auto___70522)){
args__4870__auto__.push((arguments[i__4865__auto___70523]));

var G__70524 = (i__4865__auto___70523 + (1));
i__4865__auto___70523 = G__70524;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.em.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.em.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68828 = conformed_args__65183__auto__;
var map__68828__$1 = cljs.core.__destructure_map(map__68828);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68828__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68828__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68828__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("em",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.em.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.em.cljs$lang$applyTo = (function (seq68826){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68826));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (kbd "hello")
 * (kbd nil "hello")
 * 
 * These two are made equivalent at compile time
 * (kbd {:onClick f} "hello")
 * (kbd #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (kbd :#the-id.klass.other-klass "hello")
 * (kbd :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.kbd = (function com$fulcrologic$fulcro$dom$kbd(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70526 = arguments.length;
var i__4865__auto___70527 = (0);
while(true){
if((i__4865__auto___70527 < len__4864__auto___70526)){
args__4870__auto__.push((arguments[i__4865__auto___70527]));

var G__70528 = (i__4865__auto___70527 + (1));
i__4865__auto___70527 = G__70528;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.kbd.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.kbd.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68832 = conformed_args__65183__auto__;
var map__68832__$1 = cljs.core.__destructure_map(map__68832);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68832__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68832__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68832__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("kbd",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.kbd.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.kbd.cljs$lang$applyTo = (function (seq68830){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68830));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (article "hello")
 * (article nil "hello")
 * 
 * These two are made equivalent at compile time
 * (article {:onClick f} "hello")
 * (article #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (article :#the-id.klass.other-klass "hello")
 * (article :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.article = (function com$fulcrologic$fulcro$dom$article(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70529 = arguments.length;
var i__4865__auto___70530 = (0);
while(true){
if((i__4865__auto___70530 < len__4864__auto___70529)){
args__4870__auto__.push((arguments[i__4865__auto___70530]));

var G__70531 = (i__4865__auto___70530 + (1));
i__4865__auto___70530 = G__70531;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.article.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.article.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68839 = conformed_args__65183__auto__;
var map__68839__$1 = cljs.core.__destructure_map(map__68839);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68839__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68839__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68839__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("article",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.article.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.article.cljs$lang$applyTo = (function (seq68833){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68833));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateColor "hello")
 * (animateColor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateColor {:onClick f} "hello")
 * (animateColor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateColor :#the-id.klass.other-klass "hello")
 * (animateColor :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.animateColor = (function com$fulcrologic$fulcro$dom$animateColor(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70532 = arguments.length;
var i__4865__auto___70533 = (0);
while(true){
if((i__4865__auto___70533 < len__4864__auto___70532)){
args__4870__auto__.push((arguments[i__4865__auto___70533]));

var G__70534 = (i__4865__auto___70533 + (1));
i__4865__auto___70533 = G__70534;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.animateColor.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.animateColor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68852 = conformed_args__65183__auto__;
var map__68852__$1 = cljs.core.__destructure_map(map__68852);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68852__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68852__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68852__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("animateColor",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.animateColor.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.animateColor.cljs$lang$applyTo = (function (seq68845){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68845));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (clipPath "hello")
 * (clipPath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (clipPath {:onClick f} "hello")
 * (clipPath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (clipPath :#the-id.klass.other-klass "hello")
 * (clipPath :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.clipPath = (function com$fulcrologic$fulcro$dom$clipPath(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70535 = arguments.length;
var i__4865__auto___70536 = (0);
while(true){
if((i__4865__auto___70536 < len__4864__auto___70535)){
args__4870__auto__.push((arguments[i__4865__auto___70536]));

var G__70537 = (i__4865__auto___70536 + (1));
i__4865__auto___70536 = G__70537;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.clipPath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68859 = conformed_args__65183__auto__;
var map__68859__$1 = cljs.core.__destructure_map(map__68859);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68859__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68859__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68859__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("clipPath",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.clipPath.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.clipPath.cljs$lang$applyTo = (function (seq68854){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68854));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (abbr "hello")
 * (abbr nil "hello")
 * 
 * These two are made equivalent at compile time
 * (abbr {:onClick f} "hello")
 * (abbr #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (abbr :#the-id.klass.other-klass "hello")
 * (abbr :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.abbr = (function com$fulcrologic$fulcro$dom$abbr(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70538 = arguments.length;
var i__4865__auto___70540 = (0);
while(true){
if((i__4865__auto___70540 < len__4864__auto___70538)){
args__4870__auto__.push((arguments[i__4865__auto___70540]));

var G__70541 = (i__4865__auto___70540 + (1));
i__4865__auto___70540 = G__70541;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.abbr.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.abbr.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68869 = conformed_args__65183__auto__;
var map__68869__$1 = cljs.core.__destructure_map(map__68869);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68869__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68869__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68869__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("abbr",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.abbr.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.abbr.cljs$lang$applyTo = (function (seq68865){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68865));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (altGlyphDef "hello")
 * (altGlyphDef nil "hello")
 * 
 * These two are made equivalent at compile time
 * (altGlyphDef {:onClick f} "hello")
 * (altGlyphDef #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (altGlyphDef :#the-id.klass.other-klass "hello")
 * (altGlyphDef :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.altGlyphDef = (function com$fulcrologic$fulcro$dom$altGlyphDef(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70542 = arguments.length;
var i__4865__auto___70543 = (0);
while(true){
if((i__4865__auto___70543 < len__4864__auto___70542)){
args__4870__auto__.push((arguments[i__4865__auto___70543]));

var G__70544 = (i__4865__auto___70543 + (1));
i__4865__auto___70543 = G__70544;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.altGlyphDef.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.altGlyphDef.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68878 = conformed_args__65183__auto__;
var map__68878__$1 = cljs.core.__destructure_map(map__68878);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68878__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68878__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68878__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("altGlyphDef",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.altGlyphDef.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.altGlyphDef.cljs$lang$applyTo = (function (seq68875){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68875));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshrow "hello")
 * (meshrow nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshrow {:onClick f} "hello")
 * (meshrow #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshrow :#the-id.klass.other-klass "hello")
 * (meshrow :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meshrow = (function com$fulcrologic$fulcro$dom$meshrow(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70545 = arguments.length;
var i__4865__auto___70546 = (0);
while(true){
if((i__4865__auto___70546 < len__4864__auto___70545)){
args__4870__auto__.push((arguments[i__4865__auto___70546]));

var G__70547 = (i__4865__auto___70546 + (1));
i__4865__auto___70546 = G__70547;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meshrow.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meshrow.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68889 = conformed_args__65183__auto__;
var map__68889__$1 = cljs.core.__destructure_map(map__68889);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68889__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68889__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68889__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meshrow",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.meshrow.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meshrow.cljs$lang$applyTo = (function (seq68883){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68883));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (cursor "hello")
 * (cursor nil "hello")
 * 
 * These two are made equivalent at compile time
 * (cursor {:onClick f} "hello")
 * (cursor #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (cursor :#the-id.klass.other-klass "hello")
 * (cursor :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.cursor = (function com$fulcrologic$fulcro$dom$cursor(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70550 = arguments.length;
var i__4865__auto___70551 = (0);
while(true){
if((i__4865__auto___70551 < len__4864__auto___70550)){
args__4870__auto__.push((arguments[i__4865__auto___70551]));

var G__70552 = (i__4865__auto___70551 + (1));
i__4865__auto___70551 = G__70552;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.cursor.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.cursor.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68893 = conformed_args__65183__auto__;
var map__68893__$1 = cljs.core.__destructure_map(map__68893);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68893__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68893__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68893__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("cursor",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.cursor.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.cursor.cljs$lang$applyTo = (function (seq68890){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68890));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animate "hello")
 * (animate nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animate {:onClick f} "hello")
 * (animate #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animate :#the-id.klass.other-klass "hello")
 * (animate :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.animate = (function com$fulcrologic$fulcro$dom$animate(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70556 = arguments.length;
var i__4865__auto___70557 = (0);
while(true){
if((i__4865__auto___70557 < len__4864__auto___70556)){
args__4870__auto__.push((arguments[i__4865__auto___70557]));

var G__70558 = (i__4865__auto___70557 + (1));
i__4865__auto___70557 = G__70558;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.animate.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.animate.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68903 = conformed_args__65183__auto__;
var map__68903__$1 = cljs.core.__destructure_map(map__68903);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68903__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68903__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68903__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("animate",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.animate.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.animate.cljs$lang$applyTo = (function (seq68898){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68898));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (source "hello")
 * (source nil "hello")
 * 
 * These two are made equivalent at compile time
 * (source {:onClick f} "hello")
 * (source #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (source :#the-id.klass.other-klass "hello")
 * (source :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.source = (function com$fulcrologic$fulcro$dom$source(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70561 = arguments.length;
var i__4865__auto___70563 = (0);
while(true){
if((i__4865__auto___70563 < len__4864__auto___70561)){
args__4870__auto__.push((arguments[i__4865__auto___70563]));

var G__70564 = (i__4865__auto___70563 + (1));
i__4865__auto___70563 = G__70564;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.source.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.source.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68906 = conformed_args__65183__auto__;
var map__68906__$1 = cljs.core.__destructure_map(map__68906);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68906__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68906__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68906__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("source",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.source.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.source.cljs$lang$applyTo = (function (seq68904){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68904));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (output "hello")
 * (output nil "hello")
 * 
 * These two are made equivalent at compile time
 * (output {:onClick f} "hello")
 * (output #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (output :#the-id.klass.other-klass "hello")
 * (output :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.output = (function com$fulcrologic$fulcro$dom$output(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70574 = arguments.length;
var i__4865__auto___70575 = (0);
while(true){
if((i__4865__auto___70575 < len__4864__auto___70574)){
args__4870__auto__.push((arguments[i__4865__auto___70575]));

var G__70580 = (i__4865__auto___70575 + (1));
i__4865__auto___70575 = G__70580;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.output.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.output.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68916 = conformed_args__65183__auto__;
var map__68916__$1 = cljs.core.__destructure_map(map__68916);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68916__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68916__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68916__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("output",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.output.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.output.cljs$lang$applyTo = (function (seq68910){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68910));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face "hello")
 * (font-face nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face {:onClick f} "hello")
 * (font-face #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face :#the-id.klass.other-klass "hello")
 * (font-face :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face = (function com$fulcrologic$fulcro$dom$font_face(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70583 = arguments.length;
var i__4865__auto___70584 = (0);
while(true){
if((i__4865__auto___70584 < len__4864__auto___70583)){
args__4870__auto__.push((arguments[i__4865__auto___70584]));

var G__70585 = (i__4865__auto___70584 + (1));
i__4865__auto___70584 = G__70585;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68924 = conformed_args__65183__auto__;
var map__68924__$1 = cljs.core.__destructure_map(map__68924);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68924__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68924__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68924__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face.cljs$lang$applyTo = (function (seq68917){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68917));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMergeNode "hello")
 * (feMergeNode nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMergeNode {:onClick f} "hello")
 * (feMergeNode #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMergeNode :#the-id.klass.other-klass "hello")
 * (feMergeNode :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feMergeNode = (function com$fulcrologic$fulcro$dom$feMergeNode(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70586 = arguments.length;
var i__4865__auto___70587 = (0);
while(true){
if((i__4865__auto___70587 < len__4864__auto___70586)){
args__4870__auto__.push((arguments[i__4865__auto___70587]));

var G__70588 = (i__4865__auto___70587 + (1));
i__4865__auto___70587 = G__70588;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feMergeNode.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feMergeNode.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68929 = conformed_args__65183__auto__;
var map__68929__$1 = cljs.core.__destructure_map(map__68929);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68929__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68929__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68929__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feMergeNode",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feMergeNode.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feMergeNode.cljs$lang$applyTo = (function (seq68928){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68928));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feSpotLight "hello")
 * (feSpotLight nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feSpotLight {:onClick f} "hello")
 * (feSpotLight #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feSpotLight :#the-id.klass.other-klass "hello")
 * (feSpotLight :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feSpotLight = (function com$fulcrologic$fulcro$dom$feSpotLight(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70590 = arguments.length;
var i__4865__auto___70591 = (0);
while(true){
if((i__4865__auto___70591 < len__4864__auto___70590)){
args__4870__auto__.push((arguments[i__4865__auto___70591]));

var G__70592 = (i__4865__auto___70591 + (1));
i__4865__auto___70591 = G__70592;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feSpotLight.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feSpotLight.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68938 = conformed_args__65183__auto__;
var map__68938__$1 = cljs.core.__destructure_map(map__68938);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68938__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68938__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68938__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feSpotLight",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feSpotLight.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feSpotLight.cljs$lang$applyTo = (function (seq68935){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68935));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (header "hello")
 * (header nil "hello")
 * 
 * These two are made equivalent at compile time
 * (header {:onClick f} "hello")
 * (header #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (header :#the-id.klass.other-klass "hello")
 * (header :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.header = (function com$fulcrologic$fulcro$dom$header(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70594 = arguments.length;
var i__4865__auto___70595 = (0);
while(true){
if((i__4865__auto___70595 < len__4864__auto___70594)){
args__4870__auto__.push((arguments[i__4865__auto___70595]));

var G__70596 = (i__4865__auto___70595 + (1));
i__4865__auto___70595 = G__70596;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.header.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.header.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68947 = conformed_args__65183__auto__;
var map__68947__$1 = cljs.core.__destructure_map(map__68947);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68947__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68947__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68947__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("header",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.header.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.header.cljs$lang$applyTo = (function (seq68943){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68943));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (datalist "hello")
 * (datalist nil "hello")
 * 
 * These two are made equivalent at compile time
 * (datalist {:onClick f} "hello")
 * (datalist #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (datalist :#the-id.klass.other-klass "hello")
 * (datalist :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.datalist = (function com$fulcrologic$fulcro$dom$datalist(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70602 = arguments.length;
var i__4865__auto___70603 = (0);
while(true){
if((i__4865__auto___70603 < len__4864__auto___70602)){
args__4870__auto__.push((arguments[i__4865__auto___70603]));

var G__70604 = (i__4865__auto___70603 + (1));
i__4865__auto___70603 = G__70604;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.datalist.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.datalist.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68954 = conformed_args__65183__auto__;
var map__68954__$1 = cljs.core.__destructure_map(map__68954);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68954__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68954__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68954__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("datalist",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.datalist.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.datalist.cljs$lang$applyTo = (function (seq68951){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68951));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tfoot "hello")
 * (tfoot nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tfoot {:onClick f} "hello")
 * (tfoot #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tfoot :#the-id.klass.other-klass "hello")
 * (tfoot :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tfoot = (function com$fulcrologic$fulcro$dom$tfoot(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70605 = arguments.length;
var i__4865__auto___70606 = (0);
while(true){
if((i__4865__auto___70606 < len__4864__auto___70605)){
args__4870__auto__.push((arguments[i__4865__auto___70606]));

var G__70607 = (i__4865__auto___70606 + (1));
i__4865__auto___70606 = G__70607;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tfoot.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68962 = conformed_args__65183__auto__;
var map__68962__$1 = cljs.core.__destructure_map(map__68962);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68962__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68962__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68962__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tfoot",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.tfoot.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tfoot.cljs$lang$applyTo = (function (seq68956){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68956));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (s "hello")
 * (s nil "hello")
 * 
 * These two are made equivalent at compile time
 * (s {:onClick f} "hello")
 * (s #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (s :#the-id.klass.other-klass "hello")
 * (s :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.s = (function com$fulcrologic$fulcro$dom$s(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70609 = arguments.length;
var i__4865__auto___70610 = (0);
while(true){
if((i__4865__auto___70610 < len__4864__auto___70609)){
args__4870__auto__.push((arguments[i__4865__auto___70610]));

var G__70611 = (i__4865__auto___70610 + (1));
i__4865__auto___70610 = G__70611;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.s.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.s.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68970 = conformed_args__65183__auto__;
var map__68970__$1 = cljs.core.__destructure_map(map__68970);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68970__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68970__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68970__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("s",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.s.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.s.cljs$lang$applyTo = (function (seq68964){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68964));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (hatch "hello")
 * (hatch nil "hello")
 * 
 * These two are made equivalent at compile time
 * (hatch {:onClick f} "hello")
 * (hatch #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (hatch :#the-id.klass.other-klass "hello")
 * (hatch :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.hatch = (function com$fulcrologic$fulcro$dom$hatch(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70612 = arguments.length;
var i__4865__auto___70613 = (0);
while(true){
if((i__4865__auto___70613 < len__4864__auto___70612)){
args__4870__auto__.push((arguments[i__4865__auto___70613]));

var G__70614 = (i__4865__auto___70613 + (1));
i__4865__auto___70613 = G__70614;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.hatch.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.hatch.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68978 = conformed_args__65183__auto__;
var map__68978__$1 = cljs.core.__destructure_map(map__68978);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68978__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68978__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68978__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("hatch",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.hatch.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.hatch.cljs$lang$applyTo = (function (seq68972){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68972));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ins "hello")
 * (ins nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ins {:onClick f} "hello")
 * (ins #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ins :#the-id.klass.other-klass "hello")
 * (ins :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ins = (function com$fulcrologic$fulcro$dom$ins(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70616 = arguments.length;
var i__4865__auto___70617 = (0);
while(true){
if((i__4865__auto___70617 < len__4864__auto___70616)){
args__4870__auto__.push((arguments[i__4865__auto___70617]));

var G__70618 = (i__4865__auto___70617 + (1));
i__4865__auto___70617 = G__70618;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ins.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ins.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__68985 = conformed_args__65183__auto__;
var map__68985__$1 = cljs.core.__destructure_map(map__68985);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68985__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68985__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68985__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ins",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.ins.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ins.cljs$lang$applyTo = (function (seq68982){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68982));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (footer "hello")
 * (footer nil "hello")
 * 
 * These two are made equivalent at compile time
 * (footer {:onClick f} "hello")
 * (footer #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (footer :#the-id.klass.other-klass "hello")
 * (footer :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.footer = (function com$fulcrologic$fulcro$dom$footer(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70621 = arguments.length;
var i__4865__auto___70622 = (0);
while(true){
if((i__4865__auto___70622 < len__4864__auto___70621)){
args__4870__auto__.push((arguments[i__4865__auto___70622]));

var G__70623 = (i__4865__auto___70622 + (1));
i__4865__auto___70622 = G__70623;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.footer.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.footer.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69002 = conformed_args__65183__auto__;
var map__69002__$1 = cljs.core.__destructure_map(map__69002);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69002__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69002__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69002__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("footer",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.footer.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.footer.cljs$lang$applyTo = (function (seq68993){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq68993));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mpath "hello")
 * (mpath nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mpath {:onClick f} "hello")
 * (mpath #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mpath :#the-id.klass.other-klass "hello")
 * (mpath :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.mpath = (function com$fulcrologic$fulcro$dom$mpath(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70624 = arguments.length;
var i__4865__auto___70625 = (0);
while(true){
if((i__4865__auto___70625 < len__4864__auto___70624)){
args__4870__auto__.push((arguments[i__4865__auto___70625]));

var G__70627 = (i__4865__auto___70625 + (1));
i__4865__auto___70625 = G__70627;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.mpath.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.mpath.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69016 = conformed_args__65183__auto__;
var map__69016__$1 = cljs.core.__destructure_map(map__69016);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69016__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69016__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69016__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("mpath",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.mpath.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.mpath.cljs$lang$applyTo = (function (seq69009){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69009));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (title "hello")
 * (title nil "hello")
 * 
 * These two are made equivalent at compile time
 * (title {:onClick f} "hello")
 * (title #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (title :#the-id.klass.other-klass "hello")
 * (title :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.title = (function com$fulcrologic$fulcro$dom$title(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70628 = arguments.length;
var i__4865__auto___70629 = (0);
while(true){
if((i__4865__auto___70629 < len__4864__auto___70628)){
args__4870__auto__.push((arguments[i__4865__auto___70629]));

var G__70631 = (i__4865__auto___70629 + (1));
i__4865__auto___70629 = G__70631;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.title.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.title.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69024 = conformed_args__65183__auto__;
var map__69024__$1 = cljs.core.__destructure_map(map__69024);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69024__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69024__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69024__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("title",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.title.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.title.cljs$lang$applyTo = (function (seq69019){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69019));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h5 "hello")
 * (h5 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h5 {:onClick f} "hello")
 * (h5 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h5 :#the-id.klass.other-klass "hello")
 * (h5 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h5 = (function com$fulcrologic$fulcro$dom$h5(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70634 = arguments.length;
var i__4865__auto___70635 = (0);
while(true){
if((i__4865__auto___70635 < len__4864__auto___70634)){
args__4870__auto__.push((arguments[i__4865__auto___70635]));

var G__70636 = (i__4865__auto___70635 + (1));
i__4865__auto___70635 = G__70636;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h5.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h5.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69032 = conformed_args__65183__auto__;
var map__69032__$1 = cljs.core.__destructure_map(map__69032);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69032__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69032__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69032__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h5",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.h5.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h5.cljs$lang$applyTo = (function (seq69025){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69025));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meshgradient "hello")
 * (meshgradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meshgradient {:onClick f} "hello")
 * (meshgradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meshgradient :#the-id.klass.other-klass "hello")
 * (meshgradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meshgradient = (function com$fulcrologic$fulcro$dom$meshgradient(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70637 = arguments.length;
var i__4865__auto___70638 = (0);
while(true){
if((i__4865__auto___70638 < len__4864__auto___70637)){
args__4870__auto__.push((arguments[i__4865__auto___70638]));

var G__70639 = (i__4865__auto___70638 + (1));
i__4865__auto___70638 = G__70639;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meshgradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meshgradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69039 = conformed_args__65183__auto__;
var map__69039__$1 = cljs.core.__destructure_map(map__69039);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69039__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69039__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69039__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meshgradient",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.meshgradient.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meshgradient.cljs$lang$applyTo = (function (seq69036){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69036));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (canvas "hello")
 * (canvas nil "hello")
 * 
 * These two are made equivalent at compile time
 * (canvas {:onClick f} "hello")
 * (canvas #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (canvas :#the-id.klass.other-klass "hello")
 * (canvas :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.canvas = (function com$fulcrologic$fulcro$dom$canvas(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70640 = arguments.length;
var i__4865__auto___70641 = (0);
while(true){
if((i__4865__auto___70641 < len__4864__auto___70640)){
args__4870__auto__.push((arguments[i__4865__auto___70641]));

var G__70642 = (i__4865__auto___70641 + (1));
i__4865__auto___70641 = G__70642;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.canvas.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.canvas.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69048 = conformed_args__65183__auto__;
var map__69048__$1 = cljs.core.__destructure_map(map__69048);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69048__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69048__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69048__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("canvas",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.canvas.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.canvas.cljs$lang$applyTo = (function (seq69047){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69047));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (param "hello")
 * (param nil "hello")
 * 
 * These two are made equivalent at compile time
 * (param {:onClick f} "hello")
 * (param #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (param :#the-id.klass.other-klass "hello")
 * (param :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.param = (function com$fulcrologic$fulcro$dom$param(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70647 = arguments.length;
var i__4865__auto___70648 = (0);
while(true){
if((i__4865__auto___70648 < len__4864__auto___70647)){
args__4870__auto__.push((arguments[i__4865__auto___70648]));

var G__70649 = (i__4865__auto___70648 + (1));
i__4865__auto___70648 = G__70649;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.param.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.param.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69056 = conformed_args__65183__auto__;
var map__69056__$1 = cljs.core.__destructure_map(map__69056);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69056__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69056__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69056__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("param",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.param.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.param.cljs$lang$applyTo = (function (seq69052){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69052));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font "hello")
 * (font nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font {:onClick f} "hello")
 * (font #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font :#the-id.klass.other-klass "hello")
 * (font :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font = (function com$fulcrologic$fulcro$dom$font(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70653 = arguments.length;
var i__4865__auto___70654 = (0);
while(true){
if((i__4865__auto___70654 < len__4864__auto___70653)){
args__4870__auto__.push((arguments[i__4865__auto___70654]));

var G__70655 = (i__4865__auto___70654 + (1));
i__4865__auto___70654 = G__70655;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69063 = conformed_args__65183__auto__;
var map__69063__$1 = cljs.core.__destructure_map(map__69063);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69063__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69063__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69063__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.font.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font.cljs$lang$applyTo = (function (seq69062){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69062));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (div "hello")
 * (div nil "hello")
 * 
 * These two are made equivalent at compile time
 * (div {:onClick f} "hello")
 * (div #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (div :#the-id.klass.other-klass "hello")
 * (div :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.div = (function com$fulcrologic$fulcro$dom$div(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70658 = arguments.length;
var i__4865__auto___70659 = (0);
while(true){
if((i__4865__auto___70659 < len__4864__auto___70658)){
args__4870__auto__.push((arguments[i__4865__auto___70659]));

var G__70660 = (i__4865__auto___70659 + (1));
i__4865__auto___70659 = G__70660;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.div.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.div.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69073 = conformed_args__65183__auto__;
var map__69073__$1 = cljs.core.__destructure_map(map__69073);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69073__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69073__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69073__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("div",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.div.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.div.cljs$lang$applyTo = (function (seq69067){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69067));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (option "hello")
 * (option nil "hello")
 * 
 * These two are made equivalent at compile time
 * (option {:onClick f} "hello")
 * (option #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (option :#the-id.klass.other-klass "hello")
 * (option :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.option = (function com$fulcrologic$fulcro$dom$option(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70661 = arguments.length;
var i__4865__auto___70662 = (0);
while(true){
if((i__4865__auto___70662 < len__4864__auto___70661)){
args__4870__auto__.push((arguments[i__4865__auto___70662]));

var G__70663 = (i__4865__auto___70662 + (1));
i__4865__auto___70662 = G__70663;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.option.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.option.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69082 = conformed_args__65183__auto__;
var map__69082__$1 = cljs.core.__destructure_map(map__69082);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69082__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69082__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69082__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("option",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.option.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.option.cljs$lang$applyTo = (function (seq69080){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69080));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feFlood "hello")
 * (feFlood nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feFlood {:onClick f} "hello")
 * (feFlood #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feFlood :#the-id.klass.other-klass "hello")
 * (feFlood :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feFlood = (function com$fulcrologic$fulcro$dom$feFlood(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70664 = arguments.length;
var i__4865__auto___70665 = (0);
while(true){
if((i__4865__auto___70665 < len__4864__auto___70664)){
args__4870__auto__.push((arguments[i__4865__auto___70665]));

var G__70666 = (i__4865__auto___70665 + (1));
i__4865__auto___70665 = G__70666;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feFlood.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feFlood.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69095 = conformed_args__65183__auto__;
var map__69095__$1 = cljs.core.__destructure_map(map__69095);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69095__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69095__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69095__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feFlood",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feFlood.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feFlood.cljs$lang$applyTo = (function (seq69088){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69088));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (summary "hello")
 * (summary nil "hello")
 * 
 * These two are made equivalent at compile time
 * (summary {:onClick f} "hello")
 * (summary #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (summary :#the-id.klass.other-klass "hello")
 * (summary :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.summary = (function com$fulcrologic$fulcro$dom$summary(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70676 = arguments.length;
var i__4865__auto___70677 = (0);
while(true){
if((i__4865__auto___70677 < len__4864__auto___70676)){
args__4870__auto__.push((arguments[i__4865__auto___70677]));

var G__70678 = (i__4865__auto___70677 + (1));
i__4865__auto___70677 = G__70678;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.summary.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.summary.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69103 = conformed_args__65183__auto__;
var map__69103__$1 = cljs.core.__destructure_map(map__69103);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69103__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69103__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69103__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("summary",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.summary.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.summary.cljs$lang$applyTo = (function (seq69102){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69102));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feMorphology "hello")
 * (feMorphology nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feMorphology {:onClick f} "hello")
 * (feMorphology #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feMorphology :#the-id.klass.other-klass "hello")
 * (feMorphology :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feMorphology = (function com$fulcrologic$fulcro$dom$feMorphology(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70684 = arguments.length;
var i__4865__auto___70685 = (0);
while(true){
if((i__4865__auto___70685 < len__4864__auto___70684)){
args__4870__auto__.push((arguments[i__4865__auto___70685]));

var G__70686 = (i__4865__auto___70685 + (1));
i__4865__auto___70685 = G__70686;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feMorphology.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feMorphology.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69111 = conformed_args__65183__auto__;
var map__69111__$1 = cljs.core.__destructure_map(map__69111);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69111__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69111__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69111__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feMorphology",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feMorphology.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feMorphology.cljs$lang$applyTo = (function (seq69105){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69105));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (samp "hello")
 * (samp nil "hello")
 * 
 * These two are made equivalent at compile time
 * (samp {:onClick f} "hello")
 * (samp #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (samp :#the-id.klass.other-klass "hello")
 * (samp :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.samp = (function com$fulcrologic$fulcro$dom$samp(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70693 = arguments.length;
var i__4865__auto___70694 = (0);
while(true){
if((i__4865__auto___70694 < len__4864__auto___70693)){
args__4870__auto__.push((arguments[i__4865__auto___70694]));

var G__70695 = (i__4865__auto___70694 + (1));
i__4865__auto___70694 = G__70695;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.samp.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.samp.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69117 = conformed_args__65183__auto__;
var map__69117__$1 = cljs.core.__destructure_map(map__69117);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69117__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69117__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69117__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("samp",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.samp.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.samp.cljs$lang$applyTo = (function (seq69116){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69116));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (glyphRef "hello")
 * (glyphRef nil "hello")
 * 
 * These two are made equivalent at compile time
 * (glyphRef {:onClick f} "hello")
 * (glyphRef #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (glyphRef :#the-id.klass.other-klass "hello")
 * (glyphRef :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.glyphRef = (function com$fulcrologic$fulcro$dom$glyphRef(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70699 = arguments.length;
var i__4865__auto___70700 = (0);
while(true){
if((i__4865__auto___70700 < len__4864__auto___70699)){
args__4870__auto__.push((arguments[i__4865__auto___70700]));

var G__70701 = (i__4865__auto___70700 + (1));
i__4865__auto___70700 = G__70701;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.glyphRef.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.glyphRef.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69124 = conformed_args__65183__auto__;
var map__69124__$1 = cljs.core.__destructure_map(map__69124);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69124__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69124__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69124__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("glyphRef",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.glyphRef.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.glyphRef.cljs$lang$applyTo = (function (seq69123){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69123));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (small "hello")
 * (small nil "hello")
 * 
 * These two are made equivalent at compile time
 * (small {:onClick f} "hello")
 * (small #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (small :#the-id.klass.other-klass "hello")
 * (small :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.small = (function com$fulcrologic$fulcro$dom$small(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70702 = arguments.length;
var i__4865__auto___70703 = (0);
while(true){
if((i__4865__auto___70703 < len__4864__auto___70702)){
args__4870__auto__.push((arguments[i__4865__auto___70703]));

var G__70704 = (i__4865__auto___70703 + (1));
i__4865__auto___70703 = G__70704;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.small.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.small.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69147 = conformed_args__65183__auto__;
var map__69147__$1 = cljs.core.__destructure_map(map__69147);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69147__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69147__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69147__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("small",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.small.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.small.cljs$lang$applyTo = (function (seq69140){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69140));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (style "hello")
 * (style nil "hello")
 * 
 * These two are made equivalent at compile time
 * (style {:onClick f} "hello")
 * (style #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (style :#the-id.klass.other-klass "hello")
 * (style :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.style = (function com$fulcrologic$fulcro$dom$style(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70705 = arguments.length;
var i__4865__auto___70706 = (0);
while(true){
if((i__4865__auto___70706 < len__4864__auto___70705)){
args__4870__auto__.push((arguments[i__4865__auto___70706]));

var G__70707 = (i__4865__auto___70706 + (1));
i__4865__auto___70706 = G__70707;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.style.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.style.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69155 = conformed_args__65183__auto__;
var map__69155__$1 = cljs.core.__destructure_map(map__69155);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69155__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69155__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69155__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("style",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.style.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.style.cljs$lang$applyTo = (function (seq69151){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69151));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (textarea "hello")
 * (textarea nil "hello")
 * 
 * These two are made equivalent at compile time
 * (textarea {:onClick f} "hello")
 * (textarea #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (textarea :#the-id.klass.other-klass "hello")
 * (textarea :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.textarea = (function com$fulcrologic$fulcro$dom$textarea(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70708 = arguments.length;
var i__4865__auto___70709 = (0);
while(true){
if((i__4865__auto___70709 < len__4864__auto___70708)){
args__4870__auto__.push((arguments[i__4865__auto___70709]));

var G__70710 = (i__4865__auto___70709 + (1));
i__4865__auto___70709 = G__70710;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.textarea.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.textarea.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69167 = conformed_args__65183__auto__;
var map__69167__$1 = cljs.core.__destructure_map(map__69167);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69167__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69167__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69167__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("textarea",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.textarea.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.textarea.cljs$lang$applyTo = (function (seq69163){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69163));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feGaussianBlur "hello")
 * (feGaussianBlur nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feGaussianBlur {:onClick f} "hello")
 * (feGaussianBlur #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feGaussianBlur :#the-id.klass.other-klass "hello")
 * (feGaussianBlur :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feGaussianBlur = (function com$fulcrologic$fulcro$dom$feGaussianBlur(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70711 = arguments.length;
var i__4865__auto___70712 = (0);
while(true){
if((i__4865__auto___70712 < len__4864__auto___70711)){
args__4870__auto__.push((arguments[i__4865__auto___70712]));

var G__70713 = (i__4865__auto___70712 + (1));
i__4865__auto___70712 = G__70713;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feGaussianBlur.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feGaussianBlur.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69181 = conformed_args__65183__auto__;
var map__69181__$1 = cljs.core.__destructure_map(map__69181);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69181__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69181__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69181__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feGaussianBlur",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feGaussianBlur.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feGaussianBlur.cljs$lang$applyTo = (function (seq69172){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69172));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h4 "hello")
 * (h4 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h4 {:onClick f} "hello")
 * (h4 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h4 :#the-id.klass.other-klass "hello")
 * (h4 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h4 = (function com$fulcrologic$fulcro$dom$h4(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70715 = arguments.length;
var i__4865__auto___70716 = (0);
while(true){
if((i__4865__auto___70716 < len__4864__auto___70715)){
args__4870__auto__.push((arguments[i__4865__auto___70716]));

var G__70717 = (i__4865__auto___70716 + (1));
i__4865__auto___70716 = G__70717;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h4.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h4.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69187 = conformed_args__65183__auto__;
var map__69187__$1 = cljs.core.__destructure_map(map__69187);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69187__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69187__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69187__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h4",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.h4.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h4.cljs$lang$applyTo = (function (seq69182){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69182));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (head "hello")
 * (head nil "hello")
 * 
 * These two are made equivalent at compile time
 * (head {:onClick f} "hello")
 * (head #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (head :#the-id.klass.other-klass "hello")
 * (head :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.head = (function com$fulcrologic$fulcro$dom$head(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70719 = arguments.length;
var i__4865__auto___70720 = (0);
while(true){
if((i__4865__auto___70720 < len__4864__auto___70719)){
args__4870__auto__.push((arguments[i__4865__auto___70720]));

var G__70721 = (i__4865__auto___70720 + (1));
i__4865__auto___70720 = G__70721;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.head.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.head.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69194 = conformed_args__65183__auto__;
var map__69194__$1 = cljs.core.__destructure_map(map__69194);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69194__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69194__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69194__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("head",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.head.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.head.cljs$lang$applyTo = (function (seq69191){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69191));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (g "hello")
 * (g nil "hello")
 * 
 * These two are made equivalent at compile time
 * (g {:onClick f} "hello")
 * (g #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (g :#the-id.klass.other-klass "hello")
 * (g :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.g = (function com$fulcrologic$fulcro$dom$g(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70724 = arguments.length;
var i__4865__auto___70725 = (0);
while(true){
if((i__4865__auto___70725 < len__4864__auto___70724)){
args__4870__auto__.push((arguments[i__4865__auto___70725]));

var G__70726 = (i__4865__auto___70725 + (1));
i__4865__auto___70725 = G__70726;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.g.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.g.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69199 = conformed_args__65183__auto__;
var map__69199__$1 = cljs.core.__destructure_map(map__69199);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69199__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69199__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69199__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("g",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.g.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.g.cljs$lang$applyTo = (function (seq69196){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69196));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (missing-glyph "hello")
 * (missing-glyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (missing-glyph {:onClick f} "hello")
 * (missing-glyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (missing-glyph :#the-id.klass.other-klass "hello")
 * (missing-glyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.missing_glyph = (function com$fulcrologic$fulcro$dom$missing_glyph(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70727 = arguments.length;
var i__4865__auto___70728 = (0);
while(true){
if((i__4865__auto___70728 < len__4864__auto___70727)){
args__4870__auto__.push((arguments[i__4865__auto___70728]));

var G__70730 = (i__4865__auto___70728 + (1));
i__4865__auto___70728 = G__70730;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.missing_glyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.missing_glyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69206 = conformed_args__65183__auto__;
var map__69206__$1 = cljs.core.__destructure_map(map__69206);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69206__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69206__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69206__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("missing-glyph",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.missing_glyph.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.missing_glyph.cljs$lang$applyTo = (function (seq69205){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69205));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (stop "hello")
 * (stop nil "hello")
 * 
 * These two are made equivalent at compile time
 * (stop {:onClick f} "hello")
 * (stop #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (stop :#the-id.klass.other-klass "hello")
 * (stop :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.stop = (function com$fulcrologic$fulcro$dom$stop(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70735 = arguments.length;
var i__4865__auto___70736 = (0);
while(true){
if((i__4865__auto___70736 < len__4864__auto___70735)){
args__4870__auto__.push((arguments[i__4865__auto___70736]));

var G__70737 = (i__4865__auto___70736 + (1));
i__4865__auto___70736 = G__70737;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.stop.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.stop.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69211 = conformed_args__65183__auto__;
var map__69211__$1 = cljs.core.__destructure_map(map__69211);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69211__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69211__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69211__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("stop",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.stop.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.stop.cljs$lang$applyTo = (function (seq69209){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69209));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feDiffuseLighting "hello")
 * (feDiffuseLighting nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feDiffuseLighting {:onClick f} "hello")
 * (feDiffuseLighting #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feDiffuseLighting :#the-id.klass.other-klass "hello")
 * (feDiffuseLighting :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feDiffuseLighting = (function com$fulcrologic$fulcro$dom$feDiffuseLighting(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70746 = arguments.length;
var i__4865__auto___70747 = (0);
while(true){
if((i__4865__auto___70747 < len__4864__auto___70746)){
args__4870__auto__.push((arguments[i__4865__auto___70747]));

var G__70748 = (i__4865__auto___70747 + (1));
i__4865__auto___70747 = G__70748;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feDiffuseLighting.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feDiffuseLighting.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69215 = conformed_args__65183__auto__;
var map__69215__$1 = cljs.core.__destructure_map(map__69215);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69215__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69215__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69215__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feDiffuseLighting",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feDiffuseLighting.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feDiffuseLighting.cljs$lang$applyTo = (function (seq69213){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69213));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (filter "hello")
 * (filter nil "hello")
 * 
 * These two are made equivalent at compile time
 * (filter {:onClick f} "hello")
 * (filter #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (filter :#the-id.klass.other-klass "hello")
 * (filter :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.filter = (function com$fulcrologic$fulcro$dom$filter(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70751 = arguments.length;
var i__4865__auto___70752 = (0);
while(true){
if((i__4865__auto___70752 < len__4864__auto___70751)){
args__4870__auto__.push((arguments[i__4865__auto___70752]));

var G__70754 = (i__4865__auto___70752 + (1));
i__4865__auto___70752 = G__70754;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.filter.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.filter.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69220 = conformed_args__65183__auto__;
var map__69220__$1 = cljs.core.__destructure_map(map__69220);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69220__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69220__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69220__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("filter",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.filter.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.filter.cljs$lang$applyTo = (function (seq69218){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69218));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feComposite "hello")
 * (feComposite nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feComposite {:onClick f} "hello")
 * (feComposite #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feComposite :#the-id.klass.other-klass "hello")
 * (feComposite :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feComposite = (function com$fulcrologic$fulcro$dom$feComposite(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70756 = arguments.length;
var i__4865__auto___70757 = (0);
while(true){
if((i__4865__auto___70757 < len__4864__auto___70756)){
args__4870__auto__.push((arguments[i__4865__auto___70757]));

var G__70758 = (i__4865__auto___70757 + (1));
i__4865__auto___70757 = G__70758;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feComposite.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feComposite.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69224 = conformed_args__65183__auto__;
var map__69224__$1 = cljs.core.__destructure_map(map__69224);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69224__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69224__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69224__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feComposite",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feComposite.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feComposite.cljs$lang$applyTo = (function (seq69222){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69222));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (mesh "hello")
 * (mesh nil "hello")
 * 
 * These two are made equivalent at compile time
 * (mesh {:onClick f} "hello")
 * (mesh #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (mesh :#the-id.klass.other-klass "hello")
 * (mesh :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.mesh = (function com$fulcrologic$fulcro$dom$mesh(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70759 = arguments.length;
var i__4865__auto___70760 = (0);
while(true){
if((i__4865__auto___70760 < len__4864__auto___70759)){
args__4870__auto__.push((arguments[i__4865__auto___70760]));

var G__70761 = (i__4865__auto___70760 + (1));
i__4865__auto___70760 = G__70761;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.mesh.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.mesh.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69229 = conformed_args__65183__auto__;
var map__69229__$1 = cljs.core.__destructure_map(map__69229);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69229__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69229__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69229__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("mesh",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.mesh.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.mesh.cljs$lang$applyTo = (function (seq69227){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69227));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (var "hello")
 * (var nil "hello")
 * 
 * These two are made equivalent at compile time
 * (var {:onClick f} "hello")
 * (var #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (var :#the-id.klass.other-klass "hello")
 * (var :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.var$ = (function com$fulcrologic$fulcro$dom$var(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70763 = arguments.length;
var i__4865__auto___70764 = (0);
while(true){
if((i__4865__auto___70764 < len__4864__auto___70763)){
args__4870__auto__.push((arguments[i__4865__auto___70764]));

var G__70766 = (i__4865__auto___70764 + (1));
i__4865__auto___70764 = G__70766;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.var$.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.var$.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69239 = conformed_args__65183__auto__;
var map__69239__$1 = cljs.core.__destructure_map(map__69239);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69239__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69239__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69239__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("var",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.var$.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.var$.cljs$lang$applyTo = (function (seq69231){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69231));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (tspan "hello")
 * (tspan nil "hello")
 * 
 * These two are made equivalent at compile time
 * (tspan {:onClick f} "hello")
 * (tspan #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (tspan :#the-id.klass.other-klass "hello")
 * (tspan :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.tspan = (function com$fulcrologic$fulcro$dom$tspan(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70767 = arguments.length;
var i__4865__auto___70768 = (0);
while(true){
if((i__4865__auto___70768 < len__4864__auto___70767)){
args__4870__auto__.push((arguments[i__4865__auto___70768]));

var G__70769 = (i__4865__auto___70768 + (1));
i__4865__auto___70768 = G__70769;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.tspan.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.tspan.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69250 = conformed_args__65183__auto__;
var map__69250__$1 = cljs.core.__destructure_map(map__69250);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69250__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69250__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69250__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("tspan",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.tspan.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.tspan.cljs$lang$applyTo = (function (seq69245){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69245));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ol "hello")
 * (ol nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ol {:onClick f} "hello")
 * (ol #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ol :#the-id.klass.other-klass "hello")
 * (ol :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ol = (function com$fulcrologic$fulcro$dom$ol(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70774 = arguments.length;
var i__4865__auto___70775 = (0);
while(true){
if((i__4865__auto___70775 < len__4864__auto___70774)){
args__4870__auto__.push((arguments[i__4865__auto___70775]));

var G__70776 = (i__4865__auto___70775 + (1));
i__4865__auto___70775 = G__70776;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ol.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ol.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69258 = conformed_args__65183__auto__;
var map__69258__$1 = cljs.core.__destructure_map(map__69258);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69258__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69258__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69258__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ol",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.ol.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ol.cljs$lang$applyTo = (function (seq69254){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69254));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (details "hello")
 * (details nil "hello")
 * 
 * These two are made equivalent at compile time
 * (details {:onClick f} "hello")
 * (details #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (details :#the-id.klass.other-klass "hello")
 * (details :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.details = (function com$fulcrologic$fulcro$dom$details(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70779 = arguments.length;
var i__4865__auto___70780 = (0);
while(true){
if((i__4865__auto___70780 < len__4864__auto___70779)){
args__4870__auto__.push((arguments[i__4865__auto___70780]));

var G__70781 = (i__4865__auto___70780 + (1));
i__4865__auto___70780 = G__70781;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.details.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.details.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69271 = conformed_args__65183__auto__;
var map__69271__$1 = cljs.core.__destructure_map(map__69271);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69271__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69271__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69271__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("details",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.details.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.details.cljs$lang$applyTo = (function (seq69264){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69264));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (line "hello")
 * (line nil "hello")
 * 
 * These two are made equivalent at compile time
 * (line {:onClick f} "hello")
 * (line #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (line :#the-id.klass.other-klass "hello")
 * (line :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.line = (function com$fulcrologic$fulcro$dom$line(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70783 = arguments.length;
var i__4865__auto___70784 = (0);
while(true){
if((i__4865__auto___70784 < len__4864__auto___70783)){
args__4870__auto__.push((arguments[i__4865__auto___70784]));

var G__70785 = (i__4865__auto___70784 + (1));
i__4865__auto___70784 = G__70785;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.line.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.line.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69276 = conformed_args__65183__auto__;
var map__69276__$1 = cljs.core.__destructure_map(map__69276);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69276__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69276__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69276__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("line",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.line.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.line.cljs$lang$applyTo = (function (seq69273){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69273));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (col "hello")
 * (col nil "hello")
 * 
 * These two are made equivalent at compile time
 * (col {:onClick f} "hello")
 * (col #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (col :#the-id.klass.other-klass "hello")
 * (col :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.col = (function com$fulcrologic$fulcro$dom$col(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70788 = arguments.length;
var i__4865__auto___70789 = (0);
while(true){
if((i__4865__auto___70789 < len__4864__auto___70788)){
args__4870__auto__.push((arguments[i__4865__auto___70789]));

var G__70790 = (i__4865__auto___70789 + (1));
i__4865__auto___70789 = G__70790;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.col.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.col.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69284 = conformed_args__65183__auto__;
var map__69284__$1 = cljs.core.__destructure_map(map__69284);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69284__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69284__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69284__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("col",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.col.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.col.cljs$lang$applyTo = (function (seq69280){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69280));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (label "hello")
 * (label nil "hello")
 * 
 * These two are made equivalent at compile time
 * (label {:onClick f} "hello")
 * (label #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (label :#the-id.klass.other-klass "hello")
 * (label :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.label = (function com$fulcrologic$fulcro$dom$label(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70792 = arguments.length;
var i__4865__auto___70793 = (0);
while(true){
if((i__4865__auto___70793 < len__4864__auto___70792)){
args__4870__auto__.push((arguments[i__4865__auto___70793]));

var G__70794 = (i__4865__auto___70793 + (1));
i__4865__auto___70793 = G__70794;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.label.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.label.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69292 = conformed_args__65183__auto__;
var map__69292__$1 = cljs.core.__destructure_map(map__69292);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69292__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69292__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69292__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("label",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.label.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.label.cljs$lang$applyTo = (function (seq69288){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69288));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (picture "hello")
 * (picture nil "hello")
 * 
 * These two are made equivalent at compile time
 * (picture {:onClick f} "hello")
 * (picture #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (picture :#the-id.klass.other-klass "hello")
 * (picture :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.picture = (function com$fulcrologic$fulcro$dom$picture(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70795 = arguments.length;
var i__4865__auto___70796 = (0);
while(true){
if((i__4865__auto___70796 < len__4864__auto___70795)){
args__4870__auto__.push((arguments[i__4865__auto___70796]));

var G__70797 = (i__4865__auto___70796 + (1));
i__4865__auto___70796 = G__70797;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.picture.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.picture.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69298 = conformed_args__65183__auto__;
var map__69298__$1 = cljs.core.__destructure_map(map__69298);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69298__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69298__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69298__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("picture",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.picture.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.picture.cljs$lang$applyTo = (function (seq69295){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69295));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (rt "hello")
 * (rt nil "hello")
 * 
 * These two are made equivalent at compile time
 * (rt {:onClick f} "hello")
 * (rt #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (rt :#the-id.klass.other-klass "hello")
 * (rt :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.rt = (function com$fulcrologic$fulcro$dom$rt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70800 = arguments.length;
var i__4865__auto___70801 = (0);
while(true){
if((i__4865__auto___70801 < len__4864__auto___70800)){
args__4870__auto__.push((arguments[i__4865__auto___70801]));

var G__70802 = (i__4865__auto___70801 + (1));
i__4865__auto___70801 = G__70802;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.rt.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.rt.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69308 = conformed_args__65183__auto__;
var map__69308__$1 = cljs.core.__destructure_map(map__69308);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69308__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69308__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69308__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("rt",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.rt.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.rt.cljs$lang$applyTo = (function (seq69305){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69305));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h6 "hello")
 * (h6 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h6 {:onClick f} "hello")
 * (h6 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h6 :#the-id.klass.other-klass "hello")
 * (h6 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h6 = (function com$fulcrologic$fulcro$dom$h6(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70803 = arguments.length;
var i__4865__auto___70804 = (0);
while(true){
if((i__4865__auto___70804 < len__4864__auto___70803)){
args__4870__auto__.push((arguments[i__4865__auto___70804]));

var G__70805 = (i__4865__auto___70804 + (1));
i__4865__auto___70804 = G__70805;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h6.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h6.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69315 = conformed_args__65183__auto__;
var map__69315__$1 = cljs.core.__destructure_map(map__69315);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69315__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69315__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69315__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h6",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.h6.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h6.cljs$lang$applyTo = (function (seq69312){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69312));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (vkern "hello")
 * (vkern nil "hello")
 * 
 * These two are made equivalent at compile time
 * (vkern {:onClick f} "hello")
 * (vkern #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (vkern :#the-id.klass.other-klass "hello")
 * (vkern :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.vkern = (function com$fulcrologic$fulcro$dom$vkern(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70807 = arguments.length;
var i__4865__auto___70808 = (0);
while(true){
if((i__4865__auto___70808 < len__4864__auto___70807)){
args__4870__auto__.push((arguments[i__4865__auto___70808]));

var G__70809 = (i__4865__auto___70808 + (1));
i__4865__auto___70808 = G__70809;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.vkern.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.vkern.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69323 = conformed_args__65183__auto__;
var map__69323__$1 = cljs.core.__destructure_map(map__69323);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69323__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69323__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69323__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("vkern",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.vkern.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.vkern.cljs$lang$applyTo = (function (seq69321){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69321));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (link "hello")
 * (link nil "hello")
 * 
 * These two are made equivalent at compile time
 * (link {:onClick f} "hello")
 * (link #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (link :#the-id.klass.other-klass "hello")
 * (link :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.link = (function com$fulcrologic$fulcro$dom$link(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70811 = arguments.length;
var i__4865__auto___70812 = (0);
while(true){
if((i__4865__auto___70812 < len__4864__auto___70811)){
args__4870__auto__.push((arguments[i__4865__auto___70812]));

var G__70813 = (i__4865__auto___70812 + (1));
i__4865__auto___70812 = G__70813;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.link.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.link.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69331 = conformed_args__65183__auto__;
var map__69331__$1 = cljs.core.__destructure_map(map__69331);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69331__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69331__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69331__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("link",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.link.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.link.cljs$lang$applyTo = (function (seq69326){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69326));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (defs "hello")
 * (defs nil "hello")
 * 
 * These two are made equivalent at compile time
 * (defs {:onClick f} "hello")
 * (defs #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (defs :#the-id.klass.other-klass "hello")
 * (defs :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.defs = (function com$fulcrologic$fulcro$dom$defs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70820 = arguments.length;
var i__4865__auto___70821 = (0);
while(true){
if((i__4865__auto___70821 < len__4864__auto___70820)){
args__4870__auto__.push((arguments[i__4865__auto___70821]));

var G__70823 = (i__4865__auto___70821 + (1));
i__4865__auto___70821 = G__70823;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.defs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.defs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69339 = conformed_args__65183__auto__;
var map__69339__$1 = cljs.core.__destructure_map(map__69339);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69339__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69339__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69339__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("defs",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.defs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.defs.cljs$lang$applyTo = (function (seq69333){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69333));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (glyph "hello")
 * (glyph nil "hello")
 * 
 * These two are made equivalent at compile time
 * (glyph {:onClick f} "hello")
 * (glyph #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (glyph :#the-id.klass.other-klass "hello")
 * (glyph :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.glyph = (function com$fulcrologic$fulcro$dom$glyph(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70828 = arguments.length;
var i__4865__auto___70829 = (0);
while(true){
if((i__4865__auto___70829 < len__4864__auto___70828)){
args__4870__auto__.push((arguments[i__4865__auto___70829]));

var G__70831 = (i__4865__auto___70829 + (1));
i__4865__auto___70829 = G__70831;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.glyph.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.glyph.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69344 = conformed_args__65183__auto__;
var map__69344__$1 = cljs.core.__destructure_map(map__69344);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69344__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69344__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69344__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("glyph",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.glyph.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.glyph.cljs$lang$applyTo = (function (seq69343){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69343));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (colgroup "hello")
 * (colgroup nil "hello")
 * 
 * These two are made equivalent at compile time
 * (colgroup {:onClick f} "hello")
 * (colgroup #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (colgroup :#the-id.klass.other-klass "hello")
 * (colgroup :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.colgroup = (function com$fulcrologic$fulcro$dom$colgroup(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70837 = arguments.length;
var i__4865__auto___70838 = (0);
while(true){
if((i__4865__auto___70838 < len__4864__auto___70837)){
args__4870__auto__.push((arguments[i__4865__auto___70838]));

var G__70840 = (i__4865__auto___70838 + (1));
i__4865__auto___70838 = G__70840;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.colgroup.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69361 = conformed_args__65183__auto__;
var map__69361__$1 = cljs.core.__destructure_map(map__69361);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69361__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69361__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69361__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("colgroup",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.colgroup.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.colgroup.cljs$lang$applyTo = (function (seq69358){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69358));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (meter "hello")
 * (meter nil "hello")
 * 
 * These two are made equivalent at compile time
 * (meter {:onClick f} "hello")
 * (meter #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (meter :#the-id.klass.other-klass "hello")
 * (meter :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.meter = (function com$fulcrologic$fulcro$dom$meter(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70841 = arguments.length;
var i__4865__auto___70842 = (0);
while(true){
if((i__4865__auto___70842 < len__4864__auto___70841)){
args__4870__auto__.push((arguments[i__4865__auto___70842]));

var G__70843 = (i__4865__auto___70842 + (1));
i__4865__auto___70842 = G__70843;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.meter.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.meter.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69375 = conformed_args__65183__auto__;
var map__69375__$1 = cljs.core.__destructure_map(map__69375);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69375__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69375__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69375__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("meter",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.meter.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.meter.cljs$lang$applyTo = (function (seq69365){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69365));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (bdo "hello")
 * (bdo nil "hello")
 * 
 * These two are made equivalent at compile time
 * (bdo {:onClick f} "hello")
 * (bdo #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (bdo :#the-id.klass.other-klass "hello")
 * (bdo :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.bdo = (function com$fulcrologic$fulcro$dom$bdo(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70848 = arguments.length;
var i__4865__auto___70849 = (0);
while(true){
if((i__4865__auto___70849 < len__4864__auto___70848)){
args__4870__auto__.push((arguments[i__4865__auto___70849]));

var G__70850 = (i__4865__auto___70849 + (1));
i__4865__auto___70849 = G__70850;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.bdo.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.bdo.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69386 = conformed_args__65183__auto__;
var map__69386__$1 = cljs.core.__destructure_map(map__69386);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69386__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69386__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69386__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("bdo",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.bdo.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.bdo.cljs$lang$applyTo = (function (seq69381){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69381));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feImage "hello")
 * (feImage nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feImage {:onClick f} "hello")
 * (feImage #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feImage :#the-id.klass.other-klass "hello")
 * (feImage :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feImage = (function com$fulcrologic$fulcro$dom$feImage(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70851 = arguments.length;
var i__4865__auto___70852 = (0);
while(true){
if((i__4865__auto___70852 < len__4864__auto___70851)){
args__4870__auto__.push((arguments[i__4865__auto___70852]));

var G__70853 = (i__4865__auto___70852 + (1));
i__4865__auto___70852 = G__70853;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feImage.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feImage.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69397 = conformed_args__65183__auto__;
var map__69397__$1 = cljs.core.__destructure_map(map__69397);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69397__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69397__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69397__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feImage",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feImage.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feImage.cljs$lang$applyTo = (function (seq69396){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69396));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (b "hello")
 * (b nil "hello")
 * 
 * These two are made equivalent at compile time
 * (b {:onClick f} "hello")
 * (b #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (b :#the-id.klass.other-klass "hello")
 * (b :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.b = (function com$fulcrologic$fulcro$dom$b(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70855 = arguments.length;
var i__4865__auto___70856 = (0);
while(true){
if((i__4865__auto___70856 < len__4864__auto___70855)){
args__4870__auto__.push((arguments[i__4865__auto___70856]));

var G__70857 = (i__4865__auto___70856 + (1));
i__4865__auto___70856 = G__70857;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.b.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.b.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69405 = conformed_args__65183__auto__;
var map__69405__$1 = cljs.core.__destructure_map(map__69405);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69405__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69405__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69405__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("b",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.b.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.b.cljs$lang$applyTo = (function (seq69400){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69400));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (svg "hello")
 * (svg nil "hello")
 * 
 * These two are made equivalent at compile time
 * (svg {:onClick f} "hello")
 * (svg #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (svg :#the-id.klass.other-klass "hello")
 * (svg :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.svg = (function com$fulcrologic$fulcro$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70862 = arguments.length;
var i__4865__auto___70863 = (0);
while(true){
if((i__4865__auto___70863 < len__4864__auto___70862)){
args__4870__auto__.push((arguments[i__4865__auto___70863]));

var G__70864 = (i__4865__auto___70863 + (1));
i__4865__auto___70863 = G__70864;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.svg.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69411 = conformed_args__65183__auto__;
var map__69411__$1 = cljs.core.__destructure_map(map__69411);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69411__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69411__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69411__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("svg",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.svg.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.svg.cljs$lang$applyTo = (function (seq69410){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69410));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feTile "hello")
 * (feTile nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feTile {:onClick f} "hello")
 * (feTile #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feTile :#the-id.klass.other-klass "hello")
 * (feTile :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feTile = (function com$fulcrologic$fulcro$dom$feTile(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70868 = arguments.length;
var i__4865__auto___70869 = (0);
while(true){
if((i__4865__auto___70869 < len__4864__auto___70868)){
args__4870__auto__.push((arguments[i__4865__auto___70869]));

var G__70871 = (i__4865__auto___70869 + (1));
i__4865__auto___70869 = G__70871;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feTile.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feTile.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69419 = conformed_args__65183__auto__;
var map__69419__$1 = cljs.core.__destructure_map(map__69419);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69419__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69419__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69419__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feTile",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feTile.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feTile.cljs$lang$applyTo = (function (seq69414){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69414));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (ellipse "hello")
 * (ellipse nil "hello")
 * 
 * These two are made equivalent at compile time
 * (ellipse {:onClick f} "hello")
 * (ellipse #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (ellipse :#the-id.klass.other-klass "hello")
 * (ellipse :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.ellipse = (function com$fulcrologic$fulcro$dom$ellipse(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70874 = arguments.length;
var i__4865__auto___70875 = (0);
while(true){
if((i__4865__auto___70875 < len__4864__auto___70874)){
args__4870__auto__.push((arguments[i__4865__auto___70875]));

var G__70876 = (i__4865__auto___70875 + (1));
i__4865__auto___70875 = G__70876;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.ellipse.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69425 = conformed_args__65183__auto__;
var map__69425__$1 = cljs.core.__destructure_map(map__69425);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69425__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69425__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69425__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("ellipse",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.ellipse.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.ellipse.cljs$lang$applyTo = (function (seq69421){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69421));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (code "hello")
 * (code nil "hello")
 * 
 * These two are made equivalent at compile time
 * (code {:onClick f} "hello")
 * (code #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (code :#the-id.klass.other-klass "hello")
 * (code :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.code = (function com$fulcrologic$fulcro$dom$code(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70877 = arguments.length;
var i__4865__auto___70878 = (0);
while(true){
if((i__4865__auto___70878 < len__4864__auto___70877)){
args__4870__auto__.push((arguments[i__4865__auto___70878]));

var G__70879 = (i__4865__auto___70878 + (1));
i__4865__auto___70878 = G__70879;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.code.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.code.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69433 = conformed_args__65183__auto__;
var map__69433__$1 = cljs.core.__destructure_map(map__69433);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69433__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69433__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69433__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("code",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.code.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.code.cljs$lang$applyTo = (function (seq69428){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69428));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (dialog "hello")
 * (dialog nil "hello")
 * 
 * These two are made equivalent at compile time
 * (dialog {:onClick f} "hello")
 * (dialog #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (dialog :#the-id.klass.other-klass "hello")
 * (dialog :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.dialog = (function com$fulcrologic$fulcro$dom$dialog(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70882 = arguments.length;
var i__4865__auto___70883 = (0);
while(true){
if((i__4865__auto___70883 < len__4864__auto___70882)){
args__4870__auto__.push((arguments[i__4865__auto___70883]));

var G__70884 = (i__4865__auto___70883 + (1));
i__4865__auto___70883 = G__70884;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.dialog.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.dialog.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69437 = conformed_args__65183__auto__;
var map__69437__$1 = cljs.core.__destructure_map(map__69437);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69437__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69437__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69437__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("dialog",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.dialog.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.dialog.cljs$lang$applyTo = (function (seq69434){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69434));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (linearGradient "hello")
 * (linearGradient nil "hello")
 * 
 * These two are made equivalent at compile time
 * (linearGradient {:onClick f} "hello")
 * (linearGradient #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (linearGradient :#the-id.klass.other-klass "hello")
 * (linearGradient :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.linearGradient = (function com$fulcrologic$fulcro$dom$linearGradient(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70889 = arguments.length;
var i__4865__auto___70890 = (0);
while(true){
if((i__4865__auto___70890 < len__4864__auto___70889)){
args__4870__auto__.push((arguments[i__4865__auto___70890]));

var G__70891 = (i__4865__auto___70890 + (1));
i__4865__auto___70890 = G__70891;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.linearGradient.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69450 = conformed_args__65183__auto__;
var map__69450__$1 = cljs.core.__destructure_map(map__69450);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69450__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69450__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69450__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("linearGradient",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.linearGradient.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.linearGradient.cljs$lang$applyTo = (function (seq69443){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69443));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (discard "hello")
 * (discard nil "hello")
 * 
 * These two are made equivalent at compile time
 * (discard {:onClick f} "hello")
 * (discard #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (discard :#the-id.klass.other-klass "hello")
 * (discard :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.discard = (function com$fulcrologic$fulcro$dom$discard(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70892 = arguments.length;
var i__4865__auto___70893 = (0);
while(true){
if((i__4865__auto___70893 < len__4864__auto___70892)){
args__4870__auto__.push((arguments[i__4865__auto___70893]));

var G__70895 = (i__4865__auto___70893 + (1));
i__4865__auto___70893 = G__70895;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.discard.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.discard.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69457 = conformed_args__65183__auto__;
var map__69457__$1 = cljs.core.__destructure_map(map__69457);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69457__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69457__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69457__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("discard",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.discard.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.discard.cljs$lang$applyTo = (function (seq69455){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69455));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (font-face-src "hello")
 * (font-face-src nil "hello")
 * 
 * These two are made equivalent at compile time
 * (font-face-src {:onClick f} "hello")
 * (font-face-src #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (font-face-src :#the-id.klass.other-klass "hello")
 * (font-face-src :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.font_face_src = (function com$fulcrologic$fulcro$dom$font_face_src(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70898 = arguments.length;
var i__4865__auto___70899 = (0);
while(true){
if((i__4865__auto___70899 < len__4864__auto___70898)){
args__4870__auto__.push((arguments[i__4865__auto___70899]));

var G__70900 = (i__4865__auto___70899 + (1));
i__4865__auto___70899 = G__70900;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.font_face_src.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.font_face_src.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69462 = conformed_args__65183__auto__;
var map__69462__$1 = cljs.core.__destructure_map(map__69462);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69462__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69462__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69462__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("font-face-src",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.font_face_src.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.font_face_src.cljs$lang$applyTo = (function (seq69460){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69460));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (noscript "hello")
 * (noscript nil "hello")
 * 
 * These two are made equivalent at compile time
 * (noscript {:onClick f} "hello")
 * (noscript #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (noscript :#the-id.klass.other-klass "hello")
 * (noscript :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.noscript = (function com$fulcrologic$fulcro$dom$noscript(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70903 = arguments.length;
var i__4865__auto___70905 = (0);
while(true){
if((i__4865__auto___70905 < len__4864__auto___70903)){
args__4870__auto__.push((arguments[i__4865__auto___70905]));

var G__70906 = (i__4865__auto___70905 + (1));
i__4865__auto___70905 = G__70906;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.noscript.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.noscript.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69464 = conformed_args__65183__auto__;
var map__69464__$1 = cljs.core.__destructure_map(map__69464);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69464__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69464__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69464__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("noscript",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.noscript.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.noscript.cljs$lang$applyTo = (function (seq69463){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69463));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (animateTransform "hello")
 * (animateTransform nil "hello")
 * 
 * These two are made equivalent at compile time
 * (animateTransform {:onClick f} "hello")
 * (animateTransform #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (animateTransform :#the-id.klass.other-klass "hello")
 * (animateTransform :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.animateTransform = (function com$fulcrologic$fulcro$dom$animateTransform(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70908 = arguments.length;
var i__4865__auto___70909 = (0);
while(true){
if((i__4865__auto___70909 < len__4864__auto___70908)){
args__4870__auto__.push((arguments[i__4865__auto___70909]));

var G__70910 = (i__4865__auto___70909 + (1));
i__4865__auto___70909 = G__70910;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.animateTransform.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.animateTransform.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69480 = conformed_args__65183__auto__;
var map__69480__$1 = cljs.core.__destructure_map(map__69480);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69480__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69480__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69480__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("animateTransform",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.animateTransform.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.animateTransform.cljs$lang$applyTo = (function (seq69470){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69470));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (feColorMatrix "hello")
 * (feColorMatrix nil "hello")
 * 
 * These two are made equivalent at compile time
 * (feColorMatrix {:onClick f} "hello")
 * (feColorMatrix #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (feColorMatrix :#the-id.klass.other-klass "hello")
 * (feColorMatrix :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.feColorMatrix = (function com$fulcrologic$fulcro$dom$feColorMatrix(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70913 = arguments.length;
var i__4865__auto___70914 = (0);
while(true){
if((i__4865__auto___70914 < len__4864__auto___70913)){
args__4870__auto__.push((arguments[i__4865__auto___70914]));

var G__70915 = (i__4865__auto___70914 + (1));
i__4865__auto___70914 = G__70915;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.feColorMatrix.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.feColorMatrix.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69489 = conformed_args__65183__auto__;
var map__69489__$1 = cljs.core.__destructure_map(map__69489);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69489__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69489__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69489__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("feColorMatrix",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.feColorMatrix.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.feColorMatrix.cljs$lang$applyTo = (function (seq69484){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69484));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (h2 "hello")
 * (h2 nil "hello")
 * 
 * These two are made equivalent at compile time
 * (h2 {:onClick f} "hello")
 * (h2 #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (h2 :#the-id.klass.other-klass "hello")
 * (h2 :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.h2 = (function com$fulcrologic$fulcro$dom$h2(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70918 = arguments.length;
var i__4865__auto___70919 = (0);
while(true){
if((i__4865__auto___70919 < len__4864__auto___70918)){
args__4870__auto__.push((arguments[i__4865__auto___70919]));

var G__70920 = (i__4865__auto___70919 + (1));
i__4865__auto___70919 = G__70920;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.h2.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.h2.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69499 = conformed_args__65183__auto__;
var map__69499__$1 = cljs.core.__destructure_map(map__69499);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69499__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69499__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69499__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("h2",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.h2.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.h2.cljs$lang$applyTo = (function (seq69496){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69496));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (area "hello")
 * (area nil "hello")
 * 
 * These two are made equivalent at compile time
 * (area {:onClick f} "hello")
 * (area #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (area :#the-id.klass.other-klass "hello")
 * (area :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.area = (function com$fulcrologic$fulcro$dom$area(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70924 = arguments.length;
var i__4865__auto___70925 = (0);
while(true){
if((i__4865__auto___70925 < len__4864__auto___70924)){
args__4870__auto__.push((arguments[i__4865__auto___70925]));

var G__70926 = (i__4865__auto___70925 + (1));
i__4865__auto___70925 = G__70926;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.area.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.area.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69509 = conformed_args__65183__auto__;
var map__69509__$1 = cljs.core.__destructure_map(map__69509);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69509__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69509__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69509__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("area",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.area.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.area.cljs$lang$applyTo = (function (seq69502){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69502));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (br "hello")
 * (br nil "hello")
 * 
 * These two are made equivalent at compile time
 * (br {:onClick f} "hello")
 * (br #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (br :#the-id.klass.other-klass "hello")
 * (br :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.br = (function com$fulcrologic$fulcro$dom$br(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70938 = arguments.length;
var i__4865__auto___70939 = (0);
while(true){
if((i__4865__auto___70939 < len__4864__auto___70938)){
args__4870__auto__.push((arguments[i__4865__auto___70939]));

var G__70940 = (i__4865__auto___70939 + (1));
i__4865__auto___70939 = G__70940;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.br.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.br.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69526 = conformed_args__65183__auto__;
var map__69526__$1 = cljs.core.__destructure_map(map__69526);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69526__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69526__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69526__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("br",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.br.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.br.cljs$lang$applyTo = (function (seq69517){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69517));
}));


/**
 * Returns a React DOM element. Can be invoked in several ways
 * 
 * These two are made equivalent at compile time
 * (image "hello")
 * (image nil "hello")
 * 
 * These two are made equivalent at compile time
 * (image {:onClick f} "hello")
 * (image #js {:onClick f} "hello")
 * 
 * There is also a shorthand for CSS id and class names
 * (image :#the-id.klass.other-klass "hello")
 * (image :#the-id.klass.other-klass {:onClick f} "hello")
 */
com.fulcrologic.fulcro.dom.image = (function com$fulcrologic$fulcro$dom$image(var_args){
var args__4870__auto__ = [];
var len__4864__auto___70942 = arguments.length;
var i__4865__auto___70943 = (0);
while(true){
if((i__4865__auto___70943 < len__4864__auto___70942)){
args__4870__auto__.push((arguments[i__4865__auto___70943]));

var G__70944 = (i__4865__auto___70943 + (1));
i__4865__auto___70943 = G__70944;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return com.fulcrologic.fulcro.dom.image.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(com.fulcrologic.fulcro.dom.image.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var conformed_args__65183__auto__ = com.fulcrologic.fulcro.dom.parse_args(args);
var map__69543 = conformed_args__65183__auto__;
var map__69543__$1 = cljs.core.__destructure_map(map__69543);
var css__65186__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69543__$1,new cljs.core.Keyword(null,"css","css",1135045163));
var attrs__65184__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69543__$1,new cljs.core.Keyword(null,"attrs","attrs",-2090668713));
var children__65185__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69543__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var children__65185__auto____$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.second,children__65185__auto__);
var attrs_value__65187__auto__ = (function (){var or__4253__auto__ = cljs.core.second(attrs__65184__auto__);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
return com.fulcrologic.fulcro.dom.macro_create_element.cljs$core$IFn$_invoke$arity$3("image",cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs_value__65187__auto__], null),children__65185__auto____$1),css__65186__auto__);
}));

(com.fulcrologic.fulcro.dom.image.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.fulcrologic.fulcro.dom.image.cljs$lang$applyTo = (function (seq69529){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq69529));
}));


//# sourceMappingURL=com.fulcrologic.fulcro.dom.js.map
