goog.provide('com.fulcrologic.fulcro.rendering.ident_optimized_render');
/**
 * Checks the given `idents` and returns a subset of them where the data they refer to has changed
 * between `old-state` and `new-state`.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.dirty_table_entries = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$dirty_table_entries(old_state,new_state,idents){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,ident){
if((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(old_state,ident) === cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,ident))){
return result;
} else {
return cljs.core.cons(ident,result);
}
}),cljs.core.List.EMPTY,idents);
});
/**
 * Uses the component's query and the current application state to query for the current value of that component's
 *   props (subtree). It then sends those props to the component via "props tunnelling" (setting them on a well-known key in
 *   component-local state).
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_component_BANG_(app,ident,c){
if(cljs.core.truth_((function (){var and__4251__auto__ = c;
if(cljs.core.truth_(and__4251__auto__)){
return ident;
} else {
return and__4251__auto__;
}
})())){
var map__64846 = app;
var map__64846__$1 = cljs.core.__destructure_map(map__64846);
var state_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64846__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","state-atom","com.fulcrologic.fulcro.application/state-atom",648128366));
var state_map = cljs.core.deref(state_atom);
var query = com.fulcrologic.fulcro.components.get_query.cljs$core$IFn$_invoke$arity$2(c,state_map);
var q = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.createAsIfByAssoc([ident,query])], null);
var prior_computed = (function (){var or__4253__auto__ = (com.fulcrologic.fulcro.components.get_computed.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_computed.cljs$core$IFn$_invoke$arity$1(c) : com.fulcrologic.fulcro.components.get_computed.call(null,c));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var data_tree = (cljs.core.truth_(query)?com.fulcrologic.fulcro.algorithms.denormalize.db__GT_tree(q,state_map,state_map):null);
var new_props = (function (){var G__64847 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(data_tree,ident);
var G__64848 = prior_computed;
return (com.fulcrologic.fulcro.components.computed.cljs$core$IFn$_invoke$arity$2 ? com.fulcrologic.fulcro.components.computed.cljs$core$IFn$_invoke$arity$2(G__64847,G__64848) : com.fulcrologic.fulcro.components.computed.call(null,G__64847,G__64848));
})();
if(cljs.core.truth_(query)){
} else {
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"com.fulcrologic.fulcro.rendering.ident-optimized-render",null,42,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Query was empty. Refresh failed for ",cljs.core.type(c),"See https://book.fulcrologic.com/#err-id-opt-render-empty-query"], null);
}),null)),null,691964610,null);
}

return com.fulcrologic.fulcro.components.tunnel_props_BANG_(c,new_props);
} else {
var root = new cljs.core.Keyword("com.fulcrologic.fulcro.application","app-root","com.fulcrologic.fulcro.application/app-root",835379005).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword("com.fulcrologic.fulcro.application","runtime-atom","com.fulcrologic.fulcro.application/runtime-atom",-1167397772).cljs$core$IFn$_invoke$arity$1(app)));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,root)){
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"com.fulcrologic.fulcro.rendering.ident-optimized-render",null,46,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Failed to do optimized update. Component",(function (){var G__64851 = com.fulcrologic.fulcro.components.react_type(c);
return (com.fulcrologic.fulcro.components.class__GT_registry_key.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.class__GT_registry_key.cljs$core$IFn$_invoke$arity$1(G__64851) : com.fulcrologic.fulcro.components.class__GT_registry_key.call(null,G__64851));
})(),"queries for data that changed, but does not have an ident."], null);
}),null)),null,-1983537048,null);
} else {
}

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Targeted update failed",cljs.core.PersistentArrayMap.EMPTY);
}
});
/**
 * Renders *only* components that *have* the given ident.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_components_with_ident_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_components_with_ident_BANG_(app,ident){
var seq__64855 = cljs.core.seq(com.fulcrologic.fulcro.components.ident__GT_components(app,ident));
var chunk__64856 = null;
var count__64857 = (0);
var i__64858 = (0);
while(true){
if((i__64858 < count__64857)){
var c = chunk__64856.cljs$core$IIndexed$_nth$arity$2(null,i__64858);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,ident,c);


var G__65120 = seq__64855;
var G__65121 = chunk__64856;
var G__65122 = count__64857;
var G__65123 = (i__64858 + (1));
seq__64855 = G__65120;
chunk__64856 = G__65121;
count__64857 = G__65122;
i__64858 = G__65123;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__64855);
if(temp__5753__auto__){
var seq__64855__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64855__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__64855__$1);
var G__65125 = cljs.core.chunk_rest(seq__64855__$1);
var G__65126 = c__4679__auto__;
var G__65127 = cljs.core.count(c__4679__auto__);
var G__65128 = (0);
seq__64855 = G__65125;
chunk__64856 = G__65126;
count__64857 = G__65127;
i__64858 = G__65128;
continue;
} else {
var c = cljs.core.first(seq__64855__$1);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,ident,c);


var G__65130 = cljs.core.next(seq__64855__$1);
var G__65131 = null;
var G__65132 = (0);
var G__65133 = (0);
seq__64855 = G__65130;
chunk__64856 = G__65131;
count__64857 = G__65132;
i__64858 = G__65133;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Renders components that have, or query for, the given ident.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_dependents_of_ident_BANG_(app,ident){
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_components_with_ident_BANG_(app,ident);

var map__64866 = app;
var map__64866__$1 = cljs.core.__destructure_map(map__64866);
var runtime_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64866__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","runtime-atom","com.fulcrologic.fulcro.application/runtime-atom",-1167397772));
var map__64867 = cljs.core.deref(runtime_atom);
var map__64867__$1 = cljs.core.__destructure_map(map__64867);
var indexes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64867__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","indexes","com.fulcrologic.fulcro.application/indexes",-165326938));
var map__64868 = indexes;
var map__64868__$1 = cljs.core.__destructure_map(map__64868);
var prop__GT_classes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64868__$1,new cljs.core.Keyword(null,"prop->classes","prop->classes",515892717));
var idents_in_joins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64868__$1,new cljs.core.Keyword(null,"idents-in-joins","idents-in-joins",-1556962035));
var class__GT_components = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64868__$1,new cljs.core.Keyword(null,"class->components","class->components",436435919));
var idents_in_joins__$1 = (function (){var or__4253__auto__ = idents_in_joins;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
if(cljs.core.contains_QMARK_(idents_in_joins__$1,ident)){
var classes = (prop__GT_classes.cljs$core$IFn$_invoke$arity$1 ? prop__GT_classes.cljs$core$IFn$_invoke$arity$1(ident) : prop__GT_classes.call(null,ident));
if(cljs.core.seq(classes)){
var seq__64870 = cljs.core.seq(classes);
var chunk__64871 = null;
var count__64872 = (0);
var i__64873 = (0);
while(true){
if((i__64873 < count__64872)){
var class$ = chunk__64871.cljs$core$IIndexed$_nth$arity$2(null,i__64873);
var seq__64900_65142 = cljs.core.seq((class__GT_components.cljs$core$IFn$_invoke$arity$1 ? class__GT_components.cljs$core$IFn$_invoke$arity$1(class$) : class__GT_components.call(null,class$)));
var chunk__64902_65143 = null;
var count__64903_65144 = (0);
var i__64904_65145 = (0);
while(true){
if((i__64904_65145 < count__64903_65144)){
var component_65146 = chunk__64902_65143.cljs$core$IIndexed$_nth$arity$2(null,i__64904_65145);
var component_ident_65147 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(component_65146) : com.fulcrologic.fulcro.components.get_ident.call(null,component_65146));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,component_ident_65147,component_65146);


var G__65148 = seq__64900_65142;
var G__65149 = chunk__64902_65143;
var G__65150 = count__64903_65144;
var G__65151 = (i__64904_65145 + (1));
seq__64900_65142 = G__65148;
chunk__64902_65143 = G__65149;
count__64903_65144 = G__65150;
i__64904_65145 = G__65151;
continue;
} else {
var temp__5753__auto___65152 = cljs.core.seq(seq__64900_65142);
if(temp__5753__auto___65152){
var seq__64900_65153__$1 = temp__5753__auto___65152;
if(cljs.core.chunked_seq_QMARK_(seq__64900_65153__$1)){
var c__4679__auto___65154 = cljs.core.chunk_first(seq__64900_65153__$1);
var G__65155 = cljs.core.chunk_rest(seq__64900_65153__$1);
var G__65156 = c__4679__auto___65154;
var G__65157 = cljs.core.count(c__4679__auto___65154);
var G__65158 = (0);
seq__64900_65142 = G__65155;
chunk__64902_65143 = G__65156;
count__64903_65144 = G__65157;
i__64904_65145 = G__65158;
continue;
} else {
var component_65159 = cljs.core.first(seq__64900_65153__$1);
var component_ident_65161 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(component_65159) : com.fulcrologic.fulcro.components.get_ident.call(null,component_65159));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,component_ident_65161,component_65159);


var G__65163 = cljs.core.next(seq__64900_65153__$1);
var G__65164 = null;
var G__65165 = (0);
var G__65166 = (0);
seq__64900_65142 = G__65163;
chunk__64902_65143 = G__65164;
count__64903_65144 = G__65165;
i__64904_65145 = G__65166;
continue;
}
} else {
}
}
break;
}


var G__65167 = seq__64870;
var G__65168 = chunk__64871;
var G__65169 = count__64872;
var G__65170 = (i__64873 + (1));
seq__64870 = G__65167;
chunk__64871 = G__65168;
count__64872 = G__65169;
i__64873 = G__65170;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__64870);
if(temp__5753__auto__){
var seq__64870__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64870__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__64870__$1);
var G__65173 = cljs.core.chunk_rest(seq__64870__$1);
var G__65174 = c__4679__auto__;
var G__65175 = cljs.core.count(c__4679__auto__);
var G__65176 = (0);
seq__64870 = G__65173;
chunk__64871 = G__65174;
count__64872 = G__65175;
i__64873 = G__65176;
continue;
} else {
var class$ = cljs.core.first(seq__64870__$1);
var seq__64920_65179 = cljs.core.seq((class__GT_components.cljs$core$IFn$_invoke$arity$1 ? class__GT_components.cljs$core$IFn$_invoke$arity$1(class$) : class__GT_components.call(null,class$)));
var chunk__64922_65180 = null;
var count__64923_65181 = (0);
var i__64924_65182 = (0);
while(true){
if((i__64924_65182 < count__64923_65181)){
var component_65188 = chunk__64922_65180.cljs$core$IIndexed$_nth$arity$2(null,i__64924_65182);
var component_ident_65189 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(component_65188) : com.fulcrologic.fulcro.components.get_ident.call(null,component_65188));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,component_ident_65189,component_65188);


var G__65190 = seq__64920_65179;
var G__65191 = chunk__64922_65180;
var G__65192 = count__64923_65181;
var G__65193 = (i__64924_65182 + (1));
seq__64920_65179 = G__65190;
chunk__64922_65180 = G__65191;
count__64923_65181 = G__65192;
i__64924_65182 = G__65193;
continue;
} else {
var temp__5753__auto___65194__$1 = cljs.core.seq(seq__64920_65179);
if(temp__5753__auto___65194__$1){
var seq__64920_65195__$1 = temp__5753__auto___65194__$1;
if(cljs.core.chunked_seq_QMARK_(seq__64920_65195__$1)){
var c__4679__auto___65196 = cljs.core.chunk_first(seq__64920_65195__$1);
var G__65197 = cljs.core.chunk_rest(seq__64920_65195__$1);
var G__65198 = c__4679__auto___65196;
var G__65199 = cljs.core.count(c__4679__auto___65196);
var G__65200 = (0);
seq__64920_65179 = G__65197;
chunk__64922_65180 = G__65198;
count__64923_65181 = G__65199;
i__64924_65182 = G__65200;
continue;
} else {
var component_65201 = cljs.core.first(seq__64920_65195__$1);
var component_ident_65202 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(component_65201) : com.fulcrologic.fulcro.components.get_ident.call(null,component_65201));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,component_ident_65202,component_65201);


var G__65204 = cljs.core.next(seq__64920_65195__$1);
var G__65205 = null;
var G__65206 = (0);
var G__65207 = (0);
seq__64920_65179 = G__65204;
chunk__64922_65180 = G__65205;
count__64923_65181 = G__65206;
i__64924_65182 = G__65207;
continue;
}
} else {
}
}
break;
}


var G__65208 = cljs.core.next(seq__64870__$1);
var G__65209 = null;
var G__65210 = (0);
var G__65211 = (0);
seq__64870 = G__65208;
chunk__64871 = G__65209;
count__64872 = G__65210;
i__64873 = G__65211;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
/**
 * Given an app and a `property-set`: returns the components that query for the items in property-set.
 * 
 *   The `property-set` can be any sequence (ideally a set) of keywords and idents that can directly appear
 *   in a component query as a property or join key.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.props__GT_components = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$props__GT_components(app,property_set){
if(cljs.core.seq(property_set)){
var map__64944 = app;
var map__64944__$1 = cljs.core.__destructure_map(map__64944);
var runtime_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64944__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","runtime-atom","com.fulcrologic.fulcro.application/runtime-atom",-1167397772));
var map__64945 = cljs.core.deref(runtime_atom);
var map__64945__$1 = cljs.core.__destructure_map(map__64945);
var indexes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64945__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","indexes","com.fulcrologic.fulcro.application/indexes",-165326938));
var map__64946 = indexes;
var map__64946__$1 = cljs.core.__destructure_map(map__64946);
var prop__GT_classes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64946__$1,new cljs.core.Keyword(null,"prop->classes","prop->classes",515892717));
var class__GT_components = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64946__$1,new cljs.core.Keyword(null,"class->components","class->components",436435919));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,prop){
var classes = (prop__GT_classes.cljs$core$IFn$_invoke$arity$1 ? prop__GT_classes.cljs$core$IFn$_invoke$arity$1(prop) : prop__GT_classes.call(null,prop));
var components = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__64942_SHARP_,p2__64943_SHARP_){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(p1__64942_SHARP_,(class__GT_components.cljs$core$IFn$_invoke$arity$1 ? class__GT_components.cljs$core$IFn$_invoke$arity$1(p2__64943_SHARP_) : class__GT_components.call(null,p2__64943_SHARP_)));
}),cljs.core.PersistentHashSet.EMPTY,classes);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(result,components);
}),cljs.core.PersistentHashSet.EMPTY,property_set);
} else {
return null;
}
});
/**
 * This function tracks the state of the app at the time of prior render in the app's runtime-atom. It
 * uses that to do a comparison of old vs. current application state (bounded by the needs of on-screen components).
 * When it finds data that has changed it renders all of the components that depend on that data.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_stale_components_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_stale_components_BANG_(app){
var map__64963 = app;
var map__64963__$1 = cljs.core.__destructure_map(map__64963);
var runtime_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64963__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","runtime-atom","com.fulcrologic.fulcro.application/runtime-atom",-1167397772));
var state_atom = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64963__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","state-atom","com.fulcrologic.fulcro.application/state-atom",648128366));
var map__64964 = cljs.core.deref(runtime_atom);
var map__64964__$1 = cljs.core.__destructure_map(map__64964);
var indexes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64964__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","indexes","com.fulcrologic.fulcro.application/indexes",-165326938));
var last_rendered_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64964__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","last-rendered-state","com.fulcrologic.fulcro.application/last-rendered-state",1438978441));
var to_refresh = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64964__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","to-refresh","com.fulcrologic.fulcro.application/to-refresh",-967758829));
var only_refresh = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64964__$1,new cljs.core.Keyword("com.fulcrologic.fulcro.application","only-refresh","com.fulcrologic.fulcro.application/only-refresh",1300408206));
var map__64965 = indexes;
var map__64965__$1 = cljs.core.__destructure_map(map__64965);
var linked_props = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64965__$1,new cljs.core.Keyword(null,"linked-props","linked-props",1547374714));
var ident__GT_components = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64965__$1,new cljs.core.Keyword(null,"ident->components","ident->components",-1952169224));
var prop__GT_classes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64965__$1,new cljs.core.Keyword(null,"prop->classes","prop->classes",515892717));
var idents_in_joins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64965__$1,new cljs.core.Keyword(null,"idents-in-joins","idents-in-joins",-1556962035));
var limited_refresh_QMARK_ = cljs.core.seq(only_refresh);
if(limited_refresh_QMARK_){
var map__64967 = cljs.core.group_by(edn_query_language.core.ident_QMARK_,only_refresh);
var map__64967__$1 = cljs.core.__destructure_map(map__64967);
var limited_idents = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64967__$1,true);
var limited_props = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64967__$1,false);
var limited_to_render = com.fulcrologic.fulcro.rendering.ident_optimized_render.props__GT_components(app,limited_props);
var seq__64970_65218 = cljs.core.seq(limited_to_render);
var chunk__64972_65219 = null;
var count__64973_65220 = (0);
var i__64974_65221 = (0);
while(true){
if((i__64974_65221 < count__64973_65220)){
var c_65222 = chunk__64972_65219.cljs$core$IIndexed$_nth$arity$2(null,i__64974_65221);
var ident_65223 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(c_65222) : com.fulcrologic.fulcro.components.get_ident.call(null,c_65222));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,ident_65223,c_65222);


var G__65224 = seq__64970_65218;
var G__65225 = chunk__64972_65219;
var G__65226 = count__64973_65220;
var G__65227 = (i__64974_65221 + (1));
seq__64970_65218 = G__65224;
chunk__64972_65219 = G__65225;
count__64973_65220 = G__65226;
i__64974_65221 = G__65227;
continue;
} else {
var temp__5753__auto___65228 = cljs.core.seq(seq__64970_65218);
if(temp__5753__auto___65228){
var seq__64970_65229__$1 = temp__5753__auto___65228;
if(cljs.core.chunked_seq_QMARK_(seq__64970_65229__$1)){
var c__4679__auto___65231 = cljs.core.chunk_first(seq__64970_65229__$1);
var G__65232 = cljs.core.chunk_rest(seq__64970_65229__$1);
var G__65233 = c__4679__auto___65231;
var G__65234 = cljs.core.count(c__4679__auto___65231);
var G__65235 = (0);
seq__64970_65218 = G__65232;
chunk__64972_65219 = G__65233;
count__64973_65220 = G__65234;
i__64974_65221 = G__65235;
continue;
} else {
var c_65236 = cljs.core.first(seq__64970_65229__$1);
var ident_65237 = (com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(c_65236) : com.fulcrologic.fulcro.components.get_ident.call(null,c_65236));
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,ident_65237,c_65236);


var G__65240 = cljs.core.next(seq__64970_65229__$1);
var G__65241 = null;
var G__65242 = (0);
var G__65243 = (0);
seq__64970_65218 = G__65240;
chunk__64972_65219 = G__65241;
count__64973_65220 = G__65242;
i__64974_65221 = G__65243;
continue;
}
} else {
}
}
break;
}

var seq__64993 = cljs.core.seq(limited_idents);
var chunk__64994 = null;
var count__64995 = (0);
var i__64996 = (0);
while(true){
if((i__64996 < count__64995)){
var i = chunk__64994.cljs$core$IIndexed$_nth$arity$2(null,i__64996);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_(app,i);


var G__65246 = seq__64993;
var G__65247 = chunk__64994;
var G__65248 = count__64995;
var G__65249 = (i__64996 + (1));
seq__64993 = G__65246;
chunk__64994 = G__65247;
count__64995 = G__65248;
i__64996 = G__65249;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__64993);
if(temp__5753__auto__){
var seq__64993__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64993__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__64993__$1);
var G__65252 = cljs.core.chunk_rest(seq__64993__$1);
var G__65253 = c__4679__auto__;
var G__65254 = cljs.core.count(c__4679__auto__);
var G__65255 = (0);
seq__64993 = G__65252;
chunk__64994 = G__65253;
count__64995 = G__65254;
i__64996 = G__65255;
continue;
} else {
var i = cljs.core.first(seq__64993__$1);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_(app,i);


var G__65256 = cljs.core.next(seq__64993__$1);
var G__65257 = null;
var G__65258 = (0);
var G__65259 = (0);
seq__64993 = G__65256;
chunk__64994 = G__65257;
count__64995 = G__65258;
i__64996 = G__65259;
continue;
}
} else {
return null;
}
}
break;
}
} else {
var state_map = cljs.core.deref(state_atom);
var idents_in_joins__$1 = (function (){var or__4253__auto__ = idents_in_joins;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
var dirty_linked_props = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(state_map,p) === cljs.core.get.cljs$core$IFn$_invoke$arity$2(last_rendered_state,p))))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,p);
} else {
return acc;
}
}),cljs.core.PersistentHashSet.EMPTY,linked_props);
var map__65020 = cljs.core.group_by(edn_query_language.core.ident_QMARK_,to_refresh);
var map__65020__$1 = cljs.core.__destructure_map(map__65020);
var idents_to_force = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65020__$1,true);
var props_to_force = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65020__$1,false);
var props_to_force__$1 = clojure.set.union.cljs$core$IFn$_invoke$arity$2(props_to_force,dirty_linked_props);
var mounted_idents = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(ident__GT_components),idents_in_joins__$1);
var stale_idents = com.fulcrologic.fulcro.rendering.ident_optimized_render.dirty_table_entries(last_rendered_state,state_map,mounted_idents);
var extra_to_force = com.fulcrologic.fulcro.rendering.ident_optimized_render.props__GT_components(app,props_to_force__$1);
var all_idents = clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.set(idents_to_force),cljs.core.set(stale_idents));
var seq__65035_65268 = cljs.core.seq(all_idents);
var chunk__65036_65269 = null;
var count__65037_65270 = (0);
var i__65038_65271 = (0);
while(true){
if((i__65038_65271 < count__65037_65270)){
var i_65274 = chunk__65036_65269.cljs$core$IIndexed$_nth$arity$2(null,i__65038_65271);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_(app,i_65274);


var G__65275 = seq__65035_65268;
var G__65276 = chunk__65036_65269;
var G__65277 = count__65037_65270;
var G__65278 = (i__65038_65271 + (1));
seq__65035_65268 = G__65275;
chunk__65036_65269 = G__65276;
count__65037_65270 = G__65277;
i__65038_65271 = G__65278;
continue;
} else {
var temp__5753__auto___65280 = cljs.core.seq(seq__65035_65268);
if(temp__5753__auto___65280){
var seq__65035_65282__$1 = temp__5753__auto___65280;
if(cljs.core.chunked_seq_QMARK_(seq__65035_65282__$1)){
var c__4679__auto___65283 = cljs.core.chunk_first(seq__65035_65282__$1);
var G__65284 = cljs.core.chunk_rest(seq__65035_65282__$1);
var G__65285 = c__4679__auto___65283;
var G__65286 = cljs.core.count(c__4679__auto___65283);
var G__65287 = (0);
seq__65035_65268 = G__65284;
chunk__65036_65269 = G__65285;
count__65037_65270 = G__65286;
i__65038_65271 = G__65287;
continue;
} else {
var i_65288 = cljs.core.first(seq__65035_65282__$1);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_dependents_of_ident_BANG_(app,i_65288);


var G__65289 = cljs.core.next(seq__65035_65282__$1);
var G__65290 = null;
var G__65291 = (0);
var G__65292 = (0);
seq__65035_65268 = G__65289;
chunk__65036_65269 = G__65290;
count__65037_65270 = G__65291;
i__65038_65271 = G__65292;
continue;
}
} else {
}
}
break;
}

var seq__65058 = cljs.core.seq(extra_to_force);
var chunk__65059 = null;
var count__65060 = (0);
var i__65061 = (0);
while(true){
if((i__65061 < count__65060)){
var c = chunk__65059.cljs$core$IIndexed$_nth$arity$2(null,i__65061);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,(com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(c) : com.fulcrologic.fulcro.components.get_ident.call(null,c)),c);


var G__65294 = seq__65058;
var G__65295 = chunk__65059;
var G__65296 = count__65060;
var G__65297 = (i__65061 + (1));
seq__65058 = G__65294;
chunk__65059 = G__65295;
count__65060 = G__65296;
i__65061 = G__65297;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__65058);
if(temp__5753__auto__){
var seq__65058__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__65058__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__65058__$1);
var G__65299 = cljs.core.chunk_rest(seq__65058__$1);
var G__65300 = c__4679__auto__;
var G__65301 = cljs.core.count(c__4679__auto__);
var G__65302 = (0);
seq__65058 = G__65299;
chunk__65059 = G__65300;
count__65060 = G__65301;
i__65061 = G__65302;
continue;
} else {
var c = cljs.core.first(seq__65058__$1);
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_component_BANG_(app,(com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1 ? com.fulcrologic.fulcro.components.get_ident.cljs$core$IFn$_invoke$arity$1(c) : com.fulcrologic.fulcro.components.get_ident.call(null,c)),c);


var G__65305 = cljs.core.next(seq__65058__$1);
var G__65306 = null;
var G__65307 = (0);
var G__65308 = (0);
seq__65058 = G__65305;
chunk__65059 = G__65306;
count__65060 = G__65307;
i__65061 = G__65308;
continue;
}
} else {
return null;
}
}
break;
}
}
});
/**
 * The top-level call for using this optimized render in your application.
 * 
 *   If `:force-root? true` is passed in options, then it just forces a keyframe root render; otherwise
 *   it tries to minimize the work done for screen refresh to just the queries/refreshes needed by the
 *   data that has changed.
 */
com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_ = (function com$fulcrologic$fulcro$rendering$ident_optimized_render$render_BANG_(var_args){
var G__65081 = arguments.length;
switch (G__65081) {
case 1:
return com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (app){
return com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$2(app,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (app,p__65086){
var map__65087 = p__65086;
var map__65087__$1 = cljs.core.__destructure_map(map__65087);
var options = map__65087__$1;
var force_root_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65087__$1,new cljs.core.Keyword(null,"force-root?","force-root?",-1598741683));
var root_props_changed_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65087__$1,new cljs.core.Keyword(null,"root-props-changed?","root-props-changed?",1999614835));
if(cljs.core.truth_((function (){var or__4253__auto__ = force_root_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return root_props_changed_QMARK_;
}
})())){
return com.fulcrologic.fulcro.rendering.keyframe_render.render_BANG_(app,options);
} else {
try{return com.fulcrologic.fulcro.rendering.ident_optimized_render.render_stale_components_BANG_(app);
}catch (e65090){var e = e65090;
taoensso.timbre._log_BANG_.cljs$core$IFn$_invoke$arity$11(taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"info","info",-317069002),"com.fulcrologic.fulcro.rendering.ident-optimized-render",null,146,new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Optimized render failed. Falling back to root render."], null);
}),null)),null,1848538487,null);

return com.fulcrologic.fulcro.rendering.keyframe_render.render_BANG_(app,options);
}}
}));

(com.fulcrologic.fulcro.rendering.ident_optimized_render.render_BANG_.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=com.fulcrologic.fulcro.rendering.ident_optimized_render.js.map
