goog.provide('dv.cljs_emotion.devcards');
var module$node_modules$polished$dist$polished_cjs=shadow.js.require("module$node_modules$polished$dist$polished_cjs", {});
cljs.core.enable_console_print_BANG_();
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  Hi there. This page uses devcards to demonstrate usage of the dv.cljs-emotion library.\n  This library is a small wrapper around the emotion css-in-js JavaScript library that\n  makes it easy to use all of CSS within a react application.\n\n  The source of these cards can be found here:\n  https://github.com/dvingo/cljs-emotion/tree/master/src/dev/dv/cljs_emotion\n\n  The main API of this library is: `[defstyled keyframes global-style theme-provider]`\n\n  defstyled is a wrapper around `@emotion/styled`\n  Styled is multi-arity and supports passing functions that return maps of styles, a vector of styles that\n  will be merged top down (first to last) and a map, you can also pass JavaScript objects and arrays.\n\n  This library converts between cljs and js structures, but the multi-arity capability is built into emotion already.\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"# Use it\n\nRequire the library:\n```clojure\n(require [dv.cljs-emotion :refer [defstyled keyframes global-style theme-provider]])\n```\n\nOr for reagent support:\n```clojure\n(require [dv.cljs-emotion-reagent :refer [defstyled keyframes global-style theme-provider]])\n```\n\nYou can pass any number of children to defstyled:\n\n```clojure\n(defstyled sample1 :div\n  {:background-color \"RebeccaPurple\"})\n```\n\n```clojure\n(defstyled sample1 :div\n {:background-color \"RebeccaPurple\"}\n #js{:color \"yellow\"}\n (fn [props] {:border-radius 4}))\n```\n\nThis library delegates to emotion's styled API, while adding a transform layer for cljs->js data structures.\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),null,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.global_data = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on?","on?",-74017086),false], null));
dv.cljs_emotion.devcards.btn_styles = new cljs.core.PersistentArrayMap(null, 1, ["button",cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"line-height","line-height",1870784992),new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"vertical-align","vertical-align",651007333),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"font-weight","font-weight",2085804583),new cljs.core.Keyword(null,"background-color","background-color",570434026),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"background-image","background-image",-1142314704),":hover",":active",new cljs.core.Keyword(null,"padding","padding",1660304693),new cljs.core.Keyword(null,"text-shadow","text-shadow",116733623),new cljs.core.Keyword(null,"border","border",1444987323),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"font-family","font-family",-667419874),new cljs.core.Keyword(null,"margin","margin",-995903681)],["1rem",["inset 0 1px 0 white, inset 0 -1px 0 #d9d9d9,"," inset    0 0 0 1px #f2f2f2, 0 2px 4px rgba(0, 0, 0, 0.2)"].join(''),"#8c8c8c","top","all 20ms ease-out",(700),"#f2f2f2","pointer","linear-gradient(to bottom, #f2f2f2, #f2f2f2)",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"background","background",-863952629),"#f2f2f2",new cljs.core.Keyword(null,"border-color","border-color",-2059162761),"#8c8c8c",new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"inset 0 1px 0 white, inset 0 -1px 0 #d9d9d9, inset 0 0 0 1px #f2f2f2"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"inset 0 2px 3px rgba(0, 0, 0, 0.2)"], null),"9px 16px 9px","0 1px 0 rgba(255, 255, 255, 0.5)","1px solid #bfbfbf",(3),"sans-serif","16px 0 0 16px"])], null);
dv.cljs_emotion.devcards.button_styles = new cljs.core.PersistentArrayMap(null, 1, ["button",new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem 2rem",new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"transition","transition",765692007),"all .5s",":hover",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755)," 0px 10px 10px rgba(0,0,0,0.2)",new cljs.core.Keyword(null,"transform","transform",1381301764),"translateY(-3px)","::after",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"transform","transform",1381301764),"scaleX(1.4) scaleY(1.6)",new cljs.core.Keyword(null,"opacity","opacity",397153780),(0)], null)], null),"::after",cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"text-transform","text-transform",1685000676),new cljs.core.Keyword(null,"transition","transition",765692007),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"z-index","z-index",1892827090),new cljs.core.Keyword(null,"text-decoration","text-decoration",1836813207),new cljs.core.Keyword(null,"display","display",242065432),new cljs.core.Keyword(null,"position","position",-2011731912),new cljs.core.Keyword(null,"border-radius","border-radius",419594011),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"left","left",-399115937)],["uppercase","all .5s",(0),"''","100 %",(-1),"none","inline-block","absolute",(100),"100 %",(0)])], null)], null);
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"For a quick demonstration we will change some global styles on this page.\n\n  In this example we add some styles to `<button>` elements on this page.\n\n  If global styles are rendered and then on subsequent render they are not, emotion will remove those global styles\n  from the page so you can dynamically include global styles.\n```clojure\n(html\n  [:div\n  [:h2 \"Click the button to style all the <button>s on this page\"]\n  [:button {:on-click #(swap! global-data update :on? not)} \"Do it.\"]\n (when on? (global-style btn-styles))])\n```\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (data,_){
var on_QMARK_ = new cljs.core.Keyword(null,"on?","on?",-74017086).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(data));
var G__62969 = "div";
var G__62970 = null;
var G__62971 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("h2",null,"Click the button to style all the <button>s on this page") : sablono.core.create_element.call(null,"h2",null,"Click the button to style all the <button>s on this page"));
var G__62972 = (function (){var G__62974 = "button";
var G__62975 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dv.cljs_emotion.devcards.global_data,cljs.core.update,new cljs.core.Keyword(null,"on?","on?",-74017086),cljs.core.not);
})});
var G__62976 = "Do it.";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__62974,G__62975,G__62976) : sablono.core.create_element.call(null,G__62974,G__62975,G__62976));
})();
var G__62973 = (cljs.core.truth_(on_QMARK_)?sablono.interpreter.interpret(dv.cljs_emotion.global_style(dv.cljs_emotion.devcards.btn_styles)):null);
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__62969,G__62970,G__62971,G__62972,G__62973) : sablono.core.create_element.call(null,G__62969,G__62970,G__62971,G__62972,G__62973));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),dv.cljs_emotion.devcards.global_data,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className62979_63173 = "dv.cljs-emotion.devcards/sample1";
var fullClassName62980_63174 = "dv.cljs-emotion.devcards/sample1";
var children62981_63175 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"rebeCCApurple"], null)], null));
var children62981_63176__$1 = cljs.core.clj__GT_js(children62981_63175);
var component_type62977_63177 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"div");
var clss62978_63178 = component_type62977_63177.apply(component_type62977_63177,children62981_63176__$1);
dv.cljs_emotion.obj_set(clss62978_63178,"displayName","dv.cljs-emotion.devcards/sample1");

dv.cljs_emotion.devcards.sample1 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss62978_63178,className62979_63173),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName62980_63174),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss62978_63178], null));

var x62982_63179 = dv.cljs_emotion.devcards.sample1;
(x62982_63179.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.sample1)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"The main api is defstyled which will return react element factory - a function that accepts props and children.\n\n  ```clojure\n  (defstyled sample1 :div\n    {:background-color \"RebeccaPurple\"})\n\n  (sample1 \"Some text here\")\n  ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$1("Some text here") : dv.cljs_emotion.devcards.sample1.call(null,"Some text here")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"You may find it useful to know that the `className` property is passed through to the rendered element.\n  Inspect the output in the browser devtools to confirm that it works.\n\n  Additionally you will note that the fully qualified symbol name is also added as a classname - this is soley used\n  during development time to see your components easily in the browser devtools. By default these classnames are removed\n  when `goog.DEBUG` is set to `false`. You can keep them during release builds by setting the closure constant:\n\n`dv.cljs-emotion/ADD_CLASSNAMES` to `true`\n\nor if using reagent:\n\n`dv.cljs-emotion-reagent/ADD_CLASSNAMES`\n\nI've set this var to true so these classname will show up in the release build of these devcards.\n\n```clojure\n  (defstyled sample1 :div\n    {:background-color \"RebeccaPurple\"})\n  (sample1 {:className \"TEST\"} \"Some text here\")\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__62983 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),"TEST"], null);
var G__62984 = "Some text here";
return (dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.sample1.cljs$core$IFn$_invoke$arity$2(G__62983,G__62984) : dv.cljs_emotion.devcards.sample1.call(null,G__62983,G__62984));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.mw_700 = "@media (min-width:700px)";
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"global-styles","global-styles",1792539654)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"global-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Nested styles are supported - as these are part of the emotion API. Here we are applying different styles\n  for screen widths greater than 699 pixels using a breakpoint.\n\n  We also target a global class \"my-thing\" - using the :.classname notation is handled by this library and passes\n  \".my-thing\" to emotion.\n\n  Resize the width of the page to see the effect.\n\n```clojure\n(def mw-700 \"@media (min-width:700px)\")\n[:div\n [:.my-thing \"Some content\"]\n  (global-style\n    {:.my-thing {:background \"navy\" :color \"#cce\" mw-700 {:background \"black\"}}})])\n```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__62987 = "div";
var G__62988 = null;
var G__62989 = (function (){var G__62991 = "div";
var G__62992 = ({"className": "my-thing"});
var G__62993 = "Some content";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__62991,G__62992,G__62993) : sablono.core.create_element.call(null,G__62991,G__62992,G__62993));
})();
var G__62990 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,".my-thing",".my-thing",780594527),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"background","background",-863952629),"navy",new cljs.core.Keyword(null,"color","color",1011675173),"#cce",dv.cljs_emotion.devcards.mw_700,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"black"], null)])], null)));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$4 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$4(G__62987,G__62988,G__62989,G__62990) : sablono.core.create_element.call(null,G__62987,G__62988,G__62989,G__62990));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.animation = dv.cljs_emotion.keyframes(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"transparent"], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background-color","background-color",570434026),"grey"], null)], null));
dv.cljs_emotion.devcards.animation_styles = (function dv$cljs_emotion$devcards$animation_styles(p__62994){
var map__62995 = p__62994;
var map__62995__$1 = cljs.core.__destructure_map(map__62995);
var time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62995__$1,new cljs.core.Keyword(null,"time","time",1385887882));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"animation","animation",-1248293244),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.devcards.animation)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(time),"s ease-in-out infinite"].join('')], null);
});
var className62998_63180 = "dv.cljs-emotion.devcards/with-anim";
var fullClassName62999_63181 = "dv.cljs-emotion.devcards/with-anim";
var children63000_63182 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv.cljs_emotion.devcards.animation_styles], null));
var children63000_63183__$1 = cljs.core.clj__GT_js(children63000_63182);
var component_type62996_63184 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"div");
var clss62997_63185 = component_type62996_63184.apply(component_type62996_63184,children63000_63183__$1);
dv.cljs_emotion.obj_set(clss62997_63185,"displayName","dv.cljs-emotion.devcards/with-anim");

dv.cljs_emotion.devcards.with_anim = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss62997_63185,className62998_63180),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName62999_63181),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss62997_63185], null));

var x63001_63186 = dv.cljs_emotion.devcards.with_anim;
(x63001_63186.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.with_anim)))].join('');
}));

dv.cljs_emotion.devcards.animation_card = (function dv$cljs_emotion$devcards$animation_card(a,o){
var G__63002 = "div";
var G__63003 = null;
var G__63004 = (function (){var G__63008 = "p";
var G__63009 = null;
var G__63010 = "animation time: ";
var G__63011 = sablono.interpreter.interpret(new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)));
var G__63012 = " seconds";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__63008,G__63009,G__63010,G__63011,G__63012) : sablono.core.create_element.call(null,G__63008,G__63009,G__63010,G__63011,G__63012));
})();
var G__63005 = (function (){var G__63013 = "button";
var G__63014 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"time","time",1385887882),cljs.core.inc);
})});
var G__63015 = "inc";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63013,G__63014,G__63015) : sablono.core.create_element.call(null,G__63013,G__63014,G__63015));
})();
var G__63006 = (function (){var G__63016 = "button";
var G__63017 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"time","time",1385887882),cljs.core.dec);
})});
var G__63018 = "dec";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63016,G__63017,G__63018) : sablono.core.create_element.call(null,G__63016,G__63017,G__63018));
})();
var G__63007 = sablono.interpreter.interpret((function (){var G__63019 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a))], null);
var G__63020 = "Some text here";
return (dv.cljs_emotion.devcards.with_anim.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.with_anim.cljs$core$IFn$_invoke$arity$2(G__63019,G__63020) : dv.cljs_emotion.devcards.with_anim.call(null,G__63019,G__63020));
})());
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$6 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$6(G__63002,G__63003,G__63004,G__63005,G__63006,G__63007) : sablono.core.create_element.call(null,G__63002,G__63003,G__63004,G__63005,G__63006,G__63007));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Keyframe animations are supported - this is built into emotion. ",["\n```clojure\n","(def animation\n  (keyframes {:from {:background-color \"transparent\"}\n              :to   {:background-color \"grey\"}}))","\n```\n"].join(''),["\n```clojure\n","(defn animation-styles [{:keys [time]}]\n  {:animation (str animation \" \" time \"s ease-in-out infinite\")})","\n```\n"].join(''),["\n```clojure\n","(defstyled with-anim :div\n  animation-styles)","\n```\n"].join(''),["\n```clojure\n","(defn animation-card [a o]\n  (html\n    [:div\n     [:p \"animation time: \" (:time @a) \" seconds\"]\n     [:button {:on-click #(swap! a update :time inc)} \"inc\"]\n     [:button {:on-click #(swap! a update :time dec)} \"dec\"]\n     (with-anim {:time (:time @a)} \"Some text here\")]))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"keyframes","keyframes",-1437976012)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"keyframes",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.animation_card,new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"time","time",1385887882),(1)], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
var className63023_63187 = "dv.cljs-emotion.devcards/with-anim2";
var fullClassName63024_63188 = "dv.cljs-emotion.devcards/with-anim2";
var children63025_63189 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__63026){
var map__63027 = p__63026;
var map__63027__$1 = cljs.core.__destructure_map(map__63027);
var amt = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__63027__$1,new cljs.core.Keyword(null,"amt","amt",-1785711538),(20));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"animation","animation",-1248293244),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(dv.cljs_emotion.keyframes(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.adjustHue(amt,"yellow")], null),new cljs.core.Keyword(null,"to","to",192099007),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"yellow"], null)], null)))," 2s ease-in-out infinite"].join('')], null);
})], null));
var children63025_63190__$1 = cljs.core.clj__GT_js(children63025_63189);
var component_type63021_63191 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"div");
var clss63022_63192 = component_type63021_63191.apply(component_type63021_63191,children63025_63190__$1);
dv.cljs_emotion.obj_set(clss63022_63192,"displayName","dv.cljs-emotion.devcards/with-anim2");

dv.cljs_emotion.devcards.with_anim2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss63022_63192,className63023_63187),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName63024_63188),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss63022_63192], null));

var x63028_63193 = dv.cljs_emotion.devcards.with_anim2;
(x63028_63193.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.with_anim2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"keyframes2","keyframes2",-701299326)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"keyframes2",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Animation can be defined dynamically as well - in the render.\n\n  This example also shows how you can pass any props to the underlying component - in this case onClick.\n\n  ```clojure\n  (defstyled with-anim2 :div\n    (fn [{:keys [amt] :or {amt 20}}]\n      {:animation\n        (str (keyframes\n          {:from {:background (p/adjustHue amt \"yellow\")}\n           :to   {:background \"yellow\"}})\n            \" 2s ease-in-out infinite\")}))\n\n  (html\n  [:div\n    [:p \"hue: \" (p/adjustHue (:amt @a) \"yellow\")]\n    [:button {:on-click #(swap! a update :amt (partial + 10))} \"inc\"]\n    [:button {:on-click #(swap! a update :amt (partial - 10))} \"dec\"]\n    (with-anim2 {:amt     (:amt @a)\n                 :onClick #(js/console.log \"ON CLICK\")} \"Some text here\")])\n  ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,o){
var G__63029 = "div";
var G__63030 = null;
var G__63031 = (function (){var G__63035 = "p";
var G__63036 = null;
var G__63037 = "hue: ";
var G__63038 = sablono.interpreter.interpret(module$node_modules$polished$dist$polished_cjs.adjustHue(new cljs.core.Keyword(null,"amt","amt",-1785711538).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)),"yellow"));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$4 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$4(G__63035,G__63036,G__63037,G__63038) : sablono.core.create_element.call(null,G__63035,G__63036,G__63037,G__63038));
})();
var G__63032 = (function (){var G__63039 = "button";
var G__63040 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"amt","amt",-1785711538),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,(10)));
})});
var G__63041 = "inc";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63039,G__63040,G__63041) : sablono.core.create_element.call(null,G__63039,G__63040,G__63041));
})();
var G__63033 = (function (){var G__63042 = "button";
var G__63043 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.update,new cljs.core.Keyword(null,"amt","amt",-1785711538),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._,(10)));
})});
var G__63044 = "dec";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63042,G__63043,G__63044) : sablono.core.create_element.call(null,G__63042,G__63043,G__63044));
})();
var G__63034 = sablono.interpreter.interpret((function (){var G__63045 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"amt","amt",-1785711538),new cljs.core.Keyword(null,"amt","amt",-1785711538).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(a)),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return console.log("ON CLICK");
})], null);
var G__63046 = "Some text here";
return (dv.cljs_emotion.devcards.with_anim2.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.with_anim2.cljs$core$IFn$_invoke$arity$2(G__63045,G__63046) : dv.cljs_emotion.devcards.with_anim2.call(null,G__63045,G__63046));
})());
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$6 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$6(G__63029,G__63030,G__63031,G__63032,G__63033,G__63034) : sablono.core.create_element.call(null,G__63029,G__63030,G__63031,G__63032,G__63033,G__63034));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"amt","amt",-1785711538),(20)], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
var className63049_63194 = "dv.cljs-emotion.devcards/multi";
var fullClassName63050_63195 = "dv.cljs-emotion.devcards/multi";
var children63051_63196 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"blue"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow"], null),({"borderRadius": (4)}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, ["border","1px solid grey"], null)], null),(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"white"], null)], null);
})], null));
var children63051_63197__$1 = cljs.core.clj__GT_js(children63051_63196);
var component_type63047_63198 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"div");
var clss63048_63199 = component_type63047_63198.apply(component_type63047_63198,children63051_63197__$1);
dv.cljs_emotion.obj_set(clss63048_63199,"displayName","dv.cljs-emotion.devcards/multi");

dv.cljs_emotion.devcards.multi = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss63048_63199,className63049_63194),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName63050_63195),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss63048_63199], null));

var x63052_63200 = dv.cljs_emotion.devcards.multi;
(x63052_63200.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.multi)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Multiple children are handled just like emotion:\n```clojure\n(defstyled multi :div\n  {:background \"blue\"}\n  {:color \"yellow\"}\n  #js{\"borderRadius\" 4}\n  [{\"border\" \"1px solid grey\"}]\n  (fn [_] {\":hover\" {:background \"white\"}}))\n\n(multi \"HELLO\")\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.multi.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.multi.cljs$core$IFn$_invoke$arity$1("HELLO") : dv.cljs_emotion.devcards.multi.call(null,"HELLO")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className63055_63201 = "dv.cljs-emotion.devcards/multi2";
var fullClassName63056_63202 = "dv.cljs-emotion.devcards/multi2";
var children63057_63203 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"blue"], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"yellow"], null),({"borderRadius": (4)}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, ["border","1px solid grey"], null)], null),(function (_){
return new cljs.core.PersistentArrayMap(null, 1, [":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"white"], null)], null);
})], null)], null));
var children63057_63204__$1 = cljs.core.clj__GT_js(children63057_63203);
var component_type63053_63205 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"div");
var clss63054_63206 = component_type63053_63205.apply(component_type63053_63205,children63057_63204__$1);
dv.cljs_emotion.obj_set(clss63054_63206,"displayName","dv.cljs-emotion.devcards/multi2");

dv.cljs_emotion.devcards.multi2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss63054_63206,className63055_63201),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName63056_63202),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss63054_63206], null));

var x63058_63207 = dv.cljs_emotion.devcards.multi2;
(x63058_63207.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.multi2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Anywhere an array is passed emotion will merge those styles, so you can also\n  pass multiple styles as a vector/array:\n\n```clojure\n(defstyled multi2 :div\n  [{:background \"blue\"}\n  {:color \"yellow\"}\n  #js{\"borderRadius\" 4}\n  [{\"border\" \"1px solid grey\"}]\n  (fn [_] {\":hover\" {:background \"white\"}})])\n\n(multi2 \"HELLO\")\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(dv.cljs_emotion.devcards.multi2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.multi2.cljs$core$IFn$_invoke$arity$1("HELLO") : dv.cljs_emotion.devcards.multi2.call(null,"HELLO")),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className63061_63208 = "dv.cljs-emotion.devcards/a-fn";
var fullClassName63062_63209 = "dv.cljs-emotion.devcards/a-fn";
var children63063_63210 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__63064){
var map__63065 = p__63064;
var map__63065__$1 = cljs.core.__destructure_map(map__63065);
var my_padding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63065__$1,new cljs.core.Keyword(null,"my-padding","my-padding",1389925511));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"padding","padding",1660304693),my_padding], null);
})], null));
var children63063_63211__$1 = cljs.core.clj__GT_js(children63063_63210);
var component_type63059_63212 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"button");
var clss63060_63213 = component_type63059_63212.apply(component_type63059_63212,children63063_63211__$1);
dv.cljs_emotion.obj_set(clss63060_63213,"displayName","dv.cljs-emotion.devcards/a-fn");

dv.cljs_emotion.devcards.a_fn = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss63060_63213,className63061_63208),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName63062_63209),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss63060_63213], null));

var x63066_63214 = dv.cljs_emotion.devcards.a_fn;
(x63066_63214.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.a_fn)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Any props you pass to the component at render time are converted to cljs data\n  structures via `js->clj` and then passed to any functions in defstyled. The output of your\n  function is then passed to `clj->js` and on to emotion.\n```clojure\n(defstyled a-fn :button\n  (fn [{:keys [my-padding]}]\n    {:padding my-padding}))\n\n  (a-fn\n    {:my-padding 20 :onClick #(js/console.log \"clicked\")\n     :another-key 5} \"This is a button\")\n```\n  ",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__63067 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"my-padding","my-padding",1389925511),(20),new cljs.core.Keyword(null,"onClick","onClick",-1991238530),(function (){
return console.log("clicked");
}),new cljs.core.Keyword(null,"another-key","another-key",1757915937),(5)], null);
var G__63068 = "This is a button";
return (dv.cljs_emotion.devcards.a_fn.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.devcards.a_fn.cljs$core$IFn$_invoke$arity$2(G__63067,G__63068) : dv.cljs_emotion.devcards.a_fn.call(null,G__63067,G__63068));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
var className63071_63215 = "dv.cljs-emotion.devcards/flex";
var fullClassName63072_63216 = "dv.cljs-emotion.devcards/flex";
var children63073_63217 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"flex-wrap","flex-wrap",455413707),"wrap",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"space-evenly"], null)], null));
var children63073_63218__$1 = cljs.core.clj__GT_js(children63073_63217);
var component_type63069_63219 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"div");
var clss63070_63220 = component_type63069_63219.apply(component_type63069_63219,children63073_63218__$1);
dv.cljs_emotion.obj_set(clss63070_63220,"displayName","dv.cljs-emotion.devcards/flex");

dv.cljs_emotion.devcards.flex = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss63070_63220,className63071_63215),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName63072_63216),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss63070_63220], null));

var x63074_63221 = dv.cljs_emotion.devcards.flex;
(x63074_63221.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.flex)))].join('');
}));

var className63077_63222 = "dv.cljs-emotion.devcards/box";
var fullClassName63078_63223 = "dv.cljs-emotion.devcards/box";
var children63079_63224 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"width","width",-384071477),"20%",new cljs.core.Keyword(null,"padding","padding",1660304693),"1rem 0",new cljs.core.Keyword(null,"display","display",242065432),"flex",new cljs.core.Keyword(null,"margin","margin",-995903681),"1rem",new cljs.core.Keyword(null,"justify-content","justify-content",-1990475787),"center",new cljs.core.Keyword(null,"background","background",-863952629),"palEvIoletrEd"], null)], null));
var children63079_63225__$1 = cljs.core.clj__GT_js(children63079_63224);
var component_type63075_63226 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"div");
var clss63076_63227 = component_type63075_63226.apply(component_type63075_63226,children63079_63225__$1);
dv.cljs_emotion.obj_set(clss63076_63227,"displayName","dv.cljs-emotion.devcards/box");

dv.cljs_emotion.devcards.box = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss63076_63227,className63077_63222),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName63078_63223),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss63076_63227], null));

var x63080_63228 = dv.cljs_emotion.devcards.box;
(x63080_63228.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box)))].join('');
}));

var className63083_63229 = "dv.cljs-emotion.devcards/box2";
var fullClassName63084_63230 = "dv.cljs-emotion.devcards/box2";
var children63085_63231 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"border-radius","border-radius",419594011),"4px",new cljs.core.Keyword(null,"user-select","user-select",-346451650),"none",new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.lighten(0.2,"palevioletred"),new cljs.core.Keyword(null,"cursor","cursor",1011937484),"pointer",":hover",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.darken(0.2,"palevioletred")], null),":active",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"background","background",-863952629),module$node_modules$polished$dist$polished_cjs.darken(0.4,"palevioletred"),new cljs.core.Keyword(null,"box-shadow","box-shadow",1600206755),"4px 4px lightgrey"], null)], null)], null));
var children63085_63232__$1 = cljs.core.clj__GT_js(children63085_63231);
var component_type63081_63233 = ((typeof dv.cljs_emotion.devcards.box === 'string')?dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,dv.cljs_emotion.devcards.box):(((dv.cljs_emotion.devcards.box instanceof cljs.core.Keyword))?dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"box"):(cljs.core.truth_(new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box)))?dv.cljs_emotion.styled.call(dv.cljs_emotion.styled,new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box))):dv.cljs_emotion.styled.call(dv.cljs_emotion.styled,dv.cljs_emotion.devcards.box)
)));
var clss63082_63234 = component_type63081_63233.apply(component_type63081_63233,children63085_63232__$1);
dv.cljs_emotion.obj_set(clss63082_63234,"displayName","dv.cljs-emotion.devcards/box2");

dv.cljs_emotion.devcards.box2 = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss63082_63234,className63083_63229),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName63084_63230),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss63082_63234], null));

var x63086_63235 = dv.cljs_emotion.devcards.box2;
(x63086_63235.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.box2)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"flex-card","flex-card",-1954027863)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"flex-card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Here is a somewhat larger example, showing the extension feature of emotion to override styles.\n\n  This example using the polished library as well.\n\n```clojure\n(defstyled flex :div\n  {:display         \"flex\"\n   :flex-wrap       \"wrap\"\n   :justify-content \"space-evenly\"})\n\n(defstyled box :div\n  {:width           \"20%\"\n   :padding         \"1rem 0\"\n   :display         \"flex\"\n   :margin          \"1rem\"\n   :justify-content \"center\"\n   :background      \"palEvIoletrEd\"})\n\n\n(defstyled box2 box\n  {:border-radius \"4px\"\n   :user-select   \"none\"\n   :background    (p/lighten 0.2 \"palevioletred\")\n   :cursor        \"pointer\"\n   \":hover\"       {:background (darken 0.2 \"palevioletred\")}\n   \":active\"      {:background (darken 0.4 \"palevioletred\")\n                   :box-shadow \"4px 4px lightgrey\"}})\n\n(flex (box \"box\") (box \"box\") (box \"box\") (box2 \"box2\") (box2 \"box2\") (box \"box\") (box \"box\") (box2 \"box2\") (box \"box\")))\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var G__63087 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__63088 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__63089 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__63090 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__63091 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__63092 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__63093 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
var G__63094 = (dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box2.cljs$core$IFn$_invoke$arity$1("box2") : dv.cljs_emotion.devcards.box2.call(null,"box2"));
var G__63095 = (dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.box.cljs$core$IFn$_invoke$arity$1("box") : dv.cljs_emotion.devcards.box.call(null,"box"));
return (dv.cljs_emotion.devcards.flex.cljs$core$IFn$_invoke$arity$9 ? dv.cljs_emotion.devcards.flex.cljs$core$IFn$_invoke$arity$9(G__63087,G__63088,G__63089,G__63090,G__63091,G__63092,G__63093,G__63094,G__63095) : dv.cljs_emotion.devcards.flex.call(null,G__63087,G__63088,G__63089,G__63090,G__63091,G__63092,G__63093,G__63094,G__63095));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"update-global-styles","update-global-styles",1487171421)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"update-global-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  This example changes the body background of this page's body color.\n  ```clojure\n  [:div\n         [:label \"Input a color for the background color:\"]\n         [:input {:value bg :on-change #(swap! a assoc :bg (-> % .-target .-value))}]\n         (global-style {:body {:background bg}})]\n   ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,_){
var map__63097 = cljs.core.deref(a);
var map__63097__$1 = cljs.core.__destructure_map(map__63097);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63097__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
var G__63100 = "div";
var G__63101 = null;
var G__63102 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("label",null,"Input a color for the background color:") : sablono.core.create_element.call(null,"label",null,"Input a color for the background color:"));
var G__63103 = sablono.interpreter.create_element("input",({"value": bg, "onChange": (function (p1__63096_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),p1__63096_SHARP_.target.value);
})}));
var G__63104 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),bg], null)], null)));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__63100,G__63101,G__63102,G__63103,G__63104) : sablono.core.create_element.call(null,G__63100,G__63101,G__63102,G__63103,G__63104));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"#cce"], null),new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.start_bg = "#eeaabb";
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"update-card-bg-styles","update-card-bg-styles",-771594595)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"update-card-bg-styles",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"\n  This example changes the background color of this card.\n  ```clojure\n  (let [{:keys [bg]} @a\n          cls :.my-card]\n      (html\n        [:div\n         [:label \"Input a color for the background:\"]\n         [:input {:value bg :on-change #(swap! a assoc :bg (-> % .-target .-value))}]\n         [:button {:on-click #(swap! a assoc :bg start-bg)} \"reset\"]\n         [:button\n          {:on-click\n           #(swap! a assoc :bg (p/lighten 0.08 bg))} \"lighten\"]\n\n         [:button\n          {:on-click\n           #(swap! a assoc :bg (p/darken 0.08 bg))} \"darken\"]\n         (global-style {cls {:background bg}})]))\n   ```",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (a,_){
var map__63106 = cljs.core.deref(a);
var map__63106__$1 = cljs.core.__destructure_map(map__63106);
var bg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63106__$1,new cljs.core.Keyword(null,"bg","bg",-206688421));
var cls = new cljs.core.Keyword(null,".my-card",".my-card",1656982961);
var G__63109 = "div";
var G__63110 = null;
var G__63111 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("label",null,"Input a color for the background:") : sablono.core.create_element.call(null,"label",null,"Input a color for the background:"));
var G__63112 = sablono.interpreter.create_element("input",({"value": bg, "onChange": (function (p1__63105_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),p1__63105_SHARP_.target.value);
})}));
var G__63113 = (function (){var G__63117 = "button";
var G__63118 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),dv.cljs_emotion.devcards.start_bg);
})});
var G__63119 = "reset";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63117,G__63118,G__63119) : sablono.core.create_element.call(null,G__63117,G__63118,G__63119));
})();
var G__63114 = (function (){var G__63120 = "button";
var G__63121 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),module$node_modules$polished$dist$polished_cjs.lighten(0.08,bg));
})});
var G__63122 = "lighten";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63120,G__63121,G__63122) : sablono.core.create_element.call(null,G__63120,G__63121,G__63122));
})();
var G__63115 = (function (){var G__63123 = "button";
var G__63124 = ({"onClick": (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,cljs.core.assoc,new cljs.core.Keyword(null,"bg","bg",-206688421),module$node_modules$polished$dist$polished_cjs.darken(0.08,bg));
})});
var G__63125 = "darken";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63123,G__63124,G__63125) : sablono.core.create_element.call(null,G__63123,G__63124,G__63125));
})();
var G__63116 = sablono.interpreter.interpret(dv.cljs_emotion.global_style(cljs.core.PersistentArrayMap.createAsIfByAssoc([cls,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),bg], null)])));
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$8 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$8(G__63109,G__63110,G__63111,G__63112,G__63113,G__63114,G__63115,G__63116) : sablono.core.create_element.call(null,G__63109,G__63110,G__63111,G__63112,G__63113,G__63114,G__63115,G__63116));
}),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),dv.cljs_emotion.devcards.start_bg], null),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"classname","classname",777390796),"my-card"], null)], null));
})], null));
var className63128_63236 = "dv.cljs-emotion.devcards/test-theme";
var fullClassName63129_63237 = "dv.cljs-emotion.devcards/test-theme";
var children63130_63238 = clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(false),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (p__63131){
var map__63132 = p__63131;
var map__63132__$1 = cljs.core.__destructure_map(map__63132);
var theme = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63132__$1,new cljs.core.Keyword(null,"theme","theme",-1247880880));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"bg","bg",-206688421).cljs$core$IFn$_invoke$arity$1(theme);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "blue";
}
})()], null);
})], null));
var children63130_63239__$1 = cljs.core.clj__GT_js(children63130_63238);
var component_type63126_63240 = dv.cljs_emotion.obj_get(dv.cljs_emotion.styled,"div");
var clss63127_63241 = component_type63126_63240.apply(component_type63126_63240,children63130_63239__$1);
dv.cljs_emotion.obj_set(clss63127_63241,"displayName","dv.cljs-emotion.devcards/test-theme");

dv.cljs_emotion.devcards.test_theme = cljs.core.with_meta(dv.cljs_emotion.react_factory(clss63127_63241,className63128_63236),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661),dv.cljs_emotion.hashit(fullClassName63129_63237),new cljs.core.Keyword("dv.cljs-emotion","styled","dv.cljs-emotion/styled",764203097),clss63127_63241], null));

var x63133_63242 = dv.cljs_emotion.devcards.test_theme;
(x63133_63242.toString = (function (){
var this__62551__auto__ = this;
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(dv.cljs_emotion.devcards.test_theme)))].join('');
}));

devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"theme-provider-card","theme-provider-card",-1686140511)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"theme-provider-card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),"Theme use is straight forward.\n\n  It wraps emotion's ThemeProvider calling clj->js first on the props.\n  Wrap your application with `theme-provider` passing it\n  a map or JS object of theme data.\n```clojure\n(defstyled test-theme :div\n  (fn [{:keys [theme]}]\n    {:background (or (:bg theme) \"blue\")}))\n\n(html\n  [:div\n   (theme-provider {:theme {:bg \"yellow\"}} (test-theme \"Hello there theme\"))\n   (test-theme \"no theme\")])\n```\n",new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),(function (){var attrs63134 = dv.cljs_emotion.theme_provider.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"theme","theme",-1247880880),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"yellow"], null)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("Hello there theme") : dv.cljs_emotion.devcards.test_theme.call(null,"Hello there theme"))], 0));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(sablono.core.create_element,"div",((cljs.core.map_QMARK_(attrs63134))?sablono.interpreter.attributes(attrs63134):null),((cljs.core.map_QMARK_(attrs63134))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret((dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("no theme") : dv.cljs_emotion.devcards.test_theme.call(null,"no theme")))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs63134),sablono.interpreter.interpret((dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.devcards.test_theme.cljs$core$IFn$_invoke$arity$1("no theme") : dv.cljs_emotion.devcards.test_theme.call(null,"no theme")))], null)));
})(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.PersistentArrayMap.EMPTY], null));
})], null));
dv.cljs_emotion.devcards.anon_styles = (function dv$cljs_emotion$devcards$anon_styles(){
var attrs63135 = (function (){var G__63136 = "div";
var G__63137 = cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163),clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(true),new cljs.core.Keyword(null,"css","css",1135045163).cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null)))));
var G__63138 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("p",null,"Some text on a lightgrey background.") : sablono.core.create_element.call(null,"p",null,"Some text on a lightgrey background."));
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3(G__63136,G__63137,G__63138) : dv.cljs_emotion.jsx_STAR_.call(null,G__63136,G__63137,G__63138));
})();
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(sablono.core.create_element,"div",((cljs.core.map_QMARK_(attrs63135))?sablono.interpreter.attributes(attrs63135):null),((cljs.core.map_QMARK_(attrs63135))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(dv.cljs_emotion.theme_provider.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"theme","theme",-1247880880),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"salmon"], null)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (){var G__63141 = "div";
var G__63142 = cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"white"], null),({"border": "1px solid"}),(function (t){
console.log("THEME :  ",t);

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"bg","bg",-206688421).cljs$core$IFn$_invoke$arity$1(t);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "lightgrey";
}
})()], null);
})], null)], null),new cljs.core.Keyword(null,"css","css",1135045163),clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(true),new cljs.core.Keyword(null,"css","css",1135045163).cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"white"], null),({"border": "1px solid"}),(function (t){
console.log("THEME :  ",t);

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"bg","bg",-206688421).cljs$core$IFn$_invoke$arity$1(t);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "lightgrey";
}
})()], null);
})], null)], null)))));
var G__63143 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("p",null,"Some text on a salmon background.") : sablono.core.create_element.call(null,"p",null,"Some text on a salmon background."));
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3(G__63141,G__63142,G__63143) : dv.cljs_emotion.jsx_STAR_.call(null,G__63141,G__63142,G__63143));
})()], 0)))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs63135),sablono.interpreter.interpret(dv.cljs_emotion.theme_provider.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"theme","theme",-1247880880),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bg","bg",-206688421),"salmon"], null)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (){var G__63146 = "div";
var G__63147 = cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"white"], null),({"border": "1px solid"}),(function (t){
console.log("THEME :  ",t);

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"bg","bg",-206688421).cljs$core$IFn$_invoke$arity$1(t);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "lightgrey";
}
})()], null);
})], null)], null),new cljs.core.Keyword(null,"css","css",1135045163),clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(true),new cljs.core.Keyword(null,"css","css",1135045163).cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"color","color",1011675173),"white"], null),({"border": "1px solid"}),(function (t){
console.log("THEME :  ",t);

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"bg","bg",-206688421).cljs$core$IFn$_invoke$arity$1(t);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "lightgrey";
}
})()], null);
})], null)], null)))));
var G__63148 = (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3("p",null,"Some text on a salmon background.") : sablono.core.create_element.call(null,"p",null,"Some text on a salmon background."));
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3(G__63146,G__63147,G__63148) : dv.cljs_emotion.jsx_STAR_.call(null,G__63146,G__63147,G__63148));
})()], 0)))], null)));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["# Anonymous inline styles support.\n   You can use the `jsx` helper to style a react element inline without needing to create a component.",["\n```clojure\n","(defn anon-styles []\n  (html [:div\n         (jsx :div {:css {:background \"lightgrey\"}}\n           (html [:p \"Some text on a lightgrey background.\"]))\n         (theme-provider {:theme {:bg \"salmon\"}}\n           (jsx :div {:css\n                      [{:color \"white\"}\n                       #js{:border \"1px solid\"}\n                       (fn [t]\n                         (.log js/console \"THEME :  \" t)\n                         {:background (or (:bg t) \"lightgrey\")})]}\n             (html [:p \"Some text on a salmon background.\"])))]))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.anon_styles(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.anon_styles2 = (function dv$cljs_emotion$devcards$anon_styles2(){
var G__63151 = "div";
var G__63152 = cljs.core.clj__GT_js(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null),new cljs.core.Keyword(null,"css","css",1135045163),clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(true),new cljs.core.Keyword(null,"css","css",1135045163).cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"css","css",1135045163),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"background","background",-863952629),"lightgrey"], null)], null)))));
var G__63153 = (function (){var G__63156 = "div";
var G__63157 = null;
var G__63158 = (function (){var G__63161 = "div";
var G__63162 = null;
var G__63163 = (function (){var G__63164 = "div";
var G__63165 = ({"key": (1)});
var G__63166 = "Hello";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63164,G__63165,G__63166) : sablono.core.create_element.call(null,G__63164,G__63165,G__63166));
})();
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63161,G__63162,G__63163) : sablono.core.create_element.call(null,G__63161,G__63162,G__63163));
})();
var G__63159 = (function (){var G__63167 = "div";
var G__63168 = ({"key": (2)});
var G__63169 = "Hello2";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63167,G__63168,G__63169) : sablono.core.create_element.call(null,G__63167,G__63168,G__63169));
})();
var G__63160 = (function (){var G__63170 = "div";
var G__63171 = ({"key": (3)});
var G__63172 = "Hello3";
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$3 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$3(G__63170,G__63171,G__63172) : sablono.core.create_element.call(null,G__63170,G__63171,G__63172));
})();
return (sablono.core.create_element.cljs$core$IFn$_invoke$arity$5 ? sablono.core.create_element.cljs$core$IFn$_invoke$arity$5(G__63156,G__63157,G__63158,G__63159,G__63160) : sablono.core.create_element.call(null,G__63156,G__63157,G__63158,G__63159,G__63160));
})();
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3(G__63151,G__63152,G__63153) : dv.cljs_emotion.jsx_STAR_.call(null,G__63151,G__63152,G__63153));
});
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),devcards.core.markdown__GT_react.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Multiple children are wrapped in a react fragment.",["\n```clojure\n","(defn anon-styles2 []\n  (jsx :div {:css {:background \"lightgrey\"}}\n    (html\n      [:div\n       [:div [:div {:key 1} \"Hello\"]]\n       [:div {:key 2} \"Hello2\"]\n       [:div {:key 3} \"Hello3\"]])))","\n```\n"].join('')], 0)),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"hide-border","hide-border",1463657151),true], null))], 0))], null));
})], null));
devcards.core.register_card(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dv.cljs_emotion.devcards","dv.cljs_emotion.devcards",540490030),new cljs.core.Keyword(null,"card","card",-1430355152)], null),new cljs.core.Keyword(null,"func","func",-238706040),(function (){
return devcards.core.card_base(new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),"card",new cljs.core.Keyword(null,"documentation","documentation",1889593999),null,new cljs.core.Keyword(null,"main-obj","main-obj",-1544409742),dv.cljs_emotion.devcards.anon_styles2(),new cljs.core.Keyword(null,"initial-data","initial-data",-1315709804),null,new cljs.core.Keyword(null,"options","options",99638489),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"heading","heading",-1312171873),false], null),devcards.core.assert_options_map(null)], 0))], null));
})], null));
dv.cljs_emotion.devcards.main = (function dv$cljs_emotion$devcards$main(){
return devcards.core.start_devcard_ui_BANG__STAR_.cljs$core$IFn$_invoke$arity$0();
});
goog.exportSymbol('dv.cljs_emotion.devcards.main', dv.cljs_emotion.devcards.main);

//# sourceMappingURL=dv.cljs_emotion.devcards.js.map
