goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__44559 = arguments.length;
switch (G__44559) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44570 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44570 = (function (f,blockable,meta44571){
this.f = f;
this.blockable = blockable;
this.meta44571 = meta44571;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44570.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44572,meta44571__$1){
var self__ = this;
var _44572__$1 = this;
return (new cljs.core.async.t_cljs$core$async44570(self__.f,self__.blockable,meta44571__$1));
}));

(cljs.core.async.t_cljs$core$async44570.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44572){
var self__ = this;
var _44572__$1 = this;
return self__.meta44571;
}));

(cljs.core.async.t_cljs$core$async44570.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44570.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44570.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async44570.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async44570.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta44571","meta44571",1424970121,null)], null);
}));

(cljs.core.async.t_cljs$core$async44570.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44570.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44570");

(cljs.core.async.t_cljs$core$async44570.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44570");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44570.
 */
cljs.core.async.__GT_t_cljs$core$async44570 = (function cljs$core$async$__GT_t_cljs$core$async44570(f__$1,blockable__$1,meta44571){
return (new cljs.core.async.t_cljs$core$async44570(f__$1,blockable__$1,meta44571));
});

}

return (new cljs.core.async.t_cljs$core$async44570(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__44639 = arguments.length;
switch (G__44639) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__44656 = arguments.length;
switch (G__44656) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__44665 = arguments.length;
switch (G__44665) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_47937 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47937) : fn1.call(null,val_47937));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_47937) : fn1.call(null,val_47937));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__44688 = arguments.length;
switch (G__44688) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___47946 = n;
var x_47947 = (0);
while(true){
if((x_47947 < n__4741__auto___47946)){
(a[x_47947] = x_47947);

var G__47948 = (x_47947 + (1));
x_47947 = G__47948;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44726 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44726 = (function (flag,meta44727){
this.flag = flag;
this.meta44727 = meta44727;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44726.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44728,meta44727__$1){
var self__ = this;
var _44728__$1 = this;
return (new cljs.core.async.t_cljs$core$async44726(self__.flag,meta44727__$1));
}));

(cljs.core.async.t_cljs$core$async44726.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44728){
var self__ = this;
var _44728__$1 = this;
return self__.meta44727;
}));

(cljs.core.async.t_cljs$core$async44726.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44726.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44726.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44726.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async44726.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta44727","meta44727",1579586196,null)], null);
}));

(cljs.core.async.t_cljs$core$async44726.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44726.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44726");

(cljs.core.async.t_cljs$core$async44726.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44726");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44726.
 */
cljs.core.async.__GT_t_cljs$core$async44726 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async44726(flag__$1,meta44727){
return (new cljs.core.async.t_cljs$core$async44726(flag__$1,meta44727));
});

}

return (new cljs.core.async.t_cljs$core$async44726(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async44768 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async44768 = (function (flag,cb,meta44769){
this.flag = flag;
this.cb = cb;
this.meta44769 = meta44769;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async44768.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44770,meta44769__$1){
var self__ = this;
var _44770__$1 = this;
return (new cljs.core.async.t_cljs$core$async44768(self__.flag,self__.cb,meta44769__$1));
}));

(cljs.core.async.t_cljs$core$async44768.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44770){
var self__ = this;
var _44770__$1 = this;
return self__.meta44769;
}));

(cljs.core.async.t_cljs$core$async44768.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async44768.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async44768.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async44768.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async44768.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta44769","meta44769",-1133479764,null)], null);
}));

(cljs.core.async.t_cljs$core$async44768.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async44768.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async44768");

(cljs.core.async.t_cljs$core$async44768.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async44768");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async44768.
 */
cljs.core.async.__GT_t_cljs$core$async44768 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async44768(flag__$1,cb__$1,meta44769){
return (new cljs.core.async.t_cljs$core$async44768(flag__$1,cb__$1,meta44769));
});

}

return (new cljs.core.async.t_cljs$core$async44768(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44771_SHARP_){
var G__44783 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44771_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44783) : fret.call(null,G__44783));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__44772_SHARP_){
var G__44785 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__44772_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__44785) : fret.call(null,G__44785));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__47955 = (i + (1));
i = G__47955;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4251__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___47956 = arguments.length;
var i__4865__auto___47957 = (0);
while(true){
if((i__4865__auto___47957 < len__4864__auto___47956)){
args__4870__auto__.push((arguments[i__4865__auto___47957]));

var G__47958 = (i__4865__auto___47957 + (1));
i__4865__auto___47957 = G__47958;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__44818){
var map__44819 = p__44818;
var map__44819__$1 = cljs.core.__destructure_map(map__44819);
var opts = map__44819__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq44800){
var G__44801 = cljs.core.first(seq44800);
var seq44800__$1 = cljs.core.next(seq44800);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44801,seq44800__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__44864 = arguments.length;
switch (G__44864) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__44466__auto___47962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_44922){
var state_val_44923 = (state_44922[(1)]);
if((state_val_44923 === (7))){
var inst_44918 = (state_44922[(2)]);
var state_44922__$1 = state_44922;
var statearr_44941_47963 = state_44922__$1;
(statearr_44941_47963[(2)] = inst_44918);

(statearr_44941_47963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (1))){
var state_44922__$1 = state_44922;
var statearr_44945_47965 = state_44922__$1;
(statearr_44945_47965[(2)] = null);

(statearr_44945_47965[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (4))){
var inst_44885 = (state_44922[(7)]);
var inst_44885__$1 = (state_44922[(2)]);
var inst_44890 = (inst_44885__$1 == null);
var state_44922__$1 = (function (){var statearr_44952 = state_44922;
(statearr_44952[(7)] = inst_44885__$1);

return statearr_44952;
})();
if(cljs.core.truth_(inst_44890)){
var statearr_44953_47969 = state_44922__$1;
(statearr_44953_47969[(1)] = (5));

} else {
var statearr_44956_47971 = state_44922__$1;
(statearr_44956_47971[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (13))){
var state_44922__$1 = state_44922;
var statearr_44959_47972 = state_44922__$1;
(statearr_44959_47972[(2)] = null);

(statearr_44959_47972[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (6))){
var inst_44885 = (state_44922[(7)]);
var state_44922__$1 = state_44922;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_44922__$1,(11),to,inst_44885);
} else {
if((state_val_44923 === (3))){
var inst_44920 = (state_44922[(2)]);
var state_44922__$1 = state_44922;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44922__$1,inst_44920);
} else {
if((state_val_44923 === (12))){
var state_44922__$1 = state_44922;
var statearr_44963_47973 = state_44922__$1;
(statearr_44963_47973[(2)] = null);

(statearr_44963_47973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (2))){
var state_44922__$1 = state_44922;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44922__$1,(4),from);
} else {
if((state_val_44923 === (11))){
var inst_44911 = (state_44922[(2)]);
var state_44922__$1 = state_44922;
if(cljs.core.truth_(inst_44911)){
var statearr_44966_47975 = state_44922__$1;
(statearr_44966_47975[(1)] = (12));

} else {
var statearr_44967_47978 = state_44922__$1;
(statearr_44967_47978[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (9))){
var state_44922__$1 = state_44922;
var statearr_44969_47979 = state_44922__$1;
(statearr_44969_47979[(2)] = null);

(statearr_44969_47979[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (5))){
var state_44922__$1 = state_44922;
if(cljs.core.truth_(close_QMARK_)){
var statearr_44970_47981 = state_44922__$1;
(statearr_44970_47981[(1)] = (8));

} else {
var statearr_44971_47982 = state_44922__$1;
(statearr_44971_47982[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (14))){
var inst_44916 = (state_44922[(2)]);
var state_44922__$1 = state_44922;
var statearr_44976_47983 = state_44922__$1;
(statearr_44976_47983[(2)] = inst_44916);

(statearr_44976_47983[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (10))){
var inst_44908 = (state_44922[(2)]);
var state_44922__$1 = state_44922;
var statearr_44977_47985 = state_44922__$1;
(statearr_44977_47985[(2)] = inst_44908);

(statearr_44977_47985[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_44923 === (8))){
var inst_44901 = cljs.core.async.close_BANG_(to);
var state_44922__$1 = state_44922;
var statearr_44984_47986 = state_44922__$1;
(statearr_44984_47986[(2)] = inst_44901);

(statearr_44984_47986[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_44987 = [null,null,null,null,null,null,null,null];
(statearr_44987[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_44987[(1)] = (1));

return statearr_44987;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_44922){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_44922);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e44990){var ex__44385__auto__ = e44990;
var statearr_44991_47989 = state_44922;
(statearr_44991_47989[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_44922[(4)]))){
var statearr_44992_47990 = state_44922;
(statearr_44992_47990[(1)] = cljs.core.first((state_44922[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47991 = state_44922;
state_44922 = G__47991;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_44922){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_44922);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_44998 = f__44467__auto__();
(statearr_44998[(6)] = c__44466__auto___47962);

return statearr_44998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__45002){
var vec__45003 = p__45002;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45003,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45003,(1),null);
var job = vec__45003;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__44466__auto___47992 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_45013){
var state_val_45014 = (state_45013[(1)]);
if((state_val_45014 === (1))){
var state_45013__$1 = state_45013;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45013__$1,(2),res,v);
} else {
if((state_val_45014 === (2))){
var inst_45010 = (state_45013[(2)]);
var inst_45011 = cljs.core.async.close_BANG_(res);
var state_45013__$1 = (function (){var statearr_45023 = state_45013;
(statearr_45023[(7)] = inst_45010);

return statearr_45023;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_45013__$1,inst_45011);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0 = (function (){
var statearr_45025 = [null,null,null,null,null,null,null,null];
(statearr_45025[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__);

(statearr_45025[(1)] = (1));

return statearr_45025;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1 = (function (state_45013){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45013);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45026){var ex__44385__auto__ = e45026;
var statearr_45027_47997 = state_45013;
(statearr_45027_47997[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45013[(4)]))){
var statearr_45028_47998 = state_45013;
(statearr_45028_47998[(1)] = cljs.core.first((state_45013[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47999 = state_45013;
state_45013 = G__47999;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = function(state_45013){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1.call(this,state_45013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_45029 = f__44467__auto__();
(statearr_45029[(6)] = c__44466__auto___47992);

return statearr_45029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__45040){
var vec__45045 = p__45040;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45045,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45045,(1),null);
var job = vec__45045;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4741__auto___48002 = n;
var __48003 = (0);
while(true){
if((__48003 < n__4741__auto___48002)){
var G__45057_48004 = type;
var G__45057_48005__$1 = (((G__45057_48004 instanceof cljs.core.Keyword))?G__45057_48004.fqn:null);
switch (G__45057_48005__$1) {
case "compute":
var c__44466__auto___48007 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48003,c__44466__auto___48007,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async){
return (function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = ((function (__48003,c__44466__auto___48007,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async){
return (function (state_45070){
var state_val_45071 = (state_45070[(1)]);
if((state_val_45071 === (1))){
var state_45070__$1 = state_45070;
var statearr_45076_48011 = state_45070__$1;
(statearr_45076_48011[(2)] = null);

(statearr_45076_48011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (2))){
var state_45070__$1 = state_45070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45070__$1,(4),jobs);
} else {
if((state_val_45071 === (3))){
var inst_45068 = (state_45070[(2)]);
var state_45070__$1 = state_45070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45070__$1,inst_45068);
} else {
if((state_val_45071 === (4))){
var inst_45060 = (state_45070[(2)]);
var inst_45061 = process(inst_45060);
var state_45070__$1 = state_45070;
if(cljs.core.truth_(inst_45061)){
var statearr_45079_48012 = state_45070__$1;
(statearr_45079_48012[(1)] = (5));

} else {
var statearr_45080_48019 = state_45070__$1;
(statearr_45080_48019[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (5))){
var state_45070__$1 = state_45070;
var statearr_45081_48021 = state_45070__$1;
(statearr_45081_48021[(2)] = null);

(statearr_45081_48021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (6))){
var state_45070__$1 = state_45070;
var statearr_45084_48028 = state_45070__$1;
(statearr_45084_48028[(2)] = null);

(statearr_45084_48028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45071 === (7))){
var inst_45066 = (state_45070[(2)]);
var state_45070__$1 = state_45070;
var statearr_45085_48029 = state_45070__$1;
(statearr_45085_48029[(2)] = inst_45066);

(statearr_45085_48029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48003,c__44466__auto___48007,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async))
;
return ((function (__48003,switch__44381__auto__,c__44466__auto___48007,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0 = (function (){
var statearr_45086 = [null,null,null,null,null,null,null];
(statearr_45086[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__);

(statearr_45086[(1)] = (1));

return statearr_45086;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1 = (function (state_45070){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45070);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45087){var ex__44385__auto__ = e45087;
var statearr_45088_48037 = state_45070;
(statearr_45088_48037[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45070[(4)]))){
var statearr_45089_48039 = state_45070;
(statearr_45089_48039[(1)] = cljs.core.first((state_45070[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48040 = state_45070;
state_45070 = G__48040;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = function(state_45070){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1.call(this,state_45070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__;
})()
;})(__48003,switch__44381__auto__,c__44466__auto___48007,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async))
})();
var state__44468__auto__ = (function (){var statearr_45093 = f__44467__auto__();
(statearr_45093[(6)] = c__44466__auto___48007);

return statearr_45093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
});})(__48003,c__44466__auto___48007,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async))
);


break;
case "async":
var c__44466__auto___48041 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__48003,c__44466__auto___48041,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async){
return (function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = ((function (__48003,c__44466__auto___48041,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async){
return (function (state_45110){
var state_val_45111 = (state_45110[(1)]);
if((state_val_45111 === (1))){
var state_45110__$1 = state_45110;
var statearr_45114_48042 = state_45110__$1;
(statearr_45114_48042[(2)] = null);

(statearr_45114_48042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45111 === (2))){
var state_45110__$1 = state_45110;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45110__$1,(4),jobs);
} else {
if((state_val_45111 === (3))){
var inst_45108 = (state_45110[(2)]);
var state_45110__$1 = state_45110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45110__$1,inst_45108);
} else {
if((state_val_45111 === (4))){
var inst_45096 = (state_45110[(2)]);
var inst_45097 = async(inst_45096);
var state_45110__$1 = state_45110;
if(cljs.core.truth_(inst_45097)){
var statearr_45123_48051 = state_45110__$1;
(statearr_45123_48051[(1)] = (5));

} else {
var statearr_45128_48053 = state_45110__$1;
(statearr_45128_48053[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45111 === (5))){
var state_45110__$1 = state_45110;
var statearr_45130_48057 = state_45110__$1;
(statearr_45130_48057[(2)] = null);

(statearr_45130_48057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45111 === (6))){
var state_45110__$1 = state_45110;
var statearr_45135_48058 = state_45110__$1;
(statearr_45135_48058[(2)] = null);

(statearr_45135_48058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45111 === (7))){
var inst_45102 = (state_45110[(2)]);
var state_45110__$1 = state_45110;
var statearr_45140_48059 = state_45110__$1;
(statearr_45140_48059[(2)] = inst_45102);

(statearr_45140_48059[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__48003,c__44466__auto___48041,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async))
;
return ((function (__48003,switch__44381__auto__,c__44466__auto___48041,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0 = (function (){
var statearr_45146 = [null,null,null,null,null,null,null];
(statearr_45146[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__);

(statearr_45146[(1)] = (1));

return statearr_45146;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1 = (function (state_45110){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45110);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45149){var ex__44385__auto__ = e45149;
var statearr_45150_48066 = state_45110;
(statearr_45150_48066[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45110[(4)]))){
var statearr_45151_48067 = state_45110;
(statearr_45151_48067[(1)] = cljs.core.first((state_45110[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48068 = state_45110;
state_45110 = G__48068;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = function(state_45110){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1.call(this,state_45110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__;
})()
;})(__48003,switch__44381__auto__,c__44466__auto___48041,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async))
})();
var state__44468__auto__ = (function (){var statearr_45152 = f__44467__auto__();
(statearr_45152[(6)] = c__44466__auto___48041);

return statearr_45152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
});})(__48003,c__44466__auto___48041,G__45057_48004,G__45057_48005__$1,n__4741__auto___48002,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__45057_48005__$1)].join('')));

}

var G__48069 = (__48003 + (1));
__48003 = G__48069;
continue;
} else {
}
break;
}

var c__44466__auto___48070 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_45182){
var state_val_45183 = (state_45182[(1)]);
if((state_val_45183 === (7))){
var inst_45177 = (state_45182[(2)]);
var state_45182__$1 = state_45182;
var statearr_45194_48072 = state_45182__$1;
(statearr_45194_48072[(2)] = inst_45177);

(statearr_45194_48072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45183 === (1))){
var state_45182__$1 = state_45182;
var statearr_45201_48074 = state_45182__$1;
(statearr_45201_48074[(2)] = null);

(statearr_45201_48074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45183 === (4))){
var inst_45157 = (state_45182[(7)]);
var inst_45157__$1 = (state_45182[(2)]);
var inst_45158 = (inst_45157__$1 == null);
var state_45182__$1 = (function (){var statearr_45218 = state_45182;
(statearr_45218[(7)] = inst_45157__$1);

return statearr_45218;
})();
if(cljs.core.truth_(inst_45158)){
var statearr_45219_48075 = state_45182__$1;
(statearr_45219_48075[(1)] = (5));

} else {
var statearr_45220_48076 = state_45182__$1;
(statearr_45220_48076[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45183 === (6))){
var inst_45162 = (state_45182[(8)]);
var inst_45157 = (state_45182[(7)]);
var inst_45162__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_45168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_45169 = [inst_45157,inst_45162__$1];
var inst_45170 = (new cljs.core.PersistentVector(null,2,(5),inst_45168,inst_45169,null));
var state_45182__$1 = (function (){var statearr_45226 = state_45182;
(statearr_45226[(8)] = inst_45162__$1);

return statearr_45226;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45182__$1,(8),jobs,inst_45170);
} else {
if((state_val_45183 === (3))){
var inst_45179 = (state_45182[(2)]);
var state_45182__$1 = state_45182;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45182__$1,inst_45179);
} else {
if((state_val_45183 === (2))){
var state_45182__$1 = state_45182;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45182__$1,(4),from);
} else {
if((state_val_45183 === (9))){
var inst_45174 = (state_45182[(2)]);
var state_45182__$1 = (function (){var statearr_45241 = state_45182;
(statearr_45241[(9)] = inst_45174);

return statearr_45241;
})();
var statearr_45243_48077 = state_45182__$1;
(statearr_45243_48077[(2)] = null);

(statearr_45243_48077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45183 === (5))){
var inst_45160 = cljs.core.async.close_BANG_(jobs);
var state_45182__$1 = state_45182;
var statearr_45252_48078 = state_45182__$1;
(statearr_45252_48078[(2)] = inst_45160);

(statearr_45252_48078[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45183 === (8))){
var inst_45162 = (state_45182[(8)]);
var inst_45172 = (state_45182[(2)]);
var state_45182__$1 = (function (){var statearr_45260 = state_45182;
(statearr_45260[(10)] = inst_45172);

return statearr_45260;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45182__$1,(9),results,inst_45162);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0 = (function (){
var statearr_45270 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_45270[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__);

(statearr_45270[(1)] = (1));

return statearr_45270;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1 = (function (state_45182){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45182);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45273){var ex__44385__auto__ = e45273;
var statearr_45274_48085 = state_45182;
(statearr_45274_48085[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45182[(4)]))){
var statearr_45276_48086 = state_45182;
(statearr_45276_48086[(1)] = cljs.core.first((state_45182[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48087 = state_45182;
state_45182 = G__48087;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = function(state_45182){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1.call(this,state_45182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_45284 = f__44467__auto__();
(statearr_45284[(6)] = c__44466__auto___48070);

return statearr_45284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


var c__44466__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_45342){
var state_val_45343 = (state_45342[(1)]);
if((state_val_45343 === (7))){
var inst_45338 = (state_45342[(2)]);
var state_45342__$1 = state_45342;
var statearr_45354_48088 = state_45342__$1;
(statearr_45354_48088[(2)] = inst_45338);

(statearr_45354_48088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (20))){
var state_45342__$1 = state_45342;
var statearr_45355_48089 = state_45342__$1;
(statearr_45355_48089[(2)] = null);

(statearr_45355_48089[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (1))){
var state_45342__$1 = state_45342;
var statearr_45361_48090 = state_45342__$1;
(statearr_45361_48090[(2)] = null);

(statearr_45361_48090[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (4))){
var inst_45291 = (state_45342[(7)]);
var inst_45291__$1 = (state_45342[(2)]);
var inst_45292 = (inst_45291__$1 == null);
var state_45342__$1 = (function (){var statearr_45372 = state_45342;
(statearr_45372[(7)] = inst_45291__$1);

return statearr_45372;
})();
if(cljs.core.truth_(inst_45292)){
var statearr_45377_48091 = state_45342__$1;
(statearr_45377_48091[(1)] = (5));

} else {
var statearr_45378_48092 = state_45342__$1;
(statearr_45378_48092[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (15))){
var inst_45313 = (state_45342[(8)]);
var state_45342__$1 = state_45342;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45342__$1,(18),to,inst_45313);
} else {
if((state_val_45343 === (21))){
var inst_45333 = (state_45342[(2)]);
var state_45342__$1 = state_45342;
var statearr_45383_48094 = state_45342__$1;
(statearr_45383_48094[(2)] = inst_45333);

(statearr_45383_48094[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (13))){
var inst_45335 = (state_45342[(2)]);
var state_45342__$1 = (function (){var statearr_45388 = state_45342;
(statearr_45388[(9)] = inst_45335);

return statearr_45388;
})();
var statearr_45392_48095 = state_45342__$1;
(statearr_45392_48095[(2)] = null);

(statearr_45392_48095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (6))){
var inst_45291 = (state_45342[(7)]);
var state_45342__$1 = state_45342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45342__$1,(11),inst_45291);
} else {
if((state_val_45343 === (17))){
var inst_45326 = (state_45342[(2)]);
var state_45342__$1 = state_45342;
if(cljs.core.truth_(inst_45326)){
var statearr_45401_48097 = state_45342__$1;
(statearr_45401_48097[(1)] = (19));

} else {
var statearr_45403_48099 = state_45342__$1;
(statearr_45403_48099[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (3))){
var inst_45340 = (state_45342[(2)]);
var state_45342__$1 = state_45342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45342__$1,inst_45340);
} else {
if((state_val_45343 === (12))){
var inst_45308 = (state_45342[(10)]);
var state_45342__$1 = state_45342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45342__$1,(14),inst_45308);
} else {
if((state_val_45343 === (2))){
var state_45342__$1 = state_45342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45342__$1,(4),results);
} else {
if((state_val_45343 === (19))){
var state_45342__$1 = state_45342;
var statearr_45409_48103 = state_45342__$1;
(statearr_45409_48103[(2)] = null);

(statearr_45409_48103[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (11))){
var inst_45308 = (state_45342[(2)]);
var state_45342__$1 = (function (){var statearr_45410 = state_45342;
(statearr_45410[(10)] = inst_45308);

return statearr_45410;
})();
var statearr_45412_48104 = state_45342__$1;
(statearr_45412_48104[(2)] = null);

(statearr_45412_48104[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (9))){
var state_45342__$1 = state_45342;
var statearr_45420_48105 = state_45342__$1;
(statearr_45420_48105[(2)] = null);

(statearr_45420_48105[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (5))){
var state_45342__$1 = state_45342;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45421_48108 = state_45342__$1;
(statearr_45421_48108[(1)] = (8));

} else {
var statearr_45422_48109 = state_45342__$1;
(statearr_45422_48109[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (14))){
var inst_45317 = (state_45342[(11)]);
var inst_45313 = (state_45342[(8)]);
var inst_45313__$1 = (state_45342[(2)]);
var inst_45316 = (inst_45313__$1 == null);
var inst_45317__$1 = cljs.core.not(inst_45316);
var state_45342__$1 = (function (){var statearr_45424 = state_45342;
(statearr_45424[(11)] = inst_45317__$1);

(statearr_45424[(8)] = inst_45313__$1);

return statearr_45424;
})();
if(inst_45317__$1){
var statearr_45429_48110 = state_45342__$1;
(statearr_45429_48110[(1)] = (15));

} else {
var statearr_45430_48111 = state_45342__$1;
(statearr_45430_48111[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (16))){
var inst_45317 = (state_45342[(11)]);
var state_45342__$1 = state_45342;
var statearr_45433_48113 = state_45342__$1;
(statearr_45433_48113[(2)] = inst_45317);

(statearr_45433_48113[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (10))){
var inst_45302 = (state_45342[(2)]);
var state_45342__$1 = state_45342;
var statearr_45439_48114 = state_45342__$1;
(statearr_45439_48114[(2)] = inst_45302);

(statearr_45439_48114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (18))){
var inst_45322 = (state_45342[(2)]);
var state_45342__$1 = state_45342;
var statearr_45442_48116 = state_45342__$1;
(statearr_45442_48116[(2)] = inst_45322);

(statearr_45442_48116[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45343 === (8))){
var inst_45299 = cljs.core.async.close_BANG_(to);
var state_45342__$1 = state_45342;
var statearr_45443_48118 = state_45342__$1;
(statearr_45443_48118[(2)] = inst_45299);

(statearr_45443_48118[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0 = (function (){
var statearr_45447 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_45447[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__);

(statearr_45447[(1)] = (1));

return statearr_45447;
});
var cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1 = (function (state_45342){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45342);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45448){var ex__44385__auto__ = e45448;
var statearr_45449_48121 = state_45342;
(statearr_45449_48121[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45342[(4)]))){
var statearr_45450_48122 = state_45342;
(statearr_45450_48122[(1)] = cljs.core.first((state_45342[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48123 = state_45342;
state_45342 = G__48123;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__ = function(state_45342){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1.call(this,state_45342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__44382__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_45455 = f__44467__auto__();
(statearr_45455[(6)] = c__44466__auto__);

return statearr_45455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));

return c__44466__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__45463 = arguments.length;
switch (G__45463) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__45482 = arguments.length;
switch (G__45482) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__45503 = arguments.length;
switch (G__45503) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__44466__auto___48138 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_45537){
var state_val_45538 = (state_45537[(1)]);
if((state_val_45538 === (7))){
var inst_45533 = (state_45537[(2)]);
var state_45537__$1 = state_45537;
var statearr_45539_48139 = state_45537__$1;
(statearr_45539_48139[(2)] = inst_45533);

(statearr_45539_48139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (1))){
var state_45537__$1 = state_45537;
var statearr_45540_48140 = state_45537__$1;
(statearr_45540_48140[(2)] = null);

(statearr_45540_48140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (4))){
var inst_45511 = (state_45537[(7)]);
var inst_45511__$1 = (state_45537[(2)]);
var inst_45513 = (inst_45511__$1 == null);
var state_45537__$1 = (function (){var statearr_45541 = state_45537;
(statearr_45541[(7)] = inst_45511__$1);

return statearr_45541;
})();
if(cljs.core.truth_(inst_45513)){
var statearr_45546_48141 = state_45537__$1;
(statearr_45546_48141[(1)] = (5));

} else {
var statearr_45552_48143 = state_45537__$1;
(statearr_45552_48143[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (13))){
var state_45537__$1 = state_45537;
var statearr_45561_48144 = state_45537__$1;
(statearr_45561_48144[(2)] = null);

(statearr_45561_48144[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (6))){
var inst_45511 = (state_45537[(7)]);
var inst_45520 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_45511) : p.call(null,inst_45511));
var state_45537__$1 = state_45537;
if(cljs.core.truth_(inst_45520)){
var statearr_45576_48149 = state_45537__$1;
(statearr_45576_48149[(1)] = (9));

} else {
var statearr_45578_48150 = state_45537__$1;
(statearr_45578_48150[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (3))){
var inst_45535 = (state_45537[(2)]);
var state_45537__$1 = state_45537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45537__$1,inst_45535);
} else {
if((state_val_45538 === (12))){
var state_45537__$1 = state_45537;
var statearr_45589_48152 = state_45537__$1;
(statearr_45589_48152[(2)] = null);

(statearr_45589_48152[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (2))){
var state_45537__$1 = state_45537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45537__$1,(4),ch);
} else {
if((state_val_45538 === (11))){
var inst_45511 = (state_45537[(7)]);
var inst_45524 = (state_45537[(2)]);
var state_45537__$1 = state_45537;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45537__$1,(8),inst_45524,inst_45511);
} else {
if((state_val_45538 === (9))){
var state_45537__$1 = state_45537;
var statearr_45602_48155 = state_45537__$1;
(statearr_45602_48155[(2)] = tc);

(statearr_45602_48155[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (5))){
var inst_45516 = cljs.core.async.close_BANG_(tc);
var inst_45517 = cljs.core.async.close_BANG_(fc);
var state_45537__$1 = (function (){var statearr_45607 = state_45537;
(statearr_45607[(8)] = inst_45516);

return statearr_45607;
})();
var statearr_45608_48159 = state_45537__$1;
(statearr_45608_48159[(2)] = inst_45517);

(statearr_45608_48159[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (14))){
var inst_45531 = (state_45537[(2)]);
var state_45537__$1 = state_45537;
var statearr_45612_48161 = state_45537__$1;
(statearr_45612_48161[(2)] = inst_45531);

(statearr_45612_48161[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (10))){
var state_45537__$1 = state_45537;
var statearr_45615_48162 = state_45537__$1;
(statearr_45615_48162[(2)] = fc);

(statearr_45615_48162[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45538 === (8))){
var inst_45526 = (state_45537[(2)]);
var state_45537__$1 = state_45537;
if(cljs.core.truth_(inst_45526)){
var statearr_45619_48163 = state_45537__$1;
(statearr_45619_48163[(1)] = (12));

} else {
var statearr_45620_48164 = state_45537__$1;
(statearr_45620_48164[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_45624 = [null,null,null,null,null,null,null,null,null];
(statearr_45624[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_45624[(1)] = (1));

return statearr_45624;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_45537){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45537);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45626){var ex__44385__auto__ = e45626;
var statearr_45627_48165 = state_45537;
(statearr_45627_48165[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45537[(4)]))){
var statearr_45631_48166 = state_45537;
(statearr_45631_48166[(1)] = cljs.core.first((state_45537[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48171 = state_45537;
state_45537 = G__48171;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_45537){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_45537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_45644 = f__44467__auto__();
(statearr_45644[(6)] = c__44466__auto___48138);

return statearr_45644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__44466__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_45707){
var state_val_45708 = (state_45707[(1)]);
if((state_val_45708 === (7))){
var inst_45695 = (state_45707[(2)]);
var state_45707__$1 = state_45707;
var statearr_45732_48174 = state_45707__$1;
(statearr_45732_48174[(2)] = inst_45695);

(statearr_45732_48174[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45708 === (1))){
var inst_45663 = init;
var inst_45664 = inst_45663;
var state_45707__$1 = (function (){var statearr_45749 = state_45707;
(statearr_45749[(7)] = inst_45664);

return statearr_45749;
})();
var statearr_45753_48178 = state_45707__$1;
(statearr_45753_48178[(2)] = null);

(statearr_45753_48178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45708 === (4))){
var inst_45668 = (state_45707[(8)]);
var inst_45668__$1 = (state_45707[(2)]);
var inst_45674 = (inst_45668__$1 == null);
var state_45707__$1 = (function (){var statearr_45762 = state_45707;
(statearr_45762[(8)] = inst_45668__$1);

return statearr_45762;
})();
if(cljs.core.truth_(inst_45674)){
var statearr_45765_48180 = state_45707__$1;
(statearr_45765_48180[(1)] = (5));

} else {
var statearr_45766_48181 = state_45707__$1;
(statearr_45766_48181[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45708 === (6))){
var inst_45664 = (state_45707[(7)]);
var inst_45679 = (state_45707[(9)]);
var inst_45668 = (state_45707[(8)]);
var inst_45679__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_45664,inst_45668) : f.call(null,inst_45664,inst_45668));
var inst_45684 = cljs.core.reduced_QMARK_(inst_45679__$1);
var state_45707__$1 = (function (){var statearr_45770 = state_45707;
(statearr_45770[(9)] = inst_45679__$1);

return statearr_45770;
})();
if(inst_45684){
var statearr_45771_48182 = state_45707__$1;
(statearr_45771_48182[(1)] = (8));

} else {
var statearr_45772_48183 = state_45707__$1;
(statearr_45772_48183[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45708 === (3))){
var inst_45698 = (state_45707[(2)]);
var state_45707__$1 = state_45707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45707__$1,inst_45698);
} else {
if((state_val_45708 === (2))){
var state_45707__$1 = state_45707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45707__$1,(4),ch);
} else {
if((state_val_45708 === (9))){
var inst_45679 = (state_45707[(9)]);
var inst_45664 = inst_45679;
var state_45707__$1 = (function (){var statearr_45778 = state_45707;
(statearr_45778[(7)] = inst_45664);

return statearr_45778;
})();
var statearr_45781_48184 = state_45707__$1;
(statearr_45781_48184[(2)] = null);

(statearr_45781_48184[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45708 === (5))){
var inst_45664 = (state_45707[(7)]);
var state_45707__$1 = state_45707;
var statearr_45787_48185 = state_45707__$1;
(statearr_45787_48185[(2)] = inst_45664);

(statearr_45787_48185[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45708 === (10))){
var inst_45693 = (state_45707[(2)]);
var state_45707__$1 = state_45707;
var statearr_45793_48186 = state_45707__$1;
(statearr_45793_48186[(2)] = inst_45693);

(statearr_45793_48186[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45708 === (8))){
var inst_45679 = (state_45707[(9)]);
var inst_45687 = cljs.core.deref(inst_45679);
var state_45707__$1 = state_45707;
var statearr_45796_48189 = state_45707__$1;
(statearr_45796_48189[(2)] = inst_45687);

(statearr_45796_48189[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__44382__auto__ = null;
var cljs$core$async$reduce_$_state_machine__44382__auto____0 = (function (){
var statearr_45803 = [null,null,null,null,null,null,null,null,null,null];
(statearr_45803[(0)] = cljs$core$async$reduce_$_state_machine__44382__auto__);

(statearr_45803[(1)] = (1));

return statearr_45803;
});
var cljs$core$async$reduce_$_state_machine__44382__auto____1 = (function (state_45707){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45707);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45808){var ex__44385__auto__ = e45808;
var statearr_45809_48197 = state_45707;
(statearr_45809_48197[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45707[(4)]))){
var statearr_45814_48199 = state_45707;
(statearr_45814_48199[(1)] = cljs.core.first((state_45707[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48200 = state_45707;
state_45707 = G__48200;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__44382__auto__ = function(state_45707){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__44382__auto____1.call(this,state_45707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__44382__auto____0;
cljs$core$async$reduce_$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__44382__auto____1;
return cljs$core$async$reduce_$_state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_45825 = f__44467__auto__();
(statearr_45825[(6)] = c__44466__auto__);

return statearr_45825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));

return c__44466__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__44466__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_45844){
var state_val_45845 = (state_45844[(1)]);
if((state_val_45845 === (1))){
var inst_45838 = cljs.core.async.reduce(f__$1,init,ch);
var state_45844__$1 = state_45844;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_45844__$1,(2),inst_45838);
} else {
if((state_val_45845 === (2))){
var inst_45840 = (state_45844[(2)]);
var inst_45841 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_45840) : f__$1.call(null,inst_45840));
var state_45844__$1 = state_45844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45844__$1,inst_45841);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__44382__auto__ = null;
var cljs$core$async$transduce_$_state_machine__44382__auto____0 = (function (){
var statearr_45861 = [null,null,null,null,null,null,null];
(statearr_45861[(0)] = cljs$core$async$transduce_$_state_machine__44382__auto__);

(statearr_45861[(1)] = (1));

return statearr_45861;
});
var cljs$core$async$transduce_$_state_machine__44382__auto____1 = (function (state_45844){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45844);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45864){var ex__44385__auto__ = e45864;
var statearr_45865_48206 = state_45844;
(statearr_45865_48206[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45844[(4)]))){
var statearr_45866_48207 = state_45844;
(statearr_45866_48207[(1)] = cljs.core.first((state_45844[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48209 = state_45844;
state_45844 = G__48209;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__44382__auto__ = function(state_45844){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__44382__auto____1.call(this,state_45844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__44382__auto____0;
cljs$core$async$transduce_$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__44382__auto____1;
return cljs$core$async$transduce_$_state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_45873 = f__44467__auto__();
(statearr_45873[(6)] = c__44466__auto__);

return statearr_45873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));

return c__44466__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__45886 = arguments.length;
switch (G__45886) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__44466__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_45925){
var state_val_45927 = (state_45925[(1)]);
if((state_val_45927 === (7))){
var inst_45903 = (state_45925[(2)]);
var state_45925__$1 = state_45925;
var statearr_45940_48219 = state_45925__$1;
(statearr_45940_48219[(2)] = inst_45903);

(statearr_45940_48219[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (1))){
var inst_45897 = cljs.core.seq(coll);
var inst_45898 = inst_45897;
var state_45925__$1 = (function (){var statearr_45941 = state_45925;
(statearr_45941[(7)] = inst_45898);

return statearr_45941;
})();
var statearr_45944_48223 = state_45925__$1;
(statearr_45944_48223[(2)] = null);

(statearr_45944_48223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (4))){
var inst_45898 = (state_45925[(7)]);
var inst_45901 = cljs.core.first(inst_45898);
var state_45925__$1 = state_45925;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_45925__$1,(7),ch,inst_45901);
} else {
if((state_val_45927 === (13))){
var inst_45919 = (state_45925[(2)]);
var state_45925__$1 = state_45925;
var statearr_45947_48235 = state_45925__$1;
(statearr_45947_48235[(2)] = inst_45919);

(statearr_45947_48235[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (6))){
var inst_45907 = (state_45925[(2)]);
var state_45925__$1 = state_45925;
if(cljs.core.truth_(inst_45907)){
var statearr_45948_48243 = state_45925__$1;
(statearr_45948_48243[(1)] = (8));

} else {
var statearr_45949_48244 = state_45925__$1;
(statearr_45949_48244[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (3))){
var inst_45923 = (state_45925[(2)]);
var state_45925__$1 = state_45925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_45925__$1,inst_45923);
} else {
if((state_val_45927 === (12))){
var state_45925__$1 = state_45925;
var statearr_45956_48245 = state_45925__$1;
(statearr_45956_48245[(2)] = null);

(statearr_45956_48245[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (2))){
var inst_45898 = (state_45925[(7)]);
var state_45925__$1 = state_45925;
if(cljs.core.truth_(inst_45898)){
var statearr_45957_48248 = state_45925__$1;
(statearr_45957_48248[(1)] = (4));

} else {
var statearr_45958_48249 = state_45925__$1;
(statearr_45958_48249[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (11))){
var inst_45915 = cljs.core.async.close_BANG_(ch);
var state_45925__$1 = state_45925;
var statearr_45959_48252 = state_45925__$1;
(statearr_45959_48252[(2)] = inst_45915);

(statearr_45959_48252[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (9))){
var state_45925__$1 = state_45925;
if(cljs.core.truth_(close_QMARK_)){
var statearr_45960_48253 = state_45925__$1;
(statearr_45960_48253[(1)] = (11));

} else {
var statearr_45961_48254 = state_45925__$1;
(statearr_45961_48254[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (5))){
var inst_45898 = (state_45925[(7)]);
var state_45925__$1 = state_45925;
var statearr_45962_48256 = state_45925__$1;
(statearr_45962_48256[(2)] = inst_45898);

(statearr_45962_48256[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (10))){
var inst_45921 = (state_45925[(2)]);
var state_45925__$1 = state_45925;
var statearr_45963_48261 = state_45925__$1;
(statearr_45963_48261[(2)] = inst_45921);

(statearr_45963_48261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_45927 === (8))){
var inst_45898 = (state_45925[(7)]);
var inst_45911 = cljs.core.next(inst_45898);
var inst_45898__$1 = inst_45911;
var state_45925__$1 = (function (){var statearr_45965 = state_45925;
(statearr_45965[(7)] = inst_45898__$1);

return statearr_45965;
})();
var statearr_45968_48267 = state_45925__$1;
(statearr_45968_48267[(2)] = null);

(statearr_45968_48267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_45975 = [null,null,null,null,null,null,null,null];
(statearr_45975[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_45975[(1)] = (1));

return statearr_45975;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_45925){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_45925);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e45976){var ex__44385__auto__ = e45976;
var statearr_45977_48286 = state_45925;
(statearr_45977_48286[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_45925[(4)]))){
var statearr_45981_48288 = state_45925;
(statearr_45981_48288[(1)] = cljs.core.first((state_45925[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48294 = state_45925;
state_45925 = G__48294;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_45925){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_45925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_45983 = f__44467__auto__();
(statearr_45983[(6)] = c__44466__auto__);

return statearr_45983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));

return c__44466__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__45996 = arguments.length;
switch (G__45996) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_48318 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4551__auto__.call(null,_));
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4549__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_48318(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_48339 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4551__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4549__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_48339(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_48352 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_48352(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_48367 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_48367(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46080 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46080 = (function (ch,cs,meta46081){
this.ch = ch;
this.cs = cs;
this.meta46081 = meta46081;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46080.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46082,meta46081__$1){
var self__ = this;
var _46082__$1 = this;
return (new cljs.core.async.t_cljs$core$async46080(self__.ch,self__.cs,meta46081__$1));
}));

(cljs.core.async.t_cljs$core$async46080.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46082){
var self__ = this;
var _46082__$1 = this;
return self__.meta46081;
}));

(cljs.core.async.t_cljs$core$async46080.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46080.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46080.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46080.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async46080.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async46080.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async46080.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta46081","meta46081",-1615031134,null)], null);
}));

(cljs.core.async.t_cljs$core$async46080.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46080.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46080");

(cljs.core.async.t_cljs$core$async46080.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46080");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46080.
 */
cljs.core.async.__GT_t_cljs$core$async46080 = (function cljs$core$async$mult_$___GT_t_cljs$core$async46080(ch__$1,cs__$1,meta46081){
return (new cljs.core.async.t_cljs$core$async46080(ch__$1,cs__$1,meta46081));
});

}

return (new cljs.core.async.t_cljs$core$async46080(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__44466__auto___48408 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_46262){
var state_val_46263 = (state_46262[(1)]);
if((state_val_46263 === (7))){
var inst_46257 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46265_48413 = state_46262__$1;
(statearr_46265_48413[(2)] = inst_46257);

(statearr_46265_48413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (20))){
var inst_46148 = (state_46262[(7)]);
var inst_46160 = cljs.core.first(inst_46148);
var inst_46161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46160,(0),null);
var inst_46162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46160,(1),null);
var state_46262__$1 = (function (){var statearr_46266 = state_46262;
(statearr_46266[(8)] = inst_46161);

return statearr_46266;
})();
if(cljs.core.truth_(inst_46162)){
var statearr_46267_48416 = state_46262__$1;
(statearr_46267_48416[(1)] = (22));

} else {
var statearr_46268_48419 = state_46262__$1;
(statearr_46268_48419[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (27))){
var inst_46105 = (state_46262[(9)]);
var inst_46204 = (state_46262[(10)]);
var inst_46197 = (state_46262[(11)]);
var inst_46199 = (state_46262[(12)]);
var inst_46204__$1 = cljs.core._nth(inst_46197,inst_46199);
var inst_46205 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46204__$1,inst_46105,done);
var state_46262__$1 = (function (){var statearr_46277 = state_46262;
(statearr_46277[(10)] = inst_46204__$1);

return statearr_46277;
})();
if(cljs.core.truth_(inst_46205)){
var statearr_46282_48428 = state_46262__$1;
(statearr_46282_48428[(1)] = (30));

} else {
var statearr_46283_48432 = state_46262__$1;
(statearr_46283_48432[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (1))){
var state_46262__$1 = state_46262;
var statearr_46284_48435 = state_46262__$1;
(statearr_46284_48435[(2)] = null);

(statearr_46284_48435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (24))){
var inst_46148 = (state_46262[(7)]);
var inst_46167 = (state_46262[(2)]);
var inst_46168 = cljs.core.next(inst_46148);
var inst_46114 = inst_46168;
var inst_46115 = null;
var inst_46116 = (0);
var inst_46117 = (0);
var state_46262__$1 = (function (){var statearr_46287 = state_46262;
(statearr_46287[(13)] = inst_46116);

(statearr_46287[(14)] = inst_46167);

(statearr_46287[(15)] = inst_46114);

(statearr_46287[(16)] = inst_46115);

(statearr_46287[(17)] = inst_46117);

return statearr_46287;
})();
var statearr_46289_48450 = state_46262__$1;
(statearr_46289_48450[(2)] = null);

(statearr_46289_48450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (39))){
var state_46262__$1 = state_46262;
var statearr_46298_48453 = state_46262__$1;
(statearr_46298_48453[(2)] = null);

(statearr_46298_48453[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (4))){
var inst_46105 = (state_46262[(9)]);
var inst_46105__$1 = (state_46262[(2)]);
var inst_46106 = (inst_46105__$1 == null);
var state_46262__$1 = (function (){var statearr_46299 = state_46262;
(statearr_46299[(9)] = inst_46105__$1);

return statearr_46299;
})();
if(cljs.core.truth_(inst_46106)){
var statearr_46300_48460 = state_46262__$1;
(statearr_46300_48460[(1)] = (5));

} else {
var statearr_46302_48463 = state_46262__$1;
(statearr_46302_48463[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (15))){
var inst_46116 = (state_46262[(13)]);
var inst_46114 = (state_46262[(15)]);
var inst_46115 = (state_46262[(16)]);
var inst_46117 = (state_46262[(17)]);
var inst_46140 = (state_46262[(2)]);
var inst_46145 = (inst_46117 + (1));
var tmp46290 = inst_46116;
var tmp46291 = inst_46114;
var tmp46292 = inst_46115;
var inst_46114__$1 = tmp46291;
var inst_46115__$1 = tmp46292;
var inst_46116__$1 = tmp46290;
var inst_46117__$1 = inst_46145;
var state_46262__$1 = (function (){var statearr_46305 = state_46262;
(statearr_46305[(18)] = inst_46140);

(statearr_46305[(13)] = inst_46116__$1);

(statearr_46305[(15)] = inst_46114__$1);

(statearr_46305[(16)] = inst_46115__$1);

(statearr_46305[(17)] = inst_46117__$1);

return statearr_46305;
})();
var statearr_46306_48473 = state_46262__$1;
(statearr_46306_48473[(2)] = null);

(statearr_46306_48473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (21))){
var inst_46171 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46313_48477 = state_46262__$1;
(statearr_46313_48477[(2)] = inst_46171);

(statearr_46313_48477[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (31))){
var inst_46204 = (state_46262[(10)]);
var inst_46208 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46204);
var state_46262__$1 = state_46262;
var statearr_46314_48485 = state_46262__$1;
(statearr_46314_48485[(2)] = inst_46208);

(statearr_46314_48485[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (32))){
var inst_46196 = (state_46262[(19)]);
var inst_46198 = (state_46262[(20)]);
var inst_46197 = (state_46262[(11)]);
var inst_46199 = (state_46262[(12)]);
var inst_46210 = (state_46262[(2)]);
var inst_46211 = (inst_46199 + (1));
var tmp46309 = inst_46196;
var tmp46310 = inst_46198;
var tmp46311 = inst_46197;
var inst_46196__$1 = tmp46309;
var inst_46197__$1 = tmp46311;
var inst_46198__$1 = tmp46310;
var inst_46199__$1 = inst_46211;
var state_46262__$1 = (function (){var statearr_46319 = state_46262;
(statearr_46319[(19)] = inst_46196__$1);

(statearr_46319[(20)] = inst_46198__$1);

(statearr_46319[(11)] = inst_46197__$1);

(statearr_46319[(21)] = inst_46210);

(statearr_46319[(12)] = inst_46199__$1);

return statearr_46319;
})();
var statearr_46321_48499 = state_46262__$1;
(statearr_46321_48499[(2)] = null);

(statearr_46321_48499[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (40))){
var inst_46225 = (state_46262[(22)]);
var inst_46229 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_46225);
var state_46262__$1 = state_46262;
var statearr_46322_48502 = state_46262__$1;
(statearr_46322_48502[(2)] = inst_46229);

(statearr_46322_48502[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (33))){
var inst_46214 = (state_46262[(23)]);
var inst_46216 = cljs.core.chunked_seq_QMARK_(inst_46214);
var state_46262__$1 = state_46262;
if(inst_46216){
var statearr_46325_48508 = state_46262__$1;
(statearr_46325_48508[(1)] = (36));

} else {
var statearr_46327_48510 = state_46262__$1;
(statearr_46327_48510[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (13))){
var inst_46130 = (state_46262[(24)]);
var inst_46137 = cljs.core.async.close_BANG_(inst_46130);
var state_46262__$1 = state_46262;
var statearr_46328_48515 = state_46262__$1;
(statearr_46328_48515[(2)] = inst_46137);

(statearr_46328_48515[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (22))){
var inst_46161 = (state_46262[(8)]);
var inst_46164 = cljs.core.async.close_BANG_(inst_46161);
var state_46262__$1 = state_46262;
var statearr_46329_48521 = state_46262__$1;
(statearr_46329_48521[(2)] = inst_46164);

(statearr_46329_48521[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (36))){
var inst_46214 = (state_46262[(23)]);
var inst_46218 = cljs.core.chunk_first(inst_46214);
var inst_46219 = cljs.core.chunk_rest(inst_46214);
var inst_46221 = cljs.core.count(inst_46218);
var inst_46196 = inst_46219;
var inst_46197 = inst_46218;
var inst_46198 = inst_46221;
var inst_46199 = (0);
var state_46262__$1 = (function (){var statearr_46337 = state_46262;
(statearr_46337[(19)] = inst_46196);

(statearr_46337[(20)] = inst_46198);

(statearr_46337[(11)] = inst_46197);

(statearr_46337[(12)] = inst_46199);

return statearr_46337;
})();
var statearr_46338_48533 = state_46262__$1;
(statearr_46338_48533[(2)] = null);

(statearr_46338_48533[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (41))){
var inst_46214 = (state_46262[(23)]);
var inst_46231 = (state_46262[(2)]);
var inst_46232 = cljs.core.next(inst_46214);
var inst_46196 = inst_46232;
var inst_46197 = null;
var inst_46198 = (0);
var inst_46199 = (0);
var state_46262__$1 = (function (){var statearr_46340 = state_46262;
(statearr_46340[(19)] = inst_46196);

(statearr_46340[(20)] = inst_46198);

(statearr_46340[(25)] = inst_46231);

(statearr_46340[(11)] = inst_46197);

(statearr_46340[(12)] = inst_46199);

return statearr_46340;
})();
var statearr_46343_48541 = state_46262__$1;
(statearr_46343_48541[(2)] = null);

(statearr_46343_48541[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (43))){
var state_46262__$1 = state_46262;
var statearr_46345_48546 = state_46262__$1;
(statearr_46345_48546[(2)] = null);

(statearr_46345_48546[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (29))){
var inst_46241 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46352_48551 = state_46262__$1;
(statearr_46352_48551[(2)] = inst_46241);

(statearr_46352_48551[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (44))){
var inst_46254 = (state_46262[(2)]);
var state_46262__$1 = (function (){var statearr_46354 = state_46262;
(statearr_46354[(26)] = inst_46254);

return statearr_46354;
})();
var statearr_46355_48557 = state_46262__$1;
(statearr_46355_48557[(2)] = null);

(statearr_46355_48557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (6))){
var inst_46185 = (state_46262[(27)]);
var inst_46184 = cljs.core.deref(cs);
var inst_46185__$1 = cljs.core.keys(inst_46184);
var inst_46186 = cljs.core.count(inst_46185__$1);
var inst_46187 = cljs.core.reset_BANG_(dctr,inst_46186);
var inst_46192 = cljs.core.seq(inst_46185__$1);
var inst_46196 = inst_46192;
var inst_46197 = null;
var inst_46198 = (0);
var inst_46199 = (0);
var state_46262__$1 = (function (){var statearr_46356 = state_46262;
(statearr_46356[(19)] = inst_46196);

(statearr_46356[(20)] = inst_46198);

(statearr_46356[(28)] = inst_46187);

(statearr_46356[(11)] = inst_46197);

(statearr_46356[(27)] = inst_46185__$1);

(statearr_46356[(12)] = inst_46199);

return statearr_46356;
})();
var statearr_46358_48571 = state_46262__$1;
(statearr_46358_48571[(2)] = null);

(statearr_46358_48571[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (28))){
var inst_46196 = (state_46262[(19)]);
var inst_46214 = (state_46262[(23)]);
var inst_46214__$1 = cljs.core.seq(inst_46196);
var state_46262__$1 = (function (){var statearr_46359 = state_46262;
(statearr_46359[(23)] = inst_46214__$1);

return statearr_46359;
})();
if(inst_46214__$1){
var statearr_46361_48580 = state_46262__$1;
(statearr_46361_48580[(1)] = (33));

} else {
var statearr_46362_48582 = state_46262__$1;
(statearr_46362_48582[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (25))){
var inst_46198 = (state_46262[(20)]);
var inst_46199 = (state_46262[(12)]);
var inst_46201 = (inst_46199 < inst_46198);
var inst_46202 = inst_46201;
var state_46262__$1 = state_46262;
if(cljs.core.truth_(inst_46202)){
var statearr_46366_48589 = state_46262__$1;
(statearr_46366_48589[(1)] = (27));

} else {
var statearr_46370_48593 = state_46262__$1;
(statearr_46370_48593[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (34))){
var state_46262__$1 = state_46262;
var statearr_46375_48594 = state_46262__$1;
(statearr_46375_48594[(2)] = null);

(statearr_46375_48594[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (17))){
var state_46262__$1 = state_46262;
var statearr_46380_48595 = state_46262__$1;
(statearr_46380_48595[(2)] = null);

(statearr_46380_48595[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (3))){
var inst_46259 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46262__$1,inst_46259);
} else {
if((state_val_46263 === (12))){
var inst_46178 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46384_48597 = state_46262__$1;
(statearr_46384_48597[(2)] = inst_46178);

(statearr_46384_48597[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (2))){
var state_46262__$1 = state_46262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46262__$1,(4),ch);
} else {
if((state_val_46263 === (23))){
var state_46262__$1 = state_46262;
var statearr_46390_48598 = state_46262__$1;
(statearr_46390_48598[(2)] = null);

(statearr_46390_48598[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (35))){
var inst_46238 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46393_48600 = state_46262__$1;
(statearr_46393_48600[(2)] = inst_46238);

(statearr_46393_48600[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (19))){
var inst_46148 = (state_46262[(7)]);
var inst_46152 = cljs.core.chunk_first(inst_46148);
var inst_46153 = cljs.core.chunk_rest(inst_46148);
var inst_46154 = cljs.core.count(inst_46152);
var inst_46114 = inst_46153;
var inst_46115 = inst_46152;
var inst_46116 = inst_46154;
var inst_46117 = (0);
var state_46262__$1 = (function (){var statearr_46397 = state_46262;
(statearr_46397[(13)] = inst_46116);

(statearr_46397[(15)] = inst_46114);

(statearr_46397[(16)] = inst_46115);

(statearr_46397[(17)] = inst_46117);

return statearr_46397;
})();
var statearr_46399_48606 = state_46262__$1;
(statearr_46399_48606[(2)] = null);

(statearr_46399_48606[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (11))){
var inst_46148 = (state_46262[(7)]);
var inst_46114 = (state_46262[(15)]);
var inst_46148__$1 = cljs.core.seq(inst_46114);
var state_46262__$1 = (function (){var statearr_46404 = state_46262;
(statearr_46404[(7)] = inst_46148__$1);

return statearr_46404;
})();
if(inst_46148__$1){
var statearr_46406_48612 = state_46262__$1;
(statearr_46406_48612[(1)] = (16));

} else {
var statearr_46407_48614 = state_46262__$1;
(statearr_46407_48614[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (9))){
var inst_46180 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46409_48618 = state_46262__$1;
(statearr_46409_48618[(2)] = inst_46180);

(statearr_46409_48618[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (5))){
var inst_46112 = cljs.core.deref(cs);
var inst_46113 = cljs.core.seq(inst_46112);
var inst_46114 = inst_46113;
var inst_46115 = null;
var inst_46116 = (0);
var inst_46117 = (0);
var state_46262__$1 = (function (){var statearr_46416 = state_46262;
(statearr_46416[(13)] = inst_46116);

(statearr_46416[(15)] = inst_46114);

(statearr_46416[(16)] = inst_46115);

(statearr_46416[(17)] = inst_46117);

return statearr_46416;
})();
var statearr_46418_48626 = state_46262__$1;
(statearr_46418_48626[(2)] = null);

(statearr_46418_48626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (14))){
var state_46262__$1 = state_46262;
var statearr_46420_48631 = state_46262__$1;
(statearr_46420_48631[(2)] = null);

(statearr_46420_48631[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (45))){
var inst_46251 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46429_48638 = state_46262__$1;
(statearr_46429_48638[(2)] = inst_46251);

(statearr_46429_48638[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (26))){
var inst_46185 = (state_46262[(27)]);
var inst_46244 = (state_46262[(2)]);
var inst_46248 = cljs.core.seq(inst_46185);
var state_46262__$1 = (function (){var statearr_46431 = state_46262;
(statearr_46431[(29)] = inst_46244);

return statearr_46431;
})();
if(inst_46248){
var statearr_46434_48643 = state_46262__$1;
(statearr_46434_48643[(1)] = (42));

} else {
var statearr_46437_48646 = state_46262__$1;
(statearr_46437_48646[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (16))){
var inst_46148 = (state_46262[(7)]);
var inst_46150 = cljs.core.chunked_seq_QMARK_(inst_46148);
var state_46262__$1 = state_46262;
if(inst_46150){
var statearr_46449_48648 = state_46262__$1;
(statearr_46449_48648[(1)] = (19));

} else {
var statearr_46451_48650 = state_46262__$1;
(statearr_46451_48650[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (38))){
var inst_46235 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46456_48654 = state_46262__$1;
(statearr_46456_48654[(2)] = inst_46235);

(statearr_46456_48654[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (30))){
var state_46262__$1 = state_46262;
var statearr_46465_48659 = state_46262__$1;
(statearr_46465_48659[(2)] = null);

(statearr_46465_48659[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (10))){
var inst_46115 = (state_46262[(16)]);
var inst_46117 = (state_46262[(17)]);
var inst_46129 = cljs.core._nth(inst_46115,inst_46117);
var inst_46130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46129,(0),null);
var inst_46135 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46129,(1),null);
var state_46262__$1 = (function (){var statearr_46471 = state_46262;
(statearr_46471[(24)] = inst_46130);

return statearr_46471;
})();
if(cljs.core.truth_(inst_46135)){
var statearr_46472_48665 = state_46262__$1;
(statearr_46472_48665[(1)] = (13));

} else {
var statearr_46473_48667 = state_46262__$1;
(statearr_46473_48667[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (18))){
var inst_46176 = (state_46262[(2)]);
var state_46262__$1 = state_46262;
var statearr_46474_48668 = state_46262__$1;
(statearr_46474_48668[(2)] = inst_46176);

(statearr_46474_48668[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (42))){
var state_46262__$1 = state_46262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46262__$1,(45),dchan);
} else {
if((state_val_46263 === (37))){
var inst_46105 = (state_46262[(9)]);
var inst_46214 = (state_46262[(23)]);
var inst_46225 = (state_46262[(22)]);
var inst_46225__$1 = cljs.core.first(inst_46214);
var inst_46226 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_46225__$1,inst_46105,done);
var state_46262__$1 = (function (){var statearr_46478 = state_46262;
(statearr_46478[(22)] = inst_46225__$1);

return statearr_46478;
})();
if(cljs.core.truth_(inst_46226)){
var statearr_46479_48682 = state_46262__$1;
(statearr_46479_48682[(1)] = (39));

} else {
var statearr_46480_48684 = state_46262__$1;
(statearr_46480_48684[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46263 === (8))){
var inst_46116 = (state_46262[(13)]);
var inst_46117 = (state_46262[(17)]);
var inst_46119 = (inst_46117 < inst_46116);
var inst_46120 = inst_46119;
var state_46262__$1 = state_46262;
if(cljs.core.truth_(inst_46120)){
var statearr_46481_48696 = state_46262__$1;
(statearr_46481_48696[(1)] = (10));

} else {
var statearr_46485_48698 = state_46262__$1;
(statearr_46485_48698[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__44382__auto__ = null;
var cljs$core$async$mult_$_state_machine__44382__auto____0 = (function (){
var statearr_46489 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46489[(0)] = cljs$core$async$mult_$_state_machine__44382__auto__);

(statearr_46489[(1)] = (1));

return statearr_46489;
});
var cljs$core$async$mult_$_state_machine__44382__auto____1 = (function (state_46262){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_46262);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e46490){var ex__44385__auto__ = e46490;
var statearr_46491_48702 = state_46262;
(statearr_46491_48702[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_46262[(4)]))){
var statearr_46492_48705 = state_46262;
(statearr_46492_48705[(1)] = cljs.core.first((state_46262[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48706 = state_46262;
state_46262 = G__48706;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__44382__auto__ = function(state_46262){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__44382__auto____1.call(this,state_46262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__44382__auto____0;
cljs$core$async$mult_$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__44382__auto____1;
return cljs$core$async$mult_$_state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_46496 = f__44467__auto__();
(statearr_46496[(6)] = c__44466__auto___48408);

return statearr_46496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__46500 = arguments.length;
switch (G__46500) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_48731 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_48731(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_48742 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4551__auto__.call(null,m,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4549__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_48742(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_48762 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4551__auto__.call(null,m));
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4549__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_48762(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_48781 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4551__auto__.call(null,m,state_map));
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4549__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_48781(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_48794 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4551__auto__.call(null,m,mode));
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4549__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_48794(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___48815 = arguments.length;
var i__4865__auto___48816 = (0);
while(true){
if((i__4865__auto___48816 < len__4864__auto___48815)){
args__4870__auto__.push((arguments[i__4865__auto___48816]));

var G__48819 = (i__4865__auto___48816 + (1));
i__4865__auto___48816 = G__48819;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__46566){
var map__46567 = p__46566;
var map__46567__$1 = cljs.core.__destructure_map(map__46567);
var opts = map__46567__$1;
var statearr_46568_48829 = state;
(statearr_46568_48829[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_46569_48835 = state;
(statearr_46569_48835[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_46570_48845 = state;
(statearr_46570_48845[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq46556){
var G__46558 = cljs.core.first(seq46556);
var seq46556__$1 = cljs.core.next(seq46556);
var G__46559 = cljs.core.first(seq46556__$1);
var seq46556__$2 = cljs.core.next(seq46556__$1);
var G__46560 = cljs.core.first(seq46556__$2);
var seq46556__$3 = cljs.core.next(seq46556__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__46558,G__46559,G__46560,seq46556__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46580 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46580 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta46581){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta46581 = meta46581;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46582,meta46581__$1){
var self__ = this;
var _46582__$1 = this;
return (new cljs.core.async.t_cljs$core$async46580(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta46581__$1));
}));

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46582){
var self__ = this;
var _46582__$1 = this;
return self__.meta46581;
}));

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46580.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async46580.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta46581","meta46581",1955605967,null)], null);
}));

(cljs.core.async.t_cljs$core$async46580.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46580.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46580");

(cljs.core.async.t_cljs$core$async46580.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46580");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46580.
 */
cljs.core.async.__GT_t_cljs$core$async46580 = (function cljs$core$async$mix_$___GT_t_cljs$core$async46580(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46581){
return (new cljs.core.async.t_cljs$core$async46580(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta46581));
});

}

return (new cljs.core.async.t_cljs$core$async46580(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44466__auto___48916 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_46674){
var state_val_46675 = (state_46674[(1)]);
if((state_val_46675 === (7))){
var inst_46627 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
if(cljs.core.truth_(inst_46627)){
var statearr_46678_48917 = state_46674__$1;
(statearr_46678_48917[(1)] = (8));

} else {
var statearr_46680_48918 = state_46674__$1;
(statearr_46680_48918[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (20))){
var inst_46619 = (state_46674[(7)]);
var state_46674__$1 = state_46674;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46674__$1,(23),out,inst_46619);
} else {
if((state_val_46675 === (1))){
var inst_46600 = calc_state();
var inst_46601 = cljs.core.__destructure_map(inst_46600);
var inst_46602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46601,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46603 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46601,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46604 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46601,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_46605 = inst_46600;
var state_46674__$1 = (function (){var statearr_46684 = state_46674;
(statearr_46684[(8)] = inst_46605);

(statearr_46684[(9)] = inst_46604);

(statearr_46684[(10)] = inst_46603);

(statearr_46684[(11)] = inst_46602);

return statearr_46684;
})();
var statearr_46686_48925 = state_46674__$1;
(statearr_46686_48925[(2)] = null);

(statearr_46686_48925[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (24))){
var inst_46609 = (state_46674[(12)]);
var inst_46605 = inst_46609;
var state_46674__$1 = (function (){var statearr_46690 = state_46674;
(statearr_46690[(8)] = inst_46605);

return statearr_46690;
})();
var statearr_46691_48936 = state_46674__$1;
(statearr_46691_48936[(2)] = null);

(statearr_46691_48936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (4))){
var inst_46621 = (state_46674[(13)]);
var inst_46619 = (state_46674[(7)]);
var inst_46618 = (state_46674[(2)]);
var inst_46619__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46618,(0),null);
var inst_46620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_46618,(1),null);
var inst_46621__$1 = (inst_46619__$1 == null);
var state_46674__$1 = (function (){var statearr_46693 = state_46674;
(statearr_46693[(13)] = inst_46621__$1);

(statearr_46693[(7)] = inst_46619__$1);

(statearr_46693[(14)] = inst_46620);

return statearr_46693;
})();
if(cljs.core.truth_(inst_46621__$1)){
var statearr_46694_48942 = state_46674__$1;
(statearr_46694_48942[(1)] = (5));

} else {
var statearr_46695_48946 = state_46674__$1;
(statearr_46695_48946[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (15))){
var inst_46610 = (state_46674[(15)]);
var inst_46646 = (state_46674[(16)]);
var inst_46646__$1 = cljs.core.empty_QMARK_(inst_46610);
var state_46674__$1 = (function (){var statearr_46696 = state_46674;
(statearr_46696[(16)] = inst_46646__$1);

return statearr_46696;
})();
if(inst_46646__$1){
var statearr_46697_48951 = state_46674__$1;
(statearr_46697_48951[(1)] = (17));

} else {
var statearr_46698_48952 = state_46674__$1;
(statearr_46698_48952[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (21))){
var inst_46609 = (state_46674[(12)]);
var inst_46605 = inst_46609;
var state_46674__$1 = (function (){var statearr_46701 = state_46674;
(statearr_46701[(8)] = inst_46605);

return statearr_46701;
})();
var statearr_46703_48955 = state_46674__$1;
(statearr_46703_48955[(2)] = null);

(statearr_46703_48955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (13))){
var inst_46634 = (state_46674[(2)]);
var inst_46636 = calc_state();
var inst_46605 = inst_46636;
var state_46674__$1 = (function (){var statearr_46706 = state_46674;
(statearr_46706[(8)] = inst_46605);

(statearr_46706[(17)] = inst_46634);

return statearr_46706;
})();
var statearr_46707_48957 = state_46674__$1;
(statearr_46707_48957[(2)] = null);

(statearr_46707_48957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (22))){
var inst_46667 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
var statearr_46710_48960 = state_46674__$1;
(statearr_46710_48960[(2)] = inst_46667);

(statearr_46710_48960[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (6))){
var inst_46620 = (state_46674[(14)]);
var inst_46624 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_46620,change);
var state_46674__$1 = state_46674;
var statearr_46713_48961 = state_46674__$1;
(statearr_46713_48961[(2)] = inst_46624);

(statearr_46713_48961[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (25))){
var state_46674__$1 = state_46674;
var statearr_46714_48963 = state_46674__$1;
(statearr_46714_48963[(2)] = null);

(statearr_46714_48963[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (17))){
var inst_46611 = (state_46674[(18)]);
var inst_46620 = (state_46674[(14)]);
var inst_46648 = (inst_46611.cljs$core$IFn$_invoke$arity$1 ? inst_46611.cljs$core$IFn$_invoke$arity$1(inst_46620) : inst_46611.call(null,inst_46620));
var inst_46649 = cljs.core.not(inst_46648);
var state_46674__$1 = state_46674;
var statearr_46715_48965 = state_46674__$1;
(statearr_46715_48965[(2)] = inst_46649);

(statearr_46715_48965[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (3))){
var inst_46671 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46674__$1,inst_46671);
} else {
if((state_val_46675 === (12))){
var state_46674__$1 = state_46674;
var statearr_46718_48967 = state_46674__$1;
(statearr_46718_48967[(2)] = null);

(statearr_46718_48967[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (2))){
var inst_46605 = (state_46674[(8)]);
var inst_46609 = (state_46674[(12)]);
var inst_46609__$1 = cljs.core.__destructure_map(inst_46605);
var inst_46610 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46609__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_46611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46609__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_46613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46609__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_46674__$1 = (function (){var statearr_46721 = state_46674;
(statearr_46721[(12)] = inst_46609__$1);

(statearr_46721[(15)] = inst_46610);

(statearr_46721[(18)] = inst_46611);

return statearr_46721;
})();
return cljs.core.async.ioc_alts_BANG_(state_46674__$1,(4),inst_46613);
} else {
if((state_val_46675 === (23))){
var inst_46657 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
if(cljs.core.truth_(inst_46657)){
var statearr_46724_48970 = state_46674__$1;
(statearr_46724_48970[(1)] = (24));

} else {
var statearr_46725_48971 = state_46674__$1;
(statearr_46725_48971[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (19))){
var inst_46652 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
var statearr_46727_48972 = state_46674__$1;
(statearr_46727_48972[(2)] = inst_46652);

(statearr_46727_48972[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (11))){
var inst_46620 = (state_46674[(14)]);
var inst_46631 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_46620);
var state_46674__$1 = state_46674;
var statearr_46729_48978 = state_46674__$1;
(statearr_46729_48978[(2)] = inst_46631);

(statearr_46729_48978[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (9))){
var inst_46641 = (state_46674[(19)]);
var inst_46610 = (state_46674[(15)]);
var inst_46620 = (state_46674[(14)]);
var inst_46641__$1 = (inst_46610.cljs$core$IFn$_invoke$arity$1 ? inst_46610.cljs$core$IFn$_invoke$arity$1(inst_46620) : inst_46610.call(null,inst_46620));
var state_46674__$1 = (function (){var statearr_46730 = state_46674;
(statearr_46730[(19)] = inst_46641__$1);

return statearr_46730;
})();
if(cljs.core.truth_(inst_46641__$1)){
var statearr_46731_48981 = state_46674__$1;
(statearr_46731_48981[(1)] = (14));

} else {
var statearr_46732_48986 = state_46674__$1;
(statearr_46732_48986[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (5))){
var inst_46621 = (state_46674[(13)]);
var state_46674__$1 = state_46674;
var statearr_46733_48989 = state_46674__$1;
(statearr_46733_48989[(2)] = inst_46621);

(statearr_46733_48989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (14))){
var inst_46641 = (state_46674[(19)]);
var state_46674__$1 = state_46674;
var statearr_46735_48990 = state_46674__$1;
(statearr_46735_48990[(2)] = inst_46641);

(statearr_46735_48990[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (26))){
var inst_46662 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
var statearr_46738_48993 = state_46674__$1;
(statearr_46738_48993[(2)] = inst_46662);

(statearr_46738_48993[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (16))){
var inst_46654 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
if(cljs.core.truth_(inst_46654)){
var statearr_46741_48996 = state_46674__$1;
(statearr_46741_48996[(1)] = (20));

} else {
var statearr_46743_48997 = state_46674__$1;
(statearr_46743_48997[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (10))){
var inst_46669 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
var statearr_46745_48998 = state_46674__$1;
(statearr_46745_48998[(2)] = inst_46669);

(statearr_46745_48998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (18))){
var inst_46646 = (state_46674[(16)]);
var state_46674__$1 = state_46674;
var statearr_46746_49000 = state_46674__$1;
(statearr_46746_49000[(2)] = inst_46646);

(statearr_46746_49000[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46675 === (8))){
var inst_46619 = (state_46674[(7)]);
var inst_46629 = (inst_46619 == null);
var state_46674__$1 = state_46674;
if(cljs.core.truth_(inst_46629)){
var statearr_46747_49007 = state_46674__$1;
(statearr_46747_49007[(1)] = (11));

} else {
var statearr_46748_49009 = state_46674__$1;
(statearr_46748_49009[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__44382__auto__ = null;
var cljs$core$async$mix_$_state_machine__44382__auto____0 = (function (){
var statearr_46756 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46756[(0)] = cljs$core$async$mix_$_state_machine__44382__auto__);

(statearr_46756[(1)] = (1));

return statearr_46756;
});
var cljs$core$async$mix_$_state_machine__44382__auto____1 = (function (state_46674){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_46674);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e46757){var ex__44385__auto__ = e46757;
var statearr_46762_49021 = state_46674;
(statearr_46762_49021[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_46674[(4)]))){
var statearr_46765_49022 = state_46674;
(statearr_46765_49022[(1)] = cljs.core.first((state_46674[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49024 = state_46674;
state_46674 = G__49024;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__44382__auto__ = function(state_46674){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__44382__auto____1.call(this,state_46674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__44382__auto____0;
cljs$core$async$mix_$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__44382__auto____1;
return cljs$core$async$mix_$_state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_46776 = f__44467__auto__();
(statearr_46776[(6)] = c__44466__auto___48916);

return statearr_46776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_49030 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4551__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4549__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_49030(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_49034 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4551__auto__.call(null,p,v,ch));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4549__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_49034(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_49038 = (function() {
var G__49039 = null;
var G__49039__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4551__auto__.call(null,p));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4549__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__49039__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4551__auto__.call(null,p,v));
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4549__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__49039 = function(p,v){
switch(arguments.length){
case 1:
return G__49039__1.call(this,p);
case 2:
return G__49039__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__49039.cljs$core$IFn$_invoke$arity$1 = G__49039__1;
G__49039.cljs$core$IFn$_invoke$arity$2 = G__49039__2;
return G__49039;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__46823 = arguments.length;
switch (G__46823) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49038(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_49038(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__46830 = arguments.length;
switch (G__46830) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__46827_SHARP_){
if(cljs.core.truth_((p1__46827_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__46827_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__46827_SHARP_.call(null,topic)))){
return p1__46827_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__46827_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async46832 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async46832 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta46833){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta46833 = meta46833;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_46834,meta46833__$1){
var self__ = this;
var _46834__$1 = this;
return (new cljs.core.async.t_cljs$core$async46832(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta46833__$1));
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_46834){
var self__ = this;
var _46834__$1 = this;
return self__.meta46833;
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async46832.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async46832.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta46833","meta46833",-1829149481,null)], null);
}));

(cljs.core.async.t_cljs$core$async46832.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async46832.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async46832");

(cljs.core.async.t_cljs$core$async46832.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async46832");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async46832.
 */
cljs.core.async.__GT_t_cljs$core$async46832 = (function cljs$core$async$__GT_t_cljs$core$async46832(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46833){
return (new cljs.core.async.t_cljs$core$async46832(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta46833));
});

}

return (new cljs.core.async.t_cljs$core$async46832(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__44466__auto___49063 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_46927){
var state_val_46928 = (state_46927[(1)]);
if((state_val_46928 === (7))){
var inst_46922 = (state_46927[(2)]);
var state_46927__$1 = state_46927;
var statearr_46932_49068 = state_46927__$1;
(statearr_46932_49068[(2)] = inst_46922);

(statearr_46932_49068[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (20))){
var state_46927__$1 = state_46927;
var statearr_46934_49069 = state_46927__$1;
(statearr_46934_49069[(2)] = null);

(statearr_46934_49069[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (1))){
var state_46927__$1 = state_46927;
var statearr_46935_49070 = state_46927__$1;
(statearr_46935_49070[(2)] = null);

(statearr_46935_49070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (24))){
var inst_46904 = (state_46927[(7)]);
var inst_46914 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_46904);
var state_46927__$1 = state_46927;
var statearr_46936_49071 = state_46927__$1;
(statearr_46936_49071[(2)] = inst_46914);

(statearr_46936_49071[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (4))){
var inst_46853 = (state_46927[(8)]);
var inst_46853__$1 = (state_46927[(2)]);
var inst_46854 = (inst_46853__$1 == null);
var state_46927__$1 = (function (){var statearr_46937 = state_46927;
(statearr_46937[(8)] = inst_46853__$1);

return statearr_46937;
})();
if(cljs.core.truth_(inst_46854)){
var statearr_46939_49075 = state_46927__$1;
(statearr_46939_49075[(1)] = (5));

} else {
var statearr_46942_49076 = state_46927__$1;
(statearr_46942_49076[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (15))){
var inst_46897 = (state_46927[(2)]);
var state_46927__$1 = state_46927;
var statearr_46943_49078 = state_46927__$1;
(statearr_46943_49078[(2)] = inst_46897);

(statearr_46943_49078[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (21))){
var inst_46919 = (state_46927[(2)]);
var state_46927__$1 = (function (){var statearr_46945 = state_46927;
(statearr_46945[(9)] = inst_46919);

return statearr_46945;
})();
var statearr_46947_49081 = state_46927__$1;
(statearr_46947_49081[(2)] = null);

(statearr_46947_49081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (13))){
var inst_46878 = (state_46927[(10)]);
var inst_46880 = cljs.core.chunked_seq_QMARK_(inst_46878);
var state_46927__$1 = state_46927;
if(inst_46880){
var statearr_46948_49084 = state_46927__$1;
(statearr_46948_49084[(1)] = (16));

} else {
var statearr_46949_49085 = state_46927__$1;
(statearr_46949_49085[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (22))){
var inst_46911 = (state_46927[(2)]);
var state_46927__$1 = state_46927;
if(cljs.core.truth_(inst_46911)){
var statearr_46950_49086 = state_46927__$1;
(statearr_46950_49086[(1)] = (23));

} else {
var statearr_46951_49087 = state_46927__$1;
(statearr_46951_49087[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (6))){
var inst_46853 = (state_46927[(8)]);
var inst_46904 = (state_46927[(7)]);
var inst_46906 = (state_46927[(11)]);
var inst_46904__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_46853) : topic_fn.call(null,inst_46853));
var inst_46905 = cljs.core.deref(mults);
var inst_46906__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46905,inst_46904__$1);
var state_46927__$1 = (function (){var statearr_46952 = state_46927;
(statearr_46952[(7)] = inst_46904__$1);

(statearr_46952[(11)] = inst_46906__$1);

return statearr_46952;
})();
if(cljs.core.truth_(inst_46906__$1)){
var statearr_46953_49096 = state_46927__$1;
(statearr_46953_49096[(1)] = (19));

} else {
var statearr_46954_49097 = state_46927__$1;
(statearr_46954_49097[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (25))){
var inst_46916 = (state_46927[(2)]);
var state_46927__$1 = state_46927;
var statearr_46955_49099 = state_46927__$1;
(statearr_46955_49099[(2)] = inst_46916);

(statearr_46955_49099[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (17))){
var inst_46878 = (state_46927[(10)]);
var inst_46888 = cljs.core.first(inst_46878);
var inst_46889 = cljs.core.async.muxch_STAR_(inst_46888);
var inst_46890 = cljs.core.async.close_BANG_(inst_46889);
var inst_46891 = cljs.core.next(inst_46878);
var inst_46863 = inst_46891;
var inst_46864 = null;
var inst_46865 = (0);
var inst_46866 = (0);
var state_46927__$1 = (function (){var statearr_46960 = state_46927;
(statearr_46960[(12)] = inst_46863);

(statearr_46960[(13)] = inst_46864);

(statearr_46960[(14)] = inst_46866);

(statearr_46960[(15)] = inst_46865);

(statearr_46960[(16)] = inst_46890);

return statearr_46960;
})();
var statearr_46962_49112 = state_46927__$1;
(statearr_46962_49112[(2)] = null);

(statearr_46962_49112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (3))){
var inst_46924 = (state_46927[(2)]);
var state_46927__$1 = state_46927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46927__$1,inst_46924);
} else {
if((state_val_46928 === (12))){
var inst_46899 = (state_46927[(2)]);
var state_46927__$1 = state_46927;
var statearr_46964_49113 = state_46927__$1;
(statearr_46964_49113[(2)] = inst_46899);

(statearr_46964_49113[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (2))){
var state_46927__$1 = state_46927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46927__$1,(4),ch);
} else {
if((state_val_46928 === (23))){
var state_46927__$1 = state_46927;
var statearr_46966_49119 = state_46927__$1;
(statearr_46966_49119[(2)] = null);

(statearr_46966_49119[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (19))){
var inst_46853 = (state_46927[(8)]);
var inst_46906 = (state_46927[(11)]);
var inst_46909 = cljs.core.async.muxch_STAR_(inst_46906);
var state_46927__$1 = state_46927;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_46927__$1,(22),inst_46909,inst_46853);
} else {
if((state_val_46928 === (11))){
var inst_46863 = (state_46927[(12)]);
var inst_46878 = (state_46927[(10)]);
var inst_46878__$1 = cljs.core.seq(inst_46863);
var state_46927__$1 = (function (){var statearr_46968 = state_46927;
(statearr_46968[(10)] = inst_46878__$1);

return statearr_46968;
})();
if(inst_46878__$1){
var statearr_46970_49124 = state_46927__$1;
(statearr_46970_49124[(1)] = (13));

} else {
var statearr_46971_49126 = state_46927__$1;
(statearr_46971_49126[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (9))){
var inst_46901 = (state_46927[(2)]);
var state_46927__$1 = state_46927;
var statearr_46972_49127 = state_46927__$1;
(statearr_46972_49127[(2)] = inst_46901);

(statearr_46972_49127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (5))){
var inst_46860 = cljs.core.deref(mults);
var inst_46861 = cljs.core.vals(inst_46860);
var inst_46862 = cljs.core.seq(inst_46861);
var inst_46863 = inst_46862;
var inst_46864 = null;
var inst_46865 = (0);
var inst_46866 = (0);
var state_46927__$1 = (function (){var statearr_46975 = state_46927;
(statearr_46975[(12)] = inst_46863);

(statearr_46975[(13)] = inst_46864);

(statearr_46975[(14)] = inst_46866);

(statearr_46975[(15)] = inst_46865);

return statearr_46975;
})();
var statearr_46976_49137 = state_46927__$1;
(statearr_46976_49137[(2)] = null);

(statearr_46976_49137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (14))){
var state_46927__$1 = state_46927;
var statearr_46980_49139 = state_46927__$1;
(statearr_46980_49139[(2)] = null);

(statearr_46980_49139[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (16))){
var inst_46878 = (state_46927[(10)]);
var inst_46882 = cljs.core.chunk_first(inst_46878);
var inst_46884 = cljs.core.chunk_rest(inst_46878);
var inst_46885 = cljs.core.count(inst_46882);
var inst_46863 = inst_46884;
var inst_46864 = inst_46882;
var inst_46865 = inst_46885;
var inst_46866 = (0);
var state_46927__$1 = (function (){var statearr_46982 = state_46927;
(statearr_46982[(12)] = inst_46863);

(statearr_46982[(13)] = inst_46864);

(statearr_46982[(14)] = inst_46866);

(statearr_46982[(15)] = inst_46865);

return statearr_46982;
})();
var statearr_46983_49145 = state_46927__$1;
(statearr_46983_49145[(2)] = null);

(statearr_46983_49145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (10))){
var inst_46863 = (state_46927[(12)]);
var inst_46864 = (state_46927[(13)]);
var inst_46866 = (state_46927[(14)]);
var inst_46865 = (state_46927[(15)]);
var inst_46872 = cljs.core._nth(inst_46864,inst_46866);
var inst_46873 = cljs.core.async.muxch_STAR_(inst_46872);
var inst_46874 = cljs.core.async.close_BANG_(inst_46873);
var inst_46875 = (inst_46866 + (1));
var tmp46977 = inst_46863;
var tmp46978 = inst_46864;
var tmp46979 = inst_46865;
var inst_46863__$1 = tmp46977;
var inst_46864__$1 = tmp46978;
var inst_46865__$1 = tmp46979;
var inst_46866__$1 = inst_46875;
var state_46927__$1 = (function (){var statearr_46985 = state_46927;
(statearr_46985[(12)] = inst_46863__$1);

(statearr_46985[(13)] = inst_46864__$1);

(statearr_46985[(14)] = inst_46866__$1);

(statearr_46985[(15)] = inst_46865__$1);

(statearr_46985[(17)] = inst_46874);

return statearr_46985;
})();
var statearr_46986_49154 = state_46927__$1;
(statearr_46986_49154[(2)] = null);

(statearr_46986_49154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (18))){
var inst_46894 = (state_46927[(2)]);
var state_46927__$1 = state_46927;
var statearr_46989_49155 = state_46927__$1;
(statearr_46989_49155[(2)] = inst_46894);

(statearr_46989_49155[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46928 === (8))){
var inst_46866 = (state_46927[(14)]);
var inst_46865 = (state_46927[(15)]);
var inst_46869 = (inst_46866 < inst_46865);
var inst_46870 = inst_46869;
var state_46927__$1 = state_46927;
if(cljs.core.truth_(inst_46870)){
var statearr_46990_49162 = state_46927__$1;
(statearr_46990_49162[(1)] = (10));

} else {
var statearr_46992_49163 = state_46927__$1;
(statearr_46992_49163[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_46994 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_46994[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_46994[(1)] = (1));

return statearr_46994;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_46927){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_46927);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e46995){var ex__44385__auto__ = e46995;
var statearr_46996_49172 = state_46927;
(statearr_46996_49172[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_46927[(4)]))){
var statearr_46997_49173 = state_46927;
(statearr_46997_49173[(1)] = cljs.core.first((state_46927[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49174 = state_46927;
state_46927 = G__49174;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_46927){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_46927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_46999 = f__44467__auto__();
(statearr_46999[(6)] = c__44466__auto___49063);

return statearr_46999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__47002 = arguments.length;
switch (G__47002) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__47004 = arguments.length;
switch (G__47004) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__47007 = arguments.length;
switch (G__47007) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__44466__auto___49191 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_47052){
var state_val_47053 = (state_47052[(1)]);
if((state_val_47053 === (7))){
var state_47052__$1 = state_47052;
var statearr_47054_49195 = state_47052__$1;
(statearr_47054_49195[(2)] = null);

(statearr_47054_49195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (1))){
var state_47052__$1 = state_47052;
var statearr_47055_49196 = state_47052__$1;
(statearr_47055_49196[(2)] = null);

(statearr_47055_49196[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (4))){
var inst_47011 = (state_47052[(7)]);
var inst_47012 = (state_47052[(8)]);
var inst_47014 = (inst_47012 < inst_47011);
var state_47052__$1 = state_47052;
if(cljs.core.truth_(inst_47014)){
var statearr_47056_49198 = state_47052__$1;
(statearr_47056_49198[(1)] = (6));

} else {
var statearr_47058_49199 = state_47052__$1;
(statearr_47058_49199[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (15))){
var inst_47038 = (state_47052[(9)]);
var inst_47043 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_47038);
var state_47052__$1 = state_47052;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47052__$1,(17),out,inst_47043);
} else {
if((state_val_47053 === (13))){
var inst_47038 = (state_47052[(9)]);
var inst_47038__$1 = (state_47052[(2)]);
var inst_47039 = cljs.core.some(cljs.core.nil_QMARK_,inst_47038__$1);
var state_47052__$1 = (function (){var statearr_47059 = state_47052;
(statearr_47059[(9)] = inst_47038__$1);

return statearr_47059;
})();
if(cljs.core.truth_(inst_47039)){
var statearr_47060_49205 = state_47052__$1;
(statearr_47060_49205[(1)] = (14));

} else {
var statearr_47061_49206 = state_47052__$1;
(statearr_47061_49206[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (6))){
var state_47052__$1 = state_47052;
var statearr_47062_49207 = state_47052__$1;
(statearr_47062_49207[(2)] = null);

(statearr_47062_49207[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (17))){
var inst_47045 = (state_47052[(2)]);
var state_47052__$1 = (function (){var statearr_47065 = state_47052;
(statearr_47065[(10)] = inst_47045);

return statearr_47065;
})();
var statearr_47066_49209 = state_47052__$1;
(statearr_47066_49209[(2)] = null);

(statearr_47066_49209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (3))){
var inst_47050 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47052__$1,inst_47050);
} else {
if((state_val_47053 === (12))){
var _ = (function (){var statearr_47067 = state_47052;
(statearr_47067[(4)] = cljs.core.rest((state_47052[(4)])));

return statearr_47067;
})();
var state_47052__$1 = state_47052;
var ex47063 = (state_47052__$1[(2)]);
var statearr_47068_49212 = state_47052__$1;
(statearr_47068_49212[(5)] = ex47063);


if((ex47063 instanceof Object)){
var statearr_47069_49213 = state_47052__$1;
(statearr_47069_49213[(1)] = (11));

(statearr_47069_49213[(5)] = null);

} else {
throw ex47063;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (2))){
var inst_47010 = cljs.core.reset_BANG_(dctr,cnt);
var inst_47011 = cnt;
var inst_47012 = (0);
var state_47052__$1 = (function (){var statearr_47070 = state_47052;
(statearr_47070[(7)] = inst_47011);

(statearr_47070[(8)] = inst_47012);

(statearr_47070[(11)] = inst_47010);

return statearr_47070;
})();
var statearr_47071_49214 = state_47052__$1;
(statearr_47071_49214[(2)] = null);

(statearr_47071_49214[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (11))){
var inst_47016 = (state_47052[(2)]);
var inst_47017 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_47052__$1 = (function (){var statearr_47072 = state_47052;
(statearr_47072[(12)] = inst_47016);

return statearr_47072;
})();
var statearr_47074_49217 = state_47052__$1;
(statearr_47074_49217[(2)] = inst_47017);

(statearr_47074_49217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (9))){
var inst_47012 = (state_47052[(8)]);
var _ = (function (){var statearr_47075 = state_47052;
(statearr_47075[(4)] = cljs.core.cons((12),(state_47052[(4)])));

return statearr_47075;
})();
var inst_47023 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_47012) : chs__$1.call(null,inst_47012));
var inst_47024 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_47012) : done.call(null,inst_47012));
var inst_47025 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_47023,inst_47024);
var ___$1 = (function (){var statearr_47076 = state_47052;
(statearr_47076[(4)] = cljs.core.rest((state_47052[(4)])));

return statearr_47076;
})();
var state_47052__$1 = state_47052;
var statearr_47077_49224 = state_47052__$1;
(statearr_47077_49224[(2)] = inst_47025);

(statearr_47077_49224[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (5))){
var inst_47036 = (state_47052[(2)]);
var state_47052__$1 = (function (){var statearr_47078 = state_47052;
(statearr_47078[(13)] = inst_47036);

return statearr_47078;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47052__$1,(13),dchan);
} else {
if((state_val_47053 === (14))){
var inst_47041 = cljs.core.async.close_BANG_(out);
var state_47052__$1 = state_47052;
var statearr_47079_49228 = state_47052__$1;
(statearr_47079_49228[(2)] = inst_47041);

(statearr_47079_49228[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (16))){
var inst_47048 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
var statearr_47080_49229 = state_47052__$1;
(statearr_47080_49229[(2)] = inst_47048);

(statearr_47080_49229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (10))){
var inst_47012 = (state_47052[(8)]);
var inst_47028 = (state_47052[(2)]);
var inst_47029 = (inst_47012 + (1));
var inst_47012__$1 = inst_47029;
var state_47052__$1 = (function (){var statearr_47081 = state_47052;
(statearr_47081[(14)] = inst_47028);

(statearr_47081[(8)] = inst_47012__$1);

return statearr_47081;
})();
var statearr_47082_49231 = state_47052__$1;
(statearr_47082_49231[(2)] = null);

(statearr_47082_49231[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47053 === (8))){
var inst_47033 = (state_47052[(2)]);
var state_47052__$1 = state_47052;
var statearr_47083_49234 = state_47052__$1;
(statearr_47083_49234[(2)] = inst_47033);

(statearr_47083_49234[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_47084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47084[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_47084[(1)] = (1));

return statearr_47084;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_47052){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_47052);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e47086){var ex__44385__auto__ = e47086;
var statearr_47087_49242 = state_47052;
(statearr_47087_49242[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_47052[(4)]))){
var statearr_47088_49244 = state_47052;
(statearr_47088_49244[(1)] = cljs.core.first((state_47052[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49246 = state_47052;
state_47052 = G__49246;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_47052){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_47052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_47089 = f__44467__auto__();
(statearr_47089[(6)] = c__44466__auto___49191);

return statearr_47089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__47092 = arguments.length;
switch (G__47092) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44466__auto___49256 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_47125){
var state_val_47126 = (state_47125[(1)]);
if((state_val_47126 === (7))){
var inst_47103 = (state_47125[(7)]);
var inst_47104 = (state_47125[(8)]);
var inst_47103__$1 = (state_47125[(2)]);
var inst_47104__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47103__$1,(0),null);
var inst_47105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_47103__$1,(1),null);
var inst_47107 = (inst_47104__$1 == null);
var state_47125__$1 = (function (){var statearr_47127 = state_47125;
(statearr_47127[(7)] = inst_47103__$1);

(statearr_47127[(8)] = inst_47104__$1);

(statearr_47127[(9)] = inst_47105);

return statearr_47127;
})();
if(cljs.core.truth_(inst_47107)){
var statearr_47128_49262 = state_47125__$1;
(statearr_47128_49262[(1)] = (8));

} else {
var statearr_47129_49264 = state_47125__$1;
(statearr_47129_49264[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (1))){
var inst_47093 = cljs.core.vec(chs);
var inst_47094 = inst_47093;
var state_47125__$1 = (function (){var statearr_47130 = state_47125;
(statearr_47130[(10)] = inst_47094);

return statearr_47130;
})();
var statearr_47131_49268 = state_47125__$1;
(statearr_47131_49268[(2)] = null);

(statearr_47131_49268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (4))){
var inst_47094 = (state_47125[(10)]);
var state_47125__$1 = state_47125;
return cljs.core.async.ioc_alts_BANG_(state_47125__$1,(7),inst_47094);
} else {
if((state_val_47126 === (6))){
var inst_47121 = (state_47125[(2)]);
var state_47125__$1 = state_47125;
var statearr_47132_49276 = state_47125__$1;
(statearr_47132_49276[(2)] = inst_47121);

(statearr_47132_49276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (3))){
var inst_47123 = (state_47125[(2)]);
var state_47125__$1 = state_47125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47125__$1,inst_47123);
} else {
if((state_val_47126 === (2))){
var inst_47094 = (state_47125[(10)]);
var inst_47096 = cljs.core.count(inst_47094);
var inst_47097 = (inst_47096 > (0));
var state_47125__$1 = state_47125;
if(cljs.core.truth_(inst_47097)){
var statearr_47135_49280 = state_47125__$1;
(statearr_47135_49280[(1)] = (4));

} else {
var statearr_47136_49282 = state_47125__$1;
(statearr_47136_49282[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (11))){
var inst_47094 = (state_47125[(10)]);
var inst_47114 = (state_47125[(2)]);
var tmp47134 = inst_47094;
var inst_47094__$1 = tmp47134;
var state_47125__$1 = (function (){var statearr_47137 = state_47125;
(statearr_47137[(11)] = inst_47114);

(statearr_47137[(10)] = inst_47094__$1);

return statearr_47137;
})();
var statearr_47138_49286 = state_47125__$1;
(statearr_47138_49286[(2)] = null);

(statearr_47138_49286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (9))){
var inst_47104 = (state_47125[(8)]);
var state_47125__$1 = state_47125;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47125__$1,(11),out,inst_47104);
} else {
if((state_val_47126 === (5))){
var inst_47119 = cljs.core.async.close_BANG_(out);
var state_47125__$1 = state_47125;
var statearr_47139_49287 = state_47125__$1;
(statearr_47139_49287[(2)] = inst_47119);

(statearr_47139_49287[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (10))){
var inst_47117 = (state_47125[(2)]);
var state_47125__$1 = state_47125;
var statearr_47140_49288 = state_47125__$1;
(statearr_47140_49288[(2)] = inst_47117);

(statearr_47140_49288[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47126 === (8))){
var inst_47103 = (state_47125[(7)]);
var inst_47104 = (state_47125[(8)]);
var inst_47105 = (state_47125[(9)]);
var inst_47094 = (state_47125[(10)]);
var inst_47109 = (function (){var cs = inst_47094;
var vec__47099 = inst_47103;
var v = inst_47104;
var c = inst_47105;
return (function (p1__47090_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__47090_SHARP_);
});
})();
var inst_47110 = cljs.core.filterv(inst_47109,inst_47094);
var inst_47094__$1 = inst_47110;
var state_47125__$1 = (function (){var statearr_47142 = state_47125;
(statearr_47142[(10)] = inst_47094__$1);

return statearr_47142;
})();
var statearr_47143_49290 = state_47125__$1;
(statearr_47143_49290[(2)] = null);

(statearr_47143_49290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_47145 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47145[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_47145[(1)] = (1));

return statearr_47145;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_47125){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_47125);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e47146){var ex__44385__auto__ = e47146;
var statearr_47147_49294 = state_47125;
(statearr_47147_49294[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_47125[(4)]))){
var statearr_47148_49296 = state_47125;
(statearr_47148_49296[(1)] = cljs.core.first((state_47125[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49298 = state_47125;
state_47125 = G__49298;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_47125){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_47125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_47149 = f__44467__auto__();
(statearr_47149[(6)] = c__44466__auto___49256);

return statearr_47149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__47152 = arguments.length;
switch (G__47152) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44466__auto___49301 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_47179){
var state_val_47180 = (state_47179[(1)]);
if((state_val_47180 === (7))){
var inst_47159 = (state_47179[(7)]);
var inst_47159__$1 = (state_47179[(2)]);
var inst_47160 = (inst_47159__$1 == null);
var inst_47161 = cljs.core.not(inst_47160);
var state_47179__$1 = (function (){var statearr_47186 = state_47179;
(statearr_47186[(7)] = inst_47159__$1);

return statearr_47186;
})();
if(inst_47161){
var statearr_47187_49305 = state_47179__$1;
(statearr_47187_49305[(1)] = (8));

} else {
var statearr_47188_49306 = state_47179__$1;
(statearr_47188_49306[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47180 === (1))){
var inst_47154 = (0);
var state_47179__$1 = (function (){var statearr_47189 = state_47179;
(statearr_47189[(8)] = inst_47154);

return statearr_47189;
})();
var statearr_47190_49307 = state_47179__$1;
(statearr_47190_49307[(2)] = null);

(statearr_47190_49307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47180 === (4))){
var state_47179__$1 = state_47179;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47179__$1,(7),ch);
} else {
if((state_val_47180 === (6))){
var inst_47174 = (state_47179[(2)]);
var state_47179__$1 = state_47179;
var statearr_47193_49309 = state_47179__$1;
(statearr_47193_49309[(2)] = inst_47174);

(statearr_47193_49309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47180 === (3))){
var inst_47176 = (state_47179[(2)]);
var inst_47177 = cljs.core.async.close_BANG_(out);
var state_47179__$1 = (function (){var statearr_47194 = state_47179;
(statearr_47194[(9)] = inst_47176);

return statearr_47194;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47179__$1,inst_47177);
} else {
if((state_val_47180 === (2))){
var inst_47154 = (state_47179[(8)]);
var inst_47156 = (inst_47154 < n);
var state_47179__$1 = state_47179;
if(cljs.core.truth_(inst_47156)){
var statearr_47195_49313 = state_47179__$1;
(statearr_47195_49313[(1)] = (4));

} else {
var statearr_47196_49314 = state_47179__$1;
(statearr_47196_49314[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47180 === (11))){
var inst_47154 = (state_47179[(8)]);
var inst_47166 = (state_47179[(2)]);
var inst_47167 = (inst_47154 + (1));
var inst_47154__$1 = inst_47167;
var state_47179__$1 = (function (){var statearr_47198 = state_47179;
(statearr_47198[(8)] = inst_47154__$1);

(statearr_47198[(10)] = inst_47166);

return statearr_47198;
})();
var statearr_47199_49315 = state_47179__$1;
(statearr_47199_49315[(2)] = null);

(statearr_47199_49315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47180 === (9))){
var state_47179__$1 = state_47179;
var statearr_47200_49316 = state_47179__$1;
(statearr_47200_49316[(2)] = null);

(statearr_47200_49316[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47180 === (5))){
var state_47179__$1 = state_47179;
var statearr_47201_49317 = state_47179__$1;
(statearr_47201_49317[(2)] = null);

(statearr_47201_49317[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47180 === (10))){
var inst_47171 = (state_47179[(2)]);
var state_47179__$1 = state_47179;
var statearr_47202_49318 = state_47179__$1;
(statearr_47202_49318[(2)] = inst_47171);

(statearr_47202_49318[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47180 === (8))){
var inst_47159 = (state_47179[(7)]);
var state_47179__$1 = state_47179;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47179__$1,(11),out,inst_47159);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_47212 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47212[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_47212[(1)] = (1));

return statearr_47212;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_47179){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_47179);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e47214){var ex__44385__auto__ = e47214;
var statearr_47219_49319 = state_47179;
(statearr_47219_49319[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_47179[(4)]))){
var statearr_47220_49320 = state_47179;
(statearr_47220_49320[(1)] = cljs.core.first((state_47179[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49321 = state_47179;
state_47179 = G__49321;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_47179){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_47179);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_47222 = f__44467__auto__();
(statearr_47222[(6)] = c__44466__auto___49301);

return statearr_47222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47224 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47224 = (function (f,ch,meta47225){
this.f = f;
this.ch = ch;
this.meta47225 = meta47225;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47226,meta47225__$1){
var self__ = this;
var _47226__$1 = this;
return (new cljs.core.async.t_cljs$core$async47224(self__.f,self__.ch,meta47225__$1));
}));

(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47226){
var self__ = this;
var _47226__$1 = this;
return self__.meta47225;
}));

(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47230 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47230 = (function (f,ch,meta47225,_,fn1,meta47231){
this.f = f;
this.ch = ch;
this.meta47225 = meta47225;
this._ = _;
this.fn1 = fn1;
this.meta47231 = meta47231;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47230.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47232,meta47231__$1){
var self__ = this;
var _47232__$1 = this;
return (new cljs.core.async.t_cljs$core$async47230(self__.f,self__.ch,self__.meta47225,self__._,self__.fn1,meta47231__$1));
}));

(cljs.core.async.t_cljs$core$async47230.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47232){
var self__ = this;
var _47232__$1 = this;
return self__.meta47231;
}));

(cljs.core.async.t_cljs$core$async47230.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47230.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async47230.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async47230.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__47223_SHARP_){
var G__47235 = (((p1__47223_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__47223_SHARP_) : self__.f.call(null,p1__47223_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__47235) : f1.call(null,G__47235));
});
}));

(cljs.core.async.t_cljs$core$async47230.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47225","meta47225",2138199399,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async47224","cljs.core.async/t_cljs$core$async47224",-653484138,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta47231","meta47231",-1262220340,null)], null);
}));

(cljs.core.async.t_cljs$core$async47230.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47230.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47230");

(cljs.core.async.t_cljs$core$async47230.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47230");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47230.
 */
cljs.core.async.__GT_t_cljs$core$async47230 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47230(f__$1,ch__$1,meta47225__$1,___$2,fn1__$1,meta47231){
return (new cljs.core.async.t_cljs$core$async47230(f__$1,ch__$1,meta47225__$1,___$2,fn1__$1,meta47231));
});

}

return (new cljs.core.async.t_cljs$core$async47230(self__.f,self__.ch,self__.meta47225,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__47238 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__47238) : self__.f.call(null,G__47238));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47224.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async47224.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47225","meta47225",2138199399,null)], null);
}));

(cljs.core.async.t_cljs$core$async47224.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47224.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47224");

(cljs.core.async.t_cljs$core$async47224.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47224");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47224.
 */
cljs.core.async.__GT_t_cljs$core$async47224 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async47224(f__$1,ch__$1,meta47225){
return (new cljs.core.async.t_cljs$core$async47224(f__$1,ch__$1,meta47225));
});

}

return (new cljs.core.async.t_cljs$core$async47224(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47241 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47241 = (function (f,ch,meta47242){
this.f = f;
this.ch = ch;
this.meta47242 = meta47242;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47241.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47243,meta47242__$1){
var self__ = this;
var _47243__$1 = this;
return (new cljs.core.async.t_cljs$core$async47241(self__.f,self__.ch,meta47242__$1));
}));

(cljs.core.async.t_cljs$core$async47241.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47243){
var self__ = this;
var _47243__$1 = this;
return self__.meta47242;
}));

(cljs.core.async.t_cljs$core$async47241.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47241.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47241.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47241.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47241.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47241.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async47241.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47242","meta47242",937087580,null)], null);
}));

(cljs.core.async.t_cljs$core$async47241.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47241.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47241");

(cljs.core.async.t_cljs$core$async47241.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47241");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47241.
 */
cljs.core.async.__GT_t_cljs$core$async47241 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async47241(f__$1,ch__$1,meta47242){
return (new cljs.core.async.t_cljs$core$async47241(f__$1,ch__$1,meta47242));
});

}

return (new cljs.core.async.t_cljs$core$async47241(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async47246 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async47246 = (function (p,ch,meta47247){
this.p = p;
this.ch = ch;
this.meta47247 = meta47247;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_47248,meta47247__$1){
var self__ = this;
var _47248__$1 = this;
return (new cljs.core.async.t_cljs$core$async47246(self__.p,self__.ch,meta47247__$1));
}));

(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_47248){
var self__ = this;
var _47248__$1 = this;
return self__.meta47247;
}));

(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async47246.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async47246.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta47247","meta47247",-833617251,null)], null);
}));

(cljs.core.async.t_cljs$core$async47246.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async47246.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async47246");

(cljs.core.async.t_cljs$core$async47246.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"cljs.core.async/t_cljs$core$async47246");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async47246.
 */
cljs.core.async.__GT_t_cljs$core$async47246 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async47246(p__$1,ch__$1,meta47247){
return (new cljs.core.async.t_cljs$core$async47246(p__$1,ch__$1,meta47247));
});

}

return (new cljs.core.async.t_cljs$core$async47246(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__47252 = arguments.length;
switch (G__47252) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44466__auto___49373 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_47273){
var state_val_47274 = (state_47273[(1)]);
if((state_val_47274 === (7))){
var inst_47269 = (state_47273[(2)]);
var state_47273__$1 = state_47273;
var statearr_47275_49374 = state_47273__$1;
(statearr_47275_49374[(2)] = inst_47269);

(statearr_47275_49374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47274 === (1))){
var state_47273__$1 = state_47273;
var statearr_47276_49375 = state_47273__$1;
(statearr_47276_49375[(2)] = null);

(statearr_47276_49375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47274 === (4))){
var inst_47255 = (state_47273[(7)]);
var inst_47255__$1 = (state_47273[(2)]);
var inst_47256 = (inst_47255__$1 == null);
var state_47273__$1 = (function (){var statearr_47277 = state_47273;
(statearr_47277[(7)] = inst_47255__$1);

return statearr_47277;
})();
if(cljs.core.truth_(inst_47256)){
var statearr_47278_49383 = state_47273__$1;
(statearr_47278_49383[(1)] = (5));

} else {
var statearr_47279_49384 = state_47273__$1;
(statearr_47279_49384[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47274 === (6))){
var inst_47255 = (state_47273[(7)]);
var inst_47260 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_47255) : p.call(null,inst_47255));
var state_47273__$1 = state_47273;
if(cljs.core.truth_(inst_47260)){
var statearr_47280_49385 = state_47273__$1;
(statearr_47280_49385[(1)] = (8));

} else {
var statearr_47281_49390 = state_47273__$1;
(statearr_47281_49390[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47274 === (3))){
var inst_47271 = (state_47273[(2)]);
var state_47273__$1 = state_47273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47273__$1,inst_47271);
} else {
if((state_val_47274 === (2))){
var state_47273__$1 = state_47273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47273__$1,(4),ch);
} else {
if((state_val_47274 === (11))){
var inst_47263 = (state_47273[(2)]);
var state_47273__$1 = state_47273;
var statearr_47285_49394 = state_47273__$1;
(statearr_47285_49394[(2)] = inst_47263);

(statearr_47285_49394[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47274 === (9))){
var state_47273__$1 = state_47273;
var statearr_47286_49395 = state_47273__$1;
(statearr_47286_49395[(2)] = null);

(statearr_47286_49395[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47274 === (5))){
var inst_47258 = cljs.core.async.close_BANG_(out);
var state_47273__$1 = state_47273;
var statearr_47287_49396 = state_47273__$1;
(statearr_47287_49396[(2)] = inst_47258);

(statearr_47287_49396[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47274 === (10))){
var inst_47266 = (state_47273[(2)]);
var state_47273__$1 = (function (){var statearr_47291 = state_47273;
(statearr_47291[(8)] = inst_47266);

return statearr_47291;
})();
var statearr_47292_49400 = state_47273__$1;
(statearr_47292_49400[(2)] = null);

(statearr_47292_49400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47274 === (8))){
var inst_47255 = (state_47273[(7)]);
var state_47273__$1 = state_47273;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47273__$1,(11),out,inst_47255);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_47296 = [null,null,null,null,null,null,null,null,null];
(statearr_47296[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_47296[(1)] = (1));

return statearr_47296;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_47273){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_47273);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e47297){var ex__44385__auto__ = e47297;
var statearr_47298_49404 = state_47273;
(statearr_47298_49404[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_47273[(4)]))){
var statearr_47299_49406 = state_47273;
(statearr_47299_49406[(1)] = cljs.core.first((state_47273[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49411 = state_47273;
state_47273 = G__49411;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_47273){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_47273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_47301 = f__44467__auto__();
(statearr_47301[(6)] = c__44466__auto___49373);

return statearr_47301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__47306 = arguments.length;
switch (G__47306) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__44466__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_47385){
var state_val_47386 = (state_47385[(1)]);
if((state_val_47386 === (7))){
var inst_47380 = (state_47385[(2)]);
var state_47385__$1 = state_47385;
var statearr_47391_49429 = state_47385__$1;
(statearr_47391_49429[(2)] = inst_47380);

(statearr_47391_49429[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (20))){
var inst_47347 = (state_47385[(7)]);
var inst_47361 = (state_47385[(2)]);
var inst_47362 = cljs.core.next(inst_47347);
var inst_47329 = inst_47362;
var inst_47330 = null;
var inst_47331 = (0);
var inst_47332 = (0);
var state_47385__$1 = (function (){var statearr_47395 = state_47385;
(statearr_47395[(8)] = inst_47331);

(statearr_47395[(9)] = inst_47332);

(statearr_47395[(10)] = inst_47330);

(statearr_47395[(11)] = inst_47329);

(statearr_47395[(12)] = inst_47361);

return statearr_47395;
})();
var statearr_47396_49432 = state_47385__$1;
(statearr_47396_49432[(2)] = null);

(statearr_47396_49432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (1))){
var state_47385__$1 = state_47385;
var statearr_47398_49433 = state_47385__$1;
(statearr_47398_49433[(2)] = null);

(statearr_47398_49433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (4))){
var inst_47317 = (state_47385[(13)]);
var inst_47317__$1 = (state_47385[(2)]);
var inst_47319 = (inst_47317__$1 == null);
var state_47385__$1 = (function (){var statearr_47402 = state_47385;
(statearr_47402[(13)] = inst_47317__$1);

return statearr_47402;
})();
if(cljs.core.truth_(inst_47319)){
var statearr_47403_49435 = state_47385__$1;
(statearr_47403_49435[(1)] = (5));

} else {
var statearr_47404_49436 = state_47385__$1;
(statearr_47404_49436[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (15))){
var state_47385__$1 = state_47385;
var statearr_47409_49439 = state_47385__$1;
(statearr_47409_49439[(2)] = null);

(statearr_47409_49439[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (21))){
var state_47385__$1 = state_47385;
var statearr_47413_49441 = state_47385__$1;
(statearr_47413_49441[(2)] = null);

(statearr_47413_49441[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (13))){
var inst_47331 = (state_47385[(8)]);
var inst_47332 = (state_47385[(9)]);
var inst_47330 = (state_47385[(10)]);
var inst_47329 = (state_47385[(11)]);
var inst_47342 = (state_47385[(2)]);
var inst_47343 = (inst_47332 + (1));
var tmp47406 = inst_47331;
var tmp47407 = inst_47330;
var tmp47408 = inst_47329;
var inst_47329__$1 = tmp47408;
var inst_47330__$1 = tmp47407;
var inst_47331__$1 = tmp47406;
var inst_47332__$1 = inst_47343;
var state_47385__$1 = (function (){var statearr_47415 = state_47385;
(statearr_47415[(8)] = inst_47331__$1);

(statearr_47415[(9)] = inst_47332__$1);

(statearr_47415[(10)] = inst_47330__$1);

(statearr_47415[(14)] = inst_47342);

(statearr_47415[(11)] = inst_47329__$1);

return statearr_47415;
})();
var statearr_47419_49443 = state_47385__$1;
(statearr_47419_49443[(2)] = null);

(statearr_47419_49443[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (22))){
var state_47385__$1 = state_47385;
var statearr_47420_49444 = state_47385__$1;
(statearr_47420_49444[(2)] = null);

(statearr_47420_49444[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (6))){
var inst_47317 = (state_47385[(13)]);
var inst_47327 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47317) : f.call(null,inst_47317));
var inst_47328 = cljs.core.seq(inst_47327);
var inst_47329 = inst_47328;
var inst_47330 = null;
var inst_47331 = (0);
var inst_47332 = (0);
var state_47385__$1 = (function (){var statearr_47425 = state_47385;
(statearr_47425[(8)] = inst_47331);

(statearr_47425[(9)] = inst_47332);

(statearr_47425[(10)] = inst_47330);

(statearr_47425[(11)] = inst_47329);

return statearr_47425;
})();
var statearr_47426_49447 = state_47385__$1;
(statearr_47426_49447[(2)] = null);

(statearr_47426_49447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (17))){
var inst_47347 = (state_47385[(7)]);
var inst_47351 = cljs.core.chunk_first(inst_47347);
var inst_47353 = cljs.core.chunk_rest(inst_47347);
var inst_47355 = cljs.core.count(inst_47351);
var inst_47329 = inst_47353;
var inst_47330 = inst_47351;
var inst_47331 = inst_47355;
var inst_47332 = (0);
var state_47385__$1 = (function (){var statearr_47431 = state_47385;
(statearr_47431[(8)] = inst_47331);

(statearr_47431[(9)] = inst_47332);

(statearr_47431[(10)] = inst_47330);

(statearr_47431[(11)] = inst_47329);

return statearr_47431;
})();
var statearr_47432_49448 = state_47385__$1;
(statearr_47432_49448[(2)] = null);

(statearr_47432_49448[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (3))){
var inst_47382 = (state_47385[(2)]);
var state_47385__$1 = state_47385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47385__$1,inst_47382);
} else {
if((state_val_47386 === (12))){
var inst_47370 = (state_47385[(2)]);
var state_47385__$1 = state_47385;
var statearr_47437_49450 = state_47385__$1;
(statearr_47437_49450[(2)] = inst_47370);

(statearr_47437_49450[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (2))){
var state_47385__$1 = state_47385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47385__$1,(4),in$);
} else {
if((state_val_47386 === (23))){
var inst_47378 = (state_47385[(2)]);
var state_47385__$1 = state_47385;
var statearr_47440_49453 = state_47385__$1;
(statearr_47440_49453[(2)] = inst_47378);

(statearr_47440_49453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (19))){
var inst_47365 = (state_47385[(2)]);
var state_47385__$1 = state_47385;
var statearr_47444_49455 = state_47385__$1;
(statearr_47444_49455[(2)] = inst_47365);

(statearr_47444_49455[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (11))){
var inst_47347 = (state_47385[(7)]);
var inst_47329 = (state_47385[(11)]);
var inst_47347__$1 = cljs.core.seq(inst_47329);
var state_47385__$1 = (function (){var statearr_47446 = state_47385;
(statearr_47446[(7)] = inst_47347__$1);

return statearr_47446;
})();
if(inst_47347__$1){
var statearr_47447_49459 = state_47385__$1;
(statearr_47447_49459[(1)] = (14));

} else {
var statearr_47450_49461 = state_47385__$1;
(statearr_47450_49461[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (9))){
var inst_47372 = (state_47385[(2)]);
var inst_47373 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_47385__$1 = (function (){var statearr_47452 = state_47385;
(statearr_47452[(15)] = inst_47372);

return statearr_47452;
})();
if(cljs.core.truth_(inst_47373)){
var statearr_47455_49464 = state_47385__$1;
(statearr_47455_49464[(1)] = (21));

} else {
var statearr_47457_49465 = state_47385__$1;
(statearr_47457_49465[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (5))){
var inst_47321 = cljs.core.async.close_BANG_(out);
var state_47385__$1 = state_47385;
var statearr_47459_49466 = state_47385__$1;
(statearr_47459_49466[(2)] = inst_47321);

(statearr_47459_49466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (14))){
var inst_47347 = (state_47385[(7)]);
var inst_47349 = cljs.core.chunked_seq_QMARK_(inst_47347);
var state_47385__$1 = state_47385;
if(inst_47349){
var statearr_47462_49468 = state_47385__$1;
(statearr_47462_49468[(1)] = (17));

} else {
var statearr_47465_49471 = state_47385__$1;
(statearr_47465_49471[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (16))){
var inst_47368 = (state_47385[(2)]);
var state_47385__$1 = state_47385;
var statearr_47468_49475 = state_47385__$1;
(statearr_47468_49475[(2)] = inst_47368);

(statearr_47468_49475[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47386 === (10))){
var inst_47332 = (state_47385[(9)]);
var inst_47330 = (state_47385[(10)]);
var inst_47340 = cljs.core._nth(inst_47330,inst_47332);
var state_47385__$1 = state_47385;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47385__$1,(13),out,inst_47340);
} else {
if((state_val_47386 === (18))){
var inst_47347 = (state_47385[(7)]);
var inst_47359 = cljs.core.first(inst_47347);
var state_47385__$1 = state_47385;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47385__$1,(20),out,inst_47359);
} else {
if((state_val_47386 === (8))){
var inst_47331 = (state_47385[(8)]);
var inst_47332 = (state_47385[(9)]);
var inst_47336 = (inst_47332 < inst_47331);
var inst_47337 = inst_47336;
var state_47385__$1 = state_47385;
if(cljs.core.truth_(inst_47337)){
var statearr_47476_49485 = state_47385__$1;
(statearr_47476_49485[(1)] = (10));

} else {
var statearr_47478_49487 = state_47385__$1;
(statearr_47478_49487[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__44382__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__44382__auto____0 = (function (){
var statearr_47480 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47480[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__44382__auto__);

(statearr_47480[(1)] = (1));

return statearr_47480;
});
var cljs$core$async$mapcat_STAR__$_state_machine__44382__auto____1 = (function (state_47385){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_47385);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e47484){var ex__44385__auto__ = e47484;
var statearr_47485_49493 = state_47385;
(statearr_47485_49493[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_47385[(4)]))){
var statearr_47486_49494 = state_47385;
(statearr_47486_49494[(1)] = cljs.core.first((state_47385[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49497 = state_47385;
state_47385 = G__49497;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__44382__auto__ = function(state_47385){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__44382__auto____1.call(this,state_47385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__44382__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__44382__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_47496 = f__44467__auto__();
(statearr_47496[(6)] = c__44466__auto__);

return statearr_47496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));

return c__44466__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__47505 = arguments.length;
switch (G__47505) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__47514 = arguments.length;
switch (G__47514) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__47525 = arguments.length;
switch (G__47525) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44466__auto___49508 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_47557){
var state_val_47558 = (state_47557[(1)]);
if((state_val_47558 === (7))){
var inst_47552 = (state_47557[(2)]);
var state_47557__$1 = state_47557;
var statearr_47563_49509 = state_47557__$1;
(statearr_47563_49509[(2)] = inst_47552);

(statearr_47563_49509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47558 === (1))){
var inst_47533 = null;
var state_47557__$1 = (function (){var statearr_47566 = state_47557;
(statearr_47566[(7)] = inst_47533);

return statearr_47566;
})();
var statearr_47569_49510 = state_47557__$1;
(statearr_47569_49510[(2)] = null);

(statearr_47569_49510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47558 === (4))){
var inst_47536 = (state_47557[(8)]);
var inst_47536__$1 = (state_47557[(2)]);
var inst_47537 = (inst_47536__$1 == null);
var inst_47538 = cljs.core.not(inst_47537);
var state_47557__$1 = (function (){var statearr_47571 = state_47557;
(statearr_47571[(8)] = inst_47536__$1);

return statearr_47571;
})();
if(inst_47538){
var statearr_47572_49514 = state_47557__$1;
(statearr_47572_49514[(1)] = (5));

} else {
var statearr_47574_49515 = state_47557__$1;
(statearr_47574_49515[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47558 === (6))){
var state_47557__$1 = state_47557;
var statearr_47577_49517 = state_47557__$1;
(statearr_47577_49517[(2)] = null);

(statearr_47577_49517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47558 === (3))){
var inst_47554 = (state_47557[(2)]);
var inst_47555 = cljs.core.async.close_BANG_(out);
var state_47557__$1 = (function (){var statearr_47581 = state_47557;
(statearr_47581[(9)] = inst_47554);

return statearr_47581;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47557__$1,inst_47555);
} else {
if((state_val_47558 === (2))){
var state_47557__$1 = state_47557;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47557__$1,(4),ch);
} else {
if((state_val_47558 === (11))){
var inst_47536 = (state_47557[(8)]);
var inst_47546 = (state_47557[(2)]);
var inst_47533 = inst_47536;
var state_47557__$1 = (function (){var statearr_47586 = state_47557;
(statearr_47586[(7)] = inst_47533);

(statearr_47586[(10)] = inst_47546);

return statearr_47586;
})();
var statearr_47588_49523 = state_47557__$1;
(statearr_47588_49523[(2)] = null);

(statearr_47588_49523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47558 === (9))){
var inst_47536 = (state_47557[(8)]);
var state_47557__$1 = state_47557;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47557__$1,(11),out,inst_47536);
} else {
if((state_val_47558 === (5))){
var inst_47536 = (state_47557[(8)]);
var inst_47533 = (state_47557[(7)]);
var inst_47540 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47536,inst_47533);
var state_47557__$1 = state_47557;
if(inst_47540){
var statearr_47593_49527 = state_47557__$1;
(statearr_47593_49527[(1)] = (8));

} else {
var statearr_47596_49528 = state_47557__$1;
(statearr_47596_49528[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47558 === (10))){
var inst_47549 = (state_47557[(2)]);
var state_47557__$1 = state_47557;
var statearr_47598_49529 = state_47557__$1;
(statearr_47598_49529[(2)] = inst_47549);

(statearr_47598_49529[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47558 === (8))){
var inst_47533 = (state_47557[(7)]);
var tmp47592 = inst_47533;
var inst_47533__$1 = tmp47592;
var state_47557__$1 = (function (){var statearr_47600 = state_47557;
(statearr_47600[(7)] = inst_47533__$1);

return statearr_47600;
})();
var statearr_47601_49531 = state_47557__$1;
(statearr_47601_49531[(2)] = null);

(statearr_47601_49531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_47605 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47605[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_47605[(1)] = (1));

return statearr_47605;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_47557){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_47557);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e47607){var ex__44385__auto__ = e47607;
var statearr_47608_49535 = state_47557;
(statearr_47608_49535[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_47557[(4)]))){
var statearr_47611_49536 = state_47557;
(statearr_47611_49536[(1)] = cljs.core.first((state_47557[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49538 = state_47557;
state_47557 = G__49538;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_47557){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_47557);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_47614 = f__44467__auto__();
(statearr_47614[(6)] = c__44466__auto___49508);

return statearr_47614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__47620 = arguments.length;
switch (G__47620) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44466__auto___49542 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_47669){
var state_val_47670 = (state_47669[(1)]);
if((state_val_47670 === (7))){
var inst_47665 = (state_47669[(2)]);
var state_47669__$1 = state_47669;
var statearr_47675_49543 = state_47669__$1;
(statearr_47675_49543[(2)] = inst_47665);

(statearr_47675_49543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (1))){
var inst_47628 = (new Array(n));
var inst_47629 = inst_47628;
var inst_47630 = (0);
var state_47669__$1 = (function (){var statearr_47677 = state_47669;
(statearr_47677[(7)] = inst_47629);

(statearr_47677[(8)] = inst_47630);

return statearr_47677;
})();
var statearr_47679_49549 = state_47669__$1;
(statearr_47679_49549[(2)] = null);

(statearr_47679_49549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (4))){
var inst_47633 = (state_47669[(9)]);
var inst_47633__$1 = (state_47669[(2)]);
var inst_47634 = (inst_47633__$1 == null);
var inst_47635 = cljs.core.not(inst_47634);
var state_47669__$1 = (function (){var statearr_47682 = state_47669;
(statearr_47682[(9)] = inst_47633__$1);

return statearr_47682;
})();
if(inst_47635){
var statearr_47684_49554 = state_47669__$1;
(statearr_47684_49554[(1)] = (5));

} else {
var statearr_47685_49555 = state_47669__$1;
(statearr_47685_49555[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (15))){
var inst_47658 = (state_47669[(2)]);
var state_47669__$1 = state_47669;
var statearr_47688_49560 = state_47669__$1;
(statearr_47688_49560[(2)] = inst_47658);

(statearr_47688_49560[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (13))){
var state_47669__$1 = state_47669;
var statearr_47690_49564 = state_47669__$1;
(statearr_47690_49564[(2)] = null);

(statearr_47690_49564[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (6))){
var inst_47630 = (state_47669[(8)]);
var inst_47653 = (inst_47630 > (0));
var state_47669__$1 = state_47669;
if(cljs.core.truth_(inst_47653)){
var statearr_47694_49567 = state_47669__$1;
(statearr_47694_49567[(1)] = (12));

} else {
var statearr_47695_49568 = state_47669__$1;
(statearr_47695_49568[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (3))){
var inst_47667 = (state_47669[(2)]);
var state_47669__$1 = state_47669;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47669__$1,inst_47667);
} else {
if((state_val_47670 === (12))){
var inst_47629 = (state_47669[(7)]);
var inst_47656 = cljs.core.vec(inst_47629);
var state_47669__$1 = state_47669;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47669__$1,(15),out,inst_47656);
} else {
if((state_val_47670 === (2))){
var state_47669__$1 = state_47669;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47669__$1,(4),ch);
} else {
if((state_val_47670 === (11))){
var inst_47646 = (state_47669[(2)]);
var inst_47647 = (new Array(n));
var inst_47629 = inst_47647;
var inst_47630 = (0);
var state_47669__$1 = (function (){var statearr_47706 = state_47669;
(statearr_47706[(7)] = inst_47629);

(statearr_47706[(8)] = inst_47630);

(statearr_47706[(10)] = inst_47646);

return statearr_47706;
})();
var statearr_47707_49580 = state_47669__$1;
(statearr_47707_49580[(2)] = null);

(statearr_47707_49580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (9))){
var inst_47629 = (state_47669[(7)]);
var inst_47644 = cljs.core.vec(inst_47629);
var state_47669__$1 = state_47669;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47669__$1,(11),out,inst_47644);
} else {
if((state_val_47670 === (5))){
var inst_47629 = (state_47669[(7)]);
var inst_47639 = (state_47669[(11)]);
var inst_47630 = (state_47669[(8)]);
var inst_47633 = (state_47669[(9)]);
var inst_47637 = (inst_47629[inst_47630] = inst_47633);
var inst_47639__$1 = (inst_47630 + (1));
var inst_47640 = (inst_47639__$1 < n);
var state_47669__$1 = (function (){var statearr_47713 = state_47669;
(statearr_47713[(11)] = inst_47639__$1);

(statearr_47713[(12)] = inst_47637);

return statearr_47713;
})();
if(cljs.core.truth_(inst_47640)){
var statearr_47714_49585 = state_47669__$1;
(statearr_47714_49585[(1)] = (8));

} else {
var statearr_47715_49587 = state_47669__$1;
(statearr_47715_49587[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (14))){
var inst_47661 = (state_47669[(2)]);
var inst_47663 = cljs.core.async.close_BANG_(out);
var state_47669__$1 = (function (){var statearr_47717 = state_47669;
(statearr_47717[(13)] = inst_47661);

return statearr_47717;
})();
var statearr_47718_49599 = state_47669__$1;
(statearr_47718_49599[(2)] = inst_47663);

(statearr_47718_49599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (10))){
var inst_47650 = (state_47669[(2)]);
var state_47669__$1 = state_47669;
var statearr_47719_49601 = state_47669__$1;
(statearr_47719_49601[(2)] = inst_47650);

(statearr_47719_49601[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47670 === (8))){
var inst_47629 = (state_47669[(7)]);
var inst_47639 = (state_47669[(11)]);
var tmp47716 = inst_47629;
var inst_47629__$1 = tmp47716;
var inst_47630 = inst_47639;
var state_47669__$1 = (function (){var statearr_47724 = state_47669;
(statearr_47724[(7)] = inst_47629__$1);

(statearr_47724[(8)] = inst_47630);

return statearr_47724;
})();
var statearr_47728_49607 = state_47669__$1;
(statearr_47728_49607[(2)] = null);

(statearr_47728_49607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_47730 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47730[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_47730[(1)] = (1));

return statearr_47730;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_47669){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_47669);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e47731){var ex__44385__auto__ = e47731;
var statearr_47732_49610 = state_47669;
(statearr_47732_49610[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_47669[(4)]))){
var statearr_47733_49611 = state_47669;
(statearr_47733_49611[(1)] = cljs.core.first((state_47669[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49613 = state_47669;
state_47669 = G__49613;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_47669){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_47669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_47738 = f__44467__auto__();
(statearr_47738[(6)] = c__44466__auto___49542);

return statearr_47738;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__47744 = arguments.length;
switch (G__47744) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__44466__auto___49621 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_47805){
var state_val_47806 = (state_47805[(1)]);
if((state_val_47806 === (7))){
var inst_47798 = (state_47805[(2)]);
var state_47805__$1 = state_47805;
var statearr_47809_49631 = state_47805__$1;
(statearr_47809_49631[(2)] = inst_47798);

(statearr_47809_49631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (1))){
var inst_47751 = [];
var inst_47752 = inst_47751;
var inst_47753 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_47805__$1 = (function (){var statearr_47814 = state_47805;
(statearr_47814[(7)] = inst_47753);

(statearr_47814[(8)] = inst_47752);

return statearr_47814;
})();
var statearr_47815_49633 = state_47805__$1;
(statearr_47815_49633[(2)] = null);

(statearr_47815_49633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (4))){
var inst_47759 = (state_47805[(9)]);
var inst_47759__$1 = (state_47805[(2)]);
var inst_47760 = (inst_47759__$1 == null);
var inst_47761 = cljs.core.not(inst_47760);
var state_47805__$1 = (function (){var statearr_47820 = state_47805;
(statearr_47820[(9)] = inst_47759__$1);

return statearr_47820;
})();
if(inst_47761){
var statearr_47821_49646 = state_47805__$1;
(statearr_47821_49646[(1)] = (5));

} else {
var statearr_47822_49647 = state_47805__$1;
(statearr_47822_49647[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (15))){
var inst_47752 = (state_47805[(8)]);
var inst_47790 = cljs.core.vec(inst_47752);
var state_47805__$1 = state_47805;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47805__$1,(18),out,inst_47790);
} else {
if((state_val_47806 === (13))){
var inst_47781 = (state_47805[(2)]);
var state_47805__$1 = state_47805;
var statearr_47827_49648 = state_47805__$1;
(statearr_47827_49648[(2)] = inst_47781);

(statearr_47827_49648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (6))){
var inst_47752 = (state_47805[(8)]);
var inst_47783 = inst_47752.length;
var inst_47784 = (inst_47783 > (0));
var state_47805__$1 = state_47805;
if(cljs.core.truth_(inst_47784)){
var statearr_47830_49651 = state_47805__$1;
(statearr_47830_49651[(1)] = (15));

} else {
var statearr_47831_49652 = state_47805__$1;
(statearr_47831_49652[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (17))){
var inst_47795 = (state_47805[(2)]);
var inst_47796 = cljs.core.async.close_BANG_(out);
var state_47805__$1 = (function (){var statearr_47833 = state_47805;
(statearr_47833[(10)] = inst_47795);

return statearr_47833;
})();
var statearr_47834_49654 = state_47805__$1;
(statearr_47834_49654[(2)] = inst_47796);

(statearr_47834_49654[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (3))){
var inst_47800 = (state_47805[(2)]);
var state_47805__$1 = state_47805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47805__$1,inst_47800);
} else {
if((state_val_47806 === (12))){
var inst_47752 = (state_47805[(8)]);
var inst_47774 = cljs.core.vec(inst_47752);
var state_47805__$1 = state_47805;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_47805__$1,(14),out,inst_47774);
} else {
if((state_val_47806 === (2))){
var state_47805__$1 = state_47805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47805__$1,(4),ch);
} else {
if((state_val_47806 === (11))){
var inst_47763 = (state_47805[(11)]);
var inst_47759 = (state_47805[(9)]);
var inst_47752 = (state_47805[(8)]);
var inst_47771 = inst_47752.push(inst_47759);
var tmp47836 = inst_47752;
var inst_47752__$1 = tmp47836;
var inst_47753 = inst_47763;
var state_47805__$1 = (function (){var statearr_47841 = state_47805;
(statearr_47841[(12)] = inst_47771);

(statearr_47841[(7)] = inst_47753);

(statearr_47841[(8)] = inst_47752__$1);

return statearr_47841;
})();
var statearr_47845_49658 = state_47805__$1;
(statearr_47845_49658[(2)] = null);

(statearr_47845_49658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (9))){
var inst_47753 = (state_47805[(7)]);
var inst_47767 = cljs.core.keyword_identical_QMARK_(inst_47753,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_47805__$1 = state_47805;
var statearr_47849_49660 = state_47805__$1;
(statearr_47849_49660[(2)] = inst_47767);

(statearr_47849_49660[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (5))){
var inst_47763 = (state_47805[(11)]);
var inst_47759 = (state_47805[(9)]);
var inst_47764 = (state_47805[(13)]);
var inst_47753 = (state_47805[(7)]);
var inst_47763__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_47759) : f.call(null,inst_47759));
var inst_47764__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47763__$1,inst_47753);
var state_47805__$1 = (function (){var statearr_47855 = state_47805;
(statearr_47855[(11)] = inst_47763__$1);

(statearr_47855[(13)] = inst_47764__$1);

return statearr_47855;
})();
if(inst_47764__$1){
var statearr_47859_49662 = state_47805__$1;
(statearr_47859_49662[(1)] = (8));

} else {
var statearr_47861_49663 = state_47805__$1;
(statearr_47861_49663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (14))){
var inst_47763 = (state_47805[(11)]);
var inst_47759 = (state_47805[(9)]);
var inst_47776 = (state_47805[(2)]);
var inst_47777 = [];
var inst_47778 = inst_47777.push(inst_47759);
var inst_47752 = inst_47777;
var inst_47753 = inst_47763;
var state_47805__$1 = (function (){var statearr_47862 = state_47805;
(statearr_47862[(14)] = inst_47776);

(statearr_47862[(15)] = inst_47778);

(statearr_47862[(7)] = inst_47753);

(statearr_47862[(8)] = inst_47752);

return statearr_47862;
})();
var statearr_47866_49673 = state_47805__$1;
(statearr_47866_49673[(2)] = null);

(statearr_47866_49673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (16))){
var state_47805__$1 = state_47805;
var statearr_47868_49674 = state_47805__$1;
(statearr_47868_49674[(2)] = null);

(statearr_47868_49674[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (10))){
var inst_47769 = (state_47805[(2)]);
var state_47805__$1 = state_47805;
if(cljs.core.truth_(inst_47769)){
var statearr_47869_49675 = state_47805__$1;
(statearr_47869_49675[(1)] = (11));

} else {
var statearr_47870_49677 = state_47805__$1;
(statearr_47870_49677[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (18))){
var inst_47792 = (state_47805[(2)]);
var state_47805__$1 = state_47805;
var statearr_47875_49679 = state_47805__$1;
(statearr_47875_49679[(2)] = inst_47792);

(statearr_47875_49679[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47806 === (8))){
var inst_47764 = (state_47805[(13)]);
var state_47805__$1 = state_47805;
var statearr_47876_49680 = state_47805__$1;
(statearr_47876_49680[(2)] = inst_47764);

(statearr_47876_49680[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__44382__auto__ = null;
var cljs$core$async$state_machine__44382__auto____0 = (function (){
var statearr_47879 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47879[(0)] = cljs$core$async$state_machine__44382__auto__);

(statearr_47879[(1)] = (1));

return statearr_47879;
});
var cljs$core$async$state_machine__44382__auto____1 = (function (state_47805){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_47805);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e47880){var ex__44385__auto__ = e47880;
var statearr_47881_49682 = state_47805;
(statearr_47881_49682[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_47805[(4)]))){
var statearr_47882_49684 = state_47805;
(statearr_47882_49684[(1)] = cljs.core.first((state_47805[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__49686 = state_47805;
state_47805 = G__49686;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
cljs$core$async$state_machine__44382__auto__ = function(state_47805){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__44382__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__44382__auto____1.call(this,state_47805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__44382__auto____0;
cljs$core$async$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__44382__auto____1;
return cljs$core$async$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_47883 = f__44467__auto__();
(statearr_47883[(6)] = c__44466__auto___49621);

return statearr_47883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
