goog.provide('dv.cljs_emotion');
goog.scope(function(){
  dv.cljs_emotion.goog$module$goog$object = goog.module.get('goog.object');
});
var module$node_modules$react$index=shadow.js.require("module$node_modules$react$index", {});
var module$node_modules$$emotion$hash$dist$emotion_hash_cjs=shadow.js.require("module$node_modules$$emotion$hash$dist$emotion_hash_cjs", {});
var module$node_modules$$emotion$styled$dist$emotion_styled_cjs=shadow.js.require("module$node_modules$$emotion$styled$dist$emotion_styled_cjs", {});
var module$node_modules$$emotion$react$dist$emotion_react_cjs=shadow.js.require("module$node_modules$$emotion$react$dist$emotion_react_cjs", {});
dv.cljs_emotion.emotion_hash = dv.cljs_emotion.goog$module$goog$object.get(module$node_modules$$emotion$hash$dist$emotion_hash_cjs,"default");
dv.cljs_emotion.styled = dv.cljs_emotion.goog$module$goog$object.get(module$node_modules$$emotion$styled$dist$emotion_styled_cjs,"default");
dv.cljs_emotion.jsx_STAR_ = module$node_modules$$emotion$react$dist$emotion_react_cjs.jsx;
dv.cljs_emotion.obj_set = (function dv$cljs_emotion$obj_set(o,k,v){
return dv.cljs_emotion.goog$module$goog$object.set(o,k,v);
});
dv.cljs_emotion.obj_get = (function dv$cljs_emotion$obj_get(o,k){
return dv.cljs_emotion.goog$module$goog$object.get(o,k);
});
/**
 * Utility function that will force a lazy sequence of children (recursively) into realized
 *   vectors (React cannot deal with lazy seqs in production mode)
 */
dv.cljs_emotion.force_children = (function dv$cljs_emotion$force_children(x){
if(cljs.core.seq_QMARK_(x)){
return cljs.core.to_array(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(dv.cljs_emotion.force_children,x));
} else {
return x;
}
});
dv.cljs_emotion.kebab__GT_camel = (function dv$cljs_emotion$kebab__GT_camel(prop){
if(clojure.string.starts_with_QMARK_(prop,".")){
return prop;
} else {
if(clojure.string.includes_QMARK_(prop,"-")){
var words = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(clojure.string.capitalize,cljs.core.re_seq(/[a-zA-Z]+/,prop));
return clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.update.cljs$core$IFn$_invoke$arity$3(words,(0),clojure.string.lower_case));
} else {
return prop;
}
}
});
/**
 * Also replaces styled components with their css classname is key position.
 */
dv.cljs_emotion.camelize_keys = (function dv$cljs_emotion$camelize_keys(style_map){
return clojure.walk.postwalk((function dv$cljs_emotion$camelize_keys_$_in_walk(v){
if((v instanceof cljs.core.Keyword)){
return dv.cljs_emotion.kebab__GT_camel(cljs.core.name(v));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.meta(v);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(v),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4251__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v)))].join('');
} else {
return v;

}
}
}),style_map);
});
dv.cljs_emotion.keyframes = (function dv$cljs_emotion$keyframes(anim_map){
return module$node_modules$$emotion$react$dist$emotion_react_cjs.keyframes(cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys(anim_map)));
});
dv.cljs_emotion.cljs_props_key = "dv.cljs-emotion/props";
dv.cljs_emotion.wrap_call_style_fn = (function dv$cljs_emotion$wrap_call_style_fn(anon_styles_QMARK_){
return (function (x){
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core.meta(x);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.contains_QMARK_(cljs.core.meta(x),new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661));
} else {
return and__4251__auto__;
}
})())){
return [".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword("dv.cljs-emotion","hashed-name","dv.cljs-emotion/hashed-name",-795044661).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(x)))].join('');
} else {
if(cljs.core.fn_QMARK_(x)){
return (function (arg){
delete arg["children"];

if(cljs.core.truth_(anon_styles_QMARK_)){
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((function (){var G__62565 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(arg,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__62565) : x.call(null,G__62565));
})()));
} else {
var cljs_args = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dv.cljs_emotion.obj_get(arg,dv.cljs_emotion.cljs_props_key),new cljs.core.Keyword(null,"theme","theme",-1247880880),cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(dv.cljs_emotion.obj_get(arg,"theme"),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return cljs.core.clj__GT_js(dv.cljs_emotion.camelize_keys((x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(cljs_args) : x.call(null,cljs_args))));
}
});
} else {
if(cljs.core.map_QMARK_(x)){
return dv.cljs_emotion.camelize_keys(x);
} else {
return x;

}
}
}
});
});
/**
 * @define {string}
 */
dv.cljs_emotion.ADD_CLASSNAMES = goog.define("dv.cljs_emotion.ADD_CLASSNAMES","INITIAL");
dv.cljs_emotion.add_class_names_QMARK_ = (function dv$cljs_emotion$add_class_names_QMARK_(){
if(cljs.core.boolean_QMARK_(dv.cljs_emotion.ADD_CLASSNAMES)){
return dv.cljs_emotion.ADD_CLASSNAMES;
} else {
return goog.DEBUG;
}
});
dv.cljs_emotion.add_class_name = (function dv$cljs_emotion$add_class_name(props,class_name){
if(cljs.core.object_QMARK_(props)){
var G__62567 = props;
dv.cljs_emotion.goog$module$goog$object.set(G__62567,"className",clojure.string.trim(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [class_name,dv.cljs_emotion.goog$module$goog$object.get(props,"className")], null))));

return G__62567;
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(props,new cljs.core.Keyword(null,"className","className",-1983287057),(function (p1__62566_SHARP_){
if((p1__62566_SHARP_ == null)){
return class_name;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class_name)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__62566_SHARP_)].join('');
}
}));
}
});
dv.cljs_emotion.hashit = (function dv$cljs_emotion$hashit(string){
return ["dvcss-",cljs.core.str.cljs$core$IFn$_invoke$arity$1((dv.cljs_emotion.emotion_hash.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.emotion_hash.cljs$core$IFn$_invoke$arity$1(string) : dv.cljs_emotion.emotion_hash.call(null,string)))].join('');
});
dv.cljs_emotion.set_class_name = (function dv$cljs_emotion$set_class_name(props,class_name){
if(cljs.core.truth_(class_name)){
var hashed_name = dv.cljs_emotion.hashit(class_name);
var props__$1 = dv.cljs_emotion.add_class_name(props,hashed_name);
if(cljs.core.truth_(dv.cljs_emotion.add_class_names_QMARK_())){
return dv.cljs_emotion.add_class_name(props__$1,class_name);
} else {
return props__$1;
}
} else {
return props;
}
});
dv.cljs_emotion.map__GT_obj = (function dv$cljs_emotion$map__GT_obj(m){
return cljs.core.reduce_kv((function (o,k,v){
var new_k = (function (){var G__62568 = k;
if((((!((k == null))))?(((((k.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === k.cljs$core$INamed$))))?true:false):false)){
return cljs.core.name(G__62568);
} else {
return G__62568;
}
})();
var new_v = (function (){var G__62570 = v;
if(cljs.core.map_QMARK_(v)){
return (dv.cljs_emotion.map__GT_obj.cljs$core$IFn$_invoke$arity$1 ? dv.cljs_emotion.map__GT_obj.cljs$core$IFn$_invoke$arity$1(G__62570) : dv.cljs_emotion.map__GT_obj.call(null,G__62570));
} else {
return G__62570;
}
})();
var G__62571 = o;
dv.cljs_emotion.obj_set(G__62571,new_k,new_v);

return G__62571;
}),({}),m);
});
dv.cljs_emotion.make_js_props = (function dv$cljs_emotion$make_js_props(props,class_name){
if(cljs.core.object_QMARK_(props)){
return props;
} else {
var clj_props = dv.cljs_emotion.set_class_name(props,class_name);
var js_props = dv.cljs_emotion.map__GT_obj(clj_props);
var G__62572 = js_props;
dv.cljs_emotion.obj_set(G__62572,dv.cljs_emotion.cljs_props_key,clj_props);

return G__62572;
}
});
dv.cljs_emotion.react_factory = (function dv$cljs_emotion$react_factory(el,class_name){
return (function() {
var G__62617 = null;
var G__62617__0 = (function (){
var G__62573 = el;
var G__62574 = cljs.core.clj__GT_js(dv.cljs_emotion.set_class_name(cljs.core.PersistentArrayMap.EMPTY,class_name));
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2(G__62573,G__62574) : dv.cljs_emotion.jsx_STAR_.call(null,G__62573,G__62574));
});
var G__62617__1 = (function (props){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = module$node_modules$react$index.isValidElement(props);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return typeof props === 'string';
}
})())){
var G__62576 = el;
var G__62577 = dv.cljs_emotion.set_class_name(({}),class_name);
var G__62578 = props;
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3(G__62576,G__62577,G__62578) : dv.cljs_emotion.jsx_STAR_.call(null,G__62576,G__62577,G__62578));
} else {
if(cljs.core.map_QMARK_(props)){
var G__62579 = el;
var G__62580 = dv.cljs_emotion.make_js_props(props,class_name);
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2(G__62579,G__62580) : dv.cljs_emotion.jsx_STAR_.call(null,G__62579,G__62580));
} else {
if(cljs.core.object_QMARK_(props)){
var G__62581 = el;
var G__62582 = dv.cljs_emotion.set_class_name(props,class_name);
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2(G__62581,G__62582) : dv.cljs_emotion.jsx_STAR_.call(null,G__62581,G__62582));
} else {
if(((cljs.core.array_QMARK_(props)) || (cljs.core.coll_QMARK_(props)))){
var G__62583 = el;
var G__62584 = dv.cljs_emotion.set_class_name(({}),class_name);
var G__62585 = dv.cljs_emotion.force_children(props);
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$3(G__62583,G__62584,G__62585) : dv.cljs_emotion.jsx_STAR_.call(null,G__62583,G__62584,G__62585));
} else {
var G__62586 = el;
var G__62587 = dv.cljs_emotion.set_class_name(({}),class_name);
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2(G__62586,G__62587) : dv.cljs_emotion.jsx_STAR_.call(null,G__62586,G__62587));

}
}
}
}
}catch (e62575){if((e62575 instanceof Object)){
var e = e62575;
return console.error("Error invoking an emotion styled component: ",e);
} else {
throw e62575;

}
}});
var G__62617__2 = (function() { 
var G__62618__delegate = function (props,children){
if(((((cljs.core.object_QMARK_(props)) && (cljs.core.not(module$node_modules$react$index.isValidElement(props))))) || (cljs.core.map_QMARK_(props)))){
var js_props = dv.cljs_emotion.make_js_props(props,class_name);
if(cljs.core.seq(children)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(dv.cljs_emotion.jsx_STAR_,el,js_props,dv.cljs_emotion.force_children(children));
} else {
return (dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2 ? dv.cljs_emotion.jsx_STAR_.cljs$core$IFn$_invoke$arity$2(el,js_props) : dv.cljs_emotion.jsx_STAR_.call(null,el,js_props));
}
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(dv.cljs_emotion.jsx_STAR_,el,dv.cljs_emotion.set_class_name(({}),class_name),dv.cljs_emotion.force_children(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(props,children)));
}
};
var G__62618 = function (props,var_args){
var children = null;
if (arguments.length > 1) {
var G__62619__i = 0, G__62619__a = new Array(arguments.length -  1);
while (G__62619__i < G__62619__a.length) {G__62619__a[G__62619__i] = arguments[G__62619__i + 1]; ++G__62619__i;}
  children = new cljs.core.IndexedSeq(G__62619__a,0,null);
} 
return G__62618__delegate.call(this,props,children);};
G__62618.cljs$lang$maxFixedArity = 1;
G__62618.cljs$lang$applyTo = (function (arglist__62620){
var props = cljs.core.first(arglist__62620);
var children = cljs.core.rest(arglist__62620);
return G__62618__delegate(props,children);
});
G__62618.cljs$core$IFn$_invoke$arity$variadic = G__62618__delegate;
return G__62618;
})()
;
G__62617 = function(props,var_args){
var children = var_args;
switch(arguments.length){
case 0:
return G__62617__0.call(this);
case 1:
return G__62617__1.call(this,props);
default:
var G__62621 = null;
if (arguments.length > 1) {
var G__62622__i = 0, G__62622__a = new Array(arguments.length -  1);
while (G__62622__i < G__62622__a.length) {G__62622__a[G__62622__i] = arguments[G__62622__i + 1]; ++G__62622__i;}
G__62621 = new cljs.core.IndexedSeq(G__62622__a,0,null);
}
return G__62617__2.cljs$core$IFn$_invoke$arity$variadic(props, G__62621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__62617.cljs$lang$maxFixedArity = 1;
G__62617.cljs$lang$applyTo = G__62617__2.cljs$lang$applyTo;
G__62617.cljs$core$IFn$_invoke$arity$0 = G__62617__0;
G__62617.cljs$core$IFn$_invoke$arity$1 = G__62617__1;
G__62617.cljs$core$IFn$_invoke$arity$variadic = G__62617__2.cljs$core$IFn$_invoke$arity$variadic;
return G__62617;
})()
});
dv.cljs_emotion.global_STAR_ = dv.cljs_emotion.react_factory(module$node_modules$$emotion$react$dist$emotion_react_cjs.Global,null);
/**
 * Takes a cljs vector or hashmap of styles and converts to JS types before calling emotion's Global function.
 *   Inserts styles into the DOM that target global elements and classes.
 */
dv.cljs_emotion.global_style = (function dv$cljs_emotion$global_style(props){
return dv.cljs_emotion.global_STAR_(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"styles","styles",1954480375),dv.cljs_emotion.camelize_keys(props)], null));
});
/**
 * Takes a hashmap of a style theme and react children to render with that theme in the React Context
 *   using emotion's ThemeProvider.
 */
dv.cljs_emotion.theme_provider = (function dv$cljs_emotion$theme_provider(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62626 = arguments.length;
var i__4865__auto___62627 = (0);
while(true){
if((i__4865__auto___62627 < len__4864__auto___62626)){
args__4870__auto__.push((arguments[i__4865__auto___62627]));

var G__62628 = (i__4865__auto___62627 + (1));
i__4865__auto___62627 = G__62628;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return dv.cljs_emotion.theme_provider.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(dv.cljs_emotion.theme_provider.cljs$core$IFn$_invoke$arity$variadic = (function (props,children){
if(cljs.core.contains_QMARK_(props,new cljs.core.Keyword(null,"theme","theme",-1247880880))){
} else {
throw (new Error("You must pass a :theme to the theme-provider."));
}

return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(module$node_modules$react$index.createElement,module$node_modules$$emotion$react$dist$emotion_react_cjs.ThemeProvider,cljs.core.clj__GT_js(props),dv.cljs_emotion.force_children(children));
}));

(dv.cljs_emotion.theme_provider.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(dv.cljs_emotion.theme_provider.cljs$lang$applyTo = (function (seq62589){
var G__62590 = cljs.core.first(seq62589);
var seq62589__$1 = cljs.core.next(seq62589);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62590,seq62589__$1);
}));

/**
 * Takes a hashmap or vector of styles and converts to JS types, will pass any functions cljs data structures.
 */
dv.cljs_emotion.convert_css = (function dv$cljs_emotion$convert_css(css){
return cljs.core.clj__GT_js(clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(true),css));
});
dv.cljs_emotion.css = (function dv$cljs_emotion$css(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62637 = arguments.length;
var i__4865__auto___62638 = (0);
while(true){
if((i__4865__auto___62638 < len__4864__auto___62637)){
args__4870__auto__.push((arguments[i__4865__auto___62638]));

var G__62639 = (i__4865__auto___62638 + (1));
i__4865__auto___62638 = G__62639;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return dv.cljs_emotion.css.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(dv.cljs_emotion.css.cljs$core$IFn$_invoke$arity$variadic = (function (css){
return module$node_modules$$emotion$react$dist$emotion_react_cjs.css(cljs.core.clj__GT_js(clojure.walk.postwalk(dv.cljs_emotion.wrap_call_style_fn(true),css)));
}));

(dv.cljs_emotion.css.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(dv.cljs_emotion.css.cljs$lang$applyTo = (function (seq62591){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq62591));
}));


//# sourceMappingURL=dv.cljs_emotion.js.map
