goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_49824 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_49824(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_49826 = (function (this$){
var x__4550__auto__ = (((this$ == null))?null:this$);
var m__4551__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return (m__4551__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4551__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4551__auto__.call(null,this$));
} else {
var m__4549__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4549__auto__ == null)))){
return (m__4549__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4549__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4549__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_49826(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__47976 = coll;
var G__47977 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__47976,G__47977) : shadow.dom.lazy_native_coll_seq.call(null,G__47976,G__47977));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4253__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write(writer__4492__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__48052 = arguments.length;
switch (G__48052) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__48073 = arguments.length;
switch (G__48073) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__48084 = arguments.length;
switch (G__48084) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__48096 = arguments.length;
switch (G__48096) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__48120 = arguments.length;
switch (G__48120) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__48130 = arguments.length;
switch (G__48130) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e48151){if((e48151 instanceof Object)){
var e = e48151;
return console.log("didnt support attachEvent",el,e);
} else {
throw e48151;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4253__auto__ = (!((typeof document !== 'undefined')));
if(or__4253__auto__){
return or__4253__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__48167 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__48168 = null;
var count__48169 = (0);
var i__48170 = (0);
while(true){
if((i__48170 < count__48169)){
var el = chunk__48168.cljs$core$IIndexed$_nth$arity$2(null,i__48170);
var handler_49870__$1 = ((function (seq__48167,chunk__48168,count__48169,i__48170,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48167,chunk__48168,count__48169,i__48170,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49870__$1);


var G__49871 = seq__48167;
var G__49872 = chunk__48168;
var G__49873 = count__48169;
var G__49874 = (i__48170 + (1));
seq__48167 = G__49871;
chunk__48168 = G__49872;
count__48169 = G__49873;
i__48170 = G__49874;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48167);
if(temp__5753__auto__){
var seq__48167__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48167__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__48167__$1);
var G__49875 = cljs.core.chunk_rest(seq__48167__$1);
var G__49877 = c__4679__auto__;
var G__49878 = cljs.core.count(c__4679__auto__);
var G__49879 = (0);
seq__48167 = G__49875;
chunk__48168 = G__49877;
count__48169 = G__49878;
i__48170 = G__49879;
continue;
} else {
var el = cljs.core.first(seq__48167__$1);
var handler_49880__$1 = ((function (seq__48167,chunk__48168,count__48169,i__48170,el,seq__48167__$1,temp__5753__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__48167,chunk__48168,count__48169,i__48170,el,seq__48167__$1,temp__5753__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_49880__$1);


var G__49881 = cljs.core.next(seq__48167__$1);
var G__49882 = null;
var G__49883 = (0);
var G__49884 = (0);
seq__48167 = G__49881;
chunk__48168 = G__49882;
count__48169 = G__49883;
i__48170 = G__49884;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__48214 = arguments.length;
switch (G__48214) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__48270 = cljs.core.seq(events);
var chunk__48272 = null;
var count__48273 = (0);
var i__48274 = (0);
while(true){
if((i__48274 < count__48273)){
var vec__48331 = chunk__48272.cljs$core$IIndexed$_nth$arity$2(null,i__48274);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48331,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48331,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49897 = seq__48270;
var G__49898 = chunk__48272;
var G__49899 = count__48273;
var G__49900 = (i__48274 + (1));
seq__48270 = G__49897;
chunk__48272 = G__49898;
count__48273 = G__49899;
i__48274 = G__49900;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48270);
if(temp__5753__auto__){
var seq__48270__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48270__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__48270__$1);
var G__49902 = cljs.core.chunk_rest(seq__48270__$1);
var G__49903 = c__4679__auto__;
var G__49904 = cljs.core.count(c__4679__auto__);
var G__49905 = (0);
seq__48270 = G__49902;
chunk__48272 = G__49903;
count__48273 = G__49904;
i__48274 = G__49905;
continue;
} else {
var vec__48357 = cljs.core.first(seq__48270__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48357,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48357,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__49906 = cljs.core.next(seq__48270__$1);
var G__49907 = null;
var G__49908 = (0);
var G__49909 = (0);
seq__48270 = G__49906;
chunk__48272 = G__49907;
count__48273 = G__49908;
i__48274 = G__49909;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__48370 = cljs.core.seq(styles);
var chunk__48371 = null;
var count__48372 = (0);
var i__48373 = (0);
while(true){
if((i__48373 < count__48372)){
var vec__48410 = chunk__48371.cljs$core$IIndexed$_nth$arity$2(null,i__48373);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48410,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48410,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49912 = seq__48370;
var G__49913 = chunk__48371;
var G__49914 = count__48372;
var G__49915 = (i__48373 + (1));
seq__48370 = G__49912;
chunk__48371 = G__49913;
count__48372 = G__49914;
i__48373 = G__49915;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48370);
if(temp__5753__auto__){
var seq__48370__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48370__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__48370__$1);
var G__49916 = cljs.core.chunk_rest(seq__48370__$1);
var G__49917 = c__4679__auto__;
var G__49918 = cljs.core.count(c__4679__auto__);
var G__49919 = (0);
seq__48370 = G__49916;
chunk__48371 = G__49917;
count__48372 = G__49918;
i__48373 = G__49919;
continue;
} else {
var vec__48424 = cljs.core.first(seq__48370__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48424,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48424,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__49921 = cljs.core.next(seq__48370__$1);
var G__49922 = null;
var G__49923 = (0);
var G__49924 = (0);
seq__48370 = G__49921;
chunk__48371 = G__49922;
count__48372 = G__49923;
i__48373 = G__49924;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__48454_49925 = key;
var G__48454_49926__$1 = (((G__48454_49925 instanceof cljs.core.Keyword))?G__48454_49925.fqn:null);
switch (G__48454_49926__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_49932 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4253__auto__ = goog.string.startsWith(ks_49932,"data-");
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return goog.string.startsWith(ks_49932,"aria-");
}
})())){
el.setAttribute(ks_49932,value);
} else {
(el[ks_49932] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__48579){
var map__48583 = p__48579;
var map__48583__$1 = cljs.core.__destructure_map(map__48583);
var props = map__48583__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48583__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__48590 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48590,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48590,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48590,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__48596 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__48596,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__48596;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__48601 = arguments.length;
switch (G__48601) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5753__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5753__auto__)){
var n = temp__5753__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__48639){
var vec__48640 = p__48639;
var seq__48641 = cljs.core.seq(vec__48640);
var first__48642 = cljs.core.first(seq__48641);
var seq__48641__$1 = cljs.core.next(seq__48641);
var nn = first__48642;
var first__48642__$1 = cljs.core.first(seq__48641__$1);
var seq__48641__$2 = cljs.core.next(seq__48641__$1);
var np = first__48642__$1;
var nc = seq__48641__$2;
var node = vec__48640;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48657 = nn;
var G__48658 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48657,G__48658) : create_fn.call(null,G__48657,G__48658));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__48660 = nn;
var G__48661 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__48660,G__48661) : create_fn.call(null,G__48660,G__48661));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__48670 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48670,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48670,(1),null);
var seq__48676_49947 = cljs.core.seq(node_children);
var chunk__48677_49948 = null;
var count__48678_49949 = (0);
var i__48679_49950 = (0);
while(true){
if((i__48679_49950 < count__48678_49949)){
var child_struct_49951 = chunk__48677_49948.cljs$core$IIndexed$_nth$arity$2(null,i__48679_49950);
var children_49953 = shadow.dom.dom_node(child_struct_49951);
if(cljs.core.seq_QMARK_(children_49953)){
var seq__48839_49954 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49953));
var chunk__48841_49955 = null;
var count__48842_49956 = (0);
var i__48843_49957 = (0);
while(true){
if((i__48843_49957 < count__48842_49956)){
var child_49958 = chunk__48841_49955.cljs$core$IIndexed$_nth$arity$2(null,i__48843_49957);
if(cljs.core.truth_(child_49958)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49958);


var G__49959 = seq__48839_49954;
var G__49960 = chunk__48841_49955;
var G__49961 = count__48842_49956;
var G__49962 = (i__48843_49957 + (1));
seq__48839_49954 = G__49959;
chunk__48841_49955 = G__49960;
count__48842_49956 = G__49961;
i__48843_49957 = G__49962;
continue;
} else {
var G__49964 = seq__48839_49954;
var G__49965 = chunk__48841_49955;
var G__49966 = count__48842_49956;
var G__49967 = (i__48843_49957 + (1));
seq__48839_49954 = G__49964;
chunk__48841_49955 = G__49965;
count__48842_49956 = G__49966;
i__48843_49957 = G__49967;
continue;
}
} else {
var temp__5753__auto___49968 = cljs.core.seq(seq__48839_49954);
if(temp__5753__auto___49968){
var seq__48839_49969__$1 = temp__5753__auto___49968;
if(cljs.core.chunked_seq_QMARK_(seq__48839_49969__$1)){
var c__4679__auto___49970 = cljs.core.chunk_first(seq__48839_49969__$1);
var G__49971 = cljs.core.chunk_rest(seq__48839_49969__$1);
var G__49972 = c__4679__auto___49970;
var G__49973 = cljs.core.count(c__4679__auto___49970);
var G__49974 = (0);
seq__48839_49954 = G__49971;
chunk__48841_49955 = G__49972;
count__48842_49956 = G__49973;
i__48843_49957 = G__49974;
continue;
} else {
var child_49975 = cljs.core.first(seq__48839_49969__$1);
if(cljs.core.truth_(child_49975)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_49975);


var G__49976 = cljs.core.next(seq__48839_49969__$1);
var G__49977 = null;
var G__49978 = (0);
var G__49979 = (0);
seq__48839_49954 = G__49976;
chunk__48841_49955 = G__49977;
count__48842_49956 = G__49978;
i__48843_49957 = G__49979;
continue;
} else {
var G__49981 = cljs.core.next(seq__48839_49969__$1);
var G__49982 = null;
var G__49983 = (0);
var G__49984 = (0);
seq__48839_49954 = G__49981;
chunk__48841_49955 = G__49982;
count__48842_49956 = G__49983;
i__48843_49957 = G__49984;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49953);
}


var G__49985 = seq__48676_49947;
var G__49986 = chunk__48677_49948;
var G__49987 = count__48678_49949;
var G__49988 = (i__48679_49950 + (1));
seq__48676_49947 = G__49985;
chunk__48677_49948 = G__49986;
count__48678_49949 = G__49987;
i__48679_49950 = G__49988;
continue;
} else {
var temp__5753__auto___49989 = cljs.core.seq(seq__48676_49947);
if(temp__5753__auto___49989){
var seq__48676_49990__$1 = temp__5753__auto___49989;
if(cljs.core.chunked_seq_QMARK_(seq__48676_49990__$1)){
var c__4679__auto___49991 = cljs.core.chunk_first(seq__48676_49990__$1);
var G__49992 = cljs.core.chunk_rest(seq__48676_49990__$1);
var G__49993 = c__4679__auto___49991;
var G__49994 = cljs.core.count(c__4679__auto___49991);
var G__49995 = (0);
seq__48676_49947 = G__49992;
chunk__48677_49948 = G__49993;
count__48678_49949 = G__49994;
i__48679_49950 = G__49995;
continue;
} else {
var child_struct_49996 = cljs.core.first(seq__48676_49990__$1);
var children_49997 = shadow.dom.dom_node(child_struct_49996);
if(cljs.core.seq_QMARK_(children_49997)){
var seq__48882_50003 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_49997));
var chunk__48884_50004 = null;
var count__48885_50005 = (0);
var i__48886_50006 = (0);
while(true){
if((i__48886_50006 < count__48885_50005)){
var child_50007 = chunk__48884_50004.cljs$core$IIndexed$_nth$arity$2(null,i__48886_50006);
if(cljs.core.truth_(child_50007)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50007);


var G__50008 = seq__48882_50003;
var G__50009 = chunk__48884_50004;
var G__50010 = count__48885_50005;
var G__50011 = (i__48886_50006 + (1));
seq__48882_50003 = G__50008;
chunk__48884_50004 = G__50009;
count__48885_50005 = G__50010;
i__48886_50006 = G__50011;
continue;
} else {
var G__50012 = seq__48882_50003;
var G__50013 = chunk__48884_50004;
var G__50014 = count__48885_50005;
var G__50015 = (i__48886_50006 + (1));
seq__48882_50003 = G__50012;
chunk__48884_50004 = G__50013;
count__48885_50005 = G__50014;
i__48886_50006 = G__50015;
continue;
}
} else {
var temp__5753__auto___50017__$1 = cljs.core.seq(seq__48882_50003);
if(temp__5753__auto___50017__$1){
var seq__48882_50018__$1 = temp__5753__auto___50017__$1;
if(cljs.core.chunked_seq_QMARK_(seq__48882_50018__$1)){
var c__4679__auto___50019 = cljs.core.chunk_first(seq__48882_50018__$1);
var G__50020 = cljs.core.chunk_rest(seq__48882_50018__$1);
var G__50021 = c__4679__auto___50019;
var G__50022 = cljs.core.count(c__4679__auto___50019);
var G__50023 = (0);
seq__48882_50003 = G__50020;
chunk__48884_50004 = G__50021;
count__48885_50005 = G__50022;
i__48886_50006 = G__50023;
continue;
} else {
var child_50024 = cljs.core.first(seq__48882_50018__$1);
if(cljs.core.truth_(child_50024)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50024);


var G__50026 = cljs.core.next(seq__48882_50018__$1);
var G__50027 = null;
var G__50028 = (0);
var G__50029 = (0);
seq__48882_50003 = G__50026;
chunk__48884_50004 = G__50027;
count__48885_50005 = G__50028;
i__48886_50006 = G__50029;
continue;
} else {
var G__50030 = cljs.core.next(seq__48882_50018__$1);
var G__50031 = null;
var G__50032 = (0);
var G__50033 = (0);
seq__48882_50003 = G__50030;
chunk__48884_50004 = G__50031;
count__48885_50005 = G__50032;
i__48886_50006 = G__50033;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_49997);
}


var G__50034 = cljs.core.next(seq__48676_49990__$1);
var G__50036 = null;
var G__50037 = (0);
var G__50038 = (0);
seq__48676_49947 = G__50034;
chunk__48677_49948 = G__50036;
count__48678_49949 = G__50037;
i__48679_49950 = G__50038;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__48974 = cljs.core.seq(node);
var chunk__48975 = null;
var count__48976 = (0);
var i__48977 = (0);
while(true){
if((i__48977 < count__48976)){
var n = chunk__48975.cljs$core$IIndexed$_nth$arity$2(null,i__48977);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__50052 = seq__48974;
var G__50053 = chunk__48975;
var G__50054 = count__48976;
var G__50055 = (i__48977 + (1));
seq__48974 = G__50052;
chunk__48975 = G__50053;
count__48976 = G__50054;
i__48977 = G__50055;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__48974);
if(temp__5753__auto__){
var seq__48974__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__48974__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__48974__$1);
var G__50058 = cljs.core.chunk_rest(seq__48974__$1);
var G__50059 = c__4679__auto__;
var G__50060 = cljs.core.count(c__4679__auto__);
var G__50061 = (0);
seq__48974 = G__50058;
chunk__48975 = G__50059;
count__48976 = G__50060;
i__48977 = G__50061;
continue;
} else {
var n = cljs.core.first(seq__48974__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__50066 = cljs.core.next(seq__48974__$1);
var G__50067 = null;
var G__50068 = (0);
var G__50069 = (0);
seq__48974 = G__50066;
chunk__48975 = G__50067;
count__48976 = G__50068;
i__48977 = G__50069;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__49025 = arguments.length;
switch (G__49025) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__49033 = arguments.length;
switch (G__49033) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__49048 = arguments.length;
switch (G__49048) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4253__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4870__auto__ = [];
var len__4864__auto___50093 = arguments.length;
var i__4865__auto___50094 = (0);
while(true){
if((i__4865__auto___50094 < len__4864__auto___50093)){
args__4870__auto__.push((arguments[i__4865__auto___50094]));

var G__50096 = (i__4865__auto___50094 + (1));
i__4865__auto___50094 = G__50096;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__49088_50098 = cljs.core.seq(nodes);
var chunk__49089_50099 = null;
var count__49090_50100 = (0);
var i__49091_50101 = (0);
while(true){
if((i__49091_50101 < count__49090_50100)){
var node_50102 = chunk__49089_50099.cljs$core$IIndexed$_nth$arity$2(null,i__49091_50101);
fragment.appendChild(shadow.dom._to_dom(node_50102));


var G__50104 = seq__49088_50098;
var G__50105 = chunk__49089_50099;
var G__50106 = count__49090_50100;
var G__50107 = (i__49091_50101 + (1));
seq__49088_50098 = G__50104;
chunk__49089_50099 = G__50105;
count__49090_50100 = G__50106;
i__49091_50101 = G__50107;
continue;
} else {
var temp__5753__auto___50108 = cljs.core.seq(seq__49088_50098);
if(temp__5753__auto___50108){
var seq__49088_50109__$1 = temp__5753__auto___50108;
if(cljs.core.chunked_seq_QMARK_(seq__49088_50109__$1)){
var c__4679__auto___50110 = cljs.core.chunk_first(seq__49088_50109__$1);
var G__50111 = cljs.core.chunk_rest(seq__49088_50109__$1);
var G__50112 = c__4679__auto___50110;
var G__50113 = cljs.core.count(c__4679__auto___50110);
var G__50114 = (0);
seq__49088_50098 = G__50111;
chunk__49089_50099 = G__50112;
count__49090_50100 = G__50113;
i__49091_50101 = G__50114;
continue;
} else {
var node_50115 = cljs.core.first(seq__49088_50109__$1);
fragment.appendChild(shadow.dom._to_dom(node_50115));


var G__50117 = cljs.core.next(seq__49088_50109__$1);
var G__50118 = null;
var G__50119 = (0);
var G__50120 = (0);
seq__49088_50098 = G__50117;
chunk__49089_50099 = G__50118;
count__49090_50100 = G__50119;
i__49091_50101 = G__50120;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq49077){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49077));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__49128_50122 = cljs.core.seq(scripts);
var chunk__49129_50124 = null;
var count__49130_50127 = (0);
var i__49131_50130 = (0);
while(true){
if((i__49131_50130 < count__49130_50127)){
var vec__49150_50131 = chunk__49129_50124.cljs$core$IIndexed$_nth$arity$2(null,i__49131_50130);
var script_tag_50132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49150_50131,(0),null);
var script_body_50133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49150_50131,(1),null);
eval(script_body_50133);


var G__50135 = seq__49128_50122;
var G__50136 = chunk__49129_50124;
var G__50137 = count__49130_50127;
var G__50138 = (i__49131_50130 + (1));
seq__49128_50122 = G__50135;
chunk__49129_50124 = G__50136;
count__49130_50127 = G__50137;
i__49131_50130 = G__50138;
continue;
} else {
var temp__5753__auto___50139 = cljs.core.seq(seq__49128_50122);
if(temp__5753__auto___50139){
var seq__49128_50141__$1 = temp__5753__auto___50139;
if(cljs.core.chunked_seq_QMARK_(seq__49128_50141__$1)){
var c__4679__auto___50146 = cljs.core.chunk_first(seq__49128_50141__$1);
var G__50147 = cljs.core.chunk_rest(seq__49128_50141__$1);
var G__50148 = c__4679__auto___50146;
var G__50149 = cljs.core.count(c__4679__auto___50146);
var G__50150 = (0);
seq__49128_50122 = G__50147;
chunk__49129_50124 = G__50148;
count__49130_50127 = G__50149;
i__49131_50130 = G__50150;
continue;
} else {
var vec__49158_50152 = cljs.core.first(seq__49128_50141__$1);
var script_tag_50153 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49158_50152,(0),null);
var script_body_50154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49158_50152,(1),null);
eval(script_body_50154);


var G__50155 = cljs.core.next(seq__49128_50141__$1);
var G__50156 = null;
var G__50157 = (0);
var G__50158 = (0);
seq__49128_50122 = G__50155;
chunk__49129_50124 = G__50156;
count__49130_50127 = G__50157;
i__49131_50130 = G__50158;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__49166){
var vec__49169 = p__49166;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49169,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49169,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__49185 = arguments.length;
switch (G__49185) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__49218 = cljs.core.seq(style_keys);
var chunk__49219 = null;
var count__49220 = (0);
var i__49221 = (0);
while(true){
if((i__49221 < count__49220)){
var it = chunk__49219.cljs$core$IIndexed$_nth$arity$2(null,i__49221);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50167 = seq__49218;
var G__50168 = chunk__49219;
var G__50169 = count__49220;
var G__50170 = (i__49221 + (1));
seq__49218 = G__50167;
chunk__49219 = G__50168;
count__49220 = G__50169;
i__49221 = G__50170;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__49218);
if(temp__5753__auto__){
var seq__49218__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49218__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__49218__$1);
var G__50172 = cljs.core.chunk_rest(seq__49218__$1);
var G__50173 = c__4679__auto__;
var G__50174 = cljs.core.count(c__4679__auto__);
var G__50175 = (0);
seq__49218 = G__50172;
chunk__49219 = G__50173;
count__49220 = G__50174;
i__49221 = G__50175;
continue;
} else {
var it = cljs.core.first(seq__49218__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50181 = cljs.core.next(seq__49218__$1);
var G__50182 = null;
var G__50183 = (0);
var G__50184 = (0);
seq__49218 = G__50181;
chunk__49219 = G__50182;
count__49220 = G__50183;
i__49221 = G__50184;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k49239,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__49260 = k49239;
var G__49260__$1 = (((G__49260 instanceof cljs.core.Keyword))?G__49260.fqn:null);
switch (G__49260__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49239,else__4505__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__49271){
var vec__49273 = p__49271;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49273,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49273,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49238){
var self__ = this;
var G__49238__$1 = this;
return (new cljs.core.RecordIter((0),G__49238__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49240,other49241){
var self__ = this;
var this49240__$1 = this;
return (((!((other49241 == null)))) && ((((this49240__$1.constructor === other49241.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49240__$1.x,other49241.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49240__$1.y,other49241.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49240__$1.__extmap,other49241.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k49239){
var self__ = this;
var this__4509__auto____$1 = this;
var G__49308 = k49239;
var G__49308__$1 = (((G__49308 instanceof cljs.core.Keyword))?G__49308.fqn:null);
switch (G__49308__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k49239);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__49238){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__49310 = cljs.core.keyword_identical_QMARK_;
var expr__49311 = k__4511__auto__;
if(cljs.core.truth_((pred__49310.cljs$core$IFn$_invoke$arity$2 ? pred__49310.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__49311) : pred__49310.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__49311)))){
return (new shadow.dom.Coordinate(G__49238,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49310.cljs$core$IFn$_invoke$arity$2 ? pred__49310.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__49311) : pred__49310.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__49311)))){
return (new shadow.dom.Coordinate(self__.x,G__49238,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__49238),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__49238){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__49238,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__49245){
var extmap__4542__auto__ = (function (){var G__49324 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49245,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__49245)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49324);
} else {
return G__49324;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__49245),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__49245),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k49337,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__49349 = k49337;
var G__49349__$1 = (((G__49349 instanceof cljs.core.Keyword))?G__49349.fqn:null);
switch (G__49349__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49337,else__4505__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__49358){
var vec__49363 = p__49358;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49363,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49363,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#shadow.dom.Size{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49336){
var self__ = this;
var G__49336__$1 = this;
return (new cljs.core.RecordIter((0),G__49336__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
})(this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49338,other49339){
var self__ = this;
var this49338__$1 = this;
return (((!((other49339 == null)))) && ((((this49338__$1.constructor === other49339.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49338__$1.w,other49339.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49338__$1.h,other49339.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49338__$1.__extmap,other49339.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k49337){
var self__ = this;
var this__4509__auto____$1 = this;
var G__49405 = k49337;
var G__49405__$1 = (((G__49405 instanceof cljs.core.Keyword))?G__49405.fqn:null);
switch (G__49405__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k49337);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__49336){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__49415 = cljs.core.keyword_identical_QMARK_;
var expr__49416 = k__4511__auto__;
if(cljs.core.truth_((pred__49415.cljs$core$IFn$_invoke$arity$2 ? pred__49415.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__49416) : pred__49415.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__49416)))){
return (new shadow.dom.Size(G__49336,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49415.cljs$core$IFn$_invoke$arity$2 ? pred__49415.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__49416) : pred__49415.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__49416)))){
return (new shadow.dom.Size(self__.w,G__49336,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__49336),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__49336){
var self__ = this;
var this__4501__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__49336,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4508__auto__,(0)),cljs.core._nth(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__49342){
var extmap__4542__auto__ = (function (){var G__49442 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49342,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__49342)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49442);
} else {
return G__49442;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__49342),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__49342),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4738__auto__ = opts;
var l__4739__auto__ = a__4738__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4739__auto__)){
var G__50231 = (i + (1));
var G__50232 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__50231;
ret = G__50232;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__49486){
var vec__49488 = p__49486;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49488,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49488,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__49499 = arguments.length;
switch (G__49499) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5751__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5751__auto__)){
var child = temp__5751__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__50238 = ps;
var G__50239 = (i + (1));
el__$1 = G__50238;
i = G__50239;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__49544 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49544,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49544,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49544,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__49550_50243 = cljs.core.seq(props);
var chunk__49551_50244 = null;
var count__49552_50245 = (0);
var i__49553_50246 = (0);
while(true){
if((i__49553_50246 < count__49552_50245)){
var vec__49581_50248 = chunk__49551_50244.cljs$core$IIndexed$_nth$arity$2(null,i__49553_50246);
var k_50249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49581_50248,(0),null);
var v_50250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49581_50248,(1),null);
el.setAttributeNS((function (){var temp__5753__auto__ = cljs.core.namespace(k_50249);
if(cljs.core.truth_(temp__5753__auto__)){
var ns = temp__5753__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50249),v_50250);


var G__50252 = seq__49550_50243;
var G__50253 = chunk__49551_50244;
var G__50254 = count__49552_50245;
var G__50255 = (i__49553_50246 + (1));
seq__49550_50243 = G__50252;
chunk__49551_50244 = G__50253;
count__49552_50245 = G__50254;
i__49553_50246 = G__50255;
continue;
} else {
var temp__5753__auto___50256 = cljs.core.seq(seq__49550_50243);
if(temp__5753__auto___50256){
var seq__49550_50257__$1 = temp__5753__auto___50256;
if(cljs.core.chunked_seq_QMARK_(seq__49550_50257__$1)){
var c__4679__auto___50259 = cljs.core.chunk_first(seq__49550_50257__$1);
var G__50260 = cljs.core.chunk_rest(seq__49550_50257__$1);
var G__50261 = c__4679__auto___50259;
var G__50262 = cljs.core.count(c__4679__auto___50259);
var G__50263 = (0);
seq__49550_50243 = G__50260;
chunk__49551_50244 = G__50261;
count__49552_50245 = G__50262;
i__49553_50246 = G__50263;
continue;
} else {
var vec__49603_50265 = cljs.core.first(seq__49550_50257__$1);
var k_50266 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49603_50265,(0),null);
var v_50267 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49603_50265,(1),null);
el.setAttributeNS((function (){var temp__5753__auto____$1 = cljs.core.namespace(k_50266);
if(cljs.core.truth_(temp__5753__auto____$1)){
var ns = temp__5753__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_50266),v_50267);


var G__50268 = cljs.core.next(seq__49550_50257__$1);
var G__50269 = null;
var G__50270 = (0);
var G__50271 = (0);
seq__49550_50243 = G__50268;
chunk__49551_50244 = G__50269;
count__49552_50245 = G__50270;
i__49553_50246 = G__50271;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__49618 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49618,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49618,(1),null);
var seq__49624_50277 = cljs.core.seq(node_children);
var chunk__49626_50278 = null;
var count__49627_50279 = (0);
var i__49628_50280 = (0);
while(true){
if((i__49628_50280 < count__49627_50279)){
var child_struct_50281 = chunk__49626_50278.cljs$core$IIndexed$_nth$arity$2(null,i__49628_50280);
if((!((child_struct_50281 == null)))){
if(typeof child_struct_50281 === 'string'){
var text_50282 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50282),child_struct_50281].join(''));
} else {
var children_50284 = shadow.dom.svg_node(child_struct_50281);
if(cljs.core.seq_QMARK_(children_50284)){
var seq__49695_50285 = cljs.core.seq(children_50284);
var chunk__49697_50286 = null;
var count__49698_50287 = (0);
var i__49699_50288 = (0);
while(true){
if((i__49699_50288 < count__49698_50287)){
var child_50289 = chunk__49697_50286.cljs$core$IIndexed$_nth$arity$2(null,i__49699_50288);
if(cljs.core.truth_(child_50289)){
node.appendChild(child_50289);


var G__50291 = seq__49695_50285;
var G__50292 = chunk__49697_50286;
var G__50293 = count__49698_50287;
var G__50294 = (i__49699_50288 + (1));
seq__49695_50285 = G__50291;
chunk__49697_50286 = G__50292;
count__49698_50287 = G__50293;
i__49699_50288 = G__50294;
continue;
} else {
var G__50295 = seq__49695_50285;
var G__50296 = chunk__49697_50286;
var G__50297 = count__49698_50287;
var G__50298 = (i__49699_50288 + (1));
seq__49695_50285 = G__50295;
chunk__49697_50286 = G__50296;
count__49698_50287 = G__50297;
i__49699_50288 = G__50298;
continue;
}
} else {
var temp__5753__auto___50302 = cljs.core.seq(seq__49695_50285);
if(temp__5753__auto___50302){
var seq__49695_50303__$1 = temp__5753__auto___50302;
if(cljs.core.chunked_seq_QMARK_(seq__49695_50303__$1)){
var c__4679__auto___50304 = cljs.core.chunk_first(seq__49695_50303__$1);
var G__50305 = cljs.core.chunk_rest(seq__49695_50303__$1);
var G__50306 = c__4679__auto___50304;
var G__50307 = cljs.core.count(c__4679__auto___50304);
var G__50308 = (0);
seq__49695_50285 = G__50305;
chunk__49697_50286 = G__50306;
count__49698_50287 = G__50307;
i__49699_50288 = G__50308;
continue;
} else {
var child_50310 = cljs.core.first(seq__49695_50303__$1);
if(cljs.core.truth_(child_50310)){
node.appendChild(child_50310);


var G__50311 = cljs.core.next(seq__49695_50303__$1);
var G__50312 = null;
var G__50313 = (0);
var G__50314 = (0);
seq__49695_50285 = G__50311;
chunk__49697_50286 = G__50312;
count__49698_50287 = G__50313;
i__49699_50288 = G__50314;
continue;
} else {
var G__50315 = cljs.core.next(seq__49695_50303__$1);
var G__50316 = null;
var G__50317 = (0);
var G__50318 = (0);
seq__49695_50285 = G__50315;
chunk__49697_50286 = G__50316;
count__49698_50287 = G__50317;
i__49699_50288 = G__50318;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50284);
}
}


var G__50319 = seq__49624_50277;
var G__50320 = chunk__49626_50278;
var G__50321 = count__49627_50279;
var G__50322 = (i__49628_50280 + (1));
seq__49624_50277 = G__50319;
chunk__49626_50278 = G__50320;
count__49627_50279 = G__50321;
i__49628_50280 = G__50322;
continue;
} else {
var G__50324 = seq__49624_50277;
var G__50325 = chunk__49626_50278;
var G__50326 = count__49627_50279;
var G__50327 = (i__49628_50280 + (1));
seq__49624_50277 = G__50324;
chunk__49626_50278 = G__50325;
count__49627_50279 = G__50326;
i__49628_50280 = G__50327;
continue;
}
} else {
var temp__5753__auto___50328 = cljs.core.seq(seq__49624_50277);
if(temp__5753__auto___50328){
var seq__49624_50329__$1 = temp__5753__auto___50328;
if(cljs.core.chunked_seq_QMARK_(seq__49624_50329__$1)){
var c__4679__auto___50330 = cljs.core.chunk_first(seq__49624_50329__$1);
var G__50331 = cljs.core.chunk_rest(seq__49624_50329__$1);
var G__50332 = c__4679__auto___50330;
var G__50333 = cljs.core.count(c__4679__auto___50330);
var G__50334 = (0);
seq__49624_50277 = G__50331;
chunk__49626_50278 = G__50332;
count__49627_50279 = G__50333;
i__49628_50280 = G__50334;
continue;
} else {
var child_struct_50336 = cljs.core.first(seq__49624_50329__$1);
if((!((child_struct_50336 == null)))){
if(typeof child_struct_50336 === 'string'){
var text_50337 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_50337),child_struct_50336].join(''));
} else {
var children_50338 = shadow.dom.svg_node(child_struct_50336);
if(cljs.core.seq_QMARK_(children_50338)){
var seq__49713_50339 = cljs.core.seq(children_50338);
var chunk__49717_50340 = null;
var count__49718_50341 = (0);
var i__49719_50342 = (0);
while(true){
if((i__49719_50342 < count__49718_50341)){
var child_50344 = chunk__49717_50340.cljs$core$IIndexed$_nth$arity$2(null,i__49719_50342);
if(cljs.core.truth_(child_50344)){
node.appendChild(child_50344);


var G__50345 = seq__49713_50339;
var G__50346 = chunk__49717_50340;
var G__50347 = count__49718_50341;
var G__50348 = (i__49719_50342 + (1));
seq__49713_50339 = G__50345;
chunk__49717_50340 = G__50346;
count__49718_50341 = G__50347;
i__49719_50342 = G__50348;
continue;
} else {
var G__50349 = seq__49713_50339;
var G__50350 = chunk__49717_50340;
var G__50351 = count__49718_50341;
var G__50352 = (i__49719_50342 + (1));
seq__49713_50339 = G__50349;
chunk__49717_50340 = G__50350;
count__49718_50341 = G__50351;
i__49719_50342 = G__50352;
continue;
}
} else {
var temp__5753__auto___50353__$1 = cljs.core.seq(seq__49713_50339);
if(temp__5753__auto___50353__$1){
var seq__49713_50355__$1 = temp__5753__auto___50353__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49713_50355__$1)){
var c__4679__auto___50356 = cljs.core.chunk_first(seq__49713_50355__$1);
var G__50357 = cljs.core.chunk_rest(seq__49713_50355__$1);
var G__50358 = c__4679__auto___50356;
var G__50359 = cljs.core.count(c__4679__auto___50356);
var G__50360 = (0);
seq__49713_50339 = G__50357;
chunk__49717_50340 = G__50358;
count__49718_50341 = G__50359;
i__49719_50342 = G__50360;
continue;
} else {
var child_50361 = cljs.core.first(seq__49713_50355__$1);
if(cljs.core.truth_(child_50361)){
node.appendChild(child_50361);


var G__50362 = cljs.core.next(seq__49713_50355__$1);
var G__50363 = null;
var G__50364 = (0);
var G__50365 = (0);
seq__49713_50339 = G__50362;
chunk__49717_50340 = G__50363;
count__49718_50341 = G__50364;
i__49719_50342 = G__50365;
continue;
} else {
var G__50367 = cljs.core.next(seq__49713_50355__$1);
var G__50368 = null;
var G__50369 = (0);
var G__50370 = (0);
seq__49713_50339 = G__50367;
chunk__49717_50340 = G__50368;
count__49718_50341 = G__50369;
i__49719_50342 = G__50370;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_50338);
}
}


var G__50371 = cljs.core.next(seq__49624_50329__$1);
var G__50372 = null;
var G__50373 = (0);
var G__50374 = (0);
seq__49624_50277 = G__50371;
chunk__49626_50278 = G__50372;
count__49627_50279 = G__50373;
i__49628_50280 = G__50374;
continue;
} else {
var G__50375 = cljs.core.next(seq__49624_50329__$1);
var G__50376 = null;
var G__50377 = (0);
var G__50378 = (0);
seq__49624_50277 = G__50375;
chunk__49626_50278 = G__50376;
count__49627_50279 = G__50377;
i__49628_50280 = G__50378;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4870__auto__ = [];
var len__4864__auto___50382 = arguments.length;
var i__4865__auto___50383 = (0);
while(true){
if((i__4865__auto___50383 < len__4864__auto___50382)){
args__4870__auto__.push((arguments[i__4865__auto___50383]));

var G__50384 = (i__4865__auto___50383 + (1));
i__4865__auto___50383 = G__50384;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq49759){
var G__49760 = cljs.core.first(seq49759);
var seq49759__$1 = cljs.core.next(seq49759);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49760,seq49759__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__49772 = arguments.length;
switch (G__49772) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4251__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4251__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4251__auto__;
}
})())){
var c__44466__auto___50399 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__44467__auto__ = (function (){var switch__44381__auto__ = (function (state_49784){
var state_val_49785 = (state_49784[(1)]);
if((state_val_49785 === (1))){
var state_49784__$1 = state_49784;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49784__$1,(2),once_or_cleanup);
} else {
if((state_val_49785 === (2))){
var inst_49781 = (state_49784[(2)]);
var inst_49782 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_49784__$1 = (function (){var statearr_49789 = state_49784;
(statearr_49789[(7)] = inst_49781);

return statearr_49789;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_49784__$1,inst_49782);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__44382__auto__ = null;
var shadow$dom$state_machine__44382__auto____0 = (function (){
var statearr_49791 = [null,null,null,null,null,null,null,null];
(statearr_49791[(0)] = shadow$dom$state_machine__44382__auto__);

(statearr_49791[(1)] = (1));

return statearr_49791;
});
var shadow$dom$state_machine__44382__auto____1 = (function (state_49784){
while(true){
var ret_value__44383__auto__ = (function (){try{while(true){
var result__44384__auto__ = switch__44381__auto__(state_49784);
if(cljs.core.keyword_identical_QMARK_(result__44384__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__44384__auto__;
}
break;
}
}catch (e49792){var ex__44385__auto__ = e49792;
var statearr_49793_50402 = state_49784;
(statearr_49793_50402[(2)] = ex__44385__auto__);


if(cljs.core.seq((state_49784[(4)]))){
var statearr_49795_50403 = state_49784;
(statearr_49795_50403[(1)] = cljs.core.first((state_49784[(4)])));

} else {
throw ex__44385__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__44383__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__50404 = state_49784;
state_49784 = G__50404;
continue;
} else {
return ret_value__44383__auto__;
}
break;
}
});
shadow$dom$state_machine__44382__auto__ = function(state_49784){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__44382__auto____0.call(this);
case 1:
return shadow$dom$state_machine__44382__auto____1.call(this,state_49784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__44382__auto____0;
shadow$dom$state_machine__44382__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__44382__auto____1;
return shadow$dom$state_machine__44382__auto__;
})()
})();
var state__44468__auto__ = (function (){var statearr_49798 = f__44467__auto__();
(statearr_49798[(6)] = c__44466__auto___50399);

return statearr_49798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44468__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
