goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__55379){
var map__55380 = p__55379;
var map__55380__$1 = (((((!((map__55380 == null))))?(((((map__55380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55380.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55380):map__55380);
var m = map__55380__$1;
var n = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55380__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55380__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-------------------------"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return [(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})()], 0));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Protocol"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__55384_55593 = cljs.core.seq(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__55385_55594 = null;
var count__55386_55595 = (0);
var i__55387_55596 = (0);
while(true){
if((i__55387_55596 < count__55386_55595)){
var f_55597 = chunk__55385_55594.cljs$core$IIndexed$_nth$arity$2(null,i__55387_55596);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ",f_55597], 0));


var G__55598 = seq__55384_55593;
var G__55599 = chunk__55385_55594;
var G__55600 = count__55386_55595;
var G__55601 = (i__55387_55596 + (1));
seq__55384_55593 = G__55598;
chunk__55385_55594 = G__55599;
count__55386_55595 = G__55600;
i__55387_55596 = G__55601;
continue;
} else {
var temp__5735__auto___55602 = cljs.core.seq(seq__55384_55593);
if(temp__5735__auto___55602){
var seq__55384_55603__$1 = temp__5735__auto___55602;
if(cljs.core.chunked_seq_QMARK_(seq__55384_55603__$1)){
var c__4556__auto___55604 = cljs.core.chunk_first(seq__55384_55603__$1);
var G__55605 = cljs.core.chunk_rest(seq__55384_55603__$1);
var G__55606 = c__4556__auto___55604;
var G__55607 = cljs.core.count(c__4556__auto___55604);
var G__55608 = (0);
seq__55384_55593 = G__55605;
chunk__55385_55594 = G__55606;
count__55386_55595 = G__55607;
i__55387_55596 = G__55608;
continue;
} else {
var f_55610 = cljs.core.first(seq__55384_55603__$1);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["  ",f_55610], 0));


var G__55611 = cljs.core.next(seq__55384_55603__$1);
var G__55612 = null;
var G__55613 = (0);
var G__55614 = (0);
seq__55384_55593 = G__55611;
chunk__55385_55594 = G__55612;
count__55386_55595 = G__55613;
i__55387_55596 = G__55614;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_55615 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arglists_55615], 0));
} else {
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first(arglists_55615)))?cljs.core.second(arglists_55615):arglists_55615)], 0));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Special Form"], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m)], 0));

if(cljs.core.contains_QMARK_(m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
} else {
return null;
}
} else {
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('')], 0));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Macro"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Spec"], 0));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["REPL Special Function"], 0));
} else {
}

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m)], 0));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__55391_55617 = cljs.core.seq(new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__55392_55618 = null;
var count__55393_55619 = (0);
var i__55394_55620 = (0);
while(true){
if((i__55394_55620 < count__55393_55619)){
var vec__55407_55621 = chunk__55392_55618.cljs$core$IIndexed$_nth$arity$2(null,i__55394_55620);
var name_55622 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55407_55621,(0),null);
var map__55410_55623 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55407_55621,(1),null);
var map__55410_55624__$1 = (((((!((map__55410_55623 == null))))?(((((map__55410_55623.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55410_55623.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55410_55623):map__55410_55623);
var doc_55625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55410_55624__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_55626 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55410_55624__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",name_55622], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",arglists_55626], 0));

if(cljs.core.truth_(doc_55625)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",doc_55625], 0));
} else {
}


var G__55627 = seq__55391_55617;
var G__55628 = chunk__55392_55618;
var G__55629 = count__55393_55619;
var G__55630 = (i__55394_55620 + (1));
seq__55391_55617 = G__55627;
chunk__55392_55618 = G__55628;
count__55393_55619 = G__55629;
i__55394_55620 = G__55630;
continue;
} else {
var temp__5735__auto___55631 = cljs.core.seq(seq__55391_55617);
if(temp__5735__auto___55631){
var seq__55391_55632__$1 = temp__5735__auto___55631;
if(cljs.core.chunked_seq_QMARK_(seq__55391_55632__$1)){
var c__4556__auto___55633 = cljs.core.chunk_first(seq__55391_55632__$1);
var G__55634 = cljs.core.chunk_rest(seq__55391_55632__$1);
var G__55635 = c__4556__auto___55633;
var G__55636 = cljs.core.count(c__4556__auto___55633);
var G__55637 = (0);
seq__55391_55617 = G__55634;
chunk__55392_55618 = G__55635;
count__55393_55619 = G__55636;
i__55394_55620 = G__55637;
continue;
} else {
var vec__55412_55639 = cljs.core.first(seq__55391_55632__$1);
var name_55640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55412_55639,(0),null);
var map__55415_55641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55412_55639,(1),null);
var map__55415_55642__$1 = (((((!((map__55415_55641 == null))))?(((((map__55415_55641.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55415_55641.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55415_55641):map__55415_55641);
var doc_55643 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55415_55642__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_55644 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55415_55642__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println();

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",name_55640], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",arglists_55644], 0));

if(cljs.core.truth_(doc_55643)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" ",doc_55643], 0));
} else {
}


var G__55645 = cljs.core.next(seq__55391_55632__$1);
var G__55646 = null;
var G__55647 = (0);
var G__55648 = (0);
seq__55391_55617 = G__55645;
chunk__55392_55618 = G__55646;
count__55393_55619 = G__55647;
i__55394_55620 = G__55648;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5735__auto__ = cljs.spec.alpha.get_spec(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name(n)),cljs.core.name(nm)));
if(cljs.core.truth_(temp__5735__auto__)){
var fnspec = temp__5735__auto__;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Spec"], 0));

var seq__55419 = cljs.core.seq(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__55420 = null;
var count__55421 = (0);
var i__55422 = (0);
while(true){
if((i__55422 < count__55421)){
var role = chunk__55420.cljs$core$IIndexed$_nth$arity$2(null,i__55422);
var temp__5735__auto___55649__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fnspec,role);
if(cljs.core.truth_(temp__5735__auto___55649__$1)){
var spec_55650 = temp__5735__auto___55649__$1;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n ",cljs.core.name(role),":"].join(''),cljs.spec.alpha.describe(spec_55650)], 0));
} else {
}


var G__55651 = seq__55419;
var G__55652 = chunk__55420;
var G__55653 = count__55421;
var G__55654 = (i__55422 + (1));
seq__55419 = G__55651;
chunk__55420 = G__55652;
count__55421 = G__55653;
i__55422 = G__55654;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq(seq__55419);
if(temp__5735__auto____$1){
var seq__55419__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__55419__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__55419__$1);
var G__55655 = cljs.core.chunk_rest(seq__55419__$1);
var G__55656 = c__4556__auto__;
var G__55657 = cljs.core.count(c__4556__auto__);
var G__55658 = (0);
seq__55419 = G__55655;
chunk__55420 = G__55656;
count__55421 = G__55657;
i__55422 = G__55658;
continue;
} else {
var role = cljs.core.first(seq__55419__$1);
var temp__5735__auto___55659__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fnspec,role);
if(cljs.core.truth_(temp__5735__auto___55659__$2)){
var spec_55660 = temp__5735__auto___55659__$2;
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["\n ",cljs.core.name(role),":"].join(''),cljs.spec.alpha.describe(spec_55660)], 0));
} else {
}


var G__55661 = cljs.core.next(seq__55419__$1);
var G__55662 = null;
var G__55663 = (0);
var G__55664 = (0);
seq__55419 = G__55661;
chunk__55420 = G__55662;
count__55421 = G__55663;
i__55422 = G__55664;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol(null,"ExceptionInfo","ExceptionInfo",294935087,null):(((t instanceof Error))?cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("js",t.name):null
))], null),(function (){var temp__5735__auto__ = cljs.core.ex_message(t);
if(cljs.core.truth_(temp__5735__auto__)){
var msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data(t);
if(cljs.core.truth_(temp__5735__auto__)){
var ed = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})()], 0));
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__55665 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(via,t);
var G__55666 = cljs.core.ex_cause(t);
via = G__55665;
t = G__55666;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek(via);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5735__auto__ = cljs.core.ex_message(root);
if(cljs.core.truth_(temp__5735__auto__)){
var root_msg = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = cljs.core.ex_data(root);
if(cljs.core.truth_(temp__5735__auto__)){
var data = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5735__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data(o));
if(cljs.core.truth_(temp__5735__auto__)){
var phase = temp__5735__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})()], 0));
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__55428 = datafied_throwable;
var map__55428__$1 = (((((!((map__55428 == null))))?(((((map__55428.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55428.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55428):map__55428);
var via = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55428__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55428__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__55428__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__55429 = cljs.core.last(via);
var map__55429__$1 = (((((!((map__55429 == null))))?(((((map__55429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55429.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55429):map__55429);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55429__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55429__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55429__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__55430 = data;
var map__55430__$1 = (((((!((map__55430 == null))))?(((((map__55430.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55430.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55430):map__55430);
var problems = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55430__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55430__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55430__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__55431 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first(via));
var map__55431__$1 = (((((!((map__55431 == null))))?(((((map__55431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55431.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55431):map__55431);
var top_data = map__55431__$1;
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55431__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((function (){var G__55453 = phase;
var G__55453__$1 = (((G__55453 instanceof cljs.core.Keyword))?G__55453.fqn:null);
switch (G__55453__$1) {
case "read-source":
var map__55454 = data;
var map__55454__$1 = (((((!((map__55454 == null))))?(((((map__55454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55454):map__55454);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55454__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55454__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__55456 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second(via)),top_data], 0));
var G__55456__$1 = (cljs.core.truth_(source)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55456,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__55456);
var G__55456__$2 = (cljs.core.truth_((function (){var fexpr__55457 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__55457.cljs$core$IFn$_invoke$arity$1 ? fexpr__55457.cljs$core$IFn$_invoke$arity$1(source) : fexpr__55457.call(null,source));
})())?cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__55456__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__55456__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55456__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__55456__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__55465 = top_data;
var G__55465__$1 = (cljs.core.truth_(source)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55465,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__55465);
var G__55465__$2 = (cljs.core.truth_((function (){var fexpr__55466 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__55466.cljs$core$IFn$_invoke$arity$1 ? fexpr__55466.cljs$core$IFn$_invoke$arity$1(source) : fexpr__55466.call(null,source));
})())?cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__55465__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__55465__$1);
var G__55465__$3 = (cljs.core.truth_(type)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55465__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__55465__$2);
var G__55465__$4 = (cljs.core.truth_(message)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55465__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__55465__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55465__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__55465__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__55467 = cljs.core.first(trace);
var source__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55467,(0),null);
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55467,(1),null);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55467,(2),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55467,(3),null);
var G__55474 = top_data;
var G__55474__$1 = (cljs.core.truth_(line)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55474,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__55474);
var G__55474__$2 = (cljs.core.truth_(file)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55474__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__55474__$1);
var G__55474__$3 = (cljs.core.truth_((function (){var and__4115__auto__ = source__$1;
if(cljs.core.truth_(and__4115__auto__)){
return method;
} else {
return and__4115__auto__;
}
})())?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55474__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__55474__$2);
var G__55474__$4 = (cljs.core.truth_(type)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55474__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__55474__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55474__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__55474__$4;
}

break;
case "execution":
var vec__55485 = cljs.core.first(trace);
var source__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55485,(0),null);
var method = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55485,(1),null);
var file = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55485,(2),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55485,(3),null);
var file__$1 = cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__55427_SHARP_){
var or__4126__auto__ = (p1__55427_SHARP_ == null);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var fexpr__55500 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null);
return (fexpr__55500.cljs$core$IFn$_invoke$arity$1 ? fexpr__55500.cljs$core$IFn$_invoke$arity$1(p1__55427_SHARP_) : fexpr__55500.call(null,p1__55427_SHARP_));
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return line;
}
})();
var G__55514 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__55514__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55514,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__55514);
var G__55514__$2 = (cljs.core.truth_(message)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55514__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__55514__$1);
var G__55514__$3 = (cljs.core.truth_((function (){var or__4126__auto__ = fn;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = source__$1;
if(cljs.core.truth_(and__4115__auto__)){
return method;
} else {
return and__4115__auto__;
}
}
})())?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55514__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__4126__auto__ = fn;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__55514__$2);
var G__55514__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55514__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__55514__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__55514__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__55514__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55453__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__55524){
var map__55529 = p__55524;
var map__55529__$1 = (((((!((map__55529 == null))))?(((((map__55529.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__55529.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__55529):map__55529);
var triage_data = map__55529__$1;
var phase = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55529__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55529__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55529__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55529__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55529__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55529__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55529__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55529__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name((function (){var or__4126__auto__ = class$;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__55549 = phase;
var G__55549__$1 = (((G__55549 instanceof cljs.core.Keyword))?G__55549.fqn:null);
switch (G__55549__$1) {
case "read-source":
return (format.cljs$core$IFn$_invoke$arity$3 ? format.cljs$core$IFn$_invoke$arity$3("Syntax error reading source at (%s).\n%s\n",loc,cause) : format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause));

break;
case "macro-syntax-check":
var G__55550 = "Syntax error macroexpanding %sat (%s).\n%s";
var G__55551 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__55552 = loc;
var G__55553 = (cljs.core.truth_(spec)?(function (){var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__55558_55678 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__55559_55679 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__55560_55680 = true;
var _STAR_print_fn_STAR__temp_val__55561_55681 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__55560_55680);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__55561_55681);

try{cljs.spec.alpha.explain_out(cljs.core.update.cljs$core$IFn$_invoke$arity$3(spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__55522_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__55522_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__55559_55679);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__55558_55678);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
})():(format.cljs$core$IFn$_invoke$arity$2 ? format.cljs$core$IFn$_invoke$arity$2("%s\n",cause) : format.call(null,"%s\n",cause)));
return (format.cljs$core$IFn$_invoke$arity$4 ? format.cljs$core$IFn$_invoke$arity$4(G__55550,G__55551,G__55552,G__55553) : format.call(null,G__55550,G__55551,G__55552,G__55553));

break;
case "macroexpansion":
var G__55562 = "Unexpected error%s macroexpanding %sat (%s).\n%s\n";
var G__55563 = cause_type;
var G__55564 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__55565 = loc;
var G__55566 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__55562,G__55563,G__55564,G__55565,G__55566) : format.call(null,G__55562,G__55563,G__55564,G__55565,G__55566));

break;
case "compile-syntax-check":
var G__55567 = "Syntax error%s compiling %sat (%s).\n%s\n";
var G__55568 = cause_type;
var G__55569 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__55570 = loc;
var G__55571 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__55567,G__55568,G__55569,G__55570,G__55571) : format.call(null,G__55567,G__55568,G__55569,G__55570,G__55571));

break;
case "compilation":
var G__55573 = "Unexpected error%s compiling %sat (%s).\n%s\n";
var G__55574 = cause_type;
var G__55575 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__55576 = loc;
var G__55577 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__55573,G__55574,G__55575,G__55576,G__55577) : format.call(null,G__55573,G__55574,G__55575,G__55576,G__55577));

break;
case "read-eval-result":
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5("Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause) : format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause));

break;
case "print-eval-result":
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5("Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause) : format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause));

break;
case "execution":
if(cljs.core.truth_(spec)){
var G__55578 = "Execution error - invalid arguments to %s at (%s).\n%s";
var G__55579 = symbol;
var G__55580 = loc;
var G__55581 = (function (){var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__55582_55682 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__55583_55683 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__55584_55684 = true;
var _STAR_print_fn_STAR__temp_val__55585_55685 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__55584_55684);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__55585_55685);

try{cljs.spec.alpha.explain_out(cljs.core.update.cljs$core$IFn$_invoke$arity$3(spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__55523_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__55523_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__55583_55683);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__55582_55682);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
})();
return (format.cljs$core$IFn$_invoke$arity$4 ? format.cljs$core$IFn$_invoke$arity$4(G__55578,G__55579,G__55580,G__55581) : format.call(null,G__55578,G__55579,G__55580,G__55581));
} else {
var G__55587 = "Execution error%s at %s(%s).\n%s\n";
var G__55588 = cause_type;
var G__55589 = (cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):"");
var G__55590 = loc;
var G__55591 = cause;
return (format.cljs$core$IFn$_invoke$arity$5 ? format.cljs$core$IFn$_invoke$arity$5(G__55587,G__55588,G__55589,G__55590,G__55591) : format.call(null,G__55587,G__55588,G__55589,G__55590,G__55591));
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55549__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str(cljs.repl.ex_triage(cljs.repl.Error__GT_map(error)));
});

//# sourceMappingURL=cljs.repl.js.map
