goog.provide('shadow.cljs.devtools.client.browser');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('goog.dom');
goog.require('goog.Uri');
goog.require('shadow.cljs.devtools.client.env');
goog.require('shadow.cljs.devtools.client.console');
goog.require('shadow.cljs.devtools.client.hud');
goog.require('shadow.cljs.devtools.client.websocket');
goog.require('shadow.cljs.devtools.client.shared');
goog.require('shadow.remote.runtime.api');
goog.require('shadow.remote.runtime.shared');
shadow.cljs.devtools.client.browser.devtools_msg = (function shadow$cljs$devtools$client$browser$devtools_msg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54442 = arguments.length;
var i__4737__auto___54443 = (0);
while(true){
if((i__4737__auto___54443 < len__4736__auto___54442)){
args__4742__auto__.push((arguments[i__4737__auto___54443]));

var G__54444 = (i__4737__auto___54443 + (1));
i__4737__auto___54443 = G__54444;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic = (function (msg,args){
if(cljs.core.seq(shadow.cljs.devtools.client.env.log_style)){
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["%c\uD83E\uDC36 shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''),shadow.cljs.devtools.client.env.log_style], null),args)));
} else {
return console.log.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["shadow-cljs: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join('')], null),args)));
}
}));

(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.cljs.devtools.client.browser.devtools_msg.cljs$lang$applyTo = (function (seq54237){
var G__54238 = cljs.core.first(seq54237);
var seq54237__$1 = cljs.core.next(seq54237);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54238,seq54237__$1);
}));

shadow.cljs.devtools.client.browser.script_eval = (function shadow$cljs$devtools$client$browser$script_eval(code){
return goog.globalEval(code);
});
shadow.cljs.devtools.client.browser.do_js_load = (function shadow$cljs$devtools$client$browser$do_js_load(sources){
var seq__54253 = cljs.core.seq(sources);
var chunk__54254 = null;
var count__54255 = (0);
var i__54256 = (0);
while(true){
if((i__54256 < count__54255)){
var map__54267 = chunk__54254.cljs$core$IIndexed$_nth$arity$2(null,i__54256);
var map__54267__$1 = (((((!((map__54267 == null))))?(((((map__54267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54267.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54267):map__54267);
var src = map__54267__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54267__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54267__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54267__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54267__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e54269){var e_54445 = e54269;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_54445);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_54445.message)].join('')));
}

var G__54446 = seq__54253;
var G__54447 = chunk__54254;
var G__54448 = count__54255;
var G__54449 = (i__54256 + (1));
seq__54253 = G__54446;
chunk__54254 = G__54447;
count__54255 = G__54448;
i__54256 = G__54449;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__54253);
if(temp__5735__auto__){
var seq__54253__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__54253__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__54253__$1);
var G__54450 = cljs.core.chunk_rest(seq__54253__$1);
var G__54451 = c__4556__auto__;
var G__54452 = cljs.core.count(c__4556__auto__);
var G__54453 = (0);
seq__54253 = G__54450;
chunk__54254 = G__54451;
count__54255 = G__54452;
i__54256 = G__54453;
continue;
} else {
var map__54270 = cljs.core.first(seq__54253__$1);
var map__54270__$1 = (((((!((map__54270 == null))))?(((((map__54270.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54270.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54270):map__54270);
var src = map__54270__$1;
var resource_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54270__$1,new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582));
var output_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54270__$1,new cljs.core.Keyword(null,"output-name","output-name",-1769107767));
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54270__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54270__$1,new cljs.core.Keyword(null,"js","js",1768080579));
$CLJS.SHADOW_ENV.setLoaded(output_name);

shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load JS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([resource_name], 0));

shadow.cljs.devtools.client.env.before_load_src(src);

try{shadow.cljs.devtools.client.browser.script_eval([cljs.core.str.cljs$core$IFn$_invoke$arity$1(js),"\n//# sourceURL=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''));
}catch (e54272){var e_54454 = e54272;
console.error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name)].join(''),e_54454);

throw (new Error(["Failed to load ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e_54454.message)].join('')));
}

var G__54455 = cljs.core.next(seq__54253__$1);
var G__54456 = null;
var G__54457 = (0);
var G__54458 = (0);
seq__54253 = G__54455;
chunk__54254 = G__54456;
count__54255 = G__54457;
i__54256 = G__54458;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.do_js_reload = (function shadow$cljs$devtools$client$browser$do_js_reload(msg,sources,complete_fn,failure_fn){
return shadow.cljs.devtools.client.env.do_js_reload.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(msg,new cljs.core.Keyword(null,"log-missing-fn","log-missing-fn",732676765),(function (fn_sym){
return null;
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"log-call-async","log-call-async",183826192),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call async ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
}),new cljs.core.Keyword(null,"log-call","log-call",412404391),(function (fn_sym){
return shadow.cljs.devtools.client.browser.devtools_msg(["call ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_sym)].join(''));
})], 0)),(function (){
return shadow.cljs.devtools.client.browser.do_js_load(sources);
}),complete_fn,failure_fn);
});
/**
 * when (require '["some-str" :as x]) is done at the REPL we need to manually call the shadow.js.require for it
 * since the file only adds the shadow$provide. only need to do this for shadow-js.
 */
shadow.cljs.devtools.client.browser.do_js_requires = (function shadow$cljs$devtools$client$browser$do_js_requires(js_requires){
var seq__54276 = cljs.core.seq(js_requires);
var chunk__54277 = null;
var count__54278 = (0);
var i__54279 = (0);
while(true){
if((i__54279 < count__54278)){
var js_ns = chunk__54277.cljs$core$IIndexed$_nth$arity$2(null,i__54279);
var require_str_54459 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_54459);


var G__54460 = seq__54276;
var G__54461 = chunk__54277;
var G__54462 = count__54278;
var G__54463 = (i__54279 + (1));
seq__54276 = G__54460;
chunk__54277 = G__54461;
count__54278 = G__54462;
i__54279 = G__54463;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__54276);
if(temp__5735__auto__){
var seq__54276__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__54276__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__54276__$1);
var G__54464 = cljs.core.chunk_rest(seq__54276__$1);
var G__54465 = c__4556__auto__;
var G__54466 = cljs.core.count(c__4556__auto__);
var G__54467 = (0);
seq__54276 = G__54464;
chunk__54277 = G__54465;
count__54278 = G__54466;
i__54279 = G__54467;
continue;
} else {
var js_ns = cljs.core.first(seq__54276__$1);
var require_str_54468 = ["var ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns)," = shadow.js.require(\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(js_ns),"\");"].join('');
shadow.cljs.devtools.client.browser.script_eval(require_str_54468);


var G__54469 = cljs.core.next(seq__54276__$1);
var G__54470 = null;
var G__54471 = (0);
var G__54472 = (0);
seq__54276 = G__54469;
chunk__54277 = G__54470;
count__54278 = G__54471;
i__54279 = G__54472;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.handle_build_complete = (function shadow$cljs$devtools$client$browser$handle_build_complete(runtime,p__54282){
var map__54283 = p__54282;
var map__54283__$1 = (((((!((map__54283 == null))))?(((((map__54283.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54283.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54283):map__54283);
var msg = map__54283__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54283__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var reload_info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54283__$1,new cljs.core.Keyword(null,"reload-info","reload-info",1648088086));
var warnings = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((function (){var iter__4529__auto__ = (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__54286(s__54287){
return (new cljs.core.LazySeq(null,(function (){
var s__54287__$1 = s__54287;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__54287__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var map__54292 = cljs.core.first(xs__6292__auto__);
var map__54292__$1 = (((((!((map__54292 == null))))?(((((map__54292.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54292.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54292):map__54292);
var src = map__54292__$1;
var resource_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54292__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
var warnings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54292__$1,new cljs.core.Keyword(null,"warnings","warnings",-735437651));
if(cljs.core.not(new cljs.core.Keyword(null,"from-jar","from-jar",1050932827).cljs$core$IFn$_invoke$arity$1(src))){
var iterys__4525__auto__ = ((function (s__54287__$1,map__54292,map__54292__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__54283,map__54283__$1,msg,info,reload_info){
return (function shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__54286_$_iter__54288(s__54289){
return (new cljs.core.LazySeq(null,((function (s__54287__$1,map__54292,map__54292__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__54283,map__54283__$1,msg,info,reload_info){
return (function (){
var s__54289__$1 = s__54289;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__54289__$1);
if(temp__5735__auto____$1){
var s__54289__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__54289__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__54289__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__54291 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__54290 = (0);
while(true){
if((i__54290 < size__4528__auto__)){
var warning = cljs.core._nth(c__4527__auto__,i__54290);
cljs.core.chunk_append(b__54291,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name));

var G__54473 = (i__54290 + (1));
i__54290 = G__54473;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__54291),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__54286_$_iter__54288(cljs.core.chunk_rest(s__54289__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__54291),null);
}
} else {
var warning = cljs.core.first(s__54289__$2);
return cljs.core.cons(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(warning,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100),resource_name),shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__54286_$_iter__54288(cljs.core.rest(s__54289__$2)));
}
} else {
return null;
}
break;
}
});})(s__54287__$1,map__54292,map__54292__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__54283,map__54283__$1,msg,info,reload_info))
,null,null));
});})(s__54287__$1,map__54292,map__54292__$1,src,resource_name,warnings,xs__6292__auto__,temp__5735__auto__,map__54283,map__54283__$1,msg,info,reload_info))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(warnings));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,shadow$cljs$devtools$client$browser$handle_build_complete_$_iter__54286(cljs.core.rest(s__54287__$1)));
} else {
var G__54474 = cljs.core.rest(s__54287__$1);
s__54287__$1 = G__54474;
continue;
}
} else {
var G__54475 = cljs.core.rest(s__54287__$1);
s__54287__$1 = G__54475;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(new cljs.core.Keyword(null,"sources","sources",-321166424).cljs$core$IFn$_invoke$arity$1(info));
})()));
var seq__54294_54476 = cljs.core.seq(warnings);
var chunk__54295_54477 = null;
var count__54296_54478 = (0);
var i__54297_54479 = (0);
while(true){
if((i__54297_54479 < count__54296_54478)){
var map__54303_54480 = chunk__54295_54477.cljs$core$IIndexed$_nth$arity$2(null,i__54297_54479);
var map__54303_54481__$1 = (((((!((map__54303_54480 == null))))?(((((map__54303_54480.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54303_54480.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54303_54480):map__54303_54480);
var w_54482 = map__54303_54481__$1;
var msg_54483__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54303_54481__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_54484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54303_54481__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_54485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54303_54481__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_54486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54303_54481__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_54486)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_54484),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_54485),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_54483__$1)].join(''));


var G__54487 = seq__54294_54476;
var G__54488 = chunk__54295_54477;
var G__54489 = count__54296_54478;
var G__54490 = (i__54297_54479 + (1));
seq__54294_54476 = G__54487;
chunk__54295_54477 = G__54488;
count__54296_54478 = G__54489;
i__54297_54479 = G__54490;
continue;
} else {
var temp__5735__auto___54491 = cljs.core.seq(seq__54294_54476);
if(temp__5735__auto___54491){
var seq__54294_54492__$1 = temp__5735__auto___54491;
if(cljs.core.chunked_seq_QMARK_(seq__54294_54492__$1)){
var c__4556__auto___54493 = cljs.core.chunk_first(seq__54294_54492__$1);
var G__54494 = cljs.core.chunk_rest(seq__54294_54492__$1);
var G__54495 = c__4556__auto___54493;
var G__54496 = cljs.core.count(c__4556__auto___54493);
var G__54497 = (0);
seq__54294_54476 = G__54494;
chunk__54295_54477 = G__54495;
count__54296_54478 = G__54496;
i__54297_54479 = G__54497;
continue;
} else {
var map__54305_54498 = cljs.core.first(seq__54294_54492__$1);
var map__54305_54499__$1 = (((((!((map__54305_54498 == null))))?(((((map__54305_54498.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54305_54498.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54305_54498):map__54305_54498);
var w_54500 = map__54305_54499__$1;
var msg_54501__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54305_54499__$1,new cljs.core.Keyword(null,"msg","msg",-1386103444));
var line_54502 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54305_54499__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_54503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54305_54499__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var resource_name_54504 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54305_54499__$1,new cljs.core.Keyword(null,"resource-name","resource-name",2001617100));
console.warn(["BUILD-WARNING in ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resource_name_54504)," at [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line_54502),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column_54503),"]\n\t",cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg_54501__$1)].join(''));


var G__54505 = cljs.core.next(seq__54294_54492__$1);
var G__54506 = null;
var G__54507 = (0);
var G__54508 = (0);
seq__54294_54476 = G__54505;
chunk__54295_54477 = G__54506;
count__54296_54478 = G__54507;
i__54297_54479 = G__54508;
continue;
}
} else {
}
}
break;
}

if((!(shadow.cljs.devtools.client.env.autoload))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(((cljs.core.empty_QMARK_(warnings)) || (shadow.cljs.devtools.client.env.ignore_warnings))){
var sources_to_get = shadow.cljs.devtools.client.env.filter_reload_sources(info,reload_info);
if(cljs.core.not(cljs.core.seq(sources_to_get))){
return shadow.cljs.devtools.client.hud.load_end_success();
} else {
if(cljs.core.seq(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"reload-info","reload-info",1648088086),new cljs.core.Keyword(null,"after-load","after-load",-1278503285)], null)))){
} else {
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("reloading code but no :after-load hooks are configured!",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["https://shadow-cljs.github.io/docs/UsersGuide.html#_lifecycle_hooks"], 0));
}

return shadow.cljs.devtools.client.websocket.load_sources(runtime,sources_to_get,(function (p1__54281_SHARP_){
return shadow.cljs.devtools.client.browser.do_js_reload(msg,p1__54281_SHARP_,shadow.cljs.devtools.client.hud.load_end_success,shadow.cljs.devtools.client.hud.load_failure);
}));
}
} else {
return null;
}
}
});
shadow.cljs.devtools.client.browser.page_load_uri = (cljs.core.truth_(goog.global.document)?goog.Uri.parse(document.location.href):null);
shadow.cljs.devtools.client.browser.match_paths = (function shadow$cljs$devtools$client$browser$match_paths(old,new$){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("file",shadow.cljs.devtools.client.browser.page_load_uri.getScheme())){
var rel_new = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(new$,(1));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old,rel_new)) || (clojure.string.starts_with_QMARK_(old,[rel_new,"?"].join(''))))){
return rel_new;
} else {
return null;
}
} else {
var node_uri = goog.Uri.parse(old);
var node_uri_resolved = shadow.cljs.devtools.client.browser.page_load_uri.resolve(node_uri);
var node_abs = node_uri_resolved.getPath();
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1(shadow.cljs.devtools.client.browser.page_load_uri.hasSameDomainAs(node_uri))) || (cljs.core.not(node_uri.hasDomain())))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(node_abs,new$)){
return new$;
} else {
return false;
}
} else {
return false;
}
}
});
shadow.cljs.devtools.client.browser.handle_asset_update = (function shadow$cljs$devtools$client$browser$handle_asset_update(p__54309){
var map__54310 = p__54309;
var map__54310__$1 = (((((!((map__54310 == null))))?(((((map__54310.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54310.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54310):map__54310);
var msg = map__54310__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54310__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
var seq__54312 = cljs.core.seq(updates);
var chunk__54314 = null;
var count__54315 = (0);
var i__54316 = (0);
while(true){
if((i__54316 < count__54315)){
var path = chunk__54314.cljs$core$IIndexed$_nth$arity$2(null,i__54316);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__54349_54509 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__54352_54510 = null;
var count__54353_54511 = (0);
var i__54354_54512 = (0);
while(true){
if((i__54354_54512 < count__54353_54511)){
var node_54513 = chunk__54352_54510.cljs$core$IIndexed$_nth$arity$2(null,i__54354_54512);
var path_match_54514 = shadow.cljs.devtools.client.browser.match_paths(node_54513.getAttribute("href"),path);
if(cljs.core.truth_(path_match_54514)){
var new_link_54515 = (function (){var G__54367 = node_54513.cloneNode(true);
G__54367.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_54514),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__54367;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_54514], 0));

goog.dom.insertSiblingAfter(new_link_54515,node_54513);

goog.dom.removeNode(node_54513);


var G__54516 = seq__54349_54509;
var G__54517 = chunk__54352_54510;
var G__54518 = count__54353_54511;
var G__54519 = (i__54354_54512 + (1));
seq__54349_54509 = G__54516;
chunk__54352_54510 = G__54517;
count__54353_54511 = G__54518;
i__54354_54512 = G__54519;
continue;
} else {
var G__54520 = seq__54349_54509;
var G__54521 = chunk__54352_54510;
var G__54522 = count__54353_54511;
var G__54523 = (i__54354_54512 + (1));
seq__54349_54509 = G__54520;
chunk__54352_54510 = G__54521;
count__54353_54511 = G__54522;
i__54354_54512 = G__54523;
continue;
}
} else {
var temp__5735__auto___54524 = cljs.core.seq(seq__54349_54509);
if(temp__5735__auto___54524){
var seq__54349_54525__$1 = temp__5735__auto___54524;
if(cljs.core.chunked_seq_QMARK_(seq__54349_54525__$1)){
var c__4556__auto___54526 = cljs.core.chunk_first(seq__54349_54525__$1);
var G__54527 = cljs.core.chunk_rest(seq__54349_54525__$1);
var G__54528 = c__4556__auto___54526;
var G__54529 = cljs.core.count(c__4556__auto___54526);
var G__54530 = (0);
seq__54349_54509 = G__54527;
chunk__54352_54510 = G__54528;
count__54353_54511 = G__54529;
i__54354_54512 = G__54530;
continue;
} else {
var node_54531 = cljs.core.first(seq__54349_54525__$1);
var path_match_54532 = shadow.cljs.devtools.client.browser.match_paths(node_54531.getAttribute("href"),path);
if(cljs.core.truth_(path_match_54532)){
var new_link_54533 = (function (){var G__54372 = node_54531.cloneNode(true);
G__54372.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_54532),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__54372;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_54532], 0));

goog.dom.insertSiblingAfter(new_link_54533,node_54531);

goog.dom.removeNode(node_54531);


var G__54534 = cljs.core.next(seq__54349_54525__$1);
var G__54535 = null;
var G__54536 = (0);
var G__54537 = (0);
seq__54349_54509 = G__54534;
chunk__54352_54510 = G__54535;
count__54353_54511 = G__54536;
i__54354_54512 = G__54537;
continue;
} else {
var G__54538 = cljs.core.next(seq__54349_54525__$1);
var G__54539 = null;
var G__54540 = (0);
var G__54541 = (0);
seq__54349_54509 = G__54538;
chunk__54352_54510 = G__54539;
count__54353_54511 = G__54540;
i__54354_54512 = G__54541;
continue;
}
}
} else {
}
}
break;
}


var G__54542 = seq__54312;
var G__54543 = chunk__54314;
var G__54544 = count__54315;
var G__54545 = (i__54316 + (1));
seq__54312 = G__54542;
chunk__54314 = G__54543;
count__54315 = G__54544;
i__54316 = G__54545;
continue;
} else {
var G__54546 = seq__54312;
var G__54547 = chunk__54314;
var G__54548 = count__54315;
var G__54549 = (i__54316 + (1));
seq__54312 = G__54546;
chunk__54314 = G__54547;
count__54315 = G__54548;
i__54316 = G__54549;
continue;
}
} else {
var temp__5735__auto__ = cljs.core.seq(seq__54312);
if(temp__5735__auto__){
var seq__54312__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__54312__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__54312__$1);
var G__54550 = cljs.core.chunk_rest(seq__54312__$1);
var G__54551 = c__4556__auto__;
var G__54552 = cljs.core.count(c__4556__auto__);
var G__54553 = (0);
seq__54312 = G__54550;
chunk__54314 = G__54551;
count__54315 = G__54552;
i__54316 = G__54553;
continue;
} else {
var path = cljs.core.first(seq__54312__$1);
if(clojure.string.ends_with_QMARK_(path,"css")){
var seq__54376_54554 = cljs.core.seq(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1(document.querySelectorAll("link[rel=\"stylesheet\"]")));
var chunk__54379_54555 = null;
var count__54380_54556 = (0);
var i__54381_54557 = (0);
while(true){
if((i__54381_54557 < count__54380_54556)){
var node_54558 = chunk__54379_54555.cljs$core$IIndexed$_nth$arity$2(null,i__54381_54557);
var path_match_54559 = shadow.cljs.devtools.client.browser.match_paths(node_54558.getAttribute("href"),path);
if(cljs.core.truth_(path_match_54559)){
var new_link_54560 = (function (){var G__54398 = node_54558.cloneNode(true);
G__54398.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_54559),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__54398;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_54559], 0));

goog.dom.insertSiblingAfter(new_link_54560,node_54558);

goog.dom.removeNode(node_54558);


var G__54561 = seq__54376_54554;
var G__54562 = chunk__54379_54555;
var G__54563 = count__54380_54556;
var G__54564 = (i__54381_54557 + (1));
seq__54376_54554 = G__54561;
chunk__54379_54555 = G__54562;
count__54380_54556 = G__54563;
i__54381_54557 = G__54564;
continue;
} else {
var G__54565 = seq__54376_54554;
var G__54566 = chunk__54379_54555;
var G__54567 = count__54380_54556;
var G__54568 = (i__54381_54557 + (1));
seq__54376_54554 = G__54565;
chunk__54379_54555 = G__54566;
count__54380_54556 = G__54567;
i__54381_54557 = G__54568;
continue;
}
} else {
var temp__5735__auto___54569__$1 = cljs.core.seq(seq__54376_54554);
if(temp__5735__auto___54569__$1){
var seq__54376_54570__$1 = temp__5735__auto___54569__$1;
if(cljs.core.chunked_seq_QMARK_(seq__54376_54570__$1)){
var c__4556__auto___54571 = cljs.core.chunk_first(seq__54376_54570__$1);
var G__54572 = cljs.core.chunk_rest(seq__54376_54570__$1);
var G__54573 = c__4556__auto___54571;
var G__54574 = cljs.core.count(c__4556__auto___54571);
var G__54575 = (0);
seq__54376_54554 = G__54572;
chunk__54379_54555 = G__54573;
count__54380_54556 = G__54574;
i__54381_54557 = G__54575;
continue;
} else {
var node_54576 = cljs.core.first(seq__54376_54570__$1);
var path_match_54577 = shadow.cljs.devtools.client.browser.match_paths(node_54576.getAttribute("href"),path);
if(cljs.core.truth_(path_match_54577)){
var new_link_54578 = (function (){var G__54402 = node_54576.cloneNode(true);
G__54402.setAttribute("href",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_match_54577),"?r=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.rand.cljs$core$IFn$_invoke$arity$0())].join(''));

return G__54402;
})();
shadow.cljs.devtools.client.browser.devtools_msg.cljs$core$IFn$_invoke$arity$variadic("load CSS",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([path_match_54577], 0));

goog.dom.insertSiblingAfter(new_link_54578,node_54576);

goog.dom.removeNode(node_54576);


var G__54579 = cljs.core.next(seq__54376_54570__$1);
var G__54580 = null;
var G__54581 = (0);
var G__54582 = (0);
seq__54376_54554 = G__54579;
chunk__54379_54555 = G__54580;
count__54380_54556 = G__54581;
i__54381_54557 = G__54582;
continue;
} else {
var G__54583 = cljs.core.next(seq__54376_54570__$1);
var G__54584 = null;
var G__54585 = (0);
var G__54586 = (0);
seq__54376_54554 = G__54583;
chunk__54379_54555 = G__54584;
count__54380_54556 = G__54585;
i__54381_54557 = G__54586;
continue;
}
}
} else {
}
}
break;
}


var G__54587 = cljs.core.next(seq__54312__$1);
var G__54588 = null;
var G__54589 = (0);
var G__54590 = (0);
seq__54312 = G__54587;
chunk__54314 = G__54588;
count__54315 = G__54589;
i__54316 = G__54590;
continue;
} else {
var G__54591 = cljs.core.next(seq__54312__$1);
var G__54592 = null;
var G__54593 = (0);
var G__54594 = (0);
seq__54312 = G__54591;
chunk__54314 = G__54592;
count__54315 = G__54593;
i__54316 = G__54594;
continue;
}
}
} else {
return null;
}
}
break;
}
});
shadow.cljs.devtools.client.browser.global_eval = (function shadow$cljs$devtools$client$browser$global_eval(js){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("undefined",typeof(module))){
return eval(js);
} else {
return (0,eval)(js);;
}
});
shadow.cljs.devtools.client.browser.repl_init = (function shadow$cljs$devtools$client$browser$repl_init(runtime,p__54404){
var map__54406 = p__54404;
var map__54406__$1 = (((((!((map__54406 == null))))?(((((map__54406.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54406.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54406):map__54406);
var repl_state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54406__$1,new cljs.core.Keyword(null,"repl-state","repl-state",-1733780387));
return shadow.cljs.devtools.client.websocket.load_sources(runtime,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535).cljs$core$IFn$_invoke$arity$1(repl_state))),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

return shadow.cljs.devtools.client.browser.devtools_msg("ready!");
}));
});
shadow.cljs.devtools.client.browser.start = (function shadow$cljs$devtools$client$browser$start(){
var ws_url = shadow.cljs.devtools.client.env.get_ws_relay_url();
return shadow.cljs.devtools.client.websocket.start(ws_url,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"host","host",-1558485167),(cljs.core.truth_(goog.global.document)?new cljs.core.Keyword(null,"browser","browser",828191719):new cljs.core.Keyword(null,"browser-worker","browser-worker",1638998282)),new cljs.core.Keyword(null,"dom","dom",-1236537922),(!((goog.global.document == null)))], null));
});
if(((shadow.cljs.devtools.client.env.enabled) && ((shadow.cljs.devtools.client.env.worker_client_id > (0))))){
(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$remote$runtime$api$IEvalJS$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$remote$runtime$api$IEvalJS$_js_eval$arity$2 = (function (this$,code){
var this$__$1 = this;
return shadow.cljs.devtools.client.browser.global_eval(code);
}));

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$cljs$devtools$client$shared$IHostSpecific$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$cljs$devtools$client$shared$IHostSpecific$do_invoke$arity$2 = (function (this$,p__54410){
var map__54411 = p__54410;
var map__54411__$1 = (((((!((map__54411 == null))))?(((((map__54411.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54411.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54411):map__54411);
var _ = map__54411__$1;
var js = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54411__$1,new cljs.core.Keyword(null,"js","js",1768080579));
var this$__$1 = this;
return shadow.cljs.devtools.client.browser.global_eval(js);
}));

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$cljs$devtools$client$shared$IHostSpecific$do_repl_init$arity$4 = (function (runtime,p__54413,done,error){
var map__54414 = p__54413;
var map__54414__$1 = (((((!((map__54414 == null))))?(((((map__54414.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54414.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54414):map__54414);
var repl_sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54414__$1,new cljs.core.Keyword(null,"repl-sources","repl-sources",723867535));
var runtime__$1 = this;
return shadow.cljs.devtools.client.websocket.load_sources(runtime__$1,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(shadow.cljs.devtools.client.env.src_is_loaded_QMARK_,repl_sources)),(function (sources){
shadow.cljs.devtools.client.browser.do_js_load(sources);

return (done.cljs$core$IFn$_invoke$arity$0 ? done.cljs$core$IFn$_invoke$arity$0() : done.call(null));
}));
}));

(shadow.cljs.devtools.client.shared.Runtime.prototype.shadow$cljs$devtools$client$shared$IHostSpecific$do_repl_require$arity$4 = (function (runtime,p__54416,done,error){
var map__54417 = p__54416;
var map__54417__$1 = (((((!((map__54417 == null))))?(((((map__54417.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54417.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54417):map__54417);
var msg = map__54417__$1;
var sources = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
var reload_namespaces = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,new cljs.core.Keyword(null,"reload-namespaces","reload-namespaces",250210134));
var js_requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,new cljs.core.Keyword(null,"js-requires","js-requires",-1311472051));
var runtime__$1 = this;
var sources_to_load = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p__54421){
var map__54422 = p__54421;
var map__54422__$1 = (((((!((map__54422 == null))))?(((((map__54422.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54422.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54422):map__54422);
var src = map__54422__$1;
var provides = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54422__$1,new cljs.core.Keyword(null,"provides","provides",-1634397992));
var and__4115__auto__ = shadow.cljs.devtools.client.env.src_is_loaded_QMARK_(src);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(cljs.core.some(reload_namespaces,provides));
} else {
return and__4115__auto__;
}
}),sources));
if(cljs.core.not(cljs.core.seq(sources_to_load))){
var G__54425 = cljs.core.PersistentVector.EMPTY;
return (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(G__54425) : done.call(null,G__54425));
} else {
return shadow.remote.runtime.shared.call.cljs$core$IFn$_invoke$arity$3(runtime__$1,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"cljs-load-sources","cljs-load-sources",-1458295962),new cljs.core.Keyword(null,"to","to",192099007),shadow.cljs.devtools.client.env.worker_client_id,new cljs.core.Keyword(null,"sources","sources",-321166424),cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"resource-id","resource-id",-1308422582)),sources_to_load)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cljs-sources","cljs-sources",31121610),(function (p__54426){
var map__54427 = p__54426;
var map__54427__$1 = (((((!((map__54427 == null))))?(((((map__54427.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54427.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54427):map__54427);
var msg__$1 = map__54427__$1;
var sources__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54427__$1,new cljs.core.Keyword(null,"sources","sources",-321166424));
try{shadow.cljs.devtools.client.browser.do_js_load(sources__$1);

if(cljs.core.seq(js_requires)){
shadow.cljs.devtools.client.browser.do_js_requires(js_requires);
} else {
}

return (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(sources_to_load) : done.call(null,sources_to_load));
}catch (e54429){var ex = e54429;
return (error.cljs$core$IFn$_invoke$arity$1 ? error.cljs$core$IFn$_invoke$arity$1(ex) : error.call(null,ex));
}})], null));
}
}));

shadow.cljs.devtools.client.shared.init_extension_BANG_(new cljs.core.Keyword("shadow.cljs.devtools.client.browser","client","shadow.cljs.devtools.client.browser/client",-1461019282),cljs.core.PersistentHashSet.EMPTY,(function (p__54430){
var map__54431 = p__54430;
var map__54431__$1 = (((((!((map__54431 == null))))?(((((map__54431.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54431.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54431):map__54431);
var env = map__54431__$1;
var runtime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54431__$1,new cljs.core.Keyword(null,"runtime","runtime",-1331573996));
var svc = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"runtime","runtime",-1331573996),runtime], null);
shadow.remote.runtime.api.add_extension(runtime,new cljs.core.Keyword("shadow.cljs.devtools.client.browser","client","shadow.cljs.devtools.client.browser/client",-1461019282),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-connect","on-connect",-1148973056),(function (){
shadow.cljs.devtools.client.env.patch_goog_BANG_();

return shadow.cljs.devtools.client.browser.devtools_msg(["#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state-ref","state-ref",2127874952).cljs$core$IFn$_invoke$arity$1(runtime))))," ready!"].join(''));
}),new cljs.core.Keyword(null,"on-disconnect","on-disconnect",-809021814),(function (){
return shadow.cljs.devtools.client.hud.connection_error("The Websocket connection was closed!");
}),new cljs.core.Keyword(null,"ops","ops",1237330063),new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"access-denied","access-denied",959449406),(function (msg){
return shadow.cljs.devtools.client.hud.connection_error(["Stale Output! Your loaded JS was not produced by the running shadow-cljs instance."," Is the watch for this build running?"].join(''));
}),new cljs.core.Keyword(null,"cljs-runtime-init","cljs-runtime-init",1305890232),(function (msg){
return shadow.cljs.devtools.client.browser.repl_init(runtime,msg);
}),new cljs.core.Keyword(null,"cljs-asset-update","cljs-asset-update",1224093028),(function (p__54433){
var map__54434 = p__54433;
var map__54434__$1 = (((((!((map__54434 == null))))?(((((map__54434.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54434.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54434):map__54434);
var msg = map__54434__$1;
var updates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54434__$1,new cljs.core.Keyword(null,"updates","updates",2013983452));
return shadow.cljs.devtools.client.browser.handle_asset_update(msg);
}),new cljs.core.Keyword(null,"cljs-build-start","cljs-build-start",-725781241),(function (msg){
shadow.cljs.devtools.client.hud.hud_hide();

shadow.cljs.devtools.client.hud.load_start();

return shadow.cljs.devtools.client.env.run_custom_notify_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(msg,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"build-start","build-start",-959649480)));
}),new cljs.core.Keyword(null,"cljs-build-complete","cljs-build-complete",273626153),(function (msg){
var msg__$1 = shadow.cljs.devtools.client.env.add_warnings_to_info(msg);
shadow.cljs.devtools.client.hud.hud_warnings(msg__$1);

shadow.cljs.devtools.client.browser.handle_build_complete(runtime,msg__$1);

return shadow.cljs.devtools.client.env.run_custom_notify_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(msg__$1,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"build-complete","build-complete",-501868472)));
}),new cljs.core.Keyword(null,"cljs-build-failure","cljs-build-failure",1718154990),(function (msg){
shadow.cljs.devtools.client.hud.load_end();

shadow.cljs.devtools.client.hud.hud_error(msg);

return shadow.cljs.devtools.client.env.run_custom_notify_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(msg,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"build-failure","build-failure",-2107487466)));
}),new cljs.core.Keyword("shadow.cljs.devtools.client.env","worker-notify","shadow.cljs.devtools.client.env/worker-notify",-1456820670),(function (p__54436){
var map__54437 = p__54436;
var map__54437__$1 = (((((!((map__54437 == null))))?(((((map__54437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54437):map__54437);
var event_op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54437__$1,new cljs.core.Keyword(null,"event-op","event-op",200358057));
var client_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54437__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"client-disconnect","client-disconnect",640227957),event_op)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(client_id,shadow.cljs.devtools.client.env.worker_client_id)))){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

return shadow.cljs.devtools.client.hud.connection_error("The watch for this build was stopped!");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"client-connect","client-connect",-1113973888),event_op)){
shadow.cljs.devtools.client.hud.connection_error_clear_BANG_();

return shadow.cljs.devtools.client.hud.connection_error("The watch for this build was restarted. Reload required!");
} else {
return null;
}
}
})], null)], null));

return svc;
}),(function (p__54439){
var map__54440 = p__54439;
var map__54440__$1 = (((((!((map__54440 == null))))?(((((map__54440.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__54440.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__54440):map__54440);
var svc = map__54440__$1;
var runtime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54440__$1,new cljs.core.Keyword(null,"runtime","runtime",-1331573996));
return shadow.remote.runtime.api.del_extension(runtime,new cljs.core.Keyword("shadow.cljs.devtools.client.browser","client","shadow.cljs.devtools.client.browser/client",-1461019282));
}));

shadow.cljs.devtools.client.browser.start();
} else {
}

//# sourceMappingURL=shadow.cljs.devtools.client.browser.js.map
