(ns {{namespace}}.client.ui.root
  (:require
    [com.fulcrologic.fulcro.application :as app]
    [com.fulcrologic.fulcro.components :as c :refer [defsc]]
    [com.fulcrologic.fulcro.dom :as dom :refer [div]]
    [com.fulcrologic.fulcro.routing.dynamic-routing :as dr]
    [com.fulcrologic.fulcro.ui-state-machines :as sm]
    [{{namespace}}.client.ui.task-item :refer [ui-task-list TaskList TaskForm ui-task-form]]
    [{{namespace}}.client.application :refer [SPA]]
    [{{namespace}}.client.router :as r :refer [routes change-route!]]
    {{#server?}}
    [{{namespace}}.auth.login :refer [ui-login Login Session session-join valid-session?]]
    [{{namespace}}.auth.signup :refer [Signup]]
    {{/server?}}))

(defsc Hello [this {:keys [task-list task-form]}]
  {:query         [{:task-list (c/get-query TaskList)}
                   {:task-form (c/get-query TaskForm)}]
   :route-segment (r/route-segment :hello)
   :initial-state (fn [_] {:task-form (c/get-initial-state TaskForm)})
   :ident         (fn [_] [:component/id :hello])}
  [:div
   [:h1 "Here's a task form:"]
   (ui-task-form task-form)
   [:h1 "Here's a task list:"]
   (ui-task-list task-list)])

(dr/defrouter TopRouter
  [this {:keys [current-state route-factory route-props]}]
  {:router-targets [Hello]})

(def ui-top-router (c/factory TopRouter))

{{#server?}}
 (defn menu [{:keys [current-tab session? login]}]
   (div :.ui.secondary.pointing.menu
     (conj
       (mapv r/link [:debug])
       (ui-login login))))
 {{/server?}}
 {{^server?}}
 (defn menu [{:keys [current-tab]}]
   (div :.ui.secondary.pointing.menu
     (mapv
       #(r/link % current-tab) [:hello])))
 {{/server?}}

 {{#server?}}
  (defsc PageContainer [this {:root/keys [router login] :as props}]
    {:query         [{:root/router (c/get-query TopRouter)}
                     [::sm/asm-id ::TopRouter]
                     session-join
                     {:root/login (c/get-query Login)}]
     :ident         (fn [] [:component/id :page-container])
     :initial-state (fn [_] {:root/router             (c/get-initial-state TopRouter {})
                             :root/login              (c/get-initial-state Login {})
                             :root/signup             (c/get-initial-state Signup {})
                             [:component/id :session] (c/get-initial-state Session {})})}
    (let [current-tab (r/current-route this)
          session? (valid-session? props)]
      [:.ui.container
       ^:inline (menu {:current-tab current-tab :session? session? :login login})
       ^:inline (ui-top-router router)]))
  {{/server?}}

  {{^server?}}
  (defsc PageContainer [this {:root/keys [router] :as props}]
    {:query         [{:root/router (c/get-query TopRouter)}
                     [::sm/asm-id ::TopRouter]]
     :ident         (fn [] [:component/id :page-container])
     :initial-state (fn [_] {:root/router (c/get-initial-state TopRouter {})})}
    (let [current-tab (r/current-route this)]
      [:.ui.container
       ^:inline (menu {:current-tab current-tab})
       ^:inline (ui-top-router router)]))
  {{/server?}}

  (def ui-page-container (c/factory PageContainer))

  (defsc Root [_ {:root/keys [page-container]}]
    {:query         [{:root/page-container (c/get-query PageContainer)}]
     :initial-state (fn [_] {:root/page-container (c/get-initial-state PageContainer {})})}
    ^:inline (ui-page-container page-container))
