(ns e85th.clj-postgis
  (:require [clojure.java.jdbc :as jdbc]
            [e85th.commons.geo :as geo]))

(defmulti parse-geometry class)

(defmethod parse-geometry org.postgis.Point
  [^org.postgis.Point v]
  (geo/map->LatLng {:lng (.getX v) :lat (.getY v)}))

(defmethod parse-geometry :default
  [v]
  ;;(geo/map->Point {:lat (.getX v) :lng (.getY v)})
  (throw (ex-info "Unhandled parse-geometry" {:input v :class (class v)})))

(extend-protocol jdbc/IResultSetReadColumn
  org.postgis.PGgeometry
  (result-set-read-column [^org.postgis.PGgeometry v _ _]
    (parse-geometry (.getGeometry v))))

(extend-protocol jdbc/ISQLParameter
  e85th.commons.geo.LatLng
  (set-parameter [v ^java.sql.PreparedStatement stmt idx]
    (.setObject stmt idx (org.postgis.PGgeometry. (org.postgis.Point. (geo/lng v) (geo/lat v)))))

  e85th.commons.geo.Point
  (set-parameter [v ^java.sql.PreparedStatement stmt idx]
    (.setObject stmt idx (org.postgis.PGgeometry. (org.postgis.Point. (geo/x v) (geo/y v))))))
