/*
 * Decompiled with CFR 0.152.
 */
package JSci.io;

import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ExtraMath;
import JSci.maths.MathDouble;
import JSci.maths.MathSet;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.RealField;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.Complex3Vector;
import JSci.maths.vectors.Double3Vector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class MathMLExpression {
    private String operation;
    private List args = new ArrayList();

    public void setOperation(String string) {
        this.operation = string;
    }

    public String getOperation() {
        return this.operation;
    }

    public void addArgument(Object object) {
        this.args.add(object);
    }

    public Object getArgument(int n) {
        return this.args.get(n);
    }

    public int length() {
        return this.args.size();
    }

    public MathMLExpression substitute(String string, Object object) {
        MathMLExpression mathMLExpression = new MathMLExpression();
        mathMLExpression.operation = this.operation;
        for (int i = 0; i < this.length(); ++i) {
            Object object2 = this.getArgument(i);
            if (object2 instanceof MathMLExpression) {
                object2 = ((MathMLExpression)object2).substitute(string, object);
            } else if (object2.equals(string)) {
                object2 = object;
            }
            mathMLExpression.addArgument(object2);
        }
        return mathMLExpression;
    }

    public MathMLExpression substitute(Map map) {
        MathMLExpression mathMLExpression = new MathMLExpression();
        mathMLExpression.operation = this.operation;
        for (int i = 0; i < this.length(); ++i) {
            Object object = this.getArgument(i);
            if (object instanceof MathMLExpression) {
                object = ((MathMLExpression)object).substitute(map);
            } else if (map.containsKey(object)) {
                object = map.get(object);
            }
            mathMLExpression.addArgument(object);
        }
        return mathMLExpression;
    }

    public Object evaluate() {
        if (this.length() == 1) {
            return this.unaryEvaluate();
        }
        if (this.length() == 2) {
            return this.binaryEvaluate();
        }
        return this.nAryEvaluate();
    }

    private Object unaryEvaluate() {
        Object object = this.getArgument(0);
        if (object instanceof MathMLExpression) {
            object = ((MathMLExpression)object).evaluate();
        }
        if (this.operation.equals("abs")) {
            if (object instanceof MathDouble) {
                object = new MathDouble(Math.abs(((MathDouble)object).value()));
            } else if (object instanceof Complex) {
                object = new MathDouble(((Complex)object).mod());
            }
        } else if (this.operation.equals("arg")) {
            if (object instanceof MathDouble) {
                object = ((MathDouble)object).value() >= 0.0 ? RealField.ZERO : RealField.PI;
            } else if (object instanceof Complex) {
                object = new MathDouble(((Complex)object).arg());
            }
        } else if (this.operation.equals("real")) {
            if (object instanceof Complex) {
                object = new MathDouble(((Complex)object).real());
            } else if (object instanceof AbstractComplexVector) {
                object = ((AbstractComplexVector)object).real();
            } else if (object instanceof AbstractComplexMatrix) {
                object = ((AbstractComplexMatrix)object).real();
            }
        } else if (this.operation.equals("imaginary")) {
            if (object instanceof Complex) {
                object = new MathDouble(((Complex)object).imag());
            } else if (object instanceof AbstractComplexVector) {
                object = ((AbstractComplexVector)object).imag();
            } else if (object instanceof AbstractComplexMatrix) {
                object = ((AbstractComplexMatrix)object).imag();
            }
        } else if (this.operation.equals("conjugate")) {
            if (object instanceof Complex) {
                object = ((Complex)object).conjugate();
            } else if (object instanceof AbstractComplexVector) {
                object = ((AbstractComplexVector)object).conjugate();
            } else if (object instanceof AbstractComplexMatrix) {
                object = ((AbstractComplexMatrix)object).conjugate();
            }
        } else if (this.operation.equals("transpose")) {
            if (object instanceof Matrix) {
                object = ((Matrix)object).transpose();
            }
        } else if (this.operation.equals("exp")) {
            if (object instanceof MathDouble) {
                object = MathDouble.exp((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.exp((Complex)object);
            }
        } else if (this.operation.equals("ln")) {
            if (object instanceof MathDouble) {
                object = MathDouble.log((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.log((Complex)object);
            }
        } else if (this.operation.equals("sin")) {
            if (object instanceof MathDouble) {
                object = MathDouble.sin((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.sin((Complex)object);
            }
        } else if (this.operation.equals("cos")) {
            if (object instanceof MathDouble) {
                object = MathDouble.cos((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.cos((Complex)object);
            }
        } else if (this.operation.equals("tan")) {
            if (object instanceof MathDouble) {
                object = MathDouble.tan((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.tan((Complex)object);
            }
        } else if (this.operation.equals("arcsin")) {
            if (object instanceof MathDouble) {
                object = MathDouble.asin((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.asin((Complex)object);
            }
        } else if (this.operation.equals("arccos")) {
            if (object instanceof MathDouble) {
                object = MathDouble.acos((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.acos((Complex)object);
            }
        } else if (this.operation.equals("arctan")) {
            if (object instanceof MathDouble) {
                object = MathDouble.atan((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.atan((Complex)object);
            }
        } else if (this.operation.equals("sinh")) {
            if (object instanceof MathDouble) {
                object = MathDouble.sinh((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.sinh((Complex)object);
            }
        } else if (this.operation.equals("cosh")) {
            if (object instanceof MathDouble) {
                object = MathDouble.cosh((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.cosh((Complex)object);
            }
        } else if (this.operation.equals("tanh")) {
            if (object instanceof MathDouble) {
                object = MathDouble.tanh((MathDouble)object);
            } else if (object instanceof Complex) {
                object = Complex.tanh((Complex)object);
            }
        } else if (this.operation.equals("factorial")) {
            if (object instanceof MathDouble) {
                object = new MathDouble(ExtraMath.factorial(((MathDouble)object).value()));
            }
        } else if (this.operation.equals("not") && object instanceof Boolean) {
            object = new Boolean((Boolean)object == false);
        }
        return object;
    }

    private Object binaryEvaluate() {
        Object object;
        Object object2 = this.getArgument(0);
        if (object2 instanceof MathMLExpression) {
            object2 = ((MathMLExpression)object2).evaluate();
        }
        if ((object = this.getArgument(1)) instanceof MathMLExpression) {
            object = ((MathMLExpression)object).evaluate();
        }
        if (this.operation.equals("minus")) {
            if (object2 instanceof AbelianGroup.Member) {
                object2 = ((AbelianGroup.Member)object2).subtract((AbelianGroup.Member)object);
            }
        } else if (this.operation.equals("divide")) {
            if (object instanceof Field.Member) {
                if (object2 instanceof Field.Member) {
                    object2 = ((Field.Member)object2).divide((Field.Member)object);
                } else if (object2 instanceof VectorSpace.Member) {
                    object2 = ((VectorSpace.Member)object2).scalarDivide((Field.Member)object);
                }
            }
        } else if (this.operation.equals("scalarproduct")) {
            if (object2 instanceof AbstractDoubleVector) {
                object2 = new MathDouble(((AbstractDoubleVector)object2).scalarProduct((AbstractDoubleVector)object));
            } else if (object2 instanceof AbstractComplexVector) {
                object2 = ((AbstractComplexVector)object2).scalarProduct((AbstractComplexVector)object);
            }
        } else if (this.operation.equals("vectorproduct")) {
            if (object2 instanceof Double3Vector) {
                object2 = ((Double3Vector)object2).multiply((Double3Vector)object);
            } else if (object2 instanceof Complex3Vector) {
                object2 = ((Complex3Vector)object2).multiply((Complex3Vector)object);
            }
        } else if (this.operation.equals("power")) {
            if (object2 instanceof MathDouble) {
                object2 = new MathDouble(Math.pow(((MathDouble)object2).value(), ((MathDouble)object).value()));
            }
        } else if (this.operation.equals("neq")) {
            object2 = new Boolean(!object2.equals(object));
        } else {
            return this.nAryEvaluate();
        }
        return object2;
    }

    private Object nAryEvaluate() {
        Object object = this.getArgument(0);
        if (object instanceof MathMLExpression) {
            object = ((MathMLExpression)object).evaluate();
        }
        if (this.operation.equals("plus")) {
            if (object instanceof AbelianGroup.Member) {
                AbelianGroup.Member member = (AbelianGroup.Member)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object2 = this.getArgument(i);
                    if (object2 instanceof MathMLExpression) {
                        object2 = ((MathMLExpression)object2).evaluate();
                    }
                    if (!(object2 instanceof AbelianGroup.Member)) continue;
                    member = member.add((AbelianGroup.Member)object2);
                }
                object = member;
            }
        } else if (this.operation.equals("times")) {
            if (object instanceof Ring.Member) {
                for (int i = 1; i < this.length(); ++i) {
                    Object object3 = this.getArgument(i);
                    if (object3 instanceof MathMLExpression) {
                        object3 = ((MathMLExpression)object3).evaluate();
                    }
                    if (object3 instanceof Ring.Member) {
                        object = ((Ring.Member)object).multiply((Ring.Member)object3);
                        continue;
                    }
                    if (!(object3 instanceof Module.Member)) continue;
                    object = ((Module.Member)object3).scalarMultiply((Ring.Member)object);
                }
            }
        } else if (this.operation.equals("min")) {
            Comparable comparable = (Comparable)object;
            for (int i = 1; i < this.length(); ++i) {
                Object object4 = this.getArgument(i);
                if (object4 instanceof MathMLExpression) {
                    object4 = ((MathMLExpression)object4).evaluate();
                }
                if (comparable.compareTo(object4) <= 0) continue;
                comparable = (Comparable)object4;
            }
            object = comparable;
        } else if (this.operation.equals("max")) {
            Comparable comparable = (Comparable)object;
            for (int i = 1; i < this.length(); ++i) {
                Object object5 = this.getArgument(i);
                if (object5 instanceof MathMLExpression) {
                    object5 = ((MathMLExpression)object5).evaluate();
                }
                if (comparable.compareTo(object5) >= 0) continue;
                comparable = (Comparable)object5;
            }
            object = comparable;
        } else if (this.operation.equals("mean")) {
            object = new MathDouble(this.mean());
        } else if (this.operation.equals("sdev")) {
            object = new MathDouble(Math.sqrt(this.variance()));
        } else if (this.operation.equals("var")) {
            object = new MathDouble(this.variance());
        } else if (this.operation.equals("median")) {
            double[] dArray = new double[this.length()];
            dArray[0] = ((MathDouble)object).value();
            for (int i = 1; i < dArray.length; ++i) {
                Object object6 = this.getArgument(i);
                if (object6 instanceof MathMLExpression) {
                    object6 = ((MathMLExpression)object6).evaluate();
                }
                dArray[i] = ((MathDouble)object6).value();
            }
            object = new MathDouble(ArrayMath.median(dArray));
        } else if (this.operation.equals("union")) {
            if (object instanceof MathSet) {
                MathSet mathSet = (MathSet)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object7 = this.getArgument(i);
                    if (object7 instanceof MathMLExpression) {
                        object7 = ((MathMLExpression)object7).evaluate();
                    }
                    if (!(object7 instanceof MathSet)) continue;
                    mathSet = mathSet.union((MathSet)object7);
                }
                object = mathSet;
            }
        } else if (this.operation.equals("intersect")) {
            if (object instanceof MathSet) {
                MathSet mathSet = (MathSet)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object8 = this.getArgument(i);
                    if (object8 instanceof MathMLExpression) {
                        object8 = ((MathMLExpression)object8).evaluate();
                    }
                    if (!(object8 instanceof MathSet)) continue;
                    mathSet = mathSet.intersect((MathSet)object8);
                }
                object = mathSet;
            }
        } else if (this.operation.equals("and")) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object9 = this.getArgument(i);
                    if (object9 instanceof MathMLExpression) {
                        object9 = ((MathMLExpression)object9).evaluate();
                    }
                    if (!(object9 instanceof Boolean)) continue;
                    bl &= ((Boolean)object9).booleanValue();
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("or")) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object10 = this.getArgument(i);
                    if (object10 instanceof MathMLExpression) {
                        object10 = ((MathMLExpression)object10).evaluate();
                    }
                    if (!(object10 instanceof Boolean)) continue;
                    bl |= ((Boolean)object10).booleanValue();
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("xor")) {
            if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                for (int i = 1; i < this.length(); ++i) {
                    Object object11 = this.getArgument(i);
                    if (object11 instanceof MathMLExpression) {
                        object11 = ((MathMLExpression)object11).evaluate();
                    }
                    if (!(object11 instanceof Boolean)) continue;
                    bl ^= ((Boolean)object11).booleanValue();
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("eq")) {
            Object object12 = object;
            boolean bl = true;
            for (int i = 1; i < this.length(); ++i) {
                Object object13 = this.getArgument(i);
                if (object13 instanceof MathMLExpression) {
                    object13 = ((MathMLExpression)object13).evaluate();
                }
                bl &= object12.equals(object13);
                object12 = object13;
            }
            object = new Boolean(bl);
        } else if (this.operation.equals("lt")) {
            if (object instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                boolean bl = true;
                for (int i = 1; i < this.length(); ++i) {
                    Object object14 = this.getArgument(i);
                    if (object14 instanceof MathMLExpression) {
                        object14 = ((MathMLExpression)object14).evaluate();
                    }
                    bl &= comparable.compareTo(object14) < 0;
                    if (!(object14 instanceof Comparable)) continue;
                    comparable = (Comparable)object14;
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("leq")) {
            if (object instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                boolean bl = true;
                for (int i = 1; i < this.length(); ++i) {
                    Object object15 = this.getArgument(i);
                    if (object15 instanceof MathMLExpression) {
                        object15 = ((MathMLExpression)object15).evaluate();
                    }
                    bl &= comparable.compareTo(object15) <= 0;
                    if (!(object15 instanceof Comparable)) continue;
                    comparable = (Comparable)object15;
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("gt")) {
            if (object instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                boolean bl = true;
                for (int i = 1; i < this.length(); ++i) {
                    Object object16 = this.getArgument(i);
                    if (object16 instanceof MathMLExpression) {
                        object16 = ((MathMLExpression)object16).evaluate();
                    }
                    bl &= comparable.compareTo(object16) > 0;
                    if (!(object16 instanceof Comparable)) continue;
                    comparable = (Comparable)object16;
                }
                object = new Boolean(bl);
            }
        } else if (this.operation.equals("geq") && object instanceof Comparable) {
            Comparable comparable = (Comparable)object;
            boolean bl = true;
            for (int i = 1; i < this.length(); ++i) {
                Object object17 = this.getArgument(i);
                if (object17 instanceof MathMLExpression) {
                    object17 = ((MathMLExpression)object17).evaluate();
                }
                bl &= comparable.compareTo(object17) >= 0;
                if (!(object17 instanceof Comparable)) continue;
                comparable = (Comparable)object17;
            }
            object = new Boolean(bl);
        }
        return object;
    }

    private double mean() {
        double d = ((MathDouble)this.getArgument(0)).value();
        for (int i = 1; i < this.length(); ++i) {
            Object object = this.getArgument(i);
            if (object instanceof MathMLExpression) {
                object = ((MathMLExpression)object).evaluate();
            }
            d += ((MathDouble)object).value();
        }
        return d / (double)this.length();
    }

    private double variance() {
        double d = this.mean();
        double d2 = ((MathDouble)this.getArgument(0)).value();
        double d3 = (d2 - d) * (d2 - d);
        for (int i = 1; i < this.length(); ++i) {
            Object object = this.getArgument(i);
            if (object instanceof MathMLExpression) {
                object = ((MathMLExpression)object).evaluate();
            }
            d2 = ((MathDouble)object).value();
            d3 += (d2 - d) * (d2 - d);
        }
        return d3 / (double)(this.length() - 1);
    }
}

