/*
 * Decompiled with CFR 0.152.
 */
package JSci.io;

import JSci.io.MathMLExpression;
import JSci.maths.Complex;
import JSci.maths.FiniteSet;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.fields.ComplexField;
import JSci.maths.fields.RealField;
import JSci.maths.fields.Ring;
import JSci.maths.matrices.ComplexMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.IntegerMatrix;
import JSci.maths.matrices.IntegerSquareMatrix;
import JSci.maths.vectors.ComplexVector;
import JSci.maths.vectors.DoubleVector;
import JSci.maths.vectors.IntegerVector;
import java.util.HashSet;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.mathml.MathMLApplyElement;
import org.w3c.dom.mathml.MathMLCiElement;
import org.w3c.dom.mathml.MathMLCnElement;
import org.w3c.dom.mathml.MathMLContentContainer;
import org.w3c.dom.mathml.MathMLContentElement;
import org.w3c.dom.mathml.MathMLMatrixElement;
import org.w3c.dom.mathml.MathMLMatrixrowElement;
import org.w3c.dom.mathml.MathMLPresentationToken;
import org.w3c.dom.mathml.MathMLSetElement;
import org.w3c.dom.mathml.MathMLStringLitElement;
import org.w3c.dom.mathml.MathMLVectorElement;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public final class MathMLParser
extends DOMParser {
    public MathMLParser() {
        try {
            this.setProperty("http://apache.org/xml/properties/dom/document-class-name", "JSci.mathml.MathMLDocumentImpl");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
    }

    public Object[] translateToJSciObjects() {
        return MathMLParser.translateToJSciObjects(this.getDocument().getDocumentElement());
    }

    public static Object[] translateToJSciObjects(Node node) {
        JSciObjectTranslator jSciObjectTranslator = new JSciObjectTranslator();
        return jSciObjectTranslator.translate(node);
    }

    public Object[] translateToJSciCode() {
        return MathMLParser.translateToJSciCode(this.getDocument().getDocumentElement());
    }

    public static Object[] translateToJSciCode(Node node) {
        JSciCodeTranslator jSciCodeTranslator = new JSciCodeTranslator();
        return jSciCodeTranslator.translate(node);
    }

    static class JSciCodeTranslator
    extends Translator {
        protected Object parseAPPLY(MathMLContentContainer mathMLContentContainer) {
            StringBuffer stringBuffer = new StringBuffer();
            NodeList nodeList = mathMLContentContainer.getChildNodes();
            int n = 0;
            while (nodeList.item(n).getNodeType() == 3) {
                ++n;
            }
            String string = nodeList.item(n).getNodeName();
            if (string.equals("plus")) {
                string = "add";
            } else if (string.equals("minus")) {
                string = "subtract";
            } else if (string.equals("times")) {
                string = "multiply";
            }
            boolean bl = true;
            while (n < nodeList.getLength()) {
                Object object = this.processNode(nodeList.item(n));
                if (object != null) {
                    if (bl) {
                        stringBuffer.append(object);
                        bl = false;
                    } else {
                        stringBuffer.append('.').append(string).append('(').append(object).append(')');
                    }
                }
                ++n;
            }
            return stringBuffer;
        }

        protected Object parseCN(MathMLCnElement mathMLCnElement) {
            if (!mathMLCnElement.getBase().equals("10")) {
                return null;
            }
            String string = mathMLCnElement.getType();
            if (string.equals("real")) {
                return "new MathDouble(" + mathMLCnElement.getFirstChild().getNodeValue() + ')';
            }
            if (string.equals("integer")) {
                return "new MathInteger(" + mathMLCnElement.getFirstChild().getNodeValue() + ')';
            }
            if (string.equals("rational")) {
                Node node = mathMLCnElement.getArgument(1);
                Node node2 = mathMLCnElement.getArgument(2);
                return "new MathDouble(" + node.getNodeValue() + '/' + node2.getNodeValue() + ')';
            }
            if (string.equals("complex-cartesian")) {
                Node node = mathMLCnElement.getArgument(1);
                Node node3 = mathMLCnElement.getArgument(2);
                return "new Complex(" + node.getNodeValue() + ',' + node3.getNodeValue() + ')';
            }
            if (string.equals("complex-polar")) {
                Node node = mathMLCnElement.getArgument(1);
                Node node4 = mathMLCnElement.getArgument(2);
                return "Complex.polar(" + node.getNodeValue() + ',' + node4.getNodeValue() + ')';
            }
            if (string.equals("constant")) {
                String string2 = mathMLCnElement.getFirstChild().getNodeValue();
                if (string2.equals("&pi;")) {
                    return "RealField.PI";
                }
                if (string2.equals("&ee;") || string2.equals("&ExponentialE;")) {
                    return "RealField.E";
                }
                if (string2.equals("&ii;") || string2.equals("&ImaginaryI;")) {
                    return "ComplexField.I";
                }
                if (string2.equals("&gamma;")) {
                    return "RealField.GAMMA";
                }
                if (string2.equals("&infty;") || string2.equals("&infin;")) {
                    return "RealField.INFINITY";
                }
                if (string2.equals("&NaN;") || string2.equals("&NotANumber;")) {
                    return "RealField.NaN";
                }
                return null;
            }
            return null;
        }

        protected Object parseCI(MathMLCiElement mathMLCiElement) {
            return mathMLCiElement.getFirstChild().getNodeValue();
        }

        protected Object parseVECTOR(MathMLVectorElement mathMLVectorElement) {
            return null;
        }

        protected Object parseMATRIX(MathMLMatrixElement mathMLMatrixElement) {
            return null;
        }

        protected Object parseSET(MathMLSetElement mathMLSetElement) {
            return null;
        }

        protected Object parseMS(MathMLStringLitElement mathMLStringLitElement) {
            return mathMLStringLitElement.getFirstChild().getNodeValue();
        }

        protected Object parseMTEXT(MathMLPresentationToken mathMLPresentationToken) {
            return "/*\n" + mathMLPresentationToken.getFirstChild().getNodeValue() + "\n*/";
        }
    }

    static class JSciObjectTranslator
    extends Translator {
        private final int INTEGER = 0;
        private final int DOUBLE = 1;
        private final int COMPLEX = 2;
        private int setID = 1;

        protected Object parseAPPLY(MathMLContentContainer mathMLContentContainer) {
            MathMLExpression mathMLExpression = new MathMLExpression();
            NodeList nodeList = mathMLContentContainer.getChildNodes();
            int n = 0;
            while (nodeList.item(n).getNodeType() == 3) {
                ++n;
            }
            mathMLExpression.setOperation(nodeList.item(n).getNodeName());
            while (n < nodeList.getLength()) {
                Object object = this.processNode(nodeList.item(n));
                if (object != null) {
                    mathMLExpression.addArgument(object);
                }
                ++n;
            }
            return mathMLExpression;
        }

        protected Object parseCN(MathMLCnElement mathMLCnElement) {
            return this.parseNumber(mathMLCnElement);
        }

        private Ring.Member parseNumber(MathMLCnElement mathMLCnElement) {
            if (!mathMLCnElement.getBase().equals("10")) {
                return null;
            }
            String string = mathMLCnElement.getType();
            if (string.equals("real")) {
                return new MathDouble(mathMLCnElement.getFirstChild().getNodeValue());
            }
            if (string.equals("integer")) {
                return new MathInteger(mathMLCnElement.getFirstChild().getNodeValue());
            }
            if (string.equals("rational")) {
                Node node = mathMLCnElement.getArgument(1);
                Node node2 = mathMLCnElement.getArgument(2);
                return new MathDouble(node.getNodeValue()).divide(new MathDouble(node2.getNodeValue()));
            }
            if (string.equals("complex-cartesian")) {
                Node node = mathMLCnElement.getArgument(1);
                Node node3 = mathMLCnElement.getArgument(2);
                return new Complex(new Double(node.getNodeValue()), new Double(node3.getNodeValue()));
            }
            if (string.equals("complex-polar")) {
                Node node = mathMLCnElement.getArgument(1);
                Node node4 = mathMLCnElement.getArgument(2);
                return Complex.polar(new Double(node.getNodeValue()), new Double(node4.getNodeValue()));
            }
            if (string.equals("constant")) {
                String string2 = mathMLCnElement.getFirstChild().getNodeValue();
                if (string2.equals("&pi;")) {
                    return RealField.PI;
                }
                if (string2.equals("&ee;") || string2.equals("&ExponentialE;")) {
                    return RealField.E;
                }
                if (string2.equals("&ii;") || string2.equals("&ImaginaryI;")) {
                    return ComplexField.I;
                }
                if (string2.equals("&gamma;")) {
                    return RealField.GAMMA;
                }
                if (string2.equals("&infty;") || string2.equals("&infin;")) {
                    return RealField.INFINITY;
                }
                if (string2.equals("&NaN;") || string2.equals("&NotANumber;")) {
                    return RealField.NaN;
                }
                return null;
            }
            return null;
        }

        protected Object parseCI(MathMLCiElement mathMLCiElement) {
            return mathMLCiElement.getFirstChild().getNodeValue();
        }

        protected Object parseVECTOR(MathMLVectorElement mathMLVectorElement) {
            int n = 0;
            int n2 = 0;
            Ring.Member[] memberArray = new Ring.Member[mathMLVectorElement.getNcomponents()];
            for (int i = 0; i < memberArray.length; ++i) {
                MathMLContentElement mathMLContentElement = mathMLVectorElement.getComponent(i + 1);
                if (!(mathMLContentElement instanceof MathMLCnElement)) continue;
                memberArray[n] = this.parseNumber((MathMLCnElement)mathMLContentElement);
                if (memberArray[n] == null) continue;
                if (memberArray[n] instanceof MathDouble && n2 < 1) {
                    n2 = 1;
                } else if (memberArray[n] instanceof Complex && n2 < 2) {
                    n2 = 2;
                }
                ++n;
            }
            if (n2 == 0) {
                int[] nArray = new int[n];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = ((MathInteger)memberArray[i]).value();
                }
                return new IntegerVector(nArray);
            }
            if (n2 == 1) {
                double[] dArray = new double[n];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = memberArray[i] instanceof MathInteger ? (double)((MathInteger)memberArray[i]).value() : ((MathDouble)memberArray[i]).value();
                }
                return new DoubleVector(dArray);
            }
            Complex[] complexArray = new Complex[n];
            for (int i = 0; i < complexArray.length; ++i) {
                complexArray[i] = memberArray[i] instanceof MathInteger ? new Complex(((MathInteger)memberArray[i]).value(), 0.0) : (memberArray[i] instanceof MathDouble ? new Complex(((MathDouble)memberArray[i]).value(), 0.0) : (Complex)memberArray[i]);
            }
            return new ComplexVector(complexArray);
        }

        protected Object parseMATRIX(MathMLMatrixElement mathMLMatrixElement) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = Integer.MAX_VALUE;
            Ring.Member[][] memberArrayArray = new Ring.Member[mathMLMatrixElement.getNrows()][];
            for (n2 = 0; n2 < memberArrayArray.length; ++n2) {
                memberArrayArray[n3] = this.parseMatrixRow(mathMLMatrixElement.getRow(n2 + 1));
                if (memberArrayArray[n3].length < n4) {
                    n4 = memberArrayArray[n3].length;
                }
                ++n3;
            }
            n2 = 0;
            for (n = 0; n < n3; ++n) {
                for (int i = 0; i < n4; ++i) {
                    if (memberArrayArray[n][i] instanceof MathDouble && n2 < 1) {
                        n2 = 1;
                        continue;
                    }
                    if (!(memberArrayArray[n][i] instanceof Complex) || n2 >= 2) continue;
                    n2 = 2;
                }
            }
            if (n2 == 0) {
                int[][] nArray = new int[n3][n4];
                for (int i = 0; i < n3; ++i) {
                    for (n = 0; n < n4; ++n) {
                        nArray[i][n] = ((MathInteger)memberArrayArray[i][n]).value();
                    }
                }
                if (n3 == n4) {
                    return new IntegerSquareMatrix(nArray);
                }
                return new IntegerMatrix(nArray);
            }
            if (n2 == 1) {
                double[][] dArray = new double[n3][n4];
                for (int i = 0; i < n3; ++i) {
                    for (n = 0; n < n4; ++n) {
                        dArray[i][n] = memberArrayArray[i][n] instanceof MathInteger ? (double)((MathInteger)memberArrayArray[i][n]).value() : ((MathDouble)memberArrayArray[i][n]).value();
                    }
                }
                if (n3 == n4) {
                    return new DoubleSquareMatrix(dArray);
                }
                return new DoubleMatrix(dArray);
            }
            Complex[][] complexArray = new Complex[n3][n4];
            for (int i = 0; i < n3; ++i) {
                for (n = 0; n < n4; ++n) {
                    complexArray[i][n] = memberArrayArray[i][n] instanceof MathInteger ? new Complex(((MathInteger)memberArrayArray[i][n]).value(), 0.0) : (memberArrayArray[i][n] instanceof MathDouble ? new Complex(((MathDouble)memberArrayArray[i][n]).value(), 0.0) : (Complex)memberArrayArray[i][n]);
                }
            }
            if (n3 == n4) {
                return new ComplexSquareMatrix(complexArray);
            }
            return new ComplexMatrix(complexArray);
        }

        private Ring.Member[] parseMatrixRow(MathMLMatrixrowElement mathMLMatrixrowElement) {
            int n = 0;
            Ring.Member[] memberArray = new Ring.Member[mathMLMatrixrowElement.getNEntries()];
            for (int i = 0; i < memberArray.length; ++i) {
                MathMLContentElement mathMLContentElement = mathMLMatrixrowElement.getEntry(i + 1);
                if (!(mathMLContentElement instanceof MathMLCnElement)) continue;
                memberArray[n] = this.parseNumber((MathMLCnElement)mathMLContentElement);
                if (memberArray[n] == null) continue;
                ++n;
            }
            Ring.Member[] memberArray2 = new Ring.Member[n];
            System.arraycopy(memberArray, 0, memberArray2, 0, n);
            return memberArray2;
        }

        protected Object parseSET(MathMLSetElement mathMLSetElement) {
            NodeList nodeList = mathMLSetElement.getChildNodes();
            HashSet<Object> hashSet = new HashSet<Object>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof MathMLCiElement)) continue;
                hashSet.add(this.parseCI((MathMLCiElement)node));
            }
            return new FiniteSet(hashSet);
        }

        protected Object parseMS(MathMLStringLitElement mathMLStringLitElement) {
            return mathMLStringLitElement.getFirstChild().getNodeValue();
        }

        protected Object parseMTEXT(MathMLPresentationToken mathMLPresentationToken) {
            return mathMLPresentationToken.getFirstChild().getNodeValue();
        }
    }

    static abstract class Translator {
        public Object[] translate(Node node) {
            return this.parseMATH(node);
        }

        private Object[] parseMATH(Node node) {
            int n = 0;
            NodeList nodeList = node.getChildNodes();
            Object[] objectArray = new Object[nodeList.getLength()];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = this.processNode(nodeList.item(i));
                if (object == null) continue;
                objectArray[n] = object;
                ++n;
            }
            Object[] objectArray2 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            return objectArray2;
        }

        protected Object processNode(Node node) {
            String string = node.getNodeName();
            if (node instanceof MathMLApplyElement || string.equals("reln")) {
                return this.parseAPPLY((MathMLContentContainer)node);
            }
            if (node instanceof MathMLCnElement) {
                return this.parseCN((MathMLCnElement)node);
            }
            if (node instanceof MathMLCiElement) {
                return this.parseCI((MathMLCiElement)node);
            }
            if (node instanceof MathMLVectorElement) {
                return this.parseVECTOR((MathMLVectorElement)node);
            }
            if (node instanceof MathMLMatrixElement) {
                return this.parseMATRIX((MathMLMatrixElement)node);
            }
            if (node instanceof MathMLSetElement) {
                return this.parseSET((MathMLSetElement)node);
            }
            if (node instanceof MathMLStringLitElement) {
                return this.parseMS((MathMLStringLitElement)node);
            }
            if (string.equals("mtext")) {
                return this.parseMTEXT((MathMLPresentationToken)node);
            }
            return null;
        }

        protected abstract Object parseAPPLY(MathMLContentContainer var1);

        protected abstract Object parseCN(MathMLCnElement var1);

        protected abstract Object parseCI(MathMLCiElement var1);

        protected abstract Object parseVECTOR(MathMLVectorElement var1);

        protected abstract Object parseMATRIX(MathMLMatrixElement var1);

        protected abstract Object parseSET(MathMLSetElement var1);

        protected abstract Object parseMS(MathMLStringLitElement var1);

        protected abstract Object parseMTEXT(MathMLPresentationToken var1);
    }
}

