/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.algebras;

import JSci.maths.Complex;
import JSci.maths.algebras.LieAlgebra;
import JSci.maths.fields.ComplexField;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractComplexSquareMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.Double3Vector;
import JSci.maths.vectors.VectorDimensionException;

public final class su2Dim2
extends LieAlgebra {
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, ComplexField.HALF}, {ComplexField.HALF, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, ComplexField.HALF_I}, {ComplexField.MINUS_HALF_I, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{ComplexField.HALF, Complex.ZERO}, {Complex.ZERO, ComplexField.MINUS_HALF}};
    private static final AbstractComplexSquareMatrix[] basisMatrices = new AbstractComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3)};
    private static final su2Dim2 _instance = new su2Dim2();

    private su2Dim2() {
        super("su(2) [2]");
    }

    public static final su2Dim2 getInstance() {
        return _instance;
    }

    public AbstractComplexSquareMatrix getElement(AbstractDoubleVector abstractDoubleVector) {
        AbstractComplexMatrix abstractComplexMatrix = basisMatrices[0].scalarMultiply(abstractDoubleVector.getComponent(0));
        abstractComplexMatrix = abstractComplexMatrix.add(basisMatrices[1].scalarMultiply(abstractDoubleVector.getComponent(1)));
        abstractComplexMatrix = abstractComplexMatrix.add(basisMatrices[2].scalarMultiply(abstractDoubleVector.getComponent(2)));
        return (AbstractComplexSquareMatrix)abstractComplexMatrix.scalarMultiply(Complex.I);
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector, AbstractDoubleVector abstractDoubleVector2) {
        if (!(abstractDoubleVector instanceof Double3Vector) || !(abstractDoubleVector2 instanceof Double3Vector)) {
            throw new VectorDimensionException("Vectors must be 3-vectors.");
        }
        return ((Double3Vector)abstractDoubleVector).multiply((Double3Vector)abstractDoubleVector2);
    }

    public AbstractComplexSquareMatrix[] basis() {
        return basisMatrices;
    }
}

