/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;
import java.util.Arrays;

public class CalibrationCommandPacket
extends HrdCommandPacket
implements Packable {
    public static final int CMD_TYPE = 8;
    public static final int INT_SIZE = 4;
    public static final int FLOAT_SIZE = 4;
    public static final int BYTE_SIZE = 1;
    public static final byte AMPLITUDEUNIT_VOLT = 1;
    public static final byte AMPLITUDEUNIT_AMP = 0;
    public static final byte ATTENUATION_INS_CHOICE = 0;
    public static final byte ATTENUATION_NONE = 1;
    public static final byte ATTENUATION_BY10X = 2;
    public static final byte ATTENUATION_BY100X = 3;
    public static final byte ATTENUATION_BY1000X = 4;
    public static final int ID_LENGTH = 32;
    private static final int OFFSET_TO_SUBTYPE = 7;
    private static final int OFFSET_TO_LENGTH = 8;
    private static final int OFFSET_TO_CHANNEL = 10;
    private static final int OFFSET_TO_CTRL = 11;
    private static final int OFFSET_TO_ATTEN = 14;
    private static final int OFFSET_TO_UNIT = 15;
    private static final int OFFSET_TO_AMPLITUDE = 16;
    private static final int OFFSET_TO_DCOFFSET = 20;
    private static final int OFFSET_TO_TON = 24;
    private static final int OFFSET_TO_RAMPDUR = 28;
    private static final int OFFSET_TO_DURATION = 32;
    private static final int OFFSET_TO_IDENT = 40;
    private static final int OFFSET_TO_PARAMS = 72;
    private byte channelBits;
    private byte subtype;
    private byte ctrlLines;
    private byte attenuation;
    private byte amplitudeUnit;
    private float amplitude;
    private float dcOffset;
    private float tOn;
    private float ramp;
    private float duration;
    private String identifier;
    private short numParamBytes;
    protected byte[] paramBytes;

    public CalibrationCommandPacket(int _timeSecs, int _instrumentID, byte _channelBits, byte _subtype, byte _ctrlLines, byte _attenuation, byte _amplitudeUnit, float _amplitude, float _dcOffset, float _tOn, float _ramp, float _duration, String _identifier, int _numParamBytes) {
        super(_timeSecs, _instrumentID, 8);
        this.channelBits = _channelBits;
        this.subtype = _subtype;
        this.ctrlLines = _ctrlLines;
        this.attenuation = _attenuation;
        this.amplitudeUnit = _amplitudeUnit;
        this.amplitude = _amplitude;
        this.dcOffset = _dcOffset;
        this.tOn = _tOn;
        this.ramp = _ramp;
        this.duration = _duration;
        this.identifier = _identifier;
        this.numParamBytes = (short)_numParamBytes;
        this.paramBytes = new byte[_numParamBytes];
        Arrays.fill(this.paramBytes, (byte)0);
    }

    public CalibrationCommandPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public byte getChannelBits() {
        return this.channelBits;
    }

    public byte getSubtype() {
        return this.subtype;
    }

    public byte getCtrlLines() {
        return this.ctrlLines;
    }

    public byte getAttenuation() {
        return this.attenuation;
    }

    public byte getAmplitudeUnit() {
        return this.amplitudeUnit;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public float getDcOffset() {
        return this.dcOffset;
    }

    public float getDuration() {
        return this.duration;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public float getTOn() {
        return this.tOn;
    }

    public float getRamp() {
        return this.ramp;
    }

    public int getNumParamBytes() {
        return this.numParamBytes;
    }

    public byte[] getParamBytes() {
        return this.paramBytes;
    }

    public void setChannelBits(byte newBits) {
        this.channelBits = newBits;
    }

    public void setAttenuation(byte newByte) {
        this.attenuation = newByte;
    }

    public void setAmplitudeUnit(byte newUnit) {
        this.amplitudeUnit = newUnit;
    }

    public void setAmplitude(float newAmplitude) {
        this.amplitude = newAmplitude;
    }

    public void setCtrlLines(byte newLines) {
        this.ctrlLines = newLines;
    }

    public void setDcOffset(float newOffset) {
        this.dcOffset = newOffset;
    }

    public void setDuration(float newDuration) {
        this.duration = newDuration;
    }

    public void setIdentifier(String newID) {
        this.identifier = newID;
    }

    public void setTOn(float newTOn) {
        this.tOn = newTOn;
    }

    public void setRamp(float newRamp) {
        this.ramp = newRamp;
    }

    public void setSubtype(byte newSubtype) {
        this.subtype = newSubtype;
    }

    public void setNumParamBytes(int newNum) {
        byte[] params = new byte[newNum];
        Arrays.fill(params, (byte)0);
        int copyNum = Math.min(newNum, this.paramBytes.length);
        System.arraycopy(this.paramBytes, 0, params, 0, copyNum);
        this.paramBytes = params;
        this.numParamBytes = (short)newNum;
    }

    public void setParamBytes(byte[] newBytes) {
        this.paramBytes = newBytes;
    }

    public int getDataLength() {
        return 72 + this.getNumParamBytes();
    }

    public void writeTo(byte[] buffer, int offset) {
        super.writeTo(buffer, offset);
        buffer[offset + 7] = this.subtype;
        short totalLength = (short)(this.numParamBytes + 72 - 10);
        LittleEndian.writeShort(buffer, offset + 8, totalLength);
        buffer[offset + 10] = this.channelBits;
        buffer[offset + 11] = this.ctrlLines;
        buffer[offset + 14] = this.attenuation;
        buffer[offset + 15] = this.amplitudeUnit;
        LittleEndian.writeFloat(buffer, offset + 16, this.amplitude);
        LittleEndian.writeFloat(buffer, offset + 20, this.dcOffset);
        LittleEndian.writeFloat(buffer, offset + 24, this.tOn);
        LittleEndian.writeFloat(buffer, offset + 28, this.ramp);
        LittleEndian.writeFloat(buffer, offset + 32, this.duration);
        LittleEndian.writeString(buffer, offset + 40, this.identifier, 32);
        System.arraycopy(this.paramBytes, 0, buffer, offset + 72, this.numParamBytes);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, 26);
        short totalLength = LittleEndian.readShort(buffer, offset + 8);
        int packetSize = totalLength + 10;
        if (length < packetSize || buffer.length - offset < packetSize || packetSize < 72) {
            throw new InvalidInputException("CalibrationCommandPacket");
        }
        this.numParamBytes = (short)(totalLength - 72 + 10);
        this.channelBits = buffer[offset + 10];
        this.subtype = buffer[offset + 7];
        this.ctrlLines = buffer[offset + 11];
        this.attenuation = buffer[offset + 14];
        this.amplitudeUnit = buffer[offset + 15];
        this.amplitude = LittleEndian.readFloat(buffer, offset + 16);
        this.dcOffset = LittleEndian.readFloat(buffer, offset + 20);
        this.tOn = LittleEndian.readFloat(buffer, offset + 24);
        this.ramp = LittleEndian.readFloat(buffer, offset + 28);
        this.duration = LittleEndian.readFloat(buffer, offset + 32);
        this.identifier = LittleEndian.readString(buffer, offset + 40, 32);
        this.paramBytes = new byte[this.numParamBytes];
        System.arraycopy(buffer, offset + 72, this.paramBytes, 0, this.numParamBytes);
    }

    public String toString() {
        return "CalibrationCommand " + this.getSubtype() + " for instrument " + this.getInstrumentID();
    }
}

