/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.DecompDataHandler;
import ca.nanometrics.packet.DecompDataPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.util.Log;

public class FirFilter
implements NmxPacketHandler,
DecompDataHandler {
    private int key;
    private DecompDataHandler handler;
    private int packetSeconds;
    private int packetSamples;
    private int[] outputBuffer;
    private int bufferIndex;
    private int[] Samples;
    private double dbInPktTime;
    private double dbOutPktTime;
    private int InPktStartIndex;
    private int numSavedSamples;
    private int filterOrder;
    private double[] filterCoeff;
    private int decimation;
    private double sampleRate;
    private int skips;
    private int TimeTears;

    public FirFilter(int key, DecompDataHandler handler, double[] filterCoeff, int decimation, int packetSeconds, double sampleRate) {
        this.key = key;
        this.handler = handler;
        this.filterOrder = filterCoeff.length;
        this.decimation = decimation;
        this.filterCoeff = filterCoeff;
        this.packetSeconds = packetSeconds;
        this.sampleRate = sampleRate;
        this.packetSamples = (int)sampleRate * packetSeconds / decimation;
        this.outputBuffer = new int[this.packetSamples];
        this.Samples = new int[0];
        this.numSavedSamples = 0;
        this.bufferIndex = 0;
        this.dbOutPktTime = 0.0;
    }

    public void put(DecompDataPacket dp) {
        if (this.key == dp.getKey()) {
            this.process(dp.getStartTime(), dp.getSamples(), dp.getSampleRate());
        }
    }

    public void put(NmxPacket p) {
        DataPacket dp;
        if (p instanceof DataPacket && this.key == (dp = (DataPacket)p).getKey()) {
            this.process(dp.getStartTime(), dp.getSamples(), dp.getSampleRate());
        }
    }

    private void process(double pktStartTime, int[] pktSamples, int pktSampleRate) {
        Log.report(this, 1, 0, String.valueOf(this.key) + ": processing " + pktSamples.length + " samp at " + pktSampleRate + " sps, time = " + pktStartTime);
        this.dbInPktTime = pktStartTime;
        this.InPktStartIndex = this.numSavedSamples;
        this.checkForTimeTear();
        int sampleIndex = 0;
        if (this.bufferIndex == 0) {
            sampleIndex = this.alignToSecond(this.getStartTime(pktSamples.length));
        }
        int numSamples = pktSamples.length + this.numSavedSamples;
        int[] newSamples = new int[numSamples];
        System.arraycopy(this.Samples, this.Samples.length - this.numSavedSamples, newSamples, 0, this.numSavedSamples);
        System.arraycopy(pktSamples, 0, newSamples, this.numSavedSamples, pktSamples.length);
        this.Samples = newSamples;
        while (numSamples - sampleIndex >= this.filterOrder) {
            if (this.filterOrder == 1) {
                this.outputBuffer[this.bufferIndex] = this.Samples[sampleIndex];
            } else {
                double sum = 0.0;
                int i = 0;
                while (i < this.filterOrder) {
                    sum += (double)this.Samples[sampleIndex + i] * this.filterCoeff[i];
                    ++i;
                }
                this.outputBuffer[this.bufferIndex] = (int)sum;
            }
            ++this.bufferIndex;
            sampleIndex += this.decimation;
            if (this.bufferIndex != this.packetSamples) continue;
            DecompDataPacket outputPacket = new DecompDataPacket(this.key, this.dbOutPktTime, this.outputBuffer, this.packetSamples, this.packetSamples / this.packetSeconds);
            Log.report(this, 2, 0, String.valueOf(this.key) + ": 0ut time = " + this.dbOutPktTime);
            this.handler.put(outputPacket);
            this.bufferIndex = 0;
            this.outputBuffer = new int[this.packetSamples];
            this.dbOutPktTime += (double)this.packetSeconds;
        }
        this.numSavedSamples = this.bufferIndex > 0 ? numSamples - sampleIndex : (this.filterOrder == 1 ? (this.packetSamples < numSamples ? this.packetSamples : numSamples) : (this.filterOrder < numSamples ? this.filterOrder : numSamples));
    }

    private int alignToSecond(double dbAlignTime) {
        int startIndex = -1;
        int skippedSeconds = 0;
        long lgNearestSecond = Math.round(dbAlignTime);
        while (startIndex < 0) {
            double dbTimeDiff = (double)lgNearestSecond - this.dbInPktTime;
            startIndex = (int)((long)this.InPktStartIndex + Math.round(dbTimeDiff * this.sampleRate - (double)(this.filterOrder - 1) / 2.0));
            ++lgNearestSecond;
            ++skippedSeconds;
        }
        if (skippedSeconds > 1) {
            ++this.skips;
            Log.report(this, 3, 0, String.valueOf(this.key) + ": number of skips = " + this.skips);
        }
        double dbTimeFromStart = ((double)startIndex + (double)(this.filterOrder - 1) / 2.0 - (double)this.InPktStartIndex) / this.sampleRate;
        this.dbOutPktTime = this.dbInPktTime + dbTimeFromStart;
        return startIndex;
    }

    private void checkForTimeTear() {
        double dbTimeLastOutSample = this.dbOutPktTime + (double)(this.bufferIndex * this.packetSeconds) / (double)this.packetSamples;
        double timeInStorage = ((double)this.numSavedSamples - (double)(this.filterOrder - 1) / 2.0) / this.sampleRate;
        if (this.dbInPktTime - dbTimeLastOutSample >= timeInStorage + (double)0.1f) {
            ++this.TimeTears;
            Log.report(this, 4, 0, String.valueOf(this.key) + ": number of time tears = " + this.TimeTears);
            if (this.bufferIndex != 0) {
                DecompDataPacket outputPacket = new DecompDataPacket(this.key, this.dbOutPktTime, this.outputBuffer, this.bufferIndex, this.packetSamples / this.packetSeconds);
                Log.report(this, 5, 0, String.valueOf(this.key) + ": out time = " + this.dbOutPktTime);
                this.handler.put(outputPacket);
                this.bufferIndex = 0;
                this.outputBuffer = new int[this.packetSamples];
            }
            this.Samples = new int[0];
            this.numSavedSamples = 0;
            this.InPktStartIndex = 0;
        }
    }

    private double getStartTime(int inPktSize) {
        int pktsPerSum = this.filterOrder / (2 * inPktSize);
        double startTime = this.dbInPktTime - (double)pktsPerSum;
        return startTime;
    }

    public String toString() {
        return "FirFilter " + this.filterOrder + " " + this.decimation + " " + this.sampleRate + " " + this.packetSamples + " " + this.packetSeconds;
    }
}

