/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class HrdCommandPacket
extends Packet {
    public static final int DATA_TYPE = 2;
    public static final int MSG_TYPE = 2;
    private int dataLength;
    protected static final int OFFSET_TO_ID = 0;
    protected static final int OFFSET_TO_TIME = 2;
    protected static final int OFFSET_TO_TYPE = 6;
    protected byte[] packet;

    protected HrdCommandPacket(int timeSeconds, int instrumentID, int type) {
        this(timeSeconds, instrumentID, type, 26);
    }

    public HrdCommandPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.dataLength = 26;
        this.packet = new byte[this.dataLength];
        this.readFrom(buffer, offset, length);
    }

    public HrdCommandPacket(int timeSeconds, int instrumentID, int type, int packetSize) {
        this.dataLength = packetSize;
        this.packet = new byte[packetSize];
        LittleEndian.writeShort(this.packet, 0, (short)instrumentID);
        LittleEndian.writeInt(this.packet, 2, timeSeconds);
        this.packet[6] = (byte)type;
    }

    public int getDataType() {
        return 2;
    }

    public int getChannel() {
        return 0;
    }

    public int getKeyType() {
        return 0;
    }

    public int getKey() {
        return ChannelKey.getKeyOf(this.getKeyType(), this.getChannel(), this.getInstrumentID());
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void writeTo(byte[] buffer, int offset) {
        System.arraycopy(this.packet, 0, buffer, offset, this.dataLength);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        if (length != this.dataLength) {
            throw new InvalidInputException("HrdCommandPacket");
        }
        System.arraycopy(buffer, offset, this.packet, 0, this.dataLength);
    }

    public static int getTypeOf(byte[] buffer, int offset) {
        return buffer[offset + 6];
    }

    public int getType() {
        return this.packet[6];
    }

    public int getInstrumentID() {
        return LittleEndian.readShort(this.packet, 0);
    }

    public String getInstrumentName() {
        int ID = this.getInstrumentID();
        return Instrument.getNameOf(ID);
    }

    public int getTime() {
        return LittleEndian.readInt(this.packet, 2);
    }

    public String toString() {
        return "HrdCommand " + this.getType() + " inst " + this.getInstrumentID();
    }
}

