/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.BigEndian;

public class InternetPacketWrapper
extends PacketWrapper {
    public static final int NMX_SIGNATURE = 2059197967;
    static final int SIGNATURE_OFFSET = 0;
    static final int DATA_TYPE_OFFSET = 4;
    static final int DATA_LEN_OFFSET = 8;
    private static final int OFFSET_TO_DATA = 12;

    public byte[] makeWrappedPacket(Packable p) {
        int dataLen = p.getDataLength();
        int length = 12 + dataLen;
        byte[] buffer = new byte[length];
        BigEndian.writeInt(buffer, 0, 2059197967);
        BigEndian.writeInt(buffer, 4, p.getDataType());
        BigEndian.writeInt(buffer, 8, p.getDataLength());
        p.writeTo(buffer, 12);
        return buffer;
    }

    public boolean isValidPacket(byte[] buffer, int length) {
        return BigEndian.readInt(buffer, 0) == 2059197967 && BigEndian.readInt(buffer, 8) + 12 == length;
    }

    public int getDataOffset() {
        return 12;
    }

    public static int getDataOffsetAsClassConst() {
        return 12;
    }

    public int getDataType(byte[] buffer) {
        return BigEndian.readInt(buffer, 4);
    }

    public int getDataLength(byte[] buffer) {
        return BigEndian.readInt(buffer, 8);
    }
}

