/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Instrument;
import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.IntegerHelper;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;
import ca.nanometrics.util.NmxDateFormat;

public class NmxPacket
extends Packet {
    public static final int MSG_TYPE = 1;
    public static final byte TYPE_MASK = 31;
    public static final byte RETX_MASK = 32;
    public static final byte DOD_MASK = 64;
    public static final int OSN_SIZE = 4;
    public static final int BUNDLE_SIZE = 17;
    public static final int MAX_BUNDLES = 59;
    public static final byte NULL_BUNDLE = 9;
    static final int OFFSET_TO_TIMESECS = 1;
    static final int OFFSET_TO_TIMEFRAC = 5;
    static final int OFFSET_TO_INSTR_ID = 7;
    static final int OFFSET_TO_SEQUENCE = 9;
    public static final String SUBTYPE_NAME = "Nmx";
    byte[] guts;
    int oldestSequence;
    private static NmxDateFormat hms = new NmxDateFormat("HH:mm:ss.SSS");

    public NmxPacket(byte[] buffer, int oldestAvailable) throws InvalidInputException {
        if (!this.isLengthOk(buffer.length)) {
            throw new InvalidInputException("NmxPacket");
        }
        this.guts = buffer;
        this.oldestSequence = oldestAvailable;
    }

    public NmxPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    public NmxPacket(byte[] buffer, int offset, int length, int payloadSize, int headerSize) throws InvalidInputException {
        if (length < 0) {
            throw new InvalidInputException("Input To Create NMX packet invalid!: Data Length Specified is Negative!");
        }
        if (offset < 0) {
            throw new InvalidInputException("Input To Create NMX packet invalid: Data Offset Specified is Negative!");
        }
        if (length != IntegerHelper.nextClosestDivisible(payloadSize + headerSize, 17) + 4) {
            throw new InvalidInputException("Input To Create NMX packet invalid: Incorrect length!");
        }
        if (offset + length > buffer.length) {
            throw new InvalidInputException("Input To Create NMX packet invalid: Data offset+length > buffer length");
        }
        this.readFrom(buffer, offset, length);
    }

    public NmxPacket(NmxPacket packet) {
        this.oldestSequence = packet.oldestSequence;
        this.guts = new byte[packet.guts.length];
        System.arraycopy(packet.guts, 0, this.guts, 0, this.guts.length);
    }

    public static NmxPacket makeNullPacket(NmxPacket packet) {
        NmxPacket newpkt = new NmxPacket(packet);
        newpkt.guts[17] = 9;
        newpkt.setTimeSeconds(0);
        newpkt.setTimeFraction(0);
        return newpkt;
    }

    protected boolean isLengthOk(int length) {
        return length > 17;
    }

    public int getDataType() {
        return 1;
    }

    public int getDataLength() {
        return 4 + this.guts.length;
    }

    public void writeTo(byte[] dest, int offset) {
        LittleEndian.writeInt(dest, offset, this.oldestSequence);
        System.arraycopy(this.guts, 0, dest, offset + 4, this.guts.length);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.oldestSequence = LittleEndian.readInt(buffer, offset);
        offset += 4;
        if (!this.isLengthOk(length -= 4)) {
            throw new InvalidInputException("NmxPacket");
        }
        this.guts = new byte[length];
        System.arraycopy(buffer, offset, this.guts, 0, length);
    }

    public static int getKeyOf(int type, int channel, int ID) {
        return ID << 16 | (type & 0xFF) << 8 | channel & 0xFF;
    }

    public static int getTypeOf(byte[] buffer, int offset) {
        return NmxPacket.readTypeFrom(buffer, offset);
    }

    public static int readTypeFrom(byte[] buffer, int offset) {
        return buffer[offset + 4] & 0x1F;
    }

    public static int getNmxpType(byte[] buffer) {
        return buffer[0] & 0x1F;
    }

    public int getKey() {
        return NmxPacket.getKeyOf(this.getType(), this.getChannel(), this.getInstrumentID());
    }

    public int getType() {
        return this.guts[0] & 0x1F;
    }

    public boolean isReTx() {
        return (this.guts[0] & 0x20) == 32;
    }

    public boolean isDoD() {
        return (this.guts[0] & 0x40) == 64;
    }

    public void setReTx(boolean reTx) {
        this.guts[0] = reTx ? (byte)(this.guts[0] | 0x20) : (byte)(this.guts[0] & 0xFFFFFFDF);
    }

    public int getInstrumentID() {
        return LittleEndian.readShort(this.guts, 7);
    }

    public String getInstrumentName() {
        int ID = this.getInstrumentID();
        return Instrument.getNameOf(ID);
    }

    public int getChannel() {
        return 0;
    }

    public String getSubTypeName() {
        return SUBTYPE_NAME;
    }

    public void setSequenceNumber(int sequenceNumber) {
        LittleEndian.writeInt(this.guts, 9, sequenceNumber);
    }

    public int getSequenceNumber() {
        return LittleEndian.readInt(this.guts, 9);
    }

    public int getOldestSequence() {
        return this.oldestSequence;
    }

    public void setOldestSequence(int oldestSequenceNumber) {
        this.oldestSequence = oldestSequenceNumber;
    }

    public int getStorableLength() {
        return this.guts.length;
    }

    public int getNumBundles() {
        return this.getStorableLength() / 17 - 1;
    }

    public int getTimeSeconds() {
        return LittleEndian.readInt(this.guts, 1);
    }

    public long getLongSeconds() {
        return LittleEndian.readUInt(this.guts, 1);
    }

    public void setTimeSeconds(int seconds) {
        LittleEndian.writeInt(this.guts, 1, seconds);
    }

    public int getTimeFraction() {
        return 0;
    }

    public void setTimeFraction(int frac) {
        LittleEndian.writeShort(this.guts, 5, (short)frac);
    }

    public double getPacketTime() {
        return (double)this.getLongSeconds() + 1.0E-4 * (double)this.getTimeFraction();
    }

    public byte[] getStorableBytes() {
        return this.guts;
    }

    protected String getTimeString(double time) {
        return hms.format(time);
    }

    protected String getPacketTimeString() {
        return hms.format(this.getPacketTime());
    }

    public byte getStorableByte(int offset) {
        return this.guts[offset];
    }

    public String toString() {
        String str = String.valueOf(this.getInstrumentName()) + "-" + this.getSubTypeName() + ":" + this.getSequenceNumber() + " @ " + this.getPacketTimeString();
        return str;
    }
}

