/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;

public class NmxPacketBuffer
implements NmxPacketHandler {
    private int capacity = 1;
    private int numPackets = 0;
    private int firstPacket = 0;
    private NmxPacket[] buffer = null;

    public NmxPacketBuffer(int bufferLength) {
        this.reset(bufferLength);
    }

    public synchronized void reset(int bufferLength) {
        this.capacity = bufferLength > 1 ? bufferLength : 1;
        this.buffer = new NmxPacket[this.capacity];
        this.numPackets = 0;
        this.firstPacket = 0;
    }

    public synchronized void put(NmxPacket pkt) {
        this.buffer[(this.firstPacket + this.numPackets) % this.capacity] = pkt;
        if (this.numPackets < this.capacity) {
            ++this.numPackets;
        } else {
            this.firstPacket = (this.firstPacket + 1) % this.capacity;
        }
    }

    public void sendTo(NmxPacketHandler handler) {
        this.sendTo(handler, this.capacity);
    }

    public synchronized void sendTo(NmxPacketHandler handler, int numToSend) {
        if (numToSend > this.numPackets) {
            numToSend = this.numPackets;
        }
        int ipkt = this.numPackets - numToSend;
        while (ipkt < this.numPackets) {
            handler.put(this.buffer[(this.firstPacket + ipkt) % this.capacity]);
            ++ipkt;
        }
    }
}

