/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.CalibrationCommandPacket;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class PRBCalibrationCommandPacket
extends CalibrationCommandPacket {
    public static final byte SUB_TYPE = 3;
    private static final int OFFSET_TO_UNITPULSE = 0;
    private static final int OFFSET_TO_POLYMASK = 4;
    private static final int OFFSET_TO_SEED = 8;
    private static final int NUM_PARAMBYTES = 12;

    public PRBCalibrationCommandPacket(int _timeSecs, int _instrumentID, byte _channelBits, byte _ctrlLines, byte _attenuation, byte _amplitudeUnit, float _amplitude, float _dcOffset, float _tOn, float _ramp, float _duration, String _identifier, float _unitPulseWidth, int _polynomialMask, int _seedValue) {
        super(_timeSecs, _instrumentID, _channelBits, (byte)3, _ctrlLines, _attenuation, _amplitudeUnit, _amplitude, _dcOffset, _tOn, _ramp, _duration, _identifier, 12);
        this.setUnitPulseWidth(_unitPulseWidth);
        this.setPolynomialMask(_polynomialMask);
        this.setSeed(_seedValue);
    }

    public PRBCalibrationCommandPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public float getUnitPulseWidth() {
        float unitDur = LittleEndian.readFloat(this.paramBytes, 0);
        return unitDur;
    }

    public int getPolynomialMask() {
        int mask = LittleEndian.readInt(this.paramBytes, 4);
        return mask;
    }

    public int getSeed() {
        int seed = LittleEndian.readInt(this.paramBytes, 8);
        return seed;
    }

    public void setUnitPulseWidth(float newUnitWidth) {
        LittleEndian.writeFloat(this.paramBytes, 0, newUnitWidth);
    }

    public void setPolynomialMask(int newMask) {
        LittleEndian.writeInt(this.paramBytes, 4, newMask);
    }

    public void setSeed(int newSeed) {
        LittleEndian.writeInt(this.paramBytes, 8, newSeed);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        this.setNumParamBytes(12);
    }

    public String toString() {
        return "PRBCalibrationCommand for instrument " + this.getInstrumentID();
    }
}

