/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.CalibrationCommandPacket;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class SWCalibrationCommandPacket
extends CalibrationCommandPacket {
    public static final byte SUB_TYPE = 1;
    private static final int OFFSET_TO_FREQUENCY = 0;
    private static final int NUM_PARAMS = 1;
    private static final int NUM_PARAMBYTES = 4;

    public SWCalibrationCommandPacket(int _timeSecs, int _instrumentID, byte _channelBits, byte _ctrlLines, byte _attenuation, byte _amplitudeUnit, float _amplitude, float _dcOffset, float _tOn, float _ramp, float _duration, String _identifier, float _frequency) {
        super(_timeSecs, _instrumentID, _channelBits, (byte)1, _ctrlLines, _attenuation, _amplitudeUnit, _amplitude, _dcOffset, _tOn, _ramp, _duration, _identifier, 4);
        this.setFrequency(_frequency);
    }

    public SWCalibrationCommandPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public float getFrequency() {
        float frequency = LittleEndian.readFloat(this.paramBytes, 0);
        return frequency;
    }

    public void setFrequency(float newFreq) {
        LittleEndian.writeFloat(this.paramBytes, 0, newFreq);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        this.setNumParamBytes(4);
    }

    public String toString() {
        return "SWCalibrationCommand for instrument " + this.getInstrumentID();
    }
}

