/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class SerialPacket
extends NmxPacket {
    public static final int PACKET_TYPE = 6;
    public static final String SUBTYPE_NAME = "Serial";
    public static final int FILE_TAG = 45;
    static final int OFFSET_TO_BYTECOUNT = 13;
    static final int OFFSET_TO_CHANNEL = 15;
    static final int OFFSET_TO_PAYLOAD = 17;

    public SerialPacket(byte[] buffer, int oldestAvailable) throws InvalidInputException {
        super(buffer, oldestAvailable);
    }

    public SerialPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public int getChannel() {
        return this.guts[15];
    }

    public int getTimeFraction() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public int getPayloadSize() {
        int size = LittleEndian.readShort(this.guts, 13);
        if (size < 0) {
            size = 0;
        }
        if (size > this.guts.length - 17) {
            size = this.guts.length - 17;
        }
        return size;
    }

    public String getSubTypeName() {
        return "S" + this.getChannel();
    }

    public byte[] getPayload() {
        int size = this.getPayloadSize();
        byte[] buffer = new byte[size];
        if (size > 0) {
            System.arraycopy(this.guts, 17, buffer, 0, size);
        }
        return buffer;
    }

    public String toString() {
        String str = String.valueOf(this.getInstrumentName()) + "-" + this.getSubTypeName() + ":" + this.getSequenceNumber() + " PayloadSize:" + this.getPayloadSize() + " @ " + this.getPacketTimeString();
        int channel = this.getChannel();
        if (channel >= 16 && channel <= 21) {
            if (this.guts[17] == 0) {
                double stamp = BigEndian.readDouble(this.guts, 61);
                str = String.valueOf(str) + " stamp: " + this.getTimeString(stamp);
            } else if (this.guts[17] == 1 && this.guts.length >= 65) {
                boolean isValidTimeStamp = true;
                int firstByte = 45;
                int lastByte = firstByte + 20;
                int ix = firstByte;
                while (ix < lastByte && isValidTimeStamp) {
                    isValidTimeStamp &= this.guts[ix] >= 32 && this.guts[ix] < 64;
                    ++ix;
                }
                if (isValidTimeStamp) {
                    str = String.valueOf(str) + " stamp: " + new String(this.guts, firstByte, 20);
                }
            }
        }
        return str;
    }
}

