/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;
import java.util.Arrays;

public class TimeSyncPacket
extends NmxPacket {
    public static final int PACKET_TYPE = 4;
    public static final String SUBTYPE_NAME = "TimeSync";

    public TimeSyncPacket(byte[] buffer, int oldestAvailable) throws InvalidInputException {
        super(buffer, oldestAvailable);
    }

    public TimeSyncPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public TimeSyncPacket(int instID, double time, int bundles) throws InvalidInputException {
        super(TimeSyncPacket.createTimeSync(instID, time, bundles), 0);
    }

    protected static byte[] createTimeSync(int instID, double time, int bundles) {
        if (bundles < 1) {
            bundles = 1;
        }
        byte[] buffer = new byte[17 * (bundles + 1)];
        Arrays.fill(buffer, (byte)0);
        buffer[0] = 4;
        long time10kths = (long)(time * 10000.0 + 0.5);
        long timesec = time10kths / 10000L;
        long timefrac = time10kths - 10000L * timesec;
        LittleEndian.writeInt(buffer, 1, (int)timesec);
        LittleEndian.writeShort(buffer, 5, (short)timefrac);
        LittleEndian.writeShort(buffer, 7, (short)instID);
        buffer[17] = 9;
        return buffer;
    }

    public int getTimeFraction() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public String getSubTypeName() {
        return SUBTYPE_NAME;
    }

    public String toString() {
        String str = String.valueOf(this.getInstrumentName()) + "-" + this.getSubTypeName() + " @ " + this.getPacketTimeString();
        return str;
    }
}

