/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet.test;

import ca.nanometrics.packet.CalibrationResponse;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CalibrationResponseTester
extends TestCase {
    static /* synthetic */ Class class$0;

    public CalibrationResponseTester(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ca.nanometrics.packet.test.CalibrationResponseTester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
    }

    public void testConstructor() throws Exception {
        float calib = 5.0f;
        float calper = 10.0f;
        CalibrationResponse calResponse = new CalibrationResponse(calib, calper, "Channel", "Instrument", "response", "recordID");
        Assert.assertNotNull((String)"null CalibrationResponse on construct", (Object)calResponse);
    }

    public void testGets() throws Exception {
        float calib = 5.0f;
        float calper = 10.0f;
        String channel = "channel";
        String instrument = "Instrument";
        String response = "response";
        String recordID = "recordID";
        CalibrationResponse calResponse = new CalibrationResponse(calib, calper, channel, instrument, response, recordID);
        Assert.assertEquals((String)"Get calib incorrect", (double)calib, (double)calResponse.getCalib(), (double)0.1);
        Assert.assertEquals((String)"Get calper incorrect", (double)calper, (double)calResponse.getCalper(), (double)0.1);
        Assert.assertEquals((String)"Get channel incorrect", (String)channel, (String)calResponse.getChannel());
        Assert.assertEquals((String)"Get instrument incorrect", (String)instrument, (String)calResponse.getInstrument());
        Assert.assertEquals((String)"getResponse", (String)response, (String)calResponse.getResponse());
        Assert.assertEquals((String)"getRecordID", (String)recordID, (String)calResponse.getRecordID());
    }

    public void testPackable() throws Exception {
        float calib = 5.0f;
        float calper = 10.0f;
        String channel = "channel";
        String instrument = "Instrument";
        String response = "response";
        String recordID = "recordID";
        CalibrationResponse calResponse = new CalibrationResponse(calib, calper, channel, instrument, response, recordID);
        byte[] packetBytes = new byte[calResponse.getDataLength()];
        calResponse.writeTo(packetBytes, 0);
        CalibrationResponse readResponse = new CalibrationResponse(packetBytes, 0, packetBytes.length);
        Assert.assertEquals((String)"Get calib incorrect", (double)calib, (double)readResponse.getCalib(), (double)0.1);
        Assert.assertEquals((String)"Get calper incorrect", (double)calper, (double)readResponse.getCalper(), (double)0.1);
        Assert.assertEquals((String)"Get channel incorrect", (String)channel, (String)readResponse.getChannel());
        Assert.assertEquals((String)"Get instrument incorrect", (String)instrument, (String)readResponse.getInstrument());
        Assert.assertEquals((String)"getResponse", (String)response, (String)readResponse.getResponse());
        Assert.assertEquals((String)"getRecordID", (String)recordID, (String)readResponse.getRecordID());
    }
}

