/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet.test;

import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.LogPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.SampleRateTable;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Date;

public class NmxPacketMaker {
    static final int BYTE_PACKING = 85;
    static final int SHORT_PACKING = 170;
    static final int BUNDLE_SIZE = 17;
    static final int NMX_PACKET_TYPE = 1;
    byte[] buffer = null;
    private int type;
    private int instrumentKey;
    private byte[] packetInfo;
    private byte[] data;
    private Date startTime;

    public NmxPacketMaker(int _type, int _instrumentKey, byte[] _packetInfo, byte[] _data, Date _startTime) {
        this.type = _type;
        this.instrumentKey = _instrumentKey;
        this.packetInfo = _packetInfo;
        this.data = _data;
        this.startTime = _startTime;
    }

    public NmxPacketMaker() {
        this(1, 0, null, null, new Date());
    }

    public static NmxPacket makeNmxPacket(int instrumentKey) throws InvalidInputException {
        byte[] data = new byte[1];
        byte[] info = new byte[4];
        NmxPacketMaker maker = new NmxPacketMaker(1, instrumentKey, info, data, new Date());
        maker.makePacketBytes();
        NmxPacket np = new NmxPacket(maker.getBuffer(), 0, maker.getBufferSize());
        return np;
    }

    public static DataPacket makeDataPacket(int instrumentKey, byte[] data, int referenceSample, int sampleRate, Date startTime, int channel) throws InvalidInputException {
        byte[] packetInfo = new byte[]{(byte)((sampleRate & 0x1F) << 3 | channel & 7), (byte)(referenceSample >> 0 & 0xFF), (byte)(referenceSample >> 8 & 0xFF), (byte)(referenceSample >> 16 & 0xFF)};
        NmxPacketMaker maker = new NmxPacketMaker(1, instrumentKey, packetInfo, data, startTime);
        maker.makePacketBytes();
        DataPacket dp = new DataPacket(maker.getBuffer(), 0, maker.getBufferSize());
        return dp;
    }

    public static LogPacket makeLogPacket(int instrumentKey, String msg, int severity) throws InvalidInputException {
        byte[] data = msg.getBytes();
        byte[] packetInfo = new byte[]{0, 0, (byte)(severity & 0xFF), 0};
        NmxPacketMaker maker = new NmxPacketMaker(5, instrumentKey, packetInfo, data, new Date());
        maker.makePacketBytes();
        LogPacket lp = new LogPacket(maker.getBuffer(), 0, maker.getBufferSize());
        return lp;
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] makePacketBytes() throws InvalidInputException {
        ByteArrayOutputStream testBaos = new ByteArrayOutputStream();
        byte[] byArray = new byte[4];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byte[] osn = byArray;
        testBaos.write(osn, 0, 4);
        testBaos.write(this.type);
        int seconds = (int)(this.startTime.getTime() / 1000L);
        byte[] packettime = new byte[]{(byte)(seconds >> 0 & 0xFF), (byte)(seconds >> 8 & 0xFF), (byte)(seconds >> 16 & 0xFF), (byte)(seconds >> 24 & 0xFF)};
        testBaos.write(packettime, 0, 4);
        short secondFraction = (short)((double)(this.startTime.getTime() - (long)(seconds * 1000)) / 10.0);
        byte[] timeFraction = new byte[]{(byte)(secondFraction >> 0 & 0xFF), (byte)(secondFraction >> 8 & 0xFF)};
        testBaos.write(timeFraction, 0, 2);
        byte[] key = new byte[]{(byte)(this.instrumentKey >> 0 & 0xFF), (byte)(this.instrumentKey >> 8 & 0xFF)};
        testBaos.write(key, 0, 2);
        byte[] byArray2 = new byte[4];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byte[] sequenceNum = byArray2;
        testBaos.write(sequenceNum, 0, 4);
        testBaos.write(this.packetInfo, 0, 4);
        testBaos.write(this.data, 0, this.data.length);
        this.buffer = testBaos.toByteArray();
        return this.buffer;
    }

    public static DataPacket[] makeDataPackets(int[] data, double dataStartSec, int sampleRate, double startSec, int numSamples, int instrumentKey, int channelKey) throws InvalidInputException {
        int samplesPerBundle = 16;
        int bundlesPerPacket = 4;
        int samplesPerPacket = samplesPerBundle * bundlesPerPacket;
        int numExpectedPackets = (int)Math.ceil((double)numSamples / (double)samplesPerPacket);
        DataPacket[] packets = new DataPacket[numExpectedPackets];
        int startOffset = (int)((startSec - dataStartSec) * (double)sampleRate);
        int[] packetData = new int[numExpectedPackets * samplesPerPacket];
        Arrays.fill(packetData, 0);
        System.arraycopy(data, startOffset, packetData, 0, numSamples);
        if (startOffset < 0) {
            return null;
        }
        int refData = packetData[startOffset];
        int curPacket = 0;
        while (curPacket < numExpectedPackets) {
            byte[] bundleData = NmxPacketMaker.generateBundles(true, packetData, startOffset, refData);
            double second = dataStartSec + (double)(startOffset - 1) / (double)sampleRate;
            int sampleRateKey = SampleRateTable.getIndex(sampleRate);
            packets[curPacket] = NmxPacketMaker.makeDataPacket(instrumentKey, bundleData, refData, sampleRateKey, new Date((long)(second * 1000.0)), channelKey);
            refData = packetData[(startOffset += samplesPerPacket) - 1];
            ++curPacket;
        }
        return packets;
    }

    public static byte[] generateBundles(boolean useByteDiffs, int[] data, int dataOffset, int referenceData) {
        int scaleFactor = 1;
        int samplesPerBundle = 16;
        int bundlesPerPacket = 4;
        if (!useByteDiffs) {
            scaleFactor = 20;
            samplesPerBundle = 8;
        }
        int diff = data[dataOffset] - referenceData;
        int numBytesPerPacket = (samplesPerBundle + 1) * bundlesPerPacket;
        byte[] buffer = new byte[numBytesPerPacket];
        int bundle = 0;
        while (bundle < bundlesPerPacket) {
            int sampleOffset;
            int ix;
            int offset = bundle * 17;
            dataOffset += offset;
            if (useByteDiffs) {
                buffer[offset] = 85;
                ++offset;
                ix = 0;
                while (ix < samplesPerBundle) {
                    buffer[offset + ix] = diff;
                    sampleOffset = dataOffset + ix;
                    if (sampleOffset + 1 < data.length) {
                        int difference = data[sampleOffset + 1] - data[sampleOffset];
                        diff = difference > 127 ? 127 : (int)((byte)difference);
                    }
                    ++ix;
                }
            } else {
                buffer[offset] = -86;
                ++offset;
                ix = 0;
                while (ix < samplesPerBundle) {
                    LittleEndian.writeShort(buffer, offset + 2 * ix, (short)(scaleFactor * diff));
                    sampleOffset = dataOffset + ix;
                    if (sampleOffset < data.length) {
                        diff = (byte)(data[sampleOffset + 1] - data[sampleOffset]);
                    }
                    ++ix;
                }
            }
            ++bundle;
        }
        return buffer;
    }
}

